"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findParent = exports.isReference = exports.isDefinition = exports.range = exports.forEach = void 0;
const main_1 = require("vscode-languageserver/lib/main");
function forEach(node, cb) {
    cb(node);
    if (node.children.length) {
        node.children.forEach(n => forEach(n, cb));
    }
}
exports.forEach = forEach;
function range(n) {
    return main_1.Range.create(n.startPosition.row, n.startPosition.column, n.endPosition.row, n.endPosition.column);
}
exports.range = range;
function isDefinition(n) {
    switch (n.type) {
        // For now. Later we'll have a command_declaration take precedence over
        // variable_assignment
        case 'variable_assignment':
        case 'function_definition':
            return true;
        default:
            return false;
    }
}
exports.isDefinition = isDefinition;
function isReference(n) {
    switch (n.type) {
        case 'variable_name':
        case 'command_name':
            return true;
        default:
            return false;
    }
}
exports.isReference = isReference;
function findParent(start, predicate) {
    let node = start.parent;
    while (node !== null) {
        if (predicate(node)) {
            return node;
        }
        node = node.parent;
    }
    return null;
}
exports.findParent = findParent;
//# sourceMappingURL=tree-sitter.js.map