/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.border.AbstractBorder;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColImageBorder
extends AbstractBorder {
    private static final List<FreeColImageBorder> borders = new ArrayList<FreeColImageBorder>();
    public static final FreeColImageBorder panelWithoutShadowBorder = new FreeColImageBorder("image.border.panel.noshadow");
    public static final FreeColImageBorder panelBorder = new FreeColImageBorder("image.border.panel");
    public static final FreeColImageBorder buttonBorder = new FreeColImageBorder("image.border.button");
    public static final FreeColImageBorder simpleButtonBorder = new FreeColImageBorder("image.border.button.simple");
    public static final FreeColImageBorder menuBarBorder = new FreeColImageBorder("image.border.menu", true);
    private static float scaleFactor = 1.0f;
    private final String baseKey;
    private final boolean noScaling;
    private boolean initialized = false;
    private BufferedImage topLeftCornerImage;
    private BufferedImage topImage;
    private BufferedImage topRightCornerImage;
    private BufferedImage rightImage;
    private BufferedImage bottomRightCornerImage;
    private BufferedImage bottomImage;
    private BufferedImage bottomLeftCornerImage;
    private BufferedImage leftImage;

    private FreeColImageBorder(String baseKey) {
        this(baseKey, false);
    }

    private FreeColImageBorder(String baseKey, boolean noScaling) {
        this.baseKey = baseKey;
        this.noScaling = noScaling;
        this.loadImages();
        borders.add(this);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.loadImages();
        }
    }

    private void loadImages() {
        this.loadImages(this.getImage(this.baseKey + ".nw"), this.getImage(this.baseKey + ".n"), this.getImage(this.baseKey + ".ne"), this.getImage(this.baseKey + ".e"), this.getImage(this.baseKey + ".se"), this.getImage(this.baseKey + ".s"), this.getImage(this.baseKey + ".sw"), this.getImage(this.baseKey + ".w"));
        this.initialized = true;
    }

    private void loadImages(BufferedImage topLeftCornerImage, BufferedImage topImage, BufferedImage topRightCornerImage, BufferedImage rightImage, BufferedImage bottomRightCornerImage, BufferedImage bottomImage, BufferedImage bottomLeftCornerImage, BufferedImage leftImage) {
        this.topLeftCornerImage = topLeftCornerImage;
        this.topImage = topImage;
        this.topRightCornerImage = topRightCornerImage;
        this.rightImage = rightImage;
        this.bottomRightCornerImage = bottomRightCornerImage;
        this.bottomImage = bottomImage;
        this.bottomLeftCornerImage = bottomLeftCornerImage;
        this.leftImage = leftImage;
    }

    public static void setScaleFactor(float scaleFactor) {
        FreeColImageBorder.scaleFactor = scaleFactor;
        FreeColImageBorder.reloadAllImages();
    }

    private static void reloadAllImages() {
        borders.stream().forEach(FreeColImageBorder::loadImages);
    }

    private BufferedImage getImage(String key) {
        ImageResource ir = ResourceManager.getImageResource(key, false);
        if (ir == null) {
            return null;
        }
        BufferedImage image = ir.getImage();
        if (this.noScaling) {
            return image;
        }
        Dimension scaledDimensions = new Dimension(Math.round((float)image.getWidth() * scaleFactor), Math.round((float)image.getHeight() * scaleFactor));
        return ir.getImage(scaledDimensions, false);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        this.ensureInitialized();
        return this.getBorderInsets(c, null);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        this.ensureInitialized();
        int top = Math.max(Math.max(FreeColImageBorder.getHeight(this.topImage), FreeColImageBorder.getHeight(this.topLeftCornerImage)), FreeColImageBorder.getHeight(this.topRightCornerImage));
        int left = Math.max(Math.max(FreeColImageBorder.getWidth(this.leftImage), FreeColImageBorder.getWidth(this.topLeftCornerImage)), FreeColImageBorder.getWidth(this.bottomLeftCornerImage));
        int bottom = Math.max(Math.max(FreeColImageBorder.getHeight(this.bottomImage), FreeColImageBorder.getHeight(this.bottomLeftCornerImage)), FreeColImageBorder.getHeight(this.bottomRightCornerImage));
        int right = Math.max(Math.max(FreeColImageBorder.getWidth(this.rightImage), FreeColImageBorder.getWidth(this.topRightCornerImage)), FreeColImageBorder.getWidth(this.bottomRightCornerImage));
        if (this.topImage == null) {
            top = 0;
        }
        if (this.leftImage == null) {
            left = 0;
        }
        if (this.bottomImage == null) {
            bottom = 0;
        }
        if (this.rightImage == null) {
            right = 0;
        }
        if (insets == null) {
            return new Insets(top, left, bottom, right);
        }
        insets.top = top;
        insets.left = left;
        insets.bottom = bottom;
        insets.right = right;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.ensureInitialized();
        Insets insets = this.getBorderInsets(c);
        Graphics2D g2 = (Graphics2D)g;
        int topHeight = FreeColImageBorder.getHeight(this.topImage);
        int leftWidth = FreeColImageBorder.getWidth(this.leftImage);
        int bottomHeight = FreeColImageBorder.getHeight(this.bottomImage);
        int rightWidth = FreeColImageBorder.getWidth(this.rightImage);
        int topLeftCornerWidth = FreeColImageBorder.getWidth(this.topLeftCornerImage);
        int topLeftCornerHeight = FreeColImageBorder.getHeight(this.topLeftCornerImage);
        int topRightCornerWidth = FreeColImageBorder.getWidth(this.topRightCornerImage);
        int topRightCornerHeight = FreeColImageBorder.getHeight(this.topRightCornerImage);
        int bottomLeftCornerWidth = FreeColImageBorder.getWidth(this.bottomLeftCornerImage);
        int bottomLeftCornerHeight = FreeColImageBorder.getHeight(this.bottomLeftCornerImage);
        int bottomRightCornerWidth = FreeColImageBorder.getWidth(this.bottomRightCornerImage);
        int bottomRightCornerHeight = FreeColImageBorder.getHeight(this.bottomRightCornerImage);
        if (this.topImage != null) {
            ImageUtils.fillTexture(g2, this.topImage, x + topLeftCornerWidth, y + insets.top - topHeight, width - topLeftCornerWidth - topRightCornerWidth, topHeight);
        }
        if (this.leftImage != null) {
            ImageUtils.fillTexture(g2, this.leftImage, x + insets.left - leftWidth, y + topLeftCornerHeight, leftWidth, height - topLeftCornerHeight - bottomLeftCornerHeight);
        }
        if (this.bottomImage != null) {
            ImageUtils.fillTexture(g2, this.bottomImage, x + bottomLeftCornerWidth, y + height - insets.bottom, width - bottomLeftCornerWidth - bottomRightCornerWidth, bottomHeight);
        }
        if (this.rightImage != null) {
            ImageUtils.fillTexture(g2, this.rightImage, x + width - insets.right, y + topRightCornerHeight, rightWidth, height - topRightCornerHeight - bottomRightCornerHeight);
        }
        if (this.topLeftCornerImage != null) {
            ImageUtils.fillTexture(g2, this.topLeftCornerImage, x + Math.max(insets.left, topLeftCornerWidth) - topLeftCornerWidth, y + Math.max(insets.top, topLeftCornerHeight) - topLeftCornerHeight, topLeftCornerWidth, topLeftCornerHeight);
        }
        if (this.topRightCornerImage != null) {
            ImageUtils.fillTexture(g2, this.topRightCornerImage, x + width - Math.max(insets.right, topRightCornerWidth), y + Math.max(insets.top, topRightCornerHeight) - topRightCornerHeight, topRightCornerWidth, topRightCornerHeight);
        }
        if (this.bottomLeftCornerImage != null) {
            ImageUtils.fillTexture(g2, this.bottomLeftCornerImage, x + Math.max(insets.left, bottomLeftCornerWidth) - bottomLeftCornerWidth, y + height - Math.max(insets.bottom, bottomLeftCornerHeight), bottomLeftCornerWidth, bottomLeftCornerHeight);
        }
        if (this.bottomRightCornerImage != null) {
            ImageUtils.fillTexture(g2, this.bottomRightCornerImage, x + width - Math.max(insets.right, bottomRightCornerWidth), y + height - Math.max(insets.bottom, bottomRightCornerHeight), bottomRightCornerWidth, bottomRightCornerHeight);
        }
    }

    private static int getHeight(Image im) {
        return im == null ? 0 : im.getHeight(null);
    }

    private static int getWidth(Image im) {
        return im == null ? 0 : im.getWidth(null);
    }
}

