/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;

public final class RecruitPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(RecruitPanel.class.getName());
    private final JButton[] person;
    private boolean shouldEnable = false;

    public RecruitPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new MigLayout("wrap 1", "", ""));
        List<AbstractUnit> recruitables = this.getMyPlayer().getEurope().getExpandedRecruitables(false);
        this.person = new JButton[recruitables.size()];
        for (int i = 0; i < this.person.length; ++i) {
            this.person[i] = new JButton();
            this.person[i].setActionCommand(String.valueOf(i));
            this.person[i].addActionListener(this);
            this.person[i].setIconTextGap(3);
        }
        this.update();
    }

    public void update() {
        this.removeAll();
        Player player = this.getMyPlayer();
        Europe europe = player.getEurope();
        int production = player.getTotalImmigrationProduction();
        int turns = 100;
        if (production > 0) {
            int immigrationRequired = player.getImmigrationRequired() - player.getImmigration();
            turns = immigrationRequired / production;
            if (immigrationRequired % production > 0) {
                ++turns;
            }
        }
        int recruitPrice = player.getEuropeanRecruitPrice();
        this.add((Component)Utility.localizedTextArea(((StringTemplate)StringTemplate.template("recruitPanel.clickOn").addAmount("%money%", recruitPrice)).addAmount("%number%", turns)), "wrap 20");
        this.shouldEnable = false;
        List<AbstractUnit> recruitables = europe.getExpandedRecruitables(false);
        for (int i = 0; i < this.person.length; ++i) {
            boolean enable = player.checkGold(recruitPrice);
            AbstractUnit au = recruitables.get(i);
            this.person[i].setText(Messages.message(au.getSingleLabel()));
            this.person[i].setIcon(new ImageIcon(this.getSmallAbstractUnitImage(au)));
            this.person[i].setEnabled(enable);
            this.add((Component)this.person[i], "growx");
            this.shouldEnable |= enable;
        }
        this.okButton.setText(Messages.message("close"));
        this.add((Component)this.okButton, "newline 20, tag ok");
        this.setSize(this.getPreferredSize());
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(ae);
        } else {
            try {
                int index = Integer.parseInt(command);
                if (Europe.MigrationType.validMigrantIndex(index)) {
                    this.igc().recruitUnitInEurope(index);
                    this.getGUI().updateEuropeanSubpanels();
                    if (!this.shouldEnable) {
                        this.getGUI().removeComponent(this);
                    }
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            logger.warning("Invalid action command: " + command);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        if (this.person != null) {
            for (int i = 0; i < this.person.length; ++i) {
                this.person[i] = null;
            }
        }
    }
}

