/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter {
    private String[] names;
    private IOCase caseSensitivity;

    public NameFileFilter(String name) {
        this(name, null);
    }

    public NameFileFilter(String name, IOCase caseSensitivity) {
        if (name == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{name};
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public NameFileFilter(String[] names) {
        this(names, null);
    }

    public NameFileFilter(String[] names, IOCase caseSensitivity) {
        if (names == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = names;
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public NameFileFilter(List names) {
        this(names, null);
    }

    public NameFileFilter(List names, IOCase caseSensitivity) {
        if (names == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = names.toArray(new String[names.size()]);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public boolean accept(File file) {
        String name = file.getName();
        int i = 0;
        while (i < this.names.length) {
            if (this.caseSensitivity.checkEquals(name, this.names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File file, String name) {
        int i = 0;
        while (i < this.names.length) {
            if (this.caseSensitivity.checkEquals(name, this.names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

