/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class Utils {
    private Utils() {
    }

    static RaiseException newIOError(Ruby runtime, IOException e) {
        RaiseException ex = Utils.newIOError(runtime, e.getMessage());
        ex.initCause((Throwable)e);
        return ex;
    }

    static RaiseException newIOError(Ruby runtime, String msg) {
        return new RaiseException(runtime, runtime.getIOError(), msg, true);
    }

    static RaiseException newRuntimeError(Ruby runtime, Exception e) {
        RaiseException ex = Utils.newRuntimeError(runtime, e.getMessage());
        ex.initCause((Throwable)e);
        return ex;
    }

    static RaiseException newArgumentError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, runtime.getArgumentError(), e);
    }

    static RaiseException newRuntimeError(Ruby runtime, String msg) {
        return new RaiseException(runtime, runtime.getRuntimeError(), msg, true);
    }

    static RaiseException newErrorWithoutTrace(Ruby runtime, RubyClass errorClass, String message) {
        RubyArray backtrace = runtime.newEmptyArray();
        return new RaiseException(runtime, errorClass, message, (IRubyObject)backtrace, false);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, String message, boolean nativeException) {
        return new RaiseException(runtime, errorClass, message, nativeException);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, Throwable e) {
        return Utils.newError(runtime, errorClass, e.getMessage(), e);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, String msg) {
        return Utils.newError(runtime, errorClass, msg, true);
    }

    static RaiseException newError(Ruby runtime, RubyClass errorClass, String msg, Throwable e) {
        RaiseException ex = Utils.newError(runtime, errorClass, msg);
        ex.initCause(e);
        return ex;
    }

    static boolean hasNonNilInstanceVariable(IRubyObject self, String var) {
        IRubyObject val = self.getInstanceVariables().getInstanceVariable(var);
        return val != null && !val.isNil();
    }

    static IRubyObject invoke(ThreadContext context2, IRubyObject self, String name2, Block block) {
        return self.getMetaClass().finvoke(context2, self, name2, block);
    }

    static IRubyObject invokeSuper(ThreadContext context2, IRubyObject self, IRubyObject[] args, Block block) {
        return Utils.invokeSuper(context2, self, context2.getFrameKlazz(), context2.getFrameName(), args, block);
    }

    static IRubyObject invokeSuper(ThreadContext context2, IRubyObject self, RubyModule klass, String name2, IRubyObject[] args, Block block) {
        Utils.checkSuperDisabledOrOutOfMethod(context2, klass, name2);
        RubyClass superClass = Utils.findImplementerIfNecessary((RubyModule)self.getMetaClass(), klass).getSuperClass();
        UndefinedMethod method = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        return method.call(context2, self, (RubyModule)superClass, name2, args, block);
    }

    private static void checkSuperDisabledOrOutOfMethod(ThreadContext context2, RubyModule klass, String name2) {
        if (klass == null) {
            if (name2 != null) {
                throw context2.runtime.newNameError("superclass method '" + name2 + "' disabled", name2);
            }
            throw context2.runtime.newNoMethodError("super called outside of method", null, context2.nil);
        }
    }

    private static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass != null && implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass;
    }

    static void throwException(Throwable e) {
        Utils.throwsUnchecked(e);
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }

    static IRubyObject[] extractKeywordArgs(ThreadContext context2, RubyHash options2, String ... validKeys) {
        return Utils.extractKeywordArgs(context2, options2, validKeys, 0);
    }

    static IRubyObject[] extractKeywordArgs(final ThreadContext context2, RubyHash options2, String[] validKeys, int offset) {
        IRubyObject[] ret = new IRubyObject[offset + validKeys.length];
        final HashSet<RubySymbol> validKeySet = new HashSet<RubySymbol>(ret.length);
        for (int i2 = 0; i2 < validKeys.length; ++i2) {
            String key = validKeys[i2];
            RubySymbol keySym = context2.runtime.newSymbol(key);
            IRubyObject val = options2.fastARef((IRubyObject)keySym);
            ret[offset + i2] = val != null ? val : RubyBasicObject.UNDEF;
            validKeySet.add(keySym);
        }
        options2.visitAll(new RubyHash.Visitor(){

            public void visit(IRubyObject key, IRubyObject value2) {
                if (!validKeySet.contains(key)) {
                    throw context2.runtime.newArgumentError("unknown keyword: " + key);
                }
            }
        });
        return ret;
    }

    static IRubyObject extractKeywordArg(ThreadContext context2, String keyword, RubyHash opts) {
        return opts.op_aref(context2, (IRubyObject)context2.runtime.newSymbol(keyword));
    }
}

