from email import _MessageT
from email.message import Message
from email.policy import Policy
from typing import Callable, Generic, overload

__all__ = ["FeedParser", "BytesFeedParser"]

class FeedParser(Generic[_MessageT]):
    @overload
    def __init__(self: FeedParser[Message], _factory: None = ..., *, policy: Policy = ...) -> None: ...
    @overload
    def __init__(self, _factory: Callable[[], _MessageT], *, policy: Policy = ...) -> None: ...
    def feed(self, data: str) -> None: ...
    def close(self) -> _MessageT: ...

class BytesFeedParser(Generic[_MessageT]):
    @overload
    def __init__(self: BytesFeedParser[Message], _factory: None = ..., *, policy: Policy = ...) -> None: ...
    @overload
    def __init__(self, _factory: Callable[[], _MessageT], *, policy: Policy = ...) -> None: ...
    def feed(self, data: bytes) -> None: ...
    def close(self) -> _MessageT: ...
