/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import net.sourceforge.plantuml.utils.UniqueSequence;

public abstract class AbstractClassOrObjectDiagram
extends AbstractEntityDiagram {
    private final List<Association> associations = new ArrayList<Association>();

    public AbstractClassOrObjectDiagram(ThemeStyle style, UmlSource source, UmlDiagramType type, ISkinSimple orig) {
        super(style, source, type, orig);
    }

    @Override
    public Ident cleanIdent(Ident ident) {
        String codeString = ident.getName();
        if (codeString.startsWith("\"") && codeString.endsWith("\"")) {
            return ident.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        }
        return ident;
    }

    public final boolean insertBetween(IEntity entity1, IEntity entity2, IEntity node) {
        Link link = this.foundLink(entity1, entity2);
        if (link == null) {
            return false;
        }
        Link l1 = new Link(entity1, node, link.getType(), link.getLabel(), link.getLength(), link.getQualifier1(), null, link.getLabeldistance(), link.getLabelangle(), this.getSkinParam().getCurrentStyleBuilder());
        Link l2 = new Link(node, entity2, link.getType(), link.getLabel(), link.getLength(), null, link.getQualifier2(), link.getLabeldistance(), link.getLabelangle(), this.getSkinParam().getCurrentStyleBuilder());
        this.addLink(l1);
        this.addLink(l2);
        this.removeLink(link);
        return true;
    }

    private Link foundLink(IEntity entity1, IEntity entity2) {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link l = links.get(i);
            if (!l.isBetween(entity1, entity2)) continue;
            return l;
        }
        return null;
    }

    public int getNbOfHozizontalLollipop(IEntity entity) {
        if (entity.getLeafType() == LeafType.LOLLIPOP_FULL || entity.getLeafType() == LeafType.LOLLIPOP_HALF) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        for (Link link : this.getLinks()) {
            if (link.getLength() != 1 || !link.contains(entity) || !link.containsType(LeafType.LOLLIPOP_FULL) && !link.containsType(LeafType.LOLLIPOP_HALF)) continue;
            ++result;
        }
        return result;
    }

    public CommandExecutionResult associationClass(String name1A, String name1B, String name2A, String name2B, LinkType linkType, Display label) {
        Ident ident1A = this.buildLeafIdent(name1A);
        Ident ident1B = this.buildLeafIdent(name1B);
        Ident ident2A = this.buildLeafIdent(name2A);
        Ident ident2B = this.buildLeafIdent(name2B);
        Ident code1A = this.V1972() ? ident1A : this.buildCode(name1A);
        Ident code1B = this.V1972() ? ident1B : this.buildCode(name1B);
        Ident code2A = this.V1972() ? ident2A : this.buildCode(name2A);
        Ident code2B = this.V1972() ? ident2B : this.buildCode(name2B);
        IEntity entity1A = this.getOrCreateLeaf(ident1A, code1A, null, null);
        IEntity entity1B = this.getOrCreateLeaf(ident1B, code1B, null, null);
        IEntity entity2A = this.getOrCreateLeaf(ident2A, code2A, null, null);
        IEntity entity2B = this.getOrCreateLeaf(ident2B, code2B, null, null);
        List<Association> same1 = this.getExistingAssociatedPoints(entity1A, entity1B);
        List<Association> same2 = this.getExistingAssociatedPoints(entity2A, entity2B);
        if (same1.size() == 0 && same2.size() == 0) {
            String tmp1 = UniqueSequence.getString("apoint");
            String tmp2 = UniqueSequence.getString("apoint");
            Ident ident1 = this.buildLeafIdent(tmp1);
            Ident ident2 = this.buildLeafIdent(tmp2);
            Ident code1 = this.V1972() ? ident1 : this.buildCode(tmp1);
            Ident code2 = this.V1972() ? ident2 : this.buildCode(tmp2);
            IEntity point1 = this.getOrCreateLeaf(ident1, code1, LeafType.POINT_FOR_ASSOCIATION, null);
            IEntity point2 = this.getOrCreateLeaf(ident2, code2, LeafType.POINT_FOR_ASSOCIATION, null);
            this.insertPointBetween(entity1A, entity1B, point1);
            this.insertPointBetween(entity2A, entity2B, point2);
            boolean length = true;
            Link point1ToPoint2 = new Link(point1, point2, linkType, label, 1, this.getSkinParam().getCurrentStyleBuilder());
            this.addLink(point1ToPoint2);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot link two associations points");
    }

    private void insertPointBetween(IEntity entity1A, IEntity entity1B, IEntity point1) {
        Link existingLink1 = this.foundLink(entity1A, entity1B);
        if (existingLink1 == null) {
            existingLink1 = new Link(entity1A, entity1B, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2, this.getSkinParam().getCurrentStyleBuilder());
        } else {
            this.removeLink(existingLink1);
        }
        IEntity entity1real = existingLink1.isInverted() ? existingLink1.getEntity2() : existingLink1.getEntity1();
        IEntity entity2real = existingLink1.isInverted() ? existingLink1.getEntity1() : existingLink1.getEntity2();
        Link entity1ToPoint = new Link(entity1real, point1, existingLink1.getType().getPart2(), existingLink1.getLabel(), existingLink1.getLength(), existingLink1.getQualifier1(), null, existingLink1.getLabeldistance(), existingLink1.getLabelangle(), this.getSkinParam().getCurrentStyleBuilder());
        entity1ToPoint.setLinkArrow(existingLink1.getLinkArrow());
        Link pointToEntity2 = new Link(point1, entity2real, existingLink1.getType().getPart1(), Display.NULL, existingLink1.getLength(), null, existingLink1.getQualifier2(), existingLink1.getLabeldistance(), existingLink1.getLabelangle(), this.getSkinParam().getCurrentStyleBuilder());
        this.addLink(entity1ToPoint);
        this.addLink(pointToEntity2);
    }

    public boolean associationClass(int mode, String name1, String name2, IEntity associed, LinkType linkType, Display label) {
        IEntity entity2;
        Ident ident1 = this.buildLeafIdent(name1);
        Ident ident2 = this.buildLeafIdent(name2);
        Ident code1 = this.V1972() ? ident1 : this.buildCode(name1);
        Ident code2 = this.V1972() ? ident2 : this.buildCode(name2);
        IEntity entity1 = this.getOrCreateLeaf(ident1, code1, null, null);
        List<Association> same = this.getExistingAssociatedPoints(entity1, entity2 = this.getOrCreateLeaf(ident2, code2, null, null));
        if (same.size() > 1) {
            return false;
        }
        if (same.size() == 0) {
            Association association = new Association(mode, entity1, entity2, associed);
            association.createNew(mode, linkType, label);
            this.associations.add(association);
            return true;
        }
        assert (same.size() == 1);
        Association association = same.get(0).createSecondAssociation(mode, associed, label);
        association.createInSecond(linkType, label);
        this.associations.add(association);
        return true;
    }

    private List<Association> getExistingAssociatedPoints(IEntity entity1, IEntity entity2) {
        ArrayList<Association> same = new ArrayList<Association>();
        for (Association existing : this.associations) {
            if (!existing.sameCouple(entity1, entity2)) continue;
            same.add(existing);
        }
        return same;
    }

    @Override
    public void setLegend(DisplayPositioned legend) {
        IGroup currentGroup = this.getCurrentGroup();
        if (currentGroup instanceof GroupRoot) {
            super.setLegend(legend);
            return;
        }
        currentGroup.setLegend(legend);
    }

    class Association {
        private IEntity entity1;
        private IEntity entity2;
        private IEntity associed;
        private IEntity point;
        private Link existingLink;
        private Link entity1ToPoint;
        private Link pointToEntity2;
        private Link pointToAssocied;
        private Association other;

        public Association(int mode, IEntity entity1, IEntity entity2, IEntity associed) {
            this.entity1 = entity1;
            this.entity2 = entity2;
            this.associed = associed;
            String idShort = UniqueSequence.getString("apoint");
            Ident ident = AbstractClassOrObjectDiagram.this.buildLeafIdent(idShort);
            Ident code = AbstractClassOrObjectDiagram.this.V1972() ? ident : AbstractClassOrObjectDiagram.this.buildCode(idShort);
            this.point = AbstractClassOrObjectDiagram.this.getOrCreateLeaf(ident, code, LeafType.POINT_FOR_ASSOCIATION, null);
        }

        public Association createSecondAssociation(int mode2, IEntity associed2, Display label) {
            Association result = new Association(mode2, this.entity1, this.entity2, associed2);
            result.existingLink = this.existingLink;
            result.other = this;
            if (this.existingLink.getLength() == 1) {
                this.entity1ToPoint.setLength(2);
                this.pointToEntity2.setLength(2);
                this.pointToAssocied.setLength(1);
            }
            return result;
        }

        void createNew(int mode, LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            IEntity entity1real = this.existingLink.isInverted() ? this.existingLink.getEntity2() : this.existingLink.getEntity1();
            IEntity entity2real = this.existingLink.isInverted() ? this.existingLink.getEntity1() : this.existingLink.getEntity2();
            this.entity1ToPoint = new Link(entity1real, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), this.existingLink.getLength(), this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle(), AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            this.entity1ToPoint.setLinkArrow(this.existingLink.getLinkArrow());
            this.pointToEntity2 = new Link(this.point, entity2real, this.existingLink.getType().getPart1(), Display.NULL, this.existingLink.getLength(), null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle(), AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            int length = 1;
            if (this.existingLink.getLength() == 1 && this.entity1 != this.entity2) {
                length = 2;
            }
            if (this.existingLink.getLength() == 2 && this.entity1 == this.entity2) {
                length = 2;
            }
            if (length == 1) {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.NORMAL);
            } else {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_PRINTED_FULL);
                this.pointToEntity2.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_NOT_PRINTED);
            }
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            this.pointToAssocied = mode == 1 ? new Link(this.point, this.associed, linkType, label, length, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder()) : new Link(this.associed, this.point, linkType, label, length, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
        }

        void createInSecond(LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), 2, this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle(), AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), Display.NULL, 2, null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle(), AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            if (this.other.pointToAssocied.getEntity1().getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
                AbstractClassOrObjectDiagram.this.removeLink(this.other.pointToAssocied);
                this.other.pointToAssocied = this.other.pointToAssocied.getInv();
                AbstractClassOrObjectDiagram.this.addLink(this.other.pointToAssocied);
            }
            this.pointToAssocied = new Link(this.point, this.associed, linkType, label, 1, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
            Link lnode = new Link(this.other.point, this.point, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 1, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder());
            lnode.setInvis(true);
            AbstractClassOrObjectDiagram.this.addLink(lnode);
        }

        boolean sameCouple(IEntity entity1, IEntity entity2) {
            if (this.entity1 == entity1 && this.entity2 == entity2) {
                return true;
            }
            return this.entity1 == entity2 && this.entity2 == entity1;
        }
    }
}

