/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import org.protege.editor.owl.ui.renderer.layout.LinkBox;
import org.protege.editor.owl.ui.renderer.layout.Page;

public class LinkManager {
    private JComponent component;
    private List<LinkBox> pageLinks = new ArrayList<LinkBox>();
    private Page currentPage;
    private int currentPageXOffset = 0;
    private int currentPageYOffset = 0;
    private MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            LinkManager.this.handleMouseMoved(e);
            LinkManager.this.updateCursor();
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            LinkManager.this.checkForLinkClick(e);
        }
    };

    public void setComponent(JComponent component) {
        if (this.component != null && this.component != component) {
            this.component.removeMouseListener(this.mouseListener);
            this.component.removeMouseMotionListener(this.mouseMotionListener);
        }
        if (this.component != component) {
            this.component = component;
            this.component.addMouseListener(this.mouseListener);
            this.component.addMouseMotionListener(this.mouseMotionListener);
        }
    }

    public void clear(Rectangle rectangle) {
        Iterator<LinkBox> it = this.pageLinks.iterator();
        while (it.hasNext()) {
            LinkBox link = it.next();
            if (!link.getBounds().intersects(rectangle)) continue;
            it.remove();
        }
    }

    public void add(LinkBox pageLink) {
        this.pageLinks.add(pageLink);
    }

    private void updateCursor() {
        if (this.component == null) {
            return;
        }
        Point pos = this.component.getMousePosition();
        if (pos == null) {
            return;
        }
        for (LinkBox pageLink : this.pageLinks) {
            if (!pageLink.contains(pos.x, pos.y)) continue;
            this.component.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.component.setCursor(Cursor.getDefaultCursor());
    }

    private void checkForLinkClick(MouseEvent event) {
        JList list;
        int index;
        if (this.component == null) {
            return;
        }
        Point pos = this.component.getMousePosition();
        if (pos == null) {
            return;
        }
        if (this.component instanceof JList && (index = (list = (JList)this.component).locationToIndex(pos)) != -1) {
            this.component.paintImmediately(list.getCellBounds(index, index));
        }
        for (LinkBox link : this.pageLinks) {
            if (!link.contains(pos.x, pos.y)) continue;
            link.getLink().activate(this.component, event);
        }
    }

    public void clearCurrentPage() {
        this.currentPage = null;
    }

    public void setCurrentPage(Page page, int xOffset, int yOffset) {
        this.currentPage = page;
        this.currentPageXOffset = xOffset;
        this.currentPageYOffset = yOffset;
    }

    private void handleMouseMoved(MouseEvent e) {
        if (this.currentPage == null) {
            return;
        }
        e.translatePoint(-this.currentPageXOffset, -this.currentPageYOffset);
        this.currentPage.handleMouseMoved(e);
        e.translatePoint(this.currentPageXOffset, this.currentPageYOffset);
    }
}

