# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WlRegion(Interface):
    """Region interface

    A region object describes an area.

    Region objects are used to describe the opaque and input regions of a
    surface.
    """

    name = "wl_region"
    version = 1


class WlRegionProxy(Proxy[WlRegion]):
    interface = WlRegion

    @WlRegion.request()
    def destroy(self) -> None:
        """Destroy region

        Destroy the region.  This will invalidate the object ID.
        """
        self._marshal(0)
        self._destroy()

    @WlRegion.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def add(self, x: int, y: int, width: int, height: int) -> None:
        """Add rectangle to region

        Add the specified rectangle to the region.

        :param x:
            region-local x coordinate
        :type x:
            `ArgumentType.Int`
        :param y:
            region-local y coordinate
        :type y:
            `ArgumentType.Int`
        :param width:
            rectangle width
        :type width:
            `ArgumentType.Int`
        :param height:
            rectangle height
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(1, x, y, width, height)

    @WlRegion.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def subtract(self, x: int, y: int, width: int, height: int) -> None:
        """Subtract rectangle from region

        Subtract the specified rectangle from the region.

        :param x:
            region-local x coordinate
        :type x:
            `ArgumentType.Int`
        :param y:
            region-local y coordinate
        :type y:
            `ArgumentType.Int`
        :param width:
            rectangle width
        :type width:
            `ArgumentType.Int`
        :param height:
            rectangle height
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(2, x, y, width, height)


class WlRegionResource(Resource):
    interface = WlRegion


class WlRegionGlobal(Global):
    interface = WlRegion


WlRegion._gen_c()
WlRegion.proxy_class = WlRegionProxy
WlRegion.resource_class = WlRegionResource
WlRegion.global_class = WlRegionGlobal
