
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "desktopfile_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DesktopFile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DesktopFile >()))
        return -1;

    ::DesktopFile *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "DesktopFile", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: DesktopFile::DesktopFile()
    // 1: DesktopFile::DesktopFile(DesktopFile)
    // 2: DesktopFile::DesktopFile(QString)
    if (numArgs == 0) {
        overloadId = 0; // DesktopFile()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 2; // DesktopFile(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // DesktopFile(DesktopFile)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DesktopFile_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // DesktopFile()
        {

            if (!PyErr_Occurred()) {
                // DesktopFile()
                cptr = new ::DesktopFile();
            }
            break;
        }
        case 1: // DesktopFile(const DesktopFile & DesktopFile)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::DesktopFile cppArg0_local;
            ::DesktopFile *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // DesktopFile(DesktopFile)
                cptr = new ::DesktopFile(*cppArg0);
            }
            break;
        }
        case 2: // DesktopFile(const QString & fileName)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // DesktopFile(QString)
                cptr = new ::DesktopFile(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::DesktopFile >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_DesktopFile_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_DesktopFile_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_DesktopFileFunc_comment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.comment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comment()const
            QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->comment();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DesktopFileFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DesktopFileFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()const
            QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->icon();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DesktopFileFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DesktopFileFunc_tryExec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.tryExec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tryExec()const
            bool cppResult = const_cast<const ::DesktopFile *>(cppSelf)->tryExec();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DesktopFileFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QString cppResult = const_cast<const ::DesktopFile *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_DesktopFileFunc_value(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.DesktopFile.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_DesktopFileFunc_value_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_DesktopFileFunc_value_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:value", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: DesktopFile::value(QString,bool)const
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // value(QString,bool)const
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // value(QString,bool)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_DesktopFileFunc_value_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_localized = Shiboken::String::createStaticString("localized");
            if (PyDict_Contains(kwds, key_localized)) {
                value = PyDict_GetItem(kwds, key_localized);
                if (value && pyArgs[1]) {
                    errInfo = key_localized;
                    Py_INCREF(errInfo);
                    goto Sbk_DesktopFileFunc_value_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_DesktopFileFunc_value_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_localized);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_DesktopFileFunc_value_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // value(QString,bool)const
            QVariant cppResult = const_cast<const ::DesktopFile *>(cppSelf)->value(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_DesktopFileFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_DesktopFile___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_DesktopFile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_DesktopFile_methods[] = {
    {"comment", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_comment), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_fileName), METH_NOARGS},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_icon), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_name), METH_NOARGS},
    {"tryExec", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_tryExec), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_type), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_DesktopFileFunc_value), METH_VARARGS|METH_KEYWORDS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_DesktopFile___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_DesktopFile_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_DesktopFile_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_DesktopFile_Type = nullptr;
static SbkObjectType *Sbk_DesktopFile_TypeF(void)
{
    return _Sbk_DesktopFile_Type;
}

static PyType_Slot Sbk_DesktopFile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DesktopFile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DesktopFile_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DesktopFile_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DesktopFile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_DesktopFile_spec = {
    "1:PyFalkon.DesktopFile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_DesktopFile_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DesktopFile_PythonToCpp_DesktopFile_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_DesktopFile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DesktopFile_PythonToCpp_DesktopFile_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_DesktopFile_TypeF())))
        return DesktopFile_PythonToCpp_DesktopFile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DesktopFile_PTR_CppToPython_DesktopFile(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::DesktopFile *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_DesktopFile_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *DesktopFile_COPY_CppToPython_DesktopFile(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_DesktopFile_TypeF(), new ::DesktopFile(*reinterpret_cast<const ::DesktopFile *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void DesktopFile_PythonToCpp_DesktopFile_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::DesktopFile *>(cppOut) = *reinterpret_cast< ::DesktopFile *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_DesktopFile_PythonToCpp_DesktopFile_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_DesktopFile_TypeF())))
        return DesktopFile_PythonToCpp_DesktopFile_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *DesktopFile_SignatureStrings[] = {
    "2:PyFalkon.DesktopFile(self)",
    "1:PyFalkon.DesktopFile(self,DesktopFile:PyFalkon.DesktopFile)",
    "0:PyFalkon.DesktopFile(self,fileName:QString)",
    "PyFalkon.DesktopFile.comment(self)->QString",
    "PyFalkon.DesktopFile.fileName(self)->QString",
    "PyFalkon.DesktopFile.icon(self)->QString",
    "PyFalkon.DesktopFile.name(self)->QString",
    "PyFalkon.DesktopFile.tryExec(self)->bool",
    "PyFalkon.DesktopFile.type(self)->QString",
    "PyFalkon.DesktopFile.value(self,key:QString,localized:bool=false)->QVariant",
    "PyFalkon.DesktopFile.__copy__()",
    nullptr}; // Sentinel

void init_DesktopFile(PyObject *module)
{
    _Sbk_DesktopFile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DesktopFile",
        "DesktopFile",
        &Sbk_DesktopFile_spec,
        &Shiboken::callCppDestructor< ::DesktopFile >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_DesktopFile_Type);
    InitSignatureStrings(pyType, DesktopFile_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_DesktopFile_Type), Sbk_DesktopFile_PropertyStrings);
    SbkPyFalkonTypes[SBK_DESKTOPFILE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_DesktopFile_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_DesktopFile_TypeF(),
        DesktopFile_PythonToCpp_DesktopFile_PTR,
        is_DesktopFile_PythonToCpp_DesktopFile_PTR_Convertible,
        DesktopFile_PTR_CppToPython_DesktopFile,
        DesktopFile_COPY_CppToPython_DesktopFile);

    Shiboken::Conversions::registerConverterName(converter, "DesktopFile");
    Shiboken::Conversions::registerConverterName(converter, "DesktopFile*");
    Shiboken::Conversions::registerConverterName(converter, "DesktopFile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DesktopFile).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        DesktopFile_PythonToCpp_DesktopFile_COPY,
        is_DesktopFile_PythonToCpp_DesktopFile_COPY_Convertible);


    qRegisterMetaType< ::DesktopFile >("DesktopFile");
}
