/* CaffeineApplet.c generated by valac 0.56.0, the Vala compiler
 * generated from CaffeineApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2018-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "caffeineapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <libpeas/peas.h>

enum  {
	CAFFEINE_PLUGIN_0_PROPERTY,
	CAFFEINE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* caffeine_plugin_properties[CAFFEINE_PLUGIN_NUM_PROPERTIES];
enum  {
	CAFFEINE_APPLET_0_PROPERTY,
	CAFFEINE_APPLET_UUID_PROPERTY,
	CAFFEINE_APPLET_NUM_PROPERTIES
};
static GParamSpec* caffeine_applet_properties[CAFFEINE_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CaffeineAppletPrivate {
	GtkEventBox* event_box;
	GtkImage* applet_icon;
	BudgiePopover* popover;
	BudgiePopoverManager* manager;
	GSettings* interface_settings;
	GSettings* settings;
	GThemedIcon* caffeine_full_cup;
	GThemedIcon* caffeine_empty_cup;
	gchar* _uuid;
};

static gpointer caffeine_plugin_parent_class = NULL;
static BudgiePluginIface * caffeine_plugin_budgie_plugin_parent_iface = NULL;
static GType caffeine_plugin_type_id = 0;
static gint CaffeineApplet_private_offset;
static gpointer caffeine_applet_parent_class = NULL;
static GType caffeine_applet_type_id = 0;

static BudgieApplet* caffeine_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                     const gchar* uuid);
static GThemedIcon* caffeine_applet_get_current_mode_icon (CaffeineApplet* self);
static void __lambda7_ (CaffeineApplet* self);
static void caffeine_applet_update_icon (CaffeineApplet* self);
static void ___lambda7__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void __lambda8_ (CaffeineApplet* self);
static gboolean __lambda9_ (CaffeineApplet* self);
static void caffeine_applet_set_caffeine_icons (CaffeineApplet* self);
static gboolean ___lambda9__gsource_func (gpointer self);
static void ___lambda8__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static gboolean __lambda10_ (CaffeineApplet* self,
                      GdkEventButton* e);
static void caffeine_applet_toggle_caffeine_mode (CaffeineApplet* self);
static gboolean ___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void caffeine_applet_real_update_popovers (BudgieApplet* base,
                                           BudgiePopoverManager* manager);
static gboolean caffeine_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* caffeine_applet_real_get_settings_ui (BudgieApplet* base);
static void caffeine_applet_finalize (GObject * obj);
static void _vala_caffeine_applet_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_caffeine_applet_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
GType caffeine_caffeine_window_register_type (GTypeModule * module);
GType caffeine_applet_settings_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static BudgieApplet*
caffeine_plugin_real_get_panel_widget (BudgiePlugin* base,
                                       const gchar* uuid)
{
	CaffeinePlugin * self;
	CaffeineApplet* _tmp0_;
	BudgieApplet* result;
	self = (CaffeinePlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = caffeine_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

CaffeinePlugin*
caffeine_plugin_construct (GType object_type)
{
	CaffeinePlugin * self = NULL;
	self = (CaffeinePlugin*) g_object_new (object_type, NULL);
	return self;
}

CaffeinePlugin*
caffeine_plugin_new (void)
{
	return caffeine_plugin_construct (CAFFEINE_TYPE_PLUGIN);
}

static void
caffeine_plugin_class_init (CaffeinePluginClass * klass,
                            gpointer klass_data)
{
	caffeine_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
caffeine_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                              gpointer iface_data)
{
	caffeine_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) caffeine_plugin_real_get_panel_widget;
}

static void
caffeine_plugin_instance_init (CaffeinePlugin * self,
                               gpointer klass)
{
}

GType
caffeine_plugin_get_type (void)
{
	return caffeine_plugin_type_id;
}

GType
caffeine_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaffeinePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) caffeine_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaffeinePlugin), 0, (GInstanceInitFunc) caffeine_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) caffeine_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	caffeine_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "CaffeinePlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, caffeine_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return caffeine_plugin_type_id;
}

static inline gpointer
caffeine_applet_get_instance_private (CaffeineApplet* self)
{
	return G_STRUCT_MEMBER_P (self, CaffeineApplet_private_offset);
}

static void
__lambda7_ (CaffeineApplet* self)
{
	caffeine_applet_update_icon (self);
}

static void
___lambda7__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda7_ ((CaffeineApplet*) self);
}

static gboolean
__lambda9_ (CaffeineApplet* self)
{
	gboolean result;
	caffeine_applet_set_caffeine_icons (self);
	caffeine_applet_update_icon (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ ((CaffeineApplet*) self);
	return result;
}

static void
__lambda8_ (CaffeineApplet* self)
{
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda8__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda8_ ((CaffeineApplet*) self);
}

static gboolean
__lambda10_ (CaffeineApplet* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	switch (e->button) {
		case 1:
		{
			BudgiePopover* _tmp0_;
			_tmp0_ = self->priv->popover;
			if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
				BudgiePopover* _tmp1_;
				_tmp1_ = self->priv->popover;
				gtk_widget_hide ((GtkWidget*) _tmp1_);
			} else {
				BudgiePopover* _tmp2_;
				BudgiePopoverManager* _tmp3_;
				GtkEventBox* _tmp4_;
				_tmp2_ = self->priv->popover;
				gtk_widget_show_all ((GtkWidget*) _tmp2_);
				_tmp3_ = self->priv->manager;
				_tmp4_ = self->priv->event_box;
				budgie_popover_manager_show_popover (_tmp3_, (GtkWidget*) _tmp4_);
			}
			break;
		}
		case 2:
		{
			caffeine_applet_toggle_caffeine_mode (self);
			break;
		}
		default:
		{
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda10_ ((CaffeineApplet*) self, event);
	return result;
}

CaffeineApplet*
caffeine_applet_construct (GType object_type,
                           const gchar* uuid)
{
	CaffeineApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GThemedIcon* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GThemedIcon* _tmp11_;
	GtkEventBox* _tmp12_;
	GtkEventBox* _tmp13_;
	GThemedIcon* _tmp14_;
	GThemedIcon* _tmp15_;
	GtkImage* _tmp16_;
	GtkEventBox* _tmp17_;
	GtkImage* _tmp18_;
	GtkEventBox* _tmp19_;
	GSettings* _tmp20_;
	CaffeineCaffeineWindow* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	GtkEventBox* _tmp24_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (CaffeineApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp0_;
	_tmp1_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = g_strdup ("caffeine-cup-full");
	_tmp3_ = g_strdup ("budgie-caffeine-cup-full");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp5_, 2);
	_g_object_unref0 (self->priv->caffeine_full_cup);
	self->priv->caffeine_full_cup = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = g_strdup ("caffeine-cup-empty");
	_tmp8_ = g_strdup ("budgie-caffeine-cup-empty");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp10_, 2);
	_g_object_unref0 (self->priv->caffeine_empty_cup);
	self->priv->caffeine_empty_cup = _tmp11_;
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->event_box);
	self->priv->event_box = _tmp12_;
	_tmp13_ = self->priv->event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = caffeine_applet_get_current_mode_icon (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = (GtkImage*) gtk_image_new_from_gicon ((GIcon*) _tmp15_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->applet_icon);
	self->priv->applet_icon = _tmp16_;
	_g_object_unref0 (_tmp15_);
	_tmp17_ = self->priv->event_box;
	_tmp18_ = self->priv->applet_icon;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->event_box;
	_tmp20_ = self->priv->settings;
	_tmp21_ = caffeine_caffeine_window_new ((GtkWidget*) _tmp19_, _tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = (BudgiePopover*) _tmp21_;
	_tmp22_ = self->priv->settings;
	g_signal_connect_object (_tmp22_, "changed::caffeine-mode", (GCallback) ___lambda7__g_settings_changed, self, 0);
	_tmp23_ = self->priv->interface_settings;
	g_signal_connect_object (_tmp23_, "changed::icon-theme", (GCallback) ___lambda8__g_settings_changed, self, G_CONNECT_AFTER);
	_tmp24_ = self->priv->event_box;
	g_signal_connect_object ((GtkWidget*) _tmp24_, "button-press-event", (GCallback) ___lambda10__gtk_widget_button_press_event, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

CaffeineApplet*
caffeine_applet_new (const gchar* uuid)
{
	return caffeine_applet_construct (CAFFEINE_TYPE_APPLET, uuid);
}

/**
* get_current_mode_icon will get the current ThemedIcon (GIcon) for the current Caffeine Mode state
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GThemedIcon*
caffeine_applet_get_current_mode_icon (CaffeineApplet* self)
{
	gboolean enabled = FALSE;
	GSettings* _tmp0_;
	GThemedIcon* _tmp1_ = NULL;
	GThemedIcon* state_icon = NULL;
	GThemedIcon* _tmp4_;
	GThemedIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	enabled = g_settings_get_boolean (_tmp0_, "caffeine-mode");
	if (enabled) {
		GThemedIcon* _tmp2_;
		_tmp2_ = self->priv->caffeine_full_cup;
		_tmp1_ = _tmp2_;
	} else {
		GThemedIcon* _tmp3_;
		_tmp3_ = self->priv->caffeine_empty_cup;
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = _g_object_ref0 (_tmp1_);
	state_icon = _tmp4_;
	result = state_icon;
	return result;
}

/**
* toggle_caffeine_mode will toggle our current Caffeine Mode
*/
static void
caffeine_applet_toggle_caffeine_mode (CaffeineApplet* self)
{
	gboolean enabled = FALSE;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	enabled = g_settings_get_boolean (_tmp0_, "caffeine-mode");
	_tmp1_ = self->priv->settings;
	g_settings_set_boolean (_tmp1_, "caffeine-mode", !enabled);
}

/**
* set_caffeine_icons will set our full and empty cup icons to the current IconTheme icons
*/
static void
caffeine_applet_set_caffeine_icons (CaffeineApplet* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GThemedIcon* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GThemedIcon* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("caffeine-cup-full");
	_tmp1_ = g_strdup ("budgie-caffeine-cup-full");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	_tmp4_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp3_, 2);
	_g_object_unref0 (self->priv->caffeine_full_cup);
	self->priv->caffeine_full_cup = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = g_strdup ("caffeine-cup-empty");
	_tmp6_ = g_strdup ("budgie-caffeine-cup-empty");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp5_;
	_tmp7_[1] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	_tmp9_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp8_, 2);
	_g_object_unref0 (self->priv->caffeine_empty_cup);
	self->priv->caffeine_empty_cup = _tmp9_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
}

/**
* update_icon will update the applet icon
*/
static void
caffeine_applet_update_icon (CaffeineApplet* self)
{
	GtkImage* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applet_icon;
	_tmp1_ = caffeine_applet_get_current_mode_icon (self);
	_tmp2_ = _tmp1_;
	gtk_image_set_from_gicon (_tmp0_, (GIcon*) _tmp2_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	_g_object_unref0 (_tmp2_);
}

static void
caffeine_applet_real_update_popovers (BudgieApplet* base,
                                      BudgiePopoverManager* manager)
{
	CaffeineApplet * self;
	GtkEventBox* _tmp0_;
	BudgiePopover* _tmp1_;
	self = (CaffeineApplet*) base;
	_tmp0_ = self->priv->event_box;
	_tmp1_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, _tmp1_);
	self->priv->manager = manager;
}

static gboolean
caffeine_applet_real_supports_settings (BudgieApplet* base)
{
	CaffeineApplet * self;
	gboolean result;
	self = (CaffeineApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
caffeine_applet_real_get_settings_ui (BudgieApplet* base)
{
	CaffeineApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	CaffeineAppletSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (CaffeineApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = caffeine_applet_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

const gchar*
caffeine_applet_get_uuid (CaffeineApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
caffeine_applet_set_uuid (CaffeineApplet* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = caffeine_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, caffeine_applet_properties[CAFFEINE_APPLET_UUID_PROPERTY]);
	}
}

static void
caffeine_applet_class_init (CaffeineAppletClass * klass,
                            gpointer klass_data)
{
	caffeine_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CaffeineApplet_private_offset);
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) caffeine_applet_real_update_popovers;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) caffeine_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) caffeine_applet_real_get_settings_ui;
	G_OBJECT_CLASS (klass)->get_property = _vala_caffeine_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_caffeine_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = caffeine_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAFFEINE_APPLET_UUID_PROPERTY, caffeine_applet_properties[CAFFEINE_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
caffeine_applet_instance_init (CaffeineApplet * self,
                               gpointer klass)
{
	self->priv = caffeine_applet_get_instance_private (self);
	self->priv->popover = NULL;
	self->priv->manager = NULL;
}

static void
caffeine_applet_finalize (GObject * obj)
{
	CaffeineApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAFFEINE_TYPE_APPLET, CaffeineApplet);
	_g_object_unref0 (self->priv->event_box);
	_g_object_unref0 (self->priv->applet_icon);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->interface_settings);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->caffeine_full_cup);
	_g_object_unref0 (self->priv->caffeine_empty_cup);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (caffeine_applet_parent_class)->finalize (obj);
}

GType
caffeine_applet_get_type (void)
{
	return caffeine_applet_type_id;
}

GType
caffeine_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaffeineAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) caffeine_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaffeineApplet), 0, (GInstanceInitFunc) caffeine_applet_instance_init, NULL };
	caffeine_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "CaffeineApplet", &g_define_type_info, 0);
	CaffeineApplet_private_offset = sizeof (CaffeineAppletPrivate);
	return caffeine_applet_type_id;
}

static void
_vala_caffeine_applet_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	CaffeineApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAFFEINE_TYPE_APPLET, CaffeineApplet);
	switch (property_id) {
		case CAFFEINE_APPLET_UUID_PROPERTY:
		g_value_set_string (value, caffeine_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_caffeine_applet_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	CaffeineApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAFFEINE_TYPE_APPLET, CaffeineApplet);
	switch (property_id) {
		case CAFFEINE_APPLET_UUID_PROPERTY:
		caffeine_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	caffeine_plugin_register_type (module);
	caffeine_applet_register_type (module);
	caffeine_caffeine_window_register_type (module);
	caffeine_applet_settings_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), CAFFEINE_TYPE_PLUGIN);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

