/* settings_page.c generated by valac 0.56.0, the Vala compiler
 * generated from settings_page.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>

#define BUDGIE_SETTINGS_GROUP_APPEARANCE "appearance"
#define BUDGIE_SETTINGS_GROUP_PANEL "panel"
#define BUDGIE_SETTINGS_GROUP_SESSION "session"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;
typedef struct _BudgieSettingsRowPrivate BudgieSettingsRowPrivate;
enum  {
	BUDGIE_SETTINGS_ROW_0_PROPERTY,
	BUDGIE_SETTINGS_ROW_WIDGET_PROPERTY,
	BUDGIE_SETTINGS_ROW_LABEL_PROPERTY,
	BUDGIE_SETTINGS_ROW_DESCRIPTION_PROPERTY,
	BUDGIE_SETTINGS_ROW_NUM_PROPERTIES
};
static GParamSpec* budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;
typedef struct _BudgieSettingsGridPrivate BudgieSettingsGridPrivate;
enum  {
	BUDGIE_SETTINGS_GRID_0_PROPERTY,
	BUDGIE_SETTINGS_GRID_NUM_PROPERTIES
};
static GParamSpec* budgie_settings_grid_properties[BUDGIE_SETTINGS_GRID_NUM_PROPERTIES];

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;
typedef struct _BudgieSettingsPagePrivate BudgieSettingsPagePrivate;
enum  {
	BUDGIE_SETTINGS_PAGE_0_PROPERTY,
	BUDGIE_SETTINGS_PAGE_GROUP_PROPERTY,
	BUDGIE_SETTINGS_PAGE_CONTENT_ID_PROPERTY,
	BUDGIE_SETTINGS_PAGE_ICON_NAME_PROPERTY,
	BUDGIE_SETTINGS_PAGE_TITLE_PROPERTY,
	BUDGIE_SETTINGS_PAGE_WANT_SCROLL_PROPERTY,
	BUDGIE_SETTINGS_PAGE_DISPLAY_WEIGHT_PROPERTY,
	BUDGIE_SETTINGS_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_NUM_PROPERTIES];

struct _BudgieSettingsRow {
	GObject parent_instance;
	BudgieSettingsRowPrivate * priv;
};

struct _BudgieSettingsRowClass {
	GObjectClass parent_class;
};

struct _BudgieSettingsRowPrivate {
	GtkWidget* _widget;
	gchar* _label;
	gchar* _description;
};

struct _BudgieSettingsGrid {
	GtkGrid parent_instance;
	BudgieSettingsGridPrivate * priv;
	gint current_row;
	gboolean small_mode;
};

struct _BudgieSettingsGridClass {
	GtkGridClass parent_class;
};

struct _BudgieSettingsPage {
	GtkBox parent_instance;
	BudgieSettingsPagePrivate * priv;
};

struct _BudgieSettingsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieSettingsPagePrivate {
	gchar* _group;
	gchar* _content_id;
	gchar* _icon_name;
	gchar* _title;
	gboolean _want_scroll;
	gint _display_weight;
};

static gint BudgieSettingsRow_private_offset;
static gpointer budgie_settings_row_parent_class = NULL;
static gpointer budgie_settings_grid_parent_class = NULL;
static gint BudgieSettingsPage_private_offset;
static gpointer budgie_settings_page_parent_class = NULL;

VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
VALA_EXTERN void budgie_settings_row_set_widget (BudgieSettingsRow* self,
                                     GtkWidget* value);
VALA_EXTERN void budgie_settings_row_set_label (BudgieSettingsRow* self,
                                    const gchar* value);
VALA_EXTERN void budgie_settings_row_set_description (BudgieSettingsRow* self,
                                          const gchar* value);
VALA_EXTERN GtkWidget* budgie_settings_row_get_widget (BudgieSettingsRow* self);
VALA_EXTERN const gchar* budgie_settings_row_get_label (BudgieSettingsRow* self);
VALA_EXTERN const gchar* budgie_settings_row_get_description (BudgieSettingsRow* self);
static void budgie_settings_row_finalize (GObject * obj);
static GType budgie_settings_row_get_type_once (void);
static void _vala_budgie_settings_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_budgie_settings_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
static void budgie_settings_grid_finalize (GObject * obj);
static GType budgie_settings_grid_get_type_once (void);
VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN BudgieSettingsPage* budgie_settings_page_new (void);
VALA_EXTERN BudgieSettingsPage* budgie_settings_page_construct (GType object_type);
VALA_EXTERN const gchar* budgie_settings_page_get_group (BudgieSettingsPage* self);
VALA_EXTERN void budgie_settings_page_set_group (BudgieSettingsPage* self,
                                     const gchar* value);
VALA_EXTERN const gchar* budgie_settings_page_get_content_id (BudgieSettingsPage* self);
VALA_EXTERN void budgie_settings_page_set_content_id (BudgieSettingsPage* self,
                                          const gchar* value);
VALA_EXTERN const gchar* budgie_settings_page_get_icon_name (BudgieSettingsPage* self);
VALA_EXTERN void budgie_settings_page_set_icon_name (BudgieSettingsPage* self,
                                         const gchar* value);
VALA_EXTERN const gchar* budgie_settings_page_get_title (BudgieSettingsPage* self);
VALA_EXTERN void budgie_settings_page_set_title (BudgieSettingsPage* self,
                                     const gchar* value);
VALA_EXTERN gboolean budgie_settings_page_get_want_scroll (BudgieSettingsPage* self);
VALA_EXTERN void budgie_settings_page_set_want_scroll (BudgieSettingsPage* self,
                                           gboolean value);
VALA_EXTERN gint budgie_settings_page_get_display_weight (BudgieSettingsPage* self);
VALA_EXTERN void budgie_settings_page_set_display_weight (BudgieSettingsPage* self,
                                              gint value);
static GObject * budgie_settings_page_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void budgie_settings_page_finalize (GObject * obj);
static GType budgie_settings_page_get_type_once (void);
static void _vala_budgie_settings_page_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_budgie_settings_page_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
budgie_settings_row_get_instance_private (BudgieSettingsRow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsRow_private_offset);
}

BudgieSettingsRow*
budgie_settings_row_construct (GType object_type,
                               GtkWidget* widget,
                               const gchar* label,
                               const gchar* description)
{
	BudgieSettingsRow * self = NULL;
	self = (BudgieSettingsRow*) g_object_new (object_type, NULL);
	budgie_settings_row_set_widget (self, widget);
	budgie_settings_row_set_label (self, label);
	budgie_settings_row_set_description (self, description);
	return self;
}

BudgieSettingsRow*
budgie_settings_row_new (GtkWidget* widget,
                         const gchar* label,
                         const gchar* description)
{
	return budgie_settings_row_construct (BUDGIE_TYPE_SETTINGS_ROW, widget, label, description);
}

GtkWidget*
budgie_settings_row_get_widget (BudgieSettingsRow* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
budgie_settings_row_set_widget (BudgieSettingsRow* self,
                                GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_row_get_widget (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_widget);
		self->priv->_widget = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_WIDGET_PROPERTY]);
	}
}

const gchar*
budgie_settings_row_get_label (BudgieSettingsRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
budgie_settings_row_set_label (BudgieSettingsRow* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_row_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_LABEL_PROPERTY]);
	}
}

const gchar*
budgie_settings_row_get_description (BudgieSettingsRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
budgie_settings_row_set_description (BudgieSettingsRow* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_row_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_DESCRIPTION_PROPERTY]);
	}
}

static void
budgie_settings_row_class_init (BudgieSettingsRowClass * klass,
                                gpointer klass_data)
{
	budgie_settings_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieSettingsRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_settings_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_settings_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_settings_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_ROW_WIDGET_PROPERTY, budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_ROW_LABEL_PROPERTY, budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_ROW_DESCRIPTION_PROPERTY, budgie_settings_row_properties[BUDGIE_SETTINGS_ROW_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
budgie_settings_row_instance_init (BudgieSettingsRow * self,
                                   gpointer klass)
{
	self->priv = budgie_settings_row_get_instance_private (self);
}

static void
budgie_settings_row_finalize (GObject * obj)
{
	BudgieSettingsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow);
	_g_object_unref0 (self->priv->_widget);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (budgie_settings_row_parent_class)->finalize (obj);
}

/**
* A SettingsRow is used to control the content layout in a SettingsPage
* to ensure everyone conforms to the page grid
*/
static GType
budgie_settings_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsRow), 0, (GInstanceInitFunc) budgie_settings_row_instance_init, NULL };
	GType budgie_settings_row_type_id;
	budgie_settings_row_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieSettingsRow", &g_define_type_info, 0);
	BudgieSettingsRow_private_offset = g_type_add_instance_private (budgie_settings_row_type_id, sizeof (BudgieSettingsRowPrivate));
	return budgie_settings_row_type_id;
}

GType
budgie_settings_row_get_type (void)
{
	static volatile gsize budgie_settings_row_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_row_type_id__once)) {
		GType budgie_settings_row_type_id;
		budgie_settings_row_type_id = budgie_settings_row_get_type_once ();
		g_once_init_leave (&budgie_settings_row_type_id__once, budgie_settings_row_type_id);
	}
	return budgie_settings_row_type_id__once;
}

static void
_vala_budgie_settings_row_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BudgieSettingsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow);
	switch (property_id) {
		case BUDGIE_SETTINGS_ROW_WIDGET_PROPERTY:
		g_value_set_object (value, budgie_settings_row_get_widget (self));
		break;
		case BUDGIE_SETTINGS_ROW_LABEL_PROPERTY:
		g_value_set_string (value, budgie_settings_row_get_label (self));
		break;
		case BUDGIE_SETTINGS_ROW_DESCRIPTION_PROPERTY:
		g_value_set_string (value, budgie_settings_row_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_settings_row_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BudgieSettingsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow);
	switch (property_id) {
		case BUDGIE_SETTINGS_ROW_WIDGET_PROPERTY:
		budgie_settings_row_set_widget (self, g_value_get_object (value));
		break;
		case BUDGIE_SETTINGS_ROW_LABEL_PROPERTY:
		budgie_settings_row_set_label (self, g_value_get_string (value));
		break;
		case BUDGIE_SETTINGS_ROW_DESCRIPTION_PROPERTY:
		budgie_settings_row_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/**
* Add a new row into this SettingsPage, taking ownership of the row
* content and widgets.
*/
void
budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                              BudgieSettingsRow* row)
{
	GtkLabel* lab_main = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkWidget* _tmp19_;
	GtkWidget* _tmp20_;
	GtkWidget* _tmp21_;
	GtkWidget* _tmp22_;
	GtkWidget* _tmp23_;
	GtkWidget* _tmp24_;
	gint _tmp25_ = 0;
	GtkWidget* _tmp26_;
	GtkWidget* _tmp27_;
	GtkWidget* _tmp28_;
	GtkWidget* _tmp29_;
	gint _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GtkLabel* desc_lab = NULL;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	gint _tmp37_ = 0;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GValue _tmp40_ = {0};
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* _tmp43_;
	GtkStyleContext* _tmp44_;
	GtkLabel* _tmp45_;
	gint _tmp46_;
	g_return_if_fail (self != NULL);
	lab_main = NULL;
	_tmp0_ = budgie_settings_row_get_label (row);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		GtkLabel* _tmp7_;
		GtkLabel* _tmp8_;
		gint _tmp9_ = 0;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GtkWidget* _tmp12_;
		GtkWidget* _tmp13_;
		_tmp2_ = budgie_settings_row_get_label (row);
		_tmp3_ = _tmp2_;
		_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (lab_main);
		lab_main = _tmp4_;
		_tmp5_ = lab_main;
		gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
		_tmp6_ = lab_main;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, 12);
		_tmp7_ = lab_main;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
		_tmp8_ = lab_main;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp8_, 0, self->current_row, 1, 1);
		_tmp10_ = budgie_settings_row_get_description (row);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			_tmp9_ = 1;
		} else {
			_tmp9_ = 2;
		}
		_tmp12_ = budgie_settings_row_get_widget (row);
		_tmp13_ = _tmp12_;
		gtk_grid_attach ((GtkGrid*) self, _tmp13_, 1, self->current_row, 1, _tmp9_);
	} else {
		gint _tmp14_ = 0;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GtkWidget* _tmp17_;
		GtkWidget* _tmp18_;
		_tmp15_ = budgie_settings_row_get_description (row);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == NULL) {
			_tmp14_ = 1;
		} else {
			_tmp14_ = 2;
		}
		_tmp17_ = budgie_settings_row_get_widget (row);
		_tmp18_ = _tmp17_;
		gtk_grid_attach ((GtkGrid*) self, _tmp18_, 0, self->current_row, 2, _tmp14_);
	}
	_tmp19_ = budgie_settings_row_get_widget (row);
	_tmp20_ = _tmp19_;
	gtk_widget_set_halign (_tmp20_, GTK_ALIGN_END);
	_tmp21_ = budgie_settings_row_get_widget (row);
	_tmp22_ = _tmp21_;
	gtk_widget_set_valign (_tmp22_, GTK_ALIGN_CENTER);
	_tmp23_ = budgie_settings_row_get_widget (row);
	_tmp24_ = _tmp23_;
	gtk_widget_set_vexpand (_tmp24_, FALSE);
	if (self->small_mode) {
		_tmp25_ = 8;
	} else {
		_tmp25_ = 28;
	}
	_tmp26_ = budgie_settings_row_get_widget (row);
	_tmp27_ = _tmp26_;
	gtk_widget_set_margin_start (_tmp27_, _tmp25_);
	_tmp28_ = budgie_settings_row_get_widget (row);
	_tmp29_ = _tmp28_;
	gtk_widget_set_margin_top (_tmp29_, 12);
	self->current_row = self->current_row + 1;
	_tmp30_ = self->current_row;
	_tmp31_ = budgie_settings_row_get_description (row);
	_tmp32_ = _tmp31_;
	if (_tmp32_ == NULL) {
		_g_object_unref0 (lab_main);
		return;
	}
	_tmp33_ = budgie_settings_row_get_description (row);
	_tmp34_ = _tmp33_;
	_tmp35_ = (GtkLabel*) gtk_label_new (_tmp34_);
	g_object_ref_sink (_tmp35_);
	desc_lab = _tmp35_;
	_tmp36_ = desc_lab;
	gtk_widget_set_halign ((GtkWidget*) _tmp36_, GTK_ALIGN_START);
	if (self->small_mode) {
		_tmp37_ = 12;
	} else {
		_tmp37_ = 40;
	}
	_tmp38_ = desc_lab;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp38_, _tmp37_);
	_tmp39_ = desc_lab;
	g_value_init (&_tmp40_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp40_, 0.0);
	g_object_set_property ((GObject*) _tmp39_, "xalign", &_tmp40_);
	G_IS_VALUE (&_tmp40_) ? (g_value_unset (&_tmp40_), NULL) : NULL;
	_tmp41_ = desc_lab;
	gtk_label_set_line_wrap (_tmp41_, TRUE);
	_tmp42_ = desc_lab;
	gtk_label_set_line_wrap_mode (_tmp42_, PANGO_WRAP_WORD);
	_tmp43_ = desc_lab;
	_tmp44_ = gtk_widget_get_style_context ((GtkWidget*) _tmp43_);
	gtk_style_context_add_class (_tmp44_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp45_ = desc_lab;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp45_, 0, self->current_row, 1, 1);
	self->current_row = self->current_row + 1;
	_tmp46_ = self->current_row;
	_g_object_unref0 (desc_lab);
	_g_object_unref0 (lab_main);
}

BudgieSettingsGrid*
budgie_settings_grid_construct (GType object_type)
{
	BudgieSettingsGrid * self = NULL;
	self = (BudgieSettingsGrid*) g_object_new (object_type, NULL);
	return self;
}

BudgieSettingsGrid*
budgie_settings_grid_new (void)
{
	return budgie_settings_grid_construct (BUDGIE_TYPE_SETTINGS_GRID);
}

static void
budgie_settings_grid_class_init (BudgieSettingsGridClass * klass,
                                 gpointer klass_data)
{
	budgie_settings_grid_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_settings_grid_finalize;
}

static void
budgie_settings_grid_instance_init (BudgieSettingsGrid * self,
                                    gpointer klass)
{
	self->current_row = 0;
	self->small_mode = FALSE;
}

static void
budgie_settings_grid_finalize (GObject * obj)
{
	BudgieSettingsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid);
	G_OBJECT_CLASS (budgie_settings_grid_parent_class)->finalize (obj);
}

/**
* A settings grid is just a helper with some methods to add new setting items
* easily without buggering about with the internals of GtkGrids
*/
static GType
budgie_settings_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsGrid), 0, (GInstanceInitFunc) budgie_settings_grid_instance_init, NULL };
	GType budgie_settings_grid_type_id;
	budgie_settings_grid_type_id = g_type_register_static (gtk_grid_get_type (), "BudgieSettingsGrid", &g_define_type_info, 0);
	return budgie_settings_grid_type_id;
}

GType
budgie_settings_grid_get_type (void)
{
	static volatile gsize budgie_settings_grid_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_grid_type_id__once)) {
		GType budgie_settings_grid_type_id;
		budgie_settings_grid_type_id = budgie_settings_grid_get_type_once ();
		g_once_init_leave (&budgie_settings_grid_type_id__once, budgie_settings_grid_type_id);
	}
	return budgie_settings_grid_type_id__once;
}

static inline gpointer
budgie_settings_page_get_instance_private (BudgieSettingsPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsPage_private_offset);
}

BudgieSettingsPage*
budgie_settings_page_construct (GType object_type)
{
	BudgieSettingsPage * self = NULL;
	self = (BudgieSettingsPage*) g_object_new (object_type, NULL);
	return self;
}

BudgieSettingsPage*
budgie_settings_page_new (void)
{
	return budgie_settings_page_construct (BUDGIE_TYPE_SETTINGS_PAGE);
}

const gchar*
budgie_settings_page_get_group (BudgieSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group;
	result = _tmp0_;
	return result;
}

void
budgie_settings_page_set_group (BudgieSettingsPage* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_page_get_group (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_group);
		self->priv->_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_GROUP_PROPERTY]);
	}
}

const gchar*
budgie_settings_page_get_content_id (BudgieSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_id;
	result = _tmp0_;
	return result;
}

void
budgie_settings_page_set_content_id (BudgieSettingsPage* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_page_get_content_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_id);
		self->priv->_content_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_CONTENT_ID_PROPERTY]);
	}
}

const gchar*
budgie_settings_page_get_icon_name (BudgieSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
budgie_settings_page_set_icon_name (BudgieSettingsPage* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_page_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_ICON_NAME_PROPERTY]);
	}
}

const gchar*
budgie_settings_page_get_title (BudgieSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
budgie_settings_page_set_title (BudgieSettingsPage* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_page_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_TITLE_PROPERTY]);
	}
}

gboolean
budgie_settings_page_get_want_scroll (BudgieSettingsPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_want_scroll;
	return result;
}

void
budgie_settings_page_set_want_scroll (BudgieSettingsPage* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_page_get_want_scroll (self);
	if (old_value != value) {
		self->priv->_want_scroll = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_WANT_SCROLL_PROPERTY]);
	}
}

gint
budgie_settings_page_get_display_weight (BudgieSettingsPage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_display_weight;
	return result;
}

void
budgie_settings_page_set_display_weight (BudgieSettingsPage* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_page_get_display_weight (self);
	if (old_value != value) {
		self->priv->_display_weight = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_DISPLAY_WEIGHT_PROPERTY]);
	}
}

static GObject *
budgie_settings_page_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieSettingsPage * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (budgie_settings_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 20);
	gtk_widget_set_margin_end ((GtkWidget*) self, 24);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "settings-page");
	return obj;
}

static void
budgie_settings_page_class_init (BudgieSettingsPageClass * klass,
                                 gpointer klass_data)
{
	budgie_settings_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieSettingsPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_settings_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_settings_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_settings_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_settings_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PAGE_GROUP_PROPERTY, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_GROUP_PROPERTY] = g_param_spec_string ("group", "group", "group", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PAGE_CONTENT_ID_PROPERTY, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_CONTENT_ID_PROPERTY] = g_param_spec_string ("content-id", "content-id", "content-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PAGE_ICON_NAME_PROPERTY, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PAGE_TITLE_PROPERTY, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PAGE_WANT_SCROLL_PROPERTY, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_WANT_SCROLL_PROPERTY] = g_param_spec_boolean ("want-scroll", "want-scroll", "want-scroll", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PAGE_DISPLAY_WEIGHT_PROPERTY, budgie_settings_page_properties[BUDGIE_SETTINGS_PAGE_DISPLAY_WEIGHT_PROPERTY] = g_param_spec_int ("display-weight", "display-weight", "display-weight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_settings_page_instance_init (BudgieSettingsPage * self,
                                    gpointer klass)
{
	self->priv = budgie_settings_page_get_instance_private (self);
	self->priv->_want_scroll = TRUE;
	self->priv->_display_weight = 0;
}

static void
budgie_settings_page_finalize (GObject * obj)
{
	BudgieSettingsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage);
	_g_free0 (self->priv->_group);
	_g_free0 (self->priv->_content_id);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (budgie_settings_page_parent_class)->finalize (obj);
}

/**
* A base SettingsPage exposes properties to allow it to fit into the UI
* and sidebar navigation
*/
static GType
budgie_settings_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsPage), 0, (GInstanceInitFunc) budgie_settings_page_instance_init, NULL };
	GType budgie_settings_page_type_id;
	budgie_settings_page_type_id = g_type_register_static (gtk_box_get_type (), "BudgieSettingsPage", &g_define_type_info, 0);
	BudgieSettingsPage_private_offset = g_type_add_instance_private (budgie_settings_page_type_id, sizeof (BudgieSettingsPagePrivate));
	return budgie_settings_page_type_id;
}

GType
budgie_settings_page_get_type (void)
{
	static volatile gsize budgie_settings_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_page_type_id__once)) {
		GType budgie_settings_page_type_id;
		budgie_settings_page_type_id = budgie_settings_page_get_type_once ();
		g_once_init_leave (&budgie_settings_page_type_id__once, budgie_settings_page_type_id);
	}
	return budgie_settings_page_type_id__once;
}

static void
_vala_budgie_settings_page_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BudgieSettingsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage);
	switch (property_id) {
		case BUDGIE_SETTINGS_PAGE_GROUP_PROPERTY:
		g_value_set_string (value, budgie_settings_page_get_group (self));
		break;
		case BUDGIE_SETTINGS_PAGE_CONTENT_ID_PROPERTY:
		g_value_set_string (value, budgie_settings_page_get_content_id (self));
		break;
		case BUDGIE_SETTINGS_PAGE_ICON_NAME_PROPERTY:
		g_value_set_string (value, budgie_settings_page_get_icon_name (self));
		break;
		case BUDGIE_SETTINGS_PAGE_TITLE_PROPERTY:
		g_value_set_string (value, budgie_settings_page_get_title (self));
		break;
		case BUDGIE_SETTINGS_PAGE_WANT_SCROLL_PROPERTY:
		g_value_set_boolean (value, budgie_settings_page_get_want_scroll (self));
		break;
		case BUDGIE_SETTINGS_PAGE_DISPLAY_WEIGHT_PROPERTY:
		g_value_set_int (value, budgie_settings_page_get_display_weight (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_settings_page_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BudgieSettingsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage);
	switch (property_id) {
		case BUDGIE_SETTINGS_PAGE_GROUP_PROPERTY:
		budgie_settings_page_set_group (self, g_value_get_string (value));
		break;
		case BUDGIE_SETTINGS_PAGE_CONTENT_ID_PROPERTY:
		budgie_settings_page_set_content_id (self, g_value_get_string (value));
		break;
		case BUDGIE_SETTINGS_PAGE_ICON_NAME_PROPERTY:
		budgie_settings_page_set_icon_name (self, g_value_get_string (value));
		break;
		case BUDGIE_SETTINGS_PAGE_TITLE_PROPERTY:
		budgie_settings_page_set_title (self, g_value_get_string (value));
		break;
		case BUDGIE_SETTINGS_PAGE_WANT_SCROLL_PROPERTY:
		budgie_settings_page_set_want_scroll (self, g_value_get_boolean (value));
		break;
		case BUDGIE_SETTINGS_PAGE_DISPLAY_WEIGHT_PROPERTY:
		budgie_settings_page_set_display_weight (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

