/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDescriptor;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import java.io.File;
import junit.framework.TestCase;

public class ExifDescriptorTest
extends TestCase {
    public ExifDescriptorTest(String s) {
        super(s);
    }

    public void testXResolutionDescription() throws Exception {
        ExifDirectory directory = new ExifDirectory();
        directory.setRational(282, new Rational(72, 1));
        directory.setInt(296, 2);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"72 dots per inch", (String)descriptor.getDescription(282));
    }

    public void testYResolutionDescription() throws Exception {
        ExifDirectory directory = new ExifDirectory();
        directory.setRational(283, new Rational(50, 1));
        directory.setInt(296, 3);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"50 dots per cm", (String)descriptor.getDescription(283));
    }

    public void testUserCommentDescription_EmptyEncoding() throws Exception {
        byte[] commentBytes = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000This is a comment".getBytes();
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"This is a comment", (String)descriptor.getDescription(37510));
    }

    public void testUserCommentDescription_AsciiHeaderExtendedAsciiEncoding() throws Exception {
        byte[] commentBytes = "ASCII\u0000\u0000This is a comment with extended characters ??? ???".getBytes();
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"This is a comment with extended characters ??? ???", (String)descriptor.getDescription(37510));
    }

    public void testUserCommentDescription_AsciiHeaderAsciiEncoding() throws Exception {
        byte[] commentBytes = "ASCII\u0000\u0000This is a comment".getBytes();
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"This is a comment", (String)descriptor.getDescription(37510));
    }

    public void testUserCommentDescription_BlankAscii() throws Exception {
        byte[] commentBytes = "ASCII\u0000\u0000\u0000          ".getBytes();
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"", (String)descriptor.getDescription(37510));
    }

    public void testUserCommentDescription_ZeroLengthAscii1() throws Exception {
        byte[] commentBytes = "ASCII\u0000\u0000\u0000".getBytes();
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"ASCII", (String)descriptor.getDescription(37510));
    }

    public void testUserCommentDescription_ZeroLengthAscii2() throws Exception {
        byte[] commentBytes = "ASCII\u0000\u0000\u0000\u0000\u0000".getBytes();
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"", (String)descriptor.getDescription(37510));
    }

    public void testUnicodeComment_ActualBytes() throws Exception {
        byte[] byArray = new byte[302];
        byArray[0] = 85;
        byArray[1] = 78;
        byArray[2] = 73;
        byArray[3] = 67;
        byArray[4] = 79;
        byArray[5] = 68;
        byArray[6] = 69;
        byArray[8] = 84;
        byArray[10] = 104;
        byArray[12] = 105;
        byArray[14] = 115;
        byArray[16] = 32;
        byArray[18] = 109;
        byArray[20] = 97;
        byArray[22] = 114;
        byArray[24] = 109;
        byArray[26] = 111;
        byArray[28] = 116;
        byArray[30] = 32;
        byArray[32] = 105;
        byArray[34] = 115;
        byArray[36] = 32;
        byArray[38] = 103;
        byArray[40] = 101;
        byArray[42] = 116;
        byArray[44] = 116;
        byArray[46] = 105;
        byArray[48] = 110;
        byArray[50] = 103;
        byArray[52] = 32;
        byArray[54] = 99;
        byArray[56] = 108;
        byArray[58] = 111;
        byArray[60] = 115;
        byArray[62] = 101;
        byArray[64] = 46;
        byArray[66] = 46;
        byArray[68] = 46;
        byArray[70] = 32;
        byArray[72] = 32;
        byArray[74] = 32;
        byArray[76] = 32;
        byArray[78] = 32;
        byArray[80] = 32;
        byArray[82] = 32;
        byArray[84] = 32;
        byArray[86] = 32;
        byArray[88] = 32;
        byArray[90] = 32;
        byArray[92] = 32;
        byArray[94] = 32;
        byArray[96] = 32;
        byArray[98] = 32;
        byArray[100] = 32;
        byArray[102] = 32;
        byArray[104] = 32;
        byArray[106] = 32;
        byArray[108] = 32;
        byArray[110] = 32;
        byArray[112] = 32;
        byArray[114] = 32;
        byArray[116] = 32;
        byArray[118] = 32;
        byArray[120] = 32;
        byArray[122] = 32;
        byArray[124] = 32;
        byArray[126] = 32;
        byArray[128] = 32;
        byArray[130] = 32;
        byArray[132] = 32;
        byArray[134] = 32;
        byArray[136] = 32;
        byArray[138] = 32;
        byArray[140] = 32;
        byArray[142] = 32;
        byArray[144] = 32;
        byArray[146] = 32;
        byArray[148] = 32;
        byArray[150] = 32;
        byArray[152] = 32;
        byArray[154] = 32;
        byArray[156] = 32;
        byArray[158] = 32;
        byArray[160] = 32;
        byArray[162] = 32;
        byArray[164] = 32;
        byArray[166] = 32;
        byArray[168] = 32;
        byArray[170] = 32;
        byArray[172] = 32;
        byArray[174] = 32;
        byArray[176] = 32;
        byArray[178] = 32;
        byArray[180] = 32;
        byArray[182] = 32;
        byArray[184] = 32;
        byArray[186] = 32;
        byArray[188] = 32;
        byArray[190] = 32;
        byArray[192] = 32;
        byArray[194] = 32;
        byArray[196] = 32;
        byArray[198] = 32;
        byArray[200] = 32;
        byArray[202] = 32;
        byArray[204] = 32;
        byArray[206] = 32;
        byArray[208] = 32;
        byArray[210] = 32;
        byArray[212] = 32;
        byArray[214] = 32;
        byArray[216] = 32;
        byArray[218] = 32;
        byArray[220] = 32;
        byArray[222] = 32;
        byArray[224] = 32;
        byArray[226] = 32;
        byArray[228] = 32;
        byArray[230] = 32;
        byArray[232] = 32;
        byArray[234] = 32;
        byArray[236] = 32;
        byArray[238] = 32;
        byArray[240] = 32;
        byArray[242] = 32;
        byArray[244] = 32;
        byArray[246] = 32;
        byArray[248] = 32;
        byArray[250] = 32;
        byArray[252] = 32;
        byArray[254] = 32;
        byArray[256] = 32;
        byArray[258] = 32;
        byArray[260] = 32;
        byArray[262] = 32;
        byArray[264] = 32;
        byArray[266] = 32;
        byArray[268] = 32;
        byArray[270] = 32;
        byArray[272] = 32;
        byArray[274] = 32;
        byArray[276] = 32;
        byArray[278] = 32;
        byArray[280] = 32;
        byArray[282] = 32;
        byArray[284] = 32;
        byArray[286] = 32;
        byArray[288] = 32;
        byArray[290] = 32;
        byArray[292] = 32;
        byArray[294] = 32;
        byArray[296] = 32;
        byArray[298] = 32;
        byArray[300] = 32;
        byte[] commentBytes = byArray;
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"This marmot is getting close...", (String)descriptor.getDescription(37510));
    }

    public void testUnicodeComment_Ascii() throws Exception {
        byte[] byArray = new byte[29];
        byArray[0] = 65;
        byArray[1] = 83;
        byArray[2] = 67;
        byArray[3] = 73;
        byArray[4] = 73;
        byArray[8] = 73;
        byArray[9] = 32;
        byArray[10] = 97;
        byArray[11] = 109;
        byArray[12] = 32;
        byArray[13] = 97;
        byArray[14] = 32;
        byArray[15] = 99;
        byArray[16] = 111;
        byArray[17] = 109;
        byArray[18] = 109;
        byArray[19] = 101;
        byArray[20] = 110;
        byArray[21] = 116;
        byArray[22] = 46;
        byArray[23] = 32;
        byArray[24] = 89;
        byArray[25] = 101;
        byArray[26] = 121;
        byArray[27] = 46;
        byte[] commentBytes = byArray;
        ExifDirectory directory = new ExifDirectory();
        directory.setByteArray(37510, commentBytes);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"I am a comment. Yey.", (String)descriptor.getDescription(37510));
    }

    public void testWindowsXpFields() throws Exception {
        String fileName = "src/com/drew/metadata/exif/test/windowsXpFields.jpg";
        Metadata metadata = new ExifReader(new File(fileName)).extract();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifDescriptor descriptor = new ExifDescriptor(directory);
        ExifDescriptorTest.assertEquals((String)"Testing artist", (String)descriptor.getDescription(40093));
        ExifDescriptorTest.assertEquals((String)"Testing comments", (String)descriptor.getDescription(40092));
        ExifDescriptorTest.assertEquals((String)"Testing keywords", (String)descriptor.getDescription(40094));
        ExifDescriptorTest.assertEquals((String)"Testing subject", (String)descriptor.getDescription(40095));
        ExifDescriptorTest.assertEquals((String)"Testing title", (String)descriptor.getDescription(40091));
    }
}

