/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import impl.org.controlsfx.tableview2.TableRow2;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import org.controlsfx.control.tableview2.TableView2;

public class TableRow2Skin<S>
extends CellSkinBase<TableRow<S>> {
    private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass LEFT_CELL = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_CELL = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass SINGLE_CELL = PseudoClass.getPseudoClass((String)"single");
    private static final PseudoClass FIXED_CELL = PseudoClass.getPseudoClass((String)"fixed");
    private final TableView2<S> tableView;
    private final TableView2Skin<S> skin;
    private Reference<HashMap<TableColumnBase, TableCell<S, ?>>> cellsMap;
    private final List<TableCell<S, ?>> cells = new ArrayList();
    private final TableView2<S> parentTableView;

    public TableRow2Skin(TableView2<S> tableView, TableRow<S> tableRow) {
        super(tableRow);
        this.tableView = tableView;
        ((TableRow)this.getSkinnable()).setPickOnBounds(false);
        this.registerChangeListener((ObservableValue)tableRow.itemProperty(), t -> this.requestCellUpdate());
        this.registerChangeListener((ObservableValue)tableRow.indexProperty(), t -> {
            if (((TableRow)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        });
        if (tableView.getParent() != null && tableView.getParent() instanceof RowHeader) {
            this.parentTableView = ((RowHeader)tableView.getParent()).getParentTableView();
            this.skin = (TableView2Skin)this.parentTableView.getSkin();
        } else {
            this.parentTableView = null;
            this.skin = (TableView2Skin)tableView.getSkin();
        }
    }

    private void requestCellUpdate() {
        ((TableRow)this.getSkinnable()).requestLayout();
        int newIndex = ((TableRow)this.getSkinnable()).getIndex();
        this.getChildren().clear();
        int max = this.cells.size();
        for (int i = 0; i < max; ++i) {
            this.cells.get(i).updateIndex(newIndex);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h2) {
        boolean singleColumn;
        ObservableList visibleLeafColumns = this.tableView.getVisibleLeafColumns();
        if (visibleLeafColumns.isEmpty()) {
            super.layoutChildren(x, y, w, h2);
            return;
        }
        TableRow2 control = (TableRow2)this.getSkinnable();
        int index = control.getIndex();
        if (index < 0) {
            this.getChildren().clear();
            this.putCellsInCache();
            return;
        }
        this.getChildren().removeIf(n -> n.getId() != null && n.getId().equals("pane-fixed-cell"));
        Object o = control.getProperties().get((Object)"fixed");
        boolean fixedRow = o != null && ((Boolean)o).equals(Boolean.TRUE);
        ObservableList columns = this.tableView.getVisibleLeafColumns();
        ((TableRow)this.getSkinnable()).setVisible(true);
        double height = 0.0;
        double verticalPadding = this.snappedTopInset() + this.snappedBottomInset();
        double horizontalPadding = this.snappedLeftInset() + this.snappedRightInset();
        double customHeight = this.skin.getRowHeight(control.getIndex());
        this.skin.hBarValue.set(index, true);
        double headerWidth = this.tableView.getWidth();
        double hbarValue = this.parentTableView != null ? 0.0 : this.skin.getHBar().getValue();
        control.verticalShift.setValue((Number)(this.tableView.isRowFixingEnabled() ? this.getFixedRowShift(index) : 0.0));
        double fixedColumnWidth = 0.0;
        ArrayList fixedCells = new ArrayList();
        this.putCellsInCache();
        boolean firstVisibleCell = false;
        TableCell<S, ?> lastCell = null;
        boolean rowHeightChange = false;
        boolean isFirstColumn = false;
        block5: for (int indexColumn = 0; indexColumn < columns.size(); ++indexColumn) {
            int columnSpan;
            boolean isVisible;
            TableColumn column = (TableColumn)columns.get(indexColumn);
            if (!column.isVisible()) continue;
            TableCell<S, ?> tableCell = this.getCell((TableColumnBase)column);
            if (!isFirstColumn) {
                tableCell.pseudoClassStateChanged(LEFT_CELL, true);
                isFirstColumn = true;
            }
            TablePosition pos = new TablePosition(this.tableView, tableCell.getIndex(), column);
            double width = this.snapSize(column.getWidth()) - this.snapSize(horizontalPadding);
            boolean bl = isVisible = !this.isInvisible(x, width, hbarValue, headerWidth, columnSpan = this.tableView.getColumnSpan(pos));
            while (column.getParentColumn() != null) {
                column = (TableColumn)column.getParentColumn();
            }
            if (this.tableView.isColumnFixingEnabled() && this.tableView.getFixedColumns().contains((Object)column)) {
                isVisible = true;
            }
            if (!isVisible) {
                if (firstVisibleCell) break;
                x += width;
                continue;
            }
            this.cells.add(0, tableCell);
            tableCell.setManaged(true);
            double tableCellX = 0.0;
            boolean increaseFixedWidth = false;
            if (this.tableView.isColumnFixingEnabled() && this.tableView.getFixedColumns().contains((Object)column) && hbarValue + fixedColumnWidth > x) {
                increaseFixedWidth = true;
                tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                fixedColumnWidth += width;
                fixedCells.add(tableCell);
            }
            if (isVisible) {
                TableView2.SpanType spanType = this.tableView.getSpanType(index, indexColumn);
                switch (spanType) {
                    case ROW_SPAN_INVISIBLE: 
                    case BOTH_INVISIBLE: {
                        fixedCells.remove(tableCell);
                        this.getChildren().remove(tableCell);
                        x += width;
                        continue block5;
                    }
                    case COLUMN_SPAN_INVISIBLE: {
                        fixedCells.remove(tableCell);
                        this.getChildren().remove(tableCell);
                        continue block5;
                    }
                    case ROW_VISIBLE: 
                    case NORMAL_CELL: {
                        if (tableCell.getIndex() != index) {
                            tableCell.updateIndex(index);
                        } else {
                            tableCell.updateIndex(index);
                            tableCell.requestLayout();
                        }
                        if (!tableCell.isEditing() && tableCell.getParent() != this.getSkinnable()) {
                            this.getChildren().add(0, tableCell);
                        }
                    }
                    default: {
                        int i;
                        if (this.tableView.getSelectionModel() != null && this.tableView.getSelectionModel().isCellSelectionEnabled()) {
                            int ic = indexColumn;
                            boolean select = !this.tableView.getSelectionModel().getSelectedCells().stream().noneMatch(cell -> cell.getRow() == index && cell.getColumn() == ic);
                            tableCell.pseudoClassStateChanged(SELECTED, select);
                        }
                        if (columnSpan > 1) {
                            int viewColumn = this.skin.getViewColumn(indexColumn);
                            int max = this.tableView.getVisibleLeafColumns().size() - viewColumn;
                            int colSpan = columnSpan;
                            for (i = 1; i < colSpan && i < max; ++i) {
                                double tempWidth = this.snapSize(this.tableView.getVisibleLeafColumn(viewColumn + i).getWidth());
                                width += tempWidth;
                                if (!increaseFixedWidth) continue;
                                fixedColumnWidth += tempWidth;
                            }
                        }
                        if (!tableCell.isEditing()) {
                            double tempHeight = tableCell.prefHeight(width) + tableCell.snappedTopInset() + tableCell.snappedBottomInset();
                            if (this.parentTableView != null && control.getIndex() < this.skin.getItemCount()) {
                                tempHeight = (Double)this.skin.rowHeightMap.getOrDefault((Object)control.getIndex(), (Object)tempHeight);
                            }
                            if (tempHeight > customHeight) {
                                rowHeightChange = true;
                                this.skin.rowHeightMap.put((Object)control.getIndex(), (Object)tempHeight);
                                for (TableCell<S, ?> cell2 : this.cells) {
                                    cell2.resize(cell2.getWidth(), cell2.getHeight() + (tempHeight - customHeight));
                                }
                                customHeight = tempHeight;
                                if (this.parentTableView != null) {
                                    ((TableView2Skin)this.tableView.getSkin()).getFlow().layoutChildren();
                                } else {
                                    this.skin.getFlow().layoutChildren();
                                }
                            }
                        }
                        height = customHeight;
                        height = this.snapSize(height) - this.snapSize(verticalPadding);
                        int rowSpan = this.tableView.getRowSpan(pos, index);
                        if (rowSpan > 1) {
                            height = 0.0;
                            int maxRow = index + rowSpan;
                            for (i = index; i < maxRow; ++i) {
                                height += this.snapSize(this.skin.getRowHeight(i));
                            }
                        }
                        boolean needToBeShifted = false;
                        if (lastCell != null && !this.hasRightBorder(lastCell) && !this.hasLeftBorder(tableCell)) {
                            tableCell.resize(width + 1.0, height);
                            needToBeShifted = true;
                        } else {
                            tableCell.resize(width, height);
                        }
                        lastCell = tableCell;
                        double spaceBetweenTopAndMe = 0.0;
                        tableCell.relocate(x + tableCellX + (double)(needToBeShifted ? -1 : 0), this.snappedTopInset() - spaceBetweenTopAndMe + control.verticalShift.get());
                        break;
                    }
                }
            } else {
                this.getChildren().remove(tableCell);
            }
            x += width;
        }
        double paneWidth = this.tableView.getWidth() - x - this.tableView.snappedLeftInset() - this.tableView.snappedRightInset();
        if (this.tableView.isRowHeaderVisible()) {
            paneWidth -= this.tableView.getRowHeaderWidth();
        }
        if (this.skin.getVBar().isVisible()) {
            paneWidth -= this.skin.getVBar().getWidth();
        }
        boolean paneBorderInset = true;
        boolean paneBorderVisible = paneWidth > 1.0;
        boolean bl = singleColumn = columns.size() == 1;
        if (fixedRow && paneWidth >= 0.0 && this.parentTableView == null) {
            Pane pane = new Pane();
            pane.setId("pane-fixed-cell");
            pane.getStyleClass().add((Object)"tableview2-cell");
            pane.pseudoClassStateChanged(RIGHT_CELL, paneBorderVisible);
            pane.resizeRelocate(x, this.snappedTopInset() + control.verticalShift.get(), paneWidth, height);
            this.getChildren().add((Object)pane);
        }
        if (lastCell != null) {
            lastCell.pseudoClassStateChanged(RIGHT_CELL, !singleColumn && !paneBorderVisible);
            lastCell.pseudoClassStateChanged(SINGLE_CELL, singleColumn && !paneBorderVisible);
            if (this.parentTableView != null) {
                lastCell.pseudoClassStateChanged(FIXED_CELL, fixedRow && control.getIndex() < this.skin.getItemCount());
            }
        }
        this.skin.fixedColumnWidth = fixedColumnWidth;
        this.handleFixedCell(fixedCells, index);
        this.removeUselessCell(index);
        if (this.skin.lastRowLayout.get()) {
            this.skin.lastRowLayout.setValue(Boolean.valueOf(false));
        }
        if (rowHeightChange && this.tableView.getFixedRows().contains((Object)index)) {
            this.skin.computeFixedRowHeight();
        }
    }

    private boolean hasRightBorder(TableCell<S, ?> tableCell) {
        return tableCell.getBorder() != null && !tableCell.getBorder().isEmpty() && ((BorderStroke)tableCell.getBorder().getStrokes().get(0)).getWidths().getRight() > 0.0;
    }

    private boolean hasLeftBorder(TableCell<S, ?> tableCell) {
        return tableCell.getBorder() != null && !tableCell.getBorder().isEmpty() && ((BorderStroke)tableCell.getBorder().getStrokes().get(0)).getWidths().getLeft() > 0.0;
    }

    private void removeUselessCell(int index) {
        this.getChildren().removeIf(t -> {
            if (t instanceof TableCell) {
                return !this.cells.contains((TableCell)t) && ((TableCell)t).getIndex() == index;
            }
            return false;
        });
    }

    private void removeDeportedCells() {
        for (Map.Entry entry : this.skin.deportedCells.entrySet()) {
            ArrayList toRemove = new ArrayList();
            for (TableCell cell : entry.getValue()) {
                if (cell.isEditing() || cell.getTableRow() != this.getSkinnable() || entry.getKey() == this.getSkinnable()) continue;
                entry.getKey().removeCell(cell);
                toRemove.add(cell);
            }
            entry.getValue().removeAll(toRemove);
        }
    }

    private void handleFixedCell(List<TableCell<S, ?>> fixedCells, int index) {
        block7: {
            block6: {
                this.removeDeportedCells();
                if (fixedCells.isEmpty()) {
                    return;
                }
                if (!this.skin.rowToLayout.get(index)) break block6;
                TableRow tableRow = (TableRow)this.getSkinnable();
                if (tableRow == null || !(tableRow instanceof TableRow2)) break block7;
                TableRow2 tableRow2 = (TableRow2)tableRow;
                for (TableCell<S, ?> cell : fixedCells) {
                    if (!cell.isEditing()) {
                        tableRow2.removeCell(cell);
                        tableRow2.addCell(cell);
                    }
                    double originalLayoutY = ((TableRow)this.getSkinnable()).getLayoutY() + cell.getLayoutY();
                    if (this.skin.deportedCells.containsKey((Object)tableRow2)) {
                        this.skin.deportedCells.get((Object)tableRow2).add(cell);
                    } else {
                        HashSet temp = new HashSet();
                        temp.add(cell);
                        this.skin.deportedCells.put(tableRow2, temp);
                    }
                    cell.relocate(cell.getLayoutX(), originalLayoutY - tableRow.getLayoutY());
                }
                break block7;
            }
            for (TableCell<S, ?> cell : fixedCells) {
                cell.toFront();
            }
        }
    }

    private HashMap<TableColumnBase, TableCell<S, ?>> getCellsMap() {
        if (this.cellsMap == null || this.cellsMap.get() == null) {
            HashMap map = new HashMap();
            this.cellsMap = new WeakReference(map);
            return map;
        }
        return this.cellsMap.get();
    }

    private void putCellsInCache() {
        for (TableCell<S, ?> cell : this.cells) {
            this.getCellsMap().put((TableColumnBase)cell.getTableColumn(), cell);
        }
        this.cells.clear();
    }

    private TableCell<S, ?> getCell(TableColumnBase tcb) {
        TableCell cell;
        TableColumn tableColumn = (TableColumn)tcb;
        if (this.getCellsMap().containsKey(tableColumn)) {
            cell = this.getCellsMap().remove(tableColumn);
        } else {
            Callback cellFactory = tableColumn.getCellFactory();
            if (cellFactory == null) {
                cellFactory = TableColumn.DEFAULT_CELL_FACTORY;
            }
            if (!(cell = (TableCell)cellFactory.call((Object)tableColumn)).getStyleClass().contains((Object)"tableview2-cell")) {
                cell.getStyleClass().add((Object)"tableview2-cell");
            }
            cell.updateTableColumn(tableColumn);
            cell.updateTableView(tableColumn.getTableView());
            cell.updateTableRow((TableRow)this.getSkinnable());
            if (this.parentTableView != null) {
                cell.setOnContextMenuRequested(e -> {
                    BiFunction<Integer, S, ContextMenu> cmFactory = this.parentTableView.getRowHeaderContextMenuFactory();
                    if (this.tableView.getItems() != null && cmFactory != null) {
                        ContextMenu contextMenu = cmFactory.apply(((TableRow)this.getSkinnable()).getIndex(), ((TableRow)this.getSkinnable()).getItem());
                        contextMenu.show(this.tableView.getScene().getWindow(), e.getScreenX(), e.getScreenY());
                    }
                });
            }
        }
        cell.pseudoClassStateChanged(LEFT_CELL, false);
        cell.pseudoClassStateChanged(RIGHT_CELL, false);
        cell.pseudoClassStateChanged(SINGLE_CELL, false);
        return cell;
    }

    private double getFixedRowShift(int index) {
        double tableCellY = 0.0;
        int positionY = this.tableView.getFixedRows().indexOf((Object)index);
        double space = 0.0;
        for (int o = 0; o < positionY; ++o) {
            space += this.skin.getRowHeight((Integer)this.tableView.getFixedRows().get(o));
        }
        if (positionY != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= space) {
            tableCellY = space - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            this.skin.getCurrentlyFixedRow().add((Object)index);
        } else {
            this.skin.getCurrentlyFixedRow().remove((Object)index);
        }
        return tableCellY;
    }

    private boolean isInvisible(double x, double width, double hbarValue, double headerWidth, int columnSpan) {
        return x + width < hbarValue && columnSpan == 1 || x > hbarValue + headerWidth;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = 0.0;
        ObservableList visibleLeafColumns = this.tableView.getVisibleLeafColumns();
        int max = visibleLeafColumns.size();
        for (int i = 0; i < max; ++i) {
            prefWidth += ((TableColumnBase)visibleLeafColumns.get(i)).getWidth();
        }
        return prefWidth;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.parentTableView != null) {
            return this.skin.getRow(((TableRow)this.getSkinnable()).getIndex()).getPrefHeight();
        }
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.parentTableView != null) {
            return this.skin.getRow(((TableRow)this.getSkinnable()).getIndex()).getPrefHeight();
        }
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

