#include "zink_device_info.h"
#include "zink_screen.h"

bool
zink_get_physical_device_info(struct zink_screen *screen) 
{
   struct zink_device_info *info = &screen->info;
   bool support_KHR_maintenance1 = false;
   bool support_KHR_maintenance2 = false;
   bool support_KHR_maintenance3 = false;
   bool support_KHR_external_memory = false;
   bool support_KHR_external_memory_fd = false;
   bool support_KHR_external_semaphore_fd = false;
   bool support_EXT_external_memory_dma_buf = false;
   bool support_EXT_queue_family_foreign = false;
   bool support_EXT_provoking_vertex = false;
   bool support_EXT_shader_viewport_index_layer = false;
   bool support_KHR_get_memory_requirements2 = false;
   bool support_EXT_post_depth_coverage = false;
   bool support_EXT_shader_subgroup_ballot = false;
   bool support_EXT_shader_atomic_float = false;
   bool support_KHR_8bit_storage = false;
   bool support_KHR_16bit_storage = false;
   bool support_KHR_driver_properties = false;
   bool support_EXT_memory_budget = false;
   bool support_KHR_draw_indirect_count = false;
   bool support_EXT_fragment_shader_interlock = false;
   bool support_EXT_sample_locations = false;
   bool support_EXT_conservative_rasterization = false;
   bool support_KHR_shader_draw_parameters = false;
   bool support_KHR_sampler_mirror_clamp_to_edge = false;
   bool support_EXT_conditional_rendering = false;
   bool support_EXT_transform_feedback = false;
   bool support_EXT_index_type_uint8 = false;
   bool support_KHR_image_format_list = false;
   bool support_KHR_sampler_ycbcr_conversion = false;
   bool support_KHR_imageless_framebuffer = false;
   bool support_EXT_robustness2 = false;
   bool support_EXT_image_drm_format_modifier = false;
   bool support_EXT_vertex_attribute_divisor = false;
   bool support_EXT_calibrated_timestamps = false;
   bool support_KHR_shader_clock = false;
   bool support_EXT_sampler_filter_minmax = false;
   bool support_EXT_custom_border_color = false;
   bool support_EXT_blend_operation_advanced = false;
   bool support_EXT_extended_dynamic_state = false;
   bool support_EXT_extended_dynamic_state2 = false;
   bool support_EXT_pipeline_creation_cache_control = false;
   bool support_EXT_shader_stencil_export = false;
#ifdef VK_EXTX_PORTABILITY_SUBSET_EXTENSION_NAME
   bool support_EXTX_portability_subset = false;
#endif
   bool support_KHR_timeline_semaphore = false;
   bool support_EXT_4444_formats = false;
   bool support_EXT_scalar_block_layout = false;
   bool support_KHR_swapchain = false;
   bool support_KHR_shader_float16_int8 = false;
   bool support_EXT_multi_draw = false;
   bool support_KHR_push_descriptor = false;
   bool support_KHR_descriptor_update_template = false;
   bool support_EXT_line_rasterization = false;
   bool support_EXT_vertex_input_dynamic_state = false;
   bool support_EXT_primitive_topology_list_restart = false;
   bool support_KHR_dedicated_allocation = false;
   bool support_EXT_descriptor_indexing = false;
   uint32_t num_extensions = 0;

   // get device memory properties
   vkGetPhysicalDeviceMemoryProperties(screen->pdev, &info->mem_props);

   // enumerate device supported extensions
   if (vkEnumerateDeviceExtensionProperties(screen->pdev, NULL, &num_extensions, NULL) == VK_SUCCESS) {
      if (num_extensions > 0) {
         VkExtensionProperties *extensions = MALLOC(sizeof(VkExtensionProperties) * num_extensions);
         if (!extensions) goto fail;
         vkEnumerateDeviceExtensionProperties(screen->pdev, NULL, &num_extensions, extensions);

         for (uint32_t i = 0; i < num_extensions; ++i) {
            if (!strcmp(extensions[i].extensionName, "VK_KHR_maintenance1")) {
               info->have_KHR_maintenance1 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_maintenance2")) {
               info->have_KHR_maintenance2 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_maintenance3")) {
               info->have_KHR_maintenance3 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_external_memory")) {
               info->have_KHR_external_memory = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_external_memory_fd")) {
               info->have_KHR_external_memory_fd = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_external_semaphore_fd")) {
               info->have_KHR_external_semaphore_fd = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_external_memory_dma_buf")) {
               info->have_EXT_external_memory_dma_buf = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_queue_family_foreign")) {
               info->have_EXT_queue_family_foreign = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_provoking_vertex")) {
               support_EXT_provoking_vertex = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_shader_viewport_index_layer")) {
               info->have_EXT_shader_viewport_index_layer = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_get_memory_requirements2")) {
               info->have_KHR_get_memory_requirements2 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_post_depth_coverage")) {
               info->have_EXT_post_depth_coverage = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_shader_subgroup_ballot")) {
               info->have_EXT_shader_subgroup_ballot = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_shader_atomic_float")) {
               support_EXT_shader_atomic_float = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_8bit_storage")) {
               support_KHR_8bit_storage = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_16bit_storage")) {
               support_KHR_16bit_storage = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_driver_properties")) {
               support_KHR_driver_properties = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_memory_budget")) {
               info->have_EXT_memory_budget = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_draw_indirect_count")) {
               info->have_KHR_draw_indirect_count = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_fragment_shader_interlock")) {
               support_EXT_fragment_shader_interlock = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_sample_locations")) {
               support_EXT_sample_locations = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_conservative_rasterization")) {
               support_EXT_conservative_rasterization = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_shader_draw_parameters")) {
               info->have_KHR_shader_draw_parameters = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_sampler_mirror_clamp_to_edge")) {
               info->have_KHR_sampler_mirror_clamp_to_edge = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_conditional_rendering")) {
               support_EXT_conditional_rendering = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_transform_feedback")) {
               support_EXT_transform_feedback = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_index_type_uint8")) {
               support_EXT_index_type_uint8 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_image_format_list")) {
               info->have_KHR_image_format_list = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_sampler_ycbcr_conversion")) {
               info->have_KHR_sampler_ycbcr_conversion = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_imageless_framebuffer")) {
               support_KHR_imageless_framebuffer = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_robustness2")) {
               support_EXT_robustness2 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_image_drm_format_modifier")) {
               info->have_EXT_image_drm_format_modifier = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_vertex_attribute_divisor")) {
               support_EXT_vertex_attribute_divisor = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_calibrated_timestamps")) {
               info->have_EXT_calibrated_timestamps = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_shader_clock")) {
               support_KHR_shader_clock = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_sampler_filter_minmax")) {
               support_EXT_sampler_filter_minmax = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_custom_border_color")) {
               support_EXT_custom_border_color = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_blend_operation_advanced")) {
               support_EXT_blend_operation_advanced = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_extended_dynamic_state")) {
               support_EXT_extended_dynamic_state = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_extended_dynamic_state2")) {
               support_EXT_extended_dynamic_state2 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_pipeline_creation_cache_control")) {
               support_EXT_pipeline_creation_cache_control = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_shader_stencil_export")) {
               info->have_EXT_shader_stencil_export = true;
            }
         #ifdef VK_EXTX_PORTABILITY_SUBSET_EXTENSION_NAME
   if (!strcmp(extensions[i].extensionName, "VK_EXTX_portability_subset")) {
               support_EXTX_portability_subset = true;
            }
#endif
            if (!strcmp(extensions[i].extensionName, "VK_KHR_timeline_semaphore")) {
               support_KHR_timeline_semaphore = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_4444_formats")) {
               support_EXT_4444_formats = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_scalar_block_layout")) {
               support_EXT_scalar_block_layout = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_swapchain")) {
               info->have_KHR_swapchain = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_shader_float16_int8")) {
               support_KHR_shader_float16_int8 = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_multi_draw")) {
               support_EXT_multi_draw = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_push_descriptor")) {
               support_KHR_push_descriptor = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_descriptor_update_template")) {
               info->have_KHR_descriptor_update_template = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_line_rasterization")) {
               support_EXT_line_rasterization = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_vertex_input_dynamic_state")) {
               support_EXT_vertex_input_dynamic_state = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_primitive_topology_list_restart")) {
               support_EXT_primitive_topology_list_restart = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_KHR_dedicated_allocation")) {
               info->have_KHR_dedicated_allocation = true;
            }
            if (!strcmp(extensions[i].extensionName, "VK_EXT_descriptor_indexing")) {
               support_EXT_descriptor_indexing = true;
            }
         }

         FREE(extensions);
      }
   }

   // get device features
   if (screen->vk.GetPhysicalDeviceFeatures2) {
      // check for device extension features
      info->feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2;

      if (VK_MAKE_VERSION(1,2,0) <= screen->vk_version) {
         /* VkPhysicalDeviceVulkan11Features was added in 1.2, not 1.1 as one would think */
         info->feats11.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES;
         info->feats11.pNext = info->feats.pNext;
         info->feats.pNext = &info->feats11;
         info->have_vulkan11 = true;
      }
      if (VK_MAKE_VERSION(1,2,0) <= screen->vk_version) {
         info->feats12.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES;
         info->feats12.pNext = info->feats.pNext;
         info->feats.pNext = &info->feats12;
         info->have_vulkan12 = true;
      }

   if (support_EXT_provoking_vertex) {
         info->pv_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT;
         info->pv_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->pv_feats;
      }
   if (support_EXT_shader_atomic_float) {
         info->atomic_float_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT;
         info->atomic_float_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->atomic_float_feats;
      }
   if (support_KHR_8bit_storage) {
         info->storage_8bit_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR;
         info->storage_8bit_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->storage_8bit_feats;
      }
   if (support_KHR_16bit_storage) {
         info->storage_16bit_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR;
         info->storage_16bit_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->storage_16bit_feats;
      }
   if (support_EXT_fragment_shader_interlock) {
         info->interlock_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT;
         info->interlock_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->interlock_feats;
      }
   if (support_EXT_conditional_rendering) {
         info->cond_render_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT;
         info->cond_render_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->cond_render_feats;
      }
   if (support_EXT_transform_feedback) {
         info->tf_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT;
         info->tf_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->tf_feats;
      }
   if (support_EXT_index_type_uint8) {
         info->index_uint8_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT;
         info->index_uint8_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->index_uint8_feats;
      }
   if (support_KHR_imageless_framebuffer) {
         info->imgless_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR;
         info->imgless_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->imgless_feats;
      }
   if (support_EXT_robustness2) {
         info->rb2_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT;
         info->rb2_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->rb2_feats;
      }
   if (support_EXT_vertex_attribute_divisor) {
         info->vdiv_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT;
         info->vdiv_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->vdiv_feats;
      }
   if (support_KHR_shader_clock) {
         info->shader_clock_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR;
         info->shader_clock_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->shader_clock_feats;
      }
   if (support_EXT_custom_border_color) {
         info->border_color_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT;
         info->border_color_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->border_color_feats;
      }
   if (support_EXT_extended_dynamic_state) {
         info->dynamic_state_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT;
         info->dynamic_state_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->dynamic_state_feats;
      }
   if (support_EXT_extended_dynamic_state2) {
         info->dynamic_state2_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT;
         info->dynamic_state2_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->dynamic_state2_feats;
      }
   if (support_EXT_pipeline_creation_cache_control) {
         info->pipeline_cache_control_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT;
         info->pipeline_cache_control_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->pipeline_cache_control_feats;
      }
#ifdef VK_EXTX_PORTABILITY_SUBSET_EXTENSION_NAME
   if (support_EXTX_portability_subset) {
         info->portability_subset_extx_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_EXTX;
         info->portability_subset_extx_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->portability_subset_extx_feats;
      }
#endif
   if (support_KHR_timeline_semaphore) {
         info->timeline_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR;
         info->timeline_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->timeline_feats;
      }
   if (support_EXT_4444_formats) {
         info->format_4444_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT;
         info->format_4444_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->format_4444_feats;
      }
   if (support_EXT_scalar_block_layout) {
         info->scalar_block_layout_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT;
         info->scalar_block_layout_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->scalar_block_layout_feats;
      }
   if (support_KHR_shader_float16_int8) {
         info->shader_float16_int8_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR;
         info->shader_float16_int8_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->shader_float16_int8_feats;
      }
   if (support_EXT_multi_draw) {
         info->multidraw_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT;
         info->multidraw_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->multidraw_feats;
      }
   if (support_EXT_line_rasterization) {
         info->line_rast_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT;
         info->line_rast_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->line_rast_feats;
      }
   if (support_EXT_vertex_input_dynamic_state) {
         info->vertex_input_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT;
         info->vertex_input_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->vertex_input_feats;
      }
   if (support_EXT_primitive_topology_list_restart) {
         info->list_restart_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT;
         info->list_restart_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->list_restart_feats;
      }
   if (support_EXT_descriptor_indexing) {
         info->desc_indexing_feats.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT;
         info->desc_indexing_feats.pNext = info->feats.pNext;
         info->feats.pNext = &info->desc_indexing_feats;
      }

      screen->vk.GetPhysicalDeviceFeatures2(screen->pdev, &info->feats);
   } else {
      vkGetPhysicalDeviceFeatures(screen->pdev, &info->feats.features);
   }

   // check for device properties
   if (screen->vk.GetPhysicalDeviceProperties2) {
      VkPhysicalDeviceProperties2 props = {0};
      props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2;

      if (VK_MAKE_VERSION(1,2,0) <= screen->vk_version) {
         /* VkPhysicalDeviceVulkan11Properties was added in 1.2, not 1.1 as one would think */
         info->props11.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES;
         info->props11.pNext = props.pNext;
         props.pNext = &info->props11;
      }
      if (VK_MAKE_VERSION(1,2,0) <= screen->vk_version) {
         info->props12.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES;
         info->props12.pNext = props.pNext;
         props.pNext = &info->props12;
      }

   if (support_EXT_provoking_vertex) {
         info->pv_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT;
         info->pv_props.pNext = props.pNext;
         props.pNext = &info->pv_props;
      }
   if (support_KHR_driver_properties) {
         info->driver_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR;
         info->driver_props.pNext = props.pNext;
         props.pNext = &info->driver_props;
      }
   if (support_EXT_sample_locations) {
         info->sample_locations_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT;
         info->sample_locations_props.pNext = props.pNext;
         props.pNext = &info->sample_locations_props;
      }
   if (support_EXT_conservative_rasterization) {
         info->cons_raster_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT;
         info->cons_raster_props.pNext = props.pNext;
         props.pNext = &info->cons_raster_props;
      }
   if (support_EXT_transform_feedback) {
         info->tf_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT;
         info->tf_props.pNext = props.pNext;
         props.pNext = &info->tf_props;
      }
   if (support_EXT_robustness2) {
         info->rb2_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT;
         info->rb2_props.pNext = props.pNext;
         props.pNext = &info->rb2_props;
      }
   if (support_EXT_vertex_attribute_divisor) {
         info->vdiv_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT;
         info->vdiv_props.pNext = props.pNext;
         props.pNext = &info->vdiv_props;
      }
   if (support_EXT_sampler_filter_minmax) {
         info->reduction_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT;
         info->reduction_props.pNext = props.pNext;
         props.pNext = &info->reduction_props;
      }
   if (support_EXT_custom_border_color) {
         info->border_color_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT;
         info->border_color_props.pNext = props.pNext;
         props.pNext = &info->border_color_props;
      }
   if (support_EXT_blend_operation_advanced) {
         info->blend_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT;
         info->blend_props.pNext = props.pNext;
         props.pNext = &info->blend_props;
      }
#ifdef VK_EXTX_PORTABILITY_SUBSET_EXTENSION_NAME
   if (support_EXTX_portability_subset) {
         info->portability_subset_extx_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_EXTX;
         info->portability_subset_extx_props.pNext = props.pNext;
         props.pNext = &info->portability_subset_extx_props;
      }
#endif
   if (support_EXT_multi_draw) {
         info->multidraw_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT;
         info->multidraw_props.pNext = props.pNext;
         props.pNext = &info->multidraw_props;
      }
   if (support_KHR_push_descriptor) {
         info->push_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR;
         info->push_props.pNext = props.pNext;
         props.pNext = &info->push_props;
      }
   if (support_EXT_line_rasterization) {
         info->line_rast_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT;
         info->line_rast_props.pNext = props.pNext;
         props.pNext = &info->line_rast_props;
      }
   if (support_EXT_descriptor_indexing) {
         info->desc_indexing_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT;
         info->desc_indexing_props.pNext = props.pNext;
         props.pNext = &info->desc_indexing_props;
      }

      if (screen->vk_version < VK_MAKE_VERSION(1,2,0) && screen->instance_info.have_KHR_external_memory_capabilities) {
         info->deviceid_props.sType = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES;
         info->deviceid_props.pNext = props.pNext;
         props.pNext = &info->deviceid_props;
      }

      // note: setting up local VkPhysicalDeviceProperties2.
      screen->vk.GetPhysicalDeviceProperties2(screen->pdev, &props);
   }

   // enable the extensions if they match the conditions given by ext.enable_conds 
   if (screen->vk.GetPhysicalDeviceProperties2) {
   info->have_KHR_maintenance1 |= support_KHR_maintenance1
         ;
   info->have_KHR_maintenance2 |= support_KHR_maintenance2
         ;
   info->have_KHR_maintenance3 |= support_KHR_maintenance3
         ;
   info->have_KHR_external_memory |= support_KHR_external_memory
         ;
   info->have_KHR_external_memory_fd |= support_KHR_external_memory_fd
         ;
   info->have_KHR_external_semaphore_fd |= support_KHR_external_semaphore_fd
         ;
   info->have_EXT_external_memory_dma_buf |= support_EXT_external_memory_dma_buf
         ;
   info->have_EXT_queue_family_foreign |= support_EXT_queue_family_foreign
         ;
   info->have_EXT_provoking_vertex |= support_EXT_provoking_vertex
         && (info->pv_feats.provokingVertexLast);
   info->have_EXT_shader_viewport_index_layer |= support_EXT_shader_viewport_index_layer
         ;
   info->have_KHR_get_memory_requirements2 |= support_KHR_get_memory_requirements2
         ;
   info->have_EXT_post_depth_coverage |= support_EXT_post_depth_coverage
         ;
   info->have_EXT_shader_subgroup_ballot |= support_EXT_shader_subgroup_ballot
         ;
   info->have_EXT_shader_atomic_float |= support_EXT_shader_atomic_float
         ;
   info->have_KHR_8bit_storage |= support_KHR_8bit_storage
         && (info->storage_8bit_feats.storageBuffer8BitAccess);
   info->have_KHR_16bit_storage |= support_KHR_16bit_storage
         && (info->storage_16bit_feats.storageBuffer16BitAccess);
   info->have_KHR_driver_properties |= support_KHR_driver_properties
         ;
   info->have_EXT_memory_budget |= support_EXT_memory_budget
         ;
   info->have_KHR_draw_indirect_count |= support_KHR_draw_indirect_count
         ;
   info->have_EXT_fragment_shader_interlock |= support_EXT_fragment_shader_interlock
         && (info->interlock_feats.fragmentShaderSampleInterlock)
&& (info->interlock_feats.fragmentShaderPixelInterlock);
   info->have_EXT_sample_locations |= support_EXT_sample_locations
         ;
   info->have_EXT_conservative_rasterization |= support_EXT_conservative_rasterization
         && (info->cons_raster_props.fullyCoveredFragmentShaderInputVariable);
   info->have_KHR_shader_draw_parameters |= support_KHR_shader_draw_parameters
         ;
   info->have_KHR_sampler_mirror_clamp_to_edge |= support_KHR_sampler_mirror_clamp_to_edge
         ;
   info->have_EXT_conditional_rendering |= support_EXT_conditional_rendering
         && (info->cond_render_feats.conditionalRendering);
   info->have_EXT_transform_feedback |= support_EXT_transform_feedback
         && (info->tf_feats.transformFeedback);
   info->have_EXT_index_type_uint8 |= support_EXT_index_type_uint8
         && (info->index_uint8_feats.indexTypeUint8);
   info->have_KHR_image_format_list |= support_KHR_image_format_list
         ;
   info->have_KHR_sampler_ycbcr_conversion |= support_KHR_sampler_ycbcr_conversion
         ;
   info->have_KHR_imageless_framebuffer |= support_KHR_imageless_framebuffer
         && (info->imgless_feats.imagelessFramebuffer);
   info->have_EXT_robustness2 |= support_EXT_robustness2
         && (info->rb2_feats.nullDescriptor);
   info->have_EXT_image_drm_format_modifier |= support_EXT_image_drm_format_modifier
         ;
   info->have_EXT_vertex_attribute_divisor |= support_EXT_vertex_attribute_divisor
         && (info->vdiv_feats.vertexAttributeInstanceRateDivisor);
   info->have_EXT_calibrated_timestamps |= support_EXT_calibrated_timestamps
         ;
   info->have_KHR_shader_clock |= support_KHR_shader_clock
         && (info->shader_clock_feats.shaderSubgroupClock);
   info->have_EXT_sampler_filter_minmax |= support_EXT_sampler_filter_minmax
         ;
   info->have_EXT_custom_border_color |= support_EXT_custom_border_color
         && (info->border_color_feats.customBorderColors);
   info->have_EXT_blend_operation_advanced |= support_EXT_blend_operation_advanced
         && (info->blend_props.advancedBlendNonPremultipliedSrcColor)
&& (info->blend_props.advancedBlendNonPremultipliedDstColor);
   info->have_EXT_extended_dynamic_state |= support_EXT_extended_dynamic_state
         && (info->dynamic_state_feats.extendedDynamicState);
   info->have_EXT_extended_dynamic_state2 |= support_EXT_extended_dynamic_state2
         && (info->dynamic_state2_feats.extendedDynamicState2);
   info->have_EXT_pipeline_creation_cache_control |= support_EXT_pipeline_creation_cache_control
         && (info->pipeline_cache_control_feats.pipelineCreationCacheControl);
   info->have_EXT_shader_stencil_export |= support_EXT_shader_stencil_export
         ;
#ifdef VK_EXTX_PORTABILITY_SUBSET_EXTENSION_NAME
   info->have_EXTX_portability_subset |= support_EXTX_portability_subset
         ;
#endif
   info->have_KHR_timeline_semaphore |= support_KHR_timeline_semaphore
         ;
   info->have_EXT_4444_formats |= support_EXT_4444_formats
         ;
   info->have_EXT_scalar_block_layout |= support_EXT_scalar_block_layout
         && (info->scalar_block_layout_feats.scalarBlockLayout);
   info->have_KHR_swapchain |= support_KHR_swapchain
         ;
   info->have_KHR_shader_float16_int8 |= support_KHR_shader_float16_int8
         ;
   info->have_EXT_multi_draw |= support_EXT_multi_draw
         && (info->multidraw_feats.multiDraw);
   info->have_KHR_push_descriptor |= support_KHR_push_descriptor
         ;
   info->have_KHR_descriptor_update_template |= support_KHR_descriptor_update_template
         ;
   info->have_EXT_line_rasterization |= support_EXT_line_rasterization
         ;
   info->have_EXT_vertex_input_dynamic_state |= support_EXT_vertex_input_dynamic_state
         && (info->vertex_input_feats.vertexInputDynamicState);
   info->have_EXT_primitive_topology_list_restart |= support_EXT_primitive_topology_list_restart
         && (info->list_restart_feats.primitiveTopologyListRestart);
   info->have_KHR_dedicated_allocation |= support_KHR_dedicated_allocation
         ;
   info->have_EXT_descriptor_indexing |= support_EXT_descriptor_indexing
         && (info->desc_indexing_feats.descriptorBindingPartiallyBound);
   }

   // generate extension list
   num_extensions = 0;

   if (info->have_KHR_maintenance1) {
       info->extensions[num_extensions++] = "VK_KHR_maintenance1";
   } else {
       debug_printf("ZINK: VK_KHR_maintenance1 required!\n");
       goto fail;
   }
   if (info->have_KHR_maintenance2) {
       info->extensions[num_extensions++] = "VK_KHR_maintenance2";
   }
   if (info->have_KHR_maintenance3) {
       info->extensions[num_extensions++] = "VK_KHR_maintenance3";
   }
   if (info->have_KHR_external_memory) {
       info->extensions[num_extensions++] = "VK_KHR_external_memory";
   }
   if (info->have_KHR_external_memory_fd) {
       info->extensions[num_extensions++] = "VK_KHR_external_memory_fd";
   }
   if (info->have_KHR_external_semaphore_fd) {
       info->extensions[num_extensions++] = "VK_KHR_external_semaphore_fd";
   }
   if (info->have_EXT_external_memory_dma_buf) {
       info->extensions[num_extensions++] = "VK_EXT_external_memory_dma_buf";
   }
   if (info->have_EXT_queue_family_foreign) {
       info->extensions[num_extensions++] = "VK_EXT_queue_family_foreign";
   }
   if (info->have_EXT_provoking_vertex) {
       info->extensions[num_extensions++] = "VK_EXT_provoking_vertex";
   }
   if (info->have_EXT_shader_viewport_index_layer) {
       info->extensions[num_extensions++] = "VK_EXT_shader_viewport_index_layer";
   }
   if (info->have_KHR_get_memory_requirements2) {
       info->extensions[num_extensions++] = "VK_KHR_get_memory_requirements2";
   }
   if (info->have_EXT_post_depth_coverage) {
       info->extensions[num_extensions++] = "VK_EXT_post_depth_coverage";
   }
   if (info->have_EXT_shader_subgroup_ballot) {
       info->extensions[num_extensions++] = "VK_EXT_shader_subgroup_ballot";
   }
   if (info->have_EXT_shader_atomic_float) {
       info->extensions[num_extensions++] = "VK_EXT_shader_atomic_float";
   }
   if (info->have_KHR_8bit_storage) {
       info->extensions[num_extensions++] = "VK_KHR_8bit_storage";
   }
   if (info->have_KHR_16bit_storage) {
       info->extensions[num_extensions++] = "VK_KHR_16bit_storage";
   }
   if (info->have_KHR_driver_properties) {
       info->extensions[num_extensions++] = "VK_KHR_driver_properties";
   }
   if (info->have_EXT_memory_budget) {
       info->extensions[num_extensions++] = "VK_EXT_memory_budget";
   }
   if (info->have_KHR_draw_indirect_count) {
       info->extensions[num_extensions++] = "VK_KHR_draw_indirect_count";
   }
   if (info->have_EXT_fragment_shader_interlock) {
       info->extensions[num_extensions++] = "VK_EXT_fragment_shader_interlock";
   }
   if (info->have_EXT_sample_locations) {
       info->extensions[num_extensions++] = "VK_EXT_sample_locations";
   }
   if (info->have_EXT_conservative_rasterization) {
       info->extensions[num_extensions++] = "VK_EXT_conservative_rasterization";
   }
   if (info->have_KHR_shader_draw_parameters) {
       info->extensions[num_extensions++] = "VK_KHR_shader_draw_parameters";
   }
   if (info->have_KHR_sampler_mirror_clamp_to_edge) {
       info->extensions[num_extensions++] = "VK_KHR_sampler_mirror_clamp_to_edge";
   }
   if (info->have_EXT_conditional_rendering) {
       info->extensions[num_extensions++] = "VK_EXT_conditional_rendering";
   }
   if (info->have_EXT_transform_feedback) {
       info->extensions[num_extensions++] = "VK_EXT_transform_feedback";
   }
   if (info->have_EXT_index_type_uint8) {
       info->extensions[num_extensions++] = "VK_EXT_index_type_uint8";
   }
   if (info->have_KHR_image_format_list) {
       info->extensions[num_extensions++] = "VK_KHR_image_format_list";
   }
   if (info->have_KHR_sampler_ycbcr_conversion) {
       info->extensions[num_extensions++] = "VK_KHR_sampler_ycbcr_conversion";
   }
   if (info->have_KHR_imageless_framebuffer) {
       info->extensions[num_extensions++] = "VK_KHR_imageless_framebuffer";
   }
   if (info->have_EXT_robustness2) {
       info->extensions[num_extensions++] = "VK_EXT_robustness2";
   }
   if (info->have_EXT_image_drm_format_modifier) {
       info->extensions[num_extensions++] = "VK_EXT_image_drm_format_modifier";
   }
   if (info->have_EXT_vertex_attribute_divisor) {
       info->extensions[num_extensions++] = "VK_EXT_vertex_attribute_divisor";
   }
   if (info->have_EXT_calibrated_timestamps) {
       info->extensions[num_extensions++] = "VK_EXT_calibrated_timestamps";
   }
   if (info->have_KHR_shader_clock) {
       info->extensions[num_extensions++] = "VK_KHR_shader_clock";
   }
   if (info->have_EXT_sampler_filter_minmax) {
       info->extensions[num_extensions++] = "VK_EXT_sampler_filter_minmax";
   }
   if (info->have_EXT_custom_border_color) {
       info->extensions[num_extensions++] = "VK_EXT_custom_border_color";
   }
   if (info->have_EXT_blend_operation_advanced) {
       info->extensions[num_extensions++] = "VK_EXT_blend_operation_advanced";
   }
   if (info->have_EXT_extended_dynamic_state) {
       info->extensions[num_extensions++] = "VK_EXT_extended_dynamic_state";
   }
   if (info->have_EXT_extended_dynamic_state2) {
       info->extensions[num_extensions++] = "VK_EXT_extended_dynamic_state2";
   }
   if (info->have_EXT_pipeline_creation_cache_control) {
       info->extensions[num_extensions++] = "VK_EXT_pipeline_creation_cache_control";
   }
   if (info->have_EXT_shader_stencil_export) {
       info->extensions[num_extensions++] = "VK_EXT_shader_stencil_export";
   }
#ifdef VK_EXTX_PORTABILITY_SUBSET_EXTENSION_NAME
   if (info->have_EXTX_portability_subset) {
       info->extensions[num_extensions++] = "VK_EXTX_portability_subset";
   }
#endif
   if (info->have_KHR_timeline_semaphore) {
       info->extensions[num_extensions++] = "VK_KHR_timeline_semaphore";
   }
   if (info->have_EXT_4444_formats) {
       info->extensions[num_extensions++] = "VK_EXT_4444_formats";
   }
   if (info->have_EXT_scalar_block_layout) {
       info->extensions[num_extensions++] = "VK_EXT_scalar_block_layout";
   }
   if (info->have_KHR_swapchain) {
       info->extensions[num_extensions++] = "VK_KHR_swapchain";
   }
   if (info->have_KHR_shader_float16_int8) {
       info->extensions[num_extensions++] = "VK_KHR_shader_float16_int8";
   }
   if (info->have_EXT_multi_draw) {
       info->extensions[num_extensions++] = "VK_EXT_multi_draw";
   }
   if (info->have_KHR_push_descriptor) {
       info->extensions[num_extensions++] = "VK_KHR_push_descriptor";
   }
   if (info->have_KHR_descriptor_update_template) {
       info->extensions[num_extensions++] = "VK_KHR_descriptor_update_template";
   }
   if (info->have_EXT_line_rasterization) {
       info->extensions[num_extensions++] = "VK_EXT_line_rasterization";
   }
   if (info->have_EXT_vertex_input_dynamic_state) {
       info->extensions[num_extensions++] = "VK_EXT_vertex_input_dynamic_state";
   }
   if (info->have_EXT_primitive_topology_list_restart) {
       info->extensions[num_extensions++] = "VK_EXT_primitive_topology_list_restart";
   }
   if (info->have_KHR_dedicated_allocation) {
       info->extensions[num_extensions++] = "VK_KHR_dedicated_allocation";
   }
   if (info->have_EXT_descriptor_indexing) {
       info->extensions[num_extensions++] = "VK_EXT_descriptor_indexing";
   }

   info->num_extensions = num_extensions;

   return true;

fail:
   return false;
}

void
zink_verify_device_extensions(struct zink_screen *screen)
{
   if (screen->info.have_KHR_maintenance1) {
      if (!screen->vk.TrimCommandPoolKHR) {
#ifndef NDEBUG
         screen->vk.TrimCommandPoolKHR = (PFN_vkTrimCommandPoolKHR)zink_stub_TrimCommandPoolKHR;
#else
         screen->vk.TrimCommandPoolKHR = (PFN_vkTrimCommandPoolKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_maintenance2) {
   }
   if (screen->info.have_KHR_maintenance3) {
      if (!screen->vk.GetDescriptorSetLayoutSupportKHR) {
#ifndef NDEBUG
         screen->vk.GetDescriptorSetLayoutSupportKHR = (PFN_vkGetDescriptorSetLayoutSupportKHR)zink_stub_GetDescriptorSetLayoutSupportKHR;
#else
         screen->vk.GetDescriptorSetLayoutSupportKHR = (PFN_vkGetDescriptorSetLayoutSupportKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_external_memory) {
   }
   if (screen->info.have_KHR_external_memory_fd) {
      if (!screen->vk.GetMemoryFdKHR) {
#ifndef NDEBUG
         screen->vk.GetMemoryFdKHR = (PFN_vkGetMemoryFdKHR)zink_stub_GetMemoryFdKHR;
#else
         screen->vk.GetMemoryFdKHR = (PFN_vkGetMemoryFdKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetMemoryFdPropertiesKHR) {
#ifndef NDEBUG
         screen->vk.GetMemoryFdPropertiesKHR = (PFN_vkGetMemoryFdPropertiesKHR)zink_stub_GetMemoryFdPropertiesKHR;
#else
         screen->vk.GetMemoryFdPropertiesKHR = (PFN_vkGetMemoryFdPropertiesKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_external_semaphore_fd) {
      if (!screen->vk.ImportSemaphoreFdKHR) {
#ifndef NDEBUG
         screen->vk.ImportSemaphoreFdKHR = (PFN_vkImportSemaphoreFdKHR)zink_stub_ImportSemaphoreFdKHR;
#else
         screen->vk.ImportSemaphoreFdKHR = (PFN_vkImportSemaphoreFdKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetSemaphoreFdKHR) {
#ifndef NDEBUG
         screen->vk.GetSemaphoreFdKHR = (PFN_vkGetSemaphoreFdKHR)zink_stub_GetSemaphoreFdKHR;
#else
         screen->vk.GetSemaphoreFdKHR = (PFN_vkGetSemaphoreFdKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_external_memory_dma_buf) {
   }
   if (screen->info.have_EXT_queue_family_foreign) {
   }
   if (screen->info.have_EXT_provoking_vertex) {
   }
   if (screen->info.have_EXT_shader_viewport_index_layer) {
   }
   if (screen->info.have_KHR_get_memory_requirements2) {
      if (!screen->vk.GetImageMemoryRequirements2KHR) {
#ifndef NDEBUG
         screen->vk.GetImageMemoryRequirements2KHR = (PFN_vkGetImageMemoryRequirements2KHR)zink_stub_GetImageMemoryRequirements2KHR;
#else
         screen->vk.GetImageMemoryRequirements2KHR = (PFN_vkGetImageMemoryRequirements2KHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetBufferMemoryRequirements2KHR) {
#ifndef NDEBUG
         screen->vk.GetBufferMemoryRequirements2KHR = (PFN_vkGetBufferMemoryRequirements2KHR)zink_stub_GetBufferMemoryRequirements2KHR;
#else
         screen->vk.GetBufferMemoryRequirements2KHR = (PFN_vkGetBufferMemoryRequirements2KHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetImageSparseMemoryRequirements2KHR) {
#ifndef NDEBUG
         screen->vk.GetImageSparseMemoryRequirements2KHR = (PFN_vkGetImageSparseMemoryRequirements2KHR)zink_stub_GetImageSparseMemoryRequirements2KHR;
#else
         screen->vk.GetImageSparseMemoryRequirements2KHR = (PFN_vkGetImageSparseMemoryRequirements2KHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_post_depth_coverage) {
   }
   if (screen->info.have_EXT_shader_subgroup_ballot) {
   }
   if (screen->info.have_EXT_shader_atomic_float) {
   }
   if (screen->info.have_KHR_8bit_storage) {
   }
   if (screen->info.have_KHR_16bit_storage) {
   }
   if (screen->info.have_KHR_driver_properties) {
   }
   if (screen->info.have_EXT_memory_budget) {
   }
   if (screen->info.have_KHR_draw_indirect_count) {
      if (!screen->vk.CmdDrawIndirectCountKHR) {
#ifndef NDEBUG
         screen->vk.CmdDrawIndirectCountKHR = (PFN_vkCmdDrawIndirectCountKHR)zink_stub_CmdDrawIndirectCountKHR;
#else
         screen->vk.CmdDrawIndirectCountKHR = (PFN_vkCmdDrawIndirectCountKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdDrawIndexedIndirectCountKHR) {
#ifndef NDEBUG
         screen->vk.CmdDrawIndexedIndirectCountKHR = (PFN_vkCmdDrawIndexedIndirectCountKHR)zink_stub_CmdDrawIndexedIndirectCountKHR;
#else
         screen->vk.CmdDrawIndexedIndirectCountKHR = (PFN_vkCmdDrawIndexedIndirectCountKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_fragment_shader_interlock) {
   }
   if (screen->info.have_EXT_sample_locations) {
      if (!screen->vk.CmdSetSampleLocationsEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetSampleLocationsEXT = (PFN_vkCmdSetSampleLocationsEXT)zink_stub_CmdSetSampleLocationsEXT;
#else
         screen->vk.CmdSetSampleLocationsEXT = (PFN_vkCmdSetSampleLocationsEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_conservative_rasterization) {
   }
   if (screen->info.have_KHR_shader_draw_parameters) {
   }
   if (screen->info.have_KHR_sampler_mirror_clamp_to_edge) {
   }
   if (screen->info.have_EXT_conditional_rendering) {
      if (!screen->vk.CmdBeginConditionalRenderingEXT) {
#ifndef NDEBUG
         screen->vk.CmdBeginConditionalRenderingEXT = (PFN_vkCmdBeginConditionalRenderingEXT)zink_stub_CmdBeginConditionalRenderingEXT;
#else
         screen->vk.CmdBeginConditionalRenderingEXT = (PFN_vkCmdBeginConditionalRenderingEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdEndConditionalRenderingEXT) {
#ifndef NDEBUG
         screen->vk.CmdEndConditionalRenderingEXT = (PFN_vkCmdEndConditionalRenderingEXT)zink_stub_CmdEndConditionalRenderingEXT;
#else
         screen->vk.CmdEndConditionalRenderingEXT = (PFN_vkCmdEndConditionalRenderingEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_transform_feedback) {
      if (!screen->vk.CmdBindTransformFeedbackBuffersEXT) {
#ifndef NDEBUG
         screen->vk.CmdBindTransformFeedbackBuffersEXT = (PFN_vkCmdBindTransformFeedbackBuffersEXT)zink_stub_CmdBindTransformFeedbackBuffersEXT;
#else
         screen->vk.CmdBindTransformFeedbackBuffersEXT = (PFN_vkCmdBindTransformFeedbackBuffersEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdBeginTransformFeedbackEXT) {
#ifndef NDEBUG
         screen->vk.CmdBeginTransformFeedbackEXT = (PFN_vkCmdBeginTransformFeedbackEXT)zink_stub_CmdBeginTransformFeedbackEXT;
#else
         screen->vk.CmdBeginTransformFeedbackEXT = (PFN_vkCmdBeginTransformFeedbackEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdEndTransformFeedbackEXT) {
#ifndef NDEBUG
         screen->vk.CmdEndTransformFeedbackEXT = (PFN_vkCmdEndTransformFeedbackEXT)zink_stub_CmdEndTransformFeedbackEXT;
#else
         screen->vk.CmdEndTransformFeedbackEXT = (PFN_vkCmdEndTransformFeedbackEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdBeginQueryIndexedEXT) {
#ifndef NDEBUG
         screen->vk.CmdBeginQueryIndexedEXT = (PFN_vkCmdBeginQueryIndexedEXT)zink_stub_CmdBeginQueryIndexedEXT;
#else
         screen->vk.CmdBeginQueryIndexedEXT = (PFN_vkCmdBeginQueryIndexedEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdEndQueryIndexedEXT) {
#ifndef NDEBUG
         screen->vk.CmdEndQueryIndexedEXT = (PFN_vkCmdEndQueryIndexedEXT)zink_stub_CmdEndQueryIndexedEXT;
#else
         screen->vk.CmdEndQueryIndexedEXT = (PFN_vkCmdEndQueryIndexedEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdDrawIndirectByteCountEXT) {
#ifndef NDEBUG
         screen->vk.CmdDrawIndirectByteCountEXT = (PFN_vkCmdDrawIndirectByteCountEXT)zink_stub_CmdDrawIndirectByteCountEXT;
#else
         screen->vk.CmdDrawIndirectByteCountEXT = (PFN_vkCmdDrawIndirectByteCountEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_index_type_uint8) {
   }
   if (screen->info.have_KHR_image_format_list) {
   }
   if (screen->info.have_KHR_sampler_ycbcr_conversion) {
      if (!screen->vk.CreateSamplerYcbcrConversionKHR) {
#ifndef NDEBUG
         screen->vk.CreateSamplerYcbcrConversionKHR = (PFN_vkCreateSamplerYcbcrConversionKHR)zink_stub_CreateSamplerYcbcrConversionKHR;
#else
         screen->vk.CreateSamplerYcbcrConversionKHR = (PFN_vkCreateSamplerYcbcrConversionKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.DestroySamplerYcbcrConversionKHR) {
#ifndef NDEBUG
         screen->vk.DestroySamplerYcbcrConversionKHR = (PFN_vkDestroySamplerYcbcrConversionKHR)zink_stub_DestroySamplerYcbcrConversionKHR;
#else
         screen->vk.DestroySamplerYcbcrConversionKHR = (PFN_vkDestroySamplerYcbcrConversionKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_imageless_framebuffer) {
   }
   if (screen->info.have_EXT_robustness2) {
   }
   if (screen->info.have_EXT_image_drm_format_modifier) {
      if (!screen->vk.GetImageDrmFormatModifierPropertiesEXT) {
#ifndef NDEBUG
         screen->vk.GetImageDrmFormatModifierPropertiesEXT = (PFN_vkGetImageDrmFormatModifierPropertiesEXT)zink_stub_GetImageDrmFormatModifierPropertiesEXT;
#else
         screen->vk.GetImageDrmFormatModifierPropertiesEXT = (PFN_vkGetImageDrmFormatModifierPropertiesEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_vertex_attribute_divisor) {
   }
   if (screen->info.have_EXT_calibrated_timestamps) {
      if (!screen->vk.GetCalibratedTimestampsEXT) {
#ifndef NDEBUG
         screen->vk.GetCalibratedTimestampsEXT = (PFN_vkGetCalibratedTimestampsEXT)zink_stub_GetCalibratedTimestampsEXT;
#else
         screen->vk.GetCalibratedTimestampsEXT = (PFN_vkGetCalibratedTimestampsEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_shader_clock) {
   }
   if (screen->info.have_EXT_sampler_filter_minmax) {
   }
   if (screen->info.have_EXT_custom_border_color) {
   }
   if (screen->info.have_EXT_blend_operation_advanced) {
   }
   if (screen->info.have_EXT_extended_dynamic_state) {
      if (!screen->vk.CmdSetCullModeEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetCullModeEXT = (PFN_vkCmdSetCullModeEXT)zink_stub_CmdSetCullModeEXT;
#else
         screen->vk.CmdSetCullModeEXT = (PFN_vkCmdSetCullModeEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetFrontFaceEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetFrontFaceEXT = (PFN_vkCmdSetFrontFaceEXT)zink_stub_CmdSetFrontFaceEXT;
#else
         screen->vk.CmdSetFrontFaceEXT = (PFN_vkCmdSetFrontFaceEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetPrimitiveTopologyEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetPrimitiveTopologyEXT = (PFN_vkCmdSetPrimitiveTopologyEXT)zink_stub_CmdSetPrimitiveTopologyEXT;
#else
         screen->vk.CmdSetPrimitiveTopologyEXT = (PFN_vkCmdSetPrimitiveTopologyEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetViewportWithCountEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetViewportWithCountEXT = (PFN_vkCmdSetViewportWithCountEXT)zink_stub_CmdSetViewportWithCountEXT;
#else
         screen->vk.CmdSetViewportWithCountEXT = (PFN_vkCmdSetViewportWithCountEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetScissorWithCountEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetScissorWithCountEXT = (PFN_vkCmdSetScissorWithCountEXT)zink_stub_CmdSetScissorWithCountEXT;
#else
         screen->vk.CmdSetScissorWithCountEXT = (PFN_vkCmdSetScissorWithCountEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdBindVertexBuffers2EXT) {
#ifndef NDEBUG
         screen->vk.CmdBindVertexBuffers2EXT = (PFN_vkCmdBindVertexBuffers2EXT)zink_stub_CmdBindVertexBuffers2EXT;
#else
         screen->vk.CmdBindVertexBuffers2EXT = (PFN_vkCmdBindVertexBuffers2EXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetDepthTestEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetDepthTestEnableEXT = (PFN_vkCmdSetDepthTestEnableEXT)zink_stub_CmdSetDepthTestEnableEXT;
#else
         screen->vk.CmdSetDepthTestEnableEXT = (PFN_vkCmdSetDepthTestEnableEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetDepthWriteEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetDepthWriteEnableEXT = (PFN_vkCmdSetDepthWriteEnableEXT)zink_stub_CmdSetDepthWriteEnableEXT;
#else
         screen->vk.CmdSetDepthWriteEnableEXT = (PFN_vkCmdSetDepthWriteEnableEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetDepthCompareOpEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetDepthCompareOpEXT = (PFN_vkCmdSetDepthCompareOpEXT)zink_stub_CmdSetDepthCompareOpEXT;
#else
         screen->vk.CmdSetDepthCompareOpEXT = (PFN_vkCmdSetDepthCompareOpEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetDepthBoundsTestEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetDepthBoundsTestEnableEXT = (PFN_vkCmdSetDepthBoundsTestEnableEXT)zink_stub_CmdSetDepthBoundsTestEnableEXT;
#else
         screen->vk.CmdSetDepthBoundsTestEnableEXT = (PFN_vkCmdSetDepthBoundsTestEnableEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetStencilTestEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetStencilTestEnableEXT = (PFN_vkCmdSetStencilTestEnableEXT)zink_stub_CmdSetStencilTestEnableEXT;
#else
         screen->vk.CmdSetStencilTestEnableEXT = (PFN_vkCmdSetStencilTestEnableEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetStencilOpEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetStencilOpEXT = (PFN_vkCmdSetStencilOpEXT)zink_stub_CmdSetStencilOpEXT;
#else
         screen->vk.CmdSetStencilOpEXT = (PFN_vkCmdSetStencilOpEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_extended_dynamic_state2) {
      if (!screen->vk.CmdSetPatchControlPointsEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetPatchControlPointsEXT = (PFN_vkCmdSetPatchControlPointsEXT)zink_stub_CmdSetPatchControlPointsEXT;
#else
         screen->vk.CmdSetPatchControlPointsEXT = (PFN_vkCmdSetPatchControlPointsEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetRasterizerDiscardEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetRasterizerDiscardEnableEXT = (PFN_vkCmdSetRasterizerDiscardEnableEXT)zink_stub_CmdSetRasterizerDiscardEnableEXT;
#else
         screen->vk.CmdSetRasterizerDiscardEnableEXT = (PFN_vkCmdSetRasterizerDiscardEnableEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetDepthBiasEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetDepthBiasEnableEXT = (PFN_vkCmdSetDepthBiasEnableEXT)zink_stub_CmdSetDepthBiasEnableEXT;
#else
         screen->vk.CmdSetDepthBiasEnableEXT = (PFN_vkCmdSetDepthBiasEnableEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetLogicOpEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetLogicOpEXT = (PFN_vkCmdSetLogicOpEXT)zink_stub_CmdSetLogicOpEXT;
#else
         screen->vk.CmdSetLogicOpEXT = (PFN_vkCmdSetLogicOpEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdSetPrimitiveRestartEnableEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetPrimitiveRestartEnableEXT = (PFN_vkCmdSetPrimitiveRestartEnableEXT)zink_stub_CmdSetPrimitiveRestartEnableEXT;
#else
         screen->vk.CmdSetPrimitiveRestartEnableEXT = (PFN_vkCmdSetPrimitiveRestartEnableEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_pipeline_creation_cache_control) {
   }
   if (screen->info.have_EXT_shader_stencil_export) {
   }
   if (screen->info.have_KHR_timeline_semaphore) {
      if (!screen->vk.GetSemaphoreCounterValueKHR) {
#ifndef NDEBUG
         screen->vk.GetSemaphoreCounterValueKHR = (PFN_vkGetSemaphoreCounterValueKHR)zink_stub_GetSemaphoreCounterValueKHR;
#else
         screen->vk.GetSemaphoreCounterValueKHR = (PFN_vkGetSemaphoreCounterValueKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.WaitSemaphoresKHR) {
#ifndef NDEBUG
         screen->vk.WaitSemaphoresKHR = (PFN_vkWaitSemaphoresKHR)zink_stub_WaitSemaphoresKHR;
#else
         screen->vk.WaitSemaphoresKHR = (PFN_vkWaitSemaphoresKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.SignalSemaphoreKHR) {
#ifndef NDEBUG
         screen->vk.SignalSemaphoreKHR = (PFN_vkSignalSemaphoreKHR)zink_stub_SignalSemaphoreKHR;
#else
         screen->vk.SignalSemaphoreKHR = (PFN_vkSignalSemaphoreKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_4444_formats) {
   }
   if (screen->info.have_EXT_scalar_block_layout) {
   }
   if (screen->info.have_KHR_swapchain) {
      if (!screen->vk.CreateSwapchainKHR) {
#ifndef NDEBUG
         screen->vk.CreateSwapchainKHR = (PFN_vkCreateSwapchainKHR)zink_stub_CreateSwapchainKHR;
#else
         screen->vk.CreateSwapchainKHR = (PFN_vkCreateSwapchainKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.DestroySwapchainKHR) {
#ifndef NDEBUG
         screen->vk.DestroySwapchainKHR = (PFN_vkDestroySwapchainKHR)zink_stub_DestroySwapchainKHR;
#else
         screen->vk.DestroySwapchainKHR = (PFN_vkDestroySwapchainKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetSwapchainImagesKHR) {
#ifndef NDEBUG
         screen->vk.GetSwapchainImagesKHR = (PFN_vkGetSwapchainImagesKHR)zink_stub_GetSwapchainImagesKHR;
#else
         screen->vk.GetSwapchainImagesKHR = (PFN_vkGetSwapchainImagesKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.AcquireNextImageKHR) {
#ifndef NDEBUG
         screen->vk.AcquireNextImageKHR = (PFN_vkAcquireNextImageKHR)zink_stub_AcquireNextImageKHR;
#else
         screen->vk.AcquireNextImageKHR = (PFN_vkAcquireNextImageKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.QueuePresentKHR) {
#ifndef NDEBUG
         screen->vk.QueuePresentKHR = (PFN_vkQueuePresentKHR)zink_stub_QueuePresentKHR;
#else
         screen->vk.QueuePresentKHR = (PFN_vkQueuePresentKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetDeviceGroupPresentCapabilitiesKHR) {
#ifndef NDEBUG
         screen->vk.GetDeviceGroupPresentCapabilitiesKHR = (PFN_vkGetDeviceGroupPresentCapabilitiesKHR)zink_stub_GetDeviceGroupPresentCapabilitiesKHR;
#else
         screen->vk.GetDeviceGroupPresentCapabilitiesKHR = (PFN_vkGetDeviceGroupPresentCapabilitiesKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.GetDeviceGroupSurfacePresentModesKHR) {
#ifndef NDEBUG
         screen->vk.GetDeviceGroupSurfacePresentModesKHR = (PFN_vkGetDeviceGroupSurfacePresentModesKHR)zink_stub_GetDeviceGroupSurfacePresentModesKHR;
#else
         screen->vk.GetDeviceGroupSurfacePresentModesKHR = (PFN_vkGetDeviceGroupSurfacePresentModesKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.AcquireNextImage2KHR) {
#ifndef NDEBUG
         screen->vk.AcquireNextImage2KHR = (PFN_vkAcquireNextImage2KHR)zink_stub_AcquireNextImage2KHR;
#else
         screen->vk.AcquireNextImage2KHR = (PFN_vkAcquireNextImage2KHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_shader_float16_int8) {
   }
   if (screen->info.have_EXT_multi_draw) {
      if (!screen->vk.CmdDrawMultiEXT) {
#ifndef NDEBUG
         screen->vk.CmdDrawMultiEXT = (PFN_vkCmdDrawMultiEXT)zink_stub_CmdDrawMultiEXT;
#else
         screen->vk.CmdDrawMultiEXT = (PFN_vkCmdDrawMultiEXT)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdDrawMultiIndexedEXT) {
#ifndef NDEBUG
         screen->vk.CmdDrawMultiIndexedEXT = (PFN_vkCmdDrawMultiIndexedEXT)zink_stub_CmdDrawMultiIndexedEXT;
#else
         screen->vk.CmdDrawMultiIndexedEXT = (PFN_vkCmdDrawMultiIndexedEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_push_descriptor) {
      if (!screen->vk.CmdPushDescriptorSetKHR) {
#ifndef NDEBUG
         screen->vk.CmdPushDescriptorSetKHR = (PFN_vkCmdPushDescriptorSetKHR)zink_stub_CmdPushDescriptorSetKHR;
#else
         screen->vk.CmdPushDescriptorSetKHR = (PFN_vkCmdPushDescriptorSetKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdPushDescriptorSetWithTemplateKHR) {
#ifndef NDEBUG
         screen->vk.CmdPushDescriptorSetWithTemplateKHR = (PFN_vkCmdPushDescriptorSetWithTemplateKHR)zink_stub_CmdPushDescriptorSetWithTemplateKHR;
#else
         screen->vk.CmdPushDescriptorSetWithTemplateKHR = (PFN_vkCmdPushDescriptorSetWithTemplateKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdPushDescriptorSetWithTemplateKHR) {
#ifndef NDEBUG
         screen->vk.CmdPushDescriptorSetWithTemplateKHR = (PFN_vkCmdPushDescriptorSetWithTemplateKHR)zink_stub_CmdPushDescriptorSetWithTemplateKHR;
#else
         screen->vk.CmdPushDescriptorSetWithTemplateKHR = (PFN_vkCmdPushDescriptorSetWithTemplateKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_KHR_descriptor_update_template) {
      if (!screen->vk.CreateDescriptorUpdateTemplateKHR) {
#ifndef NDEBUG
         screen->vk.CreateDescriptorUpdateTemplateKHR = (PFN_vkCreateDescriptorUpdateTemplateKHR)zink_stub_CreateDescriptorUpdateTemplateKHR;
#else
         screen->vk.CreateDescriptorUpdateTemplateKHR = (PFN_vkCreateDescriptorUpdateTemplateKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.DestroyDescriptorUpdateTemplateKHR) {
#ifndef NDEBUG
         screen->vk.DestroyDescriptorUpdateTemplateKHR = (PFN_vkDestroyDescriptorUpdateTemplateKHR)zink_stub_DestroyDescriptorUpdateTemplateKHR;
#else
         screen->vk.DestroyDescriptorUpdateTemplateKHR = (PFN_vkDestroyDescriptorUpdateTemplateKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.UpdateDescriptorSetWithTemplateKHR) {
#ifndef NDEBUG
         screen->vk.UpdateDescriptorSetWithTemplateKHR = (PFN_vkUpdateDescriptorSetWithTemplateKHR)zink_stub_UpdateDescriptorSetWithTemplateKHR;
#else
         screen->vk.UpdateDescriptorSetWithTemplateKHR = (PFN_vkUpdateDescriptorSetWithTemplateKHR)zink_stub_function_not_loaded;
#endif
      }
      if (!screen->vk.CmdPushDescriptorSetWithTemplateKHR) {
#ifndef NDEBUG
         screen->vk.CmdPushDescriptorSetWithTemplateKHR = (PFN_vkCmdPushDescriptorSetWithTemplateKHR)zink_stub_CmdPushDescriptorSetWithTemplateKHR;
#else
         screen->vk.CmdPushDescriptorSetWithTemplateKHR = (PFN_vkCmdPushDescriptorSetWithTemplateKHR)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_line_rasterization) {
      if (!screen->vk.CmdSetLineStippleEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetLineStippleEXT = (PFN_vkCmdSetLineStippleEXT)zink_stub_CmdSetLineStippleEXT;
#else
         screen->vk.CmdSetLineStippleEXT = (PFN_vkCmdSetLineStippleEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_vertex_input_dynamic_state) {
      if (!screen->vk.CmdSetVertexInputEXT) {
#ifndef NDEBUG
         screen->vk.CmdSetVertexInputEXT = (PFN_vkCmdSetVertexInputEXT)zink_stub_CmdSetVertexInputEXT;
#else
         screen->vk.CmdSetVertexInputEXT = (PFN_vkCmdSetVertexInputEXT)zink_stub_function_not_loaded;
#endif
      }
   }
   if (screen->info.have_EXT_primitive_topology_list_restart) {
   }
   if (screen->info.have_KHR_dedicated_allocation) {
   }
   if (screen->info.have_EXT_descriptor_indexing) {
   }
}

#ifndef NDEBUG
/* generated stub functions */


   
void
zink_stub_TrimCommandPoolKHR()
{
   mesa_loge("ZINK: vkTrimCommandPoolKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetDescriptorSetLayoutSupportKHR()
{
   mesa_loge("ZINK: vkGetDescriptorSetLayoutSupportKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetMemoryFdKHR()
{
   mesa_loge("ZINK: vkGetMemoryFdKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetMemoryFdPropertiesKHR()
{
   mesa_loge("ZINK: vkGetMemoryFdPropertiesKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_ImportSemaphoreFdKHR()
{
   mesa_loge("ZINK: vkImportSemaphoreFdKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetSemaphoreFdKHR()
{
   mesa_loge("ZINK: vkGetSemaphoreFdKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetImageMemoryRequirements2KHR()
{
   mesa_loge("ZINK: vkGetImageMemoryRequirements2KHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetBufferMemoryRequirements2KHR()
{
   mesa_loge("ZINK: vkGetBufferMemoryRequirements2KHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetImageSparseMemoryRequirements2KHR()
{
   mesa_loge("ZINK: vkGetImageSparseMemoryRequirements2KHR is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdDrawIndirectCountKHR()
{
   mesa_loge("ZINK: vkCmdDrawIndirectCountKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdDrawIndexedIndirectCountKHR()
{
   mesa_loge("ZINK: vkCmdDrawIndexedIndirectCountKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetSampleLocationsEXT()
{
   mesa_loge("ZINK: vkCmdSetSampleLocationsEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdBeginConditionalRenderingEXT()
{
   mesa_loge("ZINK: vkCmdBeginConditionalRenderingEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdEndConditionalRenderingEXT()
{
   mesa_loge("ZINK: vkCmdEndConditionalRenderingEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdBindTransformFeedbackBuffersEXT()
{
   mesa_loge("ZINK: vkCmdBindTransformFeedbackBuffersEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdBeginTransformFeedbackEXT()
{
   mesa_loge("ZINK: vkCmdBeginTransformFeedbackEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdEndTransformFeedbackEXT()
{
   mesa_loge("ZINK: vkCmdEndTransformFeedbackEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdBeginQueryIndexedEXT()
{
   mesa_loge("ZINK: vkCmdBeginQueryIndexedEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdEndQueryIndexedEXT()
{
   mesa_loge("ZINK: vkCmdEndQueryIndexedEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdDrawIndirectByteCountEXT()
{
   mesa_loge("ZINK: vkCmdDrawIndirectByteCountEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CreateSamplerYcbcrConversionKHR()
{
   mesa_loge("ZINK: vkCreateSamplerYcbcrConversionKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_DestroySamplerYcbcrConversionKHR()
{
   mesa_loge("ZINK: vkDestroySamplerYcbcrConversionKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetImageDrmFormatModifierPropertiesEXT()
{
   mesa_loge("ZINK: vkGetImageDrmFormatModifierPropertiesEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_GetCalibratedTimestampsEXT()
{
   mesa_loge("ZINK: vkGetCalibratedTimestampsEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetCullModeEXT()
{
   mesa_loge("ZINK: vkCmdSetCullModeEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetFrontFaceEXT()
{
   mesa_loge("ZINK: vkCmdSetFrontFaceEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetPrimitiveTopologyEXT()
{
   mesa_loge("ZINK: vkCmdSetPrimitiveTopologyEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetViewportWithCountEXT()
{
   mesa_loge("ZINK: vkCmdSetViewportWithCountEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetScissorWithCountEXT()
{
   mesa_loge("ZINK: vkCmdSetScissorWithCountEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdBindVertexBuffers2EXT()
{
   mesa_loge("ZINK: vkCmdBindVertexBuffers2EXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetDepthTestEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetDepthTestEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetDepthWriteEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetDepthWriteEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetDepthCompareOpEXT()
{
   mesa_loge("ZINK: vkCmdSetDepthCompareOpEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetDepthBoundsTestEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetDepthBoundsTestEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetStencilTestEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetStencilTestEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetStencilOpEXT()
{
   mesa_loge("ZINK: vkCmdSetStencilOpEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetPatchControlPointsEXT()
{
   mesa_loge("ZINK: vkCmdSetPatchControlPointsEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetRasterizerDiscardEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetRasterizerDiscardEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetDepthBiasEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetDepthBiasEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetLogicOpEXT()
{
   mesa_loge("ZINK: vkCmdSetLogicOpEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetPrimitiveRestartEnableEXT()
{
   mesa_loge("ZINK: vkCmdSetPrimitiveRestartEnableEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_GetSemaphoreCounterValueKHR()
{
   mesa_loge("ZINK: vkGetSemaphoreCounterValueKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_WaitSemaphoresKHR()
{
   mesa_loge("ZINK: vkWaitSemaphoresKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_SignalSemaphoreKHR()
{
   mesa_loge("ZINK: vkSignalSemaphoreKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_CreateSwapchainKHR()
{
   mesa_loge("ZINK: vkCreateSwapchainKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_DestroySwapchainKHR()
{
   mesa_loge("ZINK: vkDestroySwapchainKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetSwapchainImagesKHR()
{
   mesa_loge("ZINK: vkGetSwapchainImagesKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_AcquireNextImageKHR()
{
   mesa_loge("ZINK: vkAcquireNextImageKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_QueuePresentKHR()
{
   mesa_loge("ZINK: vkQueuePresentKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetDeviceGroupPresentCapabilitiesKHR()
{
   mesa_loge("ZINK: vkGetDeviceGroupPresentCapabilitiesKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_GetDeviceGroupSurfacePresentModesKHR()
{
   mesa_loge("ZINK: vkGetDeviceGroupSurfacePresentModesKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_AcquireNextImage2KHR()
{
   mesa_loge("ZINK: vkAcquireNextImage2KHR is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdDrawMultiEXT()
{
   mesa_loge("ZINK: vkCmdDrawMultiEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdDrawMultiIndexedEXT()
{
   mesa_loge("ZINK: vkCmdDrawMultiIndexedEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdPushDescriptorSetKHR()
{
   mesa_loge("ZINK: vkCmdPushDescriptorSetKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdPushDescriptorSetWithTemplateKHR()
{
   mesa_loge("ZINK: vkCmdPushDescriptorSetWithTemplateKHR is not loaded properly!");
   abort();
}
      
void
zink_stub_CreateDescriptorUpdateTemplateKHR()
{
   mesa_loge("ZINK: vkCreateDescriptorUpdateTemplateKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_DestroyDescriptorUpdateTemplateKHR()
{
   mesa_loge("ZINK: vkDestroyDescriptorUpdateTemplateKHR is not loaded properly!");
   abort();
}
   
void
zink_stub_UpdateDescriptorSetWithTemplateKHR()
{
   mesa_loge("ZINK: vkUpdateDescriptorSetWithTemplateKHR is not loaded properly!");
   abort();
}
      
void
zink_stub_CmdSetLineStippleEXT()
{
   mesa_loge("ZINK: vkCmdSetLineStippleEXT is not loaded properly!");
   abort();
}
   
void
zink_stub_CmdSetVertexInputEXT()
{
   mesa_loge("ZINK: vkCmdSetVertexInputEXT is not loaded properly!");
   abort();
}
#endif
