/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.0
 *
 * Copyright (c) 2021 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtDBus.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtDBus/qdbusargument.sip"
#include <qdbusargument.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.6/build/QtDBus/sipQtDBusQDBusArgument.cpp"

#line 30 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtDBus/qdbusargument.sip"
#include <QStringList>


static PyObject *qdbusargument_add(QDBusArgument *arg, PyObject *obj, int mtype)
{
    int iserr = 0;

    if (PyLong_CheckExact(obj)
#if PY_MAJOR_VERSION < 3
            || PyInt_CheckExact(obj)
#endif
            )
    {
        if (mtype == QMetaType::UChar || mtype == QMetaType::UShort || mtype == QMetaType::UInt || mtype == QMetaType::ULongLong)
        {
            // Handle the unsigned values.
#if defined(HAVE_LONG_LONG)
            unsigned PY_LONG_LONG v = PyLong_AsUnsignedLongLongMask(obj);
#else
            unsigned long v = PyLong_AsUnsignedLongMask(obj);
#endif

            switch (mtype)
            {
            case QMetaType::UChar:
                *arg << (uchar)v;
                break;

            case QMetaType::UShort:
                *arg << (ushort)v;
                break;

            case QMetaType::UInt:
                *arg << (uint)v;
                break;

            case QMetaType::ULongLong:
                *arg << (qulonglong)v;
                break;
            }
        }
        else if (mtype == QMetaType::Short || mtype == QMetaType::Int || mtype == QMetaType::LongLong)
        {
            // Handle the signed values.
#if defined(HAVE_LONG_LONG)
            PY_LONG_LONG v = PyLong_AsLongLong(obj);
#else
            long v = PyLong_AsLong(obj);
#endif

            switch (mtype)
            {
            case QMetaType::Short:
                *arg << (short)v;
                break;

            case QMetaType::Int:
                *arg << (int)v;
                break;

            case QMetaType::LongLong:
                *arg << (qlonglong)v;
                break;
            }
        }
        else
        {
            PyErr_Format(PyExc_ValueError,
                    "%d is an invalid QMetaType::Type for an integer object",
                    mtype);
            iserr = 1;
        }
    }
    else if (mtype == QMetaType::QStringList)
    {
        // A QStringList has to be handled explicitly to prevent it being seen
        // as a vialiant list.

        int value_state;

        QStringList *qsl = reinterpret_cast<QStringList *>(
                sipForceConvertToType(obj, sipType_QStringList, 0,
                        SIP_NOT_NONE, &value_state, &iserr));

        if (!iserr)
        {
            arg->beginArray(QMetaType::QString);

            for (int i = 0; i < qsl->count(); ++i)
                *arg << qsl->at(i);

            arg->endArray();

            sipReleaseType(qsl, sipType_QStringList, value_state);
        }
    }
    else
    {
        int value_state;

        QVariant *qv = reinterpret_cast<QVariant *>(
                sipForceConvertToType(obj, sipType_QVariant, 0, SIP_NOT_NONE,
                        &value_state, &iserr));

        if (!iserr)
        {
            // This is an internal method. If it proves to be a problem then we
            // will have to handle each type explicitly.
            arg->appendVariant(*qv);
            sipReleaseType(qv, sipType_QVariant, value_state);
        }
    }

    if (iserr)
        return 0;

    Py_INCREF(Py_None);
    return Py_None;
}
#line 151 "/build/pyqt5/src/PyQt5-5.15.6/build/QtDBus/sipQtDBusQDBusArgument.cpp"


PyDoc_STRVAR(doc_QDBusArgument_add, "add(self, object, id: int = QMetaType.Int)");

extern "C" {static PyObject *meth_QDBusArgument_add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        int a1 = QMetaType::Int;
         ::QDBusArgument *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0|i", &sipSelf, sipType_QDBusArgument, &sipCpp, &a0, &a1))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 173 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtDBus/qdbusargument.sip"
        sipRes = qdbusargument_add(sipCpp, a0, a1);
#line 178 "/build/pyqt5/src/PyQt5-5.15.6/build/QtDBus/sipQtDBusQDBusArgument.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_add, doc_QDBusArgument_add);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_beginStructure, "beginStructure(self)");

extern "C" {static PyObject *meth_QDBusArgument_beginStructure(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_beginStructure(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusArgument, &sipCpp))
        {
            sipCpp->beginStructure();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_beginStructure, doc_QDBusArgument_beginStructure);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_endStructure, "endStructure(self)");

extern "C" {static PyObject *meth_QDBusArgument_endStructure(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_endStructure(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusArgument, &sipCpp))
        {
            sipCpp->endStructure();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_endStructure, doc_QDBusArgument_endStructure);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_beginArray, "beginArray(self, int)");

extern "C" {static PyObject *meth_QDBusArgument_beginArray(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_beginArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDBusArgument, &sipCpp, &a0))
        {
            sipCpp->beginArray(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_beginArray, doc_QDBusArgument_beginArray);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_endArray, "endArray(self)");

extern "C" {static PyObject *meth_QDBusArgument_endArray(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_endArray(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusArgument, &sipCpp))
        {
            sipCpp->endArray();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_endArray, doc_QDBusArgument_endArray);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_beginMap, "beginMap(self, int, int)");

extern "C" {static PyObject *meth_QDBusArgument_beginMap(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_beginMap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QDBusArgument, &sipCpp, &a0, &a1))
        {
            sipCpp->beginMap(a0,a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_beginMap, doc_QDBusArgument_beginMap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_endMap, "endMap(self)");

extern "C" {static PyObject *meth_QDBusArgument_endMap(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_endMap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusArgument, &sipCpp))
        {
            sipCpp->endMap();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_endMap, doc_QDBusArgument_endMap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_beginMapEntry, "beginMapEntry(self)");

extern "C" {static PyObject *meth_QDBusArgument_beginMapEntry(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_beginMapEntry(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusArgument, &sipCpp))
        {
            sipCpp->beginMapEntry();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_beginMapEntry, doc_QDBusArgument_beginMapEntry);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_endMapEntry, "endMapEntry(self)");

extern "C" {static PyObject *meth_QDBusArgument_endMapEntry(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_endMapEntry(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusArgument, &sipCpp))
        {
            sipCpp->endMapEntry();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_endMapEntry, doc_QDBusArgument_endMapEntry);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusArgument_swap, "swap(self, QDBusArgument)");

extern "C" {static PyObject *meth_QDBusArgument_swap(PyObject *, PyObject *);}
static PyObject *meth_QDBusArgument_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDBusArgument* a0;
         ::QDBusArgument *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDBusArgument, &sipCpp, sipType_QDBusArgument, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusArgument, sipName_swap, doc_QDBusArgument_swap);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDBusArgument(void *, int);}
static void release_QDBusArgument(void *sipCppV, int)
{
    delete reinterpret_cast< ::QDBusArgument *>(sipCppV);
}


extern "C" {static void *array_QDBusArgument(Py_ssize_t);}
static void *array_QDBusArgument(Py_ssize_t sipNrElem)
{
    return new  ::QDBusArgument[sipNrElem];
}


extern "C" {static void assign_QDBusArgument(void *, Py_ssize_t, void *);}
static void assign_QDBusArgument(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QDBusArgument *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QDBusArgument *>(sipSrc);
}


extern "C" {static void *copy_QDBusArgument(const void *, Py_ssize_t);}
static void *copy_QDBusArgument(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QDBusArgument(reinterpret_cast<const  ::QDBusArgument *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDBusArgument(sipSimpleWrapper *);}
static void dealloc_QDBusArgument(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QDBusArgument(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QDBusArgument(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QDBusArgument(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QDBusArgument *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QDBusArgument();

            return sipCpp;
        }
    }

    {
        const  ::QDBusArgument* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QDBusArgument, &a0))
        {
            sipCpp = new  ::QDBusArgument(*a0);

            return sipCpp;
        }
    }

    {
        PyObject * a0;
        int a1 = QMetaType::Int;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_id,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0|i", &a0, &a1))
        {
#line 156 "/build/pyqt5/src/PyQt5-5.15.6/sip/QtDBus/qdbusargument.sip"
        sipCpp = new QDBusArgument();
        PyObject *res = qdbusargument_add(sipCpp, a0, a1);
        
        if (res)
        {
            Py_DECREF(res);
        }
        else
        {
            delete sipCpp;
            sipCpp = 0;
        }
#line 516 "/build/pyqt5/src/PyQt5-5.15.6/build/QtDBus/sipQtDBusQDBusArgument.cpp"

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QDBusArgument[] = {
    {sipName_add, SIP_MLMETH_CAST(meth_QDBusArgument_add), METH_VARARGS|METH_KEYWORDS, doc_QDBusArgument_add},
    {sipName_beginArray, meth_QDBusArgument_beginArray, METH_VARARGS, doc_QDBusArgument_beginArray},
    {sipName_beginMap, meth_QDBusArgument_beginMap, METH_VARARGS, doc_QDBusArgument_beginMap},
    {sipName_beginMapEntry, meth_QDBusArgument_beginMapEntry, METH_VARARGS, doc_QDBusArgument_beginMapEntry},
    {sipName_beginStructure, meth_QDBusArgument_beginStructure, METH_VARARGS, doc_QDBusArgument_beginStructure},
    {sipName_endArray, meth_QDBusArgument_endArray, METH_VARARGS, doc_QDBusArgument_endArray},
    {sipName_endMap, meth_QDBusArgument_endMap, METH_VARARGS, doc_QDBusArgument_endMap},
    {sipName_endMapEntry, meth_QDBusArgument_endMapEntry, METH_VARARGS, doc_QDBusArgument_endMapEntry},
    {sipName_endStructure, meth_QDBusArgument_endStructure, METH_VARARGS, doc_QDBusArgument_endStructure},
    {sipName_swap, meth_QDBusArgument_swap, METH_VARARGS, doc_QDBusArgument_swap}
};

PyDoc_STRVAR(doc_QDBusArgument, "\1QDBusArgument()\n"
"QDBusArgument(QDBusArgument)\n"
"QDBusArgument(object, id: int = QMetaType.Int)");


static pyqt5ClassPluginDef plugin_QDBusArgument = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtDBus_QDBusArgument = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QDBusArgument,
        SIP_NULLPTR,
        &plugin_QDBusArgument
    },
    {
        sipNameNr_QDBusArgument,
        {0, 0, 1},
        10, methods_QDBusArgument,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QDBusArgument,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QDBusArgument,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QDBusArgument,
    assign_QDBusArgument,
    array_QDBusArgument,
    copy_QDBusArgument,
    release_QDBusArgument,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
