# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the nxos_route_maps module
"""


class Route_mapsArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_route_maps module"""

    argument_spec = {
        "running_config": {"type": "str"},
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "route_map": {"type": "str"},
                "entries": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "sequence": {"type": "int"},
                        "action": {
                            "type": "str",
                            "choices": ["deny", "permit"],
                        },
                        "continue_sequence": {"type": "int"},
                        "description": {"type": "str"},
                        "match": {
                            "type": "dict",
                            "options": {
                                "as_number": {
                                    "type": "dict",
                                    "options": {
                                        "asn": {
                                            "type": "list",
                                            "elements": "str",
                                        },
                                        "as_path_list": {
                                            "type": "list",
                                            "elements": "str",
                                        },
                                    },
                                },
                                "as_path": {"type": "list", "elements": "str"},
                                "community": {
                                    "type": "dict",
                                    "options": {
                                        "community_list": {
                                            "type": "list",
                                            "elements": "str",
                                        },
                                        "exact_match": {"type": "bool"},
                                    },
                                },
                                "evpn": {
                                    "type": "dict",
                                    "options": {
                                        "route_types": {
                                            "type": "list",
                                            "elements": "str",
                                        }
                                    },
                                },
                                "extcommunity": {
                                    "type": "dict",
                                    "options": {
                                        "extcommunity_list": {
                                            "type": "list",
                                            "elements": "str",
                                        },
                                        "exact_match": {"type": "bool"},
                                    },
                                },
                                "interfaces": {
                                    "type": "list",
                                    "elements": "str",
                                },
                                "ip": {
                                    "type": "dict",
                                    "options": {
                                        "address": {
                                            "type": "dict",
                                            "options": {
                                                "access_list": {"type": "str"},
                                                "prefix_lists": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                            },
                                        },
                                        "multicast": {
                                            "type": "dict",
                                            "options": {
                                                "source": {"type": "str"},
                                                "group": {
                                                    "type": "dict",
                                                    "options": {
                                                        "prefix": {
                                                            "type": "str"
                                                        }
                                                    },
                                                },
                                                "group_range": {
                                                    "type": "dict",
                                                    "options": {
                                                        "first": {
                                                            "type": "str"
                                                        },
                                                        "last": {
                                                            "type": "str"
                                                        },
                                                    },
                                                },
                                                "rp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "prefix": {
                                                            "type": "str"
                                                        },
                                                        "rp_type": {
                                                            "type": "str",
                                                            "choices": [
                                                                "ASM",
                                                                "Bidir",
                                                            ],
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "next_hop": {
                                            "type": "dict",
                                            "options": {
                                                "prefix_lists": {
                                                    "type": "list",
                                                    "elements": "str",
                                                }
                                            },
                                        },
                                        "route_source": {
                                            "type": "dict",
                                            "options": {
                                                "prefix_lists": {
                                                    "type": "list",
                                                    "elements": "str",
                                                }
                                            },
                                        },
                                    },
                                },
                                "ipv6": {
                                    "type": "dict",
                                    "options": {
                                        "address": {
                                            "type": "dict",
                                            "options": {
                                                "access_list": {"type": "str"},
                                                "prefix_lists": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                            },
                                        },
                                        "multicast": {
                                            "type": "dict",
                                            "options": {
                                                "source": {"type": "str"},
                                                "group": {
                                                    "type": "dict",
                                                    "options": {
                                                        "prefix": {
                                                            "type": "str"
                                                        }
                                                    },
                                                },
                                                "group_range": {
                                                    "type": "dict",
                                                    "options": {
                                                        "first": {
                                                            "type": "str"
                                                        },
                                                        "last": {
                                                            "type": "str"
                                                        },
                                                    },
                                                },
                                                "rp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "prefix": {
                                                            "type": "str"
                                                        },
                                                        "rp_type": {
                                                            "type": "str",
                                                            "choices": [
                                                                "ASM",
                                                                "Bidir",
                                                            ],
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "next_hop": {
                                            "type": "dict",
                                            "options": {
                                                "prefix_lists": {
                                                    "type": "list",
                                                    "elements": "str",
                                                }
                                            },
                                        },
                                        "route_source": {
                                            "type": "dict",
                                            "options": {
                                                "prefix_lists": {
                                                    "type": "list",
                                                    "elements": "str",
                                                }
                                            },
                                        },
                                    },
                                },
                                "mac_list": {
                                    "type": "list",
                                    "elements": "str",
                                },
                                "metric": {"type": "list", "elements": "int"},
                                "ospf_area": {
                                    "type": "list",
                                    "elements": "int",
                                },
                                "route_types": {
                                    "type": "list",
                                    "elements": "str",
                                    "choices": [
                                        "external",
                                        "inter-area",
                                        "internal",
                                        "intra-area",
                                        "level-1",
                                        "level-2",
                                        "local",
                                        "nssa-external",
                                        "type-1",
                                        "type-2",
                                    ],
                                },
                                "source_protocol": {
                                    "type": "list",
                                    "elements": "str",
                                },
                                "tags": {"type": "list", "elements": "int"},
                            },
                        },
                        "set": {
                            "type": "dict",
                            "options": {
                                "as_path": {
                                    "type": "dict",
                                    "options": {
                                        "prepend": {
                                            "type": "dict",
                                            "options": {
                                                "as_number": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "last_as": {"type": "int"},
                                            },
                                        },
                                        "tag": {"type": "bool"},
                                    },
                                },
                                "comm_list": {"type": "str"},
                                "community": {
                                    "type": "dict",
                                    "options": {
                                        "additive": {"type": "bool"},
                                        "graceful_shutdown": {"type": "bool"},
                                        "internet": {"type": "bool"},
                                        "local_as": {"type": "bool"},
                                        "no_advertise": {"type": "bool"},
                                        "no_export": {"type": "bool"},
                                        "number": {
                                            "type": "list",
                                            "elements": "str",
                                        },
                                    },
                                },
                                "dampening": {
                                    "type": "dict",
                                    "options": {
                                        "half_life": {"type": "int"},
                                        "start_reuse_route": {"type": "int"},
                                        "start_suppress_route": {
                                            "type": "int"
                                        },
                                        "max_suppress_time": {"type": "int"},
                                    },
                                },
                                "distance": {
                                    "type": "dict",
                                    "options": {
                                        "igp_ebgp_routes": {"type": "int"},
                                        "internal_routes": {"type": "int"},
                                        "local_routes": {"type": "int"},
                                    },
                                },
                                "evpn": {
                                    "type": "dict",
                                    "options": {
                                        "gateway_ip": {
                                            "type": "dict",
                                            "mutually_exclusive": [
                                                ["ip", "use_nexthop"]
                                            ],
                                            "options": {
                                                "ip": {"type": "str"},
                                                "use_nexthop": {
                                                    "type": "bool"
                                                },
                                            },
                                        }
                                    },
                                },
                                "extcomm_list": {"type": "str"},
                                "forwarding_address": {"type": "bool"},
                                "null_interface": {"type": "str"},
                                "ip": {
                                    "type": "dict",
                                    "options": {
                                        "address": {
                                            "type": "dict",
                                            "options": {
                                                "prefix_list": {"type": "str"}
                                            },
                                        },
                                        "precedence": {"type": "str"},
                                    },
                                },
                                "ipv6": {
                                    "type": "dict",
                                    "options": {
                                        "address": {
                                            "type": "dict",
                                            "options": {
                                                "prefix_list": {"type": "str"}
                                            },
                                        },
                                        "precedence": {"type": "str"},
                                    },
                                },
                                "label_index": {"type": "int"},
                                "level": {
                                    "type": "str",
                                    "choices": [
                                        "level-1",
                                        "level-1-2",
                                        "level-2",
                                    ],
                                },
                                "local_preference": {"type": "int"},
                                "metric": {
                                    "type": "dict",
                                    "options": {
                                        "bandwidth": {"type": "int"},
                                        "igrp_delay_metric": {"type": "int"},
                                        "igrp_reliability_metric": {
                                            "type": "int"
                                        },
                                        "igrp_effective_bandwidth_metric": {
                                            "type": "int"
                                        },
                                        "igrp_mtu": {"type": "int"},
                                    },
                                },
                                "metric_type": {
                                    "type": "str",
                                    "choices": [
                                        "external",
                                        "internal",
                                        "type-1",
                                        "type-2",
                                    ],
                                },
                                "nssa_only": {"type": "bool"},
                                "origin": {
                                    "type": "str",
                                    "choices": ["egp", "igp", "incomplete"],
                                },
                                "path_selection": {
                                    "type": "str",
                                    "choices": [
                                        "all",
                                        "backup",
                                        "best2",
                                        "multipaths",
                                    ],
                                },
                                "tag": {"type": "int"},
                                "weight": {"type": "int"},
                            },
                        },
                    },
                },
            },
        },
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "parsed",
                "gathered",
                "rendered",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
