/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.FileNotFoundException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.transfer.MetadataNotFoundException;

class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    LoggingRepositoryListener(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void artifactInstalling(RepositoryEvent event2) {
        this.logger.info("Installing " + event2.getArtifact().getFile() + " to " + event2.getFile());
    }

    @Override
    public void metadataInstalling(RepositoryEvent event2) {
        this.logger.debug("Installing " + event2.getMetadata() + " to " + event2.getFile());
    }

    @Override
    public void metadataResolved(RepositoryEvent event2) {
        Exception e2 = event2.getException();
        if (e2 != null) {
            if (e2 instanceof MetadataNotFoundException) {
                this.logger.debug(e2.getMessage());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(e2.getMessage(), e2);
            } else {
                this.logger.warn(e2.getMessage());
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event2) {
        Exception exception = event2.getException();
        StringBuilder buffer2 = new StringBuilder(256);
        buffer2.append("The metadata ");
        if (event2.getMetadata().getFile() != null) {
            buffer2.append(event2.getMetadata().getFile());
        } else {
            buffer2.append(event2.getMetadata());
        }
        if (exception instanceof FileNotFoundException) {
            buffer2.append(" is inaccessible");
        } else {
            buffer2.append(" is invalid");
        }
        if (exception != null) {
            buffer2.append(": ");
            buffer2.append(exception.getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer2.toString(), exception);
        } else {
            this.logger.warn(buffer2.toString());
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event2) {
        StringBuilder buffer2 = new StringBuilder(256);
        buffer2.append("The POM for ");
        buffer2.append(event2.getArtifact());
        buffer2.append(" is invalid, transitive dependencies (if any) will not be available");
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer2 + ": " + event2.getException().getMessage());
        } else {
            this.logger.warn(buffer2 + ", enable debug logging for more details");
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event2) {
        this.logger.warn("The POM for " + event2.getArtifact() + " is missing, no dependency information available");
    }
}

