# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BSplCLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_bsplclib.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BSplCLib
else:
    import _BSplCLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BSplCLib.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BSplCLib.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BSplCLib.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BSplCLib.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BSplCLib.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BSplCLib.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BSplCLib.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BSplCLib.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BSplCLib.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BSplCLib.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BSplCLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BSplCLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BSplCLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BSplCLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BSplCLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BSplCLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BSplCLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BSplCLib:
_BSplCLib.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BSplCLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.gp
import OCC.Core.TColgp
import OCC.Core.GeomAbs

from enum import IntEnum
from OCC.Core.Exception import *

BSplCLib_NonConstant = _BSplCLib.BSplCLib_NonConstant
BSplCLib_Constant = _BSplCLib.BSplCLib_Constant
BSplCLib_QuasiConstant = _BSplCLib.BSplCLib_QuasiConstant
BSplCLib_NonUniform = _BSplCLib.BSplCLib_NonUniform
BSplCLib_Uniform = _BSplCLib.BSplCLib_Uniform


class BSplCLib_MultDistribution(IntEnum):
	BSplCLib_NonConstant = 0
	BSplCLib_Constant = 1
	BSplCLib_QuasiConstant = 2
BSplCLib_NonConstant = BSplCLib_MultDistribution.BSplCLib_NonConstant
BSplCLib_Constant = BSplCLib_MultDistribution.BSplCLib_Constant
BSplCLib_QuasiConstant = BSplCLib_MultDistribution.BSplCLib_QuasiConstant

class BSplCLib_KnotDistribution(IntEnum):
	BSplCLib_NonUniform = 0
	BSplCLib_Uniform = 1
BSplCLib_NonUniform = BSplCLib_KnotDistribution.BSplCLib_NonUniform
BSplCLib_Uniform = BSplCLib_KnotDistribution.BSplCLib_Uniform


def Handle_BSplCLib_Cache_Create() -> "opencascade::handle< BSplCLib_Cache >":
    return _BSplCLib.Handle_BSplCLib_Cache_Create()

def Handle_BSplCLib_Cache_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BSplCLib_Cache >":
    return _BSplCLib.Handle_BSplCLib_Cache_DownCast(t)

def Handle_BSplCLib_Cache_IsNull(t: "opencascade::handle< BSplCLib_Cache > const &") -> "bool":
    return _BSplCLib.Handle_BSplCLib_Cache_IsNull(t)
class bsplclib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AntiBoorScheme(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Compute the content of pole before the boorscheme. this method is used to remove poles. //! u is the poles to remove, knots should contains the knots of the curve after knot removal. //! the first and last poles do not change, the other poles are computed by averaging two possible values. the distance between the two possible poles is computed, if it is higher than <tolerance> false is returned.

        Parameters
        ----------
        U: float
        Degree: int
        Dimension: int
        Depth: int
        Length: int
        Tolerance: float

        Returns
        -------
        Knots: float
        Poles: float

        """
        return _BSplCLib.bsplclib_AntiBoorScheme(*args)

    @staticmethod
    def Bohm(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Performs the bohm algorithm at parameter <u>. this algorithm computes the value and all the derivatives up to order n (n <= degree). //! <poles> is the original array of poles. //! the result in <poles> is the value and the derivatives. poles[0] is the value, poles[degree] is the last derivative.

        Parameters
        ----------
        U: float
        Degree: int
        N: int
        Dimension: int

        Returns
        -------
        Knots: float
        Poles: float

        """
        return _BSplCLib.bsplclib_Bohm(*args)

    @staticmethod
    def BoorIndex(*args) -> "Standard_Integer":
        r"""
        Returns the index in the boor result array of the poles <index>. if the boor algorithm was perform with <length> and <depth>.

        Parameters
        ----------
        Index: int
        Length: int
        Depth: int

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_BoorIndex(*args)

    @staticmethod
    def BoorScheme(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Performs the boor algorithm at parameter <u> with the given <degree> and the array of <knots> on the poles <poles> of dimension <dimension>. the schema is computed until level <depth> on a basis of <length+1> poles. //! * knots is an array of reals of length : //! <length> + <degree> //! * poles is an array of reals of length : //! (2 * <length> + 1) * <dimension> //! the poles values must be set in the array at the positions. //! 0..dimension, //! 2 * dimension .. 3 * dimension //! 4 * dimension .. 5 * dimension //! ... //! the results are found in the array poles depending on the depth. (see the method getpole).

        Parameters
        ----------
        U: float
        Degree: int
        Dimension: int
        Depth: int
        Length: int

        Returns
        -------
        Knots: float
        Poles: float

        """
        return _BSplCLib.bsplclib_BoorScheme(*args)

    @staticmethod
    def BuildBSpMatrix(*args) -> "Standard_Integer &, Standard_Integer &":
        r"""
        This builds a fully blown matrix of (ni) bi (tj) //! with i and j within 1..order + numpoles the integer ni is the ith slot of the array orderarray, tj is the jth slot of the array parameters.

        Parameters
        ----------
        Parameters: TColStd_Array1OfReal
        OrderArray: TColStd_Array1OfInteger
        FlatKnots: TColStd_Array1OfReal
        Degree: int
        Matrix: math_Matrix

        Returns
        -------
        UpperBandWidth: int
        LowerBandWidth: int

        """
        return _BSplCLib.bsplclib_BuildBSpMatrix(*args)

    @staticmethod
    def BuildBoor(*args) -> "Standard_Real &":
        r"""
        Copy in <lp> poles for <dimension> boor scheme. starting from <index> * <dimension>, copy <length+1> poles.

        Parameters
        ----------
        Index: int
        Length: int
        Dimension: int
        Poles: TColStd_Array1OfReal

        Returns
        -------
        LP: float

        """
        return _BSplCLib.bsplclib_BuildBoor(*args)

    @staticmethod
    def BuildCache(*args) -> "void":
        r"""
        Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. if rational computes the homogeneous taylor expension for the numerator and stores it in cachepoles.

        Parameters
        ----------
        U: float
        InverseOfSpanDomain: float
        PeriodicFlag: bool
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        CachePoles: TColgp_Array1OfPnt
        CacheWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. if rational computes the homogeneous taylor expension for the numerator and stores it in cachepoles.

        Parameters
        ----------
        U: float
        InverseOfSpanDomain: float
        PeriodicFlag: bool
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        CachePoles: TColgp_Array1OfPnt2d
        CacheWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. structure of result optimized for bsplclib_cache.

        Parameters
        ----------
        theParameter: float
        theSpanDomain: float
        thePeriodicFlag: bool
        theDegree: int
        theSpanIndex: int
        theFlatKnots: TColStd_Array1OfReal
        thePoles: TColgp_Array1OfPnt
        theWeights: TColStd_Array1OfReal *
        theCacheArray: TColStd_Array2OfReal

        Returns
        -------
        None
        Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. structure of result optimized for bsplclib_cache.

        Parameters
        ----------
        theParameter: float
        theSpanDomain: float
        thePeriodicFlag: bool
        theDegree: int
        theSpanIndex: int
        theFlatKnots: TColStd_Array1OfReal
        thePoles: TColgp_Array1OfPnt2d
        theWeights: TColStd_Array1OfReal *
        theCacheArray: TColStd_Array2OfReal

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_BuildCache(*args)

    @staticmethod
    def BuildEval(*args) -> "Standard_Real &":
        r"""
        No available documentation.

        Parameters
        ----------
        Degree: int
        Index: int
        Poles: TColStd_Array1OfReal
        Weights: TColStd_Array1OfReal *

        Returns
        -------
        LP: float
        No available documentation.

        Parameters
        ----------
        Degree: int
        Index: int
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *

        Returns
        -------
        LP: float
        Copy in <lp> the poles and weights for the eval scheme. starting from poles(poles.lower()+index).

        Parameters
        ----------
        Degree: int
        Index: int
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *

        Returns
        -------
        LP: float

        """
        return _BSplCLib.bsplclib_BuildEval(*args)

    @staticmethod
    def BuildKnots(*args) -> "Standard_Real &":
        r"""
        Stores in lk the usefull knots for the boorschem on the span knots(index) - knots(index+1).

        Parameters
        ----------
        Degree: int
        Index: int
        Periodic: bool
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *

        Returns
        -------
        LK: float

        """
        return _BSplCLib.bsplclib_BuildKnots(*args)

    @staticmethod
    def BuildSchoenbergPoints(*args) -> "void":
        r"""
        Builds the schoenberg points from the flat knot used to interpolate a bspline since the bspline matrix is invertible.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_BuildSchoenbergPoints(*args)

    @staticmethod
    def CacheD0(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt

        Returns
        -------
        None
        Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CacheD0(*args)

    @staticmethod
    def CacheD1(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt
        Vec: gp_Vec

        Returns
        -------
        None
        Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d
        Vec: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CacheD1(*args)

    @staticmethod
    def CacheD2(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt
        Vec1: gp_Vec
        Vec2: gp_Vec

        Returns
        -------
        None
        Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d
        Vec1: gp_Vec2d
        Vec2: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CacheD2(*args)

    @staticmethod
    def CacheD3(*args) -> "void":
        r"""
        Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt
        Vec1: gp_Vec
        Vec2: gp_Vec
        Vec3: gp_Vec

        Returns
        -------
        None
        Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

        Parameters
        ----------
        U: float
        Degree: int
        CacheParameter: float
        SpanLenght: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d
        Vec1: gp_Vec2d
        Vec2: gp_Vec2d
        Vec3: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CacheD3(*args)

    @staticmethod
    def CoefsD0(*args) -> "void":
        r"""
        Calls cached0 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt

        Returns
        -------
        None
        Calls cached0 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CoefsD0(*args)

    @staticmethod
    def CoefsD1(*args) -> "void":
        r"""
        Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt
        Vec: gp_Vec

        Returns
        -------
        None
        Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d
        Vec: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CoefsD1(*args)

    @staticmethod
    def CoefsD2(*args) -> "void":
        r"""
        Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt
        Vec1: gp_Vec
        Vec2: gp_Vec

        Returns
        -------
        None
        Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d
        Vec1: gp_Vec2d
        Vec2: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CoefsD2(*args)

    @staticmethod
    def CoefsD3(*args) -> "void":
        r"""
        Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt
        Vec1: gp_Vec
        Vec2: gp_Vec
        Vec3: gp_Vec

        Returns
        -------
        None
        Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Point: gp_Pnt2d
        Vec1: gp_Vec2d
        Vec2: gp_Vec2d
        Vec3: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_CoefsD3(*args)

    @staticmethod
    def D0(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColStd_Array1OfReal
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *

        Returns
        -------
        P: float
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        UIndex: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_D0(*args)

    @staticmethod
    def D1(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColStd_Array1OfReal
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *

        Returns
        -------
        P: float
        V: float
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        UIndex: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt2d
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt2d
        V: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_D1(*args)

    @staticmethod
    def D2(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColStd_Array1OfReal
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *

        Returns
        -------
        P: float
        V1: float
        V2: float
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        UIndex: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt2d
        V1: gp_Vec2d
        V2: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt2d
        V1: gp_Vec2d
        V2: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_D2(*args)

    @staticmethod
    def D3(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColStd_Array1OfReal
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *

        Returns
        -------
        P: float
        V1: float
        V2: float
        V3: float
        No available documentation.

        Parameters
        ----------
        U: float
        Index: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec
        V3: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        UIndex: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        P: gp_Pnt2d
        V1: gp_Vec2d
        V2: gp_Vec2d
        V3: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt
        V1: gp_Vec
        V2: gp_Vec
        V3: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        U: float
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        P: gp_Pnt2d
        V1: gp_Vec2d
        V2: gp_Vec2d
        V3: gp_Vec2d

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_D3(*args)

    @staticmethod
    def Derivative(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Computes the poles of the bspline giving the derivatives of order <order>. //! the formula for the first order is //! pole(i) = degree * (pole(i+1) - pole(i)) / (knots(i+degree+1) - knots(i+1)) //! this formula is repeated (degree is decremented at each step).

        Parameters
        ----------
        Degree: int
        Dimension: int
        Length: int
        Order: int

        Returns
        -------
        Knots: float
        Poles: float

        """
        return _BSplCLib.bsplclib_Derivative(*args)

    @staticmethod
    def Eval(*args) -> "Standard_Integer &, Standard_Real &":
        r"""
        Perform the boor algorithm to evaluate a point at parameter <u>, with <degree> and <dimension>. //! poles is an array of reals of size //! <dimension> * <degree>+1 //! containing the poles. at the end <poles> contains the current point.

        Parameters
        ----------
        U: float
        Degree: int
        Dimension: int

        Returns
        -------
        Knots: float
        Poles: float
        Perform the de boor algorithm to evaluate a point at parameter <u>, with <degree> and <dimension>. //! poles is an array of reals of size //! <dimension> * <degree>+1 //! containing the poles. at the end <poles> contains the current point. poles contain all the poles of the bsplinecurve, knots also contains all the knots of the bsplinecurve. extrapmode has two slots [0] = degree used to extrapolate before the first knot [1] = degre used to extrapolate after the last knot has to be between 1 and degree.

        Parameters
        ----------
        U: float
        PeriodicFlag: bool
        DerivativeRequest: int
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        ArrayDimension: int

        Returns
        -------
        ExtrapMode: int
        Poles: float
        Result: float
        Perform the de boor algorithm to evaluate a point at parameter <u>, with <degree> and <dimension>. evaluates by multiplying the poles by the weights and gives the homogeneous result in polesresult that is the results of the evaluation of the numerator once it has been multiplied by the weights and in weightsresult one has the result of the evaluation of the denominator //! warning: <polesresult> and <weightsresult> must be dimensionned properly.

        Parameters
        ----------
        U: float
        PeriodicFlag: bool
        DerivativeRequest: int
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        ArrayDimension: int

        Returns
        -------
        ExtrapMode: int
        Poles: float
        Weights: float
        PolesResult: float
        WeightsResult: float
        Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point.

        Parameters
        ----------
        U: float
        PeriodicFlag: bool
        HomogeneousFlag: bool
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal
        Point: gp_Pnt

        Returns
        -------
        ExtrapMode: int
        Weight: float
        Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point.

        Parameters
        ----------
        U: float
        PeriodicFlag: bool
        HomogeneousFlag: bool
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal
        Point: gp_Pnt2d

        Returns
        -------
        ExtrapMode: int
        Weight: float

        """
        return _BSplCLib.bsplclib_Eval(*args)

    @staticmethod
    def EvalBsplineBasis(*args) -> "Standard_Integer &":
        r"""
        This evaluates the bspline basis at a given parameter parameter up to the requested derivativeorder and store the result in the array bsplinebasis in the following fashion bsplinebasis(1,1) = value of first non vanishing bspline function which has index firstnonzerobsplineindex bsplinebasis(1,2) = value of second non vanishing bspline function which has index firstnonzerobsplineindex + 1 bsplinebasis(1,n) = value of second non vanishing non vanishing bspline function which has index firstnonzerobsplineindex + n (n <= order) bsplinebasis(2,1) = value of derivative of first non vanishing bspline function which has index firstnonzerobsplineindex bsplinebasis(n,1) = value of nth derivative of first non vanishing bspline function which has index firstnonzerobsplineindex if n <= derivativeorder + 1.

        Parameters
        ----------
        DerivativeOrder: int
        Order: int
        FlatKnots: TColStd_Array1OfReal
        Parameter: float
        BsplineBasis: math_Matrix
        isPeriodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        FirstNonZeroBsplineIndex: int

        """
        return _BSplCLib.bsplclib_EvalBsplineBasis(*args)

    @staticmethod
    def FactorBandedMatrix(*args) -> "Standard_Integer &":
        r"""
        This factors the banded matrix in the lu form with a banded storage of components of the l matrix warning : do not use if the matrix is totally positive (it is the case for bspline matrices build as above with parameters being the schoenberg points.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int

        Returns
        -------
        PivotIndexProblem: int

        """
        return _BSplCLib.bsplclib_FactorBandedMatrix(*args)

    @staticmethod
    def FirstUKnotIndex(*args) -> "Standard_Integer":
        r"""
        Computes the index of the knots value which gives the start point of the curve.

        Parameters
        ----------
        Degree: int
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_FirstUKnotIndex(*args)

    @staticmethod
    def FlatBezierKnots(*args) -> "Standard_Real const &":
        r"""
        Returns pointer to statically allocated array representing flat knots for bezier curve of the specified degree. raises outofrange if degree > maxdegree().

        Parameters
        ----------
        Degree: int

        Returns
        -------
        float

        """
        return _BSplCLib.bsplclib_FlatBezierKnots(*args)

    @staticmethod
    def FlatIndex(*args) -> "Standard_Integer":
        r"""
        Computes the index of the flats knots sequence corresponding to <index> in the knots sequence which multiplicities are <mults>.

        Parameters
        ----------
        Degree: int
        Index: int
        Mults: TColStd_Array1OfInteger
        Periodic: bool

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_FlatIndex(*args)

    @staticmethod
    def FunctionMultiply(*args) -> "Standard_Integer &":
        r"""
        This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        PolesDimension: int
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int

        Returns
        -------
        Poles: float
        NewPoles: float
        theStatus: int
        This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        Poles: TColStd_Array1OfReal
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int
        NewPoles: TColStd_Array1OfReal

        Returns
        -------
        theStatus: int
        This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt2d
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int
        NewPoles: TColgp_Array1OfPnt2d

        Returns
        -------
        theStatus: int
        This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int
        NewPoles: TColgp_Array1OfPnt

        Returns
        -------
        theStatus: int

        """
        return _BSplCLib.bsplclib_FunctionMultiply(*args)

    @staticmethod
    def FunctionReparameterise(*args) -> "Standard_Integer &":
        r"""
        This function will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following: //! 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots //! 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) //! warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method //! thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        PolesDimension: int
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int

        Returns
        -------
        Poles: float
        NewPoles: float
        theStatus: int
        This function will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following: //! 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots //! 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) //! warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method //! thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        Poles: TColStd_Array1OfReal
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int
        NewPoles: TColStd_Array1OfReal

        Returns
        -------
        theStatus: int
        This will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following : 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int
        NewPoles: TColgp_Array1OfPnt

        Returns
        -------
        theStatus: int
        This will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following : 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

        Parameters
        ----------
        Function: BSplCLib_EvaluatorFunction
        BSplineDegree: int
        BSplineFlatKnots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt2d
        FlatKnots: TColStd_Array1OfReal
        NewDegree: int
        NewPoles: TColgp_Array1OfPnt2d

        Returns
        -------
        theStatus: int

        """
        return _BSplCLib.bsplclib_FunctionReparameterise(*args)

    @staticmethod
    def GetPole(*args) -> "Standard_Real &, Standard_Integer &":
        r"""
        Copy the pole at position <index> in the boor scheme of dimension <dimension> to <position> in the array <pole>. <position> is updated.

        Parameters
        ----------
        Index: int
        Length: int
        Depth: int
        Dimension: int
        Pole: TColStd_Array1OfReal

        Returns
        -------
        LocPoles: float
        Position: int

        """
        return _BSplCLib.bsplclib_GetPole(*args)

    @staticmethod
    def Hunt(*args) -> "Standard_Integer &":
        r"""
        This routine searches the position of the real value thex in the monotonically increasing set of real values thearray using bisection algorithm. //! if the given value is out of range or array values, algorithm returns either thearray.lower()-1 or thearray.upper()+1 depending on thex position in the ordered set. //! this routine is used to locate a knot value in a set of knots.

        Parameters
        ----------
        theArray: TColStd_Array1OfReal
        theX: float

        Returns
        -------
        theXPos: int

        """
        return _BSplCLib.bsplclib_Hunt(*args)

    @staticmethod
    def IncreaseDegree(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Degree: int
        NewDegree: int
        Periodic: bool
        Dimension: int
        Poles: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColStd_Array1OfReal
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        NewDegree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        NewDegree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        NewDegree: int
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        Increase the degree of a bspline (or bezier) curve of dimension <dimension> form <degree> to <newdegree>. //! the number of poles in the new curve is : //! poles.length() + (newdegree - degree) * number of spans //! where the number of spans is : //! lastuknotindex(mults) - firstuknotindex(mults) + 1 //! for a non-periodic curve //! and knots.length() - 1 for a periodic curve. //! the multiplicities of all knots are increased by the degree elevation. //! the new knots are usually the same knots with the exception of a non-periodic curve with the first and last multiplicity not equal to degree+1 where knots are removed form the start and the bottom untils the sum of the multiplicities is equal to newdegree+1 at the knots corresponding to the first and last parameters of the curve. //! example : suppose a curve of degree 3 starting with following knots and multiplicities : //! knot : 0. 1. 2. mult : 1 2 1 //! the firstuknot is 2. because the sum of multiplicities is degree+1 : 1 + 2 + 1 = 4 = 3 + 1 //! i.e. the first parameter of the curve is 2. and will still be 2. after degree elevation. let raises this curve to degree 4. the multiplicities are increased by 2. //! they become 2 3 2. but we need a sum of multiplicities of 5 at knot 2. so the first knot is removed and the new knots are : //! knot : 1. 2. mult : 3 2 //! the multipicity of the first knot may also be reduced if the sum is still to big. //! in the most common situations (periodic curve or curve with first and last multiplicities equals to degree+1) the knots are knot changes. //! the method increasedegreecountknots can be used to compute the new number of knots.

        Parameters
        ----------
        NewDegree: int
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_IncreaseDegree(*args)

    @staticmethod
    def IncreaseDegreeCountKnots(*args) -> "Standard_Integer":
        r"""
        Returns the number of knots of a curve with multiplicities <mults> after elevating the degree from <degree> to <newdegree>. see the increasedegree method for more comments.

        Parameters
        ----------
        Degree: int
        NewDegree: int
        Periodic: bool
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_IncreaseDegreeCountKnots(*args)

    @staticmethod
    def InsertKnot(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        UIndex: int
        U: float
        UMult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        Insert a new knot u of multiplicity umult in the knot sequence. //! the location of the new knot should be given as an input data. uindex locates the new knot u in the knot sequence and knots (uindex) < u < knots (uindex + 1). //! the new control points corresponding to this insertion are returned. knots and mults are not updated.

        Parameters
        ----------
        UIndex: int
        U: float
        UMult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_InsertKnot(*args)

    @staticmethod
    def InsertKnots(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Dimension: int
        Poles: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        AddKnots: TColStd_Array1OfReal
        AddMults: TColStd_Array1OfInteger *
        NewPoles: TColStd_Array1OfReal
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Epsilon: float
        Add: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        AddKnots: TColStd_Array1OfReal
        AddMults: TColStd_Array1OfInteger *
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Epsilon: float
        Add: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Insert a sequence of knots <addknots> with multiplicities <addmults>. <addknots> must be a non decreasing sequence and verifies : //! knots(knots.lower()) <= addknots(addknots.lower()) knots(knots.upper()) >= addknots(addknots.upper()) //! the newpoles and newweights arrays must have a length : poles.length() + sum(addmults()) //! when a knot to insert is identic to an existing knot the multiplicities are added. //! epsilon is used to test knots for equality. //! when addmult is negative or null the knot is not inserted. no multiplicity will becomes higher than the degree. //! the new knots and multiplicities are copied in <newknots> and <newmults>. //! all the new arrays should be correctly dimensioned. //! when all the new knots are existing knots, i.e. only the multiplicities will change it is safe to use the same arrays as input and output.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        AddKnots: TColStd_Array1OfReal
        AddMults: TColStd_Array1OfInteger *
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Epsilon: float
        Add: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_InsertKnots(*args)

    @staticmethod
    def Interpolate(*args) -> "Standard_Real &, Standard_Real &, Standard_Integer &":
        r"""
        Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation or interpolation at scheonberg points the method will work the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal
        ContactOrderArray: TColStd_Array1OfInteger
        Poles: TColgp_Array1OfPnt

        Returns
        -------
        InversionProblem: int
        Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem w ll report 0 if there was no problem else it will give the index of the faulty pivot.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal
        ContactOrderArray: TColStd_Array1OfInteger
        Poles: TColgp_Array1OfPnt2d

        Returns
        -------
        InversionProblem: int
        Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal
        ContactOrderArray: TColStd_Array1OfInteger
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal

        Returns
        -------
        InversionProblem: int
        Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem w ll report 0 if there was no problem else it will give the i.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal
        ContactOrderArray: TColStd_Array1OfInteger
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal

        Returns
        -------
        InversionProblem: int
        Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray the length of flatknots is degree + l + 1 the polesarray is an seen as an array[1..n][1..arraydimension] with n = tge length of the parameters array warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation or interpolation at scheonberg points the method will work the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal
        ContactOrderArray: TColStd_Array1OfInteger
        ArrayDimension: int

        Returns
        -------
        Poles: float
        InversionProblem: int
        No available documentation.

        Parameters
        ----------
        Degree: int
        FlatKnots: TColStd_Array1OfReal
        Parameters: TColStd_Array1OfReal
        ContactOrderArray: TColStd_Array1OfInteger
        ArrayDimension: int

        Returns
        -------
        Poles: float
        Weights: float
        InversionProblem: int

        """
        return _BSplCLib.bsplclib_Interpolate(*args)

    @staticmethod
    def IsRational(*args) -> "Standard_Boolean":
        r"""
        Returns false if all the weights of the array <weights> between i1 an i2 are identic. epsilon is used for comparing weights. if epsilon is 0. the epsilon of the first weight is used.

        Parameters
        ----------
        Weights: TColStd_Array1OfReal
        I1: int
        I2: int
        Epsilon: float,optional
        	default value is 0.0

        Returns
        -------
        bool

        """
        return _BSplCLib.bsplclib_IsRational(*args)

    @staticmethod
    def KnotAnalysis(*args) -> "Standard_Integer &":
        r"""
        Analyzes the array of knots. returns the form and the maximum knot multiplicity.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        CKnots: TColStd_Array1OfReal
        CMults: TColStd_Array1OfInteger
        KnotForm: GeomAbs_BSplKnotDistribution

        Returns
        -------
        MaxKnotMult: int

        """
        return _BSplCLib.bsplclib_KnotAnalysis(*args)

    @staticmethod
    def KnotForm(*args) -> "BSplCLib_KnotDistribution":
        r"""
        Analyses if the knots distribution is 'uniform' or 'nonuniform' between the knot fromk1 and the knot tok2. there is no repetition of knot in the knots'sequence <knots>.

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        FromK1: int
        ToK2: int

        Returns
        -------
        BSplCLib_KnotDistribution

        """
        return _BSplCLib.bsplclib_KnotForm(*args)

    @staticmethod
    def KnotSequence(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        KnotSeq: TColStd_Array1OfReal
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Computes the sequence of knots knotseq with repetition of the knots of multiplicity greater than 1. //! length of knotseq must be knotsequencelength(mults,degree,periodic).

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Degree: int
        Periodic: bool
        KnotSeq: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_KnotSequence(*args)

    @staticmethod
    def KnotSequenceLength(*args) -> "Standard_Integer":
        r"""
        Returns the length of the sequence of knots with repetition. //! periodic : //! sum(mults(i), i = mults.lower(); i <= mults.upper()); //! non periodic : //! sum(mults(i); i = mults.lower(); i < mults.upper()) + 2 * degree.

        Parameters
        ----------
        Mults: TColStd_Array1OfInteger
        Degree: int
        Periodic: bool

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_KnotSequenceLength(*args)

    @staticmethod
    def Knots(*args) -> "void":
        r"""
        Computes the sequence of knots knots without repetition of the knots of multiplicity greater than 1. //! length of <knots> and <mults> must be knotslength(knotsequence,periodic).

        Parameters
        ----------
        KnotSeq: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_Knots(*args)

    @staticmethod
    def KnotsLength(*args) -> "Standard_Integer":
        r"""
        Returns the length of the sequence of knots (and mults) without repetition.

        Parameters
        ----------
        KnotSeq: TColStd_Array1OfReal
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_KnotsLength(*args)

    @staticmethod
    def LastUKnotIndex(*args) -> "Standard_Integer":
        r"""
        Computes the index of the knots value which gives the end point of the curve.

        Parameters
        ----------
        Degree: int
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_LastUKnotIndex(*args)

    @staticmethod
    def LocateParameter(*args) -> "Standard_Integer &, Standard_Real &":
        r"""
        Locates the parametric value u in the knots sequence between the knot k1 and the knot k2. the value return in index verifies. //! knots(index) <= u < knots(index + 1) if u <= knots (k1) then index = k1 if u >= knots (k2) then index = k2 - 1 //! if periodic is true u may be modified to fit in the range knots(k1), knots(k2). in any case the correct value is returned in newu. //! warnings :index is used as input data to initialize the searching function. warning: knots have to be 'withe repetitions'.

        Parameters
        ----------
        Degree: int
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        U: float
        IsPeriodic: bool
        FromK1: int
        ToK2: int

        Returns
        -------
        KnotIndex: int
        NewU: float
        Locates the parametric value u in the knots sequence between the knot k1 and the knot k2. the value return in index verifies. //! knots(index) <= u < knots(index + 1) if u <= knots (k1) then index = k1 if u >= knots (k2) then index = k2 - 1 //! if periodic is true u may be modified to fit in the range knots(k1), knots(k2). in any case the correct value is returned in newu. //! warnings :index is used as input data to initialize the searching function. warning: knots have to be 'flat'.

        Parameters
        ----------
        Degree: int
        Knots: TColStd_Array1OfReal
        U: float
        IsPeriodic: bool
        FromK1: int
        ToK2: int

        Returns
        -------
        KnotIndex: int
        NewU: float
        No available documentation.

        Parameters
        ----------
        Degree: int
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger *
        U: float
        Periodic: bool

        Returns
        -------
        Index: int
        NewU: float

        """
        return _BSplCLib.bsplclib_LocateParameter(*args)

    @staticmethod
    def MaxDegree(*args) -> "Standard_Integer":
        r"""
        Returns the degree maxima for a bsplinecurve.

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_MaxDegree(*args)

    @staticmethod
    def MaxKnotMult(*args) -> "Standard_Integer":
        r"""
        Finds the greatest multiplicity in a set of knots between k1 and k2. mults is the multiplicity associated with each knot value.

        Parameters
        ----------
        Mults: TColStd_Array1OfInteger
        K1: int
        K2: int

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_MaxKnotMult(*args)

    @staticmethod
    def MergeBSplineKnots(*args) -> "Standard_Integer &":
        r"""
        Merges two knot vector by setting the starting and ending values to startvalue and endvalue.

        Parameters
        ----------
        Tolerance: float
        StartValue: float
        EndValue: float
        Degree1: int
        Knots1: TColStd_Array1OfReal
        Mults1: TColStd_Array1OfInteger
        Degree2: int
        Knots2: TColStd_Array1OfReal
        Mults2: TColStd_Array1OfInteger
        NewKnots: TColStd_HArray1OfReal
        NewMults: TColStd_HArray1OfInteger

        Returns
        -------
        NumPoles: int

        """
        return _BSplCLib.bsplclib_MergeBSplineKnots(*args)

    @staticmethod
    def MinKnotMult(*args) -> "Standard_Integer":
        r"""
        Finds the lowest multiplicity in a set of knots between k1 and k2. mults is the multiplicity associated with each knot value.

        Parameters
        ----------
        Mults: TColStd_Array1OfInteger
        K1: int
        K2: int

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_MinKnotMult(*args)

    @staticmethod
    def MovePoint(*args) -> "Standard_Integer &, Standard_Integer &":
        r"""
        Find the new poles which allows an old point (with a given u as parameter) to reach a new position index1 and index2 indicate the range of poles we can move (1, nbpoles-1) or (2, nbpoles) -> no constraint for one side don't enter (1,nbpoles) -> error: rigid move (2, nbpoles-1) -> the ends are enforced (3, nbpoles-2) -> the ends and the tangency are enforced if problem in bsplinebasis calculation, no change for the curve and firstindex, lastindex = 0.

        Parameters
        ----------
        U: float
        Displ: gp_Vec2d
        Index1: int
        Index2: int
        Degree: int
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        FlatKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array1OfPnt2d

        Returns
        -------
        FirstIndex: int
        LastIndex: int
        Find the new poles which allows an old point (with a given u as parameter) to reach a new position index1 and index2 indicate the range of poles we can move (1, nbpoles-1) or (2, nbpoles) -> no constraint for one side don't enter (1,nbpoles) -> error: rigid move (2, nbpoles-1) -> the ends are enforced (3, nbpoles-2) -> the ends and the tangency are enforced if problem in bsplinebasis calculation, no change for the curve and firstindex, lastindex = 0.

        Parameters
        ----------
        U: float
        Displ: gp_Vec
        Index1: int
        Index2: int
        Degree: int
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        FlatKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array1OfPnt

        Returns
        -------
        FirstIndex: int
        LastIndex: int

        """
        return _BSplCLib.bsplclib_MovePoint(*args)

    @staticmethod
    def MovePointAndTangent(*args) -> "Standard_Integer &":
        r"""
        This is the dimension free version of the utility u is the parameter must be within the first flatknots and the last flatknots delta is the amount the curve has to be moved deltaderivative is the amount the derivative has to be moved. delta and deltaderivative must be array of dimension arraydimension degree is the degree of the bspline and the flatknots are the knots of the bspline starting condition if = -1 means the starting point of the curve can move = 0 means the starting point of the cuve cannot move but tangen starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... same holds for endingcondition poles are the poles of the curve weights are the weights of the curve if not null newpoles are the poles of the deformed curve errorstatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions the way to solve this problem is to add knots to the bspline if startcondition = 1 and endcondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a c1 cubic you will need have at least 2 internal knots.

        Parameters
        ----------
        U: float
        ArrayDimension: int
        Tolerance: float
        Degree: int
        StartingCondition: int
        EndingCondition: int
        Weights: TColStd_Array1OfReal *
        FlatKnots: TColStd_Array1OfReal

        Returns
        -------
        Delta: float
        DeltaDerivative: float
        Poles: float
        NewPoles: float
        ErrorStatus: int
        This is the dimension free version of the utility u is the parameter must be within the first flatknots and the last flatknots delta is the amount the curve has to be moved deltaderivative is the amount the derivative has to be moved. delta and deltaderivative must be array of dimension arraydimension degree is the degree of the bspline and the flatknots are the knots of the bspline starting condition if = -1 means the starting point of the curve can move = 0 means the starting point of the cuve cannot move but tangen starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... same holds for endingcondition poles are the poles of the curve weights are the weights of the curve if not null newpoles are the poles of the deformed curve errorstatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions the way to solve this problem is to add knots to the bspline if startcondition = 1 and endcondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a c1 cubic you will need have at least 2 internal knots.

        Parameters
        ----------
        U: float
        Delta: gp_Vec
        DeltaDerivative: gp_Vec
        Tolerance: float
        Degree: int
        StartingCondition: int
        EndingCondition: int
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        FlatKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array1OfPnt

        Returns
        -------
        ErrorStatus: int
        This is the dimension free version of the utility u is the parameter must be within the first flatknots and the last flatknots delta is the amount the curve has to be moved deltaderivative is the amount the derivative has to be moved. delta and deltaderivative must be array of dimension arraydimension degree is the degree of the bspline and the flatknots are the knots of the bspline starting condition if = -1 means the starting point of the curve can move = 0 means the starting point of the cuve cannot move but tangen starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... same holds for endingcondition poles are the poles of the curve weights are the weights of the curve if not null newpoles are the poles of the deformed curve errorstatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions the way to solve this problem is to add knots to the bspline if startcondition = 1 and endcondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a c1 cubic you will need have at least 2 internal knots.

        Parameters
        ----------
        U: float
        Delta: gp_Vec2d
        DeltaDerivative: gp_Vec2d
        Tolerance: float
        Degree: int
        StartingCondition: int
        EndingCondition: int
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        FlatKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array1OfPnt2d

        Returns
        -------
        ErrorStatus: int

        """
        return _BSplCLib.bsplclib_MovePointAndTangent(*args)

    @staticmethod
    def MultForm(*args) -> "BSplCLib_MultDistribution":
        r"""
        Analyses the distribution of multiplicities between the knot fromk1 and the knot tok2.

        Parameters
        ----------
        Mults: TColStd_Array1OfInteger
        FromK1: int
        ToK2: int

        Returns
        -------
        BSplCLib_MultDistribution

        """
        return _BSplCLib.bsplclib_MultForm(*args)

    @staticmethod
    def NbPoles(*args) -> "Standard_Integer":
        r"""
        Returns the number of poles of the curve. returns 0 if one of the multiplicities is incorrect. //! * non positive. //! * greater than degree, or degree+1 at the first and last knot of a non periodic curve. //! * the last periodicity on a periodic curve is not equal to the first.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_NbPoles(*args)

    @staticmethod
    def NoMults(*args) -> "TColStd_Array1OfInteger *":
        r"""
        Used as argument for a flatknots evaluation.

        Returns
        -------
        TColStd_Array1OfInteger *

        """
        return _BSplCLib.bsplclib_NoMults(*args)

    @staticmethod
    def NoWeights(*args) -> "TColStd_Array1OfReal *":
        r"""
        Used as argument for a non rational curve.

        Returns
        -------
        TColStd_Array1OfReal *

        """
        return _BSplCLib.bsplclib_NoWeights(*args)

    @staticmethod
    def PoleIndex(*args) -> "Standard_Integer":
        r"""
        Return the index of the first pole to use on the span mults(index) - mults(index+1). this index must be added to poles.lower().

        Parameters
        ----------
        Degree: int
        Index: int
        Periodic: bool
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_PoleIndex(*args)

    @staticmethod
    def PolesCoefficients(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d
        CachePoles: TColgp_Array1OfPnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        CachePoles: TColgp_Array1OfPnt2d
        CacheWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt
        CachePoles: TColgp_Array1OfPnt

        Returns
        -------
        None
        Encapsulation of buildcache to perform the evaluation of the taylor expansion for beziercurves at parameter 0. warning: to be used for beziercurves only!!!.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        CachePoles: TColgp_Array1OfPnt
        CacheWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_PolesCoefficients(*args)

    @staticmethod
    def PrepareInsertKnots(*args) -> "Standard_Integer &, Standard_Integer &":
        r"""
        Returns in <nbpoles, nbknots> the new number of poles and knots if the sequence of knots <addknots, addmults> is inserted in the sequence <knots, mults>. //! epsilon is used to compare knots for equality. //! if add is true the multiplicities on equal knots are added. //! if add is false the max value of the multiplicities is kept. //! return false if : the knew knots are knot increasing. the new knots are not in the range.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        AddKnots: TColStd_Array1OfReal
        AddMults: TColStd_Array1OfInteger *
        Epsilon: float
        Add: bool,optional
        	default value is Standard_True

        Returns
        -------
        NbPoles: int
        NbKnots: int

        """
        return _BSplCLib.bsplclib_PrepareInsertKnots(*args)

    @staticmethod
    def PrepareTrimming(*args) -> "Standard_Integer &, Standard_Integer &":
        r"""
        Set in <nbknots> and <nbpoles> the number of knots and poles of the curve resulting of the trimming of the bsplinecurve definded with <degree>, <knots>, <mults>.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        U1: float
        U2: float

        Returns
        -------
        NbKnots: int
        NbPoles: int

        """
        return _BSplCLib.bsplclib_PrepareTrimming(*args)

    @staticmethod
    def PrepareUnperiodize(*args) -> "Standard_Integer &, Standard_Integer &":
        r"""
        Set in <nbknots> and <nbpolestoadd> the number of knots and poles of the notperiodic curve identical at the periodic curve with a degree <degree> , a knots-distribution with multiplicities <mults>.

        Parameters
        ----------
        Degree: int
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        NbKnots: int
        NbPoles: int

        """
        return _BSplCLib.bsplclib_PrepareUnperiodize(*args)

    @staticmethod
    def RaiseMultiplicity(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        KnotIndex: int
        Mult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        Raise the multiplicity of knot to <umult>. //! the new control points are returned. knots and mults are not updated.

        Parameters
        ----------
        KnotIndex: int
        Mult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_RaiseMultiplicity(*args)

    @staticmethod
    def RemoveKnot(*args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        Index: int
        Mult: int
        Degree: int
        Periodic: bool
        Dimension: int
        Poles: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColStd_Array1OfReal
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Tolerance: float

        Returns
        -------
        bool
        No available documentation.

        Parameters
        ----------
        Index: int
        Mult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Tolerance: float

        Returns
        -------
        bool
        Decrement the multiplicity of <knots(index)> to <mult>. if <mult> is null the knot is removed. //! as there are two ways to compute the new poles the midlle will be used as long as the distance is lower than tolerance. //! if a distance is bigger than tolerance the methods returns false and the new arrays are not modified. //! a low tolerance can be used to test if the knot can be removed without modifying the curve. //! a high tolerance can be used to 'smooth' the curve.

        Parameters
        ----------
        Index: int
        Mult: int
        Degree: int
        Periodic: bool
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        Tolerance: float

        Returns
        -------
        bool

        """
        return _BSplCLib.bsplclib_RemoveKnot(*args)

    @staticmethod
    def Reparametrize(*args) -> "void":
        r"""
        Reparametrizes a b-spline curve to [u1, u2]. the knot values are recomputed such that knots (lower) = u1 and knots (upper) = u2 but the knot form is not modified. warnings : in the array knots the values must be in ascending order. u1 must not be equal to u2 to avoid division by zero.

        Parameters
        ----------
        U1: float
        U2: float
        Knots: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_Reparametrize(*args)

    @staticmethod
    def Resolution(*args) -> "Standard_Real &":
        r"""
        Given a tolerance in 3d space returns a tolerance in u parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < utolerance and we have |f (u1) - f (u0)| < tolerance3d.

        Parameters
        ----------
        ArrayDimension: int
        NumPoles: int
        Weights: TColStd_Array1OfReal *
        FlatKnots: TColStd_Array1OfReal
        Degree: int
        Tolerance3D: float

        Returns
        -------
        PolesArray: float
        UTolerance: float
        Given a tolerance in 3d space returns a tolerance in u parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < utolerance and we have |f (u1) - f (u0)| < tolerance3d.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        NumPoles: int
        FlatKnots: TColStd_Array1OfReal
        Degree: int
        Tolerance3D: float

        Returns
        -------
        UTolerance: float
        Given a tolerance in 3d space returns a tolerance in u parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < utolerance and we have |f (u1) - f (u0)| < tolerance3d.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        NumPoles: int
        FlatKnots: TColStd_Array1OfReal
        Degree: int
        Tolerance3D: float

        Returns
        -------
        UTolerance: float

        """
        return _BSplCLib.bsplclib_Resolution(*args)

    @staticmethod
    def Reverse(*args) -> "void":
        r"""
        Reverses the array knots to become the knots sequence of the reversed curve.

        Parameters
        ----------
        Knots: TColStd_Array1OfReal

        Returns
        -------
        None
        Reverses the array of multiplicities.

        Parameters
        ----------
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        None
        Reverses the array of poles. last is the index of the new first pole. on a non periodic curve last is poles.upper(). on a periodic curve last is //! (number of flat knots - degree - 1) //! or //! (sum of multiplicities(but for the last) + degree - 1).

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt
        Last: int

        Returns
        -------
        None
        Reverses the array of poles.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d
        Last: int

        Returns
        -------
        None
        Reverses the array of poles.

        Parameters
        ----------
        Weights: TColStd_Array1OfReal
        Last: int

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_Reverse(*args)

    @staticmethod
    def SolveBandedSystem(*args) -> "Standard_Integer":
        r"""
        This solves the system matrix.x = b with when matrix is factored in lu form the array is an seen as an array[1..n][1..arraydimension] with n = the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int
        ArrayDimension: int

        Returns
        -------
        Array: float
        This solves the system matrix.x = b with when matrix is factored in lu form the array has the length of the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int
        Array: TColgp_Array1OfPnt2d

        Returns
        -------
        int
        This solves the system matrix.x = b with when matrix is factored in lu form the array has the length of the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int
        Array: TColgp_Array1OfPnt

        Returns
        -------
        int
        No available documentation.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int
        HomogenousFlag: bool
        ArrayDimension: int

        Returns
        -------
        Array: float
        Weights: float
        This solves the system matrix.x = b with when matrix is factored in lu form the array is an seen as an array[1..n][1..arraydimension] with n = the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension. if homogeneousflag == 0 the poles are multiplied by the weights uppon entry and once interpolation is carried over the result of the poles are divided by the result of the interpolation of the weights. otherwise if homogenousflag == 1 the poles and weigths are treated homogenously that is that those are interpolated as they are and result is returned without division by the interpolated weigths.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int
        HomogenousFlag: bool
        Array: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal

        Returns
        -------
        int
        This solves the system matrix.x = b with when matrix is factored in lu form the array is an seen as an array[1..n][1..arraydimension] with n = the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension if homogeneousflag == 0 the poles are multiplied by the weights uppon entry and once interpolation is carried over the result of the poles are divided by the result of the interpolation of the weights. otherwise if homogenousflag == 1 the poles and weigths are treated homogenously that is that those are interpolated as they are and result is returned without division by the interpolated weigths.

        Parameters
        ----------
        Matrix: math_Matrix
        UpperBandWidth: int
        LowerBandWidth: int
        HomogeneousFlag: bool
        Array: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal

        Returns
        -------
        int

        """
        return _BSplCLib.bsplclib_SolveBandedSystem(*args)

    @staticmethod
    def TangExtendToConstraint(*args) -> "Standard_Real &, Standard_Integer &, Standard_Integer &, Standard_Real &, Standard_Real &":
        r"""
        Extend a bspline nd using the tangency map <c1coefficient> is the coefficient of reparametrisation <continuity> must be equal to 1, 2 or 3. <degree> must be greater or equal than <continuity> + 1. //! warning: <knotsresult> and <polesresult> must be dimensionned properly.

        Parameters
        ----------
        FlatKnots: TColStd_Array1OfReal
        C1Coefficient: float
        NumPoles: int
        Dimension: int
        Degree: int
        ConstraintPoint: TColStd_Array1OfReal
        Continuity: int
        After: bool

        Returns
        -------
        Poles: float
        NbPolesResult: int
        NbKnotsRsult: int
        KnotsResult: float
        PolesResult: float

        """
        return _BSplCLib.bsplclib_TangExtendToConstraint(*args)

    @staticmethod
    def Trimming(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Dimension: int
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Poles: TColStd_Array1OfReal
        U1: float
        U2: float
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        NewPoles: TColStd_Array1OfReal

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        U1: float
        U2: float
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        Periodic: bool
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        U1: float
        U2: float
        NewKnots: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_Trimming(*args)

    @staticmethod
    def Unperiodize(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Degree: int
        Dimension: int
        Mults: TColStd_Array1OfInteger
        Knots: TColStd_Array1OfReal
        Poles: TColStd_Array1OfReal
        NewMults: TColStd_Array1OfInteger
        NewKnots: TColStd_Array1OfReal
        NewPoles: TColStd_Array1OfReal

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        Mults: TColStd_Array1OfInteger
        Knots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt
        Weights: TColStd_Array1OfReal *
        NewMults: TColStd_Array1OfInteger
        NewKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array1OfPnt
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Degree: int
        Mults: TColStd_Array1OfInteger
        Knots: TColStd_Array1OfReal
        Poles: TColgp_Array1OfPnt2d
        Weights: TColStd_Array1OfReal *
        NewMults: TColStd_Array1OfInteger
        NewKnots: TColStd_Array1OfReal
        NewPoles: TColgp_Array1OfPnt2d
        NewWeights: TColStd_Array1OfReal *

        Returns
        -------
        None

        """
        return _BSplCLib.bsplclib_Unperiodize(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def DN(self):
    	pass


    def __init__(self):
        _BSplCLib.bsplclib_swiginit(self, _BSplCLib.new_bsplclib())
    __swig_destroy__ = _BSplCLib.delete_bsplclib

# Register bsplclib in _BSplCLib:
_BSplCLib.bsplclib_swigregister(bsplclib)

def bsplclib_AntiBoorScheme(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Compute the content of pole before the boorscheme. this method is used to remove poles. //! u is the poles to remove, knots should contains the knots of the curve after knot removal. //! the first and last poles do not change, the other poles are computed by averaging two possible values. the distance between the two possible poles is computed, if it is higher than <tolerance> false is returned.

    Parameters
    ----------
    U: float
    Degree: int
    Dimension: int
    Depth: int
    Length: int
    Tolerance: float

    Returns
    -------
    Knots: float
    Poles: float

    """
    return _BSplCLib.bsplclib_AntiBoorScheme(*args)

def bsplclib_Bohm(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Performs the bohm algorithm at parameter <u>. this algorithm computes the value and all the derivatives up to order n (n <= degree). //! <poles> is the original array of poles. //! the result in <poles> is the value and the derivatives. poles[0] is the value, poles[degree] is the last derivative.

    Parameters
    ----------
    U: float
    Degree: int
    N: int
    Dimension: int

    Returns
    -------
    Knots: float
    Poles: float

    """
    return _BSplCLib.bsplclib_Bohm(*args)

def bsplclib_BoorIndex(*args) -> "Standard_Integer":
    r"""
    Returns the index in the boor result array of the poles <index>. if the boor algorithm was perform with <length> and <depth>.

    Parameters
    ----------
    Index: int
    Length: int
    Depth: int

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_BoorIndex(*args)

def bsplclib_BoorScheme(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Performs the boor algorithm at parameter <u> with the given <degree> and the array of <knots> on the poles <poles> of dimension <dimension>. the schema is computed until level <depth> on a basis of <length+1> poles. //! * knots is an array of reals of length : //! <length> + <degree> //! * poles is an array of reals of length : //! (2 * <length> + 1) * <dimension> //! the poles values must be set in the array at the positions. //! 0..dimension, //! 2 * dimension .. 3 * dimension //! 4 * dimension .. 5 * dimension //! ... //! the results are found in the array poles depending on the depth. (see the method getpole).

    Parameters
    ----------
    U: float
    Degree: int
    Dimension: int
    Depth: int
    Length: int

    Returns
    -------
    Knots: float
    Poles: float

    """
    return _BSplCLib.bsplclib_BoorScheme(*args)

def bsplclib_BuildBSpMatrix(*args) -> "Standard_Integer &, Standard_Integer &":
    r"""
    This builds a fully blown matrix of (ni) bi (tj) //! with i and j within 1..order + numpoles the integer ni is the ith slot of the array orderarray, tj is the jth slot of the array parameters.

    Parameters
    ----------
    Parameters: TColStd_Array1OfReal
    OrderArray: TColStd_Array1OfInteger
    FlatKnots: TColStd_Array1OfReal
    Degree: int
    Matrix: math_Matrix

    Returns
    -------
    UpperBandWidth: int
    LowerBandWidth: int

    """
    return _BSplCLib.bsplclib_BuildBSpMatrix(*args)

def bsplclib_BuildBoor(*args) -> "Standard_Real &":
    r"""
    Copy in <lp> poles for <dimension> boor scheme. starting from <index> * <dimension>, copy <length+1> poles.

    Parameters
    ----------
    Index: int
    Length: int
    Dimension: int
    Poles: TColStd_Array1OfReal

    Returns
    -------
    LP: float

    """
    return _BSplCLib.bsplclib_BuildBoor(*args)

def bsplclib_BuildCache(*args) -> "void":
    r"""
    Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. if rational computes the homogeneous taylor expension for the numerator and stores it in cachepoles.

    Parameters
    ----------
    U: float
    InverseOfSpanDomain: float
    PeriodicFlag: bool
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    CachePoles: TColgp_Array1OfPnt
    CacheWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. if rational computes the homogeneous taylor expension for the numerator and stores it in cachepoles.

    Parameters
    ----------
    U: float
    InverseOfSpanDomain: float
    PeriodicFlag: bool
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    CachePoles: TColgp_Array1OfPnt2d
    CacheWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. structure of result optimized for bsplclib_cache.

    Parameters
    ----------
    theParameter: float
    theSpanDomain: float
    thePeriodicFlag: bool
    theDegree: int
    theSpanIndex: int
    theFlatKnots: TColStd_Array1OfReal
    thePoles: TColgp_Array1OfPnt
    theWeights: TColStd_Array1OfReal *
    theCacheArray: TColStd_Array2OfReal

    Returns
    -------
    None
    Perform the evaluation of the taylor expansion of the bspline normalized between 0 and 1. structure of result optimized for bsplclib_cache.

    Parameters
    ----------
    theParameter: float
    theSpanDomain: float
    thePeriodicFlag: bool
    theDegree: int
    theSpanIndex: int
    theFlatKnots: TColStd_Array1OfReal
    thePoles: TColgp_Array1OfPnt2d
    theWeights: TColStd_Array1OfReal *
    theCacheArray: TColStd_Array2OfReal

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_BuildCache(*args)

def bsplclib_BuildEval(*args) -> "Standard_Real &":
    r"""
    No available documentation.

    Parameters
    ----------
    Degree: int
    Index: int
    Poles: TColStd_Array1OfReal
    Weights: TColStd_Array1OfReal *

    Returns
    -------
    LP: float
    No available documentation.

    Parameters
    ----------
    Degree: int
    Index: int
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *

    Returns
    -------
    LP: float
    Copy in <lp> the poles and weights for the eval scheme. starting from poles(poles.lower()+index).

    Parameters
    ----------
    Degree: int
    Index: int
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *

    Returns
    -------
    LP: float

    """
    return _BSplCLib.bsplclib_BuildEval(*args)

def bsplclib_BuildKnots(*args) -> "Standard_Real &":
    r"""
    Stores in lk the usefull knots for the boorschem on the span knots(index) - knots(index+1).

    Parameters
    ----------
    Degree: int
    Index: int
    Periodic: bool
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *

    Returns
    -------
    LK: float

    """
    return _BSplCLib.bsplclib_BuildKnots(*args)

def bsplclib_BuildSchoenbergPoints(*args) -> "void":
    r"""
    Builds the schoenberg points from the flat knot used to interpolate a bspline since the bspline matrix is invertible.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_BuildSchoenbergPoints(*args)

def bsplclib_CacheD0(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt

    Returns
    -------
    None
    Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CacheD0(*args)

def bsplclib_CacheD1(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt
    Vec: gp_Vec

    Returns
    -------
    None
    Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d
    Vec: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CacheD1(*args)

def bsplclib_CacheD2(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt
    Vec1: gp_Vec
    Vec2: gp_Vec

    Returns
    -------
    None
    Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d
    Vec1: gp_Vec2d
    Vec2: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CacheD2(*args)

def bsplclib_CacheD3(*args) -> "void":
    r"""
    Perform the evaluation of the of the cache the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights this just evaluates the current point the cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effects.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt
    Vec1: gp_Vec
    Vec2: gp_Vec
    Vec3: gp_Vec

    Returns
    -------
    None
    Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point the parameter must be normalized between the 0 and 1 for the span. the cache must be valid when calling this routine. geom package will insure that. and then multiplies by the weights ththe cacheparameter is where the cache was constructed the spanlength is to normalize the polynomial in the cache to avoid bad conditioning effectsis just evaluates the current point.

    Parameters
    ----------
    U: float
    Degree: int
    CacheParameter: float
    SpanLenght: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d
    Vec1: gp_Vec2d
    Vec2: gp_Vec2d
    Vec3: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CacheD3(*args)

def bsplclib_CoefsD0(*args) -> "void":
    r"""
    Calls cached0 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt

    Returns
    -------
    None
    Calls cached0 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CoefsD0(*args)

def bsplclib_CoefsD1(*args) -> "void":
    r"""
    Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt
    Vec: gp_Vec

    Returns
    -------
    None
    Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d
    Vec: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CoefsD1(*args)

def bsplclib_CoefsD2(*args) -> "void":
    r"""
    Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt
    Vec1: gp_Vec
    Vec2: gp_Vec

    Returns
    -------
    None
    Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d
    Vec1: gp_Vec2d
    Vec2: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CoefsD2(*args)

def bsplclib_CoefsD3(*args) -> "void":
    r"""
    Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt
    Vec1: gp_Vec
    Vec2: gp_Vec
    Vec3: gp_Vec

    Returns
    -------
    None
    Calls cached1 for bezier curves arrays computed with the method polescoefficients. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Point: gp_Pnt2d
    Vec1: gp_Vec2d
    Vec2: gp_Vec2d
    Vec3: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_CoefsD3(*args)

def bsplclib_D0(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColStd_Array1OfReal
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *

    Returns
    -------
    P: float
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    UIndex: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt2d

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_D0(*args)

def bsplclib_D1(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColStd_Array1OfReal
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *

    Returns
    -------
    P: float
    V: float
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt
    V: gp_Vec

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    UIndex: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt2d
    V: gp_Vec2d

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt
    V: gp_Vec

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt2d
    V: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_D1(*args)

def bsplclib_D2(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColStd_Array1OfReal
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *

    Returns
    -------
    P: float
    V1: float
    V2: float
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt
    V1: gp_Vec
    V2: gp_Vec

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    UIndex: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt2d
    V1: gp_Vec2d
    V2: gp_Vec2d

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt
    V1: gp_Vec
    V2: gp_Vec

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt2d
    V1: gp_Vec2d
    V2: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_D2(*args)

def bsplclib_D3(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColStd_Array1OfReal
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *

    Returns
    -------
    P: float
    V1: float
    V2: float
    V3: float
    No available documentation.

    Parameters
    ----------
    U: float
    Index: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt
    V1: gp_Vec
    V2: gp_Vec
    V3: gp_Vec

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    UIndex: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    P: gp_Pnt2d
    V1: gp_Vec2d
    V2: gp_Vec2d
    V3: gp_Vec2d

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt
    V1: gp_Vec
    V2: gp_Vec
    V3: gp_Vec

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    U: float
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    P: gp_Pnt2d
    V1: gp_Vec2d
    V2: gp_Vec2d
    V3: gp_Vec2d

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_D3(*args)

def bsplclib_Derivative(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Computes the poles of the bspline giving the derivatives of order <order>. //! the formula for the first order is //! pole(i) = degree * (pole(i+1) - pole(i)) / (knots(i+degree+1) - knots(i+1)) //! this formula is repeated (degree is decremented at each step).

    Parameters
    ----------
    Degree: int
    Dimension: int
    Length: int
    Order: int

    Returns
    -------
    Knots: float
    Poles: float

    """
    return _BSplCLib.bsplclib_Derivative(*args)

def bsplclib_Eval(*args) -> "Standard_Integer &, Standard_Real &":
    r"""
    Perform the boor algorithm to evaluate a point at parameter <u>, with <degree> and <dimension>. //! poles is an array of reals of size //! <dimension> * <degree>+1 //! containing the poles. at the end <poles> contains the current point.

    Parameters
    ----------
    U: float
    Degree: int
    Dimension: int

    Returns
    -------
    Knots: float
    Poles: float
    Perform the de boor algorithm to evaluate a point at parameter <u>, with <degree> and <dimension>. //! poles is an array of reals of size //! <dimension> * <degree>+1 //! containing the poles. at the end <poles> contains the current point. poles contain all the poles of the bsplinecurve, knots also contains all the knots of the bsplinecurve. extrapmode has two slots [0] = degree used to extrapolate before the first knot [1] = degre used to extrapolate after the last knot has to be between 1 and degree.

    Parameters
    ----------
    U: float
    PeriodicFlag: bool
    DerivativeRequest: int
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    ArrayDimension: int

    Returns
    -------
    ExtrapMode: int
    Poles: float
    Result: float
    Perform the de boor algorithm to evaluate a point at parameter <u>, with <degree> and <dimension>. evaluates by multiplying the poles by the weights and gives the homogeneous result in polesresult that is the results of the evaluation of the numerator once it has been multiplied by the weights and in weightsresult one has the result of the evaluation of the denominator //! warning: <polesresult> and <weightsresult> must be dimensionned properly.

    Parameters
    ----------
    U: float
    PeriodicFlag: bool
    DerivativeRequest: int
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    ArrayDimension: int

    Returns
    -------
    ExtrapMode: int
    Poles: float
    Weights: float
    PolesResult: float
    WeightsResult: float
    Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point.

    Parameters
    ----------
    U: float
    PeriodicFlag: bool
    HomogeneousFlag: bool
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal
    Point: gp_Pnt

    Returns
    -------
    ExtrapMode: int
    Weight: float
    Perform the evaluation of the bspline basis and then multiplies by the weights this just evaluates the current point.

    Parameters
    ----------
    U: float
    PeriodicFlag: bool
    HomogeneousFlag: bool
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal
    Point: gp_Pnt2d

    Returns
    -------
    ExtrapMode: int
    Weight: float

    """
    return _BSplCLib.bsplclib_Eval(*args)

def bsplclib_EvalBsplineBasis(*args) -> "Standard_Integer &":
    r"""
    This evaluates the bspline basis at a given parameter parameter up to the requested derivativeorder and store the result in the array bsplinebasis in the following fashion bsplinebasis(1,1) = value of first non vanishing bspline function which has index firstnonzerobsplineindex bsplinebasis(1,2) = value of second non vanishing bspline function which has index firstnonzerobsplineindex + 1 bsplinebasis(1,n) = value of second non vanishing non vanishing bspline function which has index firstnonzerobsplineindex + n (n <= order) bsplinebasis(2,1) = value of derivative of first non vanishing bspline function which has index firstnonzerobsplineindex bsplinebasis(n,1) = value of nth derivative of first non vanishing bspline function which has index firstnonzerobsplineindex if n <= derivativeorder + 1.

    Parameters
    ----------
    DerivativeOrder: int
    Order: int
    FlatKnots: TColStd_Array1OfReal
    Parameter: float
    BsplineBasis: math_Matrix
    isPeriodic: bool,optional
    	default value is Standard_False

    Returns
    -------
    FirstNonZeroBsplineIndex: int

    """
    return _BSplCLib.bsplclib_EvalBsplineBasis(*args)

def bsplclib_FactorBandedMatrix(*args) -> "Standard_Integer &":
    r"""
    This factors the banded matrix in the lu form with a banded storage of components of the l matrix warning : do not use if the matrix is totally positive (it is the case for bspline matrices build as above with parameters being the schoenberg points.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int

    Returns
    -------
    PivotIndexProblem: int

    """
    return _BSplCLib.bsplclib_FactorBandedMatrix(*args)

def bsplclib_FirstUKnotIndex(*args) -> "Standard_Integer":
    r"""
    Computes the index of the knots value which gives the start point of the curve.

    Parameters
    ----------
    Degree: int
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_FirstUKnotIndex(*args)

def bsplclib_FlatBezierKnots(*args) -> "Standard_Real const &":
    r"""
    Returns pointer to statically allocated array representing flat knots for bezier curve of the specified degree. raises outofrange if degree > maxdegree().

    Parameters
    ----------
    Degree: int

    Returns
    -------
    float

    """
    return _BSplCLib.bsplclib_FlatBezierKnots(*args)

def bsplclib_FlatIndex(*args) -> "Standard_Integer":
    r"""
    Computes the index of the flats knots sequence corresponding to <index> in the knots sequence which multiplicities are <mults>.

    Parameters
    ----------
    Degree: int
    Index: int
    Mults: TColStd_Array1OfInteger
    Periodic: bool

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_FlatIndex(*args)

def bsplclib_FunctionMultiply(*args) -> "Standard_Integer &":
    r"""
    This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    PolesDimension: int
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int

    Returns
    -------
    Poles: float
    NewPoles: float
    theStatus: int
    This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    Poles: TColStd_Array1OfReal
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int
    NewPoles: TColStd_Array1OfReal

    Returns
    -------
    theStatus: int
    This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt2d
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int
    NewPoles: TColgp_Array1OfPnt2d

    Returns
    -------
    theStatus: int
    This will multiply a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] by a function a(t) which is assumed to satisfy the following : 1. a(t) * f(t) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. the range of a(t) is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of a(t)*f(t).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int
    NewPoles: TColgp_Array1OfPnt

    Returns
    -------
    theStatus: int

    """
    return _BSplCLib.bsplclib_FunctionMultiply(*args)

def bsplclib_FunctionReparameterise(*args) -> "Standard_Integer &":
    r"""
    This function will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following: //! 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots //! 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) //! warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method //! thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    PolesDimension: int
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int

    Returns
    -------
    Poles: float
    NewPoles: float
    theStatus: int
    This function will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following: //! 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots //! 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) //! warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method //! thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    Poles: TColStd_Array1OfReal
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int
    NewPoles: TColStd_Array1OfReal

    Returns
    -------
    theStatus: int
    This will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following : 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int
    NewPoles: TColgp_Array1OfPnt

    Returns
    -------
    theStatus: int
    This will compose a given vectorial bspline f(t) defined by its bsplinedegree and bsplineflatknotsl, its poles array which are coded as an array of real of the form [1..numpoles][1..polesdimension] with a function a(t) which is assumed to satisfy the following : 1. f(a(t)) is a polynomial bspline that can be expressed exactly as a bspline of degree newdegree on the knots flatknots 2. a(t) defines a differentiable isomorphism between the range of flatknots to the range of bsplineflatknots which is the same as the range of f(t) warning: it is the caller's responsability to insure that conditions 1. and 2. above are satisfied : no check whatsoever is made in this method thestatus will return 0 if ok else it will return the pivot index of the matrix that was inverted to compute the multiplied bspline : the method used is interpolation at schoenenberg points of f(a(t)).

    Parameters
    ----------
    Function: BSplCLib_EvaluatorFunction
    BSplineDegree: int
    BSplineFlatKnots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt2d
    FlatKnots: TColStd_Array1OfReal
    NewDegree: int
    NewPoles: TColgp_Array1OfPnt2d

    Returns
    -------
    theStatus: int

    """
    return _BSplCLib.bsplclib_FunctionReparameterise(*args)

def bsplclib_GetPole(*args) -> "Standard_Real &, Standard_Integer &":
    r"""
    Copy the pole at position <index> in the boor scheme of dimension <dimension> to <position> in the array <pole>. <position> is updated.

    Parameters
    ----------
    Index: int
    Length: int
    Depth: int
    Dimension: int
    Pole: TColStd_Array1OfReal

    Returns
    -------
    LocPoles: float
    Position: int

    """
    return _BSplCLib.bsplclib_GetPole(*args)

def bsplclib_Hunt(*args) -> "Standard_Integer &":
    r"""
    This routine searches the position of the real value thex in the monotonically increasing set of real values thearray using bisection algorithm. //! if the given value is out of range or array values, algorithm returns either thearray.lower()-1 or thearray.upper()+1 depending on thex position in the ordered set. //! this routine is used to locate a knot value in a set of knots.

    Parameters
    ----------
    theArray: TColStd_Array1OfReal
    theX: float

    Returns
    -------
    theXPos: int

    """
    return _BSplCLib.bsplclib_Hunt(*args)

def bsplclib_IncreaseDegree(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Degree: int
    NewDegree: int
    Periodic: bool
    Dimension: int
    Poles: TColStd_Array1OfReal
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColStd_Array1OfReal
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    NewDegree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    NewDegree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    NewDegree: int
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    Increase the degree of a bspline (or bezier) curve of dimension <dimension> form <degree> to <newdegree>. //! the number of poles in the new curve is : //! poles.length() + (newdegree - degree) * number of spans //! where the number of spans is : //! lastuknotindex(mults) - firstuknotindex(mults) + 1 //! for a non-periodic curve //! and knots.length() - 1 for a periodic curve. //! the multiplicities of all knots are increased by the degree elevation. //! the new knots are usually the same knots with the exception of a non-periodic curve with the first and last multiplicity not equal to degree+1 where knots are removed form the start and the bottom untils the sum of the multiplicities is equal to newdegree+1 at the knots corresponding to the first and last parameters of the curve. //! example : suppose a curve of degree 3 starting with following knots and multiplicities : //! knot : 0. 1. 2. mult : 1 2 1 //! the firstuknot is 2. because the sum of multiplicities is degree+1 : 1 + 2 + 1 = 4 = 3 + 1 //! i.e. the first parameter of the curve is 2. and will still be 2. after degree elevation. let raises this curve to degree 4. the multiplicities are increased by 2. //! they become 2 3 2. but we need a sum of multiplicities of 5 at knot 2. so the first knot is removed and the new knots are : //! knot : 1. 2. mult : 3 2 //! the multipicity of the first knot may also be reduced if the sum is still to big. //! in the most common situations (periodic curve or curve with first and last multiplicities equals to degree+1) the knots are knot changes. //! the method increasedegreecountknots can be used to compute the new number of knots.

    Parameters
    ----------
    NewDegree: int
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_IncreaseDegree(*args)

def bsplclib_IncreaseDegreeCountKnots(*args) -> "Standard_Integer":
    r"""
    Returns the number of knots of a curve with multiplicities <mults> after elevating the degree from <degree> to <newdegree>. see the increasedegree method for more comments.

    Parameters
    ----------
    Degree: int
    NewDegree: int
    Periodic: bool
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_IncreaseDegreeCountKnots(*args)

def bsplclib_InsertKnot(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    UIndex: int
    U: float
    UMult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    Insert a new knot u of multiplicity umult in the knot sequence. //! the location of the new knot should be given as an input data. uindex locates the new knot u in the knot sequence and knots (uindex) < u < knots (uindex + 1). //! the new control points corresponding to this insertion are returned. knots and mults are not updated.

    Parameters
    ----------
    UIndex: int
    U: float
    UMult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_InsertKnot(*args)

def bsplclib_InsertKnots(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Dimension: int
    Poles: TColStd_Array1OfReal
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    AddKnots: TColStd_Array1OfReal
    AddMults: TColStd_Array1OfInteger *
    NewPoles: TColStd_Array1OfReal
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Epsilon: float
    Add: bool,optional
    	default value is Standard_True

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    AddKnots: TColStd_Array1OfReal
    AddMults: TColStd_Array1OfInteger *
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Epsilon: float
    Add: bool,optional
    	default value is Standard_True

    Returns
    -------
    None
    Insert a sequence of knots <addknots> with multiplicities <addmults>. <addknots> must be a non decreasing sequence and verifies : //! knots(knots.lower()) <= addknots(addknots.lower()) knots(knots.upper()) >= addknots(addknots.upper()) //! the newpoles and newweights arrays must have a length : poles.length() + sum(addmults()) //! when a knot to insert is identic to an existing knot the multiplicities are added. //! epsilon is used to test knots for equality. //! when addmult is negative or null the knot is not inserted. no multiplicity will becomes higher than the degree. //! the new knots and multiplicities are copied in <newknots> and <newmults>. //! all the new arrays should be correctly dimensioned. //! when all the new knots are existing knots, i.e. only the multiplicities will change it is safe to use the same arrays as input and output.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    AddKnots: TColStd_Array1OfReal
    AddMults: TColStd_Array1OfInteger *
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Epsilon: float
    Add: bool,optional
    	default value is Standard_True

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_InsertKnots(*args)

def bsplclib_Interpolate(*args) -> "Standard_Real &, Standard_Real &, Standard_Integer &":
    r"""
    Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation or interpolation at scheonberg points the method will work the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal
    ContactOrderArray: TColStd_Array1OfInteger
    Poles: TColgp_Array1OfPnt

    Returns
    -------
    InversionProblem: int
    Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem w ll report 0 if there was no problem else it will give the index of the faulty pivot.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal
    ContactOrderArray: TColStd_Array1OfInteger
    Poles: TColgp_Array1OfPnt2d

    Returns
    -------
    InversionProblem: int
    Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal
    ContactOrderArray: TColStd_Array1OfInteger
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal

    Returns
    -------
    InversionProblem: int
    Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray, poles, the length of flatknots is degree + l + 1 warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation at knots or interpolation at scheonberg points the method will work. the inversionproblem w ll report 0 if there was no problem else it will give the i.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal
    ContactOrderArray: TColStd_Array1OfInteger
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal

    Returns
    -------
    InversionProblem: int
    Performs the interpolation of the data given in the poles array according to the requests in contactorderarray that is :  if contactorderarray(i) has value d it means that poles(i) containes the dth derivative of the function to be interpolated. the length l of the following arrays must be the same : parameters, contactorderarray the length of flatknots is degree + l + 1 the polesarray is an seen as an array[1..n][1..arraydimension] with n = tge length of the parameters array warning: the method used to do that interpolation is gauss elimination without pivoting. thus if the diagonal is not dominant there is no guarantee that the algorithm will work. nevertheless for cubic interpolation or interpolation at scheonberg points the method will work the inversionproblem will report 0 if there was no problem else it will give the index of the faulty pivot.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal
    ContactOrderArray: TColStd_Array1OfInteger
    ArrayDimension: int

    Returns
    -------
    Poles: float
    InversionProblem: int
    No available documentation.

    Parameters
    ----------
    Degree: int
    FlatKnots: TColStd_Array1OfReal
    Parameters: TColStd_Array1OfReal
    ContactOrderArray: TColStd_Array1OfInteger
    ArrayDimension: int

    Returns
    -------
    Poles: float
    Weights: float
    InversionProblem: int

    """
    return _BSplCLib.bsplclib_Interpolate(*args)

def bsplclib_IsRational(*args) -> "Standard_Boolean":
    r"""
    Returns false if all the weights of the array <weights> between i1 an i2 are identic. epsilon is used for comparing weights. if epsilon is 0. the epsilon of the first weight is used.

    Parameters
    ----------
    Weights: TColStd_Array1OfReal
    I1: int
    I2: int
    Epsilon: float,optional
    	default value is 0.0

    Returns
    -------
    bool

    """
    return _BSplCLib.bsplclib_IsRational(*args)

def bsplclib_KnotAnalysis(*args) -> "Standard_Integer &":
    r"""
    Analyzes the array of knots. returns the form and the maximum knot multiplicity.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    CKnots: TColStd_Array1OfReal
    CMults: TColStd_Array1OfInteger
    KnotForm: GeomAbs_BSplKnotDistribution

    Returns
    -------
    MaxKnotMult: int

    """
    return _BSplCLib.bsplclib_KnotAnalysis(*args)

def bsplclib_KnotForm(*args) -> "BSplCLib_KnotDistribution":
    r"""
    Analyses if the knots distribution is 'uniform' or 'nonuniform' between the knot fromk1 and the knot tok2. there is no repetition of knot in the knots'sequence <knots>.

    Parameters
    ----------
    Knots: TColStd_Array1OfReal
    FromK1: int
    ToK2: int

    Returns
    -------
    BSplCLib_KnotDistribution

    """
    return _BSplCLib.bsplclib_KnotForm(*args)

def bsplclib_KnotSequence(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    KnotSeq: TColStd_Array1OfReal
    Periodic: bool,optional
    	default value is Standard_False

    Returns
    -------
    None
    Computes the sequence of knots knotseq with repetition of the knots of multiplicity greater than 1. //! length of knotseq must be knotsequencelength(mults,degree,periodic).

    Parameters
    ----------
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    Degree: int
    Periodic: bool
    KnotSeq: TColStd_Array1OfReal

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_KnotSequence(*args)

def bsplclib_KnotSequenceLength(*args) -> "Standard_Integer":
    r"""
    Returns the length of the sequence of knots with repetition. //! periodic : //! sum(mults(i), i = mults.lower(); i <= mults.upper()); //! non periodic : //! sum(mults(i); i = mults.lower(); i < mults.upper()) + 2 * degree.

    Parameters
    ----------
    Mults: TColStd_Array1OfInteger
    Degree: int
    Periodic: bool

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_KnotSequenceLength(*args)

def bsplclib_Knots(*args) -> "void":
    r"""
    Computes the sequence of knots knots without repetition of the knots of multiplicity greater than 1. //! length of <knots> and <mults> must be knotslength(knotsequence,periodic).

    Parameters
    ----------
    KnotSeq: TColStd_Array1OfReal
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    Periodic: bool,optional
    	default value is Standard_False

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_Knots(*args)

def bsplclib_KnotsLength(*args) -> "Standard_Integer":
    r"""
    Returns the length of the sequence of knots (and mults) without repetition.

    Parameters
    ----------
    KnotSeq: TColStd_Array1OfReal
    Periodic: bool,optional
    	default value is Standard_False

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_KnotsLength(*args)

def bsplclib_LastUKnotIndex(*args) -> "Standard_Integer":
    r"""
    Computes the index of the knots value which gives the end point of the curve.

    Parameters
    ----------
    Degree: int
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_LastUKnotIndex(*args)

def bsplclib_LocateParameter(*args) -> "Standard_Integer &, Standard_Real &":
    r"""
    Locates the parametric value u in the knots sequence between the knot k1 and the knot k2. the value return in index verifies. //! knots(index) <= u < knots(index + 1) if u <= knots (k1) then index = k1 if u >= knots (k2) then index = k2 - 1 //! if periodic is true u may be modified to fit in the range knots(k1), knots(k2). in any case the correct value is returned in newu. //! warnings :index is used as input data to initialize the searching function. warning: knots have to be 'withe repetitions'.

    Parameters
    ----------
    Degree: int
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    U: float
    IsPeriodic: bool
    FromK1: int
    ToK2: int

    Returns
    -------
    KnotIndex: int
    NewU: float
    Locates the parametric value u in the knots sequence between the knot k1 and the knot k2. the value return in index verifies. //! knots(index) <= u < knots(index + 1) if u <= knots (k1) then index = k1 if u >= knots (k2) then index = k2 - 1 //! if periodic is true u may be modified to fit in the range knots(k1), knots(k2). in any case the correct value is returned in newu. //! warnings :index is used as input data to initialize the searching function. warning: knots have to be 'flat'.

    Parameters
    ----------
    Degree: int
    Knots: TColStd_Array1OfReal
    U: float
    IsPeriodic: bool
    FromK1: int
    ToK2: int

    Returns
    -------
    KnotIndex: int
    NewU: float
    No available documentation.

    Parameters
    ----------
    Degree: int
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger *
    U: float
    Periodic: bool

    Returns
    -------
    Index: int
    NewU: float

    """
    return _BSplCLib.bsplclib_LocateParameter(*args)

def bsplclib_MaxDegree(*args) -> "Standard_Integer":
    r"""
    Returns the degree maxima for a bsplinecurve.

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_MaxDegree(*args)

def bsplclib_MaxKnotMult(*args) -> "Standard_Integer":
    r"""
    Finds the greatest multiplicity in a set of knots between k1 and k2. mults is the multiplicity associated with each knot value.

    Parameters
    ----------
    Mults: TColStd_Array1OfInteger
    K1: int
    K2: int

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_MaxKnotMult(*args)

def bsplclib_MergeBSplineKnots(*args) -> "Standard_Integer &":
    r"""
    Merges two knot vector by setting the starting and ending values to startvalue and endvalue.

    Parameters
    ----------
    Tolerance: float
    StartValue: float
    EndValue: float
    Degree1: int
    Knots1: TColStd_Array1OfReal
    Mults1: TColStd_Array1OfInteger
    Degree2: int
    Knots2: TColStd_Array1OfReal
    Mults2: TColStd_Array1OfInteger
    NewKnots: TColStd_HArray1OfReal
    NewMults: TColStd_HArray1OfInteger

    Returns
    -------
    NumPoles: int

    """
    return _BSplCLib.bsplclib_MergeBSplineKnots(*args)

def bsplclib_MinKnotMult(*args) -> "Standard_Integer":
    r"""
    Finds the lowest multiplicity in a set of knots between k1 and k2. mults is the multiplicity associated with each knot value.

    Parameters
    ----------
    Mults: TColStd_Array1OfInteger
    K1: int
    K2: int

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_MinKnotMult(*args)

def bsplclib_MovePoint(*args) -> "Standard_Integer &, Standard_Integer &":
    r"""
    Find the new poles which allows an old point (with a given u as parameter) to reach a new position index1 and index2 indicate the range of poles we can move (1, nbpoles-1) or (2, nbpoles) -> no constraint for one side don't enter (1,nbpoles) -> error: rigid move (2, nbpoles-1) -> the ends are enforced (3, nbpoles-2) -> the ends and the tangency are enforced if problem in bsplinebasis calculation, no change for the curve and firstindex, lastindex = 0.

    Parameters
    ----------
    U: float
    Displ: gp_Vec2d
    Index1: int
    Index2: int
    Degree: int
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    FlatKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array1OfPnt2d

    Returns
    -------
    FirstIndex: int
    LastIndex: int
    Find the new poles which allows an old point (with a given u as parameter) to reach a new position index1 and index2 indicate the range of poles we can move (1, nbpoles-1) or (2, nbpoles) -> no constraint for one side don't enter (1,nbpoles) -> error: rigid move (2, nbpoles-1) -> the ends are enforced (3, nbpoles-2) -> the ends and the tangency are enforced if problem in bsplinebasis calculation, no change for the curve and firstindex, lastindex = 0.

    Parameters
    ----------
    U: float
    Displ: gp_Vec
    Index1: int
    Index2: int
    Degree: int
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    FlatKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array1OfPnt

    Returns
    -------
    FirstIndex: int
    LastIndex: int

    """
    return _BSplCLib.bsplclib_MovePoint(*args)

def bsplclib_MovePointAndTangent(*args) -> "Standard_Integer &":
    r"""
    This is the dimension free version of the utility u is the parameter must be within the first flatknots and the last flatknots delta is the amount the curve has to be moved deltaderivative is the amount the derivative has to be moved. delta and deltaderivative must be array of dimension arraydimension degree is the degree of the bspline and the flatknots are the knots of the bspline starting condition if = -1 means the starting point of the curve can move = 0 means the starting point of the cuve cannot move but tangen starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... same holds for endingcondition poles are the poles of the curve weights are the weights of the curve if not null newpoles are the poles of the deformed curve errorstatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions the way to solve this problem is to add knots to the bspline if startcondition = 1 and endcondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a c1 cubic you will need have at least 2 internal knots.

    Parameters
    ----------
    U: float
    ArrayDimension: int
    Tolerance: float
    Degree: int
    StartingCondition: int
    EndingCondition: int
    Weights: TColStd_Array1OfReal *
    FlatKnots: TColStd_Array1OfReal

    Returns
    -------
    Delta: float
    DeltaDerivative: float
    Poles: float
    NewPoles: float
    ErrorStatus: int
    This is the dimension free version of the utility u is the parameter must be within the first flatknots and the last flatknots delta is the amount the curve has to be moved deltaderivative is the amount the derivative has to be moved. delta and deltaderivative must be array of dimension arraydimension degree is the degree of the bspline and the flatknots are the knots of the bspline starting condition if = -1 means the starting point of the curve can move = 0 means the starting point of the cuve cannot move but tangen starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... same holds for endingcondition poles are the poles of the curve weights are the weights of the curve if not null newpoles are the poles of the deformed curve errorstatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions the way to solve this problem is to add knots to the bspline if startcondition = 1 and endcondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a c1 cubic you will need have at least 2 internal knots.

    Parameters
    ----------
    U: float
    Delta: gp_Vec
    DeltaDerivative: gp_Vec
    Tolerance: float
    Degree: int
    StartingCondition: int
    EndingCondition: int
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    FlatKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array1OfPnt

    Returns
    -------
    ErrorStatus: int
    This is the dimension free version of the utility u is the parameter must be within the first flatknots and the last flatknots delta is the amount the curve has to be moved deltaderivative is the amount the derivative has to be moved. delta and deltaderivative must be array of dimension arraydimension degree is the degree of the bspline and the flatknots are the knots of the bspline starting condition if = -1 means the starting point of the curve can move = 0 means the starting point of the cuve cannot move but tangen starting point of the curve cannot move = 1 means the starting point and tangents cannot move = 2 means the starting point tangent and curvature cannot move = ... same holds for endingcondition poles are the poles of the curve weights are the weights of the curve if not null newpoles are the poles of the deformed curve errorstatus will be 0 if no error happened 1 if there are not enough knots/poles the imposed conditions the way to solve this problem is to add knots to the bspline if startcondition = 1 and endcondition = 1 then you need at least 4 + 2 = 6 poles so for example to have a c1 cubic you will need have at least 2 internal knots.

    Parameters
    ----------
    U: float
    Delta: gp_Vec2d
    DeltaDerivative: gp_Vec2d
    Tolerance: float
    Degree: int
    StartingCondition: int
    EndingCondition: int
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    FlatKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array1OfPnt2d

    Returns
    -------
    ErrorStatus: int

    """
    return _BSplCLib.bsplclib_MovePointAndTangent(*args)

def bsplclib_MultForm(*args) -> "BSplCLib_MultDistribution":
    r"""
    Analyses the distribution of multiplicities between the knot fromk1 and the knot tok2.

    Parameters
    ----------
    Mults: TColStd_Array1OfInteger
    FromK1: int
    ToK2: int

    Returns
    -------
    BSplCLib_MultDistribution

    """
    return _BSplCLib.bsplclib_MultForm(*args)

def bsplclib_NbPoles(*args) -> "Standard_Integer":
    r"""
    Returns the number of poles of the curve. returns 0 if one of the multiplicities is incorrect. //! * non positive. //! * greater than degree, or degree+1 at the first and last knot of a non periodic curve. //! * the last periodicity on a periodic curve is not equal to the first.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_NbPoles(*args)

def bsplclib_NoMults(*args) -> "TColStd_Array1OfInteger *":
    r"""
    Used as argument for a flatknots evaluation.

    Returns
    -------
    TColStd_Array1OfInteger *

    """
    return _BSplCLib.bsplclib_NoMults(*args)

def bsplclib_NoWeights(*args) -> "TColStd_Array1OfReal *":
    r"""
    Used as argument for a non rational curve.

    Returns
    -------
    TColStd_Array1OfReal *

    """
    return _BSplCLib.bsplclib_NoWeights(*args)

def bsplclib_PoleIndex(*args) -> "Standard_Integer":
    r"""
    Return the index of the first pole to use on the span mults(index) - mults(index+1). this index must be added to poles.lower().

    Parameters
    ----------
    Degree: int
    Index: int
    Periodic: bool
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_PoleIndex(*args)

def bsplclib_PolesCoefficients(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt2d
    CachePoles: TColgp_Array1OfPnt2d

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    CachePoles: TColgp_Array1OfPnt2d
    CacheWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt
    CachePoles: TColgp_Array1OfPnt

    Returns
    -------
    None
    Encapsulation of buildcache to perform the evaluation of the taylor expansion for beziercurves at parameter 0. warning: to be used for beziercurves only!!!.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    CachePoles: TColgp_Array1OfPnt
    CacheWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_PolesCoefficients(*args)

def bsplclib_PrepareInsertKnots(*args) -> "Standard_Integer &, Standard_Integer &":
    r"""
    Returns in <nbpoles, nbknots> the new number of poles and knots if the sequence of knots <addknots, addmults> is inserted in the sequence <knots, mults>. //! epsilon is used to compare knots for equality. //! if add is true the multiplicities on equal knots are added. //! if add is false the max value of the multiplicities is kept. //! return false if : the knew knots are knot increasing. the new knots are not in the range.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    AddKnots: TColStd_Array1OfReal
    AddMults: TColStd_Array1OfInteger *
    Epsilon: float
    Add: bool,optional
    	default value is Standard_True

    Returns
    -------
    NbPoles: int
    NbKnots: int

    """
    return _BSplCLib.bsplclib_PrepareInsertKnots(*args)

def bsplclib_PrepareTrimming(*args) -> "Standard_Integer &, Standard_Integer &":
    r"""
    Set in <nbknots> and <nbpoles> the number of knots and poles of the curve resulting of the trimming of the bsplinecurve definded with <degree>, <knots>, <mults>.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    U1: float
    U2: float

    Returns
    -------
    NbKnots: int
    NbPoles: int

    """
    return _BSplCLib.bsplclib_PrepareTrimming(*args)

def bsplclib_PrepareUnperiodize(*args) -> "Standard_Integer &, Standard_Integer &":
    r"""
    Set in <nbknots> and <nbpolestoadd> the number of knots and poles of the notperiodic curve identical at the periodic curve with a degree <degree> , a knots-distribution with multiplicities <mults>.

    Parameters
    ----------
    Degree: int
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    NbKnots: int
    NbPoles: int

    """
    return _BSplCLib.bsplclib_PrepareUnperiodize(*args)

def bsplclib_RaiseMultiplicity(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    KnotIndex: int
    Mult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    Raise the multiplicity of knot to <umult>. //! the new control points are returned. knots and mults are not updated.

    Parameters
    ----------
    KnotIndex: int
    Mult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_RaiseMultiplicity(*args)

def bsplclib_RemoveKnot(*args) -> "Standard_Boolean":
    r"""
    No available documentation.

    Parameters
    ----------
    Index: int
    Mult: int
    Degree: int
    Periodic: bool
    Dimension: int
    Poles: TColStd_Array1OfReal
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColStd_Array1OfReal
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Tolerance: float

    Returns
    -------
    bool
    No available documentation.

    Parameters
    ----------
    Index: int
    Mult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Tolerance: float

    Returns
    -------
    bool
    Decrement the multiplicity of <knots(index)> to <mult>. if <mult> is null the knot is removed. //! as there are two ways to compute the new poles the midlle will be used as long as the distance is lower than tolerance. //! if a distance is bigger than tolerance the methods returns false and the new arrays are not modified. //! a low tolerance can be used to test if the knot can be removed without modifying the curve. //! a high tolerance can be used to 'smooth' the curve.

    Parameters
    ----------
    Index: int
    Mult: int
    Degree: int
    Periodic: bool
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    Tolerance: float

    Returns
    -------
    bool

    """
    return _BSplCLib.bsplclib_RemoveKnot(*args)

def bsplclib_Reparametrize(*args) -> "void":
    r"""
    Reparametrizes a b-spline curve to [u1, u2]. the knot values are recomputed such that knots (lower) = u1 and knots (upper) = u2 but the knot form is not modified. warnings : in the array knots the values must be in ascending order. u1 must not be equal to u2 to avoid division by zero.

    Parameters
    ----------
    U1: float
    U2: float
    Knots: TColStd_Array1OfReal

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_Reparametrize(*args)

def bsplclib_Resolution(*args) -> "Standard_Real &":
    r"""
    Given a tolerance in 3d space returns a tolerance in u parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < utolerance and we have |f (u1) - f (u0)| < tolerance3d.

    Parameters
    ----------
    ArrayDimension: int
    NumPoles: int
    Weights: TColStd_Array1OfReal *
    FlatKnots: TColStd_Array1OfReal
    Degree: int
    Tolerance3D: float

    Returns
    -------
    PolesArray: float
    UTolerance: float
    Given a tolerance in 3d space returns a tolerance in u parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < utolerance and we have |f (u1) - f (u0)| < tolerance3d.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    NumPoles: int
    FlatKnots: TColStd_Array1OfReal
    Degree: int
    Tolerance3D: float

    Returns
    -------
    UTolerance: float
    Given a tolerance in 3d space returns a tolerance in u parameter space such that all u1 and u0 in the domain of the curve f(u) | u1 - u0 | < utolerance and we have |f (u1) - f (u0)| < tolerance3d.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    NumPoles: int
    FlatKnots: TColStd_Array1OfReal
    Degree: int
    Tolerance3D: float

    Returns
    -------
    UTolerance: float

    """
    return _BSplCLib.bsplclib_Resolution(*args)

def bsplclib_Reverse(*args) -> "void":
    r"""
    Reverses the array knots to become the knots sequence of the reversed curve.

    Parameters
    ----------
    Knots: TColStd_Array1OfReal

    Returns
    -------
    None
    Reverses the array of multiplicities.

    Parameters
    ----------
    Mults: TColStd_Array1OfInteger

    Returns
    -------
    None
    Reverses the array of poles. last is the index of the new first pole. on a non periodic curve last is poles.upper(). on a periodic curve last is //! (number of flat knots - degree - 1) //! or //! (sum of multiplicities(but for the last) + degree - 1).

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt
    Last: int

    Returns
    -------
    None
    Reverses the array of poles.

    Parameters
    ----------
    Poles: TColgp_Array1OfPnt2d
    Last: int

    Returns
    -------
    None
    Reverses the array of poles.

    Parameters
    ----------
    Weights: TColStd_Array1OfReal
    Last: int

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_Reverse(*args)

def bsplclib_SolveBandedSystem(*args) -> "Standard_Integer":
    r"""
    This solves the system matrix.x = b with when matrix is factored in lu form the array is an seen as an array[1..n][1..arraydimension] with n = the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int
    ArrayDimension: int

    Returns
    -------
    Array: float
    This solves the system matrix.x = b with when matrix is factored in lu form the array has the length of the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int
    Array: TColgp_Array1OfPnt2d

    Returns
    -------
    int
    This solves the system matrix.x = b with when matrix is factored in lu form the array has the length of the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int
    Array: TColgp_Array1OfPnt

    Returns
    -------
    int
    No available documentation.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int
    HomogenousFlag: bool
    ArrayDimension: int

    Returns
    -------
    Array: float
    Weights: float
    This solves the system matrix.x = b with when matrix is factored in lu form the array is an seen as an array[1..n][1..arraydimension] with n = the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension. if homogeneousflag == 0 the poles are multiplied by the weights uppon entry and once interpolation is carried over the result of the poles are divided by the result of the interpolation of the weights. otherwise if homogenousflag == 1 the poles and weigths are treated homogenously that is that those are interpolated as they are and result is returned without division by the interpolated weigths.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int
    HomogenousFlag: bool
    Array: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal

    Returns
    -------
    int
    This solves the system matrix.x = b with when matrix is factored in lu form the array is an seen as an array[1..n][1..arraydimension] with n = the rank of the matrix matrix. the result is stored in array when each coordinate is solved that is b is the array whose values are b[i] = array[i][p] for each p in 1..arraydimension if homogeneousflag == 0 the poles are multiplied by the weights uppon entry and once interpolation is carried over the result of the poles are divided by the result of the interpolation of the weights. otherwise if homogenousflag == 1 the poles and weigths are treated homogenously that is that those are interpolated as they are and result is returned without division by the interpolated weigths.

    Parameters
    ----------
    Matrix: math_Matrix
    UpperBandWidth: int
    LowerBandWidth: int
    HomogeneousFlag: bool
    Array: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal

    Returns
    -------
    int

    """
    return _BSplCLib.bsplclib_SolveBandedSystem(*args)

def bsplclib_TangExtendToConstraint(*args) -> "Standard_Real &, Standard_Integer &, Standard_Integer &, Standard_Real &, Standard_Real &":
    r"""
    Extend a bspline nd using the tangency map <c1coefficient> is the coefficient of reparametrisation <continuity> must be equal to 1, 2 or 3. <degree> must be greater or equal than <continuity> + 1. //! warning: <knotsresult> and <polesresult> must be dimensionned properly.

    Parameters
    ----------
    FlatKnots: TColStd_Array1OfReal
    C1Coefficient: float
    NumPoles: int
    Dimension: int
    Degree: int
    ConstraintPoint: TColStd_Array1OfReal
    Continuity: int
    After: bool

    Returns
    -------
    Poles: float
    NbPolesResult: int
    NbKnotsRsult: int
    KnotsResult: float
    PolesResult: float

    """
    return _BSplCLib.bsplclib_TangExtendToConstraint(*args)

def bsplclib_Trimming(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Dimension: int
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    Poles: TColStd_Array1OfReal
    U1: float
    U2: float
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    NewPoles: TColStd_Array1OfReal

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    U1: float
    U2: float
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    Periodic: bool
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    U1: float
    U2: float
    NewKnots: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_Trimming(*args)

def bsplclib_Unperiodize(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Degree: int
    Dimension: int
    Mults: TColStd_Array1OfInteger
    Knots: TColStd_Array1OfReal
    Poles: TColStd_Array1OfReal
    NewMults: TColStd_Array1OfInteger
    NewKnots: TColStd_Array1OfReal
    NewPoles: TColStd_Array1OfReal

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    Mults: TColStd_Array1OfInteger
    Knots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt
    Weights: TColStd_Array1OfReal *
    NewMults: TColStd_Array1OfInteger
    NewKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array1OfPnt
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None
    No available documentation.

    Parameters
    ----------
    Degree: int
    Mults: TColStd_Array1OfInteger
    Knots: TColStd_Array1OfReal
    Poles: TColgp_Array1OfPnt2d
    Weights: TColStd_Array1OfReal *
    NewMults: TColStd_Array1OfInteger
    NewKnots: TColStd_Array1OfReal
    NewPoles: TColgp_Array1OfPnt2d
    NewWeights: TColStd_Array1OfReal *

    Returns
    -------
    None

    """
    return _BSplCLib.bsplclib_Unperiodize(*args)

class BSplCLib_Cache(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor, prepares data structures for caching values on a 2d curve. \param thedegree degree of the curve \param theperiodic identify whether the curve is periodic \param theflatknots knots of bezier/b-spline curve (with repetitions) \param thepoles2d array of poles of 2d curve \param theweights array of weights of corresponding poles.

        Parameters
        ----------
        theDegree: int
        thePeriodic: bool
        theFlatKnots: TColStd_Array1OfReal
        thePoles2d: TColgp_Array1OfPnt2d
        theWeights: TColStd_Array1OfReal *,optional
        	default value is NULL

        Returns
        -------
        None
        Constructor, prepares data structures for caching values on a 3d curve. \param thedegree degree of the curve \param theperiodic identify whether the curve is periodic \param theflatknots knots of bezier/b-spline curve (with repetitions) \param thepoles array of poles of 3d curve \param theweights array of weights of corresponding poles.

        Parameters
        ----------
        theDegree: int
        thePeriodic: bool
        theFlatKnots: TColStd_Array1OfReal
        thePoles: TColgp_Array1OfPnt
        theWeights: TColStd_Array1OfReal *,optional
        	default value is NULL

        Returns
        -------
        None

        """
        _BSplCLib.BSplCLib_Cache_swiginit(self, _BSplCLib.new_BSplCLib_Cache(*args))

    def BuildCache(self, *args) -> "void":
        r"""
        Recomputes the cache data for 2d curves. does not verify validity of the cache \param theparameter the value on the knot's axis to identify the span \param theflatknots knots of bezier/b-spline curve (with repetitions) \param thepoles2d array of poles of 2d curve \param theweights array of weights of corresponding poles.

        Parameters
        ----------
        theParameter: float
        theFlatKnots: TColStd_Array1OfReal
        thePoles2d: TColgp_Array1OfPnt2d
        theWeights: TColStd_Array1OfReal *

        Returns
        -------
        None
        Recomputes the cache data for 3d curves. does not verify validity of the cache \param theparameter the value on the knot's axis to identify the span \param theflatknots knots of bezier/b-spline curve (with repetitions) \param thepoles array of poles of 3d curve \param theweights array of weights of corresponding poles.

        Parameters
        ----------
        theParameter: float
        theFlatKnots: TColStd_Array1OfReal
        thePoles: TColgp_Array1OfPnt
        theWeights: TColStd_Array1OfReal *,optional
        	default value is NULL

        Returns
        -------
        None

        """
        return _BSplCLib.BSplCLib_Cache_BuildCache(self, *args)

    def D0(self, *args) -> "void":
        r"""
        Calculates the point on the curve in the specified parameter \param[in] theparameter parameter of calculation of the value \param[out] thepoint the result of calculation (the point on the curve).

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt

        Returns
        -------
        None

        """
        return _BSplCLib.BSplCLib_Cache_D0(self, *args)

    def D1(self, *args) -> "void":
        r"""
        Calculates the point on the curve and its first derivative in the specified parameter \param[in] theparameter parameter of calculation of the value \param[out] thepoint the result of calculation (the point on the curve) \param[out] thetangent tangent vector (first derivatives) for the curve in the calculated point.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt2d
        theTangent: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt
        theTangent: gp_Vec

        Returns
        -------
        None

        """
        return _BSplCLib.BSplCLib_Cache_D1(self, *args)

    def D2(self, *args) -> "void":
        r"""
        Calculates the point on the curve and two derivatives in the specified parameter \param[in] theparameter parameter of calculation of the value \param[out] thepoint the result of calculation (the point on the curve) \param[out] thetangent tangent vector (1st derivatives) for the curve in the calculated point \param[out] thecurvature curvature vector (2nd derivatives) for the curve in the calculated point.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt2d
        theTangent: gp_Vec2d
        theCurvature: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt
        theTangent: gp_Vec
        theCurvature: gp_Vec

        Returns
        -------
        None

        """
        return _BSplCLib.BSplCLib_Cache_D2(self, *args)

    def D3(self, *args) -> "void":
        r"""
        Calculates the point on the curve and three derivatives in the specified parameter \param[in] theparameter parameter of calculation of the value \param[out] thepoint the result of calculation (the point on the curve) \param[out] thetangent tangent vector (1st derivatives) for the curve in the calculated point \param[out] thecurvature curvature vector (2nd derivatives) for the curve in the calculated point \param[out] thetorsion second curvature vector (3rd derivatives) for the curve in the calculated point.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt2d
        theTangent: gp_Vec2d
        theCurvature: gp_Vec2d
        theTorsion: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theParameter: float
        thePoint: gp_Pnt
        theTangent: gp_Vec
        theCurvature: gp_Vec
        theTorsion: gp_Vec

        Returns
        -------
        None

        """
        return _BSplCLib.BSplCLib_Cache_D3(self, *args)

    def IsCacheValid(self, *args) -> "Standard_Boolean":
        r"""
        Verifies validity of the cache using flat parameter of the point \param theparameter parameter of the point placed in the span.

        Parameters
        ----------
        theParameter: float

        Returns
        -------
        bool

        """
        return _BSplCLib.BSplCLib_Cache_IsCacheValid(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BSplCLib_Cache_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BSplCLib.delete_BSplCLib_Cache

# Register BSplCLib_Cache in _BSplCLib:
_BSplCLib.BSplCLib_Cache_swigregister(BSplCLib_Cache)

class BSplCLib_CacheParams(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    SpanStart = property(_BSplCLib.BSplCLib_CacheParams_SpanStart_get, _BSplCLib.BSplCLib_CacheParams_SpanStart_set)
    SpanLength = property(_BSplCLib.BSplCLib_CacheParams_SpanLength_get, _BSplCLib.BSplCLib_CacheParams_SpanLength_set)
    SpanIndex = property(_BSplCLib.BSplCLib_CacheParams_SpanIndex_get, _BSplCLib.BSplCLib_CacheParams_SpanIndex_set)

    def __init__(self, *args):
        r"""
        Constructor, prepares data structures for caching. \param thedegree degree of the b-spline (or bezier) \param theperiodic identify whether the b-spline is periodic \param theflatknots knots of bezier / b-spline parameterization.

        Parameters
        ----------
        theDegree: int
        thePeriodic: bool
        theFlatKnots: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _BSplCLib.BSplCLib_CacheParams_swiginit(self, _BSplCLib.new_BSplCLib_CacheParams(*args))

    def IsCacheValid(self, *args) -> "Standard_Boolean":
        r"""
        Verifies validity of the cache using flat parameter of the point \param theparameter parameter of the point placed in the span.

        Parameters
        ----------
        theParameter: float

        Returns
        -------
        bool

        """
        return _BSplCLib.BSplCLib_CacheParams_IsCacheValid(self, *args)

    def LocateParameter(self, *args) -> "void":
        r"""
        Computes span for the specified parameter \param theparameter parameter of the point placed in the span \param theflatknots knots of bezier / b-spline parameterization.

        Parameters
        ----------
        theFlatKnots: TColStd_Array1OfReal

        Returns
        -------
        theParameter: float

        """
        return _BSplCLib.BSplCLib_CacheParams_LocateParameter(self, *args)

    def PeriodicNormalization(self, *args) -> "Standard_Real":
        r"""
        Normalizes the parameter for periodic b-splines \param theparameter the value to be normalized into the knots array.

        Parameters
        ----------
        theParameter: float

        Returns
        -------
        float

        """
        return _BSplCLib.BSplCLib_CacheParams_PeriodicNormalization(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BSplCLib.delete_BSplCLib_CacheParams

# Register BSplCLib_CacheParams in _BSplCLib:
_BSplCLib.BSplCLib_CacheParams_swigregister(BSplCLib_CacheParams)

class BSplCLib_EvaluatorFunction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Evaluate(self, *args) -> "void":
        r"""
        Function evaluation method to be defined by descendant.

        Parameters
        ----------
        theDerivativeRequest: int
        theStartEnd: float *
        theParameter: float

        Returns
        -------
        theResult: float
        theErrorCode: int

        """
        return _BSplCLib.BSplCLib_EvaluatorFunction_Evaluate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BSplCLib.delete_BSplCLib_EvaluatorFunction

# Register BSplCLib_EvaluatorFunction in _BSplCLib:
_BSplCLib.BSplCLib_EvaluatorFunction_swigregister(BSplCLib_EvaluatorFunction)





