from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.TopTools import *
from OCC.Core.Message import *
from OCC.Core.IntTools import *
from OCC.Core.BOPDS import *
from OCC.Core.Bnd import *
from OCC.Core.gp import *
from OCC.Core.BRepTools import *
from OCC.Core.BOPTools import *
from OCC.Core.TopAbs import *

#the following typedef cannot be wrapped as is
BOPAlgo_ListIteratorOfListOfCheckResult = NewType('BOPAlgo_ListIteratorOfListOfCheckResult', Any)
BOPAlgo_PArgumentAnalyzer = NewType('BOPAlgo_PArgumentAnalyzer', BOPAlgo_ArgumentAnalyzer)
BOPAlgo_PBOP = NewType('BOPAlgo_PBOP', BOPAlgo_BOP)
BOPAlgo_PBuilder = NewType('BOPAlgo_PBuilder', BOPAlgo_Builder)
BOPAlgo_PPaveFiller = NewType('BOPAlgo_PPaveFiller', BOPAlgo_PaveFiller)
BOPAlgo_PSection = NewType('BOPAlgo_PSection', BOPAlgo_Section)
BOPAlgo_PWireEdgeSet = NewType('BOPAlgo_PWireEdgeSet', BOPAlgo_WireEdgeSet)

class BOPAlgo_ListOfCheckResult:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> BOPAlgo_CheckResult: ...
    def Last(self) -> BOPAlgo_CheckResult: ...
    def Append(self, theItem: BOPAlgo_CheckResult) -> BOPAlgo_CheckResult: ...
    def Prepend(self, theItem: BOPAlgo_CheckResult) -> BOPAlgo_CheckResult: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> BOPAlgo_CheckResult: ...
    def SetValue(self, theIndex: int, theValue: BOPAlgo_CheckResult) -> None: ...

class BOPAlgo_CheckStatus(IntEnum):
    BOPAlgo_CheckUnknown: int = ...
    BOPAlgo_BadType: int = ...
    BOPAlgo_SelfIntersect: int = ...
    BOPAlgo_TooSmallEdge: int = ...
    BOPAlgo_NonRecoverableFace: int = ...
    BOPAlgo_IncompatibilityOfVertex: int = ...
    BOPAlgo_IncompatibilityOfEdge: int = ...
    BOPAlgo_IncompatibilityOfFace: int = ...
    BOPAlgo_OperationAborted: int = ...
    BOPAlgo_GeomAbs_C0: int = ...
    BOPAlgo_InvalidCurveOnSurface: int = ...
    BOPAlgo_NotValid: int = ...

BOPAlgo_CheckUnknown = BOPAlgo_CheckStatus.BOPAlgo_CheckUnknown
BOPAlgo_BadType = BOPAlgo_CheckStatus.BOPAlgo_BadType
BOPAlgo_SelfIntersect = BOPAlgo_CheckStatus.BOPAlgo_SelfIntersect
BOPAlgo_TooSmallEdge = BOPAlgo_CheckStatus.BOPAlgo_TooSmallEdge
BOPAlgo_NonRecoverableFace = BOPAlgo_CheckStatus.BOPAlgo_NonRecoverableFace
BOPAlgo_IncompatibilityOfVertex = BOPAlgo_CheckStatus.BOPAlgo_IncompatibilityOfVertex
BOPAlgo_IncompatibilityOfEdge = BOPAlgo_CheckStatus.BOPAlgo_IncompatibilityOfEdge
BOPAlgo_IncompatibilityOfFace = BOPAlgo_CheckStatus.BOPAlgo_IncompatibilityOfFace
BOPAlgo_OperationAborted = BOPAlgo_CheckStatus.BOPAlgo_OperationAborted
BOPAlgo_GeomAbs_C0 = BOPAlgo_CheckStatus.BOPAlgo_GeomAbs_C0
BOPAlgo_InvalidCurveOnSurface = BOPAlgo_CheckStatus.BOPAlgo_InvalidCurveOnSurface
BOPAlgo_NotValid = BOPAlgo_CheckStatus.BOPAlgo_NotValid

class BOPAlgo_Operation(IntEnum):
    BOPAlgo_COMMON: int = ...
    BOPAlgo_FUSE: int = ...
    BOPAlgo_CUT: int = ...
    BOPAlgo_CUT21: int = ...
    BOPAlgo_SECTION: int = ...
    BOPAlgo_UNKNOWN: int = ...

BOPAlgo_COMMON = BOPAlgo_Operation.BOPAlgo_COMMON
BOPAlgo_FUSE = BOPAlgo_Operation.BOPAlgo_FUSE
BOPAlgo_CUT = BOPAlgo_Operation.BOPAlgo_CUT
BOPAlgo_CUT21 = BOPAlgo_Operation.BOPAlgo_CUT21
BOPAlgo_SECTION = BOPAlgo_Operation.BOPAlgo_SECTION
BOPAlgo_UNKNOWN = BOPAlgo_Operation.BOPAlgo_UNKNOWN

class BOPAlgo_GlueEnum(IntEnum):
    BOPAlgo_GlueOff: int = ...
    BOPAlgo_GlueShift: int = ...
    BOPAlgo_GlueFull: int = ...

BOPAlgo_GlueOff = BOPAlgo_GlueEnum.BOPAlgo_GlueOff
BOPAlgo_GlueShift = BOPAlgo_GlueEnum.BOPAlgo_GlueShift
BOPAlgo_GlueFull = BOPAlgo_GlueEnum.BOPAlgo_GlueFull

class BOPAlgo_CheckResult:
    def __init__(self) -> None: ...
    def AddFaultyShape1(self, TheShape: TopoDS_Shape) -> None: ...
    def AddFaultyShape2(self, TheShape: TopoDS_Shape) -> None: ...
    def GetCheckStatus(self) -> BOPAlgo_CheckStatus: ...
    def GetFaultyShapes1(self) -> TopTools_ListOfShape: ...
    def GetFaultyShapes2(self) -> TopTools_ListOfShape: ...
    def GetMaxDistance1(self) -> float: ...
    def GetMaxDistance2(self) -> float: ...
    def GetMaxParameter1(self) -> float: ...
    def GetMaxParameter2(self) -> float: ...
    def GetShape1(self) -> TopoDS_Shape: ...
    def GetShape2(self) -> TopoDS_Shape: ...
    def SetCheckStatus(self, TheStatus: BOPAlgo_CheckStatus) -> None: ...
    def SetMaxDistance1(self, theDist: float) -> None: ...
    def SetMaxDistance2(self, theDist: float) -> None: ...
    def SetMaxParameter1(self, thePar: float) -> None: ...
    def SetMaxParameter2(self, thePar: float) -> None: ...
    def SetShape1(self, TheShape: TopoDS_Shape) -> None: ...
    def SetShape2(self, TheShape: TopoDS_Shape) -> None: ...

class BOPAlgo_Options:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddError(self, theAlert: Message_Alert) -> None: ...
    def AddWarning(self, theAlert: Message_Alert) -> None: ...
    def Allocator(self) -> NCollection_BaseAllocator: ...
    def Clear(self) -> None: ...
    def ClearWarnings(self) -> None: ...
    def FuzzyValue(self) -> float: ...
    @staticmethod
    def GetParallelMode() -> bool: ...
    def GetReport(self) -> Message_Report: ...
    def HasError(self, theType: Standard_Type) -> bool: ...
    def HasErrors(self) -> bool: ...
    def HasWarning(self, theType: Standard_Type) -> bool: ...
    def HasWarnings(self) -> bool: ...
    def RunParallel(self) -> bool: ...
    def SetFuzzyValue(self, theFuzz: float) -> None: ...
    @staticmethod
    def SetParallelMode(theNewMode: bool) -> None: ...
    def SetProgressIndicator(self, theProgress: Message_ProgressScope) -> None: ...
    def SetRunParallel(self, theFlag: bool) -> None: ...
    def SetUseOBB(self, theUseOBB: bool) -> None: ...
    def UseOBB(self) -> bool: ...

class BOPAlgo_SectionAttribute:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAproximation: bool, thePCurveOnS1: bool, thePCurveOnS2: bool) -> None: ...
    @overload
    def Approximation(self, theApprox: bool) -> None: ...
    @overload
    def Approximation(self) -> bool: ...
    @overload
    def PCurveOnS1(self, thePCurveOnS1: bool) -> None: ...
    @overload
    def PCurveOnS1(self) -> bool: ...
    @overload
    def PCurveOnS2(self, thePCurveOnS2: bool) -> None: ...
    @overload
    def PCurveOnS2(self) -> bool: ...

class BOPAlgo_Tools:
    @staticmethod
    def ClassifyFaces(theFaces: TopTools_ListOfShape, theSolids: TopTools_ListOfShape, theRunParallel: bool, theContext: IntTools_Context, theInParts: TopTools_IndexedDataMapOfShapeListOfShape, theShapeBoxMap: Optional[TopTools_DataMapOfShapeBox] = TopTools_DataMapOfShapeBox(), theSolidsIF: Optional[TopTools_DataMapOfShapeListOfShape] = TopTools_DataMapOfShapeListOfShape()) -> None: ...
    @staticmethod
    def ComputeToleranceOfCB(theCB: BOPDS_CommonBlock, theDS: BOPDS_PDS, theContext: IntTools_Context) -> float: ...
    @staticmethod
    def EdgesToWires(theEdges: TopoDS_Shape, theWires: TopoDS_Shape, theShared: Optional[bool] = False, theAngTol: Optional[float] = 1e-8) -> int: ...
    @staticmethod
    def FillInternals(theSolids: TopTools_ListOfShape, theParts: TopTools_ListOfShape, theImages: TopTools_DataMapOfShapeListOfShape, theContext: IntTools_Context) -> None: ...
    @staticmethod
    def IntersectVertices(theVertices: TopTools_IndexedDataMapOfShapeReal, theFuzzyValue: float, theChains: TopTools_ListOfListOfShape) -> None: ...
    @overload
    @staticmethod
    def PerformCommonBlocks(theMBlocks: BOPDS_IndexedDataMapOfPaveBlockListOfPaveBlock, theAllocator: NCollection_BaseAllocator, theDS: BOPDS_PDS, theContext: Optional[IntTools_Context] = IntTools_Context()) -> None: ...
    @overload
    @staticmethod
    def PerformCommonBlocks(theMBlocks: BOPDS_IndexedDataMapOfPaveBlockListOfInteger, theAllocator: NCollection_BaseAllocator, pDS: BOPDS_PDS, theContext: Optional[IntTools_Context] = IntTools_Context()) -> None: ...
    @staticmethod
    def TrsfToPoint(theBox1: Bnd_Box, theBox2: Bnd_Box, theTrsf: gp_Trsf, thePoint: Optional[gp_Pnt] = gp_Pnt(0.0,0.0,0.0), theCriteria: Optional[float] = 1e+5) -> bool: ...
    @staticmethod
    def WiresToFaces(theWires: TopoDS_Shape, theFaces: TopoDS_Shape, theAngTol: Optional[float] = 1e-8) -> bool: ...

class BOPAlgo_WireEdgeSet:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddShape(self, sS: TopoDS_Shape) -> None: ...
    def AddStartElement(self, sS: TopoDS_Shape) -> None: ...
    def Clear(self) -> None: ...
    def Face(self) -> TopoDS_Face: ...
    def SetFace(self, aF: TopoDS_Face) -> None: ...
    def Shapes(self) -> TopTools_ListOfShape: ...
    def StartElements(self) -> TopTools_ListOfShape: ...

class BOPAlgo_Algo(BOPAlgo_Options):
    def Perform(self) -> None: ...

class BOPAlgo_MakeConnected(BOPAlgo_Options):
    def __init__(self) -> None: ...
    def AddArgument(self, theS: TopoDS_Shape) -> None: ...
    def Arguments(self) -> TopTools_ListOfShape: ...
    def Clear(self) -> None: ...
    def ClearRepetitions(self) -> None: ...
    def GetModified(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def GetOrigins(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def History(self) -> BRepTools_History: ...
    def MaterialsOnNegativeSide(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def MaterialsOnPositiveSide(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def Perform(self) -> None: ...
    def PeriodicShape(self) -> TopoDS_Shape: ...
    def PeriodicityTool(self) -> BOPAlgo_MakePeriodic: ...
    def RepeatShape(self, theDirectionID: int, theTimes: int) -> None: ...
    def SetArguments(self, theArgs: TopTools_ListOfShape) -> None: ...
    def Shape(self) -> TopoDS_Shape: ...

class BOPAlgo_MakePeriodic(BOPAlgo_Options):
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...
    def ClearRepetitions(self) -> None: ...
    def GetTwins(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def History(self) -> BRepTools_History: ...
    def IsInputTrimmed(self, theDirectionID: int) -> bool: ...
    def IsInputXTrimmed(self) -> bool: ...
    def IsInputYTrimmed(self) -> bool: ...
    def IsInputZTrimmed(self) -> bool: ...
    def IsPeriodic(self, theDirectionID: int) -> bool: ...
    def IsXPeriodic(self) -> bool: ...
    def IsYPeriodic(self) -> bool: ...
    def IsZPeriodic(self) -> bool: ...
    def MakePeriodic(self, theDirectionID: int, theIsPeriodic: bool, thePeriod: Optional[float] = 0.0) -> None: ...
    def MakeXPeriodic(self, theIsPeriodic: bool, thePeriod: Optional[float] = 0.0) -> None: ...
    def MakeYPeriodic(self, theIsPeriodic: bool, thePeriod: Optional[float] = 0.0) -> None: ...
    def MakeZPeriodic(self, theIsPeriodic: bool, thePeriod: Optional[float] = 0.0) -> None: ...
    def Perform(self) -> None: ...
    def Period(self, theDirectionID: int) -> float: ...
    def PeriodFirst(self, theDirectionID: int) -> float: ...
    def PeriodicityParameters(self) -> False: ...
    def RepeatShape(self, theDirectionID: int, theTimes: int) -> TopoDS_Shape: ...
    def RepeatedShape(self) -> TopoDS_Shape: ...
    def SetShape(self, theShape: TopoDS_Shape) -> None: ...
    def SetTrimmed(self, theDirectionID: int, theIsTrimmed: bool, theFirst: Optional[float] = 0.0) -> None: ...
    def SetXTrimmed(self, theIsTrimmed: bool, theFirst: Optional[bool] = 0.0) -> None: ...
    def SetYTrimmed(self, theIsTrimmed: bool, theFirst: Optional[bool] = 0.0) -> None: ...
    def SetZTrimmed(self, theIsTrimmed: bool, theFirst: Optional[bool] = 0.0) -> None: ...
    def Shape(self) -> TopoDS_Shape: ...
    @staticmethod
    def ToDirectionID(theDirectionID: int) -> int: ...
    def XPeriod(self) -> float: ...
    def XPeriodFirst(self) -> float: ...
    def XRepeat(self, theTimes: int) -> TopoDS_Shape: ...
    def YPeriod(self) -> float: ...
    def YPeriodFirst(self) -> float: ...
    def YRepeat(self, theTimes: int) -> TopoDS_Shape: ...
    def ZPeriod(self) -> float: ...
    def ZPeriodFirst(self) -> float: ...
    def ZRepeat(self, theTimes: int) -> TopoDS_Shape: ...

class BOPAlgo_ArgumentAnalyzer(BOPAlgo_Algo):
    def __init__(self) -> None: ...
    def GetArgumentTypeMode(self) -> bool: ...
    def SetArgumentTypeMode(self, value: bool) -> None: ...
    def GetContinuityMode(self) -> bool: ...
    def SetContinuityMode(self, value: bool) -> None: ...
    def GetCurveOnSurfaceMode(self) -> bool: ...
    def SetCurveOnSurfaceMode(self, value: bool) -> None: ...
    def GetCheckResult(self) -> BOPAlgo_ListOfCheckResult: ...
    def GetShape1(self) -> TopoDS_Shape: ...
    def GetShape2(self) -> TopoDS_Shape: ...
    def HasFaulty(self) -> bool: ...
    def GetMergeEdgeMode(self) -> bool: ...
    def SetMergeEdgeMode(self, value: bool) -> None: ...
    def GetMergeVertexMode(self) -> bool: ...
    def SetMergeVertexMode(self, value: bool) -> None: ...
    def OperationType(self) -> BOPAlgo_Operation: ...
    def Perform(self) -> None: ...
    def GetRebuildFaceMode(self) -> bool: ...
    def SetRebuildFaceMode(self, value: bool) -> None: ...
    def GetSelfInterMode(self) -> bool: ...
    def SetSelfInterMode(self, value: bool) -> None: ...
    def SetShape1(self, TheShape: TopoDS_Shape) -> None: ...
    def SetShape2(self, TheShape: TopoDS_Shape) -> None: ...
    def GetSmallEdgeMode(self) -> bool: ...
    def SetSmallEdgeMode(self, value: bool) -> None: ...
    def GetStopOnFirstFaulty(self) -> bool: ...
    def SetStopOnFirstFaulty(self, value: bool) -> None: ...
    def GetTangentMode(self) -> bool: ...
    def SetTangentMode(self, value: bool) -> None: ...

class BOPAlgo_BuilderArea(BOPAlgo_Algo):
    def Areas(self) -> TopTools_ListOfShape: ...
    def IsAvoidInternalShapes(self) -> bool: ...
    def Loops(self) -> TopTools_ListOfShape: ...
    def SetAvoidInternalShapes(self, theAvoidInternal: bool) -> None: ...
    def SetContext(self, theContext: IntTools_Context) -> None: ...
    def SetShapes(self, theLS: TopTools_ListOfShape) -> None: ...
    def Shapes(self) -> TopTools_ListOfShape: ...

class BOPAlgo_BuilderShape(BOPAlgo_Algo):
    def Generated(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def HasDeleted(self) -> bool: ...
    def HasGenerated(self) -> bool: ...
    def HasHistory(self) -> bool: ...
    def HasModified(self) -> bool: ...
    def History(self) -> BRepTools_History: ...
    def IsDeleted(self, theS: TopoDS_Shape) -> bool: ...
    def Modified(self, theS: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def SetToFillHistory(self, theHistFlag: bool) -> None: ...
    def Shape(self) -> TopoDS_Shape: ...

class BOPAlgo_PaveFiller(BOPAlgo_Algo):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddArgument(self, theShape: TopoDS_Shape) -> None: ...
    def Arguments(self) -> TopTools_ListOfShape: ...
    def Context(self) -> IntTools_Context: ...
    def DS(self) -> BOPDS_DS: ...
    def Glue(self) -> BOPAlgo_GlueEnum: ...
    def IsAvoidBuildPCurve(self) -> bool: ...
    def NonDestructive(self) -> bool: ...
    def PDS(self) -> BOPDS_PDS: ...
    def Perform(self) -> None: ...
    def SetArguments(self, theLS: TopTools_ListOfShape) -> None: ...
    def SetAvoidBuildPCurve(self, theValue: bool) -> None: ...
    def SetGlue(self, theGlue: BOPAlgo_GlueEnum) -> None: ...
    def SetNonDestructive(self, theFlag: bool) -> None: ...
    def SetSectionAttribute(self, theSecAttr: BOPAlgo_SectionAttribute) -> None: ...

class BOPAlgo_ShellSplitter(BOPAlgo_Algo):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddStartElement(self, theS: TopoDS_Shape) -> None: ...
    def Perform(self) -> None: ...
    def Shells(self) -> TopTools_ListOfShape: ...
    @staticmethod
    def SplitBlock(theCB: BOPTools_ConnexityBlock) -> None: ...
    def StartElements(self) -> TopTools_ListOfShape: ...

class BOPAlgo_WireSplitter(BOPAlgo_Algo):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def Context(self) -> IntTools_Context: ...
    @staticmethod
    def MakeWire(theLE: TopTools_ListOfShape, theW: TopoDS_Wire) -> None: ...
    def Perform(self) -> None: ...
    def SetContext(self, theContext: IntTools_Context) -> None: ...
    def SetWES(self, theWES: BOPAlgo_WireEdgeSet) -> None: ...
    @staticmethod
    def SplitBlock(theF: TopoDS_Face, theCB: BOPTools_ConnexityBlock, theContext: IntTools_Context) -> None: ...
    def WES(self) -> BOPAlgo_WireEdgeSet: ...

class BOPAlgo_Builder(BOPAlgo_BuilderShape):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddArgument(self, theShape: TopoDS_Shape) -> None: ...
    def Arguments(self) -> TopTools_ListOfShape: ...
    @overload
    def BuildBOP(self, theObjects: TopTools_ListOfShape, theObjState: TopAbs_State, theTools: TopTools_ListOfShape, theToolsState: TopAbs_State, theReport: Optional[Message_Report] = None) -> None: ...
    @overload
    def BuildBOP(self, theObjects: TopTools_ListOfShape, theTools: TopTools_ListOfShape, theOperation: BOPAlgo_Operation, theReport: Optional[Message_Report] = None) -> None: ...
    def CheckInverted(self) -> bool: ...
    def Clear(self) -> None: ...
    def Context(self) -> IntTools_Context: ...
    def Glue(self) -> BOPAlgo_GlueEnum: ...
    def Images(self) -> TopTools_DataMapOfShapeListOfShape: ...
    def NonDestructive(self) -> bool: ...
    def Origins(self) -> TopTools_DataMapOfShapeListOfShape: ...
    def PDS(self) -> BOPDS_PDS: ...
    def PPaveFiller(self) -> BOPAlgo_PPaveFiller: ...
    def Perform(self) -> None: ...
    def PerformWithFiller(self, theFiller: BOPAlgo_PaveFiller) -> None: ...
    def SetArguments(self, theLS: TopTools_ListOfShape) -> None: ...
    def SetCheckInverted(self, theCheck: bool) -> None: ...
    def SetGlue(self, theGlue: BOPAlgo_GlueEnum) -> None: ...
    def SetNonDestructive(self, theFlag: bool) -> None: ...
    def ShapesSD(self) -> TopTools_DataMapOfShapeShape: ...

class BOPAlgo_BuilderFace(BOPAlgo_BuilderArea):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def Face(self) -> TopoDS_Face: ...
    def Orientation(self) -> TopAbs_Orientation: ...
    def Perform(self) -> None: ...
    def SetFace(self, theFace: TopoDS_Face) -> None: ...

class BOPAlgo_BuilderSolid(BOPAlgo_BuilderArea):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def GetBoxesMap(self) -> TopTools_DataMapOfShapeBox: ...
    def Perform(self) -> None: ...

class BOPAlgo_CheckerSI(BOPAlgo_PaveFiller):
    def __init__(self) -> None: ...
    def Perform(self) -> None: ...
    def SetLevelOfCheck(self, theLevel: int) -> None: ...

class BOPAlgo_RemoveFeatures(BOPAlgo_BuilderShape):
    def __init__(self) -> None: ...
    def AddFaceToRemove(self, theFace: TopoDS_Shape) -> None: ...
    def AddFacesToRemove(self, theFaces: TopTools_ListOfShape) -> None: ...
    def Clear(self) -> None: ...
    def FacesToRemove(self) -> TopTools_ListOfShape: ...
    def InputShape(self) -> TopoDS_Shape: ...
    def Perform(self) -> None: ...
    def SetShape(self, theShape: TopoDS_Shape) -> None: ...

class BOPAlgo_CellsBuilder(BOPAlgo_Builder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddAllToResult(self, theMaterial: Optional[int] = 0, theUpdate: Optional[bool] = False) -> None: ...
    def AddToResult(self, theLSToTake: TopTools_ListOfShape, theLSToAvoid: TopTools_ListOfShape, theMaterial: Optional[int] = 0, theUpdate: Optional[bool] = False) -> None: ...
    def Clear(self) -> None: ...
    def GetAllParts(self) -> TopoDS_Shape: ...
    def MakeContainers(self) -> None: ...
    def RemoveAllFromResult(self) -> None: ...
    def RemoveFromResult(self, theLSToTake: TopTools_ListOfShape, theLSToAvoid: TopTools_ListOfShape) -> None: ...
    def RemoveInternalBoundaries(self) -> None: ...

class BOPAlgo_MakerVolume(BOPAlgo_Builder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def Box(self) -> TopoDS_Solid: ...
    def Clear(self) -> None: ...
    def Faces(self) -> TopTools_ListOfShape: ...
    def IsAvoidInternalShapes(self) -> bool: ...
    def IsIntersect(self) -> bool: ...
    def Perform(self) -> None: ...
    def SetAvoidInternalShapes(self, theAvoidInternal: bool) -> None: ...
    def SetIntersect(self, bIntersect: bool) -> None: ...

class BOPAlgo_Section(BOPAlgo_Builder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...

class BOPAlgo_ToolsProvider(BOPAlgo_Builder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def AddTool(self, theShape: TopoDS_Shape) -> None: ...
    def Clear(self) -> None: ...
    def SetTools(self, theShapes: TopTools_ListOfShape) -> None: ...
    def Tools(self) -> TopTools_ListOfShape: ...

class BOPAlgo_BOP(BOPAlgo_ToolsProvider):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def Clear(self) -> None: ...
    def Operation(self) -> BOPAlgo_Operation: ...
    def Perform(self) -> None: ...
    def SetOperation(self, theOperation: BOPAlgo_Operation) -> None: ...

class BOPAlgo_Splitter(BOPAlgo_ToolsProvider):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theAllocator: NCollection_BaseAllocator) -> None: ...
    def Perform(self) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes

BOPAlgo_Options_GetParallelMode = BOPAlgo_Options.GetParallelMode
BOPAlgo_Options_SetParallelMode = BOPAlgo_Options.SetParallelMode
BOPAlgo_Tools_ClassifyFaces = BOPAlgo_Tools.ClassifyFaces
BOPAlgo_Tools_ComputeToleranceOfCB = BOPAlgo_Tools.ComputeToleranceOfCB
BOPAlgo_Tools_EdgesToWires = BOPAlgo_Tools.EdgesToWires
BOPAlgo_Tools_FillInternals = BOPAlgo_Tools.FillInternals
BOPAlgo_Tools_IntersectVertices = BOPAlgo_Tools.IntersectVertices
BOPAlgo_Tools_PerformCommonBlocks = BOPAlgo_Tools.PerformCommonBlocks
BOPAlgo_Tools_PerformCommonBlocks = BOPAlgo_Tools.PerformCommonBlocks
BOPAlgo_Tools_TrsfToPoint = BOPAlgo_Tools.TrsfToPoint
BOPAlgo_Tools_WiresToFaces = BOPAlgo_Tools.WiresToFaces
BOPAlgo_MakePeriodic_ToDirectionID = BOPAlgo_MakePeriodic.ToDirectionID
BOPAlgo_ShellSplitter_SplitBlock = BOPAlgo_ShellSplitter.SplitBlock
BOPAlgo_WireSplitter_MakeWire = BOPAlgo_WireSplitter.MakeWire
BOPAlgo_WireSplitter_SplitBlock = BOPAlgo_WireSplitter.SplitBlock
