/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.artefact;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.artefact.ArtefactFile;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestReader {
    private static final Logger LOG = Logger.getLogger(ManifestReader.class);

    public void read(InputStream is, Artefact artefact) throws IOException {
        Document doc;
        LOG.info("Reading manifest");
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Failed to read manifest: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("Failed to read manifest: " + e.getMessage());
        }
        finally {
            is.close();
        }
        Element manifest = doc.getDocumentElement();
        if (!"manifest".equals(manifest.getNodeName())) {
            throw new IOException("Wrong root node: " + manifest.getNodeName());
        }
        ArrayList<ArtefactFile> fileList = new ArrayList<ArtefactFile>();
        NodeList nodelist = manifest.getChildNodes();
        int n = nodelist.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() == 1) {
                Element el = (Element)node;
                String nn = el.getNodeName();
                if (!"file".equals(nn)) {
                    throw new IOException("Unexpected manifest element: " + nn);
                }
                String filename = el.getTextContent().trim();
                LOG.trace("File: " + filename);
                ArtefactFile record = new ArtefactFile(filename);
                if (el.hasAttribute("exe")) {
                    record.setExe(Boolean.valueOf(el.getAttribute("exe")));
                }
                if (el.hasAttribute("library")) {
                    record.setLibrary(Boolean.valueOf(el.getAttribute("library")));
                }
                fileList.add(record);
                continue;
            }
            if (node.getNodeType() != 3 && "".equals(node.getTextContent().trim())) continue;
        }
        artefact.setFileList(fileList);
    }
}

