/* UserCard.c generated by valac 0.56.0, the Vala compiler
 * generated from UserCard.vala, do not modify */

/*
 * Copyright 2018–2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <lightdm.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <act/act.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <handy.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>

#define GREETER_BASE_CARD_ERROR_SHAKE_DURATION 450
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_BASE_CARD (greeter_base_card_get_type ())
#define GREETER_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCard))
#define GREETER_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))
#define GREETER_IS_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BASE_CARD))
#define GREETER_IS_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BASE_CARD))
#define GREETER_BASE_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))

typedef struct _GreeterBaseCard GreeterBaseCard;
typedef struct _GreeterBaseCardClass GreeterBaseCardClass;
typedef struct _GreeterBaseCardPrivate GreeterBaseCardPrivate;

#define GREETER_TYPE_USER_CARD (greeter_user_card_get_type ())
#define GREETER_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_USER_CARD, GreeterUserCard))
#define GREETER_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_USER_CARD, GreeterUserCardClass))
#define GREETER_IS_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_USER_CARD))
#define GREETER_IS_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_USER_CARD))
#define GREETER_USER_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_USER_CARD, GreeterUserCardClass))

typedef struct _GreeterUserCard GreeterUserCard;
typedef struct _GreeterUserCardClass GreeterUserCardClass;
typedef struct _GreeterUserCardPrivate GreeterUserCardPrivate;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_accounts_service_get_type ())
#define PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsService))
#define PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsServiceIface))

typedef struct _PantheonAccountsService PantheonAccountsService;
typedef struct _PantheonAccountsServiceIface PantheonAccountsServiceIface;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_accounts_service_proxy_get_type ())

#define PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE (pantheon_settings_daemon_accounts_service_get_type ())
#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, PantheonSettingsDaemonAccountsService))
#define PANTHEON_SETTINGS_DAEMON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, PantheonSettingsDaemonAccountsServiceIface))

typedef struct _PantheonSettingsDaemonAccountsService PantheonSettingsDaemonAccountsService;
typedef struct _PantheonSettingsDaemonAccountsServiceIface PantheonSettingsDaemonAccountsServiceIface;

#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_KEYBOARD_LAYOUT (pantheon_settings_daemon_accounts_service_keyboard_layout_get_type ())
typedef struct _PantheonSettingsDaemonAccountsServiceKeyboardLayout PantheonSettingsDaemonAccountsServiceKeyboardLayout;

#define PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_settings_daemon_accounts_service_proxy_get_type ())

#define GREETER_TYPE_PASSWORD_ENTRY (greeter_password_entry_get_type ())
#define GREETER_PASSWORD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_PASSWORD_ENTRY, GreeterPasswordEntry))
#define GREETER_PASSWORD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_PASSWORD_ENTRY, GreeterPasswordEntryClass))
#define GREETER_IS_PASSWORD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_PASSWORD_ENTRY))
#define GREETER_IS_PASSWORD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_PASSWORD_ENTRY))
#define GREETER_PASSWORD_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_PASSWORD_ENTRY, GreeterPasswordEntryClass))

typedef struct _GreeterPasswordEntry GreeterPasswordEntry;
typedef struct _GreeterPasswordEntryClass GreeterPasswordEntryClass;

#define GREETER_USER_CARD_TYPE_SELECTION_CHECK (greeter_user_card_selection_check_get_type ())
#define GREETER_USER_CARD_SELECTION_CHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheck))
#define GREETER_USER_CARD_SELECTION_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheckClass))
#define GREETER_USER_CARD_IS_SELECTION_CHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_USER_CARD_TYPE_SELECTION_CHECK))
#define GREETER_USER_CARD_IS_SELECTION_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_USER_CARD_TYPE_SELECTION_CHECK))
#define GREETER_USER_CARD_SELECTION_CHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheckClass))

typedef struct _GreeterUserCardSelectionCheck GreeterUserCardSelectionCheck;
typedef struct _GreeterUserCardSelectionCheckClass GreeterUserCardSelectionCheckClass;
enum  {
	GREETER_USER_CARD_0_PROPERTY,
	GREETER_USER_CARD_LIGHTDM_USER_PROPERTY,
	GREETER_USER_CARD_SHOW_INPUT_PROPERTY,
	GREETER_USER_CARD_REVEAL_RATIO_PROPERTY,
	GREETER_USER_CARD_IS_24H_PROPERTY,
	GREETER_USER_CARD_PREFERS_ACCENT_COLOR_PROPERTY,
	GREETER_USER_CARD_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY,
	GREETER_USER_CARD_SLEEP_INACTIVE_AC_TYPE_PROPERTY,
	GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY,
	GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY,
	GREETER_USER_CARD_NUM_PROPERTIES
};
static GParamSpec* greeter_user_card_properties[GREETER_USER_CARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _GreeterUserCardSelectionCheckPrivate GreeterUserCardSelectionCheckPrivate;
enum  {
	GREETER_USER_CARD_SELECTION_CHECK_0_PROPERTY,
	GREETER_USER_CARD_SELECTION_CHECK_NUM_PROPERTIES
};
static GParamSpec* greeter_user_card_selection_check_properties[GREETER_USER_CARD_SELECTION_CHECK_NUM_PROPERTIES];
typedef struct _Block8Data Block8Data;

#define GREETER_TYPE_SESSION_BUTTON (greeter_session_button_get_type ())
#define GREETER_SESSION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SESSION_BUTTON, GreeterSessionButton))
#define GREETER_SESSION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SESSION_BUTTON, GreeterSessionButtonClass))
#define GREETER_IS_SESSION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SESSION_BUTTON))
#define GREETER_IS_SESSION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SESSION_BUTTON))
#define GREETER_SESSION_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SESSION_BUTTON, GreeterSessionButtonClass))

typedef struct _GreeterSessionButton GreeterSessionButton;
typedef struct _GreeterSessionButtonClass GreeterSessionButtonClass;

#define GREETER_TYPE_CAPS_LOCK_REVEALER (greeter_caps_lock_revealer_get_type ())
#define GREETER_CAPS_LOCK_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_CAPS_LOCK_REVEALER, GreeterCapsLockRevealer))
#define GREETER_CAPS_LOCK_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_CAPS_LOCK_REVEALER, GreeterCapsLockRevealerClass))
#define GREETER_IS_CAPS_LOCK_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_CAPS_LOCK_REVEALER))
#define GREETER_IS_CAPS_LOCK_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_CAPS_LOCK_REVEALER))
#define GREETER_CAPS_LOCK_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_CAPS_LOCK_REVEALER, GreeterCapsLockRevealerClass))

typedef struct _GreeterCapsLockRevealer GreeterCapsLockRevealer;
typedef struct _GreeterCapsLockRevealerClass GreeterCapsLockRevealerClass;

#define GREETER_TYPE_BACKGROUND_IMAGE (greeter_background_image_get_type ())
#define GREETER_BACKGROUND_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImage))
#define GREETER_BACKGROUND_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImageClass))
#define GREETER_IS_BACKGROUND_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BACKGROUND_IMAGE))
#define GREETER_IS_BACKGROUND_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BACKGROUND_IMAGE))
#define GREETER_BACKGROUND_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImageClass))

typedef struct _GreeterBackgroundImage GreeterBackgroundImage;
typedef struct _GreeterBackgroundImageClass GreeterBackgroundImageClass;
enum  {
	GREETER_USER_CARD_GO_LEFT_SIGNAL,
	GREETER_USER_CARD_GO_RIGHT_SIGNAL,
	GREETER_USER_CARD_FOCUS_REQUESTED_SIGNAL,
	GREETER_USER_CARD_NUM_SIGNALS
};
static guint greeter_user_card_signals[GREETER_USER_CARD_NUM_SIGNALS] = {0};

struct _GreeterBaseCard {
	GtkRevealer parent_instance;
	GreeterBaseCardPrivate * priv;
};

struct _GreeterBaseCardClass {
	GtkRevealerClass parent_class;
	void (*wrong_credentials) (GreeterBaseCard* self);
};

struct _GreeterUserCard {
	GreeterBaseCard parent_instance;
	GreeterUserCardPrivate * priv;
};

struct _GreeterUserCardClass {
	GreeterBaseCardClass parent_class;
};

struct _PantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gchar* (*get_time_format) (PantheonAccountsService* self);
	void (*set_time_format) (PantheonAccountsService* self, const gchar* value);
	gint (*get_prefers_accent_color) (PantheonAccountsService* self);
	void (*set_prefers_accent_color) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_ac_timeout) (PantheonAccountsService* self);
	void (*set_sleep_inactive_ac_timeout) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_ac_type) (PantheonAccountsService* self);
	void (*set_sleep_inactive_ac_type) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_battery_timeout) (PantheonAccountsService* self);
	void (*set_sleep_inactive_battery_timeout) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_battery_type) (PantheonAccountsService* self);
	void (*set_sleep_inactive_battery_type) (PantheonAccountsService* self, gint value);
};

struct _PantheonSettingsDaemonAccountsServiceKeyboardLayout {
	gchar* backend;
	gchar* name;
};

struct _PantheonSettingsDaemonAccountsServiceIface {
	GTypeInterface parent_iface;
	PantheonSettingsDaemonAccountsServiceKeyboardLayout* (*get_keyboard_layouts) (PantheonSettingsDaemonAccountsService* self, gint* result_length1);
	void (*set_keyboard_layouts) (PantheonSettingsDaemonAccountsService* self, PantheonSettingsDaemonAccountsServiceKeyboardLayout* value, gint value_length1);
	guint (*get_active_keyboard_layout) (PantheonSettingsDaemonAccountsService* self);
	void (*set_active_keyboard_layout) (PantheonSettingsDaemonAccountsService* self, guint value);
};

struct _GreeterUserCardPrivate {
	LightDMUser* _lightdm_user;
	gboolean _show_input;
	gdouble _reveal_ratio;
	gboolean _is_24h;
	gint _prefers_accent_color;
	gint _sleep_inactive_ac_timeout;
	gint _sleep_inactive_ac_type;
	gint _sleep_inactive_battery_timeout;
	gint _sleep_inactive_battery_type;
	ActUser* act_user;
	PantheonAccountsService* greeter_act;
	PantheonSettingsDaemonAccountsService* settings_act;
	GtkRevealer* form_revealer;
	GtkStack* login_stack;
	GreeterPasswordEntry* password_entry;
	GreeterUserCardSelectionCheck* logged_in;
	GtkStyleContext* logged_in_context;
	GtkStyleContext* main_grid_style_context;
	GtkStyleContext* password_entry_context;
	gboolean needs_keyboard_layout_set;
};

struct _Block7Data {
	int _ref_count_;
	GreeterUserCard* self;
	GtkStyleContext* entry_style_context;
};

struct _GreeterUserCardSelectionCheck {
	GtkSpinner parent_instance;
	GreeterUserCardSelectionCheckPrivate * priv;
};

struct _GreeterUserCardSelectionCheckClass {
	GtkSpinnerClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	GreeterUserCard* self;
	GtkGrid* password_grid;
	GtkButton* login_button;
	GtkGrid* form_grid;
};

static gint GreeterUserCard_private_offset;
static gpointer greeter_user_card_parent_class = NULL;
static gpointer greeter_user_card_selection_check_parent_class = NULL;
static GtkCssProvider* greeter_user_card_selection_check_check_provider;
static GtkCssProvider* greeter_user_card_selection_check_check_provider = NULL;
VALA_EXTERN GtkCssProvider* greeter_base_card_css_provider;

VALA_EXTERN GType greeter_base_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBaseCard, g_object_unref)
VALA_EXTERN GType greeter_user_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterUserCard, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_accounts_service_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_keyboard_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonSettingsDaemonAccountsServiceKeyboardLayout* pantheon_settings_daemon_accounts_service_keyboard_layout_dup (const PantheonSettingsDaemonAccountsServiceKeyboardLayout* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_keyboard_layout_free (PantheonSettingsDaemonAccountsServiceKeyboardLayout* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_keyboard_layout_copy (const PantheonSettingsDaemonAccountsServiceKeyboardLayout* self,
                                                                     PantheonSettingsDaemonAccountsServiceKeyboardLayout* dest);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_keyboard_layout_destroy (PantheonSettingsDaemonAccountsServiceKeyboardLayout* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonSettingsDaemonAccountsServiceKeyboardLayout, pantheon_settings_daemon_accounts_service_keyboard_layout_destroy)
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonSettingsDaemonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_settings_daemon_accounts_service_register_object (void* object,
                                                                 GDBusConnection* connection,
                                                                 const gchar* path,
                                                                 GError** error);
VALA_EXTERN GType greeter_password_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterPasswordEntry, g_object_unref)
static GType greeter_user_card_selection_check_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterUserCardSelectionCheck, g_object_unref)
VALA_EXTERN void greeter_base_card_wrong_credentials (GreeterBaseCard* self);
static void greeter_user_card_update_style (GreeterUserCard* self);
static gchar* greeter_user_card_accent_to_string (GreeterUserCard* self,
                                           gint i);
VALA_EXTERN gint greeter_user_card_get_prefers_accent_color (GreeterUserCard* self);
static void greeter_user_card_on_act_user_loaded (GreeterUserCard* self);
VALA_EXTERN gchar* pantheon_accounts_service_get_time_format (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_is_24h (GreeterUserCard* self,
                                   gboolean value);
VALA_EXTERN gint pantheon_accounts_service_get_prefers_accent_color (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_prefers_accent_color (GreeterUserCard* self,
                                                 gint value);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_ac_timeout (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_sleep_inactive_ac_timeout (GreeterUserCard* self,
                                                      gint value);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_ac_type (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_sleep_inactive_ac_type (GreeterUserCard* self,
                                                   gint value);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_battery_timeout (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_sleep_inactive_battery_timeout (GreeterUserCard* self,
                                                           gint value);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_battery_type (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_sleep_inactive_battery_type (GreeterUserCard* self,
                                                        gint value);
static void ____lambda10_ (GreeterUserCard* self,
                    GVariant* changed_properties,
                    gchar** invalidated_properties);
static void _____lambda10__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                       GVariant* changed_properties,
                                                       gchar** invalidated_properties,
                                                       gpointer self);
VALA_EXTERN void greeter_user_card_set_keyboard_layouts (GreeterUserCard* self);
VALA_EXTERN gboolean greeter_base_card_get_need_password (GreeterBaseCard* self);
static void greeter_user_card_on_login (GreeterUserCard* self);
VALA_EXTERN void greeter_base_card_set_connecting (GreeterBaseCard* self,
                                       gboolean value);
static void greeter_user_card_update_collapsed_class (GreeterUserCard* self);
VALA_EXTERN gboolean greeter_user_card_get_show_input (GreeterUserCard* self);
VALA_EXTERN PantheonSettingsDaemonAccountsServiceKeyboardLayout* pantheon_settings_daemon_accounts_service_get_keyboard_layouts (PantheonSettingsDaemonAccountsService* self,
                                                                                                                     gint* result_length1);
static void _vala_array_add2 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
static void _vala_PantheonSettingsDaemonAccountsServiceKeyboardLayout_array_free (PantheonSettingsDaemonAccountsServiceKeyboardLayout * array,
                                                                           gssize array_length);
VALA_EXTERN guint pantheon_settings_daemon_accounts_service_get_active_keyboard_layout (PantheonSettingsDaemonAccountsService* self);
static GVariant* _variant_new1 (guint value);
VALA_EXTERN GreeterUserCard* greeter_user_card_new (LightDMUser* lightdm_user);
VALA_EXTERN GreeterUserCard* greeter_user_card_construct (GType object_type,
                                              LightDMUser* lightdm_user);
static void greeter_user_card_real_wrong_credentials (GreeterBaseCard* base);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda11_ (Block7Data* _data7_);
static gboolean ___lambda11__gsource_func (gpointer self);
VALA_EXTERN LightDMUser* greeter_user_card_get_lightdm_user (GreeterUserCard* self);
static void greeter_user_card_set_lightdm_user (GreeterUserCard* self,
                                         LightDMUser* value);
VALA_EXTERN void greeter_user_card_set_show_input (GreeterUserCard* self,
                                       gboolean value);
VALA_EXTERN gdouble greeter_user_card_get_reveal_ratio (GreeterUserCard* self);
static void greeter_user_card_set_reveal_ratio (GreeterUserCard* self,
                                         gdouble value);
VALA_EXTERN gboolean greeter_user_card_get_is_24h (GreeterUserCard* self);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_ac_timeout (GreeterUserCard* self);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_ac_type (GreeterUserCard* self);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_battery_timeout (GreeterUserCard* self);
VALA_EXTERN gint greeter_user_card_get_sleep_inactive_battery_type (GreeterUserCard* self);
static GreeterUserCardSelectionCheck* greeter_user_card_selection_check_new (void);
static GreeterUserCardSelectionCheck* greeter_user_card_selection_check_construct (GType object_type);
static GObject * greeter_user_card_selection_check_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void greeter_user_card_selection_check_finalize (GObject * obj);
static GType greeter_user_card_selection_check_get_type_once (void);
static GObject * greeter_user_card_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN void greeter_base_card_set_need_password (GreeterBaseCard* self,
                                          gboolean value);
VALA_EXTERN GreeterPasswordEntry* greeter_password_entry_new (void);
VALA_EXTERN GreeterPasswordEntry* greeter_password_entry_construct (GType object_type);
VALA_EXTERN GType greeter_session_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSessionButton, g_object_unref)
VALA_EXTERN GreeterSessionButton* greeter_session_button_new (void);
VALA_EXTERN GreeterSessionButton* greeter_session_button_construct (GType object_type);
VALA_EXTERN GType greeter_caps_lock_revealer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCapsLockRevealer, g_object_unref)
VALA_EXTERN GreeterCapsLockRevealer* greeter_caps_lock_revealer_new (void);
VALA_EXTERN GreeterCapsLockRevealer* greeter_caps_lock_revealer_construct (GType object_type);
VALA_EXTERN GType greeter_background_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBackgroundImage, g_object_unref)
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_new (const gchar* path);
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_construct (GType object_type,
                                                            const gchar* path);
static void _greeter_user_card_on_act_user_loaded_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static gboolean _greeter_user_card___lambda14_ (GreeterUserCard* self,
                                         GtkDirectionType direction);
static gboolean __greeter_user_card___lambda14__gtk_widget_focus (GtkWidget* _sender,
                                                           GtkDirectionType direction,
                                                           gpointer self);
static gboolean _greeter_user_card___lambda15_ (GreeterUserCard* self,
                                         GdkEventButton* event);
static gboolean __greeter_user_card___lambda15__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self);
static void _greeter_user_card___lambda16_ (Block8Data* _data8_,
                                     GtkAllocation* alloc);
static void __greeter_user_card___lambda16__gtk_widget_size_allocate (GtkWidget* _sender,
                                                               GtkAllocation* allocation,
                                                               gpointer self);
static void _greeter_user_card___lambda17_ (GreeterUserCard* self);
static void __greeter_user_card___lambda17__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _greeter_user_card___lambda18_ (GreeterUserCard* self);
static void __greeter_user_card___lambda18__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _greeter_user_card_on_login_gtk_entry_activate (GtkEntry* _sender,
                                                     gpointer self);
static void _greeter_user_card_on_login_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _greeter_user_card___lambda19_ (Block8Data* _data8_);
static void __greeter_user_card___lambda19__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _greeter_user_card___lambda20_ (GreeterUserCard* self);
static void __greeter_user_card___lambda20__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _greeter_user_card___lambda21_ (GreeterUserCard* self);
static void __greeter_user_card___lambda21__gtk_widget_grab_focus (GtkWidget* _sender,
                                                            gpointer self);
static void greeter_user_card_finalize (GObject * obj);
static GType greeter_user_card_get_type_once (void);
static void _vala_greeter_user_card_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_greeter_user_card_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
greeter_user_card_get_instance_private (GreeterUserCard* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterUserCard_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_user_card_update_style (GreeterUserCard* self)
{
	GtkSettings* gtksettings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkCssProvider* style_provider = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkCssProvider* _tmp10_;
	GtkCssProvider* _tmp11_;
	GtkCssProvider* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtksettings = _tmp1_;
	_tmp2_ = self->priv->_prefers_accent_color;
	_tmp3_ = greeter_user_card_accent_to_string (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("io.elementary.stylesheet.", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_object_set (gtksettings, "gtk-theme-name", _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	g_object_get (gtksettings, "gtk-theme-name", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_css_provider_get_named (_tmp9_, NULL);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp9_);
	style_provider = _tmp12_;
	_tmp13_ = self->priv->logged_in_context;
	gtk_style_context_add_provider (_tmp13_, (GtkStyleProvider*) style_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp14_ = self->priv->password_entry_context;
	gtk_style_context_add_provider (_tmp14_, (GtkStyleProvider*) style_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (style_provider);
	_g_object_unref0 (gtksettings);
}

static gchar*
greeter_user_card_accent_to_string (GreeterUserCard* self,
                                    gint i)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (i) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("strawberry");
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("orange");
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("banana");
			result = _tmp2_;
			return result;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("lime");
			result = _tmp3_;
			return result;
		}
		case 5:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("mint");
			result = _tmp4_;
			return result;
		}
		case 7:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("grape");
			result = _tmp5_;
			return result;
		}
		case 8:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("bubblegum");
			result = _tmp6_;
			return result;
		}
		case 9:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("cocoa");
			result = _tmp7_;
			return result;
		}
		case 10:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("slate");
			result = _tmp8_;
			return result;
		}
		default:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("blueberry");
			result = _tmp9_;
			return result;
		}
	}
}

static void
____lambda10_ (GreeterUserCard* self,
               GVariant* changed_properties,
               gchar** invalidated_properties)
{
	gchar* time_format = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (changed_properties != NULL);
	g_variant_lookup (changed_properties, "TimeFormat", "s", &_tmp0_, NULL);
	_g_free0 (time_format);
	time_format = _tmp0_;
	greeter_user_card_set_is_24h (self, g_strcmp0 (time_format, "12h") != 0);
	g_variant_lookup (changed_properties, "PrefersAccentColor", "i", &_tmp1_, NULL);
	self->priv->_prefers_accent_color = _tmp1_;
	g_variant_lookup (changed_properties, "SleepInactiveACTimeout", "i", &_tmp2_, NULL);
	self->priv->_sleep_inactive_ac_timeout = _tmp2_;
	g_variant_lookup (changed_properties, "SleepInactiveACType", "i", &_tmp3_, NULL);
	self->priv->_sleep_inactive_ac_type = _tmp3_;
	g_variant_lookup (changed_properties, "SleepInactiveBatteryTimeout", "i", &_tmp4_, NULL);
	self->priv->_sleep_inactive_battery_timeout = _tmp4_;
	g_variant_lookup (changed_properties, "SleepInactiveBatteryType", "i", &_tmp5_, NULL);
	self->priv->_sleep_inactive_battery_type = _tmp5_;
	_g_free0 (time_format);
}

static void
_____lambda10__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                  GVariant* changed_properties,
                                                  gchar** invalidated_properties,
                                                  gpointer self)
{
	____lambda10_ ((GreeterUserCard*) self, changed_properties, invalidated_properties);
}

static void
greeter_user_card_on_act_user_loaded (GreeterUserCard* self)
{
	ActUser* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* act_path = NULL;
	ActUser* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ActUser* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->act_user;
	g_object_get (_tmp0_, "is-loaded", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->act_user;
	_tmp4_ = act_user_get_object_path (_tmp3_);
	act_path = _tmp4_;
	_tmp5_ = act_path;
	if (_tmp5_ != NULL) {
		{
			PantheonAccountsService* _tmp6_ = NULL;
			const gchar* _tmp7_;
			PantheonAccountsService* _tmp8_;
			PantheonAccountsService* _tmp9_;
			PantheonSettingsDaemonAccountsService* _tmp10_ = NULL;
			const gchar* _tmp11_;
			PantheonSettingsDaemonAccountsService* _tmp12_;
			PantheonSettingsDaemonAccountsService* _tmp13_;
			PantheonAccountsService* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			PantheonAccountsService* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			PantheonAccountsService* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			PantheonAccountsService* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			PantheonAccountsService* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			PantheonAccountsService* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			PantheonAccountsService* _tmp33_;
			_tmp7_ = act_path;
			_tmp8_ = (PantheonAccountsService*) g_initable_new (PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp7_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
			_tmp6_ = (PantheonAccountsService*) _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (self->priv->greeter_act);
			self->priv->greeter_act = _tmp9_;
			_tmp11_ = act_path;
			_tmp12_ = (PantheonSettingsDaemonAccountsService*) g_initable_new (PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp11_, "g-interface-name", "io.elementary.SettingsDaemon.AccountsService", NULL);
			_tmp10_ = (PantheonSettingsDaemonAccountsService*) _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_object_unref0 (self->priv->settings_act);
			self->priv->settings_act = _tmp13_;
			_tmp14_ = self->priv->greeter_act;
			_tmp15_ = pantheon_accounts_service_get_time_format (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			greeter_user_card_set_is_24h (self, g_strcmp0 (_tmp17_, "12h") != 0);
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->greeter_act;
			_tmp19_ = pantheon_accounts_service_get_prefers_accent_color (_tmp18_);
			_tmp20_ = _tmp19_;
			greeter_user_card_set_prefers_accent_color (self, _tmp20_);
			_tmp21_ = self->priv->greeter_act;
			_tmp22_ = pantheon_accounts_service_get_sleep_inactive_ac_timeout (_tmp21_);
			_tmp23_ = _tmp22_;
			greeter_user_card_set_sleep_inactive_ac_timeout (self, _tmp23_);
			_tmp24_ = self->priv->greeter_act;
			_tmp25_ = pantheon_accounts_service_get_sleep_inactive_ac_type (_tmp24_);
			_tmp26_ = _tmp25_;
			greeter_user_card_set_sleep_inactive_ac_type (self, _tmp26_);
			_tmp27_ = self->priv->greeter_act;
			_tmp28_ = pantheon_accounts_service_get_sleep_inactive_battery_timeout (_tmp27_);
			_tmp29_ = _tmp28_;
			greeter_user_card_set_sleep_inactive_battery_timeout (self, _tmp29_);
			_tmp30_ = self->priv->greeter_act;
			_tmp31_ = pantheon_accounts_service_get_sleep_inactive_battery_type (_tmp30_);
			_tmp32_ = _tmp31_;
			greeter_user_card_set_sleep_inactive_battery_type (self, _tmp32_);
			_tmp33_ = self->priv->greeter_act;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _____lambda10__g_dbus_proxy_g_properties_changed, self, 0);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (_tmp6_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp34_;
			const gchar* _tmp35_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp34_ = e;
			_tmp35_ = _tmp34_->message;
			g_critical ("UserCard.vala:378: %s", _tmp35_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (self->priv->needs_keyboard_layout_set) {
		greeter_user_card_set_keyboard_layouts (self);
	}
	_tmp36_ = self->priv->act_user;
	_tmp37_ = act_user_get_locked (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_) {
		GtkStack* _tmp39_;
		_tmp39_ = self->priv->login_stack;
		gtk_stack_set_visible_child_name (_tmp39_, "disabled");
	} else {
		gboolean _tmp40_;
		gboolean _tmp41_;
		_tmp40_ = greeter_base_card_get_need_password ((GreeterBaseCard*) self);
		_tmp41_ = _tmp40_;
		if (_tmp41_) {
			GtkStack* _tmp42_;
			_tmp42_ = self->priv->login_stack;
			gtk_stack_set_visible_child_name (_tmp42_, "password");
		} else {
			GtkStack* _tmp43_;
			_tmp43_ = self->priv->login_stack;
			gtk_stack_set_visible_child_name (_tmp43_, "button");
		}
	}
}

static void
greeter_user_card_on_login (GreeterUserCard* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	greeter_base_card_set_connecting ((GreeterBaseCard*) self, TRUE);
	_tmp0_ = greeter_base_card_get_need_password ((GreeterBaseCard*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GreeterPasswordEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->password_entry;
		_tmp3_ = gtk_entry_get_text ((GtkEntry*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_signal_emit_by_name ((GreeterBaseCard*) self, "do-connect", _tmp4_);
	} else {
		g_signal_emit_by_name ((GreeterBaseCard*) self, "do-connect", NULL);
	}
}

static void
greeter_user_card_update_collapsed_class (GreeterUserCard* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_show_input;
	if (_tmp0_) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = self->priv->main_grid_style_context;
		gtk_style_context_remove_class (_tmp1_, "collapsed");
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = self->priv->main_grid_style_context;
		gtk_style_context_add_class (_tmp2_, "collapsed");
	}
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
_vala_array_add2 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_PantheonSettingsDaemonAccountsServiceKeyboardLayout_array_free (PantheonSettingsDaemonAccountsServiceKeyboardLayout * array,
                                                                      gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pantheon_settings_daemon_accounts_service_keyboard_layout_destroy (&array[i]);
		}
	}
	g_free (array);
}

static GVariant*
_variant_new1 (guint value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

void
greeter_user_card_set_keyboard_layouts (GreeterUserCard* self)
{
	ActUser* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	GVariant** elements = NULL;
	GVariant** _tmp4_;
	gint elements_length1;
	gint _elements_size_;
	PantheonSettingsDaemonAccountsService* _tmp5_;
	PantheonSettingsDaemonAccountsServiceKeyboardLayout* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	PantheonSettingsDaemonAccountsServiceKeyboardLayout* _tmp8_;
	gint _tmp8__length1;
	GVariant* list = NULL;
	GVariantType* _tmp27_;
	GVariantType* _tmp28_;
	GVariant** _tmp29_;
	gint _tmp29__length1;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	GSettings* _tmp32_;
	GVariant* _tmp33_;
	GSettings* _tmp34_;
	PantheonSettingsDaemonAccountsService* _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	GVariant* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->act_user;
	g_object_get (_tmp0_, "is-loaded", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		self->priv->needs_keyboard_layout_set = TRUE;
		return;
	}
	_tmp3_ = g_settings_new ("org.gnome.desktop.input-sources");
	settings = _tmp3_;
	_tmp4_ = g_new0 (GVariant*, 0 + 1);
	elements = _tmp4_;
	elements_length1 = 0;
	_elements_size_ = elements_length1;
	_tmp5_ = self->priv->settings_act;
	_tmp6_ = pantheon_settings_daemon_accounts_service_get_keyboard_layouts (_tmp5_, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	{
		PantheonSettingsDaemonAccountsServiceKeyboardLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
		layout_collection = _tmp8_;
		layout_collection_length1 = _tmp8__length1;
		for (layout_it = 0; layout_it < layout_collection_length1; layout_it = layout_it + 1) {
			PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp9_;
			PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp10_ = {0};
			PantheonSettingsDaemonAccountsServiceKeyboardLayout layout = {0};
			_tmp9_ = layout_collection[layout_it];
			pantheon_settings_daemon_accounts_service_keyboard_layout_copy (&_tmp9_, &_tmp10_);
			layout = _tmp10_;
			{
				GVariant* first = NULL;
				PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp11_;
				const gchar* _tmp12_;
				GVariant* _tmp13_;
				GVariant* second = NULL;
				PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp14_;
				const gchar* _tmp15_;
				GVariant* _tmp16_;
				GVariant* _result_ = NULL;
				GVariant* _tmp17_;
				GVariant* _tmp18_;
				GVariant* _tmp19_;
				GVariant* _tmp20_;
				GVariant** _tmp21_;
				GVariant** _tmp22_;
				gint _tmp22__length1;
				GVariant* _tmp23_;
				GVariant* _tmp24_;
				GVariant* _tmp25_;
				GVariant* _tmp26_;
				_tmp11_ = layout;
				_tmp12_ = _tmp11_.backend;
				_tmp13_ = g_variant_new_string (_tmp12_);
				g_variant_ref_sink (_tmp13_);
				first = _tmp13_;
				_tmp14_ = layout;
				_tmp15_ = _tmp14_.name;
				_tmp16_ = g_variant_new_string (_tmp15_);
				g_variant_ref_sink (_tmp16_);
				second = _tmp16_;
				_tmp17_ = first;
				_tmp18_ = _g_variant_ref0 (_tmp17_);
				_tmp19_ = second;
				_tmp20_ = _g_variant_ref0 (_tmp19_);
				_tmp21_ = g_new0 (GVariant*, 2 + 1);
				_tmp21_[0] = _tmp18_;
				_tmp21_[1] = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp22__length1 = 2;
				_tmp23_ = g_variant_new_tuple (_tmp22_, 2);
				g_variant_ref_sink (_tmp23_);
				_tmp24_ = _tmp23_;
				_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_variant_unref), NULL);
				_result_ = _tmp24_;
				_tmp25_ = _result_;
				_tmp26_ = _g_variant_ref0 (_tmp25_);
				_vala_array_add2 (&elements, &elements_length1, &_elements_size_, _tmp26_);
				_g_variant_unref0 (_result_);
				_g_variant_unref0 (second);
				_g_variant_unref0 (first);
				pantheon_settings_daemon_accounts_service_keyboard_layout_destroy (&layout);
			}
		}
		layout_collection = (_vala_PantheonSettingsDaemonAccountsServiceKeyboardLayout_array_free (layout_collection, layout_collection_length1), NULL);
	}
	_tmp27_ = g_variant_type_new ("(ss)");
	_tmp28_ = _tmp27_;
	_tmp29_ = elements;
	_tmp29__length1 = elements_length1;
	_tmp30_ = g_variant_new_array (_tmp28_, _tmp29_, _tmp29__length1);
	g_variant_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	_g_variant_type_free0 (_tmp28_);
	list = _tmp31_;
	_tmp32_ = settings;
	_tmp33_ = list;
	g_settings_set_value (_tmp32_, "sources", _tmp33_);
	_tmp34_ = settings;
	_tmp35_ = self->priv->settings_act;
	_tmp36_ = pantheon_settings_daemon_accounts_service_get_active_keyboard_layout (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _variant_new1 (_tmp37_);
	g_settings_set_value (_tmp34_, "current", _tmp38_);
	_g_variant_unref0 (_tmp38_);
	_g_variant_unref0 (list);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_object_unref0 (settings);
}

GreeterUserCard*
greeter_user_card_construct (GType object_type,
                             LightDMUser* lightdm_user)
{
	GreeterUserCard * self = NULL;
	g_return_val_if_fail (lightdm_user != NULL, NULL);
	self = (GreeterUserCard*) g_object_new (object_type, "lightdm-user", lightdm_user, NULL);
	return self;
}

GreeterUserCard*
greeter_user_card_new (LightDMUser* lightdm_user)
{
	return greeter_user_card_construct (GREETER_TYPE_USER_CARD, lightdm_user);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GreeterUserCard* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda11_ (Block7Data* _data7_)
{
	GreeterUserCard* self;
	GtkStyleContext* _tmp0_;
	gboolean result;
	self = _data7_->self;
	_tmp0_ = self->priv->main_grid_style_context;
	gtk_style_context_remove_class (_tmp0_, "shake");
	gtk_style_context_remove_class (_data7_->entry_style_context, GTK_STYLE_CLASS_ERROR);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ (self);
	return result;
}

static void
greeter_user_card_real_wrong_credentials (GreeterBaseCard* base)
{
	GreeterUserCard * self;
	Block7Data* _data7_;
	GreeterPasswordEntry* _tmp0_;
	GreeterPasswordEntry* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	self = (GreeterUserCard*) base;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = self->priv->password_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->password_entry;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_data7_->entry_style_context = _tmp2_;
	gtk_style_context_add_class (_data7_->entry_style_context, GTK_STYLE_CLASS_ERROR);
	_tmp3_ = self->priv->main_grid_style_context;
	gtk_style_context_add_class (_tmp3_, "shake");
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GREETER_BASE_CARD_ERROR_SHAKE_DURATION, ___lambda11__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

LightDMUser*
greeter_user_card_get_lightdm_user (GreeterUserCard* self)
{
	LightDMUser* result;
	LightDMUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lightdm_user;
	result = _tmp0_;
	return result;
}

static void
greeter_user_card_set_lightdm_user (GreeterUserCard* self,
                                    LightDMUser* value)
{
	LightDMUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_lightdm_user (self);
	if (old_value != value) {
		LightDMUser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_lightdm_user);
		self->priv->_lightdm_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_LIGHTDM_USER_PROPERTY]);
	}
}

gboolean
greeter_user_card_get_show_input (GreeterUserCard* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_input;
	return result;
}

void
greeter_user_card_set_show_input (GreeterUserCard* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_show_input (self);
	if (old_value != value) {
		self->priv->_show_input = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_SHOW_INPUT_PROPERTY]);
	}
}

gdouble
greeter_user_card_get_reveal_ratio (GreeterUserCard* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_reveal_ratio;
	return result;
}

static void
greeter_user_card_set_reveal_ratio (GreeterUserCard* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_reveal_ratio (self);
	if (old_value != value) {
		self->priv->_reveal_ratio = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_REVEAL_RATIO_PROPERTY]);
	}
}

gboolean
greeter_user_card_get_is_24h (GreeterUserCard* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_24h;
	return result;
}

void
greeter_user_card_set_is_24h (GreeterUserCard* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_is_24h (self);
	if (old_value != value) {
		self->priv->_is_24h = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_IS_24H_PROPERTY]);
	}
}

gint
greeter_user_card_get_prefers_accent_color (GreeterUserCard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_prefers_accent_color;
	return result;
}

void
greeter_user_card_set_prefers_accent_color (GreeterUserCard* self,
                                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_prefers_accent_color (self);
	if (old_value != value) {
		self->priv->_prefers_accent_color = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_PREFERS_ACCENT_COLOR_PROPERTY]);
	}
}

gint
greeter_user_card_get_sleep_inactive_ac_timeout (GreeterUserCard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sleep_inactive_ac_timeout;
	return result;
}

void
greeter_user_card_set_sleep_inactive_ac_timeout (GreeterUserCard* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_sleep_inactive_ac_timeout (self);
	if (old_value != value) {
		self->priv->_sleep_inactive_ac_timeout = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY]);
	}
}

gint
greeter_user_card_get_sleep_inactive_ac_type (GreeterUserCard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sleep_inactive_ac_type;
	return result;
}

void
greeter_user_card_set_sleep_inactive_ac_type (GreeterUserCard* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_sleep_inactive_ac_type (self);
	if (old_value != value) {
		self->priv->_sleep_inactive_ac_type = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_AC_TYPE_PROPERTY]);
	}
}

gint
greeter_user_card_get_sleep_inactive_battery_timeout (GreeterUserCard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sleep_inactive_battery_timeout;
	return result;
}

void
greeter_user_card_set_sleep_inactive_battery_timeout (GreeterUserCard* self,
                                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_sleep_inactive_battery_timeout (self);
	if (old_value != value) {
		self->priv->_sleep_inactive_battery_timeout = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY]);
	}
}

gint
greeter_user_card_get_sleep_inactive_battery_type (GreeterUserCard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sleep_inactive_battery_type;
	return result;
}

void
greeter_user_card_set_sleep_inactive_battery_type (GreeterUserCard* self,
                                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_sleep_inactive_battery_type (self);
	if (old_value != value) {
		self->priv->_sleep_inactive_battery_type = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY]);
	}
}

static GreeterUserCardSelectionCheck*
greeter_user_card_selection_check_construct (GType object_type)
{
	GreeterUserCardSelectionCheck * self = NULL;
	self = (GreeterUserCardSelectionCheck*) g_object_new (object_type, NULL);
	return self;
}

static GreeterUserCardSelectionCheck*
greeter_user_card_selection_check_new (void)
{
	return greeter_user_card_selection_check_construct (GREETER_USER_CARD_TYPE_SELECTION_CHECK);
}

static GObject *
greeter_user_card_selection_check_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterUserCardSelectionCheck * self;
	GtkStyleContext* _tmp0_;
	GtkCssProvider* _tmp1_;
	parent_class = G_OBJECT_CLASS (greeter_user_card_selection_check_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheck);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = greeter_user_card_selection_check_check_provider;
	gtk_style_context_add_provider (_tmp0_, (GtkStyleProvider*) _tmp1_, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	return obj;
}

static void
greeter_user_card_selection_check_base_init (GreeterUserCardSelectionCheckClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), GTK_STYLE_CLASS_CHECK);
}

static void
greeter_user_card_selection_check_class_init (GreeterUserCardSelectionCheckClass * klass,
                                              gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	greeter_user_card_selection_check_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = greeter_user_card_selection_check_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_user_card_selection_check_finalize;
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (greeter_user_card_selection_check_check_provider);
	greeter_user_card_selection_check_check_provider = _tmp0_;
	_tmp1_ = greeter_user_card_selection_check_check_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/greeter/Check.css");
}

static void
greeter_user_card_selection_check_instance_init (GreeterUserCardSelectionCheck * self,
                                                 gpointer klass)
{
}

static void
greeter_user_card_selection_check_finalize (GObject * obj)
{
	GreeterUserCardSelectionCheck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheck);
	G_OBJECT_CLASS (greeter_user_card_selection_check_parent_class)->finalize (obj);
}

static GType
greeter_user_card_selection_check_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterUserCardSelectionCheckClass), (GBaseInitFunc) greeter_user_card_selection_check_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_user_card_selection_check_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterUserCardSelectionCheck), 0, (GInstanceInitFunc) greeter_user_card_selection_check_instance_init, NULL };
	GType greeter_user_card_selection_check_type_id;
	greeter_user_card_selection_check_type_id = g_type_register_static (gtk_spinner_get_type (), "GreeterUserCardSelectionCheck", &g_define_type_info, 0);
	return greeter_user_card_selection_check_type_id;
}

static GType
greeter_user_card_selection_check_get_type (void)
{
	static volatile gsize greeter_user_card_selection_check_type_id__once = 0;
	if (g_once_init_enter (&greeter_user_card_selection_check_type_id__once)) {
		GType greeter_user_card_selection_check_type_id;
		greeter_user_card_selection_check_type_id = greeter_user_card_selection_check_get_type_once ();
		g_once_init_leave (&greeter_user_card_selection_check_type_id__once, greeter_user_card_selection_check_type_id);
	}
	return greeter_user_card_selection_check_type_id__once;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GreeterUserCard* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->form_grid);
		_g_object_unref0 (_data8_->login_button);
		_g_object_unref0 (_data8_->password_grid);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_greeter_user_card_on_act_user_loaded_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	greeter_user_card_on_act_user_loaded ((GreeterUserCard*) self);
}

static gboolean
_greeter_user_card___lambda14_ (GreeterUserCard* self,
                                GtkDirectionType direction)
{
	gboolean result;
	if (direction == GTK_DIR_LEFT) {
		g_signal_emit (self, greeter_user_card_signals[GREETER_USER_CARD_GO_LEFT_SIGNAL], 0);
		result = TRUE;
		return result;
	} else {
		if (direction == GTK_DIR_RIGHT) {
			g_signal_emit (self, greeter_user_card_signals[GREETER_USER_CARD_GO_RIGHT_SIGNAL], 0);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
__greeter_user_card___lambda14__gtk_widget_focus (GtkWidget* _sender,
                                                  GtkDirectionType direction,
                                                  gpointer self)
{
	gboolean result;
	result = _greeter_user_card___lambda14_ ((GreeterUserCard*) self, direction);
	return result;
}

static gboolean
_greeter_user_card___lambda15_ (GreeterUserCard* self,
                                GdkEventButton* event)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_show_input;
	if (!_tmp0_) {
		GreeterPasswordEntry* _tmp1_;
		g_signal_emit (self, greeter_user_card_signals[GREETER_USER_CARD_FOCUS_REQUESTED_SIGNAL], 0);
		_tmp1_ = self->priv->password_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	}
	result = FALSE;
	return result;
}

static gboolean
__greeter_user_card___lambda15__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                 GdkEventButton* event,
                                                                 gpointer self)
{
	gboolean result;
	result = _greeter_user_card___lambda15_ ((GreeterUserCard*) self, event);
	return result;
}

static void
_greeter_user_card___lambda16_ (Block8Data* _data8_,
                                GtkAllocation* alloc)
{
	GreeterUserCard* self;
	gint total_height = 0;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkGrid* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkAllocation _tmp7_;
	self = _data8_->self;
	g_return_if_fail (alloc != NULL);
	_tmp0_ = _data8_->form_grid;
	_tmp1_ = _data8_->form_grid;
	_tmp2_ = gtk_widget_get_margin_top ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data8_->form_grid;
	_tmp5_ = gtk_widget_get_margin_bottom ((GtkWidget*) _tmp4_);
	_tmp6_ = _tmp5_;
	total_height = (gtk_widget_get_allocated_height ((GtkWidget*) _tmp0_) + _tmp3_) + _tmp6_;
	_tmp7_ = *alloc;
	greeter_user_card_set_reveal_ratio (self, ((gdouble) _tmp7_.height) / ((gdouble) total_height));
}

static void
__greeter_user_card___lambda16__gtk_widget_size_allocate (GtkWidget* _sender,
                                                          GtkAllocation* allocation,
                                                          gpointer self)
{
	_greeter_user_card___lambda16_ (self, allocation);
}

static void
_greeter_user_card___lambda17_ (GreeterUserCard* self)
{
	greeter_user_card_update_collapsed_class (self);
}

static void
__greeter_user_card___lambda17__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_greeter_user_card___lambda17_ ((GreeterUserCard*) self);
}

static void
_greeter_user_card___lambda18_ (GreeterUserCard* self)
{
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp1_ = gtk_revealer_get_child_revealed ((GtkRevealer*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = 1.0;
	} else {
		_tmp0_ = 0.0;
	}
	greeter_user_card_set_reveal_ratio (self, _tmp0_);
}

static void
__greeter_user_card___lambda18__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_greeter_user_card___lambda18_ ((GreeterUserCard*) self);
}

static void
_greeter_user_card_on_login_gtk_entry_activate (GtkEntry* _sender,
                                                gpointer self)
{
	greeter_user_card_on_login ((GreeterUserCard*) self);
}

static void
_greeter_user_card_on_login_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	greeter_user_card_on_login ((GreeterUserCard*) self);
}

static void
_greeter_user_card___lambda19_ (Block8Data* _data8_)
{
	GreeterUserCard* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data8_->self;
	_tmp0_ = greeter_base_card_get_need_password ((GreeterBaseCard*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkStack* _tmp2_;
		GtkGrid* _tmp3_;
		_tmp2_ = self->priv->login_stack;
		_tmp3_ = _data8_->password_grid;
		gtk_stack_set_visible_child (_tmp2_, (GtkWidget*) _tmp3_);
	} else {
		GtkStack* _tmp4_;
		GtkButton* _tmp5_;
		_tmp4_ = self->priv->login_stack;
		_tmp5_ = _data8_->login_button;
		gtk_stack_set_visible_child (_tmp4_, (GtkWidget*) _tmp5_);
	}
}

static void
__greeter_user_card___lambda19__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_greeter_user_card___lambda19_ (self);
}

static void
_greeter_user_card___lambda20_ (GreeterUserCard* self)
{
	greeter_user_card_update_style (self);
}

static void
__greeter_user_card___lambda20__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_greeter_user_card___lambda20_ ((GreeterUserCard*) self);
}

static void
_greeter_user_card___lambda21_ (GreeterUserCard* self)
{
	GreeterPasswordEntry* _tmp0_;
	_tmp0_ = self->priv->password_entry;
	gtk_entry_grab_focus_without_selecting ((GtkEntry*) _tmp0_);
}

static void
__greeter_user_card___lambda21__gtk_widget_grab_focus (GtkWidget* _sender,
                                                       gpointer self)
{
	_greeter_user_card___lambda21_ ((GreeterUserCard*) self);
}

static GObject *
greeter_user_card_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterUserCard * self;
	Block8Data* _data8_;
	GtkLabel* username_label = NULL;
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkStyleContext* username_label_context = NULL;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkCssProvider* _tmp8_;
	GreeterPasswordEntry* _tmp9_;
	GreeterPasswordEntry* _tmp10_;
	GtkStyleContext* _tmp11_;
	GreeterPasswordEntry* _tmp12_;
	GtkImage* fingerprint_image = NULL;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GreeterSessionButton* session_button = NULL;
	GreeterSessionButton* _tmp16_ = NULL;
	GreeterCapsLockRevealer* caps_lock_revealer = NULL;
	GreeterCapsLockRevealer* _tmp17_;
	GtkGrid* _tmp18_ = NULL;
	GtkGrid* _tmp19_;
	GreeterPasswordEntry* _tmp20_;
	GtkGrid* _tmp21_;
	GtkImage* _tmp22_;
	GtkGrid* _tmp23_;
	GreeterCapsLockRevealer* _tmp24_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp25_;
	GtkSizeGroup* _tmp26_;
	GreeterPasswordEntry* _tmp27_;
	GtkSizeGroup* _tmp28_;
	GreeterSessionButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkButton* _tmp33_;
	GtkImage* disabled_icon = NULL;
	GtkImage* _tmp34_;
	GtkLabel* disabled_message = NULL;
	GtkLabel* _tmp35_;
	GtkGrid* disabled_grid = NULL;
	GtkGrid* _tmp36_ = NULL;
	GtkGrid* _tmp37_;
	GtkStyleContext* _tmp38_;
	GtkGrid* _tmp39_;
	GtkImage* _tmp40_;
	GtkGrid* _tmp41_;
	GtkLabel* _tmp42_;
	GtkStack* _tmp43_;
	GtkStack* _tmp44_;
	GtkGrid* _tmp45_;
	GtkStack* _tmp46_;
	GtkButton* _tmp47_;
	GtkStack* _tmp48_;
	GtkGrid* _tmp49_;
	GtkGrid* _tmp50_ = NULL;
	GtkGrid* _tmp51_;
	GtkStack* _tmp52_;
	GtkGrid* _tmp53_;
	GreeterSessionButton* _tmp54_;
	GtkRevealer* _tmp55_ = NULL;
	GtkRevealer* _tmp56_;
	GtkGrid* _tmp57_;
	GtkRevealer* _tmp58_;
	gchar* background_path = NULL;
	LightDMUser* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	GreeterBackgroundImage* background_image = NULL;
	const gchar* _tmp85_;
	GreeterBackgroundImage* _tmp86_;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp87_ = NULL;
	GtkGrid* _tmp88_;
	GreeterBackgroundImage* _tmp89_;
	GtkGrid* _tmp90_;
	GtkLabel* _tmp91_;
	GtkGrid* _tmp92_;
	GtkRevealer* _tmp93_;
	GtkGrid* _tmp94_;
	GtkStyleContext* _tmp95_;
	GtkStyleContext* _tmp96_;
	GtkStyleContext* _tmp97_;
	GtkStyleContext* _tmp98_;
	GtkCssProvider* _tmp99_;
	HdyAvatar* avatar = NULL;
	LightDMUser* _tmp100_;
	const gchar* _tmp101_;
	const gchar* _tmp102_;
	HdyAvatar* _tmp103_ = NULL;
	HdyAvatar* _tmp104_;
	LightDMUser* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	GFile* _tmp108_;
	GFile* _tmp109_;
	GFileIcon* _tmp110_;
	GFileIcon* _tmp111_;
	GtkOverlay* avatar_overlay = NULL;
	GtkOverlay* _tmp112_ = NULL;
	GtkOverlay* _tmp113_;
	HdyAvatar* _tmp114_;
	GreeterUserCardSelectionCheck* _tmp115_ = NULL;
	GreeterUserCardSelectionCheck* _tmp116_;
	GtkStyleContext* _tmp117_;
	LightDMUser* _tmp118_;
	gboolean _tmp119_;
	gboolean _tmp120_;
	GtkOverlay* card_overlay = NULL;
	GtkOverlay* _tmp125_ = NULL;
	GtkOverlay* _tmp126_;
	GtkGrid* _tmp127_;
	GtkOverlay* _tmp128_;
	GtkOverlay* _tmp129_;
	GtkOverlay* _tmp130_;
	ActUserManager* _tmp131_;
	LightDMUser* _tmp132_;
	const gchar* _tmp133_;
	const gchar* _tmp134_;
	ActUser* _tmp135_;
	ActUser* _tmp136_;
	ActUser* _tmp137_;
	GtkLabel* _tmp138_;
	ActUser* _tmp139_;
	GreeterSessionButton* _tmp140_;
	ActUser* _tmp141_;
	GtkOverlay* _tmp142_;
	GtkOverlay* _tmp143_;
	GtkRevealer* _tmp144_;
	GreeterPasswordEntry* _tmp145_;
	GtkButton* _tmp146_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (greeter_user_card_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_USER_CARD, GreeterUserCard);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	greeter_base_card_set_need_password ((GreeterBaseCard*) self, TRUE);
	_tmp0_ = self->priv->_lightdm_user;
	_tmp1_ = lightdm_user_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_set ((GtkWidget*) _tmp3_, "margin", 24, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 12);
	g_object_ref_sink (_tmp3_);
	username_label = _tmp3_;
	_tmp4_ = username_label;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	username_label_context = _tmp5_;
	_tmp6_ = username_label_context;
	gtk_style_context_add_class (_tmp6_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp7_ = username_label_context;
	_tmp8_ = greeter_base_card_css_provider;
	gtk_style_context_add_provider (_tmp7_, (GtkStyleProvider*) _tmp8_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp9_ = greeter_password_entry_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp9_;
	_tmp10_ = self->priv->password_entry;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	self->priv->password_entry_context = _tmp11_;
	_tmp12_ = self->priv->password_entry;
	g_object_bind_property_with_closures ((GObject*) self, "connecting", (GObject*) _tmp12_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("fingerprint-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp13_);
	fingerprint_image = _tmp13_;
	_tmp14_ = fingerprint_image;
	g_object_bind_property_with_closures ((GObject*) self, "use-fingerprint", (GObject*) _tmp14_, "no-show-all", G_BINDING_INVERT_BOOLEAN | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp15_ = fingerprint_image;
	g_object_bind_property_with_closures ((GObject*) self, "use-fingerprint", (GObject*) _tmp15_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = greeter_session_button_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp16_);
	session_button = _tmp16_;
	_tmp17_ = greeter_caps_lock_revealer_new ();
	g_object_ref_sink (_tmp17_);
	caps_lock_revealer = _tmp17_;
	_tmp18_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp18_, 6);
	gtk_grid_set_row_spacing (_tmp18_, 6);
	g_object_ref_sink (_tmp18_);
	_data8_->password_grid = _tmp18_;
	_tmp19_ = _data8_->password_grid;
	_tmp20_ = self->priv->password_entry;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 0, 0, 1, 1);
	_tmp21_ = _data8_->password_grid;
	_tmp22_ = fingerprint_image;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 1, 0, 1, 1);
	_tmp23_ = _data8_->password_grid;
	_tmp24_ = caps_lock_revealer;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 0, 1, 2, 1);
	_tmp25_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	size_group = _tmp25_;
	_tmp26_ = size_group;
	_tmp27_ = self->priv->password_entry;
	gtk_size_group_add_widget (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = size_group;
	_tmp29_ = session_button;
	gtk_size_group_add_widget (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkButton*) gtk_button_new_with_label (_ ("Log In"));
	g_object_ref_sink (_tmp30_);
	_data8_->login_button = _tmp30_;
	_tmp31_ = _data8_->login_button;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
	gtk_style_context_add_class (_tmp32_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp33_ = _data8_->login_button;
	g_object_bind_property_with_closures ((GObject*) self, "connecting", (GObject*) _tmp33_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp34_);
	disabled_icon = _tmp34_;
	_tmp35_ = (GtkLabel*) gtk_label_new (_ ("Account disabled"));
	g_object_ref_sink (_tmp35_);
	disabled_message = _tmp35_;
	_tmp36_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp36_, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp36_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp36_, 3);
	g_object_ref_sink (_tmp36_);
	disabled_grid = _tmp36_;
	_tmp37_ = disabled_grid;
	_tmp38_ = gtk_widget_get_style_context ((GtkWidget*) _tmp37_);
	gtk_style_context_add_class (_tmp38_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp39_ = disabled_grid;
	_tmp40_ = disabled_icon;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = disabled_grid;
	_tmp42_ = disabled_message;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->login_stack);
	self->priv->login_stack = _tmp43_;
	_tmp44_ = self->priv->login_stack;
	_tmp45_ = _data8_->password_grid;
	gtk_stack_add_named (_tmp44_, (GtkWidget*) _tmp45_, "password");
	_tmp46_ = self->priv->login_stack;
	_tmp47_ = _data8_->login_button;
	gtk_stack_add_named (_tmp46_, (GtkWidget*) _tmp47_, "button");
	_tmp48_ = self->priv->login_stack;
	_tmp49_ = disabled_grid;
	gtk_stack_add_named (_tmp48_, (GtkWidget*) _tmp49_, "disabled");
	_tmp50_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp50_, 6);
	g_object_set ((GtkWidget*) _tmp50_, "margin", 24, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp50_, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp50_, 12);
	gtk_grid_set_row_spacing (_tmp50_, 12);
	g_object_ref_sink (_tmp50_);
	_data8_->form_grid = _tmp50_;
	_tmp51_ = _data8_->form_grid;
	_tmp52_ = self->priv->login_stack;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = _data8_->form_grid;
	_tmp54_ = session_button;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp55_, 12);
	gtk_revealer_set_reveal_child (_tmp55_, TRUE);
	gtk_revealer_set_transition_type (_tmp55_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->form_revealer);
	self->priv->form_revealer = _tmp55_;
	_tmp56_ = self->priv->form_revealer;
	_tmp57_ = _data8_->form_grid;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = self->priv->form_revealer;
	g_object_bind_property_with_closures ((GObject*) self, "show-input", (GObject*) _tmp58_, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp59_ = self->priv->_lightdm_user;
	_tmp60_ = lightdm_user_get_background (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = g_strdup (_tmp61_);
	background_path = _tmp62_;
	_tmp63_ = background_path;
	if (_tmp63_ == NULL) {
		gchar* path = NULL;
		LightDMUser* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		gchar* _tmp67_;
		const gchar* _tmp68_;
		_tmp64_ = self->priv->_lightdm_user;
		_tmp65_ = lightdm_user_get_name (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_build_filename ("/", "var", "lib", "lightdm-data", _tmp66_, "wallpaper", NULL);
		path = _tmp67_;
		_tmp68_ = path;
		if (g_file_test (_tmp68_, G_FILE_TEST_EXISTS)) {
			GFile* background_directory = NULL;
			const gchar* _tmp69_;
			GFile* _tmp70_;
			_tmp69_ = path;
			_tmp70_ = g_file_new_for_path (_tmp69_);
			background_directory = _tmp70_;
			{
				GFileEnumerator* enumerator = NULL;
				GFile* _tmp71_;
				GFileEnumerator* _tmp72_;
				GFileInfo* file_info = NULL;
				_tmp71_ = background_directory;
				_tmp72_ = g_file_enumerate_children (_tmp71_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				enumerator = _tmp72_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				while (TRUE) {
					GFileInfo* _tmp73_ = NULL;
					GFileEnumerator* _tmp74_;
					GFileInfo* _tmp75_;
					GFileInfo* _tmp76_;
					GFileInfo* _tmp77_;
					GFileInfo* _tmp78_;
					_tmp74_ = enumerator;
					_tmp75_ = g_file_enumerator_next_file (_tmp74_, NULL, &_inner_error0_);
					_tmp73_ = _tmp75_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file_info);
						_g_object_unref0 (enumerator);
						goto __catch0_g_error;
					}
					_tmp76_ = _tmp73_;
					_tmp73_ = NULL;
					_g_object_unref0 (file_info);
					file_info = _tmp76_;
					_tmp77_ = file_info;
					if (!(_tmp77_ != NULL)) {
						_g_object_unref0 (_tmp73_);
						break;
					}
					_tmp78_ = file_info;
					if (g_file_info_get_file_type (_tmp78_) == G_FILE_TYPE_REGULAR) {
						const gchar* _tmp79_;
						GFileInfo* _tmp80_;
						const gchar* _tmp81_;
						gchar* _tmp82_;
						_tmp79_ = path;
						_tmp80_ = file_info;
						_tmp81_ = g_file_info_get_name (_tmp80_);
						_tmp82_ = g_build_filename (_tmp79_, _tmp81_, NULL);
						_g_free0 (background_path);
						background_path = _tmp82_;
						_g_object_unref0 (_tmp73_);
						break;
					}
					_g_object_unref0 (_tmp73_);
				}
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp83_;
				const gchar* _tmp84_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp83_ = e;
				_tmp84_ = _tmp83_->message;
				g_critical ("UserCard.vala:184: %s", _tmp84_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (background_directory);
				_g_free0 (path);
				_g_free0 (background_path);
				_g_object_unref0 (disabled_grid);
				_g_object_unref0 (disabled_message);
				_g_object_unref0 (disabled_icon);
				_g_object_unref0 (size_group);
				_g_object_unref0 (caps_lock_revealer);
				_g_object_unref0 (session_button);
				_g_object_unref0 (fingerprint_image);
				_g_object_unref0 (username_label);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_g_object_unref0 (background_directory);
		}
		_g_free0 (path);
	}
	_tmp85_ = background_path;
	_tmp86_ = greeter_background_image_new (_tmp85_);
	g_object_ref_sink (_tmp86_);
	background_image = _tmp86_;
	_tmp87_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp87_, 48);
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp87_, GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp87_);
	main_grid = _tmp87_;
	_tmp88_ = main_grid;
	_tmp89_ = background_image;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = main_grid;
	_tmp91_ = username_label;
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = main_grid;
	_tmp93_ = self->priv->form_revealer;
	gtk_container_add ((GtkContainer*) _tmp92_, (GtkWidget*) _tmp93_);
	_tmp94_ = main_grid;
	_tmp95_ = gtk_widget_get_style_context ((GtkWidget*) _tmp94_);
	self->priv->main_grid_style_context = _tmp95_;
	_tmp96_ = self->priv->main_grid_style_context;
	gtk_style_context_add_class (_tmp96_, GRANITE_STYLE_CLASS_CARD);
	_tmp97_ = self->priv->main_grid_style_context;
	gtk_style_context_add_class (_tmp97_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp98_ = self->priv->main_grid_style_context;
	_tmp99_ = greeter_base_card_css_provider;
	gtk_style_context_add_provider (_tmp98_, (GtkStyleProvider*) _tmp99_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	greeter_user_card_update_collapsed_class (self);
	_tmp100_ = self->priv->_lightdm_user;
	_tmp101_ = lightdm_user_get_display_name (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = (HdyAvatar*) hdy_avatar_new (64, _tmp102_, TRUE);
	g_object_set ((GtkWidget*) _tmp103_, "margin", 6, NULL);
	g_object_ref_sink (_tmp103_);
	avatar = _tmp103_;
	_tmp104_ = avatar;
	_tmp105_ = self->priv->_lightdm_user;
	_tmp106_ = lightdm_user_get_image (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = g_file_new_for_path (_tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = (GFileIcon*) g_file_icon_new (_tmp109_);
	_tmp111_ = _tmp110_;
	hdy_avatar_set_loadable_icon (_tmp104_, (GLoadableIcon*) _tmp111_);
	_g_object_unref0 (_tmp111_);
	_g_object_unref0 (_tmp109_);
	_tmp112_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp112_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp112_, 100);
	gtk_widget_set_valign ((GtkWidget*) _tmp112_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp112_);
	avatar_overlay = _tmp112_;
	_tmp113_ = avatar_overlay;
	_tmp114_ = avatar;
	gtk_container_add ((GtkContainer*) _tmp113_, (GtkWidget*) _tmp114_);
	_tmp115_ = greeter_user_card_selection_check_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp115_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp115_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp115_);
	_g_object_unref0 (self->priv->logged_in);
	self->priv->logged_in = _tmp115_;
	_tmp116_ = self->priv->logged_in;
	_tmp117_ = gtk_widget_get_style_context ((GtkWidget*) _tmp116_);
	self->priv->logged_in_context = _tmp117_;
	_tmp118_ = self->priv->_lightdm_user;
	_tmp119_ = lightdm_user_get_logged_in (_tmp118_);
	_tmp120_ = _tmp119_;
	if (_tmp120_) {
		GtkOverlay* _tmp121_;
		GreeterUserCardSelectionCheck* _tmp122_;
		GreeterSessionButton* _tmp123_;
		GreeterSessionButton* _tmp124_;
		_tmp121_ = avatar_overlay;
		_tmp122_ = self->priv->logged_in;
		gtk_overlay_add_overlay (_tmp121_, (GtkWidget*) _tmp122_);
		_tmp123_ = session_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp123_, FALSE);
		_tmp124_ = session_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp124_, _ ("Session cannot be changed while user is logged in"));
	}
	_tmp125_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_set ((GtkWidget*) _tmp125_, "margin", 12, NULL);
	g_object_ref_sink (_tmp125_);
	card_overlay = _tmp125_;
	_tmp126_ = card_overlay;
	_tmp127_ = main_grid;
	gtk_container_add ((GtkContainer*) _tmp126_, (GtkWidget*) _tmp127_);
	_tmp128_ = card_overlay;
	_tmp129_ = avatar_overlay;
	gtk_overlay_add_overlay (_tmp128_, (GtkWidget*) _tmp129_);
	_tmp130_ = card_overlay;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp130_);
	_tmp131_ = act_user_manager_get_default ();
	_tmp132_ = self->priv->_lightdm_user;
	_tmp133_ = lightdm_user_get_name (_tmp132_);
	_tmp134_ = _tmp133_;
	_tmp135_ = act_user_manager_get_user (_tmp131_, _tmp134_);
	_tmp136_ = _g_object_ref0 (_tmp135_);
	_g_object_unref0 (self->priv->act_user);
	self->priv->act_user = _tmp136_;
	_tmp137_ = self->priv->act_user;
	_tmp138_ = username_label;
	g_object_bind_property_with_closures ((GObject*) _tmp137_, "locked", (GObject*) _tmp138_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp139_ = self->priv->act_user;
	_tmp140_ = session_button;
	g_object_bind_property_with_closures ((GObject*) _tmp139_, "locked", (GObject*) _tmp140_, "visible", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp141_ = self->priv->act_user;
	g_signal_connect_object ((GObject*) _tmp141_, "notify::is-loaded", (GCallback) _greeter_user_card_on_act_user_loaded_g_object_notify, self, 0);
	greeter_user_card_on_act_user_loaded (self);
	_tmp142_ = card_overlay;
	g_signal_connect_object ((GtkWidget*) _tmp142_, "focus", (GCallback) __greeter_user_card___lambda14__gtk_widget_focus, self, 0);
	_tmp143_ = card_overlay;
	g_signal_connect_object ((GtkWidget*) _tmp143_, "button-release-event", (GCallback) __greeter_user_card___lambda15__gtk_widget_button_release_event, self, 0);
	_tmp144_ = self->priv->form_revealer;
	g_signal_connect_data ((GtkWidget*) _tmp144_, "size-allocate", (GCallback) __greeter_user_card___lambda16__gtk_widget_size_allocate, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-input", (GCallback) __greeter_user_card___lambda17__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::child-revealed", (GCallback) __greeter_user_card___lambda18__g_object_notify, self, 0);
	_tmp145_ = self->priv->password_entry;
	g_signal_connect_object ((GtkEntry*) _tmp145_, "activate", (GCallback) _greeter_user_card_on_login_gtk_entry_activate, self, 0);
	_tmp146_ = _data8_->login_button;
	g_signal_connect_object (_tmp146_, "clicked", (GCallback) _greeter_user_card_on_login_gtk_button_clicked, self, 0);
	g_signal_connect_data ((GObject*) self, "notify::need-password", (GCallback) __greeter_user_card___lambda19__g_object_notify, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	greeter_user_card_update_style (self);
	g_signal_connect_object ((GObject*) self, "notify::prefers-accent-color", (GCallback) __greeter_user_card___lambda20__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "grab-focus", (GCallback) __greeter_user_card___lambda21__gtk_widget_grab_focus, self, 0);
	_g_object_unref0 (card_overlay);
	_g_object_unref0 (avatar_overlay);
	_g_object_unref0 (avatar);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (background_image);
	_g_free0 (background_path);
	_g_object_unref0 (disabled_grid);
	_g_object_unref0 (disabled_message);
	_g_object_unref0 (disabled_icon);
	_g_object_unref0 (size_group);
	_g_object_unref0 (caps_lock_revealer);
	_g_object_unref0 (session_button);
	_g_object_unref0 (fingerprint_image);
	_g_object_unref0 (username_label);
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return obj;
}

static void
greeter_user_card_class_init (GreeterUserCardClass * klass,
                              gpointer klass_data)
{
	greeter_user_card_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterUserCard_private_offset);
	((GreeterBaseCardClass *) klass)->wrong_credentials = (void (*) (GreeterBaseCard*)) greeter_user_card_real_wrong_credentials;
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_user_card_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_user_card_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_user_card_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_user_card_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_LIGHTDM_USER_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_LIGHTDM_USER_PROPERTY] = g_param_spec_object ("lightdm-user", "lightdm-user", "lightdm-user", lightdm_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_SHOW_INPUT_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_SHOW_INPUT_PROPERTY] = g_param_spec_boolean ("show-input", "show-input", "show-input", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_REVEAL_RATIO_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_REVEAL_RATIO_PROPERTY] = g_param_spec_double ("reveal-ratio", "reveal-ratio", "reveal-ratio", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_IS_24H_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_IS_24H_PROPERTY] = g_param_spec_boolean ("is-24h", "is-24h", "is-24h", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_PREFERS_ACCENT_COLOR_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_PREFERS_ACCENT_COLOR_PROPERTY] = g_param_spec_int ("prefers-accent-color", "prefers-accent-color", "prefers-accent-color", G_MININT, G_MAXINT, 6, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY] = g_param_spec_int ("sleep-inactive-ac-timeout", "sleep-inactive-ac-timeout", "sleep-inactive-ac-timeout", G_MININT, G_MAXINT, 1200, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_SLEEP_INACTIVE_AC_TYPE_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_AC_TYPE_PROPERTY] = g_param_spec_int ("sleep-inactive-ac-type", "sleep-inactive-ac-type", "sleep-inactive-ac-type", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY] = g_param_spec_int ("sleep-inactive-battery-timeout", "sleep-inactive-battery-timeout", "sleep-inactive-battery-timeout", G_MININT, G_MAXINT, 1200, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY] = g_param_spec_int ("sleep-inactive-battery-type", "sleep-inactive-battery-type", "sleep-inactive-battery-type", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	greeter_user_card_signals[GREETER_USER_CARD_GO_LEFT_SIGNAL] = g_signal_new ("go-left", GREETER_TYPE_USER_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	greeter_user_card_signals[GREETER_USER_CARD_GO_RIGHT_SIGNAL] = g_signal_new ("go-right", GREETER_TYPE_USER_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	greeter_user_card_signals[GREETER_USER_CARD_FOCUS_REQUESTED_SIGNAL] = g_signal_new ("focus-requested", GREETER_TYPE_USER_CARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
greeter_user_card_instance_init (GreeterUserCard * self,
                                 gpointer klass)
{
	self->priv = greeter_user_card_get_instance_private (self);
	self->priv->_show_input = FALSE;
	self->priv->_reveal_ratio = 0.0;
	self->priv->_is_24h = TRUE;
	self->priv->_prefers_accent_color = 6;
	self->priv->_sleep_inactive_ac_timeout = 1200;
	self->priv->_sleep_inactive_ac_type = 1;
	self->priv->_sleep_inactive_battery_timeout = 1200;
	self->priv->_sleep_inactive_battery_type = 1;
	self->priv->needs_keyboard_layout_set = FALSE;
}

static void
greeter_user_card_finalize (GObject * obj)
{
	GreeterUserCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_USER_CARD, GreeterUserCard);
	_g_object_unref0 (self->priv->_lightdm_user);
	_g_object_unref0 (self->priv->act_user);
	_g_object_unref0 (self->priv->greeter_act);
	_g_object_unref0 (self->priv->settings_act);
	_g_object_unref0 (self->priv->form_revealer);
	_g_object_unref0 (self->priv->login_stack);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->logged_in);
	G_OBJECT_CLASS (greeter_user_card_parent_class)->finalize (obj);
}

static GType
greeter_user_card_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterUserCardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_user_card_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterUserCard), 0, (GInstanceInitFunc) greeter_user_card_instance_init, NULL };
	GType greeter_user_card_type_id;
	greeter_user_card_type_id = g_type_register_static (GREETER_TYPE_BASE_CARD, "GreeterUserCard", &g_define_type_info, 0);
	GreeterUserCard_private_offset = g_type_add_instance_private (greeter_user_card_type_id, sizeof (GreeterUserCardPrivate));
	return greeter_user_card_type_id;
}

GType
greeter_user_card_get_type (void)
{
	static volatile gsize greeter_user_card_type_id__once = 0;
	if (g_once_init_enter (&greeter_user_card_type_id__once)) {
		GType greeter_user_card_type_id;
		greeter_user_card_type_id = greeter_user_card_get_type_once ();
		g_once_init_leave (&greeter_user_card_type_id__once, greeter_user_card_type_id);
	}
	return greeter_user_card_type_id__once;
}

static void
_vala_greeter_user_card_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GreeterUserCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_USER_CARD, GreeterUserCard);
	switch (property_id) {
		case GREETER_USER_CARD_LIGHTDM_USER_PROPERTY:
		g_value_set_object (value, greeter_user_card_get_lightdm_user (self));
		break;
		case GREETER_USER_CARD_SHOW_INPUT_PROPERTY:
		g_value_set_boolean (value, greeter_user_card_get_show_input (self));
		break;
		case GREETER_USER_CARD_REVEAL_RATIO_PROPERTY:
		g_value_set_double (value, greeter_user_card_get_reveal_ratio (self));
		break;
		case GREETER_USER_CARD_IS_24H_PROPERTY:
		g_value_set_boolean (value, greeter_user_card_get_is_24h (self));
		break;
		case GREETER_USER_CARD_PREFERS_ACCENT_COLOR_PROPERTY:
		g_value_set_int (value, greeter_user_card_get_prefers_accent_color (self));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY:
		g_value_set_int (value, greeter_user_card_get_sleep_inactive_ac_timeout (self));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_AC_TYPE_PROPERTY:
		g_value_set_int (value, greeter_user_card_get_sleep_inactive_ac_type (self));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY:
		g_value_set_int (value, greeter_user_card_get_sleep_inactive_battery_timeout (self));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY:
		g_value_set_int (value, greeter_user_card_get_sleep_inactive_battery_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_user_card_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GreeterUserCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_USER_CARD, GreeterUserCard);
	switch (property_id) {
		case GREETER_USER_CARD_LIGHTDM_USER_PROPERTY:
		greeter_user_card_set_lightdm_user (self, g_value_get_object (value));
		break;
		case GREETER_USER_CARD_SHOW_INPUT_PROPERTY:
		greeter_user_card_set_show_input (self, g_value_get_boolean (value));
		break;
		case GREETER_USER_CARD_REVEAL_RATIO_PROPERTY:
		greeter_user_card_set_reveal_ratio (self, g_value_get_double (value));
		break;
		case GREETER_USER_CARD_IS_24H_PROPERTY:
		greeter_user_card_set_is_24h (self, g_value_get_boolean (value));
		break;
		case GREETER_USER_CARD_PREFERS_ACCENT_COLOR_PROPERTY:
		greeter_user_card_set_prefers_accent_color (self, g_value_get_int (value));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY:
		greeter_user_card_set_sleep_inactive_ac_timeout (self, g_value_get_int (value));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_AC_TYPE_PROPERTY:
		greeter_user_card_set_sleep_inactive_ac_type (self, g_value_get_int (value));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY:
		greeter_user_card_set_sleep_inactive_battery_timeout (self, g_value_get_int (value));
		break;
		case GREETER_USER_CARD_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY:
		greeter_user_card_set_sleep_inactive_battery_type (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

