/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixedCentered;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class AbstractParallelFtilesBuilder {
    protected final double barHeight = 6.0;
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    protected final List<Ftile> list99 = new ArrayList<Ftile>();

    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignatureBasic getStyleSignatureArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public AbstractParallelFtilesBuilder(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> all) {
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.list99.addAll(this.getFoo2(all));
    }

    protected List<Ftile> getFoo2(List<Ftile> all) {
        double maxHeight = this.computeMaxHeight(all);
        ArrayList<Ftile> result = new ArrayList<Ftile>();
        for (Ftile ftile : all) {
            Ftile newFtile = this.computeNewFtile(ftile, maxHeight);
            result.add(newFtile);
        }
        return result;
    }

    private Ftile computeNewFtile(Ftile ftile, double maxHeight) {
        double spaceArroundBlackBar = 20.0;
        double xMargin = 14.0;
        Ftile tmp = FtileUtils.addHorizontalMargin(ftile, 14.0);
        tmp = new FtileHeightFixedCentered(tmp, maxHeight + 40.0);
        return tmp;
    }

    protected final double computeMaxHeight(List<Ftile> all) {
        double height = 0.0;
        for (Ftile tmp : all) {
            height = Math.max(height, tmp.calculateDimension(this.getStringBounder()).getHeight());
        }
        return height;
    }

    public final Ftile build(Ftile inner) {
        Ftile step1 = this.doStep1(inner);
        return this.doStep2(inner, step1);
    }

    protected abstract Ftile doStep1(Ftile var1);

    protected abstract Ftile doStep2(Ftile var1, Ftile var2);

    protected StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected Rose getRose() {
        return this.rose;
    }

    protected ISkinParam skinParam() {
        return this.skinParam;
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        Style style = this.getStyleSignatureArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
        return display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = linkRendering.getDisplay();
        return this.getTextBlock(display);
    }

    protected final double getHeightOfMiddle(Ftile middle) {
        return middle.calculateDimension(this.getStringBounder()).getHeight();
    }

    protected Swimlane swimlaneOutForStep2() {
        return this.list99.get(this.list99.size() - 1).getSwimlaneOut();
    }
}

