/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorRuntimeException;

public class CommandCreoleColorChange
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*?)\\</color\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*)$)");
    private final Pattern2 mypattern;

    @Override
    public String startingChars() {
        return "<";
    }

    public static Command create() {
        return new CommandCreoleColorChange(pattern);
    }

    public static Command createEol() {
        return new CommandCreoleColorChange(patternEol);
    }

    private CommandCreoleColorChange(Pattern2 pattern) {
        this.mypattern = pattern;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) throws NoSuchColorRuntimeException {
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        String s = m.group(2);
        try {
            HColor color = HColorSet.instance().getColor(stripe.getSkinParam().getThemeStyle(), s);
            FontConfiguration fc2 = fc1.changeColor(color);
            stripe.setActualFontConfiguration(fc2);
        }
        catch (NoSuchColorException noSuchColorException) {
            // empty catch block
        }
        stripe.analyzeAndAdd(m.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

