/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.ComponentStyle;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.USymbolActor;
import net.sourceforge.plantuml.graphic.USymbolArtifact;
import net.sourceforge.plantuml.graphic.USymbolBoundary;
import net.sourceforge.plantuml.graphic.USymbolCard;
import net.sourceforge.plantuml.graphic.USymbolCloud;
import net.sourceforge.plantuml.graphic.USymbolCollections;
import net.sourceforge.plantuml.graphic.USymbolComponent1;
import net.sourceforge.plantuml.graphic.USymbolComponent2;
import net.sourceforge.plantuml.graphic.USymbolControl;
import net.sourceforge.plantuml.graphic.USymbolDatabase;
import net.sourceforge.plantuml.graphic.USymbolEntityDomain;
import net.sourceforge.plantuml.graphic.USymbolFile;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.USymbolFrame;
import net.sourceforge.plantuml.graphic.USymbolHexagon;
import net.sourceforge.plantuml.graphic.USymbolInterface;
import net.sourceforge.plantuml.graphic.USymbolLabel;
import net.sourceforge.plantuml.graphic.USymbolNode;
import net.sourceforge.plantuml.graphic.USymbolPerson;
import net.sourceforge.plantuml.graphic.USymbolQueue;
import net.sourceforge.plantuml.graphic.USymbolRectangle;
import net.sourceforge.plantuml.graphic.USymbolStack;
import net.sourceforge.plantuml.graphic.USymbolStorage;
import net.sourceforge.plantuml.graphic.USymbolTogether;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.svek.PackageStyle;

public abstract class USymbols {
    private static final Map<String, USymbol> all = new HashMap<String, USymbol>();
    public static final USymbol STORAGE = USymbols.record("STORAGE", SkinParameter.STORAGE, new USymbolStorage());
    public static final USymbol DATABASE = USymbols.record("DATABASE", SkinParameter.DATABASE, new USymbolDatabase());
    public static final USymbol CLOUD = USymbols.record("CLOUD", SkinParameter.CLOUD, new USymbolCloud());
    public static final USymbol CARD = USymbols.record("CARD", SkinParameter.CARD, new USymbolCard(SkinParameter.CARD));
    public static final USymbol FRAME = USymbols.record("FRAME", SkinParameter.FRAME, new USymbolFrame());
    public static final USymbol NODE = USymbols.record("NODE", SkinParameter.NODE, new USymbolNode());
    public static final USymbol ARTIFACT = USymbols.record("ARTIFACT", SkinParameter.ARTIFACT, new USymbolArtifact());
    public static final USymbol PACKAGE = USymbols.record("PACKAGE", SkinParameter.PACKAGE, new USymbolFolder(SName.package_, SkinParameter.PACKAGE, true));
    public static final USymbol FOLDER = USymbols.record("FOLDER", SkinParameter.FOLDER, new USymbolFolder(SName.folder, SkinParameter.FOLDER, false));
    public static final USymbol FILE = USymbols.record("FILE", SkinParameter.FILE, new USymbolFile());
    public static final USymbol RECTANGLE = USymbols.record("RECTANGLE", SkinParameter.RECTANGLE, new USymbolRectangle(SkinParameter.RECTANGLE));
    public static final USymbol HEXAGON = USymbols.record("HEXAGON", SkinParameter.HEXAGON, new USymbolHexagon());
    public static final USymbol PERSON = USymbols.record("PERSON", SkinParameter.PERSON, new USymbolPerson());
    public static final USymbol LABEL = USymbols.record("LABEL", SkinParameter.LABEL, new USymbolLabel(SkinParameter.LABEL));
    public static final USymbol ARCHIMATE = USymbols.record("ARCHIMATE", SkinParameter.ARCHIMATE, new USymbolRectangle(SkinParameter.ARCHIMATE));
    public static final USymbol COLLECTIONS = USymbols.record("COLLECTIONS", SkinParameter.COLLECTIONS, new USymbolCollections(SkinParameter.COLLECTIONS));
    public static final USymbol AGENT = USymbols.record("AGENT", SkinParameter.AGENT, new USymbolRectangle(SkinParameter.AGENT));
    public static final USymbol ACTOR_STICKMAN = USymbols.record("ACTOR_STICKMAN", SkinParameter.ACTOR, new USymbolActor(ActorStyle.STICKMAN));
    public static final USymbol ACTOR_STICKMAN_BUSINESS = USymbols.record("ACTOR_STICKMAN_BUSINESS", SkinParameter.ACTOR, new USymbolActor(ActorStyle.STICKMAN_BUSINESS));
    public static final USymbol ACTOR_AWESOME = USymbols.record("ACTOR_AWESOME", SkinParameter.ACTOR, new USymbolActor(ActorStyle.AWESOME));
    public static final USymbol ACTOR_HOLLOW = USymbols.record("ACTOR_HOLLOW", SkinParameter.ACTOR, new USymbolActor(ActorStyle.HOLLOW));
    public static final USymbol USECASE = null;
    public static final USymbol COMPONENT1 = USymbols.record("COMPONENT1", SkinParameter.COMPONENT1, new USymbolComponent1());
    public static final USymbol COMPONENT2 = USymbols.record("COMPONENT2", SkinParameter.COMPONENT2, new USymbolComponent2());
    public static final USymbol BOUNDARY = USymbols.record("BOUNDARY", SkinParameter.BOUNDARY, new USymbolBoundary());
    public static final USymbol ENTITY_DOMAIN = USymbols.record("ENTITY_DOMAIN", SkinParameter.ENTITY, new USymbolEntityDomain());
    public static final USymbol CONTROL = USymbols.record("CONTROL", SkinParameter.CONTROL, new USymbolControl());
    public static final USymbol INTERFACE = USymbols.record("INTERFACE", SkinParameter.INTERFACE, new USymbolInterface());
    public static final USymbol QUEUE = USymbols.record("QUEUE", SkinParameter.QUEUE, new USymbolQueue());
    public static final USymbol STACK = USymbols.record("STACK", SkinParameter.STACK, new USymbolStack());
    public static final USymbol TOGETHER = USymbols.record("TOGETHER", SkinParameter.QUEUE, new USymbolTogether());

    private USymbols() {
    }

    private static USymbol record(String code, SkinParameter skinParameter, USymbol symbol) {
        all.put(StringUtils.goUpperCase(code), symbol);
        return symbol;
    }

    public static USymbol fromString(String s, ActorStyle actorStyle, ComponentStyle componentStyle, PackageStyle packageStyle) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("package")) {
            return packageStyle.toUSymbol();
        }
        if (s.equalsIgnoreCase("actor")) {
            return actorStyle.toUSymbol();
        }
        if (s.equalsIgnoreCase("component")) {
            return componentStyle.toUSymbol();
        }
        if (s.equalsIgnoreCase("entity")) {
            return ENTITY_DOMAIN;
        }
        if (s.equalsIgnoreCase("circle")) {
            return INTERFACE;
        }
        USymbol result = all.get(StringUtils.goUpperCase(s.replaceAll("\\W", "")));
        return result;
    }

    public static USymbol fromString(String symbol, ISkinParam skinParam) {
        USymbol usymbol = null;
        if (symbol.equalsIgnoreCase("artifact")) {
            usymbol = ARTIFACT;
        } else if (symbol.equalsIgnoreCase("folder")) {
            usymbol = FOLDER;
        } else if (symbol.equalsIgnoreCase("file")) {
            usymbol = FILE;
        } else if (symbol.equalsIgnoreCase("package")) {
            usymbol = PACKAGE;
        } else if (symbol.equalsIgnoreCase("rectangle")) {
            usymbol = RECTANGLE;
        } else if (symbol.equalsIgnoreCase("person")) {
            usymbol = PERSON;
        } else if (symbol.equalsIgnoreCase("hexagon")) {
            usymbol = HEXAGON;
        } else if (symbol.equalsIgnoreCase("label")) {
            usymbol = LABEL;
        } else if (symbol.equalsIgnoreCase("collections")) {
            usymbol = COLLECTIONS;
        } else if (symbol.equalsIgnoreCase("node")) {
            usymbol = NODE;
        } else if (symbol.equalsIgnoreCase("frame")) {
            usymbol = FRAME;
        } else if (symbol.equalsIgnoreCase("cloud")) {
            usymbol = CLOUD;
        } else if (symbol.equalsIgnoreCase("database")) {
            usymbol = DATABASE;
        } else if (symbol.equalsIgnoreCase("queue")) {
            usymbol = QUEUE;
        } else if (symbol.equalsIgnoreCase("stack")) {
            usymbol = STACK;
        } else if (symbol.equalsIgnoreCase("storage")) {
            usymbol = STORAGE;
        } else if (symbol.equalsIgnoreCase("agent")) {
            usymbol = AGENT;
        } else if (symbol.equalsIgnoreCase("actor/")) {
            usymbol = ACTOR_STICKMAN_BUSINESS;
        } else if (symbol.equalsIgnoreCase("actor")) {
            usymbol = skinParam.actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("component")) {
            usymbol = skinParam.componentStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("boundary")) {
            usymbol = BOUNDARY;
        } else if (symbol.equalsIgnoreCase("control")) {
            usymbol = CONTROL;
        } else if (symbol.equalsIgnoreCase("entity")) {
            usymbol = ENTITY_DOMAIN;
        } else if (symbol.equalsIgnoreCase("card")) {
            usymbol = CARD;
        } else if (symbol.equalsIgnoreCase("interface")) {
            usymbol = INTERFACE;
        } else if (symbol.equalsIgnoreCase("()")) {
            usymbol = INTERFACE;
        }
        return usymbol;
    }
}

