/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SequenceDiagramFileMakerPuma2
implements FileMaker {
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private final StringBounder stringBounder;

    public SequenceDiagramFileMakerPuma2(SequenceDiagram diagram, Rose skin, FileFormatOption fileFormatOption) {
        this.diagram = diagram;
        this.stringBounder = fileFormatOption.getDefaultStringBounder(diagram.getSkinParam());
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer initializer = new DrawableSetInitializer(skin, diagram.getSkinParam(), diagram.isShowFootbox(), diagram.getAutonewpage());
        for (Participant participant : diagram.participants()) {
            initializer.addParticipant(participant, diagram.getEnglober(participant));
        }
        for (Event event : diagram.events()) {
            initializer.addEvent(event);
        }
        this.drawableSet = initializer.createDrawableSet(this.stringBounder);
        ArrayList<Newpage> newpages = new ArrayList<Newpage>();
        for (Event ev : this.drawableSet.getAllEvents()) {
            if (!(ev instanceof Newpage)) continue;
            newpages.add((Newpage)ev);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        for (Newpage n : newpages) {
            linkedHashMap.put(n, initializer.getYposition(this.stringBounder, n));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, diagram.isShowFootbox(), diagram.getTitle().getDisplay()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> positions, boolean showFootbox, Display title) {
        double headerHeight = drawableSet.getHeadHeight(this.stringBounder);
        double tailHeight = drawableSet.getTailHeight(this.stringBounder, showFootbox);
        double signatureHeight = 0.0;
        double newpageHeight = drawableSet.getSkin().createComponentNewPage(drawableSet.getSkinParam()).getPreferredHeight(this.stringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), headerHeight, positions, tailHeight, 0.0, newpageHeight, title);
    }

    @Override
    public ImageData createOne(OutputStream os, final int index, boolean isWithMetadata) throws IOException {
        TextBlock legendBlock;
        TextBlock compTitle;
        final Page page = this.pages.get(index);
        final SequenceDiagramArea area = new SequenceDiagramArea(this.fullDimension.getWidth(), page.getHeight());
        final AnnotatedWorker annotatedWorker = new AnnotatedWorker(this.diagram, this.diagram.getSkinParam(), this.stringBounder);
        final TextBlock caption = annotatedWorker.getCaption();
        area.setCaptionArea(caption.calculateDimension(this.stringBounder));
        if (Display.isNull(page.getTitle())) {
            compTitle = null;
        } else {
            if (UseStyle.useBetaStyle()) {
                Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.title).getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder());
                compTitle = style.createTextBlockBordered(page.getTitle(), this.diagram.getSkinParam().getIHtmlColorSet(), this.diagram.getSkinParam());
            } else {
                compTitle = TextBlockUtils.withMargin(TextBlockUtils.title(FontConfiguration.create(this.drawableSet.getSkinParam(), FontParam.TITLE, null), page.getTitle(), this.drawableSet.getSkinParam()), 7.0, 7.0);
            }
            Dimension2D dimTitle = compTitle.calculateDimension(this.stringBounder);
            area.setTitleArea(dimTitle.getWidth(), dimTitle.getHeight());
        }
        area.initFooter(this.getPngTitler(FontParam.FOOTER, index), this.stringBounder);
        area.initHeader(this.getPngTitler(FontParam.HEADER, index), this.stringBounder);
        if (this.diagram.getLegend().isNull()) {
            legendBlock = TextBlockUtils.empty(0.0, 0.0);
        } else if (UseStyle.useBetaStyle()) {
            Style style = StyleSignatureBasic.of(SName.root, SName.document, SName.legend).getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder());
            legendBlock = style.createTextBlockBordered(this.diagram.getLegend().getDisplay(), this.diagram.getSkinParam().getIHtmlColorSet(), this.diagram.getSkinParam());
        } else {
            legendBlock = EntityImageLegend.create(this.diagram.getLegend().getDisplay(), this.diagram.getSkinParam());
        }
        Dimension2D dimLegend = legendBlock.calculateDimension(this.stringBounder);
        area.setLegend(dimLegend, this.isLegendTop(), this.diagram.getLegend().getHorizontalAlignment());
        UDrawable drawable = new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                double delta = 0.0;
                if (index > 0) {
                    delta = page.getNewpage1() - page.getHeaderHeight();
                }
                if (delta < 0.0) {
                    delta = 0.0;
                }
                if (compTitle != null) {
                    HColor back = SequenceDiagramFileMakerPuma2.this.diagram.calculateBackColor();
                    compTitle.drawU(ug.apply(back.bg()).apply(new UTranslate(area.getTitleX(), area.getTitleY())));
                }
                caption.drawU(ug.apply(new UTranslate(area.getCaptionX(), area.getCaptionY())));
                double delta1 = Math.max(0.0, area.getLegendWidth() - area.getWidth());
                UTranslate forCore = new UTranslate(area.getSequenceAreaX() + delta1 / 2.0, area.getSequenceAreaY());
                TextBlock core = SequenceDiagramFileMakerPuma2.this.drawableSet.asTextBlock(delta, SequenceDiagramFileMakerPuma2.this.fullDimension.getWidth(), page, SequenceDiagramFileMakerPuma2.this.diagram.isShowFootbox());
                core = annotatedWorker.addFrame(core);
                core.drawU(ug.apply(forCore));
                SequenceDiagramFileMakerPuma2.this.drawHeader(area, ug, index);
                SequenceDiagramFileMakerPuma2.this.drawFooter(area, ug, index);
                if (area.hasLegend()) {
                    legendBlock.drawU(ug.apply(new UTranslate(area.getLegendX(), area.getLegendY())));
                }
            }
        };
        return this.diagram.createImageBuilder(this.fileFormatOption).drawable(drawable).write(os);
    }

    private void drawFooter(SequenceDiagramArea area, UGraphic ug, int page) {
        PngTitler pngTitler = this.getPngTitler(FontParam.FOOTER, page);
        TextBlock text = pngTitler.getRibbonBlock();
        if (text == null) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(area.getFooterX(this.diagram.getFooter().getHorizontalAlignment()), area.getFooterY())));
    }

    private void drawHeader(SequenceDiagramArea area, UGraphic ug, int page) {
        PngTitler pngTitler = this.getPngTitler(FontParam.HEADER, page);
        TextBlock text = pngTitler.getRibbonBlock();
        if (text == null) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(area.getHeaderX(this.diagram.getHeader().getHorizontalAlignment()), area.getHeaderY())));
    }

    private PngTitler getPngTitler(FontParam fontParam, int page) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        DisplaySection display = this.diagram.getFooterOrHeaderTeoz(fontParam).withPage(page + 1, this.pages.size());
        StyleSignatureBasic def = fontParam.getStyleDefinition(null);
        Style style = def.getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new PngTitler(display, style, skinParam.getIHtmlColorSet(), skinParam);
    }

    private boolean isLegendTop() {
        return !this.diagram.getLegend().isNull() && this.diagram.getLegend().getVerticalAlignment() == VerticalAlignment.TOP;
    }
}

