/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;

public abstract class AbstractEntityImageBorder
extends AbstractEntityImage {
    public final EntityPosition entityPosition;
    protected final Cluster parent;
    protected final Bibliotekon bibliotekon;
    protected final Rankdir rankdir;
    protected final TextBlock desc;

    AbstractEntityImageBorder(ILeaf leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon, FontParam fontParam) {
        super(leaf, skinParam);
        this.parent = parent;
        this.bibliotekon = bibliotekon;
        this.entityPosition = leaf.getEntityPosition();
        this.rankdir = skinParam.getRankdir();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        Stereotype stereotype = leaf.getStereotype();
        FontConfiguration fc = FontConfiguration.create(skinParam, fontParam, stereotype);
        this.desc = leaf.getDisplay().create(fc, HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.entityPosition.getDimension(this.rankdir);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    @Override
    public ShapeType getShapeType() {
        return this.entityPosition.getShapeType();
    }
}

