/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.protege.editor.owl.ui.util.ProgressDialog;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologySaver {
    private final Logger logger = LoggerFactory.getLogger(OntologySaver.class);
    private final List<OntologySaveDescriptor> saveDescriptors = new ArrayList<OntologySaveDescriptor>();
    private final ProgressDialog dlg = new ProgressDialog();
    private ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

    private OntologySaver(List<OntologySaveDescriptor> saveDescriptors) {
        this.saveDescriptors.addAll(saveDescriptors);
    }

    public void saveOntologies() throws OWLOntologyStorageException {
        ListenableFuture future = this.executorService.submit(() -> {
            try {
                Void void_ = this.saveOntologyInternal();
                return void_;
            }
            finally {
                this.dlg.setVisible(false);
            }
        });
        this.dlg.setVisible(true);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            this.logger.info("Save was interrupted");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OWLOntologyStorageException) {
                throw (OWLOntologyStorageException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            this.logger.info("An error occurred during save: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void saveOntologyInternal() throws OWLOntologyStorageException {
        for (OntologySaveDescriptor descriptor : this.saveDescriptors) {
            try {
                OWLOntology ontology = descriptor.getOntology();
                OntologyIRIShortFormProvider sfp = new OntologyIRIShortFormProvider();
                String ontologyShortForm = sfp.getShortForm(ontology);
                this.logger.info("Saving {}", (Object)ontologyShortForm);
                this.dlg.setMessage(String.format("Saving ontology: %s", ontologyShortForm));
                IRI documentIRI = descriptor.getDocumentIRI();
                this.dlg.setSubMessage(String.format("Location: %s", OntologySaver.formatIRI(documentIRI)));
                if ("file".equals(documentIRI.getScheme())) {
                    File tempFile = File.createTempFile("temp-ontology", "");
                    try {
                        this.logger.info("Saving ontology to temp file: {}", (Object)tempFile);
                        ontology.saveOntology(descriptor.getDocumentFormat(), IRI.create((File)tempFile));
                        File destFile = new File(documentIRI.toURI());
                        this.logger.info("Copying ontology from temp file ({}) to actual destination ({})", (Object)tempFile, (Object)destFile);
                        FileUtils.copyFile((File)tempFile, (File)destFile);
                        continue;
                    }
                    finally {
                        this.logger.info("Removing temp file: {}", (Object)tempFile);
                        FileUtils.deleteQuietly((File)tempFile);
                        continue;
                    }
                }
                this.logger.info("Saving ontology to: {}", (Object)documentIRI);
                ontology.saveOntology(descriptor.getDocumentFormat(), documentIRI);
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException((Throwable)e);
            }
        }
        return null;
    }

    private static String formatIRI(IRI iri) {
        if ("file".equals(iri.getScheme())) {
            return new File(iri.toString()).toString();
        }
        return iri.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class OntologySaveDescriptor {
        private final OWLOntology ontology;
        private final OWLDocumentFormat documentFormat;
        private final IRI documentIRI;

        public OntologySaveDescriptor(OWLOntology ontology, OWLDocumentFormat documentFormat, IRI documentIRI) {
            this.ontology = (OWLOntology)Preconditions.checkNotNull((Object)ontology);
            this.documentFormat = (OWLDocumentFormat)Preconditions.checkNotNull((Object)documentFormat);
            this.documentIRI = (IRI)Preconditions.checkNotNull((Object)documentIRI);
        }

        public OWLOntology getOntology() {
            return this.ontology;
        }

        public OWLDocumentFormat getDocumentFormat() {
            return this.documentFormat;
        }

        public IRI getDocumentIRI() {
            return this.documentIRI;
        }
    }

    public static class Builder {
        private final List<OntologySaveDescriptor> saveDescriptors = new ArrayList<OntologySaveDescriptor>();

        public Builder addOntology(OWLOntology ontology, OWLDocumentFormat documentFormat, IRI documentIRI) {
            this.saveDescriptors.add(new OntologySaveDescriptor(ontology, documentFormat, documentIRI));
            return this;
        }

        public OntologySaver build() {
            return new OntologySaver(this.saveDescriptors);
        }
    }
}

