// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from e310x.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/SiFive-Community

//go:build sifive && fe310
// +build sifive,fe310

//
//

package sifive

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "FE310"
)

// Interrupt numbers.
const (
	// Watchdog
	IRQ_WATCHDOG = 1

	// Watchdog
	IRQ_RTC = 2

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART0 = 3

	IRQ_UART1 = 4

	// Quad Serial Peripheral Interface
	IRQ_QSPI0 = 5

	IRQ_QSPI1 = 6

	IRQ_QSPI2 = 7

	// General Purpose Input Output
	IRQ_GPIO0 = 8

	// General Purpose Input Output
	IRQ_GPIO1 = 9

	// General Purpose Input Output
	IRQ_GPIO2 = 10

	// General Purpose Input Output
	IRQ_GPIO3 = 11

	// General Purpose Input Output
	IRQ_GPIO4 = 12

	// General Purpose Input Output
	IRQ_GPIO5 = 13

	// General Purpose Input Output
	IRQ_GPIO6 = 14

	// General Purpose Input Output
	IRQ_GPIO7 = 15

	// General Purpose Input Output
	IRQ_GPIO8 = 16

	// General Purpose Input Output
	IRQ_GPIO9 = 17

	// General Purpose Input Output
	IRQ_GPIO10 = 18

	// General Purpose Input Output
	IRQ_GPIO11 = 19

	// General Purpose Input Output
	IRQ_GPIO12 = 20

	// General Purpose Input Output
	IRQ_GPIO13 = 21

	// General Purpose Input Output
	IRQ_GPIO14 = 22

	// General Purpose Input Output
	IRQ_GPIO15 = 23

	// General Purpose Input Output
	IRQ_GPIO16 = 24

	// General Purpose Input Output
	IRQ_GPIO17 = 25

	// General Purpose Input Output
	IRQ_GPIO18 = 26

	// General Purpose Input Output
	IRQ_GPIO19 = 27

	// General Purpose Input Output
	IRQ_GPIO20 = 28

	// General Purpose Input Output
	IRQ_GPIO21 = 29

	// General Purpose Input Output
	IRQ_GPIO22 = 30

	// General Purpose Input Output
	IRQ_GPIO23 = 31

	// General Purpose Input Output
	IRQ_GPIO24 = 32

	// General Purpose Input Output
	IRQ_GPIO25 = 33

	// General Purpose Input Output
	IRQ_GPIO26 = 34

	// General Purpose Input Output
	IRQ_GPIO27 = 35

	// General Purpose Input Output
	IRQ_GPIO28 = 36

	// General Purpose Input Output
	IRQ_GPIO29 = 37

	// General Purpose Input Output
	IRQ_GPIO30 = 38

	// General Purpose Input Output
	IRQ_GPIO31 = 39

	// 8-bit timer with 4 cmp
	IRQ_PWM0CMP0 = 40

	// 8-bit timer with 4 cmp
	IRQ_PWM0CMP1 = 41

	// 8-bit timer with 4 cmp
	IRQ_PWM0CMP2 = 42

	// 8-bit timer with 4 cmp
	IRQ_PWM0CMP3 = 43

	IRQ_PWM1CMP0 = 44

	IRQ_PWM1CMP1 = 45

	IRQ_PWM1CMP2 = 46

	IRQ_PWM1CMP3 = 47

	IRQ_PWM2CMP0 = 48

	IRQ_PWM2CMP1 = 49

	IRQ_PWM2CMP2 = 50

	IRQ_PWM2CMP3 = 51

	// Inter-Integrated Circuit Master Interface (FE310-G002 only)
	IRQ_I2C0 = 52

	// Highest interrupt number on this device.
	IRQ_max = 52
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_WATCHDOG:
		callHandlers(IRQ_WATCHDOG)
	case IRQ_RTC:
		callHandlers(IRQ_RTC)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_QSPI0:
		callHandlers(IRQ_QSPI0)
	case IRQ_QSPI1:
		callHandlers(IRQ_QSPI1)
	case IRQ_QSPI2:
		callHandlers(IRQ_QSPI2)
	case IRQ_GPIO0:
		callHandlers(IRQ_GPIO0)
	case IRQ_GPIO1:
		callHandlers(IRQ_GPIO1)
	case IRQ_GPIO2:
		callHandlers(IRQ_GPIO2)
	case IRQ_GPIO3:
		callHandlers(IRQ_GPIO3)
	case IRQ_GPIO4:
		callHandlers(IRQ_GPIO4)
	case IRQ_GPIO5:
		callHandlers(IRQ_GPIO5)
	case IRQ_GPIO6:
		callHandlers(IRQ_GPIO6)
	case IRQ_GPIO7:
		callHandlers(IRQ_GPIO7)
	case IRQ_GPIO8:
		callHandlers(IRQ_GPIO8)
	case IRQ_GPIO9:
		callHandlers(IRQ_GPIO9)
	case IRQ_GPIO10:
		callHandlers(IRQ_GPIO10)
	case IRQ_GPIO11:
		callHandlers(IRQ_GPIO11)
	case IRQ_GPIO12:
		callHandlers(IRQ_GPIO12)
	case IRQ_GPIO13:
		callHandlers(IRQ_GPIO13)
	case IRQ_GPIO14:
		callHandlers(IRQ_GPIO14)
	case IRQ_GPIO15:
		callHandlers(IRQ_GPIO15)
	case IRQ_GPIO16:
		callHandlers(IRQ_GPIO16)
	case IRQ_GPIO17:
		callHandlers(IRQ_GPIO17)
	case IRQ_GPIO18:
		callHandlers(IRQ_GPIO18)
	case IRQ_GPIO19:
		callHandlers(IRQ_GPIO19)
	case IRQ_GPIO20:
		callHandlers(IRQ_GPIO20)
	case IRQ_GPIO21:
		callHandlers(IRQ_GPIO21)
	case IRQ_GPIO22:
		callHandlers(IRQ_GPIO22)
	case IRQ_GPIO23:
		callHandlers(IRQ_GPIO23)
	case IRQ_GPIO24:
		callHandlers(IRQ_GPIO24)
	case IRQ_GPIO25:
		callHandlers(IRQ_GPIO25)
	case IRQ_GPIO26:
		callHandlers(IRQ_GPIO26)
	case IRQ_GPIO27:
		callHandlers(IRQ_GPIO27)
	case IRQ_GPIO28:
		callHandlers(IRQ_GPIO28)
	case IRQ_GPIO29:
		callHandlers(IRQ_GPIO29)
	case IRQ_GPIO30:
		callHandlers(IRQ_GPIO30)
	case IRQ_GPIO31:
		callHandlers(IRQ_GPIO31)
	case IRQ_PWM0CMP0:
		callHandlers(IRQ_PWM0CMP0)
	case IRQ_PWM0CMP1:
		callHandlers(IRQ_PWM0CMP1)
	case IRQ_PWM0CMP2:
		callHandlers(IRQ_PWM0CMP2)
	case IRQ_PWM0CMP3:
		callHandlers(IRQ_PWM0CMP3)
	case IRQ_PWM1CMP0:
		callHandlers(IRQ_PWM1CMP0)
	case IRQ_PWM1CMP1:
		callHandlers(IRQ_PWM1CMP1)
	case IRQ_PWM1CMP2:
		callHandlers(IRQ_PWM1CMP2)
	case IRQ_PWM1CMP3:
		callHandlers(IRQ_PWM1CMP3)
	case IRQ_PWM2CMP0:
		callHandlers(IRQ_PWM2CMP0)
	case IRQ_PWM2CMP1:
		callHandlers(IRQ_PWM2CMP1)
	case IRQ_PWM2CMP2:
		callHandlers(IRQ_PWM2CMP2)
	case IRQ_PWM2CMP3:
		callHandlers(IRQ_PWM2CMP3)
	case IRQ_I2C0:
		callHandlers(IRQ_I2C0)
	}
}

// Peripherals.
var (
	// Coreplex Local Interrupts
	CLINT = (*CLINT_Type)(unsafe.Pointer(uintptr(0x2000000)))

	// Platform Level Interrupt Control
	PLIC = (*PLIC_Type)(unsafe.Pointer(uintptr(0xc000000)))

	// Watchdog
	WDOG = (*Watchdog_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// Watchdog
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// Always-On Clock Configuration
	AONCLK = (*AONCLOCK_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// Backup Registers
	BACKUP = (*BACKUP_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// PMU
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// Power Reset Clock Interrupts
	PRCI = (*PRCI_Type)(unsafe.Pointer(uintptr(0x10008000)))

	// One Time Programmable Memory
	OTP = (*OTP_Type)(unsafe.Pointer(uintptr(0x10010000)))

	// General Purpose Input Output
	GPIO0 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x10012000)))

	// Universal Asynchronous Receiver Transmitter
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x10013000)))

	// Quad Serial Peripheral Interface
	QSPI0 = (*QSPI_Type)(unsafe.Pointer(uintptr(0x10014000)))

	// 8-bit timer with 4 cmp
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x10015000)))

	// Inter-Integrated Circuit Master Interface (FE310-G002 only)
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x10016000)))

	// Universal Asynchronous Receiver Transmitter
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x10023000)))

	// Quad Serial Peripheral Interface
	QSPI1 = (*QSPI_Type)(unsafe.Pointer(uintptr(0x10024000)))

	// 8-bit timer with 4 cmp
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x10025000)))

	// Quad Serial Peripheral Interface
	QSPI2 = (*QSPI_Type)(unsafe.Pointer(uintptr(0x10034000)))

	// 8-bit timer with 4 cmp
	PWM2 = (*PWM_Type)(unsafe.Pointer(uintptr(0x10035000)))
)

// Coreplex Local Interrupts
type CLINT_Type struct {
	MSIP      volatile.Register32 // 0x0
	_         [16380]byte
	MTIMECMP  volatile.Register32 // 0x4000
	MTIMECMPH volatile.Register32 // 0x4004
	_         [32752]byte
	MTIME     volatile.Register32 // 0xBFF8
	MTIMEH    volatile.Register32 // 0xBFFC
}

// Platform Level Interrupt Control
type PLIC_Type struct {
	PRIORITY  [52]volatile.Register32 // 0x0
	_         [3888]byte
	PENDING   [2]volatile.Register32 // 0x1000
	_         [4088]byte
	ENABLE    [2]volatile.Register32 // 0x2000
	_         [2088952]byte
	THRESHOLD volatile.Register32 // 0x200000
	CLAIM     volatile.Register32 // 0x200004
}

// PLIC.THRESHOLD: Priority Threshold Register
func (o *PLIC_Type) SetTHRESHOLD_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.THRESHOLD.Reg, volatile.LoadUint32(&o.THRESHOLD.Reg)&^(0x7)|value)
}
func (o *PLIC_Type) GetTHRESHOLD_PRIORITY() uint32 {
	return volatile.LoadUint32(&o.THRESHOLD.Reg) & 0x7
}

// Watchdog
type Watchdog_Type struct {
	WDOGCFG   volatile.Register32 // 0x0
	_         [4]byte
	WDOGCOUNT volatile.Register32 // 0x8
	_         [4]byte
	WDOGS     volatile.Register32 // 0x10
	_         [4]byte
	WDOGFEED  volatile.Register32 // 0x18
	WDOGKEY   volatile.Register32 // 0x1C
	WDOGCMP   volatile.Register32 // 0x20
}

// Watchdog.WDOGCFG: Watchdog Configuration Register
func (o *Watchdog_Type) SetWDOGCFG_CMPIP(value uint32) {
	volatile.StoreUint32(&o.WDOGCFG.Reg, volatile.LoadUint32(&o.WDOGCFG.Reg)&^(0x10000000)|value<<28)
}
func (o *Watchdog_Type) GetWDOGCFG_CMPIP() uint32 {
	return (volatile.LoadUint32(&o.WDOGCFG.Reg) & 0x10000000) >> 28
}
func (o *Watchdog_Type) SetWDOGCFG_ENCOREAWAKE(value uint32) {
	volatile.StoreUint32(&o.WDOGCFG.Reg, volatile.LoadUint32(&o.WDOGCFG.Reg)&^(0x2000)|value<<13)
}
func (o *Watchdog_Type) GetWDOGCFG_ENCOREAWAKE() uint32 {
	return (volatile.LoadUint32(&o.WDOGCFG.Reg) & 0x2000) >> 13
}
func (o *Watchdog_Type) SetWDOGCFG_ENALWAYS(value uint32) {
	volatile.StoreUint32(&o.WDOGCFG.Reg, volatile.LoadUint32(&o.WDOGCFG.Reg)&^(0x1000)|value<<12)
}
func (o *Watchdog_Type) GetWDOGCFG_ENALWAYS() uint32 {
	return (volatile.LoadUint32(&o.WDOGCFG.Reg) & 0x1000) >> 12
}
func (o *Watchdog_Type) SetWDOGCFG_ZEROCMP(value uint32) {
	volatile.StoreUint32(&o.WDOGCFG.Reg, volatile.LoadUint32(&o.WDOGCFG.Reg)&^(0x200)|value<<9)
}
func (o *Watchdog_Type) GetWDOGCFG_ZEROCMP() uint32 {
	return (volatile.LoadUint32(&o.WDOGCFG.Reg) & 0x200) >> 9
}
func (o *Watchdog_Type) SetWDOGCFG_RSTEN(value uint32) {
	volatile.StoreUint32(&o.WDOGCFG.Reg, volatile.LoadUint32(&o.WDOGCFG.Reg)&^(0x100)|value<<8)
}
func (o *Watchdog_Type) GetWDOGCFG_RSTEN() uint32 {
	return (volatile.LoadUint32(&o.WDOGCFG.Reg) & 0x100) >> 8
}
func (o *Watchdog_Type) SetWDOGCFG_SCALE(value uint32) {
	volatile.StoreUint32(&o.WDOGCFG.Reg, volatile.LoadUint32(&o.WDOGCFG.Reg)&^(0xf)|value)
}
func (o *Watchdog_Type) GetWDOGCFG_SCALE() uint32 {
	return volatile.LoadUint32(&o.WDOGCFG.Reg) & 0xf
}

// Watchdog.WDOGCMP: Watchdog Compare Register
func (o *Watchdog_Type) SetWDOGCMP_VALUE(value uint32) {
	volatile.StoreUint32(&o.WDOGCMP.Reg, volatile.LoadUint32(&o.WDOGCMP.Reg)&^(0xffff)|value)
}
func (o *Watchdog_Type) GetWDOGCMP_VALUE() uint32 {
	return volatile.LoadUint32(&o.WDOGCMP.Reg) & 0xffff
}

// Watchdog
type RTC_Type struct {
	_      [64]byte
	RTCCFG volatile.Register32 // 0x40
	_      [4]byte
	RTCLO  volatile.Register32 // 0x48
	RTCHI  volatile.Register32 // 0x4C
	RTCS   volatile.Register32 // 0x50
	_      [12]byte
	RTCCMP volatile.Register32 // 0x60
}

// RTC.RTCCFG: RTC Configuration Register
func (o *RTC_Type) SetRTCCFG_CMPIP(value uint32) {
	volatile.StoreUint32(&o.RTCCFG.Reg, volatile.LoadUint32(&o.RTCCFG.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_Type) GetRTCCFG_CMPIP() uint32 {
	return (volatile.LoadUint32(&o.RTCCFG.Reg) & 0x10000000) >> 28
}
func (o *RTC_Type) SetRTCCFG_ENALWAYS(value uint32) {
	volatile.StoreUint32(&o.RTCCFG.Reg, volatile.LoadUint32(&o.RTCCFG.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetRTCCFG_ENALWAYS() uint32 {
	return (volatile.LoadUint32(&o.RTCCFG.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetRTCCFG_SCALE(value uint32) {
	volatile.StoreUint32(&o.RTCCFG.Reg, volatile.LoadUint32(&o.RTCCFG.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRTCCFG_SCALE() uint32 {
	return volatile.LoadUint32(&o.RTCCFG.Reg) & 0xf
}

// RTC.RTCHI: RTC Counter High Register
func (o *RTC_Type) SetRTCHI_VALUE(value uint32) {
	volatile.StoreUint32(&o.RTCHI.Reg, volatile.LoadUint32(&o.RTCHI.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetRTCHI_VALUE() uint32 {
	return volatile.LoadUint32(&o.RTCHI.Reg) & 0xffff
}

// Always-On Clock Configuration
type AONCLOCK_Type struct {
	_         [112]byte
	LFROSCCFG volatile.Register32 // 0x70
}

// AONCLOCK.LFROSCCFG: AON Clock Configuration Register
func (o *AONCLOCK_Type) SetLFROSCCFG_READY(value uint32) {
	volatile.StoreUint32(&o.LFROSCCFG.Reg, volatile.LoadUint32(&o.LFROSCCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *AONCLOCK_Type) GetLFROSCCFG_READY() uint32 {
	return (volatile.LoadUint32(&o.LFROSCCFG.Reg) & 0x80000000) >> 31
}
func (o *AONCLOCK_Type) SetLFROSCCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LFROSCCFG.Reg, volatile.LoadUint32(&o.LFROSCCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *AONCLOCK_Type) GetLFROSCCFG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LFROSCCFG.Reg) & 0x40000000) >> 30
}
func (o *AONCLOCK_Type) SetLFROSCCFG_TRIM(value uint32) {
	volatile.StoreUint32(&o.LFROSCCFG.Reg, volatile.LoadUint32(&o.LFROSCCFG.Reg)&^(0x1f0000)|value<<16)
}
func (o *AONCLOCK_Type) GetLFROSCCFG_TRIM() uint32 {
	return (volatile.LoadUint32(&o.LFROSCCFG.Reg) & 0x1f0000) >> 16
}
func (o *AONCLOCK_Type) SetLFROSCCFG_DIV(value uint32) {
	volatile.StoreUint32(&o.LFROSCCFG.Reg, volatile.LoadUint32(&o.LFROSCCFG.Reg)&^(0x3f)|value)
}
func (o *AONCLOCK_Type) GetLFROSCCFG_DIV() uint32 {
	return volatile.LoadUint32(&o.LFROSCCFG.Reg) & 0x3f
}

// Backup Registers
type BACKUP_Type struct {
	_      [128]byte
	BACKUP [16]volatile.Register32 // 0x80
}

// PMU
type PMU_Type struct {
	_          [256]byte
	PMUWAKEPM  [8]volatile.Register32 // 0x100
	PMUSLEEPPM [8]volatile.Register32 // 0x120
	PMUIE      volatile.Register32    // 0x140
	PMUCAUSE   volatile.Register32    // 0x144
	PMUSLEEP   volatile.Register32    // 0x148
	PMUKEY     volatile.Register32    // 0x14C
}

// PMU.PMUWAKEPM: PMU Wake Program Memory
func (o *PMU_Type) SetPMUWAKEPM_ISOLATE(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUWAKEPM[idx].Reg, volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg)&^(0x200)|value<<9)
}
func (o *PMU_Type) GetPMUWAKEPM_ISOLATE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg) & 0x200) >> 9
}
func (o *PMU_Type) SetPMUWAKEPM_HFCLKRST(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUWAKEPM[idx].Reg, volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg)&^(0x100)|value<<8)
}
func (o *PMU_Type) GetPMUWAKEPM_HFCLKRST(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg) & 0x100) >> 8
}
func (o *PMU_Type) SetPMUWAKEPM_CORERST(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUWAKEPM[idx].Reg, volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg)&^(0x80)|value<<7)
}
func (o *PMU_Type) GetPMUWAKEPM_CORERST(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg) & 0x80) >> 7
}
func (o *PMU_Type) SetPMUWAKEPM_PMU_OUT_1_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUWAKEPM[idx].Reg, volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg)&^(0x20)|value<<5)
}
func (o *PMU_Type) GetPMUWAKEPM_PMU_OUT_1_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg) & 0x20) >> 5
}
func (o *PMU_Type) SetPMUWAKEPM_PMU_OUT_0_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUWAKEPM[idx].Reg, volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg)&^(0x10)|value<<4)
}
func (o *PMU_Type) GetPMUWAKEPM_PMU_OUT_0_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg) & 0x10) >> 4
}
func (o *PMU_Type) SetPMUWAKEPM_DELAY(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUWAKEPM[idx].Reg, volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg)&^(0xf)|value)
}
func (o *PMU_Type) GetPMUWAKEPM_DELAY(idx int) uint32 {
	return volatile.LoadUint32(&o.PMUWAKEPM[idx].Reg) & 0xf
}

// PMU.PMUSLEEPPM: PMU Sleep Program Memory
func (o *PMU_Type) SetPMUSLEEPPM_ISOLATE(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUSLEEPPM[idx].Reg, volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg)&^(0x200)|value<<9)
}
func (o *PMU_Type) GetPMUSLEEPPM_ISOLATE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg) & 0x200) >> 9
}
func (o *PMU_Type) SetPMUSLEEPPM_HFCLKRST(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUSLEEPPM[idx].Reg, volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg)&^(0x100)|value<<8)
}
func (o *PMU_Type) GetPMUSLEEPPM_HFCLKRST(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg) & 0x100) >> 8
}
func (o *PMU_Type) SetPMUSLEEPPM_CORERST(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUSLEEPPM[idx].Reg, volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg)&^(0x80)|value<<7)
}
func (o *PMU_Type) GetPMUSLEEPPM_CORERST(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg) & 0x80) >> 7
}
func (o *PMU_Type) SetPMUSLEEPPM_PMU_OUT_1_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUSLEEPPM[idx].Reg, volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg)&^(0x20)|value<<5)
}
func (o *PMU_Type) GetPMUSLEEPPM_PMU_OUT_1_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg) & 0x20) >> 5
}
func (o *PMU_Type) SetPMUSLEEPPM_PMU_OUT_0_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUSLEEPPM[idx].Reg, volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg)&^(0x10)|value<<4)
}
func (o *PMU_Type) GetPMUSLEEPPM_PMU_OUT_0_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg) & 0x10) >> 4
}
func (o *PMU_Type) SetPMUSLEEPPM_DELAY(idx int, value uint32) {
	volatile.StoreUint32(&o.PMUSLEEPPM[idx].Reg, volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg)&^(0xf)|value)
}
func (o *PMU_Type) GetPMUSLEEPPM_DELAY(idx int) uint32 {
	return volatile.LoadUint32(&o.PMUSLEEPPM[idx].Reg) & 0xf
}

// PMU.PMUIE: PMU Interrupt Enable Register
func (o *PMU_Type) SetPMUIE_AWAKEUP(value uint32) {
	volatile.StoreUint32(&o.PMUIE.Reg, volatile.LoadUint32(&o.PMUIE.Reg)&^(0x8)|value<<3)
}
func (o *PMU_Type) GetPMUIE_AWAKEUP() uint32 {
	return (volatile.LoadUint32(&o.PMUIE.Reg) & 0x8) >> 3
}
func (o *PMU_Type) SetPMUIE_DWAKEUP(value uint32) {
	volatile.StoreUint32(&o.PMUIE.Reg, volatile.LoadUint32(&o.PMUIE.Reg)&^(0x4)|value<<2)
}
func (o *PMU_Type) GetPMUIE_DWAKEUP() uint32 {
	return (volatile.LoadUint32(&o.PMUIE.Reg) & 0x4) >> 2
}
func (o *PMU_Type) SetPMUIE_RTC(value uint32) {
	volatile.StoreUint32(&o.PMUIE.Reg, volatile.LoadUint32(&o.PMUIE.Reg)&^(0x2)|value<<1)
}
func (o *PMU_Type) GetPMUIE_RTC() uint32 {
	return (volatile.LoadUint32(&o.PMUIE.Reg) & 0x2) >> 1
}

// PMU.PMUCAUSE: PMU Cause Register
func (o *PMU_Type) SetPMUCAUSE_RESETCAUSE(value uint32) {
	volatile.StoreUint32(&o.PMUCAUSE.Reg, volatile.LoadUint32(&o.PMUCAUSE.Reg)&^(0x300)|value<<8)
}
func (o *PMU_Type) GetPMUCAUSE_RESETCAUSE() uint32 {
	return (volatile.LoadUint32(&o.PMUCAUSE.Reg) & 0x300) >> 8
}
func (o *PMU_Type) SetPMUCAUSE_WAKEUPCAUSE(value uint32) {
	volatile.StoreUint32(&o.PMUCAUSE.Reg, volatile.LoadUint32(&o.PMUCAUSE.Reg)&^(0x3)|value)
}
func (o *PMU_Type) GetPMUCAUSE_WAKEUPCAUSE() uint32 {
	return volatile.LoadUint32(&o.PMUCAUSE.Reg) & 0x3
}

// PMU.PMUSLEEP: PMU Sleep Register
func (o *PMU_Type) SetPMUSLEEP_SLEEP(value uint32) {
	volatile.StoreUint32(&o.PMUSLEEP.Reg, volatile.LoadUint32(&o.PMUSLEEP.Reg)&^(0x1)|value)
}
func (o *PMU_Type) GetPMUSLEEP_SLEEP() uint32 {
	return volatile.LoadUint32(&o.PMUSLEEP.Reg) & 0x1
}

// Power Reset Clock Interrupts
type PRCI_Type struct {
	HFROSCCFG  volatile.Register32 // 0x0
	HFXOSCCFG  volatile.Register32 // 0x4
	PLLCFG     volatile.Register32 // 0x8
	PLLOUTDIV  volatile.Register32 // 0xC
	CORECLKCFG volatile.Register32 // 0x10
}

// PRCI.HFROSCCFG: Clock Configuration Register
func (o *PRCI_Type) SetHFROSCCFG_READY(value uint32) {
	volatile.StoreUint32(&o.HFROSCCFG.Reg, volatile.LoadUint32(&o.HFROSCCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *PRCI_Type) GetHFROSCCFG_READY() uint32 {
	return (volatile.LoadUint32(&o.HFROSCCFG.Reg) & 0x80000000) >> 31
}
func (o *PRCI_Type) SetHFROSCCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.HFROSCCFG.Reg, volatile.LoadUint32(&o.HFROSCCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *PRCI_Type) GetHFROSCCFG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.HFROSCCFG.Reg) & 0x40000000) >> 30
}
func (o *PRCI_Type) SetHFROSCCFG_TRIM(value uint32) {
	volatile.StoreUint32(&o.HFROSCCFG.Reg, volatile.LoadUint32(&o.HFROSCCFG.Reg)&^(0x1f0000)|value<<16)
}
func (o *PRCI_Type) GetHFROSCCFG_TRIM() uint32 {
	return (volatile.LoadUint32(&o.HFROSCCFG.Reg) & 0x1f0000) >> 16
}
func (o *PRCI_Type) SetHFROSCCFG_DIV(value uint32) {
	volatile.StoreUint32(&o.HFROSCCFG.Reg, volatile.LoadUint32(&o.HFROSCCFG.Reg)&^(0x3f)|value)
}
func (o *PRCI_Type) GetHFROSCCFG_DIV() uint32 {
	return volatile.LoadUint32(&o.HFROSCCFG.Reg) & 0x3f
}

// PRCI.HFXOSCCFG: Clock Configuration Register
func (o *PRCI_Type) SetHFXOSCCFG_READY(value uint32) {
	volatile.StoreUint32(&o.HFXOSCCFG.Reg, volatile.LoadUint32(&o.HFXOSCCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *PRCI_Type) GetHFXOSCCFG_READY() uint32 {
	return (volatile.LoadUint32(&o.HFXOSCCFG.Reg) & 0x80000000) >> 31
}
func (o *PRCI_Type) SetHFXOSCCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.HFXOSCCFG.Reg, volatile.LoadUint32(&o.HFXOSCCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *PRCI_Type) GetHFXOSCCFG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.HFXOSCCFG.Reg) & 0x40000000) >> 30
}

// PRCI.PLLCFG: PLL Configuration Register
func (o *PRCI_Type) SetPLLCFG_LOCK(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *PRCI_Type) GetPLLCFG_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PLLCFG.Reg) & 0x80000000) >> 31
}
func (o *PRCI_Type) SetPLLCFG_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0x40000)|value<<18)
}
func (o *PRCI_Type) GetPLLCFG_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PLLCFG.Reg) & 0x40000) >> 18
}
func (o *PRCI_Type) SetPLLCFG_REFSEL(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0x20000)|value<<17)
}
func (o *PRCI_Type) GetPLLCFG_REFSEL() uint32 {
	return (volatile.LoadUint32(&o.PLLCFG.Reg) & 0x20000) >> 17
}
func (o *PRCI_Type) SetPLLCFG_SEL(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0x10000)|value<<16)
}
func (o *PRCI_Type) GetPLLCFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.PLLCFG.Reg) & 0x10000) >> 16
}
func (o *PRCI_Type) SetPLLCFG_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0xc00)|value<<10)
}
func (o *PRCI_Type) GetPLLCFG_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFG.Reg) & 0xc00) >> 10
}
func (o *PRCI_Type) SetPLLCFG_PLLF(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0x3f0)|value<<4)
}
func (o *PRCI_Type) GetPLLCFG_PLLF() uint32 {
	return (volatile.LoadUint32(&o.PLLCFG.Reg) & 0x3f0) >> 4
}
func (o *PRCI_Type) SetPLLCFG_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFG.Reg, volatile.LoadUint32(&o.PLLCFG.Reg)&^(0x7)|value)
}
func (o *PRCI_Type) GetPLLCFG_PLLR() uint32 {
	return volatile.LoadUint32(&o.PLLCFG.Reg) & 0x7
}

// PRCI.PLLOUTDIV: PLL Divider Register
func (o *PRCI_Type) SetPLLOUTDIV_DIVBY1(value uint32) {
	volatile.StoreUint32(&o.PLLOUTDIV.Reg, volatile.LoadUint32(&o.PLLOUTDIV.Reg)&^(0x100)|value<<8)
}
func (o *PRCI_Type) GetPLLOUTDIV_DIVBY1() uint32 {
	return (volatile.LoadUint32(&o.PLLOUTDIV.Reg) & 0x100) >> 8
}
func (o *PRCI_Type) SetPLLOUTDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.PLLOUTDIV.Reg, volatile.LoadUint32(&o.PLLOUTDIV.Reg)&^(0x3f)|value)
}
func (o *PRCI_Type) GetPLLOUTDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.PLLOUTDIV.Reg) & 0x3f
}

// One Time Programmable Memory
type OTP_Type struct {
	LOCK      volatile.Register32 // 0x0
	CLOCK     volatile.Register32 // 0x4
	OUTPUT_EN volatile.Register32 // 0x8
	SELECT    volatile.Register32 // 0xC
	WRITE_EN  volatile.Register32 // 0x10
	MODE      volatile.Register32 // 0x14
	MRR       volatile.Register32 // 0x18
	MPP       volatile.Register32 // 0x1C
	VRREN     volatile.Register32 // 0x20
	VPPEN     volatile.Register32 // 0x24
	ADDR      volatile.Register32 // 0x28
	DATA_IN   volatile.Register32 // 0x2C
	DATA_OUT  volatile.Register32 // 0x30
	RSCTRL    volatile.Register32 // 0x34
}

// General Purpose Input Output
type GPIO_Type struct {
	VALUE     volatile.Register32 // 0x0
	INPUT_EN  volatile.Register32 // 0x4
	OUTPUT_EN volatile.Register32 // 0x8
	PORT      volatile.Register32 // 0xC
	PULLUP    volatile.Register32 // 0x10
	DRIVE     volatile.Register32 // 0x14
	RISE_IE   volatile.Register32 // 0x18
	RISE_IP   volatile.Register32 // 0x1C
	FALL_IE   volatile.Register32 // 0x20
	FALL_IP   volatile.Register32 // 0x24
	HIGH_IE   volatile.Register32 // 0x28
	HIGH_IP   volatile.Register32 // 0x2C
	LOW_IE    volatile.Register32 // 0x30
	LOW_IP    volatile.Register32 // 0x34
	IOF_EN    volatile.Register32 // 0x38
	IOF_SEL   volatile.Register32 // 0x3C
	OUT_XOR   volatile.Register32 // 0x40
}

// GPIO.VALUE: Pin value.
func (o *GPIO_Type) SetVALUE_PIN0(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetVALUE_PIN0() uint32 {
	return volatile.LoadUint32(&o.VALUE.Reg) & 0x1
}
func (o *GPIO_Type) SetVALUE_PIN1(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetVALUE_PIN1() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetVALUE_PIN2(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetVALUE_PIN2() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetVALUE_PIN3(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetVALUE_PIN3() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetVALUE_PIN4(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetVALUE_PIN4() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetVALUE_PIN5(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetVALUE_PIN5() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetVALUE_PIN6(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetVALUE_PIN6() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetVALUE_PIN7(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetVALUE_PIN7() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetVALUE_PIN8(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetVALUE_PIN8() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetVALUE_PIN9(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetVALUE_PIN9() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetVALUE_PIN10(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetVALUE_PIN10() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetVALUE_PIN11(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetVALUE_PIN11() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetVALUE_PIN12(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetVALUE_PIN12() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetVALUE_PIN13(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetVALUE_PIN13() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetVALUE_PIN14(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetVALUE_PIN14() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetVALUE_PIN15(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetVALUE_PIN15() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetVALUE_PIN16(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetVALUE_PIN16() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetVALUE_PIN17(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetVALUE_PIN17() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetVALUE_PIN18(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetVALUE_PIN18() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetVALUE_PIN19(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetVALUE_PIN19() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetVALUE_PIN20(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetVALUE_PIN20() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetVALUE_PIN21(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetVALUE_PIN21() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetVALUE_PIN22(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetVALUE_PIN22() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetVALUE_PIN23(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetVALUE_PIN23() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetVALUE_PIN24(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetVALUE_PIN24() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetVALUE_PIN25(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetVALUE_PIN25() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetVALUE_PIN26(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetVALUE_PIN26() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetVALUE_PIN27(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetVALUE_PIN27() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetVALUE_PIN28(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetVALUE_PIN28() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetVALUE_PIN29(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetVALUE_PIN29() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetVALUE_PIN30(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetVALUE_PIN30() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetVALUE_PIN31(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetVALUE_PIN31() uint32 {
	return (volatile.LoadUint32(&o.VALUE.Reg) & 0x80000000) >> 31
}

// GPIO.INPUT_EN: Pin Input Enable Register
func (o *GPIO_Type) SetINPUT_EN_PIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetINPUT_EN_PIN0() uint32 {
	return volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x1
}
func (o *GPIO_Type) SetINPUT_EN_PIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetINPUT_EN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetINPUT_EN_PIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetINPUT_EN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetINPUT_EN_PIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetINPUT_EN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetINPUT_EN_PIN4(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetINPUT_EN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetINPUT_EN_PIN5(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetINPUT_EN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetINPUT_EN_PIN6(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetINPUT_EN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetINPUT_EN_PIN7(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetINPUT_EN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetINPUT_EN_PIN8(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetINPUT_EN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetINPUT_EN_PIN9(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetINPUT_EN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetINPUT_EN_PIN10(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetINPUT_EN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetINPUT_EN_PIN11(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetINPUT_EN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetINPUT_EN_PIN12(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetINPUT_EN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetINPUT_EN_PIN13(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetINPUT_EN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetINPUT_EN_PIN14(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetINPUT_EN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetINPUT_EN_PIN15(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetINPUT_EN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetINPUT_EN_PIN16(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetINPUT_EN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetINPUT_EN_PIN17(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetINPUT_EN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetINPUT_EN_PIN18(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetINPUT_EN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetINPUT_EN_PIN19(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetINPUT_EN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetINPUT_EN_PIN20(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetINPUT_EN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetINPUT_EN_PIN21(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetINPUT_EN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetINPUT_EN_PIN22(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetINPUT_EN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetINPUT_EN_PIN23(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetINPUT_EN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetINPUT_EN_PIN24(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetINPUT_EN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetINPUT_EN_PIN25(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetINPUT_EN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetINPUT_EN_PIN26(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetINPUT_EN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetINPUT_EN_PIN27(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetINPUT_EN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetINPUT_EN_PIN28(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetINPUT_EN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetINPUT_EN_PIN29(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetINPUT_EN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetINPUT_EN_PIN30(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetINPUT_EN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetINPUT_EN_PIN31(value uint32) {
	volatile.StoreUint32(&o.INPUT_EN.Reg, volatile.LoadUint32(&o.INPUT_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetINPUT_EN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.INPUT_EN.Reg) & 0x80000000) >> 31
}

// GPIO.OUTPUT_EN: Pin Output Enable Register
func (o *GPIO_Type) SetOUTPUT_EN_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTPUT_EN_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTPUT_EN.Reg, volatile.LoadUint32(&o.OUTPUT_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTPUT_EN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT_EN.Reg) & 0x80000000) >> 31
}

// GPIO.PORT: Output Port Value Register
func (o *GPIO_Type) SetPORT_PIN0(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPORT_PIN0() uint32 {
	return volatile.LoadUint32(&o.PORT.Reg) & 0x1
}
func (o *GPIO_Type) SetPORT_PIN1(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPORT_PIN1() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPORT_PIN2(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPORT_PIN2() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPORT_PIN3(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPORT_PIN3() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPORT_PIN4(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPORT_PIN4() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPORT_PIN5(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPORT_PIN5() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPORT_PIN6(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPORT_PIN6() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPORT_PIN7(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPORT_PIN7() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPORT_PIN8(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPORT_PIN8() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPORT_PIN9(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPORT_PIN9() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPORT_PIN10(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPORT_PIN10() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPORT_PIN11(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPORT_PIN11() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPORT_PIN12(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPORT_PIN12() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPORT_PIN13(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPORT_PIN13() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPORT_PIN14(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPORT_PIN14() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPORT_PIN15(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPORT_PIN15() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPORT_PIN16(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPORT_PIN16() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPORT_PIN17(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPORT_PIN17() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPORT_PIN18(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPORT_PIN18() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPORT_PIN19(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPORT_PIN19() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPORT_PIN20(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPORT_PIN20() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPORT_PIN21(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPORT_PIN21() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPORT_PIN22(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPORT_PIN22() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPORT_PIN23(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPORT_PIN23() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPORT_PIN24(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPORT_PIN24() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPORT_PIN25(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPORT_PIN25() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPORT_PIN26(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPORT_PIN26() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPORT_PIN27(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPORT_PIN27() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPORT_PIN28(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPORT_PIN28() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPORT_PIN29(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPORT_PIN29() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPORT_PIN30(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPORT_PIN30() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPORT_PIN31(value uint32) {
	volatile.StoreUint32(&o.PORT.Reg, volatile.LoadUint32(&o.PORT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPORT_PIN31() uint32 {
	return (volatile.LoadUint32(&o.PORT.Reg) & 0x80000000) >> 31
}

// GPIO.PULLUP: Internal Pull-Up Enable Register
func (o *GPIO_Type) SetPULLUP_PIN0(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPULLUP_PIN0() uint32 {
	return volatile.LoadUint32(&o.PULLUP.Reg) & 0x1
}
func (o *GPIO_Type) SetPULLUP_PIN1(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPULLUP_PIN1() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPULLUP_PIN2(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPULLUP_PIN2() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPULLUP_PIN3(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPULLUP_PIN3() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPULLUP_PIN4(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPULLUP_PIN4() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPULLUP_PIN5(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPULLUP_PIN5() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPULLUP_PIN6(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPULLUP_PIN6() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPULLUP_PIN7(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPULLUP_PIN7() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPULLUP_PIN8(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPULLUP_PIN8() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPULLUP_PIN9(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPULLUP_PIN9() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPULLUP_PIN10(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPULLUP_PIN10() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPULLUP_PIN11(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPULLUP_PIN11() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPULLUP_PIN12(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPULLUP_PIN12() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPULLUP_PIN13(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPULLUP_PIN13() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPULLUP_PIN14(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPULLUP_PIN14() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPULLUP_PIN15(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPULLUP_PIN15() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPULLUP_PIN16(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPULLUP_PIN16() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPULLUP_PIN17(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPULLUP_PIN17() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPULLUP_PIN18(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPULLUP_PIN18() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPULLUP_PIN19(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPULLUP_PIN19() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPULLUP_PIN20(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPULLUP_PIN20() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPULLUP_PIN21(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPULLUP_PIN21() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPULLUP_PIN22(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPULLUP_PIN22() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPULLUP_PIN23(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPULLUP_PIN23() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPULLUP_PIN24(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPULLUP_PIN24() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPULLUP_PIN25(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPULLUP_PIN25() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPULLUP_PIN26(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPULLUP_PIN26() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPULLUP_PIN27(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPULLUP_PIN27() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPULLUP_PIN28(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPULLUP_PIN28() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPULLUP_PIN29(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPULLUP_PIN29() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPULLUP_PIN30(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPULLUP_PIN30() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPULLUP_PIN31(value uint32) {
	volatile.StoreUint32(&o.PULLUP.Reg, volatile.LoadUint32(&o.PULLUP.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPULLUP_PIN31() uint32 {
	return (volatile.LoadUint32(&o.PULLUP.Reg) & 0x80000000) >> 31
}

// GPIO.DRIVE: Drive Strength Register
func (o *GPIO_Type) SetDRIVE_PIN0(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDRIVE_PIN0() uint32 {
	return volatile.LoadUint32(&o.DRIVE.Reg) & 0x1
}
func (o *GPIO_Type) SetDRIVE_PIN1(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDRIVE_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDRIVE_PIN2(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDRIVE_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDRIVE_PIN3(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDRIVE_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDRIVE_PIN4(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDRIVE_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDRIVE_PIN5(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDRIVE_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDRIVE_PIN6(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDRIVE_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDRIVE_PIN7(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDRIVE_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDRIVE_PIN8(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDRIVE_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDRIVE_PIN9(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDRIVE_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDRIVE_PIN10(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDRIVE_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDRIVE_PIN11(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDRIVE_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDRIVE_PIN12(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDRIVE_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDRIVE_PIN13(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDRIVE_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDRIVE_PIN14(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDRIVE_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDRIVE_PIN15(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDRIVE_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDRIVE_PIN16(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDRIVE_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDRIVE_PIN17(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDRIVE_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDRIVE_PIN18(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDRIVE_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDRIVE_PIN19(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDRIVE_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDRIVE_PIN20(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDRIVE_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDRIVE_PIN21(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDRIVE_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDRIVE_PIN22(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDRIVE_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDRIVE_PIN23(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDRIVE_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDRIVE_PIN24(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDRIVE_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDRIVE_PIN25(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDRIVE_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDRIVE_PIN26(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDRIVE_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDRIVE_PIN27(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDRIVE_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDRIVE_PIN28(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDRIVE_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDRIVE_PIN29(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDRIVE_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDRIVE_PIN30(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDRIVE_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDRIVE_PIN31(value uint32) {
	volatile.StoreUint32(&o.DRIVE.Reg, volatile.LoadUint32(&o.DRIVE.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDRIVE_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DRIVE.Reg) & 0x80000000) >> 31
}

// GPIO.RISE_IE: Rise Interrupt Enable Register
func (o *GPIO_Type) SetRISE_IE_PIN0(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetRISE_IE_PIN0() uint32 {
	return volatile.LoadUint32(&o.RISE_IE.Reg) & 0x1
}
func (o *GPIO_Type) SetRISE_IE_PIN1(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetRISE_IE_PIN1() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetRISE_IE_PIN2(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetRISE_IE_PIN2() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetRISE_IE_PIN3(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetRISE_IE_PIN3() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetRISE_IE_PIN4(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetRISE_IE_PIN4() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetRISE_IE_PIN5(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetRISE_IE_PIN5() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetRISE_IE_PIN6(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetRISE_IE_PIN6() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetRISE_IE_PIN7(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetRISE_IE_PIN7() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetRISE_IE_PIN8(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetRISE_IE_PIN8() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetRISE_IE_PIN9(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetRISE_IE_PIN9() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetRISE_IE_PIN10(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetRISE_IE_PIN10() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetRISE_IE_PIN11(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetRISE_IE_PIN11() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetRISE_IE_PIN12(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetRISE_IE_PIN12() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetRISE_IE_PIN13(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetRISE_IE_PIN13() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetRISE_IE_PIN14(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetRISE_IE_PIN14() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetRISE_IE_PIN15(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetRISE_IE_PIN15() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetRISE_IE_PIN16(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetRISE_IE_PIN16() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetRISE_IE_PIN17(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetRISE_IE_PIN17() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetRISE_IE_PIN18(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetRISE_IE_PIN18() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetRISE_IE_PIN19(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetRISE_IE_PIN19() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetRISE_IE_PIN20(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetRISE_IE_PIN20() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetRISE_IE_PIN21(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetRISE_IE_PIN21() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetRISE_IE_PIN22(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetRISE_IE_PIN22() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetRISE_IE_PIN23(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetRISE_IE_PIN23() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetRISE_IE_PIN24(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetRISE_IE_PIN24() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetRISE_IE_PIN25(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetRISE_IE_PIN25() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetRISE_IE_PIN26(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetRISE_IE_PIN26() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetRISE_IE_PIN27(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetRISE_IE_PIN27() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetRISE_IE_PIN28(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetRISE_IE_PIN28() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetRISE_IE_PIN29(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetRISE_IE_PIN29() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetRISE_IE_PIN30(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetRISE_IE_PIN30() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetRISE_IE_PIN31(value uint32) {
	volatile.StoreUint32(&o.RISE_IE.Reg, volatile.LoadUint32(&o.RISE_IE.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetRISE_IE_PIN31() uint32 {
	return (volatile.LoadUint32(&o.RISE_IE.Reg) & 0x80000000) >> 31
}

// GPIO.RISE_IP: Rise Interrupt Pending Register
func (o *GPIO_Type) SetRISE_IP_PIN0(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetRISE_IP_PIN0() uint32 {
	return volatile.LoadUint32(&o.RISE_IP.Reg) & 0x1
}
func (o *GPIO_Type) SetRISE_IP_PIN1(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetRISE_IP_PIN1() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetRISE_IP_PIN2(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetRISE_IP_PIN2() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetRISE_IP_PIN3(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetRISE_IP_PIN3() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetRISE_IP_PIN4(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetRISE_IP_PIN4() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetRISE_IP_PIN5(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetRISE_IP_PIN5() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetRISE_IP_PIN6(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetRISE_IP_PIN6() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetRISE_IP_PIN7(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetRISE_IP_PIN7() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetRISE_IP_PIN8(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetRISE_IP_PIN8() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetRISE_IP_PIN9(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetRISE_IP_PIN9() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetRISE_IP_PIN10(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetRISE_IP_PIN10() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetRISE_IP_PIN11(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetRISE_IP_PIN11() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetRISE_IP_PIN12(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetRISE_IP_PIN12() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetRISE_IP_PIN13(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetRISE_IP_PIN13() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetRISE_IP_PIN14(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetRISE_IP_PIN14() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetRISE_IP_PIN15(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetRISE_IP_PIN15() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetRISE_IP_PIN16(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetRISE_IP_PIN16() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetRISE_IP_PIN17(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetRISE_IP_PIN17() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetRISE_IP_PIN18(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetRISE_IP_PIN18() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetRISE_IP_PIN19(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetRISE_IP_PIN19() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetRISE_IP_PIN20(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetRISE_IP_PIN20() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetRISE_IP_PIN21(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetRISE_IP_PIN21() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetRISE_IP_PIN22(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetRISE_IP_PIN22() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetRISE_IP_PIN23(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetRISE_IP_PIN23() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetRISE_IP_PIN24(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetRISE_IP_PIN24() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetRISE_IP_PIN25(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetRISE_IP_PIN25() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetRISE_IP_PIN26(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetRISE_IP_PIN26() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetRISE_IP_PIN27(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetRISE_IP_PIN27() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetRISE_IP_PIN28(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetRISE_IP_PIN28() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetRISE_IP_PIN29(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetRISE_IP_PIN29() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetRISE_IP_PIN30(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetRISE_IP_PIN30() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetRISE_IP_PIN31(value uint32) {
	volatile.StoreUint32(&o.RISE_IP.Reg, volatile.LoadUint32(&o.RISE_IP.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetRISE_IP_PIN31() uint32 {
	return (volatile.LoadUint32(&o.RISE_IP.Reg) & 0x80000000) >> 31
}

// GPIO.FALL_IE: Fall Interrupt Enable Register
func (o *GPIO_Type) SetFALL_IE_PIN0(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetFALL_IE_PIN0() uint32 {
	return volatile.LoadUint32(&o.FALL_IE.Reg) & 0x1
}
func (o *GPIO_Type) SetFALL_IE_PIN1(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetFALL_IE_PIN1() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetFALL_IE_PIN2(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetFALL_IE_PIN2() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetFALL_IE_PIN3(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetFALL_IE_PIN3() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetFALL_IE_PIN4(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetFALL_IE_PIN4() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetFALL_IE_PIN5(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFALL_IE_PIN5() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFALL_IE_PIN6(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFALL_IE_PIN6() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFALL_IE_PIN7(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFALL_IE_PIN7() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetFALL_IE_PIN8(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFALL_IE_PIN8() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFALL_IE_PIN9(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFALL_IE_PIN9() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFALL_IE_PIN10(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFALL_IE_PIN10() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFALL_IE_PIN11(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFALL_IE_PIN11() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetFALL_IE_PIN12(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetFALL_IE_PIN12() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetFALL_IE_PIN13(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetFALL_IE_PIN13() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetFALL_IE_PIN14(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetFALL_IE_PIN14() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetFALL_IE_PIN15(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetFALL_IE_PIN15() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetFALL_IE_PIN16(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetFALL_IE_PIN16() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetFALL_IE_PIN17(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetFALL_IE_PIN17() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetFALL_IE_PIN18(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetFALL_IE_PIN18() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetFALL_IE_PIN19(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetFALL_IE_PIN19() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetFALL_IE_PIN20(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetFALL_IE_PIN20() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetFALL_IE_PIN21(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetFALL_IE_PIN21() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetFALL_IE_PIN22(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetFALL_IE_PIN22() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetFALL_IE_PIN23(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetFALL_IE_PIN23() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetFALL_IE_PIN24(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetFALL_IE_PIN24() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetFALL_IE_PIN25(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetFALL_IE_PIN25() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetFALL_IE_PIN26(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetFALL_IE_PIN26() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetFALL_IE_PIN27(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetFALL_IE_PIN27() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetFALL_IE_PIN28(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetFALL_IE_PIN28() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetFALL_IE_PIN29(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetFALL_IE_PIN29() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetFALL_IE_PIN30(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetFALL_IE_PIN30() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetFALL_IE_PIN31(value uint32) {
	volatile.StoreUint32(&o.FALL_IE.Reg, volatile.LoadUint32(&o.FALL_IE.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetFALL_IE_PIN31() uint32 {
	return (volatile.LoadUint32(&o.FALL_IE.Reg) & 0x80000000) >> 31
}

// GPIO.FALL_IP: Fall Interrupt Pending Register
func (o *GPIO_Type) SetFALL_IP_PIN0(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetFALL_IP_PIN0() uint32 {
	return volatile.LoadUint32(&o.FALL_IP.Reg) & 0x1
}
func (o *GPIO_Type) SetFALL_IP_PIN1(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetFALL_IP_PIN1() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetFALL_IP_PIN2(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetFALL_IP_PIN2() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetFALL_IP_PIN3(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetFALL_IP_PIN3() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetFALL_IP_PIN4(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetFALL_IP_PIN4() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetFALL_IP_PIN5(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetFALL_IP_PIN5() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetFALL_IP_PIN6(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFALL_IP_PIN6() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFALL_IP_PIN7(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFALL_IP_PIN7() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetFALL_IP_PIN8(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFALL_IP_PIN8() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFALL_IP_PIN9(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFALL_IP_PIN9() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFALL_IP_PIN10(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFALL_IP_PIN10() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFALL_IP_PIN11(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFALL_IP_PIN11() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetFALL_IP_PIN12(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetFALL_IP_PIN12() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetFALL_IP_PIN13(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetFALL_IP_PIN13() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetFALL_IP_PIN14(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetFALL_IP_PIN14() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetFALL_IP_PIN15(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetFALL_IP_PIN15() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetFALL_IP_PIN16(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetFALL_IP_PIN16() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetFALL_IP_PIN17(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetFALL_IP_PIN17() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetFALL_IP_PIN18(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetFALL_IP_PIN18() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetFALL_IP_PIN19(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetFALL_IP_PIN19() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetFALL_IP_PIN20(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetFALL_IP_PIN20() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetFALL_IP_PIN21(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetFALL_IP_PIN21() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetFALL_IP_PIN22(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetFALL_IP_PIN22() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetFALL_IP_PIN23(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetFALL_IP_PIN23() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetFALL_IP_PIN24(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetFALL_IP_PIN24() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetFALL_IP_PIN25(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetFALL_IP_PIN25() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetFALL_IP_PIN26(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetFALL_IP_PIN26() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetFALL_IP_PIN27(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetFALL_IP_PIN27() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetFALL_IP_PIN28(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetFALL_IP_PIN28() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetFALL_IP_PIN29(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetFALL_IP_PIN29() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetFALL_IP_PIN30(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetFALL_IP_PIN30() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetFALL_IP_PIN31(value uint32) {
	volatile.StoreUint32(&o.FALL_IP.Reg, volatile.LoadUint32(&o.FALL_IP.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetFALL_IP_PIN31() uint32 {
	return (volatile.LoadUint32(&o.FALL_IP.Reg) & 0x80000000) >> 31
}

// GPIO.HIGH_IE: High Interrupt Enable Register
func (o *GPIO_Type) SetHIGH_IE_PIN0(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetHIGH_IE_PIN0() uint32 {
	return volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x1
}
func (o *GPIO_Type) SetHIGH_IE_PIN1(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetHIGH_IE_PIN1() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetHIGH_IE_PIN2(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetHIGH_IE_PIN2() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetHIGH_IE_PIN3(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetHIGH_IE_PIN3() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetHIGH_IE_PIN4(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetHIGH_IE_PIN4() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetHIGH_IE_PIN5(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetHIGH_IE_PIN5() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetHIGH_IE_PIN6(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetHIGH_IE_PIN6() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetHIGH_IE_PIN7(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetHIGH_IE_PIN7() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetHIGH_IE_PIN8(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetHIGH_IE_PIN8() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetHIGH_IE_PIN9(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetHIGH_IE_PIN9() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetHIGH_IE_PIN10(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetHIGH_IE_PIN10() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetHIGH_IE_PIN11(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetHIGH_IE_PIN11() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetHIGH_IE_PIN12(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetHIGH_IE_PIN12() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetHIGH_IE_PIN13(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetHIGH_IE_PIN13() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetHIGH_IE_PIN14(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetHIGH_IE_PIN14() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetHIGH_IE_PIN15(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetHIGH_IE_PIN15() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetHIGH_IE_PIN16(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetHIGH_IE_PIN16() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetHIGH_IE_PIN17(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetHIGH_IE_PIN17() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetHIGH_IE_PIN18(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetHIGH_IE_PIN18() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetHIGH_IE_PIN19(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetHIGH_IE_PIN19() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetHIGH_IE_PIN20(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetHIGH_IE_PIN20() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetHIGH_IE_PIN21(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetHIGH_IE_PIN21() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetHIGH_IE_PIN22(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetHIGH_IE_PIN22() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetHIGH_IE_PIN23(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetHIGH_IE_PIN23() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetHIGH_IE_PIN24(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetHIGH_IE_PIN24() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetHIGH_IE_PIN25(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetHIGH_IE_PIN25() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetHIGH_IE_PIN26(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetHIGH_IE_PIN26() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetHIGH_IE_PIN27(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetHIGH_IE_PIN27() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetHIGH_IE_PIN28(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetHIGH_IE_PIN28() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetHIGH_IE_PIN29(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetHIGH_IE_PIN29() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetHIGH_IE_PIN30(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetHIGH_IE_PIN30() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetHIGH_IE_PIN31(value uint32) {
	volatile.StoreUint32(&o.HIGH_IE.Reg, volatile.LoadUint32(&o.HIGH_IE.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetHIGH_IE_PIN31() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IE.Reg) & 0x80000000) >> 31
}

// GPIO.HIGH_IP: High Interrupt Pending Register
func (o *GPIO_Type) SetHIGH_IP_PIN0(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetHIGH_IP_PIN0() uint32 {
	return volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x1
}
func (o *GPIO_Type) SetHIGH_IP_PIN1(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetHIGH_IP_PIN1() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetHIGH_IP_PIN2(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetHIGH_IP_PIN2() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetHIGH_IP_PIN3(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetHIGH_IP_PIN3() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetHIGH_IP_PIN4(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetHIGH_IP_PIN4() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetHIGH_IP_PIN5(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetHIGH_IP_PIN5() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetHIGH_IP_PIN6(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetHIGH_IP_PIN6() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetHIGH_IP_PIN7(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetHIGH_IP_PIN7() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetHIGH_IP_PIN8(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetHIGH_IP_PIN8() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetHIGH_IP_PIN9(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetHIGH_IP_PIN9() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetHIGH_IP_PIN10(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetHIGH_IP_PIN10() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetHIGH_IP_PIN11(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetHIGH_IP_PIN11() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetHIGH_IP_PIN12(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetHIGH_IP_PIN12() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetHIGH_IP_PIN13(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetHIGH_IP_PIN13() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetHIGH_IP_PIN14(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetHIGH_IP_PIN14() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetHIGH_IP_PIN15(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetHIGH_IP_PIN15() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetHIGH_IP_PIN16(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetHIGH_IP_PIN16() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetHIGH_IP_PIN17(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetHIGH_IP_PIN17() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetHIGH_IP_PIN18(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetHIGH_IP_PIN18() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetHIGH_IP_PIN19(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetHIGH_IP_PIN19() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetHIGH_IP_PIN20(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetHIGH_IP_PIN20() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetHIGH_IP_PIN21(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetHIGH_IP_PIN21() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetHIGH_IP_PIN22(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetHIGH_IP_PIN22() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetHIGH_IP_PIN23(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetHIGH_IP_PIN23() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetHIGH_IP_PIN24(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetHIGH_IP_PIN24() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetHIGH_IP_PIN25(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetHIGH_IP_PIN25() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetHIGH_IP_PIN26(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetHIGH_IP_PIN26() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetHIGH_IP_PIN27(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetHIGH_IP_PIN27() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetHIGH_IP_PIN28(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetHIGH_IP_PIN28() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetHIGH_IP_PIN29(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetHIGH_IP_PIN29() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetHIGH_IP_PIN30(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetHIGH_IP_PIN30() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetHIGH_IP_PIN31(value uint32) {
	volatile.StoreUint32(&o.HIGH_IP.Reg, volatile.LoadUint32(&o.HIGH_IP.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetHIGH_IP_PIN31() uint32 {
	return (volatile.LoadUint32(&o.HIGH_IP.Reg) & 0x80000000) >> 31
}

// GPIO.LOW_IE: Low Interrupt Enable Register
func (o *GPIO_Type) SetLOW_IE_PIN0(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLOW_IE_PIN0() uint32 {
	return volatile.LoadUint32(&o.LOW_IE.Reg) & 0x1
}
func (o *GPIO_Type) SetLOW_IE_PIN1(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLOW_IE_PIN1() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLOW_IE_PIN2(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLOW_IE_PIN2() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLOW_IE_PIN3(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLOW_IE_PIN3() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLOW_IE_PIN4(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLOW_IE_PIN4() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLOW_IE_PIN5(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLOW_IE_PIN5() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLOW_IE_PIN6(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLOW_IE_PIN6() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLOW_IE_PIN7(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLOW_IE_PIN7() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLOW_IE_PIN8(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLOW_IE_PIN8() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLOW_IE_PIN9(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLOW_IE_PIN9() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLOW_IE_PIN10(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLOW_IE_PIN10() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLOW_IE_PIN11(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLOW_IE_PIN11() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLOW_IE_PIN12(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLOW_IE_PIN12() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLOW_IE_PIN13(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLOW_IE_PIN13() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLOW_IE_PIN14(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLOW_IE_PIN14() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLOW_IE_PIN15(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLOW_IE_PIN15() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLOW_IE_PIN16(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLOW_IE_PIN16() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLOW_IE_PIN17(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetLOW_IE_PIN17() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetLOW_IE_PIN18(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetLOW_IE_PIN18() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetLOW_IE_PIN19(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetLOW_IE_PIN19() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetLOW_IE_PIN20(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetLOW_IE_PIN20() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetLOW_IE_PIN21(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetLOW_IE_PIN21() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetLOW_IE_PIN22(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetLOW_IE_PIN22() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetLOW_IE_PIN23(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetLOW_IE_PIN23() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetLOW_IE_PIN24(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetLOW_IE_PIN24() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetLOW_IE_PIN25(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetLOW_IE_PIN25() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetLOW_IE_PIN26(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetLOW_IE_PIN26() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetLOW_IE_PIN27(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetLOW_IE_PIN27() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetLOW_IE_PIN28(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetLOW_IE_PIN28() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetLOW_IE_PIN29(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetLOW_IE_PIN29() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetLOW_IE_PIN30(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetLOW_IE_PIN30() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetLOW_IE_PIN31(value uint32) {
	volatile.StoreUint32(&o.LOW_IE.Reg, volatile.LoadUint32(&o.LOW_IE.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetLOW_IE_PIN31() uint32 {
	return (volatile.LoadUint32(&o.LOW_IE.Reg) & 0x80000000) >> 31
}

// GPIO.LOW_IP: Low Interrupt Pending Register
func (o *GPIO_Type) SetLOW_IP_PIN0(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLOW_IP_PIN0() uint32 {
	return volatile.LoadUint32(&o.LOW_IP.Reg) & 0x1
}
func (o *GPIO_Type) SetLOW_IP_PIN1(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLOW_IP_PIN1() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLOW_IP_PIN2(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLOW_IP_PIN2() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLOW_IP_PIN3(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLOW_IP_PIN3() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLOW_IP_PIN4(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLOW_IP_PIN4() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLOW_IP_PIN5(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLOW_IP_PIN5() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLOW_IP_PIN6(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLOW_IP_PIN6() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLOW_IP_PIN7(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLOW_IP_PIN7() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLOW_IP_PIN8(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLOW_IP_PIN8() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLOW_IP_PIN9(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLOW_IP_PIN9() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLOW_IP_PIN10(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLOW_IP_PIN10() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLOW_IP_PIN11(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLOW_IP_PIN11() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLOW_IP_PIN12(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLOW_IP_PIN12() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLOW_IP_PIN13(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLOW_IP_PIN13() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLOW_IP_PIN14(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLOW_IP_PIN14() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLOW_IP_PIN15(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLOW_IP_PIN15() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLOW_IP_PIN16(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLOW_IP_PIN16() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLOW_IP_PIN17(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetLOW_IP_PIN17() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetLOW_IP_PIN18(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetLOW_IP_PIN18() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetLOW_IP_PIN19(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetLOW_IP_PIN19() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetLOW_IP_PIN20(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetLOW_IP_PIN20() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetLOW_IP_PIN21(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetLOW_IP_PIN21() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetLOW_IP_PIN22(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetLOW_IP_PIN22() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetLOW_IP_PIN23(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetLOW_IP_PIN23() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetLOW_IP_PIN24(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetLOW_IP_PIN24() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetLOW_IP_PIN25(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetLOW_IP_PIN25() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetLOW_IP_PIN26(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetLOW_IP_PIN26() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetLOW_IP_PIN27(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetLOW_IP_PIN27() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetLOW_IP_PIN28(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetLOW_IP_PIN28() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetLOW_IP_PIN29(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetLOW_IP_PIN29() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetLOW_IP_PIN30(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetLOW_IP_PIN30() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetLOW_IP_PIN31(value uint32) {
	volatile.StoreUint32(&o.LOW_IP.Reg, volatile.LoadUint32(&o.LOW_IP.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetLOW_IP_PIN31() uint32 {
	return (volatile.LoadUint32(&o.LOW_IP.Reg) & 0x80000000) >> 31
}

// GPIO.IOF_EN: HW I/O Function Enable Register
func (o *GPIO_Type) SetIOF_EN_PIN0(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIOF_EN_PIN0() uint32 {
	return volatile.LoadUint32(&o.IOF_EN.Reg) & 0x1
}
func (o *GPIO_Type) SetIOF_EN_PIN1(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIOF_EN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIOF_EN_PIN2(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIOF_EN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIOF_EN_PIN3(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIOF_EN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIOF_EN_PIN4(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIOF_EN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIOF_EN_PIN5(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIOF_EN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIOF_EN_PIN6(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIOF_EN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIOF_EN_PIN7(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIOF_EN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIOF_EN_PIN8(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIOF_EN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIOF_EN_PIN9(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIOF_EN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIOF_EN_PIN10(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIOF_EN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIOF_EN_PIN11(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIOF_EN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIOF_EN_PIN12(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIOF_EN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIOF_EN_PIN13(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIOF_EN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIOF_EN_PIN14(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIOF_EN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIOF_EN_PIN15(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIOF_EN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIOF_EN_PIN16(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetIOF_EN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetIOF_EN_PIN17(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetIOF_EN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetIOF_EN_PIN18(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetIOF_EN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetIOF_EN_PIN19(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetIOF_EN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetIOF_EN_PIN20(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetIOF_EN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetIOF_EN_PIN21(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetIOF_EN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetIOF_EN_PIN22(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetIOF_EN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetIOF_EN_PIN23(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetIOF_EN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetIOF_EN_PIN24(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetIOF_EN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetIOF_EN_PIN25(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetIOF_EN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetIOF_EN_PIN26(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetIOF_EN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetIOF_EN_PIN27(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetIOF_EN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetIOF_EN_PIN28(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetIOF_EN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetIOF_EN_PIN29(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetIOF_EN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetIOF_EN_PIN30(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetIOF_EN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetIOF_EN_PIN31(value uint32) {
	volatile.StoreUint32(&o.IOF_EN.Reg, volatile.LoadUint32(&o.IOF_EN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetIOF_EN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.IOF_EN.Reg) & 0x80000000) >> 31
}

// GPIO.IOF_SEL: HW I/O Function Select Register
func (o *GPIO_Type) SetIOF_SEL_PIN0(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIOF_SEL_PIN0() uint32 {
	return volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x1
}
func (o *GPIO_Type) SetIOF_SEL_PIN1(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIOF_SEL_PIN1() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIOF_SEL_PIN2(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIOF_SEL_PIN2() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIOF_SEL_PIN3(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIOF_SEL_PIN3() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIOF_SEL_PIN4(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIOF_SEL_PIN4() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIOF_SEL_PIN5(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIOF_SEL_PIN5() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIOF_SEL_PIN6(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIOF_SEL_PIN6() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIOF_SEL_PIN7(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIOF_SEL_PIN7() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIOF_SEL_PIN8(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIOF_SEL_PIN8() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIOF_SEL_PIN9(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIOF_SEL_PIN9() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIOF_SEL_PIN10(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIOF_SEL_PIN10() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIOF_SEL_PIN11(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIOF_SEL_PIN11() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIOF_SEL_PIN12(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIOF_SEL_PIN12() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIOF_SEL_PIN13(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIOF_SEL_PIN13() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIOF_SEL_PIN14(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIOF_SEL_PIN14() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIOF_SEL_PIN15(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIOF_SEL_PIN15() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIOF_SEL_PIN16(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetIOF_SEL_PIN16() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetIOF_SEL_PIN17(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetIOF_SEL_PIN17() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetIOF_SEL_PIN18(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetIOF_SEL_PIN18() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetIOF_SEL_PIN19(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetIOF_SEL_PIN19() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetIOF_SEL_PIN20(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetIOF_SEL_PIN20() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetIOF_SEL_PIN21(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetIOF_SEL_PIN21() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetIOF_SEL_PIN22(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetIOF_SEL_PIN22() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetIOF_SEL_PIN23(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetIOF_SEL_PIN23() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetIOF_SEL_PIN24(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetIOF_SEL_PIN24() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetIOF_SEL_PIN25(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetIOF_SEL_PIN25() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetIOF_SEL_PIN26(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetIOF_SEL_PIN26() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetIOF_SEL_PIN27(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetIOF_SEL_PIN27() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetIOF_SEL_PIN28(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetIOF_SEL_PIN28() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetIOF_SEL_PIN29(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetIOF_SEL_PIN29() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetIOF_SEL_PIN30(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetIOF_SEL_PIN30() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetIOF_SEL_PIN31(value uint32) {
	volatile.StoreUint32(&o.IOF_SEL.Reg, volatile.LoadUint32(&o.IOF_SEL.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetIOF_SEL_PIN31() uint32 {
	return (volatile.LoadUint32(&o.IOF_SEL.Reg) & 0x80000000) >> 31
}

// GPIO.OUT_XOR: Output XOR (invert) Register
func (o *GPIO_Type) SetOUT_XOR_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUT_XOR_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x1
}
func (o *GPIO_Type) SetOUT_XOR_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUT_XOR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUT_XOR_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUT_XOR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUT_XOR_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUT_XOR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUT_XOR_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUT_XOR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUT_XOR_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUT_XOR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUT_XOR_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUT_XOR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUT_XOR_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUT_XOR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUT_XOR_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUT_XOR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUT_XOR_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUT_XOR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUT_XOR_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUT_XOR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUT_XOR_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUT_XOR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUT_XOR_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUT_XOR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUT_XOR_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUT_XOR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUT_XOR_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUT_XOR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUT_XOR_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUT_XOR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUT_XOR_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUT_XOR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUT_XOR_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUT_XOR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUT_XOR_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUT_XOR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUT_XOR_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUT_XOR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUT_XOR_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUT_XOR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUT_XOR_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUT_XOR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUT_XOR_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUT_XOR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUT_XOR_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUT_XOR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUT_XOR_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUT_XOR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUT_XOR_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUT_XOR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUT_XOR_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUT_XOR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUT_XOR_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUT_XOR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUT_XOR_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUT_XOR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUT_XOR_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUT_XOR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUT_XOR_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUT_XOR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUT_XOR_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUT_XOR.Reg, volatile.LoadUint32(&o.OUT_XOR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUT_XOR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUT_XOR.Reg) & 0x80000000) >> 31
}

// Universal Asynchronous Receiver Transmitter
type UART_Type struct {
	TXDATA volatile.Register32 // 0x0
	RXDATA volatile.Register32 // 0x4
	TXCTRL volatile.Register32 // 0x8
	RXCTRL volatile.Register32 // 0xC
	IE     volatile.Register32 // 0x10
	IP     volatile.Register32 // 0x14
	DIV    volatile.Register32 // 0x18
}

// UART.TXDATA: Transmit Data Register
func (o *UART_Type) SetTXDATA_FULL(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_Type) GetTXDATA_FULL() uint32 {
	return (volatile.LoadUint32(&o.TXDATA.Reg) & 0x80000000) >> 31
}
func (o *UART_Type) SetTXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg) & 0xff
}

// UART.RXDATA: Receive Data Register
func (o *UART_Type) SetRXDATA_EMPTY(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_Type) GetRXDATA_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.RXDATA.Reg) & 0x80000000) >> 31
}
func (o *UART_Type) SetRXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg) & 0xff
}

// UART.TXCTRL: Transmit Control Register
func (o *UART_Type) SetTXCTRL_COUNTER(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x70000)|value<<16)
}
func (o *UART_Type) GetTXCTRL_COUNTER() uint32 {
	return (volatile.LoadUint32(&o.TXCTRL.Reg) & 0x70000) >> 16
}
func (o *UART_Type) SetTXCTRL_NSTOP(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetTXCTRL_NSTOP() uint32 {
	return (volatile.LoadUint32(&o.TXCTRL.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetTXCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.TXCTRL.Reg, volatile.LoadUint32(&o.TXCTRL.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTXCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.TXCTRL.Reg) & 0x1
}

// UART.RXCTRL: Receive Control Register
func (o *UART_Type) SetRXCTRL_COUNTER(value uint32) {
	volatile.StoreUint32(&o.RXCTRL.Reg, volatile.LoadUint32(&o.RXCTRL.Reg)&^(0x70000)|value<<16)
}
func (o *UART_Type) GetRXCTRL_COUNTER() uint32 {
	return (volatile.LoadUint32(&o.RXCTRL.Reg) & 0x70000) >> 16
}
func (o *UART_Type) SetRXCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RXCTRL.Reg, volatile.LoadUint32(&o.RXCTRL.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetRXCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RXCTRL.Reg) & 0x1
}

// UART.IE: Interrupt Enable Register
func (o *UART_Type) SetIE_RXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIE_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIE_TXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIE_TXWM() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}

// UART.IP: Interrupt Pending Register
func (o *UART_Type) SetIP_RXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIP_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IP.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIP_TXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIP_TXWM() uint32 {
	return volatile.LoadUint32(&o.IP.Reg) & 0x1
}

// UART.DIV: Baud Rate Divisor Register
func (o *UART_Type) SetDIV_VALUE(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetDIV_VALUE() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xffff
}

// Quad Serial Peripheral Interface
type QSPI_Type struct {
	DIV    volatile.Register32 // 0x0
	MODE   volatile.Register32 // 0x4
	_      [8]byte
	CSID   volatile.Register32 // 0x10
	CSDEF  volatile.Register32 // 0x14
	CSMODE volatile.Register32 // 0x18
	_      [12]byte
	DELAY0 volatile.Register32 // 0x28
	DELAY1 volatile.Register32 // 0x2C
	_      [16]byte
	FMT    volatile.Register32 // 0x40
	_      [4]byte
	TXDATA volatile.Register32 // 0x48
	RXDATA volatile.Register32 // 0x4C
	TXMARK volatile.Register32 // 0x50
	RXMARK volatile.Register32 // 0x54
	_      [8]byte
	FCTRL  volatile.Register32 // 0x60
	FFMT   volatile.Register32 // 0x64
	_      [8]byte
	IE     volatile.Register32 // 0x70
	IP     volatile.Register32 // 0x74
}

// QSPI.DIV: Serial Clock Divisor Register
func (o *QSPI_Type) SetDIV_VALUE(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xfff)|value)
}
func (o *QSPI_Type) GetDIV_VALUE() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xfff
}

// QSPI.MODE: Serial Clock Mode Register
func (o *QSPI_Type) SetMODE_POLARITY(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetMODE_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetMODE_PHASE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetMODE_PHASE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// QSPI.DELAY0: Delay Control 0 Register
func (o *QSPI_Type) SetDELAY0_SCKCS(value uint32) {
	volatile.StoreUint32(&o.DELAY0.Reg, volatile.LoadUint32(&o.DELAY0.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetDELAY0_SCKCS() uint32 {
	return (volatile.LoadUint32(&o.DELAY0.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetDELAY0_CSSCK(value uint32) {
	volatile.StoreUint32(&o.DELAY0.Reg, volatile.LoadUint32(&o.DELAY0.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetDELAY0_CSSCK() uint32 {
	return volatile.LoadUint32(&o.DELAY0.Reg) & 0xff
}

// QSPI.DELAY1: Delay Control 1 Register
func (o *QSPI_Type) SetDELAY1_INTERXFR(value uint32) {
	volatile.StoreUint32(&o.DELAY1.Reg, volatile.LoadUint32(&o.DELAY1.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetDELAY1_INTERXFR() uint32 {
	return (volatile.LoadUint32(&o.DELAY1.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetDELAY1_INTERCS(value uint32) {
	volatile.StoreUint32(&o.DELAY1.Reg, volatile.LoadUint32(&o.DELAY1.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetDELAY1_INTERCS() uint32 {
	return volatile.LoadUint32(&o.DELAY1.Reg) & 0xff
}

// QSPI.FMT: Frame Format Register
func (o *QSPI_Type) SetFMT_LENGTH(value uint32) {
	volatile.StoreUint32(&o.FMT.Reg, volatile.LoadUint32(&o.FMT.Reg)&^(0xf0000)|value<<16)
}
func (o *QSPI_Type) GetFMT_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.FMT.Reg) & 0xf0000) >> 16
}
func (o *QSPI_Type) SetFMT_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.FMT.Reg, volatile.LoadUint32(&o.FMT.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetFMT_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.FMT.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetFMT_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.FMT.Reg, volatile.LoadUint32(&o.FMT.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetFMT_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.FMT.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetFMT_PROTOCOL(value uint32) {
	volatile.StoreUint32(&o.FMT.Reg, volatile.LoadUint32(&o.FMT.Reg)&^(0x3)|value)
}
func (o *QSPI_Type) GetFMT_PROTOCOL() uint32 {
	return volatile.LoadUint32(&o.FMT.Reg) & 0x3
}

// QSPI.TXDATA: Transmit Data Register
func (o *QSPI_Type) SetTXDATA_FULL(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetTXDATA_FULL() uint32 {
	return (volatile.LoadUint32(&o.TXDATA.Reg) & 0x80000000) >> 31
}
func (o *QSPI_Type) SetTXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetTXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg) & 0xff
}

// QSPI.RXDATA: Receive Data Register
func (o *QSPI_Type) SetRXDATA_EMPTY(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0x80000000)|value<<31)
}
func (o *QSPI_Type) GetRXDATA_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.RXDATA.Reg) & 0x80000000) >> 31
}
func (o *QSPI_Type) SetRXDATA_DATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetRXDATA_DATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg) & 0xff
}

// QSPI.TXMARK: Transmit Watermark Register
func (o *QSPI_Type) SetTXMARK_VALUE(value uint32) {
	volatile.StoreUint32(&o.TXMARK.Reg, volatile.LoadUint32(&o.TXMARK.Reg)&^(0x7)|value)
}
func (o *QSPI_Type) GetTXMARK_VALUE() uint32 {
	return volatile.LoadUint32(&o.TXMARK.Reg) & 0x7
}

// QSPI.RXMARK: Receive Watermark Register
func (o *QSPI_Type) SetRXMARK_VALUE(value uint32) {
	volatile.StoreUint32(&o.RXMARK.Reg, volatile.LoadUint32(&o.RXMARK.Reg)&^(0x7)|value)
}
func (o *QSPI_Type) GetRXMARK_VALUE() uint32 {
	return volatile.LoadUint32(&o.RXMARK.Reg) & 0x7
}

// QSPI.FCTRL: SPI Flash Interface Control Register
func (o *QSPI_Type) SetFCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.FCTRL.Reg, volatile.LoadUint32(&o.FCTRL.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetFCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.FCTRL.Reg) & 0x1
}

// QSPI.FFMT: SPI Flash Instruction Format Register
func (o *QSPI_Type) SetFFMT_PAD_CODE(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0xff000000)|value<<24)
}
func (o *QSPI_Type) GetFFMT_PAD_CODE() uint32 {
	return (volatile.LoadUint32(&o.FFMT.Reg) & 0xff000000) >> 24
}
func (o *QSPI_Type) SetFFMT_CMD_CODE(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetFFMT_CMD_CODE() uint32 {
	return (volatile.LoadUint32(&o.FFMT.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetFFMT_DATA_PROTO(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0x3000)|value<<12)
}
func (o *QSPI_Type) GetFFMT_DATA_PROTO() uint32 {
	return (volatile.LoadUint32(&o.FFMT.Reg) & 0x3000) >> 12
}
func (o *QSPI_Type) SetFFMT_ADDR_PROTO(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0xc00)|value<<10)
}
func (o *QSPI_Type) GetFFMT_ADDR_PROTO() uint32 {
	return (volatile.LoadUint32(&o.FFMT.Reg) & 0xc00) >> 10
}
func (o *QSPI_Type) SetFFMT_CMD_PROTO(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0x300)|value<<8)
}
func (o *QSPI_Type) GetFFMT_CMD_PROTO() uint32 {
	return (volatile.LoadUint32(&o.FFMT.Reg) & 0x300) >> 8
}
func (o *QSPI_Type) SetFFMT_PAD_CNT(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetFFMT_PAD_CNT() uint32 {
	return volatile.LoadUint32(&o.FFMT.Reg) & 0x1
}
func (o *QSPI_Type) SetFFMT_ADDR_LEN(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0xe)|value<<1)
}
func (o *QSPI_Type) GetFFMT_ADDR_LEN() uint32 {
	return (volatile.LoadUint32(&o.FFMT.Reg) & 0xe) >> 1
}
func (o *QSPI_Type) SetFFMT_CMD_EN(value uint32) {
	volatile.StoreUint32(&o.FFMT.Reg, volatile.LoadUint32(&o.FFMT.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetFFMT_CMD_EN() uint32 {
	return volatile.LoadUint32(&o.FFMT.Reg) & 0x1
}

// QSPI.IE: SPI Interrupt Enable Register
func (o *QSPI_Type) SetIE_RXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIE_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIE_TXWM(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIE_TXWM() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}

// QSPI.IP: SPI Interrupt Pending Register
func (o *QSPI_Type) SetIP_RXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIP_RXWM() uint32 {
	return (volatile.LoadUint32(&o.IP.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIP_TXWM(value uint32) {
	volatile.StoreUint32(&o.IP.Reg, volatile.LoadUint32(&o.IP.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIP_TXWM() uint32 {
	return volatile.LoadUint32(&o.IP.Reg) & 0x1
}

// 8-bit timer with 4 cmp
type PWM_Type struct {
	CFG   volatile.Register32 // 0x0
	_     [4]byte
	COUNT volatile.Register32 // 0x8
	_     [4]byte
	PWMS  volatile.Register32 // 0x10
	_     [12]byte
	CMP0  volatile.Register32 // 0x20
	CMP1  volatile.Register32 // 0x24
	CMP2  volatile.Register32 // 0x28
	CMP3  volatile.Register32 // 0x2C
}

// PWM.CFG: PWM Configuration Register
func (o *PWM_Type) SetCFG_CMP3IP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetCFG_CMP3IP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80000000) >> 31
}
func (o *PWM_Type) SetCFG_CMP2IP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40000000)|value<<30)
}
func (o *PWM_Type) GetCFG_CMP2IP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40000000) >> 30
}
func (o *PWM_Type) SetCFG_CMP1IP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x20000000)|value<<29)
}
func (o *PWM_Type) GetCFG_CMP1IP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x20000000) >> 29
}
func (o *PWM_Type) SetCFG_CMP0IP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10000000)|value<<28)
}
func (o *PWM_Type) GetCFG_CMP0IP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10000000) >> 28
}
func (o *PWM_Type) SetCFG_CMP3GANG(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8000000)|value<<27)
}
func (o *PWM_Type) GetCFG_CMP3GANG() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8000000) >> 27
}
func (o *PWM_Type) SetCFG_CMP2GANG(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xfc000000)|value<<26)
}
func (o *PWM_Type) GetCFG_CMP2GANG() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xfc000000) >> 26
}
func (o *PWM_Type) SetCFG_CMP1GANG(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2000000)|value<<25)
}
func (o *PWM_Type) GetCFG_CMP1GANG() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2000000) >> 25
}
func (o *PWM_Type) SetCFG_CMP0GANG(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCFG_CMP0GANG() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000000) >> 24
}
func (o *PWM_Type) SetCFG_CMP3CENTER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetCFG_CMP3CENTER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetCFG_CMP2CENTER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCFG_CMP2CENTER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetCFG_CMP1CENTER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCFG_CMP1CENTER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCFG_CMP0CENTER(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCFG_CMP0CENTER() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCFG_ENONESHOT(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCFG_ENONESHOT() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetCFG_ENALWAYS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetCFG_ENALWAYS() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetCFG_DEGLITCH(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCFG_DEGLITCH() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCFG_ZEROCMP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCFG_ZEROCMP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCFG_STICKY(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCFG_STICKY() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCFG_SCALE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCFG_SCALE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0xf
}

// PWM.CMP0: Compare Register
func (o *PWM_Type) SetCMP0_VALUE(value uint32) {
	volatile.StoreUint32(&o.CMP0.Reg, volatile.LoadUint32(&o.CMP0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCMP0_VALUE() uint32 {
	return volatile.LoadUint32(&o.CMP0.Reg) & 0xffff
}

// PWM.CMP1: Compare Register
func (o *PWM_Type) SetCMP1_VALUE(value uint32) {
	volatile.StoreUint32(&o.CMP1.Reg, volatile.LoadUint32(&o.CMP1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCMP1_VALUE() uint32 {
	return volatile.LoadUint32(&o.CMP1.Reg) & 0xffff
}

// PWM.CMP2: Compare Register
func (o *PWM_Type) SetCMP2_VALUE(value uint32) {
	volatile.StoreUint32(&o.CMP2.Reg, volatile.LoadUint32(&o.CMP2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCMP2_VALUE() uint32 {
	return volatile.LoadUint32(&o.CMP2.Reg) & 0xffff
}

// PWM.CMP3: Compare Register
func (o *PWM_Type) SetCMP3_VALUE(value uint32) {
	volatile.StoreUint32(&o.CMP3.Reg, volatile.LoadUint32(&o.CMP3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCMP3_VALUE() uint32 {
	return volatile.LoadUint32(&o.CMP3.Reg) & 0xffff
}

// Inter-Integrated Circuit Master Interface (FE310-G002 only)
type I2C_Type struct {
	PRER_LO volatile.Register32 // 0x0
	PRER_HI volatile.Register32 // 0x4
	CTR     volatile.Register32 // 0x8
	TXR_RXR volatile.Register32 // 0xC
	CR_SR   volatile.Register32 // 0x10
}

// I2C.PRER_LO: Clock Prescale register lo-byte
func (o *I2C_Type) SetPRER_LO_VALUE(value uint32) {
	volatile.StoreUint32(&o.PRER_LO.Reg, volatile.LoadUint32(&o.PRER_LO.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPRER_LO_VALUE() uint32 {
	return volatile.LoadUint32(&o.PRER_LO.Reg) & 0xff
}

// I2C.PRER_HI: Clock Prescale register hi-byte
func (o *I2C_Type) SetPRER_HI_VALUE(value uint32) {
	volatile.StoreUint32(&o.PRER_HI.Reg, volatile.LoadUint32(&o.PRER_HI.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPRER_HI_VALUE() uint32 {
	return volatile.LoadUint32(&o.PRER_HI.Reg) & 0xff
}

// I2C.CTR: Control register
func (o *I2C_Type) SetCTR_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_IEN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}

// I2C.TXR_RXR: Transmit register / Receive register
func (o *I2C_Type) SetTXR_RXR_DATA(value uint32) {
	volatile.StoreUint32(&o.TXR_RXR.Reg, volatile.LoadUint32(&o.TXR_RXR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXR_RXR_DATA() uint32 {
	return volatile.LoadUint32(&o.TXR_RXR.Reg) & 0xff
}

// Constants for CLINT: Coreplex Local Interrupts
const ()

// Constants for PLIC: Platform Level Interrupt Control
const (
	// THRESHOLD: Priority Threshold Register
	// Position of PRIORITY field.
	PLIC_THRESHOLD_PRIORITY_Pos = 0x0
	// Bit mask of PRIORITY field.
	PLIC_THRESHOLD_PRIORITY_Msk = 0x7
	// Never interrupt
	PLIC_THRESHOLD_PRIORITY_Never = 0x0
	// Priority 1
	PLIC_THRESHOLD_PRIORITY_P1 = 0x1
	// Priority 2
	PLIC_THRESHOLD_PRIORITY_P2 = 0x2
	// Priority 3
	PLIC_THRESHOLD_PRIORITY_P3 = 0x3
	// Priority 4
	PLIC_THRESHOLD_PRIORITY_P4 = 0x4
	// Priority 5
	PLIC_THRESHOLD_PRIORITY_P5 = 0x5
	// Priority 6
	PLIC_THRESHOLD_PRIORITY_P6 = 0x6
	// Priority 7
	PLIC_THRESHOLD_PRIORITY_P7 = 0x7
)

// Constants for WDOG: Watchdog
const (
	// WDOGCFG: Watchdog Configuration Register
	// Position of CMPIP field.
	Watchdog_WDOGCFG_CMPIP_Pos = 0x1c
	// Bit mask of CMPIP field.
	Watchdog_WDOGCFG_CMPIP_Msk = 0x10000000
	// Bit CMPIP.
	Watchdog_WDOGCFG_CMPIP = 0x10000000
	// Position of ENCOREAWAKE field.
	Watchdog_WDOGCFG_ENCOREAWAKE_Pos = 0xd
	// Bit mask of ENCOREAWAKE field.
	Watchdog_WDOGCFG_ENCOREAWAKE_Msk = 0x2000
	// Bit ENCOREAWAKE.
	Watchdog_WDOGCFG_ENCOREAWAKE = 0x2000
	// Position of ENALWAYS field.
	Watchdog_WDOGCFG_ENALWAYS_Pos = 0xc
	// Bit mask of ENALWAYS field.
	Watchdog_WDOGCFG_ENALWAYS_Msk = 0x1000
	// Bit ENALWAYS.
	Watchdog_WDOGCFG_ENALWAYS = 0x1000
	// Position of ZEROCMP field.
	Watchdog_WDOGCFG_ZEROCMP_Pos = 0x9
	// Bit mask of ZEROCMP field.
	Watchdog_WDOGCFG_ZEROCMP_Msk = 0x200
	// Bit ZEROCMP.
	Watchdog_WDOGCFG_ZEROCMP = 0x200
	// Position of RSTEN field.
	Watchdog_WDOGCFG_RSTEN_Pos = 0x8
	// Bit mask of RSTEN field.
	Watchdog_WDOGCFG_RSTEN_Msk = 0x100
	// Bit RSTEN.
	Watchdog_WDOGCFG_RSTEN = 0x100
	// Position of SCALE field.
	Watchdog_WDOGCFG_SCALE_Pos = 0x0
	// Bit mask of SCALE field.
	Watchdog_WDOGCFG_SCALE_Msk = 0xf

	// WDOGCMP: Watchdog Compare Register
	// Position of VALUE field.
	Watchdog_WDOGCMP_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	Watchdog_WDOGCMP_VALUE_Msk = 0xffff
)

// Constants for RTC: Watchdog
const (
	// RTCCFG: RTC Configuration Register
	// Position of CMPIP field.
	RTC_RTCCFG_CMPIP_Pos = 0x1c
	// Bit mask of CMPIP field.
	RTC_RTCCFG_CMPIP_Msk = 0x10000000
	// Bit CMPIP.
	RTC_RTCCFG_CMPIP = 0x10000000
	// Position of ENALWAYS field.
	RTC_RTCCFG_ENALWAYS_Pos = 0xc
	// Bit mask of ENALWAYS field.
	RTC_RTCCFG_ENALWAYS_Msk = 0x1000
	// Bit ENALWAYS.
	RTC_RTCCFG_ENALWAYS = 0x1000
	// Position of SCALE field.
	RTC_RTCCFG_SCALE_Pos = 0x0
	// Bit mask of SCALE field.
	RTC_RTCCFG_SCALE_Msk = 0xf

	// RTCHI: RTC Counter High Register
	// Position of VALUE field.
	RTC_RTCHI_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_RTCHI_VALUE_Msk = 0xffff
)

// Constants for AONCLK: Always-On Clock Configuration
const (
	// LFROSCCFG: AON Clock Configuration Register
	// Position of READY field.
	AONCLOCK_LFROSCCFG_READY_Pos = 0x1f
	// Bit mask of READY field.
	AONCLOCK_LFROSCCFG_READY_Msk = 0x80000000
	// Bit READY.
	AONCLOCK_LFROSCCFG_READY = 0x80000000
	// Position of ENABLE field.
	AONCLOCK_LFROSCCFG_ENABLE_Pos = 0x1e
	// Bit mask of ENABLE field.
	AONCLOCK_LFROSCCFG_ENABLE_Msk = 0x40000000
	// Bit ENABLE.
	AONCLOCK_LFROSCCFG_ENABLE = 0x40000000
	// Position of TRIM field.
	AONCLOCK_LFROSCCFG_TRIM_Pos = 0x10
	// Bit mask of TRIM field.
	AONCLOCK_LFROSCCFG_TRIM_Msk = 0x1f0000
	// Position of DIV field.
	AONCLOCK_LFROSCCFG_DIV_Pos = 0x0
	// Bit mask of DIV field.
	AONCLOCK_LFROSCCFG_DIV_Msk = 0x3f
)

// Constants for BACKUP: Backup Registers
const ()

// Constants for PMU: PMU
const (
	// PMUWAKEPM: PMU Wake Program Memory
	// Position of ISOLATE field.
	PMU_PMUWAKEPM_ISOLATE_Pos = 0x9
	// Bit mask of ISOLATE field.
	PMU_PMUWAKEPM_ISOLATE_Msk = 0x200
	// Bit ISOLATE.
	PMU_PMUWAKEPM_ISOLATE = 0x200
	// Position of HFCLKRST field.
	PMU_PMUWAKEPM_HFCLKRST_Pos = 0x8
	// Bit mask of HFCLKRST field.
	PMU_PMUWAKEPM_HFCLKRST_Msk = 0x100
	// Bit HFCLKRST.
	PMU_PMUWAKEPM_HFCLKRST = 0x100
	// Position of CORERST field.
	PMU_PMUWAKEPM_CORERST_Pos = 0x7
	// Bit mask of CORERST field.
	PMU_PMUWAKEPM_CORERST_Msk = 0x80
	// Bit CORERST.
	PMU_PMUWAKEPM_CORERST = 0x80
	// Position of PMU_OUT_1_EN field.
	PMU_PMUWAKEPM_PMU_OUT_1_EN_Pos = 0x5
	// Bit mask of PMU_OUT_1_EN field.
	PMU_PMUWAKEPM_PMU_OUT_1_EN_Msk = 0x20
	// Bit PMU_OUT_1_EN.
	PMU_PMUWAKEPM_PMU_OUT_1_EN = 0x20
	// Position of PMU_OUT_0_EN field.
	PMU_PMUWAKEPM_PMU_OUT_0_EN_Pos = 0x4
	// Bit mask of PMU_OUT_0_EN field.
	PMU_PMUWAKEPM_PMU_OUT_0_EN_Msk = 0x10
	// Bit PMU_OUT_0_EN.
	PMU_PMUWAKEPM_PMU_OUT_0_EN = 0x10
	// Position of DELAY field.
	PMU_PMUWAKEPM_DELAY_Pos = 0x0
	// Bit mask of DELAY field.
	PMU_PMUWAKEPM_DELAY_Msk = 0xf

	// PMUSLEEPPM: PMU Sleep Program Memory
	// Position of ISOLATE field.
	PMU_PMUSLEEPPM_ISOLATE_Pos = 0x9
	// Bit mask of ISOLATE field.
	PMU_PMUSLEEPPM_ISOLATE_Msk = 0x200
	// Bit ISOLATE.
	PMU_PMUSLEEPPM_ISOLATE = 0x200
	// Position of HFCLKRST field.
	PMU_PMUSLEEPPM_HFCLKRST_Pos = 0x8
	// Bit mask of HFCLKRST field.
	PMU_PMUSLEEPPM_HFCLKRST_Msk = 0x100
	// Bit HFCLKRST.
	PMU_PMUSLEEPPM_HFCLKRST = 0x100
	// Position of CORERST field.
	PMU_PMUSLEEPPM_CORERST_Pos = 0x7
	// Bit mask of CORERST field.
	PMU_PMUSLEEPPM_CORERST_Msk = 0x80
	// Bit CORERST.
	PMU_PMUSLEEPPM_CORERST = 0x80
	// Position of PMU_OUT_1_EN field.
	PMU_PMUSLEEPPM_PMU_OUT_1_EN_Pos = 0x5
	// Bit mask of PMU_OUT_1_EN field.
	PMU_PMUSLEEPPM_PMU_OUT_1_EN_Msk = 0x20
	// Bit PMU_OUT_1_EN.
	PMU_PMUSLEEPPM_PMU_OUT_1_EN = 0x20
	// Position of PMU_OUT_0_EN field.
	PMU_PMUSLEEPPM_PMU_OUT_0_EN_Pos = 0x4
	// Bit mask of PMU_OUT_0_EN field.
	PMU_PMUSLEEPPM_PMU_OUT_0_EN_Msk = 0x10
	// Bit PMU_OUT_0_EN.
	PMU_PMUSLEEPPM_PMU_OUT_0_EN = 0x10
	// Position of DELAY field.
	PMU_PMUSLEEPPM_DELAY_Pos = 0x0
	// Bit mask of DELAY field.
	PMU_PMUSLEEPPM_DELAY_Msk = 0xf

	// PMUIE: PMU Interrupt Enable Register
	// Position of AWAKEUP field.
	PMU_PMUIE_AWAKEUP_Pos = 0x3
	// Bit mask of AWAKEUP field.
	PMU_PMUIE_AWAKEUP_Msk = 0x8
	// Bit AWAKEUP.
	PMU_PMUIE_AWAKEUP = 0x8
	// Position of DWAKEUP field.
	PMU_PMUIE_DWAKEUP_Pos = 0x2
	// Bit mask of DWAKEUP field.
	PMU_PMUIE_DWAKEUP_Msk = 0x4
	// Bit DWAKEUP.
	PMU_PMUIE_DWAKEUP = 0x4
	// Position of RTC field.
	PMU_PMUIE_RTC_Pos = 0x1
	// Bit mask of RTC field.
	PMU_PMUIE_RTC_Msk = 0x2
	// Bit RTC.
	PMU_PMUIE_RTC = 0x2

	// PMUCAUSE: PMU Cause Register
	// Position of RESETCAUSE field.
	PMU_PMUCAUSE_RESETCAUSE_Pos = 0x8
	// Bit mask of RESETCAUSE field.
	PMU_PMUCAUSE_RESETCAUSE_Msk = 0x300
	// Power-on reset
	PMU_PMUCAUSE_RESETCAUSE_PowerOn = 0x0
	// External reset
	PMU_PMUCAUSE_RESETCAUSE_External = 0x1
	// Watchdog reset
	PMU_PMUCAUSE_RESETCAUSE_Watchdog = 0x2
	// Position of WAKEUPCAUSE field.
	PMU_PMUCAUSE_WAKEUPCAUSE_Pos = 0x0
	// Bit mask of WAKEUPCAUSE field.
	PMU_PMUCAUSE_WAKEUPCAUSE_Msk = 0x3
	// Reset wakeup
	PMU_PMUCAUSE_WAKEUPCAUSE_Reset = 0x0
	// RTC wakeup
	PMU_PMUCAUSE_WAKEUPCAUSE_RTC = 0x1
	// Digital input wakeup
	PMU_PMUCAUSE_WAKEUPCAUSE_Digital = 0x2

	// PMUSLEEP: PMU Sleep Register
	// Position of SLEEP field.
	PMU_PMUSLEEP_SLEEP_Pos = 0x0
	// Bit mask of SLEEP field.
	PMU_PMUSLEEP_SLEEP_Msk = 0x1
	// Bit SLEEP.
	PMU_PMUSLEEP_SLEEP = 0x1
)

// Constants for PRCI: Power Reset Clock Interrupts
const (
	// HFROSCCFG: Clock Configuration Register
	// Position of READY field.
	PRCI_HFROSCCFG_READY_Pos = 0x1f
	// Bit mask of READY field.
	PRCI_HFROSCCFG_READY_Msk = 0x80000000
	// Bit READY.
	PRCI_HFROSCCFG_READY = 0x80000000
	// Position of ENABLE field.
	PRCI_HFROSCCFG_ENABLE_Pos = 0x1e
	// Bit mask of ENABLE field.
	PRCI_HFROSCCFG_ENABLE_Msk = 0x40000000
	// Bit ENABLE.
	PRCI_HFROSCCFG_ENABLE = 0x40000000
	// Position of TRIM field.
	PRCI_HFROSCCFG_TRIM_Pos = 0x10
	// Bit mask of TRIM field.
	PRCI_HFROSCCFG_TRIM_Msk = 0x1f0000
	// Position of DIV field.
	PRCI_HFROSCCFG_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PRCI_HFROSCCFG_DIV_Msk = 0x3f

	// HFXOSCCFG: Clock Configuration Register
	// Position of READY field.
	PRCI_HFXOSCCFG_READY_Pos = 0x1f
	// Bit mask of READY field.
	PRCI_HFXOSCCFG_READY_Msk = 0x80000000
	// Bit READY.
	PRCI_HFXOSCCFG_READY = 0x80000000
	// Position of ENABLE field.
	PRCI_HFXOSCCFG_ENABLE_Pos = 0x1e
	// Bit mask of ENABLE field.
	PRCI_HFXOSCCFG_ENABLE_Msk = 0x40000000
	// Bit ENABLE.
	PRCI_HFXOSCCFG_ENABLE = 0x40000000

	// PLLCFG: PLL Configuration Register
	// Position of LOCK field.
	PRCI_PLLCFG_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	PRCI_PLLCFG_LOCK_Msk = 0x80000000
	// Bit LOCK.
	PRCI_PLLCFG_LOCK = 0x80000000
	// Position of BYPASS field.
	PRCI_PLLCFG_BYPASS_Pos = 0x12
	// Bit mask of BYPASS field.
	PRCI_PLLCFG_BYPASS_Msk = 0x40000
	// Bit BYPASS.
	PRCI_PLLCFG_BYPASS = 0x40000
	// Position of REFSEL field.
	PRCI_PLLCFG_REFSEL_Pos = 0x11
	// Bit mask of REFSEL field.
	PRCI_PLLCFG_REFSEL_Msk = 0x20000
	// Bit REFSEL.
	PRCI_PLLCFG_REFSEL = 0x20000
	// Position of SEL field.
	PRCI_PLLCFG_SEL_Pos = 0x10
	// Bit mask of SEL field.
	PRCI_PLLCFG_SEL_Msk = 0x10000
	// Bit SEL.
	PRCI_PLLCFG_SEL = 0x10000
	// Position of PLLQ field.
	PRCI_PLLCFG_PLLQ_Pos = 0xa
	// Bit mask of PLLQ field.
	PRCI_PLLCFG_PLLQ_Msk = 0xc00
	PRCI_PLLCFG_PLLQ_Q2  = 0x1
	PRCI_PLLCFG_PLLQ_Q4  = 0x2
	PRCI_PLLCFG_PLLQ_Q8  = 0x3
	// Position of PLLF field.
	PRCI_PLLCFG_PLLF_Pos = 0x4
	// Bit mask of PLLF field.
	PRCI_PLLCFG_PLLF_Msk = 0x3f0
	// Position of PLLR field.
	PRCI_PLLCFG_PLLR_Pos = 0x0
	// Bit mask of PLLR field.
	PRCI_PLLCFG_PLLR_Msk = 0x7
	PRCI_PLLCFG_PLLR_R1  = 0x0
	PRCI_PLLCFG_PLLR_R2  = 0x1
	PRCI_PLLCFG_PLLR_R3  = 0x2
	PRCI_PLLCFG_PLLR_R4  = 0x3

	// PLLOUTDIV: PLL Divider Register
	// Position of DIVBY1 field.
	PRCI_PLLOUTDIV_DIVBY1_Pos = 0x8
	// Bit mask of DIVBY1 field.
	PRCI_PLLOUTDIV_DIVBY1_Msk = 0x100
	// Bit DIVBY1.
	PRCI_PLLOUTDIV_DIVBY1 = 0x100
	// Position of DIV field.
	PRCI_PLLOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PRCI_PLLOUTDIV_DIV_Msk = 0x3f
)

// Constants for OTP: One Time Programmable Memory
const ()

// Constants for GPIO0: General Purpose Input Output
const (
	// VALUE: Pin value.
	// Position of PIN0 field.
	GPIO_VALUE_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_VALUE_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_VALUE_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_VALUE_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_VALUE_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_VALUE_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_VALUE_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_VALUE_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_VALUE_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_VALUE_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_VALUE_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_VALUE_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_VALUE_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_VALUE_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_VALUE_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_VALUE_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_VALUE_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_VALUE_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_VALUE_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_VALUE_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_VALUE_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_VALUE_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_VALUE_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_VALUE_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_VALUE_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_VALUE_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_VALUE_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_VALUE_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_VALUE_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_VALUE_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_VALUE_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_VALUE_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_VALUE_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_VALUE_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_VALUE_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_VALUE_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_VALUE_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_VALUE_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_VALUE_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_VALUE_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_VALUE_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_VALUE_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_VALUE_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_VALUE_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_VALUE_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_VALUE_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_VALUE_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_VALUE_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_VALUE_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_VALUE_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_VALUE_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_VALUE_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_VALUE_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_VALUE_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_VALUE_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_VALUE_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_VALUE_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_VALUE_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_VALUE_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_VALUE_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_VALUE_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_VALUE_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_VALUE_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_VALUE_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_VALUE_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_VALUE_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_VALUE_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_VALUE_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_VALUE_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_VALUE_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_VALUE_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_VALUE_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_VALUE_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_VALUE_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_VALUE_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_VALUE_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_VALUE_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_VALUE_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_VALUE_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_VALUE_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_VALUE_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_VALUE_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_VALUE_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_VALUE_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_VALUE_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_VALUE_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_VALUE_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_VALUE_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_VALUE_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_VALUE_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_VALUE_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_VALUE_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_VALUE_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_VALUE_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_VALUE_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_VALUE_PIN31 = 0x80000000

	// INPUT_EN: Pin Input Enable Register
	// Position of PIN0 field.
	GPIO_INPUT_EN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_INPUT_EN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_INPUT_EN_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_INPUT_EN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_INPUT_EN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_INPUT_EN_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_INPUT_EN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_INPUT_EN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_INPUT_EN_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_INPUT_EN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_INPUT_EN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_INPUT_EN_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_INPUT_EN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_INPUT_EN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_INPUT_EN_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_INPUT_EN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_INPUT_EN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_INPUT_EN_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_INPUT_EN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_INPUT_EN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_INPUT_EN_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_INPUT_EN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_INPUT_EN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_INPUT_EN_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_INPUT_EN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_INPUT_EN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_INPUT_EN_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_INPUT_EN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_INPUT_EN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_INPUT_EN_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_INPUT_EN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_INPUT_EN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_INPUT_EN_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_INPUT_EN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_INPUT_EN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_INPUT_EN_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_INPUT_EN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_INPUT_EN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_INPUT_EN_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_INPUT_EN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_INPUT_EN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_INPUT_EN_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_INPUT_EN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_INPUT_EN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_INPUT_EN_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_INPUT_EN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_INPUT_EN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_INPUT_EN_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_INPUT_EN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_INPUT_EN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_INPUT_EN_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_INPUT_EN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_INPUT_EN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_INPUT_EN_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_INPUT_EN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_INPUT_EN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_INPUT_EN_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_INPUT_EN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_INPUT_EN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_INPUT_EN_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_INPUT_EN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_INPUT_EN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_INPUT_EN_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_INPUT_EN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_INPUT_EN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_INPUT_EN_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_INPUT_EN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_INPUT_EN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_INPUT_EN_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_INPUT_EN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_INPUT_EN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_INPUT_EN_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_INPUT_EN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_INPUT_EN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_INPUT_EN_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_INPUT_EN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_INPUT_EN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_INPUT_EN_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_INPUT_EN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_INPUT_EN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_INPUT_EN_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_INPUT_EN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_INPUT_EN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_INPUT_EN_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_INPUT_EN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_INPUT_EN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_INPUT_EN_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_INPUT_EN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_INPUT_EN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_INPUT_EN_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_INPUT_EN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_INPUT_EN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_INPUT_EN_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_INPUT_EN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_INPUT_EN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_INPUT_EN_PIN31 = 0x80000000

	// OUTPUT_EN: Pin Output Enable Register
	// Position of PIN0 field.
	GPIO_OUTPUT_EN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTPUT_EN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTPUT_EN_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_OUTPUT_EN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTPUT_EN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTPUT_EN_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_OUTPUT_EN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTPUT_EN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTPUT_EN_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_OUTPUT_EN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTPUT_EN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTPUT_EN_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_OUTPUT_EN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTPUT_EN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTPUT_EN_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_OUTPUT_EN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTPUT_EN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTPUT_EN_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_OUTPUT_EN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTPUT_EN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTPUT_EN_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_OUTPUT_EN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTPUT_EN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTPUT_EN_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_OUTPUT_EN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTPUT_EN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTPUT_EN_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_OUTPUT_EN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTPUT_EN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTPUT_EN_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_OUTPUT_EN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTPUT_EN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTPUT_EN_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_OUTPUT_EN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTPUT_EN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTPUT_EN_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_OUTPUT_EN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTPUT_EN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTPUT_EN_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_OUTPUT_EN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTPUT_EN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTPUT_EN_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_OUTPUT_EN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTPUT_EN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTPUT_EN_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_OUTPUT_EN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTPUT_EN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTPUT_EN_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_OUTPUT_EN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTPUT_EN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTPUT_EN_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_OUTPUT_EN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTPUT_EN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTPUT_EN_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_OUTPUT_EN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTPUT_EN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTPUT_EN_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_OUTPUT_EN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTPUT_EN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTPUT_EN_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_OUTPUT_EN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTPUT_EN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTPUT_EN_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_OUTPUT_EN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTPUT_EN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTPUT_EN_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_OUTPUT_EN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTPUT_EN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTPUT_EN_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_OUTPUT_EN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTPUT_EN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTPUT_EN_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_OUTPUT_EN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTPUT_EN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTPUT_EN_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_OUTPUT_EN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTPUT_EN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTPUT_EN_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_OUTPUT_EN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTPUT_EN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTPUT_EN_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_OUTPUT_EN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTPUT_EN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTPUT_EN_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_OUTPUT_EN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTPUT_EN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTPUT_EN_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_OUTPUT_EN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTPUT_EN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTPUT_EN_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_OUTPUT_EN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTPUT_EN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTPUT_EN_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_OUTPUT_EN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTPUT_EN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTPUT_EN_PIN31 = 0x80000000

	// PORT: Output Port Value Register
	// Position of PIN0 field.
	GPIO_PORT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_PORT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_PORT_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_PORT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_PORT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_PORT_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_PORT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_PORT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_PORT_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_PORT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_PORT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_PORT_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_PORT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_PORT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_PORT_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_PORT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_PORT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_PORT_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_PORT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_PORT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_PORT_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_PORT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_PORT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_PORT_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_PORT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_PORT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_PORT_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_PORT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_PORT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_PORT_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_PORT_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_PORT_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_PORT_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_PORT_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_PORT_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_PORT_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_PORT_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_PORT_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_PORT_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_PORT_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_PORT_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_PORT_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_PORT_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_PORT_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_PORT_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_PORT_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_PORT_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_PORT_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_PORT_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_PORT_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_PORT_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_PORT_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_PORT_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_PORT_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_PORT_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_PORT_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_PORT_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_PORT_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_PORT_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_PORT_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_PORT_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_PORT_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_PORT_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_PORT_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_PORT_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_PORT_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_PORT_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_PORT_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_PORT_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_PORT_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_PORT_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_PORT_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_PORT_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_PORT_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_PORT_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_PORT_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_PORT_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_PORT_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_PORT_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_PORT_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_PORT_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_PORT_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_PORT_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_PORT_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_PORT_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_PORT_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_PORT_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_PORT_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_PORT_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_PORT_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_PORT_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_PORT_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_PORT_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_PORT_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_PORT_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_PORT_PIN31 = 0x80000000

	// PULLUP: Internal Pull-Up Enable Register
	// Position of PIN0 field.
	GPIO_PULLUP_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_PULLUP_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_PULLUP_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_PULLUP_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_PULLUP_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_PULLUP_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_PULLUP_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_PULLUP_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_PULLUP_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_PULLUP_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_PULLUP_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_PULLUP_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_PULLUP_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_PULLUP_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_PULLUP_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_PULLUP_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_PULLUP_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_PULLUP_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_PULLUP_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_PULLUP_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_PULLUP_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_PULLUP_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_PULLUP_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_PULLUP_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_PULLUP_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_PULLUP_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_PULLUP_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_PULLUP_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_PULLUP_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_PULLUP_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_PULLUP_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_PULLUP_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_PULLUP_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_PULLUP_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_PULLUP_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_PULLUP_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_PULLUP_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_PULLUP_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_PULLUP_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_PULLUP_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_PULLUP_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_PULLUP_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_PULLUP_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_PULLUP_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_PULLUP_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_PULLUP_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_PULLUP_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_PULLUP_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_PULLUP_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_PULLUP_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_PULLUP_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_PULLUP_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_PULLUP_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_PULLUP_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_PULLUP_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_PULLUP_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_PULLUP_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_PULLUP_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_PULLUP_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_PULLUP_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_PULLUP_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_PULLUP_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_PULLUP_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_PULLUP_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_PULLUP_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_PULLUP_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_PULLUP_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_PULLUP_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_PULLUP_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_PULLUP_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_PULLUP_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_PULLUP_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_PULLUP_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_PULLUP_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_PULLUP_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_PULLUP_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_PULLUP_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_PULLUP_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_PULLUP_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_PULLUP_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_PULLUP_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_PULLUP_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_PULLUP_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_PULLUP_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_PULLUP_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_PULLUP_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_PULLUP_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_PULLUP_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_PULLUP_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_PULLUP_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_PULLUP_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_PULLUP_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_PULLUP_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_PULLUP_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_PULLUP_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_PULLUP_PIN31 = 0x80000000

	// DRIVE: Drive Strength Register
	// Position of PIN0 field.
	GPIO_DRIVE_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DRIVE_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DRIVE_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_DRIVE_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DRIVE_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DRIVE_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_DRIVE_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DRIVE_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DRIVE_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_DRIVE_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DRIVE_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DRIVE_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_DRIVE_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DRIVE_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DRIVE_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_DRIVE_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DRIVE_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DRIVE_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_DRIVE_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DRIVE_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DRIVE_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_DRIVE_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DRIVE_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DRIVE_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_DRIVE_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DRIVE_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DRIVE_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_DRIVE_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DRIVE_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DRIVE_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_DRIVE_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DRIVE_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DRIVE_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_DRIVE_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DRIVE_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DRIVE_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_DRIVE_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DRIVE_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DRIVE_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_DRIVE_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DRIVE_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DRIVE_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_DRIVE_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DRIVE_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DRIVE_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_DRIVE_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DRIVE_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DRIVE_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_DRIVE_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DRIVE_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DRIVE_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_DRIVE_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DRIVE_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DRIVE_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_DRIVE_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DRIVE_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DRIVE_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_DRIVE_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DRIVE_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DRIVE_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_DRIVE_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DRIVE_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DRIVE_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_DRIVE_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DRIVE_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DRIVE_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_DRIVE_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DRIVE_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DRIVE_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_DRIVE_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DRIVE_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DRIVE_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_DRIVE_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DRIVE_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DRIVE_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_DRIVE_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DRIVE_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DRIVE_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_DRIVE_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DRIVE_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DRIVE_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_DRIVE_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DRIVE_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DRIVE_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_DRIVE_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DRIVE_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DRIVE_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_DRIVE_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DRIVE_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DRIVE_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_DRIVE_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DRIVE_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DRIVE_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_DRIVE_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DRIVE_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DRIVE_PIN31 = 0x80000000

	// RISE_IE: Rise Interrupt Enable Register
	// Position of PIN0 field.
	GPIO_RISE_IE_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_RISE_IE_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_RISE_IE_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_RISE_IE_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_RISE_IE_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_RISE_IE_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_RISE_IE_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_RISE_IE_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_RISE_IE_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_RISE_IE_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_RISE_IE_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_RISE_IE_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_RISE_IE_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_RISE_IE_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_RISE_IE_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_RISE_IE_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_RISE_IE_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_RISE_IE_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_RISE_IE_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_RISE_IE_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_RISE_IE_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_RISE_IE_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_RISE_IE_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_RISE_IE_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_RISE_IE_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_RISE_IE_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_RISE_IE_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_RISE_IE_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_RISE_IE_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_RISE_IE_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_RISE_IE_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_RISE_IE_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_RISE_IE_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_RISE_IE_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_RISE_IE_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_RISE_IE_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_RISE_IE_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_RISE_IE_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_RISE_IE_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_RISE_IE_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_RISE_IE_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_RISE_IE_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_RISE_IE_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_RISE_IE_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_RISE_IE_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_RISE_IE_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_RISE_IE_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_RISE_IE_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_RISE_IE_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_RISE_IE_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_RISE_IE_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_RISE_IE_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_RISE_IE_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_RISE_IE_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_RISE_IE_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_RISE_IE_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_RISE_IE_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_RISE_IE_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_RISE_IE_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_RISE_IE_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_RISE_IE_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_RISE_IE_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_RISE_IE_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_RISE_IE_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_RISE_IE_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_RISE_IE_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_RISE_IE_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_RISE_IE_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_RISE_IE_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_RISE_IE_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_RISE_IE_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_RISE_IE_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_RISE_IE_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_RISE_IE_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_RISE_IE_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_RISE_IE_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_RISE_IE_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_RISE_IE_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_RISE_IE_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_RISE_IE_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_RISE_IE_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_RISE_IE_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_RISE_IE_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_RISE_IE_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_RISE_IE_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_RISE_IE_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_RISE_IE_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_RISE_IE_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_RISE_IE_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_RISE_IE_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_RISE_IE_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_RISE_IE_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_RISE_IE_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_RISE_IE_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_RISE_IE_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_RISE_IE_PIN31 = 0x80000000

	// RISE_IP: Rise Interrupt Pending Register
	// Position of PIN0 field.
	GPIO_RISE_IP_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_RISE_IP_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_RISE_IP_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_RISE_IP_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_RISE_IP_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_RISE_IP_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_RISE_IP_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_RISE_IP_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_RISE_IP_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_RISE_IP_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_RISE_IP_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_RISE_IP_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_RISE_IP_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_RISE_IP_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_RISE_IP_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_RISE_IP_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_RISE_IP_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_RISE_IP_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_RISE_IP_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_RISE_IP_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_RISE_IP_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_RISE_IP_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_RISE_IP_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_RISE_IP_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_RISE_IP_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_RISE_IP_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_RISE_IP_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_RISE_IP_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_RISE_IP_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_RISE_IP_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_RISE_IP_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_RISE_IP_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_RISE_IP_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_RISE_IP_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_RISE_IP_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_RISE_IP_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_RISE_IP_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_RISE_IP_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_RISE_IP_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_RISE_IP_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_RISE_IP_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_RISE_IP_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_RISE_IP_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_RISE_IP_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_RISE_IP_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_RISE_IP_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_RISE_IP_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_RISE_IP_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_RISE_IP_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_RISE_IP_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_RISE_IP_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_RISE_IP_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_RISE_IP_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_RISE_IP_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_RISE_IP_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_RISE_IP_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_RISE_IP_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_RISE_IP_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_RISE_IP_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_RISE_IP_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_RISE_IP_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_RISE_IP_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_RISE_IP_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_RISE_IP_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_RISE_IP_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_RISE_IP_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_RISE_IP_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_RISE_IP_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_RISE_IP_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_RISE_IP_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_RISE_IP_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_RISE_IP_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_RISE_IP_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_RISE_IP_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_RISE_IP_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_RISE_IP_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_RISE_IP_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_RISE_IP_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_RISE_IP_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_RISE_IP_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_RISE_IP_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_RISE_IP_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_RISE_IP_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_RISE_IP_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_RISE_IP_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_RISE_IP_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_RISE_IP_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_RISE_IP_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_RISE_IP_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_RISE_IP_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_RISE_IP_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_RISE_IP_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_RISE_IP_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_RISE_IP_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_RISE_IP_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_RISE_IP_PIN31 = 0x80000000

	// FALL_IE: Fall Interrupt Enable Register
	// Position of PIN0 field.
	GPIO_FALL_IE_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_FALL_IE_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_FALL_IE_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_FALL_IE_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_FALL_IE_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_FALL_IE_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_FALL_IE_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_FALL_IE_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_FALL_IE_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_FALL_IE_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_FALL_IE_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_FALL_IE_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_FALL_IE_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_FALL_IE_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_FALL_IE_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_FALL_IE_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_FALL_IE_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_FALL_IE_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_FALL_IE_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_FALL_IE_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_FALL_IE_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_FALL_IE_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_FALL_IE_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_FALL_IE_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_FALL_IE_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_FALL_IE_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_FALL_IE_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_FALL_IE_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_FALL_IE_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_FALL_IE_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_FALL_IE_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_FALL_IE_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_FALL_IE_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_FALL_IE_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_FALL_IE_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_FALL_IE_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_FALL_IE_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_FALL_IE_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_FALL_IE_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_FALL_IE_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_FALL_IE_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_FALL_IE_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_FALL_IE_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_FALL_IE_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_FALL_IE_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_FALL_IE_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_FALL_IE_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_FALL_IE_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_FALL_IE_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_FALL_IE_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_FALL_IE_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_FALL_IE_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_FALL_IE_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_FALL_IE_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_FALL_IE_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_FALL_IE_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_FALL_IE_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_FALL_IE_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_FALL_IE_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_FALL_IE_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_FALL_IE_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_FALL_IE_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_FALL_IE_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_FALL_IE_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_FALL_IE_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_FALL_IE_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_FALL_IE_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_FALL_IE_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_FALL_IE_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_FALL_IE_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_FALL_IE_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_FALL_IE_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_FALL_IE_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_FALL_IE_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_FALL_IE_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_FALL_IE_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_FALL_IE_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_FALL_IE_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_FALL_IE_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_FALL_IE_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_FALL_IE_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_FALL_IE_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_FALL_IE_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_FALL_IE_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_FALL_IE_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_FALL_IE_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_FALL_IE_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_FALL_IE_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_FALL_IE_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_FALL_IE_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_FALL_IE_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_FALL_IE_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_FALL_IE_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_FALL_IE_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_FALL_IE_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_FALL_IE_PIN31 = 0x80000000

	// FALL_IP: Fall Interrupt Pending Register
	// Position of PIN0 field.
	GPIO_FALL_IP_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_FALL_IP_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_FALL_IP_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_FALL_IP_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_FALL_IP_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_FALL_IP_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_FALL_IP_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_FALL_IP_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_FALL_IP_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_FALL_IP_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_FALL_IP_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_FALL_IP_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_FALL_IP_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_FALL_IP_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_FALL_IP_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_FALL_IP_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_FALL_IP_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_FALL_IP_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_FALL_IP_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_FALL_IP_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_FALL_IP_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_FALL_IP_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_FALL_IP_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_FALL_IP_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_FALL_IP_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_FALL_IP_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_FALL_IP_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_FALL_IP_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_FALL_IP_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_FALL_IP_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_FALL_IP_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_FALL_IP_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_FALL_IP_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_FALL_IP_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_FALL_IP_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_FALL_IP_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_FALL_IP_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_FALL_IP_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_FALL_IP_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_FALL_IP_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_FALL_IP_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_FALL_IP_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_FALL_IP_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_FALL_IP_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_FALL_IP_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_FALL_IP_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_FALL_IP_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_FALL_IP_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_FALL_IP_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_FALL_IP_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_FALL_IP_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_FALL_IP_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_FALL_IP_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_FALL_IP_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_FALL_IP_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_FALL_IP_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_FALL_IP_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_FALL_IP_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_FALL_IP_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_FALL_IP_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_FALL_IP_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_FALL_IP_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_FALL_IP_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_FALL_IP_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_FALL_IP_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_FALL_IP_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_FALL_IP_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_FALL_IP_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_FALL_IP_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_FALL_IP_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_FALL_IP_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_FALL_IP_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_FALL_IP_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_FALL_IP_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_FALL_IP_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_FALL_IP_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_FALL_IP_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_FALL_IP_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_FALL_IP_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_FALL_IP_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_FALL_IP_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_FALL_IP_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_FALL_IP_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_FALL_IP_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_FALL_IP_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_FALL_IP_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_FALL_IP_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_FALL_IP_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_FALL_IP_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_FALL_IP_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_FALL_IP_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_FALL_IP_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_FALL_IP_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_FALL_IP_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_FALL_IP_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_FALL_IP_PIN31 = 0x80000000

	// HIGH_IE: High Interrupt Enable Register
	// Position of PIN0 field.
	GPIO_HIGH_IE_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_HIGH_IE_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_HIGH_IE_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_HIGH_IE_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_HIGH_IE_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_HIGH_IE_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_HIGH_IE_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_HIGH_IE_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_HIGH_IE_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_HIGH_IE_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_HIGH_IE_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_HIGH_IE_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_HIGH_IE_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_HIGH_IE_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_HIGH_IE_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_HIGH_IE_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_HIGH_IE_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_HIGH_IE_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_HIGH_IE_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_HIGH_IE_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_HIGH_IE_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_HIGH_IE_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_HIGH_IE_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_HIGH_IE_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_HIGH_IE_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_HIGH_IE_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_HIGH_IE_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_HIGH_IE_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_HIGH_IE_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_HIGH_IE_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_HIGH_IE_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_HIGH_IE_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_HIGH_IE_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_HIGH_IE_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_HIGH_IE_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_HIGH_IE_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_HIGH_IE_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_HIGH_IE_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_HIGH_IE_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_HIGH_IE_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_HIGH_IE_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_HIGH_IE_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_HIGH_IE_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_HIGH_IE_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_HIGH_IE_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_HIGH_IE_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_HIGH_IE_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_HIGH_IE_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_HIGH_IE_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_HIGH_IE_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_HIGH_IE_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_HIGH_IE_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_HIGH_IE_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_HIGH_IE_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_HIGH_IE_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_HIGH_IE_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_HIGH_IE_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_HIGH_IE_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_HIGH_IE_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_HIGH_IE_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_HIGH_IE_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_HIGH_IE_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_HIGH_IE_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_HIGH_IE_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_HIGH_IE_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_HIGH_IE_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_HIGH_IE_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_HIGH_IE_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_HIGH_IE_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_HIGH_IE_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_HIGH_IE_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_HIGH_IE_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_HIGH_IE_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_HIGH_IE_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_HIGH_IE_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_HIGH_IE_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_HIGH_IE_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_HIGH_IE_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_HIGH_IE_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_HIGH_IE_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_HIGH_IE_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_HIGH_IE_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_HIGH_IE_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_HIGH_IE_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_HIGH_IE_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_HIGH_IE_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_HIGH_IE_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_HIGH_IE_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_HIGH_IE_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_HIGH_IE_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_HIGH_IE_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_HIGH_IE_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_HIGH_IE_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_HIGH_IE_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_HIGH_IE_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_HIGH_IE_PIN31 = 0x80000000

	// HIGH_IP: High Interrupt Pending Register
	// Position of PIN0 field.
	GPIO_HIGH_IP_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_HIGH_IP_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_HIGH_IP_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_HIGH_IP_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_HIGH_IP_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_HIGH_IP_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_HIGH_IP_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_HIGH_IP_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_HIGH_IP_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_HIGH_IP_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_HIGH_IP_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_HIGH_IP_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_HIGH_IP_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_HIGH_IP_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_HIGH_IP_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_HIGH_IP_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_HIGH_IP_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_HIGH_IP_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_HIGH_IP_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_HIGH_IP_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_HIGH_IP_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_HIGH_IP_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_HIGH_IP_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_HIGH_IP_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_HIGH_IP_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_HIGH_IP_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_HIGH_IP_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_HIGH_IP_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_HIGH_IP_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_HIGH_IP_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_HIGH_IP_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_HIGH_IP_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_HIGH_IP_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_HIGH_IP_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_HIGH_IP_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_HIGH_IP_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_HIGH_IP_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_HIGH_IP_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_HIGH_IP_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_HIGH_IP_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_HIGH_IP_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_HIGH_IP_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_HIGH_IP_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_HIGH_IP_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_HIGH_IP_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_HIGH_IP_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_HIGH_IP_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_HIGH_IP_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_HIGH_IP_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_HIGH_IP_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_HIGH_IP_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_HIGH_IP_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_HIGH_IP_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_HIGH_IP_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_HIGH_IP_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_HIGH_IP_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_HIGH_IP_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_HIGH_IP_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_HIGH_IP_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_HIGH_IP_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_HIGH_IP_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_HIGH_IP_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_HIGH_IP_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_HIGH_IP_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_HIGH_IP_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_HIGH_IP_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_HIGH_IP_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_HIGH_IP_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_HIGH_IP_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_HIGH_IP_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_HIGH_IP_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_HIGH_IP_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_HIGH_IP_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_HIGH_IP_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_HIGH_IP_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_HIGH_IP_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_HIGH_IP_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_HIGH_IP_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_HIGH_IP_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_HIGH_IP_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_HIGH_IP_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_HIGH_IP_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_HIGH_IP_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_HIGH_IP_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_HIGH_IP_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_HIGH_IP_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_HIGH_IP_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_HIGH_IP_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_HIGH_IP_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_HIGH_IP_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_HIGH_IP_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_HIGH_IP_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_HIGH_IP_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_HIGH_IP_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_HIGH_IP_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_HIGH_IP_PIN31 = 0x80000000

	// LOW_IE: Low Interrupt Enable Register
	// Position of PIN0 field.
	GPIO_LOW_IE_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_LOW_IE_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_LOW_IE_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_LOW_IE_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_LOW_IE_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_LOW_IE_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_LOW_IE_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_LOW_IE_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_LOW_IE_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_LOW_IE_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_LOW_IE_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_LOW_IE_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_LOW_IE_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_LOW_IE_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_LOW_IE_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_LOW_IE_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_LOW_IE_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_LOW_IE_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_LOW_IE_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_LOW_IE_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_LOW_IE_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_LOW_IE_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_LOW_IE_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_LOW_IE_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_LOW_IE_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_LOW_IE_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_LOW_IE_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_LOW_IE_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_LOW_IE_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_LOW_IE_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_LOW_IE_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_LOW_IE_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_LOW_IE_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_LOW_IE_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_LOW_IE_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_LOW_IE_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_LOW_IE_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_LOW_IE_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_LOW_IE_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_LOW_IE_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_LOW_IE_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_LOW_IE_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_LOW_IE_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_LOW_IE_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_LOW_IE_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_LOW_IE_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_LOW_IE_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_LOW_IE_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_LOW_IE_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_LOW_IE_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_LOW_IE_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_LOW_IE_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_LOW_IE_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_LOW_IE_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_LOW_IE_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_LOW_IE_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_LOW_IE_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_LOW_IE_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_LOW_IE_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_LOW_IE_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_LOW_IE_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_LOW_IE_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_LOW_IE_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_LOW_IE_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_LOW_IE_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_LOW_IE_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_LOW_IE_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_LOW_IE_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_LOW_IE_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_LOW_IE_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_LOW_IE_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_LOW_IE_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_LOW_IE_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_LOW_IE_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_LOW_IE_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_LOW_IE_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_LOW_IE_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_LOW_IE_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_LOW_IE_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_LOW_IE_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_LOW_IE_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_LOW_IE_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_LOW_IE_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_LOW_IE_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_LOW_IE_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_LOW_IE_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_LOW_IE_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_LOW_IE_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_LOW_IE_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_LOW_IE_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_LOW_IE_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_LOW_IE_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_LOW_IE_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_LOW_IE_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_LOW_IE_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_LOW_IE_PIN31 = 0x80000000

	// LOW_IP: Low Interrupt Pending Register
	// Position of PIN0 field.
	GPIO_LOW_IP_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_LOW_IP_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_LOW_IP_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_LOW_IP_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_LOW_IP_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_LOW_IP_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_LOW_IP_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_LOW_IP_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_LOW_IP_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_LOW_IP_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_LOW_IP_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_LOW_IP_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_LOW_IP_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_LOW_IP_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_LOW_IP_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_LOW_IP_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_LOW_IP_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_LOW_IP_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_LOW_IP_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_LOW_IP_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_LOW_IP_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_LOW_IP_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_LOW_IP_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_LOW_IP_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_LOW_IP_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_LOW_IP_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_LOW_IP_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_LOW_IP_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_LOW_IP_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_LOW_IP_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_LOW_IP_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_LOW_IP_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_LOW_IP_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_LOW_IP_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_LOW_IP_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_LOW_IP_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_LOW_IP_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_LOW_IP_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_LOW_IP_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_LOW_IP_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_LOW_IP_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_LOW_IP_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_LOW_IP_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_LOW_IP_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_LOW_IP_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_LOW_IP_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_LOW_IP_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_LOW_IP_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_LOW_IP_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_LOW_IP_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_LOW_IP_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_LOW_IP_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_LOW_IP_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_LOW_IP_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_LOW_IP_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_LOW_IP_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_LOW_IP_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_LOW_IP_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_LOW_IP_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_LOW_IP_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_LOW_IP_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_LOW_IP_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_LOW_IP_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_LOW_IP_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_LOW_IP_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_LOW_IP_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_LOW_IP_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_LOW_IP_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_LOW_IP_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_LOW_IP_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_LOW_IP_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_LOW_IP_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_LOW_IP_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_LOW_IP_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_LOW_IP_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_LOW_IP_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_LOW_IP_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_LOW_IP_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_LOW_IP_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_LOW_IP_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_LOW_IP_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_LOW_IP_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_LOW_IP_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_LOW_IP_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_LOW_IP_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_LOW_IP_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_LOW_IP_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_LOW_IP_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_LOW_IP_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_LOW_IP_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_LOW_IP_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_LOW_IP_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_LOW_IP_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_LOW_IP_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_LOW_IP_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_LOW_IP_PIN31 = 0x80000000

	// IOF_EN: HW I/O Function Enable Register
	// Position of PIN0 field.
	GPIO_IOF_EN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IOF_EN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IOF_EN_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_IOF_EN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IOF_EN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IOF_EN_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_IOF_EN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IOF_EN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IOF_EN_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_IOF_EN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IOF_EN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IOF_EN_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_IOF_EN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IOF_EN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IOF_EN_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_IOF_EN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IOF_EN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IOF_EN_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_IOF_EN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IOF_EN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IOF_EN_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_IOF_EN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IOF_EN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IOF_EN_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_IOF_EN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IOF_EN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IOF_EN_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_IOF_EN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IOF_EN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IOF_EN_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_IOF_EN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IOF_EN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IOF_EN_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_IOF_EN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IOF_EN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IOF_EN_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_IOF_EN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IOF_EN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IOF_EN_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_IOF_EN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IOF_EN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IOF_EN_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_IOF_EN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IOF_EN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IOF_EN_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_IOF_EN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IOF_EN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IOF_EN_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_IOF_EN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IOF_EN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IOF_EN_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_IOF_EN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IOF_EN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IOF_EN_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_IOF_EN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IOF_EN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IOF_EN_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_IOF_EN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IOF_EN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IOF_EN_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_IOF_EN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IOF_EN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IOF_EN_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_IOF_EN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IOF_EN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IOF_EN_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_IOF_EN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IOF_EN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IOF_EN_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_IOF_EN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IOF_EN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IOF_EN_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_IOF_EN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IOF_EN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IOF_EN_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_IOF_EN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IOF_EN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IOF_EN_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_IOF_EN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IOF_EN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IOF_EN_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_IOF_EN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IOF_EN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IOF_EN_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_IOF_EN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IOF_EN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IOF_EN_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_IOF_EN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IOF_EN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IOF_EN_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_IOF_EN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IOF_EN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IOF_EN_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_IOF_EN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IOF_EN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IOF_EN_PIN31 = 0x80000000

	// IOF_SEL: HW I/O Function Select Register
	// Position of PIN0 field.
	GPIO_IOF_SEL_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IOF_SEL_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IOF_SEL_PIN0        = 0x1
	GPIO_IOF_SEL_PIN0_IOF0   = 0x0
	GPIO_IOF_SEL_PIN0_PWM0_0 = 0x1
	// Position of PIN1 field.
	GPIO_IOF_SEL_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IOF_SEL_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IOF_SEL_PIN1        = 0x2
	GPIO_IOF_SEL_PIN1_IOF0   = 0x0
	GPIO_IOF_SEL_PIN1_PWM0_1 = 0x1
	// Position of PIN2 field.
	GPIO_IOF_SEL_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IOF_SEL_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IOF_SEL_PIN2           = 0x4
	GPIO_IOF_SEL_PIN2_QSPI1_SS0 = 0x0
	GPIO_IOF_SEL_PIN2_PWM0_2    = 0x1
	// Position of PIN3 field.
	GPIO_IOF_SEL_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IOF_SEL_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IOF_SEL_PIN3           = 0x8
	GPIO_IOF_SEL_PIN3_QSPI1_SD0 = 0x0
	GPIO_IOF_SEL_PIN3_PWM0_3    = 0x1
	// Position of PIN4 field.
	GPIO_IOF_SEL_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IOF_SEL_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IOF_SEL_PIN4           = 0x10
	GPIO_IOF_SEL_PIN4_QSPI1_SD1 = 0x0
	GPIO_IOF_SEL_PIN4_IOF1      = 0x1
	// Position of PIN5 field.
	GPIO_IOF_SEL_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IOF_SEL_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IOF_SEL_PIN5           = 0x20
	GPIO_IOF_SEL_PIN5_QSPI1_SCK = 0x0
	GPIO_IOF_SEL_PIN5_IOF1      = 0x1
	// Position of PIN6 field.
	GPIO_IOF_SEL_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IOF_SEL_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IOF_SEL_PIN6           = 0x40
	GPIO_IOF_SEL_PIN6_QSPI1_SD2 = 0x0
	GPIO_IOF_SEL_PIN6_IOF1      = 0x1
	// Position of PIN7 field.
	GPIO_IOF_SEL_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IOF_SEL_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IOF_SEL_PIN7           = 0x80
	GPIO_IOF_SEL_PIN7_QSPI1_SD3 = 0x0
	GPIO_IOF_SEL_PIN7_IOF1      = 0x1
	// Position of PIN8 field.
	GPIO_IOF_SEL_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IOF_SEL_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IOF_SEL_PIN8           = 0x100
	GPIO_IOF_SEL_PIN8_QSPI1_SS1 = 0x0
	GPIO_IOF_SEL_PIN8_IOF1      = 0x1
	// Position of PIN9 field.
	GPIO_IOF_SEL_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IOF_SEL_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IOF_SEL_PIN9           = 0x200
	GPIO_IOF_SEL_PIN9_QSPI1_SS2 = 0x0
	GPIO_IOF_SEL_PIN9_IOF1      = 0x1
	// Position of PIN10 field.
	GPIO_IOF_SEL_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IOF_SEL_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IOF_SEL_PIN10           = 0x400
	GPIO_IOF_SEL_PIN10_QSPI1_SS3 = 0x0
	GPIO_IOF_SEL_PIN10_PWM2_0    = 0x1
	// Position of PIN11 field.
	GPIO_IOF_SEL_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IOF_SEL_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IOF_SEL_PIN11        = 0x800
	GPIO_IOF_SEL_PIN11_IOF0   = 0x0
	GPIO_IOF_SEL_PIN11_PWM2_1 = 0x1
	// Position of PIN12 field.
	GPIO_IOF_SEL_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IOF_SEL_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IOF_SEL_PIN12        = 0x1000
	GPIO_IOF_SEL_PIN12_IOF0   = 0x0
	GPIO_IOF_SEL_PIN12_PWM2_2 = 0x1
	// Position of PIN13 field.
	GPIO_IOF_SEL_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IOF_SEL_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IOF_SEL_PIN13        = 0x2000
	GPIO_IOF_SEL_PIN13_IOF0   = 0x0
	GPIO_IOF_SEL_PIN13_PWM2_3 = 0x1
	// Position of PIN14 field.
	GPIO_IOF_SEL_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IOF_SEL_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IOF_SEL_PIN14      = 0x4000
	GPIO_IOF_SEL_PIN14_IOF0 = 0x0
	GPIO_IOF_SEL_PIN14_IOF1 = 0x1
	// Position of PIN15 field.
	GPIO_IOF_SEL_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IOF_SEL_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IOF_SEL_PIN15      = 0x8000
	GPIO_IOF_SEL_PIN15_IOF0 = 0x0
	GPIO_IOF_SEL_PIN15_IOF1 = 0x1
	// Position of PIN16 field.
	GPIO_IOF_SEL_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IOF_SEL_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IOF_SEL_PIN16          = 0x10000
	GPIO_IOF_SEL_PIN16_UART0_RX = 0x0
	GPIO_IOF_SEL_PIN16_IOF1     = 0x1
	// Position of PIN17 field.
	GPIO_IOF_SEL_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IOF_SEL_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IOF_SEL_PIN17          = 0x20000
	GPIO_IOF_SEL_PIN17_UART0_TX = 0x0
	GPIO_IOF_SEL_PIN17_IOF1     = 0x1
	// Position of PIN18 field.
	GPIO_IOF_SEL_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IOF_SEL_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IOF_SEL_PIN18      = 0x40000
	GPIO_IOF_SEL_PIN18_IOF0 = 0x0
	GPIO_IOF_SEL_PIN18_IOF1 = 0x1
	// Position of PIN19 field.
	GPIO_IOF_SEL_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IOF_SEL_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IOF_SEL_PIN19        = 0x80000
	GPIO_IOF_SEL_PIN19_IOF0   = 0x0
	GPIO_IOF_SEL_PIN19_PWM1_1 = 0x1
	// Position of PIN20 field.
	GPIO_IOF_SEL_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IOF_SEL_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IOF_SEL_PIN20        = 0x100000
	GPIO_IOF_SEL_PIN20_IOF0   = 0x0
	GPIO_IOF_SEL_PIN20_PWM1_0 = 0x1
	// Position of PIN21 field.
	GPIO_IOF_SEL_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IOF_SEL_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IOF_SEL_PIN21        = 0x200000
	GPIO_IOF_SEL_PIN21_IOF0   = 0x0
	GPIO_IOF_SEL_PIN21_PWM1_2 = 0x1
	// Position of PIN22 field.
	GPIO_IOF_SEL_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IOF_SEL_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IOF_SEL_PIN22        = 0x400000
	GPIO_IOF_SEL_PIN22_IOF0   = 0x0
	GPIO_IOF_SEL_PIN22_PWM1_3 = 0x1
	// Position of PIN23 field.
	GPIO_IOF_SEL_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IOF_SEL_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IOF_SEL_PIN23      = 0x800000
	GPIO_IOF_SEL_PIN23_IOF0 = 0x0
	GPIO_IOF_SEL_PIN23_IOF1 = 0x1
	// Position of PIN24 field.
	GPIO_IOF_SEL_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IOF_SEL_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IOF_SEL_PIN24          = 0x1000000
	GPIO_IOF_SEL_PIN24_UART1_RX = 0x0
	GPIO_IOF_SEL_PIN24_IOF1     = 0x1
	// Position of PIN25 field.
	GPIO_IOF_SEL_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IOF_SEL_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IOF_SEL_PIN25          = 0x2000000
	GPIO_IOF_SEL_PIN25_UART1_TX = 0x0
	GPIO_IOF_SEL_PIN25_IOF1     = 0x1
	// Position of PIN26 field.
	GPIO_IOF_SEL_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IOF_SEL_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IOF_SEL_PIN26          = 0x4000000
	GPIO_IOF_SEL_PIN26_QSPI2_SS = 0x0
	GPIO_IOF_SEL_PIN26_IOF1     = 0x1
	// Position of PIN27 field.
	GPIO_IOF_SEL_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IOF_SEL_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IOF_SEL_PIN27           = 0x8000000
	GPIO_IOF_SEL_PIN27_QSPI2_SD0 = 0x0
	GPIO_IOF_SEL_PIN27_IOF1      = 0x1
	// Position of PIN28 field.
	GPIO_IOF_SEL_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IOF_SEL_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IOF_SEL_PIN28           = 0x10000000
	GPIO_IOF_SEL_PIN28_QSPI2_SD1 = 0x0
	GPIO_IOF_SEL_PIN28_IOF1      = 0x1
	// Position of PIN29 field.
	GPIO_IOF_SEL_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IOF_SEL_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IOF_SEL_PIN29           = 0x20000000
	GPIO_IOF_SEL_PIN29_QSPI2_SCK = 0x0
	GPIO_IOF_SEL_PIN29_IOF1      = 0x1
	// Position of PIN30 field.
	GPIO_IOF_SEL_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IOF_SEL_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IOF_SEL_PIN30           = 0x40000000
	GPIO_IOF_SEL_PIN30_QSPI2_SD2 = 0x0
	GPIO_IOF_SEL_PIN30_IOF1      = 0x1
	// Position of PIN31 field.
	GPIO_IOF_SEL_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IOF_SEL_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IOF_SEL_PIN31           = 0x80000000
	GPIO_IOF_SEL_PIN31_QSPI2_SD3 = 0x0
	GPIO_IOF_SEL_PIN31_IOF1      = 0x1

	// OUT_XOR: Output XOR (invert) Register
	// Position of PIN0 field.
	GPIO_OUT_XOR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_XOR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_XOR_PIN0 = 0x1
	// Position of PIN1 field.
	GPIO_OUT_XOR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_XOR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_XOR_PIN1 = 0x2
	// Position of PIN2 field.
	GPIO_OUT_XOR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_XOR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_XOR_PIN2 = 0x4
	// Position of PIN3 field.
	GPIO_OUT_XOR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_XOR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_XOR_PIN3 = 0x8
	// Position of PIN4 field.
	GPIO_OUT_XOR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_XOR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_XOR_PIN4 = 0x10
	// Position of PIN5 field.
	GPIO_OUT_XOR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_XOR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_XOR_PIN5 = 0x20
	// Position of PIN6 field.
	GPIO_OUT_XOR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_XOR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_XOR_PIN6 = 0x40
	// Position of PIN7 field.
	GPIO_OUT_XOR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_XOR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_XOR_PIN7 = 0x80
	// Position of PIN8 field.
	GPIO_OUT_XOR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_XOR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_XOR_PIN8 = 0x100
	// Position of PIN9 field.
	GPIO_OUT_XOR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_XOR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_XOR_PIN9 = 0x200
	// Position of PIN10 field.
	GPIO_OUT_XOR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUT_XOR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUT_XOR_PIN10 = 0x400
	// Position of PIN11 field.
	GPIO_OUT_XOR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUT_XOR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUT_XOR_PIN11 = 0x800
	// Position of PIN12 field.
	GPIO_OUT_XOR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUT_XOR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUT_XOR_PIN12 = 0x1000
	// Position of PIN13 field.
	GPIO_OUT_XOR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUT_XOR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUT_XOR_PIN13 = 0x2000
	// Position of PIN14 field.
	GPIO_OUT_XOR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUT_XOR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUT_XOR_PIN14 = 0x4000
	// Position of PIN15 field.
	GPIO_OUT_XOR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUT_XOR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUT_XOR_PIN15 = 0x8000
	// Position of PIN16 field.
	GPIO_OUT_XOR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUT_XOR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUT_XOR_PIN16 = 0x10000
	// Position of PIN17 field.
	GPIO_OUT_XOR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUT_XOR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUT_XOR_PIN17 = 0x20000
	// Position of PIN18 field.
	GPIO_OUT_XOR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUT_XOR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUT_XOR_PIN18 = 0x40000
	// Position of PIN19 field.
	GPIO_OUT_XOR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUT_XOR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUT_XOR_PIN19 = 0x80000
	// Position of PIN20 field.
	GPIO_OUT_XOR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUT_XOR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUT_XOR_PIN20 = 0x100000
	// Position of PIN21 field.
	GPIO_OUT_XOR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUT_XOR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUT_XOR_PIN21 = 0x200000
	// Position of PIN22 field.
	GPIO_OUT_XOR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUT_XOR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUT_XOR_PIN22 = 0x400000
	// Position of PIN23 field.
	GPIO_OUT_XOR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUT_XOR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUT_XOR_PIN23 = 0x800000
	// Position of PIN24 field.
	GPIO_OUT_XOR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUT_XOR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUT_XOR_PIN24 = 0x1000000
	// Position of PIN25 field.
	GPIO_OUT_XOR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUT_XOR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUT_XOR_PIN25 = 0x2000000
	// Position of PIN26 field.
	GPIO_OUT_XOR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUT_XOR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUT_XOR_PIN26 = 0x4000000
	// Position of PIN27 field.
	GPIO_OUT_XOR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUT_XOR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUT_XOR_PIN27 = 0x8000000
	// Position of PIN28 field.
	GPIO_OUT_XOR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUT_XOR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUT_XOR_PIN28 = 0x10000000
	// Position of PIN29 field.
	GPIO_OUT_XOR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUT_XOR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUT_XOR_PIN29 = 0x20000000
	// Position of PIN30 field.
	GPIO_OUT_XOR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUT_XOR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUT_XOR_PIN30 = 0x40000000
	// Position of PIN31 field.
	GPIO_OUT_XOR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUT_XOR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUT_XOR_PIN31 = 0x80000000
)

// Constants for UART0: Universal Asynchronous Receiver Transmitter
const (
	// TXDATA: Transmit Data Register
	// Position of FULL field.
	UART_TXDATA_FULL_Pos = 0x1f
	// Bit mask of FULL field.
	UART_TXDATA_FULL_Msk = 0x80000000
	// Bit FULL.
	UART_TXDATA_FULL = 0x80000000
	// Position of DATA field.
	UART_TXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UART_TXDATA_DATA_Msk = 0xff

	// RXDATA: Receive Data Register
	// Position of EMPTY field.
	UART_RXDATA_EMPTY_Pos = 0x1f
	// Bit mask of EMPTY field.
	UART_RXDATA_EMPTY_Msk = 0x80000000
	// Bit EMPTY.
	UART_RXDATA_EMPTY = 0x80000000
	// Position of DATA field.
	UART_RXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	UART_RXDATA_DATA_Msk = 0xff

	// TXCTRL: Transmit Control Register
	// Position of COUNTER field.
	UART_TXCTRL_COUNTER_Pos = 0x10
	// Bit mask of COUNTER field.
	UART_TXCTRL_COUNTER_Msk = 0x70000
	// Position of NSTOP field.
	UART_TXCTRL_NSTOP_Pos = 0x1
	// Bit mask of NSTOP field.
	UART_TXCTRL_NSTOP_Msk = 0x2
	// Bit NSTOP.
	UART_TXCTRL_NSTOP = 0x2
	// Position of ENABLE field.
	UART_TXCTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UART_TXCTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	UART_TXCTRL_ENABLE = 0x1

	// RXCTRL: Receive Control Register
	// Position of COUNTER field.
	UART_RXCTRL_COUNTER_Pos = 0x10
	// Bit mask of COUNTER field.
	UART_RXCTRL_COUNTER_Msk = 0x70000
	// Position of ENABLE field.
	UART_RXCTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UART_RXCTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	UART_RXCTRL_ENABLE = 0x1

	// IE: Interrupt Enable Register
	// Position of RXWM field.
	UART_IE_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	UART_IE_RXWM_Msk = 0x2
	// Bit RXWM.
	UART_IE_RXWM = 0x2
	// Position of TXWM field.
	UART_IE_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	UART_IE_TXWM_Msk = 0x1
	// Bit TXWM.
	UART_IE_TXWM = 0x1

	// IP: Interrupt Pending Register
	// Position of RXWM field.
	UART_IP_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	UART_IP_RXWM_Msk = 0x2
	// Bit RXWM.
	UART_IP_RXWM = 0x2
	// Position of TXWM field.
	UART_IP_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	UART_IP_TXWM_Msk = 0x1
	// Bit TXWM.
	UART_IP_TXWM = 0x1

	// DIV: Baud Rate Divisor Register
	// Position of VALUE field.
	UART_DIV_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	UART_DIV_VALUE_Msk = 0xffff
)

// Constants for QSPI0: Quad Serial Peripheral Interface
const (
	// DIV: Serial Clock Divisor Register
	// Position of VALUE field.
	QSPI_DIV_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	QSPI_DIV_VALUE_Msk = 0xfff

	// MODE: Serial Clock Mode Register
	// Position of POLARITY field.
	QSPI_MODE_POLARITY_Pos = 0x1
	// Bit mask of POLARITY field.
	QSPI_MODE_POLARITY_Msk = 0x2
	// Bit POLARITY.
	QSPI_MODE_POLARITY = 0x2
	// Position of PHASE field.
	QSPI_MODE_PHASE_Pos = 0x0
	// Bit mask of PHASE field.
	QSPI_MODE_PHASE_Msk = 0x1
	// Bit PHASE.
	QSPI_MODE_PHASE = 0x1

	// DELAY0: Delay Control 0 Register
	// Position of SCKCS field.
	QSPI_DELAY0_SCKCS_Pos = 0x10
	// Bit mask of SCKCS field.
	QSPI_DELAY0_SCKCS_Msk = 0xff0000
	// Position of CSSCK field.
	QSPI_DELAY0_CSSCK_Pos = 0x0
	// Bit mask of CSSCK field.
	QSPI_DELAY0_CSSCK_Msk = 0xff

	// DELAY1: Delay Control 1 Register
	// Position of INTERXFR field.
	QSPI_DELAY1_INTERXFR_Pos = 0x10
	// Bit mask of INTERXFR field.
	QSPI_DELAY1_INTERXFR_Msk = 0xff0000
	// Position of INTERCS field.
	QSPI_DELAY1_INTERCS_Pos = 0x0
	// Bit mask of INTERCS field.
	QSPI_DELAY1_INTERCS_Msk = 0xff

	// FMT: Frame Format Register
	// Position of LENGTH field.
	QSPI_FMT_LENGTH_Pos = 0x10
	// Bit mask of LENGTH field.
	QSPI_FMT_LENGTH_Msk = 0xf0000
	// Position of DIRECTION field.
	QSPI_FMT_DIRECTION_Pos = 0x3
	// Bit mask of DIRECTION field.
	QSPI_FMT_DIRECTION_Msk = 0x8
	// Bit DIRECTION.
	QSPI_FMT_DIRECTION = 0x8
	// For dual and quad protocols, the DQ pins are tri-stated. For the single protocol, the DQ0 pin is driven with the transmit data as normal.
	QSPI_FMT_DIRECTION_Rx = 0x0
	// The receive FIFO is not populated.
	QSPI_FMT_DIRECTION_Tx = 0x1
	// Position of ENDIAN field.
	QSPI_FMT_ENDIAN_Pos = 0x2
	// Bit mask of ENDIAN field.
	QSPI_FMT_ENDIAN_Msk = 0x4
	// Bit ENDIAN.
	QSPI_FMT_ENDIAN = 0x4
	// Transmit MSB first.
	QSPI_FMT_ENDIAN_Big = 0x0
	// Transmit LSB first.
	QSPI_FMT_ENDIAN_Little = 0x1
	// Position of PROTOCOL field.
	QSPI_FMT_PROTOCOL_Pos = 0x0
	// Bit mask of PROTOCOL field.
	QSPI_FMT_PROTOCOL_Msk = 0x3
	// DQ0 (MOSI), DQ1 (MISO)
	QSPI_FMT_PROTOCOL_Single = 0x0
	// DQ0, DQ1
	QSPI_FMT_PROTOCOL_Dual = 0x1
	// DQ0, DQ1, DQ2, DQ3
	QSPI_FMT_PROTOCOL_Quad = 0x2

	// TXDATA: Transmit Data Register
	// Position of FULL field.
	QSPI_TXDATA_FULL_Pos = 0x1f
	// Bit mask of FULL field.
	QSPI_TXDATA_FULL_Msk = 0x80000000
	// Bit FULL.
	QSPI_TXDATA_FULL = 0x80000000
	// Position of DATA field.
	QSPI_TXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QSPI_TXDATA_DATA_Msk = 0xff

	// RXDATA: Receive Data Register
	// Position of EMPTY field.
	QSPI_RXDATA_EMPTY_Pos = 0x1f
	// Bit mask of EMPTY field.
	QSPI_RXDATA_EMPTY_Msk = 0x80000000
	// Bit EMPTY.
	QSPI_RXDATA_EMPTY = 0x80000000
	// Position of DATA field.
	QSPI_RXDATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QSPI_RXDATA_DATA_Msk = 0xff

	// TXMARK: Transmit Watermark Register
	// Position of VALUE field.
	QSPI_TXMARK_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	QSPI_TXMARK_VALUE_Msk = 0x7

	// RXMARK: Receive Watermark Register
	// Position of VALUE field.
	QSPI_RXMARK_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	QSPI_RXMARK_VALUE_Msk = 0x7

	// FCTRL: SPI Flash Interface Control Register
	// Position of ENABLE field.
	QSPI_FCTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	QSPI_FCTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	QSPI_FCTRL_ENABLE = 0x1

	// FFMT: SPI Flash Instruction Format Register
	// Position of PAD_CODE field.
	QSPI_FFMT_PAD_CODE_Pos = 0x18
	// Bit mask of PAD_CODE field.
	QSPI_FFMT_PAD_CODE_Msk = 0xff000000
	// Position of CMD_CODE field.
	QSPI_FFMT_CMD_CODE_Pos = 0x10
	// Bit mask of CMD_CODE field.
	QSPI_FFMT_CMD_CODE_Msk = 0xff0000
	// Position of DATA_PROTO field.
	QSPI_FFMT_DATA_PROTO_Pos = 0xc
	// Bit mask of DATA_PROTO field.
	QSPI_FFMT_DATA_PROTO_Msk = 0x3000
	// DQ0 (MOSI), DQ1 (MISO)
	QSPI_FFMT_DATA_PROTO_Single = 0x0
	// DQ0, DQ1
	QSPI_FFMT_DATA_PROTO_Dual = 0x1
	// DQ0, DQ1, DQ2, DQ3
	QSPI_FFMT_DATA_PROTO_Quad = 0x2
	// Position of ADDR_PROTO field.
	QSPI_FFMT_ADDR_PROTO_Pos = 0xa
	// Bit mask of ADDR_PROTO field.
	QSPI_FFMT_ADDR_PROTO_Msk = 0xc00
	// DQ0 (MOSI), DQ1 (MISO)
	QSPI_FFMT_ADDR_PROTO_Single = 0x0
	// DQ0, DQ1
	QSPI_FFMT_ADDR_PROTO_Dual = 0x1
	// DQ0, DQ1, DQ2, DQ3
	QSPI_FFMT_ADDR_PROTO_Quad = 0x2
	// Position of CMD_PROTO field.
	QSPI_FFMT_CMD_PROTO_Pos = 0x8
	// Bit mask of CMD_PROTO field.
	QSPI_FFMT_CMD_PROTO_Msk = 0x300
	// DQ0 (MOSI), DQ1 (MISO)
	QSPI_FFMT_CMD_PROTO_Single = 0x0
	// DQ0, DQ1
	QSPI_FFMT_CMD_PROTO_Dual = 0x1
	// DQ0, DQ1, DQ2, DQ3
	QSPI_FFMT_CMD_PROTO_Quad = 0x2
	// Position of PAD_CNT field.
	QSPI_FFMT_PAD_CNT_Pos = 0x0
	// Bit mask of PAD_CNT field.
	QSPI_FFMT_PAD_CNT_Msk = 0x1
	// Bit PAD_CNT.
	QSPI_FFMT_PAD_CNT = 0x1
	// Position of ADDR_LEN field.
	QSPI_FFMT_ADDR_LEN_Pos = 0x1
	// Bit mask of ADDR_LEN field.
	QSPI_FFMT_ADDR_LEN_Msk = 0xe
	// Position of CMD_EN field.
	QSPI_FFMT_CMD_EN_Pos = 0x0
	// Bit mask of CMD_EN field.
	QSPI_FFMT_CMD_EN_Msk = 0x1
	// Bit CMD_EN.
	QSPI_FFMT_CMD_EN = 0x1

	// IE: SPI Interrupt Enable Register
	// Position of RXWM field.
	QSPI_IE_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	QSPI_IE_RXWM_Msk = 0x2
	// Bit RXWM.
	QSPI_IE_RXWM = 0x2
	// Position of TXWM field.
	QSPI_IE_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	QSPI_IE_TXWM_Msk = 0x1
	// Bit TXWM.
	QSPI_IE_TXWM = 0x1

	// IP: SPI Interrupt Pending Register
	// Position of RXWM field.
	QSPI_IP_RXWM_Pos = 0x1
	// Bit mask of RXWM field.
	QSPI_IP_RXWM_Msk = 0x2
	// Bit RXWM.
	QSPI_IP_RXWM = 0x2
	// Position of TXWM field.
	QSPI_IP_TXWM_Pos = 0x0
	// Bit mask of TXWM field.
	QSPI_IP_TXWM_Msk = 0x1
	// Bit TXWM.
	QSPI_IP_TXWM = 0x1
)

// Constants for PWM0: 8-bit timer with 4 cmp
const (
	// CFG: PWM Configuration Register
	// Position of CMP3IP field.
	PWM_CFG_CMP3IP_Pos = 0x1f
	// Bit mask of CMP3IP field.
	PWM_CFG_CMP3IP_Msk = 0x80000000
	// Bit CMP3IP.
	PWM_CFG_CMP3IP = 0x80000000
	// Position of CMP2IP field.
	PWM_CFG_CMP2IP_Pos = 0x1e
	// Bit mask of CMP2IP field.
	PWM_CFG_CMP2IP_Msk = 0x40000000
	// Bit CMP2IP.
	PWM_CFG_CMP2IP = 0x40000000
	// Position of CMP1IP field.
	PWM_CFG_CMP1IP_Pos = 0x1d
	// Bit mask of CMP1IP field.
	PWM_CFG_CMP1IP_Msk = 0x20000000
	// Bit CMP1IP.
	PWM_CFG_CMP1IP = 0x20000000
	// Position of CMP0IP field.
	PWM_CFG_CMP0IP_Pos = 0x1c
	// Bit mask of CMP0IP field.
	PWM_CFG_CMP0IP_Msk = 0x10000000
	// Bit CMP0IP.
	PWM_CFG_CMP0IP = 0x10000000
	// Position of CMP3GANG field.
	PWM_CFG_CMP3GANG_Pos = 0x1b
	// Bit mask of CMP3GANG field.
	PWM_CFG_CMP3GANG_Msk = 0x8000000
	// Bit CMP3GANG.
	PWM_CFG_CMP3GANG = 0x8000000
	// Position of CMP2GANG field.
	PWM_CFG_CMP2GANG_Pos = 0x1a
	// Bit mask of CMP2GANG field.
	PWM_CFG_CMP2GANG_Msk = 0x1ffc000000
	// Position of CMP1GANG field.
	PWM_CFG_CMP1GANG_Pos = 0x19
	// Bit mask of CMP1GANG field.
	PWM_CFG_CMP1GANG_Msk = 0x2000000
	// Bit CMP1GANG.
	PWM_CFG_CMP1GANG = 0x2000000
	// Position of CMP0GANG field.
	PWM_CFG_CMP0GANG_Pos = 0x18
	// Bit mask of CMP0GANG field.
	PWM_CFG_CMP0GANG_Msk = 0x1000000
	// Bit CMP0GANG.
	PWM_CFG_CMP0GANG = 0x1000000
	// Position of CMP3CENTER field.
	PWM_CFG_CMP3CENTER_Pos = 0x13
	// Bit mask of CMP3CENTER field.
	PWM_CFG_CMP3CENTER_Msk = 0x80000
	// Bit CMP3CENTER.
	PWM_CFG_CMP3CENTER = 0x80000
	// Position of CMP2CENTER field.
	PWM_CFG_CMP2CENTER_Pos = 0x12
	// Bit mask of CMP2CENTER field.
	PWM_CFG_CMP2CENTER_Msk = 0x40000
	// Bit CMP2CENTER.
	PWM_CFG_CMP2CENTER = 0x40000
	// Position of CMP1CENTER field.
	PWM_CFG_CMP1CENTER_Pos = 0x11
	// Bit mask of CMP1CENTER field.
	PWM_CFG_CMP1CENTER_Msk = 0x20000
	// Bit CMP1CENTER.
	PWM_CFG_CMP1CENTER = 0x20000
	// Position of CMP0CENTER field.
	PWM_CFG_CMP0CENTER_Pos = 0x10
	// Bit mask of CMP0CENTER field.
	PWM_CFG_CMP0CENTER_Msk = 0x10000
	// Bit CMP0CENTER.
	PWM_CFG_CMP0CENTER = 0x10000
	// Position of ENONESHOT field.
	PWM_CFG_ENONESHOT_Pos = 0xd
	// Bit mask of ENONESHOT field.
	PWM_CFG_ENONESHOT_Msk = 0x2000
	// Bit ENONESHOT.
	PWM_CFG_ENONESHOT = 0x2000
	// Position of ENALWAYS field.
	PWM_CFG_ENALWAYS_Pos = 0xc
	// Bit mask of ENALWAYS field.
	PWM_CFG_ENALWAYS_Msk = 0x1000
	// Bit ENALWAYS.
	PWM_CFG_ENALWAYS = 0x1000
	// Position of DEGLITCH field.
	PWM_CFG_DEGLITCH_Pos = 0xa
	// Bit mask of DEGLITCH field.
	PWM_CFG_DEGLITCH_Msk = 0x400
	// Bit DEGLITCH.
	PWM_CFG_DEGLITCH = 0x400
	// Position of ZEROCMP field.
	PWM_CFG_ZEROCMP_Pos = 0x9
	// Bit mask of ZEROCMP field.
	PWM_CFG_ZEROCMP_Msk = 0x200
	// Bit ZEROCMP.
	PWM_CFG_ZEROCMP = 0x200
	// Position of STICKY field.
	PWM_CFG_STICKY_Pos = 0x8
	// Bit mask of STICKY field.
	PWM_CFG_STICKY_Msk = 0x100
	// Bit STICKY.
	PWM_CFG_STICKY = 0x100
	// Position of SCALE field.
	PWM_CFG_SCALE_Pos = 0x0
	// Bit mask of SCALE field.
	PWM_CFG_SCALE_Msk = 0xf

	// CMP0: Compare Register
	// Position of VALUE field.
	PWM_CMP0_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	PWM_CMP0_VALUE_Msk = 0xffff

	// CMP1: Compare Register
	// Position of VALUE field.
	PWM_CMP1_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	PWM_CMP1_VALUE_Msk = 0xffff

	// CMP2: Compare Register
	// Position of VALUE field.
	PWM_CMP2_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	PWM_CMP2_VALUE_Msk = 0xffff

	// CMP3: Compare Register
	// Position of VALUE field.
	PWM_CMP3_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	PWM_CMP3_VALUE_Msk = 0xffff
)

// Constants for I2C0: Inter-Integrated Circuit Master Interface (FE310-G002 only)
const (
	// PRER_LO: Clock Prescale register lo-byte
	// Position of VALUE field.
	I2C_PRER_LO_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_PRER_LO_VALUE_Msk = 0xff

	// PRER_HI: Clock Prescale register hi-byte
	// Position of VALUE field.
	I2C_PRER_HI_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	I2C_PRER_HI_VALUE_Msk = 0xff

	// CTR: Control register
	// Position of EN field.
	I2C_CTR_EN_Pos = 0x7
	// Bit mask of EN field.
	I2C_CTR_EN_Msk = 0x80
	// Bit EN.
	I2C_CTR_EN = 0x80
	// Position of IEN field.
	I2C_CTR_IEN_Pos = 0x6
	// Bit mask of IEN field.
	I2C_CTR_IEN_Msk = 0x40
	// Bit IEN.
	I2C_CTR_IEN = 0x40

	// TXR_RXR: Transmit register / Receive register
	// Position of DATA field.
	I2C_TXR_RXR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C_TXR_RXR_DATA_Msk = 0xff

	// CR: Command register
	// Position of STA field.
	I2C_CR_STA_Pos = 0x7
	// Bit mask of STA field.
	I2C_CR_STA_Msk = 0x80
	// Bit STA.
	I2C_CR_STA = 0x80
	// Position of STO field.
	I2C_CR_STO_Pos = 0x6
	// Bit mask of STO field.
	I2C_CR_STO_Msk = 0x40
	// Bit STO.
	I2C_CR_STO = 0x40
	// Position of RD field.
	I2C_CR_RD_Pos = 0x5
	// Bit mask of RD field.
	I2C_CR_RD_Msk = 0x20
	// Bit RD.
	I2C_CR_RD = 0x20
	// Position of WR field.
	I2C_CR_WR_Pos = 0x4
	// Bit mask of WR field.
	I2C_CR_WR_Msk = 0x10
	// Bit WR.
	I2C_CR_WR = 0x10
	// Position of ACK field.
	I2C_CR_ACK_Pos = 0x3
	// Bit mask of ACK field.
	I2C_CR_ACK_Msk = 0x8
	// Bit ACK.
	I2C_CR_ACK      = 0x8
	I2C_CR_ACK_ACK  = 0x0
	I2C_CR_ACK_NACK = 0x1
	// Position of IACK field.
	I2C_CR_IACK_Pos = 0x0
	// Bit mask of IACK field.
	I2C_CR_IACK_Msk = 0x1
	// Bit IACK.
	I2C_CR_IACK = 0x1

	// SR: Status register
	// Position of RX_ACK field.
	I2C_SR_RX_ACK_Pos = 0x7
	// Bit mask of RX_ACK field.
	I2C_SR_RX_ACK_Msk = 0x80
	// Bit RX_ACK.
	I2C_SR_RX_ACK = 0x80
	// Position of BUSY field.
	I2C_SR_BUSY_Pos = 0x6
	// Bit mask of BUSY field.
	I2C_SR_BUSY_Msk = 0x40
	// Bit BUSY.
	I2C_SR_BUSY = 0x40
	// Position of AL field.
	I2C_SR_AL_Pos = 0x5
	// Bit mask of AL field.
	I2C_SR_AL_Msk = 0x20
	// Bit AL.
	I2C_SR_AL = 0x20
	// Position of TIP field.
	I2C_SR_TIP_Pos = 0x1
	// Bit mask of TIP field.
	I2C_SR_TIP_Msk = 0x2
	// Bit TIP.
	I2C_SR_TIP = 0x2
	// Position of IF field.
	I2C_SR_IF_Pos = 0x0
	// Bit mask of IF field.
	I2C_SR_IF_Msk = 0x1
	// Bit IF.
	I2C_SR_IF = 0x1
)
