// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32l4x6.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32l4x6
// +build stm32,stm32l4x6

// STM32L4x6
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32L4x6"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD_PVM = 1

	// Real-time clock
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// Direct memory access controller
	IRQ_DMA1_CH1 = 11

	// Direct memory access controller
	IRQ_DMA1_CH2 = 12

	// Direct memory access controller
	IRQ_DMA1_CH3 = 13

	// Direct memory access controller
	IRQ_DMA1_CH4 = 14

	// Direct memory access controller
	IRQ_DMA1_CH5 = 15

	// Direct memory access controller
	IRQ_DMA1_CH6 = 16

	// Direct memory access controller
	IRQ_DMA1_CH7 = 17

	// Analog-to-Digital Converter //
	IRQ_ADC1_2 = 18

	// Controller area network
	IRQ_CAN1_TX = 19

	// Controller area network
	IRQ_CAN1_RX0 = 20

	// Controller area network
	IRQ_CAN1_RX1 = 21

	// Controller area network
	IRQ_CAN1_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK_TIM15 = 24

	// Advanced-timers
	IRQ_TIM1_UP_TIM16 = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM_TIM17 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General-purpose-timers
	IRQ_TIM2 = 28

	// General-purpose-timers
	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT3 = 42

	// Advanced-timers
	IRQ_TIM8_BRK = 43

	// Advanced-timers
	IRQ_TIM8_UP = 44

	// Advanced-timers
	IRQ_TIM8_TRG_COM = 45

	// Advanced-timers
	IRQ_TIM8_CC = 46

	// Analog-to-Digital Converter //
	IRQ_ADC3 = 47

	// Flexible memory controller
	IRQ_FMC = 48

	// Secure digital input/output interface
	IRQ_SDMMC1 = 49

	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic-timers
	IRQ_TIM6_DACUNDER = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_CH1 = 56

	IRQ_DMA2_CH2 = 57

	IRQ_DMA2_CH3 = 58

	IRQ_DMA2_CH4 = 59

	IRQ_DMA2_CH5 = 60

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT0 = 61

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1 = 62

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2 = 63

	// Comparator
	IRQ_COMP = 64

	// Low power timer
	IRQ_LPTIM1 = 65

	IRQ_LPTIM2 = 66

	// USB on the go full speed
	IRQ_OTG_FS = 67

	IRQ_DMA2_CH6 = 68

	IRQ_DMA2_CH7 = 69

	// Universal synchronous asynchronous receiver transmitter
	IRQ_LPUART1 = 70

	// QuadSPI interface
	IRQ_QUADSPI = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	// Serial audio interface
	IRQ_SAI1 = 74

	IRQ_SAI2 = 75

	// Single Wire Protocol Master Interface
	IRQ_SWPMI1 = 76

	// Touch sensing controller
	IRQ_TSC = 77

	// Liquid crystal display controller
	IRQ_LCD = 78

	// Advanced encryption standard hardware accelerator
	IRQ_AES = 79

	// Random number generator
	IRQ_RNG_HASH = 80

	// Flexible memory controller // Floting point unit
	IRQ_FPU = 81

	// Clock recovery system
	IRQ_CRS = 82

	IRQ_I2C4_EV = 83

	IRQ_I2C4_ER = 84

	// Digital camera interface
	IRQ_DCMI = 85

	IRQ_CAN2_TX = 86

	IRQ_CAN2_RX0 = 87

	IRQ_CAN2_RX1 = 88

	IRQ_CAN2_SCE = 89

	// DMA2D controller
	IRQ_DMA2D = 90

	// Highest interrupt number on this device.
	IRQ_max = 90
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_PVM_IRQHandler
func interruptPVD_PVM() {
	callHandlers(IRQ_PVD_PVM)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_CH1_IRQHandler
func interruptDMA1_CH1() {
	callHandlers(IRQ_DMA1_CH1)
}

//export DMA1_CH2_IRQHandler
func interruptDMA1_CH2() {
	callHandlers(IRQ_DMA1_CH2)
}

//export DMA1_CH3_IRQHandler
func interruptDMA1_CH3() {
	callHandlers(IRQ_DMA1_CH3)
}

//export DMA1_CH4_IRQHandler
func interruptDMA1_CH4() {
	callHandlers(IRQ_DMA1_CH4)
}

//export DMA1_CH5_IRQHandler
func interruptDMA1_CH5() {
	callHandlers(IRQ_DMA1_CH5)
}

//export DMA1_CH6_IRQHandler
func interruptDMA1_CH6() {
	callHandlers(IRQ_DMA1_CH6)
}

//export DMA1_CH7_IRQHandler
func interruptDMA1_CH7() {
	callHandlers(IRQ_DMA1_CH7)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export CAN1_TX_IRQHandler
func interruptCAN1_TX() {
	callHandlers(IRQ_CAN1_TX)
}

//export CAN1_RX0_IRQHandler
func interruptCAN1_RX0() {
	callHandlers(IRQ_CAN1_RX0)
}

//export CAN1_RX1_IRQHandler
func interruptCAN1_RX1() {
	callHandlers(IRQ_CAN1_RX1)
}

//export CAN1_SCE_IRQHandler
func interruptCAN1_SCE() {
	callHandlers(IRQ_CAN1_SCE)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM15_IRQHandler
func interruptTIM1_BRK_TIM15() {
	callHandlers(IRQ_TIM1_BRK_TIM15)
}

//export TIM1_UP_TIM16_IRQHandler
func interruptTIM1_UP_TIM16() {
	callHandlers(IRQ_TIM1_UP_TIM16)
}

//export TIM1_TRG_COM_TIM17_IRQHandler
func interruptTIM1_TRG_COM_TIM17() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM17)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export DFSDM1_FLT3_IRQHandler
func interruptDFSDM1_FLT3() {
	callHandlers(IRQ_DFSDM1_FLT3)
}

//export TIM8_BRK_IRQHandler
func interruptTIM8_BRK() {
	callHandlers(IRQ_TIM8_BRK)
}

//export TIM8_UP_IRQHandler
func interruptTIM8_UP() {
	callHandlers(IRQ_TIM8_UP)
}

//export TIM8_TRG_COM_IRQHandler
func interruptTIM8_TRG_COM() {
	callHandlers(IRQ_TIM8_TRG_COM)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export ADC3_IRQHandler
func interruptADC3() {
	callHandlers(IRQ_ADC3)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export SDMMC1_IRQHandler
func interruptSDMMC1() {
	callHandlers(IRQ_SDMMC1)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DACUNDER_IRQHandler
func interruptTIM6_DACUNDER() {
	callHandlers(IRQ_TIM6_DACUNDER)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export DFSDM1_FLT0_IRQHandler
func interruptDFSDM1_FLT0() {
	callHandlers(IRQ_DFSDM1_FLT0)
}

//export DFSDM1_FLT1_IRQHandler
func interruptDFSDM1_FLT1() {
	callHandlers(IRQ_DFSDM1_FLT1)
}

//export DFSDM1_FLT2_IRQHandler
func interruptDFSDM1_FLT2() {
	callHandlers(IRQ_DFSDM1_FLT2)
}

//export COMP_IRQHandler
func interruptCOMP() {
	callHandlers(IRQ_COMP)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMA2_CH6_IRQHandler
func interruptDMA2_CH6() {
	callHandlers(IRQ_DMA2_CH6)
}

//export DMA2_CH7_IRQHandler
func interruptDMA2_CH7() {
	callHandlers(IRQ_DMA2_CH7)
}

//export LPUART1_IRQHandler
func interruptLPUART1() {
	callHandlers(IRQ_LPUART1)
}

//export QUADSPI_IRQHandler
func interruptQUADSPI() {
	callHandlers(IRQ_QUADSPI)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export SAI2_IRQHandler
func interruptSAI2() {
	callHandlers(IRQ_SAI2)
}

//export SWPMI1_IRQHandler
func interruptSWPMI1() {
	callHandlers(IRQ_SWPMI1)
}

//export TSC_IRQHandler
func interruptTSC() {
	callHandlers(IRQ_TSC)
}

//export LCD_IRQHandler
func interruptLCD() {
	callHandlers(IRQ_LCD)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export RNG_HASH_IRQHandler
func interruptRNG_HASH() {
	callHandlers(IRQ_RNG_HASH)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export CRS_IRQHandler
func interruptCRS() {
	callHandlers(IRQ_CRS)
}

//export I2C4_EV_IRQHandler
func interruptI2C4_EV() {
	callHandlers(IRQ_I2C4_EV)
}

//export I2C4_ER_IRQHandler
func interruptI2C4_ER() {
	callHandlers(IRQ_I2C4_ER)
}

//export DCMI_IRQHandler
func interruptDCMI() {
	callHandlers(IRQ_DCMI)
}

//export CAN2_TX_IRQHandler
func interruptCAN2_TX() {
	callHandlers(IRQ_CAN2_TX)
}

//export CAN2_RX0_IRQHandler
func interruptCAN2_RX0() {
	callHandlers(IRQ_CAN2_RX0)
}

//export CAN2_RX1_IRQHandler
func interruptCAN2_RX1() {
	callHandlers(IRQ_CAN2_RX1)
}

//export CAN2_SCE_IRQHandler
func interruptCAN2_SCE() {
	callHandlers(IRQ_CAN2_SCE)
}

//export DMA2D_IRQHandler
func interruptDMA2D() {
	callHandlers(IRQ_DMA2D)
}

// Peripherals.
var (
	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Liquid crystal display controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Firewall
	FIREWALL = (*Firewall_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Digital filter for sigma delta modulators
	DFSDM1 = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// Advanced encryption standard hardware accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Analog-to-Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040000)))

	// Analog-to-Digital Converter
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040300)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// General-purpose I/Os
	GPIOI = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48002000)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Basic-timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Secure digital input/output interface
	SDMMC1 = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Voltage reference buffer
	VREFBUF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// Single Wire Protocol Master Interface
	SWPMI1 = (*SWPMI_Type)(unsafe.Pointer(uintptr(0x40008800)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Flexible memory controller
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Clock recovery system
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))

	// Hash processor
	HASH = (*HASH_Type)(unsafe.Pointer(uintptr(0x50060400)))

	// DMA2D controller
	DMA2D = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x4002b000)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40008400)))

	// Analog-to-Digital Converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040100)))

	// Analog-to-Digital Converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040200)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// General-purpose-timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Basic-timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Controller area network
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))
)

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	SHSR2   volatile.Register32 // 0x44
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_CEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetCR_CEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_CEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetCR_CEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left-aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetSR_CAL_FLAG1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetSR_CAL_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetSR_BWST1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *DAC_Type) GetSR_BWST1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_CAL_FLAG2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetSR_CAL_FLAG2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DAC_Type) SetSR_BWST2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DAC_Type) GetSR_BWST2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DAC.CCR: calibration control register
func (o *DAC_Type) SetCCR_OTRIM1(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f)|value)
}
func (o *DAC_Type) GetCCR_OTRIM1() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1f
}
func (o *DAC_Type) SetCCR_OTRIM2(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DAC_Type) GetCCR_OTRIM2() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1f0000) >> 16
}

// DAC.MCR: mode control register
func (o *DAC_Type) SetMCR_MODE1(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x7)|value)
}
func (o *DAC_Type) GetMCR_MODE1() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x7
}
func (o *DAC_Type) SetMCR_MODE2(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x70000)|value<<16)
}
func (o *DAC_Type) GetMCR_MODE2() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x70000) >> 16
}

// DAC.SHSR1: Sample and Hold sample time register 1
func (o *DAC_Type) SetSHSR1_TSAMPLE1(value uint32) {
	volatile.StoreUint32(&o.SHSR1.Reg, volatile.LoadUint32(&o.SHSR1.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR1_TSAMPLE1() uint32 {
	return volatile.LoadUint32(&o.SHSR1.Reg) & 0x3ff
}

// DAC.SHSR2: Sample and Hold sample time register 2
func (o *DAC_Type) SetSHSR2_TSAMPLE2(value uint32) {
	volatile.StoreUint32(&o.SHSR2.Reg, volatile.LoadUint32(&o.SHSR2.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR2_TSAMPLE2() uint32 {
	return volatile.LoadUint32(&o.SHSR2.Reg) & 0x3ff
}

// DAC.SHHR: Sample and Hold hold time register
func (o *DAC_Type) SetSHHR_THOLD1(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHHR_THOLD1() uint32 {
	return volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff
}
func (o *DAC_Type) SetSHHR_THOLD2(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DAC_Type) GetSHHR_THOLD2() uint32 {
	return (volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff0000) >> 16
}

// DAC.SHRR: Sample and Hold refresh time register
func (o *DAC_Type) SetSHRR_TREFRESH1(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetSHRR_TREFRESH1() uint32 {
	return volatile.LoadUint32(&o.SHRR.Reg) & 0xff
}
func (o *DAC_Type) SetSHRR_TREFRESH2(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff0000)|value<<16)
}
func (o *DAC_Type) GetSHRR_TREFRESH2() uint32 {
	return (volatile.LoadUint32(&o.SHRR.Reg) & 0xff0000) >> 16
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
	_      [24]byte
	CSELR  volatile.Register32 // 0xA8
}

// DMA.ISR: interrupt status register
func (o *DMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA.IFCR: interrupt flag clear register
func (o *DMA_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA.CCR1: channel x configuration register
func (o *DMA_Type) SetCCR1_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR1_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR1_PL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR1_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR1_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR1_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR1_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR1_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR1_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR1_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR1_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR1_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR1_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR1_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR1_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR1_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR1_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR1_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR1_EN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR1_EN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}

// DMA.CNDTR1: channel x number of data register
func (o *DMA_Type) SetCNDTR1_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR1.Reg, volatile.LoadUint32(&o.CNDTR1.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR1_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR1.Reg) & 0xffff
}

// DMA.CPAR1: channel x peripheral address register
func (o *DMA_Type) SetCPAR1(value uint32) {
	volatile.StoreUint32(&o.CPAR1.Reg, value)
}
func (o *DMA_Type) GetCPAR1() uint32 {
	return volatile.LoadUint32(&o.CPAR1.Reg)
}

// DMA.CMAR1: channel x memory address register
func (o *DMA_Type) SetCMAR1(value uint32) {
	volatile.StoreUint32(&o.CMAR1.Reg, value)
}
func (o *DMA_Type) GetCMAR1() uint32 {
	return volatile.LoadUint32(&o.CMAR1.Reg)
}

// DMA.CCR2: channel x configuration register
func (o *DMA_Type) SetCCR2_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR2_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR2_PL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR2_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR2_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR2_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR2_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR2_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR2_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR2_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR2_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR2_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR2_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR2_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR2_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR2_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR2_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR2_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR2_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR2_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR2_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR2_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR2_EN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR2_EN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}

// DMA.CNDTR2: channel x number of data register
func (o *DMA_Type) SetCNDTR2_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR2.Reg, volatile.LoadUint32(&o.CNDTR2.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR2_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR2.Reg) & 0xffff
}

// DMA.CPAR2: channel x peripheral address register
func (o *DMA_Type) SetCPAR2(value uint32) {
	volatile.StoreUint32(&o.CPAR2.Reg, value)
}
func (o *DMA_Type) GetCPAR2() uint32 {
	return volatile.LoadUint32(&o.CPAR2.Reg)
}

// DMA.CMAR2: channel x memory address register
func (o *DMA_Type) SetCMAR2(value uint32) {
	volatile.StoreUint32(&o.CMAR2.Reg, value)
}
func (o *DMA_Type) GetCMAR2() uint32 {
	return volatile.LoadUint32(&o.CMAR2.Reg)
}

// DMA.CCR3: channel x configuration register
func (o *DMA_Type) SetCCR3_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR3_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR3_PL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR3_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR3_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR3_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR3_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR3_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR3_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR3_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR3_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR3_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR3_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR3_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR3_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR3_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR3_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR3_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR3_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR3_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR3_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR3_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR3_EN(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR3_EN() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0x1
}

// DMA.CNDTR3: channel x number of data register
func (o *DMA_Type) SetCNDTR3_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR3.Reg, volatile.LoadUint32(&o.CNDTR3.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR3_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR3.Reg) & 0xffff
}

// DMA.CPAR3: channel x peripheral address register
func (o *DMA_Type) SetCPAR3(value uint32) {
	volatile.StoreUint32(&o.CPAR3.Reg, value)
}
func (o *DMA_Type) GetCPAR3() uint32 {
	return volatile.LoadUint32(&o.CPAR3.Reg)
}

// DMA.CMAR3: channel x memory address register
func (o *DMA_Type) SetCMAR3(value uint32) {
	volatile.StoreUint32(&o.CMAR3.Reg, value)
}
func (o *DMA_Type) GetCMAR3() uint32 {
	return volatile.LoadUint32(&o.CMAR3.Reg)
}

// DMA.CCR4: channel x configuration register
func (o *DMA_Type) SetCCR4_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR4_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR4_PL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR4_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR4_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR4_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR4_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR4_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR4_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR4_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR4_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR4_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR4_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR4_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR4_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR4_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR4_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR4_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR4_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR4_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR4_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR4_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR4_EN(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR4_EN() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0x1
}

// DMA.CNDTR4: channel x number of data register
func (o *DMA_Type) SetCNDTR4_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR4.Reg, volatile.LoadUint32(&o.CNDTR4.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR4_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR4.Reg) & 0xffff
}

// DMA.CPAR4: channel x peripheral address register
func (o *DMA_Type) SetCPAR4(value uint32) {
	volatile.StoreUint32(&o.CPAR4.Reg, value)
}
func (o *DMA_Type) GetCPAR4() uint32 {
	return volatile.LoadUint32(&o.CPAR4.Reg)
}

// DMA.CMAR4: channel x memory address register
func (o *DMA_Type) SetCMAR4(value uint32) {
	volatile.StoreUint32(&o.CMAR4.Reg, value)
}
func (o *DMA_Type) GetCMAR4() uint32 {
	return volatile.LoadUint32(&o.CMAR4.Reg)
}

// DMA.CCR5: channel x configuration register
func (o *DMA_Type) SetCCR5_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR5_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR5_PL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR5_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR5_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR5_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR5_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR5_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR5_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR5_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR5_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR5_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR5_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR5_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR5_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR5_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR5_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR5_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR5_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR5_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR5_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR5_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR5_EN(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR5_EN() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0x1
}

// DMA.CNDTR5: channel x number of data register
func (o *DMA_Type) SetCNDTR5_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR5.Reg, volatile.LoadUint32(&o.CNDTR5.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR5_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR5.Reg) & 0xffff
}

// DMA.CPAR5: channel x peripheral address register
func (o *DMA_Type) SetCPAR5(value uint32) {
	volatile.StoreUint32(&o.CPAR5.Reg, value)
}
func (o *DMA_Type) GetCPAR5() uint32 {
	return volatile.LoadUint32(&o.CPAR5.Reg)
}

// DMA.CMAR5: channel x memory address register
func (o *DMA_Type) SetCMAR5(value uint32) {
	volatile.StoreUint32(&o.CMAR5.Reg, value)
}
func (o *DMA_Type) GetCMAR5() uint32 {
	return volatile.LoadUint32(&o.CMAR5.Reg)
}

// DMA.CCR6: channel x configuration register
func (o *DMA_Type) SetCCR6_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR6_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR6_PL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR6_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR6_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR6_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR6_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR6_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR6_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR6_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR6_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR6_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR6_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR6_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR6_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR6_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR6_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR6_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR6_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR6_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR6_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR6_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR6_EN(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR6_EN() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0x1
}

// DMA.CNDTR6: channel x number of data register
func (o *DMA_Type) SetCNDTR6_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR6.Reg, volatile.LoadUint32(&o.CNDTR6.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR6_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR6.Reg) & 0xffff
}

// DMA.CPAR6: channel x peripheral address register
func (o *DMA_Type) SetCPAR6(value uint32) {
	volatile.StoreUint32(&o.CPAR6.Reg, value)
}
func (o *DMA_Type) GetCPAR6() uint32 {
	return volatile.LoadUint32(&o.CPAR6.Reg)
}

// DMA.CMAR6: channel x memory address register
func (o *DMA_Type) SetCMAR6(value uint32) {
	volatile.StoreUint32(&o.CMAR6.Reg, value)
}
func (o *DMA_Type) GetCMAR6() uint32 {
	return volatile.LoadUint32(&o.CMAR6.Reg)
}

// DMA.CCR7: channel x configuration register
func (o *DMA_Type) SetCCR7_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR7_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR7_PL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR7_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR7_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR7_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR7_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR7_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR7_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR7_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR7_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR7_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR7_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR7_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR7_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR7_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR7_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR7_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR7_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR7_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR7_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR7_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR7_EN(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR7_EN() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0x1
}

// DMA.CNDTR7: channel x number of data register
func (o *DMA_Type) SetCNDTR7_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR7.Reg, volatile.LoadUint32(&o.CNDTR7.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR7_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR7.Reg) & 0xffff
}

// DMA.CPAR7: channel x peripheral address register
func (o *DMA_Type) SetCPAR7(value uint32) {
	volatile.StoreUint32(&o.CPAR7.Reg, value)
}
func (o *DMA_Type) GetCPAR7() uint32 {
	return volatile.LoadUint32(&o.CPAR7.Reg)
}

// DMA.CMAR7: channel x memory address register
func (o *DMA_Type) SetCMAR7(value uint32) {
	volatile.StoreUint32(&o.CMAR7.Reg, value)
}
func (o *DMA_Type) GetCMAR7() uint32 {
	return volatile.LoadUint32(&o.CMAR7.Reg)
}

// DMA.CSELR: channel selection register
func (o *DMA_Type) SetCSELR_C7S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf000000)|value<<24)
}
func (o *DMA_Type) GetCSELR_C7S() uint32 {
	return (volatile.LoadUint32(&o.CSELR.Reg) & 0xf000000) >> 24
}
func (o *DMA_Type) SetCSELR_C6S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf00000)|value<<20)
}
func (o *DMA_Type) GetCSELR_C6S() uint32 {
	return (volatile.LoadUint32(&o.CSELR.Reg) & 0xf00000) >> 20
}
func (o *DMA_Type) SetCSELR_C5S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf0000)|value<<16)
}
func (o *DMA_Type) GetCSELR_C5S() uint32 {
	return (volatile.LoadUint32(&o.CSELR.Reg) & 0xf0000) >> 16
}
func (o *DMA_Type) SetCSELR_C4S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf000)|value<<12)
}
func (o *DMA_Type) GetCSELR_C4S() uint32 {
	return (volatile.LoadUint32(&o.CSELR.Reg) & 0xf000) >> 12
}
func (o *DMA_Type) SetCSELR_C3S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetCSELR_C3S() uint32 {
	return (volatile.LoadUint32(&o.CSELR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetCSELR_C2S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf0)|value<<4)
}
func (o *DMA_Type) GetCSELR_C2S() uint32 {
	return (volatile.LoadUint32(&o.CSELR.Reg) & 0xf0) >> 4
}
func (o *DMA_Type) SetCSELR_C1S(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCSELR_C1S() uint32 {
	return volatile.LoadUint32(&o.CSELR.Reg) & 0xf
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Liquid crystal display controller
type LCD_Type struct {
	CR       volatile.Register32 // 0x0
	FCR      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	CLR      volatile.Register32 // 0xC
	_        [4]byte
	RAM_COM0 volatile.Register64 // 0x14
	RAM_COM1 volatile.Register64 // 0x1C
	RAM_COM2 volatile.Register64 // 0x24
	RAM_COM3 volatile.Register64 // 0x2C
	RAM_COM4 volatile.Register64 // 0x34
	RAM_COM5 volatile.Register64 // 0x3C
	RAM_COM6 volatile.Register64 // 0x44
	RAM_COM7 volatile.Register64 // 0x4C
}

// LCD.CR: control register
func (o *LCD_Type) SetCR_BIAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *LCD_Type) GetCR_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *LCD_Type) SetCR_DUTY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c)|value<<2)
}
func (o *LCD_Type) GetCR_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c) >> 2
}
func (o *LCD_Type) SetCR_VSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCR_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetCR_LCDEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCR_LCDEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *LCD_Type) SetCR_MUX_SEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetCR_MUX_SEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetCR_BUFEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetCR_BUFEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// LCD.FCR: frame control register
func (o *LCD_Type) SetFCR_PS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3c00000)|value<<22)
}
func (o *LCD_Type) GetFCR_PS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3c00000) >> 22
}
func (o *LCD_Type) SetFCR_DIV(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3c0000)|value<<18)
}
func (o *LCD_Type) GetFCR_DIV() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3c0000) >> 18
}
func (o *LCD_Type) SetFCR_BLINK(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x30000)|value<<16)
}
func (o *LCD_Type) GetFCR_BLINK() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x30000) >> 16
}
func (o *LCD_Type) SetFCR_BLINKF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xe000)|value<<13)
}
func (o *LCD_Type) GetFCR_BLINKF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xe000) >> 13
}
func (o *LCD_Type) SetFCR_CC(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1c00)|value<<10)
}
func (o *LCD_Type) GetFCR_CC() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x1c00) >> 10
}
func (o *LCD_Type) SetFCR_DEAD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x380)|value<<7)
}
func (o *LCD_Type) GetFCR_DEAD() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x380) >> 7
}
func (o *LCD_Type) SetFCR_PON(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x70)|value<<4)
}
func (o *LCD_Type) GetFCR_PON() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x70) >> 4
}
func (o *LCD_Type) SetFCR_UDDIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetFCR_UDDIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetFCR_SOFIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetFCR_SOFIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetFCR_HD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetFCR_HD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// LCD.SR: status register
func (o *LCD_Type) SetSR_FCRSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetSR_FCRSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetSR_RDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetSR_RDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetSR_UDD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetSR_UDD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetSR_SOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetSR_SOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetSR_ENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetSR_ENS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// LCD.CLR: clear register
func (o *LCD_Type) SetCLR_UDDC(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetCLR_UDDC() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetCLR_SOFC(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCLR_SOFC() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2) >> 1
}

// LCD.RAM_COM0: display memory
func (o *LCD_Type) SetRAM_COM0_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM0.Reg, volatile.LoadUint64(&o.RAM_COM0.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM0_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM0.Reg) & 0x0
}

// LCD.RAM_COM1: display memory
func (o *LCD_Type) SetRAM_COM1_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM1.Reg, volatile.LoadUint64(&o.RAM_COM1.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM1_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM1.Reg) & 0x0
}

// LCD.RAM_COM2: display memory
func (o *LCD_Type) SetRAM_COM2_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM2.Reg, volatile.LoadUint64(&o.RAM_COM2.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM2_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM2.Reg) & 0x0
}

// LCD.RAM_COM3: display memory
func (o *LCD_Type) SetRAM_COM3_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM3.Reg, volatile.LoadUint64(&o.RAM_COM3.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM3_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM3.Reg) & 0x0
}

// LCD.RAM_COM4: display memory
func (o *LCD_Type) SetRAM_COM4_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM4.Reg, volatile.LoadUint64(&o.RAM_COM4.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM4_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM4.Reg) & 0x0
}

// LCD.RAM_COM5: display memory
func (o *LCD_Type) SetRAM_COM5_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM5.Reg, volatile.LoadUint64(&o.RAM_COM5.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM5_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM5.Reg) & 0x0
}

// LCD.RAM_COM6: display memory
func (o *LCD_Type) SetRAM_COM6_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM6.Reg, volatile.LoadUint64(&o.RAM_COM6.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM6_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM6.Reg) & 0x0
}

// LCD.RAM_COM7: display memory
func (o *LCD_Type) SetRAM_COM7_SEGS(value uint64) {
	volatile.StoreUint64(&o.RAM_COM7.Reg, volatile.LoadUint64(&o.RAM_COM7.Reg)&^(0x0)|value)
}
func (o *LCD_Type) GetRAM_COM7_SEGS() uint64 {
	return volatile.LoadUint64(&o.RAM_COM7.Reg) & 0x0
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// TSC.CR: control register
func (o *TSC_Type) SetCR_CTPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *TSC_Type) GetCR_CTPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000000) >> 28
}
func (o *TSC_Type) SetCR_CTPL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *TSC_Type) GetCR_CTPL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *TSC_Type) SetCR_SSD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xfe0000)|value<<17)
}
func (o *TSC_Type) GetCR_SSD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xfe0000) >> 17
}
func (o *TSC_Type) SetCR_SSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetCR_SSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetCR_SSPSC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetCR_SSPSC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetCR_PGPSC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7000)|value<<12)
}
func (o *TSC_Type) GetCR_PGPSC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7000) >> 12
}
func (o *TSC_Type) SetCR_MCV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *TSC_Type) GetCR_MCV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *TSC_Type) SetCR_IODEF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetCR_IODEF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetCR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetCR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetCR_AM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetCR_AM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetCR_TSCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetCR_TSCE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// TSC.IER: interrupt enable register
func (o *TSC_Type) SetIER_MCEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIER_MCEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIER_EOAIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIER_EOAIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TSC.ICR: interrupt clear register
func (o *TSC_Type) SetICR_MCEIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetICR_MCEIC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetICR_EOAIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetICR_EOAIC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// TSC.ISR: interrupt status register
func (o *TSC_Type) SetISR_MCEF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetISR_MCEF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetISR_EOAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetISR_EOAF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TSC.IOHCR: I/O hysteresis control register
func (o *TSC_Type) SetIOHCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOHCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80000000) >> 31
}
func (o *TSC_Type) SetIOHCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOHCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOHCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOHCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOHCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOHCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOHCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOHCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOHCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOHCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOHCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOHCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOHCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOHCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOHCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOHCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOHCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOHCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOHCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOHCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOHCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOHCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOHCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOHCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOHCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOHCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOHCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOHCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOHCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOHCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOHCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOHCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOHCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOHCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOHCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOHCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOHCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOHCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOHCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOHCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOHCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOHCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOHCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOHCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOHCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOHCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOHCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOHCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOHCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOHCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOHCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOHCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOHCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOHCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOHCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOHCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOHCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOHCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOHCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOHCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOHCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOHCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOHCR.Reg) & 0x1
}

// TSC.IOASCR: I/O analog switch control register
func (o *TSC_Type) SetIOASCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOASCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80000000) >> 31
}
func (o *TSC_Type) SetIOASCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOASCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOASCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOASCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOASCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOASCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOASCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOASCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOASCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOASCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOASCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOASCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOASCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOASCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOASCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOASCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOASCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOASCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOASCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOASCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOASCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOASCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOASCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOASCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOASCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOASCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOASCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOASCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOASCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOASCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOASCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOASCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOASCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOASCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOASCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOASCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOASCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOASCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOASCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOASCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOASCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOASCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOASCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOASCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOASCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOASCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOASCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOASCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOASCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOASCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOASCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOASCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOASCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOASCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOASCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOASCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOASCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOASCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOASCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOASCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOASCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOASCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOASCR.Reg) & 0x1
}

// TSC.IOSCR: I/O sampling control register
func (o *TSC_Type) SetIOSCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOSCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80000000) >> 31
}
func (o *TSC_Type) SetIOSCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOSCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOSCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOSCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOSCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOSCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOSCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOSCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOSCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOSCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOSCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOSCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOSCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOSCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOSCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOSCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOSCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOSCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOSCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOSCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOSCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOSCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOSCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOSCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOSCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOSCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOSCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOSCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOSCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOSCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOSCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOSCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOSCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOSCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOSCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOSCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOSCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOSCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOSCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOSCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOSCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOSCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOSCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOSCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOSCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOSCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOSCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOSCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOSCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOSCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOSCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOSCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOSCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOSCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOSCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOSCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOSCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOSCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOSCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOSCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOSCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOSCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOSCR.Reg) & 0x1
}

// TSC.IOCCR: I/O channel control register
func (o *TSC_Type) SetIOCCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOCCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80000000) >> 31
}
func (o *TSC_Type) SetIOCCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOCCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOCCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOCCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOCCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOCCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOCCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOCCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOCCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOCCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOCCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOCCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOCCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOCCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOCCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOCCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOCCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOCCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOCCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOCCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOCCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOCCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOCCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOCCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOCCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOCCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOCCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOCCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOCCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOCCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOCCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOCCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOCCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOCCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOCCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOCCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOCCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOCCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOCCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOCCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOCCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOCCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOCCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOCCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOCCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOCCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOCCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOCCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOCCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOCCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOCCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOCCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOCCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOCCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOCCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOCCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOCCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOCCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOCCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOCCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOCCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOCCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOCCR.Reg) & 0x1
}

// TSC.IOGCSR: I/O group control status register
func (o *TSC_Type) SetIOGCSR_G8S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOGCSR_G8S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOGCSR_G7S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOGCSR_G7S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOGCSR_G6S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOGCSR_G6S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOGCSR_G5S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOGCSR_G5S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOGCSR_G4S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOGCSR_G4S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOGCSR_G3S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOGCSR_G3S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOGCSR_G2S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOGCSR_G2S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOGCSR_G1S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOGCSR_G1S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOGCSR_G8E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOGCSR_G8E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOGCSR_G7E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOGCSR_G7E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOGCSR_G6E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOGCSR_G6E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOGCSR_G5E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOGCSR_G5E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOGCSR_G4E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOGCSR_G4E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOGCSR_G3E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOGCSR_G3E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOGCSR_G2E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOGCSR_G2E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOGCSR_G1E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOGCSR_G1E() uint32 {
	return volatile.LoadUint32(&o.IOGCSR.Reg) & 0x1
}

// TSC.IOG1CR: I/O group x counter register
func (o *TSC_Type) SetIOG1CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG1CR.Reg, volatile.LoadUint32(&o.IOG1CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG1CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG1CR.Reg) & 0x3fff
}

// TSC.IOG2CR: I/O group x counter register
func (o *TSC_Type) SetIOG2CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG2CR.Reg, volatile.LoadUint32(&o.IOG2CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG2CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG2CR.Reg) & 0x3fff
}

// TSC.IOG3CR: I/O group x counter register
func (o *TSC_Type) SetIOG3CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG3CR.Reg, volatile.LoadUint32(&o.IOG3CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG3CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG3CR.Reg) & 0x3fff
}

// TSC.IOG4CR: I/O group x counter register
func (o *TSC_Type) SetIOG4CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG4CR.Reg, volatile.LoadUint32(&o.IOG4CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG4CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG4CR.Reg) & 0x3fff
}

// TSC.IOG5CR: I/O group x counter register
func (o *TSC_Type) SetIOG5CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG5CR.Reg, volatile.LoadUint32(&o.IOG5CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG5CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG5CR.Reg) & 0x3fff
}

// TSC.IOG6CR: I/O group x counter register
func (o *TSC_Type) SetIOG6CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG6CR.Reg, volatile.LoadUint32(&o.IOG6CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG6CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG6CR.Reg) & 0x3fff
}

// TSC.IOG7CR: I/O group x counter register
func (o *TSC_Type) SetIOG7CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG7CR.Reg, volatile.LoadUint32(&o.IOG7CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG7CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG7CR.Reg) & 0x3fff
}

// TSC.IOG8CR: I/O group x counter register
func (o *TSC_Type) SetIOG8CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG8CR.Reg, volatile.LoadUint32(&o.IOG8CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG8CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG8CR.Reg) & 0x3fff
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Comparator
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// COMP.COMP1_CSR: Comparator 1 control and status register
func (o *COMP_Type) SetCOMP1_CSR_COMP1_EN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_EN() uint32 {
	return volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0xc)|value<<2)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0xc) >> 2
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x80)|value<<7)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x80) >> 7
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_BRGEN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_SCALEN(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP1_CSR_COMP1_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP1_CSR.Reg, volatile.LoadUint32(&o.COMP1_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP1_CSR_COMP1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP1_CSR.Reg) & 0x80000000) >> 31
}

// COMP.COMP2_CSR: Comparator 2 control and status register
func (o *COMP_Type) SetCOMP2_CSR_COMP2_EN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_EN() uint32 {
	return volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0xc)|value<<2)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0xc) >> 2
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_INPSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x80) >> 7
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_WINMODE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x200)|value<<9)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x200) >> 9
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_POLARITY(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_HYST(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x30000)|value<<16)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x30000) >> 16
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_BRGEN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x400000) >> 22
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_SCALEN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x800000) >> 23
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_VALUE(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_VALUE() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x80000000) >> 31
}

// Firewall
type Firewall_Type struct {
	CSSA   volatile.Register32 // 0x0
	CSL    volatile.Register32 // 0x4
	NVDSSA volatile.Register32 // 0x8
	NVDSL  volatile.Register32 // 0xC
	VDSSA  volatile.Register32 // 0x10
	VDSL   volatile.Register32 // 0x14
	_      [8]byte
	CR     volatile.Register32 // 0x20
}

// Firewall.CSSA: Code segment start address
func (o *Firewall_Type) SetCSSA_ADD(value uint32) {
	volatile.StoreUint32(&o.CSSA.Reg, volatile.LoadUint32(&o.CSSA.Reg)&^(0xffff00)|value<<8)
}
func (o *Firewall_Type) GetCSSA_ADD() uint32 {
	return (volatile.LoadUint32(&o.CSSA.Reg) & 0xffff00) >> 8
}

// Firewall.CSL: Code segment length
func (o *Firewall_Type) SetCSL_LENG(value uint32) {
	volatile.StoreUint32(&o.CSL.Reg, volatile.LoadUint32(&o.CSL.Reg)&^(0x3fff00)|value<<8)
}
func (o *Firewall_Type) GetCSL_LENG() uint32 {
	return (volatile.LoadUint32(&o.CSL.Reg) & 0x3fff00) >> 8
}

// Firewall.NVDSSA: Non-volatile data segment start address
func (o *Firewall_Type) SetNVDSSA_ADD(value uint32) {
	volatile.StoreUint32(&o.NVDSSA.Reg, volatile.LoadUint32(&o.NVDSSA.Reg)&^(0xffff00)|value<<8)
}
func (o *Firewall_Type) GetNVDSSA_ADD() uint32 {
	return (volatile.LoadUint32(&o.NVDSSA.Reg) & 0xffff00) >> 8
}

// Firewall.NVDSL: Non-volatile data segment length
func (o *Firewall_Type) SetNVDSL_LENG(value uint32) {
	volatile.StoreUint32(&o.NVDSL.Reg, volatile.LoadUint32(&o.NVDSL.Reg)&^(0x3fff00)|value<<8)
}
func (o *Firewall_Type) GetNVDSL_LENG() uint32 {
	return (volatile.LoadUint32(&o.NVDSL.Reg) & 0x3fff00) >> 8
}

// Firewall.VDSSA: Volatile data segment start address
func (o *Firewall_Type) SetVDSSA_ADD(value uint32) {
	volatile.StoreUint32(&o.VDSSA.Reg, volatile.LoadUint32(&o.VDSSA.Reg)&^(0xffc0)|value<<6)
}
func (o *Firewall_Type) GetVDSSA_ADD() uint32 {
	return (volatile.LoadUint32(&o.VDSSA.Reg) & 0xffc0) >> 6
}

// Firewall.VDSL: Volatile data segment length
func (o *Firewall_Type) SetVDSL_LENG(value uint32) {
	volatile.StoreUint32(&o.VDSL.Reg, volatile.LoadUint32(&o.VDSL.Reg)&^(0xffc0)|value<<6)
}
func (o *Firewall_Type) GetVDSL_LENG() uint32 {
	return (volatile.LoadUint32(&o.VDSL.Reg) & 0xffc0) >> 6
}

// Firewall.CR: Configuration register
func (o *Firewall_Type) SetCR_VDE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Firewall_Type) GetCR_VDE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Firewall_Type) SetCR_VDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Firewall_Type) GetCR_VDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Firewall_Type) SetCR_FPA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Firewall_Type) GetCR_FPA() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Flash
type Flash_Type struct {
	ACR      volatile.Register32 // 0x0
	PDKEYR   volatile.Register32 // 0x4
	KEYR     volatile.Register32 // 0x8
	OPTKEYR  volatile.Register32 // 0xC
	SR       volatile.Register32 // 0x10
	CR       volatile.Register32 // 0x14
	ECCR     volatile.Register32 // 0x18
	_        [4]byte
	OPTR     volatile.Register32 // 0x20
	PCROP1SR volatile.Register32 // 0x24
	PCROP1ER volatile.Register32 // 0x28
	WRP1AR   volatile.Register32 // 0x2C
	WRP1BR   volatile.Register32 // 0x30
	_        [16]byte
	PCROP2SR volatile.Register32 // 0x44
	PCROP2ER volatile.Register32 // 0x48
	WRP2AR   volatile.Register32 // 0x4C
	WRP2BR   volatile.Register32 // 0x50
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *Flash_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetACR_RUN_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetACR_RUN_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetACR_SLEEP_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetACR_SLEEP_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4000) >> 14
}

// Flash.PDKEYR: Power down key register
func (o *Flash_Type) SetPDKEYR(value uint32) {
	volatile.StoreUint32(&o.PDKEYR.Reg, value)
}
func (o *Flash_Type) GetPDKEYR() uint32 {
	return volatile.LoadUint32(&o.PDKEYR.Reg)
}

// Flash.KEYR: Flash key register
func (o *Flash_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *Flash_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// Flash.OPTKEYR: Option byte key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Status register
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *Flash_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSR_PROGERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSR_PROGERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetSR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSR_MISERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSR_MISERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetSR_FASTERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetSR_FASTERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// Flash.CR: Flash control register
func (o *Flash_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *Flash_Type) SetCR_PER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetCR_PER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetCR_MER1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetCR_MER1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetCR_PNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f8)|value<<3)
}
func (o *Flash_Type) GetCR_PNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7f8) >> 3
}
func (o *Flash_Type) SetCR_BKER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetCR_BKER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetCR_MER2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetCR_MER2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetCR_FSTPG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetCR_FSTPG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetCR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetCR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetCR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// Flash.ECCR: Flash ECC register
func (o *Flash_Type) SetECCR_ADDR_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x7ffff)|value)
}
func (o *Flash_Type) GetECCR_ADDR_ECC() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg) & 0x7ffff
}
func (o *Flash_Type) SetECCR_BK_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetECCR_BK_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetECCR_SYSF_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetECCR_SYSF_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetECCR_ECCIE(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetECCR_ECCIE() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetECCR_ECCC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetECCR_ECCC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetECCR_ECCD(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetECCR_ECCD() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000000) >> 31
}

// Flash.OPTR: Flash option register
func (o *Flash_Type) SetOPTR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOPTR_RDP() uint32 {
	return volatile.LoadUint32(&o.OPTR.Reg) & 0xff
}
func (o *Flash_Type) SetOPTR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x700)|value<<8)
}
func (o *Flash_Type) GetOPTR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x700) >> 8
}
func (o *Flash_Type) SetOPTR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetOPTR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetOPTR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOPTR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOPTR_IDWG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetOPTR_IDWG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetOPTR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetOPTR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetOPTR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetOPTR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetOPTR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetOPTR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetOPTR_BFB2(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetOPTR_BFB2() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetOPTR_DUALBANK(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x200000)|value<<21)
}
func (o *Flash_Type) GetOPTR_DUALBANK() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x200000) >> 21
}
func (o *Flash_Type) SetOPTR_NBOOT1(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetOPTR_NBOOT1() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x800000) >> 23
}
func (o *Flash_Type) SetOPTR_SRAM2_PE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetOPTR_SRAM2_PE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetOPTR_SRAM2_RST(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetOPTR_SRAM2_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetOPTR_NSWBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetOPTR_NSWBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetOPTR_NBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetOPTR_NBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x8000000) >> 27
}

// Flash.PCROP1SR: Flash Bank 1 PCROP Start address register
func (o *Flash_Type) SetPCROP1SR_PCROP1_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP1SR.Reg, volatile.LoadUint32(&o.PCROP1SR.Reg)&^(0xffff)|value)
}
func (o *Flash_Type) GetPCROP1SR_PCROP1_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP1SR.Reg) & 0xffff
}

// Flash.PCROP1ER: Flash Bank 1 PCROP End address register
func (o *Flash_Type) SetPCROP1ER_PCROP1_END(value uint32) {
	volatile.StoreUint32(&o.PCROP1ER.Reg, volatile.LoadUint32(&o.PCROP1ER.Reg)&^(0xffff)|value)
}
func (o *Flash_Type) GetPCROP1ER_PCROP1_END() uint32 {
	return volatile.LoadUint32(&o.PCROP1ER.Reg) & 0xffff
}
func (o *Flash_Type) SetPCROP1ER_PCROP_RDP(value uint32) {
	volatile.StoreUint32(&o.PCROP1ER.Reg, volatile.LoadUint32(&o.PCROP1ER.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetPCROP1ER_PCROP_RDP() uint32 {
	return (volatile.LoadUint32(&o.PCROP1ER.Reg) & 0x80000000) >> 31
}

// Flash.WRP1AR: Flash Bank 1 WRP area A address register
func (o *Flash_Type) SetWRP1AR_WRP1A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP1AR.Reg) & 0xff
}
func (o *Flash_Type) SetWRP1AR_WRP1A_END(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP1AR.Reg) & 0xff0000) >> 16
}

// Flash.WRP1BR: Flash Bank 1 WRP area B address register
func (o *Flash_Type) SetWRP1BR_WRP1B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_STRT() uint32 {
	return (volatile.LoadUint32(&o.WRP1BR.Reg) & 0xff0000) >> 16
}
func (o *Flash_Type) SetWRP1BR_WRP1B_END(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_END() uint32 {
	return volatile.LoadUint32(&o.WRP1BR.Reg) & 0xff
}

// Flash.PCROP2SR: Flash Bank 2 PCROP Start address register
func (o *Flash_Type) SetPCROP2SR_PCROP2_STRT(value uint32) {
	volatile.StoreUint32(&o.PCROP2SR.Reg, volatile.LoadUint32(&o.PCROP2SR.Reg)&^(0xffff)|value)
}
func (o *Flash_Type) GetPCROP2SR_PCROP2_STRT() uint32 {
	return volatile.LoadUint32(&o.PCROP2SR.Reg) & 0xffff
}

// Flash.PCROP2ER: Flash Bank 2 PCROP End address register
func (o *Flash_Type) SetPCROP2ER_PCROP2_END(value uint32) {
	volatile.StoreUint32(&o.PCROP2ER.Reg, volatile.LoadUint32(&o.PCROP2ER.Reg)&^(0xffff)|value)
}
func (o *Flash_Type) GetPCROP2ER_PCROP2_END() uint32 {
	return volatile.LoadUint32(&o.PCROP2ER.Reg) & 0xffff
}

// Flash.WRP2AR: Flash Bank 2 WRP area A address register
func (o *Flash_Type) SetWRP2AR_WRP2A_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP2AR.Reg, volatile.LoadUint32(&o.WRP2AR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetWRP2AR_WRP2A_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP2AR.Reg) & 0xff
}
func (o *Flash_Type) SetWRP2AR_WRP2A_END(value uint32) {
	volatile.StoreUint32(&o.WRP2AR.Reg, volatile.LoadUint32(&o.WRP2AR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetWRP2AR_WRP2A_END() uint32 {
	return (volatile.LoadUint32(&o.WRP2AR.Reg) & 0xff0000) >> 16
}

// Flash.WRP2BR: Flash Bank 2 WRP area B address register
func (o *Flash_Type) SetWRP2BR_WRP2B_STRT(value uint32) {
	volatile.StoreUint32(&o.WRP2BR.Reg, volatile.LoadUint32(&o.WRP2BR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetWRP2BR_WRP2B_STRT() uint32 {
	return volatile.LoadUint32(&o.WRP2BR.Reg) & 0xff
}
func (o *Flash_Type) SetWRP2BR_WRP2B_END(value uint32) {
	volatile.StoreUint32(&o.WRP2BR.Reg, volatile.LoadUint32(&o.WRP2BR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetWRP2BR_WRP2B_END() uint32 {
	return (volatile.LoadUint32(&o.WRP2BR.Reg) & 0xff0000) >> 16
}

// Debug support
type DBGMCU_Type struct {
	IDCODE    volatile.Register32 // 0x0
	CR        volatile.Register32 // 0x4
	APB1_FZR1 volatile.Register32 // 0x8
	APB1_FZR2 volatile.Register32 // 0xC
	APB2_FZR  volatile.Register32 // 0x10
}

// DBGMCU.IDCODE: MCU Device ID Code Register
func (o *DBGMCU_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff)|value)
}
func (o *DBGMCU_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff
}
func (o *DBGMCU_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBGMCU_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBGMCU.CR: Debug MCU Configuration Register
func (o *DBGMCU_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBGMCU_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBGMCU_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBGMCU.APB1_FZR1: APB Low Freeze Register 1
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_TIMER2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_TIMER2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_TIMER6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_TIMER6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_I2C1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_I2C1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_I2C2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_I2C2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x400000) >> 22
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_I2C3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x800000)|value<<23)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_I2C3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x800000) >> 23
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_CAN_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x2000000)|value<<25)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_CAN_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x2000000) >> 25
}
func (o *DBGMCU_Type) SetAPB1_FZR1_DBG_LPTIMER_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR1.Reg, volatile.LoadUint32(&o.APB1_FZR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGMCU_Type) GetAPB1_FZR1_DBG_LPTIMER_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR1.Reg) & 0x80000000) >> 31
}

// DBGMCU.APB1_FZR2: APB Low Freeze Register 2
func (o *DBGMCU_Type) SetAPB1_FZR2_DBG_LPTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZR2.Reg, volatile.LoadUint32(&o.APB1_FZR2.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1_FZR2_DBG_LPTIM2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZR2.Reg) & 0x20) >> 5
}

// DBGMCU.APB2_FZR: APB High Freeze Register
func (o *DBGMCU_Type) SetAPB2_FZR_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZR.Reg, volatile.LoadUint32(&o.APB2_FZR.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB2_FZR_DBG_TIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZR.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB2_FZR_DBG_TIM8_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZR.Reg, volatile.LoadUint32(&o.APB2_FZR.Reg)&^(0x2000)|value<<13)
}
func (o *DBGMCU_Type) GetAPB2_FZR_DBG_TIM8_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZR.Reg) & 0x2000) >> 13
}
func (o *DBGMCU_Type) SetAPB2_FZR_DBG_TIM15_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZR.Reg, volatile.LoadUint32(&o.APB2_FZR.Reg)&^(0x10000)|value<<16)
}
func (o *DBGMCU_Type) GetAPB2_FZR_DBG_TIM15_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZR.Reg) & 0x10000) >> 16
}
func (o *DBGMCU_Type) SetAPB2_FZR_DBG_TIM16_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZR.Reg, volatile.LoadUint32(&o.APB2_FZR.Reg)&^(0x20000)|value<<17)
}
func (o *DBGMCU_Type) GetAPB2_FZR_DBG_TIM16_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZR.Reg) & 0x20000) >> 17
}
func (o *DBGMCU_Type) SetAPB2_FZR_DBG_TIM17_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZR.Reg, volatile.LoadUint32(&o.APB2_FZR.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB2_FZR_DBG_TIM17_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZR.Reg) & 0x40000) >> 18
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// QUADSPI.CR: control register
func (o *QUADSPI_Type) SetCR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *QUADSPI_Type) GetCR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}
func (o *QUADSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *QUADSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *QUADSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *QUADSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *QUADSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *QUADSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *QUADSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *QUADSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *QUADSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *QUADSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *QUADSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *QUADSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *QUADSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *QUADSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *QUADSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *QUADSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}
func (o *QUADSPI_Type) SetCR_FSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QUADSPI_Type) GetCR_FSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QUADSPI_Type) SetCR_DFM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *QUADSPI_Type) GetCR_DFM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *QUADSPI_Type) SetCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// QUADSPI.DCR: device configuration register
func (o *QUADSPI_Type) SetDCR_FSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QUADSPI_Type) GetDCR_FSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f0000) >> 16
}
func (o *QUADSPI_Type) SetDCR_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x700)|value<<8)
}
func (o *QUADSPI_Type) GetDCR_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x700) >> 8
}
func (o *QUADSPI_Type) SetDCR_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetDCR_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}

// QUADSPI.SR: status register
func (o *QUADSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7f00)|value<<8)
}
func (o *QUADSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7f00) >> 8
}
func (o *QUADSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *QUADSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *QUADSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// QUADSPI.FCR: flag clear register
func (o *QUADSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// QUADSPI.DLR: data length register
func (o *QUADSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *QUADSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// QUADSPI.CCR: communication configuration register
func (o *QUADSPI_Type) SetCCR_DDRM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *QUADSPI_Type) GetCCR_DDRM() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}
func (o *QUADSPI_Type) SetCCR_DHHC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000000)|value<<30)
}
func (o *QUADSPI_Type) GetCCR_DHHC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000000) >> 30
}
func (o *QUADSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000000)|value<<28)
}
func (o *QUADSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000000) >> 28
}
func (o *QUADSPI_Type) SetCCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000000)|value<<26)
}
func (o *QUADSPI_Type) GetCCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000000) >> 26
}
func (o *QUADSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000000)|value<<24)
}
func (o *QUADSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000000) >> 24
}
func (o *QUADSPI_Type) SetCCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7c0000)|value<<18)
}
func (o *QUADSPI_Type) GetCCR_DCYC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7c0000) >> 18
}
func (o *QUADSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *QUADSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *QUADSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000)|value<<14)
}
func (o *QUADSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000) >> 14
}
func (o *QUADSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *QUADSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *QUADSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc00)|value<<10)
}
func (o *QUADSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc00) >> 10
}
func (o *QUADSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300)|value<<8)
}
func (o *QUADSPI_Type) GetCCR_IMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300) >> 8
}
func (o *QUADSPI_Type) SetCCR_INSTRUCTION(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *QUADSPI_Type) GetCCR_INSTRUCTION() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}

// QUADSPI.AR: address register
func (o *QUADSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *QUADSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// QUADSPI.ABR: ABR
func (o *QUADSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *QUADSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// QUADSPI.DR: data register
func (o *QUADSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *QUADSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// QUADSPI.PSMKR: polling status mask register
func (o *QUADSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// QUADSPI.PSMAR: polling status match register
func (o *QUADSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// QUADSPI.PIR: polling interval register
func (o *QUADSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// QUADSPI.LPTR: low-power timeout register
func (o *QUADSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// Reset and clock control
type RCC_Type struct {
	CR          volatile.Register32 // 0x0
	ICSCR       volatile.Register32 // 0x4
	CFGR        volatile.Register32 // 0x8
	PLLCFGR     volatile.Register32 // 0xC
	PLLSAI1CFGR volatile.Register32 // 0x10
	PLLSAI2CFGR volatile.Register32 // 0x14
	CIER        volatile.Register32 // 0x18
	CIFR        volatile.Register32 // 0x1C
	CICR        volatile.Register32 // 0x20
	_           [4]byte
	AHB1RSTR    volatile.Register32 // 0x28
	AHB2RSTR    volatile.Register32 // 0x2C
	AHB3RSTR    volatile.Register32 // 0x30
	_           [4]byte
	APB1RSTR1   volatile.Register32 // 0x38
	APB1RSTR2   volatile.Register32 // 0x3C
	APB2RSTR    volatile.Register32 // 0x40
	_           [4]byte
	AHB1ENR     volatile.Register32 // 0x48
	AHB2ENR     volatile.Register32 // 0x4C
	AHB3ENR     volatile.Register32 // 0x50
	_           [4]byte
	APB1ENR1    volatile.Register32 // 0x58
	APB1ENR2    volatile.Register32 // 0x5C
	APB2ENR     volatile.Register32 // 0x60
	_           [4]byte
	AHB1SMENR   volatile.Register32 // 0x68
	AHB2SMENR   volatile.Register32 // 0x6C
	AHB3SMENR   volatile.Register32 // 0x70
	_           [4]byte
	APB1SMENR1  volatile.Register32 // 0x78
	APB1SMENR2  volatile.Register32 // 0x7C
	APB2SMENR   volatile.Register32 // 0x80
	_           [4]byte
	CCIPR       volatile.Register32 // 0x88
	_           [4]byte
	BDCR        volatile.Register32 // 0x90
	CSR         volatile.Register32 // 0x94
	CRRCR       volatile.Register32 // 0x98
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_PLLSAI2RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCR_PLLSAI2RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCR_PLLSAI2ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCR_PLLSAI2ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCR_PLLSAI1RDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLSAI1RDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLLSAI1ON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLSAI1ON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSIASFS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCR_HSIASFS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCR_HSIKERON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_HSIKERON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCR_MSIRANGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCR_MSIRANGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCR_MSIRGSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCR_MSIRGSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCR_MSIPLLEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCR_MSIPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCR_MSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_MSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_MSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_MSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// RCC.ICSCR: Internal clock sources calibration register
func (o *RCC_Type) SetICSCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0x7f000000)|value<<24)
}
func (o *RCC_Type) GetICSCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0x7f000000) >> 24
}
func (o *RCC_Type) SetICSCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RCC_Type) GetICSCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff0000) >> 16
}
func (o *RCC_Type) SetICSCR_MSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetICSCR_MSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetICSCR_MSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff)|value)
}
func (o *RCC_Type) GetICSCR_MSICAL() uint32 {
	return volatile.LoadUint32(&o.ICSCR.Reg) & 0xff
}

// RCC.CFGR: Clock configuration register
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetCFGR_MCOSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCOSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_STOPWUCK(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetCFGR_STOPWUCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x700) >> 8
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x6000000)|value<<25)
}
func (o *RCC_Type) GetPLLCFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x6000000) >> 25
}
func (o *RCC_Type) SetPLLCFGR_PLLREN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLREN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetPLLCFGR_PLLQEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetPLLCFGR_PLLQEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetPLLCFGR_PLLPEN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLPEN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7f00) >> 8
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x70)|value<<4)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x70) >> 4
}
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3
}
func (o *RCC_Type) SetPLLCFGR_PLLPDIV(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf8000000)|value<<27)
}
func (o *RCC_Type) GetPLLCFGR_PLLPDIV() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf8000000) >> 27
}

// RCC.PLLSAI1CFGR: PLLSAI1 configuration register
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1R(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x6000000)|value<<25)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1R() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x6000000) >> 25
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1REN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1REN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1Q(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1Q() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1QEN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1QEN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1P(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1P() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1PEN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1PEN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1N(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1N() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0x7f00) >> 8
}
func (o *RCC_Type) SetPLLSAI1CFGR_PLLSAI1PDIV(value uint32) {
	volatile.StoreUint32(&o.PLLSAI1CFGR.Reg, volatile.LoadUint32(&o.PLLSAI1CFGR.Reg)&^(0xf8000000)|value<<27)
}
func (o *RCC_Type) GetPLLSAI1CFGR_PLLSAI1PDIV() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI1CFGR.Reg) & 0xf8000000) >> 27
}

// RCC.PLLSAI2CFGR: PLLSAI2 configuration register
func (o *RCC_Type) SetPLLSAI2CFGR_PLLSAI2R(value uint32) {
	volatile.StoreUint32(&o.PLLSAI2CFGR.Reg, volatile.LoadUint32(&o.PLLSAI2CFGR.Reg)&^(0x6000000)|value<<25)
}
func (o *RCC_Type) GetPLLSAI2CFGR_PLLSAI2R() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI2CFGR.Reg) & 0x6000000) >> 25
}
func (o *RCC_Type) SetPLLSAI2CFGR_PLLSAI2REN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI2CFGR.Reg, volatile.LoadUint32(&o.PLLSAI2CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetPLLSAI2CFGR_PLLSAI2REN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI2CFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetPLLSAI2CFGR_PLLSAI2P(value uint32) {
	volatile.StoreUint32(&o.PLLSAI2CFGR.Reg, volatile.LoadUint32(&o.PLLSAI2CFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetPLLSAI2CFGR_PLLSAI2P() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI2CFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetPLLSAI2CFGR_PLLSAI2PEN(value uint32) {
	volatile.StoreUint32(&o.PLLSAI2CFGR.Reg, volatile.LoadUint32(&o.PLLSAI2CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetPLLSAI2CFGR_PLLSAI2PEN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI2CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetPLLSAI2CFGR_PLLSAI2N(value uint32) {
	volatile.StoreUint32(&o.PLLSAI2CFGR.Reg, volatile.LoadUint32(&o.PLLSAI2CFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *RCC_Type) GetPLLSAI2CFGR_PLLSAI2N() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI2CFGR.Reg) & 0x7f00) >> 8
}
func (o *RCC_Type) SetPLLSAI2CFGR_PLLSAI2PDIV(value uint32) {
	volatile.StoreUint32(&o.PLLSAI2CFGR.Reg, volatile.LoadUint32(&o.PLLSAI2CFGR.Reg)&^(0xf8000000)|value<<27)
}
func (o *RCC_Type) GetPLLSAI2CFGR_PLLSAI2PDIV() uint32 {
	return (volatile.LoadUint32(&o.PLLSAI2CFGR.Reg) & 0xf8000000) >> 27
}

// RCC.CIER: Clock interrupt enable register
func (o *RCC_Type) SetCIER_LSECSSIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIER_LSECSSIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIER_PLLSAI2RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIER_PLLSAI2RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIER_PLLSAI1RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIER_PLLSAI1RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIER_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIER_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIER_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIER_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIER_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIER_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIER_MSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIER_MSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIER_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIER_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIER_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIER_LSIRDYIE() uint32 {
	return volatile.LoadUint32(&o.CIER.Reg) & 0x1
}
func (o *RCC_Type) SetCIER_HSI48RDYIE(value uint32) {
	volatile.StoreUint32(&o.CIER.Reg, volatile.LoadUint32(&o.CIER.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIER_HSI48RDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIER.Reg) & 0x400) >> 10
}

// RCC.CIFR: Clock interrupt flag register
func (o *RCC_Type) SetCIFR_LSECSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIFR_LSECSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIFR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIFR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIFR_PLLSAI2RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIFR_PLLSAI2RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIFR_PLLSAI1RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIFR_PLLSAI1RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIFR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIFR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIFR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIFR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIFR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIFR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIFR_MSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIFR_MSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIFR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIFR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIFR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIFR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIFR.Reg) & 0x1
}
func (o *RCC_Type) SetCIFR_HSI48RDYF(value uint32) {
	volatile.StoreUint32(&o.CIFR.Reg, volatile.LoadUint32(&o.CIFR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIFR_HSI48RDYF() uint32 {
	return (volatile.LoadUint32(&o.CIFR.Reg) & 0x400) >> 10
}

// RCC.CICR: Clock interrupt clear register
func (o *RCC_Type) SetCICR_LSECSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCICR_LSECSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCICR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCICR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCICR_PLLSAI2RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCICR_PLLSAI2RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCICR_PLLSAI1RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCICR_PLLSAI1RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCICR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCICR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCICR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCICR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCICR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCICR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCICR_MSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCICR_MSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCICR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCICR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCICR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCICR_LSIRDYC() uint32 {
	return volatile.LoadUint32(&o.CICR.Reg) & 0x1
}
func (o *RCC_Type) SetCICR_HSI48RDYC(value uint32) {
	volatile.StoreUint32(&o.CICR.Reg, volatile.LoadUint32(&o.CICR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCICR_HSI48RDYC() uint32 {
	return (volatile.LoadUint32(&o.CICR.Reg) & 0x400) >> 10
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_TSCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1RSTR_TSCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_FLASHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1RSTR_FLASHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1RSTR_DMA2DRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2DRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20000) >> 17
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB2RSTR_AESRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2RSTR_AESRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2RSTR_OTGFSRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB2RSTR_OTGFSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB2RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2RSTR_GPIOIRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB2RSTR_GPIOIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB2RSTR_DCMIRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB2RSTR_DCMIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB2RSTR_HASH1RST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB2RSTR_HASH1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20000) >> 17
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB3RSTR_FMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_FMCRST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}

// RCC.APB1RSTR1: APB1 peripheral reset register 1
func (o *RCC_Type) SetAPB1RSTR1_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR1_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR1_OPAMPRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1RSTR1_OPAMPRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1RSTR1_DAC1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR1_DAC1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR1_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR1_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR1_CAN1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1RSTR1_CAN1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1RSTR1_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR1_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR1_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR1_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR1_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR1_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR1_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR1_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR1_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR1_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR1_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR1_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR1_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR1_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR1_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR1_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR1_LCDRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1RSTR1_LCDRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1RSTR1_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR1_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR1_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR1_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR1_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR1_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR1_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR1_CRSRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1RSTR1_CRSRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1RSTR1_CAN2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR1.Reg, volatile.LoadUint32(&o.APB1RSTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1RSTR1_CAN2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR1.Reg) & 0x4000000) >> 26
}

// RCC.APB1RSTR2: APB1 peripheral reset register 2
func (o *RCC_Type) SetAPB1RSTR2_LPTIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR2_LPTIM2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR2_SWPMI1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR2_SWPMI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR2_LPUART1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR2_LPUART1RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR2_I2C4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR2.Reg, volatile.LoadUint32(&o.APB1RSTR2.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR2_I2C4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR2.Reg) & 0x2) >> 1
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_DFSDMRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2RSTR_DFSDMRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2RSTR_SAI2RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2RSTR_SAI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2RSTR_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM15RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM15RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_SDMMCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2RSTR_SDMMCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}

// RCC.AHB1ENR: AHB1 peripheral clock enable register
func (o *RCC_Type) SetAHB1ENR_TSCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1ENR_TSCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_FLASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1ENR_FLASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1ENR_DMA2DEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1ENR_DMA2DEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20000) >> 17
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB2ENR_AESEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2ENR_AESEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2ENR_ADCEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2ENR_ADCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2ENR_OTGFSEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB2ENR_OTGFSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB2ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2ENR_GPIOIEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB2ENR_GPIOIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB2ENR_DCMIEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB2ENR_DCMIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB2ENR_HASH1EN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB2ENR_HASH1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20000) >> 17
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB3ENR_FMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_FMCEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}

// RCC.APB1ENR1: APB1ENR1
func (o *RCC_Type) SetAPB1ENR1_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR1_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1ENR1_OPAMPEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1ENR1_OPAMPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1ENR1_DAC1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR1_DAC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR1_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR1_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR1_CAN1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1ENR1_CAN1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1ENR1_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR1_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR1_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR1_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR1_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR1_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR1_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR1_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR1_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR1_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR1_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR1_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR1_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR1_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR1_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR1_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR1_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR1_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR1_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR1_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR1_LCDEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1ENR1_LCDEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1ENR1_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR1_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR1_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR1_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR1_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR1_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR1_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR1_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR1_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR1_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR1_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR1_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR1_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1ENR1_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1ENR1_CRSEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1ENR1_CRSEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1ENR1_CAN2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR1.Reg, volatile.LoadUint32(&o.APB1ENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1ENR1_CAN2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR1.Reg) & 0x4000000) >> 26
}

// RCC.APB1ENR2: APB1 peripheral clock enable register 2
func (o *RCC_Type) SetAPB1ENR2_LPTIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR2_LPTIM2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR2_SWPMI1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR2_SWPMI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR2_LPUART1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR2_LPUART1EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR2_I2C4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR2.Reg, volatile.LoadUint32(&o.APB1ENR2.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR2_I2C4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR2.Reg) & 0x2) >> 1
}

// RCC.APB2ENR: APB2ENR
func (o *RCC_Type) SetAPB2ENR_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2ENR_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2ENR_SAI2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2ENR_SAI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM15EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM15EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_SDMMCEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2ENR_SDMMCEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2ENR_FIREWALLEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2ENR_FIREWALLEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}

// RCC.AHB1SMENR: AHB1 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB1SMENR_TSCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1SMENR_TSCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1SMENR_CRCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1SMENR_CRCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1SMENR_SRAM1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB1SMENR_SRAM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB1SMENR_FLASHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1SMENR_FLASHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1SMENR_DMA2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1SMENR_DMA2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1SMENR_DMA1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1SMENR_DMA1SMEN() uint32 {
	return volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1SMENR_DMA2DSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1SMENR.Reg, volatile.LoadUint32(&o.AHB1SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1SMENR_DMA2DSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1SMENR.Reg) & 0x20000) >> 17
}

// RCC.AHB2SMENR: AHB2 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB2SMENR_RNGSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB2SMENR_RNGSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB2SMENR_AESSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB2SMENR_AESSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB2SMENR_ADCFSSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB2SMENR_ADCFSSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB2SMENR_OTGFSSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB2SMENR_OTGFSSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB2SMENR_SRAM2SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB2SMENR_SRAM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB2SMENR_GPIOHSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOHSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2SMENR_GPIOGSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOGSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2SMENR_GPIOFSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOFSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2SMENR_GPIOESMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOESMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2SMENR_GPIODSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB2SMENR_GPIODSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB2SMENR_GPIOCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOCSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB2SMENR_GPIOBSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOBSMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB2SMENR_GPIOASMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOASMEN() uint32 {
	return volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2SMENR_GPIOISMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB2SMENR_GPIOISMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB2SMENR_DCMISMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAHB2SMENR_DCMISMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAHB2SMENR_HASH1SMEN(value uint32) {
	volatile.StoreUint32(&o.AHB2SMENR.Reg, volatile.LoadUint32(&o.AHB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB2SMENR_HASH1SMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2SMENR.Reg) & 0x20000) >> 17
}

// RCC.AHB3SMENR: AHB3 peripheral clocks enable in Sleep and Stop modes register
func (o *RCC_Type) SetAHB3SMENR_QSPISMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB3SMENR_QSPISMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB3SMENR_FMCSMEN(value uint32) {
	volatile.StoreUint32(&o.AHB3SMENR.Reg, volatile.LoadUint32(&o.AHB3SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3SMENR_FMCSMEN() uint32 {
	return volatile.LoadUint32(&o.AHB3SMENR.Reg) & 0x1
}

// RCC.APB1SMENR1: APB1SMENR1
func (o *RCC_Type) SetAPB1SMENR1_LPTIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1SMENR1_LPTIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1SMENR1_OPAMPSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1SMENR1_OPAMPSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1SMENR1_DAC1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1SMENR1_DAC1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1SMENR1_PWRSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1SMENR1_PWRSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1SMENR1_CAN1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1SMENR1_CAN1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1SMENR1_I2C3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1SMENR1_I2C2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1SMENR1_I2C1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1SMENR1_I2C1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1SMENR1_UART5SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1SMENR1_UART5SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1SMENR1_UART4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1SMENR1_UART4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1SMENR1_USART3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1SMENR1_USART3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1SMENR1_USART2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1SMENR1_USART2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1SMENR1_SP3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1SMENR1_SP3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1SMENR1_SPI2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1SMENR1_SPI2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1SMENR1_WWDGSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1SMENR1_WWDGSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1SMENR1_LCDSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1SMENR1_LCDSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1SMENR1_TIM7SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM7SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1SMENR1_TIM6SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM6SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1SMENR1_TIM5SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM5SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1SMENR1_TIM4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1SMENR1_TIM3SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM3SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1SMENR1_TIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR1_TIM2SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1SMENR1_RTCAPBSMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1SMENR1_RTCAPBSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1SMENR1_CAN2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR1.Reg, volatile.LoadUint32(&o.APB1SMENR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1SMENR1_CAN2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR1.Reg) & 0x4000000) >> 26
}

// RCC.APB1SMENR2: APB1 peripheral clocks enable in Sleep and Stop modes register 2
func (o *RCC_Type) SetAPB1SMENR2_LPTIM2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1SMENR2_LPTIM2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1SMENR2_SWPMI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1SMENR2_SWPMI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1SMENR2_LPUART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1SMENR2_LPUART1SMEN() uint32 {
	return volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1SMENR2_I2C4SMEN(value uint32) {
	volatile.StoreUint32(&o.APB1SMENR2.Reg, volatile.LoadUint32(&o.APB1SMENR2.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1SMENR2_I2C4SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB1SMENR2.Reg) & 0x2) >> 1
}

// RCC.APB2SMENR: APB2SMENR
func (o *RCC_Type) SetAPB2SMENR_DFSDMSMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2SMENR_DFSDMSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2SMENR_SAI2SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2SMENR_SAI2SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2SMENR_SAI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2SMENR_SAI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2SMENR_TIM17SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2SMENR_TIM17SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2SMENR_TIM16SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2SMENR_TIM16SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2SMENR_TIM15SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2SMENR_TIM15SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2SMENR_USART1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2SMENR_USART1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2SMENR_TIM8SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2SMENR_TIM8SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2SMENR_SPI1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2SMENR_SPI1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2SMENR_TIM1SMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2SMENR_TIM1SMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2SMENR_SDMMCSMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2SMENR_SDMMCSMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2SMENR_SYSCFGSMEN(value uint32) {
	volatile.StoreUint32(&o.APB2SMENR.Reg, volatile.LoadUint32(&o.APB2SMENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2SMENR_SYSCFGSMEN() uint32 {
	return volatile.LoadUint32(&o.APB2SMENR.Reg) & 0x1
}

// RCC.CCIPR: CCIPR
func (o *RCC_Type) SetCCIPR_DFSDMSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCCIPR_DFSDMSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCCIPR_SWPMI1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCCIPR_SWPMI1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCCIPR_ADCSEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000000)|value<<28)
}
func (o *RCC_Type) GetCCIPR_ADCSEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000000) >> 28
}
func (o *RCC_Type) SetCCIPR_CLK48SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000000)|value<<26)
}
func (o *RCC_Type) GetCCIPR_CLK48SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000000) >> 26
}
func (o *RCC_Type) SetCCIPR_SAI2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000000)|value<<24)
}
func (o *RCC_Type) GetCCIPR_SAI2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000000) >> 24
}
func (o *RCC_Type) SetCCIPR_SAI1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetCCIPR_SAI1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetCCIPR_LPTIM2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetCCIPR_LPTIM2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetCCIPR_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetCCIPR_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetCCIPR_I2C3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetCCIPR_I2C3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetCCIPR_I2C2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetCCIPR_I2C2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetCCIPR_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetCCIPR_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetCCIPR_LPUART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetCCIPR_LPUART1SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetCCIPR_UART5SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetCCIPR_UART5SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetCCIPR_UART4SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc0)|value<<6)
}
func (o *RCC_Type) GetCCIPR_UART4SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc0) >> 6
}
func (o *RCC_Type) SetCCIPR_USART3SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetCCIPR_USART3SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetCCIPR_USART2SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCCIPR_USART2SEL() uint32 {
	return (volatile.LoadUint32(&o.CCIPR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCCIPR_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.CCIPR.Reg, volatile.LoadUint32(&o.CCIPR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCCIPR_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.CCIPR.Reg) & 0x3
}

// RCC.BDCR: BDCR
func (o *RCC_Type) SetBDCR_LSCOSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetBDCR_LSCOSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetBDCR_LSCOEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetBDCR_LSCOEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_LSECSSD(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetBDCR_LSECSSD() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetBDCR_LSECSSON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetBDCR_LSECSSON() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}

// RCC.CSR: CSR
func (o *RCC_Type) SetCSR_LPWRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_OBLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_OBLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_FIREWALLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_FIREWALLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCSR_MSISRANGE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xf00)|value<<8)
}
func (o *RCC_Type) GetCSR_MSISRANGE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xf00) >> 8
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.CRRCR: Clock recovery RC register
func (o *RCC_Type) SetCRRCR_HSI48CAL(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0xff80)|value<<7)
}
func (o *RCC_Type) GetCRRCR_HSI48CAL() uint32 {
	return (volatile.LoadUint32(&o.CRRCR.Reg) & 0xff80) >> 7
}
func (o *RCC_Type) SetCRRCR_HSI48RDY(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCRRCR_HSI48RDY() uint32 {
	return (volatile.LoadUint32(&o.CRRCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCRRCR_HSI48ON(value uint32) {
	volatile.StoreUint32(&o.CRRCR.Reg, volatile.LoadUint32(&o.CRRCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCRRCR_HSI48ON() uint32 {
	return volatile.LoadUint32(&o.CRRCR.Reg) & 0x1
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	PUCRE volatile.Register32 // 0x40
	PDCRE volatile.Register32 // 0x44
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
	PUCRG volatile.Register32 // 0x50
	PDCRG volatile.Register32 // 0x54
	PUCRH volatile.Register32 // 0x58
	PDCRH volatile.Register32 // 0x5C
}

// PWR.CR1: Power control register 1
func (o *PWR_Type) SetCR1_LPR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR1_LPR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x600)|value<<9)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x600) >> 9
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetCR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x7
}

// PWR.CR2: Power control register 2
func (o *PWR_Type) SetCR2_USV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR2_USV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR2_IOSV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR2_IOSV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR2_PVME4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetCR2_PVME4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetCR2_PVME3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetCR2_PVME3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetCR2_PVME2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR2_PVME2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR2_PVME1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_PVME1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_PLS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xe)|value<<1)
}
func (o *PWR_Type) GetCR2_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xe) >> 1
}
func (o *PWR_Type) SetCR2_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_PVDE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// PWR.CR3: Power control register 3
func (o *PWR_Type) SetCR3_EWF(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR3_EWF() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR3_APC(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR3_APC() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR3_RRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR3_RRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR3_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR3_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR3_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR3_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// PWR.CR4: Power control register 4
func (o *PWR_Type) SetCR4_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR4_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR4_VBE(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR4_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR4_WP5(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR4_WP5() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR4_WP4(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR4_WP4() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR4_WP3(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR4_WP3() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR4_WP2(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR4_WP2() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR4_WP1(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR4_WP1() uint32 {
	return volatile.LoadUint32(&o.CR4.Reg) & 0x1
}

// PWR.SR1: Power status register 1
func (o *PWR_Type) SetSR1_WUFI(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR1_WUFI() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR1_CSBF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR1_CSBF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR1_CWUF5(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSR1_CWUF5() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSR1_CWUF4(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSR1_CWUF4() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSR1_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR1_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR1_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR1_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR1_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR1_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// PWR.SR2: Power status register 2
func (o *PWR_Type) SetSR2_PVMO4(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR2_PVMO4() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR2_PVMO3(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR2_PVMO3() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR2_PVMO2(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetSR2_PVMO2() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetSR2_PVMO1(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR2_PVMO1() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR2_PVDO(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR2_PVDO() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR2_VOSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR2_VOSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR2_REGLPF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR2_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR2_REGLPS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR2_REGLPS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x100) >> 8
}

// PWR.SCR: Power status clear register
func (o *PWR_Type) SetSCR_SBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSCR_SBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSCR_WUF5(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSCR_WUF5() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSCR_WUF4(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSCR_WUF4() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSCR_WUF3(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSCR_WUF3() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSCR_WUF2(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSCR_WUF2() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSCR_WUF1(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSCR_WUF1() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// PWR.PUCRA: Power Port A pull-up control register
func (o *PWR_Type) SetPUCRA_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRA_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRA_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRA_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRA_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRA_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRA_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRA_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRA_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRA_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRA_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRA_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRA_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRA_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRA_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRA_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRA_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRA_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRA_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRA_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRA_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRA_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRA_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRA_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRA_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRA_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRA_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRA_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRA_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRA_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRA_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRA_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRA.Reg) & 0x1
}

// PWR.PDCRA: Power Port A pull-down control register
func (o *PWR_Type) SetPDCRA_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRA_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRA_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRA_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRA_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRA_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRA_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRA_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRA_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRA_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRA_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRA_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRA_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRA_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRA_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRA_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRA_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRA_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRA_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRA_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRA_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRA_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRA_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRA_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRA_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRA_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRA_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRA_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRA_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRA_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRA_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRA_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRA.Reg) & 0x1
}

// PWR.PUCRB: Power Port B pull-up control register
func (o *PWR_Type) SetPUCRB_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRB_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRB_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRB_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRB_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRB_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRB_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRB_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRB_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRB_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRB_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRB_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRB_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRB_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRB_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRB_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRB_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRB_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRB_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRB_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRB_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRB_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRB_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRB_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRB_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRB_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRB_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRB_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRB_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRB_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRB_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRB.Reg, volatile.LoadUint32(&o.PUCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRB_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRB.Reg) & 0x1
}

// PWR.PDCRB: Power Port B pull-down control register
func (o *PWR_Type) SetPDCRB_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRB_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRB_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRB_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRB_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRB_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRB_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRB_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRB_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRB_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRB_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRB_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRB_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRB_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRB_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRB_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRB_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRB_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRB_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRB_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRB_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRB_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRB_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRB_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRB_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRB_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRB_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRB_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRB_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRB_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRB.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRB_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRB.Reg, volatile.LoadUint32(&o.PDCRB.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRB_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRB.Reg) & 0x1
}

// PWR.PUCRC: Power Port C pull-up control register
func (o *PWR_Type) SetPUCRC_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRC_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRC_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRC_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRC_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRC_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRC_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRC_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRC_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRC_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRC_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRC_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRC_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRC_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRC_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRC_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRC_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRC_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRC_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRC_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRC_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRC_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRC_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRC_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRC_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRC_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRC_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRC_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRC_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRC_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRC_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRC.Reg, volatile.LoadUint32(&o.PUCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRC_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRC.Reg) & 0x1
}

// PWR.PDCRC: Power Port C pull-down control register
func (o *PWR_Type) SetPDCRC_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRC_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRC_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRC_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRC_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRC_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRC_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRC_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRC_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRC_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRC_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRC_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRC_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRC_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRC_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRC_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRC_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRC_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRC_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRC_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRC_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRC_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRC_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRC_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRC_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRC_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRC_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRC_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRC_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRC_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRC.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRC_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRC.Reg, volatile.LoadUint32(&o.PDCRC.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRC_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRC.Reg) & 0x1
}

// PWR.PUCRD: Power Port D pull-up control register
func (o *PWR_Type) SetPUCRD_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRD_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRD_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRD_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRD_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRD_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRD_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRD_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRD_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRD_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRD_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRD_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRD_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRD_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRD_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRD_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRD_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRD_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRD_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRD_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRD_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRD_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRD_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRD_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRD_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRD_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRD_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRD_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRD_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRD_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRD_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRD.Reg, volatile.LoadUint32(&o.PUCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRD_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRD.Reg) & 0x1
}

// PWR.PDCRD: Power Port D pull-down control register
func (o *PWR_Type) SetPDCRD_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRD_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRD_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRD_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRD_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRD_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRD_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRD_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRD_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRD_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRD_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRD_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRD_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRD_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRD_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRD_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRD_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRD_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRD_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRD_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRD_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRD_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRD_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRD_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRD_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRD_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRD_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRD_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRD_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRD_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRD.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRD_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRD.Reg, volatile.LoadUint32(&o.PDCRD.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRD_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRD.Reg) & 0x1
}

// PWR.PUCRE: Power Port E pull-up control register
func (o *PWR_Type) SetPUCRE_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRE_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRE_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRE_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRE_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRE_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRE_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRE_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRE_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRE_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRE_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRE_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRE_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRE_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRE_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRE_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRE_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRE_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRE_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRE_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRE_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRE_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRE_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRE_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRE_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRE_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRE_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRE_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRE_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRE_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRE_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRE.Reg, volatile.LoadUint32(&o.PUCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRE_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRE.Reg) & 0x1
}

// PWR.PDCRE: Power Port E pull-down control register
func (o *PWR_Type) SetPDCRE_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRE_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRE_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRE_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRE_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRE_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRE_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRE_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRE_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRE_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRE_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRE_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRE_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRE_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRE_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRE_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRE_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRE_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRE_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRE_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRE_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRE_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRE_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRE_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRE_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRE_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRE_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRE_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRE_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRE_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRE.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRE_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRE.Reg, volatile.LoadUint32(&o.PDCRE.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRE_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRE.Reg) & 0x1
}

// PWR.PUCRF: Power Port F pull-up control register
func (o *PWR_Type) SetPUCRF_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRF_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRF_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRF_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRF_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRF_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRF_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRF_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRF_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRF_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRF_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRF_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRF_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRF_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRF_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRF_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRF_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRF_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRF_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRF_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRF_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRF_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRF_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRF_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRF_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRF_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRF_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRF_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRF_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRF_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRF.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRF_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRF.Reg, volatile.LoadUint32(&o.PUCRF.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRF_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRF.Reg) & 0x1
}

// PWR.PDCRF: Power Port F pull-down control register
func (o *PWR_Type) SetPDCRF_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRF_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRF_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRF_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRF_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRF_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRF_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRF_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRF_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRF_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRF_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRF_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRF_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRF_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRF_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRF_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRF_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRF_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRF_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRF_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRF_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRF_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRF_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRF_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRF_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRF_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRF_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRF_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRF_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRF_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRF.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRF_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRF.Reg, volatile.LoadUint32(&o.PDCRF.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRF_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRF.Reg) & 0x1
}

// PWR.PUCRG: Power Port G pull-up control register
func (o *PWR_Type) SetPUCRG_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRG_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRG_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRG_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRG_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRG_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRG_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRG_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRG_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRG_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRG_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRG_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRG_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRG_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRG_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRG_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRG_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRG_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRG_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRG_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRG_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRG_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRG_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRG_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRG_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRG_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRG_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRG_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRG_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRG_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRG.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRG_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRG.Reg, volatile.LoadUint32(&o.PUCRG.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRG_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRG.Reg) & 0x1
}

// PWR.PDCRG: Power Port G pull-down control register
func (o *PWR_Type) SetPDCRG_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRG_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRG_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPDCRG_PD14() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPDCRG_PD13(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPDCRG_PD13() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPDCRG_PD12(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPDCRG_PD12() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPDCRG_PD11(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPDCRG_PD11() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPDCRG_PD10(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPDCRG_PD10() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPDCRG_PD9(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPDCRG_PD9() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPDCRG_PD8(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPDCRG_PD8() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPDCRG_PD7(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPDCRG_PD7() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPDCRG_PD6(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPDCRG_PD6() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPDCRG_PD5(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPDCRG_PD5() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPDCRG_PD4(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPDCRG_PD4() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPDCRG_PD3(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPDCRG_PD3() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPDCRG_PD2(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPDCRG_PD2() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPDCRG_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRG_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRG.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRG_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRG.Reg, volatile.LoadUint32(&o.PDCRG.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRG_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRG.Reg) & 0x1
}

// PWR.PUCRH: Power Port H pull-up control register
func (o *PWR_Type) SetPUCRH_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRH.Reg, volatile.LoadUint32(&o.PUCRH.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRH_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRH.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRH_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRH.Reg, volatile.LoadUint32(&o.PUCRH.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRH_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRH.Reg) & 0x1
}

// PWR.PDCRH: Power Port H pull-down control register
func (o *PWR_Type) SetPDCRH_PD1(value uint32) {
	volatile.StoreUint32(&o.PDCRH.Reg, volatile.LoadUint32(&o.PDCRH.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPDCRH_PD1() uint32 {
	return (volatile.LoadUint32(&o.PDCRH.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPDCRH_PD0(value uint32) {
	volatile.StoreUint32(&o.PDCRH.Reg, volatile.LoadUint32(&o.PDCRH.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPDCRH_PD0() uint32 {
	return volatile.LoadUint32(&o.PDCRH.Reg) & 0x1
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
}

// SYSCFG.MEMRMP: memory remap register
func (o *SYSCFG_Type) SetMEMRMP_FB_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetMEMRMP_FB_MODE() uint32 {
	return (volatile.LoadUint32(&o.MEMRMP.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetMEMRMP_QFS(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetMEMRMP_QFS() uint32 {
	return (volatile.LoadUint32(&o.MEMRMP.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetMEMRMP_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x7
}

// SYSCFG.CFGR1: configuration register 1
func (o *SYSCFG_Type) SetCFGR1_FPU_IE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xfc000000) >> 26
}
func (o *SYSCFG_Type) SetCFGR1_I2C3_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetCFGR1_I2C3_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetCFGR1_I2C2_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetCFGR1_I2C2_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetCFGR1_I2C1_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetCFGR1_I2C1_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB9_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB9_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB8_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB8_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB7_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB7_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB6_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB6_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetCFGR1_BOOSTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR1_BOOSTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCFGR1_FWDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCFGR1_FWDIS() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x1
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0x7
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0x7
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0x7
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x7000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x700)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x700) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x70)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0x70) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0x7)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0x7
}

// SYSCFG.SCSR: SCSR
func (o *SYSCFG_Type) SetSCSR_SRAM2BSY(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSCSR_SRAM2BSY() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSCSR_SRAM2ER(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSCSR_SRAM2ER() uint32 {
	return volatile.LoadUint32(&o.SCSR.Reg) & 0x1
}

// SYSCFG.CFGR2: CFGR2
func (o *SYSCFG_Type) SetCFGR2_SPF(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCFGR2_SPF() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCFGR2_ECCL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetCFGR2_ECCL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetCFGR2_PVDL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetCFGR2_PVDL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetCFGR2_SPL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetCFGR2_SPL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetCFGR2_CLL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCFGR2_CLL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}

// SYSCFG.SWPR: SWPR
func (o *SYSCFG_Type) SetSWPR_P31WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetSWPR_P31WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000000) >> 31
}
func (o *SYSCFG_Type) SetSWPR_P30WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetSWPR_P30WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetSWPR_P29WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetSWPR_P29WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetSWPR_P28WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetSWPR_P28WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetSWPR_P27WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetSWPR_P27WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetSWPR_P26WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetSWPR_P26WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetSWPR_P25WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCFG_Type) GetSWPR_P25WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000000) >> 25
}
func (o *SYSCFG_Type) SetSWPR_P24WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetSWPR_P24WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000000) >> 24
}
func (o *SYSCFG_Type) SetSWPR_P23WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetSWPR_P23WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetSWPR_P22WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCFG_Type) GetSWPR_P22WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400000) >> 22
}
func (o *SYSCFG_Type) SetSWPR_P21WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetSWPR_P21WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetSWPR_P20WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetSWPR_P20WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetSWPR_P19WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetSWPR_P19WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetSWPR_P18WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetSWPR_P18WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetSWPR_P17WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetSWPR_P17WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetSWPR_P16WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetSWPR_P16WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetSWPR_P15WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCFG_Type) GetSWPR_P15WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8000) >> 15
}
func (o *SYSCFG_Type) SetSWPR_P14WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCFG_Type) GetSWPR_P14WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4000) >> 14
}
func (o *SYSCFG_Type) SetSWPR_P13WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetSWPR_P13WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetSWPR_P12WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetSWPR_P12WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetSWPR_P11WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetSWPR_P11WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetSWPR_P10WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x400)|value<<10)
}
func (o *SYSCFG_Type) GetSWPR_P10WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x400) >> 10
}
func (o *SYSCFG_Type) SetSWPR_P9WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCFG_Type) GetSWPR_P9WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x200) >> 9
}
func (o *SYSCFG_Type) SetSWPR_P8WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetSWPR_P8WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetSWPR_P7WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetSWPR_P7WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetSWPR_P6WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetSWPR_P6WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetSWPR_P5WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetSWPR_P5WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetSWPR_P4WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetSWPR_P4WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetSWPR_P3WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetSWPR_P3WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetSWPR_P2WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetSWPR_P2WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetSWPR_P1WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetSWPR_P1WP() uint32 {
	return (volatile.LoadUint32(&o.SWPR.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetSWPR_P0WP(value uint32) {
	volatile.StoreUint32(&o.SWPR.Reg, volatile.LoadUint32(&o.SWPR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetSWPR_P0WP() uint32 {
	return volatile.LoadUint32(&o.SWPR.Reg) & 0x1
}

// SYSCFG.SKR: SKR
func (o *SYSCFG_Type) SetSKR_KEY(value uint32) {
	volatile.StoreUint32(&o.SKR.Reg, volatile.LoadUint32(&o.SKR.Reg)&^(0xff)|value)
}
func (o *SYSCFG_Type) GetSKR_KEY() uint32 {
	return volatile.LoadUint32(&o.SKR.Reg) & 0xff
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	CHCFG0R1       volatile.Register32 // 0x0
	CHCFG0R2       volatile.Register32 // 0x4
	AWSCD0R        volatile.Register32 // 0x8
	CHWDAT0R       volatile.Register32 // 0xC
	CHDATIN0R      volatile.Register32 // 0x10
	_              [12]byte
	CHCFG1R1       volatile.Register32 // 0x20
	CHCFG1R2       volatile.Register32 // 0x24
	AWSCD1R        volatile.Register32 // 0x28
	CHWDAT1R       volatile.Register32 // 0x2C
	CHDATIN1R      volatile.Register32 // 0x30
	_              [12]byte
	CHCFG2R1       volatile.Register32 // 0x40
	CHCFG2R2       volatile.Register32 // 0x44
	AWSCD2R        volatile.Register32 // 0x48
	CHWDAT2R       volatile.Register32 // 0x4C
	CHDATIN2R      volatile.Register32 // 0x50
	_              [12]byte
	CHCFG3R1       volatile.Register32 // 0x60
	CHCFG3R2       volatile.Register32 // 0x64
	AWSCD3R        volatile.Register32 // 0x68
	CHWDAT3R       volatile.Register32 // 0x6C
	CHDATIN3R      volatile.Register32 // 0x70
	_              [12]byte
	CHCFG4R1       volatile.Register32 // 0x80
	CHCFG4R2       volatile.Register32 // 0x84
	AWSCD4R        volatile.Register32 // 0x88
	CHWDAT4R       volatile.Register32 // 0x8C
	CHDATIN4R      volatile.Register32 // 0x90
	_              [12]byte
	CHCFG5R1       volatile.Register32 // 0xA0
	CHCFG5R2       volatile.Register32 // 0xA4
	AWSCD5R        volatile.Register32 // 0xA8
	CHWDAT5R       volatile.Register32 // 0xAC
	CHDATIN5R      volatile.Register32 // 0xB0
	_              [12]byte
	CHCFG6R1       volatile.Register32 // 0xC0
	CHCFG6R2       volatile.Register32 // 0xC4
	AWSCD6R        volatile.Register32 // 0xC8
	CHWDAT6R       volatile.Register32 // 0xCC
	CHDATIN6R      volatile.Register32 // 0xD0
	_              [12]byte
	CHCFG7R1       volatile.Register32 // 0xE0
	CHCFG7R2       volatile.Register32 // 0xE4
	AWSCD7R        volatile.Register32 // 0xE8
	CHWDAT7R       volatile.Register32 // 0xEC
	CHDATIN7R      volatile.Register32 // 0xF0
	_              [12]byte
	DFSDM0_CR1     volatile.Register32 // 0x100
	DFSDM0_CR2     volatile.Register32 // 0x104
	DFSDM0_ISR     volatile.Register32 // 0x108
	DFSDM0_ICR     volatile.Register32 // 0x10C
	DFSDM0_JCHGR   volatile.Register32 // 0x110
	DFSDM0_FCR     volatile.Register32 // 0x114
	DFSDM0_JDATAR  volatile.Register32 // 0x118
	DFSDM0_RDATAR  volatile.Register32 // 0x11C
	DFSDM0_AWHTR   volatile.Register32 // 0x120
	DFSDM0_AWLTR   volatile.Register32 // 0x124
	DFSDM0_AWSR    volatile.Register32 // 0x128
	DFSDM0_AWCFR   volatile.Register32 // 0x12C
	DFSDM0_EXMAX   volatile.Register32 // 0x130
	DFSDM0_EXMIN   volatile.Register32 // 0x134
	DFSDM0_CNVTIMR volatile.Register32 // 0x138
	_              [196]byte
	CR1            volatile.Register32 // 0x200
	CR2            volatile.Register32 // 0x204
	ISR            volatile.Register32 // 0x208
	ICR            volatile.Register32 // 0x20C
	JCHGR          volatile.Register32 // 0x210
	FCR            volatile.Register32 // 0x214
	JDATAR         volatile.Register32 // 0x218
	RDATAR         volatile.Register32 // 0x21C
	AWHTR          volatile.Register32 // 0x220
	AWLTR          volatile.Register32 // 0x224
	AWSR           volatile.Register32 // 0x228
	AWCFR          volatile.Register32 // 0x22C
	EXMAX          volatile.Register32 // 0x230
	EXMIN          volatile.Register32 // 0x234
	CNVTIMR        volatile.Register32 // 0x238
	_              [196]byte
	DFSDM2_CR1     volatile.Register32 // 0x300
	DFSDM2_CR2     volatile.Register32 // 0x304
	DFSDM2_ISR     volatile.Register32 // 0x308
	DFSDM2_ICR     volatile.Register32 // 0x30C
	DFSDM2_JCHGR   volatile.Register32 // 0x310
	DFSDM2_FCR     volatile.Register32 // 0x314
	DFSDM2_JDATAR  volatile.Register32 // 0x318
	DFSDM2_RDATAR  volatile.Register32 // 0x31C
	DFSDM2_AWHTR   volatile.Register32 // 0x320
	DFSDM2_AWLTR   volatile.Register32 // 0x324
	DFSDM2_AWSR    volatile.Register32 // 0x328
	DFSDM2_AWCFR   volatile.Register32 // 0x32C
	DFSDM2_EXMAX   volatile.Register32 // 0x330
	DFSDM2_EXMIN   volatile.Register32 // 0x334
	DFSDM2_CNVTIMR volatile.Register32 // 0x338
	_              [196]byte
	DFSDM3_CR1     volatile.Register32 // 0x400
	DFSDM3_CR2     volatile.Register32 // 0x404
	DFSDM3_ISR     volatile.Register32 // 0x408
	DFSDM3_ICR     volatile.Register32 // 0x40C
	DFSDM3_JCHGR   volatile.Register32 // 0x410
	DFSDM3_FCR     volatile.Register32 // 0x414
	DFSDM3_JDATAR  volatile.Register32 // 0x418
	DFSDM3_RDATAR  volatile.Register32 // 0x41C
	DFSDM3_AWHTR   volatile.Register32 // 0x420
	DFSDM3_AWLTR   volatile.Register32 // 0x424
	DFSDM3_AWSR    volatile.Register32 // 0x428
	DFSDM3_AWCFR   volatile.Register32 // 0x42C
	DFSDM3_EXMAX   volatile.Register32 // 0x430
	DFSDM3_EXMIN   volatile.Register32 // 0x434
	DFSDM3_CNVTIMR volatile.Register32 // 0x438
}

// DFSDM.CHCFG0R1: channel configuration y register
func (o *DFSDM_Type) SetCHCFG0R1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCHCFG0R1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x80000000) >> 31
}
func (o *DFSDM_Type) SetCHCFG0R1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCHCFG0R1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCHCFG0R1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHCFG0R1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCHCFG0R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG0R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG0R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG0R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG0R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG0R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG0R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG0R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG0R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG0R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG0R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG0R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG0R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG0R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG0R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R1.Reg, volatile.LoadUint32(&o.CHCFG0R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG0R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG0R1.Reg) & 0x3
}

// DFSDM.CHCFG0R2: channel configuration y register
func (o *DFSDM_Type) SetCHCFG0R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R2.Reg, volatile.LoadUint32(&o.CHCFG0R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG0R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG0R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG0R2.Reg, volatile.LoadUint32(&o.CHCFG0R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG0R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG0R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD0R: analog watchdog and short-circuit detector register
func (o *DFSDM_Type) SetAWSCD0R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD0R.Reg, volatile.LoadUint32(&o.AWSCD0R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD0R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD0R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD0R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD0R.Reg, volatile.LoadUint32(&o.AWSCD0R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD0R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD0R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD0R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD0R.Reg, volatile.LoadUint32(&o.AWSCD0R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD0R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD0R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD0R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD0R.Reg, volatile.LoadUint32(&o.AWSCD0R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD0R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD0R.Reg) & 0xff
}

// DFSDM.CHWDAT0R: channel watchdog filter data register
func (o *DFSDM_Type) SetCHWDAT0R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT0R.Reg, volatile.LoadUint32(&o.CHWDAT0R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT0R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT0R.Reg) & 0xffff
}

// DFSDM.CHDATIN0R: channel data input register
func (o *DFSDM_Type) SetCHDATIN0R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN0R.Reg, volatile.LoadUint32(&o.CHDATIN0R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN0R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN0R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN0R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN0R.Reg, volatile.LoadUint32(&o.CHDATIN0R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN0R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN0R.Reg) & 0xffff
}

// DFSDM.CHCFG1R1: CHCFG1R1
func (o *DFSDM_Type) SetCHCFG1R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG1R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG1R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG1R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG1R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG1R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG1R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG1R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG1R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG1R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG1R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG1R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG1R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG1R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG1R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R1.Reg, volatile.LoadUint32(&o.CHCFG1R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG1R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG1R1.Reg) & 0x3
}

// DFSDM.CHCFG1R2: CHCFG1R2
func (o *DFSDM_Type) SetCHCFG1R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R2.Reg, volatile.LoadUint32(&o.CHCFG1R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG1R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG1R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG1R2.Reg, volatile.LoadUint32(&o.CHCFG1R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG1R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG1R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD1R: AWSCD1R
func (o *DFSDM_Type) SetAWSCD1R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD1R.Reg, volatile.LoadUint32(&o.AWSCD1R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD1R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD1R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD1R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD1R.Reg, volatile.LoadUint32(&o.AWSCD1R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD1R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD1R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD1R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD1R.Reg, volatile.LoadUint32(&o.AWSCD1R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD1R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD1R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD1R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD1R.Reg, volatile.LoadUint32(&o.AWSCD1R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD1R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD1R.Reg) & 0xff
}

// DFSDM.CHWDAT1R: CHWDAT1R
func (o *DFSDM_Type) SetCHWDAT1R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT1R.Reg, volatile.LoadUint32(&o.CHWDAT1R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT1R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT1R.Reg) & 0xffff
}

// DFSDM.CHDATIN1R: CHDATIN1R
func (o *DFSDM_Type) SetCHDATIN1R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN1R.Reg, volatile.LoadUint32(&o.CHDATIN1R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN1R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN1R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN1R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN1R.Reg, volatile.LoadUint32(&o.CHDATIN1R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN1R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN1R.Reg) & 0xffff
}

// DFSDM.CHCFG2R1: CHCFG2R1
func (o *DFSDM_Type) SetCHCFG2R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG2R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG2R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG2R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG2R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG2R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG2R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG2R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG2R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG2R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG2R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG2R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG2R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG2R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG2R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R1.Reg, volatile.LoadUint32(&o.CHCFG2R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG2R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG2R1.Reg) & 0x3
}

// DFSDM.CHCFG2R2: CHCFG2R2
func (o *DFSDM_Type) SetCHCFG2R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R2.Reg, volatile.LoadUint32(&o.CHCFG2R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG2R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG2R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG2R2.Reg, volatile.LoadUint32(&o.CHCFG2R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG2R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG2R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD2R: AWSCD2R
func (o *DFSDM_Type) SetAWSCD2R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD2R.Reg, volatile.LoadUint32(&o.AWSCD2R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD2R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD2R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD2R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD2R.Reg, volatile.LoadUint32(&o.AWSCD2R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD2R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD2R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD2R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD2R.Reg, volatile.LoadUint32(&o.AWSCD2R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD2R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD2R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD2R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD2R.Reg, volatile.LoadUint32(&o.AWSCD2R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD2R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD2R.Reg) & 0xff
}

// DFSDM.CHWDAT2R: CHWDAT2R
func (o *DFSDM_Type) SetCHWDAT2R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT2R.Reg, volatile.LoadUint32(&o.CHWDAT2R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT2R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT2R.Reg) & 0xffff
}

// DFSDM.CHDATIN2R: CHDATIN2R
func (o *DFSDM_Type) SetCHDATIN2R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN2R.Reg, volatile.LoadUint32(&o.CHDATIN2R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN2R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN2R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN2R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN2R.Reg, volatile.LoadUint32(&o.CHDATIN2R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN2R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN2R.Reg) & 0xffff
}

// DFSDM.CHCFG3R1: CHCFG3R1
func (o *DFSDM_Type) SetCHCFG3R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG3R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG3R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG3R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG3R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG3R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG3R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG3R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG3R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG3R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG3R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG3R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG3R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG3R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG3R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R1.Reg, volatile.LoadUint32(&o.CHCFG3R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG3R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG3R1.Reg) & 0x3
}

// DFSDM.CHCFG3R2: CHCFG3R2
func (o *DFSDM_Type) SetCHCFG3R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R2.Reg, volatile.LoadUint32(&o.CHCFG3R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG3R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG3R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG3R2.Reg, volatile.LoadUint32(&o.CHCFG3R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG3R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG3R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD3R: AWSCD3R
func (o *DFSDM_Type) SetAWSCD3R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD3R.Reg, volatile.LoadUint32(&o.AWSCD3R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD3R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD3R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD3R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD3R.Reg, volatile.LoadUint32(&o.AWSCD3R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD3R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD3R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD3R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD3R.Reg, volatile.LoadUint32(&o.AWSCD3R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD3R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD3R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD3R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD3R.Reg, volatile.LoadUint32(&o.AWSCD3R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD3R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD3R.Reg) & 0xff
}

// DFSDM.CHWDAT3R: CHWDAT3R
func (o *DFSDM_Type) SetCHWDAT3R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT3R.Reg, volatile.LoadUint32(&o.CHWDAT3R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT3R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT3R.Reg) & 0xffff
}

// DFSDM.CHDATIN3R: CHDATIN3R
func (o *DFSDM_Type) SetCHDATIN3R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN3R.Reg, volatile.LoadUint32(&o.CHDATIN3R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN3R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN3R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN3R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN3R.Reg, volatile.LoadUint32(&o.CHDATIN3R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN3R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN3R.Reg) & 0xffff
}

// DFSDM.CHCFG4R1: CHCFG4R1
func (o *DFSDM_Type) SetCHCFG4R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG4R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG4R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG4R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG4R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG4R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG4R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG4R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG4R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG4R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG4R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG4R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG4R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG4R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG4R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R1.Reg, volatile.LoadUint32(&o.CHCFG4R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG4R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG4R1.Reg) & 0x3
}

// DFSDM.CHCFG4R2: CHCFG4R2
func (o *DFSDM_Type) SetCHCFG4R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R2.Reg, volatile.LoadUint32(&o.CHCFG4R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG4R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG4R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG4R2.Reg, volatile.LoadUint32(&o.CHCFG4R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG4R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG4R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD4R: AWSCD4R
func (o *DFSDM_Type) SetAWSCD4R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD4R.Reg, volatile.LoadUint32(&o.AWSCD4R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD4R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD4R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD4R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD4R.Reg, volatile.LoadUint32(&o.AWSCD4R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD4R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD4R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD4R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD4R.Reg, volatile.LoadUint32(&o.AWSCD4R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD4R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD4R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD4R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD4R.Reg, volatile.LoadUint32(&o.AWSCD4R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD4R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD4R.Reg) & 0xff
}

// DFSDM.CHWDAT4R: CHWDAT4R
func (o *DFSDM_Type) SetCHWDAT4R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT4R.Reg, volatile.LoadUint32(&o.CHWDAT4R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT4R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT4R.Reg) & 0xffff
}

// DFSDM.CHDATIN4R: CHDATIN4R
func (o *DFSDM_Type) SetCHDATIN4R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN4R.Reg, volatile.LoadUint32(&o.CHDATIN4R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN4R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN4R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN4R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN4R.Reg, volatile.LoadUint32(&o.CHDATIN4R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN4R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN4R.Reg) & 0xffff
}

// DFSDM.CHCFG5R1: CHCFG5R1
func (o *DFSDM_Type) SetCHCFG5R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG5R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG5R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG5R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG5R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG5R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG5R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG5R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG5R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG5R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG5R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG5R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG5R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG5R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG5R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R1.Reg, volatile.LoadUint32(&o.CHCFG5R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG5R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG5R1.Reg) & 0x3
}

// DFSDM.CHCFG5R2: CHCFG5R2
func (o *DFSDM_Type) SetCHCFG5R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R2.Reg, volatile.LoadUint32(&o.CHCFG5R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG5R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG5R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG5R2.Reg, volatile.LoadUint32(&o.CHCFG5R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG5R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG5R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD5R: AWSCD5R
func (o *DFSDM_Type) SetAWSCD5R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD5R.Reg, volatile.LoadUint32(&o.AWSCD5R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD5R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD5R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD5R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD5R.Reg, volatile.LoadUint32(&o.AWSCD5R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD5R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD5R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD5R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD5R.Reg, volatile.LoadUint32(&o.AWSCD5R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD5R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD5R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD5R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD5R.Reg, volatile.LoadUint32(&o.AWSCD5R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD5R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD5R.Reg) & 0xff
}

// DFSDM.CHWDAT5R: CHWDAT5R
func (o *DFSDM_Type) SetCHWDAT5R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT5R.Reg, volatile.LoadUint32(&o.CHWDAT5R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT5R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT5R.Reg) & 0xffff
}

// DFSDM.CHDATIN5R: CHDATIN5R
func (o *DFSDM_Type) SetCHDATIN5R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN5R.Reg, volatile.LoadUint32(&o.CHDATIN5R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN5R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN5R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN5R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN5R.Reg, volatile.LoadUint32(&o.CHDATIN5R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN5R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN5R.Reg) & 0xffff
}

// DFSDM.CHCFG6R1: CHCFG6R1
func (o *DFSDM_Type) SetCHCFG6R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG6R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG6R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG6R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG6R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG6R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG6R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG6R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG6R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG6R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG6R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG6R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG6R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG6R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG6R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R1.Reg, volatile.LoadUint32(&o.CHCFG6R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG6R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG6R1.Reg) & 0x3
}

// DFSDM.CHCFG6R2: CHCFG6R2
func (o *DFSDM_Type) SetCHCFG6R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R2.Reg, volatile.LoadUint32(&o.CHCFG6R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG6R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG6R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG6R2.Reg, volatile.LoadUint32(&o.CHCFG6R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG6R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG6R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD6R: AWSCD6R
func (o *DFSDM_Type) SetAWSCD6R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD6R.Reg, volatile.LoadUint32(&o.AWSCD6R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD6R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD6R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD6R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD6R.Reg, volatile.LoadUint32(&o.AWSCD6R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD6R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD6R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD6R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD6R.Reg, volatile.LoadUint32(&o.AWSCD6R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD6R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD6R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD6R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD6R.Reg, volatile.LoadUint32(&o.AWSCD6R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD6R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD6R.Reg) & 0xff
}

// DFSDM.CHWDAT6R: CHWDAT6R
func (o *DFSDM_Type) SetCHWDAT6R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT6R.Reg, volatile.LoadUint32(&o.CHWDAT6R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT6R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT6R.Reg) & 0xffff
}

// DFSDM.CHDATIN6R: CHDATIN6R
func (o *DFSDM_Type) SetCHDATIN6R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN6R.Reg, volatile.LoadUint32(&o.CHDATIN6R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN6R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN6R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN6R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN6R.Reg, volatile.LoadUint32(&o.CHDATIN6R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN6R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN6R.Reg) & 0xffff
}

// DFSDM.CHCFG7R1: CHCFG7R1
func (o *DFSDM_Type) SetCHCFG7R1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCHCFG7R1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCHCFG7R1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCHCFG7R1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCHCFG7R1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG7R1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCHCFG7R1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCHCFG7R1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCHCFG7R1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCHCFG7R1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCHCFG7R1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCHCFG7R1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCHCFG7R1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCHCFG7R1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCHCFG7R1_SITP(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R1.Reg, volatile.LoadUint32(&o.CHCFG7R1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCHCFG7R1_SITP() uint32 {
	return volatile.LoadUint32(&o.CHCFG7R1.Reg) & 0x3
}

// DFSDM.CHCFG7R2: CHCFG7R2
func (o *DFSDM_Type) SetCHCFG7R2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R2.Reg, volatile.LoadUint32(&o.CHCFG7R2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCHCFG7R2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCHCFG7R2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CHCFG7R2.Reg, volatile.LoadUint32(&o.CHCFG7R2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCHCFG7R2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CHCFG7R2.Reg) & 0xf8) >> 3
}

// DFSDM.AWSCD7R: AWSCD7R
func (o *DFSDM_Type) SetAWSCD7R_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCD7R.Reg, volatile.LoadUint32(&o.AWSCD7R.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetAWSCD7R_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD7R.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetAWSCD7R_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCD7R.Reg, volatile.LoadUint32(&o.AWSCD7R.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetAWSCD7R_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCD7R.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetAWSCD7R_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCD7R.Reg, volatile.LoadUint32(&o.AWSCD7R.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetAWSCD7R_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCD7R.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetAWSCD7R_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCD7R.Reg, volatile.LoadUint32(&o.AWSCD7R.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSCD7R_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCD7R.Reg) & 0xff
}

// DFSDM.CHWDAT7R: CHWDAT7R
func (o *DFSDM_Type) SetCHWDAT7R_WDATA(value uint32) {
	volatile.StoreUint32(&o.CHWDAT7R.Reg, volatile.LoadUint32(&o.CHWDAT7R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHWDAT7R_WDATA() uint32 {
	return volatile.LoadUint32(&o.CHWDAT7R.Reg) & 0xffff
}

// DFSDM.CHDATIN7R: CHDATIN7R
func (o *DFSDM_Type) SetCHDATIN7R_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CHDATIN7R.Reg, volatile.LoadUint32(&o.CHDATIN7R.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCHDATIN7R_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CHDATIN7R.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCHDATIN7R_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CHDATIN7R.Reg, volatile.LoadUint32(&o.CHDATIN7R.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCHDATIN7R_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CHDATIN7R.Reg) & 0xffff
}

// DFSDM.DFSDM0_CR1: control register 1
func (o *DFSDM_Type) SetDFSDM0_CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetDFSDM0_CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetDFSDM0_CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM0_CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetDFSDM0_CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetDFSDM0_CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetDFSDM0_CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetDFSDM0_CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetDFSDM0_CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetDFSDM0_CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM0_CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM0_CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM0_CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR1.Reg, volatile.LoadUint32(&o.DFSDM0_CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM0_CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_CR1.Reg) & 0x1
}

// DFSDM.DFSDM0_CR2: control register 2
func (o *DFSDM_Type) SetDFSDM0_CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM0_CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetDFSDM0_CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetDFSDM0_CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM0_CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM0_CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetDFSDM0_CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM0_CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CR2.Reg, volatile.LoadUint32(&o.DFSDM0_CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM0_CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_CR2.Reg) & 0x1
}

// DFSDM.DFSDM0_ISR: interrupt and status register
func (o *DFSDM_Type) SetDFSDM0_ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM0_ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM0_ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetDFSDM0_ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetDFSDM0_ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM0_ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM0_ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetDFSDM0_ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM0_ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ISR.Reg, volatile.LoadUint32(&o.DFSDM0_ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM0_ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_ISR.Reg) & 0x1
}

// DFSDM.DFSDM0_ICR: interrupt flag clear register
func (o *DFSDM_Type) SetDFSDM0_ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ICR.Reg, volatile.LoadUint32(&o.DFSDM0_ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM0_ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM0_ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ICR.Reg, volatile.LoadUint32(&o.DFSDM0_ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM0_ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM0_ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ICR.Reg, volatile.LoadUint32(&o.DFSDM0_ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM0_ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM0_ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_ICR.Reg, volatile.LoadUint32(&o.DFSDM0_ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM0_ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_ICR.Reg) & 0x4) >> 2
}

// DFSDM.DFSDM0_JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetDFSDM0_JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_JCHGR.Reg, volatile.LoadUint32(&o.DFSDM0_JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM0_JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_JCHGR.Reg) & 0xff
}

// DFSDM.DFSDM0_FCR: filter control register
func (o *DFSDM_Type) SetDFSDM0_FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_FCR.Reg, volatile.LoadUint32(&o.DFSDM0_FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetDFSDM0_FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetDFSDM0_FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_FCR.Reg, volatile.LoadUint32(&o.DFSDM0_FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM0_FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM0_FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_FCR.Reg, volatile.LoadUint32(&o.DFSDM0_FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM0_FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_FCR.Reg) & 0xff
}

// DFSDM.DFSDM0_JDATAR: data register for injected group
func (o *DFSDM_Type) SetDFSDM0_JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_JDATAR.Reg, volatile.LoadUint32(&o.DFSDM0_JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_JDATAR.Reg, volatile.LoadUint32(&o.DFSDM0_JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM0_JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_JDATAR.Reg) & 0x7
}

// DFSDM.DFSDM0_RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetDFSDM0_RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM0_RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM0_RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM0_RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM0_RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM0_RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM0_RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_RDATAR.Reg) & 0x7
}

// DFSDM.DFSDM0_AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetDFSDM0_AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWHTR.Reg, volatile.LoadUint32(&o.DFSDM0_AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWHTR.Reg, volatile.LoadUint32(&o.DFSDM0_AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetDFSDM0_AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_AWHTR.Reg) & 0xf
}

// DFSDM.DFSDM0_AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetDFSDM0_AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWLTR.Reg, volatile.LoadUint32(&o.DFSDM0_AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWLTR.Reg, volatile.LoadUint32(&o.DFSDM0_AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetDFSDM0_AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_AWLTR.Reg) & 0xf
}

// DFSDM.DFSDM0_AWSR: analog watchdog status register
func (o *DFSDM_Type) SetDFSDM0_AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWSR.Reg, volatile.LoadUint32(&o.DFSDM0_AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWSR.Reg, volatile.LoadUint32(&o.DFSDM0_AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM0_AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_AWSR.Reg) & 0xff
}

// DFSDM.DFSDM0_AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetDFSDM0_AWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWCFR.Reg, volatile.LoadUint32(&o.DFSDM0_AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_AWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_AWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_AWCFR.Reg, volatile.LoadUint32(&o.DFSDM0_AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM0_AWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_AWCFR.Reg) & 0xff
}

// DFSDM.DFSDM0_EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetDFSDM0_EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_EXMAX.Reg, volatile.LoadUint32(&o.DFSDM0_EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_EXMAX.Reg, volatile.LoadUint32(&o.DFSDM0_EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM0_EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_EXMAX.Reg) & 0x7
}

// DFSDM.DFSDM0_EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetDFSDM0_EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_EXMIN.Reg, volatile.LoadUint32(&o.DFSDM0_EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM0_EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM0_EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_EXMIN.Reg, volatile.LoadUint32(&o.DFSDM0_EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM0_EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.DFSDM0_EXMIN.Reg) & 0x7
}

// DFSDM.DFSDM0_CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetDFSDM0_CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.DFSDM0_CNVTIMR.Reg, volatile.LoadUint32(&o.DFSDM0_CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM0_CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM0_CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DFSDM.CR1: control register 1
func (o *DFSDM_Type) SetCR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCR1_FAST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetCR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetCR1_RCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetCR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetCR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetCR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetCR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetCR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetCR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetCR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetCR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetCR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetCR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetCR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetCR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetCR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetCR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetCR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetCR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetCR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetCR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetCR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetCR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetCR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// DFSDM.CR2: control register 2
func (o *DFSDM_Type) SetCR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetCR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetCR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetCR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetCR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetCR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetCR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetCR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetCR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetCR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetCR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetCR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// DFSDM.ISR: interrupt and status register
func (o *DFSDM_Type) SetISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DFSDM.ICR: interrupt flag clear register
func (o *DFSDM_Type) SetICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}

// DFSDM.JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetJCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.JCHGR.Reg, volatile.LoadUint32(&o.JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetJCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.JCHGR.Reg) & 0xff
}

// DFSDM.FCR: filter control register
func (o *DFSDM_Type) SetFCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetFCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetFCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetFCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetFCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// DFSDM.JDATAR: data register for injected group
func (o *DFSDM_Type) SetJDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetJDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetJDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetJDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.JDATAR.Reg) & 0x7
}

// DFSDM.RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetRDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetRDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetRDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetRDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetRDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetRDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.RDATAR.Reg) & 0x7
}

// DFSDM.AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetAWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.AWHTR.Reg, volatile.LoadUint32(&o.AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetAWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetAWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.AWHTR.Reg, volatile.LoadUint32(&o.AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetAWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.AWHTR.Reg) & 0xf
}

// DFSDM.AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetAWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.AWLTR.Reg, volatile.LoadUint32(&o.AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetAWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetAWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.AWLTR.Reg, volatile.LoadUint32(&o.AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetAWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.AWLTR.Reg) & 0xf
}

// DFSDM.AWSR: analog watchdog status register
func (o *DFSDM_Type) SetAWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.AWSR.Reg, volatile.LoadUint32(&o.AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetAWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetAWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.AWSR.Reg, volatile.LoadUint32(&o.AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.AWSR.Reg) & 0xff
}

// DFSDM.AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetAWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.AWCFR.Reg, volatile.LoadUint32(&o.AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetAWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetAWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.AWCFR.Reg, volatile.LoadUint32(&o.AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetAWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.AWCFR.Reg) & 0xff
}

// DFSDM.EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetEXMAX(value uint32) {
	volatile.StoreUint32(&o.EXMAX.Reg, volatile.LoadUint32(&o.EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetEXMAX() uint32 {
	return (volatile.LoadUint32(&o.EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetEXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.EXMAX.Reg, volatile.LoadUint32(&o.EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetEXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.EXMAX.Reg) & 0x7
}

// DFSDM.EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetEXMIN(value uint32) {
	volatile.StoreUint32(&o.EXMIN.Reg, volatile.LoadUint32(&o.EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetEXMIN() uint32 {
	return (volatile.LoadUint32(&o.EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetEXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.EXMIN.Reg, volatile.LoadUint32(&o.EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetEXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.EXMIN.Reg) & 0x7
}

// DFSDM.CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetCNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.CNVTIMR.Reg, volatile.LoadUint32(&o.CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetCNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DFSDM.DFSDM2_CR1: control register 1
func (o *DFSDM_Type) SetDFSDM2_CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetDFSDM2_CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetDFSDM2_CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM2_CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetDFSDM2_CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetDFSDM2_CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetDFSDM2_CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetDFSDM2_CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetDFSDM2_CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetDFSDM2_CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM2_CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM2_CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM2_CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR1.Reg, volatile.LoadUint32(&o.DFSDM2_CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM2_CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_CR1.Reg) & 0x1
}

// DFSDM.DFSDM2_CR2: control register 2
func (o *DFSDM_Type) SetDFSDM2_CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM2_CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetDFSDM2_CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetDFSDM2_CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM2_CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM2_CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetDFSDM2_CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM2_CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CR2.Reg, volatile.LoadUint32(&o.DFSDM2_CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM2_CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_CR2.Reg) & 0x1
}

// DFSDM.DFSDM2_ISR: interrupt and status register
func (o *DFSDM_Type) SetDFSDM2_ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM2_ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM2_ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetDFSDM2_ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetDFSDM2_ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM2_ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM2_ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetDFSDM2_ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM2_ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ISR.Reg, volatile.LoadUint32(&o.DFSDM2_ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM2_ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_ISR.Reg) & 0x1
}

// DFSDM.DFSDM2_ICR: interrupt flag clear register
func (o *DFSDM_Type) SetDFSDM2_ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ICR.Reg, volatile.LoadUint32(&o.DFSDM2_ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM2_ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM2_ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ICR.Reg, volatile.LoadUint32(&o.DFSDM2_ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM2_ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM2_ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ICR.Reg, volatile.LoadUint32(&o.DFSDM2_ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM2_ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM2_ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_ICR.Reg, volatile.LoadUint32(&o.DFSDM2_ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM2_ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_ICR.Reg) & 0x4) >> 2
}

// DFSDM.DFSDM2_JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetDFSDM2_JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_JCHGR.Reg, volatile.LoadUint32(&o.DFSDM2_JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM2_JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_JCHGR.Reg) & 0xff
}

// DFSDM.DFSDM2_FCR: filter control register
func (o *DFSDM_Type) SetDFSDM2_FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_FCR.Reg, volatile.LoadUint32(&o.DFSDM2_FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetDFSDM2_FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetDFSDM2_FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_FCR.Reg, volatile.LoadUint32(&o.DFSDM2_FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM2_FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM2_FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_FCR.Reg, volatile.LoadUint32(&o.DFSDM2_FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM2_FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_FCR.Reg) & 0xff
}

// DFSDM.DFSDM2_JDATAR: data register for injected group
func (o *DFSDM_Type) SetDFSDM2_JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_JDATAR.Reg, volatile.LoadUint32(&o.DFSDM2_JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_JDATAR.Reg, volatile.LoadUint32(&o.DFSDM2_JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM2_JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_JDATAR.Reg) & 0x7
}

// DFSDM.DFSDM2_RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetDFSDM2_RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM2_RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM2_RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM2_RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM2_RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM2_RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM2_RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_RDATAR.Reg) & 0x7
}

// DFSDM.DFSDM2_AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetDFSDM2_AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWHTR.Reg, volatile.LoadUint32(&o.DFSDM2_AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWHTR.Reg, volatile.LoadUint32(&o.DFSDM2_AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetDFSDM2_AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_AWHTR.Reg) & 0xf
}

// DFSDM.DFSDM2_AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetDFSDM2_AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWLTR.Reg, volatile.LoadUint32(&o.DFSDM2_AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWLTR.Reg, volatile.LoadUint32(&o.DFSDM2_AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetDFSDM2_AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_AWLTR.Reg) & 0xf
}

// DFSDM.DFSDM2_AWSR: analog watchdog status register
func (o *DFSDM_Type) SetDFSDM2_AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWSR.Reg, volatile.LoadUint32(&o.DFSDM2_AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWSR.Reg, volatile.LoadUint32(&o.DFSDM2_AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM2_AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_AWSR.Reg) & 0xff
}

// DFSDM.DFSDM2_AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetDFSDM2_AWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWCFR.Reg, volatile.LoadUint32(&o.DFSDM2_AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_AWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_AWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_AWCFR.Reg, volatile.LoadUint32(&o.DFSDM2_AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM2_AWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_AWCFR.Reg) & 0xff
}

// DFSDM.DFSDM2_EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetDFSDM2_EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_EXMAX.Reg, volatile.LoadUint32(&o.DFSDM2_EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_EXMAX.Reg, volatile.LoadUint32(&o.DFSDM2_EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM2_EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_EXMAX.Reg) & 0x7
}

// DFSDM.DFSDM2_EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetDFSDM2_EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_EXMIN.Reg, volatile.LoadUint32(&o.DFSDM2_EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM2_EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM2_EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_EXMIN.Reg, volatile.LoadUint32(&o.DFSDM2_EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM2_EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.DFSDM2_EXMIN.Reg) & 0x7
}

// DFSDM.DFSDM2_CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetDFSDM2_CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.DFSDM2_CNVTIMR.Reg, volatile.LoadUint32(&o.DFSDM2_CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM2_CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM2_CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DFSDM.DFSDM3_CR1: control register 1
func (o *DFSDM_Type) SetDFSDM3_CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetDFSDM3_CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetDFSDM3_CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM3_CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetDFSDM3_CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetDFSDM3_CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetDFSDM3_CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetDFSDM3_CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetDFSDM3_CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetDFSDM3_CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM3_CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM3_CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM3_CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR1.Reg, volatile.LoadUint32(&o.DFSDM3_CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM3_CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_CR1.Reg) & 0x1
}

// DFSDM.DFSDM3_CR2: control register 2
func (o *DFSDM_Type) SetDFSDM3_CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM3_CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetDFSDM3_CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetDFSDM3_CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM3_CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM3_CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetDFSDM3_CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM3_CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CR2.Reg, volatile.LoadUint32(&o.DFSDM3_CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM3_CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_CR2.Reg) & 0x1
}

// DFSDM.DFSDM3_ISR: interrupt and status register
func (o *DFSDM_Type) SetDFSDM3_ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM3_ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM3_ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetDFSDM3_ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetDFSDM3_ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM3_ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM3_ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetDFSDM3_ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetDFSDM3_ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ISR.Reg, volatile.LoadUint32(&o.DFSDM3_ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetDFSDM3_ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_ISR.Reg) & 0x1
}

// DFSDM.DFSDM3_ICR: interrupt flag clear register
func (o *DFSDM_Type) SetDFSDM3_ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ICR.Reg, volatile.LoadUint32(&o.DFSDM3_ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetDFSDM3_ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetDFSDM3_ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ICR.Reg, volatile.LoadUint32(&o.DFSDM3_ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM3_ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM3_ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ICR.Reg, volatile.LoadUint32(&o.DFSDM3_ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetDFSDM3_ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetDFSDM3_ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_ICR.Reg, volatile.LoadUint32(&o.DFSDM3_ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetDFSDM3_ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_ICR.Reg) & 0x4) >> 2
}

// DFSDM.DFSDM3_JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetDFSDM3_JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_JCHGR.Reg, volatile.LoadUint32(&o.DFSDM3_JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM3_JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_JCHGR.Reg) & 0xff
}

// DFSDM.DFSDM3_FCR: filter control register
func (o *DFSDM_Type) SetDFSDM3_FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_FCR.Reg, volatile.LoadUint32(&o.DFSDM3_FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetDFSDM3_FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetDFSDM3_FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_FCR.Reg, volatile.LoadUint32(&o.DFSDM3_FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetDFSDM3_FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetDFSDM3_FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_FCR.Reg, volatile.LoadUint32(&o.DFSDM3_FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM3_FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_FCR.Reg) & 0xff
}

// DFSDM.DFSDM3_JDATAR: data register for injected group
func (o *DFSDM_Type) SetDFSDM3_JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_JDATAR.Reg, volatile.LoadUint32(&o.DFSDM3_JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_JDATAR.Reg, volatile.LoadUint32(&o.DFSDM3_JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM3_JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_JDATAR.Reg) & 0x7
}

// DFSDM.DFSDM3_RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetDFSDM3_RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM3_RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM3_RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM3_RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetDFSDM3_RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_RDATAR.Reg, volatile.LoadUint32(&o.DFSDM3_RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM3_RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_RDATAR.Reg) & 0x7
}

// DFSDM.DFSDM3_AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetDFSDM3_AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWHTR.Reg, volatile.LoadUint32(&o.DFSDM3_AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWHTR.Reg, volatile.LoadUint32(&o.DFSDM3_AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetDFSDM3_AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_AWHTR.Reg) & 0xf
}

// DFSDM.DFSDM3_AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetDFSDM3_AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWLTR.Reg, volatile.LoadUint32(&o.DFSDM3_AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWLTR.Reg, volatile.LoadUint32(&o.DFSDM3_AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetDFSDM3_AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_AWLTR.Reg) & 0xf
}

// DFSDM.DFSDM3_AWSR: analog watchdog status register
func (o *DFSDM_Type) SetDFSDM3_AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWSR.Reg, volatile.LoadUint32(&o.DFSDM3_AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWSR.Reg, volatile.LoadUint32(&o.DFSDM3_AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM3_AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_AWSR.Reg) & 0xff
}

// DFSDM.DFSDM3_AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetDFSDM3_AWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWCFR.Reg, volatile.LoadUint32(&o.DFSDM3_AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_AWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_AWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_AWCFR.Reg, volatile.LoadUint32(&o.DFSDM3_AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetDFSDM3_AWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_AWCFR.Reg) & 0xff
}

// DFSDM.DFSDM3_EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetDFSDM3_EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_EXMAX.Reg, volatile.LoadUint32(&o.DFSDM3_EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_EXMAX.Reg, volatile.LoadUint32(&o.DFSDM3_EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM3_EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_EXMAX.Reg) & 0x7
}

// DFSDM.DFSDM3_EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetDFSDM3_EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_EXMIN.Reg, volatile.LoadUint32(&o.DFSDM3_EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetDFSDM3_EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetDFSDM3_EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_EXMIN.Reg, volatile.LoadUint32(&o.DFSDM3_EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetDFSDM3_EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.DFSDM3_EXMIN.Reg) & 0x7
}

// DFSDM.DFSDM3_CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetDFSDM3_CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.DFSDM3_CNVTIMR.Reg, volatile.LoadUint32(&o.DFSDM3_CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetDFSDM3_CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.DFSDM3_CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Advanced encryption standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// AES.CR: control register
func (o *AES_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetCR_CHMOD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES_Type) GetCR_CHMOD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// AES.SR: status register
func (o *AES_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// AES.DINR: data input register
func (o *AES_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES.DOUTR: data output register
func (o *AES_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES.KEYR0: key register 0
func (o *AES_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES.KEYR1: key register 1
func (o *AES_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES.KEYR2: key register 2
func (o *AES_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES.KEYR3: key register 3
func (o *AES_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES.IVR0: initialization vector register 0
func (o *AES_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES.IVR1: initialization vector register 1
func (o *AES_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES.IVR2: initialization vector register 2
func (o *AES_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES.IVR3: initialization vector register 3
func (o *AES_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// Analog-to-Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// ADC.ISR: interrupt and status register
func (o *ADC_Type) SetISR_JQOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_JQOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_JEOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_JEOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_JEOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// ADC.IER: interrupt enable register
func (o *ADC_Type) SetIER_JQOVFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_JQOVFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_JEOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_JEOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ADC.CR: control register
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCR_ADCALDIF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR_ADCALDIF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR_DEEPPWD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCR_DEEPPWD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_JADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR_JADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_JADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_JADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ADC.CFGR: configuration register
func (o *ADC_Type) SetCFGR_JQDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCFGR_JQDIS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCFGR_AWDCH1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR_AWDCH1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetCFGR_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR_JAWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCFGR_JAWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCFGR_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR_JQM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR_JQM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCFGR_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCFGR_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCFGR_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCFGR_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR_AUTDLY(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR_AUTDLY() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3c0)|value<<6)
}
func (o *ADC_Type) GetCFGR_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3c0) >> 6
}
func (o *ADC_Type) SetCFGR_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCFGR_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCFGR_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetCFGR_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetCFGR_DFSDMCFG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCFGR_DFSDMCFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCFGR_DMACFG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR_DMACFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR_DMAEN() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// ADC.CFGR2: configuration register
func (o *ADC_Type) SetCFGR2_ROVSM(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCFGR2_ROVSM() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCFGR2_TROVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TROVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_OVSS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1e0)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1e0) >> 5
}
func (o *ADC_Type) SetCFGR2_OVSR(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1c)|value<<2)
}
func (o *ADC_Type) GetCFGR2_OVSR() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1c) >> 2
}
func (o *ADC_Type) SetCFGR2_JOVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR2_JOVSE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR2_ROVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_ROVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR1_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR1_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMPPLUS(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetSMPR1_SMPPLUS() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetSMPR1_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.TR1: watchdog threshold register 1
func (o *ADC_Type) SetTR1_HT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetTR1_HT1() uint32 {
	return (volatile.LoadUint32(&o.TR1.Reg) & 0xfff0000) >> 16
}
func (o *ADC_Type) SetTR1_LT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetTR1_LT1() uint32 {
	return volatile.LoadUint32(&o.TR1.Reg) & 0xfff
}

// ADC.TR2: watchdog threshold register
func (o *ADC_Type) SetTR2_HT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR2_HT2() uint32 {
	return (volatile.LoadUint32(&o.TR2.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR2_LT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR2_LT2() uint32 {
	return volatile.LoadUint32(&o.TR2.Reg) & 0xff
}

// ADC.TR3: watchdog threshold register 3
func (o *ADC_Type) SetTR3_HT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR3_HT3() uint32 {
	return (volatile.LoadUint32(&o.TR3.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR3_LT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR3_LT3() uint32 {
	return volatile.LoadUint32(&o.TR3.Reg) & 0xff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR1_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR1_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR1_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR1_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR1_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR1_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR1_SQ1() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0xf
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR2_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR2_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR2_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ5() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR3_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR3_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR3_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR3_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR3_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ10() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: regular sequence register 4
func (o *ADC_Type) SetSQR4_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR4_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR4_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ15() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.DR: regular Data Register
func (o *ADC_Type) SetDR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_RDATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c000)|value<<14)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c000) >> 14
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f00)|value<<8)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x1f00) >> 8
}
func (o *ADC_Type) SetJSQR_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetJSQR_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetJSQR_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3c)|value<<2)
}
func (o *ADC_Type) GetJSQR_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3c) >> 2
}
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x3
}

// ADC.OFR1: offset register 1
func (o *ADC_Type) SetOFR1_OFFSET1_EN(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR1_OFFSET1_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR1_OFFSET1_CH(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR1_OFFSET1_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR1_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR1_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.OFR1.Reg) & 0xfff
}

// ADC.OFR2: offset register 2
func (o *ADC_Type) SetOFR2_OFFSET2_EN(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR2_OFFSET2_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR2_OFFSET2_CH(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR2_OFFSET2_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR2_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR2_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.OFR2.Reg) & 0xfff
}

// ADC.OFR3: offset register 3
func (o *ADC_Type) SetOFR3_OFFSET3_EN(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR3_OFFSET3_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR3_OFFSET3_CH(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR3_OFFSET3_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR3_OFFSET3(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR3_OFFSET3() uint32 {
	return volatile.LoadUint32(&o.OFR3.Reg) & 0xfff
}

// ADC.OFR4: offset register 4
func (o *ADC_Type) SetOFR4_OFFSET4_EN(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR4_OFFSET4_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR4_OFFSET4_CH(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR4_OFFSET4_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR4_OFFSET4(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR4_OFFSET4() uint32 {
	return volatile.LoadUint32(&o.OFR4.Reg) & 0xfff
}

// ADC.JDR1: injected data register 1
func (o *ADC_Type) SetJDR1_JDATA1(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA1() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register 2
func (o *ADC_Type) SetJDR2_JDATA2(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA2() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register 3
func (o *ADC_Type) SetJDR3_JDATA3(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA3() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register 4
func (o *ADC_Type) SetJDR4_JDATA4(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA4() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.AWD2CR: Analog Watchdog 2 Configuration Register
func (o *ADC_Type) SetAWD2CR_AWD2CH(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x7ffff)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x7ffff
}

// ADC.AWD3CR: Analog Watchdog 3 Configuration Register
func (o *ADC_Type) SetAWD3CR_AWD3CH(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x7ffff)|value)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH() uint32 {
	return volatile.LoadUint32(&o.AWD3CR.Reg) & 0x7ffff
}

// ADC.DIFSEL: Differential Mode Selection Register 2
func (o *ADC_Type) SetDIFSEL_DIFSEL_0(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_0() uint32 {
	return volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_1_15(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0xfffe)|value<<1)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_1_15() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0xfffe) >> 1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL_16_18(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x70000)|value<<16)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL_16_18() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x70000) >> 16
}

// ADC.CALFACT: Calibration Factors
func (o *ADC_Type) SetCALFACT_CALFACT_D(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f0000)|value<<16)
}
func (o *ADC_Type) GetCALFACT_CALFACT_D() uint32 {
	return (volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f0000) >> 16
}
func (o *ADC_Type) SetCALFACT_CALFACT_S(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCALFACT_CALFACT_S() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
	ASCR    volatile.Register32 // 0x2C
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: GPIO port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// GPIO.ASCR: GPIO port analog switch control register
func (o *GPIO_Type) SetASCR_ASC0(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetASCR_ASC0() uint32 {
	return volatile.LoadUint32(&o.ASCR.Reg) & 0x1
}
func (o *GPIO_Type) SetASCR_ASC1(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetASCR_ASC1() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetASCR_ASC2(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetASCR_ASC2() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetASCR_ASC3(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetASCR_ASC3() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetASCR_ASC4(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetASCR_ASC4() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetASCR_ASC5(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetASCR_ASC5() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetASCR_ASC6(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetASCR_ASC6() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetASCR_ASC7(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetASCR_ASC7() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetASCR_ASC8(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetASCR_ASC8() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetASCR_ASC9(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetASCR_ASC9() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetASCR_ASC10(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetASCR_ASC10() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetASCR_ASC11(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetASCR_ASC11() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetASCR_ASC12(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetASCR_ASC12() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetASCR_ASC13(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetASCR_ASC13() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetASCR_ASC14(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetASCR_ASC14() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetASCR_ASC15(value uint32) {
	volatile.StoreUint32(&o.ASCR.Reg, volatile.LoadUint32(&o.ASCR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetASCR_ASC15() uint32 {
	return (volatile.LoadUint32(&o.ASCR.Reg) & 0x8000) >> 15
}

// Serial audio interface
type SAI_Type struct {
	_  [4]byte
	CH [2]SAI_CH_Type // 0x4
}

type SAI_CH_Type struct {
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	FRCR  volatile.Register32 // 0xC
	SLOTR volatile.Register32 // 0x10
	IM    volatile.Register32 // 0x14
	SR    volatile.Register32 // 0x18
	CLRFR volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
}

// SAI_CH.CR1: AConfiguration register 1
func (o *SAI_CH_Type) SetCR1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00000)|value<<20)
}
func (o *SAI_CH_Type) GetCR1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00000) >> 20
}
func (o *SAI_CH_Type) SetCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *SAI_CH_Type) SetCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetCR1_SAIEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetCR1_SAIEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetCR1_OUTDRIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR1_OUTDRIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_CH_Type) GetCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SAI_CH_Type) SetCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_CH_Type) GetCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc00) >> 10
}
func (o *SAI_CH_Type) SetCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_CH_Type) GetCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SAI_CH_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_CH_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SAI_CH_Type) SetCR1_DS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_CH_Type) GetCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *SAI_CH_Type) SetCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_CH_Type) GetCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc) >> 2
}
func (o *SAI_CH_Type) SetCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3)|value)
}
func (o *SAI_CH_Type) GetCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x3
}

// SAI_CH.CR2: AConfiguration register 2
func (o *SAI_CH_Type) SetCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_CH_Type) GetCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xc000) >> 14
}
func (o *SAI_CH_Type) SetCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_CH_Type) GetCR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_CH_Type) SetCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCR2_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetCR2_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x7)|value)
}
func (o *SAI_CH_Type) GetCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x7
}

// SAI_CH.FRCR: AFRCR
func (o *SAI_CH_Type) SetFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_CH_Type) GetFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_CH_Type) SetFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_CH_Type) GetFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_CH_Type) SetFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0xff)|value)
}
func (o *SAI_CH_Type) GetFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.FRCR.Reg) & 0xff
}

// SAI_CH.SLOTR: ASlot register
func (o *SAI_CH_Type) SetSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_CH_Type) SetSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_CH_Type) GetSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_CH_Type) SetSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_CH_Type) SetSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_CH_Type) GetSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.SLOTR.Reg) & 0x1f
}

// SAI_CH.IM: AInterrupt mask register2
func (o *SAI_CH_Type) SetIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetIM_WCKCFGIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetIM_WCKCFGIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetIM_MUTEDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetIM_MUTEDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.IM.Reg) & 0x1
}

// SAI_CH.SR: AStatus register
func (o *SAI_CH_Type) SetSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_CH_Type) GetSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000) >> 16
}
func (o *SAI_CH_Type) SetSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SAI_CH.CLRFR: AClear flag register
func (o *SAI_CH_Type) SetCLRFR_CLFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCLRFR_CLFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCLRFR_CCNRDY(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCLRFR_CCNRDY() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCLRFR_CWCKCFG(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetCLRFR_CWCKCFG() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetCLRFR_CMUTEDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetCLRFR_CMUTEDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetCLRFR_COVRUDR(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetCLRFR_COVRUDR() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}

// SAI_CH.DR: AData register
func (o *SAI_CH_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *SAI_CH_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg)
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg)
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, value)
}
func (o *TIM_Type) GetCCR1() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg)
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, value)
}
func (o *TIM_Type) GetCCR2() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg)
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, value)
}
func (o *TIM_Type) GetCCR3() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg)
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, value)
}
func (o *TIM_Type) GetCCR4() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg)
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// TIM.OR: TIM2 option register
func (o *TIM_Type) SetOR_ETR_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetOR_ETR_RMP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x7
}
func (o *TIM_Type) SetOR_TI4_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x18)|value<<3)
}
func (o *TIM_Type) GetOR_TI4_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x18) >> 3
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *USART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}
func (o *USART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetCR2_ABRMOD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x600000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x600000) >> 21
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// USART.ISR: Interrupt & status register
func (o *USART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_CRCL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_CRCL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDIO.POWER: power control register
func (o *SDIO_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDIO_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDIO.CLKCR: SDI clock control register
func (o *SDIO_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDIO_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDIO_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDIO_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDIO.ARG: argument register
func (o *SDIO_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDIO_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDIO.CMD: command register
func (o *SDIO_Type) SetCMD_CE_ATACMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCMD_CE_ATACMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCMD_NIEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCMD_NIEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCMD_ENCMDcompl(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetCMD_ENCMDcompl() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDIO_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDIO_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDIO.RESPCMD: command response register
func (o *SDIO_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDIO.RESP1: response 1..4 register
func (o *SDIO_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDIO_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDIO.RESP2: response 1..4 register
func (o *SDIO_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDIO_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDIO.RESP3: response 1..4 register
func (o *SDIO_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDIO_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDIO.RESP4: response 1..4 register
func (o *SDIO_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDIO_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDIO.DTIMER: data timer register
func (o *SDIO_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDIO_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDIO.DLEN: data length register
func (o *SDIO_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDIO.DCTRL: data control register
func (o *SDIO_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDIO_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDIO_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDIO.DCOUNT: data counter register
func (o *SDIO_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDIO.STA: status register
func (o *SDIO_Type) SetSTA_CEATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetSTA_CEATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetSTA_STBITERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetSTA_STBITERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDIO.ICR: interrupt clear register
func (o *SDIO_Type) SetICR_CEATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetICR_CEATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetICR_STBITERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetICR_STBITERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDIO.MASK: mask register
func (o *SDIO_Type) SetMASK_CEATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetMASK_CEATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetMASK_STBITERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetMASK_STBITERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDIO.FIFOCNT: FIFO counter register
func (o *SDIO_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDIO_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDIO.FIFO: data FIFO register
func (o *SDIO_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDIO_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	_      [8]byte
	IMR2   volatile.Register32 // 0x20
	EMR2   volatile.Register32 // 0x24
	RTSR2  volatile.Register32 // 0x28
	FTSR2  volatile.Register32 // 0x2C
	SWIER2 volatile.Register32 // 0x30
	PR2    volatile.Register32 // 0x34
}

// EXTI.IMR1: Interrupt mask register
func (o *EXTI_Type) SetIMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetIMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetIMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetIMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetIMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetIMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetIMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetIMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetIMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetIMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetIMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetIMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetIMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetIMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetIMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetIMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetIMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.EMR1: Event mask register
func (o *EXTI_Type) SetEMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetEMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetEMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetEMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetEMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetEMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetEMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetEMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetEMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetEMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetEMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetEMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetEMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetEMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetEMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetEMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetEMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetEMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetEMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000000) >> 31
}

// EXTI.RTSR1: Rising Trigger selection register
func (o *EXTI_Type) SetRTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR1_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR1_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400000) >> 22
}

// EXTI.FTSR1: Falling Trigger selection register
func (o *EXTI_Type) SetFTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR1_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR1_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400000) >> 22
}

// EXTI.SWIER1: Software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER1_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER1_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER1_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER1_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER1_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER1_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER1_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400000) >> 22
}

// EXTI.PR1: Pending register
func (o *EXTI_Type) SetPR1_PR0(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR1_PR0() uint32 {
	return volatile.LoadUint32(&o.PR1.Reg) & 0x1
}
func (o *EXTI_Type) SetPR1(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR1() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR1_PR2(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR1_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR1_PR3(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR1_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR1_PR4(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR1_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR1_PR5(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR1_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR1_PR6(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR1_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR1_PR7(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR1_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR1_PR8(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR1_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR1_PR9(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR1_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR1_PR10(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR1_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR1_PR11(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR1_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR1_PR12(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR1_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR1_PR13(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR1_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR1_PR14(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR1_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR1_PR15(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR1_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR1_PR16(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR1_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR1_PR18(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR1_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR1_PR19(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR1_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR1_PR20(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR1_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR1_PR21(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR1_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR1_PR22(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR1_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400000) >> 22
}

// EXTI.IMR2: Interrupt mask register
func (o *EXTI_Type) SetIMR2_MR32(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR2_MR32() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR2_MR33(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR2_MR33() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR2_MR36(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR2_MR36() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR2_MR37(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR2_MR37() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR2_MR38(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR2_MR38() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR2_MR39(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR2_MR39() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// EXTI.EMR2: Event mask register
func (o *EXTI_Type) SetEMR2_MR32(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR2_MR32() uint32 {
	return volatile.LoadUint32(&o.EMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR2_MR33(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR2_MR33() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR2_MR36(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR2_MR36() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR2_MR37(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR2_MR37() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR2_MR38(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR2_MR38() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR2_MR39(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR2_MR39() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x80) >> 7
}

// EXTI.RTSR2: Rising Trigger selection register
func (o *EXTI_Type) SetRTSR2_RT35(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR2_RT35() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR2_RT36(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR2_RT36() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR2_RT37(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR2_RT37() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR2_RT38(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR2_RT38() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x40) >> 6
}

// EXTI.FTSR2: Falling Trigger selection register
func (o *EXTI_Type) SetFTSR2_FT35(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR2_FT35() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR2_FT36(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR2_FT36() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR2_FT37(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR2_FT37() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR2_FT38(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR2_FT38() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x40) >> 6
}

// EXTI.SWIER2: Software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWI35(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER2_SWI35() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER2_SWI36(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER2_SWI36() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER2_SWI37(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER2_SWI37() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER2_SWI38(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER2_SWI38() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x40) >> 6
}

// EXTI.PR2: Pending register
func (o *EXTI_Type) SetPR2_PIF35(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR2_PIF35() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR2_PIF36(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR2_PIF36() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR2_PIF37(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR2_PIF37() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR2_PIF38(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR2_PIF38() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x40) >> 6
}

// Voltage reference buffer
type VREF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREF.CSR: VREF control and status register
func (o *VREF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *VREF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *VREF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *VREF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}

// VREF.CCR: calibration control register
func (o *VREF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TX    [3]CAN_TX_Type // 0x180
	RX    [2]CAN_RX_Type // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]CAN_FB_Type // 0x240
}

// CAN.MCR: master control register
func (o *CAN_Type) SetMCR_DBF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetMCR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetMCR_RESET(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetMCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetMCR_TTCM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMCR_TTCM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMCR_ABOM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMCR_ABOM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMCR_AWUM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMCR_AWUM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMCR_NART(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMCR_NART() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMCR_RFLM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMCR_RFLM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMCR_TXFP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMCR_TXFP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMCR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMCR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMCR_INRQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMCR_INRQ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}

// CAN.MSR: master status register
func (o *CAN_Type) SetMSR_RX(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetMSR_RX() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetMSR_SAMP(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetMSR_SAMP() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetMSR_RXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetMSR_RXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetMSR_TXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetMSR_TXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetMSR_SLAKI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMSR_SLAKI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMSR_WKUI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMSR_WKUI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMSR_SLAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMSR_SLAK() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMSR_INAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMSR_INAK() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}

// CAN.TSR: transmit status register
func (o *CAN_Type) SetTSR_LOW2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTSR_LOW2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetTSR_LOW1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTSR_LOW1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTSR_LOW0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetTSR_LOW0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetTSR_TME2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetTSR_TME2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetTSR_TME1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetTSR_TME1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetTSR_TME0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetTSR_TME0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetTSR_CODE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetTSR_CODE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetTSR_ABRQ2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetTSR_ABRQ2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetTSR_TERR2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetTSR_TERR2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetTSR_ALST2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetTSR_ALST2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetTSR_TXOK2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetTSR_TXOK2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetTSR_RQCP2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetTSR_RQCP2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetTSR_ABRQ1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetTSR_ABRQ1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetTSR_TERR1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetTSR_TERR1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetTSR_ALST1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetTSR_ALST1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetTSR_TXOK1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetTSR_TXOK1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetTSR_RQCP1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetTSR_RQCP1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetTSR_ABRQ0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTSR_ABRQ0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTSR_TERR0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTSR_TERR0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTSR_ALST0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTSR_ALST0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTSR_TXOK0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTSR_TXOK0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTSR_RQCP0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTSR_RQCP0() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}

// CAN.RF0R: receive FIFO %s register
func (o *CAN_Type) SetRF0R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF0R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF0R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF0R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF0R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF0R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF0R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF0R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF0R.Reg) & 0x3
}

// CAN.RF1R: receive FIFO %s register
func (o *CAN_Type) SetRF1R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF1R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF1R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF1R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF1R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF1R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF1R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF1R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF1R.Reg) & 0x3
}

// CAN.IER: interrupt enable register
func (o *CAN_Type) SetIER_SLKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_SLKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_WKUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_WKUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetIER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetIER_LECIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetIER_LECIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetIER_BOFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_BOFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_EPVIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_EPVIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_EWGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_EWGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_FOVIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_FOVIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_FFIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_FFIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_FMPIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_FMPIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_FOVIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_FOVIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_FFIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_FFIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_FMPIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_FMPIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_TMEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_TMEIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CAN.ESR: interrupt enable register
func (o *CAN_Type) SetESR_REC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetESR_REC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff000000) >> 24
}
func (o *CAN_Type) SetESR_TEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetESR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetESR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetESR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetESR_BOFF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetESR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetESR_EPVF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetESR_EPVF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetESR_EWGF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetESR_EWGF() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}

// CAN.BTR: bit timing register
func (o *CAN_Type) SetBTR_SILM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetBTR_SILM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetBTR_LBKM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetBTR_LBKM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetBTR_TS2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TS2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_TS1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TS1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}

// CAN.FMR: filter master register
func (o *CAN_Type) SetFMR_FINIT(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFMR_FINIT() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *CAN_Type) SetFMR_CANSB(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x3f00)|value<<8)
}
func (o *CAN_Type) GetFMR_CANSB() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x3f00) >> 8
}

// CAN.FM1R: filter mode register
func (o *CAN_Type) SetFM1R_FBM0(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFM1R_FBM0() uint32 {
	return volatile.LoadUint32(&o.FM1R.Reg) & 0x1
}
func (o *CAN_Type) SetFM1R_FBM1(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFM1R_FBM1() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFM1R_FBM2(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFM1R_FBM2() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFM1R_FBM3(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFM1R_FBM3() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFM1R_FBM4(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFM1R_FBM4() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFM1R_FBM5(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFM1R_FBM5() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFM1R_FBM6(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFM1R_FBM6() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFM1R_FBM7(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFM1R_FBM7() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFM1R_FBM8(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFM1R_FBM8() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFM1R_FBM9(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFM1R_FBM9() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFM1R_FBM10(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFM1R_FBM10() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFM1R_FBM11(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFM1R_FBM11() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFM1R_FBM12(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFM1R_FBM12() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFM1R_FBM13(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFM1R_FBM13() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFM1R_FBM14(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFM1R_FBM14() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFM1R_FBM15(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFM1R_FBM15() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFM1R_FBM16(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFM1R_FBM16() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFM1R_FBM17(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFM1R_FBM17() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFM1R_FBM18(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFM1R_FBM18() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFM1R_FBM19(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFM1R_FBM19() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFM1R_FBM20(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFM1R_FBM20() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFM1R_FBM21(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFM1R_FBM21() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFM1R_FBM22(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFM1R_FBM22() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFM1R_FBM23(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFM1R_FBM23() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFM1R_FBM24(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFM1R_FBM24() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFM1R_FBM25(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFM1R_FBM25() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFM1R_FBM26(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFM1R_FBM26() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFM1R_FBM27(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFM1R_FBM27() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000000) >> 27
}

// CAN.FS1R: filter scale register
func (o *CAN_Type) SetFS1R_FSC0(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFS1R_FSC0() uint32 {
	return volatile.LoadUint32(&o.FS1R.Reg) & 0x1
}
func (o *CAN_Type) SetFS1R_FSC1(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFS1R_FSC1() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFS1R_FSC2(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFS1R_FSC2() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFS1R_FSC3(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFS1R_FSC3() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFS1R_FSC4(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFS1R_FSC4() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFS1R_FSC5(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFS1R_FSC5() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFS1R_FSC6(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFS1R_FSC6() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFS1R_FSC7(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFS1R_FSC7() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFS1R_FSC8(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFS1R_FSC8() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFS1R_FSC9(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFS1R_FSC9() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFS1R_FSC10(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFS1R_FSC10() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFS1R_FSC11(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFS1R_FSC11() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFS1R_FSC12(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFS1R_FSC12() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFS1R_FSC13(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFS1R_FSC13() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFS1R_FSC14(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFS1R_FSC14() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFS1R_FSC15(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFS1R_FSC15() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFS1R_FSC16(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFS1R_FSC16() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFS1R_FSC17(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFS1R_FSC17() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFS1R_FSC18(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFS1R_FSC18() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFS1R_FSC19(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFS1R_FSC19() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFS1R_FSC20(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFS1R_FSC20() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFS1R_FSC21(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFS1R_FSC21() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFS1R_FSC22(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFS1R_FSC22() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFS1R_FSC23(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFS1R_FSC23() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFS1R_FSC24(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFS1R_FSC24() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFS1R_FSC25(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFS1R_FSC25() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFS1R_FSC26(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFS1R_FSC26() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFS1R_FSC27(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFS1R_FSC27() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000000) >> 27
}

// CAN.FFA1R: filter FIFO assignment register
func (o *CAN_Type) SetFFA1R_FFA0(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFFA1R_FFA0() uint32 {
	return volatile.LoadUint32(&o.FFA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFFA1R_FFA1(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFFA1R_FFA1() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFFA1R_FFA2(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFFA1R_FFA2() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFFA1R_FFA3(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFFA1R_FFA3() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFFA1R_FFA4(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFFA1R_FFA4() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFFA1R_FFA5(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFFA1R_FFA5() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFFA1R_FFA6(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFFA1R_FFA6() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFFA1R_FFA7(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFFA1R_FFA7() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFFA1R_FFA8(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFFA1R_FFA8() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFFA1R_FFA9(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFFA1R_FFA9() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFFA1R_FFA10(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFFA1R_FFA10() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFFA1R_FFA11(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFFA1R_FFA11() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFFA1R_FFA12(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFFA1R_FFA12() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFFA1R_FFA13(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFFA1R_FFA13() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFFA1R_FFA14(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFFA1R_FFA14() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFFA1R_FFA15(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFFA1R_FFA15() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFFA1R_FFA16(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFFA1R_FFA16() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFFA1R_FFA17(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFFA1R_FFA17() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFFA1R_FFA18(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFFA1R_FFA18() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFFA1R_FFA19(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFFA1R_FFA19() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFFA1R_FFA20(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFFA1R_FFA20() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFFA1R_FFA21(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFFA1R_FFA21() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFFA1R_FFA22(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFFA1R_FFA22() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFFA1R_FFA23(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFFA1R_FFA23() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFFA1R_FFA24(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFFA1R_FFA24() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFFA1R_FFA25(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFFA1R_FFA25() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFFA1R_FFA26(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFFA1R_FFA26() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFFA1R_FFA27(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFFA1R_FFA27() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000000) >> 27
}

// CAN.FA1R: filter activation register
func (o *CAN_Type) SetFA1R_FACT0(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFA1R_FACT0() uint32 {
	return volatile.LoadUint32(&o.FA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFA1R_FACT1(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFA1R_FACT1() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFA1R_FACT2(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFA1R_FACT2() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFA1R_FACT3(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFA1R_FACT3() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFA1R_FACT4(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFA1R_FACT4() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFA1R_FACT5(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFA1R_FACT5() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFA1R_FACT6(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFA1R_FACT6() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFA1R_FACT7(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFA1R_FACT7() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFA1R_FACT8(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFA1R_FACT8() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFA1R_FACT9(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFA1R_FACT9() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFA1R_FACT10(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFA1R_FACT10() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFA1R_FACT11(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFA1R_FACT11() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFA1R_FACT12(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFA1R_FACT12() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFA1R_FACT13(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFA1R_FACT13() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFA1R_FACT14(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFA1R_FACT14() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFA1R_FACT15(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFA1R_FACT15() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFA1R_FACT16(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFA1R_FACT16() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFA1R_FACT17(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFA1R_FACT17() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFA1R_FACT18(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFA1R_FACT18() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFA1R_FACT19(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFA1R_FACT19() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFA1R_FACT20(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFA1R_FACT20() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFA1R_FACT21(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFA1R_FACT21() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFA1R_FACT22(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFA1R_FACT22() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFA1R_FACT23(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFA1R_FACT23() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFA1R_FACT24(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFA1R_FACT24() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFA1R_FACT25(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFA1R_FACT25() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFA1R_FACT26(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFA1R_FACT26() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFA1R_FACT27(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFA1R_FACT27() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000000) >> 27
}

type CAN_TX_Type struct {
	TIR  volatile.Register32 // 0x180
	TDTR volatile.Register32 // 0x184
	TDLR volatile.Register32 // 0x188
	TDHR volatile.Register32 // 0x18C
}

// CAN_TX.TIR: TX mailbox identifier register
func (o *CAN_TX_Type) SetTIR_STID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_TX_Type) GetTIR_STID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_TX_Type) SetTIR_EXID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_TX_Type) GetTIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_TX_Type) SetTIR_IDE(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_TX_Type) GetTIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x4) >> 2
}
func (o *CAN_TX_Type) SetTIR_RTR(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_TX_Type) GetTIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x2) >> 1
}
func (o *CAN_TX_Type) SetTIR_TXRQ(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1)|value)
}
func (o *CAN_TX_Type) GetTIR_TXRQ() uint32 {
	return volatile.LoadUint32(&o.TIR.Reg) & 0x1
}

// CAN_TX.TDTR: mailbox data length control and time stamp register
func (o *CAN_TX_Type) SetTDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_TX_Type) SetTDTR_TGT(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_TX_Type) GetTDTR_TGT() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0x100) >> 8
}
func (o *CAN_TX_Type) SetTDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xf)|value)
}
func (o *CAN_TX_Type) GetTDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.TDTR.Reg) & 0xf
}

// CAN_TX.TDLR: mailbox data low register
func (o *CAN_TX_Type) SetTDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.TDLR.Reg) & 0xff
}

// CAN_TX.TDHR: mailbox data high register
func (o *CAN_TX_Type) SetTDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.TDHR.Reg) & 0xff
}

type CAN_RX_Type struct {
	RIR  volatile.Register32 // 0x1B0
	RDTR volatile.Register32 // 0x1B4
	RDLR volatile.Register32 // 0x1B8
	RDHR volatile.Register32 // 0x1BC
}

// CAN_RX.RIR: receive FIFO mailbox identifier register
func (o *CAN_RX_Type) SetRIR_STID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_RX_Type) GetRIR_STID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_RX_Type) SetRIR_EXID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_RX_Type) GetRIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_RX_Type) SetRIR_IDE(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_RX_Type) GetRIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x4) >> 2
}
func (o *CAN_RX_Type) SetRIR_RTR(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_RX_Type) GetRIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x2) >> 1
}

// CAN_RX.RDTR: mailbox data high register
func (o *CAN_RX_Type) SetRDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_RX_Type) SetRDTR_FMI(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDTR_FMI() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xf)|value)
}
func (o *CAN_RX_Type) GetRDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.RDTR.Reg) & 0xf
}

// CAN_RX.RDLR: mailbox data high register
func (o *CAN_RX_Type) SetRDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RDLR.Reg) & 0xff
}

// CAN_RX.RDHR: receive FIFO mailbox data high register
func (o *CAN_RX_Type) SetRDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RDHR.Reg) & 0xff
}

type CAN_FB_Type struct {
	FR1 volatile.Register32 // 0x240
	FR2 volatile.Register32 // 0x244
}

// CAN_FB.FR1: Filter bank 0 register 1
func (o *CAN_FB_Type) SetFR1(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, value)
}
func (o *CAN_FB_Type) GetFR1() uint32 {
	return volatile.LoadUint32(&o.FR1.Reg)
}

// CAN_FB.FR2: Filter bank 0 register 2
func (o *CAN_FB_Type) SetFR2(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, value)
}
func (o *CAN_FB_Type) GetFR2() uint32 {
	return volatile.LoadUint32(&o.FR2.Reg)
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAMPCR: tamper configuration register
func (o *RTC_Type) SetTAMPCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAMPCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1
}
func (o *RTC_Type) SetTAMPCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAMPCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAMPCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAMPCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAMPCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAMPCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAMPCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAMPCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAMPCR_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetTAMPCR_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetTAMPCR_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetTAMPCR_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetTAMPCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAMPCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAMPCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAMPCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAMPCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAMPCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAMPCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAMPCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAMPCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAMPCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAMPCR_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAMPCR_TAMP1IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAMPCR_TAMP1NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAMPCR_TAMP1NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAMPCR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAMPCR_TAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAMPCR_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetTAMPCR_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetTAMPCR_TAMP2NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetTAMPCR_TAMP2NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetTAMPCR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetTAMPCR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetTAMPCR_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTAMPCR_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTAMPCR_TAMP3NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTAMPCR_TAMP3NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetTAMPCR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetTAMPCR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1000000) >> 24
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.OR: option register
func (o *RTC_Type) SetOR_RTC_ALARM_TYPE(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetOR_RTC_ALARM_TYPE() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *RTC_Type) SetOR_RTC_OUT_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetOR_RTC_OUT_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// RTC.BKP20R: backup register
func (o *RTC_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *RTC_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// RTC.BKP21R: backup register
func (o *RTC_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *RTC_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// RTC.BKP22R: backup register
func (o *RTC_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *RTC_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// RTC.BKP23R: backup register
func (o *RTC_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *RTC_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// RTC.BKP24R: backup register
func (o *RTC_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *RTC_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// RTC.BKP25R: backup register
func (o *RTC_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *RTC_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// RTC.BKP26R: backup register
func (o *RTC_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *RTC_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// RTC.BKP27R: backup register
func (o *RTC_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *RTC_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// RTC.BKP28R: backup register
func (o *RTC_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *RTC_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// RTC.BKP29R: backup register
func (o *RTC_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *RTC_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// RTC.BKP30R: backup register
func (o *RTC_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *RTC_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// RTC.BKP31R: backup register
func (o *RTC_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *RTC_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	FS_GOTGCTL          volatile.Register32 // 0x0
	FS_GOTGINT          volatile.Register32 // 0x4
	FS_GAHBCFG          volatile.Register32 // 0x8
	FS_GUSBCFG          volatile.Register32 // 0xC
	FS_GRSTCTL          volatile.Register32 // 0x10
	FS_GINTSTS          volatile.Register32 // 0x14
	FS_GINTMSK          volatile.Register32 // 0x18
	FS_GRXSTSR_Device   volatile.Register32 // 0x1C
	_                   [4]byte
	FS_GRXFSIZ          volatile.Register32 // 0x24
	FS_GNPTXFSIZ_Device volatile.Register32 // 0x28
	FS_GNPTXSTS         volatile.Register32 // 0x2C
	_                   [8]byte
	FS_GCCFG            volatile.Register32 // 0x38
	FS_CID              volatile.Register32 // 0x3C
	_                   [192]byte
	FS_HPTXFSIZ         volatile.Register32 // 0x100
	FS_DIEPTXF1         volatile.Register32 // 0x104
	FS_DIEPTXF2         volatile.Register32 // 0x108
	FS_DIEPTXF3         volatile.Register32 // 0x10C
}

// USB_OTG_FS.FS_GOTGCTL: OTG_FS control and status register (OTG_FS_GOTGCTL)
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_SRQSCS(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_SRQSCS() uint32 {
	return volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_SRQ(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_SRQ() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_HNGSCS(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_HNGSCS() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_HNPRQ(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_HNPRQ() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_HSHNPEN(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_HSHNPEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_DHNPEN(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_DHNPEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_CIDSTS(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_CIDSTS() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_DBCT(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_DBCT() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_ASVLD(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_ASVLD() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GOTGCTL_BSVLD(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGCTL.Reg, volatile.LoadUint32(&o.FS_GOTGCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGCTL_BSVLD() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGCTL.Reg) & 0x80000) >> 19
}

// USB_OTG_FS.FS_GOTGINT: OTG_FS interrupt register (OTG_FS_GOTGINT)
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_SEDET(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_SEDET() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_SRSSCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_SRSSCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_HNSSCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_HNSSCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_HNGDET(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_HNGDET() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_ADTOCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_ADTOCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GOTGINT_DBCDNE(value uint32) {
	volatile.StoreUint32(&o.FS_GOTGINT.Reg, volatile.LoadUint32(&o.FS_GOTGINT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GOTGINT_DBCDNE() uint32 {
	return (volatile.LoadUint32(&o.FS_GOTGINT.Reg) & 0x80000) >> 19
}

// USB_OTG_FS.FS_GAHBCFG: OTG_FS AHB configuration register (OTG_FS_GAHBCFG)
func (o *USB_OTG_FS_Type) SetFS_GAHBCFG_GINT(value uint32) {
	volatile.StoreUint32(&o.FS_GAHBCFG.Reg, volatile.LoadUint32(&o.FS_GAHBCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GAHBCFG_GINT() uint32 {
	return volatile.LoadUint32(&o.FS_GAHBCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GAHBCFG_TXFELVL(value uint32) {
	volatile.StoreUint32(&o.FS_GAHBCFG.Reg, volatile.LoadUint32(&o.FS_GAHBCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetFS_GAHBCFG_TXFELVL() uint32 {
	return (volatile.LoadUint32(&o.FS_GAHBCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetFS_GAHBCFG_PTXFELVL(value uint32) {
	volatile.StoreUint32(&o.FS_GAHBCFG.Reg, volatile.LoadUint32(&o.FS_GAHBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GAHBCFG_PTXFELVL() uint32 {
	return (volatile.LoadUint32(&o.FS_GAHBCFG.Reg) & 0x100) >> 8
}

// USB_OTG_FS.FS_GUSBCFG: OTG_FS USB configuration register (OTG_FS_GUSBCFG)
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_TOCAL(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x7)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_TOCAL() uint32 {
	return volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x7
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_PHYSEL(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_PHYSEL() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_SRPCAP(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_SRPCAP() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_HNPCAP(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_HNPCAP() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_TRDT(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x3c00)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_TRDT() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x3c00) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_FHMOD(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_FHMOD() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_FDMOD(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_FDMOD() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetFS_GUSBCFG_CTXPKT(value uint32) {
	volatile.StoreUint32(&o.FS_GUSBCFG.Reg, volatile.LoadUint32(&o.FS_GUSBCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GUSBCFG_CTXPKT() uint32 {
	return (volatile.LoadUint32(&o.FS_GUSBCFG.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GRSTCTL: OTG_FS reset register (OTG_FS_GRSTCTL)
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_CSRST(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_CSRST() uint32 {
	return volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_HSRST(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_HSRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_FCRST(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_FCRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_RXFFLSH(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_RXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_TXFFLSH(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_TXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x7c0) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GRSTCTL_AHBIDL(value uint32) {
	volatile.StoreUint32(&o.FS_GRSTCTL.Reg, volatile.LoadUint32(&o.FS_GRSTCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GRSTCTL_AHBIDL() uint32 {
	return (volatile.LoadUint32(&o.FS_GRSTCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GINTSTS: OTG_FS core interrupt register (OTG_FS_GINTSTS)
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_CMOD(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_CMOD() uint32 {
	return volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_MMIS(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_MMIS() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_OTGINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_SOF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_SOF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_RXFLVL(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_RXFLVL() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_NPTXFE(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_NPTXFE() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_GINAKEFF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_GINAKEFF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_GOUTNAKEFF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_GOUTNAKEFF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_ESUSP(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_ESUSP() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_USBSUSP(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_USBSUSP() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_USBRST(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_USBRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_ENUMDNE(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_ENUMDNE() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_ISOODRP(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_ISOODRP() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_EOPF(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_EOPF() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_IEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_OEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_IISOIXFR(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_IISOIXFR() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_IPXFR_INCOMPISOOUT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_IPXFR_INCOMPISOOUT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_HPRTINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_HPRTINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_HCINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_HCINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_PTXFE(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_PTXFE() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_CIDSCHG(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_CIDSCHG() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_DISCINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_SRQINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_SRQINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetFS_GINTSTS_WKUPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTSTS.Reg, volatile.LoadUint32(&o.FS_GINTSTS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GINTSTS_WKUPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTSTS.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GINTMSK: OTG_FS interrupt mask register (OTG_FS_GINTMSK)
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_MMISM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_MMISM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_OTGINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_SOFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_SOFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_RXFLVLM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_RXFLVLM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_NPTXFEM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_NPTXFEM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_GINAKEFFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_GINAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_GONAKEFFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_GONAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_ESUSPM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_ESUSPM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_USBSUSPM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_USBSUSPM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_USBRST(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_USBRST() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_ENUMDNEM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_ENUMDNEM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_ISOODRPM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_ISOODRPM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_EOPFM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_EOPFM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_EPMISM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_EPMISM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_IEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_IISOIXFRM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_IISOIXFRM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_IPXFRM_IISOOXFRM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_IPXFRM_IISOOXFRM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_PRTIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_PRTIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_HCIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_HCIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_PTXFEM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_PTXFEM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_CIDSCHGM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_CIDSCHGM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_DISCINT(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_SRQIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_SRQIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetFS_GINTMSK_WUIM(value uint32) {
	volatile.StoreUint32(&o.FS_GINTMSK.Reg, volatile.LoadUint32(&o.FS_GINTMSK.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetFS_GINTMSK_WUIM() uint32 {
	return (volatile.LoadUint32(&o.FS_GINTMSK.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device mode)
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_EPNUM(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0xf)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_EPNUM() uint32 {
	return volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0xf
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_BCNT(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_BCNT() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_DPID(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_DPID() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetFS_GRXSTSR_Device_FRMNUM(value uint32) {
	volatile.StoreUint32(&o.FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg)&^(0x1e00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetFS_GRXSTSR_Device_FRMNUM() uint32 {
	return (volatile.LoadUint32(&o.FS_GRXSTSR_Device.Reg) & 0x1e00000) >> 21
}

// USB_OTG_FS.FS_GRXFSIZ: OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)
func (o *USB_OTG_FS_Type) SetFS_GRXFSIZ_RXFD(value uint32) {
	volatile.StoreUint32(&o.FS_GRXFSIZ.Reg, volatile.LoadUint32(&o.FS_GRXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GRXFSIZ_RXFD() uint32 {
	return volatile.LoadUint32(&o.FS_GRXFSIZ.Reg) & 0xffff
}

// USB_OTG_FS.FS_GNPTXFSIZ_Device: OTG_FS non-periodic transmit FIFO size register (Device mode)
func (o *USB_OTG_FS_Type) SetFS_GNPTXFSIZ_Device_TX0FSA(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXFSIZ_Device.Reg, volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXFSIZ_Device_TX0FSA() uint32 {
	return volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_GNPTXFSIZ_Device_TX0FD(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXFSIZ_Device.Reg, volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXFSIZ_Device_TX0FD() uint32 {
	return (volatile.LoadUint32(&o.FS_GNPTXFSIZ_Device.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_GNPTXSTS: OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)
func (o *USB_OTG_FS_Type) SetFS_GNPTXSTS_NPTXFSAV(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXSTS.Reg, volatile.LoadUint32(&o.FS_GNPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXSTS_NPTXFSAV() uint32 {
	return volatile.LoadUint32(&o.FS_GNPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_GNPTXSTS_NPTQXSAV(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXSTS.Reg, volatile.LoadUint32(&o.FS_GNPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXSTS_NPTQXSAV() uint32 {
	return (volatile.LoadUint32(&o.FS_GNPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_FS_Type) SetFS_GNPTXSTS_NPTXQTOP(value uint32) {
	volatile.StoreUint32(&o.FS_GNPTXSTS.Reg, volatile.LoadUint32(&o.FS_GNPTXSTS.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetFS_GNPTXSTS_NPTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.FS_GNPTXSTS.Reg) & 0x7f000000) >> 24
}

// USB_OTG_FS.FS_GCCFG: OTG_FS general core configuration register (OTG_FS_GCCFG)
func (o *USB_OTG_FS_Type) SetFS_GCCFG_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_PWRDWN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetFS_GCCFG_VBUSASEN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_VBUSASEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetFS_GCCFG_VBUSBSEN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_VBUSBSEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetFS_GCCFG_SOFOUTEN(value uint32) {
	volatile.StoreUint32(&o.FS_GCCFG.Reg, volatile.LoadUint32(&o.FS_GCCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetFS_GCCFG_SOFOUTEN() uint32 {
	return (volatile.LoadUint32(&o.FS_GCCFG.Reg) & 0x100000) >> 20
}

// USB_OTG_FS.FS_CID: core ID register
func (o *USB_OTG_FS_Type) SetFS_CID(value uint32) {
	volatile.StoreUint32(&o.FS_CID.Reg, value)
}
func (o *USB_OTG_FS_Type) GetFS_CID() uint32 {
	return volatile.LoadUint32(&o.FS_CID.Reg)
}

// USB_OTG_FS.FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)
func (o *USB_OTG_FS_Type) SetFS_HPTXFSIZ_PTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_HPTXFSIZ_PTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_HPTXFSIZ_PTXFSIZ(value uint32) {
	volatile.StoreUint32(&o.FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_HPTXFSIZ_PTXFSIZ() uint32 {
	return (volatile.LoadUint32(&o.FS_HPTXFSIZ.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF1_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.FS_DIEPTXF1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF1_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_DIEPTXF1.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF1_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.FS_DIEPTXF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF1_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.FS_DIEPTXF1.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF2_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.FS_DIEPTXF2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF2_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_DIEPTXF2.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF2_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.FS_DIEPTXF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF2_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.FS_DIEPTXF2.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF3_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.FS_DIEPTXF3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF3_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.FS_DIEPTXF3.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetFS_DIEPTXF3_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.FS_DIEPTXF3.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetFS_DIEPTXF3_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.FS_DIEPTXF3.Reg) & 0xffff0000) >> 16
}

// Single Wire Protocol Master Interface
type SWPMI_Type struct {
	CR  volatile.Register32 // 0x0
	BRR volatile.Register32 // 0x4
	_   [4]byte
	ISR volatile.Register32 // 0xC
	ICR volatile.Register32 // 0x10
	IER volatile.Register32 // 0x14
	RFL volatile.Register32 // 0x18
	TDR volatile.Register32 // 0x1C
	RDR volatile.Register32 // 0x20
	OR  volatile.Register32 // 0x24
}

// SWPMI.CR: SWPMI Configuration/Control register
func (o *SWPMI_Type) SetCR_RXDMA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SWPMI_Type) GetCR_RXDMA() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SWPMI_Type) SetCR_TXDMA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SWPMI_Type) GetCR_TXDMA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SWPMI_Type) SetCR_RXMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SWPMI_Type) GetCR_RXMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SWPMI_Type) SetCR_TXMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SWPMI_Type) GetCR_TXMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SWPMI_Type) SetCR_LPBK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *SWPMI_Type) GetCR_LPBK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *SWPMI_Type) SetCR_SWPACT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *SWPMI_Type) GetCR_SWPACT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *SWPMI_Type) SetCR_DEACT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *SWPMI_Type) GetCR_DEACT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}

// SWPMI.BRR: SWPMI Bitrate register
func (o *SWPMI_Type) SetBRR_BR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x3f)|value)
}
func (o *SWPMI_Type) GetBRR_BR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x3f
}

// SWPMI.ISR: SWPMI Interrupt and Status register
func (o *SWPMI_Type) SetISR_RXBFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *SWPMI_Type) GetISR_RXBFF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *SWPMI_Type) SetISR_TXBEF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *SWPMI_Type) GetISR_TXBEF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *SWPMI_Type) SetISR_RXBERF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *SWPMI_Type) GetISR_RXBERF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *SWPMI_Type) SetISR_RXOVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *SWPMI_Type) GetISR_RXOVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *SWPMI_Type) SetISR_TXUNRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *SWPMI_Type) GetISR_TXUNRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *SWPMI_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *SWPMI_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *SWPMI_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *SWPMI_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *SWPMI_Type) SetISR_TCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *SWPMI_Type) GetISR_TCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *SWPMI_Type) SetISR_SRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *SWPMI_Type) GetISR_SRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *SWPMI_Type) SetISR_SUSP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *SWPMI_Type) GetISR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *SWPMI_Type) SetISR_DEACTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *SWPMI_Type) GetISR_DEACTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}

// SWPMI.ICR: SWPMI Interrupt Flag Clear register
func (o *SWPMI_Type) SetICR_CRXBFF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SWPMI_Type) GetICR_CRXBFF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *SWPMI_Type) SetICR_CTXBEF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SWPMI_Type) GetICR_CTXBEF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SWPMI_Type) SetICR_CRXBERF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SWPMI_Type) GetICR_CRXBERF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SWPMI_Type) SetICR_CRXOVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SWPMI_Type) GetICR_CRXOVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SWPMI_Type) SetICR_CTXUNRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SWPMI_Type) GetICR_CTXUNRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SWPMI_Type) SetICR_CTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SWPMI_Type) GetICR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SWPMI_Type) SetICR_CSRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SWPMI_Type) GetICR_CSRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}

// SWPMI.IER: SWPMI Interrupt Enable register
func (o *SWPMI_Type) SetIER_RXBFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SWPMI_Type) GetIER_RXBFIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SWPMI_Type) SetIER_TXBEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SWPMI_Type) GetIER_TXBEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SWPMI_Type) SetIER_RXBERIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SWPMI_Type) GetIER_RXBERIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SWPMI_Type) SetIER_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SWPMI_Type) GetIER_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SWPMI_Type) SetIER_TXUNRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SWPMI_Type) GetIER_TXUNRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SWPMI_Type) SetIER_RIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SWPMI_Type) GetIER_RIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SWPMI_Type) SetIER_TIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SWPMI_Type) GetIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SWPMI_Type) SetIER_TCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SWPMI_Type) GetIER_TCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SWPMI_Type) SetIER_SRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SWPMI_Type) GetIER_SRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}

// SWPMI.RFL: SWPMI Receive Frame Length register
func (o *SWPMI_Type) SetRFL(value uint32) {
	volatile.StoreUint32(&o.RFL.Reg, volatile.LoadUint32(&o.RFL.Reg)&^(0x1f)|value)
}
func (o *SWPMI_Type) GetRFL() uint32 {
	return volatile.LoadUint32(&o.RFL.Reg) & 0x1f
}

// SWPMI.TDR: SWPMI Transmit data register
func (o *SWPMI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *SWPMI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// SWPMI.RDR: SWPMI Receive data register
func (o *SWPMI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *SWPMI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// SWPMI.OR: SWPMI Option register
func (o *SWPMI_Type) SetOR_SWP_TBYP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *SWPMI_Type) GetOR_SWP_TBYP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *SWPMI_Type) SetOR_SWP_CLASS(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *SWPMI_Type) GetOR_SWP_CLASS() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// Operational amplifiers
type OPAMP_Type struct {
	OPAMP1_CSR   volatile.Register32 // 0x0
	OPAMP1_OTR   volatile.Register32 // 0x4
	OPAMP1_LPOTR volatile.Register32 // 0x8
	_            [4]byte
	OPAMP2_CSR   volatile.Register32 // 0x10
	OPAMP2_OTR   volatile.Register32 // 0x14
	OPAMP2_LPOTR volatile.Register32 // 0x18
}

// OPAMP.OPAMP1_CSR: OPAMP1 control/status register
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP1_CSR_OPALPM(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPALPM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAMODE(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAMODE() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP1_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x30)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x30) >> 4
}
func (o *OPAMP_Type) SetOPAMP1_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x300)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x300) >> 8
}
func (o *OPAMP_Type) SetOPAMP1_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x400)|value<<10)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x400) >> 10
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x1000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x1000) >> 12
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x2000)|value<<13)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x2000) >> 13
}
func (o *OPAMP_Type) SetOPAMP1_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x4000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x4000) >> 14
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x8000) >> 15
}
func (o *OPAMP_Type) SetOPAMP1_CSR_OPA_RANGE(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPA_RANGE() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x80000000) >> 31
}

// OPAMP.OPAMP1_OTR: OPAMP1 offset trimming register in normal mode
func (o *OPAMP_Type) SetOPAMP1_OTR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_OTR.Reg, volatile.LoadUint32(&o.OPAMP1_OTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP1_OTR_TRIMOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_OTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP1_OTR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_OTR.Reg, volatile.LoadUint32(&o.OPAMP1_OTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_OTR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_OTR.Reg) & 0x1f00) >> 8
}

// OPAMP.OPAMP1_LPOTR: OPAMP1 offset trimming register in low-power mode
func (o *OPAMP_Type) SetOPAMP1_LPOTR_TRIMLPOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_LPOTR.Reg, volatile.LoadUint32(&o.OPAMP1_LPOTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP1_LPOTR_TRIMLPOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_LPOTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP1_LPOTR_TRIMLPOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_LPOTR.Reg, volatile.LoadUint32(&o.OPAMP1_LPOTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_LPOTR_TRIMLPOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_LPOTR.Reg) & 0x1f00) >> 8
}

// OPAMP.OPAMP2_CSR: OPAMP2 control/status register
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_OPALPM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPALPM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAMODE(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAMODE() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP2_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x30)|value<<4)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x30) >> 4
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x300)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x300) >> 8
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x400)|value<<10)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x400) >> 10
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1000) >> 12
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x2000)|value<<13)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x2000) >> 13
}
func (o *OPAMP_Type) SetOPAMP2_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x4000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x4000) >> 14
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x8000) >> 15
}

// OPAMP.OPAMP2_OTR: OPAMP2 offset trimming register in normal mode
func (o *OPAMP_Type) SetOPAMP2_OTR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_OTR.Reg, volatile.LoadUint32(&o.OPAMP2_OTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP2_OTR_TRIMOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_OTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP2_OTR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_OTR.Reg, volatile.LoadUint32(&o.OPAMP2_OTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_OTR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_OTR.Reg) & 0x1f00) >> 8
}

// OPAMP.OPAMP2_LPOTR: OPAMP2 offset trimming register in low-power mode
func (o *OPAMP_Type) SetOPAMP2_LPOTR_TRIMLPOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_LPOTR.Reg, volatile.LoadUint32(&o.OPAMP2_LPOTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP2_LPOTR_TRIMLPOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_LPOTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP2_LPOTR_TRIMLPOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_LPOTR.Reg, volatile.LoadUint32(&o.OPAMP2_LPOTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_LPOTR_TRIMLPOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_LPOTR.Reg) & 0x1f00) >> 8
}

// Flexible memory controller
type FMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// FMC.BCR1: SRAM/NOR-Flash chip-select control register 1
func (o *FMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR1_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR1_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR1_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR1_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200000) >> 21
}

// FMC.BTR1: SRAM/NOR-Flash chip-select timing register 1
func (o *FMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}

// FMC.BCR2: SRAM/NOR-Flash chip-select control register 2
func (o *FMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR2_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x400)|value<<10)
}
func (o *FMC_Type) GetBCR2_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x400) >> 10
}
func (o *FMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}

// FMC.BTR2: SRAM/NOR-Flash chip-select timing register 2
func (o *FMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}

// FMC.BCR3: SRAM/NOR-Flash chip-select control register 3
func (o *FMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR3_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x400)|value<<10)
}
func (o *FMC_Type) GetBCR3_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x400) >> 10
}
func (o *FMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}

// FMC.BTR3: SRAM/NOR-Flash chip-select timing register 3
func (o *FMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}

// FMC.BCR4: SRAM/NOR-Flash chip-select control register 4
func (o *FMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR4_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x400)|value<<10)
}
func (o *FMC_Type) GetBCR4_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x400) >> 10
}
func (o *FMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}

// FMC.BTR4: SRAM/NOR-Flash chip-select timing register 4
func (o *FMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}

// FMC.PCR: PC Card/NAND Flash control register 3
func (o *FMC_Type) SetPCR_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xe0000)|value<<17)
}
func (o *FMC_Type) GetPCR_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xe0000) >> 17
}
func (o *FMC_Type) SetPCR_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e000)|value<<13)
}
func (o *FMC_Type) GetPCR_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e000) >> 13
}
func (o *FMC_Type) SetPCR_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e00)|value<<9)
}
func (o *FMC_Type) GetPCR_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e00) >> 9
}
func (o *FMC_Type) SetPCR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetPCR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetPCR_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetPCR_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetPCR_PTYP(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetPCR_PTYP() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetPCR_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPCR_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPCR_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPCR_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2) >> 1
}

// FMC.SR: FIFO status and interrupt register 3
func (o *FMC_Type) SetSR_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetSR_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetSR_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FMC_Type) GetSR_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FMC_Type) SetSR_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetSR_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetSR_IREN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetSR_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetSR_IFS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetSR_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetSR_ILS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetSR_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetSR_IRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSR_IRS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// FMC.PMEM: Common memory space timing register 3
func (o *FMC_Type) SetPMEM_MEMHIZx(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff000000)|value<<24)
}
func (o *FMC_Type) GetPMEM_MEMHIZx() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff000000) >> 24
}
func (o *FMC_Type) SetPMEM_MEMHOLDx(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff0000)|value<<16)
}
func (o *FMC_Type) GetPMEM_MEMHOLDx() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff0000) >> 16
}
func (o *FMC_Type) SetPMEM_MEMWAITx(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetPMEM_MEMWAITx() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetPMEM_MEMSETx(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff)|value)
}
func (o *FMC_Type) GetPMEM_MEMSETx() uint32 {
	return volatile.LoadUint32(&o.PMEM.Reg) & 0xff
}

// FMC.PATT: Attribute memory space timing register 3
func (o *FMC_Type) SetPATT_ATTHIZx(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff000000)|value<<24)
}
func (o *FMC_Type) GetPATT_ATTHIZx() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff000000) >> 24
}
func (o *FMC_Type) SetPATT_ATTHOLDx(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff0000)|value<<16)
}
func (o *FMC_Type) GetPATT_ATTHOLDx() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff0000) >> 16
}
func (o *FMC_Type) SetPATT_ATTWAITx(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetPATT_ATTWAITx() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetPATT_ATTSETx(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff)|value)
}
func (o *FMC_Type) GetPATT_ATTSETx() uint32 {
	return volatile.LoadUint32(&o.PATT.Reg) & 0xff
}

// FMC.ECCR: ECC result register 3
func (o *FMC_Type) SetECCR(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, value)
}
func (o *FMC_Type) GetECCR() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg)
}

// FMC.BWTR1: SRAM/NOR-Flash write timing registers 1
func (o *FMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBWTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBWTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBWTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBWTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}

// FMC.BWTR2: SRAM/NOR-Flash write timing registers 2
func (o *FMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBWTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBWTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBWTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBWTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}

// FMC.BWTR3: SRAM/NOR-Flash write timing registers 3
func (o *FMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBWTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBWTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBWTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBWTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}

// FMC.BWTR4: SRAM/NOR-Flash write timing registers 4
func (o *FMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}
func (o *FMC_Type) SetBWTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBWTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBWTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBWTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// CRS.CR: control register
func (o *CRS_Type) SetCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00)|value<<8)
}
func (o *CRS_Type) GetCR_TRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00) >> 8
}
func (o *CRS_Type) SetCR_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRS_Type) GetCR_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRS_Type) SetCR_AUTOTRIMEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *CRS_Type) GetCR_AUTOTRIMEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *CRS_Type) SetCR_CEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *CRS_Type) GetCR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *CRS_Type) SetCR_ESYNCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetCR_ESYNCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetCR_SYNCWARNIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetCR_SYNCWARNIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetCR_SYNCOKIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetCR_SYNCOKIE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRS.CFGR: configuration register
func (o *CRS_Type) SetCFGR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRS_Type) GetCFGR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}
func (o *CRS_Type) SetCFGR_SYNCSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x30000000)|value<<28)
}
func (o *CRS_Type) GetCFGR_SYNCSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x30000000) >> 28
}
func (o *CRS_Type) SetCFGR_SYNCDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *CRS_Type) GetCFGR_SYNCDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *CRS_Type) SetCFGR_FELIM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *CRS_Type) GetCFGR_FELIM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xff0000) >> 16
}
func (o *CRS_Type) SetCFGR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xffff)|value)
}
func (o *CRS_Type) GetCFGR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xffff
}

// CRS.ISR: interrupt and status register
func (o *CRS_Type) SetISR_FECAP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRS_Type) GetISR_FECAP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xffff0000) >> 16
}
func (o *CRS_Type) SetISR_FEDIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *CRS_Type) GetISR_FEDIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *CRS_Type) SetISR_TRIMOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CRS_Type) GetISR_TRIMOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CRS_Type) SetISR_SYNCMISS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CRS_Type) GetISR_SYNCMISS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CRS_Type) SetISR_SYNCERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CRS_Type) GetISR_SYNCERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CRS_Type) SetISR_ESYNCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetISR_ESYNCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetISR_ERRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetISR_ERRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetISR_SYNCWARNF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetISR_SYNCWARNF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetISR_SYNCOKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetISR_SYNCOKF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// CRS.ICR: interrupt flag clear register
func (o *CRS_Type) SetICR_ESYNCC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetICR_ESYNCC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetICR_ERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetICR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetICR_SYNCWARNC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetICR_SYNCWARNC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetICR_SYNCOKC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetICR_SYNCOKC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// DCMI.CR: control register 1
func (o *DCMI_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DCMI_Type) GetCR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DCMI_Type) SetCR_EDM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DCMI_Type) GetCR_EDM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DCMI_Type) SetCR_FCRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DCMI_Type) GetCR_FCRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DCMI_Type) SetCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DCMI_Type) GetCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DCMI_Type) SetCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DCMI_Type) GetCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DCMI_Type) SetCR_PCKPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DCMI_Type) GetCR_PCKPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DCMI_Type) SetCR_ESS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetCR_ESS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetCR_JPEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetCR_JPEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetCR_CROP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetCR_CROP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetCR_CM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetCR_CM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetCR_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetCR_CAPTURE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DCMI_Type) SetCR_OELS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *DCMI_Type) GetCR_OELS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *DCMI_Type) SetCR_LSM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DCMI_Type) GetCR_LSM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DCMI_Type) SetCR_OEBS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DCMI_Type) GetCR_OEBS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DCMI_Type) SetCR_BSM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DCMI_Type) GetCR_BSM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}

// DCMI.SR: status register
func (o *DCMI_Type) SetSR_FNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetSR_FNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetSR_HSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetSR_HSYNC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DCMI.RIS: raw interrupt status register
func (o *DCMI_Type) SetRIS_LINE_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetRIS_LINE_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetRIS_VSYNC_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetRIS_VSYNC_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetRIS_ERR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetRIS_ERR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetRIS_OVR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetRIS_OVR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetRIS_FRAME_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetRIS_FRAME_RIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}

// DCMI.IER: interrupt enable register
func (o *DCMI_Type) SetIER_LINE_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetIER_LINE_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetIER_VSYNC_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetIER_VSYNC_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetIER_ERR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetIER_ERR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetIER_OVR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetIER_OVR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetIER_FRAME_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetIER_FRAME_IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// DCMI.MIS: masked interrupt status register
func (o *DCMI_Type) SetMIS_LINE_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetMIS_LINE_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetMIS_VSYNC_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetMIS_VSYNC_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetMIS_ERR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetMIS_ERR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetMIS_OVR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetMIS_OVR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetMIS_FRAME_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetMIS_FRAME_MIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}

// DCMI.ICR: interrupt clear register
func (o *DCMI_Type) SetICR_LINE_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetICR_LINE_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetICR_VSYNC_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetICR_VSYNC_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetICR_ERR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetICR_ERR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetICR_OVR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetICR_OVR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetICR_FRAME_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetICR_FRAME_ISC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// DCMI.ESCR: embedded synchronization code register
func (o *DCMI_Type) SetESCR_FEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESCR_FEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESCR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESCR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESCR_LSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESCR_LSC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESCR_FSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESCR_FSC() uint32 {
	return volatile.LoadUint32(&o.ESCR.Reg) & 0xff
}

// DCMI.ESUR: embedded synchronization unmask register
func (o *DCMI_Type) SetESUR_FEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESUR_FEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESUR_LEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESUR_LEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESUR_LSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESUR_LSU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESUR_FSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESUR_FSU() uint32 {
	return volatile.LoadUint32(&o.ESUR.Reg) & 0xff
}

// DCMI.CWSTRT: crop window start
func (o *DCMI_Type) SetCWSTRT_VST(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x1fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSTRT_VST() uint32 {
	return (volatile.LoadUint32(&o.CWSTRT.Reg) & 0x1fff0000) >> 16
}
func (o *DCMI_Type) SetCWSTRT_HOFFCNT(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSTRT_HOFFCNT() uint32 {
	return volatile.LoadUint32(&o.CWSTRT.Reg) & 0x3fff
}

// DCMI.CWSIZE: crop window size
func (o *DCMI_Type) SetCWSIZE_VLINE(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSIZE_VLINE() uint32 {
	return (volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff0000) >> 16
}
func (o *DCMI_Type) SetCWSIZE_CAPCNT(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSIZE_CAPCNT() uint32 {
	return volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff
}

// DCMI.DR: data register
func (o *DCMI_Type) SetDR_Byte3(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetDR_Byte3() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetDR_Byte2(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetDR_Byte2() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetDR_Byte1(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetDR_Byte1() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetDR_Byte0(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetDR_Byte0() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// Hash processor
type HASH_Type struct {
	CR       volatile.Register32 // 0x0
	DIN      volatile.Register32 // 0x4
	STR      volatile.Register32 // 0x8
	HR0      volatile.Register32 // 0xC
	_        [16]byte
	IMR      volatile.Register32 // 0x20
	SR       volatile.Register32 // 0x24
	_        [208]byte
	CSR0     volatile.Register32 // 0xF8
	CSR1     volatile.Register32 // 0xFC
	CSR2     volatile.Register32 // 0x100
	CSR3     volatile.Register32 // 0x104
	CSR4     volatile.Register32 // 0x108
	CSR5     volatile.Register32 // 0x10C
	CSR6     volatile.Register32 // 0x110
	CSR7     volatile.Register32 // 0x114
	CSR8     volatile.Register32 // 0x118
	CSR9     volatile.Register32 // 0x11C
	CSR10    volatile.Register32 // 0x120
	CSR11    volatile.Register32 // 0x124
	CSR12    volatile.Register32 // 0x128
	CSR13    volatile.Register32 // 0x12C
	CSR14    volatile.Register32 // 0x130
	CSR15    volatile.Register32 // 0x134
	CSR16    volatile.Register32 // 0x138
	CSR17    volatile.Register32 // 0x13C
	CSR18    volatile.Register32 // 0x140
	CSR19    volatile.Register32 // 0x144
	CSR20    volatile.Register32 // 0x148
	CSR21    volatile.Register32 // 0x14C
	CSR22    volatile.Register32 // 0x150
	CSR23    volatile.Register32 // 0x154
	CSR24    volatile.Register32 // 0x158
	CSR25    volatile.Register32 // 0x15C
	CSR26    volatile.Register32 // 0x160
	CSR27    volatile.Register32 // 0x164
	CSR28    volatile.Register32 // 0x168
	CSR29    volatile.Register32 // 0x16C
	CSR30    volatile.Register32 // 0x170
	CSR31    volatile.Register32 // 0x174
	CSR32    volatile.Register32 // 0x178
	CSR33    volatile.Register32 // 0x17C
	CSR34    volatile.Register32 // 0x180
	CSR35    volatile.Register32 // 0x184
	CSR36    volatile.Register32 // 0x188
	CSR37    volatile.Register32 // 0x18C
	CSR38    volatile.Register32 // 0x190
	CSR39    volatile.Register32 // 0x194
	CSR40    volatile.Register32 // 0x198
	CSR41    volatile.Register32 // 0x19C
	CSR42    volatile.Register32 // 0x1A0
	CSR43    volatile.Register32 // 0x1A4
	CSR44    volatile.Register32 // 0x1A8
	CSR45    volatile.Register32 // 0x1AC
	CSR46    volatile.Register32 // 0x1B0
	CSR47    volatile.Register32 // 0x1B4
	CSR48    volatile.Register32 // 0x1B8
	CSR49    volatile.Register32 // 0x1BC
	CSR50    volatile.Register32 // 0x1C0
	CSR51    volatile.Register32 // 0x1C4
	CSR52    volatile.Register32 // 0x1C8
	CSR53    volatile.Register32 // 0x1CC
	_        [320]byte
	HASH_HR0 volatile.Register32 // 0x310
	HASH_HR1 volatile.Register32 // 0x314
	HASH_HR2 volatile.Register32 // 0x318
	HASH_HR3 volatile.Register32 // 0x31C
	HASH_HR4 volatile.Register32 // 0x320
	HASH_HR5 volatile.Register32 // 0x324
	HASH_HR6 volatile.Register32 // 0x328
	HASH_HR7 volatile.Register32 // 0x32C
}

// HASH.CR: control register
func (o *HASH_Type) SetCR_INIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HASH_Type) GetCR_INIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HASH_Type) SetCR_DMAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HASH_Type) GetCR_DMAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HASH_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *HASH_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *HASH_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *HASH_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *HASH_Type) SetCR_ALGO0(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HASH_Type) GetCR_ALGO0() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *HASH_Type) SetCR_NBW(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *HASH_Type) GetCR_NBW() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *HASH_Type) SetCR_DINNE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *HASH_Type) GetCR_DINNE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *HASH_Type) SetCR_MDMAT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *HASH_Type) GetCR_MDMAT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *HASH_Type) SetCR_LKEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *HASH_Type) GetCR_LKEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *HASH_Type) SetCR_ALGO1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *HASH_Type) GetCR_ALGO1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}

// HASH.DIN: data input register
func (o *HASH_Type) SetDIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, value)
}
func (o *HASH_Type) GetDIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg)
}

// HASH.STR: start register
func (o *HASH_Type) SetSTR_DCAL(value uint32) {
	volatile.StoreUint32(&o.STR.Reg, volatile.LoadUint32(&o.STR.Reg)&^(0x100)|value<<8)
}
func (o *HASH_Type) GetSTR_DCAL() uint32 {
	return (volatile.LoadUint32(&o.STR.Reg) & 0x100) >> 8
}
func (o *HASH_Type) SetSTR_NBLW(value uint32) {
	volatile.StoreUint32(&o.STR.Reg, volatile.LoadUint32(&o.STR.Reg)&^(0x1f)|value)
}
func (o *HASH_Type) GetSTR_NBLW() uint32 {
	return volatile.LoadUint32(&o.STR.Reg) & 0x1f
}

// HASH.HR0: digest registers
func (o *HASH_Type) SetHR0(value uint32) {
	volatile.StoreUint32(&o.HR0.Reg, value)
}
func (o *HASH_Type) GetHR0() uint32 {
	return volatile.LoadUint32(&o.HR0.Reg)
}

// HASH.IMR: interrupt enable register
func (o *HASH_Type) SetIMR_DCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HASH_Type) GetIMR_DCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HASH_Type) SetIMR_DINIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HASH_Type) GetIMR_DINIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// HASH.SR: status register
func (o *HASH_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HASH_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HASH_Type) SetSR_DMAS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HASH_Type) GetSR_DMAS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HASH_Type) SetSR_DCIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HASH_Type) GetSR_DCIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HASH_Type) SetSR_DINIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HASH_Type) GetSR_DINIS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// HASH.CSR0: context swap registers
func (o *HASH_Type) SetCSR0(value uint32) {
	volatile.StoreUint32(&o.CSR0.Reg, value)
}
func (o *HASH_Type) GetCSR0() uint32 {
	return volatile.LoadUint32(&o.CSR0.Reg)
}

// HASH.CSR1: context swap registers
func (o *HASH_Type) SetCSR1(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, value)
}
func (o *HASH_Type) GetCSR1() uint32 {
	return volatile.LoadUint32(&o.CSR1.Reg)
}

// HASH.CSR2: context swap registers
func (o *HASH_Type) SetCSR2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, value)
}
func (o *HASH_Type) GetCSR2() uint32 {
	return volatile.LoadUint32(&o.CSR2.Reg)
}

// HASH.CSR3: context swap registers
func (o *HASH_Type) SetCSR3(value uint32) {
	volatile.StoreUint32(&o.CSR3.Reg, value)
}
func (o *HASH_Type) GetCSR3() uint32 {
	return volatile.LoadUint32(&o.CSR3.Reg)
}

// HASH.CSR4: context swap registers
func (o *HASH_Type) SetCSR4(value uint32) {
	volatile.StoreUint32(&o.CSR4.Reg, value)
}
func (o *HASH_Type) GetCSR4() uint32 {
	return volatile.LoadUint32(&o.CSR4.Reg)
}

// HASH.CSR5: context swap registers
func (o *HASH_Type) SetCSR5(value uint32) {
	volatile.StoreUint32(&o.CSR5.Reg, value)
}
func (o *HASH_Type) GetCSR5() uint32 {
	return volatile.LoadUint32(&o.CSR5.Reg)
}

// HASH.CSR6: context swap registers
func (o *HASH_Type) SetCSR6(value uint32) {
	volatile.StoreUint32(&o.CSR6.Reg, value)
}
func (o *HASH_Type) GetCSR6() uint32 {
	return volatile.LoadUint32(&o.CSR6.Reg)
}

// HASH.CSR7: context swap registers
func (o *HASH_Type) SetCSR7(value uint32) {
	volatile.StoreUint32(&o.CSR7.Reg, value)
}
func (o *HASH_Type) GetCSR7() uint32 {
	return volatile.LoadUint32(&o.CSR7.Reg)
}

// HASH.CSR8: context swap registers
func (o *HASH_Type) SetCSR8(value uint32) {
	volatile.StoreUint32(&o.CSR8.Reg, value)
}
func (o *HASH_Type) GetCSR8() uint32 {
	return volatile.LoadUint32(&o.CSR8.Reg)
}

// HASH.CSR9: context swap registers
func (o *HASH_Type) SetCSR9(value uint32) {
	volatile.StoreUint32(&o.CSR9.Reg, value)
}
func (o *HASH_Type) GetCSR9() uint32 {
	return volatile.LoadUint32(&o.CSR9.Reg)
}

// HASH.CSR10: context swap registers
func (o *HASH_Type) SetCSR10(value uint32) {
	volatile.StoreUint32(&o.CSR10.Reg, value)
}
func (o *HASH_Type) GetCSR10() uint32 {
	return volatile.LoadUint32(&o.CSR10.Reg)
}

// HASH.CSR11: context swap registers
func (o *HASH_Type) SetCSR11(value uint32) {
	volatile.StoreUint32(&o.CSR11.Reg, value)
}
func (o *HASH_Type) GetCSR11() uint32 {
	return volatile.LoadUint32(&o.CSR11.Reg)
}

// HASH.CSR12: context swap registers
func (o *HASH_Type) SetCSR12(value uint32) {
	volatile.StoreUint32(&o.CSR12.Reg, value)
}
func (o *HASH_Type) GetCSR12() uint32 {
	return volatile.LoadUint32(&o.CSR12.Reg)
}

// HASH.CSR13: context swap registers
func (o *HASH_Type) SetCSR13(value uint32) {
	volatile.StoreUint32(&o.CSR13.Reg, value)
}
func (o *HASH_Type) GetCSR13() uint32 {
	return volatile.LoadUint32(&o.CSR13.Reg)
}

// HASH.CSR14: context swap registers
func (o *HASH_Type) SetCSR14(value uint32) {
	volatile.StoreUint32(&o.CSR14.Reg, value)
}
func (o *HASH_Type) GetCSR14() uint32 {
	return volatile.LoadUint32(&o.CSR14.Reg)
}

// HASH.CSR15: context swap registers
func (o *HASH_Type) SetCSR15(value uint32) {
	volatile.StoreUint32(&o.CSR15.Reg, value)
}
func (o *HASH_Type) GetCSR15() uint32 {
	return volatile.LoadUint32(&o.CSR15.Reg)
}

// HASH.CSR16: context swap registers
func (o *HASH_Type) SetCSR16(value uint32) {
	volatile.StoreUint32(&o.CSR16.Reg, value)
}
func (o *HASH_Type) GetCSR16() uint32 {
	return volatile.LoadUint32(&o.CSR16.Reg)
}

// HASH.CSR17: context swap registers
func (o *HASH_Type) SetCSR17(value uint32) {
	volatile.StoreUint32(&o.CSR17.Reg, value)
}
func (o *HASH_Type) GetCSR17() uint32 {
	return volatile.LoadUint32(&o.CSR17.Reg)
}

// HASH.CSR18: context swap registers
func (o *HASH_Type) SetCSR18(value uint32) {
	volatile.StoreUint32(&o.CSR18.Reg, value)
}
func (o *HASH_Type) GetCSR18() uint32 {
	return volatile.LoadUint32(&o.CSR18.Reg)
}

// HASH.CSR19: context swap registers
func (o *HASH_Type) SetCSR19(value uint32) {
	volatile.StoreUint32(&o.CSR19.Reg, value)
}
func (o *HASH_Type) GetCSR19() uint32 {
	return volatile.LoadUint32(&o.CSR19.Reg)
}

// HASH.CSR20: context swap registers
func (o *HASH_Type) SetCSR20(value uint32) {
	volatile.StoreUint32(&o.CSR20.Reg, value)
}
func (o *HASH_Type) GetCSR20() uint32 {
	return volatile.LoadUint32(&o.CSR20.Reg)
}

// HASH.CSR21: context swap registers
func (o *HASH_Type) SetCSR21(value uint32) {
	volatile.StoreUint32(&o.CSR21.Reg, value)
}
func (o *HASH_Type) GetCSR21() uint32 {
	return volatile.LoadUint32(&o.CSR21.Reg)
}

// HASH.CSR22: context swap registers
func (o *HASH_Type) SetCSR22(value uint32) {
	volatile.StoreUint32(&o.CSR22.Reg, value)
}
func (o *HASH_Type) GetCSR22() uint32 {
	return volatile.LoadUint32(&o.CSR22.Reg)
}

// HASH.CSR23: context swap registers
func (o *HASH_Type) SetCSR23(value uint32) {
	volatile.StoreUint32(&o.CSR23.Reg, value)
}
func (o *HASH_Type) GetCSR23() uint32 {
	return volatile.LoadUint32(&o.CSR23.Reg)
}

// HASH.CSR24: context swap registers
func (o *HASH_Type) SetCSR24(value uint32) {
	volatile.StoreUint32(&o.CSR24.Reg, value)
}
func (o *HASH_Type) GetCSR24() uint32 {
	return volatile.LoadUint32(&o.CSR24.Reg)
}

// HASH.CSR25: context swap registers
func (o *HASH_Type) SetCSR25(value uint32) {
	volatile.StoreUint32(&o.CSR25.Reg, value)
}
func (o *HASH_Type) GetCSR25() uint32 {
	return volatile.LoadUint32(&o.CSR25.Reg)
}

// HASH.CSR26: context swap registers
func (o *HASH_Type) SetCSR26(value uint32) {
	volatile.StoreUint32(&o.CSR26.Reg, value)
}
func (o *HASH_Type) GetCSR26() uint32 {
	return volatile.LoadUint32(&o.CSR26.Reg)
}

// HASH.CSR27: context swap registers
func (o *HASH_Type) SetCSR27(value uint32) {
	volatile.StoreUint32(&o.CSR27.Reg, value)
}
func (o *HASH_Type) GetCSR27() uint32 {
	return volatile.LoadUint32(&o.CSR27.Reg)
}

// HASH.CSR28: context swap registers
func (o *HASH_Type) SetCSR28(value uint32) {
	volatile.StoreUint32(&o.CSR28.Reg, value)
}
func (o *HASH_Type) GetCSR28() uint32 {
	return volatile.LoadUint32(&o.CSR28.Reg)
}

// HASH.CSR29: context swap registers
func (o *HASH_Type) SetCSR29(value uint32) {
	volatile.StoreUint32(&o.CSR29.Reg, value)
}
func (o *HASH_Type) GetCSR29() uint32 {
	return volatile.LoadUint32(&o.CSR29.Reg)
}

// HASH.CSR30: context swap registers
func (o *HASH_Type) SetCSR30(value uint32) {
	volatile.StoreUint32(&o.CSR30.Reg, value)
}
func (o *HASH_Type) GetCSR30() uint32 {
	return volatile.LoadUint32(&o.CSR30.Reg)
}

// HASH.CSR31: context swap registers
func (o *HASH_Type) SetCSR31(value uint32) {
	volatile.StoreUint32(&o.CSR31.Reg, value)
}
func (o *HASH_Type) GetCSR31() uint32 {
	return volatile.LoadUint32(&o.CSR31.Reg)
}

// HASH.CSR32: context swap registers
func (o *HASH_Type) SetCSR32(value uint32) {
	volatile.StoreUint32(&o.CSR32.Reg, value)
}
func (o *HASH_Type) GetCSR32() uint32 {
	return volatile.LoadUint32(&o.CSR32.Reg)
}

// HASH.CSR33: context swap registers
func (o *HASH_Type) SetCSR33(value uint32) {
	volatile.StoreUint32(&o.CSR33.Reg, value)
}
func (o *HASH_Type) GetCSR33() uint32 {
	return volatile.LoadUint32(&o.CSR33.Reg)
}

// HASH.CSR34: context swap registers
func (o *HASH_Type) SetCSR34(value uint32) {
	volatile.StoreUint32(&o.CSR34.Reg, value)
}
func (o *HASH_Type) GetCSR34() uint32 {
	return volatile.LoadUint32(&o.CSR34.Reg)
}

// HASH.CSR35: context swap registers
func (o *HASH_Type) SetCSR35(value uint32) {
	volatile.StoreUint32(&o.CSR35.Reg, value)
}
func (o *HASH_Type) GetCSR35() uint32 {
	return volatile.LoadUint32(&o.CSR35.Reg)
}

// HASH.CSR36: context swap registers
func (o *HASH_Type) SetCSR36(value uint32) {
	volatile.StoreUint32(&o.CSR36.Reg, value)
}
func (o *HASH_Type) GetCSR36() uint32 {
	return volatile.LoadUint32(&o.CSR36.Reg)
}

// HASH.CSR37: context swap registers
func (o *HASH_Type) SetCSR37(value uint32) {
	volatile.StoreUint32(&o.CSR37.Reg, value)
}
func (o *HASH_Type) GetCSR37() uint32 {
	return volatile.LoadUint32(&o.CSR37.Reg)
}

// HASH.CSR38: context swap registers
func (o *HASH_Type) SetCSR38(value uint32) {
	volatile.StoreUint32(&o.CSR38.Reg, value)
}
func (o *HASH_Type) GetCSR38() uint32 {
	return volatile.LoadUint32(&o.CSR38.Reg)
}

// HASH.CSR39: context swap registers
func (o *HASH_Type) SetCSR39(value uint32) {
	volatile.StoreUint32(&o.CSR39.Reg, value)
}
func (o *HASH_Type) GetCSR39() uint32 {
	return volatile.LoadUint32(&o.CSR39.Reg)
}

// HASH.CSR40: context swap registers
func (o *HASH_Type) SetCSR40(value uint32) {
	volatile.StoreUint32(&o.CSR40.Reg, value)
}
func (o *HASH_Type) GetCSR40() uint32 {
	return volatile.LoadUint32(&o.CSR40.Reg)
}

// HASH.CSR41: context swap registers
func (o *HASH_Type) SetCSR41(value uint32) {
	volatile.StoreUint32(&o.CSR41.Reg, value)
}
func (o *HASH_Type) GetCSR41() uint32 {
	return volatile.LoadUint32(&o.CSR41.Reg)
}

// HASH.CSR42: context swap registers
func (o *HASH_Type) SetCSR42(value uint32) {
	volatile.StoreUint32(&o.CSR42.Reg, value)
}
func (o *HASH_Type) GetCSR42() uint32 {
	return volatile.LoadUint32(&o.CSR42.Reg)
}

// HASH.CSR43: context swap registers
func (o *HASH_Type) SetCSR43(value uint32) {
	volatile.StoreUint32(&o.CSR43.Reg, value)
}
func (o *HASH_Type) GetCSR43() uint32 {
	return volatile.LoadUint32(&o.CSR43.Reg)
}

// HASH.CSR44: context swap registers
func (o *HASH_Type) SetCSR44(value uint32) {
	volatile.StoreUint32(&o.CSR44.Reg, value)
}
func (o *HASH_Type) GetCSR44() uint32 {
	return volatile.LoadUint32(&o.CSR44.Reg)
}

// HASH.CSR45: context swap registers
func (o *HASH_Type) SetCSR45(value uint32) {
	volatile.StoreUint32(&o.CSR45.Reg, value)
}
func (o *HASH_Type) GetCSR45() uint32 {
	return volatile.LoadUint32(&o.CSR45.Reg)
}

// HASH.CSR46: context swap registers
func (o *HASH_Type) SetCSR46(value uint32) {
	volatile.StoreUint32(&o.CSR46.Reg, value)
}
func (o *HASH_Type) GetCSR46() uint32 {
	return volatile.LoadUint32(&o.CSR46.Reg)
}

// HASH.CSR47: context swap registers
func (o *HASH_Type) SetCSR47(value uint32) {
	volatile.StoreUint32(&o.CSR47.Reg, value)
}
func (o *HASH_Type) GetCSR47() uint32 {
	return volatile.LoadUint32(&o.CSR47.Reg)
}

// HASH.CSR48: context swap registers
func (o *HASH_Type) SetCSR48(value uint32) {
	volatile.StoreUint32(&o.CSR48.Reg, value)
}
func (o *HASH_Type) GetCSR48() uint32 {
	return volatile.LoadUint32(&o.CSR48.Reg)
}

// HASH.CSR49: context swap registers
func (o *HASH_Type) SetCSR49(value uint32) {
	volatile.StoreUint32(&o.CSR49.Reg, value)
}
func (o *HASH_Type) GetCSR49() uint32 {
	return volatile.LoadUint32(&o.CSR49.Reg)
}

// HASH.CSR50: context swap registers
func (o *HASH_Type) SetCSR50(value uint32) {
	volatile.StoreUint32(&o.CSR50.Reg, value)
}
func (o *HASH_Type) GetCSR50() uint32 {
	return volatile.LoadUint32(&o.CSR50.Reg)
}

// HASH.CSR51: context swap registers
func (o *HASH_Type) SetCSR51(value uint32) {
	volatile.StoreUint32(&o.CSR51.Reg, value)
}
func (o *HASH_Type) GetCSR51() uint32 {
	return volatile.LoadUint32(&o.CSR51.Reg)
}

// HASH.CSR52: context swap registers
func (o *HASH_Type) SetCSR52(value uint32) {
	volatile.StoreUint32(&o.CSR52.Reg, value)
}
func (o *HASH_Type) GetCSR52() uint32 {
	return volatile.LoadUint32(&o.CSR52.Reg)
}

// HASH.CSR53: context swap registers
func (o *HASH_Type) SetCSR53(value uint32) {
	volatile.StoreUint32(&o.CSR53.Reg, value)
}
func (o *HASH_Type) GetCSR53() uint32 {
	return volatile.LoadUint32(&o.CSR53.Reg)
}

// HASH.HASH_HR0: HASH digest register
func (o *HASH_Type) SetHASH_HR0(value uint32) {
	volatile.StoreUint32(&o.HASH_HR0.Reg, value)
}
func (o *HASH_Type) GetHASH_HR0() uint32 {
	return volatile.LoadUint32(&o.HASH_HR0.Reg)
}

// HASH.HASH_HR1: HASH digest register
func (o *HASH_Type) SetHASH_HR1(value uint32) {
	volatile.StoreUint32(&o.HASH_HR1.Reg, value)
}
func (o *HASH_Type) GetHASH_HR1() uint32 {
	return volatile.LoadUint32(&o.HASH_HR1.Reg)
}

// HASH.HASH_HR2: HASH digest register
func (o *HASH_Type) SetHASH_HR2(value uint32) {
	volatile.StoreUint32(&o.HASH_HR2.Reg, value)
}
func (o *HASH_Type) GetHASH_HR2() uint32 {
	return volatile.LoadUint32(&o.HASH_HR2.Reg)
}

// HASH.HASH_HR3: HASH digest register
func (o *HASH_Type) SetHASH_HR3(value uint32) {
	volatile.StoreUint32(&o.HASH_HR3.Reg, value)
}
func (o *HASH_Type) GetHASH_HR3() uint32 {
	return volatile.LoadUint32(&o.HASH_HR3.Reg)
}

// HASH.HASH_HR4: HASH digest register
func (o *HASH_Type) SetHASH_HR4(value uint32) {
	volatile.StoreUint32(&o.HASH_HR4.Reg, value)
}
func (o *HASH_Type) GetHASH_HR4() uint32 {
	return volatile.LoadUint32(&o.HASH_HR4.Reg)
}

// HASH.HASH_HR5: HASH digest register
func (o *HASH_Type) SetHASH_HR5(value uint32) {
	volatile.StoreUint32(&o.HASH_HR5.Reg, value)
}
func (o *HASH_Type) GetHASH_HR5() uint32 {
	return volatile.LoadUint32(&o.HASH_HR5.Reg)
}

// HASH.HASH_HR6: HASH digest register
func (o *HASH_Type) SetHASH_HR6(value uint32) {
	volatile.StoreUint32(&o.HASH_HR6.Reg, value)
}
func (o *HASH_Type) GetHASH_HR6() uint32 {
	return volatile.LoadUint32(&o.HASH_HR6.Reg)
}

// HASH.HASH_HR7: HASH digest register
func (o *HASH_Type) SetHASH_HR7(value uint32) {
	volatile.StoreUint32(&o.HASH_HR7.Reg, value)
}
func (o *HASH_Type) GetHASH_HR7() uint32 {
	return volatile.LoadUint32(&o.HASH_HR7.Reg)
}

// DMA2D controller
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
	_       [944]byte
	FGCLUT  volatile.Register32 // 0x400
	_       [1020]byte
	BGCLUT  volatile.Register32 // 0x800
}

// DMA2D.CR: control register
func (o *DMA2D_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetCR_CEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2D_Type) GetCR_CEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DMA2D_Type) SetCR_CTCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2D_Type) GetCR_CTCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DMA2D_Type) SetCR_CAEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2D_Type) GetCR_CAEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *DMA2D_Type) SetCR_TWIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2D_Type) GetCR_TWIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA2D_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2D_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA2D_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2D_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA2D_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetCR_SUSP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetCR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DMA2D.ISR: Interrupt Status Register
func (o *DMA2D_Type) SetISR_CEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetISR_CEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetISR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetISR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetISR_CAEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetISR_CAEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetISR_TWIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetISR_TWIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetISR_TCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetISR_TCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetISR_TEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetISR_TEIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA2D.IFCR: interrupt flag clear register
func (o *DMA2D_Type) SetIFCR_CCEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetIFCR_CCEIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetIFCR_CCTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetIFCR_CCTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetIFCR_CAECIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetIFCR_CAECIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetIFCR_CTWIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetIFCR_CTWIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetIFCR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetIFCR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetIFCR_CTEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetIFCR_CTEIF() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA2D.FGMAR: foreground memory address register
func (o *DMA2D_Type) SetFGMAR(value uint32) {
	volatile.StoreUint32(&o.FGMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGMAR() uint32 {
	return volatile.LoadUint32(&o.FGMAR.Reg)
}

// DMA2D.FGOR: foreground offset register
func (o *DMA2D_Type) SetFGOR_LO(value uint32) {
	volatile.StoreUint32(&o.FGOR.Reg, volatile.LoadUint32(&o.FGOR.Reg)&^(0x3fff)|value)
}
func (o *DMA2D_Type) GetFGOR_LO() uint32 {
	return volatile.LoadUint32(&o.FGOR.Reg) & 0x3fff
}

// DMA2D.BGMAR: background memory address register
func (o *DMA2D_Type) SetBGMAR(value uint32) {
	volatile.StoreUint32(&o.BGMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGMAR() uint32 {
	return volatile.LoadUint32(&o.BGMAR.Reg)
}

// DMA2D.BGOR: background offset register
func (o *DMA2D_Type) SetBGOR_LO(value uint32) {
	volatile.StoreUint32(&o.BGOR.Reg, volatile.LoadUint32(&o.BGOR.Reg)&^(0x3fff)|value)
}
func (o *DMA2D_Type) GetBGOR_LO() uint32 {
	return volatile.LoadUint32(&o.BGOR.Reg) & 0x3fff
}

// DMA2D.FGPFCCR: foreground PFC control register
func (o *DMA2D_Type) SetFGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetFGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetFGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetFGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetFGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetFGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetFGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetFGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetFGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetFGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xf
}
func (o *DMA2D_Type) SetFGPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetFGPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetFGPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetFGPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x100000) >> 20
}

// DMA2D.FGCOLR: foreground color register
func (o *DMA2D_Type) SetFGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetFGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetFGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetFGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff
}

// DMA2D.BGPFCCR: background PFC control register
func (o *DMA2D_Type) SetBGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetBGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetBGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetBGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetBGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetBGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetBGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetBGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetBGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetBGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xf
}
func (o *DMA2D_Type) SetBGPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetBGPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetBGPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetBGPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x100000) >> 20
}

// DMA2D.BGCOLR: background color register
func (o *DMA2D_Type) SetBGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetBGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetBGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetBGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff
}

// DMA2D.FGCMAR: foreground CLUT memory address register
func (o *DMA2D_Type) SetFGCMAR(value uint32) {
	volatile.StoreUint32(&o.FGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGCMAR() uint32 {
	return volatile.LoadUint32(&o.FGCMAR.Reg)
}

// DMA2D.BGCMAR: background CLUT memory address register
func (o *DMA2D_Type) SetBGCMAR(value uint32) {
	volatile.StoreUint32(&o.BGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGCMAR() uint32 {
	return volatile.LoadUint32(&o.BGCMAR.Reg)
}

// DMA2D.OPFCCR: output PFC control register
func (o *DMA2D_Type) SetOPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x7)|value)
}
func (o *DMA2D_Type) GetOPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.OPFCCR.Reg) & 0x7
}
func (o *DMA2D_Type) SetOPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetOPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetOPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetOPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x100000) >> 20
}

// DMA2D.OCOLR: output color register
func (o *DMA2D_Type) SetOCOLR_APLHA(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetOCOLR_APLHA() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetOCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetOCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetOCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetOCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetOCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetOCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.OCOLR.Reg) & 0xff
}

// DMA2D.OMAR: output memory address register
func (o *DMA2D_Type) SetOMAR(value uint32) {
	volatile.StoreUint32(&o.OMAR.Reg, value)
}
func (o *DMA2D_Type) GetOMAR() uint32 {
	return volatile.LoadUint32(&o.OMAR.Reg)
}

// DMA2D.OOR: output offset register
func (o *DMA2D_Type) SetOOR_LO(value uint32) {
	volatile.StoreUint32(&o.OOR.Reg, volatile.LoadUint32(&o.OOR.Reg)&^(0x3fff)|value)
}
func (o *DMA2D_Type) GetOOR_LO() uint32 {
	return volatile.LoadUint32(&o.OOR.Reg) & 0x3fff
}

// DMA2D.NLR: number of line register
func (o *DMA2D_Type) SetNLR_PL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DMA2D_Type) GetNLR_PL() uint32 {
	return (volatile.LoadUint32(&o.NLR.Reg) & 0x3fff0000) >> 16
}
func (o *DMA2D_Type) SetNLR_NL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetNLR_NL() uint32 {
	return volatile.LoadUint32(&o.NLR.Reg) & 0xffff
}

// DMA2D.LWR: line watermark register
func (o *DMA2D_Type) SetLWR_LW(value uint32) {
	volatile.StoreUint32(&o.LWR.Reg, volatile.LoadUint32(&o.LWR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetLWR_LW() uint32 {
	return volatile.LoadUint32(&o.LWR.Reg) & 0xffff
}

// DMA2D.AMTCR: AHB master timer configuration register
func (o *DMA2D_Type) SetAMTCR_DT(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetAMTCR_DT() uint32 {
	return (volatile.LoadUint32(&o.AMTCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetAMTCR_EN(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetAMTCR_EN() uint32 {
	return volatile.LoadUint32(&o.AMTCR.Reg) & 0x1
}

// DMA2D.FGCLUT: FGCLUT
func (o *DMA2D_Type) SetFGCLUT_APLHA(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetFGCLUT_APLHA() uint32 {
	return (volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetFGCLUT_RED(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetFGCLUT_RED() uint32 {
	return (volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetFGCLUT_GREEN(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGCLUT_GREEN() uint32 {
	return (volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGCLUT_BLUE(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetFGCLUT_BLUE() uint32 {
	return volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff
}

// DMA2D.BGCLUT: BGCLUT
func (o *DMA2D_Type) SetBGCLUT_APLHA(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetBGCLUT_APLHA() uint32 {
	return (volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetBGCLUT_RED(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetBGCLUT_RED() uint32 {
	return (volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetBGCLUT_GREEN(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGCLUT_GREEN() uint32 {
	return (volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGCLUT_BLUE(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetBGCLUT_BLUE() uint32 {
	return volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func 