/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.jdk89acesses.SunMiscLauncher;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.SetValueHandler;
import net.sourceforge.jnlp.security.dialogresults.Yes;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;

public class MoreInfoPane
extends SecurityDialogPanel {
    private final boolean showSignedJNLPWarning;

    public MoreInfoPane(SecurityDialog x, CertVerifier certVerifier) {
        super(x, certVerifier);
        this.showSignedJNLPWarning = x.requiresSignedJNLPWarning();
        this.addComponents();
    }

    private void addComponents() {
        List<String> details = this.certVerifier.getDetails(null);
        if (this.showSignedJNLPWarning) {
            details.add(Translator.R("SJNLPFileIsNotSigned"));
        }
        int numLabels = details.size();
        JPanel errorPanel = new JPanel(new GridLayout(numLabels, 1));
        errorPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        errorPanel.setPreferredSize(new Dimension(400, 70 * numLabels));
        for (int i = 0; i < numLabels; ++i) {
            ImageIcon icon = null;
            icon = details.get(i).equals(Translator.R("STrustedCertificate")) ? SunMiscLauncher.getSecureImageIcon("net/sourceforge/jnlp/resources/info-small.png") : SunMiscLauncher.getSecureImageIcon("net/sourceforge/jnlp/resources/warning-small.png");
            errorPanel.add(new JLabel(MoreInfoPane.htmlWrap(details.get(i)), icon, 2));
        }
        if (this.showSignedJNLPWarning) {
            details.remove(details.size() - 1);
        }
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        JButton certDetails = new JButton(Translator.R("SCertificateDetails"));
        certDetails.addActionListener(new CertInfoButtonListener());
        JButton close = new JButton(Translator.R("ButClose"));
        close.addActionListener(SetValueHandler.createSetValueListener(this.parent, new Yes()));
        buttonsPanel.add((Component)certDetails, "West");
        buttonsPanel.add((Component)close, "East");
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.add((Component)errorPanel, "North");
        this.add((Component)buttonsPanel, "South");
    }

    @Override
    public DialogResult getDefaultNegativeAnswer() {
        return null;
    }

    @Override
    public DialogResult getDefaultPositiveAnswer() {
        return new Yes();
    }

    @Override
    public DialogResult readFromStdIn(String what) {
        return Yes.readValue(what);
    }

    @Override
    public String helpToStdIn() {
        return new Yes().getAllowedValues().toString();
    }

    private class CertInfoButtonListener
    implements ActionListener {
        private CertInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityDialog.showCertInfoDialog(MoreInfoPane.this.parent.getCertVerifier(), MoreInfoPane.this.parent.getSecurityDialogPanel());
        }
    }
}

