/* gkr-keyring.c generated by valac 0.56.1, the Vala compiler
 * generated from gkr-keyring.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-gkr.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "seahorse-common.h"
#include <libsecret/secret.h>
#include <gcr/gcr-base.h>
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_GKR_KEYRING_0_PROPERTY,
	SEAHORSE_GKR_KEYRING_DESCRIPTION_PROPERTY,
	SEAHORSE_GKR_KEYRING_URI_PROPERTY,
	SEAHORSE_GKR_KEYRING_ICON_PROPERTY,
	SEAHORSE_GKR_KEYRING_CATEGORY_PROPERTY,
	SEAHORSE_GKR_KEYRING_ACTIONS_PROPERTY,
	SEAHORSE_GKR_KEYRING_ACTION_PREFIX_PROPERTY,
	SEAHORSE_GKR_KEYRING_MENU_MODEL_PROPERTY,
	SEAHORSE_GKR_KEYRING_SHOW_IF_EMPTY_PROPERTY,
	SEAHORSE_GKR_KEYRING_IS_DEFAULT_PROPERTY,
	SEAHORSE_GKR_KEYRING_LOCKABLE_PROPERTY,
	SEAHORSE_GKR_KEYRING_UNLOCKABLE_PROPERTY,
	SEAHORSE_GKR_KEYRING_DELETABLE_PROPERTY,
	SEAHORSE_GKR_KEYRING_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_KEYRING_DELETER (seahorse_gkr_keyring_deleter_get_type ())
#define SEAHORSE_GKR_KEYRING_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleter))
#define SEAHORSE_GKR_KEYRING_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleterClass))
#define SEAHORSE_GKR_IS_KEYRING_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_KEYRING_DELETER))
#define SEAHORSE_GKR_IS_KEYRING_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_KEYRING_DELETER))
#define SEAHORSE_GKR_KEYRING_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleterClass))

typedef struct _SeahorseGkrKeyringDeleter SeahorseGkrKeyringDeleter;
typedef struct _SeahorseGkrKeyringDeleterClass SeahorseGkrKeyringDeleterClass;
typedef struct _SeahorseGkrKeyringLockData SeahorseGkrKeyringLockData;
typedef struct _SeahorseGkrKeyringUnlockData SeahorseGkrKeyringUnlockData;
typedef struct _SeahorseGkrKeyringLoadData SeahorseGkrKeyringLoadData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef struct _SeahorseGkrKeyringDeleterPrivate SeahorseGkrKeyringDeleterPrivate;
enum  {
	SEAHORSE_GKR_KEYRING_DELETER_0_PROPERTY,
	SEAHORSE_GKR_KEYRING_DELETER_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_keyring_deleter_properties[SEAHORSE_GKR_KEYRING_DELETER_NUM_PROPERTIES];
typedef struct _SeahorseGkrKeyringDeleterDeleteData SeahorseGkrKeyringDeleterDeleteData;

struct _SeahorseGkrKeyringPrivate {
	GActionGroup* _actions;
	GMenuModel* _menu_model;
	GHashTable* _items;
};

struct _SeahorseGkrKeyringLockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrKeyring* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GList* objects;
	GDBusProxy* _tmp0_;
	SecretService* service;
	SecretService* _tmp1_;
	SecretService* _tmp2_;
	GList* locked;
	GList* _tmp3_;
	GError* _inner_error0_;
};

struct _SeahorseGkrKeyringUnlockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrKeyring* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GList* objects;
	GDBusProxy* _tmp0_;
	SecretService* service;
	SecretService* _tmp1_;
	SecretService* _tmp2_;
	GList* unlocked;
	GList* _tmp3_;
	GError* _inner_error0_;
};

struct _SeahorseGkrKeyringLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrKeyring* self;
	GCancellable* cancellable;
	gboolean result;
};

struct _Block5Data {
	int _ref_count_;
	SeahorseGkrKeyring* self;
	gpointer parent;
	SecretService* service;
};

struct _Block6Data {
	int _ref_count_;
	SeahorseGkrKeyring* self;
	gpointer parent;
	SecretService* service;
};

struct _SeahorseGkrKeyringDeleter {
	SeahorseDeleter parent_instance;
	SeahorseGkrKeyringDeleterPrivate * priv;
};

struct _SeahorseGkrKeyringDeleterClass {
	SeahorseDeleterClass parent_class;
};

struct _SeahorseGkrKeyringDeleterPrivate {
	SeahorseGkrKeyring* _keyring;
	GList* _objects;
};

struct _SeahorseGkrKeyringDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrKeyringDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	SeahorseGkrKeyring* _tmp0_;
	GError* _inner_error0_;
};

static gint SeahorseGkrKeyring_private_offset;
static gpointer seahorse_gkr_keyring_parent_class = NULL;
static GcrCollectionIface * seahorse_gkr_keyring_gcr_collection_parent_iface = NULL;
static SeahorsePlaceIface * seahorse_gkr_keyring_seahorse_place_parent_iface = NULL;
static SeahorseDeletableIface * seahorse_gkr_keyring_seahorse_deletable_parent_iface = NULL;
static SeahorseLockableIface * seahorse_gkr_keyring_seahorse_lockable_parent_iface = NULL;
static SeahorseViewableIface * seahorse_gkr_keyring_seahorse_viewable_parent_iface = NULL;
static gint SeahorseGkrKeyringDeleter_private_offset;
static gpointer seahorse_gkr_keyring_deleter_parent_class = NULL;

static void _seahorse_gkr_keyring_on_action_set_default_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void _seahorse_gkr_keyring_on_action_change_password_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                       GVariant* parameter,
                                                                                       gpointer self);
static guint seahorse_gkr_keyring_real_get_length (GcrCollection* base);
static GList* seahorse_gkr_keyring_real_get_objects (GcrCollection* base);
static gboolean seahorse_gkr_keyring_real_contains (GcrCollection* base,
                                             GObject* obj);
static GtkWindow* seahorse_gkr_keyring_real_create_viewer (SeahorseViewable* base,
                                                    GtkWindow* parent);
static SeahorseDeleter* seahorse_gkr_keyring_real_create_deleter (SeahorseDeletable* base);
VALA_EXTERN SeahorseGkrKeyringDeleter* seahorse_gkr_keyring_deleter_new (SeahorseGkrKeyring* keyring);
VALA_EXTERN SeahorseGkrKeyringDeleter* seahorse_gkr_keyring_deleter_construct (GType object_type,
                                                                   SeahorseGkrKeyring* keyring);
VALA_EXTERN GType seahorse_gkr_keyring_deleter_get_type (void) G_GNUC_CONST ;
static void seahorse_gkr_keyring_real_lock_data_free (gpointer _data);
static void seahorse_gkr_keyring_real_lock (SeahorseLockable* base,
                                     GTlsInteraction* interaction,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean seahorse_gkr_keyring_real_lock_co (SeahorseGkrKeyringLockData* _data_);
static void seahorse_gkr_keyring_lock_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_gkr_keyring_refresh_collection (SeahorseGkrKeyring* self);
static void seahorse_gkr_keyring_real_unlock_data_free (gpointer _data);
static void seahorse_gkr_keyring_real_unlock (SeahorseLockable* base,
                                       GTlsInteraction* interaction,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean seahorse_gkr_keyring_real_unlock_co (SeahorseGkrKeyringUnlockData* _data_);
static void seahorse_gkr_keyring_unlock_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void seahorse_gkr_keyring_real_load_data_free (gpointer _data);
static void seahorse_gkr_keyring_real_load (SeahorsePlace* base,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean seahorse_gkr_keyring_real_load_co (SeahorseGkrKeyringLoadData* _data_);
static void _g_free0_ (gpointer var);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda13_ (Block5Data* _data5_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda23_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda24_ (Block6Data* _data6_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda24__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda23__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GSimpleActionGroup* seahorse_gkr_keyring_create_actions (SeahorseGkrKeyring* self);
static GMenu* seahorse_gkr_keyring_create_menu_model (SeahorseGkrKeyring* self);
static GObject * seahorse_gkr_keyring_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _seahorse_gkr_keyring___lambda26_ (SeahorseGkrKeyring* self,
                                        GParamSpec* pspec);
static void __seahorse_gkr_keyring___lambda26__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void _seahorse_gkr_keyring___lambda27_ (SeahorseGkrKeyring* self,
                                        GParamSpec* pspec);
static void __seahorse_gkr_keyring___lambda27__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void seahorse_gkr_keyring_finalize (GObject * obj);
static GType seahorse_gkr_keyring_get_type_once (void);
static void _vala_seahorse_gkr_keyring_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static GtkDialog* seahorse_gkr_keyring_deleter_real_create_confirm (SeahorseDeleter* base,
                                                             GtkWindow* parent);
static GList* seahorse_gkr_keyring_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_gkr_keyring_deleter_real_add_object (SeahorseDeleter* base,
                                                       GObject* obj);
static void seahorse_gkr_keyring_deleter_real_delete_data_free (gpointer _data);
static void seahorse_gkr_keyring_deleter_real_delete (SeahorseDeleter* base,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean seahorse_gkr_keyring_deleter_real_delete_co (SeahorseGkrKeyringDeleterDeleteData* _data_);
static void seahorse_gkr_keyring_deleter_delete_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void seahorse_gkr_keyring_deleter_finalize (GObject * obj);
static GType seahorse_gkr_keyring_deleter_get_type_once (void);

static const GActionEntry SEAHORSE_GKR_KEYRING_KEYRING_ACTIONS[2] = {{"set-default", _seahorse_gkr_keyring_on_action_set_default_gsimple_action_activate_callback}, {"change-password", _seahorse_gkr_keyring_on_action_change_password_gsimple_action_activate_callback}};

static inline gpointer
seahorse_gkr_keyring_get_instance_private (SeahorseGkrKeyring* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrKeyring_private_offset);
}

static void
_seahorse_gkr_keyring_on_action_set_default_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	seahorse_gkr_keyring_on_action_set_default ((SeahorseGkrKeyring*) self, action, parameter);
}

static void
_seahorse_gkr_keyring_on_action_change_password_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self)
{
	seahorse_gkr_keyring_on_action_change_password ((SeahorseGkrKeyring*) self, action, parameter);
}

static guint
seahorse_gkr_keyring_real_get_length (GcrCollection* base)
{
	SeahorseGkrKeyring * self;
	GHashTable* _tmp0_;
	guint result;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_items;
	result = g_hash_table_size (_tmp0_);
	return result;
}

static GList*
seahorse_gkr_keyring_real_get_objects (GcrCollection* base)
{
	SeahorseGkrKeyring * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
seahorse_gkr_keyring_real_contains (GcrCollection* base,
                                    GObject* obj)
{
	SeahorseGkrKeyring * self;
	gboolean result;
	self = (SeahorseGkrKeyring*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	if (SEAHORSE_GKR_IS_ITEM (obj)) {
		GHashTable* _tmp0_;
		const gchar* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = self->priv->_items;
		_tmp1_ = g_dbus_proxy_get_object_path ((GDBusProxy*) G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
		_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
		result = ((SeahorseGkrItem*) _tmp2_) != NULL;
		return result;
	}
	result = FALSE;
	return result;
}

static GtkWindow*
seahorse_gkr_keyring_real_create_viewer (SeahorseViewable* base,
                                         GtkWindow* parent)
{
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringProperties* _tmp0_;
	GtkWindow* result;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = seahorse_gkr_keyring_properties_new (self, parent);
	g_object_ref_sink (_tmp0_);
	result = (GtkWindow*) _tmp0_;
	return result;
}

static SeahorseDeleter*
seahorse_gkr_keyring_real_create_deleter (SeahorseDeletable* base)
{
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringDeleter* _tmp0_;
	SeahorseDeleter* result;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = seahorse_gkr_keyring_deleter_new (self);
	result = (SeahorseDeleter*) _tmp0_;
	return result;
}

static void
seahorse_gkr_keyring_real_lock_data_free (gpointer _data)
{
	SeahorseGkrKeyringLockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringLockData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
seahorse_gkr_keyring_real_lock (SeahorseLockable* base,
                                GTlsInteraction* interaction,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringLockData* _data_;
	SeahorseGkrKeyring* _tmp0_;
	GTlsInteraction* _tmp1_;
	GCancellable* _tmp2_;
	self = (SeahorseGkrKeyring*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringLockData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_keyring_real_lock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_gkr_keyring_real_lock_co (_data_);
}

static gboolean
seahorse_gkr_keyring_lock_finish (SeahorseLockable* base,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	gboolean result;
	SeahorseGkrKeyringLockData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_gkr_keyring_lock_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	SeahorseGkrKeyringLockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_keyring_real_lock_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
seahorse_gkr_keyring_real_lock_co (SeahorseGkrKeyringLockData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->objects = NULL;
	_data_->_tmp0_ = _g_object_ref0 ((GDBusProxy*) _data_->self);
	_data_->objects = g_list_prepend (_data_->objects, _data_->_tmp0_);
	_data_->_tmp1_ = secret_collection_get_service ((SecretCollection*) _data_->self);
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->service = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_state_ = 1;
	secret_service_lock (_data_->service, _data_->objects, _data_->cancellable, seahorse_gkr_keyring_lock_ready, _data_);
	return FALSE;
	_state_1:
	secret_service_lock_finish (_data_->service, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
	(_data_->locked == NULL) ? NULL : (_data_->locked = (_g_list_free__g_object_unref0_ (_data_->locked), NULL));
	_data_->locked = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		(_data_->locked == NULL) ? NULL : (_data_->locked = (_g_list_free__g_object_unref0_ (_data_->locked), NULL));
		_g_object_unref0 (_data_->service);
		(_data_->objects == NULL) ? NULL : (_data_->objects = (_g_list_free__g_object_unref0_ (_data_->objects), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_gkr_keyring_refresh_collection (_data_->self);
	_data_->result = g_list_length (_data_->locked) > ((guint) 0);
	(_data_->locked == NULL) ? NULL : (_data_->locked = (_g_list_free__g_object_unref0_ (_data_->locked), NULL));
	_g_object_unref0 (_data_->service);
	(_data_->objects == NULL) ? NULL : (_data_->objects = (_g_list_free__g_object_unref0_ (_data_->objects), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_keyring_real_unlock_data_free (gpointer _data)
{
	SeahorseGkrKeyringUnlockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringUnlockData, _data_);
}

static void
seahorse_gkr_keyring_real_unlock (SeahorseLockable* base,
                                  GTlsInteraction* interaction,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringUnlockData* _data_;
	SeahorseGkrKeyring* _tmp0_;
	GTlsInteraction* _tmp1_;
	GCancellable* _tmp2_;
	self = (SeahorseGkrKeyring*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringUnlockData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_keyring_real_unlock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_gkr_keyring_real_unlock_co (_data_);
}

static gboolean
seahorse_gkr_keyring_unlock_finish (SeahorseLockable* base,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	gboolean result;
	SeahorseGkrKeyringUnlockData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_gkr_keyring_unlock_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	SeahorseGkrKeyringUnlockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_keyring_real_unlock_co (_data_);
}

static gboolean
seahorse_gkr_keyring_real_unlock_co (SeahorseGkrKeyringUnlockData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->objects = NULL;
	_data_->_tmp0_ = _g_object_ref0 ((GDBusProxy*) _data_->self);
	_data_->objects = g_list_prepend (_data_->objects, _data_->_tmp0_);
	_data_->_tmp1_ = secret_collection_get_service ((SecretCollection*) _data_->self);
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->service = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_state_ = 1;
	secret_service_unlock (_data_->service, _data_->objects, _data_->cancellable, seahorse_gkr_keyring_unlock_ready, _data_);
	return FALSE;
	_state_1:
	secret_service_unlock_finish (_data_->service, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
	(_data_->unlocked == NULL) ? NULL : (_data_->unlocked = (_g_list_free__g_object_unref0_ (_data_->unlocked), NULL));
	_data_->unlocked = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		(_data_->unlocked == NULL) ? NULL : (_data_->unlocked = (_g_list_free__g_object_unref0_ (_data_->unlocked), NULL));
		_g_object_unref0 (_data_->service);
		(_data_->objects == NULL) ? NULL : (_data_->objects = (_g_list_free__g_object_unref0_ (_data_->objects), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_gkr_keyring_refresh_collection (_data_->self);
	_data_->result = g_list_length (_data_->unlocked) > ((guint) 0);
	(_data_->unlocked == NULL) ? NULL : (_data_->unlocked = (_g_list_free__g_object_unref0_ (_data_->unlocked), NULL));
	_g_object_unref0 (_data_->service);
	(_data_->objects == NULL) ? NULL : (_data_->objects = (_g_list_free__g_object_unref0_ (_data_->objects), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_keyring_real_load_data_free (gpointer _data)
{
	SeahorseGkrKeyringLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringLoadData, _data_);
}

static void
seahorse_gkr_keyring_real_load (SeahorsePlace* base,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringLoadData* _data_;
	SeahorseGkrKeyring* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseGkrKeyring*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_keyring_real_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_gkr_keyring_real_load_co (_data_);
}

static gboolean
seahorse_gkr_keyring_load_finish (SeahorsePlace* base,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	gboolean result;
	SeahorseGkrKeyringLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
seahorse_gkr_keyring_real_load_co (SeahorseGkrKeyringLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	seahorse_gkr_keyring_refresh_collection (_data_->self);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
seahorse_gkr_keyring_refresh_collection (SeahorseGkrKeyring* self)
{
	GHashTable* seen = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GList* items = NULL;
	GList* _tmp4_;
	GHashTableIter iter = {0};
	GHashTable* _tmp22_;
	gchar* object_path = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	seen = _tmp2_;
	items = NULL;
	if (!secret_collection_get_locked ((SecretCollection*) self)) {
		GList* _tmp3_;
		_tmp3_ = secret_collection_get_items ((SecretCollection*) self);
		(items == NULL) ? NULL : (items = (_g_list_free__g_object_unref0_ (items), NULL));
		items = _tmp3_;
	}
	_tmp4_ = items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp4_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			SecretItem* _tmp5_;
			SecretItem* item = NULL;
			_tmp5_ = _g_object_ref0 ((SecretItem*) item_it->data);
			item = _tmp5_;
			{
				gchar* object_path = NULL;
				SecretItem* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				GHashTable* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				GHashTable* _tmp12_;
				const gchar* _tmp13_;
				gconstpointer _tmp14_;
				_tmp6_ = item;
				_tmp7_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp6_);
				_tmp8_ = g_strdup (_tmp7_);
				object_path = _tmp8_;
				_tmp9_ = seen;
				_tmp10_ = object_path;
				_tmp11_ = g_strdup (_tmp10_);
				g_hash_table_add (_tmp9_, _tmp11_);
				_tmp12_ = self->priv->_items;
				_tmp13_ = object_path;
				_tmp14_ = g_hash_table_lookup (_tmp12_, _tmp13_);
				if (((SeahorseGkrItem*) _tmp14_) == NULL) {
					SecretItem* _tmp15_;
					GHashTable* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					SecretItem* _tmp19_;
					SeahorseGkrItem* _tmp20_;
					SecretItem* _tmp21_;
					_tmp15_ = item;
					g_object_set ((GObject*) _tmp15_, "place", self, NULL);
					_tmp16_ = self->priv->_items;
					_tmp17_ = object_path;
					_tmp18_ = g_strdup (_tmp17_);
					_tmp19_ = item;
					_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
					g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
					_tmp21_ = item;
					gcr_collection_emit_added ((GcrCollection*) self, (GObject*) _tmp21_);
				}
				_g_free0 (object_path);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp22_ = self->priv->_items;
	g_hash_table_iter_init (&iter, _tmp22_);
	while (TRUE) {
		gconstpointer _tmp23_ = NULL;
		gboolean _tmp24_;
		gchar* _tmp25_;
		GHashTable* _tmp26_;
		const gchar* _tmp27_;
		_tmp24_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp23_), (gpointer*) NULL);
		_g_free0 (object_path);
		_tmp25_ = g_strdup (_tmp23_);
		object_path = _tmp25_;
		if (!_tmp24_) {
			break;
		}
		_tmp26_ = seen;
		_tmp27_ = object_path;
		if (!g_hash_table_contains (_tmp26_, _tmp27_)) {
			SeahorseGkrItem* item = NULL;
			GHashTable* _tmp28_;
			const gchar* _tmp29_;
			gconstpointer _tmp30_;
			SeahorseGkrItem* _tmp31_;
			SeahorseGkrItem* _tmp32_;
			SeahorseGkrItem* _tmp33_;
			_tmp28_ = self->priv->_items;
			_tmp29_ = object_path;
			_tmp30_ = g_hash_table_lookup (_tmp28_, _tmp29_);
			_tmp31_ = _g_object_ref0 ((SeahorseGkrItem*) _tmp30_);
			item = _tmp31_;
			_tmp32_ = item;
			g_object_set ((GObject*) _tmp32_, "place", NULL, NULL);
			g_hash_table_iter_remove (&iter);
			_tmp33_ = item;
			gcr_collection_emit_removed ((GcrCollection*) self, (GObject*) _tmp33_);
			_g_object_unref0 (item);
		}
	}
	_g_free0 (object_path);
	(items == NULL) ? NULL : (items = (_g_list_free__g_object_unref0_ (items), NULL));
	_g_hash_table_unref0 (seen);
}

void
seahorse_gkr_keyring_on_action_set_default (SeahorseGkrKeyring* self,
                                            GSimpleAction* action,
                                            GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	seahorse_gkr_keyring_set_as_default (self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SeahorseGkrKeyring* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->service);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda13_ (Block5Data* _data5_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseGkrKeyring* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseGkrBackend* _tmp0_;
		SeahorseGkrBackend* _tmp1_;
		secret_service_set_alias_finish (_data5_->service, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = seahorse_gkr_backend_instance ();
		_tmp1_ = _tmp0_;
		seahorse_gkr_backend_refresh (_tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error (_data5_->parent, _ ("Couldn’t set default keyring"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda13__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda13_ (self, source_object, res);
	block5_data_unref (self);
}

void
seahorse_gkr_keyring_set_as_default (SeahorseGkrKeyring* self)
{
	Block5Data* _data5_;
	SecretService* _tmp0_;
	SecretService* _tmp1_;
	SecretService* _tmp2_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->parent = NULL;
	_tmp0_ = secret_collection_get_service ((SecretCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data5_->service = _tmp2_;
	secret_service_set_alias (_data5_->service, "default", (SecretCollection*) self, NULL, ___lambda13__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

void
seahorse_gkr_keyring_on_action_change_password (SeahorseGkrKeyring* self,
                                                GSimpleAction* action,
                                                GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	seahorse_gkr_keyring_change_password (self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SeahorseGkrKeyring* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->service);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda24_ (Block6Data* _data6_,
              GObject* obj,
              GAsyncResult* res)
{
	SeahorseGkrKeyring* self;
	SeahorseGkrBackend* _tmp4_;
	SeahorseGkrBackend* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		_tmp0_ = secret_service_prompt_at_dbus_path_finish (_data6_->service, res, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_variant_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error (_data6_->parent, _ ("Couldn’t change keyring password"), _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = seahorse_gkr_backend_instance ();
	_tmp5_ = _tmp4_;
	seahorse_gkr_backend_refresh (_tmp5_);
	_g_object_unref0 (_tmp5_);
}

static void
____lambda24__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda24_ (self, source_object, res);
	block6_data_unref (self);
}

static void
__lambda23_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseGkrKeyring* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GVariant* retval = NULL;
		GDBusConnection* _tmp0_;
		GVariant* _tmp1_;
		gchar* prompt_path = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_dbus_proxy_get_connection ((GDBusProxy*) _data6_->service);
		_tmp1_ = g_dbus_connection_call_finish (_tmp0_, res, &_inner_error0_);
		retval = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_variant_get (retval, "(o)", &_tmp2_, NULL);
		_g_free0 (prompt_path);
		prompt_path = _tmp2_;
		_tmp3_ = prompt_path;
		_tmp4_ = g_strdup (_tmp3_);
		_tmp5_ = _tmp4_;
		secret_service_prompt_at_dbus_path (_data6_->service, _tmp5_, NULL, NULL, ____lambda24__gasync_ready_callback, block6_data_ref (_data6_));
		_g_free0 (_tmp5_);
		_g_free0 (prompt_path);
		_g_variant_unref0 (retval);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		seahorse_util_show_error (_data6_->parent, _ ("Couldn’t change keyring password"), _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda23__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda23_ (self, source_object, res);
	block6_data_unref (self);
}

void
seahorse_gkr_keyring_change_password (SeahorseGkrKeyring* self)
{
	Block6Data* _data6_;
	SecretService* _tmp0_;
	SecretService* _tmp1_;
	SecretService* _tmp2_;
	GDBusConnection* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariantType* _tmp9_;
	GVariantType* _tmp10_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->parent = NULL;
	_tmp0_ = secret_collection_get_service ((SecretCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data6_->service = _tmp2_;
	_tmp3_ = g_dbus_proxy_get_connection ((GDBusProxy*) _data6_->service);
	_tmp4_ = g_dbus_proxy_get_name ((GDBusProxy*) _data6_->service);
	_tmp5_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data6_->service);
	_tmp6_ = g_dbus_proxy_get_object_path ((GDBusProxy*) self);
	_tmp7_ = g_variant_new ("(o)", _tmp6_, NULL);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_type_new ("(o)");
	_tmp10_ = _tmp9_;
	g_dbus_connection_call (_tmp3_, _tmp4_, _tmp5_, "org.gnome.keyring.InternalUnsupportedGuiltRiddenInterface", "ChangeWithPrompt", _tmp8_, _tmp10_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, ___lambda23__gasync_ready_callback, block6_data_ref (_data6_));
	_g_variant_type_free0 (_tmp10_);
	_g_variant_unref0 (_tmp8_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static GSimpleActionGroup*
seahorse_gkr_keyring_create_actions (SeahorseGkrKeyring* self)
{
	GSimpleActionGroup* group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* action = NULL;
	GAction* _tmp1_;
	GAction* _tmp2_;
	GSimpleActionGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_simple_action_group_new ();
	group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) group, SEAHORSE_GKR_KEYRING_KEYRING_ACTIONS, (gint) G_N_ELEMENTS (SEAHORSE_GKR_KEYRING_KEYRING_ACTIONS), self);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) group, "set-default");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	g_object_bind_property_with_closures ((GObject*) self, "is-default", (GObject*) action, "enabled", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = group;
	_g_object_unref0 (action);
	return result;
}

static GMenu*
seahorse_gkr_keyring_create_menu_model (SeahorseGkrKeyring* self)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	const gchar* prefix = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	_tmp1_ = seahorse_place_get_action_prefix ((SeahorsePlace*) self);
	_tmp2_ = _tmp1_;
	prefix = _tmp2_;
	_tmp3_ = g_strconcat (prefix, ".set-default", NULL);
	_tmp4_ = _tmp3_;
	g_menu_insert (menu, 0, _ ("_Set as default"), _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = g_strconcat (prefix, ".change-password", NULL);
	_tmp6_ = _tmp5_;
	g_menu_insert (menu, 1, _ ("Change _Password"), _tmp6_);
	_g_free0 (_tmp6_);
	result = menu;
	return result;
}

SeahorseGkrKeyring*
seahorse_gkr_keyring_construct (GType object_type)
{
	SeahorseGkrKeyring * self = NULL;
	self = (SeahorseGkrKeyring*) g_object_new (object_type, NULL);
	return self;
}

SeahorseGkrKeyring*
seahorse_gkr_keyring_new (void)
{
	return seahorse_gkr_keyring_construct (SEAHORSE_GKR_TYPE_KEYRING);
}

static gchar*
seahorse_gkr_keyring_real_get_description (SeahorsePlace* base)
{
	gchar* result;
	SeahorseGkrKeyring* self;
	SeahorseGkrBackend* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp4_;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = seahorse_gkr_backend_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = seahorse_gkr_backend_has_alias (_tmp1_, "login", self);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("A keyring that is automatically unlocked on login"));
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup (_ ("A keyring used to store passwords"));
	result = _tmp4_;
	return result;
}

static gchar*
seahorse_gkr_keyring_real_get_uri (SeahorsePlace* base)
{
	gchar* result;
	SeahorseGkrKeyring* self;
	gchar* object_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = g_dbus_proxy_get_object_path ((GDBusProxy*) G_TYPE_CHECK_INSTANCE_CAST (self, secret_collection_get_type (), SecretCollection));
	_tmp1_ = g_strdup (_tmp0_);
	object_path = _tmp1_;
	_tmp2_ = g_strdup_printf ("secret-service://%s", object_path);
	result = _tmp2_;
	_g_free0 (object_path);
	return result;
}

static GIcon*
seahorse_gkr_keyring_real_get_icon (SeahorsePlace* base)
{
	GIcon* result;
	SeahorseGkrKeyring* self;
	GThemedIcon* _tmp0_;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("folder");
	result = (GIcon*) _tmp0_;
	return result;
}

static SeahorsePlaceCategory
seahorse_gkr_keyring_real_get_category (SeahorsePlace* base)
{
	SeahorsePlaceCategory result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = SEAHORSE_PLACE_CATEGORY_PASSWORDS;
	return result;
}

static GActionGroup*
seahorse_gkr_keyring_real_get_actions (SeahorsePlace* base)
{
	GActionGroup* result;
	SeahorseGkrKeyring* self;
	GActionGroup* _tmp0_;
	GActionGroup* _tmp1_;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_actions;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static const gchar*
seahorse_gkr_keyring_real_get_action_prefix (SeahorsePlace* base)
{
	const gchar* result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = "gkr-keyring";
	return result;
}

static GMenuModel*
seahorse_gkr_keyring_real_get_menu_model (SeahorsePlace* base)
{
	GMenuModel* result;
	SeahorseGkrKeyring* self;
	GMenuModel* _tmp0_;
	GMenuModel* _tmp1_;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_menu_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
seahorse_gkr_keyring_real_get_show_if_empty (SeahorsePlace* base)
{
	gboolean result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = TRUE;
	return result;
}

gboolean
seahorse_gkr_keyring_get_is_default (SeahorseGkrKeyring* self)
{
	gboolean result;
	SeahorseGkrBackend* _tmp0_;
	SeahorseGkrBackend* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = seahorse_gkr_backend_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = seahorse_gkr_backend_has_alias (_tmp1_, "default", self);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
seahorse_gkr_keyring_real_get_lockable (SeahorseLockable* base)
{
	gboolean result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = !secret_collection_get_locked ((SecretCollection*) self);
	return result;
}

static gboolean
seahorse_gkr_keyring_real_get_unlockable (SeahorseLockable* base)
{
	gboolean result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = secret_collection_get_locked ((SecretCollection*) self);
	return result;
}

static gboolean
seahorse_gkr_keyring_real_get_deletable (SeahorseDeletable* base)
{
	gboolean result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = TRUE;
	return result;
}

static void
_seahorse_gkr_keyring___lambda26_ (SeahorseGkrKeyring* self,
                                   GParamSpec* pspec)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (pspec != NULL);
	_tmp1_ = pspec->name;
	if (g_strcmp0 (_tmp1_, "items") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = pspec->name;
		_tmp0_ = g_strcmp0 (_tmp2_, "locked") == 0;
	}
	if (_tmp0_) {
		seahorse_gkr_keyring_refresh_collection (self);
	}
}

static void
__seahorse_gkr_keyring___lambda26__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	_seahorse_gkr_keyring___lambda26_ ((SeahorseGkrKeyring*) self, pspec);
}

static void
_seahorse_gkr_keyring___lambda27_ (SeahorseGkrKeyring* self,
                                   GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	g_object_notify ((GObject*) self, "is-default");
	g_object_notify ((GObject*) self, "description");
}

static void
__seahorse_gkr_keyring___lambda27__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	_seahorse_gkr_keyring___lambda27_ ((SeahorseGkrKeyring*) self, pspec);
}

static GObject *
seahorse_gkr_keyring_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrKeyring * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	SeahorseGkrBackend* _tmp3_;
	SeahorseGkrBackend* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	GMenu* _tmp6_;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_keyring_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_items);
	self->priv->_items = _tmp2_;
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) __seahorse_gkr_keyring___lambda26__g_object_notify, self, 0);
	_tmp3_ = seahorse_gkr_backend_instance ();
	_tmp4_ = _tmp3_;
	g_signal_connect_object ((GObject*) _tmp4_, "notify", (GCallback) __seahorse_gkr_keyring___lambda27__g_object_notify, self, 0);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = seahorse_gkr_keyring_create_actions (self);
	_g_object_unref0 (self->priv->_actions);
	self->priv->_actions = (GActionGroup*) _tmp5_;
	_tmp6_ = seahorse_gkr_keyring_create_menu_model (self);
	_g_object_unref0 (self->priv->_menu_model);
	self->priv->_menu_model = (GMenuModel*) _tmp6_;
	return obj;
}

static void
seahorse_gkr_keyring_class_init (SeahorseGkrKeyringClass * klass,
                                 gpointer klass_data)
{
	seahorse_gkr_keyring_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrKeyring_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_keyring_get_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_keyring_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_keyring_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_DESCRIPTION_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_URI_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_ICON_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_CATEGORY_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_CATEGORY_PROPERTY] = g_param_spec_enum ("category", "category", "category", SEAHORSE_PLACE_TYPE_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_ACTIONS_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_ACTION_PREFIX_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_ACTION_PREFIX_PROPERTY] = g_param_spec_string ("action-prefix", "action-prefix", "action-prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_MENU_MODEL_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_MENU_MODEL_PROPERTY] = g_param_spec_object ("menu-model", "menu-model", "menu-model", g_menu_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_SHOW_IF_EMPTY_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_SHOW_IF_EMPTY_PROPERTY] = g_param_spec_boolean ("show-if-empty", "show-if-empty", "show-if-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_IS_DEFAULT_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_IS_DEFAULT_PROPERTY] = g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_LOCKABLE_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_LOCKABLE_PROPERTY] = g_param_spec_boolean ("lockable", "lockable", "lockable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_UNLOCKABLE_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_UNLOCKABLE_PROPERTY] = g_param_spec_boolean ("unlockable", "unlockable", "unlockable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_DELETABLE_PROPERTY, seahorse_gkr_keyring_properties[SEAHORSE_GKR_KEYRING_DELETABLE_PROPERTY] = g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_gkr_keyring_gcr_collection_interface_init (GcrCollectionIface * iface,
                                                    gpointer iface_data)
{
	seahorse_gkr_keyring_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_length = (guint (*) (GcrCollection*)) seahorse_gkr_keyring_real_get_length;
	iface->get_objects = (GList* (*) (GcrCollection*)) seahorse_gkr_keyring_real_get_objects;
	iface->contains = (gboolean (*) (GcrCollection*, GObject*)) seahorse_gkr_keyring_real_contains;
}

static void
seahorse_gkr_keyring_seahorse_place_interface_init (SeahorsePlaceIface * iface,
                                                    gpointer iface_data)
{
	seahorse_gkr_keyring_seahorse_place_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (void (*) (SeahorsePlace*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_gkr_keyring_real_load;
	iface->load_finish = (gboolean (*) (SeahorsePlace*, GAsyncResult*, GError**)) seahorse_gkr_keyring_load_finish;
	iface->get_description = seahorse_gkr_keyring_real_get_description;
	iface->get_uri = seahorse_gkr_keyring_real_get_uri;
	iface->get_icon = seahorse_gkr_keyring_real_get_icon;
	iface->get_category = seahorse_gkr_keyring_real_get_category;
	iface->get_actions = seahorse_gkr_keyring_real_get_actions;
	iface->get_action_prefix = seahorse_gkr_keyring_real_get_action_prefix;
	iface->get_menu_model = seahorse_gkr_keyring_real_get_menu_model;
	iface->get_show_if_empty = seahorse_gkr_keyring_real_get_show_if_empty;
	iface->get_label = (gchar* (*) (SeahorsePlace *)) secret_collection_get_label;
	iface->set_label = (void (*) (SeahorsePlace *, const gchar*)) secret_collection_set_label;
}

static void
seahorse_gkr_keyring_seahorse_deletable_interface_init (SeahorseDeletableIface * iface,
                                                        gpointer iface_data)
{
	seahorse_gkr_keyring_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*) (SeahorseDeletable*)) seahorse_gkr_keyring_real_create_deleter;
	iface->get_deletable = seahorse_gkr_keyring_real_get_deletable;
}

static void
seahorse_gkr_keyring_seahorse_lockable_interface_init (SeahorseLockableIface * iface,
                                                       gpointer iface_data)
{
	seahorse_gkr_keyring_seahorse_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->lock = (void (*) (SeahorseLockable*, GTlsInteraction*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_gkr_keyring_real_lock;
	iface->lock_finish = (gboolean (*) (SeahorseLockable*, GAsyncResult*, GError**)) seahorse_gkr_keyring_lock_finish;
	iface->unlock = (void (*) (SeahorseLockable*, GTlsInteraction*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_gkr_keyring_real_unlock;
	iface->unlock_finish = (gboolean (*) (SeahorseLockable*, GAsyncResult*, GError**)) seahorse_gkr_keyring_unlock_finish;
	iface->get_lockable = seahorse_gkr_keyring_real_get_lockable;
	iface->get_unlockable = seahorse_gkr_keyring_real_get_unlockable;
}

static void
seahorse_gkr_keyring_seahorse_viewable_interface_init (SeahorseViewableIface * iface,
                                                       gpointer iface_data)
{
	seahorse_gkr_keyring_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*) (SeahorseViewable*, GtkWindow*)) seahorse_gkr_keyring_real_create_viewer;
}

static void
seahorse_gkr_keyring_instance_init (SeahorseGkrKeyring * self,
                                    gpointer klass)
{
	self->priv = seahorse_gkr_keyring_get_instance_private (self);
	self->priv->_actions = NULL;
	self->priv->_menu_model = NULL;
}

static void
seahorse_gkr_keyring_finalize (GObject * obj)
{
	SeahorseGkrKeyring * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_menu_model);
	_g_hash_table_unref0 (self->priv->_items);
	G_OBJECT_CLASS (seahorse_gkr_keyring_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_keyring_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrKeyringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_keyring_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrKeyring), 0, (GInstanceInitFunc) seahorse_gkr_keyring_instance_init, NULL };
	static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_place_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_place_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_lockable_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_gkr_keyring_type_id;
	seahorse_gkr_keyring_type_id = g_type_register_static (secret_collection_get_type (), "SeahorseGkrKeyring", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_gkr_keyring_type_id, gcr_collection_get_type (), &gcr_collection_info);
	g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_PLACE, &seahorse_place_info);
	g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
	g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_LOCKABLE, &seahorse_lockable_info);
	g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
	SeahorseGkrKeyring_private_offset = g_type_add_instance_private (seahorse_gkr_keyring_type_id, sizeof (SeahorseGkrKeyringPrivate));
	return seahorse_gkr_keyring_type_id;
}

GType
seahorse_gkr_keyring_get_type (void)
{
	static volatile gsize seahorse_gkr_keyring_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_keyring_type_id__once)) {
		GType seahorse_gkr_keyring_type_id;
		seahorse_gkr_keyring_type_id = seahorse_gkr_keyring_get_type_once ();
		g_once_init_leave (&seahorse_gkr_keyring_type_id__once, seahorse_gkr_keyring_type_id);
	}
	return seahorse_gkr_keyring_type_id__once;
}

static void
_vala_seahorse_gkr_keyring_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseGkrKeyring * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	switch (property_id) {
		case SEAHORSE_GKR_KEYRING_DESCRIPTION_PROPERTY:
		g_value_take_string (value, seahorse_place_get_description ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_URI_PROPERTY:
		g_value_take_string (value, seahorse_place_get_uri ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_ICON_PROPERTY:
		g_value_take_object (value, seahorse_place_get_icon ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_CATEGORY_PROPERTY:
		g_value_set_enum (value, seahorse_place_get_category ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_ACTIONS_PROPERTY:
		g_value_take_object (value, seahorse_place_get_actions ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_ACTION_PREFIX_PROPERTY:
		g_value_set_string (value, seahorse_place_get_action_prefix ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_MENU_MODEL_PROPERTY:
		g_value_take_object (value, seahorse_place_get_menu_model ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_SHOW_IF_EMPTY_PROPERTY:
		g_value_set_boolean (value, seahorse_place_get_show_if_empty ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_IS_DEFAULT_PROPERTY:
		g_value_set_boolean (value, seahorse_gkr_keyring_get_is_default (self));
		break;
		case SEAHORSE_GKR_KEYRING_LOCKABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_lockable_get_lockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_GKR_KEYRING_UNLOCKABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_lockable_get_unlockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_GKR_KEYRING_DELETABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
seahorse_gkr_keyring_deleter_get_instance_private (SeahorseGkrKeyringDeleter* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrKeyringDeleter_private_offset);
}

static GtkDialog*
seahorse_gkr_keyring_deleter_real_create_confirm (SeahorseDeleter* base,
                                                  GtkWindow* parent)
{
	SeahorseGkrKeyringDeleter * self;
	SeahorseDeleteDialog* dialog = NULL;
	SeahorseGkrKeyring* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SeahorseDeleteDialog* _tmp4_;
	SeahorseDeleteDialog* _tmp5_;
	GtkDialog* result;
	self = (SeahorseGkrKeyringDeleter*) base;
	_tmp0_ = self->priv->_keyring;
	_tmp1_ = seahorse_place_get_label ((SeahorsePlace*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (parent, _ ("Are you sure you want to delete the password keyring “%s”?"), _tmp3_, NULL);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	dialog = _tmp5_;
	seahorse_delete_dialog_set_check_label (dialog, _ ("I understand that all items will be permanently deleted."));
	seahorse_delete_dialog_set_check_require (dialog, TRUE);
	result = (GtkDialog*) dialog;
	return result;
}

SeahorseGkrKeyringDeleter*
seahorse_gkr_keyring_deleter_construct (GType object_type,
                                        SeahorseGkrKeyring* keyring)
{
	SeahorseGkrKeyringDeleter * self = NULL;
	g_return_val_if_fail (keyring != NULL, NULL);
	self = (SeahorseGkrKeyringDeleter*) seahorse_deleter_construct (object_type);
	if (!seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) keyring)) {
		g_assert_not_reached ();
	}
	return self;
}

SeahorseGkrKeyringDeleter*
seahorse_gkr_keyring_deleter_new (SeahorseGkrKeyring* keyring)
{
	return seahorse_gkr_keyring_deleter_construct (SEAHORSE_GKR_TYPE_KEYRING_DELETER, keyring);
}

static GList*
seahorse_gkr_keyring_deleter_real_get_objects (SeahorseDeleter* base)
{
	SeahorseGkrKeyringDeleter * self;
	GList* _tmp0_;
	GList* result;
	self = (SeahorseGkrKeyringDeleter*) base;
	_tmp0_ = self->priv->_objects;
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_gkr_keyring_deleter_real_add_object (SeahorseDeleter* base,
                                              GObject* obj)
{
	SeahorseGkrKeyringDeleter * self;
	SeahorseGkrKeyring* _tmp0_;
	gboolean result;
	self = (SeahorseGkrKeyringDeleter*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = self->priv->_keyring;
	if (_tmp0_ != NULL) {
		result = FALSE;
		return result;
	}
	if (SEAHORSE_GKR_IS_KEYRING (obj)) {
		SeahorseGkrKeyring* _tmp1_;
		GObject* _tmp2_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
		_g_object_unref0 (self->priv->_keyring);
		self->priv->_keyring = _tmp1_;
		_tmp2_ = _g_object_ref0 (obj);
		self->priv->_objects = g_list_append (self->priv->_objects, _tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
seahorse_gkr_keyring_deleter_real_delete_data_free (gpointer _data)
{
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringDeleterDeleteData, _data_);
}

static void
seahorse_gkr_keyring_deleter_real_delete (SeahorseDeleter* base,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SeahorseGkrKeyringDeleter * self;
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	SeahorseGkrKeyringDeleter* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseGkrKeyringDeleter*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringDeleterDeleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_keyring_deleter_real_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_gkr_keyring_deleter_real_delete_co (_data_);
}

static gboolean
seahorse_gkr_keyring_deleter_delete_finish (SeahorseDeleter* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	gboolean result;
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_gkr_keyring_deleter_delete_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_keyring_deleter_real_delete_co (_data_);
}

static gboolean
seahorse_gkr_keyring_deleter_real_delete_co (SeahorseGkrKeyringDeleterDeleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_keyring;
	_data_->_state_ = 1;
	secret_collection_delete ((SecretCollection*) _data_->_tmp0_, _data_->cancellable, seahorse_gkr_keyring_deleter_delete_ready, _data_);
	return FALSE;
	_state_1:
	secret_collection_delete_finish ((SecretCollection*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_keyring_deleter_class_init (SeahorseGkrKeyringDeleterClass * klass,
                                         gpointer klass_data)
{
	seahorse_gkr_keyring_deleter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrKeyringDeleter_private_offset);
	((SeahorseDeleterClass *) klass)->create_confirm = (GtkDialog* (*) (SeahorseDeleter*, GtkWindow*)) seahorse_gkr_keyring_deleter_real_create_confirm;
	((SeahorseDeleterClass *) klass)->get_objects = (GList* (*) (SeahorseDeleter*)) seahorse_gkr_keyring_deleter_real_get_objects;
	((SeahorseDeleterClass *) klass)->add_object = (gboolean (*) (SeahorseDeleter*, GObject*)) seahorse_gkr_keyring_deleter_real_add_object;
	((SeahorseDeleterClass *) klass)->delete = (void (*) (SeahorseDeleter*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_gkr_keyring_deleter_real_delete;
	((SeahorseDeleterClass *) klass)->delete_finish = (gboolean (*) (SeahorseDeleter*, GAsyncResult*, GError**)) seahorse_gkr_keyring_deleter_delete_finish;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_keyring_deleter_finalize;
}

static void
seahorse_gkr_keyring_deleter_instance_init (SeahorseGkrKeyringDeleter * self,
                                            gpointer klass)
{
	self->priv = seahorse_gkr_keyring_deleter_get_instance_private (self);
}

static void
seahorse_gkr_keyring_deleter_finalize (GObject * obj)
{
	SeahorseGkrKeyringDeleter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleter);
	_g_object_unref0 (self->priv->_keyring);
	(self->priv->_objects == NULL) ? NULL : (self->priv->_objects = (_g_list_free__g_object_unref0_ (self->priv->_objects), NULL));
	G_OBJECT_CLASS (seahorse_gkr_keyring_deleter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_keyring_deleter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrKeyringDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_keyring_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrKeyringDeleter), 0, (GInstanceInitFunc) seahorse_gkr_keyring_deleter_instance_init, NULL };
	GType seahorse_gkr_keyring_deleter_type_id;
	seahorse_gkr_keyring_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseGkrKeyringDeleter", &g_define_type_info, 0);
	SeahorseGkrKeyringDeleter_private_offset = g_type_add_instance_private (seahorse_gkr_keyring_deleter_type_id, sizeof (SeahorseGkrKeyringDeleterPrivate));
	return seahorse_gkr_keyring_deleter_type_id;
}

GType
seahorse_gkr_keyring_deleter_get_type (void)
{
	static volatile gsize seahorse_gkr_keyring_deleter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_keyring_deleter_type_id__once)) {
		GType seahorse_gkr_keyring_deleter_type_id;
		seahorse_gkr_keyring_deleter_type_id = seahorse_gkr_keyring_deleter_get_type_once ();
		g_once_init_leave (&seahorse_gkr_keyring_deleter_type_id__once, seahorse_gkr_keyring_deleter_type_id);
	}
	return seahorse_gkr_keyring_deleter_type_id__once;
}

