/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.websocket.server.WsContextListener;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsSessionListener;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class WsSci
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> set, ServletContext servletContext) throws ServletException {
        Object object;
        Object object3;
        WsServerContainer wsServerContainer = WsSci.init(servletContext, true);
        if (set == null || set.size() == 0) {
            return;
        }
        HashSet<ServerApplicationConfig> hashSet = new HashSet<ServerApplicationConfig>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet hashSet3 = new HashSet();
        try {
            object3 = ContainerProvider.class.getName();
            object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf(46) + 1);
            for (Class<?> iterator : set) {
                JreCompat jreCompat = JreCompat.getInstance();
                int n = iterator.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isInterface(n) || !jreCompat.isExported(iterator) || iterator.getName().startsWith((String)object3)) continue;
                if (ServerApplicationConfig.class.isAssignableFrom(iterator)) {
                    hashSet.add((ServerApplicationConfig)iterator.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                if (Endpoint.class.isAssignableFrom(iterator)) {
                    object = iterator;
                    hashSet2.add(object);
                }
                if (!iterator.isAnnotationPresent(ServerEndpoint.class)) continue;
                hashSet3.add(iterator);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ServletException((Throwable)reflectiveOperationException);
        }
        object3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        if (hashSet.isEmpty()) {
            hashSet4.addAll(hashSet3);
        } else {
            for (ServerApplicationConfig serverApplicationConfig : hashSet) {
                Set set2 = serverApplicationConfig.getEndpointConfigs(hashSet2);
                if (set2 != null) {
                    object3.addAll(set2);
                }
                if ((object = serverApplicationConfig.getAnnotatedEndpointClasses(hashSet3)) == null) continue;
                hashSet4.addAll(object);
            }
        }
        try {
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)iterator.next();
                wsServerContainer.addEndpoint(serverEndpointConfig);
            }
            Iterator iterator2 = hashSet4.iterator();
            while (iterator2.hasNext()) {
                Class clazz = (Class)iterator2.next();
                wsServerContainer.addEndpoint(clazz, true);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new ServletException((Throwable)deploymentException);
        }
    }

    static WsServerContainer init(ServletContext servletContext, boolean bl) {
        WsServerContainer wsServerContainer = new WsServerContainer(servletContext);
        servletContext.setAttribute("jakarta.websocket.server.ServerContainer", (Object)wsServerContainer);
        servletContext.addListener((EventListener)((Object)new WsSessionListener(wsServerContainer)));
        if (bl) {
            servletContext.addListener((EventListener)((Object)new WsContextListener()));
        }
        return wsServerContainer;
    }
}

