/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.cpdsadapter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.cpdsadapter.PooledConnectionImpl;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class DriverAdapterCPDS
implements ConnectionPoolDataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static final long serialVersionUID = -4820523787212147844L;
    private static final String GET_CONNECTION_CALLED = "A PooledConnection was already requested from this source, further initialization is not allowed.";
    private String description;
    private String url;
    private String userName;
    private char[] userPassword;
    private String driver;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private boolean poolPreparedStatements;
    private int maxIdle = 10;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = -1;
    private int minEvictableIdleTimeMillis = -1;
    private int maxPreparedStatements = -1;
    private volatile boolean getConnectionCalled;
    private Properties connectionProperties;
    private boolean accessToUnderlyingConnectionAllowed;

    private void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    private boolean getBooleanContentString(RefAddr refAddr) {
        return Boolean.parseBoolean(this.getStringContent(refAddr));
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriver() {
        return this.driver;
    }

    private int getIntegerStringContent(RefAddr refAddr) {
        return Integer.parseInt(this.getStringContent(refAddr));
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxPreparedStatements() {
        return this.maxPreparedStatements;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Reference reference;
        DriverAdapterCPDS driverAdapterCPDS = null;
        if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(this.getClass().getName())) {
            RefAddr refAddr = reference.get("description");
            if (this.isNotEmpty(refAddr)) {
                this.setDescription(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("driver"))) {
                this.setDriver(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("url"))) {
                this.setUrl(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("user"))) {
                this.setUser(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("password"))) {
                this.setPassword(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("poolPreparedStatements"))) {
                this.setPoolPreparedStatements(this.getBooleanContentString(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("maxIdle"))) {
                this.setMaxIdle(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("timeBetweenEvictionRunsMillis"))) {
                this.setTimeBetweenEvictionRunsMillis(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("numTestsPerEvictionRun"))) {
                this.setNumTestsPerEvictionRun(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("minEvictableIdleTimeMillis"))) {
                this.setMinEvictableIdleTimeMillis(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("maxPreparedStatements"))) {
                this.setMaxPreparedStatements(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("accessToUnderlyingConnectionAllowed"))) {
                this.setAccessToUnderlyingConnectionAllowed(this.getBooleanContentString(refAddr));
            }
            driverAdapterCPDS = this;
        }
        return driverAdapterCPDS;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getPassword() {
        return Utils.toString(this.userPassword);
    }

    public char[] getPasswordCharArray() {
        return this.userPassword == null ? null : (char[])this.userPassword.clone();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.getConnectionCalled = true;
        PooledConnectionImpl pooledConnectionImpl = null;
        try {
            if (this.connectionProperties != null) {
                this.update(this.connectionProperties, "user", string);
                this.update(this.connectionProperties, "password", string2);
                pooledConnectionImpl = new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties));
            } else {
                pooledConnectionImpl = new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), string, string2));
            }
            pooledConnectionImpl.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        }
        catch (ClassCircularityError classCircularityError) {
            pooledConnectionImpl = this.connectionProperties != null ? new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties)) : new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), string, string2));
            pooledConnectionImpl.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        }
        GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> genericKeyedObjectPool = null;
        if (this.isPoolPreparedStatements()) {
            GenericKeyedObjectPoolConfig genericKeyedObjectPoolConfig = new GenericKeyedObjectPoolConfig();
            genericKeyedObjectPoolConfig.setMaxTotalPerKey(Integer.MAX_VALUE);
            genericKeyedObjectPoolConfig.setBlockWhenExhausted(false);
            genericKeyedObjectPoolConfig.setMaxWaitMillis(0L);
            genericKeyedObjectPoolConfig.setMaxIdlePerKey(this.getMaxIdle());
            if (this.getMaxPreparedStatements() <= 0) {
                genericKeyedObjectPoolConfig.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
                genericKeyedObjectPoolConfig.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
                genericKeyedObjectPoolConfig.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
            } else {
                genericKeyedObjectPoolConfig.setMaxTotal(this.getMaxPreparedStatements());
                genericKeyedObjectPoolConfig.setTimeBetweenEvictionRunsMillis(-1L);
                genericKeyedObjectPoolConfig.setNumTestsPerEvictionRun(0);
                genericKeyedObjectPoolConfig.setMinEvictableIdleTimeMillis(0L);
            }
            genericKeyedObjectPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>(pooledConnectionImpl, genericKeyedObjectPoolConfig);
            pooledConnectionImpl.setStatementPool(genericKeyedObjectPool);
        }
        return pooledConnectionImpl;
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = this.getClass().getName();
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("driver", this.getDriver()));
        reference.add(new StringRefAddr("loginTimeout", String.valueOf(this.getLoginTimeout())));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("url", this.getUrl()));
        reference.add(new StringRefAddr("poolPreparedStatements", String.valueOf(this.isPoolPreparedStatements())));
        reference.add(new StringRefAddr("maxIdle", String.valueOf(this.getMaxIdle())));
        reference.add(new StringRefAddr("timeBetweenEvictionRunsMillis", String.valueOf(this.getTimeBetweenEvictionRunsMillis())));
        reference.add(new StringRefAddr("numTestsPerEvictionRun", String.valueOf(this.getNumTestsPerEvictionRun())));
        reference.add(new StringRefAddr("minEvictableIdleTimeMillis", String.valueOf(this.getMinEvictableIdleTimeMillis())));
        reference.add(new StringRefAddr("maxPreparedStatements", String.valueOf(this.getMaxPreparedStatements())));
        return reference;
    }

    private String getStringContent(RefAddr refAddr) {
        return refAddr.getContent().toString();
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.userName;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    private boolean isNotEmpty(RefAddr refAddr) {
        return refAddr != null && refAddr.getContent() != null;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public void setConnectionProperties(Properties properties) {
        this.assertInitializationAllowed();
        this.connectionProperties = properties;
        if (this.connectionProperties != null) {
            if (this.connectionProperties.containsKey("user")) {
                this.setUser(this.connectionProperties.getProperty("user"));
            }
            if (this.connectionProperties.containsKey("password")) {
                this.setPassword(this.connectionProperties.getProperty("password"));
            }
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDriver(String string) throws ClassNotFoundException {
        this.assertInitializationAllowed();
        this.driver = string;
        Class.forName(string);
    }

    @Override
    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.maxIdle = n;
    }

    public void setMaxPreparedStatements(int n) {
        this.maxPreparedStatements = n;
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        this.assertInitializationAllowed();
        this.minEvictableIdleTimeMillis = n;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this.numTestsPerEvictionRun = n;
    }

    public void setPassword(char[] cArray) {
        this.assertInitializationAllowed();
        this.userPassword = Utils.clone(cArray);
        this.update(this.connectionProperties, "password", Utils.toString(this.userPassword));
    }

    public void setPassword(String string) {
        this.assertInitializationAllowed();
        this.userPassword = Utils.toCharArray(string);
        this.update(this.connectionProperties, "password", string);
    }

    public void setPoolPreparedStatements(boolean bl) {
        this.assertInitializationAllowed();
        this.poolPreparedStatements = bl;
    }

    public void setTimeBetweenEvictionRunsMillis(long l) {
        this.assertInitializationAllowed();
        this.timeBetweenEvictionRunsMillis = l;
    }

    public void setUrl(String string) {
        this.assertInitializationAllowed();
        this.url = string;
    }

    public void setUser(String string) {
        this.assertInitializationAllowed();
        this.userName = string;
        this.update(this.connectionProperties, "user", string);
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[description=");
        stringBuilder.append(this.description);
        stringBuilder.append(", url=");
        stringBuilder.append(this.url);
        stringBuilder.append(", driver=");
        stringBuilder.append(this.driver);
        stringBuilder.append(", loginTimeout=");
        stringBuilder.append(this.loginTimeout);
        stringBuilder.append(", poolPreparedStatements=");
        stringBuilder.append(this.poolPreparedStatements);
        stringBuilder.append(", maxIdle=");
        stringBuilder.append(this.maxIdle);
        stringBuilder.append(", timeBetweenEvictionRunsMillis=");
        stringBuilder.append(this.timeBetweenEvictionRunsMillis);
        stringBuilder.append(", numTestsPerEvictionRun=");
        stringBuilder.append(this.numTestsPerEvictionRun);
        stringBuilder.append(", minEvictableIdleTimeMillis=");
        stringBuilder.append(this.minEvictableIdleTimeMillis);
        stringBuilder.append(", maxPreparedStatements=");
        stringBuilder.append(this.maxPreparedStatements);
        stringBuilder.append(", getConnectionCalled=");
        stringBuilder.append(this.getConnectionCalled);
        stringBuilder.append(", connectionProperties=");
        stringBuilder.append(Utils.cloneWithoutCredentials(this.connectionProperties));
        stringBuilder.append(", accessToUnderlyingConnectionAllowed=");
        stringBuilder.append(this.accessToUnderlyingConnectionAllowed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void update(Properties properties, String string, String string2) {
        if (properties != null && string != null) {
            if (string2 == null) {
                properties.remove(string);
            } else {
                properties.setProperty(string, string2);
            }
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

