/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PoolUtils;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectState;
import org.apache.tomcat.dbcp.pool2.UsageTracking;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.BaseGenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObjectInfo;
import org.apache.tomcat.dbcp.pool2.impl.EvictionConfig;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolMXBean;
import org.apache.tomcat.dbcp.pool2.impl.LinkedBlockingDeque;

public class GenericKeyedObjectPool<K, T>
extends BaseGenericObjectPool<T>
implements KeyedObjectPool<K, T>,
GenericKeyedObjectPoolMXBean<K>,
UsageTracking<T> {
    private static final Integer ZERO = 0;
    private static final String ONAME_BASE = "org.apache.commons.pool2:type=GenericKeyedObjectPool,name=";
    private volatile int maxIdlePerKey = 8;
    private volatile int minIdlePerKey = 0;
    private volatile int maxTotalPerKey = 8;
    private final KeyedPooledObjectFactory<K, T> factory;
    private final boolean fairness;
    private final Map<K, ObjectDeque<T>> poolMap = new ConcurrentHashMap<K, ObjectDeque<T>>();
    private final List<K> poolKeyList = new ArrayList<K>();
    private final ReadWriteLock keyLock = new ReentrantReadWriteLock(true);
    private final AtomicInteger numTotal = new AtomicInteger(0);
    private Iterator<K> evictionKeyIterator;
    private K evictionKey;

    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> keyedPooledObjectFactory) {
        this(keyedPooledObjectFactory, new GenericKeyedObjectPoolConfig());
    }

    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> keyedPooledObjectFactory, GenericKeyedObjectPoolConfig<T> genericKeyedObjectPoolConfig) {
        super(genericKeyedObjectPoolConfig, ONAME_BASE, genericKeyedObjectPoolConfig.getJmxNamePrefix());
        if (keyedPooledObjectFactory == null) {
            this.jmxUnregister();
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.factory = keyedPooledObjectFactory;
        this.fairness = genericKeyedObjectPoolConfig.getFairness();
        this.setConfig(genericKeyedObjectPoolConfig);
    }

    public GenericKeyedObjectPool(KeyedPooledObjectFactory<K, T> keyedPooledObjectFactory, GenericKeyedObjectPoolConfig<T> genericKeyedObjectPoolConfig, AbandonedConfig abandonedConfig) {
        this(keyedPooledObjectFactory, genericKeyedObjectPoolConfig);
        this.setAbandonedConfig(abandonedConfig);
    }

    private void addIdleObject(K k, PooledObject<T> pooledObject) throws Exception {
        if (pooledObject != null) {
            this.factory.passivateObject(k, pooledObject);
            LinkedBlockingDeque<PooledObject<T>> linkedBlockingDeque = this.poolMap.get(k).getIdleObjects();
            if (this.getLifo()) {
                linkedBlockingDeque.addFirst(pooledObject);
            } else {
                linkedBlockingDeque.addLast(pooledObject);
            }
        }
    }

    @Override
    public void addObject(K k) throws Exception {
        this.assertOpen();
        this.register(k);
        try {
            PooledObject<T> pooledObject = this.create(k);
            this.addIdleObject(k, pooledObject);
        }
        finally {
            this.deregister(k);
        }
    }

    @Override
    public T borrowObject(K k) throws Exception {
        return this.borrowObject(k, this.getMaxWaitDuration().toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowObject(K k, long l) throws Exception {
        this.assertOpen();
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnBorrow() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxTotal() - 3) {
            this.removeAbandoned(abandonedConfig);
        }
        PooledObject<T> pooledObject = null;
        boolean bl = this.getBlockWhenExhausted();
        long l2 = System.currentTimeMillis();
        ObjectDeque<T> objectDeque = this.register(k);
        try {
            while (pooledObject == null) {
                Throwable throwable;
                boolean bl2;
                block20: {
                    bl2 = false;
                    pooledObject = objectDeque.getIdleObjects().pollFirst();
                    if (pooledObject == null && (pooledObject = this.create(k)) != null) {
                        bl2 = true;
                    }
                    if (bl) {
                        if (pooledObject == null) {
                            pooledObject = l < 0L ? objectDeque.getIdleObjects().takeFirst() : objectDeque.getIdleObjects().pollFirst(l, TimeUnit.MILLISECONDS);
                        }
                        if (pooledObject == null) {
                            throw new NoSuchElementException(this.appendStats("Timeout waiting for idle object, borrowMaxWaitMillis=" + l));
                        }
                    } else if (pooledObject == null) {
                        throw new NoSuchElementException(this.appendStats("Pool exhausted"));
                    }
                    if (!pooledObject.allocate()) {
                        pooledObject = null;
                    }
                    if (pooledObject == null) continue;
                    try {
                        this.factory.activateObject(k, pooledObject);
                    }
                    catch (Exception exception) {
                        try {
                            this.destroy(k, pooledObject, true, DestroyMode.NORMAL);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        pooledObject = null;
                        if (!bl2) break block20;
                        throwable = new NoSuchElementException(this.appendStats("Unable to activate object"));
                        throwable.initCause(exception);
                        throw throwable;
                    }
                }
                if (pooledObject == null || !this.getTestOnBorrow()) continue;
                boolean bl3 = false;
                throwable = null;
                try {
                    bl3 = this.factory.validateObject(k, pooledObject);
                }
                catch (Throwable throwable2) {
                    PoolUtils.checkRethrow(throwable2);
                    throwable = throwable2;
                }
                if (bl3) continue;
                try {
                    this.destroy(k, pooledObject, true, DestroyMode.NORMAL);
                    this.destroyedByBorrowValidationCount.incrementAndGet();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pooledObject = null;
                if (!bl2) continue;
                NoSuchElementException noSuchElementException = new NoSuchElementException(this.appendStats("Unable to validate object"));
                noSuchElementException.initCause(throwable);
                throw noSuchElementException;
            }
        }
        finally {
            this.deregister(k);
        }
        this.updateStatsBorrow(pooledObject, Duration.ofMillis(System.currentTimeMillis() - l2));
        return pooledObject.getObject();
    }

    private int calculateDeficit(ObjectDeque<T> objectDeque) {
        int n;
        if (objectDeque == null) {
            return this.getMinIdlePerKey();
        }
        int n2 = this.getMaxTotal();
        int n3 = this.getMaxTotalPerKey();
        int n4 = this.getMinIdlePerKey() - objectDeque.getIdleObjects().size();
        if (n3 > 0) {
            n = Math.max(0, n3 - objectDeque.getIdleObjects().size());
            n4 = Math.min(n4, n);
        }
        if (n2 > 0) {
            n = Math.max(0, n2 - this.getNumActive() - this.getNumIdle());
            n4 = Math.min(n4, n);
        }
        return n4;
    }

    @Override
    public void clear() {
        this.poolMap.keySet().forEach(this::clear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(K k) {
        ObjectDeque<T> objectDeque = this.register(k);
        try {
            LinkedBlockingDeque<PooledObject<T>> linkedBlockingDeque = objectDeque.getIdleObjects();
            PooledObject<T> pooledObject = linkedBlockingDeque.poll();
            while (pooledObject != null) {
                try {
                    this.destroy(k, pooledObject, true, DestroyMode.NORMAL);
                }
                catch (Exception exception) {
                    this.swallowException(exception);
                }
                pooledObject = linkedBlockingDeque.poll();
            }
        }
        finally {
            this.deregister(k);
        }
    }

    public void clearOldest() {
        TreeMap treeMap = new TreeMap();
        this.poolMap.forEach((object, objectDeque) -> {
            if (objectDeque != null) {
                objectDeque.getIdleObjects().forEach(pooledObject -> treeMap.put(pooledObject, object));
            }
        });
        int n = (int)((double)treeMap.size() * 0.15) + 1;
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext() && n > 0) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            PooledObject pooledObject = (PooledObject)entry.getKey();
            boolean bl = true;
            try {
                bl = this.destroy(v, pooledObject, false, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            if (!bl) continue;
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.stopEvictor();
            this.closed = true;
            this.clear();
            this.jmxUnregister();
            this.poolMap.values().forEach(objectDeque -> objectDeque.getIdleObjects().interuptTakeWaiters());
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledObject<T> create(K k) throws Exception {
        PooledObject<T> pooledObject;
        int n = this.getMaxTotalPerKey();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = this.getMaxTotal();
        ObjectDeque<T> objectDeque = this.poolMap.get(k);
        boolean bl = true;
        while (bl) {
            int n3 = this.numTotal.incrementAndGet();
            if (n2 > -1 && n3 > n2) {
                this.numTotal.decrementAndGet();
                if (this.getNumIdle() == 0) {
                    return null;
                }
                this.clearOldest();
                continue;
            }
            bl = false;
        }
        Boolean bl2 = null;
        while (bl2 == null) {
            pooledObject = ((ObjectDeque)objectDeque).makeObjectCountLock;
            synchronized (pooledObject) {
                long l = objectDeque.getCreateCount().incrementAndGet();
                if (l > (long)n) {
                    objectDeque.getCreateCount().decrementAndGet();
                    if (((ObjectDeque)objectDeque).makeObjectCount == 0L) {
                        bl2 = Boolean.FALSE;
                    } else {
                        ((ObjectDeque)objectDeque).makeObjectCountLock.wait();
                    }
                } else {
                    ((ObjectDeque)objectDeque).makeObjectCount++;
                    bl2 = Boolean.TRUE;
                }
            }
        }
        if (!bl2.booleanValue()) {
            this.numTotal.decrementAndGet();
            return null;
        }
        pooledObject = null;
        try {
            pooledObject = this.factory.makeObject(k);
            if (this.getTestOnCreate() && !this.factory.validateObject(k, pooledObject)) {
                this.numTotal.decrementAndGet();
                objectDeque.getCreateCount().decrementAndGet();
                PooledObject<T> pooledObject2 = null;
                return pooledObject2;
            }
        }
        catch (Exception exception) {
            this.numTotal.decrementAndGet();
            objectDeque.getCreateCount().decrementAndGet();
            throw exception;
        }
        finally {
            Object object = ((ObjectDeque)objectDeque).makeObjectCountLock;
            synchronized (object) {
                ((ObjectDeque)objectDeque).makeObjectCount--;
                ((ObjectDeque)objectDeque).makeObjectCountLock.notifyAll();
            }
        }
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getLogAbandoned()) {
            pooledObject.setLogAbandoned(true);
            pooledObject.setRequireFullStackTrace(abandonedConfig.getRequireFullStackTrace());
        }
        this.createdCount.incrementAndGet();
        objectDeque.getAllObjects().put(new BaseGenericObjectPool.IdentityWrapper<T>(pooledObject.getObject()), pooledObject);
        return pooledObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister(K k) {
        Lock lock = this.keyLock.readLock();
        try {
            lock.lock();
            ObjectDeque<T> objectDeque = this.poolMap.get(k);
            long l = objectDeque.getNumInterested().decrementAndGet();
            if (l == 0L && objectDeque.getCreateCount().get() == 0) {
                lock.unlock();
                lock = this.keyLock.writeLock();
                lock.lock();
                if (objectDeque.getCreateCount().get() == 0 && objectDeque.getNumInterested().get() == 0L) {
                    this.poolMap.remove(k);
                    this.poolKeyList.remove(k);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroy(K k, PooledObject<T> pooledObject, boolean bl, DestroyMode destroyMode) throws Exception {
        ObjectDeque<T> objectDeque = this.register(k);
        try {
            boolean bl2;
            PooledObject<T> pooledObject2 = pooledObject;
            synchronized (pooledObject2) {
                bl2 = pooledObject.getState().equals((Object)PooledObjectState.IDLE);
                if (bl2 || bl) {
                    bl2 = objectDeque.getIdleObjects().remove(pooledObject);
                }
            }
            if (bl2 || bl) {
                objectDeque.getAllObjects().remove(new BaseGenericObjectPool.IdentityWrapper<T>(pooledObject.getObject()));
                pooledObject.invalidate();
                try {
                    this.factory.destroyObject(k, pooledObject, destroyMode);
                }
                finally {
                    objectDeque.getCreateCount().decrementAndGet();
                    this.destroyedCount.incrementAndGet();
                    this.numTotal.decrementAndGet();
                }
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.deregister(k);
        }
    }

    @Override
    void ensureMinIdle() throws Exception {
        int n = this.getMinIdlePerKey();
        if (n < 1) {
            return;
        }
        for (K k : this.poolMap.keySet()) {
            this.ensureMinIdle(k);
        }
    }

    private void ensureMinIdle(K k) throws Exception {
        ObjectDeque<T> objectDeque = this.poolMap.get(k);
        int n = this.calculateDeficit(objectDeque);
        for (int i = 0; i < n && this.calculateDeficit(objectDeque) > 0; ++i) {
            this.addObject(k);
            if (objectDeque != null) continue;
            objectDeque = this.poolMap.get(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() throws Exception {
        Object object;
        this.assertOpen();
        if (this.getNumIdle() > 0) {
            object = null;
            EvictionPolicy evictionPolicy = this.getEvictionPolicy();
            Object object2 = this.evictionLock;
            synchronized (object2) {
                EvictionConfig evictionConfig = new EvictionConfig(this.getMinEvictableIdleDuration(), this.getSoftMinEvictableIdleDuration(), this.getMinIdlePerKey());
                boolean bl = this.getTestWhileIdle();
                int n = this.getNumTests();
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    ObjectDeque<T> objectDeque;
                    if (this.evictionIterator == null || !this.evictionIterator.hasNext()) {
                        if (this.evictionKeyIterator == null || !this.evictionKeyIterator.hasNext()) {
                            objectDeque = new ArrayList<K>();
                            Lock lock = this.keyLock.readLock();
                            lock.lock();
                            try {
                                objectDeque.addAll(this.poolKeyList);
                            }
                            finally {
                                lock.unlock();
                            }
                            this.evictionKeyIterator = objectDeque.iterator();
                        }
                        while (this.evictionKeyIterator.hasNext()) {
                            this.evictionKey = this.evictionKeyIterator.next();
                            objectDeque = this.poolMap.get(this.evictionKey);
                            if (objectDeque == null) continue;
                            LinkedBlockingDeque linkedBlockingDeque = objectDeque.getIdleObjects();
                            this.evictionIterator = new BaseGenericObjectPool.EvictionIterator(linkedBlockingDeque);
                            if (this.evictionIterator.hasNext()) break;
                            this.evictionIterator = null;
                        }
                    }
                    if (this.evictionIterator == null) {
                        return;
                    }
                    try {
                        object = this.evictionIterator.next();
                        objectDeque = this.evictionIterator.getIdleObjects();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        --i;
                        this.evictionIterator = null;
                        continue;
                    }
                    if (!object.startEvictionTest()) {
                        --i;
                        continue;
                    }
                    try {
                        bl2 = evictionPolicy.evict(evictionConfig, object, this.poolMap.get(this.evictionKey).getIdleObjects().size());
                    }
                    catch (Throwable throwable) {
                        PoolUtils.checkRethrow(throwable);
                        this.swallowException(new Exception(throwable));
                        bl2 = false;
                    }
                    if (bl2) {
                        this.destroy(this.evictionKey, (PooledObject<T>)object, true, DestroyMode.NORMAL);
                        this.destroyedByEvictorCount.incrementAndGet();
                        continue;
                    }
                    if (bl) {
                        boolean bl3 = false;
                        try {
                            this.factory.activateObject(this.evictionKey, (PooledObject<T>)object);
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            this.destroy(this.evictionKey, (PooledObject<T>)object, true, DestroyMode.NORMAL);
                            this.destroyedByEvictorCount.incrementAndGet();
                        }
                        if (bl3) {
                            boolean bl4 = false;
                            Throwable throwable = null;
                            try {
                                bl4 = this.factory.validateObject(this.evictionKey, (PooledObject<T>)object);
                            }
                            catch (Throwable throwable2) {
                                PoolUtils.checkRethrow(throwable2);
                                throwable = throwable2;
                            }
                            if (!bl4) {
                                this.destroy(this.evictionKey, (PooledObject<T>)object, true, DestroyMode.NORMAL);
                                this.destroyedByEvictorCount.incrementAndGet();
                                if (throwable != null) {
                                    if (throwable instanceof RuntimeException) {
                                        throw (RuntimeException)throwable;
                                    }
                                    throw (Error)throwable;
                                }
                            } else {
                                try {
                                    this.factory.passivateObject(this.evictionKey, (PooledObject<T>)object);
                                }
                                catch (Exception exception) {
                                    this.destroy(this.evictionKey, (PooledObject<T>)object, true, DestroyMode.NORMAL);
                                    this.destroyedByEvictorCount.incrementAndGet();
                                }
                            }
                        }
                    }
                    if (object.endEvictionTest(objectDeque)) continue;
                }
            }
        }
        if ((object = this.abandonedConfig) != null && ((AbandonedConfig)object).getRemoveAbandonedOnMaintenance()) {
            this.removeAbandoned((AbandonedConfig)object);
        }
    }

    public KeyedPooledObjectFactory<K, T> getFactory() {
        return this.factory;
    }

    @Override
    public int getMaxIdlePerKey() {
        return this.maxIdlePerKey;
    }

    @Override
    public int getMaxTotalPerKey() {
        return this.maxTotalPerKey;
    }

    @Override
    public int getMinIdlePerKey() {
        int n = this.getMaxIdlePerKey();
        return this.minIdlePerKey > n ? n : this.minIdlePerKey;
    }

    @Override
    public int getNumActive() {
        return this.numTotal.get() - this.getNumIdle();
    }

    @Override
    public int getNumActive(K k) {
        ObjectDeque<T> objectDeque = this.poolMap.get(k);
        if (objectDeque != null) {
            return objectDeque.getAllObjects().size() - objectDeque.getIdleObjects().size();
        }
        return 0;
    }

    @Override
    public Map<String, Integer> getNumActivePerKey() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.poolMap.entrySet().forEach(entry -> {
            if (entry != null) {
                Object k = entry.getKey();
                ObjectDeque objectDeque = (ObjectDeque)entry.getValue();
                if (k != null && objectDeque != null) {
                    hashMap.put(k.toString(), objectDeque.getAllObjects().size() - objectDeque.getIdleObjects().size());
                }
            }
        });
        return hashMap;
    }

    @Override
    public int getNumIdle() {
        return this.poolMap.values().stream().mapToInt(objectDeque -> objectDeque.getIdleObjects().size()).sum();
    }

    @Override
    public int getNumIdle(K k) {
        ObjectDeque<T> objectDeque = this.poolMap.get(k);
        return objectDeque != null ? objectDeque.getIdleObjects().size() : 0;
    }

    private int getNumTests() {
        int n = this.getNumIdle();
        int n2 = this.getNumTestsPerEvictionRun();
        if (n2 >= 0) {
            return Math.min(n2, n);
        }
        return (int)Math.ceil((double)n / Math.abs((double)n2));
    }

    @Override
    public int getNumWaiters() {
        if (this.getBlockWhenExhausted()) {
            return this.poolMap.values().stream().mapToInt(objectDeque -> objectDeque.getIdleObjects().getTakeQueueLength()).sum();
        }
        return 0;
    }

    @Override
    public Map<String, Integer> getNumWaitersByKey() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry<K, ObjectDeque<T>> entry : this.poolMap.entrySet()) {
            K k = entry.getKey();
            ObjectDeque<T> objectDeque = entry.getValue();
            if (objectDeque == null) continue;
            hashMap.put(k.toString(), this.getBlockWhenExhausted() ? Integer.valueOf(objectDeque.getIdleObjects().getTakeQueueLength()) : ZERO);
        }
        return hashMap;
    }

    @Override
    String getStatsString() {
        return super.getStatsString() + String.format(", fairness=%s, maxIdlePerKey%,d, maxTotalPerKey=%,d, minIdlePerKey=%,d, numTotal=%,d", this.fairness, this.maxIdlePerKey, this.maxTotalPerKey, this.minIdlePerKey, this.numTotal.get());
    }

    private boolean hasBorrowWaiters() {
        return this.poolMap.values().stream().anyMatch(objectDeque -> objectDeque != null && objectDeque.getIdleObjects().hasTakeWaiters());
    }

    @Override
    public void invalidateObject(K k, T t) throws Exception {
        this.invalidateObject(k, t, DestroyMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(K k, T t, DestroyMode destroyMode) throws Exception {
        ObjectDeque<T> objectDeque = this.poolMap.get(k);
        PooledObject<T> pooledObject = objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<T>(t));
        if (pooledObject == null) {
            throw new IllegalStateException(this.appendStats("Object not currently part of this pool"));
        }
        PooledObject<T> pooledObject2 = pooledObject;
        synchronized (pooledObject2) {
            if (pooledObject.getState() != PooledObjectState.INVALID) {
                this.destroy(k, pooledObject, true, destroyMode);
            }
        }
        if (((ObjectDeque)objectDeque).idleObjects.hasTakeWaiters()) {
            this.addObject(k);
        }
    }

    @Override
    public Map<String, List<DefaultPooledObjectInfo>> listAllObjects() {
        HashMap<String, List<DefaultPooledObjectInfo>> hashMap = new HashMap<String, List<DefaultPooledObjectInfo>>();
        this.poolMap.forEach((object, objectDeque) -> {
            if (objectDeque != null) {
                hashMap.put(object.toString(), objectDeque.getAllObjects().values().stream().map(DefaultPooledObjectInfo::new).collect(Collectors.toList()));
            }
        });
        return hashMap;
    }

    public void preparePool(K k) throws Exception {
        int n = this.getMinIdlePerKey();
        if (n < 1) {
            return;
        }
        this.ensureMinIdle(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectDeque<T> register(K k) {
        Lock lock = this.keyLock.readLock();
        ObjectDeque<Object> objectDeque = null;
        try {
            lock.lock();
            objectDeque = this.poolMap.get(k);
            if (objectDeque == null) {
                lock.unlock();
                lock = this.keyLock.writeLock();
                lock.lock();
                objectDeque = this.poolMap.get(k);
                if (objectDeque == null) {
                    objectDeque = new ObjectDeque(this.fairness);
                    objectDeque.getNumInterested().incrementAndGet();
                    this.poolMap.put(k, objectDeque);
                    this.poolKeyList.add(k);
                } else {
                    objectDeque.getNumInterested().incrementAndGet();
                }
            } else {
                objectDeque.getNumInterested().incrementAndGet();
            }
        }
        finally {
            lock.unlock();
        }
        return objectDeque;
    }

    private void removeAbandoned(AbandonedConfig abandonedConfig) {
        this.poolMap.forEach((object, objectDeque) -> {
            ArrayList arrayList = this.createRemoveList(abandonedConfig, objectDeque.getAllObjects());
            arrayList.forEach(pooledObject -> {
                if (abandonedConfig.getLogAbandoned()) {
                    pooledObject.printStackTrace(abandonedConfig.getLogWriter());
                }
                try {
                    this.invalidateObject((K)object, (T)pooledObject.getObject(), DestroyMode.ABANDONED);
                }
                catch (Exception exception) {
                    this.swallowException(exception);
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(K k, T t) {
        ObjectDeque<T> objectDeque = this.poolMap.get(k);
        if (objectDeque == null) {
            throw new IllegalStateException("No keyed pool found under the given key.");
        }
        PooledObject<T> pooledObject = objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<T>(t));
        if (pooledObject == null) {
            throw new IllegalStateException("Returned object not currently part of this pool");
        }
        this.markReturningState(pooledObject);
        Duration duration = pooledObject.getActiveDuration();
        try {
            if (this.getTestOnReturn() && !this.factory.validateObject(k, pooledObject)) {
                try {
                    this.destroy(k, pooledObject, true, DestroyMode.NORMAL);
                }
                catch (Exception exception) {
                    this.swallowException(exception);
                }
                this.whenWaitersAddObject(k, ((ObjectDeque)objectDeque).idleObjects);
                return;
            }
            try {
                this.factory.passivateObject(k, pooledObject);
            }
            catch (Exception exception) {
                this.swallowException(exception);
                try {
                    this.destroy(k, pooledObject, true, DestroyMode.NORMAL);
                }
                catch (Exception exception2) {
                    this.swallowException(exception2);
                }
                this.whenWaitersAddObject(k, ((ObjectDeque)objectDeque).idleObjects);
                if (this.hasBorrowWaiters()) {
                    this.reuseCapacity();
                }
                this.updateStatsReturn(duration);
                return;
            }
            if (!pooledObject.deallocate()) {
                throw new IllegalStateException("Object has already been returned to this pool");
            }
            int n = this.getMaxIdlePerKey();
            LinkedBlockingDeque<PooledObject<T>> linkedBlockingDeque = objectDeque.getIdleObjects();
            if (this.isClosed() || n > -1 && n <= linkedBlockingDeque.size()) {
                try {
                    this.destroy(k, pooledObject, true, DestroyMode.NORMAL);
                }
                catch (Exception exception) {
                    this.swallowException(exception);
                }
            } else {
                if (this.getLifo()) {
                    linkedBlockingDeque.addFirst(pooledObject);
                } else {
                    linkedBlockingDeque.addLast(pooledObject);
                }
                if (this.isClosed()) {
                    this.clear(k);
                }
            }
        }
        finally {
            if (this.hasBorrowWaiters()) {
                this.reuseCapacity();
            }
            this.updateStatsReturn(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reuseCapacity() {
        int n = this.getMaxTotalPerKey();
        int n2 = 0;
        LinkedBlockingDeque<PooledObject<T>> linkedBlockingDeque = null;
        K k = null;
        for (Map.Entry<K, ObjectDeque<T>> entry : this.poolMap.entrySet()) {
            K k2 = entry.getKey();
            ObjectDeque<T> objectDeque = entry.getValue();
            if (objectDeque == null) continue;
            LinkedBlockingDeque<PooledObject<T>> linkedBlockingDeque2 = objectDeque.getIdleObjects();
            int n3 = linkedBlockingDeque2.getTakeQueueLength();
            if (this.getNumActive(k2) >= n || n3 <= n2) continue;
            n2 = n3;
            linkedBlockingDeque = linkedBlockingDeque2;
            k = k2;
        }
        if (linkedBlockingDeque != null) {
            this.register(k);
            try {
                PooledObject<T> pooledObject = this.create(k);
                if (pooledObject != null) {
                    this.addIdleObject(k, pooledObject);
                }
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            finally {
                this.deregister(k);
            }
        }
    }

    @Override
    public void setConfig(GenericKeyedObjectPoolConfig<T> genericKeyedObjectPoolConfig) {
        super.setConfig(genericKeyedObjectPoolConfig);
        this.setMaxIdlePerKey(genericKeyedObjectPoolConfig.getMaxIdlePerKey());
        this.setMaxTotalPerKey(genericKeyedObjectPoolConfig.getMaxTotalPerKey());
        this.setMaxTotal(genericKeyedObjectPoolConfig.getMaxTotal());
        this.setMinIdlePerKey(genericKeyedObjectPoolConfig.getMinIdlePerKey());
    }

    public void setMaxIdlePerKey(int n) {
        this.maxIdlePerKey = n;
    }

    public void setMaxTotalPerKey(int n) {
        this.maxTotalPerKey = n;
    }

    public void setMinIdlePerKey(int n) {
        this.minIdlePerKey = n;
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        super.toStringAppendFields(stringBuilder);
        stringBuilder.append(", maxIdlePerKey=");
        stringBuilder.append(this.maxIdlePerKey);
        stringBuilder.append(", minIdlePerKey=");
        stringBuilder.append(this.minIdlePerKey);
        stringBuilder.append(", maxTotalPerKey=");
        stringBuilder.append(this.maxTotalPerKey);
        stringBuilder.append(", factory=");
        stringBuilder.append(this.factory);
        stringBuilder.append(", fairness=");
        stringBuilder.append(this.fairness);
        stringBuilder.append(", poolMap=");
        stringBuilder.append(this.poolMap);
        stringBuilder.append(", poolKeyList=");
        stringBuilder.append(this.poolKeyList);
        stringBuilder.append(", keyLock=");
        stringBuilder.append(this.keyLock);
        stringBuilder.append(", numTotal=");
        stringBuilder.append(this.numTotal);
        stringBuilder.append(", evictionKeyIterator=");
        stringBuilder.append(this.evictionKeyIterator);
        stringBuilder.append(", evictionKey=");
        stringBuilder.append(this.evictionKey);
        stringBuilder.append(", abandonedConfig=");
        stringBuilder.append(this.abandonedConfig);
    }

    @Override
    public void use(T t) {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getUseUsageTracking()) {
            this.poolMap.values().stream().map(objectDeque -> objectDeque.getAllObjects().get(new BaseGenericObjectPool.IdentityWrapper<Object>(t))).filter(Objects::nonNull).findFirst().ifPresent(PooledObject::use);
        }
    }

    private void whenWaitersAddObject(K k, LinkedBlockingDeque<PooledObject<T>> linkedBlockingDeque) {
        if (linkedBlockingDeque.hasTakeWaiters()) {
            try {
                this.addObject(k);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
        }
    }

    private class ObjectDeque<S> {
        private final LinkedBlockingDeque<PooledObject<S>> idleObjects;
        private final AtomicInteger createCount = new AtomicInteger(0);
        private long makeObjectCount;
        private final Object makeObjectCountLock = new Object();
        private final Map<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>> allObjects = new ConcurrentHashMap<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>>();
        private final AtomicLong numInterested = new AtomicLong();

        public ObjectDeque(boolean bl) {
            this.idleObjects = new LinkedBlockingDeque(bl);
        }

        public Map<BaseGenericObjectPool.IdentityWrapper<S>, PooledObject<S>> getAllObjects() {
            return this.allObjects;
        }

        public AtomicInteger getCreateCount() {
            return this.createCount;
        }

        public LinkedBlockingDeque<PooledObject<S>> getIdleObjects() {
            return this.idleObjects;
        }

        public AtomicLong getNumInterested() {
            return this.numInterested;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ObjectDeque [idleObjects=");
            stringBuilder.append(this.idleObjects);
            stringBuilder.append(", createCount=");
            stringBuilder.append(this.createCount);
            stringBuilder.append(", allObjects=");
            stringBuilder.append(this.allObjects);
            stringBuilder.append(", numInterested=");
            stringBuilder.append(this.numInterested);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

