/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.model.ModeModel;
import org.netbeans.core.windows.model.TopComponentContextSubModel;
import org.netbeans.core.windows.model.TopComponentSubModel;
import org.netbeans.core.windows.options.TabsPanel;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.TopComponent;

final class DefaultModeModel
implements ModeModel {
    private String name;
    private final Set<String> otherNames = new HashSet<String>(3);
    private final Rectangle bounds = new Rectangle();
    private final Rectangle boundsSeparetedHelp = new Rectangle();
    private int state;
    private final int kind;
    private int frameState;
    private boolean permanent;
    private boolean minimized;
    private final TopComponentSubModel topComponentSubModel;
    private TopComponentContextSubModel topComponentContextSubModel = null;
    private final Object LOCK_STATE = new Object();
    private final Object LOCK_BOUNDS = new Object();
    private final Object LOCK_BOUNDS_SEPARATED_HELP = new Object();
    private final Object LOCK_FRAMESTATE = new Object();
    private final Object LOCK_TOPCOMPONENTS = new Object();
    private final Object LOCK_TC_CONTEXTS = new Object();

    public DefaultModeModel(String string, int n, int n2, boolean bl) {
        this.name = string;
        this.state = n;
        this.kind = n2;
        this.permanent = bl;
        this.topComponentSubModel = new TopComponentSubModel(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(int n) {
        Object object = this.LOCK_STATE;
        synchronized (object) {
            this.state = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTopComponent(TopComponent topComponent, TopComponent topComponent2) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.removeTopComponent(topComponent, topComponent2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClosedTopComponentID(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.removeClosedTopComponentID(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOpenedTopComponent(TopComponent topComponent) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.addOpenedTopComponent(topComponent);
            this.sortOpenedTopComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertOpenedTopComponent(TopComponent topComponent, int n) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.insertOpenedTopComponent(topComponent, n);
            this.sortOpenedTopComponents();
        }
    }

    private void sortOpenedTopComponents() {
        if (this.getKind() == 1) {
            this.sortByFile(this.getEditorSortType());
        } else if (this.getKind() == 2 && Switches.isModeSlidingEnabled()) {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
            List<TopComponent> list = this.topComponentSubModel.getOpenedTopComponents();
            final ArrayList<String> arrayList = new ArrayList<String>(list.size());
            final HashMap<TopComponent, String> hashMap = new HashMap<TopComponent, String>(list.size());
            for (TopComponent topComponent : list) {
                ModeImpl modeImpl;
                String string = windowManagerImpl.findTopComponentID(topComponent);
                if (null == string || null == (modeImpl = this.getTopComponentPreviousMode(string))) continue;
                if (!arrayList.contains(modeImpl.getName())) {
                    arrayList.add(modeImpl.getName());
                }
                hashMap.put(topComponent, modeImpl.getName());
            }
            if (arrayList.isEmpty()) {
                return;
            }
            Collections.sort(list, new Comparator<TopComponent>(){

                @Override
                public int compare(TopComponent topComponent, TopComponent topComponent2) {
                    String string = (String)hashMap.get(topComponent);
                    String string2 = (String)hashMap.get(topComponent2);
                    if (null == string && null != string2) {
                        return 1;
                    }
                    if (null != string && null == string2) {
                        return -1;
                    }
                    return arrayList.indexOf(string) - arrayList.indexOf(string2);
                }
            });
            this.topComponentSubModel.setOpenedTopComponents(list);
        }
    }

    private TabsPanel.EditorSortType getEditorSortType() {
        TabsPanel.EditorSortType editorSortType = TabsPanel.EditorSortType.None;
        try {
            editorSortType = TabsPanel.EditorSortType.valueOf(WinSysPrefs.HANDLER.get("editor.sort.tabs", TabsPanel.EditorSortType.None.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return editorSortType;
    }

    private void sortByFile(final TabsPanel.EditorSortType editorSortType) {
        if (editorSortType == TabsPanel.EditorSortType.None) {
            return;
        }
        List<TopComponent> list = this.topComponentSubModel.getOpenedTopComponents();
        Collections.sort(list, new Comparator<TopComponent>(){

            @Override
            public int compare(TopComponent topComponent, TopComponent topComponent2) {
                FileObject fileObject = (FileObject)topComponent.getLookup().lookup(FileObject.class);
                FileObject fileObject2 = (FileObject)topComponent2.getLookup().lookup(FileObject.class);
                if (fileObject == null && fileObject2 == null) {
                    return 0;
                }
                if (fileObject != null && fileObject2 == null) {
                    return 1;
                }
                if (fileObject == null && fileObject2 != null) {
                    return -1;
                }
                switch (editorSortType) {
                    case FullFilePath: {
                        return DefaultModeModel.this.compareFullFilePath(fileObject, fileObject2);
                    }
                    case FileName: {
                        return DefaultModeModel.this.compareFileName(fileObject, fileObject2);
                    }
                    case FileNameWithParent: {
                        return DefaultModeModel.this.compareFileNameWithParent(fileObject, fileObject2);
                    }
                }
                throw new AssertionError();
            }
        });
        this.topComponentSubModel.setOpenedTopComponents(list);
    }

    private int compareFullFilePath(FileObject fileObject, FileObject fileObject2) {
        return FileUtil.toFile((FileObject)fileObject).compareTo(FileUtil.toFile((FileObject)fileObject2));
    }

    private int compareFileName(FileObject fileObject, FileObject fileObject2) {
        return fileObject.getName().compareToIgnoreCase(fileObject2.getName());
    }

    private int compareFileNameWithParent(FileObject fileObject, FileObject fileObject2) {
        FileObject fileObject3 = fileObject.getParent();
        FileObject fileObject4 = fileObject2.getParent();
        if (fileObject3 == null && fileObject4 == null) {
            return 0;
        }
        if (fileObject3 != null && fileObject4 == null) {
            return 1;
        }
        if (fileObject3 == null && fileObject4 != null) {
            return -1;
        }
        if (fileObject3.getName().equals(fileObject4.getName())) {
            return fileObject.getName().compareToIgnoreCase(fileObject2.getName());
        }
        return fileObject3.getName().compareToIgnoreCase(fileObject4.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClosedTopComponent(TopComponent topComponent) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.addClosedTopComponent(topComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnloadedTopComponent(String string, int n) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.addUnloadedTopComponent(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnloadedSelectedTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.setUnloadedSelectedTopComponent(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnloadedPreviousSelectedTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.setUnloadedPreviousSelectedTopComponent(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedTopComponent(TopComponent topComponent) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.setSelectedTopComponent(topComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreviousSelectedTopComponentID(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            this.topComponentSubModel.setPreviousSelectedTopComponentID(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrameState(int n) {
        Object object = this.LOCK_FRAMESTATE;
        synchronized (object) {
            this.frameState = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        Object object = this.LOCK_BOUNDS;
        synchronized (object) {
            this.bounds.setBounds(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoundsSeparatedHelp(Rectangle rectangle) {
        if (this.bounds == null) {
            return;
        }
        Object object = this.LOCK_BOUNDS_SEPARATED_HELP;
        synchronized (object) {
            this.boundsSeparetedHelp.setBounds(rectangle);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle getBounds() {
        Object object = this.LOCK_BOUNDS;
        synchronized (object) {
            return (Rectangle)this.bounds.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle getBoundsSeparatedHelp() {
        Object object = this.LOCK_BOUNDS_SEPARATED_HELP;
        synchronized (object) {
            return (Rectangle)this.boundsSeparetedHelp.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.LOCK_STATE;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameState() {
        Object object = this.LOCK_FRAMESTATE;
        synchronized (object) {
            return this.frameState;
        }
    }

    @Override
    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public void makePermanent() {
        this.permanent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsTopComponent(TopComponent topComponent) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.containsTopComponent(topComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TopComponent> getTopComponents() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getTopComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopComponent getSelectedTopComponent() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getSelectedTopComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPreviousSelectedTopComponentID() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getPreviousSelectedTopComponentID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TopComponent> getOpenedTopComponents() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getOpenedTopComponents();
        }
    }

    @Override
    public final void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getOpenedTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getOpenedTopComponentsIDs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getClosedTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getClosedTopComponentsIDs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getTopComponentsIDs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenedTopComponentTabPosition(TopComponent topComponent) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponentSubModel.getOpenedTopComponentTabPosition(topComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SplitConstraint[] getTopComponentPreviousConstraints(String string) {
        Object object = this.LOCK_TC_CONTEXTS;
        synchronized (object) {
            return this.getContextSubModel().getTopComponentPreviousConstraints(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModeImpl getTopComponentPreviousMode(String string) {
        Object object = this.LOCK_TC_CONTEXTS;
        synchronized (object) {
            return this.getContextSubModel().getTopComponentPreviousMode(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTopComponentPreviousIndex(String string) {
        Object object = this.LOCK_TC_CONTEXTS;
        synchronized (object) {
            return this.getContextSubModel().getTopComponentPreviousIndex(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTopComponentPreviousConstraints(String string, SplitConstraint[] splitConstraintArray) {
        Object object = this.LOCK_TC_CONTEXTS;
        synchronized (object) {
            this.getContextSubModel().setTopComponentPreviousConstraints(string, splitConstraintArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTopComponentPreviousMode(String string, ModeImpl modeImpl, int n) {
        Object object = this.LOCK_TC_CONTEXTS;
        synchronized (object) {
            this.getContextSubModel().setTopComponentPreviousMode(string, modeImpl, n);
            this.sortOpenedTopComponents();
        }
    }

    private TopComponentContextSubModel getContextSubModel() {
        if (this.topComponentContextSubModel == null) {
            this.topComponentContextSubModel = new TopComponentContextSubModel();
        }
        return this.topComponentContextSubModel;
    }

    @Override
    public boolean isMinimized() {
        return this.minimized;
    }

    @Override
    public void setMinimized(boolean bl) {
        this.minimized = bl;
    }

    @Override
    public Collection<String> getOtherNames() {
        return Collections.unmodifiableSet(this.otherNames);
    }

    @Override
    public void addOtherName(String string) {
        this.otherNames.add(string);
    }
}

