/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "MessageNames.h"

namespace IPC {

const char* description(MessageName name)
{
    switch (name) {
    case MessageName::AuthenticationManager_CompleteAuthenticationChallenge:
        return "AuthenticationManager_CompleteAuthenticationChallenge";
    case MessageName::AuxiliaryProcess_DidReceiveMemoryPressureEvent:
        return "AuxiliaryProcess_DidReceiveMemoryPressureEvent";
    case MessageName::AuxiliaryProcess_MainThreadPing:
        return "AuxiliaryProcess_MainThreadPing";
    case MessageName::AuxiliaryProcess_SetProcessSuppressionEnabled:
        return "AuxiliaryProcess_SetProcessSuppressionEnabled";
    case MessageName::AuxiliaryProcess_ShutDown:
        return "AuxiliaryProcess_ShutDown";
    case MessageName::CacheStorageEngineConnection_Caches:
        return "CacheStorageEngineConnection_Caches";
    case MessageName::CacheStorageEngineConnection_ClearMemoryRepresentation:
        return "CacheStorageEngineConnection_ClearMemoryRepresentation";
    case MessageName::CacheStorageEngineConnection_DeleteMatchingRecords:
        return "CacheStorageEngineConnection_DeleteMatchingRecords";
    case MessageName::CacheStorageEngineConnection_Dereference:
        return "CacheStorageEngineConnection_Dereference";
    case MessageName::CacheStorageEngineConnection_EngineRepresentation:
        return "CacheStorageEngineConnection_EngineRepresentation";
    case MessageName::CacheStorageEngineConnection_Open:
        return "CacheStorageEngineConnection_Open";
    case MessageName::CacheStorageEngineConnection_PutRecords:
        return "CacheStorageEngineConnection_PutRecords";
    case MessageName::CacheStorageEngineConnection_Reference:
        return "CacheStorageEngineConnection_Reference";
    case MessageName::CacheStorageEngineConnection_Remove:
        return "CacheStorageEngineConnection_Remove";
    case MessageName::CacheStorageEngineConnection_RetrieveRecords:
        return "CacheStorageEngineConnection_RetrieveRecords";
    case MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename:
        return "DownloadProxy_DecideDestinationWithSuggestedFilename";
    case MessageName::DownloadProxy_DidCreateDestination:
        return "DownloadProxy_DidCreateDestination";
    case MessageName::DownloadProxy_DidFail:
        return "DownloadProxy_DidFail";
    case MessageName::DownloadProxy_DidFinish:
        return "DownloadProxy_DidFinish";
    case MessageName::DownloadProxy_DidReceiveAuthenticationChallenge:
        return "DownloadProxy_DidReceiveAuthenticationChallenge";
    case MessageName::DownloadProxy_DidReceiveData:
        return "DownloadProxy_DidReceiveData";
    case MessageName::DownloadProxy_DidStart:
        return "DownloadProxy_DidStart";
    case MessageName::DownloadProxy_WillSendRequest:
        return "DownloadProxy_WillSendRequest";
    case MessageName::DrawingAreaProxy_DidFirstLayerFlush:
        return "DrawingAreaProxy_DidFirstLayerFlush";
    case MessageName::DrawingAreaProxy_DidUpdateBackingStoreState:
        return "DrawingAreaProxy_DidUpdateBackingStoreState";
    case MessageName::DrawingAreaProxy_DidUpdateGeometry:
        return "DrawingAreaProxy_DidUpdateGeometry";
    case MessageName::DrawingAreaProxy_DispatchPresentationCallbacksAfterFlushingLayers:
        return "DrawingAreaProxy_DispatchPresentationCallbacksAfterFlushingLayers";
    case MessageName::DrawingAreaProxy_EnterAcceleratedCompositingMode:
        return "DrawingAreaProxy_EnterAcceleratedCompositingMode";
    case MessageName::DrawingAreaProxy_ExitAcceleratedCompositingMode:
        return "DrawingAreaProxy_ExitAcceleratedCompositingMode";
    case MessageName::DrawingAreaProxy_Update:
        return "DrawingAreaProxy_Update";
    case MessageName::DrawingAreaProxy_UpdateAcceleratedCompositingMode:
        return "DrawingAreaProxy_UpdateAcceleratedCompositingMode";
    case MessageName::DrawingArea_AcceleratedAnimationDidEnd:
        return "DrawingArea_AcceleratedAnimationDidEnd";
    case MessageName::DrawingArea_AcceleratedAnimationDidStart:
        return "DrawingArea_AcceleratedAnimationDidStart";
    case MessageName::DrawingArea_AddTransactionCallbackID:
        return "DrawingArea_AddTransactionCallbackID";
    case MessageName::DrawingArea_AdjustTransientZoom:
        return "DrawingArea_AdjustTransientZoom";
    case MessageName::DrawingArea_CommitTransientZoom:
        return "DrawingArea_CommitTransientZoom";
    case MessageName::DrawingArea_DidUpdate:
        return "DrawingArea_DidUpdate";
    case MessageName::DrawingArea_SetColorSpace:
        return "DrawingArea_SetColorSpace";
    case MessageName::DrawingArea_SetDeviceScaleFactor:
        return "DrawingArea_SetDeviceScaleFactor";
    case MessageName::DrawingArea_SetViewExposedRect:
        return "DrawingArea_SetViewExposedRect";
    case MessageName::DrawingArea_UpdateBackingStoreState:
        return "DrawingArea_UpdateBackingStoreState";
    case MessageName::DrawingArea_UpdateGeometry:
        return "DrawingArea_UpdateGeometry";
    case MessageName::EventDispatcher_DisplayWasRefreshed:
        return "EventDispatcher_DisplayWasRefreshed";
    case MessageName::EventDispatcher_GestureEvent:
        return "EventDispatcher_GestureEvent";
    case MessageName::EventDispatcher_PageScreenDidChange:
        return "EventDispatcher_PageScreenDidChange";
    case MessageName::EventDispatcher_SetScrollingAccelerationCurve:
        return "EventDispatcher_SetScrollingAccelerationCurve";
    case MessageName::EventDispatcher_TouchEvent:
        return "EventDispatcher_TouchEvent";
    case MessageName::EventDispatcher_TouchEventWithoutCallback:
        return "EventDispatcher_TouchEventWithoutCallback";
    case MessageName::EventDispatcher_WheelEvent:
        return "EventDispatcher_WheelEvent";
    case MessageName::GPUConnectionToWebProcess_ClearNowPlayingInfo:
        return "GPUConnectionToWebProcess_ClearNowPlayingInfo";
    case MessageName::GPUConnectionToWebProcess_ConfigureLoggingChannel:
        return "GPUConnectionToWebProcess_ConfigureLoggingChannel";
    case MessageName::GPUConnectionToWebProcess_CreateAudioHardwareListener:
        return "GPUConnectionToWebProcess_CreateAudioHardwareListener";
    case MessageName::GPUConnectionToWebProcess_CreateGraphicsContextGL:
        return "GPUConnectionToWebProcess_CreateGraphicsContextGL";
    case MessageName::GPUConnectionToWebProcess_CreateRemoteCommandListener:
        return "GPUConnectionToWebProcess_CreateRemoteCommandListener";
    case MessageName::GPUConnectionToWebProcess_CreateRemoteGPU:
        return "GPUConnectionToWebProcess_CreateRemoteGPU";
    case MessageName::GPUConnectionToWebProcess_CreateRenderingBackend:
        return "GPUConnectionToWebProcess_CreateRenderingBackend";
    case MessageName::GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage:
        return "GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage";
    case MessageName::GPUConnectionToWebProcess_CreateWCLayerTreeHost:
        return "GPUConnectionToWebProcess_CreateWCLayerTreeHost";
    case MessageName::GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage:
        return "GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage";
    case MessageName::GPUConnectionToWebProcess_EnableVP9Decoders:
        return "GPUConnectionToWebProcess_EnableVP9Decoders";
    case MessageName::GPUConnectionToWebProcess_EnsureMediaSessionHelper:
        return "GPUConnectionToWebProcess_EnsureMediaSessionHelper";
    case MessageName::GPUConnectionToWebProcess_ReleaseAudioHardwareListener:
        return "GPUConnectionToWebProcess_ReleaseAudioHardwareListener";
    case MessageName::GPUConnectionToWebProcess_ReleaseGraphicsContextGL:
        return "GPUConnectionToWebProcess_ReleaseGraphicsContextGL";
    case MessageName::GPUConnectionToWebProcess_ReleaseRemoteCommandListener:
        return "GPUConnectionToWebProcess_ReleaseRemoteCommandListener";
    case MessageName::GPUConnectionToWebProcess_ReleaseRenderingBackend:
        return "GPUConnectionToWebProcess_ReleaseRenderingBackend";
    case MessageName::GPUConnectionToWebProcess_ReleaseWCLayerTreeHost:
        return "GPUConnectionToWebProcess_ReleaseWCLayerTreeHost";
    case MessageName::GPUConnectionToWebProcess_SetMediaOverridesForTesting:
        return "GPUConnectionToWebProcess_SetMediaOverridesForTesting";
    case MessageName::GPUConnectionToWebProcess_SetNowPlayingInfo:
        return "GPUConnectionToWebProcess_SetNowPlayingInfo";
    case MessageName::GPUConnectionToWebProcess_SetUserPreferredLanguages:
        return "GPUConnectionToWebProcess_SetUserPreferredLanguages";
    case MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory:
        return "GPUProcessConnection_BeginRoutingArbitrationWithCategory";
    case MessageName::GPUProcessConnection_DidReceiveRemoteCommand:
        return "GPUProcessConnection_DidReceiveRemoteCommand";
    case MessageName::GPUProcessConnection_EndRoutingArbitration:
        return "GPUProcessConnection_EndRoutingArbitration";
    case MessageName::GPUProcessConnection_ResetAudioMediaStreamTrackRendererInternalUnit:
        return "GPUProcessConnection_ResetAudioMediaStreamTrackRendererInternalUnit";
    case MessageName::GPUProcessProxy_DidCreateContextForVisibilityPropagation:
        return "GPUProcessProxy_DidCreateContextForVisibilityPropagation";
    case MessageName::GPUProcessProxy_ProcessIsReadyToExit:
        return "GPUProcessProxy_ProcessIsReadyToExit";
    case MessageName::GPUProcessProxy_TerminateWebProcess:
        return "GPUProcessProxy_TerminateWebProcess";
    case MessageName::GPUProcess_AddMockMediaDevice:
        return "GPUProcess_AddMockMediaDevice";
    case MessageName::GPUProcess_AddSession:
        return "GPUProcess_AddSession";
    case MessageName::GPUProcess_ClearMockMediaDevices:
        return "GPUProcess_ClearMockMediaDevices";
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcess:
        return "GPUProcess_CreateGPUConnectionToWebProcess";
    case MessageName::GPUProcess_DisplayConfigurationChanged:
        return "GPUProcess_DisplayConfigurationChanged";
    case MessageName::GPUProcess_InitializeGPUProcess:
        return "GPUProcess_InitializeGPUProcess";
    case MessageName::GPUProcess_NotifyPreferencesChanged:
        return "GPUProcess_NotifyPreferencesChanged";
    case MessageName::GPUProcess_PrepareToSuspend:
        return "GPUProcess_PrepareToSuspend";
    case MessageName::GPUProcess_ProcessDidResume:
        return "GPUProcess_ProcessDidResume";
    case MessageName::GPUProcess_RemoveMockMediaDevice:
        return "GPUProcess_RemoveMockMediaDevice";
    case MessageName::GPUProcess_RemoveSession:
        return "GPUProcess_RemoveSession";
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTime:
        return "GPUProcess_RequestBitmapImageForCurrentTime";
    case MessageName::GPUProcess_ResetMockMediaDevices:
        return "GPUProcess_ResetMockMediaDevices";
    case MessageName::GPUProcess_SetMediaSourceInlinePaintingEnabled:
        return "GPUProcess_SetMediaSourceInlinePaintingEnabled";
    case MessageName::GPUProcess_SetMockCameraIsInterrupted:
        return "GPUProcess_SetMockCameraIsInterrupted";
    case MessageName::GPUProcess_SetMockCaptureDevicesEnabled:
        return "GPUProcess_SetMockCaptureDevicesEnabled";
    case MessageName::GPUProcess_SetOpusDecoderEnabled:
        return "GPUProcess_SetOpusDecoderEnabled";
    case MessageName::GPUProcess_SetOrientationForMediaCapture:
        return "GPUProcess_SetOrientationForMediaCapture";
    case MessageName::GPUProcess_SetScreenProperties:
        return "GPUProcess_SetScreenProperties";
    case MessageName::GPUProcess_SetUseScreenCaptureKit:
        return "GPUProcess_SetUseScreenCaptureKit";
    case MessageName::GPUProcess_SetVorbisDecoderEnabled:
        return "GPUProcess_SetVorbisDecoderEnabled";
    case MessageName::GPUProcess_SetWebMFormatReaderEnabled:
        return "GPUProcess_SetWebMFormatReaderEnabled";
    case MessageName::GPUProcess_SetWebMParserEnabled:
        return "GPUProcess_SetWebMParserEnabled";
    case MessageName::GPUProcess_ShowScreenPicker:
        return "GPUProcess_ShowScreenPicker";
    case MessageName::GPUProcess_ShowWindowPicker:
        return "GPUProcess_ShowWindowPicker";
    case MessageName::GPUProcess_UpdateCaptureAccess:
        return "GPUProcess_UpdateCaptureAccess";
    case MessageName::GPUProcess_UpdateCaptureOrigin:
        return "GPUProcess_UpdateCaptureOrigin";
    case MessageName::GPUProcess_UpdateSandboxAccess:
        return "GPUProcess_UpdateSandboxAccess";
    case MessageName::GPUProcess_WebProcessConnectionCountForTesting:
        return "GPUProcess_WebProcessConnectionCountForTesting";
    case MessageName::GtkSettingsManagerProxy_SettingsDidChange:
        return "GtkSettingsManagerProxy_SettingsDidChange";
    case MessageName::IPCTester_StartMessageTesting:
        return "IPCTester_StartMessageTesting";
    case MessageName::LibWebRTCCodecsProxy_CreateEncoder:
        return "LibWebRTCCodecsProxy_CreateEncoder";
    case MessageName::LibWebRTCCodecsProxy_CreateH264Decoder:
        return "LibWebRTCCodecsProxy_CreateH264Decoder";
    case MessageName::LibWebRTCCodecsProxy_CreateH265Decoder:
        return "LibWebRTCCodecsProxy_CreateH265Decoder";
    case MessageName::LibWebRTCCodecsProxy_CreateVP9Decoder:
        return "LibWebRTCCodecsProxy_CreateVP9Decoder";
    case MessageName::LibWebRTCCodecsProxy_DecodeFrame:
        return "LibWebRTCCodecsProxy_DecodeFrame";
    case MessageName::LibWebRTCCodecsProxy_EncodeFrame:
        return "LibWebRTCCodecsProxy_EncodeFrame";
    case MessageName::LibWebRTCCodecsProxy_InitializeEncoder:
        return "LibWebRTCCodecsProxy_InitializeEncoder";
    case MessageName::LibWebRTCCodecsProxy_ReleaseDecoder:
        return "LibWebRTCCodecsProxy_ReleaseDecoder";
    case MessageName::LibWebRTCCodecsProxy_ReleaseEncoder:
        return "LibWebRTCCodecsProxy_ReleaseEncoder";
    case MessageName::LibWebRTCCodecsProxy_SetEncodeRates:
        return "LibWebRTCCodecsProxy_SetEncodeRates";
    case MessageName::LibWebRTCCodecsProxy_SetFrameSize:
        return "LibWebRTCCodecsProxy_SetFrameSize";
    case MessageName::LibWebRTCCodecsProxy_SetRTCLoggingLevel:
        return "LibWebRTCCodecsProxy_SetRTCLoggingLevel";
    case MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameMemory:
        return "LibWebRTCCodecsProxy_SetSharedVideoFrameMemory";
    case MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameSemaphore:
        return "LibWebRTCCodecsProxy_SetSharedVideoFrameSemaphore";
    case MessageName::LibWebRTCCodecs_CompletedDecoding:
        return "LibWebRTCCodecs_CompletedDecoding";
    case MessageName::LibWebRTCCodecs_CompletedEncoding:
        return "LibWebRTCCodecs_CompletedEncoding";
    case MessageName::LibWebRTCCodecs_FailedDecoding:
        return "LibWebRTCCodecs_FailedDecoding";
    case MessageName::LibWebRTCNetwork_SignalAddressReady:
        return "LibWebRTCNetwork_SignalAddressReady";
    case MessageName::LibWebRTCNetwork_SignalClose:
        return "LibWebRTCNetwork_SignalClose";
    case MessageName::LibWebRTCNetwork_SignalConnect:
        return "LibWebRTCNetwork_SignalConnect";
    case MessageName::LibWebRTCNetwork_SignalNewConnection:
        return "LibWebRTCNetwork_SignalNewConnection";
    case MessageName::LibWebRTCNetwork_SignalReadPacket:
        return "LibWebRTCNetwork_SignalReadPacket";
    case MessageName::LibWebRTCNetwork_SignalSentPacket:
        return "LibWebRTCNetwork_SignalSentPacket";
    case MessageName::MediaPlayerPrivateRemote_ActiveSourceBuffersChanged:
        return "MediaPlayerPrivateRemote_ActiveSourceBuffersChanged";
    case MessageName::MediaPlayerPrivateRemote_AddDataCue:
        return "MediaPlayerPrivateRemote_AddDataCue";
    case MessageName::MediaPlayerPrivateRemote_AddDataCueWithType:
        return "MediaPlayerPrivateRemote_AddDataCueWithType";
    case MessageName::MediaPlayerPrivateRemote_AddGenericCue:
        return "MediaPlayerPrivateRemote_AddGenericCue";
    case MessageName::MediaPlayerPrivateRemote_AddRemoteAudioTrack:
        return "MediaPlayerPrivateRemote_AddRemoteAudioTrack";
    case MessageName::MediaPlayerPrivateRemote_AddRemoteTextTrack:
        return "MediaPlayerPrivateRemote_AddRemoteTextTrack";
    case MessageName::MediaPlayerPrivateRemote_AddRemoteVideoTrack:
        return "MediaPlayerPrivateRemote_AddRemoteVideoTrack";
    case MessageName::MediaPlayerPrivateRemote_CharacteristicChanged:
        return "MediaPlayerPrivateRemote_CharacteristicChanged";
    case MessageName::MediaPlayerPrivateRemote_CurrentPlaybackTargetIsWirelessChanged:
        return "MediaPlayerPrivateRemote_CurrentPlaybackTargetIsWirelessChanged";
    case MessageName::MediaPlayerPrivateRemote_CurrentTimeChanged:
        return "MediaPlayerPrivateRemote_CurrentTimeChanged";
    case MessageName::MediaPlayerPrivateRemote_DurationChanged:
        return "MediaPlayerPrivateRemote_DurationChanged";
    case MessageName::MediaPlayerPrivateRemote_EngineFailedToLoad:
        return "MediaPlayerPrivateRemote_EngineFailedToLoad";
    case MessageName::MediaPlayerPrivateRemote_FirstVideoFrameAvailable:
        return "MediaPlayerPrivateRemote_FirstVideoFrameAvailable";
    case MessageName::MediaPlayerPrivateRemote_GetRawCookies:
        return "MediaPlayerPrivateRemote_GetRawCookies";
    case MessageName::MediaPlayerPrivateRemote_InitializationDataEncountered:
        return "MediaPlayerPrivateRemote_InitializationDataEncountered";
    case MessageName::MediaPlayerPrivateRemote_MediaPlayerKeyNeeded:
        return "MediaPlayerPrivateRemote_MediaPlayerKeyNeeded";
    case MessageName::MediaPlayerPrivateRemote_MuteChanged:
        return "MediaPlayerPrivateRemote_MuteChanged";
    case MessageName::MediaPlayerPrivateRemote_NetworkStateChanged:
        return "MediaPlayerPrivateRemote_NetworkStateChanged";
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueData:
        return "MediaPlayerPrivateRemote_ParseWebVTTCueData";
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueDataStruct:
        return "MediaPlayerPrivateRemote_ParseWebVTTCueDataStruct";
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTFileHeader:
        return "MediaPlayerPrivateRemote_ParseWebVTTFileHeader";
    case MessageName::MediaPlayerPrivateRemote_PlaybackStateChanged:
        return "MediaPlayerPrivateRemote_PlaybackStateChanged";
    case MessageName::MediaPlayerPrivateRemote_PushVideoFrameMetadata:
        return "MediaPlayerPrivateRemote_PushVideoFrameMetadata";
    case MessageName::MediaPlayerPrivateRemote_RateChanged:
        return "MediaPlayerPrivateRemote_RateChanged";
    case MessageName::MediaPlayerPrivateRemote_ReadyStateChanged:
        return "MediaPlayerPrivateRemote_ReadyStateChanged";
    case MessageName::MediaPlayerPrivateRemote_RemoteAudioTrackConfigurationChanged:
        return "MediaPlayerPrivateRemote_RemoteAudioTrackConfigurationChanged";
    case MessageName::MediaPlayerPrivateRemote_RemoteTextTrackConfigurationChanged:
        return "MediaPlayerPrivateRemote_RemoteTextTrackConfigurationChanged";
    case MessageName::MediaPlayerPrivateRemote_RemoteVideoTrackConfigurationChanged:
        return "MediaPlayerPrivateRemote_RemoteVideoTrackConfigurationChanged";
    case MessageName::MediaPlayerPrivateRemote_RemoveDataCue:
        return "MediaPlayerPrivateRemote_RemoveDataCue";
    case MessageName::MediaPlayerPrivateRemote_RemoveGenericCue:
        return "MediaPlayerPrivateRemote_RemoveGenericCue";
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteAudioTrack:
        return "MediaPlayerPrivateRemote_RemoveRemoteAudioTrack";
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteTextTrack:
        return "MediaPlayerPrivateRemote_RemoveRemoteTextTrack";
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteVideoTrack:
        return "MediaPlayerPrivateRemote_RemoveRemoteVideoTrack";
    case MessageName::MediaPlayerPrivateRemote_RemoveResource:
        return "MediaPlayerPrivateRemote_RemoveResource";
    case MessageName::MediaPlayerPrivateRemote_RenderingModeChanged:
        return "MediaPlayerPrivateRemote_RenderingModeChanged";
    case MessageName::MediaPlayerPrivateRemote_RequestResource:
        return "MediaPlayerPrivateRemote_RequestResource";
    case MessageName::MediaPlayerPrivateRemote_ResourceNotSupported:
        return "MediaPlayerPrivateRemote_ResourceNotSupported";
    case MessageName::MediaPlayerPrivateRemote_SendH2Ping:
        return "MediaPlayerPrivateRemote_SendH2Ping";
    case MessageName::MediaPlayerPrivateRemote_SizeChanged:
        return "MediaPlayerPrivateRemote_SizeChanged";
    case MessageName::MediaPlayerPrivateRemote_TimeChanged:
        return "MediaPlayerPrivateRemote_TimeChanged";
    case MessageName::MediaPlayerPrivateRemote_UpdateCachedState:
        return "MediaPlayerPrivateRemote_UpdateCachedState";
    case MessageName::MediaPlayerPrivateRemote_UpdateDataCue:
        return "MediaPlayerPrivateRemote_UpdateDataCue";
    case MessageName::MediaPlayerPrivateRemote_UpdateGenericCue:
        return "MediaPlayerPrivateRemote_UpdateGenericCue";
    case MessageName::MediaPlayerPrivateRemote_VolumeChanged:
        return "MediaPlayerPrivateRemote_VolumeChanged";
    case MessageName::MediaPlayerPrivateRemote_WaitingForKeyChanged:
        return "MediaPlayerPrivateRemote_WaitingForKeyChanged";
    case MessageName::MediaSourcePrivateRemote_SeekToTime:
        return "MediaSourcePrivateRemote_SeekToTime";
    case MessageName::NetworkBroadcastChannelRegistry_PostMessage:
        return "NetworkBroadcastChannelRegistry_PostMessage";
    case MessageName::NetworkBroadcastChannelRegistry_RegisterChannel:
        return "NetworkBroadcastChannelRegistry_RegisterChannel";
    case MessageName::NetworkBroadcastChannelRegistry_UnregisterChannel:
        return "NetworkBroadcastChannelRegistry_UnregisterChannel";
    case MessageName::NetworkConnectionToWebProcess_AddOriginAccessAllowListEntry:
        return "NetworkConnectionToWebProcess_AddOriginAccessAllowListEntry";
    case MessageName::NetworkConnectionToWebProcess_BrowsingContextRemoved:
        return "NetworkConnectionToWebProcess_BrowsingContextRemoved";
    case MessageName::NetworkConnectionToWebProcess_CheckRemotePortForActivity:
        return "NetworkConnectionToWebProcess_CheckRemotePortForActivity";
    case MessageName::NetworkConnectionToWebProcess_ClearPageSpecificData:
        return "NetworkConnectionToWebProcess_ClearPageSpecificData";
    case MessageName::NetworkConnectionToWebProcess_CloseSWContextConnection:
        return "NetworkConnectionToWebProcess_CloseSWContextConnection";
    case MessageName::NetworkConnectionToWebProcess_CloseSharedWorkerContextConnection:
        return "NetworkConnectionToWebProcess_CloseSharedWorkerContextConnection";
    case MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource:
        return "NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource";
    case MessageName::NetworkConnectionToWebProcess_ConvertMainResourceLoadToDownload:
        return "NetworkConnectionToWebProcess_ConvertMainResourceLoadToDownload";
    case MessageName::NetworkConnectionToWebProcess_CreateNewMessagePortChannel:
        return "NetworkConnectionToWebProcess_CreateNewMessagePortChannel";
    case MessageName::NetworkConnectionToWebProcess_CreateRTCProvider:
        return "NetworkConnectionToWebProcess_CreateRTCProvider";
    case MessageName::NetworkConnectionToWebProcess_CreateSocketChannel:
        return "NetworkConnectionToWebProcess_CreateSocketChannel";
    case MessageName::NetworkConnectionToWebProcess_CreateSocketStream:
        return "NetworkConnectionToWebProcess_CreateSocketStream";
    case MessageName::NetworkConnectionToWebProcess_DeleteCookie:
        return "NetworkConnectionToWebProcess_DeleteCookie";
    case MessageName::NetworkConnectionToWebProcess_DidDeliverMessagePortMessages:
        return "NetworkConnectionToWebProcess_DidDeliverMessagePortMessages";
    case MessageName::NetworkConnectionToWebProcess_EntangleLocalPortInThisProcessToRemote:
        return "NetworkConnectionToWebProcess_EntangleLocalPortInThisProcessToRemote";
    case MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection:
        return "NetworkConnectionToWebProcess_EstablishSWContextConnection";
    case MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection:
        return "NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection";
    case MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName:
        return "NetworkConnectionToWebProcess_GetProcessDisplayName";
    case MessageName::NetworkConnectionToWebProcess_HasStorageAccess:
        return "NetworkConnectionToWebProcess_HasStorageAccess";
    case MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished:
        return "NetworkConnectionToWebProcess_IsResourceLoadFinished";
    case MessageName::NetworkConnectionToWebProcess_LoadPing:
        return "NetworkConnectionToWebProcess_LoadPing";
    case MessageName::NetworkConnectionToWebProcess_LogUserInteraction:
        return "NetworkConnectionToWebProcess_LogUserInteraction";
    case MessageName::NetworkConnectionToWebProcess_MessagePortClosed:
        return "NetworkConnectionToWebProcess_MessagePortClosed";
    case MessageName::NetworkConnectionToWebProcess_MessagePortDisentangled:
        return "NetworkConnectionToWebProcess_MessagePortDisentangled";
    case MessageName::NetworkConnectionToWebProcess_PageLoadCompleted:
        return "NetworkConnectionToWebProcess_PageLoadCompleted";
    case MessageName::NetworkConnectionToWebProcess_PostMessageToRemote:
        return "NetworkConnectionToWebProcess_PostMessageToRemote";
    case MessageName::NetworkConnectionToWebProcess_PreconnectTo:
        return "NetworkConnectionToWebProcess_PreconnectTo";
    case MessageName::NetworkConnectionToWebProcess_PrefetchDNS:
        return "NetworkConnectionToWebProcess_PrefetchDNS";
    case MessageName::NetworkConnectionToWebProcess_PrioritizeResourceLoads:
        return "NetworkConnectionToWebProcess_PrioritizeResourceLoads";
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURL:
        return "NetworkConnectionToWebProcess_RegisterBlobURL";
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLForSlice:
        return "NetworkConnectionToWebProcess_RegisterBlobURLForSlice";
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLFromURL:
        return "NetworkConnectionToWebProcess_RegisterBlobURLFromURL";
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLHandle:
        return "NetworkConnectionToWebProcess_RegisterBlobURLHandle";
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLOptionallyFileBacked:
        return "NetworkConnectionToWebProcess_RegisterBlobURLOptionallyFileBacked";
    case MessageName::NetworkConnectionToWebProcess_RegisterFileBlobURL:
        return "NetworkConnectionToWebProcess_RegisterFileBlobURL";
    case MessageName::NetworkConnectionToWebProcess_RegisterURLSchemesAsCORSEnabled:
        return "NetworkConnectionToWebProcess_RegisterURLSchemesAsCORSEnabled";
    case MessageName::NetworkConnectionToWebProcess_RemoveLoadIdentifier:
        return "NetworkConnectionToWebProcess_RemoveLoadIdentifier";
    case MessageName::NetworkConnectionToWebProcess_RemoveOriginAccessAllowListEntry:
        return "NetworkConnectionToWebProcess_RemoveOriginAccessAllowListEntry";
    case MessageName::NetworkConnectionToWebProcess_RemoveStorageAccessForFrame:
        return "NetworkConnectionToWebProcess_RemoveStorageAccessForFrame";
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccess:
        return "NetworkConnectionToWebProcess_RequestStorageAccess";
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccessUnderOpener:
        return "NetworkConnectionToWebProcess_RequestStorageAccessUnderOpener";
    case MessageName::NetworkConnectionToWebProcess_ResetOriginAccessAllowLists:
        return "NetworkConnectionToWebProcess_ResetOriginAccessAllowLists";
    case MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated:
        return "NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated";
    case MessageName::NetworkConnectionToWebProcess_ScheduleResourceLoad:
        return "NetworkConnectionToWebProcess_ScheduleResourceLoad";
    case MessageName::NetworkConnectionToWebProcess_SendH2Ping:
        return "NetworkConnectionToWebProcess_SendH2Ping";
    case MessageName::NetworkConnectionToWebProcess_SetCORSDisablingPatterns:
        return "NetworkConnectionToWebProcess_SetCORSDisablingPatterns";
    case MessageName::NetworkConnectionToWebProcess_SetCaptureExtraNetworkLoadMetricsEnabled:
        return "NetworkConnectionToWebProcess_SetCaptureExtraNetworkLoadMetricsEnabled";
    case MessageName::NetworkConnectionToWebProcess_SetCookiesFromDOM:
        return "NetworkConnectionToWebProcess_SetCookiesFromDOM";
    case MessageName::NetworkConnectionToWebProcess_SetRawCookie:
        return "NetworkConnectionToWebProcess_SetRawCookie";
    case MessageName::NetworkConnectionToWebProcess_SetResourceLoadSchedulingMode:
        return "NetworkConnectionToWebProcess_SetResourceLoadSchedulingMode";
    case MessageName::NetworkConnectionToWebProcess_StartDownload:
        return "NetworkConnectionToWebProcess_StartDownload";
    case MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort:
        return "NetworkConnectionToWebProcess_TakeAllMessagesForPort";
    case MessageName::NetworkConnectionToWebProcess_UnregisterBlobURL:
        return "NetworkConnectionToWebProcess_UnregisterBlobURL";
    case MessageName::NetworkConnectionToWebProcess_UnregisterBlobURLHandle:
        return "NetworkConnectionToWebProcess_UnregisterBlobURLHandle";
    case MessageName::NetworkConnectionToWebProcess_UnsubscribeFromCookieChangeNotifications:
        return "NetworkConnectionToWebProcess_UnsubscribeFromCookieChangeNotifications";
    case MessageName::NetworkConnectionToWebProcess_UpdateActivePages:
        return "NetworkConnectionToWebProcess_UpdateActivePages";
    case MessageName::NetworkConnectionToWebProcess_UpdateQuotaBasedOnSpaceUsageForTesting:
        return "NetworkConnectionToWebProcess_UpdateQuotaBasedOnSpaceUsageForTesting";
    case MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB:
        return "NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB";
    case MessageName::NetworkContentRuleListManager_AddContentRuleLists:
        return "NetworkContentRuleListManager_AddContentRuleLists";
    case MessageName::NetworkContentRuleListManager_Remove:
        return "NetworkContentRuleListManager_Remove";
    case MessageName::NetworkContentRuleListManager_RemoveAllContentRuleLists:
        return "NetworkContentRuleListManager_RemoveAllContentRuleLists";
    case MessageName::NetworkContentRuleListManager_RemoveContentRuleList:
        return "NetworkContentRuleListManager_RemoveContentRuleList";
    case MessageName::NetworkMDNSRegister_RegisterMDNSName:
        return "NetworkMDNSRegister_RegisterMDNSName";
    case MessageName::NetworkMDNSRegister_UnregisterMDNSNames:
        return "NetworkMDNSRegister_UnregisterMDNSNames";
    case MessageName::NetworkProcessConnection_AllCookiesDeleted:
        return "NetworkProcessConnection_AllCookiesDeleted";
    case MessageName::NetworkProcessConnection_BroadcastConsoleMessage:
        return "NetworkProcessConnection_BroadcastConsoleMessage";
    case MessageName::NetworkProcessConnection_CheckProcessLocalPortForActivity:
        return "NetworkProcessConnection_CheckProcessLocalPortForActivity";
    case MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource:
        return "NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource";
    case MessageName::NetworkProcessConnection_CookieAcceptPolicyChanged:
        return "NetworkProcessConnection_CookieAcceptPolicyChanged";
    case MessageName::NetworkProcessConnection_CookiesAdded:
        return "NetworkProcessConnection_CookiesAdded";
    case MessageName::NetworkProcessConnection_CookiesDeleted:
        return "NetworkProcessConnection_CookiesDeleted";
    case MessageName::NetworkProcessConnection_DidCacheResource:
        return "NetworkProcessConnection_DidCacheResource";
    case MessageName::NetworkProcessConnection_DidFinishPingLoad:
        return "NetworkProcessConnection_DidFinishPingLoad";
    case MessageName::NetworkProcessConnection_DidFinishPreconnection:
        return "NetworkProcessConnection_DidFinishPreconnection";
    case MessageName::NetworkProcessConnection_MessagesAvailableForPort:
        return "NetworkProcessConnection_MessagesAvailableForPort";
    case MessageName::NetworkProcessConnection_SetOnLineState:
        return "NetworkProcessConnection_SetOnLineState";
    case MessageName::NetworkProcessProxy_ContentExtensionRules:
        return "NetworkProcessProxy_ContentExtensionRules";
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains:
        return "NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains";
    case MessageName::NetworkProcessProxy_DidCommitCrossSiteLoadWithDataTransferFromPrevalentResource:
        return "NetworkProcessProxy_DidCommitCrossSiteLoadWithDataTransferFromPrevalentResource";
    case MessageName::NetworkProcessProxy_DidExceedMemoryLimit:
        return "NetworkProcessProxy_DidExceedMemoryLimit";
    case MessageName::NetworkProcessProxy_DidNegotiateModernTLS:
        return "NetworkProcessProxy_DidNegotiateModernTLS";
    case MessageName::NetworkProcessProxy_DidReceiveAuthenticationChallenge:
        return "NetworkProcessProxy_DidReceiveAuthenticationChallenge";
    case MessageName::NetworkProcessProxy_EndServiceWorkerBackgroundProcessing:
        return "NetworkProcessProxy_EndServiceWorkerBackgroundProcessing";
    case MessageName::NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcess:
        return "NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcess";
    case MessageName::NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcess:
        return "NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcess";
    case MessageName::NetworkProcessProxy_GetAppBoundDomains:
        return "NetworkProcessProxy_GetAppBoundDomains";
    case MessageName::NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentation:
        return "NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentation";
    case MessageName::NetworkProcessProxy_IncreaseQuota:
        return "NetworkProcessProxy_IncreaseQuota";
    case MessageName::NetworkProcessProxy_LogDiagnosticMessage:
        return "NetworkProcessProxy_LogDiagnosticMessage";
    case MessageName::NetworkProcessProxy_LogDiagnosticMessageWithResult:
        return "NetworkProcessProxy_LogDiagnosticMessageWithResult";
    case MessageName::NetworkProcessProxy_LogDiagnosticMessageWithValue:
        return "NetworkProcessProxy_LogDiagnosticMessageWithValue";
    case MessageName::NetworkProcessProxy_LogTestingEvent:
        return "NetworkProcessProxy_LogTestingEvent";
    case MessageName::NetworkProcessProxy_NegotiatedLegacyTLS:
        return "NetworkProcessProxy_NegotiatedLegacyTLS";
    case MessageName::NetworkProcessProxy_NotifyResourceLoadStatisticsProcessed:
        return "NetworkProcessProxy_NotifyResourceLoadStatisticsProcessed";
    case MessageName::NetworkProcessProxy_NotifyWebsiteDataDeletionForRegistrableDomainsFinished:
        return "NetworkProcessProxy_NotifyWebsiteDataDeletionForRegistrableDomainsFinished";
    case MessageName::NetworkProcessProxy_NotifyWebsiteDataScanForRegistrableDomainsFinished:
        return "NetworkProcessProxy_NotifyWebsiteDataScanForRegistrableDomainsFinished";
    case MessageName::NetworkProcessProxy_RegisterRemoteWorkerClientProcess:
        return "NetworkProcessProxy_RegisterRemoteWorkerClientProcess";
    case MessageName::NetworkProcessProxy_ReloadAfterUnblockedContentFilter:
        return "NetworkProcessProxy_ReloadAfterUnblockedContentFilter";
    case MessageName::NetworkProcessProxy_RemoteWorkerContextConnectionNoLongerNeeded:
        return "NetworkProcessProxy_RemoteWorkerContextConnectionNoLongerNeeded";
    case MessageName::NetworkProcessProxy_RequestStorageAccessConfirm:
        return "NetworkProcessProxy_RequestStorageAccessConfirm";
    case MessageName::NetworkProcessProxy_RequestStorageSpace:
        return "NetworkProcessProxy_RequestStorageSpace";
    case MessageName::NetworkProcessProxy_ResourceLoadDidCompleteWithError:
        return "NetworkProcessProxy_ResourceLoadDidCompleteWithError";
    case MessageName::NetworkProcessProxy_ResourceLoadDidPerformHTTPRedirection:
        return "NetworkProcessProxy_ResourceLoadDidPerformHTTPRedirection";
    case MessageName::NetworkProcessProxy_ResourceLoadDidReceiveChallenge:
        return "NetworkProcessProxy_ResourceLoadDidReceiveChallenge";
    case MessageName::NetworkProcessProxy_ResourceLoadDidReceiveResponse:
        return "NetworkProcessProxy_ResourceLoadDidReceiveResponse";
    case MessageName::NetworkProcessProxy_ResourceLoadDidSendRequest:
        return "NetworkProcessProxy_ResourceLoadDidSendRequest";
    case MessageName::NetworkProcessProxy_RetrieveCacheStorageParameters:
        return "NetworkProcessProxy_RetrieveCacheStorageParameters";
    case MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess:
        return "NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess";
    case MessageName::NetworkProcessProxy_SetDomainsWithUserInteraction:
        return "NetworkProcessProxy_SetDomainsWithUserInteraction";
    case MessageName::NetworkProcessProxy_SetWebProcessHasUploads:
        return "NetworkProcessProxy_SetWebProcessHasUploads";
    case MessageName::NetworkProcessProxy_StartServiceWorkerBackgroundProcessing:
        return "NetworkProcessProxy_StartServiceWorkerBackgroundProcessing";
    case MessageName::NetworkProcessProxy_TerminateUnresponsiveServiceWorkerProcesses:
        return "NetworkProcessProxy_TerminateUnresponsiveServiceWorkerProcesses";
    case MessageName::NetworkProcessProxy_TerminateWebProcess:
        return "NetworkProcessProxy_TerminateWebProcess";
    case MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation:
        return "NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation";
    case MessageName::NetworkProcessProxy_UnregisterRemoteWorkerClientProcess:
        return "NetworkProcessProxy_UnregisterRemoteWorkerClientProcess";
    case MessageName::NetworkProcess_AddWebPageNetworkParameters:
        return "NetworkProcess_AddWebPageNetworkParameters";
    case MessageName::NetworkProcess_AddWebsiteDataStore:
        return "NetworkProcess_AddWebsiteDataStore";
    case MessageName::NetworkProcess_AllowSpecificHTTPSCertificateForHost:
        return "NetworkProcess_AllowSpecificHTTPSCertificateForHost";
    case MessageName::NetworkProcess_AllowTLSCertificateChainForLocalPCMTesting:
        return "NetworkProcess_AllowTLSCertificateChainForLocalPCMTesting";
    case MessageName::NetworkProcess_AppPrivacyReportTestingData:
        return "NetworkProcess_AppPrivacyReportTestingData";
    case MessageName::NetworkProcess_ApplicationDidEnterBackground:
        return "NetworkProcess_ApplicationDidEnterBackground";
    case MessageName::NetworkProcess_ApplicationWillEnterForeground:
        return "NetworkProcess_ApplicationWillEnterForeground";
    case MessageName::NetworkProcess_CancelDownload:
        return "NetworkProcess_CancelDownload";
    case MessageName::NetworkProcess_ClearAppBoundSession:
        return "NetworkProcess_ClearAppBoundSession";
    case MessageName::NetworkProcess_ClearAppPrivacyReportTestingData:
        return "NetworkProcess_ClearAppPrivacyReportTestingData";
    case MessageName::NetworkProcess_ClearBundleIdentifier:
        return "NetworkProcess_ClearBundleIdentifier";
    case MessageName::NetworkProcess_ClearCachedCredentials:
        return "NetworkProcess_ClearCachedCredentials";
    case MessageName::NetworkProcess_ClearPrevalentResource:
        return "NetworkProcess_ClearPrevalentResource";
    case MessageName::NetworkProcess_ClearPrivateClickMeasurement:
        return "NetworkProcess_ClearPrivateClickMeasurement";
    case MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride:
        return "NetworkProcess_ClearServiceWorkerEntitlementOverride";
    case MessageName::NetworkProcess_ClearStorage:
        return "NetworkProcess_ClearStorage";
    case MessageName::NetworkProcess_ClearUserInteraction:
        return "NetworkProcess_ClearUserInteraction";
    case MessageName::NetworkProcess_CloseITPDatabase:
        return "NetworkProcess_CloseITPDatabase";
    case MessageName::NetworkProcess_ClosePCMDatabase:
        return "NetworkProcess_ClosePCMDatabase";
    case MessageName::NetworkProcess_ContinueWillSendRequest:
        return "NetworkProcess_ContinueWillSendRequest";
    case MessageName::NetworkProcess_CountNonDefaultSessionSets:
        return "NetworkProcess_CountNonDefaultSessionSets";
    case MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess:
        return "NetworkProcess_CreateNetworkConnectionToWebProcess";
    case MessageName::NetworkProcess_DeleteCookiesForTesting:
        return "NetworkProcess_DeleteCookiesForTesting";
    case MessageName::NetworkProcess_DeletePushAndNotificationRegistration:
        return "NetworkProcess_DeletePushAndNotificationRegistration";
    case MessageName::NetworkProcess_DeleteWebsiteData:
        return "NetworkProcess_DeleteWebsiteData";
    case MessageName::NetworkProcess_DeleteWebsiteDataForOrigins:
        return "NetworkProcess_DeleteWebsiteDataForOrigins";
    case MessageName::NetworkProcess_DestroySession:
        return "NetworkProcess_DestroySession";
    case MessageName::NetworkProcess_DidCommitCrossSiteLoadWithDataTransfer:
        return "NetworkProcess_DidCommitCrossSiteLoadWithDataTransfer";
    case MessageName::NetworkProcess_DidIncreaseQuota:
        return "NetworkProcess_DidIncreaseQuota";
    case MessageName::NetworkProcess_DisableServiceWorkerEntitlement:
        return "NetworkProcess_DisableServiceWorkerEntitlement";
    case MessageName::NetworkProcess_DomainIDExistsInDatabase:
        return "NetworkProcess_DomainIDExistsInDatabase";
    case MessageName::NetworkProcess_DownloadRequest:
        return "NetworkProcess_DownloadRequest";
    case MessageName::NetworkProcess_DumpPrivateClickMeasurement:
        return "NetworkProcess_DumpPrivateClickMeasurement";
    case MessageName::NetworkProcess_DumpResourceLoadStatistics:
        return "NetworkProcess_DumpResourceLoadStatistics";
    case MessageName::NetworkProcess_FetchWebsiteData:
        return "NetworkProcess_FetchWebsiteData";
    case MessageName::NetworkProcess_FlushCookies:
        return "NetworkProcess_FlushCookies";
    case MessageName::NetworkProcess_GetAllStorageAccessEntries:
        return "NetworkProcess_GetAllStorageAccessEntries";
    case MessageName::NetworkProcess_GetOriginsWithPushAndNotificationPermissions:
        return "NetworkProcess_GetOriginsWithPushAndNotificationPermissions";
    case MessageName::NetworkProcess_GetPendingPushMessages:
        return "NetworkProcess_GetPendingPushMessages";
    case MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary:
        return "NetworkProcess_GetResourceLoadStatisticsDataSummary";
    case MessageName::NetworkProcess_HadUserInteraction:
        return "NetworkProcess_HadUserInteraction";
    case MessageName::NetworkProcess_HasAppBoundSession:
        return "NetworkProcess_HasAppBoundSession";
    case MessageName::NetworkProcess_HasIsolatedSession:
        return "NetworkProcess_HasIsolatedSession";
    case MessageName::NetworkProcess_HasLocalStorage:
        return "NetworkProcess_HasLocalStorage";
    case MessageName::NetworkProcess_InitializeNetworkProcess:
        return "NetworkProcess_InitializeNetworkProcess";
    case MessageName::NetworkProcess_InsertExpiredStatisticForTesting:
        return "NetworkProcess_InsertExpiredStatisticForTesting";
    case MessageName::NetworkProcess_IsGrandfathered:
        return "NetworkProcess_IsGrandfathered";
    case MessageName::NetworkProcess_IsPrevalentResource:
        return "NetworkProcess_IsPrevalentResource";
    case MessageName::NetworkProcess_IsRegisteredAsRedirectingTo:
        return "NetworkProcess_IsRegisteredAsRedirectingTo";
    case MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder:
        return "NetworkProcess_IsRegisteredAsSubFrameUnder";
    case MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder:
        return "NetworkProcess_IsRegisteredAsSubresourceUnder";
    case MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce:
        return "NetworkProcess_IsRelationshipOnlyInDatabaseOnce";
    case MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral:
        return "NetworkProcess_IsResourceLoadStatisticsEphemeral";
    case MessageName::NetworkProcess_IsVeryPrevalentResource:
        return "NetworkProcess_IsVeryPrevalentResource";
    case MessageName::NetworkProcess_LogFrameNavigation:
        return "NetworkProcess_LogFrameNavigation";
    case MessageName::NetworkProcess_LogUserInteraction:
        return "NetworkProcess_LogUserInteraction";
    case MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting:
        return "NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting";
    case MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting:
        return "NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting";
    case MessageName::NetworkProcess_MergeStatisticForTesting:
        return "NetworkProcess_MergeStatisticForTesting";
    case MessageName::NetworkProcess_NotifyPreferencesChanged:
        return "NetworkProcess_NotifyPreferencesChanged";
    case MessageName::NetworkProcess_PreconnectTo:
        return "NetworkProcess_PreconnectTo";
    case MessageName::NetworkProcess_PrefetchDNS:
        return "NetworkProcess_PrefetchDNS";
    case MessageName::NetworkProcess_PrepareToSuspend:
        return "NetworkProcess_PrepareToSuspend";
    case MessageName::NetworkProcess_ProcessDidResume:
        return "NetworkProcess_ProcessDidResume";
    case MessageName::NetworkProcess_ProcessPushMessage:
        return "NetworkProcess_ProcessPushMessage";
    case MessageName::NetworkProcess_PublishDownloadProgress:
        return "NetworkProcess_PublishDownloadProgress";
    case MessageName::NetworkProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy:
        return "NetworkProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy";
    case MessageName::NetworkProcess_RegisterURLSchemeAsLocal:
        return "NetworkProcess_RegisterURLSchemeAsLocal";
    case MessageName::NetworkProcess_RegisterURLSchemeAsNoAccess:
        return "NetworkProcess_RegisterURLSchemeAsNoAccess";
    case MessageName::NetworkProcess_RegisterURLSchemeAsSecure:
        return "NetworkProcess_RegisterURLSchemeAsSecure";
    case MessageName::NetworkProcess_RemoveWebPageNetworkParameters:
        return "NetworkProcess_RemoveWebPageNetworkParameters";
    case MessageName::NetworkProcess_RenameOriginInWebsiteData:
        return "NetworkProcess_RenameOriginInWebsiteData";
    case MessageName::NetworkProcess_RequestResource:
        return "NetworkProcess_RequestResource";
    case MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources:
        return "NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources";
    case MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting:
        return "NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting";
    case MessageName::NetworkProcess_ResetParametersToDefaultValues:
        return "NetworkProcess_ResetParametersToDefaultValues";
    case MessageName::NetworkProcess_ResetQuota:
        return "NetworkProcess_ResetQuota";
    case MessageName::NetworkProcess_ResumeDownload:
        return "NetworkProcess_ResumeDownload";
    case MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent:
        return "NetworkProcess_ScheduleClearInMemoryAndPersistent";
    case MessageName::NetworkProcess_ScheduleCookieBlockingUpdate:
        return "NetworkProcess_ScheduleCookieBlockingUpdate";
    case MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing:
        return "NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing";
    case MessageName::NetworkProcess_SetAgeCapForClientSideCookies:
        return "NetworkProcess_SetAgeCapForClientSideCookies";
    case MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics:
        return "NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics";
    case MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources:
        return "NetworkProcess_SetCacheMaxAgeCapForPrevalentResources";
    case MessageName::NetworkProcess_SetCacheModel:
        return "NetworkProcess_SetCacheModel";
    case MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting:
        return "NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting";
    case MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting:
        return "NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting";
    case MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting:
        return "NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting";
    case MessageName::NetworkProcess_SetGrandfathered:
        return "NetworkProcess_SetGrandfathered";
    case MessageName::NetworkProcess_SetGrandfatheringTime:
        return "NetworkProcess_SetGrandfatheringTime";
    case MessageName::NetworkProcess_SetIgnoreTLSErrors:
        return "NetworkProcess_SetIgnoreTLSErrors";
    case MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest:
        return "NetworkProcess_SetIsRunningResourceLoadStatisticsTest";
    case MessageName::NetworkProcess_SetLastSeen:
        return "NetworkProcess_SetLastSeen";
    case MessageName::NetworkProcess_SetMaxStatisticsEntries:
        return "NetworkProcess_SetMaxStatisticsEntries";
    case MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval:
        return "NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval";
    case MessageName::NetworkProcess_SetNetworkProxySettings:
        return "NetworkProcess_SetNetworkProxySettings";
    case MessageName::NetworkProcess_SetNotifyPagesWhenDataRecordsWereScanned:
        return "NetworkProcess_SetNotifyPagesWhenDataRecordsWereScanned";
    case MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting:
        return "NetworkProcess_SetPCMFraudPreventionValuesForTesting";
    case MessageName::NetworkProcess_SetPersistentCredentialStorageEnabled:
        return "NetworkProcess_SetPersistentCredentialStorageEnabled";
    case MessageName::NetworkProcess_SetPrevalentResource:
        return "NetworkProcess_SetPrevalentResource";
    case MessageName::NetworkProcess_SetPrevalentResourceForDebugMode:
        return "NetworkProcess_SetPrevalentResourceForDebugMode";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting:
        return "NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting:
        return "NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementDebugMode:
        return "NetworkProcess_SetPrivateClickMeasurementDebugMode";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting:
        return "NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting:
        return "NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting:
        return "NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting:
        return "NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting";
    case MessageName::NetworkProcess_SetPruneEntriesDownTo:
        return "NetworkProcess_SetPruneEntriesDownTo";
    case MessageName::NetworkProcess_SetQOS:
        return "NetworkProcess_SetQOS";
    case MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode:
        return "NetworkProcess_SetResourceLoadStatisticsDebugMode";
    case MessageName::NetworkProcess_SetResourceLoadStatisticsEnabled:
        return "NetworkProcess_SetResourceLoadStatisticsEnabled";
    case MessageName::NetworkProcess_SetResourceLoadStatisticsLogTestingEvent:
        return "NetworkProcess_SetResourceLoadStatisticsLogTestingEvent";
    case MessageName::NetworkProcess_SetSessionIsControlledByAutomation:
        return "NetworkProcess_SetSessionIsControlledByAutomation";
    case MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval:
        return "NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval";
    case MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting:
        return "NetworkProcess_SetShouldDowngradeReferrerForTesting";
    case MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting:
        return "NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting";
    case MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain:
        return "NetworkProcess_SetSubframeUnderTopFrameDomain";
    case MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain:
        return "NetworkProcess_SetSubresourceUnderTopFrameDomain";
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom:
        return "NetworkProcess_SetSubresourceUniqueRedirectFrom";
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo:
        return "NetworkProcess_SetSubresourceUniqueRedirectTo";
    case MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting:
        return "NetworkProcess_SetThirdPartyCNAMEDomainForTesting";
    case MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode:
        return "NetworkProcess_SetThirdPartyCookieBlockingMode";
    case MessageName::NetworkProcess_SetTimeToLiveUserInteraction:
        return "NetworkProcess_SetTimeToLiveUserInteraction";
    case MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting:
        return "NetworkProcess_SetToSameSiteStrictCookiesForTesting";
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom:
        return "NetworkProcess_SetTopFrameUniqueRedirectFrom";
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo:
        return "NetworkProcess_SetTopFrameUniqueRedirectTo";
    case MessageName::NetworkProcess_SetVeryPrevalentResource:
        return "NetworkProcess_SetVeryPrevalentResource";
    case MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart:
        return "NetworkProcess_SimulatePrivateClickMeasurementSessionRestart";
    case MessageName::NetworkProcess_StatisticsDatabaseHasAllTables:
        return "NetworkProcess_StatisticsDatabaseHasAllTables";
    case MessageName::NetworkProcess_StorePrivateClickMeasurement:
        return "NetworkProcess_StorePrivateClickMeasurement";
    case MessageName::NetworkProcess_SyncLocalStorage:
        return "NetworkProcess_SyncLocalStorage";
    case MessageName::NetworkProcess_UpdateBundleIdentifier:
        return "NetworkProcess_UpdateBundleIdentifier";
    case MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor:
        return "NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor";
    case MessageName::NetworkProcess_UserPreferredLanguagesChanged:
        return "NetworkProcess_UserPreferredLanguagesChanged";
    case MessageName::NetworkRTCMonitor_StartUpdatingIfNeeded:
        return "NetworkRTCMonitor_StartUpdatingIfNeeded";
    case MessageName::NetworkRTCMonitor_StopUpdating:
        return "NetworkRTCMonitor_StopUpdating";
    case MessageName::NetworkRTCProvider_CloseSocket:
        return "NetworkRTCProvider_CloseSocket";
    case MessageName::NetworkRTCProvider_CreateClientTCPSocket:
        return "NetworkRTCProvider_CreateClientTCPSocket";
    case MessageName::NetworkRTCProvider_CreateResolver:
        return "NetworkRTCProvider_CreateResolver";
    case MessageName::NetworkRTCProvider_CreateServerTCPSocket:
        return "NetworkRTCProvider_CreateServerTCPSocket";
    case MessageName::NetworkRTCProvider_CreateUDPSocket:
        return "NetworkRTCProvider_CreateUDPSocket";
    case MessageName::NetworkRTCProvider_SendToSocket:
        return "NetworkRTCProvider_SendToSocket";
    case MessageName::NetworkRTCProvider_SetPlatformTCPSocketsEnabled:
        return "NetworkRTCProvider_SetPlatformTCPSocketsEnabled";
    case MessageName::NetworkRTCProvider_SetPlatformUDPSocketsEnabled:
        return "NetworkRTCProvider_SetPlatformUDPSocketsEnabled";
    case MessageName::NetworkRTCProvider_SetSocketOption:
        return "NetworkRTCProvider_SetSocketOption";
    case MessageName::NetworkRTCProvider_StopResolver:
        return "NetworkRTCProvider_StopResolver";
    case MessageName::NetworkRTCProvider_WrapNewTCPConnection:
        return "NetworkRTCProvider_WrapNewTCPConnection";
    case MessageName::NetworkResourceLoader_ContinueDidReceiveResponse:
        return "NetworkResourceLoader_ContinueDidReceiveResponse";
    case MessageName::NetworkResourceLoader_ContinueWillSendRequest:
        return "NetworkResourceLoader_ContinueWillSendRequest";
    case MessageName::NetworkSocketChannel_Close:
        return "NetworkSocketChannel_Close";
    case MessageName::NetworkSocketChannel_SendData:
        return "NetworkSocketChannel_SendData";
    case MessageName::NetworkSocketChannel_SendString:
        return "NetworkSocketChannel_SendString";
    case MessageName::NetworkSocketStream_Close:
        return "NetworkSocketStream_Close";
    case MessageName::NetworkSocketStream_SendData:
        return "NetworkSocketStream_SendData";
    case MessageName::NetworkSocketStream_SendHandshake:
        return "NetworkSocketStream_SendHandshake";
    case MessageName::NetworkStorageManager_AbortOpenAndUpgradeNeeded:
        return "NetworkStorageManager_AbortOpenAndUpgradeNeeded";
    case MessageName::NetworkStorageManager_AbortTransaction:
        return "NetworkStorageManager_AbortTransaction";
    case MessageName::NetworkStorageManager_Clear:
        return "NetworkStorageManager_Clear";
    case MessageName::NetworkStorageManager_ClearObjectStore:
        return "NetworkStorageManager_ClearObjectStore";
    case MessageName::NetworkStorageManager_CloneSessionStorageNamespace:
        return "NetworkStorageManager_CloneSessionStorageNamespace";
    case MessageName::NetworkStorageManager_CloseHandle:
        return "NetworkStorageManager_CloseHandle";
    case MessageName::NetworkStorageManager_CloseSyncAccessHandle:
        return "NetworkStorageManager_CloseSyncAccessHandle";
    case MessageName::NetworkStorageManager_CommitTransaction:
        return "NetworkStorageManager_CommitTransaction";
    case MessageName::NetworkStorageManager_ConnectToStorageArea:
        return "NetworkStorageManager_ConnectToStorageArea";
    case MessageName::NetworkStorageManager_CreateIndex:
        return "NetworkStorageManager_CreateIndex";
    case MessageName::NetworkStorageManager_CreateObjectStore:
        return "NetworkStorageManager_CreateObjectStore";
    case MessageName::NetworkStorageManager_CreateSyncAccessHandle:
        return "NetworkStorageManager_CreateSyncAccessHandle";
    case MessageName::NetworkStorageManager_DatabaseConnectionClosed:
        return "NetworkStorageManager_DatabaseConnectionClosed";
    case MessageName::NetworkStorageManager_DatabaseConnectionPendingClose:
        return "NetworkStorageManager_DatabaseConnectionPendingClose";
    case MessageName::NetworkStorageManager_DeleteDatabase:
        return "NetworkStorageManager_DeleteDatabase";
    case MessageName::NetworkStorageManager_DeleteIndex:
        return "NetworkStorageManager_DeleteIndex";
    case MessageName::NetworkStorageManager_DeleteObjectStore:
        return "NetworkStorageManager_DeleteObjectStore";
    case MessageName::NetworkStorageManager_DeleteRecord:
        return "NetworkStorageManager_DeleteRecord";
    case MessageName::NetworkStorageManager_DidFinishHandlingVersionChangeTransaction:
        return "NetworkStorageManager_DidFinishHandlingVersionChangeTransaction";
    case MessageName::NetworkStorageManager_DidFireVersionChangeEvent:
        return "NetworkStorageManager_DidFireVersionChangeEvent";
    case MessageName::NetworkStorageManager_DisconnectFromStorageArea:
        return "NetworkStorageManager_DisconnectFromStorageArea";
    case MessageName::NetworkStorageManager_EstablishTransaction:
        return "NetworkStorageManager_EstablishTransaction";
    case MessageName::NetworkStorageManager_FileSystemGetDirectory:
        return "NetworkStorageManager_FileSystemGetDirectory";
    case MessageName::NetworkStorageManager_GetAllDatabaseNamesAndVersions:
        return "NetworkStorageManager_GetAllDatabaseNamesAndVersions";
    case MessageName::NetworkStorageManager_GetAllRecords:
        return "NetworkStorageManager_GetAllRecords";
    case MessageName::NetworkStorageManager_GetCount:
        return "NetworkStorageManager_GetCount";
    case MessageName::NetworkStorageManager_GetDirectoryHandle:
        return "NetworkStorageManager_GetDirectoryHandle";
    case MessageName::NetworkStorageManager_GetFile:
        return "NetworkStorageManager_GetFile";
    case MessageName::NetworkStorageManager_GetFileHandle:
        return "NetworkStorageManager_GetFileHandle";
    case MessageName::NetworkStorageManager_GetHandle:
        return "NetworkStorageManager_GetHandle";
    case MessageName::NetworkStorageManager_GetHandleNames:
        return "NetworkStorageManager_GetHandleNames";
    case MessageName::NetworkStorageManager_GetRecord:
        return "NetworkStorageManager_GetRecord";
    case MessageName::NetworkStorageManager_IsSameEntry:
        return "NetworkStorageManager_IsSameEntry";
    case MessageName::NetworkStorageManager_IterateCursor:
        return "NetworkStorageManager_IterateCursor";
    case MessageName::NetworkStorageManager_Move:
        return "NetworkStorageManager_Move";
    case MessageName::NetworkStorageManager_OpenCursor:
        return "NetworkStorageManager_OpenCursor";
    case MessageName::NetworkStorageManager_OpenDBRequestCancelled:
        return "NetworkStorageManager_OpenDBRequestCancelled";
    case MessageName::NetworkStorageManager_OpenDatabase:
        return "NetworkStorageManager_OpenDatabase";
    case MessageName::NetworkStorageManager_Persist:
        return "NetworkStorageManager_Persist";
    case MessageName::NetworkStorageManager_Persisted:
        return "NetworkStorageManager_Persisted";
    case MessageName::NetworkStorageManager_PutOrAdd:
        return "NetworkStorageManager_PutOrAdd";
    case MessageName::NetworkStorageManager_RemoveEntry:
        return "NetworkStorageManager_RemoveEntry";
    case MessageName::NetworkStorageManager_RemoveItem:
        return "NetworkStorageManager_RemoveItem";
    case MessageName::NetworkStorageManager_RenameIndex:
        return "NetworkStorageManager_RenameIndex";
    case MessageName::NetworkStorageManager_RenameObjectStore:
        return "NetworkStorageManager_RenameObjectStore";
    case MessageName::NetworkStorageManager_Resolve:
        return "NetworkStorageManager_Resolve";
    case MessageName::NetworkStorageManager_SetItem:
        return "NetworkStorageManager_SetItem";
    case MessageName::NotificationManagerMessageHandler_CancelNotification:
        return "NotificationManagerMessageHandler_CancelNotification";
    case MessageName::NotificationManagerMessageHandler_ClearNotifications:
        return "NotificationManagerMessageHandler_ClearNotifications";
    case MessageName::NotificationManagerMessageHandler_DidDestroyNotification:
        return "NotificationManagerMessageHandler_DidDestroyNotification";
    case MessageName::NotificationManagerMessageHandler_RequestSystemNotificationPermission:
        return "NotificationManagerMessageHandler_RequestSystemNotificationPermission";
    case MessageName::NotificationManagerMessageHandler_ShowNotification:
        return "NotificationManagerMessageHandler_ShowNotification";
    case MessageName::PlatformXRSystemProxy_SessionDidEnd:
        return "PlatformXRSystemProxy_SessionDidEnd";
    case MessageName::PlatformXRSystemProxy_SessionDidUpdateVisibilityState:
        return "PlatformXRSystemProxy_SessionDidUpdateVisibilityState";
    case MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices:
        return "PlatformXRSystem_EnumerateImmersiveXRDevices";
    case MessageName::PlatformXRSystem_InitializeTrackingAndRendering:
        return "PlatformXRSystem_InitializeTrackingAndRendering";
    case MessageName::PlatformXRSystem_RequestFrame:
        return "PlatformXRSystem_RequestFrame";
    case MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures:
        return "PlatformXRSystem_RequestPermissionOnSessionFeatures";
    case MessageName::PlatformXRSystem_ShutDownTrackingAndRendering:
        return "PlatformXRSystem_ShutDownTrackingAndRendering";
    case MessageName::PlatformXRSystem_SubmitFrame:
        return "PlatformXRSystem_SubmitFrame";
    case MessageName::RTCDataChannelRemoteManagerProxy_BufferedAmountIsDecreasing:
        return "RTCDataChannelRemoteManagerProxy_BufferedAmountIsDecreasing";
    case MessageName::RTCDataChannelRemoteManagerProxy_ChangeReadyState:
        return "RTCDataChannelRemoteManagerProxy_ChangeReadyState";
    case MessageName::RTCDataChannelRemoteManagerProxy_Close:
        return "RTCDataChannelRemoteManagerProxy_Close";
    case MessageName::RTCDataChannelRemoteManagerProxy_DetectError:
        return "RTCDataChannelRemoteManagerProxy_DetectError";
    case MessageName::RTCDataChannelRemoteManagerProxy_ReceiveData:
        return "RTCDataChannelRemoteManagerProxy_ReceiveData";
    case MessageName::RTCDataChannelRemoteManagerProxy_SendData:
        return "RTCDataChannelRemoteManagerProxy_SendData";
    case MessageName::RTCDataChannelRemoteManager_BufferedAmountIsDecreasing:
        return "RTCDataChannelRemoteManager_BufferedAmountIsDecreasing";
    case MessageName::RTCDataChannelRemoteManager_ChangeReadyState:
        return "RTCDataChannelRemoteManager_ChangeReadyState";
    case MessageName::RTCDataChannelRemoteManager_Close:
        return "RTCDataChannelRemoteManager_Close";
    case MessageName::RTCDataChannelRemoteManager_DetectError:
        return "RTCDataChannelRemoteManager_DetectError";
    case MessageName::RTCDataChannelRemoteManager_ReceiveData:
        return "RTCDataChannelRemoteManager_ReceiveData";
    case MessageName::RTCDataChannelRemoteManager_SendData:
        return "RTCDataChannelRemoteManager_SendData";
    case MessageName::RemoteAudioDestinationManager_AudioSamplesStorageChanged:
        return "RemoteAudioDestinationManager_AudioSamplesStorageChanged";
    case MessageName::RemoteAudioDestinationManager_DeleteAudioDestination:
        return "RemoteAudioDestinationManager_DeleteAudioDestination";
    case MessageName::RemoteAudioDestinationManager_StartAudioDestination:
        return "RemoteAudioDestinationManager_StartAudioDestination";
    case MessageName::RemoteAudioDestinationManager_StopAudioDestination:
        return "RemoteAudioDestinationManager_StopAudioDestination";
    case MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeActive:
        return "RemoteAudioHardwareListener_AudioHardwareDidBecomeActive";
    case MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeInactive:
        return "RemoteAudioHardwareListener_AudioHardwareDidBecomeInactive";
    case MessageName::RemoteAudioHardwareListener_AudioOutputDeviceChanged:
        return "RemoteAudioHardwareListener_AudioOutputDeviceChanged";
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit:
        return "RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit";
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_DeleteUnit:
        return "RemoteAudioMediaStreamTrackRendererInternalUnitManager_DeleteUnit";
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_SetAudioOutputDevice:
        return "RemoteAudioMediaStreamTrackRendererInternalUnitManager_SetAudioOutputDevice";
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StartUnit:
        return "RemoteAudioMediaStreamTrackRendererInternalUnitManager_StartUnit";
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StopUnit:
        return "RemoteAudioMediaStreamTrackRendererInternalUnitManager_StopUnit";
    case MessageName::RemoteAudioSessionProxy_SetCategory:
        return "RemoteAudioSessionProxy_SetCategory";
    case MessageName::RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride:
        return "RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride";
    case MessageName::RemoteAudioSessionProxy_SetPreferredBufferSize:
        return "RemoteAudioSessionProxy_SetPreferredBufferSize";
    case MessageName::RemoteAudioSession_BeginInterruption:
        return "RemoteAudioSession_BeginInterruption";
    case MessageName::RemoteAudioSession_ConfigurationChanged:
        return "RemoteAudioSession_ConfigurationChanged";
    case MessageName::RemoteAudioSession_EndInterruption:
        return "RemoteAudioSession_EndInterruption";
    case MessageName::RemoteAudioSourceProviderManager_AudioSamplesAvailable:
        return "RemoteAudioSourceProviderManager_AudioSamplesAvailable";
    case MessageName::RemoteAudioSourceProviderManager_AudioStorageChanged:
        return "RemoteAudioSourceProviderManager_AudioStorageChanged";
    case MessageName::RemoteBindGroupLayout_SetLabel:
        return "RemoteBindGroupLayout_SetLabel";
    case MessageName::RemoteBindGroup_SetLabel:
        return "RemoteBindGroup_SetLabel";
    case MessageName::RemoteBuffer_Destroy:
        return "RemoteBuffer_Destroy";
    case MessageName::RemoteBuffer_SetLabel:
        return "RemoteBuffer_SetLabel";
    case MessageName::RemoteBuffer_Unmap:
        return "RemoteBuffer_Unmap";
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration:
        return "RemoteCDMInstanceProxy_InitializeWithConfiguration";
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificate:
        return "RemoteCDMInstanceProxy_SetServerCertificate";
    case MessageName::RemoteCDMInstanceProxy_SetStorageDirectory:
        return "RemoteCDMInstanceProxy_SetStorageDirectory";
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSession:
        return "RemoteCDMInstanceSessionProxy_CloseSession";
    case MessageName::RemoteCDMInstanceSessionProxy_DisplayIDChanged:
        return "RemoteCDMInstanceSessionProxy_DisplayIDChanged";
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSession:
        return "RemoteCDMInstanceSessionProxy_LoadSession";
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData:
        return "RemoteCDMInstanceSessionProxy_RemoveSessionData";
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicense:
        return "RemoteCDMInstanceSessionProxy_RequestLicense";
    case MessageName::RemoteCDMInstanceSessionProxy_StoreRecordOfKeyUsage:
        return "RemoteCDMInstanceSessionProxy_StoreRecordOfKeyUsage";
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense:
        return "RemoteCDMInstanceSessionProxy_UpdateLicense";
    case MessageName::RemoteCDMInstanceSession_SendMessage:
        return "RemoteCDMInstanceSession_SendMessage";
    case MessageName::RemoteCDMInstanceSession_SessionIdChanged:
        return "RemoteCDMInstanceSession_SessionIdChanged";
    case MessageName::RemoteCDMInstanceSession_UpdateKeyStatuses:
        return "RemoteCDMInstanceSession_UpdateKeyStatuses";
    case MessageName::RemoteCDMInstance_UnrequestedInitializationDataReceived:
        return "RemoteCDMInstance_UnrequestedInitializationDataReceived";
    case MessageName::RemoteCDMProxy_GetSupportedConfiguration:
        return "RemoteCDMProxy_GetSupportedConfiguration";
    case MessageName::RemoteCDMProxy_LoadAndInitialize:
        return "RemoteCDMProxy_LoadAndInitialize";
    case MessageName::RemoteCommandBuffer_SetLabel:
        return "RemoteCommandBuffer_SetLabel";
    case MessageName::RemoteCommandEncoder_BeginComputePass:
        return "RemoteCommandEncoder_BeginComputePass";
    case MessageName::RemoteCommandEncoder_BeginRenderPass:
        return "RemoteCommandEncoder_BeginRenderPass";
    case MessageName::RemoteCommandEncoder_ClearBuffer:
        return "RemoteCommandEncoder_ClearBuffer";
    case MessageName::RemoteCommandEncoder_CopyBufferToBuffer:
        return "RemoteCommandEncoder_CopyBufferToBuffer";
    case MessageName::RemoteCommandEncoder_CopyBufferToTexture:
        return "RemoteCommandEncoder_CopyBufferToTexture";
    case MessageName::RemoteCommandEncoder_CopyTextureToBuffer:
        return "RemoteCommandEncoder_CopyTextureToBuffer";
    case MessageName::RemoteCommandEncoder_CopyTextureToTexture:
        return "RemoteCommandEncoder_CopyTextureToTexture";
    case MessageName::RemoteCommandEncoder_Finish:
        return "RemoteCommandEncoder_Finish";
    case MessageName::RemoteCommandEncoder_InsertDebugMarker:
        return "RemoteCommandEncoder_InsertDebugMarker";
    case MessageName::RemoteCommandEncoder_PopDebugGroup:
        return "RemoteCommandEncoder_PopDebugGroup";
    case MessageName::RemoteCommandEncoder_PushDebugGroup:
        return "RemoteCommandEncoder_PushDebugGroup";
    case MessageName::RemoteCommandEncoder_ResolveQuerySet:
        return "RemoteCommandEncoder_ResolveQuerySet";
    case MessageName::RemoteCommandEncoder_SetLabel:
        return "RemoteCommandEncoder_SetLabel";
    case MessageName::RemoteCommandEncoder_WriteTimestamp:
        return "RemoteCommandEncoder_WriteTimestamp";
    case MessageName::RemoteComputePassEncoder_Dispatch:
        return "RemoteComputePassEncoder_Dispatch";
    case MessageName::RemoteComputePassEncoder_DispatchIndirect:
        return "RemoteComputePassEncoder_DispatchIndirect";
    case MessageName::RemoteComputePassEncoder_End:
        return "RemoteComputePassEncoder_End";
    case MessageName::RemoteComputePassEncoder_InsertDebugMarker:
        return "RemoteComputePassEncoder_InsertDebugMarker";
    case MessageName::RemoteComputePassEncoder_PopDebugGroup:
        return "RemoteComputePassEncoder_PopDebugGroup";
    case MessageName::RemoteComputePassEncoder_PushDebugGroup:
        return "RemoteComputePassEncoder_PushDebugGroup";
    case MessageName::RemoteComputePassEncoder_SetBindGroup:
        return "RemoteComputePassEncoder_SetBindGroup";
    case MessageName::RemoteComputePassEncoder_SetLabel:
        return "RemoteComputePassEncoder_SetLabel";
    case MessageName::RemoteComputePassEncoder_SetPipeline:
        return "RemoteComputePassEncoder_SetPipeline";
    case MessageName::RemoteComputePipeline_GetBindGroupLayout:
        return "RemoteComputePipeline_GetBindGroupLayout";
    case MessageName::RemoteComputePipeline_SetLabel:
        return "RemoteComputePipeline_SetLabel";
    case MessageName::RemoteDevice_CreateBindGroup:
        return "RemoteDevice_CreateBindGroup";
    case MessageName::RemoteDevice_CreateBindGroupLayout:
        return "RemoteDevice_CreateBindGroupLayout";
    case MessageName::RemoteDevice_CreateBuffer:
        return "RemoteDevice_CreateBuffer";
    case MessageName::RemoteDevice_CreateCommandEncoder:
        return "RemoteDevice_CreateCommandEncoder";
    case MessageName::RemoteDevice_CreateComputePipeline:
        return "RemoteDevice_CreateComputePipeline";
    case MessageName::RemoteDevice_CreatePipelineLayout:
        return "RemoteDevice_CreatePipelineLayout";
    case MessageName::RemoteDevice_CreateQuerySet:
        return "RemoteDevice_CreateQuerySet";
    case MessageName::RemoteDevice_CreateRenderBundleEncoder:
        return "RemoteDevice_CreateRenderBundleEncoder";
    case MessageName::RemoteDevice_CreateRenderPipeline:
        return "RemoteDevice_CreateRenderPipeline";
    case MessageName::RemoteDevice_CreateSampler:
        return "RemoteDevice_CreateSampler";
    case MessageName::RemoteDevice_CreateShaderModule:
        return "RemoteDevice_CreateShaderModule";
    case MessageName::RemoteDevice_CreateTexture:
        return "RemoteDevice_CreateTexture";
    case MessageName::RemoteDevice_Destroy:
        return "RemoteDevice_Destroy";
    case MessageName::RemoteDevice_ImportExternalTexture:
        return "RemoteDevice_ImportExternalTexture";
    case MessageName::RemoteDevice_PushErrorScope:
        return "RemoteDevice_PushErrorScope";
    case MessageName::RemoteDevice_SetLabel:
        return "RemoteDevice_SetLabel";
    case MessageName::RemoteDisplayListRecorder_ApplyDeviceScaleFactor:
        return "RemoteDisplayListRecorder_ApplyDeviceScaleFactor";
    case MessageName::RemoteDisplayListRecorder_ApplyFillPattern:
        return "RemoteDisplayListRecorder_ApplyFillPattern";
    case MessageName::RemoteDisplayListRecorder_ApplyStrokePattern:
        return "RemoteDisplayListRecorder_ApplyStrokePattern";
    case MessageName::RemoteDisplayListRecorder_BeginTransparencyLayer:
        return "RemoteDisplayListRecorder_BeginTransparencyLayer";
    case MessageName::RemoteDisplayListRecorder_ClearRect:
        return "RemoteDisplayListRecorder_ClearRect";
    case MessageName::RemoteDisplayListRecorder_ClearShadow:
        return "RemoteDisplayListRecorder_ClearShadow";
    case MessageName::RemoteDisplayListRecorder_Clip:
        return "RemoteDisplayListRecorder_Clip";
    case MessageName::RemoteDisplayListRecorder_ClipOut:
        return "RemoteDisplayListRecorder_ClipOut";
    case MessageName::RemoteDisplayListRecorder_ClipOutToPath:
        return "RemoteDisplayListRecorder_ClipOutToPath";
    case MessageName::RemoteDisplayListRecorder_ClipPath:
        return "RemoteDisplayListRecorder_ClipPath";
    case MessageName::RemoteDisplayListRecorder_ClipToImageBuffer:
        return "RemoteDisplayListRecorder_ClipToImageBuffer";
    case MessageName::RemoteDisplayListRecorder_ConcatenateCTM:
        return "RemoteDisplayListRecorder_ConcatenateCTM";
    case MessageName::RemoteDisplayListRecorder_ConvertToLuminanceMask:
        return "RemoteDisplayListRecorder_ConvertToLuminanceMask";
    case MessageName::RemoteDisplayListRecorder_DrawDotsForDocumentMarker:
        return "RemoteDisplayListRecorder_DrawDotsForDocumentMarker";
    case MessageName::RemoteDisplayListRecorder_DrawEllipse:
        return "RemoteDisplayListRecorder_DrawEllipse";
    case MessageName::RemoteDisplayListRecorder_DrawFilteredImageBuffer:
        return "RemoteDisplayListRecorder_DrawFilteredImageBuffer";
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingPath:
        return "RemoteDisplayListRecorder_DrawFocusRingPath";
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingRects:
        return "RemoteDisplayListRecorder_DrawFocusRingRects";
    case MessageName::RemoteDisplayListRecorder_DrawGlyphs:
        return "RemoteDisplayListRecorder_DrawGlyphs";
    case MessageName::RemoteDisplayListRecorder_DrawImageBuffer:
        return "RemoteDisplayListRecorder_DrawImageBuffer";
    case MessageName::RemoteDisplayListRecorder_DrawLine:
        return "RemoteDisplayListRecorder_DrawLine";
    case MessageName::RemoteDisplayListRecorder_DrawLinesForText:
        return "RemoteDisplayListRecorder_DrawLinesForText";
    case MessageName::RemoteDisplayListRecorder_DrawNativeImage:
        return "RemoteDisplayListRecorder_DrawNativeImage";
    case MessageName::RemoteDisplayListRecorder_DrawPath:
        return "RemoteDisplayListRecorder_DrawPath";
    case MessageName::RemoteDisplayListRecorder_DrawPattern:
        return "RemoteDisplayListRecorder_DrawPattern";
    case MessageName::RemoteDisplayListRecorder_DrawRect:
        return "RemoteDisplayListRecorder_DrawRect";
    case MessageName::RemoteDisplayListRecorder_EndTransparencyLayer:
        return "RemoteDisplayListRecorder_EndTransparencyLayer";
    case MessageName::RemoteDisplayListRecorder_FillArc:
        return "RemoteDisplayListRecorder_FillArc";
    case MessageName::RemoteDisplayListRecorder_FillBezierCurve:
        return "RemoteDisplayListRecorder_FillBezierCurve";
    case MessageName::RemoteDisplayListRecorder_FillCompositedRect:
        return "RemoteDisplayListRecorder_FillCompositedRect";
    case MessageName::RemoteDisplayListRecorder_FillEllipse:
        return "RemoteDisplayListRecorder_FillEllipse";
    case MessageName::RemoteDisplayListRecorder_FillLine:
        return "RemoteDisplayListRecorder_FillLine";
    case MessageName::RemoteDisplayListRecorder_FillPath:
        return "RemoteDisplayListRecorder_FillPath";
    case MessageName::RemoteDisplayListRecorder_FillQuadCurve:
        return "RemoteDisplayListRecorder_FillQuadCurve";
    case MessageName::RemoteDisplayListRecorder_FillRect:
        return "RemoteDisplayListRecorder_FillRect";
    case MessageName::RemoteDisplayListRecorder_FillRectWithColor:
        return "RemoteDisplayListRecorder_FillRectWithColor";
    case MessageName::RemoteDisplayListRecorder_FillRectWithGradient:
        return "RemoteDisplayListRecorder_FillRectWithGradient";
    case MessageName::RemoteDisplayListRecorder_FillRectWithRoundedHole:
        return "RemoteDisplayListRecorder_FillRectWithRoundedHole";
    case MessageName::RemoteDisplayListRecorder_FillRoundedRect:
        return "RemoteDisplayListRecorder_FillRoundedRect";
    case MessageName::RemoteDisplayListRecorder_FlushContext:
        return "RemoteDisplayListRecorder_FlushContext";
    case MessageName::RemoteDisplayListRecorder_PaintFrameForMedia:
        return "RemoteDisplayListRecorder_PaintFrameForMedia";
    case MessageName::RemoteDisplayListRecorder_Restore:
        return "RemoteDisplayListRecorder_Restore";
    case MessageName::RemoteDisplayListRecorder_Rotate:
        return "RemoteDisplayListRecorder_Rotate";
    case MessageName::RemoteDisplayListRecorder_Save:
        return "RemoteDisplayListRecorder_Save";
    case MessageName::RemoteDisplayListRecorder_Scale:
        return "RemoteDisplayListRecorder_Scale";
    case MessageName::RemoteDisplayListRecorder_SetCTM:
        return "RemoteDisplayListRecorder_SetCTM";
    case MessageName::RemoteDisplayListRecorder_SetInlineFillColor:
        return "RemoteDisplayListRecorder_SetInlineFillColor";
    case MessageName::RemoteDisplayListRecorder_SetInlineStrokeColor:
        return "RemoteDisplayListRecorder_SetInlineStrokeColor";
    case MessageName::RemoteDisplayListRecorder_SetLineCap:
        return "RemoteDisplayListRecorder_SetLineCap";
    case MessageName::RemoteDisplayListRecorder_SetLineDash:
        return "RemoteDisplayListRecorder_SetLineDash";
    case MessageName::RemoteDisplayListRecorder_SetLineJoin:
        return "RemoteDisplayListRecorder_SetLineJoin";
    case MessageName::RemoteDisplayListRecorder_SetMiterLimit:
        return "RemoteDisplayListRecorder_SetMiterLimit";
    case MessageName::RemoteDisplayListRecorder_SetState:
        return "RemoteDisplayListRecorder_SetState";
    case MessageName::RemoteDisplayListRecorder_SetStrokeThickness:
        return "RemoteDisplayListRecorder_SetStrokeThickness";
    case MessageName::RemoteDisplayListRecorder_StrokeArc:
        return "RemoteDisplayListRecorder_StrokeArc";
    case MessageName::RemoteDisplayListRecorder_StrokeBezierCurve:
        return "RemoteDisplayListRecorder_StrokeBezierCurve";
    case MessageName::RemoteDisplayListRecorder_StrokeEllipse:
        return "RemoteDisplayListRecorder_StrokeEllipse";
    case MessageName::RemoteDisplayListRecorder_StrokeLine:
        return "RemoteDisplayListRecorder_StrokeLine";
    case MessageName::RemoteDisplayListRecorder_StrokePath:
        return "RemoteDisplayListRecorder_StrokePath";
    case MessageName::RemoteDisplayListRecorder_StrokeQuadCurve:
        return "RemoteDisplayListRecorder_StrokeQuadCurve";
    case MessageName::RemoteDisplayListRecorder_StrokeRect:
        return "RemoteDisplayListRecorder_StrokeRect";
    case MessageName::RemoteDisplayListRecorder_TransformToColorSpace:
        return "RemoteDisplayListRecorder_TransformToColorSpace";
    case MessageName::RemoteDisplayListRecorder_Translate:
        return "RemoteDisplayListRecorder_Translate";
    case MessageName::RemoteExternalTexture_SetLabel:
        return "RemoteExternalTexture_SetLabel";
    case MessageName::RemoteGPUProxy_WasCreated:
        return "RemoteGPUProxy_WasCreated";
    case MessageName::RemoteGraphicsContextGLProxy_WasChanged:
        return "RemoteGraphicsContextGLProxy_WasChanged";
    case MessageName::RemoteGraphicsContextGLProxy_WasCreated:
        return "RemoteGraphicsContextGLProxy_WasCreated";
    case MessageName::RemoteGraphicsContextGLProxy_WasLost:
        return "RemoteGraphicsContextGLProxy_WasLost";
    case MessageName::RemoteGraphicsContextGL_ActiveTexture:
        return "RemoteGraphicsContextGL_ActiveTexture";
    case MessageName::RemoteGraphicsContextGL_AttachShader:
        return "RemoteGraphicsContextGL_AttachShader";
    case MessageName::RemoteGraphicsContextGL_BeginQuery:
        return "RemoteGraphicsContextGL_BeginQuery";
    case MessageName::RemoteGraphicsContextGL_BeginTransformFeedback:
        return "RemoteGraphicsContextGL_BeginTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_BindAttribLocation:
        return "RemoteGraphicsContextGL_BindAttribLocation";
    case MessageName::RemoteGraphicsContextGL_BindBuffer:
        return "RemoteGraphicsContextGL_BindBuffer";
    case MessageName::RemoteGraphicsContextGL_BindBufferBase:
        return "RemoteGraphicsContextGL_BindBufferBase";
    case MessageName::RemoteGraphicsContextGL_BindBufferRange:
        return "RemoteGraphicsContextGL_BindBufferRange";
    case MessageName::RemoteGraphicsContextGL_BindFramebuffer:
        return "RemoteGraphicsContextGL_BindFramebuffer";
    case MessageName::RemoteGraphicsContextGL_BindRenderbuffer:
        return "RemoteGraphicsContextGL_BindRenderbuffer";
    case MessageName::RemoteGraphicsContextGL_BindSampler:
        return "RemoteGraphicsContextGL_BindSampler";
    case MessageName::RemoteGraphicsContextGL_BindTexture:
        return "RemoteGraphicsContextGL_BindTexture";
    case MessageName::RemoteGraphicsContextGL_BindTransformFeedback:
        return "RemoteGraphicsContextGL_BindTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_BindVertexArray:
        return "RemoteGraphicsContextGL_BindVertexArray";
    case MessageName::RemoteGraphicsContextGL_BlendColor:
        return "RemoteGraphicsContextGL_BlendColor";
    case MessageName::RemoteGraphicsContextGL_BlendEquation:
        return "RemoteGraphicsContextGL_BlendEquation";
    case MessageName::RemoteGraphicsContextGL_BlendEquationSeparate:
        return "RemoteGraphicsContextGL_BlendEquationSeparate";
    case MessageName::RemoteGraphicsContextGL_BlendFunc:
        return "RemoteGraphicsContextGL_BlendFunc";
    case MessageName::RemoteGraphicsContextGL_BlendFuncSeparate:
        return "RemoteGraphicsContextGL_BlendFuncSeparate";
    case MessageName::RemoteGraphicsContextGL_BlitFramebuffer:
        return "RemoteGraphicsContextGL_BlitFramebuffer";
    case MessageName::RemoteGraphicsContextGL_BufferData0:
        return "RemoteGraphicsContextGL_BufferData0";
    case MessageName::RemoteGraphicsContextGL_BufferData1:
        return "RemoteGraphicsContextGL_BufferData1";
    case MessageName::RemoteGraphicsContextGL_BufferSubData:
        return "RemoteGraphicsContextGL_BufferSubData";
    case MessageName::RemoteGraphicsContextGL_Clear:
        return "RemoteGraphicsContextGL_Clear";
    case MessageName::RemoteGraphicsContextGL_ClearBufferfi:
        return "RemoteGraphicsContextGL_ClearBufferfi";
    case MessageName::RemoteGraphicsContextGL_ClearBufferfv:
        return "RemoteGraphicsContextGL_ClearBufferfv";
    case MessageName::RemoteGraphicsContextGL_ClearBufferiv:
        return "RemoteGraphicsContextGL_ClearBufferiv";
    case MessageName::RemoteGraphicsContextGL_ClearBufferuiv:
        return "RemoteGraphicsContextGL_ClearBufferuiv";
    case MessageName::RemoteGraphicsContextGL_ClearColor:
        return "RemoteGraphicsContextGL_ClearColor";
    case MessageName::RemoteGraphicsContextGL_ClearDepth:
        return "RemoteGraphicsContextGL_ClearDepth";
    case MessageName::RemoteGraphicsContextGL_ClearStencil:
        return "RemoteGraphicsContextGL_ClearStencil";
    case MessageName::RemoteGraphicsContextGL_ColorMask:
        return "RemoteGraphicsContextGL_ColorMask";
    case MessageName::RemoteGraphicsContextGL_CompileShader:
        return "RemoteGraphicsContextGL_CompileShader";
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D0:
        return "RemoteGraphicsContextGL_CompressedTexImage2D0";
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D1:
        return "RemoteGraphicsContextGL_CompressedTexImage2D1";
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D0:
        return "RemoteGraphicsContextGL_CompressedTexImage3D0";
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D1:
        return "RemoteGraphicsContextGL_CompressedTexImage3D1";
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D0:
        return "RemoteGraphicsContextGL_CompressedTexSubImage2D0";
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D1:
        return "RemoteGraphicsContextGL_CompressedTexSubImage2D1";
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D0:
        return "RemoteGraphicsContextGL_CompressedTexSubImage3D0";
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D1:
        return "RemoteGraphicsContextGL_CompressedTexSubImage3D1";
    case MessageName::RemoteGraphicsContextGL_CopyBufferSubData:
        return "RemoteGraphicsContextGL_CopyBufferSubData";
    case MessageName::RemoteGraphicsContextGL_CopyTexImage2D:
        return "RemoteGraphicsContextGL_CopyTexImage2D";
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage2D:
        return "RemoteGraphicsContextGL_CopyTexSubImage2D";
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage3D:
        return "RemoteGraphicsContextGL_CopyTexSubImage3D";
    case MessageName::RemoteGraphicsContextGL_CullFace:
        return "RemoteGraphicsContextGL_CullFace";
    case MessageName::RemoteGraphicsContextGL_DeleteBuffer:
        return "RemoteGraphicsContextGL_DeleteBuffer";
    case MessageName::RemoteGraphicsContextGL_DeleteFramebuffer:
        return "RemoteGraphicsContextGL_DeleteFramebuffer";
    case MessageName::RemoteGraphicsContextGL_DeleteProgram:
        return "RemoteGraphicsContextGL_DeleteProgram";
    case MessageName::RemoteGraphicsContextGL_DeleteQuery:
        return "RemoteGraphicsContextGL_DeleteQuery";
    case MessageName::RemoteGraphicsContextGL_DeleteRenderbuffer:
        return "RemoteGraphicsContextGL_DeleteRenderbuffer";
    case MessageName::RemoteGraphicsContextGL_DeleteSampler:
        return "RemoteGraphicsContextGL_DeleteSampler";
    case MessageName::RemoteGraphicsContextGL_DeleteShader:
        return "RemoteGraphicsContextGL_DeleteShader";
    case MessageName::RemoteGraphicsContextGL_DeleteSync:
        return "RemoteGraphicsContextGL_DeleteSync";
    case MessageName::RemoteGraphicsContextGL_DeleteTexture:
        return "RemoteGraphicsContextGL_DeleteTexture";
    case MessageName::RemoteGraphicsContextGL_DeleteTransformFeedback:
        return "RemoteGraphicsContextGL_DeleteTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_DeleteVertexArray:
        return "RemoteGraphicsContextGL_DeleteVertexArray";
    case MessageName::RemoteGraphicsContextGL_DepthFunc:
        return "RemoteGraphicsContextGL_DepthFunc";
    case MessageName::RemoteGraphicsContextGL_DepthMask:
        return "RemoteGraphicsContextGL_DepthMask";
    case MessageName::RemoteGraphicsContextGL_DepthRange:
        return "RemoteGraphicsContextGL_DepthRange";
    case MessageName::RemoteGraphicsContextGL_DetachShader:
        return "RemoteGraphicsContextGL_DetachShader";
    case MessageName::RemoteGraphicsContextGL_Disable:
        return "RemoteGraphicsContextGL_Disable";
    case MessageName::RemoteGraphicsContextGL_DisableVertexAttribArray:
        return "RemoteGraphicsContextGL_DisableVertexAttribArray";
    case MessageName::RemoteGraphicsContextGL_DrawArrays:
        return "RemoteGraphicsContextGL_DrawArrays";
    case MessageName::RemoteGraphicsContextGL_DrawArraysInstanced:
        return "RemoteGraphicsContextGL_DrawArraysInstanced";
    case MessageName::RemoteGraphicsContextGL_DrawBuffers:
        return "RemoteGraphicsContextGL_DrawBuffers";
    case MessageName::RemoteGraphicsContextGL_DrawBuffersEXT:
        return "RemoteGraphicsContextGL_DrawBuffersEXT";
    case MessageName::RemoteGraphicsContextGL_DrawElements:
        return "RemoteGraphicsContextGL_DrawElements";
    case MessageName::RemoteGraphicsContextGL_DrawElementsInstanced:
        return "RemoteGraphicsContextGL_DrawElementsInstanced";
    case MessageName::RemoteGraphicsContextGL_DrawRangeElements:
        return "RemoteGraphicsContextGL_DrawRangeElements";
    case MessageName::RemoteGraphicsContextGL_Enable:
        return "RemoteGraphicsContextGL_Enable";
    case MessageName::RemoteGraphicsContextGL_EnableVertexAttribArray:
        return "RemoteGraphicsContextGL_EnableVertexAttribArray";
    case MessageName::RemoteGraphicsContextGL_EndQuery:
        return "RemoteGraphicsContextGL_EndQuery";
    case MessageName::RemoteGraphicsContextGL_EndTransformFeedback:
        return "RemoteGraphicsContextGL_EndTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_EnsureExtensionEnabled:
        return "RemoteGraphicsContextGL_EnsureExtensionEnabled";
    case MessageName::RemoteGraphicsContextGL_Finish:
        return "RemoteGraphicsContextGL_Finish";
    case MessageName::RemoteGraphicsContextGL_Flush:
        return "RemoteGraphicsContextGL_Flush";
    case MessageName::RemoteGraphicsContextGL_FramebufferRenderbuffer:
        return "RemoteGraphicsContextGL_FramebufferRenderbuffer";
    case MessageName::RemoteGraphicsContextGL_FramebufferTexture2D:
        return "RemoteGraphicsContextGL_FramebufferTexture2D";
    case MessageName::RemoteGraphicsContextGL_FramebufferTextureLayer:
        return "RemoteGraphicsContextGL_FramebufferTextureLayer";
    case MessageName::RemoteGraphicsContextGL_FrontFace:
        return "RemoteGraphicsContextGL_FrontFace";
    case MessageName::RemoteGraphicsContextGL_GenerateMipmap:
        return "RemoteGraphicsContextGL_GenerateMipmap";
    case MessageName::RemoteGraphicsContextGL_Hint:
        return "RemoteGraphicsContextGL_Hint";
    case MessageName::RemoteGraphicsContextGL_InvalidateFramebuffer:
        return "RemoteGraphicsContextGL_InvalidateFramebuffer";
    case MessageName::RemoteGraphicsContextGL_InvalidateSubFramebuffer:
        return "RemoteGraphicsContextGL_InvalidateSubFramebuffer";
    case MessageName::RemoteGraphicsContextGL_LineWidth:
        return "RemoteGraphicsContextGL_LineWidth";
    case MessageName::RemoteGraphicsContextGL_LinkProgram:
        return "RemoteGraphicsContextGL_LinkProgram";
    case MessageName::RemoteGraphicsContextGL_MarkContextChanged:
        return "RemoteGraphicsContextGL_MarkContextChanged";
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysANGLE:
        return "RemoteGraphicsContextGL_MultiDrawArraysANGLE";
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE:
        return "RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE";
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsANGLE:
        return "RemoteGraphicsContextGL_MultiDrawElementsANGLE";
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE:
        return "RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE";
    case MessageName::RemoteGraphicsContextGL_PauseTransformFeedback:
        return "RemoteGraphicsContextGL_PauseTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_PixelStorei:
        return "RemoteGraphicsContextGL_PixelStorei";
    case MessageName::RemoteGraphicsContextGL_PolygonOffset:
        return "RemoteGraphicsContextGL_PolygonOffset";
    case MessageName::RemoteGraphicsContextGL_ReadBuffer:
        return "RemoteGraphicsContextGL_ReadBuffer";
    case MessageName::RemoteGraphicsContextGL_ReadnPixels1:
        return "RemoteGraphicsContextGL_ReadnPixels1";
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorage:
        return "RemoteGraphicsContextGL_RenderbufferStorage";
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisample:
        return "RemoteGraphicsContextGL_RenderbufferStorageMultisample";
    case MessageName::RemoteGraphicsContextGL_Reshape:
        return "RemoteGraphicsContextGL_Reshape";
    case MessageName::RemoteGraphicsContextGL_ResumeTransformFeedback:
        return "RemoteGraphicsContextGL_ResumeTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_SampleCoverage:
        return "RemoteGraphicsContextGL_SampleCoverage";
    case MessageName::RemoteGraphicsContextGL_SamplerParameterf:
        return "RemoteGraphicsContextGL_SamplerParameterf";
    case MessageName::RemoteGraphicsContextGL_SamplerParameteri:
        return "RemoteGraphicsContextGL_SamplerParameteri";
    case MessageName::RemoteGraphicsContextGL_Scissor:
        return "RemoteGraphicsContextGL_Scissor";
    case MessageName::RemoteGraphicsContextGL_ShaderSource:
        return "RemoteGraphicsContextGL_ShaderSource";
    case MessageName::RemoteGraphicsContextGL_SimulateEventForTesting:
        return "RemoteGraphicsContextGL_SimulateEventForTesting";
    case MessageName::RemoteGraphicsContextGL_StencilFunc:
        return "RemoteGraphicsContextGL_StencilFunc";
    case MessageName::RemoteGraphicsContextGL_StencilFuncSeparate:
        return "RemoteGraphicsContextGL_StencilFuncSeparate";
    case MessageName::RemoteGraphicsContextGL_StencilMask:
        return "RemoteGraphicsContextGL_StencilMask";
    case MessageName::RemoteGraphicsContextGL_StencilMaskSeparate:
        return "RemoteGraphicsContextGL_StencilMaskSeparate";
    case MessageName::RemoteGraphicsContextGL_StencilOp:
        return "RemoteGraphicsContextGL_StencilOp";
    case MessageName::RemoteGraphicsContextGL_StencilOpSeparate:
        return "RemoteGraphicsContextGL_StencilOpSeparate";
    case MessageName::RemoteGraphicsContextGL_SynthesizeGLError:
        return "RemoteGraphicsContextGL_SynthesizeGLError";
    case MessageName::RemoteGraphicsContextGL_TexImage2D0:
        return "RemoteGraphicsContextGL_TexImage2D0";
    case MessageName::RemoteGraphicsContextGL_TexImage2D1:
        return "RemoteGraphicsContextGL_TexImage2D1";
    case MessageName::RemoteGraphicsContextGL_TexImage3D0:
        return "RemoteGraphicsContextGL_TexImage3D0";
    case MessageName::RemoteGraphicsContextGL_TexImage3D1:
        return "RemoteGraphicsContextGL_TexImage3D1";
    case MessageName::RemoteGraphicsContextGL_TexParameterf:
        return "RemoteGraphicsContextGL_TexParameterf";
    case MessageName::RemoteGraphicsContextGL_TexParameteri:
        return "RemoteGraphicsContextGL_TexParameteri";
    case MessageName::RemoteGraphicsContextGL_TexStorage2D:
        return "RemoteGraphicsContextGL_TexStorage2D";
    case MessageName::RemoteGraphicsContextGL_TexStorage3D:
        return "RemoteGraphicsContextGL_TexStorage3D";
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D0:
        return "RemoteGraphicsContextGL_TexSubImage2D0";
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D1:
        return "RemoteGraphicsContextGL_TexSubImage2D1";
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D0:
        return "RemoteGraphicsContextGL_TexSubImage3D0";
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D1:
        return "RemoteGraphicsContextGL_TexSubImage3D1";
    case MessageName::RemoteGraphicsContextGL_TransformFeedbackVaryings:
        return "RemoteGraphicsContextGL_TransformFeedbackVaryings";
    case MessageName::RemoteGraphicsContextGL_Uniform1f:
        return "RemoteGraphicsContextGL_Uniform1f";
    case MessageName::RemoteGraphicsContextGL_Uniform1fv:
        return "RemoteGraphicsContextGL_Uniform1fv";
    case MessageName::RemoteGraphicsContextGL_Uniform1i:
        return "RemoteGraphicsContextGL_Uniform1i";
    case MessageName::RemoteGraphicsContextGL_Uniform1iv:
        return "RemoteGraphicsContextGL_Uniform1iv";
    case MessageName::RemoteGraphicsContextGL_Uniform1ui:
        return "RemoteGraphicsContextGL_Uniform1ui";
    case MessageName::RemoteGraphicsContextGL_Uniform1uiv:
        return "RemoteGraphicsContextGL_Uniform1uiv";
    case MessageName::RemoteGraphicsContextGL_Uniform2f:
        return "RemoteGraphicsContextGL_Uniform2f";
    case MessageName::RemoteGraphicsContextGL_Uniform2fv:
        return "RemoteGraphicsContextGL_Uniform2fv";
    case MessageName::RemoteGraphicsContextGL_Uniform2i:
        return "RemoteGraphicsContextGL_Uniform2i";
    case MessageName::RemoteGraphicsContextGL_Uniform2iv:
        return "RemoteGraphicsContextGL_Uniform2iv";
    case MessageName::RemoteGraphicsContextGL_Uniform2ui:
        return "RemoteGraphicsContextGL_Uniform2ui";
    case MessageName::RemoteGraphicsContextGL_Uniform2uiv:
        return "RemoteGraphicsContextGL_Uniform2uiv";
    case MessageName::RemoteGraphicsContextGL_Uniform3f:
        return "RemoteGraphicsContextGL_Uniform3f";
    case MessageName::RemoteGraphicsContextGL_Uniform3fv:
        return "RemoteGraphicsContextGL_Uniform3fv";
    case MessageName::RemoteGraphicsContextGL_Uniform3i:
        return "RemoteGraphicsContextGL_Uniform3i";
    case MessageName::RemoteGraphicsContextGL_Uniform3iv:
        return "RemoteGraphicsContextGL_Uniform3iv";
    case MessageName::RemoteGraphicsContextGL_Uniform3ui:
        return "RemoteGraphicsContextGL_Uniform3ui";
    case MessageName::RemoteGraphicsContextGL_Uniform3uiv:
        return "RemoteGraphicsContextGL_Uniform3uiv";
    case MessageName::RemoteGraphicsContextGL_Uniform4f:
        return "RemoteGraphicsContextGL_Uniform4f";
    case MessageName::RemoteGraphicsContextGL_Uniform4fv:
        return "RemoteGraphicsContextGL_Uniform4fv";
    case MessageName::RemoteGraphicsContextGL_Uniform4i:
        return "RemoteGraphicsContextGL_Uniform4i";
    case MessageName::RemoteGraphicsContextGL_Uniform4iv:
        return "RemoteGraphicsContextGL_Uniform4iv";
    case MessageName::RemoteGraphicsContextGL_Uniform4ui:
        return "RemoteGraphicsContextGL_Uniform4ui";
    case MessageName::RemoteGraphicsContextGL_Uniform4uiv:
        return "RemoteGraphicsContextGL_Uniform4uiv";
    case MessageName::RemoteGraphicsContextGL_UniformBlockBinding:
        return "RemoteGraphicsContextGL_UniformBlockBinding";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2fv:
        return "RemoteGraphicsContextGL_UniformMatrix2fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x3fv:
        return "RemoteGraphicsContextGL_UniformMatrix2x3fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x4fv:
        return "RemoteGraphicsContextGL_UniformMatrix2x4fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3fv:
        return "RemoteGraphicsContextGL_UniformMatrix3fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x2fv:
        return "RemoteGraphicsContextGL_UniformMatrix3x2fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x4fv:
        return "RemoteGraphicsContextGL_UniformMatrix3x4fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4fv:
        return "RemoteGraphicsContextGL_UniformMatrix4fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x2fv:
        return "RemoteGraphicsContextGL_UniformMatrix4x2fv";
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x3fv:
        return "RemoteGraphicsContextGL_UniformMatrix4x3fv";
    case MessageName::RemoteGraphicsContextGL_UseProgram:
        return "RemoteGraphicsContextGL_UseProgram";
    case MessageName::RemoteGraphicsContextGL_ValidateProgram:
        return "RemoteGraphicsContextGL_ValidateProgram";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1f:
        return "RemoteGraphicsContextGL_VertexAttrib1f";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1fv:
        return "RemoteGraphicsContextGL_VertexAttrib1fv";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2f:
        return "RemoteGraphicsContextGL_VertexAttrib2f";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2fv:
        return "RemoteGraphicsContextGL_VertexAttrib2fv";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3f:
        return "RemoteGraphicsContextGL_VertexAttrib3f";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3fv:
        return "RemoteGraphicsContextGL_VertexAttrib3fv";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4f:
        return "RemoteGraphicsContextGL_VertexAttrib4f";
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4fv:
        return "RemoteGraphicsContextGL_VertexAttrib4fv";
    case MessageName::RemoteGraphicsContextGL_VertexAttribDivisor:
        return "RemoteGraphicsContextGL_VertexAttribDivisor";
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4i:
        return "RemoteGraphicsContextGL_VertexAttribI4i";
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4iv:
        return "RemoteGraphicsContextGL_VertexAttribI4iv";
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4ui:
        return "RemoteGraphicsContextGL_VertexAttribI4ui";
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4uiv:
        return "RemoteGraphicsContextGL_VertexAttribI4uiv";
    case MessageName::RemoteGraphicsContextGL_VertexAttribIPointer:
        return "RemoteGraphicsContextGL_VertexAttribIPointer";
    case MessageName::RemoteGraphicsContextGL_VertexAttribPointer:
        return "RemoteGraphicsContextGL_VertexAttribPointer";
    case MessageName::RemoteGraphicsContextGL_Viewport:
        return "RemoteGraphicsContextGL_Viewport";
    case MessageName::RemoteGraphicsContextGL_WaitSync:
        return "RemoteGraphicsContextGL_WaitSync";
    case MessageName::RemoteLegacyCDMProxy_SetPlayerId:
        return "RemoteLegacyCDMProxy_SetPlayerId";
    case MessageName::RemoteLegacyCDMSessionProxy_ReleaseKeys:
        return "RemoteLegacyCDMSessionProxy_ReleaseKeys";
    case MessageName::RemoteLegacyCDMSession_SendError:
        return "RemoteLegacyCDMSession_SendError";
    case MessageName::RemoteLegacyCDMSession_SendMessage:
        return "RemoteLegacyCDMSession_SendMessage";
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration:
        return "RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration";
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration:
        return "RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration";
    case MessageName::RemoteMediaPlayerManagerProxy_ClearMediaCache:
        return "RemoteMediaPlayerManagerProxy_ClearMediaCache";
    case MessageName::RemoteMediaPlayerManagerProxy_ClearMediaCacheForOrigins:
        return "RemoteMediaPlayerManagerProxy_ClearMediaCacheForOrigins";
    case MessageName::RemoteMediaPlayerManagerProxy_CreateMediaPlayer:
        return "RemoteMediaPlayerManagerProxy_CreateMediaPlayer";
    case MessageName::RemoteMediaPlayerManagerProxy_DeleteMediaPlayer:
        return "RemoteMediaPlayerManagerProxy_DeleteMediaPlayer";
    case MessageName::RemoteMediaPlayerProxy_AcceleratedRenderingStateChanged:
        return "RemoteMediaPlayerProxy_AcceleratedRenderingStateChanged";
    case MessageName::RemoteMediaPlayerProxy_ApplicationDidBecomeActive:
        return "RemoteMediaPlayerProxy_ApplicationDidBecomeActive";
    case MessageName::RemoteMediaPlayerProxy_ApplicationWillResignActive:
        return "RemoteMediaPlayerProxy_ApplicationWillResignActive";
    case MessageName::RemoteMediaPlayerProxy_AttemptToDecryptWithInstance:
        return "RemoteMediaPlayerProxy_AttemptToDecryptWithInstance";
    case MessageName::RemoteMediaPlayerProxy_AudioTrackSetEnabled:
        return "RemoteMediaPlayerProxy_AudioTrackSetEnabled";
    case MessageName::RemoteMediaPlayerProxy_BeginSimulatedHDCPError:
        return "RemoteMediaPlayerProxy_BeginSimulatedHDCPError";
    case MessageName::RemoteMediaPlayerProxy_CancelLoad:
        return "RemoteMediaPlayerProxy_CancelLoad";
    case MessageName::RemoteMediaPlayerProxy_CdmInstanceAttached:
        return "RemoteMediaPlayerProxy_CdmInstanceAttached";
    case MessageName::RemoteMediaPlayerProxy_CdmInstanceDetached:
        return "RemoteMediaPlayerProxy_CdmInstanceDetached";
    case MessageName::RemoteMediaPlayerProxy_CreateAudioSourceProvider:
        return "RemoteMediaPlayerProxy_CreateAudioSourceProvider";
    case MessageName::RemoteMediaPlayerProxy_DidLoadingProgress:
        return "RemoteMediaPlayerProxy_DidLoadingProgress";
    case MessageName::RemoteMediaPlayerProxy_EndSimulatedHDCPError:
        return "RemoteMediaPlayerProxy_EndSimulatedHDCPError";
    case MessageName::RemoteMediaPlayerProxy_KeyAdded:
        return "RemoteMediaPlayerProxy_KeyAdded";
    case MessageName::RemoteMediaPlayerProxy_Load:
        return "RemoteMediaPlayerProxy_Load";
    case MessageName::RemoteMediaPlayerProxy_LoadMediaSource:
        return "RemoteMediaPlayerProxy_LoadMediaSource";
    case MessageName::RemoteMediaPlayerProxy_NotifyActiveSourceBuffersChanged:
        return "RemoteMediaPlayerProxy_NotifyActiveSourceBuffersChanged";
    case MessageName::RemoteMediaPlayerProxy_NotifyTrackModeChanged:
        return "RemoteMediaPlayerProxy_NotifyTrackModeChanged";
    case MessageName::RemoteMediaPlayerProxy_Pause:
        return "RemoteMediaPlayerProxy_Pause";
    case MessageName::RemoteMediaPlayerProxy_PauseAtHostTime:
        return "RemoteMediaPlayerProxy_PauseAtHostTime";
    case MessageName::RemoteMediaPlayerProxy_PerformTaskAtMediaTime:
        return "RemoteMediaPlayerProxy_PerformTaskAtMediaTime";
    case MessageName::RemoteMediaPlayerProxy_Play:
        return "RemoteMediaPlayerProxy_Play";
    case MessageName::RemoteMediaPlayerProxy_PlayAtHostTime:
        return "RemoteMediaPlayerProxy_PlayAtHostTime";
    case MessageName::RemoteMediaPlayerProxy_PrepareForPlayback:
        return "RemoteMediaPlayerProxy_PrepareForPlayback";
    case MessageName::RemoteMediaPlayerProxy_PrepareForRendering:
        return "RemoteMediaPlayerProxy_PrepareForRendering";
    case MessageName::RemoteMediaPlayerProxy_PrepareToPlay:
        return "RemoteMediaPlayerProxy_PrepareToPlay";
    case MessageName::RemoteMediaPlayerProxy_Seek:
        return "RemoteMediaPlayerProxy_Seek";
    case MessageName::RemoteMediaPlayerProxy_SeekWithTolerance:
        return "RemoteMediaPlayerProxy_SeekWithTolerance";
    case MessageName::RemoteMediaPlayerProxy_SetBufferingPolicy:
        return "RemoteMediaPlayerProxy_SetBufferingPolicy";
    case MessageName::RemoteMediaPlayerProxy_SetLegacyCDMSession:
        return "RemoteMediaPlayerProxy_SetLegacyCDMSession";
    case MessageName::RemoteMediaPlayerProxy_SetMuted:
        return "RemoteMediaPlayerProxy_SetMuted";
    case MessageName::RemoteMediaPlayerProxy_SetPageIsVisible:
        return "RemoteMediaPlayerProxy_SetPageIsVisible";
    case MessageName::RemoteMediaPlayerProxy_SetPitchCorrectionAlgorithm:
        return "RemoteMediaPlayerProxy_SetPitchCorrectionAlgorithm";
    case MessageName::RemoteMediaPlayerProxy_SetPreferredDynamicRangeMode:
        return "RemoteMediaPlayerProxy_SetPreferredDynamicRangeMode";
    case MessageName::RemoteMediaPlayerProxy_SetPreload:
        return "RemoteMediaPlayerProxy_SetPreload";
    case MessageName::RemoteMediaPlayerProxy_SetPreservesPitch:
        return "RemoteMediaPlayerProxy_SetPreservesPitch";
    case MessageName::RemoteMediaPlayerProxy_SetPrivateBrowsingMode:
        return "RemoteMediaPlayerProxy_SetPrivateBrowsingMode";
    case MessageName::RemoteMediaPlayerProxy_SetRate:
        return "RemoteMediaPlayerProxy_SetRate";
    case MessageName::RemoteMediaPlayerProxy_SetShouldContinueAfterKeyNeeded:
        return "RemoteMediaPlayerProxy_SetShouldContinueAfterKeyNeeded";
    case MessageName::RemoteMediaPlayerProxy_SetShouldDisableSleep:
        return "RemoteMediaPlayerProxy_SetShouldDisableSleep";
    case MessageName::RemoteMediaPlayerProxy_SetShouldEnableAudioSourceProvider:
        return "RemoteMediaPlayerProxy_SetShouldEnableAudioSourceProvider";
    case MessageName::RemoteMediaPlayerProxy_SetShouldMaintainAspectRatio:
        return "RemoteMediaPlayerProxy_SetShouldMaintainAspectRatio";
    case MessageName::RemoteMediaPlayerProxy_SetShouldPlayToPlaybackTarget:
        return "RemoteMediaPlayerProxy_SetShouldPlayToPlaybackTarget";
    case MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenGravity:
        return "RemoteMediaPlayerProxy_SetVideoFullscreenGravity";
    case MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenMode:
        return "RemoteMediaPlayerProxy_SetVideoFullscreenMode";
    case MessageName::RemoteMediaPlayerProxy_SetVideoInlineSizeFenced:
        return "RemoteMediaPlayerProxy_SetVideoInlineSizeFenced";
    case MessageName::RemoteMediaPlayerProxy_SetVideoPlaybackMetricsUpdateInterval:
        return "RemoteMediaPlayerProxy_SetVideoPlaybackMetricsUpdateInterval";
    case MessageName::RemoteMediaPlayerProxy_SetVolume:
        return "RemoteMediaPlayerProxy_SetVolume";
    case MessageName::RemoteMediaPlayerProxy_SetWirelessPlaybackTarget:
        return "RemoteMediaPlayerProxy_SetWirelessPlaybackTarget";
    case MessageName::RemoteMediaPlayerProxy_SetWirelessVideoPlaybackDisabled:
        return "RemoteMediaPlayerProxy_SetWirelessVideoPlaybackDisabled";
    case MessageName::RemoteMediaPlayerProxy_StartVideoFrameMetadataGathering:
        return "RemoteMediaPlayerProxy_StartVideoFrameMetadataGathering";
    case MessageName::RemoteMediaPlayerProxy_StopVideoFrameMetadataGathering:
        return "RemoteMediaPlayerProxy_StopVideoFrameMetadataGathering";
    case MessageName::RemoteMediaPlayerProxy_TextTrackSetMode:
        return "RemoteMediaPlayerProxy_TextTrackSetMode";
    case MessageName::RemoteMediaPlayerProxy_TracksChanged:
        return "RemoteMediaPlayerProxy_TracksChanged";
    case MessageName::RemoteMediaPlayerProxy_UpdateVideoFullscreenInlineImage:
        return "RemoteMediaPlayerProxy_UpdateVideoFullscreenInlineImage";
    case MessageName::RemoteMediaPlayerProxy_VideoFullscreenStandbyChanged:
        return "RemoteMediaPlayerProxy_VideoFullscreenStandbyChanged";
    case MessageName::RemoteMediaPlayerProxy_VideoTrackSetSelected:
        return "RemoteMediaPlayerProxy_VideoTrackSetSelected";
    case MessageName::RemoteMediaRecorderManager_CreateRecorder:
        return "RemoteMediaRecorderManager_CreateRecorder";
    case MessageName::RemoteMediaRecorderManager_ReleaseRecorder:
        return "RemoteMediaRecorderManager_ReleaseRecorder";
    case MessageName::RemoteMediaRecorder_AudioSamplesAvailable:
        return "RemoteMediaRecorder_AudioSamplesAvailable";
    case MessageName::RemoteMediaRecorder_AudioSamplesStorageChanged:
        return "RemoteMediaRecorder_AudioSamplesStorageChanged";
    case MessageName::RemoteMediaRecorder_FetchData:
        return "RemoteMediaRecorder_FetchData";
    case MessageName::RemoteMediaRecorder_Pause:
        return "RemoteMediaRecorder_Pause";
    case MessageName::RemoteMediaRecorder_Resume:
        return "RemoteMediaRecorder_Resume";
    case MessageName::RemoteMediaRecorder_SetSharedVideoFrameMemory:
        return "RemoteMediaRecorder_SetSharedVideoFrameMemory";
    case MessageName::RemoteMediaRecorder_SetSharedVideoFrameSemaphore:
        return "RemoteMediaRecorder_SetSharedVideoFrameSemaphore";
    case MessageName::RemoteMediaRecorder_StopRecording:
        return "RemoteMediaRecorder_StopRecording";
    case MessageName::RemoteMediaRecorder_VideoSampleAvailable:
        return "RemoteMediaRecorder_VideoSampleAvailable";
    case MessageName::RemoteMediaResourceManager_AccessControlCheckFailed:
        return "RemoteMediaResourceManager_AccessControlCheckFailed";
    case MessageName::RemoteMediaResourceManager_DataReceived:
        return "RemoteMediaResourceManager_DataReceived";
    case MessageName::RemoteMediaResourceManager_DataSent:
        return "RemoteMediaResourceManager_DataSent";
    case MessageName::RemoteMediaResourceManager_LoadFailed:
        return "RemoteMediaResourceManager_LoadFailed";
    case MessageName::RemoteMediaResourceManager_LoadFinished:
        return "RemoteMediaResourceManager_LoadFinished";
    case MessageName::RemoteMediaResourceManager_RedirectReceived:
        return "RemoteMediaResourceManager_RedirectReceived";
    case MessageName::RemoteMediaResourceManager_ResponseReceived:
        return "RemoteMediaResourceManager_ResponseReceived";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause:
        return "RemoteMediaSessionCoordinatorProxy_CoordinatePause";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay:
        return "RemoteMediaSessionCoordinatorProxy_CoordinatePlay";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo:
        return "RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack:
        return "RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack";
    case MessageName::RemoteMediaSessionCoordinatorProxy_Join:
        return "RemoteMediaSessionCoordinatorProxy_Join";
    case MessageName::RemoteMediaSessionCoordinatorProxy_Leave:
        return "RemoteMediaSessionCoordinatorProxy_Leave";
    case MessageName::RemoteMediaSessionCoordinatorProxy_PlaybackStateChanged:
        return "RemoteMediaSessionCoordinatorProxy_PlaybackStateChanged";
    case MessageName::RemoteMediaSessionCoordinatorProxy_PositionStateChanged:
        return "RemoteMediaSessionCoordinatorProxy_PositionStateChanged";
    case MessageName::RemoteMediaSessionCoordinatorProxy_ReadyStateChanged:
        return "RemoteMediaSessionCoordinatorProxy_ReadyStateChanged";
    case MessageName::RemoteMediaSessionCoordinatorProxy_TrackIdentifierChanged:
        return "RemoteMediaSessionCoordinatorProxy_TrackIdentifierChanged";
    case MessageName::RemoteMediaSessionCoordinator_CoordinatorStateChanged:
        return "RemoteMediaSessionCoordinator_CoordinatorStateChanged";
    case MessageName::RemoteMediaSessionCoordinator_PauseSession:
        return "RemoteMediaSessionCoordinator_PauseSession";
    case MessageName::RemoteMediaSessionCoordinator_PlaySession:
        return "RemoteMediaSessionCoordinator_PlaySession";
    case MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime:
        return "RemoteMediaSessionCoordinator_SeekSessionToTime";
    case MessageName::RemoteMediaSessionCoordinator_SetSessionTrack:
        return "RemoteMediaSessionCoordinator_SetSessionTrack";
    case MessageName::RemoteMediaSourceProxy_BufferedChanged:
        return "RemoteMediaSourceProxy_BufferedChanged";
    case MessageName::RemoteMediaSourceProxy_DurationChanged:
        return "RemoteMediaSourceProxy_DurationChanged";
    case MessageName::RemoteMediaSourceProxy_SeekCompleted:
        return "RemoteMediaSourceProxy_SeekCompleted";
    case MessageName::RemoteMediaSourceProxy_SetIsSeeking:
        return "RemoteMediaSourceProxy_SetIsSeeking";
    case MessageName::RemoteMediaSourceProxy_SetReadyState:
        return "RemoteMediaSourceProxy_SetReadyState";
    case MessageName::RemoteMediaSourceProxy_SetTimeFudgeFactor:
        return "RemoteMediaSourceProxy_SetTimeFudgeFactor";
    case MessageName::RemoteMediaSourceProxy_WaitForSeekCompleted:
        return "RemoteMediaSourceProxy_WaitForSeekCompleted";
    case MessageName::RemotePipelineLayout_SetLabel:
        return "RemotePipelineLayout_SetLabel";
    case MessageName::RemoteQuerySet_Destroy:
        return "RemoteQuerySet_Destroy";
    case MessageName::RemoteQuerySet_SetLabel:
        return "RemoteQuerySet_SetLabel";
    case MessageName::RemoteQueue_CopyExternalImageToTexture:
        return "RemoteQueue_CopyExternalImageToTexture";
    case MessageName::RemoteQueue_SetLabel:
        return "RemoteQueue_SetLabel";
    case MessageName::RemoteQueue_Submit:
        return "RemoteQueue_Submit";
    case MessageName::RemoteQueue_WriteBuffer:
        return "RemoteQueue_WriteBuffer";
    case MessageName::RemoteQueue_WriteTexture:
        return "RemoteQueue_WriteTexture";
    case MessageName::RemoteRemoteCommandListenerProxy_UpdateSupportedCommands:
        return "RemoteRemoteCommandListenerProxy_UpdateSupportedCommands";
    case MessageName::RemoteRemoteCommandListener_DidReceiveRemoteControlCommand:
        return "RemoteRemoteCommandListener_DidReceiveRemoteControlCommand";
    case MessageName::RemoteRenderBundleEncoder_Draw:
        return "RemoteRenderBundleEncoder_Draw";
    case MessageName::RemoteRenderBundleEncoder_DrawIndexed:
        return "RemoteRenderBundleEncoder_DrawIndexed";
    case MessageName::RemoteRenderBundleEncoder_DrawIndexedIndirect:
        return "RemoteRenderBundleEncoder_DrawIndexedIndirect";
    case MessageName::RemoteRenderBundleEncoder_DrawIndirect:
        return "RemoteRenderBundleEncoder_DrawIndirect";
    case MessageName::RemoteRenderBundleEncoder_Finish:
        return "RemoteRenderBundleEncoder_Finish";
    case MessageName::RemoteRenderBundleEncoder_InsertDebugMarker:
        return "RemoteRenderBundleEncoder_InsertDebugMarker";
    case MessageName::RemoteRenderBundleEncoder_PopDebugGroup:
        return "RemoteRenderBundleEncoder_PopDebugGroup";
    case MessageName::RemoteRenderBundleEncoder_PushDebugGroup:
        return "RemoteRenderBundleEncoder_PushDebugGroup";
    case MessageName::RemoteRenderBundleEncoder_SetBindGroup:
        return "RemoteRenderBundleEncoder_SetBindGroup";
    case MessageName::RemoteRenderBundleEncoder_SetIndexBuffer:
        return "RemoteRenderBundleEncoder_SetIndexBuffer";
    case MessageName::RemoteRenderBundleEncoder_SetLabel:
        return "RemoteRenderBundleEncoder_SetLabel";
    case MessageName::RemoteRenderBundleEncoder_SetPipeline:
        return "RemoteRenderBundleEncoder_SetPipeline";
    case MessageName::RemoteRenderBundleEncoder_SetVertexBuffer:
        return "RemoteRenderBundleEncoder_SetVertexBuffer";
    case MessageName::RemoteRenderBundle_SetLabel:
        return "RemoteRenderBundle_SetLabel";
    case MessageName::RemoteRenderPassEncoder_BeginOcclusionQuery:
        return "RemoteRenderPassEncoder_BeginOcclusionQuery";
    case MessageName::RemoteRenderPassEncoder_Draw:
        return "RemoteRenderPassEncoder_Draw";
    case MessageName::RemoteRenderPassEncoder_DrawIndexed:
        return "RemoteRenderPassEncoder_DrawIndexed";
    case MessageName::RemoteRenderPassEncoder_DrawIndexedIndirect:
        return "RemoteRenderPassEncoder_DrawIndexedIndirect";
    case MessageName::RemoteRenderPassEncoder_DrawIndirect:
        return "RemoteRenderPassEncoder_DrawIndirect";
    case MessageName::RemoteRenderPassEncoder_End:
        return "RemoteRenderPassEncoder_End";
    case MessageName::RemoteRenderPassEncoder_EndOcclusionQuery:
        return "RemoteRenderPassEncoder_EndOcclusionQuery";
    case MessageName::RemoteRenderPassEncoder_ExecuteBundles:
        return "RemoteRenderPassEncoder_ExecuteBundles";
    case MessageName::RemoteRenderPassEncoder_InsertDebugMarker:
        return "RemoteRenderPassEncoder_InsertDebugMarker";
    case MessageName::RemoteRenderPassEncoder_PopDebugGroup:
        return "RemoteRenderPassEncoder_PopDebugGroup";
    case MessageName::RemoteRenderPassEncoder_PushDebugGroup:
        return "RemoteRenderPassEncoder_PushDebugGroup";
    case MessageName::RemoteRenderPassEncoder_SetBindGroup:
        return "RemoteRenderPassEncoder_SetBindGroup";
    case MessageName::RemoteRenderPassEncoder_SetBlendConstant:
        return "RemoteRenderPassEncoder_SetBlendConstant";
    case MessageName::RemoteRenderPassEncoder_SetIndexBuffer:
        return "RemoteRenderPassEncoder_SetIndexBuffer";
    case MessageName::RemoteRenderPassEncoder_SetLabel:
        return "RemoteRenderPassEncoder_SetLabel";
    case MessageName::RemoteRenderPassEncoder_SetPipeline:
        return "RemoteRenderPassEncoder_SetPipeline";
    case MessageName::RemoteRenderPassEncoder_SetScissorRect:
        return "RemoteRenderPassEncoder_SetScissorRect";
    case MessageName::RemoteRenderPassEncoder_SetStencilReference:
        return "RemoteRenderPassEncoder_SetStencilReference";
    case MessageName::RemoteRenderPassEncoder_SetVertexBuffer:
        return "RemoteRenderPassEncoder_SetVertexBuffer";
    case MessageName::RemoteRenderPassEncoder_SetViewport:
        return "RemoteRenderPassEncoder_SetViewport";
    case MessageName::RemoteRenderPipeline_GetBindGroupLayout:
        return "RemoteRenderPipeline_GetBindGroupLayout";
    case MessageName::RemoteRenderPipeline_SetLabel:
        return "RemoteRenderPipeline_SetLabel";
    case MessageName::RemoteRenderingBackendProxy_DidCreateImageBufferBackend:
        return "RemoteRenderingBackendProxy_DidCreateImageBufferBackend";
    case MessageName::RemoteRenderingBackendProxy_DidCreateWakeUpSemaphoreForDisplayListStream:
        return "RemoteRenderingBackendProxy_DidCreateWakeUpSemaphoreForDisplayListStream";
    case MessageName::RemoteRenderingBackendProxy_DidFinalizeRenderingUpdate:
        return "RemoteRenderingBackendProxy_DidFinalizeRenderingUpdate";
    case MessageName::RemoteRenderingBackendProxy_DidFlush:
        return "RemoteRenderingBackendProxy_DidFlush";
    case MessageName::RemoteRenderingBackend_CacheFont:
        return "RemoteRenderingBackend_CacheFont";
    case MessageName::RemoteRenderingBackend_CacheNativeImage:
        return "RemoteRenderingBackend_CacheNativeImage";
    case MessageName::RemoteRenderingBackend_CreateImageBuffer:
        return "RemoteRenderingBackend_CreateImageBuffer";
    case MessageName::RemoteRenderingBackend_DeleteAllFonts:
        return "RemoteRenderingBackend_DeleteAllFonts";
    case MessageName::RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory:
        return "RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory";
    case MessageName::RemoteRenderingBackend_FinalizeRenderingUpdate:
        return "RemoteRenderingBackend_FinalizeRenderingUpdate";
    case MessageName::RemoteRenderingBackend_PutPixelBufferForImageBuffer:
        return "RemoteRenderingBackend_PutPixelBufferForImageBuffer";
    case MessageName::RemoteRenderingBackend_ReleaseRemoteResource:
        return "RemoteRenderingBackend_ReleaseRemoteResource";
    case MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer:
        return "RemoteSampleBufferDisplayLayerManager_CreateLayer";
    case MessageName::RemoteSampleBufferDisplayLayerManager_ReleaseLayer:
        return "RemoteSampleBufferDisplayLayerManager_ReleaseLayer";
    case MessageName::RemoteSampleBufferDisplayLayer_ClearEnqueuedSamples:
        return "RemoteSampleBufferDisplayLayer_ClearEnqueuedSamples";
    case MessageName::RemoteSampleBufferDisplayLayer_EnqueueSample:
        return "RemoteSampleBufferDisplayLayer_EnqueueSample";
    case MessageName::RemoteSampleBufferDisplayLayer_EnqueueSampleCV:
        return "RemoteSampleBufferDisplayLayer_EnqueueSampleCV";
    case MessageName::RemoteSampleBufferDisplayLayer_Flush:
        return "RemoteSampleBufferDisplayLayer_Flush";
    case MessageName::RemoteSampleBufferDisplayLayer_FlushAndRemoveImage:
        return "RemoteSampleBufferDisplayLayer_FlushAndRemoveImage";
    case MessageName::RemoteSampleBufferDisplayLayer_Pause:
        return "RemoteSampleBufferDisplayLayer_Pause";
    case MessageName::RemoteSampleBufferDisplayLayer_Play:
        return "RemoteSampleBufferDisplayLayer_Play";
    case MessageName::RemoteSampleBufferDisplayLayer_SetLogIdentifier:
        return "RemoteSampleBufferDisplayLayer_SetLogIdentifier";
    case MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameMemory:
        return "RemoteSampleBufferDisplayLayer_SetSharedVideoFrameMemory";
    case MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameSemaphore:
        return "RemoteSampleBufferDisplayLayer_SetSharedVideoFrameSemaphore";
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateAffineTransform:
        return "RemoteSampleBufferDisplayLayer_UpdateAffineTransform";
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateBoundsAndPosition:
        return "RemoteSampleBufferDisplayLayer_UpdateBoundsAndPosition";
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateDisplayMode:
        return "RemoteSampleBufferDisplayLayer_UpdateDisplayMode";
    case MessageName::RemoteSampler_SetLabel:
        return "RemoteSampler_SetLabel";
    case MessageName::RemoteShaderModule_SetLabel:
        return "RemoteShaderModule_SetLabel";
    case MessageName::RemoteSourceBufferProxy_Abort:
        return "RemoteSourceBufferProxy_Abort";
    case MessageName::RemoteSourceBufferProxy_AddTrackBuffer:
        return "RemoteSourceBufferProxy_AddTrackBuffer";
    case MessageName::RemoteSourceBufferProxy_Append:
        return "RemoteSourceBufferProxy_Append";
    case MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId:
        return "RemoteSourceBufferProxy_BufferedSamplesForTrackId";
    case MessageName::RemoteSourceBufferProxy_ClearTrackBuffers:
        return "RemoteSourceBufferProxy_ClearTrackBuffers";
    case MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID:
        return "RemoteSourceBufferProxy_EnqueuedSamplesForTrackID";
    case MessageName::RemoteSourceBufferProxy_ReenqueueMediaIfNeeded:
        return "RemoteSourceBufferProxy_ReenqueueMediaIfNeeded";
    case MessageName::RemoteSourceBufferProxy_RemoveCodedFrames:
        return "RemoteSourceBufferProxy_RemoveCodedFrames";
    case MessageName::RemoteSourceBufferProxy_RemovedFromMediaSource:
        return "RemoteSourceBufferProxy_RemovedFromMediaSource";
    case MessageName::RemoteSourceBufferProxy_ResetParserState:
        return "RemoteSourceBufferProxy_ResetParserState";
    case MessageName::RemoteSourceBufferProxy_ResetTimestampOffsetInTrackBuffers:
        return "RemoteSourceBufferProxy_ResetTimestampOffsetInTrackBuffers";
    case MessageName::RemoteSourceBufferProxy_ResetTrackBuffers:
        return "RemoteSourceBufferProxy_ResetTrackBuffers";
    case MessageName::RemoteSourceBufferProxy_SeekToTime:
        return "RemoteSourceBufferProxy_SeekToTime";
    case MessageName::RemoteSourceBufferProxy_SetActive:
        return "RemoteSourceBufferProxy_SetActive";
    case MessageName::RemoteSourceBufferProxy_SetAllTrackBuffersNeedRandomAccess:
        return "RemoteSourceBufferProxy_SetAllTrackBuffersNeedRandomAccess";
    case MessageName::RemoteSourceBufferProxy_SetAppendWindowEnd:
        return "RemoteSourceBufferProxy_SetAppendWindowEnd";
    case MessageName::RemoteSourceBufferProxy_SetAppendWindowStart:
        return "RemoteSourceBufferProxy_SetAppendWindowStart";
    case MessageName::RemoteSourceBufferProxy_SetGroupStartTimestamp:
        return "RemoteSourceBufferProxy_SetGroupStartTimestamp";
    case MessageName::RemoteSourceBufferProxy_SetGroupStartTimestampToEndTimestamp:
        return "RemoteSourceBufferProxy_SetGroupStartTimestampToEndTimestamp";
    case MessageName::RemoteSourceBufferProxy_SetMediaSourceEnded:
        return "RemoteSourceBufferProxy_SetMediaSourceEnded";
    case MessageName::RemoteSourceBufferProxy_SetMode:
        return "RemoteSourceBufferProxy_SetMode";
    case MessageName::RemoteSourceBufferProxy_SetReadyState:
        return "RemoteSourceBufferProxy_SetReadyState";
    case MessageName::RemoteSourceBufferProxy_SetShouldGenerateTimestamps:
        return "RemoteSourceBufferProxy_SetShouldGenerateTimestamps";
    case MessageName::RemoteSourceBufferProxy_SetTimestampOffset:
        return "RemoteSourceBufferProxy_SetTimestampOffset";
    case MessageName::RemoteSourceBufferProxy_StartChangingType:
        return "RemoteSourceBufferProxy_StartChangingType";
    case MessageName::RemoteSourceBufferProxy_UpdateTrackIds:
        return "RemoteSourceBufferProxy_UpdateTrackIds";
    case MessageName::RemoteTextureView_SetLabel:
        return "RemoteTextureView_SetLabel";
    case MessageName::RemoteTexture_CreateView:
        return "RemoteTexture_CreateView";
    case MessageName::RemoteTexture_Destroy:
        return "RemoteTexture_Destroy";
    case MessageName::RemoteTexture_SetLabel:
        return "RemoteTexture_SetLabel";
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewVideoFrameBuffer:
        return "RemoteVideoFrameObjectHeapProxyProcessor_NewVideoFrameBuffer";
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameMemory:
        return "RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameMemory";
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameSemaphore:
        return "RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameSemaphore";
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_VideoFrameBufferNotFound:
        return "RemoteVideoFrameObjectHeapProxyProcessor_VideoFrameBufferNotFound";
    case MessageName::RemoteVideoFrameObjectHeap_GetVideoFrameBuffer:
        return "RemoteVideoFrameObjectHeap_GetVideoFrameBuffer";
    case MessageName::RemoteVideoFrameObjectHeap_ReleaseVideoFrame:
        return "RemoteVideoFrameObjectHeap_ReleaseVideoFrame";
    case MessageName::RemoteWebInspectorUIProxy_Append:
        return "RemoteWebInspectorUIProxy_Append";
    case MessageName::RemoteWebInspectorUIProxy_BringToFront:
        return "RemoteWebInspectorUIProxy_BringToFront";
    case MessageName::RemoteWebInspectorUIProxy_FrontendDidClose:
        return "RemoteWebInspectorUIProxy_FrontendDidClose";
    case MessageName::RemoteWebInspectorUIProxy_FrontendLoaded:
        return "RemoteWebInspectorUIProxy_FrontendLoaded";
    case MessageName::RemoteWebInspectorUIProxy_OpenURLExternally:
        return "RemoteWebInspectorUIProxy_OpenURLExternally";
    case MessageName::RemoteWebInspectorUIProxy_Reopen:
        return "RemoteWebInspectorUIProxy_Reopen";
    case MessageName::RemoteWebInspectorUIProxy_ResetState:
        return "RemoteWebInspectorUIProxy_ResetState";
    case MessageName::RemoteWebInspectorUIProxy_Save:
        return "RemoteWebInspectorUIProxy_Save";
    case MessageName::RemoteWebInspectorUIProxy_SendMessageToBackend:
        return "RemoteWebInspectorUIProxy_SendMessageToBackend";
    case MessageName::RemoteWebInspectorUIProxy_SetForcedAppearance:
        return "RemoteWebInspectorUIProxy_SetForcedAppearance";
    case MessageName::RemoteWebInspectorUIProxy_SetSheetRect:
        return "RemoteWebInspectorUIProxy_SetSheetRect";
    case MessageName::RemoteWebInspectorUIProxy_ShowCertificate:
        return "RemoteWebInspectorUIProxy_ShowCertificate";
    case MessageName::RemoteWebInspectorUIProxy_StartWindowDrag:
        return "RemoteWebInspectorUIProxy_StartWindowDrag";
    case MessageName::RemoteWebInspectorUI_DidAppend:
        return "RemoteWebInspectorUI_DidAppend";
    case MessageName::RemoteWebInspectorUI_DidSave:
        return "RemoteWebInspectorUI_DidSave";
    case MessageName::RemoteWebInspectorUI_Initialize:
        return "RemoteWebInspectorUI_Initialize";
    case MessageName::RemoteWebInspectorUI_SendMessageToFrontend:
        return "RemoteWebInspectorUI_SendMessageToFrontend";
    case MessageName::RemoteWebInspectorUI_SetDiagnosticLoggingAvailable:
        return "RemoteWebInspectorUI_SetDiagnosticLoggingAvailable";
    case MessageName::RemoteWebInspectorUI_ShowConsole:
        return "RemoteWebInspectorUI_ShowConsole";
    case MessageName::RemoteWebInspectorUI_ShowResources:
        return "RemoteWebInspectorUI_ShowResources";
    case MessageName::RemoteWebInspectorUI_UpdateFindString:
        return "RemoteWebInspectorUI_UpdateFindString";
    case MessageName::RemoteWebLockRegistry_DidCompleteLockRequest:
        return "RemoteWebLockRegistry_DidCompleteLockRequest";
    case MessageName::RemoteWebLockRegistry_DidStealLock:
        return "RemoteWebLockRegistry_DidStealLock";
    case MessageName::SampleBufferDisplayLayer_SetDidFail:
        return "SampleBufferDisplayLayer_SetDidFail";
    case MessageName::ServiceWorkerDownloadTask_DidFail:
        return "ServiceWorkerDownloadTask_DidFail";
    case MessageName::ServiceWorkerDownloadTask_DidFinish:
        return "ServiceWorkerDownloadTask_DidFinish";
    case MessageName::ServiceWorkerDownloadTask_DidReceiveData:
        return "ServiceWorkerDownloadTask_DidReceiveData";
    case MessageName::ServiceWorkerDownloadTask_DidReceiveFormData:
        return "ServiceWorkerDownloadTask_DidReceiveFormData";
    case MessageName::ServiceWorkerFetchTask_DidFail:
        return "ServiceWorkerFetchTask_DidFail";
    case MessageName::ServiceWorkerFetchTask_DidFinish:
        return "ServiceWorkerFetchTask_DidFinish";
    case MessageName::ServiceWorkerFetchTask_DidNotHandle:
        return "ServiceWorkerFetchTask_DidNotHandle";
    case MessageName::ServiceWorkerFetchTask_DidReceiveData:
        return "ServiceWorkerFetchTask_DidReceiveData";
    case MessageName::ServiceWorkerFetchTask_DidReceiveFormData:
        return "ServiceWorkerFetchTask_DidReceiveFormData";
    case MessageName::ServiceWorkerFetchTask_DidReceiveRedirectResponse:
        return "ServiceWorkerFetchTask_DidReceiveRedirectResponse";
    case MessageName::ServiceWorkerFetchTask_DidReceiveResponse:
        return "ServiceWorkerFetchTask_DidReceiveResponse";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateAppendComplete:
        return "SourceBufferPrivateRemote_SourceBufferPrivateAppendComplete";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateAppendError:
        return "SourceBufferPrivateRemote_SourceBufferPrivateAppendError";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateBufferedDirtyChanged:
        return "SourceBufferPrivateRemote_SourceBufferPrivateBufferedDirtyChanged";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidDropSample:
        return "SourceBufferPrivateRemote_SourceBufferPrivateDidDropSample";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidParseSample:
        return "SourceBufferPrivateRemote_SourceBufferPrivateDidParseSample";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegment:
        return "SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegment";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveRenderingError:
        return "SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveRenderingError";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDurationChanged:
        return "SourceBufferPrivateRemote_SourceBufferPrivateDurationChanged";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateHighestPresentationTimestampChanged:
        return "SourceBufferPrivateRemote_SourceBufferPrivateHighestPresentationTimestampChanged";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateReportExtraMemoryCost:
        return "SourceBufferPrivateRemote_SourceBufferPrivateReportExtraMemoryCost";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateStreamEndedWithDecodeError:
        return "SourceBufferPrivateRemote_SourceBufferPrivateStreamEndedWithDecodeError";
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_CreateSource:
        return "SpeechRecognitionRealtimeMediaSourceManager_CreateSource";
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_DeleteSource:
        return "SpeechRecognitionRealtimeMediaSourceManager_DeleteSource";
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_GrantSandboxExtensions:
        return "SpeechRecognitionRealtimeMediaSourceManager_GrantSandboxExtensions";
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_RevokeSandboxExtensions:
        return "SpeechRecognitionRealtimeMediaSourceManager_RevokeSandboxExtensions";
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_Start:
        return "SpeechRecognitionRealtimeMediaSourceManager_Start";
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_Stop:
        return "SpeechRecognitionRealtimeMediaSourceManager_Stop";
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteAudioSamplesAvailable:
        return "SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteAudioSamplesAvailable";
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteCaptureFailed:
        return "SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteCaptureFailed";
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteSourceStopped:
        return "SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteSourceStopped";
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_SetStorage:
        return "SpeechRecognitionRemoteRealtimeMediaSourceManager_SetStorage";
    case MessageName::SpeechRecognitionServer_Abort:
        return "SpeechRecognitionServer_Abort";
    case MessageName::SpeechRecognitionServer_Invalidate:
        return "SpeechRecognitionServer_Invalidate";
    case MessageName::SpeechRecognitionServer_Start:
        return "SpeechRecognitionServer_Start";
    case MessageName::SpeechRecognitionServer_Stop:
        return "SpeechRecognitionServer_Stop";
    case MessageName::StorageAreaMap_ClearCache:
        return "StorageAreaMap_ClearCache";
    case MessageName::StorageAreaMap_DispatchStorageEvent:
        return "StorageAreaMap_DispatchStorageEvent";
    case MessageName::StorageManagerSet_Clear:
        return "StorageManagerSet_Clear";
    case MessageName::StorageManagerSet_CloneSessionStorageNamespace:
        return "StorageManagerSet_CloneSessionStorageNamespace";
    case MessageName::StorageManagerSet_DisconnectFromStorageArea:
        return "StorageManagerSet_DisconnectFromStorageArea";
    case MessageName::StorageManagerSet_RemoveItem:
        return "StorageManagerSet_RemoveItem";
    case MessageName::StorageManagerSet_SetItem:
        return "StorageManagerSet_SetItem";
    case MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture:
        return "ViewGestureController_DidCollectGeometryForMagnificationGesture";
    case MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture:
        return "ViewGestureController_DidCollectGeometryForSmartMagnificationGesture";
    case MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold:
        return "ViewGestureController_DidHitRenderTreeSizeThreshold";
    case MessageName::ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture:
        return "ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture";
    case MessageName::ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture:
        return "ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture";
    case MessageName::ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold:
        return "ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold";
    case MessageName::VisitedLinkStore_AddVisitedLinkHashFromPage:
        return "VisitedLinkStore_AddVisitedLinkHashFromPage";
    case MessageName::VisitedLinkTableController_AllVisitedLinkStateChanged:
        return "VisitedLinkTableController_AllVisitedLinkStateChanged";
    case MessageName::VisitedLinkTableController_RemoveAllVisitedLinks:
        return "VisitedLinkTableController_RemoveAllVisitedLinks";
    case MessageName::VisitedLinkTableController_SetVisitedLinkTable:
        return "VisitedLinkTableController_SetVisitedLinkTable";
    case MessageName::VisitedLinkTableController_VisitedLinkStateChanged:
        return "VisitedLinkTableController_VisitedLinkStateChanged";
    case MessageName::WebAutomationSessionProxy_ComputeElementLayout:
        return "WebAutomationSessionProxy_ComputeElementLayout";
    case MessageName::WebAutomationSessionProxy_DeleteCookie:
        return "WebAutomationSessionProxy_DeleteCookie";
    case MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction:
        return "WebAutomationSessionProxy_EvaluateJavaScriptFunction";
    case MessageName::WebAutomationSessionProxy_GetCookiesForFrame:
        return "WebAutomationSessionProxy_GetCookiesForFrame";
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName:
        return "WebAutomationSessionProxy_ResolveChildFrameWithName";
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle:
        return "WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle";
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal:
        return "WebAutomationSessionProxy_ResolveChildFrameWithOrdinal";
    case MessageName::WebAutomationSessionProxy_ResolveParentFrame:
        return "WebAutomationSessionProxy_ResolveParentFrame";
    case MessageName::WebAutomationSessionProxy_SelectOptionElement:
        return "WebAutomationSessionProxy_SelectOptionElement";
    case MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload:
        return "WebAutomationSessionProxy_SetFilesForInputFileUpload";
    case MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot:
        return "WebAutomationSessionProxy_SnapshotRectForScreenshot";
    case MessageName::WebAutomationSessionProxy_TakeScreenshot:
        return "WebAutomationSessionProxy_TakeScreenshot";
    case MessageName::WebAutomationSession_DidEvaluateJavaScriptFunction:
        return "WebAutomationSession_DidEvaluateJavaScriptFunction";
    case MessageName::WebAutomationSession_DidTakeScreenshot:
        return "WebAutomationSession_DidTakeScreenshot";
    case MessageName::WebBroadcastChannelRegistry_PostMessageToRemote:
        return "WebBroadcastChannelRegistry_PostMessageToRemote";
    case MessageName::WebConnection_HandleMessage:
        return "WebConnection_HandleMessage";
    case MessageName::WebCookieManagerProxy_CookiesDidChange:
        return "WebCookieManagerProxy_CookiesDidChange";
    case MessageName::WebCookieManager_DeleteAllCookies:
        return "WebCookieManager_DeleteAllCookies";
    case MessageName::WebCookieManager_DeleteAllCookiesModifiedSince:
        return "WebCookieManager_DeleteAllCookiesModifiedSince";
    case MessageName::WebCookieManager_DeleteCookie:
        return "WebCookieManager_DeleteCookie";
    case MessageName::WebCookieManager_DeleteCookiesForHostnames:
        return "WebCookieManager_DeleteCookiesForHostnames";
    case MessageName::WebCookieManager_GetAllCookies:
        return "WebCookieManager_GetAllCookies";
    case MessageName::WebCookieManager_GetCookies:
        return "WebCookieManager_GetCookies";
    case MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy:
        return "WebCookieManager_GetHTTPCookieAcceptPolicy";
    case MessageName::WebCookieManager_GetHostnamesWithCookies:
        return "WebCookieManager_GetHostnamesWithCookies";
    case MessageName::WebCookieManager_SetCookie:
        return "WebCookieManager_SetCookie";
    case MessageName::WebCookieManager_SetCookiePersistentStorage:
        return "WebCookieManager_SetCookiePersistentStorage";
    case MessageName::WebCookieManager_SetCookies:
        return "WebCookieManager_SetCookies";
    case MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy:
        return "WebCookieManager_SetHTTPCookieAcceptPolicy";
    case MessageName::WebCookieManager_StartObservingCookieChanges:
        return "WebCookieManager_StartObservingCookieChanges";
    case MessageName::WebCookieManager_StopObservingCookieChanges:
        return "WebCookieManager_StopObservingCookieChanges";
    case MessageName::WebFileSystemStorageConnection_InvalidateAccessHandle:
        return "WebFileSystemStorageConnection_InvalidateAccessHandle";
    case MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen:
        return "WebFullScreenManagerProxy_BeganEnterFullScreen";
    case MessageName::WebFullScreenManagerProxy_BeganExitFullScreen:
        return "WebFullScreenManagerProxy_BeganExitFullScreen";
    case MessageName::WebFullScreenManagerProxy_Close:
        return "WebFullScreenManagerProxy_Close";
    case MessageName::WebFullScreenManagerProxy_EnterFullScreen:
        return "WebFullScreenManagerProxy_EnterFullScreen";
    case MessageName::WebFullScreenManagerProxy_ExitFullScreen:
        return "WebFullScreenManagerProxy_ExitFullScreen";
    case MessageName::WebFullScreenManager_DidEnterFullScreen:
        return "WebFullScreenManager_DidEnterFullScreen";
    case MessageName::WebFullScreenManager_DidExitFullScreen:
        return "WebFullScreenManager_DidExitFullScreen";
    case MessageName::WebFullScreenManager_RequestEnterFullScreen:
        return "WebFullScreenManager_RequestEnterFullScreen";
    case MessageName::WebFullScreenManager_RequestExitFullScreen:
        return "WebFullScreenManager_RequestExitFullScreen";
    case MessageName::WebFullScreenManager_RestoreScrollPosition:
        return "WebFullScreenManager_RestoreScrollPosition";
    case MessageName::WebFullScreenManager_SaveScrollPosition:
        return "WebFullScreenManager_SaveScrollPosition";
    case MessageName::WebFullScreenManager_SetAnimatingFullScreen:
        return "WebFullScreenManager_SetAnimatingFullScreen";
    case MessageName::WebFullScreenManager_SetFullscreenAutoHideDuration:
        return "WebFullScreenManager_SetFullscreenAutoHideDuration";
    case MessageName::WebFullScreenManager_SetFullscreenControlsHidden:
        return "WebFullScreenManager_SetFullscreenControlsHidden";
    case MessageName::WebFullScreenManager_SetFullscreenInsets:
        return "WebFullScreenManager_SetFullscreenInsets";
    case MessageName::WebFullScreenManager_WillEnterFullScreen:
        return "WebFullScreenManager_WillEnterFullScreen";
    case MessageName::WebFullScreenManager_WillExitFullScreen:
        return "WebFullScreenManager_WillExitFullScreen";
    case MessageName::WebGeolocationManagerProxy_SetEnableHighAccuracy:
        return "WebGeolocationManagerProxy_SetEnableHighAccuracy";
    case MessageName::WebGeolocationManagerProxy_StartUpdating:
        return "WebGeolocationManagerProxy_StartUpdating";
    case MessageName::WebGeolocationManagerProxy_StopUpdating:
        return "WebGeolocationManagerProxy_StopUpdating";
    case MessageName::WebGeolocationManager_DidChangePosition:
        return "WebGeolocationManager_DidChangePosition";
    case MessageName::WebGeolocationManager_DidFailToDeterminePosition:
        return "WebGeolocationManager_DidFailToDeterminePosition";
    case MessageName::WebGeolocationManager_ResetPermissions:
        return "WebGeolocationManager_ResetPermissions";
    case MessageName::WebIDBConnectionToServer_DidAbortTransaction:
        return "WebIDBConnectionToServer_DidAbortTransaction";
    case MessageName::WebIDBConnectionToServer_DidClearObjectStore:
        return "WebIDBConnectionToServer_DidClearObjectStore";
    case MessageName::WebIDBConnectionToServer_DidCloseFromServer:
        return "WebIDBConnectionToServer_DidCloseFromServer";
    case MessageName::WebIDBConnectionToServer_DidCommitTransaction:
        return "WebIDBConnectionToServer_DidCommitTransaction";
    case MessageName::WebIDBConnectionToServer_DidCreateIndex:
        return "WebIDBConnectionToServer_DidCreateIndex";
    case MessageName::WebIDBConnectionToServer_DidCreateObjectStore:
        return "WebIDBConnectionToServer_DidCreateObjectStore";
    case MessageName::WebIDBConnectionToServer_DidDeleteDatabase:
        return "WebIDBConnectionToServer_DidDeleteDatabase";
    case MessageName::WebIDBConnectionToServer_DidDeleteIndex:
        return "WebIDBConnectionToServer_DidDeleteIndex";
    case MessageName::WebIDBConnectionToServer_DidDeleteObjectStore:
        return "WebIDBConnectionToServer_DidDeleteObjectStore";
    case MessageName::WebIDBConnectionToServer_DidDeleteRecord:
        return "WebIDBConnectionToServer_DidDeleteRecord";
    case MessageName::WebIDBConnectionToServer_DidGetAllDatabaseNamesAndVersions:
        return "WebIDBConnectionToServer_DidGetAllDatabaseNamesAndVersions";
    case MessageName::WebIDBConnectionToServer_DidGetAllRecords:
        return "WebIDBConnectionToServer_DidGetAllRecords";
    case MessageName::WebIDBConnectionToServer_DidGetCount:
        return "WebIDBConnectionToServer_DidGetCount";
    case MessageName::WebIDBConnectionToServer_DidGetRecord:
        return "WebIDBConnectionToServer_DidGetRecord";
    case MessageName::WebIDBConnectionToServer_DidIterateCursor:
        return "WebIDBConnectionToServer_DidIterateCursor";
    case MessageName::WebIDBConnectionToServer_DidOpenCursor:
        return "WebIDBConnectionToServer_DidOpenCursor";
    case MessageName::WebIDBConnectionToServer_DidOpenDatabase:
        return "WebIDBConnectionToServer_DidOpenDatabase";
    case MessageName::WebIDBConnectionToServer_DidPutOrAdd:
        return "WebIDBConnectionToServer_DidPutOrAdd";
    case MessageName::WebIDBConnectionToServer_DidRenameIndex:
        return "WebIDBConnectionToServer_DidRenameIndex";
    case MessageName::WebIDBConnectionToServer_DidRenameObjectStore:
        return "WebIDBConnectionToServer_DidRenameObjectStore";
    case MessageName::WebIDBConnectionToServer_DidStartTransaction:
        return "WebIDBConnectionToServer_DidStartTransaction";
    case MessageName::WebIDBConnectionToServer_FireVersionChangeEvent:
        return "WebIDBConnectionToServer_FireVersionChangeEvent";
    case MessageName::WebIDBConnectionToServer_NotifyOpenDBRequestBlocked:
        return "WebIDBConnectionToServer_NotifyOpenDBRequestBlocked";
    case MessageName::WebIDBServer_AbortOpenAndUpgradeNeeded:
        return "WebIDBServer_AbortOpenAndUpgradeNeeded";
    case MessageName::WebIDBServer_AbortTransaction:
        return "WebIDBServer_AbortTransaction";
    case MessageName::WebIDBServer_ClearObjectStore:
        return "WebIDBServer_ClearObjectStore";
    case MessageName::WebIDBServer_CommitTransaction:
        return "WebIDBServer_CommitTransaction";
    case MessageName::WebIDBServer_CreateIndex:
        return "WebIDBServer_CreateIndex";
    case MessageName::WebIDBServer_CreateObjectStore:
        return "WebIDBServer_CreateObjectStore";
    case MessageName::WebIDBServer_DatabaseConnectionClosed:
        return "WebIDBServer_DatabaseConnectionClosed";
    case MessageName::WebIDBServer_DatabaseConnectionPendingClose:
        return "WebIDBServer_DatabaseConnectionPendingClose";
    case MessageName::WebIDBServer_DeleteDatabase:
        return "WebIDBServer_DeleteDatabase";
    case MessageName::WebIDBServer_DeleteIndex:
        return "WebIDBServer_DeleteIndex";
    case MessageName::WebIDBServer_DeleteObjectStore:
        return "WebIDBServer_DeleteObjectStore";
    case MessageName::WebIDBServer_DeleteRecord:
        return "WebIDBServer_DeleteRecord";
    case MessageName::WebIDBServer_DidFinishHandlingVersionChangeTransaction:
        return "WebIDBServer_DidFinishHandlingVersionChangeTransaction";
    case MessageName::WebIDBServer_DidFireVersionChangeEvent:
        return "WebIDBServer_DidFireVersionChangeEvent";
    case MessageName::WebIDBServer_EstablishTransaction:
        return "WebIDBServer_EstablishTransaction";
    case MessageName::WebIDBServer_GetAllDatabaseNamesAndVersions:
        return "WebIDBServer_GetAllDatabaseNamesAndVersions";
    case MessageName::WebIDBServer_GetAllRecords:
        return "WebIDBServer_GetAllRecords";
    case MessageName::WebIDBServer_GetCount:
        return "WebIDBServer_GetCount";
    case MessageName::WebIDBServer_GetRecord:
        return "WebIDBServer_GetRecord";
    case MessageName::WebIDBServer_IterateCursor:
        return "WebIDBServer_IterateCursor";
    case MessageName::WebIDBServer_OpenCursor:
        return "WebIDBServer_OpenCursor";
    case MessageName::WebIDBServer_OpenDBRequestCancelled:
        return "WebIDBServer_OpenDBRequestCancelled";
    case MessageName::WebIDBServer_OpenDatabase:
        return "WebIDBServer_OpenDatabase";
    case MessageName::WebIDBServer_PutOrAdd:
        return "WebIDBServer_PutOrAdd";
    case MessageName::WebIDBServer_RenameIndex:
        return "WebIDBServer_RenameIndex";
    case MessageName::WebIDBServer_RenameObjectStore:
        return "WebIDBServer_RenameObjectStore";
    case MessageName::WebInspectorInterruptDispatcher_NotifyNeedDebuggerBreak:
        return "WebInspectorInterruptDispatcher_NotifyNeedDebuggerBreak";
    case MessageName::WebInspectorUIProxy_Append:
        return "WebInspectorUIProxy_Append";
    case MessageName::WebInspectorUIProxy_AttachAvailabilityChanged:
        return "WebInspectorUIProxy_AttachAvailabilityChanged";
    case MessageName::WebInspectorUIProxy_AttachBottom:
        return "WebInspectorUIProxy_AttachBottom";
    case MessageName::WebInspectorUIProxy_AttachLeft:
        return "WebInspectorUIProxy_AttachLeft";
    case MessageName::WebInspectorUIProxy_AttachRight:
        return "WebInspectorUIProxy_AttachRight";
    case MessageName::WebInspectorUIProxy_BringInspectedPageToFront:
        return "WebInspectorUIProxy_BringInspectedPageToFront";
    case MessageName::WebInspectorUIProxy_BringToFront:
        return "WebInspectorUIProxy_BringToFront";
    case MessageName::WebInspectorUIProxy_Detach:
        return "WebInspectorUIProxy_Detach";
    case MessageName::WebInspectorUIProxy_DidClose:
        return "WebInspectorUIProxy_DidClose";
    case MessageName::WebInspectorUIProxy_ElementSelectionChanged:
        return "WebInspectorUIProxy_ElementSelectionChanged";
    case MessageName::WebInspectorUIProxy_FrontendLoaded:
        return "WebInspectorUIProxy_FrontendLoaded";
    case MessageName::WebInspectorUIProxy_InspectedURLChanged:
        return "WebInspectorUIProxy_InspectedURLChanged";
    case MessageName::WebInspectorUIProxy_OpenLocalInspectorFrontend:
        return "WebInspectorUIProxy_OpenLocalInspectorFrontend";
    case MessageName::WebInspectorUIProxy_OpenURLExternally:
        return "WebInspectorUIProxy_OpenURLExternally";
    case MessageName::WebInspectorUIProxy_Reopen:
        return "WebInspectorUIProxy_Reopen";
    case MessageName::WebInspectorUIProxy_ResetState:
        return "WebInspectorUIProxy_ResetState";
    case MessageName::WebInspectorUIProxy_Save:
        return "WebInspectorUIProxy_Save";
    case MessageName::WebInspectorUIProxy_SendMessageToBackend:
        return "WebInspectorUIProxy_SendMessageToBackend";
    case MessageName::WebInspectorUIProxy_SetAttachedWindowHeight:
        return "WebInspectorUIProxy_SetAttachedWindowHeight";
    case MessageName::WebInspectorUIProxy_SetAttachedWindowWidth:
        return "WebInspectorUIProxy_SetAttachedWindowWidth";
    case MessageName::WebInspectorUIProxy_SetDeveloperPreferenceOverride:
        return "WebInspectorUIProxy_SetDeveloperPreferenceOverride";
    case MessageName::WebInspectorUIProxy_SetForcedAppearance:
        return "WebInspectorUIProxy_SetForcedAppearance";
    case MessageName::WebInspectorUIProxy_SetFrontendConnection:
        return "WebInspectorUIProxy_SetFrontendConnection";
    case MessageName::WebInspectorUIProxy_SetSheetRect:
        return "WebInspectorUIProxy_SetSheetRect";
    case MessageName::WebInspectorUIProxy_ShowCertificate:
        return "WebInspectorUIProxy_ShowCertificate";
    case MessageName::WebInspectorUIProxy_StartWindowDrag:
        return "WebInspectorUIProxy_StartWindowDrag";
    case MessageName::WebInspectorUIProxy_TimelineRecordingChanged:
        return "WebInspectorUIProxy_TimelineRecordingChanged";
    case MessageName::WebInspectorUI_AttachedBottom:
        return "WebInspectorUI_AttachedBottom";
    case MessageName::WebInspectorUI_AttachedLeft:
        return "WebInspectorUI_AttachedLeft";
    case MessageName::WebInspectorUI_AttachedRight:
        return "WebInspectorUI_AttachedRight";
    case MessageName::WebInspectorUI_Detached:
        return "WebInspectorUI_Detached";
    case MessageName::WebInspectorUI_DidAppend:
        return "WebInspectorUI_DidAppend";
    case MessageName::WebInspectorUI_DidSave:
        return "WebInspectorUI_DidSave";
    case MessageName::WebInspectorUI_EstablishConnection:
        return "WebInspectorUI_EstablishConnection";
    case MessageName::WebInspectorUI_EvaluateInFrontendForTesting:
        return "WebInspectorUI_EvaluateInFrontendForTesting";
    case MessageName::WebInspectorUI_SendMessageToFrontend:
        return "WebInspectorUI_SendMessageToFrontend";
    case MessageName::WebInspectorUI_SetDiagnosticLoggingAvailable:
        return "WebInspectorUI_SetDiagnosticLoggingAvailable";
    case MessageName::WebInspectorUI_SetDockingUnavailable:
        return "WebInspectorUI_SetDockingUnavailable";
    case MessageName::WebInspectorUI_SetIsVisible:
        return "WebInspectorUI_SetIsVisible";
    case MessageName::WebInspectorUI_ShowConsole:
        return "WebInspectorUI_ShowConsole";
    case MessageName::WebInspectorUI_ShowMainResourceForFrame:
        return "WebInspectorUI_ShowMainResourceForFrame";
    case MessageName::WebInspectorUI_ShowResources:
        return "WebInspectorUI_ShowResources";
    case MessageName::WebInspectorUI_StartElementSelection:
        return "WebInspectorUI_StartElementSelection";
    case MessageName::WebInspectorUI_StartPageProfiling:
        return "WebInspectorUI_StartPageProfiling";
    case MessageName::WebInspectorUI_StopElementSelection:
        return "WebInspectorUI_StopElementSelection";
    case MessageName::WebInspectorUI_StopPageProfiling:
        return "WebInspectorUI_StopPageProfiling";
    case MessageName::WebInspectorUI_UpdateConnection:
        return "WebInspectorUI_UpdateConnection";
    case MessageName::WebInspectorUI_UpdateFindString:
        return "WebInspectorUI_UpdateFindString";
    case MessageName::WebInspector_Close:
        return "WebInspector_Close";
    case MessageName::WebInspector_SetAttached:
        return "WebInspector_SetAttached";
    case MessageName::WebInspector_SetFrontendConnection:
        return "WebInspector_SetFrontendConnection";
    case MessageName::WebInspector_Show:
        return "WebInspector_Show";
    case MessageName::WebInspector_ShowConsole:
        return "WebInspector_ShowConsole";
    case MessageName::WebInspector_ShowMainResourceForFrame:
        return "WebInspector_ShowMainResourceForFrame";
    case MessageName::WebInspector_ShowResources:
        return "WebInspector_ShowResources";
    case MessageName::WebInspector_StartElementSelection:
        return "WebInspector_StartElementSelection";
    case MessageName::WebInspector_StartPageProfiling:
        return "WebInspector_StartPageProfiling";
    case MessageName::WebInspector_StopElementSelection:
        return "WebInspector_StopElementSelection";
    case MessageName::WebInspector_StopPageProfiling:
        return "WebInspector_StopPageProfiling";
    case MessageName::WebLockRegistryProxy_AbortLockRequest:
        return "WebLockRegistryProxy_AbortLockRequest";
    case MessageName::WebLockRegistryProxy_ClientIsGoingAway:
        return "WebLockRegistryProxy_ClientIsGoingAway";
    case MessageName::WebLockRegistryProxy_ReleaseLock:
        return "WebLockRegistryProxy_ReleaseLock";
    case MessageName::WebLockRegistryProxy_RequestLock:
        return "WebLockRegistryProxy_RequestLock";
    case MessageName::WebLockRegistryProxy_Snapshot:
        return "WebLockRegistryProxy_Snapshot";
    case MessageName::WebMDNSRegister_FinishedRegisteringMDNSName:
        return "WebMDNSRegister_FinishedRegisteringMDNSName";
    case MessageName::WebNotificationManager_DidClickNotification:
        return "WebNotificationManager_DidClickNotification";
    case MessageName::WebNotificationManager_DidCloseNotifications:
        return "WebNotificationManager_DidCloseNotifications";
    case MessageName::WebNotificationManager_DidRemoveNotificationDecisions:
        return "WebNotificationManager_DidRemoveNotificationDecisions";
    case MessageName::WebNotificationManager_DidShowNotification:
        return "WebNotificationManager_DidShowNotification";
    case MessageName::WebNotificationManager_DidUpdateNotificationDecision:
        return "WebNotificationManager_DidUpdateNotificationDecision";
    case MessageName::WebPageProxy_AbortApplePayAMSUISession:
        return "WebPageProxy_AbortApplePayAMSUISession";
    case MessageName::WebPageProxy_AddMediaUsageManagerSession:
        return "WebPageProxy_AddMediaUsageManagerSession";
    case MessageName::WebPageProxy_AddPlaybackTargetPickerClient:
        return "WebPageProxy_AddPlaybackTargetPickerClient";
    case MessageName::WebPageProxy_AssistiveTechnologyMakeFirstResponder:
        return "WebPageProxy_AssistiveTechnologyMakeFirstResponder";
    case MessageName::WebPageProxy_BackForwardAddItem:
        return "WebPageProxy_BackForwardAddItem";
    case MessageName::WebPageProxy_BackForwardClear:
        return "WebPageProxy_BackForwardClear";
    case MessageName::WebPageProxy_BeginMonitoringCaptureDevices:
        return "WebPageProxy_BeginMonitoringCaptureDevices";
    case MessageName::WebPageProxy_BindAccessibilityTree:
        return "WebPageProxy_BindAccessibilityTree";
    case MessageName::WebPageProxy_ChangeUniversalAccessZoomFocus:
        return "WebPageProxy_ChangeUniversalAccessZoomFocus";
    case MessageName::WebPageProxy_ClassifyModalContainerControls:
        return "WebPageProxy_ClassifyModalContainerControls";
    case MessageName::WebPageProxy_ClearAllEditCommands:
        return "WebPageProxy_ClearAllEditCommands";
    case MessageName::WebPageProxy_ClearTextIndicator:
        return "WebPageProxy_ClearTextIndicator";
    case MessageName::WebPageProxy_CloneAttachmentData:
        return "WebPageProxy_CloneAttachmentData";
    case MessageName::WebPageProxy_ClosePage:
        return "WebPageProxy_ClosePage";
    case MessageName::WebPageProxy_CommitPotentialTapFailed:
        return "WebPageProxy_CommitPotentialTapFailed";
    case MessageName::WebPageProxy_CompositionWasCanceled:
        return "WebPageProxy_CompositionWasCanceled";
    case MessageName::WebPageProxy_ConfigureLoggingChannel:
        return "WebPageProxy_ConfigureLoggingChannel";
    case MessageName::WebPageProxy_ContentFilterDidBlockLoadForFrame:
        return "WebPageProxy_ContentFilterDidBlockLoadForFrame";
    case MessageName::WebPageProxy_ContentRuleListNotification:
        return "WebPageProxy_ContentRuleListNotification";
    case MessageName::WebPageProxy_CouldNotRestorePageState:
        return "WebPageProxy_CouldNotRestorePageState";
    case MessageName::WebPageProxy_CreateInspectorTarget:
        return "WebPageProxy_CreateInspectorTarget";
    case MessageName::WebPageProxy_CreatePDFHUD:
        return "WebPageProxy_CreatePDFHUD";
    case MessageName::WebPageProxy_DecidePolicyForModalContainer:
        return "WebPageProxy_DecidePolicyForModalContainer";
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync:
        return "WebPageProxy_DecidePolicyForNavigationActionAsync";
    case MessageName::WebPageProxy_DecidePolicyForNewWindowAction:
        return "WebPageProxy_DecidePolicyForNewWindowAction";
    case MessageName::WebPageProxy_DecidePolicyForResponse:
        return "WebPageProxy_DecidePolicyForResponse";
    case MessageName::WebPageProxy_DestroyInspectorTarget:
        return "WebPageProxy_DestroyInspectorTarget";
    case MessageName::WebPageProxy_DidCancelClientRedirectForFrame:
        return "WebPageProxy_DidCancelClientRedirectForFrame";
    case MessageName::WebPageProxy_DidChangeContentSize:
        return "WebPageProxy_DidChangeContentSize";
    case MessageName::WebPageProxy_DidChangeInspectorFrontendCount:
        return "WebPageProxy_DidChangeInspectorFrontendCount";
    case MessageName::WebPageProxy_DidChangeIntrinsicContentSize:
        return "WebPageProxy_DidChangeIntrinsicContentSize";
    case MessageName::WebPageProxy_DidChangeMainDocument:
        return "WebPageProxy_DidChangeMainDocument";
    case MessageName::WebPageProxy_DidChangePageCount:
        return "WebPageProxy_DidChangePageCount";
    case MessageName::WebPageProxy_DidChangeProgress:
        return "WebPageProxy_DidChangeProgress";
    case MessageName::WebPageProxy_DidChangeProvisionalURLForFrame:
        return "WebPageProxy_DidChangeProvisionalURLForFrame";
    case MessageName::WebPageProxy_DidChangeScrollOffsetPinningForMainFrame:
        return "WebPageProxy_DidChangeScrollOffsetPinningForMainFrame";
    case MessageName::WebPageProxy_DidChangeScrollbarsForMainFrame:
        return "WebPageProxy_DidChangeScrollbarsForMainFrame";
    case MessageName::WebPageProxy_DidChangeViewportProperties:
        return "WebPageProxy_DidChangeViewportProperties";
    case MessageName::WebPageProxy_DidCommitLoadForFrame:
        return "WebPageProxy_DidCommitLoadForFrame";
    case MessageName::WebPageProxy_DidCompleteSyntheticClick:
        return "WebPageProxy_DidCompleteSyntheticClick";
    case MessageName::WebPageProxy_DidCountStringMatches:
        return "WebPageProxy_DidCountStringMatches";
    case MessageName::WebPageProxy_DidCreateContextInWebProcessForVisibilityPropagation:
        return "WebPageProxy_DidCreateContextInWebProcessForVisibilityPropagation";
    case MessageName::WebPageProxy_DidCreateMainFrame:
        return "WebPageProxy_DidCreateMainFrame";
    case MessageName::WebPageProxy_DidCreateSubframe:
        return "WebPageProxy_DidCreateSubframe";
    case MessageName::WebPageProxy_DidCreateWindow:
        return "WebPageProxy_DidCreateWindow";
    case MessageName::WebPageProxy_DidDestroyNavigation:
        return "WebPageProxy_DidDestroyNavigation";
    case MessageName::WebPageProxy_DidDetectXSSForFrame:
        return "WebPageProxy_DidDetectXSSForFrame";
    case MessageName::WebPageProxy_DidDisplayInsecureContentForFrame:
        return "WebPageProxy_DidDisplayInsecureContentForFrame";
    case MessageName::WebPageProxy_DidEndDragging:
        return "WebPageProxy_DidEndDragging";
    case MessageName::WebPageProxy_DidExplicitOpenForFrame:
        return "WebPageProxy_DidExplicitOpenForFrame";
    case MessageName::WebPageProxy_DidFailLoadForFrame:
        return "WebPageProxy_DidFailLoadForFrame";
    case MessageName::WebPageProxy_DidFailProvisionalLoadForFrame:
        return "WebPageProxy_DidFailProvisionalLoadForFrame";
    case MessageName::WebPageProxy_DidFailToFindString:
        return "WebPageProxy_DidFailToFindString";
    case MessageName::WebPageProxy_DidFailToSuspendAfterProcessSwap:
        return "WebPageProxy_DidFailToSuspendAfterProcessSwap";
    case MessageName::WebPageProxy_DidFindString:
        return "WebPageProxy_DidFindString";
    case MessageName::WebPageProxy_DidFindStringMatches:
        return "WebPageProxy_DidFindStringMatches";
    case MessageName::WebPageProxy_DidFindTextManipulationItems:
        return "WebPageProxy_DidFindTextManipulationItems";
    case MessageName::WebPageProxy_DidFinishDocumentLoadForFrame:
        return "WebPageProxy_DidFinishDocumentLoadForFrame";
    case MessageName::WebPageProxy_DidFinishLoadForFrame:
        return "WebPageProxy_DidFinishLoadForFrame";
    case MessageName::WebPageProxy_DidFinishLoadForQuickLookDocumentInMainFrame:
        return "WebPageProxy_DidFinishLoadForQuickLookDocumentInMainFrame";
    case MessageName::WebPageProxy_DidFinishLoadingDataForCustomContentProvider:
        return "WebPageProxy_DidFinishLoadingDataForCustomContentProvider";
    case MessageName::WebPageProxy_DidFinishProgress:
        return "WebPageProxy_DidFinishProgress";
    case MessageName::WebPageProxy_DidFinishServiceWorkerPageRegistration:
        return "WebPageProxy_DidFinishServiceWorkerPageRegistration";
    case MessageName::WebPageProxy_DidFirstLayoutForFrame:
        return "WebPageProxy_DidFirstLayoutForFrame";
    case MessageName::WebPageProxy_DidFirstVisuallyNonEmptyLayoutForFrame:
        return "WebPageProxy_DidFirstVisuallyNonEmptyLayoutForFrame";
    case MessageName::WebPageProxy_DidGetImageForFindMatch:
        return "WebPageProxy_DidGetImageForFindMatch";
    case MessageName::WebPageProxy_DidGetTapHighlightGeometries:
        return "WebPageProxy_DidGetTapHighlightGeometries";
    case MessageName::WebPageProxy_DidHandleAcceptedCandidate:
        return "WebPageProxy_DidHandleAcceptedCandidate";
    case MessageName::WebPageProxy_DidHandleAdditionalDragItemsRequest:
        return "WebPageProxy_DidHandleAdditionalDragItemsRequest";
    case MessageName::WebPageProxy_DidHandleDragStartRequest:
        return "WebPageProxy_DidHandleDragStartRequest";
    case MessageName::WebPageProxy_DidInsertAttachmentWithIdentifier:
        return "WebPageProxy_DidInsertAttachmentWithIdentifier";
    case MessageName::WebPageProxy_DidNavigateWithNavigationData:
        return "WebPageProxy_DidNavigateWithNavigationData";
    case MessageName::WebPageProxy_DidNotHandleTapAsClick:
        return "WebPageProxy_DidNotHandleTapAsClick";
    case MessageName::WebPageProxy_DidPerformClientRedirect:
        return "WebPageProxy_DidPerformClientRedirect";
    case MessageName::WebPageProxy_DidPerformDictionaryLookup:
        return "WebPageProxy_DidPerformDictionaryLookup";
    case MessageName::WebPageProxy_DidPerformDragControllerAction:
        return "WebPageProxy_DidPerformDragControllerAction";
    case MessageName::WebPageProxy_DidPerformDragOperation:
        return "WebPageProxy_DidPerformDragOperation";
    case MessageName::WebPageProxy_DidPerformImmediateActionHitTest:
        return "WebPageProxy_DidPerformImmediateActionHitTest";
    case MessageName::WebPageProxy_DidPerformServerRedirect:
        return "WebPageProxy_DidPerformServerRedirect";
    case MessageName::WebPageProxy_DidReachLayoutMilestone:
        return "WebPageProxy_DidReachLayoutMilestone";
    case MessageName::WebPageProxy_DidReceiveEditDragSnapshot:
        return "WebPageProxy_DidReceiveEditDragSnapshot";
    case MessageName::WebPageProxy_DidReceiveEvent:
        return "WebPageProxy_DidReceiveEvent";
    case MessageName::WebPageProxy_DidReceivePositionInformation:
        return "WebPageProxy_DidReceivePositionInformation";
    case MessageName::WebPageProxy_DidReceiveServerRedirectForProvisionalLoadForFrame:
        return "WebPageProxy_DidReceiveServerRedirectForProvisionalLoadForFrame";
    case MessageName::WebPageProxy_DidReceiveTitleForFrame:
        return "WebPageProxy_DidReceiveTitleForFrame";
    case MessageName::WebPageProxy_DidRemoveAttachmentWithIdentifier:
        return "WebPageProxy_DidRemoveAttachmentWithIdentifier";
    case MessageName::WebPageProxy_DidResignInputElementStrongPasswordAppearance:
        return "WebPageProxy_DidResignInputElementStrongPasswordAppearance";
    case MessageName::WebPageProxy_DidRestoreScrollPosition:
        return "WebPageProxy_DidRestoreScrollPosition";
    case MessageName::WebPageProxy_DidRunInsecureContentForFrame:
        return "WebPageProxy_DidRunInsecureContentForFrame";
    case MessageName::WebPageProxy_DidSameDocumentNavigationForFrame:
        return "WebPageProxy_DidSameDocumentNavigationForFrame";
    case MessageName::WebPageProxy_DidStartLoadForQuickLookDocumentInMainFrame:
        return "WebPageProxy_DidStartLoadForQuickLookDocumentInMainFrame";
    case MessageName::WebPageProxy_DidStartProgress:
        return "WebPageProxy_DidStartProgress";
    case MessageName::WebPageProxy_DidStartProvisionalLoadForFrame:
        return "WebPageProxy_DidStartProvisionalLoadForFrame";
    case MessageName::WebPageProxy_DidSuspendAfterProcessSwap:
        return "WebPageProxy_DidSuspendAfterProcessSwap";
    case MessageName::WebPageProxy_DidUpdateActivityState:
        return "WebPageProxy_DidUpdateActivityState";
    case MessageName::WebPageProxy_DidUpdateHistoryTitle:
        return "WebPageProxy_DidUpdateHistoryTitle";
    case MessageName::WebPageProxy_DidUpdateRenderingAfterCommittingLoad:
        return "WebPageProxy_DidUpdateRenderingAfterCommittingLoad";
    case MessageName::WebPageProxy_DisableDoubleTapGesturesDuringTapIfNecessary:
        return "WebPageProxy_DisableDoubleTapGesturesDuringTapIfNecessary";
    case MessageName::WebPageProxy_DisableInspectorNodeSearch:
        return "WebPageProxy_DisableInspectorNodeSearch";
    case MessageName::WebPageProxy_DismissCorrectionPanel:
        return "WebPageProxy_DismissCorrectionPanel";
    case MessageName::WebPageProxy_EditorStateChanged:
        return "WebPageProxy_EditorStateChanged";
    case MessageName::WebPageProxy_ElementDidBlur:
        return "WebPageProxy_ElementDidBlur";
    case MessageName::WebPageProxy_ElementDidFocus:
        return "WebPageProxy_ElementDidFocus";
    case MessageName::WebPageProxy_EnableInspectorNodeSearch:
        return "WebPageProxy_EnableInspectorNodeSearch";
    case MessageName::WebPageProxy_EndColorPicker:
        return "WebPageProxy_EndColorPicker";
    case MessageName::WebPageProxy_EndDataListSuggestions:
        return "WebPageProxy_EndDataListSuggestions";
    case MessageName::WebPageProxy_EndDateTimePicker:
        return "WebPageProxy_EndDateTimePicker";
    case MessageName::WebPageProxy_EnumerateMediaDevicesForFrame:
        return "WebPageProxy_EnumerateMediaDevicesForFrame";
    case MessageName::WebPageProxy_FixedLayoutSizeDidChange:
        return "WebPageProxy_FixedLayoutSizeDidChange";
    case MessageName::WebPageProxy_FocusedElementDidChangeInputMode:
        return "WebPageProxy_FocusedElementDidChangeInputMode";
    case MessageName::WebPageProxy_FocusedFrameChanged:
        return "WebPageProxy_FocusedFrameChanged";
    case MessageName::WebPageProxy_GetLoadDecisionForIcon:
        return "WebPageProxy_GetLoadDecisionForIcon";
    case MessageName::WebPageProxy_HandleAcceptsFirstMouse:
        return "WebPageProxy_HandleAcceptsFirstMouse";
    case MessageName::WebPageProxy_HandleAutoFillButtonClick:
        return "WebPageProxy_HandleAutoFillButtonClick";
    case MessageName::WebPageProxy_HandleAutocorrectionContext:
        return "WebPageProxy_HandleAutocorrectionContext";
    case MessageName::WebPageProxy_HandleAutoplayEvent:
        return "WebPageProxy_HandleAutoplayEvent";
    case MessageName::WebPageProxy_HandleClickForDataDetectionResult:
        return "WebPageProxy_HandleClickForDataDetectionResult";
    case MessageName::WebPageProxy_HandleContextMenuTranslation:
        return "WebPageProxy_HandleContextMenuTranslation";
    case MessageName::WebPageProxy_HandleKeydownInDataList:
        return "WebPageProxy_HandleKeydownInDataList";
    case MessageName::WebPageProxy_HandleMessage:
        return "WebPageProxy_HandleMessage";
    case MessageName::WebPageProxy_HandleMouseDownForModelElement:
        return "WebPageProxy_HandleMouseDownForModelElement";
    case MessageName::WebPageProxy_HandleMouseMoveForModelElement:
        return "WebPageProxy_HandleMouseMoveForModelElement";
    case MessageName::WebPageProxy_HandleMouseUpForModelElement:
        return "WebPageProxy_HandleMouseUpForModelElement";
    case MessageName::WebPageProxy_HandleSmartMagnificationInformationForPotentialTap:
        return "WebPageProxy_HandleSmartMagnificationInformationForPotentialTap";
    case MessageName::WebPageProxy_HideInspectorHighlight:
        return "WebPageProxy_HideInspectorHighlight";
    case MessageName::WebPageProxy_HideInspectorIndication:
        return "WebPageProxy_HideInspectorIndication";
    case MessageName::WebPageProxy_HidePopupMenu:
        return "WebPageProxy_HidePopupMenu";
    case MessageName::WebPageProxy_HideValidationMessage:
        return "WebPageProxy_HideValidationMessage";
    case MessageName::WebPageProxy_IgnoreWord:
        return "WebPageProxy_IgnoreWord";
    case MessageName::WebPageProxy_ImageOrMediaDocumentSizeChanged:
        return "WebPageProxy_ImageOrMediaDocumentSizeChanged";
    case MessageName::WebPageProxy_IsPlayingMediaDidChange:
        return "WebPageProxy_IsPlayingMediaDidChange";
    case MessageName::WebPageProxy_LearnWord:
        return "WebPageProxy_LearnWord";
    case MessageName::WebPageProxy_LogDiagnosticMessageFromWebProcess:
        return "WebPageProxy_LogDiagnosticMessageFromWebProcess";
    case MessageName::WebPageProxy_LogDiagnosticMessageWithDomainFromWebProcess:
        return "WebPageProxy_LogDiagnosticMessageWithDomainFromWebProcess";
    case MessageName::WebPageProxy_LogDiagnosticMessageWithEnhancedPrivacyFromWebProcess:
        return "WebPageProxy_LogDiagnosticMessageWithEnhancedPrivacyFromWebProcess";
    case MessageName::WebPageProxy_LogDiagnosticMessageWithResultFromWebProcess:
        return "WebPageProxy_LogDiagnosticMessageWithResultFromWebProcess";
    case MessageName::WebPageProxy_LogDiagnosticMessageWithValueDictionaryFromWebProcess:
        return "WebPageProxy_LogDiagnosticMessageWithValueDictionaryFromWebProcess";
    case MessageName::WebPageProxy_LogDiagnosticMessageWithValueFromWebProcess:
        return "WebPageProxy_LogDiagnosticMessageWithValueFromWebProcess";
    case MessageName::WebPageProxy_LogScrollingEvent:
        return "WebPageProxy_LogScrollingEvent";
    case MessageName::WebPageProxy_MainFramePluginHandlesPageScaleGestureDidChange:
        return "WebPageProxy_MainFramePluginHandlesPageScaleGestureDidChange";
    case MessageName::WebPageProxy_MakeFirstResponder:
        return "WebPageProxy_MakeFirstResponder";
    case MessageName::WebPageProxy_MockMediaPlaybackTargetPickerDismissPopup:
        return "WebPageProxy_MockMediaPlaybackTargetPickerDismissPopup";
    case MessageName::WebPageProxy_ModelElementAnimationCurrentTime:
        return "WebPageProxy_ModelElementAnimationCurrentTime";
    case MessageName::WebPageProxy_ModelElementAnimationDuration:
        return "WebPageProxy_ModelElementAnimationDuration";
    case MessageName::WebPageProxy_ModelElementDidCreatePreview:
        return "WebPageProxy_ModelElementDidCreatePreview";
    case MessageName::WebPageProxy_ModelElementGetCamera:
        return "WebPageProxy_ModelElementGetCamera";
    case MessageName::WebPageProxy_ModelElementHasAudio:
        return "WebPageProxy_ModelElementHasAudio";
    case MessageName::WebPageProxy_ModelElementIsLoopingAnimation:
        return "WebPageProxy_ModelElementIsLoopingAnimation";
    case MessageName::WebPageProxy_ModelElementIsMuted:
        return "WebPageProxy_ModelElementIsMuted";
    case MessageName::WebPageProxy_ModelElementIsPlayingAnimation:
        return "WebPageProxy_ModelElementIsPlayingAnimation";
    case MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime:
        return "WebPageProxy_ModelElementSetAnimationCurrentTime";
    case MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying:
        return "WebPageProxy_ModelElementSetAnimationIsPlaying";
    case MessageName::WebPageProxy_ModelElementSetCamera:
        return "WebPageProxy_ModelElementSetCamera";
    case MessageName::WebPageProxy_ModelElementSetInteractionEnabled:
        return "WebPageProxy_ModelElementSetInteractionEnabled";
    case MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation:
        return "WebPageProxy_ModelElementSetIsLoopingAnimation";
    case MessageName::WebPageProxy_ModelElementSetIsMuted:
        return "WebPageProxy_ModelElementSetIsMuted";
    case MessageName::WebPageProxy_ModelElementSizeDidChange:
        return "WebPageProxy_ModelElementSizeDidChange";
    case MessageName::WebPageProxy_MouseDidMoveOverElement:
        return "WebPageProxy_MouseDidMoveOverElement";
    case MessageName::WebPageProxy_NotifyScrollerThumbIsVisibleInRect:
        return "WebPageProxy_NotifyScrollerThumbIsVisibleInRect";
    case MessageName::WebPageProxy_OpenPDFFromTemporaryFolderWithNativeApplication:
        return "WebPageProxy_OpenPDFFromTemporaryFolderWithNativeApplication";
    case MessageName::WebPageProxy_PageDidScroll:
        return "WebPageProxy_PageDidScroll";
    case MessageName::WebPageProxy_PageExtendedBackgroundColorDidChange:
        return "WebPageProxy_PageExtendedBackgroundColorDidChange";
    case MessageName::WebPageProxy_PageScaleFactorDidChange:
        return "WebPageProxy_PageScaleFactorDidChange";
    case MessageName::WebPageProxy_PlaybackTargetPickerClientStateDidChange:
        return "WebPageProxy_PlaybackTargetPickerClientStateDidChange";
    case MessageName::WebPageProxy_PluginScaleFactorDidChange:
        return "WebPageProxy_PluginScaleFactorDidChange";
    case MessageName::WebPageProxy_PluginZoomFactorDidChange:
        return "WebPageProxy_PluginZoomFactorDidChange";
    case MessageName::WebPageProxy_QueryPermission:
        return "WebPageProxy_QueryPermission";
    case MessageName::WebPageProxy_RecommendedScrollbarStyleDidChange:
        return "WebPageProxy_RecommendedScrollbarStyleDidChange";
    case MessageName::WebPageProxy_RecordAutocorrectionResponse:
        return "WebPageProxy_RecordAutocorrectionResponse";
    case MessageName::WebPageProxy_RegisterAttachmentIdentifier:
        return "WebPageProxy_RegisterAttachmentIdentifier";
    case MessageName::WebPageProxy_RegisterAttachmentIdentifierFromData:
        return "WebPageProxy_RegisterAttachmentIdentifierFromData";
    case MessageName::WebPageProxy_RegisterAttachmentIdentifierFromFilePath:
        return "WebPageProxy_RegisterAttachmentIdentifierFromFilePath";
    case MessageName::WebPageProxy_RegisterAttachmentsFromSerializedData:
        return "WebPageProxy_RegisterAttachmentsFromSerializedData";
    case MessageName::WebPageProxy_RegisterEditCommandForUndo:
        return "WebPageProxy_RegisterEditCommandForUndo";
    case MessageName::WebPageProxy_RegisterInsertionUndoGrouping:
        return "WebPageProxy_RegisterInsertionUndoGrouping";
    case MessageName::WebPageProxy_RegisterWebProcessAccessibilityToken:
        return "WebPageProxy_RegisterWebProcessAccessibilityToken";
    case MessageName::WebPageProxy_RemoveDictationAlternatives:
        return "WebPageProxy_RemoveDictationAlternatives";
    case MessageName::WebPageProxy_RemoveMediaUsageManagerSession:
        return "WebPageProxy_RemoveMediaUsageManagerSession";
    case MessageName::WebPageProxy_RemovePDFHUD:
        return "WebPageProxy_RemovePDFHUD";
    case MessageName::WebPageProxy_RemovePlaybackTargetPickerClient:
        return "WebPageProxy_RemovePlaybackTargetPickerClient";
    case MessageName::WebPageProxy_RequestAttachmentIcon:
        return "WebPageProxy_RequestAttachmentIcon";
    case MessageName::WebPageProxy_RequestCheckingOfString:
        return "WebPageProxy_RequestCheckingOfString";
    case MessageName::WebPageProxy_RequestCookieConsent:
        return "WebPageProxy_RequestCookieConsent";
    case MessageName::WebPageProxy_RequestGeolocationPermissionForFrame:
        return "WebPageProxy_RequestGeolocationPermissionForFrame";
    case MessageName::WebPageProxy_RequestInstallMissingMediaPlugins:
        return "WebPageProxy_RequestInstallMissingMediaPlugins";
    case MessageName::WebPageProxy_RequestMediaKeySystemPermissionForFrame:
        return "WebPageProxy_RequestMediaKeySystemPermissionForFrame";
    case MessageName::WebPageProxy_RequestNotificationPermission:
        return "WebPageProxy_RequestNotificationPermission";
    case MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame:
        return "WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame";
    case MessageName::WebPageProxy_RequestPointerLock:
        return "WebPageProxy_RequestPointerLock";
    case MessageName::WebPageProxy_RequestPointerUnlock:
        return "WebPageProxy_RequestPointerUnlock";
    case MessageName::WebPageProxy_RequestScrollToRect:
        return "WebPageProxy_RequestScrollToRect";
    case MessageName::WebPageProxy_RequestTextRecognition:
        return "WebPageProxy_RequestTextRecognition";
    case MessageName::WebPageProxy_RequestUserMediaPermissionForFrame:
        return "WebPageProxy_RequestUserMediaPermissionForFrame";
    case MessageName::WebPageProxy_RestorePageCenterAndScale:
        return "WebPageProxy_RestorePageCenterAndScale";
    case MessageName::WebPageProxy_RestorePageState:
        return "WebPageProxy_RestorePageState";
    case MessageName::WebPageProxy_RevokeGeolocationAuthorizationToken:
        return "WebPageProxy_RevokeGeolocationAuthorizationToken";
    case MessageName::WebPageProxy_RunModal:
        return "WebPageProxy_RunModal";
    case MessageName::WebPageProxy_RunOpenPanel:
        return "WebPageProxy_RunOpenPanel";
    case MessageName::WebPageProxy_SampledPageTopColorChanged:
        return "WebPageProxy_SampledPageTopColorChanged";
    case MessageName::WebPageProxy_SaveImageToLibrary:
        return "WebPageProxy_SaveImageToLibrary";
    case MessageName::WebPageProxy_SavePDFToFileInDownloadsFolder:
        return "WebPageProxy_SavePDFToFileInDownloadsFolder";
    case MessageName::WebPageProxy_SavePDFToTemporaryFolderAndOpenWithNativeApplication:
        return "WebPageProxy_SavePDFToTemporaryFolderAndOpenWithNativeApplication";
    case MessageName::WebPageProxy_SaveRecentSearches:
        return "WebPageProxy_SaveRecentSearches";
    case MessageName::WebPageProxy_ScrollingNodeScrollDidEndScroll:
        return "WebPageProxy_ScrollingNodeScrollDidEndScroll";
    case MessageName::WebPageProxy_ScrollingNodeScrollWillStartScroll:
        return "WebPageProxy_ScrollingNodeScrollWillStartScroll";
    case MessageName::WebPageProxy_SearchTheWeb:
        return "WebPageProxy_SearchTheWeb";
    case MessageName::WebPageProxy_SearchWithSpotlight:
        return "WebPageProxy_SearchWithSpotlight";
    case MessageName::WebPageProxy_SendMessageToInspectorFrontend:
        return "WebPageProxy_SendMessageToInspectorFrontend";
    case MessageName::WebPageProxy_SendMessageToWebView:
        return "WebPageProxy_SendMessageToWebView";
    case MessageName::WebPageProxy_SendMessageToWebViewWithReply:
        return "WebPageProxy_SendMessageToWebViewWithReply";
    case MessageName::WebPageProxy_SetCanShortCircuitHorizontalWheelEvents:
        return "WebPageProxy_SetCanShortCircuitHorizontalWheelEvents";
    case MessageName::WebPageProxy_SetColorPickerColor:
        return "WebPageProxy_SetColorPickerColor";
    case MessageName::WebPageProxy_SetCursor:
        return "WebPageProxy_SetCursor";
    case MessageName::WebPageProxy_SetCursorHiddenUntilMouseMoves:
        return "WebPageProxy_SetCursorHiddenUntilMouseMoves";
    case MessageName::WebPageProxy_SetDataDetectionResult:
        return "WebPageProxy_SetDataDetectionResult";
    case MessageName::WebPageProxy_SetEditableElementIsFocused:
        return "WebPageProxy_SetEditableElementIsFocused";
    case MessageName::WebPageProxy_SetFocus:
        return "WebPageProxy_SetFocus";
    case MessageName::WebPageProxy_SetHasActiveAnimatedScrolls:
        return "WebPageProxy_SetHasActiveAnimatedScrolls";
    case MessageName::WebPageProxy_SetHasExecutedAppBoundBehaviorBeforeNavigation:
        return "WebPageProxy_SetHasExecutedAppBoundBehaviorBeforeNavigation";
    case MessageName::WebPageProxy_SetHasHadSelectionChangesFromUserInteraction:
        return "WebPageProxy_SetHasHadSelectionChangesFromUserInteraction";
    case MessageName::WebPageProxy_SetInputMethodState:
        return "WebPageProxy_SetInputMethodState";
    case MessageName::WebPageProxy_SetIsNeverRichlyEditableForTouchBar:
        return "WebPageProxy_SetIsNeverRichlyEditableForTouchBar";
    case MessageName::WebPageProxy_SetIsResizable:
        return "WebPageProxy_SetIsResizable";
    case MessageName::WebPageProxy_SetIsTouchBarUpdateSupressedForHiddenContentEditable:
        return "WebPageProxy_SetIsTouchBarUpdateSupressedForHiddenContentEditable";
    case MessageName::WebPageProxy_SetIsUsingHighPerformanceWebGL:
        return "WebPageProxy_SetIsUsingHighPerformanceWebGL";
    case MessageName::WebPageProxy_SetMenuBarIsVisible:
        return "WebPageProxy_SetMenuBarIsVisible";
    case MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerEnabled:
        return "WebPageProxy_SetMockMediaPlaybackTargetPickerEnabled";
    case MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerState:
        return "WebPageProxy_SetMockMediaPlaybackTargetPickerState";
    case MessageName::WebPageProxy_SetMockVideoPresentationModeEnabled:
        return "WebPageProxy_SetMockVideoPresentationModeEnabled";
    case MessageName::WebPageProxy_SetMockWebAuthenticationConfiguration:
        return "WebPageProxy_SetMockWebAuthenticationConfiguration";
    case MessageName::WebPageProxy_SetNetworkRequestsInProgress:
        return "WebPageProxy_SetNetworkRequestsInProgress";
    case MessageName::WebPageProxy_SetPromisedDataForImage:
        return "WebPageProxy_SetPromisedDataForImage";
    case MessageName::WebPageProxy_SetRenderTreeSize:
        return "WebPageProxy_SetRenderTreeSize";
    case MessageName::WebPageProxy_SetStatusBarIsVisible:
        return "WebPageProxy_SetStatusBarIsVisible";
    case MessageName::WebPageProxy_SetStatusText:
        return "WebPageProxy_SetStatusText";
    case MessageName::WebPageProxy_SetTextIndicator:
        return "WebPageProxy_SetTextIndicator";
    case MessageName::WebPageProxy_SetToolbarsAreVisible:
        return "WebPageProxy_SetToolbarsAreVisible";
    case MessageName::WebPageProxy_SetWindowFrame:
        return "WebPageProxy_SetWindowFrame";
    case MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess:
        return "WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess";
    case MessageName::WebPageProxy_ShowColorPicker:
        return "WebPageProxy_ShowColorPicker";
    case MessageName::WebPageProxy_ShowContactPicker:
        return "WebPageProxy_ShowContactPicker";
    case MessageName::WebPageProxy_ShowContextMenu:
        return "WebPageProxy_ShowContextMenu";
    case MessageName::WebPageProxy_ShowCorrectionPanel:
        return "WebPageProxy_ShowCorrectionPanel";
    case MessageName::WebPageProxy_ShowDataDetectorsUIForPositionInformation:
        return "WebPageProxy_ShowDataDetectorsUIForPositionInformation";
    case MessageName::WebPageProxy_ShowDataListSuggestions:
        return "WebPageProxy_ShowDataListSuggestions";
    case MessageName::WebPageProxy_ShowDateTimePicker:
        return "WebPageProxy_ShowDateTimePicker";
    case MessageName::WebPageProxy_ShowDictationAlternativeUI:
        return "WebPageProxy_ShowDictationAlternativeUI";
    case MessageName::WebPageProxy_ShowEmojiPicker:
        return "WebPageProxy_ShowEmojiPicker";
    case MessageName::WebPageProxy_ShowInspectorHighlight:
        return "WebPageProxy_ShowInspectorHighlight";
    case MessageName::WebPageProxy_ShowInspectorIndication:
        return "WebPageProxy_ShowInspectorIndication";
    case MessageName::WebPageProxy_ShowMediaControlsContextMenu:
        return "WebPageProxy_ShowMediaControlsContextMenu";
    case MessageName::WebPageProxy_ShowPage:
        return "WebPageProxy_ShowPage";
    case MessageName::WebPageProxy_ShowPlaybackTargetPicker:
        return "WebPageProxy_ShowPlaybackTargetPicker";
    case MessageName::WebPageProxy_ShowPopupMenu:
        return "WebPageProxy_ShowPopupMenu";
    case MessageName::WebPageProxy_ShowShareSheet:
        return "WebPageProxy_ShowShareSheet";
    case MessageName::WebPageProxy_ShowTelephoneNumberMenu:
        return "WebPageProxy_ShowTelephoneNumberMenu";
    case MessageName::WebPageProxy_ShowValidationMessage:
        return "WebPageProxy_ShowValidationMessage";
    case MessageName::WebPageProxy_Speak:
        return "WebPageProxy_Speak";
    case MessageName::WebPageProxy_SpeechSynthesisCancel:
        return "WebPageProxy_SpeechSynthesisCancel";
    case MessageName::WebPageProxy_SpeechSynthesisPause:
        return "WebPageProxy_SpeechSynthesisPause";
    case MessageName::WebPageProxy_SpeechSynthesisResetState:
        return "WebPageProxy_SpeechSynthesisResetState";
    case MessageName::WebPageProxy_SpeechSynthesisResume:
        return "WebPageProxy_SpeechSynthesisResume";
    case MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback:
        return "WebPageProxy_SpeechSynthesisSetFinishedCallback";
    case MessageName::WebPageProxy_SpeechSynthesisSpeak:
        return "WebPageProxy_SpeechSynthesisSpeak";
    case MessageName::WebPageProxy_StartApplePayAMSUISession:
        return "WebPageProxy_StartApplePayAMSUISession";
    case MessageName::WebPageProxy_StartDrag:
        return "WebPageProxy_StartDrag";
    case MessageName::WebPageProxy_StartURLSchemeTask:
        return "WebPageProxy_StartURLSchemeTask";
    case MessageName::WebPageProxy_StopSpeaking:
        return "WebPageProxy_StopSpeaking";
    case MessageName::WebPageProxy_StopURLSchemeTask:
        return "WebPageProxy_StopURLSchemeTask";
    case MessageName::WebPageProxy_StoreAppHighlight:
        return "WebPageProxy_StoreAppHighlight";
    case MessageName::WebPageProxy_TakeFocus:
        return "WebPageProxy_TakeFocus";
    case MessageName::WebPageProxy_TakeModelElementFullscreen:
        return "WebPageProxy_TakeModelElementFullscreen";
    case MessageName::WebPageProxy_ThemeColorChanged:
        return "WebPageProxy_ThemeColorChanged";
    case MessageName::WebPageProxy_TouchBarMenuDataChanged:
        return "WebPageProxy_TouchBarMenuDataChanged";
    case MessageName::WebPageProxy_TouchBarMenuItemDataAdded:
        return "WebPageProxy_TouchBarMenuItemDataAdded";
    case MessageName::WebPageProxy_TouchBarMenuItemDataRemoved:
        return "WebPageProxy_TouchBarMenuItemDataRemoved";
    case MessageName::WebPageProxy_UnableToImplementPolicy:
        return "WebPageProxy_UnableToImplementPolicy";
    case MessageName::WebPageProxy_UpdateInputContextAfterBlurringAndRefocusingElement:
        return "WebPageProxy_UpdateInputContextAfterBlurringAndRefocusingElement";
    case MessageName::WebPageProxy_UpdateMediaUsageManagerSessionState:
        return "WebPageProxy_UpdateMediaUsageManagerSessionState";
    case MessageName::WebPageProxy_UpdatePDFHUDLocation:
        return "WebPageProxy_UpdatePDFHUDLocation";
    case MessageName::WebPageProxy_UpdateSpellingUIWithGrammarString:
        return "WebPageProxy_UpdateSpellingUIWithGrammarString";
    case MessageName::WebPageProxy_UpdateSpellingUIWithMisspelledWord:
        return "WebPageProxy_UpdateSpellingUIWithMisspelledWord";
    case MessageName::WebPageProxy_UpdateStringForFind:
        return "WebPageProxy_UpdateStringForFind";
    case MessageName::WebPageProxy_UseFixedLayoutDidChange:
        return "WebPageProxy_UseFixedLayoutDidChange";
    case MessageName::WebPageProxy_WillGoToBackForwardListItem:
        return "WebPageProxy_WillGoToBackForwardListItem";
    case MessageName::WebPageProxy_WillPerformClientRedirectForFrame:
        return "WebPageProxy_WillPerformClientRedirectForFrame";
    case MessageName::WebPageProxy_WillReceiveEditDragSnapshot:
        return "WebPageProxy_WillReceiveEditDragSnapshot";
    case MessageName::WebPageProxy_WillSubmitForm:
        return "WebPageProxy_WillSubmitForm";
    case MessageName::WebPageProxy_WritePromisedAttachmentToPasteboard:
        return "WebPageProxy_WritePromisedAttachmentToPasteboard";
    case MessageName::WebPageProxy_toggleAutomaticDashSubstitution:
        return "WebPageProxy_toggleAutomaticDashSubstitution";
    case MessageName::WebPageProxy_toggleAutomaticLinkDetection:
        return "WebPageProxy_toggleAutomaticLinkDetection";
    case MessageName::WebPageProxy_toggleAutomaticQuoteSubstitution:
        return "WebPageProxy_toggleAutomaticQuoteSubstitution";
    case MessageName::WebPageProxy_toggleAutomaticTextReplacement:
        return "WebPageProxy_toggleAutomaticTextReplacement";
    case MessageName::WebPageProxy_toggleSmartInsertDelete:
        return "WebPageProxy_toggleSmartInsertDelete";
    case MessageName::WebPage_AccessibilitySettingsDidChange:
        return "WebPage_AccessibilitySettingsDidChange";
    case MessageName::WebPage_AddConsoleMessage:
        return "WebPage_AddConsoleMessage";
    case MessageName::WebPage_AddMIMETypeWithCustomContentProvider:
        return "WebPage_AddMIMETypeWithCustomContentProvider";
    case MessageName::WebPage_AdvanceToNextMisspelling:
        return "WebPage_AdvanceToNextMisspelling";
    case MessageName::WebPage_ApplicationDidBecomeActive:
        return "WebPage_ApplicationDidBecomeActive";
    case MessageName::WebPage_ApplicationDidEnterBackground:
        return "WebPage_ApplicationDidEnterBackground";
    case MessageName::WebPage_ApplicationDidEnterBackgroundForMedia:
        return "WebPage_ApplicationDidEnterBackgroundForMedia";
    case MessageName::WebPage_ApplicationDidFinishSnapshottingAfterEnteringBackground:
        return "WebPage_ApplicationDidFinishSnapshottingAfterEnteringBackground";
    case MessageName::WebPage_ApplicationWillEnterForeground:
        return "WebPage_ApplicationWillEnterForeground";
    case MessageName::WebPage_ApplicationWillEnterForegroundForMedia:
        return "WebPage_ApplicationWillEnterForegroundForMedia";
    case MessageName::WebPage_ApplicationWillResignActive:
        return "WebPage_ApplicationWillResignActive";
    case MessageName::WebPage_ApplyAutocorrection:
        return "WebPage_ApplyAutocorrection";
    case MessageName::WebPage_AttemptSyntheticClick:
        return "WebPage_AttemptSyntheticClick";
    case MessageName::WebPage_AttributedSubstringForCharacterRangeAsync:
        return "WebPage_AttributedSubstringForCharacterRangeAsync";
    case MessageName::WebPage_AutofillLoginCredentials:
        return "WebPage_AutofillLoginCredentials";
    case MessageName::WebPage_BeginPrinting:
        return "WebPage_BeginPrinting";
    case MessageName::WebPage_BeginSelectionInDirection:
        return "WebPage_BeginSelectionInDirection";
    case MessageName::WebPage_BlurFocusedElement:
        return "WebPage_BlurFocusedElement";
    case MessageName::WebPage_BoundaryEventOccurred:
        return "WebPage_BoundaryEventOccurred";
    case MessageName::WebPage_CancelAutoscroll:
        return "WebPage_CancelAutoscroll";
    case MessageName::WebPage_CancelComposition:
        return "WebPage_CancelComposition";
    case MessageName::WebPage_CancelPointer:
        return "WebPage_CancelPointer";
    case MessageName::WebPage_CancelPotentialTap:
        return "WebPage_CancelPotentialTap";
    case MessageName::WebPage_CapitalizeWord:
        return "WebPage_CapitalizeWord";
    case MessageName::WebPage_CaptureDevicesChanged:
        return "WebPage_CaptureDevicesChanged";
    case MessageName::WebPage_CenterSelectionInVisibleArea:
        return "WebPage_CenterSelectionInVisibleArea";
    case MessageName::WebPage_ChangeFont:
        return "WebPage_ChangeFont";
    case MessageName::WebPage_ChangeFontAttributes:
        return "WebPage_ChangeFontAttributes";
    case MessageName::WebPage_ChangeListType:
        return "WebPage_ChangeListType";
    case MessageName::WebPage_ChangeSpellingToWord:
        return "WebPage_ChangeSpellingToWord";
    case MessageName::WebPage_CharacterIndexForPointAsync:
        return "WebPage_CharacterIndexForPointAsync";
    case MessageName::WebPage_ClearAllDecoratedFoundText:
        return "WebPage_ClearAllDecoratedFoundText";
    case MessageName::WebPage_ClearLoadedSubresourceDomains:
        return "WebPage_ClearLoadedSubresourceDomains";
    case MessageName::WebPage_ClearSelection:
        return "WebPage_ClearSelection";
    case MessageName::WebPage_ClearServiceWorkerEntitlementOverride:
        return "WebPage_ClearServiceWorkerEntitlementOverride";
    case MessageName::WebPage_ClearWheelEventTestMonitor:
        return "WebPage_ClearWheelEventTestMonitor";
    case MessageName::WebPage_Close:
        return "WebPage_Close";
    case MessageName::WebPage_CollapseSelectionInFrame:
        return "WebPage_CollapseSelectionInFrame";
    case MessageName::WebPage_CommitPotentialTap:
        return "WebPage_CommitPotentialTap";
    case MessageName::WebPage_CompleteTextManipulation:
        return "WebPage_CompleteTextManipulation";
    case MessageName::WebPage_ComputePagesForPrinting:
        return "WebPage_ComputePagesForPrinting";
    case MessageName::WebPage_ConfirmCompositionAsync:
        return "WebPage_ConfirmCompositionAsync";
    case MessageName::WebPage_ConnectInspector:
        return "WebPage_ConnectInspector";
    case MessageName::WebPage_ContentSizeCategoryDidChange:
        return "WebPage_ContentSizeCategoryDidChange";
    case MessageName::WebPage_ContextMenuForKeyEvent:
        return "WebPage_ContextMenuForKeyEvent";
    case MessageName::WebPage_ContinueWillSubmitForm:
        return "WebPage_ContinueWillSubmitForm";
    case MessageName::WebPage_CountStringMatches:
        return "WebPage_CountStringMatches";
    case MessageName::WebPage_CreateAppHighlightInSelectedRange:
        return "WebPage_CreateAppHighlightInSelectedRange";
    case MessageName::WebPage_CreateMediaSessionCoordinator:
        return "WebPage_CreateMediaSessionCoordinator";
    case MessageName::WebPage_DataDetectorsDidChangeUI:
        return "WebPage_DataDetectorsDidChangeUI";
    case MessageName::WebPage_DataDetectorsDidHideUI:
        return "WebPage_DataDetectorsDidHideUI";
    case MessageName::WebPage_DataDetectorsDidPresentUI:
        return "WebPage_DataDetectorsDidPresentUI";
    case MessageName::WebPage_DecorateTextRangeWithStyle:
        return "WebPage_DecorateTextRangeWithStyle";
    case MessageName::WebPage_DecreaseListLevel:
        return "WebPage_DecreaseListLevel";
    case MessageName::WebPage_DeleteSurrounding:
        return "WebPage_DeleteSurrounding";
    case MessageName::WebPage_DetectDataInAllFrames:
        return "WebPage_DetectDataInAllFrames";
    case MessageName::WebPage_DidAcquirePointerLock:
        return "WebPage_DidAcquirePointerLock";
    case MessageName::WebPage_DidBeginTextSearchOperation:
        return "WebPage_DidBeginTextSearchOperation";
    case MessageName::WebPage_DidCancelCheckingText:
        return "WebPage_DidCancelCheckingText";
    case MessageName::WebPage_DidCancelForOpenPanel:
        return "WebPage_DidCancelForOpenPanel";
    case MessageName::WebPage_DidChangeSelectedIndexForActivePopupMenu:
        return "WebPage_DidChangeSelectedIndexForActivePopupMenu";
    case MessageName::WebPage_DidChooseColor:
        return "WebPage_DidChooseColor";
    case MessageName::WebPage_DidChooseDate:
        return "WebPage_DidChooseDate";
    case MessageName::WebPage_DidChooseFilesForOpenPanel:
        return "WebPage_DidChooseFilesForOpenPanel";
    case MessageName::WebPage_DidChooseFilesForOpenPanelWithDisplayStringAndIcon:
        return "WebPage_DidChooseFilesForOpenPanelWithDisplayStringAndIcon";
    case MessageName::WebPage_DidCloseSuggestions:
        return "WebPage_DidCloseSuggestions";
    case MessageName::WebPage_DidConcludeDrop:
        return "WebPage_DidConcludeDrop";
    case MessageName::WebPage_DidDismissContextMenu:
        return "WebPage_DidDismissContextMenu";
    case MessageName::WebPage_DidEndColorPicker:
        return "WebPage_DidEndColorPicker";
    case MessageName::WebPage_DidEndDateTimePicker:
        return "WebPage_DidEndDateTimePicker";
    case MessageName::WebPage_DidEndMagnificationGesture:
        return "WebPage_DidEndMagnificationGesture";
    case MessageName::WebPage_DidEndRequestInstallMissingMediaPlugins:
        return "WebPage_DidEndRequestInstallMissingMediaPlugins";
    case MessageName::WebPage_DidEndTextSearchOperation:
        return "WebPage_DidEndTextSearchOperation";
    case MessageName::WebPage_DidFinishCheckingText:
        return "WebPage_DidFinishCheckingText";
    case MessageName::WebPage_DidGetLoadDecisionForIcon:
        return "WebPage_DidGetLoadDecisionForIcon";
    case MessageName::WebPage_DidLosePointerLock:
        return "WebPage_DidLosePointerLock";
    case MessageName::WebPage_DidNotAcquirePointerLock:
        return "WebPage_DidNotAcquirePointerLock";
    case MessageName::WebPage_DidReceiveGeolocationPermissionDecision:
        return "WebPage_DidReceiveGeolocationPermissionDecision";
    case MessageName::WebPage_DidReceivePolicyDecision:
        return "WebPage_DidReceivePolicyDecision";
    case MessageName::WebPage_DidRecognizeLongPress:
        return "WebPage_DidRecognizeLongPress";
    case MessageName::WebPage_DidRemoveBackForwardItem:
        return "WebPage_DidRemoveBackForwardItem";
    case MessageName::WebPage_DidRemoveEditCommand:
        return "WebPage_DidRemoveEditCommand";
    case MessageName::WebPage_DidSelectDataListOption:
        return "WebPage_DidSelectDataListOption";
    case MessageName::WebPage_DidSelectItemFromActiveContextMenu:
        return "WebPage_DidSelectItemFromActiveContextMenu";
    case MessageName::WebPage_DidShowContextMenu:
        return "WebPage_DidShowContextMenu";
    case MessageName::WebPage_DidStartDrag:
        return "WebPage_DidStartDrag";
    case MessageName::WebPage_DisconnectInspector:
        return "WebPage_DisconnectInspector";
    case MessageName::WebPage_DispatchWheelEventWithoutScrolling:
        return "WebPage_DispatchWheelEventWithoutScrolling";
    case MessageName::WebPage_DragCancelled:
        return "WebPage_DragCancelled";
    case MessageName::WebPage_DragEnded:
        return "WebPage_DragEnded";
    case MessageName::WebPage_DrawPagesForPrinting:
        return "WebPage_DrawPagesForPrinting";
    case MessageName::WebPage_DrawPagesToPDF:
        return "WebPage_DrawPagesToPDF";
    case MessageName::WebPage_DrawRectToImage:
        return "WebPage_DrawRectToImage";
    case MessageName::WebPage_DrawToPDF:
        return "WebPage_DrawToPDF";
    case MessageName::WebPage_DrawToPDFiOS:
        return "WebPage_DrawToPDFiOS";
    case MessageName::WebPage_DynamicViewportSizeUpdate:
        return "WebPage_DynamicViewportSizeUpdate";
    case MessageName::WebPage_EffectiveAppearanceDidChange:
        return "WebPage_EffectiveAppearanceDidChange";
    case MessageName::WebPage_EndPrinting:
        return "WebPage_EndPrinting";
    case MessageName::WebPage_EnqueueSecurityPolicyViolationEvent:
        return "WebPage_EnqueueSecurityPolicyViolationEvent";
    case MessageName::WebPage_ExecuteEditCommand:
        return "WebPage_ExecuteEditCommand";
    case MessageName::WebPage_ExecuteEditCommandWithCallback:
        return "WebPage_ExecuteEditCommandWithCallback";
    case MessageName::WebPage_ExtendSandboxForFilesFromOpenPanel:
        return "WebPage_ExtendSandboxForFilesFromOpenPanel";
    case MessageName::WebPage_ExtendSelection:
        return "WebPage_ExtendSelection";
    case MessageName::WebPage_FailedToShowPopupMenu:
        return "WebPage_FailedToShowPopupMenu";
    case MessageName::WebPage_FindRectsForStringMatches:
        return "WebPage_FindRectsForStringMatches";
    case MessageName::WebPage_FindString:
        return "WebPage_FindString";
    case MessageName::WebPage_FindStringMatches:
        return "WebPage_FindStringMatches";
    case MessageName::WebPage_FindTextRangesForStringMatches:
        return "WebPage_FindTextRangesForStringMatches";
    case MessageName::WebPage_FirstRectForCharacterRangeAsync:
        return "WebPage_FirstRectForCharacterRangeAsync";
    case MessageName::WebPage_FocusNextFocusedElement:
        return "WebPage_FocusNextFocusedElement";
    case MessageName::WebPage_FocusTextInputContextAndPlaceCaret:
        return "WebPage_FocusTextInputContextAndPlaceCaret";
    case MessageName::WebPage_ForceRepaint:
        return "WebPage_ForceRepaint";
    case MessageName::WebPage_FrameBecameRemote:
        return "WebPage_FrameBecameRemote";
    case MessageName::WebPage_FreezeLayerTreeDueToSwipeAnimation:
        return "WebPage_FreezeLayerTreeDueToSwipeAnimation";
    case MessageName::WebPage_GamepadActivity:
        return "WebPage_GamepadActivity";
    case MessageName::WebPage_GenerateSyntheticEditingCommand:
        return "WebPage_GenerateSyntheticEditingCommand";
    case MessageName::WebPage_GetAllFrames:
        return "WebPage_GetAllFrames";
    case MessageName::WebPage_GetApplicationManifest:
        return "WebPage_GetApplicationManifest";
    case MessageName::WebPage_GetBytecodeProfile:
        return "WebPage_GetBytecodeProfile";
    case MessageName::WebPage_GetContentsAsAttributedString:
        return "WebPage_GetContentsAsAttributedString";
    case MessageName::WebPage_GetContentsAsMHTMLData:
        return "WebPage_GetContentsAsMHTMLData";
    case MessageName::WebPage_GetContentsAsString:
        return "WebPage_GetContentsAsString";
    case MessageName::WebPage_GetImageForFindMatch:
        return "WebPage_GetImageForFindMatch";
    case MessageName::WebPage_GetLoadedSubresourceDomains:
        return "WebPage_GetLoadedSubresourceDomains";
    case MessageName::WebPage_GetMainResourceDataOfFrame:
        return "WebPage_GetMainResourceDataOfFrame";
    case MessageName::WebPage_GetMarkedRangeAsync:
        return "WebPage_GetMarkedRangeAsync";
    case MessageName::WebPage_GetPDFFirstPageSize:
        return "WebPage_GetPDFFirstPageSize";
    case MessageName::WebPage_GetProcessDisplayName:
        return "WebPage_GetProcessDisplayName";
    case MessageName::WebPage_GetRectsAtSelectionOffsetWithText:
        return "WebPage_GetRectsAtSelectionOffsetWithText";
    case MessageName::WebPage_GetRectsForGranularityWithSelectionOffset:
        return "WebPage_GetRectsForGranularityWithSelectionOffset";
    case MessageName::WebPage_GetRenderTreeExternalRepresentation:
        return "WebPage_GetRenderTreeExternalRepresentation";
    case MessageName::WebPage_GetResourceDataFromFrame:
        return "WebPage_GetResourceDataFromFrame";
    case MessageName::WebPage_GetSamplingProfilerOutput:
        return "WebPage_GetSamplingProfilerOutput";
    case MessageName::WebPage_GetSelectedRangeAsync:
        return "WebPage_GetSelectedRangeAsync";
    case MessageName::WebPage_GetSelectionAsWebArchiveData:
        return "WebPage_GetSelectionAsWebArchiveData";
    case MessageName::WebPage_GetSelectionContext:
        return "WebPage_GetSelectionContext";
    case MessageName::WebPage_GetSelectionOrContentsAsString:
        return "WebPage_GetSelectionOrContentsAsString";
    case MessageName::WebPage_GetSourceForFrame:
        return "WebPage_GetSourceForFrame";
    case MessageName::WebPage_GetWebArchiveOfFrame:
        return "WebPage_GetWebArchiveOfFrame";
    case MessageName::WebPage_GoToBackForwardItem:
        return "WebPage_GoToBackForwardItem";
    case MessageName::WebPage_HandleAcceptedCandidate:
        return "WebPage_HandleAcceptedCandidate";
    case MessageName::WebPage_HandleAlternativeTextUIResult:
        return "WebPage_HandleAlternativeTextUIResult";
    case MessageName::WebPage_HandleAutocorrectionContextRequest:
        return "WebPage_HandleAutocorrectionContextRequest";
    case MessageName::WebPage_HandleDoubleTapForDoubleClickAtPoint:
        return "WebPage_HandleDoubleTapForDoubleClickAtPoint";
    case MessageName::WebPage_HandleTwoFingerTapAtPoint:
        return "WebPage_HandleTwoFingerTapAtPoint";
    case MessageName::WebPage_HardwareKeyboardAvailabilityChanged:
        return "WebPage_HardwareKeyboardAvailabilityChanged";
    case MessageName::WebPage_HasMarkedText:
        return "WebPage_HasMarkedText";
    case MessageName::WebPage_HideFindIndicator:
        return "WebPage_HideFindIndicator";
    case MessageName::WebPage_HideFindUI:
        return "WebPage_HideFindUI";
    case MessageName::WebPage_ImmediateActionDidCancel:
        return "WebPage_ImmediateActionDidCancel";
    case MessageName::WebPage_ImmediateActionDidComplete:
        return "WebPage_ImmediateActionDidComplete";
    case MessageName::WebPage_ImmediateActionDidUpdate:
        return "WebPage_ImmediateActionDidUpdate";
    case MessageName::WebPage_IncreaseListLevel:
        return "WebPage_IncreaseListLevel";
    case MessageName::WebPage_IndicateFindMatch:
        return "WebPage_IndicateFindMatch";
    case MessageName::WebPage_InsertAttachment:
        return "WebPage_InsertAttachment";
    case MessageName::WebPage_InsertDictatedTextAsync:
        return "WebPage_InsertDictatedTextAsync";
    case MessageName::WebPage_InsertDroppedImagePlaceholders:
        return "WebPage_InsertDroppedImagePlaceholders";
    case MessageName::WebPage_InsertTextAsync:
        return "WebPage_InsertTextAsync";
    case MessageName::WebPage_InsertTextPlaceholder:
        return "WebPage_InsertTextPlaceholder";
    case MessageName::WebPage_InspectorNodeSearchEndedAtPosition:
        return "WebPage_InspectorNodeSearchEndedAtPosition";
    case MessageName::WebPage_InspectorNodeSearchMovedToPosition:
        return "WebPage_InspectorNodeSearchMovedToPosition";
    case MessageName::WebPage_InstallCroppedImageOverlay:
        return "WebPage_InstallCroppedImageOverlay";
    case MessageName::WebPage_InteractableRegionsInRootViewCoordinates:
        return "WebPage_InteractableRegionsInRootViewCoordinates";
    case MessageName::WebPage_InvalidateMediaSessionCoordinator:
        return "WebPage_InvalidateMediaSessionCoordinator";
    case MessageName::WebPage_IsLayerTreeFrozen:
        return "WebPage_IsLayerTreeFrozen";
    case MessageName::WebPage_KeyEvent:
        return "WebPage_KeyEvent";
    case MessageName::WebPage_LastNavigationWasAppInitiated:
        return "WebPage_LastNavigationWasAppInitiated";
    case MessageName::WebPage_ListenForLayoutMilestones:
        return "WebPage_ListenForLayoutMilestones";
    case MessageName::WebPage_LoadAlternateHTML:
        return "WebPage_LoadAlternateHTML";
    case MessageName::WebPage_LoadData:
        return "WebPage_LoadData";
    case MessageName::WebPage_LoadDataInFrame:
        return "WebPage_LoadDataInFrame";
    case MessageName::WebPage_LoadRequest:
        return "WebPage_LoadRequest";
    case MessageName::WebPage_LoadRequestWaitingForProcessLaunch:
        return "WebPage_LoadRequestWaitingForProcessLaunch";
    case MessageName::WebPage_LoadSimulatedRequestAndResponse:
        return "WebPage_LoadSimulatedRequestAndResponse";
    case MessageName::WebPage_LoadURLInFrame:
        return "WebPage_LoadURLInFrame";
    case MessageName::WebPage_LowercaseWord:
        return "WebPage_LowercaseWord";
    case MessageName::WebPage_MediaKeySystemWasDenied:
        return "WebPage_MediaKeySystemWasDenied";
    case MessageName::WebPage_MediaKeySystemWasGranted:
        return "WebPage_MediaKeySystemWasGranted";
    case MessageName::WebPage_MouseEvent:
        return "WebPage_MouseEvent";
    case MessageName::WebPage_MoveSelectionAtBoundaryWithDirection:
        return "WebPage_MoveSelectionAtBoundaryWithDirection";
    case MessageName::WebPage_MoveSelectionByOffset:
        return "WebPage_MoveSelectionByOffset";
    case MessageName::WebPage_NavigateToPDFLinkWithSimulatedClick:
        return "WebPage_NavigateToPDFLinkWithSimulatedClick";
    case MessageName::WebPage_NotifyUserScripts:
        return "WebPage_NotifyUserScripts";
    case MessageName::WebPage_OpenPDFWithPreview:
        return "WebPage_OpenPDFWithPreview";
    case MessageName::WebPage_PauseAllMediaPlayback:
        return "WebPage_PauseAllMediaPlayback";
    case MessageName::WebPage_PerformActionOnElement:
        return "WebPage_PerformActionOnElement";
    case MessageName::WebPage_PerformDictionaryLookupAtLocation:
        return "WebPage_PerformDictionaryLookupAtLocation";
    case MessageName::WebPage_PerformDictionaryLookupOfCurrentSelection:
        return "WebPage_PerformDictionaryLookupOfCurrentSelection";
    case MessageName::WebPage_PerformDragControllerAction:
        return "WebPage_PerformDragControllerAction";
    case MessageName::WebPage_PerformImmediateActionHitTestAtLocation:
        return "WebPage_PerformImmediateActionHitTestAtLocation";
    case MessageName::WebPage_PlaybackTargetAvailabilityDidChange:
        return "WebPage_PlaybackTargetAvailabilityDidChange";
    case MessageName::WebPage_PlaybackTargetPickerWasDismissed:
        return "WebPage_PlaybackTargetPickerWasDismissed";
    case MessageName::WebPage_PlaybackTargetSelected:
        return "WebPage_PlaybackTargetSelected";
    case MessageName::WebPage_PostInjectedBundleMessage:
        return "WebPage_PostInjectedBundleMessage";
    case MessageName::WebPage_PotentialTapAtPosition:
        return "WebPage_PotentialTapAtPosition";
    case MessageName::WebPage_PreferencesDidChange:
        return "WebPage_PreferencesDidChange";
    case MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView:
        return "WebPage_PrepareSelectionForContextMenuWithLocationInView";
    case MessageName::WebPage_ReapplyEditCommand:
        return "WebPage_ReapplyEditCommand";
    case MessageName::WebPage_RegisterUIProcessAccessibilityTokens:
        return "WebPage_RegisterUIProcessAccessibilityTokens";
    case MessageName::WebPage_RegisterURLSchemeHandler:
        return "WebPage_RegisterURLSchemeHandler";
    case MessageName::WebPage_Reload:
        return "WebPage_Reload";
    case MessageName::WebPage_RemoveDataDetectedLinks:
        return "WebPage_RemoveDataDetectedLinks";
    case MessageName::WebPage_RemoveTextPlaceholder:
        return "WebPage_RemoveTextPlaceholder";
    case MessageName::WebPage_ReplaceDictatedText:
        return "WebPage_ReplaceDictatedText";
    case MessageName::WebPage_ReplaceMatches:
        return "WebPage_ReplaceMatches";
    case MessageName::WebPage_ReplaceSelectedText:
        return "WebPage_ReplaceSelectedText";
    case MessageName::WebPage_ReplaceSelectionWithPasteboardData:
        return "WebPage_ReplaceSelectionWithPasteboardData";
    case MessageName::WebPage_ReplaceWithPasteboardData:
        return "WebPage_ReplaceWithPasteboardData";
    case MessageName::WebPage_RequestAcceptsFirstMouse:
        return "WebPage_RequestAcceptsFirstMouse";
    case MessageName::WebPage_RequestActiveNowPlayingSessionInfo:
        return "WebPage_RequestActiveNowPlayingSessionInfo";
    case MessageName::WebPage_RequestAdditionalItemsForDragSession:
        return "WebPage_RequestAdditionalItemsForDragSession";
    case MessageName::WebPage_RequestAutocorrectionData:
        return "WebPage_RequestAutocorrectionData";
    case MessageName::WebPage_RequestDictationContext:
        return "WebPage_RequestDictationContext";
    case MessageName::WebPage_RequestDocumentEditingContext:
        return "WebPage_RequestDocumentEditingContext";
    case MessageName::WebPage_RequestDragStart:
        return "WebPage_RequestDragStart";
    case MessageName::WebPage_RequestEvasionRectsAboveSelection:
        return "WebPage_RequestEvasionRectsAboveSelection";
    case MessageName::WebPage_RequestFocusedElementInformation:
        return "WebPage_RequestFocusedElementInformation";
    case MessageName::WebPage_RequestFontAttributesAtSelectionStart:
        return "WebPage_RequestFontAttributesAtSelectionStart";
    case MessageName::WebPage_RequestImageBitmap:
        return "WebPage_RequestImageBitmap";
    case MessageName::WebPage_RequestMediaPlaybackState:
        return "WebPage_RequestMediaPlaybackState";
    case MessageName::WebPage_RequestPositionInformation:
        return "WebPage_RequestPositionInformation";
    case MessageName::WebPage_RequestRVItemInCurrentSelectedRange:
        return "WebPage_RequestRVItemInCurrentSelectedRange";
    case MessageName::WebPage_RequestRectForFoundTextRange:
        return "WebPage_RequestRectForFoundTextRange";
    case MessageName::WebPage_ResetPotentialTapSecurityOrigin:
        return "WebPage_ResetPotentialTapSecurityOrigin";
    case MessageName::WebPage_RestoreAppHighlightsAndScrollToIndex:
        return "WebPage_RestoreAppHighlightsAndScrollToIndex";
    case MessageName::WebPage_RestoreSelectionInFocusedEditableElement:
        return "WebPage_RestoreSelectionInFocusedEditableElement";
    case MessageName::WebPage_RestoreSession:
        return "WebPage_RestoreSession";
    case MessageName::WebPage_Resume:
        return "WebPage_Resume";
    case MessageName::WebPage_ResumeActiveDOMObjectsAndAnimations:
        return "WebPage_ResumeActiveDOMObjectsAndAnimations";
    case MessageName::WebPage_ResumeAllMediaPlayback:
        return "WebPage_ResumeAllMediaPlayback";
    case MessageName::WebPage_RunJavaScriptInFrameInScriptWorld:
        return "WebPage_RunJavaScriptInFrameInScriptWorld";
    case MessageName::WebPage_SavePDF:
        return "WebPage_SavePDF";
    case MessageName::WebPage_ScalePage:
        return "WebPage_ScalePage";
    case MessageName::WebPage_ScalePageInViewCoordinates:
        return "WebPage_ScalePageInViewCoordinates";
    case MessageName::WebPage_ScaleView:
        return "WebPage_ScaleView";
    case MessageName::WebPage_ScheduleFullEditorStateUpdate:
        return "WebPage_ScheduleFullEditorStateUpdate";
    case MessageName::WebPage_ScrollBy:
        return "WebPage_ScrollBy";
    case MessageName::WebPage_ScrollTextRangeToVisible:
        return "WebPage_ScrollTextRangeToVisible";
    case MessageName::WebPage_ScrollToRect:
        return "WebPage_ScrollToRect";
    case MessageName::WebPage_SelectAll:
        return "WebPage_SelectAll";
    case MessageName::WebPage_SelectFindMatch:
        return "WebPage_SelectFindMatch";
    case MessageName::WebPage_SelectPositionAtBoundaryWithDirection:
        return "WebPage_SelectPositionAtBoundaryWithDirection";
    case MessageName::WebPage_SelectPositionAtPoint:
        return "WebPage_SelectPositionAtPoint";
    case MessageName::WebPage_SelectTextWithGranularityAtPoint:
        return "WebPage_SelectTextWithGranularityAtPoint";
    case MessageName::WebPage_SelectWithGesture:
        return "WebPage_SelectWithGesture";
    case MessageName::WebPage_SelectWithTwoTouches:
        return "WebPage_SelectWithTwoTouches";
    case MessageName::WebPage_SelectWordBackward:
        return "WebPage_SelectWordBackward";
    case MessageName::WebPage_SendCSPViolationReport:
        return "WebPage_SendCSPViolationReport";
    case MessageName::WebPage_SendMessageToTargetBackend:
        return "WebPage_SendMessageToTargetBackend";
    case MessageName::WebPage_SendMessageToWebExtension:
        return "WebPage_SendMessageToWebExtension";
    case MessageName::WebPage_SendMessageToWebExtensionWithReply:
        return "WebPage_SendMessageToWebExtensionWithReply";
    case MessageName::WebPage_SetAccentColor:
        return "WebPage_SetAccentColor";
    case MessageName::WebPage_SetActivityState:
        return "WebPage_SetActivityState";
    case MessageName::WebPage_SetAllowsMediaDocumentInlinePlayback:
        return "WebPage_SetAllowsMediaDocumentInlinePlayback";
    case MessageName::WebPage_SetAlwaysShowsHorizontalScroller:
        return "WebPage_SetAlwaysShowsHorizontalScroller";
    case MessageName::WebPage_SetAlwaysShowsVerticalScroller:
        return "WebPage_SetAlwaysShowsVerticalScroller";
    case MessageName::WebPage_SetAppHighlightsVisibility:
        return "WebPage_SetAppHighlightsVisibility";
    case MessageName::WebPage_SetAutoSizingShouldExpandToViewHeight:
        return "WebPage_SetAutoSizingShouldExpandToViewHeight";
    case MessageName::WebPage_SetBackgroundColor:
        return "WebPage_SetBackgroundColor";
    case MessageName::WebPage_SetBackgroundExtendsBeyondPage:
        return "WebPage_SetBackgroundExtendsBeyondPage";
    case MessageName::WebPage_SetBaseWritingDirection:
        return "WebPage_SetBaseWritingDirection";
    case MessageName::WebPage_SetCanRunBeforeUnloadConfirmPanel:
        return "WebPage_SetCanRunBeforeUnloadConfirmPanel";
    case MessageName::WebPage_SetCanRunModal:
        return "WebPage_SetCanRunModal";
    case MessageName::WebPage_SetCanShowPlaceholder:
        return "WebPage_SetCanShowPlaceholder";
    case MessageName::WebPage_SetCanUseCredentialStorage:
        return "WebPage_SetCanUseCredentialStorage";
    case MessageName::WebPage_SetCompositionAsync:
        return "WebPage_SetCompositionAsync";
    case MessageName::WebPage_SetControlledByAutomation:
        return "WebPage_SetControlledByAutomation";
    case MessageName::WebPage_SetCroppedImageOverlayVisibility:
        return "WebPage_SetCroppedImageOverlayVisibility";
    case MessageName::WebPage_SetCurrentHistoryItemForReattach:
        return "WebPage_SetCurrentHistoryItemForReattach";
    case MessageName::WebPage_SetCustomTextEncodingName:
        return "WebPage_SetCustomTextEncodingName";
    case MessageName::WebPage_SetDefersLoading:
        return "WebPage_SetDefersLoading";
    case MessageName::WebPage_SetDeviceOrientation:
        return "WebPage_SetDeviceOrientation";
    case MessageName::WebPage_SetEditable:
        return "WebPage_SetEditable";
    case MessageName::WebPage_SetEnableHorizontalRubberBanding:
        return "WebPage_SetEnableHorizontalRubberBanding";
    case MessageName::WebPage_SetEnableVerticalRubberBanding:
        return "WebPage_SetEnableVerticalRubberBanding";
    case MessageName::WebPage_SetFixedLayoutSize:
        return "WebPage_SetFixedLayoutSize";
    case MessageName::WebPage_SetFocusedElementSelectedIndex:
        return "WebPage_SetFocusedElementSelectedIndex";
    case MessageName::WebPage_SetFocusedElementValue:
        return "WebPage_SetFocusedElementValue";
    case MessageName::WebPage_SetFooterBannerHeightForTesting:
        return "WebPage_SetFooterBannerHeightForTesting";
    case MessageName::WebPage_SetForceAlwaysUserScalable:
        return "WebPage_SetForceAlwaysUserScalable";
    case MessageName::WebPage_SetGapBetweenPages:
        return "WebPage_SetGapBetweenPages";
    case MessageName::WebPage_SetHasResourceLoadClient:
        return "WebPage_SetHasResourceLoadClient";
    case MessageName::WebPage_SetHeaderBannerHeightForTesting:
        return "WebPage_SetHeaderBannerHeightForTesting";
    case MessageName::WebPage_SetIndicating:
        return "WebPage_SetIndicating";
    case MessageName::WebPage_SetInitialFocus:
        return "WebPage_SetInitialFocus";
    case MessageName::WebPage_SetIsShowingInputViewForFocusedElement:
        return "WebPage_SetIsShowingInputViewForFocusedElement";
    case MessageName::WebPage_SetIsSuspended:
        return "WebPage_SetIsSuspended";
    case MessageName::WebPage_SetIsTakingSnapshotsForApplicationSuspension:
        return "WebPage_SetIsTakingSnapshotsForApplicationSuspension";
    case MessageName::WebPage_SetLayerHostingMode:
        return "WebPage_SetLayerHostingMode";
    case MessageName::WebPage_SetMainFrameIsScrollable:
        return "WebPage_SetMainFrameIsScrollable";
    case MessageName::WebPage_SetMaximumUnobscuredSize:
        return "WebPage_SetMaximumUnobscuredSize";
    case MessageName::WebPage_SetMayStartMediaWhenInWindow:
        return "WebPage_SetMayStartMediaWhenInWindow";
    case MessageName::WebPage_SetMediaVolume:
        return "WebPage_SetMediaVolume";
    case MessageName::WebPage_SetMinimumSizeForAutoLayout:
        return "WebPage_SetMinimumSizeForAutoLayout";
    case MessageName::WebPage_SetMinimumUnobscuredSize:
        return "WebPage_SetMinimumUnobscuredSize";
    case MessageName::WebPage_SetMockCameraIsInterrupted:
        return "WebPage_SetMockCameraIsInterrupted";
    case MessageName::WebPage_SetMuted:
        return "WebPage_SetMuted";
    case MessageName::WebPage_SetNeedsDOMWindowResizeEvent:
        return "WebPage_SetNeedsDOMWindowResizeEvent";
    case MessageName::WebPage_SetNeedsFontAttributes:
        return "WebPage_SetNeedsFontAttributes";
    case MessageName::WebPage_SetOrientationForMediaCapture:
        return "WebPage_SetOrientationForMediaCapture";
    case MessageName::WebPage_SetOverriddenMediaType:
        return "WebPage_SetOverriddenMediaType";
    case MessageName::WebPage_SetOverrideViewportArguments:
        return "WebPage_SetOverrideViewportArguments";
    case MessageName::WebPage_SetPageAndTextZoomFactors:
        return "WebPage_SetPageAndTextZoomFactors";
    case MessageName::WebPage_SetPageLength:
        return "WebPage_SetPageLength";
    case MessageName::WebPage_SetPageZoomFactor:
        return "WebPage_SetPageZoomFactor";
    case MessageName::WebPage_SetPaginationBehavesLikeColumns:
        return "WebPage_SetPaginationBehavesLikeColumns";
    case MessageName::WebPage_SetPaginationLineGridEnabled:
        return "WebPage_SetPaginationLineGridEnabled";
    case MessageName::WebPage_SetPaginationMode:
        return "WebPage_SetPaginationMode";
    case MessageName::WebPage_SetScreenIsBeingCaptured:
        return "WebPage_SetScreenIsBeingCaptured";
    case MessageName::WebPage_SetScrollPinningBehavior:
        return "WebPage_SetScrollPinningBehavior";
    case MessageName::WebPage_SetScrollbarOverlayStyle:
        return "WebPage_SetScrollbarOverlayStyle";
    case MessageName::WebPage_SetShouldDispatchFakeMouseMoveEvents:
        return "WebPage_SetShouldDispatchFakeMouseMoveEvents";
    case MessageName::WebPage_SetShouldPlayToPlaybackTarget:
        return "WebPage_SetShouldPlayToPlaybackTarget";
    case MessageName::WebPage_SetShouldRevealCurrentSelectionAfterInsertion:
        return "WebPage_SetShouldRevealCurrentSelectionAfterInsertion";
    case MessageName::WebPage_SetShouldScaleViewToFitDocument:
        return "WebPage_SetShouldScaleViewToFitDocument";
    case MessageName::WebPage_SetSizeToContentAutoSizeMaximumSize:
        return "WebPage_SetSizeToContentAutoSizeMaximumSize";
    case MessageName::WebPage_SetSmartInsertDeleteEnabled:
        return "WebPage_SetSmartInsertDeleteEnabled";
    case MessageName::WebPage_SetSuppressScrollbarAnimations:
        return "WebPage_SetSuppressScrollbarAnimations";
    case MessageName::WebPage_SetTextAsync:
        return "WebPage_SetTextAsync";
    case MessageName::WebPage_SetTextForActivePopupMenu:
        return "WebPage_SetTextForActivePopupMenu";
    case MessageName::WebPage_SetTextZoomFactor:
        return "WebPage_SetTextZoomFactor";
    case MessageName::WebPage_SetTopContentInset:
        return "WebPage_SetTopContentInset";
    case MessageName::WebPage_SetTopContentInsetFenced:
        return "WebPage_SetTopContentInsetFenced";
    case MessageName::WebPage_SetUnderPageBackgroundColorOverride:
        return "WebPage_SetUnderPageBackgroundColorOverride";
    case MessageName::WebPage_SetUnderlayColor:
        return "WebPage_SetUnderlayColor";
    case MessageName::WebPage_SetUseFixedLayout:
        return "WebPage_SetUseFixedLayout";
    case MessageName::WebPage_SetUseIconLoadingClient:
        return "WebPage_SetUseIconLoadingClient";
    case MessageName::WebPage_SetUseSystemAppearance:
        return "WebPage_SetUseSystemAppearance";
    case MessageName::WebPage_SetUserAgent:
        return "WebPage_SetUserAgent";
    case MessageName::WebPage_SetUserInterfaceLayoutDirection:
        return "WebPage_SetUserInterfaceLayoutDirection";
    case MessageName::WebPage_SetViewportConfigurationViewLayoutSize:
        return "WebPage_SetViewportConfigurationViewLayoutSize";
    case MessageName::WebPage_SetViewportSizeForCSSViewportUnits:
        return "WebPage_SetViewportSizeForCSSViewportUnits";
    case MessageName::WebPage_SimulateDeviceOrientationChange:
        return "WebPage_SimulateDeviceOrientationChange";
    case MessageName::WebPage_SpeakingErrorOccurred:
        return "WebPage_SpeakingErrorOccurred";
    case MessageName::WebPage_StartAutoscrollAtPosition:
        return "WebPage_StartAutoscrollAtPosition";
    case MessageName::WebPage_StartImageAnalysis:
        return "WebPage_StartImageAnalysis";
    case MessageName::WebPage_StartInteractionWithElementContextOrPosition:
        return "WebPage_StartInteractionWithElementContextOrPosition";
    case MessageName::WebPage_StartTextManipulations:
        return "WebPage_StartTextManipulations";
    case MessageName::WebPage_StopInteraction:
        return "WebPage_StopInteraction";
    case MessageName::WebPage_StopLoading:
        return "WebPage_StopLoading";
    case MessageName::WebPage_StopLoadingFrame:
        return "WebPage_StopLoadingFrame";
    case MessageName::WebPage_StopMediaCapture:
        return "WebPage_StopMediaCapture";
    case MessageName::WebPage_StoreSelectionForAccessibility:
        return "WebPage_StoreSelectionForAccessibility";
    case MessageName::WebPage_Suspend:
        return "WebPage_Suspend";
    case MessageName::WebPage_SuspendActiveDOMObjectsAndAnimations:
        return "WebPage_SuspendActiveDOMObjectsAndAnimations";
    case MessageName::WebPage_SuspendAllMediaPlayback:
        return "WebPage_SuspendAllMediaPlayback";
    case MessageName::WebPage_SystemPreviewActionTriggered:
        return "WebPage_SystemPreviewActionTriggered";
    case MessageName::WebPage_TakeSnapshot:
        return "WebPage_TakeSnapshot";
    case MessageName::WebPage_TapHighlightAtPosition:
        return "WebPage_TapHighlightAtPosition";
    case MessageName::WebPage_TextInputContextsInRect:
        return "WebPage_TextInputContextsInRect";
    case MessageName::WebPage_TouchEvent:
        return "WebPage_TouchEvent";
    case MessageName::WebPage_TouchWithIdentifierWasRemoved:
        return "WebPage_TouchWithIdentifierWasRemoved";
    case MessageName::WebPage_TryClose:
        return "WebPage_TryClose";
    case MessageName::WebPage_TryRestoreScrollPosition:
        return "WebPage_TryRestoreScrollPosition";
    case MessageName::WebPage_URLSchemeTaskDidComplete:
        return "WebPage_URLSchemeTaskDidComplete";
    case MessageName::WebPage_URLSchemeTaskDidPerformRedirection:
        return "WebPage_URLSchemeTaskDidPerformRedirection";
    case MessageName::WebPage_URLSchemeTaskDidReceiveData:
        return "WebPage_URLSchemeTaskDidReceiveData";
    case MessageName::WebPage_URLSchemeTaskDidReceiveResponse:
        return "WebPage_URLSchemeTaskDidReceiveResponse";
    case MessageName::WebPage_URLSchemeTaskWillPerformRedirection:
        return "WebPage_URLSchemeTaskWillPerformRedirection";
    case MessageName::WebPage_UnapplyEditCommand:
        return "WebPage_UnapplyEditCommand";
    case MessageName::WebPage_UnfreezeLayerTreeDueToSwipeAnimation:
        return "WebPage_UnfreezeLayerTreeDueToSwipeAnimation";
    case MessageName::WebPage_UpdateAttachmentAttributes:
        return "WebPage_UpdateAttachmentAttributes";
    case MessageName::WebPage_UpdateAttachmentIcon:
        return "WebPage_UpdateAttachmentIcon";
    case MessageName::WebPage_UpdateAttachmentThumbnail:
        return "WebPage_UpdateAttachmentThumbnail";
    case MessageName::WebPage_UpdateBackForwardListForReattach:
        return "WebPage_UpdateBackForwardListForReattach";
    case MessageName::WebPage_UpdateCORSDisablingPatterns:
        return "WebPage_UpdateCORSDisablingPatterns";
    case MessageName::WebPage_UpdateCurrentModifierState:
        return "WebPage_UpdateCurrentModifierState";
    case MessageName::WebPage_UpdateSelectionWithDelta:
        return "WebPage_UpdateSelectionWithDelta";
    case MessageName::WebPage_UpdateSelectionWithExtentPoint:
        return "WebPage_UpdateSelectionWithExtentPoint";
    case MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary:
        return "WebPage_UpdateSelectionWithExtentPointAndBoundary";
    case MessageName::WebPage_UpdateSelectionWithTouches:
        return "WebPage_UpdateSelectionWithTouches";
    case MessageName::WebPage_UpdateWebsitePolicies:
        return "WebPage_UpdateWebsitePolicies";
    case MessageName::WebPage_UpdateWithTextRecognitionResult:
        return "WebPage_UpdateWithTextRecognitionResult";
    case MessageName::WebPage_UppercaseWord:
        return "WebPage_UppercaseWord";
    case MessageName::WebPage_UserMediaAccessWasDenied:
        return "WebPage_UserMediaAccessWasDenied";
    case MessageName::WebPage_UserMediaAccessWasGranted:
        return "WebPage_UserMediaAccessWasGranted";
    case MessageName::WebPage_ValidateCommand:
        return "WebPage_ValidateCommand";
    case MessageName::WebPage_ViewWillEndLiveResize:
        return "WebPage_ViewWillEndLiveResize";
    case MessageName::WebPage_ViewWillStartLiveResize:
        return "WebPage_ViewWillStartLiveResize";
    case MessageName::WebPage_VoicesDidChange:
        return "WebPage_VoicesDidChange";
    case MessageName::WebPage_WasLoadedWithDataTransferFromPrevalentResource:
        return "WebPage_WasLoadedWithDataTransferFromPrevalentResource";
    case MessageName::WebPage_WillStartUserTriggeredZooming:
        return "WebPage_WillStartUserTriggeredZooming";
    case MessageName::WebPage_WindowAndViewFramesChanged:
        return "WebPage_WindowAndViewFramesChanged";
    case MessageName::WebPage_WindowScreenDidChange:
        return "WebPage_WindowScreenDidChange";
    case MessageName::WebPage_ZoomPDFIn:
        return "WebPage_ZoomPDFIn";
    case MessageName::WebPage_ZoomPDFOut:
        return "WebPage_ZoomPDFOut";
    case MessageName::WebPasteboardProxy_ClearClipboard:
        return "WebPasteboardProxy_ClearClipboard";
    case MessageName::WebPasteboardProxy_UpdateSupportedTypeIdentifiers:
        return "WebPasteboardProxy_UpdateSupportedTypeIdentifiers";
    case MessageName::WebPasteboardProxy_WriteImageToPasteboard:
        return "WebPasteboardProxy_WriteImageToPasteboard";
    case MessageName::WebPasteboardProxy_WriteStringToPasteboard:
        return "WebPasteboardProxy_WriteStringToPasteboard";
    case MessageName::WebPasteboardProxy_WriteToClipboard:
        return "WebPasteboardProxy_WriteToClipboard";
    case MessageName::WebPasteboardProxy_WriteURLToPasteboard:
        return "WebPasteboardProxy_WriteURLToPasteboard";
    case MessageName::WebPasteboardProxy_WriteWebContentToPasteboard:
        return "WebPasteboardProxy_WriteWebContentToPasteboard";
    case MessageName::WebProcessPool_HandleMessage:
        return "WebProcessPool_HandleMessage";
    case MessageName::WebProcessPool_ReportWebContentCPUTime:
        return "WebProcessPool_ReportWebContentCPUTime";
    case MessageName::WebProcessPool_StartedUsingGamepads:
        return "WebProcessPool_StartedUsingGamepads";
    case MessageName::WebProcessPool_StoppedUsingGamepads:
        return "WebProcessPool_StoppedUsingGamepads";
    case MessageName::WebProcessProxy_CacheMediaMIMETypes:
        return "WebProcessProxy_CacheMediaMIMETypes";
    case MessageName::WebProcessProxy_CreateSpeechRecognitionServer:
        return "WebProcessProxy_CreateSpeechRecognitionServer";
    case MessageName::WebProcessProxy_DestroySpeechRecognitionServer:
        return "WebProcessProxy_DestroySpeechRecognitionServer";
    case MessageName::WebProcessProxy_DidCollectPrewarmInformation:
        return "WebProcessProxy_DidCollectPrewarmInformation";
    case MessageName::WebProcessProxy_DidCreateSleepDisabler:
        return "WebProcessProxy_DidCreateSleepDisabler";
    case MessageName::WebProcessProxy_DidDestroyFrame:
        return "WebProcessProxy_DidDestroyFrame";
    case MessageName::WebProcessProxy_DidDestroySleepDisabler:
        return "WebProcessProxy_DidDestroySleepDisabler";
    case MessageName::WebProcessProxy_DidDestroyUserGestureToken:
        return "WebProcessProxy_DidDestroyUserGestureToken";
    case MessageName::WebProcessProxy_DidExceedActiveMemoryLimit:
        return "WebProcessProxy_DidExceedActiveMemoryLimit";
    case MessageName::WebProcessProxy_DidExceedCPULimit:
        return "WebProcessProxy_DidExceedCPULimit";
    case MessageName::WebProcessProxy_DidExceedInactiveMemoryLimit:
        return "WebProcessProxy_DidExceedInactiveMemoryLimit";
    case MessageName::WebProcessProxy_DidExceedInactiveMemoryLimitWhileActive:
        return "WebProcessProxy_DidExceedInactiveMemoryLimitWhileActive";
    case MessageName::WebProcessProxy_DidReceiveBackgroundResponsivenessPing:
        return "WebProcessProxy_DidReceiveBackgroundResponsivenessPing";
    case MessageName::WebProcessProxy_DisableSuddenTermination:
        return "WebProcessProxy_DisableSuddenTermination";
    case MessageName::WebProcessProxy_EnableSuddenTermination:
        return "WebProcessProxy_EnableSuddenTermination";
    case MessageName::WebProcessProxy_MemoryPressureStatusChanged:
        return "WebProcessProxy_MemoryPressureStatusChanged";
    case MessageName::WebProcessProxy_ReleaseHighPerformanceGPU:
        return "WebProcessProxy_ReleaseHighPerformanceGPU";
    case MessageName::WebProcessProxy_RequestHighPerformanceGPU:
        return "WebProcessProxy_RequestHighPerformanceGPU";
    case MessageName::WebProcessProxy_SendMessageToWebContext:
        return "WebProcessProxy_SendMessageToWebContext";
    case MessageName::WebProcessProxy_SendMessageToWebContextWithReply:
        return "WebProcessProxy_SendMessageToWebContextWithReply";
    case MessageName::WebProcessProxy_SetCaptionDisplayMode:
        return "WebProcessProxy_SetCaptionDisplayMode";
    case MessageName::WebProcessProxy_SetCaptionLanguage:
        return "WebProcessProxy_SetCaptionLanguage";
    case MessageName::WebProcessProxy_SetDisplayLinkPreferredFramesPerSecond:
        return "WebProcessProxy_SetDisplayLinkPreferredFramesPerSecond";
    case MessageName::WebProcessProxy_SetIsHoldingLockedFiles:
        return "WebProcessProxy_SetIsHoldingLockedFiles";
    case MessageName::WebProcessProxy_StartDisplayLink:
        return "WebProcessProxy_StartDisplayLink";
    case MessageName::WebProcessProxy_StopDisplayLink:
        return "WebProcessProxy_StopDisplayLink";
    case MessageName::WebProcessProxy_StopResponsivenessTimer:
        return "WebProcessProxy_StopResponsivenessTimer";
    case MessageName::WebProcessProxy_SystemBeep:
        return "WebProcessProxy_SystemBeep";
    case MessageName::WebProcessProxy_UpdateBackForwardItem:
        return "WebProcessProxy_UpdateBackForwardItem";
    case MessageName::WebProcess_AccessibilityPreferencesDidChange:
        return "WebProcess_AccessibilityPreferencesDidChange";
    case MessageName::WebProcess_AddMockMediaDevice:
        return "WebProcess_AddMockMediaDevice";
    case MessageName::WebProcess_BackgroundResponsivenessPing:
        return "WebProcess_BackgroundResponsivenessPing";
    case MessageName::WebProcess_BacklightLevelDidChange:
        return "WebProcess_BacklightLevelDidChange";
    case MessageName::WebProcess_ClearCachedPage:
        return "WebProcess_ClearCachedPage";
    case MessageName::WebProcess_ClearCurrentModifierStateForTesting:
        return "WebProcess_ClearCurrentModifierStateForTesting";
    case MessageName::WebProcess_ClearMockMediaDevices:
        return "WebProcess_ClearMockMediaDevices";
    case MessageName::WebProcess_ClearResourceLoadStatistics:
        return "WebProcess_ClearResourceLoadStatistics";
    case MessageName::WebProcess_ColorPreferencesDidChange:
        return "WebProcess_ColorPreferencesDidChange";
    case MessageName::WebProcess_ConsumeAudioComponentRegistrations:
        return "WebProcess_ConsumeAudioComponentRegistrations";
    case MessageName::WebProcess_CreateWebPage:
        return "WebProcess_CreateWebPage";
    case MessageName::WebProcess_DeleteWebsiteData:
        return "WebProcess_DeleteWebsiteData";
    case MessageName::WebProcess_DeleteWebsiteDataForOrigins:
        return "WebProcess_DeleteWebsiteDataForOrigins";
    case MessageName::WebProcess_DestroyAutomationSessionProxy:
        return "WebProcess_DestroyAutomationSessionProxy";
    case MessageName::WebProcess_DidWriteToPasteboardAsynchronously:
        return "WebProcess_DidWriteToPasteboardAsynchronously";
    case MessageName::WebProcess_DisplayConfigurationChanged:
        return "WebProcess_DisplayConfigurationChanged";
    case MessageName::WebProcess_DisplayWasRefreshed:
        return "WebProcess_DisplayWasRefreshed";
    case MessageName::WebProcess_EnableRemoteWebInspector:
        return "WebProcess_EnableRemoteWebInspector";
    case MessageName::WebProcess_EnsureAutomationSessionProxy:
        return "WebProcess_EnsureAutomationSessionProxy";
    case MessageName::WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcess:
        return "WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcess";
    case MessageName::WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcess:
        return "WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcess";
    case MessageName::WebProcess_FetchWebsiteData:
        return "WebProcess_FetchWebsiteData";
    case MessageName::WebProcess_FullKeyboardAccessModeChanged:
        return "WebProcess_FullKeyboardAccessModeChanged";
    case MessageName::WebProcess_GamepadConnected:
        return "WebProcess_GamepadConnected";
    case MessageName::WebProcess_GamepadDisconnected:
        return "WebProcess_GamepadDisconnected";
    case MessageName::WebProcess_GarbageCollectJavaScriptObjects:
        return "WebProcess_GarbageCollectJavaScriptObjects";
    case MessageName::WebProcess_GetActivePagesOriginsForTesting:
        return "WebProcess_GetActivePagesOriginsForTesting";
    case MessageName::WebProcess_GrantAccessToAssetServices:
        return "WebProcess_GrantAccessToAssetServices";
    case MessageName::WebProcess_GrantUserMediaDeviceSandboxExtensions:
        return "WebProcess_GrantUserMediaDeviceSandboxExtensions";
    case MessageName::WebProcess_HandleInjectedBundleMessage:
        return "WebProcess_HandleInjectedBundleMessage";
    case MessageName::WebProcess_InitializeWebProcess:
        return "WebProcess_InitializeWebProcess";
    case MessageName::WebProcess_IsJITEnabled:
        return "WebProcess_IsJITEnabled";
    case MessageName::WebProcess_MarkIsNoLongerPrewarmed:
        return "WebProcess_MarkIsNoLongerPrewarmed";
    case MessageName::WebProcess_NotifyPreferencesChanged:
        return "WebProcess_NotifyPreferencesChanged";
    case MessageName::WebProcess_PowerSourceDidChange:
        return "WebProcess_PowerSourceDidChange";
    case MessageName::WebProcess_PrepareToSuspend:
        return "WebProcess_PrepareToSuspend";
    case MessageName::WebProcess_PrewarmWithDomainInformation:
        return "WebProcess_PrewarmWithDomainInformation";
    case MessageName::WebProcess_ProcessDidResume:
        return "WebProcess_ProcessDidResume";
    case MessageName::WebProcess_RefreshPlugins:
        return "WebProcess_RefreshPlugins";
    case MessageName::WebProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy:
        return "WebProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy";
    case MessageName::WebProcess_RegisterURLSchemeAsCORSEnabled:
        return "WebProcess_RegisterURLSchemeAsCORSEnabled";
    case MessageName::WebProcess_RegisterURLSchemeAsCachePartitioned:
        return "WebProcess_RegisterURLSchemeAsCachePartitioned";
    case MessageName::WebProcess_RegisterURLSchemeAsCanDisplayOnlyIfCanRequest:
        return "WebProcess_RegisterURLSchemeAsCanDisplayOnlyIfCanRequest";
    case MessageName::WebProcess_RegisterURLSchemeAsDisplayIsolated:
        return "WebProcess_RegisterURLSchemeAsDisplayIsolated";
    case MessageName::WebProcess_RegisterURLSchemeAsEmptyDocument:
        return "WebProcess_RegisterURLSchemeAsEmptyDocument";
    case MessageName::WebProcess_RegisterURLSchemeAsLocal:
        return "WebProcess_RegisterURLSchemeAsLocal";
    case MessageName::WebProcess_RegisterURLSchemeAsNoAccess:
        return "WebProcess_RegisterURLSchemeAsNoAccess";
    case MessageName::WebProcess_RegisterURLSchemeAsSecure:
        return "WebProcess_RegisterURLSchemeAsSecure";
    case MessageName::WebProcess_RemoveMockMediaDevice:
        return "WebProcess_RemoveMockMediaDevice";
    case MessageName::WebProcess_ResetMockMediaDevices:
        return "WebProcess_ResetMockMediaDevices";
    case MessageName::WebProcess_RevokeAccessToAssetServices:
        return "WebProcess_RevokeAccessToAssetServices";
    case MessageName::WebProcess_RevokeUserMediaDeviceSandboxExtensions:
        return "WebProcess_RevokeUserMediaDeviceSandboxExtensions";
    case MessageName::WebProcess_ScrollerStylePreferenceChanged:
        return "WebProcess_ScrollerStylePreferenceChanged";
    case MessageName::WebProcess_SeedResourceLoadStatisticsForTesting:
        return "WebProcess_SeedResourceLoadStatisticsForTesting";
    case MessageName::WebProcess_SendMessageToWebExtension:
        return "WebProcess_SendMessageToWebExtension";
    case MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately:
        return "WebProcess_SendResourceLoadStatisticsDataImmediately";
    case MessageName::WebProcess_SetAlwaysUsesComplexTextCodePath:
        return "WebProcess_SetAlwaysUsesComplexTextCodePath";
    case MessageName::WebProcess_SetBackForwardCacheCapacity:
        return "WebProcess_SetBackForwardCacheCapacity";
    case MessageName::WebProcess_SetCacheModel:
        return "WebProcess_SetCacheModel";
    case MessageName::WebProcess_SetDefaultRequestTimeoutInterval:
        return "WebProcess_SetDefaultRequestTimeoutInterval";
    case MessageName::WebProcess_SetDomainRelaxationForbiddenForURLScheme:
        return "WebProcess_SetDomainRelaxationForbiddenForURLScheme";
    case MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess:
        return "WebProcess_SetDomainsWithCrossPageStorageAccess";
    case MessageName::WebProcess_SetDomainsWithUserInteraction:
        return "WebProcess_SetDomainsWithUserInteraction";
    case MessageName::WebProcess_SetEnabledServices:
        return "WebProcess_SetEnabledServices";
    case MessageName::WebProcess_SetEnhancedAccessibility:
        return "WebProcess_SetEnhancedAccessibility";
    case MessageName::WebProcess_SetHasMouseDevice:
        return "WebProcess_SetHasMouseDevice";
    case MessageName::WebProcess_SetHasStylusDevice:
        return "WebProcess_SetHasStylusDevice";
    case MessageName::WebProcess_SetHasSuspendedPageProxy:
        return "WebProcess_SetHasSuspendedPageProxy";
    case MessageName::WebProcess_SetHiddenPageDOMTimerThrottlingIncreaseLimit:
        return "WebProcess_SetHiddenPageDOMTimerThrottlingIncreaseLimit";
    case MessageName::WebProcess_SetInitialGamepads:
        return "WebProcess_SetInitialGamepads";
    case MessageName::WebProcess_SetInjectedBundleParameter:
        return "WebProcess_SetInjectedBundleParameter";
    case MessageName::WebProcess_SetInjectedBundleParameters:
        return "WebProcess_SetInjectedBundleParameters";
    case MessageName::WebProcess_SetIsInProcessCache:
        return "WebProcess_SetIsInProcessCache";
    case MessageName::WebProcess_SetJavaScriptGarbageCollectorTimerEnabled:
        return "WebProcess_SetJavaScriptGarbageCollectorTimerEnabled";
    case MessageName::WebProcess_SetMediaAccessibilityPreferences:
        return "WebProcess_SetMediaAccessibilityPreferences";
    case MessageName::WebProcess_SetMediaMIMETypes:
        return "WebProcess_SetMediaMIMETypes";
    case MessageName::WebProcess_SetMemoryCacheDisabled:
        return "WebProcess_SetMemoryCacheDisabled";
    case MessageName::WebProcess_SetResourceLoadStatisticsEnabled:
        return "WebProcess_SetResourceLoadStatisticsEnabled";
    case MessageName::WebProcess_SetScreenProperties:
        return "WebProcess_SetScreenProperties";
    case MessageName::WebProcess_SetShouldUseFontSmoothing:
        return "WebProcess_SetShouldUseFontSmoothing";
    case MessageName::WebProcess_SetTextCheckerState:
        return "WebProcess_SetTextCheckerState";
    case MessageName::WebProcess_SetThirdPartyCookieBlockingMode:
        return "WebProcess_SetThirdPartyCookieBlockingMode";
    case MessageName::WebProcess_SetUseSystemAppearanceForScrollbars:
        return "WebProcess_SetUseSystemAppearanceForScrollbars";
    case MessageName::WebProcess_SetWebsiteDataStoreParameters:
        return "WebProcess_SetWebsiteDataStoreParameters";
    case MessageName::WebProcess_StartMemorySampler:
        return "WebProcess_StartMemorySampler";
    case MessageName::WebProcess_StopMemorySampler:
        return "WebProcess_StopMemorySampler";
    case MessageName::WebProcess_SwitchFromStaticFontRegistryToUserFontRegistry:
        return "WebProcess_SwitchFromStaticFontRegistryToUserFontRegistry";
    case MessageName::WebProcess_SystemDidWake:
        return "WebProcess_SystemDidWake";
    case MessageName::WebProcess_SystemWillPowerOn:
        return "WebProcess_SystemWillPowerOn";
    case MessageName::WebProcess_SystemWillSleep:
        return "WebProcess_SystemWillSleep";
    case MessageName::WebProcess_UnblockPreferenceService:
        return "WebProcess_UnblockPreferenceService";
    case MessageName::WebProcess_UnblockServicesRequiredByAccessibility:
        return "WebProcess_UnblockServicesRequiredByAccessibility";
    case MessageName::WebProcess_UserInterfaceIdiomDidChange:
        return "WebProcess_UserInterfaceIdiomDidChange";
    case MessageName::WebProcess_UserPreferredLanguagesChanged:
        return "WebProcess_UserPreferredLanguagesChanged";
    case MessageName::WebRTCMonitor_NetworksChanged:
        return "WebRTCMonitor_NetworksChanged";
    case MessageName::WebRTCResolver_ResolvedAddressError:
        return "WebRTCResolver_ResolvedAddressError";
    case MessageName::WebRTCResolver_SetResolvedAddress:
        return "WebRTCResolver_SetResolvedAddress";
    case MessageName::WebResourceLoader_CancelMainResourceLoadForContentFilter:
        return "WebResourceLoader_CancelMainResourceLoadForContentFilter";
    case MessageName::WebResourceLoader_ContentFilterDidBlockLoad:
        return "WebResourceLoader_ContentFilterDidBlockLoad";
    case MessageName::WebResourceLoader_DidBlockAuthenticationChallenge:
        return "WebResourceLoader_DidBlockAuthenticationChallenge";
    case MessageName::WebResourceLoader_DidFailResourceLoad:
        return "WebResourceLoader_DidFailResourceLoad";
    case MessageName::WebResourceLoader_DidFailServiceWorkerLoad:
        return "WebResourceLoader_DidFailServiceWorkerLoad";
    case MessageName::WebResourceLoader_DidFinishResourceLoad:
        return "WebResourceLoader_DidFinishResourceLoad";
    case MessageName::WebResourceLoader_DidReceiveData:
        return "WebResourceLoader_DidReceiveData";
    case MessageName::WebResourceLoader_DidReceiveResource:
        return "WebResourceLoader_DidReceiveResource";
    case MessageName::WebResourceLoader_DidReceiveResponse:
        return "WebResourceLoader_DidReceiveResponse";
    case MessageName::WebResourceLoader_DidSendData:
        return "WebResourceLoader_DidSendData";
    case MessageName::WebResourceLoader_HandleProvisionalLoadFailureFromContentFilter:
        return "WebResourceLoader_HandleProvisionalLoadFailureFromContentFilter";
    case MessageName::WebResourceLoader_ServiceWorkerDidNotHandle:
        return "WebResourceLoader_ServiceWorkerDidNotHandle";
    case MessageName::WebResourceLoader_StopLoadingAfterXFrameOptionsOrContentSecurityPolicyDenied:
        return "WebResourceLoader_StopLoadingAfterXFrameOptionsOrContentSecurityPolicyDenied";
    case MessageName::WebResourceLoader_WillSendRequest:
        return "WebResourceLoader_WillSendRequest";
    case MessageName::WebSWClientConnection_FireUpdateFoundEvent:
        return "WebSWClientConnection_FireUpdateFoundEvent";
    case MessageName::WebSWClientConnection_JobRejectedInServer:
        return "WebSWClientConnection_JobRejectedInServer";
    case MessageName::WebSWClientConnection_NotifyClientsOfControllerChange:
        return "WebSWClientConnection_NotifyClientsOfControllerChange";
    case MessageName::WebSWClientConnection_PostMessageToServiceWorkerClient:
        return "WebSWClientConnection_PostMessageToServiceWorkerClient";
    case MessageName::WebSWClientConnection_RegistrationJobResolvedInServer:
        return "WebSWClientConnection_RegistrationJobResolvedInServer";
    case MessageName::WebSWClientConnection_SetDocumentIsControlled:
        return "WebSWClientConnection_SetDocumentIsControlled";
    case MessageName::WebSWClientConnection_SetRegistrationLastUpdateTime:
        return "WebSWClientConnection_SetRegistrationLastUpdateTime";
    case MessageName::WebSWClientConnection_SetRegistrationUpdateViaCache:
        return "WebSWClientConnection_SetRegistrationUpdateViaCache";
    case MessageName::WebSWClientConnection_SetSWOriginTableIsImported:
        return "WebSWClientConnection_SetSWOriginTableIsImported";
    case MessageName::WebSWClientConnection_SetSWOriginTableSharedMemory:
        return "WebSWClientConnection_SetSWOriginTableSharedMemory";
    case MessageName::WebSWClientConnection_StartScriptFetchForServer:
        return "WebSWClientConnection_StartScriptFetchForServer";
    case MessageName::WebSWClientConnection_UpdateRegistrationState:
        return "WebSWClientConnection_UpdateRegistrationState";
    case MessageName::WebSWClientConnection_UpdateWorkerState:
        return "WebSWClientConnection_UpdateWorkerState";
    case MessageName::WebSWContextManagerConnection_CancelFetch:
        return "WebSWContextManagerConnection_CancelFetch";
    case MessageName::WebSWContextManagerConnection_Close:
        return "WebSWContextManagerConnection_Close";
    case MessageName::WebSWContextManagerConnection_ContinueDidReceiveFetchResponse:
        return "WebSWContextManagerConnection_ContinueDidReceiveFetchResponse";
    case MessageName::WebSWContextManagerConnection_ConvertFetchToDownload:
        return "WebSWContextManagerConnection_ConvertFetchToDownload";
    case MessageName::WebSWContextManagerConnection_DidSaveScriptsToDisk:
        return "WebSWContextManagerConnection_DidSaveScriptsToDisk";
    case MessageName::WebSWContextManagerConnection_FireActivateEvent:
        return "WebSWContextManagerConnection_FireActivateEvent";
    case MessageName::WebSWContextManagerConnection_FireInstallEvent:
        return "WebSWContextManagerConnection_FireInstallEvent";
    case MessageName::WebSWContextManagerConnection_FirePushEvent:
        return "WebSWContextManagerConnection_FirePushEvent";
    case MessageName::WebSWContextManagerConnection_InstallServiceWorker:
        return "WebSWContextManagerConnection_InstallServiceWorker";
    case MessageName::WebSWContextManagerConnection_MatchAllCompleted:
        return "WebSWContextManagerConnection_MatchAllCompleted";
    case MessageName::WebSWContextManagerConnection_PostMessageToServiceWorker:
        return "WebSWContextManagerConnection_PostMessageToServiceWorker";
    case MessageName::WebSWContextManagerConnection_SetThrottleState:
        return "WebSWContextManagerConnection_SetThrottleState";
    case MessageName::WebSWContextManagerConnection_SetUserAgent:
        return "WebSWContextManagerConnection_SetUserAgent";
    case MessageName::WebSWContextManagerConnection_StartFetch:
        return "WebSWContextManagerConnection_StartFetch";
    case MessageName::WebSWContextManagerConnection_TerminateWorker:
        return "WebSWContextManagerConnection_TerminateWorker";
    case MessageName::WebSWContextManagerConnection_UpdateAppInitiatedValue:
        return "WebSWContextManagerConnection_UpdateAppInitiatedValue";
    case MessageName::WebSWContextManagerConnection_UpdatePreferencesStore:
        return "WebSWContextManagerConnection_UpdatePreferencesStore";
    case MessageName::WebSWServerConnection_AddServiceWorkerRegistrationInServer:
        return "WebSWServerConnection_AddServiceWorkerRegistrationInServer";
    case MessageName::WebSWServerConnection_DidResolveRegistrationPromise:
        return "WebSWServerConnection_DidResolveRegistrationPromise";
    case MessageName::WebSWServerConnection_DisableNavigationPreload:
        return "WebSWServerConnection_DisableNavigationPreload";
    case MessageName::WebSWServerConnection_EnableNavigationPreload:
        return "WebSWServerConnection_EnableNavigationPreload";
    case MessageName::WebSWServerConnection_FinishFetchingScriptInServer:
        return "WebSWServerConnection_FinishFetchingScriptInServer";
    case MessageName::WebSWServerConnection_GetNavigationPreloadState:
        return "WebSWServerConnection_GetNavigationPreloadState";
    case MessageName::WebSWServerConnection_GetPushPermissionState:
        return "WebSWServerConnection_GetPushPermissionState";
    case MessageName::WebSWServerConnection_GetPushSubscription:
        return "WebSWServerConnection_GetPushSubscription";
    case MessageName::WebSWServerConnection_GetRegistrations:
        return "WebSWServerConnection_GetRegistrations";
    case MessageName::WebSWServerConnection_MatchRegistration:
        return "WebSWServerConnection_MatchRegistration";
    case MessageName::WebSWServerConnection_PostMessageToServiceWorker:
        return "WebSWServerConnection_PostMessageToServiceWorker";
    case MessageName::WebSWServerConnection_RegisterServiceWorkerClient:
        return "WebSWServerConnection_RegisterServiceWorkerClient";
    case MessageName::WebSWServerConnection_RemoveServiceWorkerRegistrationInServer:
        return "WebSWServerConnection_RemoveServiceWorkerRegistrationInServer";
    case MessageName::WebSWServerConnection_ScheduleJobInServer:
        return "WebSWServerConnection_ScheduleJobInServer";
    case MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer:
        return "WebSWServerConnection_ScheduleUnregisterJobInServer";
    case MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue:
        return "WebSWServerConnection_SetNavigationPreloadHeaderValue";
    case MessageName::WebSWServerConnection_SetThrottleState:
        return "WebSWServerConnection_SetThrottleState";
    case MessageName::WebSWServerConnection_StoreRegistrationsOnDisk:
        return "WebSWServerConnection_StoreRegistrationsOnDisk";
    case MessageName::WebSWServerConnection_SubscribeToPushService:
        return "WebSWServerConnection_SubscribeToPushService";
    case MessageName::WebSWServerConnection_TerminateWorkerFromClient:
        return "WebSWServerConnection_TerminateWorkerFromClient";
    case MessageName::WebSWServerConnection_UnregisterServiceWorkerClient:
        return "WebSWServerConnection_UnregisterServiceWorkerClient";
    case MessageName::WebSWServerConnection_UnsubscribeFromPushService:
        return "WebSWServerConnection_UnsubscribeFromPushService";
    case MessageName::WebSWServerConnection_WhenRegistrationReady:
        return "WebSWServerConnection_WhenRegistrationReady";
    case MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting:
        return "WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting";
    case MessageName::WebSWServerToContextConnection_Claim:
        return "WebSWServerToContextConnection_Claim";
    case MessageName::WebSWServerToContextConnection_DidFailHeartBeatCheck:
        return "WebSWServerToContextConnection_DidFailHeartBeatCheck";
    case MessageName::WebSWServerToContextConnection_DidFinishActivation:
        return "WebSWServerToContextConnection_DidFinishActivation";
    case MessageName::WebSWServerToContextConnection_DidFinishInstall:
        return "WebSWServerToContextConnection_DidFinishInstall";
    case MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier:
        return "WebSWServerToContextConnection_FindClientByVisibleIdentifier";
    case MessageName::WebSWServerToContextConnection_MatchAll:
        return "WebSWServerToContextConnection_MatchAll";
    case MessageName::WebSWServerToContextConnection_PostMessageToServiceWorkerClient:
        return "WebSWServerToContextConnection_PostMessageToServiceWorkerClient";
    case MessageName::WebSWServerToContextConnection_ScriptContextFailedToStart:
        return "WebSWServerToContextConnection_ScriptContextFailedToStart";
    case MessageName::WebSWServerToContextConnection_ScriptContextStarted:
        return "WebSWServerToContextConnection_ScriptContextStarted";
    case MessageName::WebSWServerToContextConnection_SetScriptResource:
        return "WebSWServerToContextConnection_SetScriptResource";
    case MessageName::WebSWServerToContextConnection_SetServiceWorkerHasPendingEvents:
        return "WebSWServerToContextConnection_SetServiceWorkerHasPendingEvents";
    case MessageName::WebSWServerToContextConnection_SkipWaiting:
        return "WebSWServerToContextConnection_SkipWaiting";
    case MessageName::WebSWServerToContextConnection_WorkerTerminated:
        return "WebSWServerToContextConnection_WorkerTerminated";
    case MessageName::WebSharedWorkerContextManagerConnection_Close:
        return "WebSharedWorkerContextManagerConnection_Close";
    case MessageName::WebSharedWorkerContextManagerConnection_LaunchSharedWorker:
        return "WebSharedWorkerContextManagerConnection_LaunchSharedWorker";
    case MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent:
        return "WebSharedWorkerContextManagerConnection_PostConnectEvent";
    case MessageName::WebSharedWorkerContextManagerConnection_SetUserAgent:
        return "WebSharedWorkerContextManagerConnection_SetUserAgent";
    case MessageName::WebSharedWorkerContextManagerConnection_TerminateSharedWorker:
        return "WebSharedWorkerContextManagerConnection_TerminateSharedWorker";
    case MessageName::WebSharedWorkerContextManagerConnection_UpdatePreferencesStore:
        return "WebSharedWorkerContextManagerConnection_UpdatePreferencesStore";
    case MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient:
        return "WebSharedWorkerObjectConnection_FetchScriptInClient";
    case MessageName::WebSharedWorkerObjectConnection_NotifyWorkerObjectOfLoadCompletion:
        return "WebSharedWorkerObjectConnection_NotifyWorkerObjectOfLoadCompletion";
    case MessageName::WebSharedWorkerObjectConnection_PostExceptionToWorkerObject:
        return "WebSharedWorkerObjectConnection_PostExceptionToWorkerObject";
    case MessageName::WebSharedWorkerServerConnection_RequestSharedWorker:
        return "WebSharedWorkerServerConnection_RequestSharedWorker";
    case MessageName::WebSharedWorkerServerConnection_SharedWorkerObjectIsGoingAway:
        return "WebSharedWorkerServerConnection_SharedWorkerObjectIsGoingAway";
    case MessageName::WebSharedWorkerServerToContextConnection_PostExceptionToWorkerObject:
        return "WebSharedWorkerServerToContextConnection_PostExceptionToWorkerObject";
    case MessageName::WebSocketChannel_DidClose:
        return "WebSocketChannel_DidClose";
    case MessageName::WebSocketChannel_DidConnect:
        return "WebSocketChannel_DidConnect";
    case MessageName::WebSocketChannel_DidReceiveBinaryData:
        return "WebSocketChannel_DidReceiveBinaryData";
    case MessageName::WebSocketChannel_DidReceiveHandshakeResponse:
        return "WebSocketChannel_DidReceiveHandshakeResponse";
    case MessageName::WebSocketChannel_DidReceiveMessageError:
        return "WebSocketChannel_DidReceiveMessageError";
    case MessageName::WebSocketChannel_DidReceiveText:
        return "WebSocketChannel_DidReceiveText";
    case MessageName::WebSocketChannel_DidSendHandshakeRequest:
        return "WebSocketChannel_DidSendHandshakeRequest";
    case MessageName::WebSocketStream_DidCloseSocketStream:
        return "WebSocketStream_DidCloseSocketStream";
    case MessageName::WebSocketStream_DidFailSocketStream:
        return "WebSocketStream_DidFailSocketStream";
    case MessageName::WebSocketStream_DidFailToReceiveSocketStreamData:
        return "WebSocketStream_DidFailToReceiveSocketStreamData";
    case MessageName::WebSocketStream_DidOpenSocketStream:
        return "WebSocketStream_DidOpenSocketStream";
    case MessageName::WebSocketStream_DidReceiveSocketStreamData:
        return "WebSocketStream_DidReceiveSocketStreamData";
    case MessageName::WebSocketStream_DidSendData:
        return "WebSocketStream_DidSendData";
    case MessageName::WebSocketStream_DidSendHandshake:
        return "WebSocketStream_DidSendHandshake";
    case MessageName::WebSocketStream_DidUpdateBufferedAmount:
        return "WebSocketStream_DidUpdateBufferedAmount";
    case MessageName::WebSpeechRecognitionConnection_DidReceiveUpdate:
        return "WebSpeechRecognitionConnection_DidReceiveUpdate";
    case MessageName::WebUserContentControllerProxy_DidPostMessage:
        return "WebUserContentControllerProxy_DidPostMessage";
    case MessageName::WebUserContentController_AddContentRuleLists:
        return "WebUserContentController_AddContentRuleLists";
    case MessageName::WebUserContentController_AddContentWorlds:
        return "WebUserContentController_AddContentWorlds";
    case MessageName::WebUserContentController_AddUserScriptMessageHandlers:
        return "WebUserContentController_AddUserScriptMessageHandlers";
    case MessageName::WebUserContentController_AddUserScripts:
        return "WebUserContentController_AddUserScripts";
    case MessageName::WebUserContentController_AddUserStyleSheets:
        return "WebUserContentController_AddUserStyleSheets";
    case MessageName::WebUserContentController_RemoveAllContentRuleLists:
        return "WebUserContentController_RemoveAllContentRuleLists";
    case MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlers:
        return "WebUserContentController_RemoveAllUserScriptMessageHandlers";
    case MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlersForWorlds:
        return "WebUserContentController_RemoveAllUserScriptMessageHandlersForWorlds";
    case MessageName::WebUserContentController_RemoveAllUserScripts:
        return "WebUserContentController_RemoveAllUserScripts";
    case MessageName::WebUserContentController_RemoveAllUserStyleSheets:
        return "WebUserContentController_RemoveAllUserStyleSheets";
    case MessageName::WebUserContentController_RemoveContentRuleList:
        return "WebUserContentController_RemoveContentRuleList";
    case MessageName::WebUserContentController_RemoveContentWorlds:
        return "WebUserContentController_RemoveContentWorlds";
    case MessageName::WebUserContentController_RemoveUserScript:
        return "WebUserContentController_RemoveUserScript";
    case MessageName::WebUserContentController_RemoveUserScriptMessageHandler:
        return "WebUserContentController_RemoveUserScriptMessageHandler";
    case MessageName::WebUserContentController_RemoveUserStyleSheet:
        return "WebUserContentController_RemoveUserStyleSheet";
    case MessageName::InitializeConnection:
        return "InitializeConnection";
    case MessageName::LegacySessionState:
        return "LegacySessionState";
    case MessageName::ProcessOutOfStreamMessage:
        return "ProcessOutOfStreamMessage";
    case MessageName::SetStreamDestinationID:
        return "SetStreamDestinationID";
    case MessageName::SyncMessageReply:
        return "SyncMessageReply";
    case MessageName::Terminate:
        return "Terminate";
    case MessageName::AuxiliaryProcess_MainThreadPingReply:
        return "AuxiliaryProcess_MainThreadPingReply";
    case MessageName::CacheStorageEngineConnection_CachesReply:
        return "CacheStorageEngineConnection_CachesReply";
    case MessageName::CacheStorageEngineConnection_ClearMemoryRepresentationReply:
        return "CacheStorageEngineConnection_ClearMemoryRepresentationReply";
    case MessageName::CacheStorageEngineConnection_DeleteMatchingRecordsReply:
        return "CacheStorageEngineConnection_DeleteMatchingRecordsReply";
    case MessageName::CacheStorageEngineConnection_EngineRepresentationReply:
        return "CacheStorageEngineConnection_EngineRepresentationReply";
    case MessageName::CacheStorageEngineConnection_OpenReply:
        return "CacheStorageEngineConnection_OpenReply";
    case MessageName::CacheStorageEngineConnection_PutRecordsReply:
        return "CacheStorageEngineConnection_PutRecordsReply";
    case MessageName::CacheStorageEngineConnection_RemoveReply:
        return "CacheStorageEngineConnection_RemoveReply";
    case MessageName::CacheStorageEngineConnection_RetrieveRecordsReply:
        return "CacheStorageEngineConnection_RetrieveRecordsReply";
    case MessageName::DownloadProxy_DecideDestinationWithSuggestedFilenameReply:
        return "DownloadProxy_DecideDestinationWithSuggestedFilenameReply";
    case MessageName::EventDispatcher_TouchEventReply:
        return "EventDispatcher_TouchEventReply";
    case MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategoryReply:
        return "GPUProcessConnection_BeginRoutingArbitrationWithCategoryReply";
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcessReply:
        return "GPUProcess_CreateGPUConnectionToWebProcessReply";
    case MessageName::GPUProcess_PrepareToSuspendReply:
        return "GPUProcess_PrepareToSuspendReply";
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTimeReply:
        return "GPUProcess_RequestBitmapImageForCurrentTimeReply";
    case MessageName::GPUProcess_ShowScreenPickerReply:
        return "GPUProcess_ShowScreenPickerReply";
    case MessageName::GPUProcess_ShowWindowPickerReply:
        return "GPUProcess_ShowWindowPickerReply";
    case MessageName::GPUProcess_UpdateCaptureAccessReply:
        return "GPUProcess_UpdateCaptureAccessReply";
    case MessageName::GPUProcess_WebProcessConnectionCountForTestingReply:
        return "GPUProcess_WebProcessConnectionCountForTestingReply";
    case MessageName::MediaPlayerPrivateRemote_GetRawCookiesReply:
        return "MediaPlayerPrivateRemote_GetRawCookiesReply";
    case MessageName::MediaPlayerPrivateRemote_RequestResourceReply:
        return "MediaPlayerPrivateRemote_RequestResourceReply";
    case MessageName::MediaPlayerPrivateRemote_SendH2PingReply:
        return "MediaPlayerPrivateRemote_SendH2PingReply";
    case MessageName::NetworkBroadcastChannelRegistry_PostMessageReply:
        return "NetworkBroadcastChannelRegistry_PostMessageReply";
    case MessageName::NetworkConnectionToWebProcess_CheckRemotePortForActivityReply:
        return "NetworkConnectionToWebProcess_CheckRemotePortForActivityReply";
    case MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSourceReply:
        return "NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSourceReply";
    case MessageName::NetworkConnectionToWebProcess_CreateRTCProviderReply:
        return "NetworkConnectionToWebProcess_CreateRTCProviderReply";
    case MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnectionReply:
        return "NetworkConnectionToWebProcess_EstablishSWContextConnectionReply";
    case MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnectionReply:
        return "NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnectionReply";
    case MessageName::NetworkConnectionToWebProcess_GetProcessDisplayNameReply:
        return "NetworkConnectionToWebProcess_GetProcessDisplayNameReply";
    case MessageName::NetworkConnectionToWebProcess_HasStorageAccessReply:
        return "NetworkConnectionToWebProcess_HasStorageAccessReply";
    case MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinishedReply:
        return "NetworkConnectionToWebProcess_IsResourceLoadFinishedReply";
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccessReply:
        return "NetworkConnectionToWebProcess_RequestStorageAccessReply";
    case MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdatedReply:
        return "NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdatedReply";
    case MessageName::NetworkConnectionToWebProcess_SendH2PingReply:
        return "NetworkConnectionToWebProcess_SendH2PingReply";
    case MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPortReply:
        return "NetworkConnectionToWebProcess_TakeAllMessagesForPortReply";
    case MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDBReply:
        return "NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDBReply";
    case MessageName::NetworkProcessConnection_CheckProcessLocalPortForActivityReply:
        return "NetworkProcessConnection_CheckProcessLocalPortForActivityReply";
    case MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSourceReply:
        return "NetworkProcessConnection_ConnectToRTCDataChannelRemoteSourceReply";
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomainsReply:
        return "NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomainsReply";
    case MessageName::NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcessReply:
        return "NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcessReply";
    case MessageName::NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcessReply:
        return "NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcessReply";
    case MessageName::NetworkProcessProxy_GetAppBoundDomainsReply:
        return "NetworkProcessProxy_GetAppBoundDomainsReply";
    case MessageName::NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentationReply:
        return "NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentationReply";
    case MessageName::NetworkProcessProxy_RequestStorageAccessConfirmReply:
        return "NetworkProcessProxy_RequestStorageAccessConfirmReply";
    case MessageName::NetworkProcessProxy_RequestStorageSpaceReply:
        return "NetworkProcessProxy_RequestStorageSpaceReply";
    case MessageName::NetworkProcessProxy_RetrieveCacheStorageParametersReply:
        return "NetworkProcessProxy_RetrieveCacheStorageParametersReply";
    case MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccessReply:
        return "NetworkProcessProxy_SetDomainsWithCrossPageStorageAccessReply";
    case MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigationReply:
        return "NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigationReply";
    case MessageName::NetworkProcess_AppPrivacyReportTestingDataReply:
        return "NetworkProcess_AppPrivacyReportTestingDataReply";
    case MessageName::NetworkProcess_CancelDownloadReply:
        return "NetworkProcess_CancelDownloadReply";
    case MessageName::NetworkProcess_ClearAppBoundSessionReply:
        return "NetworkProcess_ClearAppBoundSessionReply";
    case MessageName::NetworkProcess_ClearAppPrivacyReportTestingDataReply:
        return "NetworkProcess_ClearAppPrivacyReportTestingDataReply";
    case MessageName::NetworkProcess_ClearBundleIdentifierReply:
        return "NetworkProcess_ClearBundleIdentifierReply";
    case MessageName::NetworkProcess_ClearPrevalentResourceReply:
        return "NetworkProcess_ClearPrevalentResourceReply";
    case MessageName::NetworkProcess_ClearPrivateClickMeasurementReply:
        return "NetworkProcess_ClearPrivateClickMeasurementReply";
    case MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverrideReply:
        return "NetworkProcess_ClearServiceWorkerEntitlementOverrideReply";
    case MessageName::NetworkProcess_ClearStorageReply:
        return "NetworkProcess_ClearStorageReply";
    case MessageName::NetworkProcess_ClearUserInteractionReply:
        return "NetworkProcess_ClearUserInteractionReply";
    case MessageName::NetworkProcess_CloseITPDatabaseReply:
        return "NetworkProcess_CloseITPDatabaseReply";
    case MessageName::NetworkProcess_ClosePCMDatabaseReply:
        return "NetworkProcess_ClosePCMDatabaseReply";
    case MessageName::NetworkProcess_CountNonDefaultSessionSetsReply:
        return "NetworkProcess_CountNonDefaultSessionSetsReply";
    case MessageName::NetworkProcess_CreateNetworkConnectionToWebProcessReply:
        return "NetworkProcess_CreateNetworkConnectionToWebProcessReply";
    case MessageName::NetworkProcess_DeleteCookiesForTestingReply:
        return "NetworkProcess_DeleteCookiesForTestingReply";
    case MessageName::NetworkProcess_DeletePushAndNotificationRegistrationReply:
        return "NetworkProcess_DeletePushAndNotificationRegistrationReply";
    case MessageName::NetworkProcess_DeleteWebsiteDataForOriginsReply:
        return "NetworkProcess_DeleteWebsiteDataForOriginsReply";
    case MessageName::NetworkProcess_DeleteWebsiteDataReply:
        return "NetworkProcess_DeleteWebsiteDataReply";
    case MessageName::NetworkProcess_DomainIDExistsInDatabaseReply:
        return "NetworkProcess_DomainIDExistsInDatabaseReply";
    case MessageName::NetworkProcess_DumpPrivateClickMeasurementReply:
        return "NetworkProcess_DumpPrivateClickMeasurementReply";
    case MessageName::NetworkProcess_DumpResourceLoadStatisticsReply:
        return "NetworkProcess_DumpResourceLoadStatisticsReply";
    case MessageName::NetworkProcess_FetchWebsiteDataReply:
        return "NetworkProcess_FetchWebsiteDataReply";
    case MessageName::NetworkProcess_FlushCookiesReply:
        return "NetworkProcess_FlushCookiesReply";
    case MessageName::NetworkProcess_GetAllStorageAccessEntriesReply:
        return "NetworkProcess_GetAllStorageAccessEntriesReply";
    case MessageName::NetworkProcess_GetOriginsWithPushAndNotificationPermissionsReply:
        return "NetworkProcess_GetOriginsWithPushAndNotificationPermissionsReply";
    case MessageName::NetworkProcess_GetPendingPushMessagesReply:
        return "NetworkProcess_GetPendingPushMessagesReply";
    case MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummaryReply:
        return "NetworkProcess_GetResourceLoadStatisticsDataSummaryReply";
    case MessageName::NetworkProcess_HadUserInteractionReply:
        return "NetworkProcess_HadUserInteractionReply";
    case MessageName::NetworkProcess_HasAppBoundSessionReply:
        return "NetworkProcess_HasAppBoundSessionReply";
    case MessageName::NetworkProcess_HasIsolatedSessionReply:
        return "NetworkProcess_HasIsolatedSessionReply";
    case MessageName::NetworkProcess_HasLocalStorageReply:
        return "NetworkProcess_HasLocalStorageReply";
    case MessageName::NetworkProcess_InsertExpiredStatisticForTestingReply:
        return "NetworkProcess_InsertExpiredStatisticForTestingReply";
    case MessageName::NetworkProcess_IsGrandfatheredReply:
        return "NetworkProcess_IsGrandfatheredReply";
    case MessageName::NetworkProcess_IsPrevalentResourceReply:
        return "NetworkProcess_IsPrevalentResourceReply";
    case MessageName::NetworkProcess_IsRegisteredAsRedirectingToReply:
        return "NetworkProcess_IsRegisteredAsRedirectingToReply";
    case MessageName::NetworkProcess_IsRegisteredAsSubFrameUnderReply:
        return "NetworkProcess_IsRegisteredAsSubFrameUnderReply";
    case MessageName::NetworkProcess_IsRegisteredAsSubresourceUnderReply:
        return "NetworkProcess_IsRegisteredAsSubresourceUnderReply";
    case MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnceReply:
        return "NetworkProcess_IsRelationshipOnlyInDatabaseOnceReply";
    case MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeralReply:
        return "NetworkProcess_IsResourceLoadStatisticsEphemeralReply";
    case MessageName::NetworkProcess_IsVeryPrevalentResourceReply:
        return "NetworkProcess_IsVeryPrevalentResourceReply";
    case MessageName::NetworkProcess_LogUserInteractionReply:
        return "NetworkProcess_LogUserInteractionReply";
    case MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTestingReply:
        return "NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTestingReply";
    case MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTestingReply:
        return "NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTestingReply";
    case MessageName::NetworkProcess_MergeStatisticForTestingReply:
        return "NetworkProcess_MergeStatisticForTestingReply";
    case MessageName::NetworkProcess_PrepareToSuspendReply:
        return "NetworkProcess_PrepareToSuspendReply";
    case MessageName::NetworkProcess_ProcessPushMessageReply:
        return "NetworkProcess_ProcessPushMessageReply";
    case MessageName::NetworkProcess_RenameOriginInWebsiteDataReply:
        return "NetworkProcess_RenameOriginInWebsiteDataReply";
    case MessageName::NetworkProcess_RequestResourceReply:
        return "NetworkProcess_RequestResourceReply";
    case MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResourcesReply:
        return "NetworkProcess_ResetCacheMaxAgeCapForPrevalentResourcesReply";
    case MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTestingReply:
        return "NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTestingReply";
    case MessageName::NetworkProcess_ResetParametersToDefaultValuesReply:
        return "NetworkProcess_ResetParametersToDefaultValuesReply";
    case MessageName::NetworkProcess_ResetQuotaReply:
        return "NetworkProcess_ResetQuotaReply";
    case MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistentReply:
        return "NetworkProcess_ScheduleClearInMemoryAndPersistentReply";
    case MessageName::NetworkProcess_ScheduleCookieBlockingUpdateReply:
        return "NetworkProcess_ScheduleCookieBlockingUpdateReply";
    case MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessingReply:
        return "NetworkProcess_ScheduleStatisticsAndDataRecordsProcessingReply";
    case MessageName::NetworkProcess_SetAgeCapForClientSideCookiesReply:
        return "NetworkProcess_SetAgeCapForClientSideCookiesReply";
    case MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatisticsReply:
        return "NetworkProcess_SetAppBoundDomainsForResourceLoadStatisticsReply";
    case MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResourcesReply:
        return "NetworkProcess_SetCacheMaxAgeCapForPrevalentResourcesReply";
    case MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTestingReply:
        return "NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTestingReply";
    case MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTestingReply:
        return "NetworkProcess_SetFirstPartyHostCNAMEDomainForTestingReply";
    case MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTestingReply:
        return "NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTestingReply";
    case MessageName::NetworkProcess_SetGrandfatheredReply:
        return "NetworkProcess_SetGrandfatheredReply";
    case MessageName::NetworkProcess_SetGrandfatheringTimeReply:
        return "NetworkProcess_SetGrandfatheringTimeReply";
    case MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTestReply:
        return "NetworkProcess_SetIsRunningResourceLoadStatisticsTestReply";
    case MessageName::NetworkProcess_SetLastSeenReply:
        return "NetworkProcess_SetLastSeenReply";
    case MessageName::NetworkProcess_SetMaxStatisticsEntriesReply:
        return "NetworkProcess_SetMaxStatisticsEntriesReply";
    case MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemovalReply:
        return "NetworkProcess_SetMinimumTimeBetweenDataRecordsRemovalReply";
    case MessageName::NetworkProcess_SetNotifyPagesWhenDataRecordsWereScannedReply:
        return "NetworkProcess_SetNotifyPagesWhenDataRecordsWereScannedReply";
    case MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTestingReply:
        return "NetworkProcess_SetPCMFraudPreventionValuesForTestingReply";
    case MessageName::NetworkProcess_SetPrevalentResourceForDebugModeReply:
        return "NetworkProcess_SetPrevalentResourceForDebugModeReply";
    case MessageName::NetworkProcess_SetPrevalentResourceReply:
        return "NetworkProcess_SetPrevalentResourceReply";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTestingReply:
        return "NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTestingReply";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTestingReply:
        return "NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTestingReply";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTestingReply:
        return "NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTestingReply";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTestingReply:
        return "NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTestingReply";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTestingReply:
        return "NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTestingReply";
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTestingReply:
        return "NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTestingReply";
    case MessageName::NetworkProcess_SetPruneEntriesDownToReply:
        return "NetworkProcess_SetPruneEntriesDownToReply";
    case MessageName::NetworkProcess_SetResourceLoadStatisticsDebugModeReply:
        return "NetworkProcess_SetResourceLoadStatisticsDebugModeReply";
    case MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemovalReply:
        return "NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemovalReply";
    case MessageName::NetworkProcess_SetShouldDowngradeReferrerForTestingReply:
        return "NetworkProcess_SetShouldDowngradeReferrerForTestingReply";
    case MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTestingReply:
        return "NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTestingReply";
    case MessageName::NetworkProcess_SetSubframeUnderTopFrameDomainReply:
        return "NetworkProcess_SetSubframeUnderTopFrameDomainReply";
    case MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomainReply:
        return "NetworkProcess_SetSubresourceUnderTopFrameDomainReply";
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectFromReply:
        return "NetworkProcess_SetSubresourceUniqueRedirectFromReply";
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectToReply:
        return "NetworkProcess_SetSubresourceUniqueRedirectToReply";
    case MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTestingReply:
        return "NetworkProcess_SetThirdPartyCNAMEDomainForTestingReply";
    case MessageName::NetworkProcess_SetThirdPartyCookieBlockingModeReply:
        return "NetworkProcess_SetThirdPartyCookieBlockingModeReply";
    case MessageName::NetworkProcess_SetTimeToLiveUserInteractionReply:
        return "NetworkProcess_SetTimeToLiveUserInteractionReply";
    case MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTestingReply:
        return "NetworkProcess_SetToSameSiteStrictCookiesForTestingReply";
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectFromReply:
        return "NetworkProcess_SetTopFrameUniqueRedirectFromReply";
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectToReply:
        return "NetworkProcess_SetTopFrameUniqueRedirectToReply";
    case MessageName::NetworkProcess_SetVeryPrevalentResourceReply:
        return "NetworkProcess_SetVeryPrevalentResourceReply";
    case MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestartReply:
        return "NetworkProcess_SimulatePrivateClickMeasurementSessionRestartReply";
    case MessageName::NetworkProcess_StatisticsDatabaseHasAllTablesReply:
        return "NetworkProcess_StatisticsDatabaseHasAllTablesReply";
    case MessageName::NetworkProcess_SyncLocalStorageReply:
        return "NetworkProcess_SyncLocalStorageReply";
    case MessageName::NetworkProcess_UpdateBundleIdentifierReply:
        return "NetworkProcess_UpdateBundleIdentifierReply";
    case MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesForReply:
        return "NetworkProcess_UpdatePrevalentDomainsToBlockCookiesForReply";
    case MessageName::NetworkSocketChannel_SendDataReply:
        return "NetworkSocketChannel_SendDataReply";
    case MessageName::NetworkSocketChannel_SendStringReply:
        return "NetworkSocketChannel_SendStringReply";
    case MessageName::NetworkStorageManager_ClearReply:
        return "NetworkStorageManager_ClearReply";
    case MessageName::NetworkStorageManager_CloseSyncAccessHandleReply:
        return "NetworkStorageManager_CloseSyncAccessHandleReply";
    case MessageName::NetworkStorageManager_ConnectToStorageAreaReply:
        return "NetworkStorageManager_ConnectToStorageAreaReply";
    case MessageName::NetworkStorageManager_CreateSyncAccessHandleReply:
        return "NetworkStorageManager_CreateSyncAccessHandleReply";
    case MessageName::NetworkStorageManager_FileSystemGetDirectoryReply:
        return "NetworkStorageManager_FileSystemGetDirectoryReply";
    case MessageName::NetworkStorageManager_GetDirectoryHandleReply:
        return "NetworkStorageManager_GetDirectoryHandleReply";
    case MessageName::NetworkStorageManager_GetFileHandleReply:
        return "NetworkStorageManager_GetFileHandleReply";
    case MessageName::NetworkStorageManager_GetFileReply:
        return "NetworkStorageManager_GetFileReply";
    case MessageName::NetworkStorageManager_GetHandleNamesReply:
        return "NetworkStorageManager_GetHandleNamesReply";
    case MessageName::NetworkStorageManager_GetHandleReply:
        return "NetworkStorageManager_GetHandleReply";
    case MessageName::NetworkStorageManager_IsSameEntryReply:
        return "NetworkStorageManager_IsSameEntryReply";
    case MessageName::NetworkStorageManager_MoveReply:
        return "NetworkStorageManager_MoveReply";
    case MessageName::NetworkStorageManager_PersistReply:
        return "NetworkStorageManager_PersistReply";
    case MessageName::NetworkStorageManager_PersistedReply:
        return "NetworkStorageManager_PersistedReply";
    case MessageName::NetworkStorageManager_RemoveEntryReply:
        return "NetworkStorageManager_RemoveEntryReply";
    case MessageName::NetworkStorageManager_RemoveItemReply:
        return "NetworkStorageManager_RemoveItemReply";
    case MessageName::NetworkStorageManager_ResolveReply:
        return "NetworkStorageManager_ResolveReply";
    case MessageName::NetworkStorageManager_SetItemReply:
        return "NetworkStorageManager_SetItemReply";
    case MessageName::NotificationManagerMessageHandler_RequestSystemNotificationPermissionReply:
        return "NotificationManagerMessageHandler_RequestSystemNotificationPermissionReply";
    case MessageName::PlatformXRSystem_EnumerateImmersiveXRDevicesReply:
        return "PlatformXRSystem_EnumerateImmersiveXRDevicesReply";
    case MessageName::PlatformXRSystem_RequestFrameReply:
        return "PlatformXRSystem_RequestFrameReply";
    case MessageName::PlatformXRSystem_RequestPermissionOnSessionFeaturesReply:
        return "PlatformXRSystem_RequestPermissionOnSessionFeaturesReply";
    case MessageName::RemoteAudioDestinationManager_DeleteAudioDestinationReply:
        return "RemoteAudioDestinationManager_DeleteAudioDestinationReply";
    case MessageName::RemoteAudioDestinationManager_StartAudioDestinationReply:
        return "RemoteAudioDestinationManager_StartAudioDestinationReply";
    case MessageName::RemoteAudioDestinationManager_StopAudioDestinationReply:
        return "RemoteAudioDestinationManager_StopAudioDestinationReply";
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnitReply:
        return "RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnitReply";
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfigurationReply:
        return "RemoteCDMInstanceProxy_InitializeWithConfigurationReply";
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificateReply:
        return "RemoteCDMInstanceProxy_SetServerCertificateReply";
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSessionReply:
        return "RemoteCDMInstanceSessionProxy_CloseSessionReply";
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSessionReply:
        return "RemoteCDMInstanceSessionProxy_LoadSessionReply";
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionDataReply:
        return "RemoteCDMInstanceSessionProxy_RemoveSessionDataReply";
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicenseReply:
        return "RemoteCDMInstanceSessionProxy_RequestLicenseReply";
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicenseReply:
        return "RemoteCDMInstanceSessionProxy_UpdateLicenseReply";
    case MessageName::RemoteCDMProxy_GetSupportedConfigurationReply:
        return "RemoteCDMProxy_GetSupportedConfigurationReply";
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfigurationReply:
        return "RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfigurationReply";
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfigurationReply:
        return "RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfigurationReply";
    case MessageName::RemoteMediaPlayerProxy_DidLoadingProgressReply:
        return "RemoteMediaPlayerProxy_DidLoadingProgressReply";
    case MessageName::RemoteMediaPlayerProxy_LoadMediaSourceReply:
        return "RemoteMediaPlayerProxy_LoadMediaSourceReply";
    case MessageName::RemoteMediaPlayerProxy_LoadReply:
        return "RemoteMediaPlayerProxy_LoadReply";
    case MessageName::RemoteMediaPlayerProxy_PerformTaskAtMediaTimeReply:
        return "RemoteMediaPlayerProxy_PerformTaskAtMediaTimeReply";
    case MessageName::RemoteMediaPlayerProxy_PrepareForPlaybackReply:
        return "RemoteMediaPlayerProxy_PrepareForPlaybackReply";
    case MessageName::RemoteMediaRecorderManager_CreateRecorderReply:
        return "RemoteMediaRecorderManager_CreateRecorderReply";
    case MessageName::RemoteMediaRecorder_FetchDataReply:
        return "RemoteMediaRecorder_FetchDataReply";
    case MessageName::RemoteMediaRecorder_PauseReply:
        return "RemoteMediaRecorder_PauseReply";
    case MessageName::RemoteMediaRecorder_ResumeReply:
        return "RemoteMediaRecorder_ResumeReply";
    case MessageName::RemoteMediaRecorder_StopRecordingReply:
        return "RemoteMediaRecorder_StopRecordingReply";
    case MessageName::RemoteMediaResourceManager_RedirectReceivedReply:
        return "RemoteMediaResourceManager_RedirectReceivedReply";
    case MessageName::RemoteMediaResourceManager_ResponseReceivedReply:
        return "RemoteMediaResourceManager_ResponseReceivedReply";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePauseReply:
        return "RemoteMediaSessionCoordinatorProxy_CoordinatePauseReply";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlayReply:
        return "RemoteMediaSessionCoordinatorProxy_CoordinatePlayReply";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekToReply:
        return "RemoteMediaSessionCoordinatorProxy_CoordinateSeekToReply";
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrackReply:
        return "RemoteMediaSessionCoordinatorProxy_CoordinateSetTrackReply";
    case MessageName::RemoteMediaSessionCoordinatorProxy_JoinReply:
        return "RemoteMediaSessionCoordinatorProxy_JoinReply";
    case MessageName::RemoteMediaSessionCoordinator_PauseSessionReply:
        return "RemoteMediaSessionCoordinator_PauseSessionReply";
    case MessageName::RemoteMediaSessionCoordinator_PlaySessionReply:
        return "RemoteMediaSessionCoordinator_PlaySessionReply";
    case MessageName::RemoteMediaSessionCoordinator_SeekSessionToTimeReply:
        return "RemoteMediaSessionCoordinator_SeekSessionToTimeReply";
    case MessageName::RemoteMediaSessionCoordinator_SetSessionTrackReply:
        return "RemoteMediaSessionCoordinator_SetSessionTrackReply";
    case MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayerReply:
        return "RemoteSampleBufferDisplayLayerManager_CreateLayerReply";
    case MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackIdReply:
        return "RemoteSourceBufferProxy_BufferedSamplesForTrackIdReply";
    case MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackIDReply:
        return "RemoteSourceBufferProxy_EnqueuedSamplesForTrackIDReply";
    case MessageName::RemoteSourceBufferProxy_RemoveCodedFramesReply:
        return "RemoteSourceBufferProxy_RemoveCodedFramesReply";
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegmentReply:
        return "SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegmentReply";
    case MessageName::StorageManagerSet_ClearReply:
        return "StorageManagerSet_ClearReply";
    case MessageName::StorageManagerSet_RemoveItemReply:
        return "StorageManagerSet_RemoveItemReply";
    case MessageName::StorageManagerSet_SetItemReply:
        return "StorageManagerSet_SetItemReply";
    case MessageName::WebAutomationSessionProxy_ComputeElementLayoutReply:
        return "WebAutomationSessionProxy_ComputeElementLayoutReply";
    case MessageName::WebAutomationSessionProxy_DeleteCookieReply:
        return "WebAutomationSessionProxy_DeleteCookieReply";
    case MessageName::WebAutomationSessionProxy_GetCookiesForFrameReply:
        return "WebAutomationSessionProxy_GetCookiesForFrameReply";
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNameReply:
        return "WebAutomationSessionProxy_ResolveChildFrameWithNameReply";
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandleReply:
        return "WebAutomationSessionProxy_ResolveChildFrameWithNodeHandleReply";
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinalReply:
        return "WebAutomationSessionProxy_ResolveChildFrameWithOrdinalReply";
    case MessageName::WebAutomationSessionProxy_ResolveParentFrameReply:
        return "WebAutomationSessionProxy_ResolveParentFrameReply";
    case MessageName::WebAutomationSessionProxy_SelectOptionElementReply:
        return "WebAutomationSessionProxy_SelectOptionElementReply";
    case MessageName::WebAutomationSessionProxy_SetFilesForInputFileUploadReply:
        return "WebAutomationSessionProxy_SetFilesForInputFileUploadReply";
    case MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshotReply:
        return "WebAutomationSessionProxy_SnapshotRectForScreenshotReply";
    case MessageName::WebBroadcastChannelRegistry_PostMessageToRemoteReply:
        return "WebBroadcastChannelRegistry_PostMessageToRemoteReply";
    case MessageName::WebCookieManager_DeleteAllCookiesModifiedSinceReply:
        return "WebCookieManager_DeleteAllCookiesModifiedSinceReply";
    case MessageName::WebCookieManager_DeleteCookieReply:
        return "WebCookieManager_DeleteCookieReply";
    case MessageName::WebCookieManager_GetAllCookiesReply:
        return "WebCookieManager_GetAllCookiesReply";
    case MessageName::WebCookieManager_GetCookiesReply:
        return "WebCookieManager_GetCookiesReply";
    case MessageName::WebCookieManager_GetHTTPCookieAcceptPolicyReply:
        return "WebCookieManager_GetHTTPCookieAcceptPolicyReply";
    case MessageName::WebCookieManager_GetHostnamesWithCookiesReply:
        return "WebCookieManager_GetHostnamesWithCookiesReply";
    case MessageName::WebCookieManager_SetCookieReply:
        return "WebCookieManager_SetCookieReply";
    case MessageName::WebCookieManager_SetCookiesReply:
        return "WebCookieManager_SetCookiesReply";
    case MessageName::WebCookieManager_SetHTTPCookieAcceptPolicyReply:
        return "WebCookieManager_SetHTTPCookieAcceptPolicyReply";
    case MessageName::WebLockRegistryProxy_AbortLockRequestReply:
        return "WebLockRegistryProxy_AbortLockRequestReply";
    case MessageName::WebLockRegistryProxy_SnapshotReply:
        return "WebLockRegistryProxy_SnapshotReply";
    case MessageName::WebPageProxy_ClassifyModalContainerControlsReply:
        return "WebPageProxy_ClassifyModalContainerControlsReply";
    case MessageName::WebPageProxy_DecidePolicyForModalContainerReply:
        return "WebPageProxy_DecidePolicyForModalContainerReply";
    case MessageName::WebPageProxy_EnumerateMediaDevicesForFrameReply:
        return "WebPageProxy_EnumerateMediaDevicesForFrameReply";
    case MessageName::WebPageProxy_ModelElementAnimationCurrentTimeReply:
        return "WebPageProxy_ModelElementAnimationCurrentTimeReply";
    case MessageName::WebPageProxy_ModelElementAnimationDurationReply:
        return "WebPageProxy_ModelElementAnimationDurationReply";
    case MessageName::WebPageProxy_ModelElementDidCreatePreviewReply:
        return "WebPageProxy_ModelElementDidCreatePreviewReply";
    case MessageName::WebPageProxy_ModelElementGetCameraReply:
        return "WebPageProxy_ModelElementGetCameraReply";
    case MessageName::WebPageProxy_ModelElementHasAudioReply:
        return "WebPageProxy_ModelElementHasAudioReply";
    case MessageName::WebPageProxy_ModelElementIsLoopingAnimationReply:
        return "WebPageProxy_ModelElementIsLoopingAnimationReply";
    case MessageName::WebPageProxy_ModelElementIsMutedReply:
        return "WebPageProxy_ModelElementIsMutedReply";
    case MessageName::WebPageProxy_ModelElementIsPlayingAnimationReply:
        return "WebPageProxy_ModelElementIsPlayingAnimationReply";
    case MessageName::WebPageProxy_ModelElementSetAnimationCurrentTimeReply:
        return "WebPageProxy_ModelElementSetAnimationCurrentTimeReply";
    case MessageName::WebPageProxy_ModelElementSetAnimationIsPlayingReply:
        return "WebPageProxy_ModelElementSetAnimationIsPlayingReply";
    case MessageName::WebPageProxy_ModelElementSetCameraReply:
        return "WebPageProxy_ModelElementSetCameraReply";
    case MessageName::WebPageProxy_ModelElementSetIsLoopingAnimationReply:
        return "WebPageProxy_ModelElementSetIsLoopingAnimationReply";
    case MessageName::WebPageProxy_ModelElementSetIsMutedReply:
        return "WebPageProxy_ModelElementSetIsMutedReply";
    case MessageName::WebPageProxy_ModelElementSizeDidChangeReply:
        return "WebPageProxy_ModelElementSizeDidChangeReply";
    case MessageName::WebPageProxy_QueryPermissionReply:
        return "WebPageProxy_QueryPermissionReply";
    case MessageName::WebPageProxy_RequestCookieConsentReply:
        return "WebPageProxy_RequestCookieConsentReply";
    case MessageName::WebPageProxy_RequestNotificationPermissionReply:
        return "WebPageProxy_RequestNotificationPermissionReply";
    case MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrameReply:
        return "WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrameReply";
    case MessageName::WebPageProxy_RequestTextRecognitionReply:
        return "WebPageProxy_RequestTextRecognitionReply";
    case MessageName::WebPageProxy_SendMessageToWebViewWithReplyReply:
        return "WebPageProxy_SendMessageToWebViewWithReplyReply";
    case MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccessReply:
        return "WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccessReply";
    case MessageName::WebPageProxy_ShowContactPickerReply:
        return "WebPageProxy_ShowContactPickerReply";
    case MessageName::WebPageProxy_ShowEmojiPickerReply:
        return "WebPageProxy_ShowEmojiPickerReply";
    case MessageName::WebPageProxy_ShowMediaControlsContextMenuReply:
        return "WebPageProxy_ShowMediaControlsContextMenuReply";
    case MessageName::WebPageProxy_ShowShareSheetReply:
        return "WebPageProxy_ShowShareSheetReply";
    case MessageName::WebPageProxy_SpeechSynthesisPauseReply:
        return "WebPageProxy_SpeechSynthesisPauseReply";
    case MessageName::WebPageProxy_SpeechSynthesisResumeReply:
        return "WebPageProxy_SpeechSynthesisResumeReply";
    case MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallbackReply:
        return "WebPageProxy_SpeechSynthesisSetFinishedCallbackReply";
    case MessageName::WebPageProxy_SpeechSynthesisSpeakReply:
        return "WebPageProxy_SpeechSynthesisSpeakReply";
    case MessageName::WebPageProxy_StartApplePayAMSUISessionReply:
        return "WebPageProxy_StartApplePayAMSUISessionReply";
    case MessageName::WebPage_ApplyAutocorrectionReply:
        return "WebPage_ApplyAutocorrectionReply";
    case MessageName::WebPage_AttributedSubstringForCharacterRangeAsyncReply:
        return "WebPage_AttributedSubstringForCharacterRangeAsyncReply";
    case MessageName::WebPage_BeginSelectionInDirectionReply:
        return "WebPage_BeginSelectionInDirectionReply";
    case MessageName::WebPage_CharacterIndexForPointAsyncReply:
        return "WebPage_CharacterIndexForPointAsyncReply";
    case MessageName::WebPage_ClearServiceWorkerEntitlementOverrideReply:
        return "WebPage_ClearServiceWorkerEntitlementOverrideReply";
    case MessageName::WebPage_CompleteTextManipulationReply:
        return "WebPage_CompleteTextManipulationReply";
    case MessageName::WebPage_ComputePagesForPrintingReply:
        return "WebPage_ComputePagesForPrintingReply";
    case MessageName::WebPage_CreateMediaSessionCoordinatorReply:
        return "WebPage_CreateMediaSessionCoordinatorReply";
    case MessageName::WebPage_DetectDataInAllFramesReply:
        return "WebPage_DetectDataInAllFramesReply";
    case MessageName::WebPage_DidGetLoadDecisionForIconReply:
        return "WebPage_DidGetLoadDecisionForIconReply";
    case MessageName::WebPage_DispatchWheelEventWithoutScrollingReply:
        return "WebPage_DispatchWheelEventWithoutScrollingReply";
    case MessageName::WebPage_DrawPagesForPrintingReply:
        return "WebPage_DrawPagesForPrintingReply";
    case MessageName::WebPage_DrawPagesToPDFReply:
        return "WebPage_DrawPagesToPDFReply";
    case MessageName::WebPage_DrawRectToImageReply:
        return "WebPage_DrawRectToImageReply";
    case MessageName::WebPage_DrawToPDFReply:
        return "WebPage_DrawToPDFReply";
    case MessageName::WebPage_DrawToPDFiOSReply:
        return "WebPage_DrawToPDFiOSReply";
    case MessageName::WebPage_ExecuteEditCommandWithCallbackReply:
        return "WebPage_ExecuteEditCommandWithCallbackReply";
    case MessageName::WebPage_ExtendSelectionReply:
        return "WebPage_ExtendSelectionReply";
    case MessageName::WebPage_FindRectsForStringMatchesReply:
        return "WebPage_FindRectsForStringMatchesReply";
    case MessageName::WebPage_FindStringReply:
        return "WebPage_FindStringReply";
    case MessageName::WebPage_FindTextRangesForStringMatchesReply:
        return "WebPage_FindTextRangesForStringMatchesReply";
    case MessageName::WebPage_FirstRectForCharacterRangeAsyncReply:
        return "WebPage_FirstRectForCharacterRangeAsyncReply";
    case MessageName::WebPage_FocusNextFocusedElementReply:
        return "WebPage_FocusNextFocusedElementReply";
    case MessageName::WebPage_FocusTextInputContextAndPlaceCaretReply:
        return "WebPage_FocusTextInputContextAndPlaceCaretReply";
    case MessageName::WebPage_ForceRepaintReply:
        return "WebPage_ForceRepaintReply";
    case MessageName::WebPage_GetAllFramesReply:
        return "WebPage_GetAllFramesReply";
    case MessageName::WebPage_GetApplicationManifestReply:
        return "WebPage_GetApplicationManifestReply";
    case MessageName::WebPage_GetBytecodeProfileReply:
        return "WebPage_GetBytecodeProfileReply";
    case MessageName::WebPage_GetContentsAsAttributedStringReply:
        return "WebPage_GetContentsAsAttributedStringReply";
    case MessageName::WebPage_GetContentsAsMHTMLDataReply:
        return "WebPage_GetContentsAsMHTMLDataReply";
    case MessageName::WebPage_GetContentsAsStringReply:
        return "WebPage_GetContentsAsStringReply";
    case MessageName::WebPage_GetLoadedSubresourceDomainsReply:
        return "WebPage_GetLoadedSubresourceDomainsReply";
    case MessageName::WebPage_GetMainResourceDataOfFrameReply:
        return "WebPage_GetMainResourceDataOfFrameReply";
    case MessageName::WebPage_GetMarkedRangeAsyncReply:
        return "WebPage_GetMarkedRangeAsyncReply";
    case MessageName::WebPage_GetPDFFirstPageSizeReply:
        return "WebPage_GetPDFFirstPageSizeReply";
    case MessageName::WebPage_GetProcessDisplayNameReply:
        return "WebPage_GetProcessDisplayNameReply";
    case MessageName::WebPage_GetRectsAtSelectionOffsetWithTextReply:
        return "WebPage_GetRectsAtSelectionOffsetWithTextReply";
    case MessageName::WebPage_GetRectsForGranularityWithSelectionOffsetReply:
        return "WebPage_GetRectsForGranularityWithSelectionOffsetReply";
    case MessageName::WebPage_GetRenderTreeExternalRepresentationReply:
        return "WebPage_GetRenderTreeExternalRepresentationReply";
    case MessageName::WebPage_GetResourceDataFromFrameReply:
        return "WebPage_GetResourceDataFromFrameReply";
    case MessageName::WebPage_GetSamplingProfilerOutputReply:
        return "WebPage_GetSamplingProfilerOutputReply";
    case MessageName::WebPage_GetSelectedRangeAsyncReply:
        return "WebPage_GetSelectedRangeAsyncReply";
    case MessageName::WebPage_GetSelectionAsWebArchiveDataReply:
        return "WebPage_GetSelectionAsWebArchiveDataReply";
    case MessageName::WebPage_GetSelectionContextReply:
        return "WebPage_GetSelectionContextReply";
    case MessageName::WebPage_GetSelectionOrContentsAsStringReply:
        return "WebPage_GetSelectionOrContentsAsStringReply";
    case MessageName::WebPage_GetSourceForFrameReply:
        return "WebPage_GetSourceForFrameReply";
    case MessageName::WebPage_GetWebArchiveOfFrameReply:
        return "WebPage_GetWebArchiveOfFrameReply";
    case MessageName::WebPage_HasMarkedTextReply:
        return "WebPage_HasMarkedTextReply";
    case MessageName::WebPage_InsertAttachmentReply:
        return "WebPage_InsertAttachmentReply";
    case MessageName::WebPage_InsertDroppedImagePlaceholdersReply:
        return "WebPage_InsertDroppedImagePlaceholdersReply";
    case MessageName::WebPage_InsertTextPlaceholderReply:
        return "WebPage_InsertTextPlaceholderReply";
    case MessageName::WebPage_InteractableRegionsInRootViewCoordinatesReply:
        return "WebPage_InteractableRegionsInRootViewCoordinatesReply";
    case MessageName::WebPage_IsLayerTreeFrozenReply:
        return "WebPage_IsLayerTreeFrozenReply";
    case MessageName::WebPage_LastNavigationWasAppInitiatedReply:
        return "WebPage_LastNavigationWasAppInitiatedReply";
    case MessageName::WebPage_MediaKeySystemWasGrantedReply:
        return "WebPage_MediaKeySystemWasGrantedReply";
    case MessageName::WebPage_MoveSelectionAtBoundaryWithDirectionReply:
        return "WebPage_MoveSelectionAtBoundaryWithDirectionReply";
    case MessageName::WebPage_MoveSelectionByOffsetReply:
        return "WebPage_MoveSelectionByOffsetReply";
    case MessageName::WebPage_OpenPDFWithPreviewReply:
        return "WebPage_OpenPDFWithPreviewReply";
    case MessageName::WebPage_PauseAllMediaPlaybackReply:
        return "WebPage_PauseAllMediaPlaybackReply";
    case MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInViewReply:
        return "WebPage_PrepareSelectionForContextMenuWithLocationInViewReply";
    case MessageName::WebPage_RemoveDataDetectedLinksReply:
        return "WebPage_RemoveDataDetectedLinksReply";
    case MessageName::WebPage_RemoveTextPlaceholderReply:
        return "WebPage_RemoveTextPlaceholderReply";
    case MessageName::WebPage_ReplaceMatchesReply:
        return "WebPage_ReplaceMatchesReply";
    case MessageName::WebPage_RequestActiveNowPlayingSessionInfoReply:
        return "WebPage_RequestActiveNowPlayingSessionInfoReply";
    case MessageName::WebPage_RequestAutocorrectionDataReply:
        return "WebPage_RequestAutocorrectionDataReply";
    case MessageName::WebPage_RequestDictationContextReply:
        return "WebPage_RequestDictationContextReply";
    case MessageName::WebPage_RequestDocumentEditingContextReply:
        return "WebPage_RequestDocumentEditingContextReply";
    case MessageName::WebPage_RequestEvasionRectsAboveSelectionReply:
        return "WebPage_RequestEvasionRectsAboveSelectionReply";
    case MessageName::WebPage_RequestFocusedElementInformationReply:
        return "WebPage_RequestFocusedElementInformationReply";
    case MessageName::WebPage_RequestFontAttributesAtSelectionStartReply:
        return "WebPage_RequestFontAttributesAtSelectionStartReply";
    case MessageName::WebPage_RequestImageBitmapReply:
        return "WebPage_RequestImageBitmapReply";
    case MessageName::WebPage_RequestMediaPlaybackStateReply:
        return "WebPage_RequestMediaPlaybackStateReply";
    case MessageName::WebPage_RequestRVItemInCurrentSelectedRangeReply:
        return "WebPage_RequestRVItemInCurrentSelectedRangeReply";
    case MessageName::WebPage_RequestRectForFoundTextRangeReply:
        return "WebPage_RequestRectForFoundTextRangeReply";
    case MessageName::WebPage_ResumeAllMediaPlaybackReply:
        return "WebPage_ResumeAllMediaPlaybackReply";
    case MessageName::WebPage_ResumeReply:
        return "WebPage_ResumeReply";
    case MessageName::WebPage_RunJavaScriptInFrameInScriptWorldReply:
        return "WebPage_RunJavaScriptInFrameInScriptWorldReply";
    case MessageName::WebPage_SavePDFReply:
        return "WebPage_SavePDFReply";
    case MessageName::WebPage_SelectPositionAtBoundaryWithDirectionReply:
        return "WebPage_SelectPositionAtBoundaryWithDirectionReply";
    case MessageName::WebPage_SelectPositionAtPointReply:
        return "WebPage_SelectPositionAtPointReply";
    case MessageName::WebPage_SelectTextWithGranularityAtPointReply:
        return "WebPage_SelectTextWithGranularityAtPointReply";
    case MessageName::WebPage_SelectWithGestureReply:
        return "WebPage_SelectWithGestureReply";
    case MessageName::WebPage_SelectWithTwoTouchesReply:
        return "WebPage_SelectWithTwoTouchesReply";
    case MessageName::WebPage_SendMessageToWebExtensionWithReplyReply:
        return "WebPage_SendMessageToWebExtensionWithReplyReply";
    case MessageName::WebPage_SetActivityStateReply:
        return "WebPage_SetActivityStateReply";
    case MessageName::WebPage_SetInitialFocusReply:
        return "WebPage_SetInitialFocusReply";
    case MessageName::WebPage_SetMutedReply:
        return "WebPage_SetMutedReply";
    case MessageName::WebPage_StartTextManipulationsReply:
        return "WebPage_StartTextManipulationsReply";
    case MessageName::WebPage_StopMediaCaptureReply:
        return "WebPage_StopMediaCaptureReply";
    case MessageName::WebPage_SuspendAllMediaPlaybackReply:
        return "WebPage_SuspendAllMediaPlaybackReply";
    case MessageName::WebPage_SuspendReply:
        return "WebPage_SuspendReply";
    case MessageName::WebPage_TakeSnapshotReply:
        return "WebPage_TakeSnapshotReply";
    case MessageName::WebPage_TextInputContextsInRectReply:
        return "WebPage_TextInputContextsInRectReply";
    case MessageName::WebPage_TryCloseReply:
        return "WebPage_TryCloseReply";
    case MessageName::WebPage_URLSchemeTaskWillPerformRedirectionReply:
        return "WebPage_URLSchemeTaskWillPerformRedirectionReply";
    case MessageName::WebPage_UpdateAttachmentAttributesReply:
        return "WebPage_UpdateAttachmentAttributesReply";
    case MessageName::WebPage_UpdateSelectionWithDeltaReply:
        return "WebPage_UpdateSelectionWithDeltaReply";
    case MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundaryReply:
        return "WebPage_UpdateSelectionWithExtentPointAndBoundaryReply";
    case MessageName::WebPage_UpdateSelectionWithExtentPointReply:
        return "WebPage_UpdateSelectionWithExtentPointReply";
    case MessageName::WebPage_UpdateSelectionWithTouchesReply:
        return "WebPage_UpdateSelectionWithTouchesReply";
    case MessageName::WebPage_UpdateWithTextRecognitionResultReply:
        return "WebPage_UpdateWithTextRecognitionResultReply";
    case MessageName::WebPage_UserMediaAccessWasGrantedReply:
        return "WebPage_UserMediaAccessWasGrantedReply";
    case MessageName::WebPage_ValidateCommandReply:
        return "WebPage_ValidateCommandReply";
    case MessageName::WebProcessProxy_SendMessageToWebContextWithReplyReply:
        return "WebProcessProxy_SendMessageToWebContextWithReplyReply";
    case MessageName::WebProcess_ClearCachedPageReply:
        return "WebProcess_ClearCachedPageReply";
    case MessageName::WebProcess_DeleteWebsiteDataForOriginsReply:
        return "WebProcess_DeleteWebsiteDataForOriginsReply";
    case MessageName::WebProcess_DeleteWebsiteDataReply:
        return "WebProcess_DeleteWebsiteDataReply";
    case MessageName::WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcessReply:
        return "WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcessReply";
    case MessageName::WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcessReply:
        return "WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcessReply";
    case MessageName::WebProcess_FetchWebsiteDataReply:
        return "WebProcess_FetchWebsiteDataReply";
    case MessageName::WebProcess_GetActivePagesOriginsForTestingReply:
        return "WebProcess_GetActivePagesOriginsForTestingReply";
    case MessageName::WebProcess_IsJITEnabledReply:
        return "WebProcess_IsJITEnabledReply";
    case MessageName::WebProcess_PrepareToSuspendReply:
        return "WebProcess_PrepareToSuspendReply";
    case MessageName::WebProcess_SeedResourceLoadStatisticsForTestingReply:
        return "WebProcess_SeedResourceLoadStatisticsForTestingReply";
    case MessageName::WebProcess_SendResourceLoadStatisticsDataImmediatelyReply:
        return "WebProcess_SendResourceLoadStatisticsDataImmediatelyReply";
    case MessageName::WebProcess_SetDomainsWithCrossPageStorageAccessReply:
        return "WebProcess_SetDomainsWithCrossPageStorageAccessReply";
    case MessageName::WebProcess_SetThirdPartyCookieBlockingModeReply:
        return "WebProcess_SetThirdPartyCookieBlockingModeReply";
    case MessageName::WebSWClientConnection_SetDocumentIsControlledReply:
        return "WebSWClientConnection_SetDocumentIsControlledReply";
    case MessageName::WebSWContextManagerConnection_FirePushEventReply:
        return "WebSWContextManagerConnection_FirePushEventReply";
    case MessageName::WebSWServerConnection_DisableNavigationPreloadReply:
        return "WebSWServerConnection_DisableNavigationPreloadReply";
    case MessageName::WebSWServerConnection_EnableNavigationPreloadReply:
        return "WebSWServerConnection_EnableNavigationPreloadReply";
    case MessageName::WebSWServerConnection_GetNavigationPreloadStateReply:
        return "WebSWServerConnection_GetNavigationPreloadStateReply";
    case MessageName::WebSWServerConnection_GetPushPermissionStateReply:
        return "WebSWServerConnection_GetPushPermissionStateReply";
    case MessageName::WebSWServerConnection_GetPushSubscriptionReply:
        return "WebSWServerConnection_GetPushSubscriptionReply";
    case MessageName::WebSWServerConnection_GetRegistrationsReply:
        return "WebSWServerConnection_GetRegistrationsReply";
    case MessageName::WebSWServerConnection_MatchRegistrationReply:
        return "WebSWServerConnection_MatchRegistrationReply";
    case MessageName::WebSWServerConnection_ScheduleUnregisterJobInServerReply:
        return "WebSWServerConnection_ScheduleUnregisterJobInServerReply";
    case MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValueReply:
        return "WebSWServerConnection_SetNavigationPreloadHeaderValueReply";
    case MessageName::WebSWServerConnection_StoreRegistrationsOnDiskReply:
        return "WebSWServerConnection_StoreRegistrationsOnDiskReply";
    case MessageName::WebSWServerConnection_SubscribeToPushServiceReply:
        return "WebSWServerConnection_SubscribeToPushServiceReply";
    case MessageName::WebSWServerConnection_TerminateWorkerFromClientReply:
        return "WebSWServerConnection_TerminateWorkerFromClientReply";
    case MessageName::WebSWServerConnection_UnsubscribeFromPushServiceReply:
        return "WebSWServerConnection_UnsubscribeFromPushServiceReply";
    case MessageName::WebSWServerConnection_WhenRegistrationReadyReply:
        return "WebSWServerConnection_WhenRegistrationReadyReply";
    case MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTestingReply:
        return "WebSWServerConnection_WhenServiceWorkerIsTerminatedForTestingReply";
    case MessageName::WebSWServerToContextConnection_ClaimReply:
        return "WebSWServerToContextConnection_ClaimReply";
    case MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifierReply:
        return "WebSWServerToContextConnection_FindClientByVisibleIdentifierReply";
    case MessageName::WebSWServerToContextConnection_SkipWaitingReply:
        return "WebSWServerToContextConnection_SkipWaitingReply";
    case MessageName::WebSharedWorkerObjectConnection_FetchScriptInClientReply:
        return "WebSharedWorkerObjectConnection_FetchScriptInClientReply";
    case MessageName::WebUserContentControllerProxy_DidPostMessageReply:
        return "WebUserContentControllerProxy_DidPostMessageReply";
    case MessageName::GPUConnectionToWebProcess_EnsureAudioSession:
        return "GPUConnectionToWebProcess_EnsureAudioSession";
    case MessageName::IPCTester_StopMessageTesting:
        return "IPCTester_StopMessageTesting";
    case MessageName::NetworkConnectionToWebProcess_BlobSize:
        return "NetworkConnectionToWebProcess_BlobSize";
    case MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue:
        return "NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue";
    case MessageName::NetworkConnectionToWebProcess_CookiesForDOM:
        return "NetworkConnectionToWebProcess_CookiesForDOM";
    case MessageName::NetworkConnectionToWebProcess_DomCookiesForHost:
        return "NetworkConnectionToWebProcess_DomCookiesForHost";
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse:
        return "NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse";
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation:
        return "NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation";
    case MessageName::NetworkConnectionToWebProcess_GetRawCookies:
        return "NetworkConnectionToWebProcess_GetRawCookies";
    case MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad:
        return "NetworkConnectionToWebProcess_PerformSynchronousLoad";
    case MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics:
        return "NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics";
    case MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return "NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply";
    case MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return "NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply";
    case MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync:
        return "NetworkProcess_ProcessWillSuspendImminentlyForTestingSync";
    case MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting:
        return "NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting";
    case MessageName::NetworkProcess_SetAllowsAnySSLCertificateForWebSocket:
        return "NetworkProcess_SetAllowsAnySSLCertificateForWebSocket";
    case MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting:
        return "NetworkProcess_SetCacheModelSynchronouslyForTesting";
    case MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting:
        return "NetworkProcess_SetServiceWorkerFetchTimeoutForTesting";
    case MessageName::NetworkStorageManager_ConnectToStorageAreaSync:
        return "NetworkStorageManager_ConnectToStorageAreaSync";
    case MessageName::RemoteAdapter_RequestDevice:
        return "RemoteAdapter_RequestDevice";
    case MessageName::RemoteAudioDestinationManager_CreateAudioDestination:
        return "RemoteAudioDestinationManager_CreateAudioDestination";
    case MessageName::RemoteAudioSessionProxy_TryToSetActive:
        return "RemoteAudioSessionProxy_TryToSetActive";
    case MessageName::RemoteBuffer_MapAsync:
        return "RemoteBuffer_MapAsync";
    case MessageName::RemoteCDMFactoryProxy_CreateCDM:
        return "RemoteCDMFactoryProxy_CreateCDM";
    case MessageName::RemoteCDMFactoryProxy_SupportsKeySystem:
        return "RemoteCDMFactoryProxy_SupportsKeySystem";
    case MessageName::RemoteCDMInstanceProxy_CreateSession:
        return "RemoteCDMInstanceProxy_CreateSession";
    case MessageName::RemoteCDMProxy_CreateInstance:
        return "RemoteCDMProxy_CreateInstance";
    case MessageName::RemoteDevice_CreateComputePipelineAsync:
        return "RemoteDevice_CreateComputePipelineAsync";
    case MessageName::RemoteDevice_CreateRenderPipelineAsync:
        return "RemoteDevice_CreateRenderPipelineAsync";
    case MessageName::RemoteDevice_PopErrorScope:
        return "RemoteDevice_PopErrorScope";
    case MessageName::RemoteGPU_RequestAdapter:
        return "RemoteGPU_RequestAdapter";
    case MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus:
        return "RemoteGraphicsContextGL_CheckFramebufferStatus";
    case MessageName::RemoteGraphicsContextGL_ClientWaitSync:
        return "RemoteGraphicsContextGL_ClientWaitSync";
    case MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame:
        return "RemoteGraphicsContextGL_CopyTextureFromVideoFrame";
    case MessageName::RemoteGraphicsContextGL_CreateBuffer:
        return "RemoteGraphicsContextGL_CreateBuffer";
    case MessageName::RemoteGraphicsContextGL_CreateFramebuffer:
        return "RemoteGraphicsContextGL_CreateFramebuffer";
    case MessageName::RemoteGraphicsContextGL_CreateProgram:
        return "RemoteGraphicsContextGL_CreateProgram";
    case MessageName::RemoteGraphicsContextGL_CreateQuery:
        return "RemoteGraphicsContextGL_CreateQuery";
    case MessageName::RemoteGraphicsContextGL_CreateRenderbuffer:
        return "RemoteGraphicsContextGL_CreateRenderbuffer";
    case MessageName::RemoteGraphicsContextGL_CreateSampler:
        return "RemoteGraphicsContextGL_CreateSampler";
    case MessageName::RemoteGraphicsContextGL_CreateShader:
        return "RemoteGraphicsContextGL_CreateShader";
    case MessageName::RemoteGraphicsContextGL_CreateTexture:
        return "RemoteGraphicsContextGL_CreateTexture";
    case MessageName::RemoteGraphicsContextGL_CreateTransformFeedback:
        return "RemoteGraphicsContextGL_CreateTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_CreateVertexArray:
        return "RemoteGraphicsContextGL_CreateVertexArray";
    case MessageName::RemoteGraphicsContextGL_FenceSync:
        return "RemoteGraphicsContextGL_FenceSync";
    case MessageName::RemoteGraphicsContextGL_GetActiveAttrib:
        return "RemoteGraphicsContextGL_GetActiveAttrib";
    case MessageName::RemoteGraphicsContextGL_GetActiveUniform:
        return "RemoteGraphicsContextGL_GetActiveUniform";
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName:
        return "RemoteGraphicsContextGL_GetActiveUniformBlockName";
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv:
        return "RemoteGraphicsContextGL_GetActiveUniformBlockiv";
    case MessageName::RemoteGraphicsContextGL_GetActiveUniforms:
        return "RemoteGraphicsContextGL_GetActiveUniforms";
    case MessageName::RemoteGraphicsContextGL_GetAttribLocation:
        return "RemoteGraphicsContextGL_GetAttribLocation";
    case MessageName::RemoteGraphicsContextGL_GetBooleanv:
        return "RemoteGraphicsContextGL_GetBooleanv";
    case MessageName::RemoteGraphicsContextGL_GetBufferParameteri:
        return "RemoteGraphicsContextGL_GetBufferParameteri";
    case MessageName::RemoteGraphicsContextGL_GetBufferSubData:
        return "RemoteGraphicsContextGL_GetBufferSubData";
    case MessageName::RemoteGraphicsContextGL_GetError:
        return "RemoteGraphicsContextGL_GetError";
    case MessageName::RemoteGraphicsContextGL_GetFloatv:
        return "RemoteGraphicsContextGL_GetFloatv";
    case MessageName::RemoteGraphicsContextGL_GetFragDataLocation:
        return "RemoteGraphicsContextGL_GetFragDataLocation";
    case MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri:
        return "RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri";
    case MessageName::RemoteGraphicsContextGL_GetGraphicsResetStatusARB:
        return "RemoteGraphicsContextGL_GetGraphicsResetStatusARB";
    case MessageName::RemoteGraphicsContextGL_GetInteger64:
        return "RemoteGraphicsContextGL_GetInteger64";
    case MessageName::RemoteGraphicsContextGL_GetInteger64i:
        return "RemoteGraphicsContextGL_GetInteger64i";
    case MessageName::RemoteGraphicsContextGL_GetIntegerv:
        return "RemoteGraphicsContextGL_GetIntegerv";
    case MessageName::RemoteGraphicsContextGL_GetInternalformativ:
        return "RemoteGraphicsContextGL_GetInternalformativ";
    case MessageName::RemoteGraphicsContextGL_GetProgramInfoLog:
        return "RemoteGraphicsContextGL_GetProgramInfoLog";
    case MessageName::RemoteGraphicsContextGL_GetProgrami:
        return "RemoteGraphicsContextGL_GetProgrami";
    case MessageName::RemoteGraphicsContextGL_GetQuery:
        return "RemoteGraphicsContextGL_GetQuery";
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui:
        return "RemoteGraphicsContextGL_GetQueryObjectui";
    case MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri:
        return "RemoteGraphicsContextGL_GetRenderbufferParameteri";
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameterf:
        return "RemoteGraphicsContextGL_GetSamplerParameterf";
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameteri:
        return "RemoteGraphicsContextGL_GetSamplerParameteri";
    case MessageName::RemoteGraphicsContextGL_GetShaderInfoLog:
        return "RemoteGraphicsContextGL_GetShaderInfoLog";
    case MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat:
        return "RemoteGraphicsContextGL_GetShaderPrecisionFormat";
    case MessageName::RemoteGraphicsContextGL_GetShaderSource:
        return "RemoteGraphicsContextGL_GetShaderSource";
    case MessageName::RemoteGraphicsContextGL_GetShaderi:
        return "RemoteGraphicsContextGL_GetShaderi";
    case MessageName::RemoteGraphicsContextGL_GetString:
        return "RemoteGraphicsContextGL_GetString";
    case MessageName::RemoteGraphicsContextGL_GetSynci:
        return "RemoteGraphicsContextGL_GetSynci";
    case MessageName::RemoteGraphicsContextGL_GetTexParameterf:
        return "RemoteGraphicsContextGL_GetTexParameterf";
    case MessageName::RemoteGraphicsContextGL_GetTexParameteri:
        return "RemoteGraphicsContextGL_GetTexParameteri";
    case MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying:
        return "RemoteGraphicsContextGL_GetTransformFeedbackVarying";
    case MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE:
        return "RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE";
    case MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex:
        return "RemoteGraphicsContextGL_GetUniformBlockIndex";
    case MessageName::RemoteGraphicsContextGL_GetUniformIndices:
        return "RemoteGraphicsContextGL_GetUniformIndices";
    case MessageName::RemoteGraphicsContextGL_GetUniformLocation:
        return "RemoteGraphicsContextGL_GetUniformLocation";
    case MessageName::RemoteGraphicsContextGL_GetUniformfv:
        return "RemoteGraphicsContextGL_GetUniformfv";
    case MessageName::RemoteGraphicsContextGL_GetUniformiv:
        return "RemoteGraphicsContextGL_GetUniformiv";
    case MessageName::RemoteGraphicsContextGL_GetUniformuiv:
        return "RemoteGraphicsContextGL_GetUniformuiv";
    case MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset:
        return "RemoteGraphicsContextGL_GetVertexAttribOffset";
    case MessageName::RemoteGraphicsContextGL_IsBuffer:
        return "RemoteGraphicsContextGL_IsBuffer";
    case MessageName::RemoteGraphicsContextGL_IsEnabled:
        return "RemoteGraphicsContextGL_IsEnabled";
    case MessageName::RemoteGraphicsContextGL_IsFramebuffer:
        return "RemoteGraphicsContextGL_IsFramebuffer";
    case MessageName::RemoteGraphicsContextGL_IsProgram:
        return "RemoteGraphicsContextGL_IsProgram";
    case MessageName::RemoteGraphicsContextGL_IsQuery:
        return "RemoteGraphicsContextGL_IsQuery";
    case MessageName::RemoteGraphicsContextGL_IsRenderbuffer:
        return "RemoteGraphicsContextGL_IsRenderbuffer";
    case MessageName::RemoteGraphicsContextGL_IsSampler:
        return "RemoteGraphicsContextGL_IsSampler";
    case MessageName::RemoteGraphicsContextGL_IsShader:
        return "RemoteGraphicsContextGL_IsShader";
    case MessageName::RemoteGraphicsContextGL_IsSync:
        return "RemoteGraphicsContextGL_IsSync";
    case MessageName::RemoteGraphicsContextGL_IsTexture:
        return "RemoteGraphicsContextGL_IsTexture";
    case MessageName::RemoteGraphicsContextGL_IsTransformFeedback:
        return "RemoteGraphicsContextGL_IsTransformFeedback";
    case MessageName::RemoteGraphicsContextGL_IsVertexArray:
        return "RemoteGraphicsContextGL_IsVertexArray";
    case MessageName::RemoteGraphicsContextGL_MoveErrorsToSyntheticErrorList:
        return "RemoteGraphicsContextGL_MoveErrorsToSyntheticErrorList";
    case MessageName::RemoteGraphicsContextGL_PaintCompositedResultsToCanvas:
        return "RemoteGraphicsContextGL_PaintCompositedResultsToCanvas";
    case MessageName::RemoteGraphicsContextGL_PaintCompositedResultsToMediaSample:
        return "RemoteGraphicsContextGL_PaintCompositedResultsToMediaSample";
    case MessageName::RemoteGraphicsContextGL_PaintRenderingResultsToCanvas:
        return "RemoteGraphicsContextGL_PaintRenderingResultsToCanvas";
    case MessageName::RemoteGraphicsContextGL_PaintRenderingResultsToPixelBuffer:
        return "RemoteGraphicsContextGL_PaintRenderingResultsToPixelBuffer";
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return "RemoteGraphicsContextGL_PrepareForDisplay";
    case MessageName::RemoteGraphicsContextGL_ReadnPixels0:
        return "RemoteGraphicsContextGL_ReadnPixels0";
    case MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM:
        return "RemoteLegacyCDMFactoryProxy_CreateCDM";
    case MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem:
        return "RemoteLegacyCDMFactoryProxy_SupportsKeySystem";
    case MessageName::RemoteLegacyCDMProxy_CreateSession:
        return "RemoteLegacyCDMProxy_CreateSession";
    case MessageName::RemoteLegacyCDMProxy_SupportsMIMEType:
        return "RemoteLegacyCDMProxy_SupportsMIMEType";
    case MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID:
        return "RemoteLegacyCDMSessionProxy_CachedKeyForKeyID";
    case MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest:
        return "RemoteLegacyCDMSessionProxy_GenerateKeyRequest";
    case MessageName::RemoteLegacyCDMSessionProxy_Update:
        return "RemoteLegacyCDMSessionProxy_Update";
    case MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes:
        return "RemoteMediaPlayerManagerProxy_GetSupportedTypes";
    case MessageName::RemoteMediaPlayerManagerProxy_OriginsInMediaCache:
        return "RemoteMediaPlayerManagerProxy_OriginsInMediaCache";
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem:
        return "RemoteMediaPlayerManagerProxy_SupportsKeySystem";
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs:
        return "RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs";
    case MessageName::RemoteMediaPlayerProxy_AccessLog:
        return "RemoteMediaPlayerProxy_AccessLog";
    case MessageName::RemoteMediaPlayerProxy_ColorSpace:
        return "RemoteMediaPlayerProxy_ColorSpace";
    case MessageName::RemoteMediaPlayerProxy_ErrorLog:
        return "RemoteMediaPlayerProxy_ErrorLog";
    case MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime:
        return "RemoteMediaPlayerProxy_NativeImageForCurrentTime";
    case MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged:
        return "RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged";
    case MessageName::RemoteMediaPlayerProxy_WouldTaintOrigin:
        return "RemoteMediaPlayerProxy_WouldTaintOrigin";
    case MessageName::RemoteMediaSourceProxy_AddSourceBuffer:
        return "RemoteMediaSourceProxy_AddSourceBuffer";
    case MessageName::RemoteQueue_OnSubmittedWorkDone:
        return "RemoteQueue_OnSubmittedWorkDone";
    case MessageName::RemoteRenderingBackend_GetDataForImageBuffer:
        return "RemoteRenderingBackend_GetDataForImageBuffer";
    case MessageName::RemoteRenderingBackend_GetDataURLForImageBuffer:
        return "RemoteRenderingBackend_GetDataURLForImageBuffer";
    case MessageName::RemoteRenderingBackend_GetFilteredImageForImageBuffer:
        return "RemoteRenderingBackend_GetFilteredImageForImageBuffer";
    case MessageName::RemoteRenderingBackend_GetPixelBufferForImageBuffer:
        return "RemoteRenderingBackend_GetPixelBufferForImageBuffer";
    case MessageName::RemoteRenderingBackend_GetPixelBufferForImageBufferWithNewMemory:
        return "RemoteRenderingBackend_GetPixelBufferForImageBufferWithNewMemory";
    case MessageName::RemoteRenderingBackend_GetShareableBitmapForImageBuffer:
        return "RemoteRenderingBackend_GetShareableBitmapForImageBuffer";
    case MessageName::RemoteRenderingBackend_MarkSurfaceNonVolatile:
        return "RemoteRenderingBackend_MarkSurfaceNonVolatile";
    case MessageName::RemoteRenderingBackend_MarkSurfacesVolatile:
        return "RemoteRenderingBackend_MarkSurfacesVolatile";
    case MessageName::RemoteRenderingBackend_SwapToValidFrontBuffer:
        return "RemoteRenderingBackend_SwapToValidFrontBuffer";
    case MessageName::RemoteShaderModule_CompilationInfo:
        return "RemoteShaderModule_CompilationInfo";
    case MessageName::RemoteSourceBufferProxy_CanSwitchToType:
        return "RemoteSourceBufferProxy_CanSwitchToType";
    case MessageName::RemoteSourceBufferProxy_EvictCodedFrames:
        return "RemoteSourceBufferProxy_EvictCodedFrames";
    case MessageName::RemoteSourceBufferProxy_UpdateBufferedFromTrackBuffers:
        return "RemoteSourceBufferProxy_UpdateBufferedFromTrackBuffers";
    case MessageName::StorageManagerSet_ConnectToLocalStorageArea:
        return "StorageManagerSet_ConnectToLocalStorageArea";
    case MessageName::StorageManagerSet_ConnectToSessionStorageArea:
        return "StorageManagerSet_ConnectToSessionStorageArea";
    case MessageName::StorageManagerSet_ConnectToTransientLocalStorageArea:
        return "StorageManagerSet_ConnectToTransientLocalStorageArea";
    case MessageName::StorageManagerSet_GetValues:
        return "StorageManagerSet_GetValues";
    case MessageName::WebFullScreenManagerProxy_SupportsFullScreen:
        return "WebFullScreenManagerProxy_SupportsFullScreen";
    case MessageName::WebPageProxy_AccessibilityScreenToRootView:
        return "WebPageProxy_AccessibilityScreenToRootView";
    case MessageName::WebPageProxy_BackForwardGoToItem:
        return "WebPageProxy_BackForwardGoToItem";
    case MessageName::WebPageProxy_BackForwardItemAtIndex:
        return "WebPageProxy_BackForwardItemAtIndex";
    case MessageName::WebPageProxy_BackForwardListCounts:
        return "WebPageProxy_BackForwardListCounts";
    case MessageName::WebPageProxy_CanUndoRedo:
        return "WebPageProxy_CanUndoRedo";
    case MessageName::WebPageProxy_CheckGrammarOfString:
        return "WebPageProxy_CheckGrammarOfString";
    case MessageName::WebPageProxy_CheckSpellingOfString:
        return "WebPageProxy_CheckSpellingOfString";
    case MessageName::WebPageProxy_CheckTextOfParagraph:
        return "WebPageProxy_CheckTextOfParagraph";
    case MessageName::WebPageProxy_CreateNewPage:
        return "WebPageProxy_CreateNewPage";
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionSync:
        return "WebPageProxy_DecidePolicyForNavigationActionSync";
    case MessageName::WebPageProxy_DictationAlternatives:
        return "WebPageProxy_DictationAlternatives";
    case MessageName::WebPageProxy_DismissCorrectionPanelSoon:
        return "WebPageProxy_DismissCorrectionPanelSoon";
    case MessageName::WebPageProxy_ExceededDatabaseQuota:
        return "WebPageProxy_ExceededDatabaseQuota";
    case MessageName::WebPageProxy_ExecuteSavedCommandBySelector:
        return "WebPageProxy_ExecuteSavedCommandBySelector";
    case MessageName::WebPageProxy_ExecuteUndoRedo:
        return "WebPageProxy_ExecuteUndoRedo";
    case MessageName::WebPageProxy_GetGuessesForWord:
        return "WebPageProxy_GetGuessesForWord";
    case MessageName::WebPageProxy_GetIsSpeaking:
        return "WebPageProxy_GetIsSpeaking";
    case MessageName::WebPageProxy_GetMenuBarIsVisible:
        return "WebPageProxy_GetMenuBarIsVisible";
    case MessageName::WebPageProxy_GetStatusBarIsVisible:
        return "WebPageProxy_GetStatusBarIsVisible";
    case MessageName::WebPageProxy_GetToolbarsAreVisible:
        return "WebPageProxy_GetToolbarsAreVisible";
    case MessageName::WebPageProxy_GetWindowFrame:
        return "WebPageProxy_GetWindowFrame";
    case MessageName::WebPageProxy_HandleSynchronousMessage:
        return "WebPageProxy_HandleSynchronousMessage";
    case MessageName::WebPageProxy_InterpretKeyEvent:
        return "WebPageProxy_InterpretKeyEvent";
    case MessageName::WebPageProxy_LoadRecentSearches:
        return "WebPageProxy_LoadRecentSearches";
    case MessageName::WebPageProxy_LoadSynchronousURLSchemeTask:
        return "WebPageProxy_LoadSynchronousURLSchemeTask";
    case MessageName::WebPageProxy_PrintFrame:
        return "WebPageProxy_PrintFrame";
    case MessageName::WebPageProxy_ReachedApplicationCacheOriginQuota:
        return "WebPageProxy_ReachedApplicationCacheOriginQuota";
    case MessageName::WebPageProxy_RequestDOMPasteAccess:
        return "WebPageProxy_RequestDOMPasteAccess";
    case MessageName::WebPageProxy_ResolveWebGLPolicyForURL:
        return "WebPageProxy_ResolveWebGLPolicyForURL";
    case MessageName::WebPageProxy_RootViewToAccessibilityScreen:
        return "WebPageProxy_RootViewToAccessibilityScreen";
    case MessageName::WebPageProxy_RootViewToScreen:
        return "WebPageProxy_RootViewToScreen";
    case MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel:
        return "WebPageProxy_RunBeforeUnloadConfirmPanel";
    case MessageName::WebPageProxy_RunJavaScriptAlert:
        return "WebPageProxy_RunJavaScriptAlert";
    case MessageName::WebPageProxy_RunJavaScriptConfirm:
        return "WebPageProxy_RunJavaScriptConfirm";
    case MessageName::WebPageProxy_RunJavaScriptPrompt:
        return "WebPageProxy_RunJavaScriptPrompt";
    case MessageName::WebPageProxy_ScreenToRootView:
        return "WebPageProxy_ScreenToRootView";
    case MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers:
        return "WebPageProxy_SerializedAttachmentDataForIdentifiers";
    case MessageName::WebPageProxy_ShowPDFContextMenu:
        return "WebPageProxy_ShowPDFContextMenu";
    case MessageName::WebPageProxy_SignedPublicKeyAndChallengeString:
        return "WebPageProxy_SignedPublicKeyAndChallengeString";
    case MessageName::WebPageProxy_SpeechSynthesisVoiceList:
        return "WebPageProxy_SpeechSynthesisVoiceList";
    case MessageName::WebPageProxy_SpellingUIIsShowing:
        return "WebPageProxy_SpellingUIIsShowing";
    case MessageName::WebPageProxy_SubstitutionsPanelIsShowing:
        return "WebPageProxy_SubstitutionsPanelIsShowing";
    case MessageName::WebPageProxy_UnwrapCryptoKey:
        return "WebPageProxy_UnwrapCryptoKey";
    case MessageName::WebPageProxy_WebGLPolicyForURL:
        return "WebPageProxy_WebGLPolicyForURL";
    case MessageName::WebPageProxy_WrapCryptoKey:
        return "WebPageProxy_WrapCryptoKey";
    case MessageName::WebPage_ComputePagesForPrintingiOS:
        return "WebPage_ComputePagesForPrintingiOS";
    case MessageName::WebPage_GetDataSelectionForPasteboard:
        return "WebPage_GetDataSelectionForPasteboard";
    case MessageName::WebPage_GetPositionInformation:
        return "WebPage_GetPositionInformation";
    case MessageName::WebPage_GetStringSelectionForPasteboard:
        return "WebPage_GetStringSelectionForPasteboard";
    case MessageName::WebPage_ReadSelectionFromPasteboard:
        return "WebPage_ReadSelectionFromPasteboard";
    case MessageName::WebPage_ShouldDelayWindowOrderingEvent:
        return "WebPage_ShouldDelayWindowOrderingEvent";
    case MessageName::WebPage_SyncApplyAutocorrection:
        return "WebPage_SyncApplyAutocorrection";
    case MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return "WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply";
    case MessageName::WebPage_TouchEventSync:
        return "WebPage_TouchEventSync";
    case MessageName::WebPasteboardProxy_AddPasteboardTypes:
        return "WebPasteboardProxy_AddPasteboardTypes";
    case MessageName::WebPasteboardProxy_AllPasteboardItemInfo:
        return "WebPasteboardProxy_AllPasteboardItemInfo";
    case MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType:
        return "WebPasteboardProxy_ContainsStringSafeForDOMToReadForType";
    case MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading:
        return "WebPasteboardProxy_ContainsURLStringSuitableForLoading";
    case MessageName::WebPasteboardProxy_GetNumberOfFiles:
        return "WebPasteboardProxy_GetNumberOfFiles";
    case MessageName::WebPasteboardProxy_GetPasteboardBufferForType:
        return "WebPasteboardProxy_GetPasteboardBufferForType";
    case MessageName::WebPasteboardProxy_GetPasteboardChangeCount:
        return "WebPasteboardProxy_GetPasteboardChangeCount";
    case MessageName::WebPasteboardProxy_GetPasteboardColor:
        return "WebPasteboardProxy_GetPasteboardColor";
    case MessageName::WebPasteboardProxy_GetPasteboardItemsCount:
        return "WebPasteboardProxy_GetPasteboardItemsCount";
    case MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType:
        return "WebPasteboardProxy_GetPasteboardPathnamesForType";
    case MessageName::WebPasteboardProxy_GetPasteboardStringForType:
        return "WebPasteboardProxy_GetPasteboardStringForType";
    case MessageName::WebPasteboardProxy_GetPasteboardStringsForType:
        return "WebPasteboardProxy_GetPasteboardStringsForType";
    case MessageName::WebPasteboardProxy_GetPasteboardTypes:
        return "WebPasteboardProxy_GetPasteboardTypes";
    case MessageName::WebPasteboardProxy_GetPasteboardURL:
        return "WebPasteboardProxy_GetPasteboardURL";
    case MessageName::WebPasteboardProxy_GetTypes:
        return "WebPasteboardProxy_GetTypes";
    case MessageName::WebPasteboardProxy_InformationForItemAtIndex:
        return "WebPasteboardProxy_InformationForItemAtIndex";
    case MessageName::WebPasteboardProxy_ReadBuffer:
        return "WebPasteboardProxy_ReadBuffer";
    case MessageName::WebPasteboardProxy_ReadBufferFromPasteboard:
        return "WebPasteboardProxy_ReadBufferFromPasteboard";
    case MessageName::WebPasteboardProxy_ReadFilePaths:
        return "WebPasteboardProxy_ReadFilePaths";
    case MessageName::WebPasteboardProxy_ReadStringFromPasteboard:
        return "WebPasteboardProxy_ReadStringFromPasteboard";
    case MessageName::WebPasteboardProxy_ReadText:
        return "WebPasteboardProxy_ReadText";
    case MessageName::WebPasteboardProxy_ReadURLFromPasteboard:
        return "WebPasteboardProxy_ReadURLFromPasteboard";
    case MessageName::WebPasteboardProxy_SetPasteboardBufferForType:
        return "WebPasteboardProxy_SetPasteboardBufferForType";
    case MessageName::WebPasteboardProxy_SetPasteboardColor:
        return "WebPasteboardProxy_SetPasteboardColor";
    case MessageName::WebPasteboardProxy_SetPasteboardStringForType:
        return "WebPasteboardProxy_SetPasteboardStringForType";
    case MessageName::WebPasteboardProxy_SetPasteboardTypes:
        return "WebPasteboardProxy_SetPasteboardTypes";
    case MessageName::WebPasteboardProxy_SetPasteboardURL:
        return "WebPasteboardProxy_SetPasteboardURL";
    case MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite:
        return "WebPasteboardProxy_TypesSafeForDOMToReadAndWrite";
    case MessageName::WebPasteboardProxy_URLStringSuitableForLoading:
        return "WebPasteboardProxy_URLStringSuitableForLoading";
    case MessageName::WebPasteboardProxy_WriteCustomData:
        return "WebPasteboardProxy_WriteCustomData";
    case MessageName::WebProcessPool_HandleSynchronousMessage:
        return "WebProcessPool_HandleSynchronousMessage";
    case MessageName::WebProcessProxy_GetGPUProcessConnection:
        return "WebProcessProxy_GetGPUProcessConnection";
    case MessageName::WebProcessProxy_GetNetworkProcessConnection:
        return "WebProcessProxy_GetNetworkProcessConnection";
    case MessageName::WebProcessProxy_GetWebAuthnProcessConnection:
        return "WebProcessProxy_GetWebAuthnProcessConnection";
    case MessageName::WebProcessProxy_IsAXAuthenticated:
        return "WebProcessProxy_IsAXAuthenticated";
    case MessageName::WebProcessProxy_ShouldTerminate:
        return "WebProcessProxy_ShouldTerminate";
    case MessageName::WrappedAsyncMessageForTesting:
        return "WrappedAsyncMessageForTesting";
    }
    ASSERT_NOT_REACHED();
    return "<invalid message name>";
}

ReceiverName receiverName(MessageName messageName)
{
    switch (messageName) {
    case MessageName::AuthenticationManager_CompleteAuthenticationChallenge:
        return ReceiverName::AuthenticationManager;
    case MessageName::AuxiliaryProcess_DidReceiveMemoryPressureEvent:
    case MessageName::AuxiliaryProcess_MainThreadPing:
    case MessageName::AuxiliaryProcess_SetProcessSuppressionEnabled:
    case MessageName::AuxiliaryProcess_ShutDown:
        return ReceiverName::AuxiliaryProcess;
    case MessageName::CacheStorageEngineConnection_Caches:
    case MessageName::CacheStorageEngineConnection_ClearMemoryRepresentation:
    case MessageName::CacheStorageEngineConnection_DeleteMatchingRecords:
    case MessageName::CacheStorageEngineConnection_Dereference:
    case MessageName::CacheStorageEngineConnection_EngineRepresentation:
    case MessageName::CacheStorageEngineConnection_Open:
    case MessageName::CacheStorageEngineConnection_PutRecords:
    case MessageName::CacheStorageEngineConnection_Reference:
    case MessageName::CacheStorageEngineConnection_Remove:
    case MessageName::CacheStorageEngineConnection_RetrieveRecords:
        return ReceiverName::CacheStorageEngineConnection;
    case MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename:
    case MessageName::DownloadProxy_DidCreateDestination:
    case MessageName::DownloadProxy_DidFail:
    case MessageName::DownloadProxy_DidFinish:
    case MessageName::DownloadProxy_DidReceiveAuthenticationChallenge:
    case MessageName::DownloadProxy_DidReceiveData:
    case MessageName::DownloadProxy_DidStart:
    case MessageName::DownloadProxy_WillSendRequest:
        return ReceiverName::DownloadProxy;
    case MessageName::DrawingAreaProxy_DidFirstLayerFlush:
    case MessageName::DrawingAreaProxy_DidUpdateBackingStoreState:
    case MessageName::DrawingAreaProxy_DidUpdateGeometry:
    case MessageName::DrawingAreaProxy_DispatchPresentationCallbacksAfterFlushingLayers:
    case MessageName::DrawingAreaProxy_EnterAcceleratedCompositingMode:
    case MessageName::DrawingAreaProxy_ExitAcceleratedCompositingMode:
    case MessageName::DrawingAreaProxy_Update:
    case MessageName::DrawingAreaProxy_UpdateAcceleratedCompositingMode:
        return ReceiverName::DrawingAreaProxy;
    case MessageName::DrawingArea_AcceleratedAnimationDidEnd:
    case MessageName::DrawingArea_AcceleratedAnimationDidStart:
    case MessageName::DrawingArea_AddTransactionCallbackID:
    case MessageName::DrawingArea_AdjustTransientZoom:
    case MessageName::DrawingArea_CommitTransientZoom:
    case MessageName::DrawingArea_DidUpdate:
    case MessageName::DrawingArea_SetColorSpace:
    case MessageName::DrawingArea_SetDeviceScaleFactor:
    case MessageName::DrawingArea_SetViewExposedRect:
    case MessageName::DrawingArea_UpdateBackingStoreState:
    case MessageName::DrawingArea_UpdateGeometry:
        return ReceiverName::DrawingArea;
    case MessageName::EventDispatcher_DisplayWasRefreshed:
    case MessageName::EventDispatcher_GestureEvent:
    case MessageName::EventDispatcher_PageScreenDidChange:
    case MessageName::EventDispatcher_SetScrollingAccelerationCurve:
    case MessageName::EventDispatcher_TouchEvent:
    case MessageName::EventDispatcher_TouchEventWithoutCallback:
    case MessageName::EventDispatcher_WheelEvent:
        return ReceiverName::EventDispatcher;
    case MessageName::GPUConnectionToWebProcess_ClearNowPlayingInfo:
    case MessageName::GPUConnectionToWebProcess_ConfigureLoggingChannel:
    case MessageName::GPUConnectionToWebProcess_CreateAudioHardwareListener:
    case MessageName::GPUConnectionToWebProcess_CreateGraphicsContextGL:
    case MessageName::GPUConnectionToWebProcess_CreateRemoteCommandListener:
    case MessageName::GPUConnectionToWebProcess_CreateRemoteGPU:
    case MessageName::GPUConnectionToWebProcess_CreateRenderingBackend:
    case MessageName::GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage:
    case MessageName::GPUConnectionToWebProcess_CreateWCLayerTreeHost:
    case MessageName::GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage:
    case MessageName::GPUConnectionToWebProcess_EnableVP9Decoders:
    case MessageName::GPUConnectionToWebProcess_EnsureMediaSessionHelper:
    case MessageName::GPUConnectionToWebProcess_ReleaseAudioHardwareListener:
    case MessageName::GPUConnectionToWebProcess_ReleaseGraphicsContextGL:
    case MessageName::GPUConnectionToWebProcess_ReleaseRemoteCommandListener:
    case MessageName::GPUConnectionToWebProcess_ReleaseRenderingBackend:
    case MessageName::GPUConnectionToWebProcess_ReleaseWCLayerTreeHost:
    case MessageName::GPUConnectionToWebProcess_SetMediaOverridesForTesting:
    case MessageName::GPUConnectionToWebProcess_SetNowPlayingInfo:
    case MessageName::GPUConnectionToWebProcess_SetUserPreferredLanguages:
        return ReceiverName::GPUConnectionToWebProcess;
    case MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory:
    case MessageName::GPUProcessConnection_DidReceiveRemoteCommand:
    case MessageName::GPUProcessConnection_EndRoutingArbitration:
    case MessageName::GPUProcessConnection_ResetAudioMediaStreamTrackRendererInternalUnit:
        return ReceiverName::GPUProcessConnection;
    case MessageName::GPUProcessProxy_DidCreateContextForVisibilityPropagation:
    case MessageName::GPUProcessProxy_ProcessIsReadyToExit:
    case MessageName::GPUProcessProxy_TerminateWebProcess:
        return ReceiverName::GPUProcessProxy;
    case MessageName::GPUProcess_AddMockMediaDevice:
    case MessageName::GPUProcess_AddSession:
    case MessageName::GPUProcess_ClearMockMediaDevices:
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcess:
    case MessageName::GPUProcess_DisplayConfigurationChanged:
    case MessageName::GPUProcess_InitializeGPUProcess:
    case MessageName::GPUProcess_NotifyPreferencesChanged:
    case MessageName::GPUProcess_PrepareToSuspend:
    case MessageName::GPUProcess_ProcessDidResume:
    case MessageName::GPUProcess_RemoveMockMediaDevice:
    case MessageName::GPUProcess_RemoveSession:
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTime:
    case MessageName::GPUProcess_ResetMockMediaDevices:
    case MessageName::GPUProcess_SetMediaSourceInlinePaintingEnabled:
    case MessageName::GPUProcess_SetMockCameraIsInterrupted:
    case MessageName::GPUProcess_SetMockCaptureDevicesEnabled:
    case MessageName::GPUProcess_SetOpusDecoderEnabled:
    case MessageName::GPUProcess_SetOrientationForMediaCapture:
    case MessageName::GPUProcess_SetScreenProperties:
    case MessageName::GPUProcess_SetUseScreenCaptureKit:
    case MessageName::GPUProcess_SetVorbisDecoderEnabled:
    case MessageName::GPUProcess_SetWebMFormatReaderEnabled:
    case MessageName::GPUProcess_SetWebMParserEnabled:
    case MessageName::GPUProcess_ShowScreenPicker:
    case MessageName::GPUProcess_ShowWindowPicker:
    case MessageName::GPUProcess_UpdateCaptureAccess:
    case MessageName::GPUProcess_UpdateCaptureOrigin:
    case MessageName::GPUProcess_UpdateSandboxAccess:
    case MessageName::GPUProcess_WebProcessConnectionCountForTesting:
        return ReceiverName::GPUProcess;
    case MessageName::GtkSettingsManagerProxy_SettingsDidChange:
        return ReceiverName::GtkSettingsManagerProxy;
    case MessageName::IPCTester_StartMessageTesting:
        return ReceiverName::IPCTester;
    case MessageName::LibWebRTCCodecsProxy_CreateEncoder:
    case MessageName::LibWebRTCCodecsProxy_CreateH264Decoder:
    case MessageName::LibWebRTCCodecsProxy_CreateH265Decoder:
    case MessageName::LibWebRTCCodecsProxy_CreateVP9Decoder:
    case MessageName::LibWebRTCCodecsProxy_DecodeFrame:
    case MessageName::LibWebRTCCodecsProxy_EncodeFrame:
    case MessageName::LibWebRTCCodecsProxy_InitializeEncoder:
    case MessageName::LibWebRTCCodecsProxy_ReleaseDecoder:
    case MessageName::LibWebRTCCodecsProxy_ReleaseEncoder:
    case MessageName::LibWebRTCCodecsProxy_SetEncodeRates:
    case MessageName::LibWebRTCCodecsProxy_SetFrameSize:
    case MessageName::LibWebRTCCodecsProxy_SetRTCLoggingLevel:
    case MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameMemory:
    case MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameSemaphore:
        return ReceiverName::LibWebRTCCodecsProxy;
    case MessageName::LibWebRTCCodecs_CompletedDecoding:
    case MessageName::LibWebRTCCodecs_CompletedEncoding:
    case MessageName::LibWebRTCCodecs_FailedDecoding:
        return ReceiverName::LibWebRTCCodecs;
    case MessageName::LibWebRTCNetwork_SignalAddressReady:
    case MessageName::LibWebRTCNetwork_SignalClose:
    case MessageName::LibWebRTCNetwork_SignalConnect:
    case MessageName::LibWebRTCNetwork_SignalNewConnection:
    case MessageName::LibWebRTCNetwork_SignalReadPacket:
    case MessageName::LibWebRTCNetwork_SignalSentPacket:
        return ReceiverName::LibWebRTCNetwork;
    case MessageName::MediaPlayerPrivateRemote_ActiveSourceBuffersChanged:
    case MessageName::MediaPlayerPrivateRemote_AddDataCue:
    case MessageName::MediaPlayerPrivateRemote_AddDataCueWithType:
    case MessageName::MediaPlayerPrivateRemote_AddGenericCue:
    case MessageName::MediaPlayerPrivateRemote_AddRemoteAudioTrack:
    case MessageName::MediaPlayerPrivateRemote_AddRemoteTextTrack:
    case MessageName::MediaPlayerPrivateRemote_AddRemoteVideoTrack:
    case MessageName::MediaPlayerPrivateRemote_CharacteristicChanged:
    case MessageName::MediaPlayerPrivateRemote_CurrentPlaybackTargetIsWirelessChanged:
    case MessageName::MediaPlayerPrivateRemote_CurrentTimeChanged:
    case MessageName::MediaPlayerPrivateRemote_DurationChanged:
    case MessageName::MediaPlayerPrivateRemote_EngineFailedToLoad:
    case MessageName::MediaPlayerPrivateRemote_FirstVideoFrameAvailable:
    case MessageName::MediaPlayerPrivateRemote_GetRawCookies:
    case MessageName::MediaPlayerPrivateRemote_InitializationDataEncountered:
    case MessageName::MediaPlayerPrivateRemote_MediaPlayerKeyNeeded:
    case MessageName::MediaPlayerPrivateRemote_MuteChanged:
    case MessageName::MediaPlayerPrivateRemote_NetworkStateChanged:
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueData:
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueDataStruct:
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTFileHeader:
    case MessageName::MediaPlayerPrivateRemote_PlaybackStateChanged:
    case MessageName::MediaPlayerPrivateRemote_PushVideoFrameMetadata:
    case MessageName::MediaPlayerPrivateRemote_RateChanged:
    case MessageName::MediaPlayerPrivateRemote_ReadyStateChanged:
    case MessageName::MediaPlayerPrivateRemote_RemoteAudioTrackConfigurationChanged:
    case MessageName::MediaPlayerPrivateRemote_RemoteTextTrackConfigurationChanged:
    case MessageName::MediaPlayerPrivateRemote_RemoteVideoTrackConfigurationChanged:
    case MessageName::MediaPlayerPrivateRemote_RemoveDataCue:
    case MessageName::MediaPlayerPrivateRemote_RemoveGenericCue:
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteAudioTrack:
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteTextTrack:
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteVideoTrack:
    case MessageName::MediaPlayerPrivateRemote_RemoveResource:
    case MessageName::MediaPlayerPrivateRemote_RenderingModeChanged:
    case MessageName::MediaPlayerPrivateRemote_RequestResource:
    case MessageName::MediaPlayerPrivateRemote_ResourceNotSupported:
    case MessageName::MediaPlayerPrivateRemote_SendH2Ping:
    case MessageName::MediaPlayerPrivateRemote_SizeChanged:
    case MessageName::MediaPlayerPrivateRemote_TimeChanged:
    case MessageName::MediaPlayerPrivateRemote_UpdateCachedState:
    case MessageName::MediaPlayerPrivateRemote_UpdateDataCue:
    case MessageName::MediaPlayerPrivateRemote_UpdateGenericCue:
    case MessageName::MediaPlayerPrivateRemote_VolumeChanged:
    case MessageName::MediaPlayerPrivateRemote_WaitingForKeyChanged:
        return ReceiverName::MediaPlayerPrivateRemote;
    case MessageName::MediaSourcePrivateRemote_SeekToTime:
        return ReceiverName::MediaSourcePrivateRemote;
    case MessageName::NetworkBroadcastChannelRegistry_PostMessage:
    case MessageName::NetworkBroadcastChannelRegistry_RegisterChannel:
    case MessageName::NetworkBroadcastChannelRegistry_UnregisterChannel:
        return ReceiverName::NetworkBroadcastChannelRegistry;
    case MessageName::NetworkConnectionToWebProcess_AddOriginAccessAllowListEntry:
    case MessageName::NetworkConnectionToWebProcess_BrowsingContextRemoved:
    case MessageName::NetworkConnectionToWebProcess_CheckRemotePortForActivity:
    case MessageName::NetworkConnectionToWebProcess_ClearPageSpecificData:
    case MessageName::NetworkConnectionToWebProcess_CloseSWContextConnection:
    case MessageName::NetworkConnectionToWebProcess_CloseSharedWorkerContextConnection:
    case MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource:
    case MessageName::NetworkConnectionToWebProcess_ConvertMainResourceLoadToDownload:
    case MessageName::NetworkConnectionToWebProcess_CreateNewMessagePortChannel:
    case MessageName::NetworkConnectionToWebProcess_CreateRTCProvider:
    case MessageName::NetworkConnectionToWebProcess_CreateSocketChannel:
    case MessageName::NetworkConnectionToWebProcess_CreateSocketStream:
    case MessageName::NetworkConnectionToWebProcess_DeleteCookie:
    case MessageName::NetworkConnectionToWebProcess_DidDeliverMessagePortMessages:
    case MessageName::NetworkConnectionToWebProcess_EntangleLocalPortInThisProcessToRemote:
    case MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection:
    case MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection:
    case MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName:
    case MessageName::NetworkConnectionToWebProcess_HasStorageAccess:
    case MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished:
    case MessageName::NetworkConnectionToWebProcess_LoadPing:
    case MessageName::NetworkConnectionToWebProcess_LogUserInteraction:
    case MessageName::NetworkConnectionToWebProcess_MessagePortClosed:
    case MessageName::NetworkConnectionToWebProcess_MessagePortDisentangled:
    case MessageName::NetworkConnectionToWebProcess_PageLoadCompleted:
    case MessageName::NetworkConnectionToWebProcess_PostMessageToRemote:
    case MessageName::NetworkConnectionToWebProcess_PreconnectTo:
    case MessageName::NetworkConnectionToWebProcess_PrefetchDNS:
    case MessageName::NetworkConnectionToWebProcess_PrioritizeResourceLoads:
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURL:
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLForSlice:
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLFromURL:
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLHandle:
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLOptionallyFileBacked:
    case MessageName::NetworkConnectionToWebProcess_RegisterFileBlobURL:
    case MessageName::NetworkConnectionToWebProcess_RegisterURLSchemesAsCORSEnabled:
    case MessageName::NetworkConnectionToWebProcess_RemoveLoadIdentifier:
    case MessageName::NetworkConnectionToWebProcess_RemoveOriginAccessAllowListEntry:
    case MessageName::NetworkConnectionToWebProcess_RemoveStorageAccessForFrame:
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccess:
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccessUnderOpener:
    case MessageName::NetworkConnectionToWebProcess_ResetOriginAccessAllowLists:
    case MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated:
    case MessageName::NetworkConnectionToWebProcess_ScheduleResourceLoad:
    case MessageName::NetworkConnectionToWebProcess_SendH2Ping:
    case MessageName::NetworkConnectionToWebProcess_SetCORSDisablingPatterns:
    case MessageName::NetworkConnectionToWebProcess_SetCaptureExtraNetworkLoadMetricsEnabled:
    case MessageName::NetworkConnectionToWebProcess_SetCookiesFromDOM:
    case MessageName::NetworkConnectionToWebProcess_SetRawCookie:
    case MessageName::NetworkConnectionToWebProcess_SetResourceLoadSchedulingMode:
    case MessageName::NetworkConnectionToWebProcess_StartDownload:
    case MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort:
    case MessageName::NetworkConnectionToWebProcess_UnregisterBlobURL:
    case MessageName::NetworkConnectionToWebProcess_UnregisterBlobURLHandle:
    case MessageName::NetworkConnectionToWebProcess_UnsubscribeFromCookieChangeNotifications:
    case MessageName::NetworkConnectionToWebProcess_UpdateActivePages:
    case MessageName::NetworkConnectionToWebProcess_UpdateQuotaBasedOnSpaceUsageForTesting:
    case MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB:
        return ReceiverName::NetworkConnectionToWebProcess;
    case MessageName::NetworkContentRuleListManager_AddContentRuleLists:
    case MessageName::NetworkContentRuleListManager_Remove:
    case MessageName::NetworkContentRuleListManager_RemoveAllContentRuleLists:
    case MessageName::NetworkContentRuleListManager_RemoveContentRuleList:
        return ReceiverName::NetworkContentRuleListManager;
    case MessageName::NetworkMDNSRegister_RegisterMDNSName:
    case MessageName::NetworkMDNSRegister_UnregisterMDNSNames:
        return ReceiverName::NetworkMDNSRegister;
    case MessageName::NetworkProcessConnection_AllCookiesDeleted:
    case MessageName::NetworkProcessConnection_BroadcastConsoleMessage:
    case MessageName::NetworkProcessConnection_CheckProcessLocalPortForActivity:
    case MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource:
    case MessageName::NetworkProcessConnection_CookieAcceptPolicyChanged:
    case MessageName::NetworkProcessConnection_CookiesAdded:
    case MessageName::NetworkProcessConnection_CookiesDeleted:
    case MessageName::NetworkProcessConnection_DidCacheResource:
    case MessageName::NetworkProcessConnection_DidFinishPingLoad:
    case MessageName::NetworkProcessConnection_DidFinishPreconnection:
    case MessageName::NetworkProcessConnection_MessagesAvailableForPort:
    case MessageName::NetworkProcessConnection_SetOnLineState:
        return ReceiverName::NetworkProcessConnection;
    case MessageName::NetworkProcessProxy_ContentExtensionRules:
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains:
    case MessageName::NetworkProcessProxy_DidCommitCrossSiteLoadWithDataTransferFromPrevalentResource:
    case MessageName::NetworkProcessProxy_DidExceedMemoryLimit:
    case MessageName::NetworkProcessProxy_DidNegotiateModernTLS:
    case MessageName::NetworkProcessProxy_DidReceiveAuthenticationChallenge:
    case MessageName::NetworkProcessProxy_EndServiceWorkerBackgroundProcessing:
    case MessageName::NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcess:
    case MessageName::NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcess:
    case MessageName::NetworkProcessProxy_GetAppBoundDomains:
    case MessageName::NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentation:
    case MessageName::NetworkProcessProxy_IncreaseQuota:
    case MessageName::NetworkProcessProxy_LogDiagnosticMessage:
    case MessageName::NetworkProcessProxy_LogDiagnosticMessageWithResult:
    case MessageName::NetworkProcessProxy_LogDiagnosticMessageWithValue:
    case MessageName::NetworkProcessProxy_LogTestingEvent:
    case MessageName::NetworkProcessProxy_NegotiatedLegacyTLS:
    case MessageName::NetworkProcessProxy_NotifyResourceLoadStatisticsProcessed:
    case MessageName::NetworkProcessProxy_NotifyWebsiteDataDeletionForRegistrableDomainsFinished:
    case MessageName::NetworkProcessProxy_NotifyWebsiteDataScanForRegistrableDomainsFinished:
    case MessageName::NetworkProcessProxy_RegisterRemoteWorkerClientProcess:
    case MessageName::NetworkProcessProxy_ReloadAfterUnblockedContentFilter:
    case MessageName::NetworkProcessProxy_RemoteWorkerContextConnectionNoLongerNeeded:
    case MessageName::NetworkProcessProxy_RequestStorageAccessConfirm:
    case MessageName::NetworkProcessProxy_RequestStorageSpace:
    case MessageName::NetworkProcessProxy_ResourceLoadDidCompleteWithError:
    case MessageName::NetworkProcessProxy_ResourceLoadDidPerformHTTPRedirection:
    case MessageName::NetworkProcessProxy_ResourceLoadDidReceiveChallenge:
    case MessageName::NetworkProcessProxy_ResourceLoadDidReceiveResponse:
    case MessageName::NetworkProcessProxy_ResourceLoadDidSendRequest:
    case MessageName::NetworkProcessProxy_RetrieveCacheStorageParameters:
    case MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess:
    case MessageName::NetworkProcessProxy_SetDomainsWithUserInteraction:
    case MessageName::NetworkProcessProxy_SetWebProcessHasUploads:
    case MessageName::NetworkProcessProxy_StartServiceWorkerBackgroundProcessing:
    case MessageName::NetworkProcessProxy_TerminateUnresponsiveServiceWorkerProcesses:
    case MessageName::NetworkProcessProxy_TerminateWebProcess:
    case MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation:
    case MessageName::NetworkProcessProxy_UnregisterRemoteWorkerClientProcess:
        return ReceiverName::NetworkProcessProxy;
    case MessageName::NetworkProcess_AddWebPageNetworkParameters:
    case MessageName::NetworkProcess_AddWebsiteDataStore:
    case MessageName::NetworkProcess_AllowSpecificHTTPSCertificateForHost:
    case MessageName::NetworkProcess_AllowTLSCertificateChainForLocalPCMTesting:
    case MessageName::NetworkProcess_AppPrivacyReportTestingData:
    case MessageName::NetworkProcess_ApplicationDidEnterBackground:
    case MessageName::NetworkProcess_ApplicationWillEnterForeground:
    case MessageName::NetworkProcess_CancelDownload:
    case MessageName::NetworkProcess_ClearAppBoundSession:
    case MessageName::NetworkProcess_ClearAppPrivacyReportTestingData:
    case MessageName::NetworkProcess_ClearBundleIdentifier:
    case MessageName::NetworkProcess_ClearCachedCredentials:
    case MessageName::NetworkProcess_ClearPrevalentResource:
    case MessageName::NetworkProcess_ClearPrivateClickMeasurement:
    case MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride:
    case MessageName::NetworkProcess_ClearStorage:
    case MessageName::NetworkProcess_ClearUserInteraction:
    case MessageName::NetworkProcess_CloseITPDatabase:
    case MessageName::NetworkProcess_ClosePCMDatabase:
    case MessageName::NetworkProcess_ContinueWillSendRequest:
    case MessageName::NetworkProcess_CountNonDefaultSessionSets:
    case MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess:
    case MessageName::NetworkProcess_DeleteCookiesForTesting:
    case MessageName::NetworkProcess_DeletePushAndNotificationRegistration:
    case MessageName::NetworkProcess_DeleteWebsiteData:
    case MessageName::NetworkProcess_DeleteWebsiteDataForOrigins:
    case MessageName::NetworkProcess_DestroySession:
    case MessageName::NetworkProcess_DidCommitCrossSiteLoadWithDataTransfer:
    case MessageName::NetworkProcess_DidIncreaseQuota:
    case MessageName::NetworkProcess_DisableServiceWorkerEntitlement:
    case MessageName::NetworkProcess_DomainIDExistsInDatabase:
    case MessageName::NetworkProcess_DownloadRequest:
    case MessageName::NetworkProcess_DumpPrivateClickMeasurement:
    case MessageName::NetworkProcess_DumpResourceLoadStatistics:
    case MessageName::NetworkProcess_FetchWebsiteData:
    case MessageName::NetworkProcess_FlushCookies:
    case MessageName::NetworkProcess_GetAllStorageAccessEntries:
    case MessageName::NetworkProcess_GetOriginsWithPushAndNotificationPermissions:
    case MessageName::NetworkProcess_GetPendingPushMessages:
    case MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary:
    case MessageName::NetworkProcess_HadUserInteraction:
    case MessageName::NetworkProcess_HasAppBoundSession:
    case MessageName::NetworkProcess_HasIsolatedSession:
    case MessageName::NetworkProcess_HasLocalStorage:
    case MessageName::NetworkProcess_InitializeNetworkProcess:
    case MessageName::NetworkProcess_InsertExpiredStatisticForTesting:
    case MessageName::NetworkProcess_IsGrandfathered:
    case MessageName::NetworkProcess_IsPrevalentResource:
    case MessageName::NetworkProcess_IsRegisteredAsRedirectingTo:
    case MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder:
    case MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder:
    case MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce:
    case MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral:
    case MessageName::NetworkProcess_IsVeryPrevalentResource:
    case MessageName::NetworkProcess_LogFrameNavigation:
    case MessageName::NetworkProcess_LogUserInteraction:
    case MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting:
    case MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting:
    case MessageName::NetworkProcess_MergeStatisticForTesting:
    case MessageName::NetworkProcess_NotifyPreferencesChanged:
    case MessageName::NetworkProcess_PreconnectTo:
    case MessageName::NetworkProcess_PrefetchDNS:
    case MessageName::NetworkProcess_PrepareToSuspend:
    case MessageName::NetworkProcess_ProcessDidResume:
    case MessageName::NetworkProcess_ProcessPushMessage:
    case MessageName::NetworkProcess_PublishDownloadProgress:
    case MessageName::NetworkProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy:
    case MessageName::NetworkProcess_RegisterURLSchemeAsLocal:
    case MessageName::NetworkProcess_RegisterURLSchemeAsNoAccess:
    case MessageName::NetworkProcess_RegisterURLSchemeAsSecure:
    case MessageName::NetworkProcess_RemoveWebPageNetworkParameters:
    case MessageName::NetworkProcess_RenameOriginInWebsiteData:
    case MessageName::NetworkProcess_RequestResource:
    case MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources:
    case MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting:
    case MessageName::NetworkProcess_ResetParametersToDefaultValues:
    case MessageName::NetworkProcess_ResetQuota:
    case MessageName::NetworkProcess_ResumeDownload:
    case MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent:
    case MessageName::NetworkProcess_ScheduleCookieBlockingUpdate:
    case MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing:
    case MessageName::NetworkProcess_SetAgeCapForClientSideCookies:
    case MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics:
    case MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources:
    case MessageName::NetworkProcess_SetCacheModel:
    case MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting:
    case MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting:
    case MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting:
    case MessageName::NetworkProcess_SetGrandfathered:
    case MessageName::NetworkProcess_SetGrandfatheringTime:
    case MessageName::NetworkProcess_SetIgnoreTLSErrors:
    case MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest:
    case MessageName::NetworkProcess_SetLastSeen:
    case MessageName::NetworkProcess_SetMaxStatisticsEntries:
    case MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval:
    case MessageName::NetworkProcess_SetNetworkProxySettings:
    case MessageName::NetworkProcess_SetNotifyPagesWhenDataRecordsWereScanned:
    case MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting:
    case MessageName::NetworkProcess_SetPersistentCredentialStorageEnabled:
    case MessageName::NetworkProcess_SetPrevalentResource:
    case MessageName::NetworkProcess_SetPrevalentResourceForDebugMode:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementDebugMode:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting:
    case MessageName::NetworkProcess_SetPruneEntriesDownTo:
    case MessageName::NetworkProcess_SetQOS:
    case MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode:
    case MessageName::NetworkProcess_SetResourceLoadStatisticsEnabled:
    case MessageName::NetworkProcess_SetResourceLoadStatisticsLogTestingEvent:
    case MessageName::NetworkProcess_SetSessionIsControlledByAutomation:
    case MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval:
    case MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting:
    case MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting:
    case MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain:
    case MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain:
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom:
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo:
    case MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting:
    case MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode:
    case MessageName::NetworkProcess_SetTimeToLiveUserInteraction:
    case MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting:
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom:
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo:
    case MessageName::NetworkProcess_SetVeryPrevalentResource:
    case MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart:
    case MessageName::NetworkProcess_StatisticsDatabaseHasAllTables:
    case MessageName::NetworkProcess_StorePrivateClickMeasurement:
    case MessageName::NetworkProcess_SyncLocalStorage:
    case MessageName::NetworkProcess_UpdateBundleIdentifier:
    case MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor:
    case MessageName::NetworkProcess_UserPreferredLanguagesChanged:
        return ReceiverName::NetworkProcess;
    case MessageName::NetworkRTCMonitor_StartUpdatingIfNeeded:
    case MessageName::NetworkRTCMonitor_StopUpdating:
        return ReceiverName::NetworkRTCMonitor;
    case MessageName::NetworkRTCProvider_CloseSocket:
    case MessageName::NetworkRTCProvider_CreateClientTCPSocket:
    case MessageName::NetworkRTCProvider_CreateResolver:
    case MessageName::NetworkRTCProvider_CreateServerTCPSocket:
    case MessageName::NetworkRTCProvider_CreateUDPSocket:
    case MessageName::NetworkRTCProvider_SendToSocket:
    case MessageName::NetworkRTCProvider_SetPlatformTCPSocketsEnabled:
    case MessageName::NetworkRTCProvider_SetPlatformUDPSocketsEnabled:
    case MessageName::NetworkRTCProvider_SetSocketOption:
    case MessageName::NetworkRTCProvider_StopResolver:
    case MessageName::NetworkRTCProvider_WrapNewTCPConnection:
        return ReceiverName::NetworkRTCProvider;
    case MessageName::NetworkResourceLoader_ContinueDidReceiveResponse:
    case MessageName::NetworkResourceLoader_ContinueWillSendRequest:
        return ReceiverName::NetworkResourceLoader;
    case MessageName::NetworkSocketChannel_Close:
    case MessageName::NetworkSocketChannel_SendData:
    case MessageName::NetworkSocketChannel_SendString:
        return ReceiverName::NetworkSocketChannel;
    case MessageName::NetworkSocketStream_Close:
    case MessageName::NetworkSocketStream_SendData:
    case MessageName::NetworkSocketStream_SendHandshake:
        return ReceiverName::NetworkSocketStream;
    case MessageName::NetworkStorageManager_AbortOpenAndUpgradeNeeded:
    case MessageName::NetworkStorageManager_AbortTransaction:
    case MessageName::NetworkStorageManager_Clear:
    case MessageName::NetworkStorageManager_ClearObjectStore:
    case MessageName::NetworkStorageManager_CloneSessionStorageNamespace:
    case MessageName::NetworkStorageManager_CloseHandle:
    case MessageName::NetworkStorageManager_CloseSyncAccessHandle:
    case MessageName::NetworkStorageManager_CommitTransaction:
    case MessageName::NetworkStorageManager_ConnectToStorageArea:
    case MessageName::NetworkStorageManager_CreateIndex:
    case MessageName::NetworkStorageManager_CreateObjectStore:
    case MessageName::NetworkStorageManager_CreateSyncAccessHandle:
    case MessageName::NetworkStorageManager_DatabaseConnectionClosed:
    case MessageName::NetworkStorageManager_DatabaseConnectionPendingClose:
    case MessageName::NetworkStorageManager_DeleteDatabase:
    case MessageName::NetworkStorageManager_DeleteIndex:
    case MessageName::NetworkStorageManager_DeleteObjectStore:
    case MessageName::NetworkStorageManager_DeleteRecord:
    case MessageName::NetworkStorageManager_DidFinishHandlingVersionChangeTransaction:
    case MessageName::NetworkStorageManager_DidFireVersionChangeEvent:
    case MessageName::NetworkStorageManager_DisconnectFromStorageArea:
    case MessageName::NetworkStorageManager_EstablishTransaction:
    case MessageName::NetworkStorageManager_FileSystemGetDirectory:
    case MessageName::NetworkStorageManager_GetAllDatabaseNamesAndVersions:
    case MessageName::NetworkStorageManager_GetAllRecords:
    case MessageName::NetworkStorageManager_GetCount:
    case MessageName::NetworkStorageManager_GetDirectoryHandle:
    case MessageName::NetworkStorageManager_GetFile:
    case MessageName::NetworkStorageManager_GetFileHandle:
    case MessageName::NetworkStorageManager_GetHandle:
    case MessageName::NetworkStorageManager_GetHandleNames:
    case MessageName::NetworkStorageManager_GetRecord:
    case MessageName::NetworkStorageManager_IsSameEntry:
    case MessageName::NetworkStorageManager_IterateCursor:
    case MessageName::NetworkStorageManager_Move:
    case MessageName::NetworkStorageManager_OpenCursor:
    case MessageName::NetworkStorageManager_OpenDBRequestCancelled:
    case MessageName::NetworkStorageManager_OpenDatabase:
    case MessageName::NetworkStorageManager_Persist:
    case MessageName::NetworkStorageManager_Persisted:
    case MessageName::NetworkStorageManager_PutOrAdd:
    case MessageName::NetworkStorageManager_RemoveEntry:
    case MessageName::NetworkStorageManager_RemoveItem:
    case MessageName::NetworkStorageManager_RenameIndex:
    case MessageName::NetworkStorageManager_RenameObjectStore:
    case MessageName::NetworkStorageManager_Resolve:
    case MessageName::NetworkStorageManager_SetItem:
        return ReceiverName::NetworkStorageManager;
    case MessageName::NotificationManagerMessageHandler_CancelNotification:
    case MessageName::NotificationManagerMessageHandler_ClearNotifications:
    case MessageName::NotificationManagerMessageHandler_DidDestroyNotification:
    case MessageName::NotificationManagerMessageHandler_RequestSystemNotificationPermission:
    case MessageName::NotificationManagerMessageHandler_ShowNotification:
        return ReceiverName::NotificationManagerMessageHandler;
    case MessageName::PlatformXRSystemProxy_SessionDidEnd:
    case MessageName::PlatformXRSystemProxy_SessionDidUpdateVisibilityState:
        return ReceiverName::PlatformXRSystemProxy;
    case MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices:
    case MessageName::PlatformXRSystem_InitializeTrackingAndRendering:
    case MessageName::PlatformXRSystem_RequestFrame:
    case MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures:
    case MessageName::PlatformXRSystem_ShutDownTrackingAndRendering:
    case MessageName::PlatformXRSystem_SubmitFrame:
        return ReceiverName::PlatformXRSystem;
    case MessageName::RTCDataChannelRemoteManagerProxy_BufferedAmountIsDecreasing:
    case MessageName::RTCDataChannelRemoteManagerProxy_ChangeReadyState:
    case MessageName::RTCDataChannelRemoteManagerProxy_Close:
    case MessageName::RTCDataChannelRemoteManagerProxy_DetectError:
    case MessageName::RTCDataChannelRemoteManagerProxy_ReceiveData:
    case MessageName::RTCDataChannelRemoteManagerProxy_SendData:
        return ReceiverName::RTCDataChannelRemoteManagerProxy;
    case MessageName::RTCDataChannelRemoteManager_BufferedAmountIsDecreasing:
    case MessageName::RTCDataChannelRemoteManager_ChangeReadyState:
    case MessageName::RTCDataChannelRemoteManager_Close:
    case MessageName::RTCDataChannelRemoteManager_DetectError:
    case MessageName::RTCDataChannelRemoteManager_ReceiveData:
    case MessageName::RTCDataChannelRemoteManager_SendData:
        return ReceiverName::RTCDataChannelRemoteManager;
    case MessageName::RemoteAudioDestinationManager_AudioSamplesStorageChanged:
    case MessageName::RemoteAudioDestinationManager_DeleteAudioDestination:
    case MessageName::RemoteAudioDestinationManager_StartAudioDestination:
    case MessageName::RemoteAudioDestinationManager_StopAudioDestination:
        return ReceiverName::RemoteAudioDestinationManager;
    case MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeActive:
    case MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeInactive:
    case MessageName::RemoteAudioHardwareListener_AudioOutputDeviceChanged:
        return ReceiverName::RemoteAudioHardwareListener;
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit:
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_DeleteUnit:
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_SetAudioOutputDevice:
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StartUnit:
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StopUnit:
        return ReceiverName::RemoteAudioMediaStreamTrackRendererInternalUnitManager;
    case MessageName::RemoteAudioSessionProxy_SetCategory:
    case MessageName::RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride:
    case MessageName::RemoteAudioSessionProxy_SetPreferredBufferSize:
        return ReceiverName::RemoteAudioSessionProxy;
    case MessageName::RemoteAudioSession_BeginInterruption:
    case MessageName::RemoteAudioSession_ConfigurationChanged:
    case MessageName::RemoteAudioSession_EndInterruption:
        return ReceiverName::RemoteAudioSession;
    case MessageName::RemoteAudioSourceProviderManager_AudioSamplesAvailable:
    case MessageName::RemoteAudioSourceProviderManager_AudioStorageChanged:
        return ReceiverName::RemoteAudioSourceProviderManager;
    case MessageName::RemoteBindGroupLayout_SetLabel:
        return ReceiverName::RemoteBindGroupLayout;
    case MessageName::RemoteBindGroup_SetLabel:
        return ReceiverName::RemoteBindGroup;
    case MessageName::RemoteBuffer_Destroy:
    case MessageName::RemoteBuffer_SetLabel:
    case MessageName::RemoteBuffer_Unmap:
        return ReceiverName::RemoteBuffer;
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration:
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificate:
    case MessageName::RemoteCDMInstanceProxy_SetStorageDirectory:
        return ReceiverName::RemoteCDMInstanceProxy;
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSession:
    case MessageName::RemoteCDMInstanceSessionProxy_DisplayIDChanged:
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSession:
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData:
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicense:
    case MessageName::RemoteCDMInstanceSessionProxy_StoreRecordOfKeyUsage:
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense:
        return ReceiverName::RemoteCDMInstanceSessionProxy;
    case MessageName::RemoteCDMInstanceSession_SendMessage:
    case MessageName::RemoteCDMInstanceSession_SessionIdChanged:
    case MessageName::RemoteCDMInstanceSession_UpdateKeyStatuses:
        return ReceiverName::RemoteCDMInstanceSession;
    case MessageName::RemoteCDMInstance_UnrequestedInitializationDataReceived:
        return ReceiverName::RemoteCDMInstance;
    case MessageName::RemoteCDMProxy_GetSupportedConfiguration:
    case MessageName::RemoteCDMProxy_LoadAndInitialize:
        return ReceiverName::RemoteCDMProxy;
    case MessageName::RemoteCommandBuffer_SetLabel:
        return ReceiverName::RemoteCommandBuffer;
    case MessageName::RemoteCommandEncoder_BeginComputePass:
    case MessageName::RemoteCommandEncoder_BeginRenderPass:
    case MessageName::RemoteCommandEncoder_ClearBuffer:
    case MessageName::RemoteCommandEncoder_CopyBufferToBuffer:
    case MessageName::RemoteCommandEncoder_CopyBufferToTexture:
    case MessageName::RemoteCommandEncoder_CopyTextureToBuffer:
    case MessageName::RemoteCommandEncoder_CopyTextureToTexture:
    case MessageName::RemoteCommandEncoder_Finish:
    case MessageName::RemoteCommandEncoder_InsertDebugMarker:
    case MessageName::RemoteCommandEncoder_PopDebugGroup:
    case MessageName::RemoteCommandEncoder_PushDebugGroup:
    case MessageName::RemoteCommandEncoder_ResolveQuerySet:
    case MessageName::RemoteCommandEncoder_SetLabel:
    case MessageName::RemoteCommandEncoder_WriteTimestamp:
        return ReceiverName::RemoteCommandEncoder;
    case MessageName::RemoteComputePassEncoder_Dispatch:
    case MessageName::RemoteComputePassEncoder_DispatchIndirect:
    case MessageName::RemoteComputePassEncoder_End:
    case MessageName::RemoteComputePassEncoder_InsertDebugMarker:
    case MessageName::RemoteComputePassEncoder_PopDebugGroup:
    case MessageName::RemoteComputePassEncoder_PushDebugGroup:
    case MessageName::RemoteComputePassEncoder_SetBindGroup:
    case MessageName::RemoteComputePassEncoder_SetLabel:
    case MessageName::RemoteComputePassEncoder_SetPipeline:
        return ReceiverName::RemoteComputePassEncoder;
    case MessageName::RemoteComputePipeline_GetBindGroupLayout:
    case MessageName::RemoteComputePipeline_SetLabel:
        return ReceiverName::RemoteComputePipeline;
    case MessageName::RemoteDevice_CreateBindGroup:
    case MessageName::RemoteDevice_CreateBindGroupLayout:
    case MessageName::RemoteDevice_CreateBuffer:
    case MessageName::RemoteDevice_CreateCommandEncoder:
    case MessageName::RemoteDevice_CreateComputePipeline:
    case MessageName::RemoteDevice_CreatePipelineLayout:
    case MessageName::RemoteDevice_CreateQuerySet:
    case MessageName::RemoteDevice_CreateRenderBundleEncoder:
    case MessageName::RemoteDevice_CreateRenderPipeline:
    case MessageName::RemoteDevice_CreateSampler:
    case MessageName::RemoteDevice_CreateShaderModule:
    case MessageName::RemoteDevice_CreateTexture:
    case MessageName::RemoteDevice_Destroy:
    case MessageName::RemoteDevice_ImportExternalTexture:
    case MessageName::RemoteDevice_PushErrorScope:
    case MessageName::RemoteDevice_SetLabel:
        return ReceiverName::RemoteDevice;
    case MessageName::RemoteDisplayListRecorder_ApplyDeviceScaleFactor:
    case MessageName::RemoteDisplayListRecorder_ApplyFillPattern:
    case MessageName::RemoteDisplayListRecorder_ApplyStrokePattern:
    case MessageName::RemoteDisplayListRecorder_BeginTransparencyLayer:
    case MessageName::RemoteDisplayListRecorder_ClearRect:
    case MessageName::RemoteDisplayListRecorder_ClearShadow:
    case MessageName::RemoteDisplayListRecorder_Clip:
    case MessageName::RemoteDisplayListRecorder_ClipOut:
    case MessageName::RemoteDisplayListRecorder_ClipOutToPath:
    case MessageName::RemoteDisplayListRecorder_ClipPath:
    case MessageName::RemoteDisplayListRecorder_ClipToImageBuffer:
    case MessageName::RemoteDisplayListRecorder_ConcatenateCTM:
    case MessageName::RemoteDisplayListRecorder_ConvertToLuminanceMask:
    case MessageName::RemoteDisplayListRecorder_DrawDotsForDocumentMarker:
    case MessageName::RemoteDisplayListRecorder_DrawEllipse:
    case MessageName::RemoteDisplayListRecorder_DrawFilteredImageBuffer:
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingPath:
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingRects:
    case MessageName::RemoteDisplayListRecorder_DrawGlyphs:
    case MessageName::RemoteDisplayListRecorder_DrawImageBuffer:
    case MessageName::RemoteDisplayListRecorder_DrawLine:
    case MessageName::RemoteDisplayListRecorder_DrawLinesForText:
    case MessageName::RemoteDisplayListRecorder_DrawNativeImage:
    case MessageName::RemoteDisplayListRecorder_DrawPath:
    case MessageName::RemoteDisplayListRecorder_DrawPattern:
    case MessageName::RemoteDisplayListRecorder_DrawRect:
    case MessageName::RemoteDisplayListRecorder_EndTransparencyLayer:
    case MessageName::RemoteDisplayListRecorder_FillArc:
    case MessageName::RemoteDisplayListRecorder_FillBezierCurve:
    case MessageName::RemoteDisplayListRecorder_FillCompositedRect:
    case MessageName::RemoteDisplayListRecorder_FillEllipse:
    case MessageName::RemoteDisplayListRecorder_FillLine:
    case MessageName::RemoteDisplayListRecorder_FillPath:
    case MessageName::RemoteDisplayListRecorder_FillQuadCurve:
    case MessageName::RemoteDisplayListRecorder_FillRect:
    case MessageName::RemoteDisplayListRecorder_FillRectWithColor:
    case MessageName::RemoteDisplayListRecorder_FillRectWithGradient:
    case MessageName::RemoteDisplayListRecorder_FillRectWithRoundedHole:
    case MessageName::RemoteDisplayListRecorder_FillRoundedRect:
    case MessageName::RemoteDisplayListRecorder_FlushContext:
    case MessageName::RemoteDisplayListRecorder_PaintFrameForMedia:
    case MessageName::RemoteDisplayListRecorder_Restore:
    case MessageName::RemoteDisplayListRecorder_Rotate:
    case MessageName::RemoteDisplayListRecorder_Save:
    case MessageName::RemoteDisplayListRecorder_Scale:
    case MessageName::RemoteDisplayListRecorder_SetCTM:
    case MessageName::RemoteDisplayListRecorder_SetInlineFillColor:
    case MessageName::RemoteDisplayListRecorder_SetInlineStrokeColor:
    case MessageName::RemoteDisplayListRecorder_SetLineCap:
    case MessageName::RemoteDisplayListRecorder_SetLineDash:
    case MessageName::RemoteDisplayListRecorder_SetLineJoin:
    case MessageName::RemoteDisplayListRecorder_SetMiterLimit:
    case MessageName::RemoteDisplayListRecorder_SetState:
    case MessageName::RemoteDisplayListRecorder_SetStrokeThickness:
    case MessageName::RemoteDisplayListRecorder_StrokeArc:
    case MessageName::RemoteDisplayListRecorder_StrokeBezierCurve:
    case MessageName::RemoteDisplayListRecorder_StrokeEllipse:
    case MessageName::RemoteDisplayListRecorder_StrokeLine:
    case MessageName::RemoteDisplayListRecorder_StrokePath:
    case MessageName::RemoteDisplayListRecorder_StrokeQuadCurve:
    case MessageName::RemoteDisplayListRecorder_StrokeRect:
    case MessageName::RemoteDisplayListRecorder_TransformToColorSpace:
    case MessageName::RemoteDisplayListRecorder_Translate:
        return ReceiverName::RemoteDisplayListRecorder;
    case MessageName::RemoteExternalTexture_SetLabel:
        return ReceiverName::RemoteExternalTexture;
    case MessageName::RemoteGPUProxy_WasCreated:
        return ReceiverName::RemoteGPUProxy;
    case MessageName::RemoteGraphicsContextGLProxy_WasChanged:
    case MessageName::RemoteGraphicsContextGLProxy_WasCreated:
    case MessageName::RemoteGraphicsContextGLProxy_WasLost:
        return ReceiverName::RemoteGraphicsContextGLProxy;
    case MessageName::RemoteGraphicsContextGL_ActiveTexture:
    case MessageName::RemoteGraphicsContextGL_AttachShader:
    case MessageName::RemoteGraphicsContextGL_BeginQuery:
    case MessageName::RemoteGraphicsContextGL_BeginTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_BindAttribLocation:
    case MessageName::RemoteGraphicsContextGL_BindBuffer:
    case MessageName::RemoteGraphicsContextGL_BindBufferBase:
    case MessageName::RemoteGraphicsContextGL_BindBufferRange:
    case MessageName::RemoteGraphicsContextGL_BindFramebuffer:
    case MessageName::RemoteGraphicsContextGL_BindRenderbuffer:
    case MessageName::RemoteGraphicsContextGL_BindSampler:
    case MessageName::RemoteGraphicsContextGL_BindTexture:
    case MessageName::RemoteGraphicsContextGL_BindTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_BindVertexArray:
    case MessageName::RemoteGraphicsContextGL_BlendColor:
    case MessageName::RemoteGraphicsContextGL_BlendEquation:
    case MessageName::RemoteGraphicsContextGL_BlendEquationSeparate:
    case MessageName::RemoteGraphicsContextGL_BlendFunc:
    case MessageName::RemoteGraphicsContextGL_BlendFuncSeparate:
    case MessageName::RemoteGraphicsContextGL_BlitFramebuffer:
    case MessageName::RemoteGraphicsContextGL_BufferData0:
    case MessageName::RemoteGraphicsContextGL_BufferData1:
    case MessageName::RemoteGraphicsContextGL_BufferSubData:
    case MessageName::RemoteGraphicsContextGL_Clear:
    case MessageName::RemoteGraphicsContextGL_ClearBufferfi:
    case MessageName::RemoteGraphicsContextGL_ClearBufferfv:
    case MessageName::RemoteGraphicsContextGL_ClearBufferiv:
    case MessageName::RemoteGraphicsContextGL_ClearBufferuiv:
    case MessageName::RemoteGraphicsContextGL_ClearColor:
    case MessageName::RemoteGraphicsContextGL_ClearDepth:
    case MessageName::RemoteGraphicsContextGL_ClearStencil:
    case MessageName::RemoteGraphicsContextGL_ColorMask:
    case MessageName::RemoteGraphicsContextGL_CompileShader:
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D0:
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D1:
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D0:
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D1:
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D0:
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D1:
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D0:
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D1:
    case MessageName::RemoteGraphicsContextGL_CopyBufferSubData:
    case MessageName::RemoteGraphicsContextGL_CopyTexImage2D:
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage2D:
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage3D:
    case MessageName::RemoteGraphicsContextGL_CullFace:
    case MessageName::RemoteGraphicsContextGL_DeleteBuffer:
    case MessageName::RemoteGraphicsContextGL_DeleteFramebuffer:
    case MessageName::RemoteGraphicsContextGL_DeleteProgram:
    case MessageName::RemoteGraphicsContextGL_DeleteQuery:
    case MessageName::RemoteGraphicsContextGL_DeleteRenderbuffer:
    case MessageName::RemoteGraphicsContextGL_DeleteSampler:
    case MessageName::RemoteGraphicsContextGL_DeleteShader:
    case MessageName::RemoteGraphicsContextGL_DeleteSync:
    case MessageName::RemoteGraphicsContextGL_DeleteTexture:
    case MessageName::RemoteGraphicsContextGL_DeleteTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_DeleteVertexArray:
    case MessageName::RemoteGraphicsContextGL_DepthFunc:
    case MessageName::RemoteGraphicsContextGL_DepthMask:
    case MessageName::RemoteGraphicsContextGL_DepthRange:
    case MessageName::RemoteGraphicsContextGL_DetachShader:
    case MessageName::RemoteGraphicsContextGL_Disable:
    case MessageName::RemoteGraphicsContextGL_DisableVertexAttribArray:
    case MessageName::RemoteGraphicsContextGL_DrawArrays:
    case MessageName::RemoteGraphicsContextGL_DrawArraysInstanced:
    case MessageName::RemoteGraphicsContextGL_DrawBuffers:
    case MessageName::RemoteGraphicsContextGL_DrawBuffersEXT:
    case MessageName::RemoteGraphicsContextGL_DrawElements:
    case MessageName::RemoteGraphicsContextGL_DrawElementsInstanced:
    case MessageName::RemoteGraphicsContextGL_DrawRangeElements:
    case MessageName::RemoteGraphicsContextGL_Enable:
    case MessageName::RemoteGraphicsContextGL_EnableVertexAttribArray:
    case MessageName::RemoteGraphicsContextGL_EndQuery:
    case MessageName::RemoteGraphicsContextGL_EndTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_EnsureExtensionEnabled:
    case MessageName::RemoteGraphicsContextGL_Finish:
    case MessageName::RemoteGraphicsContextGL_Flush:
    case MessageName::RemoteGraphicsContextGL_FramebufferRenderbuffer:
    case MessageName::RemoteGraphicsContextGL_FramebufferTexture2D:
    case MessageName::RemoteGraphicsContextGL_FramebufferTextureLayer:
    case MessageName::RemoteGraphicsContextGL_FrontFace:
    case MessageName::RemoteGraphicsContextGL_GenerateMipmap:
    case MessageName::RemoteGraphicsContextGL_Hint:
    case MessageName::RemoteGraphicsContextGL_InvalidateFramebuffer:
    case MessageName::RemoteGraphicsContextGL_InvalidateSubFramebuffer:
    case MessageName::RemoteGraphicsContextGL_LineWidth:
    case MessageName::RemoteGraphicsContextGL_LinkProgram:
    case MessageName::RemoteGraphicsContextGL_MarkContextChanged:
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysANGLE:
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE:
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsANGLE:
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE:
    case MessageName::RemoteGraphicsContextGL_PauseTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_PixelStorei:
    case MessageName::RemoteGraphicsContextGL_PolygonOffset:
    case MessageName::RemoteGraphicsContextGL_ReadBuffer:
    case MessageName::RemoteGraphicsContextGL_ReadnPixels1:
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorage:
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisample:
    case MessageName::RemoteGraphicsContextGL_Reshape:
    case MessageName::RemoteGraphicsContextGL_ResumeTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_SampleCoverage:
    case MessageName::RemoteGraphicsContextGL_SamplerParameterf:
    case MessageName::RemoteGraphicsContextGL_SamplerParameteri:
    case MessageName::RemoteGraphicsContextGL_Scissor:
    case MessageName::RemoteGraphicsContextGL_ShaderSource:
    case MessageName::RemoteGraphicsContextGL_SimulateEventForTesting:
    case MessageName::RemoteGraphicsContextGL_StencilFunc:
    case MessageName::RemoteGraphicsContextGL_StencilFuncSeparate:
    case MessageName::RemoteGraphicsContextGL_StencilMask:
    case MessageName::RemoteGraphicsContextGL_StencilMaskSeparate:
    case MessageName::RemoteGraphicsContextGL_StencilOp:
    case MessageName::RemoteGraphicsContextGL_StencilOpSeparate:
    case MessageName::RemoteGraphicsContextGL_SynthesizeGLError:
    case MessageName::RemoteGraphicsContextGL_TexImage2D0:
    case MessageName::RemoteGraphicsContextGL_TexImage2D1:
    case MessageName::RemoteGraphicsContextGL_TexImage3D0:
    case MessageName::RemoteGraphicsContextGL_TexImage3D1:
    case MessageName::RemoteGraphicsContextGL_TexParameterf:
    case MessageName::RemoteGraphicsContextGL_TexParameteri:
    case MessageName::RemoteGraphicsContextGL_TexStorage2D:
    case MessageName::RemoteGraphicsContextGL_TexStorage3D:
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D0:
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D1:
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D0:
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D1:
    case MessageName::RemoteGraphicsContextGL_TransformFeedbackVaryings:
    case MessageName::RemoteGraphicsContextGL_Uniform1f:
    case MessageName::RemoteGraphicsContextGL_Uniform1fv:
    case MessageName::RemoteGraphicsContextGL_Uniform1i:
    case MessageName::RemoteGraphicsContextGL_Uniform1iv:
    case MessageName::RemoteGraphicsContextGL_Uniform1ui:
    case MessageName::RemoteGraphicsContextGL_Uniform1uiv:
    case MessageName::RemoteGraphicsContextGL_Uniform2f:
    case MessageName::RemoteGraphicsContextGL_Uniform2fv:
    case MessageName::RemoteGraphicsContextGL_Uniform2i:
    case MessageName::RemoteGraphicsContextGL_Uniform2iv:
    case MessageName::RemoteGraphicsContextGL_Uniform2ui:
    case MessageName::RemoteGraphicsContextGL_Uniform2uiv:
    case MessageName::RemoteGraphicsContextGL_Uniform3f:
    case MessageName::RemoteGraphicsContextGL_Uniform3fv:
    case MessageName::RemoteGraphicsContextGL_Uniform3i:
    case MessageName::RemoteGraphicsContextGL_Uniform3iv:
    case MessageName::RemoteGraphicsContextGL_Uniform3ui:
    case MessageName::RemoteGraphicsContextGL_Uniform3uiv:
    case MessageName::RemoteGraphicsContextGL_Uniform4f:
    case MessageName::RemoteGraphicsContextGL_Uniform4fv:
    case MessageName::RemoteGraphicsContextGL_Uniform4i:
    case MessageName::RemoteGraphicsContextGL_Uniform4iv:
    case MessageName::RemoteGraphicsContextGL_Uniform4ui:
    case MessageName::RemoteGraphicsContextGL_Uniform4uiv:
    case MessageName::RemoteGraphicsContextGL_UniformBlockBinding:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x3fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x4fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x2fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x4fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x2fv:
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x3fv:
    case MessageName::RemoteGraphicsContextGL_UseProgram:
    case MessageName::RemoteGraphicsContextGL_ValidateProgram:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1f:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1fv:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2f:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2fv:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3f:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3fv:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4f:
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4fv:
    case MessageName::RemoteGraphicsContextGL_VertexAttribDivisor:
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4i:
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4iv:
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4ui:
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4uiv:
    case MessageName::RemoteGraphicsContextGL_VertexAttribIPointer:
    case MessageName::RemoteGraphicsContextGL_VertexAttribPointer:
    case MessageName::RemoteGraphicsContextGL_Viewport:
    case MessageName::RemoteGraphicsContextGL_WaitSync:
        return ReceiverName::RemoteGraphicsContextGL;
    case MessageName::RemoteLegacyCDMProxy_SetPlayerId:
        return ReceiverName::RemoteLegacyCDMProxy;
    case MessageName::RemoteLegacyCDMSessionProxy_ReleaseKeys:
        return ReceiverName::RemoteLegacyCDMSessionProxy;
    case MessageName::RemoteLegacyCDMSession_SendError:
    case MessageName::RemoteLegacyCDMSession_SendMessage:
        return ReceiverName::RemoteLegacyCDMSession;
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration:
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration:
        return ReceiverName::RemoteMediaEngineConfigurationFactoryProxy;
    case MessageName::RemoteMediaPlayerManagerProxy_ClearMediaCache:
    case MessageName::RemoteMediaPlayerManagerProxy_ClearMediaCacheForOrigins:
    case MessageName::RemoteMediaPlayerManagerProxy_CreateMediaPlayer:
    case MessageName::RemoteMediaPlayerManagerProxy_DeleteMediaPlayer:
        return ReceiverName::RemoteMediaPlayerManagerProxy;
    case MessageName::RemoteMediaPlayerProxy_AcceleratedRenderingStateChanged:
    case MessageName::RemoteMediaPlayerProxy_ApplicationDidBecomeActive:
    case MessageName::RemoteMediaPlayerProxy_ApplicationWillResignActive:
    case MessageName::RemoteMediaPlayerProxy_AttemptToDecryptWithInstance:
    case MessageName::RemoteMediaPlayerProxy_AudioTrackSetEnabled:
    case MessageName::RemoteMediaPlayerProxy_BeginSimulatedHDCPError:
    case MessageName::RemoteMediaPlayerProxy_CancelLoad:
    case MessageName::RemoteMediaPlayerProxy_CdmInstanceAttached:
    case MessageName::RemoteMediaPlayerProxy_CdmInstanceDetached:
    case MessageName::RemoteMediaPlayerProxy_CreateAudioSourceProvider:
    case MessageName::RemoteMediaPlayerProxy_DidLoadingProgress:
    case MessageName::RemoteMediaPlayerProxy_EndSimulatedHDCPError:
    case MessageName::RemoteMediaPlayerProxy_KeyAdded:
    case MessageName::RemoteMediaPlayerProxy_Load:
    case MessageName::RemoteMediaPlayerProxy_LoadMediaSource:
    case MessageName::RemoteMediaPlayerProxy_NotifyActiveSourceBuffersChanged:
    case MessageName::RemoteMediaPlayerProxy_NotifyTrackModeChanged:
    case MessageName::RemoteMediaPlayerProxy_Pause:
    case MessageName::RemoteMediaPlayerProxy_PauseAtHostTime:
    case MessageName::RemoteMediaPlayerProxy_PerformTaskAtMediaTime:
    case MessageName::RemoteMediaPlayerProxy_Play:
    case MessageName::RemoteMediaPlayerProxy_PlayAtHostTime:
    case MessageName::RemoteMediaPlayerProxy_PrepareForPlayback:
    case MessageName::RemoteMediaPlayerProxy_PrepareForRendering:
    case MessageName::RemoteMediaPlayerProxy_PrepareToPlay:
    case MessageName::RemoteMediaPlayerProxy_Seek:
    case MessageName::RemoteMediaPlayerProxy_SeekWithTolerance:
    case MessageName::RemoteMediaPlayerProxy_SetBufferingPolicy:
    case MessageName::RemoteMediaPlayerProxy_SetLegacyCDMSession:
    case MessageName::RemoteMediaPlayerProxy_SetMuted:
    case MessageName::RemoteMediaPlayerProxy_SetPageIsVisible:
    case MessageName::RemoteMediaPlayerProxy_SetPitchCorrectionAlgorithm:
    case MessageName::RemoteMediaPlayerProxy_SetPreferredDynamicRangeMode:
    case MessageName::RemoteMediaPlayerProxy_SetPreload:
    case MessageName::RemoteMediaPlayerProxy_SetPreservesPitch:
    case MessageName::RemoteMediaPlayerProxy_SetPrivateBrowsingMode:
    case MessageName::RemoteMediaPlayerProxy_SetRate:
    case MessageName::RemoteMediaPlayerProxy_SetShouldContinueAfterKeyNeeded:
    case MessageName::RemoteMediaPlayerProxy_SetShouldDisableSleep:
    case MessageName::RemoteMediaPlayerProxy_SetShouldEnableAudioSourceProvider:
    case MessageName::RemoteMediaPlayerProxy_SetShouldMaintainAspectRatio:
    case MessageName::RemoteMediaPlayerProxy_SetShouldPlayToPlaybackTarget:
    case MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenGravity:
    case MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenMode:
    case MessageName::RemoteMediaPlayerProxy_SetVideoInlineSizeFenced:
    case MessageName::RemoteMediaPlayerProxy_SetVideoPlaybackMetricsUpdateInterval:
    case MessageName::RemoteMediaPlayerProxy_SetVolume:
    case MessageName::RemoteMediaPlayerProxy_SetWirelessPlaybackTarget:
    case MessageName::RemoteMediaPlayerProxy_SetWirelessVideoPlaybackDisabled:
    case MessageName::RemoteMediaPlayerProxy_StartVideoFrameMetadataGathering:
    case MessageName::RemoteMediaPlayerProxy_StopVideoFrameMetadataGathering:
    case MessageName::RemoteMediaPlayerProxy_TextTrackSetMode:
    case MessageName::RemoteMediaPlayerProxy_TracksChanged:
    case MessageName::RemoteMediaPlayerProxy_UpdateVideoFullscreenInlineImage:
    case MessageName::RemoteMediaPlayerProxy_VideoFullscreenStandbyChanged:
    case MessageName::RemoteMediaPlayerProxy_VideoTrackSetSelected:
        return ReceiverName::RemoteMediaPlayerProxy;
    case MessageName::RemoteMediaRecorderManager_CreateRecorder:
    case MessageName::RemoteMediaRecorderManager_ReleaseRecorder:
        return ReceiverName::RemoteMediaRecorderManager;
    case MessageName::RemoteMediaRecorder_AudioSamplesAvailable:
    case MessageName::RemoteMediaRecorder_AudioSamplesStorageChanged:
    case MessageName::RemoteMediaRecorder_FetchData:
    case MessageName::RemoteMediaRecorder_Pause:
    case MessageName::RemoteMediaRecorder_Resume:
    case MessageName::RemoteMediaRecorder_SetSharedVideoFrameMemory:
    case MessageName::RemoteMediaRecorder_SetSharedVideoFrameSemaphore:
    case MessageName::RemoteMediaRecorder_StopRecording:
    case MessageName::RemoteMediaRecorder_VideoSampleAvailable:
        return ReceiverName::RemoteMediaRecorder;
    case MessageName::RemoteMediaResourceManager_AccessControlCheckFailed:
    case MessageName::RemoteMediaResourceManager_DataReceived:
    case MessageName::RemoteMediaResourceManager_DataSent:
    case MessageName::RemoteMediaResourceManager_LoadFailed:
    case MessageName::RemoteMediaResourceManager_LoadFinished:
    case MessageName::RemoteMediaResourceManager_RedirectReceived:
    case MessageName::RemoteMediaResourceManager_ResponseReceived:
        return ReceiverName::RemoteMediaResourceManager;
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack:
    case MessageName::RemoteMediaSessionCoordinatorProxy_Join:
    case MessageName::RemoteMediaSessionCoordinatorProxy_Leave:
    case MessageName::RemoteMediaSessionCoordinatorProxy_PlaybackStateChanged:
    case MessageName::RemoteMediaSessionCoordinatorProxy_PositionStateChanged:
    case MessageName::RemoteMediaSessionCoordinatorProxy_ReadyStateChanged:
    case MessageName::RemoteMediaSessionCoordinatorProxy_TrackIdentifierChanged:
        return ReceiverName::RemoteMediaSessionCoordinatorProxy;
    case MessageName::RemoteMediaSessionCoordinator_CoordinatorStateChanged:
    case MessageName::RemoteMediaSessionCoordinator_PauseSession:
    case MessageName::RemoteMediaSessionCoordinator_PlaySession:
    case MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime:
    case MessageName::RemoteMediaSessionCoordinator_SetSessionTrack:
        return ReceiverName::RemoteMediaSessionCoordinator;
    case MessageName::RemoteMediaSourceProxy_BufferedChanged:
    case MessageName::RemoteMediaSourceProxy_DurationChanged:
    case MessageName::RemoteMediaSourceProxy_SeekCompleted:
    case MessageName::RemoteMediaSourceProxy_SetIsSeeking:
    case MessageName::RemoteMediaSourceProxy_SetReadyState:
    case MessageName::RemoteMediaSourceProxy_SetTimeFudgeFactor:
    case MessageName::RemoteMediaSourceProxy_WaitForSeekCompleted:
        return ReceiverName::RemoteMediaSourceProxy;
    case MessageName::RemotePipelineLayout_SetLabel:
        return ReceiverName::RemotePipelineLayout;
    case MessageName::RemoteQuerySet_Destroy:
    case MessageName::RemoteQuerySet_SetLabel:
        return ReceiverName::RemoteQuerySet;
    case MessageName::RemoteQueue_CopyExternalImageToTexture:
    case MessageName::RemoteQueue_SetLabel:
    case MessageName::RemoteQueue_Submit:
    case MessageName::RemoteQueue_WriteBuffer:
    case MessageName::RemoteQueue_WriteTexture:
        return ReceiverName::RemoteQueue;
    case MessageName::RemoteRemoteCommandListenerProxy_UpdateSupportedCommands:
        return ReceiverName::RemoteRemoteCommandListenerProxy;
    case MessageName::RemoteRemoteCommandListener_DidReceiveRemoteControlCommand:
        return ReceiverName::RemoteRemoteCommandListener;
    case MessageName::RemoteRenderBundleEncoder_Draw:
    case MessageName::RemoteRenderBundleEncoder_DrawIndexed:
    case MessageName::RemoteRenderBundleEncoder_DrawIndexedIndirect:
    case MessageName::RemoteRenderBundleEncoder_DrawIndirect:
    case MessageName::RemoteRenderBundleEncoder_Finish:
    case MessageName::RemoteRenderBundleEncoder_InsertDebugMarker:
    case MessageName::RemoteRenderBundleEncoder_PopDebugGroup:
    case MessageName::RemoteRenderBundleEncoder_PushDebugGroup:
    case MessageName::RemoteRenderBundleEncoder_SetBindGroup:
    case MessageName::RemoteRenderBundleEncoder_SetIndexBuffer:
    case MessageName::RemoteRenderBundleEncoder_SetLabel:
    case MessageName::RemoteRenderBundleEncoder_SetPipeline:
    case MessageName::RemoteRenderBundleEncoder_SetVertexBuffer:
        return ReceiverName::RemoteRenderBundleEncoder;
    case MessageName::RemoteRenderBundle_SetLabel:
        return ReceiverName::RemoteRenderBundle;
    case MessageName::RemoteRenderPassEncoder_BeginOcclusionQuery:
    case MessageName::RemoteRenderPassEncoder_Draw:
    case MessageName::RemoteRenderPassEncoder_DrawIndexed:
    case MessageName::RemoteRenderPassEncoder_DrawIndexedIndirect:
    case MessageName::RemoteRenderPassEncoder_DrawIndirect:
    case MessageName::RemoteRenderPassEncoder_End:
    case MessageName::RemoteRenderPassEncoder_EndOcclusionQuery:
    case MessageName::RemoteRenderPassEncoder_ExecuteBundles:
    case MessageName::RemoteRenderPassEncoder_InsertDebugMarker:
    case MessageName::RemoteRenderPassEncoder_PopDebugGroup:
    case MessageName::RemoteRenderPassEncoder_PushDebugGroup:
    case MessageName::RemoteRenderPassEncoder_SetBindGroup:
    case MessageName::RemoteRenderPassEncoder_SetBlendConstant:
    case MessageName::RemoteRenderPassEncoder_SetIndexBuffer:
    case MessageName::RemoteRenderPassEncoder_SetLabel:
    case MessageName::RemoteRenderPassEncoder_SetPipeline:
    case MessageName::RemoteRenderPassEncoder_SetScissorRect:
    case MessageName::RemoteRenderPassEncoder_SetStencilReference:
    case MessageName::RemoteRenderPassEncoder_SetVertexBuffer:
    case MessageName::RemoteRenderPassEncoder_SetViewport:
        return ReceiverName::RemoteRenderPassEncoder;
    case MessageName::RemoteRenderPipeline_GetBindGroupLayout:
    case MessageName::RemoteRenderPipeline_SetLabel:
        return ReceiverName::RemoteRenderPipeline;
    case MessageName::RemoteRenderingBackendProxy_DidCreateImageBufferBackend:
    case MessageName::RemoteRenderingBackendProxy_DidCreateWakeUpSemaphoreForDisplayListStream:
    case MessageName::RemoteRenderingBackendProxy_DidFinalizeRenderingUpdate:
    case MessageName::RemoteRenderingBackendProxy_DidFlush:
        return ReceiverName::RemoteRenderingBackendProxy;
    case MessageName::RemoteRenderingBackend_CacheFont:
    case MessageName::RemoteRenderingBackend_CacheNativeImage:
    case MessageName::RemoteRenderingBackend_CreateImageBuffer:
    case MessageName::RemoteRenderingBackend_DeleteAllFonts:
    case MessageName::RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory:
    case MessageName::RemoteRenderingBackend_FinalizeRenderingUpdate:
    case MessageName::RemoteRenderingBackend_PutPixelBufferForImageBuffer:
    case MessageName::RemoteRenderingBackend_ReleaseRemoteResource:
        return ReceiverName::RemoteRenderingBackend;
    case MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer:
    case MessageName::RemoteSampleBufferDisplayLayerManager_ReleaseLayer:
        return ReceiverName::RemoteSampleBufferDisplayLayerManager;
    case MessageName::RemoteSampleBufferDisplayLayer_ClearEnqueuedSamples:
    case MessageName::RemoteSampleBufferDisplayLayer_EnqueueSample:
    case MessageName::RemoteSampleBufferDisplayLayer_EnqueueSampleCV:
    case MessageName::RemoteSampleBufferDisplayLayer_Flush:
    case MessageName::RemoteSampleBufferDisplayLayer_FlushAndRemoveImage:
    case MessageName::RemoteSampleBufferDisplayLayer_Pause:
    case MessageName::RemoteSampleBufferDisplayLayer_Play:
    case MessageName::RemoteSampleBufferDisplayLayer_SetLogIdentifier:
    case MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameMemory:
    case MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameSemaphore:
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateAffineTransform:
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateBoundsAndPosition:
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateDisplayMode:
        return ReceiverName::RemoteSampleBufferDisplayLayer;
    case MessageName::RemoteSampler_SetLabel:
        return ReceiverName::RemoteSampler;
    case MessageName::RemoteShaderModule_SetLabel:
        return ReceiverName::RemoteShaderModule;
    case MessageName::RemoteSourceBufferProxy_Abort:
    case MessageName::RemoteSourceBufferProxy_AddTrackBuffer:
    case MessageName::RemoteSourceBufferProxy_Append:
    case MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId:
    case MessageName::RemoteSourceBufferProxy_ClearTrackBuffers:
    case MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID:
    case MessageName::RemoteSourceBufferProxy_ReenqueueMediaIfNeeded:
    case MessageName::RemoteSourceBufferProxy_RemoveCodedFrames:
    case MessageName::RemoteSourceBufferProxy_RemovedFromMediaSource:
    case MessageName::RemoteSourceBufferProxy_ResetParserState:
    case MessageName::RemoteSourceBufferProxy_ResetTimestampOffsetInTrackBuffers:
    case MessageName::RemoteSourceBufferProxy_ResetTrackBuffers:
    case MessageName::RemoteSourceBufferProxy_SeekToTime:
    case MessageName::RemoteSourceBufferProxy_SetActive:
    case MessageName::RemoteSourceBufferProxy_SetAllTrackBuffersNeedRandomAccess:
    case MessageName::RemoteSourceBufferProxy_SetAppendWindowEnd:
    case MessageName::RemoteSourceBufferProxy_SetAppendWindowStart:
    case MessageName::RemoteSourceBufferProxy_SetGroupStartTimestamp:
    case MessageName::RemoteSourceBufferProxy_SetGroupStartTimestampToEndTimestamp:
    case MessageName::RemoteSourceBufferProxy_SetMediaSourceEnded:
    case MessageName::RemoteSourceBufferProxy_SetMode:
    case MessageName::RemoteSourceBufferProxy_SetReadyState:
    case MessageName::RemoteSourceBufferProxy_SetShouldGenerateTimestamps:
    case MessageName::RemoteSourceBufferProxy_SetTimestampOffset:
    case MessageName::RemoteSourceBufferProxy_StartChangingType:
    case MessageName::RemoteSourceBufferProxy_UpdateTrackIds:
        return ReceiverName::RemoteSourceBufferProxy;
    case MessageName::RemoteTextureView_SetLabel:
        return ReceiverName::RemoteTextureView;
    case MessageName::RemoteTexture_CreateView:
    case MessageName::RemoteTexture_Destroy:
    case MessageName::RemoteTexture_SetLabel:
        return ReceiverName::RemoteTexture;
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewVideoFrameBuffer:
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameMemory:
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameSemaphore:
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_VideoFrameBufferNotFound:
        return ReceiverName::RemoteVideoFrameObjectHeapProxyProcessor;
    case MessageName::RemoteVideoFrameObjectHeap_GetVideoFrameBuffer:
    case MessageName::RemoteVideoFrameObjectHeap_ReleaseVideoFrame:
        return ReceiverName::RemoteVideoFrameObjectHeap;
    case MessageName::RemoteWebInspectorUIProxy_Append:
    case MessageName::RemoteWebInspectorUIProxy_BringToFront:
    case MessageName::RemoteWebInspectorUIProxy_FrontendDidClose:
    case MessageName::RemoteWebInspectorUIProxy_FrontendLoaded:
    case MessageName::RemoteWebInspectorUIProxy_OpenURLExternally:
    case MessageName::RemoteWebInspectorUIProxy_Reopen:
    case MessageName::RemoteWebInspectorUIProxy_ResetState:
    case MessageName::RemoteWebInspectorUIProxy_Save:
    case MessageName::RemoteWebInspectorUIProxy_SendMessageToBackend:
    case MessageName::RemoteWebInspectorUIProxy_SetForcedAppearance:
    case MessageName::RemoteWebInspectorUIProxy_SetSheetRect:
    case MessageName::RemoteWebInspectorUIProxy_ShowCertificate:
    case MessageName::RemoteWebInspectorUIProxy_StartWindowDrag:
        return ReceiverName::RemoteWebInspectorUIProxy;
    case MessageName::RemoteWebInspectorUI_DidAppend:
    case MessageName::RemoteWebInspectorUI_DidSave:
    case MessageName::RemoteWebInspectorUI_Initialize:
    case MessageName::RemoteWebInspectorUI_SendMessageToFrontend:
    case MessageName::RemoteWebInspectorUI_SetDiagnosticLoggingAvailable:
    case MessageName::RemoteWebInspectorUI_ShowConsole:
    case MessageName::RemoteWebInspectorUI_ShowResources:
    case MessageName::RemoteWebInspectorUI_UpdateFindString:
        return ReceiverName::RemoteWebInspectorUI;
    case MessageName::RemoteWebLockRegistry_DidCompleteLockRequest:
    case MessageName::RemoteWebLockRegistry_DidStealLock:
        return ReceiverName::RemoteWebLockRegistry;
    case MessageName::SampleBufferDisplayLayer_SetDidFail:
        return ReceiverName::SampleBufferDisplayLayer;
    case MessageName::ServiceWorkerDownloadTask_DidFail:
    case MessageName::ServiceWorkerDownloadTask_DidFinish:
    case MessageName::ServiceWorkerDownloadTask_DidReceiveData:
    case MessageName::ServiceWorkerDownloadTask_DidReceiveFormData:
        return ReceiverName::ServiceWorkerDownloadTask;
    case MessageName::ServiceWorkerFetchTask_DidFail:
    case MessageName::ServiceWorkerFetchTask_DidFinish:
    case MessageName::ServiceWorkerFetchTask_DidNotHandle:
    case MessageName::ServiceWorkerFetchTask_DidReceiveData:
    case MessageName::ServiceWorkerFetchTask_DidReceiveFormData:
    case MessageName::ServiceWorkerFetchTask_DidReceiveRedirectResponse:
    case MessageName::ServiceWorkerFetchTask_DidReceiveResponse:
        return ReceiverName::ServiceWorkerFetchTask;
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateAppendComplete:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateAppendError:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateBufferedDirtyChanged:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidDropSample:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidParseSample:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegment:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveRenderingError:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDurationChanged:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateHighestPresentationTimestampChanged:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateReportExtraMemoryCost:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateStreamEndedWithDecodeError:
        return ReceiverName::SourceBufferPrivateRemote;
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_CreateSource:
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_DeleteSource:
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_GrantSandboxExtensions:
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_RevokeSandboxExtensions:
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_Start:
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_Stop:
        return ReceiverName::SpeechRecognitionRealtimeMediaSourceManager;
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteAudioSamplesAvailable:
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteCaptureFailed:
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteSourceStopped:
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_SetStorage:
        return ReceiverName::SpeechRecognitionRemoteRealtimeMediaSourceManager;
    case MessageName::SpeechRecognitionServer_Abort:
    case MessageName::SpeechRecognitionServer_Invalidate:
    case MessageName::SpeechRecognitionServer_Start:
    case MessageName::SpeechRecognitionServer_Stop:
        return ReceiverName::SpeechRecognitionServer;
    case MessageName::StorageAreaMap_ClearCache:
    case MessageName::StorageAreaMap_DispatchStorageEvent:
        return ReceiverName::StorageAreaMap;
    case MessageName::StorageManagerSet_Clear:
    case MessageName::StorageManagerSet_CloneSessionStorageNamespace:
    case MessageName::StorageManagerSet_DisconnectFromStorageArea:
    case MessageName::StorageManagerSet_RemoveItem:
    case MessageName::StorageManagerSet_SetItem:
        return ReceiverName::StorageManagerSet;
    case MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture:
    case MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture:
    case MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold:
        return ReceiverName::ViewGestureController;
    case MessageName::ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture:
    case MessageName::ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture:
    case MessageName::ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold:
        return ReceiverName::ViewGestureGeometryCollector;
    case MessageName::VisitedLinkStore_AddVisitedLinkHashFromPage:
        return ReceiverName::VisitedLinkStore;
    case MessageName::VisitedLinkTableController_AllVisitedLinkStateChanged:
    case MessageName::VisitedLinkTableController_RemoveAllVisitedLinks:
    case MessageName::VisitedLinkTableController_SetVisitedLinkTable:
    case MessageName::VisitedLinkTableController_VisitedLinkStateChanged:
        return ReceiverName::VisitedLinkTableController;
    case MessageName::WebAutomationSessionProxy_ComputeElementLayout:
    case MessageName::WebAutomationSessionProxy_DeleteCookie:
    case MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction:
    case MessageName::WebAutomationSessionProxy_GetCookiesForFrame:
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName:
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle:
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal:
    case MessageName::WebAutomationSessionProxy_ResolveParentFrame:
    case MessageName::WebAutomationSessionProxy_SelectOptionElement:
    case MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload:
    case MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot:
    case MessageName::WebAutomationSessionProxy_TakeScreenshot:
        return ReceiverName::WebAutomationSessionProxy;
    case MessageName::WebAutomationSession_DidEvaluateJavaScriptFunction:
    case MessageName::WebAutomationSession_DidTakeScreenshot:
        return ReceiverName::WebAutomationSession;
    case MessageName::WebBroadcastChannelRegistry_PostMessageToRemote:
        return ReceiverName::WebBroadcastChannelRegistry;
    case MessageName::WebConnection_HandleMessage:
        return ReceiverName::WebConnection;
    case MessageName::WebCookieManagerProxy_CookiesDidChange:
        return ReceiverName::WebCookieManagerProxy;
    case MessageName::WebCookieManager_DeleteAllCookies:
    case MessageName::WebCookieManager_DeleteAllCookiesModifiedSince:
    case MessageName::WebCookieManager_DeleteCookie:
    case MessageName::WebCookieManager_DeleteCookiesForHostnames:
    case MessageName::WebCookieManager_GetAllCookies:
    case MessageName::WebCookieManager_GetCookies:
    case MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy:
    case MessageName::WebCookieManager_GetHostnamesWithCookies:
    case MessageName::WebCookieManager_SetCookie:
    case MessageName::WebCookieManager_SetCookiePersistentStorage:
    case MessageName::WebCookieManager_SetCookies:
    case MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy:
    case MessageName::WebCookieManager_StartObservingCookieChanges:
    case MessageName::WebCookieManager_StopObservingCookieChanges:
        return ReceiverName::WebCookieManager;
    case MessageName::WebFileSystemStorageConnection_InvalidateAccessHandle:
        return ReceiverName::WebFileSystemStorageConnection;
    case MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen:
    case MessageName::WebFullScreenManagerProxy_BeganExitFullScreen:
    case MessageName::WebFullScreenManagerProxy_Close:
    case MessageName::WebFullScreenManagerProxy_EnterFullScreen:
    case MessageName::WebFullScreenManagerProxy_ExitFullScreen:
        return ReceiverName::WebFullScreenManagerProxy;
    case MessageName::WebFullScreenManager_DidEnterFullScreen:
    case MessageName::WebFullScreenManager_DidExitFullScreen:
    case MessageName::WebFullScreenManager_RequestEnterFullScreen:
    case MessageName::WebFullScreenManager_RequestExitFullScreen:
    case MessageName::WebFullScreenManager_RestoreScrollPosition:
    case MessageName::WebFullScreenManager_SaveScrollPosition:
    case MessageName::WebFullScreenManager_SetAnimatingFullScreen:
    case MessageName::WebFullScreenManager_SetFullscreenAutoHideDuration:
    case MessageName::WebFullScreenManager_SetFullscreenControlsHidden:
    case MessageName::WebFullScreenManager_SetFullscreenInsets:
    case MessageName::WebFullScreenManager_WillEnterFullScreen:
    case MessageName::WebFullScreenManager_WillExitFullScreen:
        return ReceiverName::WebFullScreenManager;
    case MessageName::WebGeolocationManagerProxy_SetEnableHighAccuracy:
    case MessageName::WebGeolocationManagerProxy_StartUpdating:
    case MessageName::WebGeolocationManagerProxy_StopUpdating:
        return ReceiverName::WebGeolocationManagerProxy;
    case MessageName::WebGeolocationManager_DidChangePosition:
    case MessageName::WebGeolocationManager_DidFailToDeterminePosition:
    case MessageName::WebGeolocationManager_ResetPermissions:
        return ReceiverName::WebGeolocationManager;
    case MessageName::WebIDBConnectionToServer_DidAbortTransaction:
    case MessageName::WebIDBConnectionToServer_DidClearObjectStore:
    case MessageName::WebIDBConnectionToServer_DidCloseFromServer:
    case MessageName::WebIDBConnectionToServer_DidCommitTransaction:
    case MessageName::WebIDBConnectionToServer_DidCreateIndex:
    case MessageName::WebIDBConnectionToServer_DidCreateObjectStore:
    case MessageName::WebIDBConnectionToServer_DidDeleteDatabase:
    case MessageName::WebIDBConnectionToServer_DidDeleteIndex:
    case MessageName::WebIDBConnectionToServer_DidDeleteObjectStore:
    case MessageName::WebIDBConnectionToServer_DidDeleteRecord:
    case MessageName::WebIDBConnectionToServer_DidGetAllDatabaseNamesAndVersions:
    case MessageName::WebIDBConnectionToServer_DidGetAllRecords:
    case MessageName::WebIDBConnectionToServer_DidGetCount:
    case MessageName::WebIDBConnectionToServer_DidGetRecord:
    case MessageName::WebIDBConnectionToServer_DidIterateCursor:
    case MessageName::WebIDBConnectionToServer_DidOpenCursor:
    case MessageName::WebIDBConnectionToServer_DidOpenDatabase:
    case MessageName::WebIDBConnectionToServer_DidPutOrAdd:
    case MessageName::WebIDBConnectionToServer_DidRenameIndex:
    case MessageName::WebIDBConnectionToServer_DidRenameObjectStore:
    case MessageName::WebIDBConnectionToServer_DidStartTransaction:
    case MessageName::WebIDBConnectionToServer_FireVersionChangeEvent:
    case MessageName::WebIDBConnectionToServer_NotifyOpenDBRequestBlocked:
        return ReceiverName::WebIDBConnectionToServer;
    case MessageName::WebIDBServer_AbortOpenAndUpgradeNeeded:
    case MessageName::WebIDBServer_AbortTransaction:
    case MessageName::WebIDBServer_ClearObjectStore:
    case MessageName::WebIDBServer_CommitTransaction:
    case MessageName::WebIDBServer_CreateIndex:
    case MessageName::WebIDBServer_CreateObjectStore:
    case MessageName::WebIDBServer_DatabaseConnectionClosed:
    case MessageName::WebIDBServer_DatabaseConnectionPendingClose:
    case MessageName::WebIDBServer_DeleteDatabase:
    case MessageName::WebIDBServer_DeleteIndex:
    case MessageName::WebIDBServer_DeleteObjectStore:
    case MessageName::WebIDBServer_DeleteRecord:
    case MessageName::WebIDBServer_DidFinishHandlingVersionChangeTransaction:
    case MessageName::WebIDBServer_DidFireVersionChangeEvent:
    case MessageName::WebIDBServer_EstablishTransaction:
    case MessageName::WebIDBServer_GetAllDatabaseNamesAndVersions:
    case MessageName::WebIDBServer_GetAllRecords:
    case MessageName::WebIDBServer_GetCount:
    case MessageName::WebIDBServer_GetRecord:
    case MessageName::WebIDBServer_IterateCursor:
    case MessageName::WebIDBServer_OpenCursor:
    case MessageName::WebIDBServer_OpenDBRequestCancelled:
    case MessageName::WebIDBServer_OpenDatabase:
    case MessageName::WebIDBServer_PutOrAdd:
    case MessageName::WebIDBServer_RenameIndex:
    case MessageName::WebIDBServer_RenameObjectStore:
        return ReceiverName::WebIDBServer;
    case MessageName::WebInspectorInterruptDispatcher_NotifyNeedDebuggerBreak:
        return ReceiverName::WebInspectorInterruptDispatcher;
    case MessageName::WebInspectorUIProxy_Append:
    case MessageName::WebInspectorUIProxy_AttachAvailabilityChanged:
    case MessageName::WebInspectorUIProxy_AttachBottom:
    case MessageName::WebInspectorUIProxy_AttachLeft:
    case MessageName::WebInspectorUIProxy_AttachRight:
    case MessageName::WebInspectorUIProxy_BringInspectedPageToFront:
    case MessageName::WebInspectorUIProxy_BringToFront:
    case MessageName::WebInspectorUIProxy_Detach:
    case MessageName::WebInspectorUIProxy_DidClose:
    case MessageName::WebInspectorUIProxy_ElementSelectionChanged:
    case MessageName::WebInspectorUIProxy_FrontendLoaded:
    case MessageName::WebInspectorUIProxy_InspectedURLChanged:
    case MessageName::WebInspectorUIProxy_OpenLocalInspectorFrontend:
    case MessageName::WebInspectorUIProxy_OpenURLExternally:
    case MessageName::WebInspectorUIProxy_Reopen:
    case MessageName::WebInspectorUIProxy_ResetState:
    case MessageName::WebInspectorUIProxy_Save:
    case MessageName::WebInspectorUIProxy_SendMessageToBackend:
    case MessageName::WebInspectorUIProxy_SetAttachedWindowHeight:
    case MessageName::WebInspectorUIProxy_SetAttachedWindowWidth:
    case MessageName::WebInspectorUIProxy_SetDeveloperPreferenceOverride:
    case MessageName::WebInspectorUIProxy_SetForcedAppearance:
    case MessageName::WebInspectorUIProxy_SetFrontendConnection:
    case MessageName::WebInspectorUIProxy_SetSheetRect:
    case MessageName::WebInspectorUIProxy_ShowCertificate:
    case MessageName::WebInspectorUIProxy_StartWindowDrag:
    case MessageName::WebInspectorUIProxy_TimelineRecordingChanged:
        return ReceiverName::WebInspectorUIProxy;
    case MessageName::WebInspectorUI_AttachedBottom:
    case MessageName::WebInspectorUI_AttachedLeft:
    case MessageName::WebInspectorUI_AttachedRight:
    case MessageName::WebInspectorUI_Detached:
    case MessageName::WebInspectorUI_DidAppend:
    case MessageName::WebInspectorUI_DidSave:
    case MessageName::WebInspectorUI_EstablishConnection:
    case MessageName::WebInspectorUI_EvaluateInFrontendForTesting:
    case MessageName::WebInspectorUI_SendMessageToFrontend:
    case MessageName::WebInspectorUI_SetDiagnosticLoggingAvailable:
    case MessageName::WebInspectorUI_SetDockingUnavailable:
    case MessageName::WebInspectorUI_SetIsVisible:
    case MessageName::WebInspectorUI_ShowConsole:
    case MessageName::WebInspectorUI_ShowMainResourceForFrame:
    case MessageName::WebInspectorUI_ShowResources:
    case MessageName::WebInspectorUI_StartElementSelection:
    case MessageName::WebInspectorUI_StartPageProfiling:
    case MessageName::WebInspectorUI_StopElementSelection:
    case MessageName::WebInspectorUI_StopPageProfiling:
    case MessageName::WebInspectorUI_UpdateConnection:
    case MessageName::WebInspectorUI_UpdateFindString:
        return ReceiverName::WebInspectorUI;
    case MessageName::WebInspector_Close:
    case MessageName::WebInspector_SetAttached:
    case MessageName::WebInspector_SetFrontendConnection:
    case MessageName::WebInspector_Show:
    case MessageName::WebInspector_ShowConsole:
    case MessageName::WebInspector_ShowMainResourceForFrame:
    case MessageName::WebInspector_ShowResources:
    case MessageName::WebInspector_StartElementSelection:
    case MessageName::WebInspector_StartPageProfiling:
    case MessageName::WebInspector_StopElementSelection:
    case MessageName::WebInspector_StopPageProfiling:
        return ReceiverName::WebInspector;
    case MessageName::WebLockRegistryProxy_AbortLockRequest:
    case MessageName::WebLockRegistryProxy_ClientIsGoingAway:
    case MessageName::WebLockRegistryProxy_ReleaseLock:
    case MessageName::WebLockRegistryProxy_RequestLock:
    case MessageName::WebLockRegistryProxy_Snapshot:
        return ReceiverName::WebLockRegistryProxy;
    case MessageName::WebMDNSRegister_FinishedRegisteringMDNSName:
        return ReceiverName::WebMDNSRegister;
    case MessageName::WebNotificationManager_DidClickNotification:
    case MessageName::WebNotificationManager_DidCloseNotifications:
    case MessageName::WebNotificationManager_DidRemoveNotificationDecisions:
    case MessageName::WebNotificationManager_DidShowNotification:
    case MessageName::WebNotificationManager_DidUpdateNotificationDecision:
        return ReceiverName::WebNotificationManager;
    case MessageName::WebPageProxy_AbortApplePayAMSUISession:
    case MessageName::WebPageProxy_AddMediaUsageManagerSession:
    case MessageName::WebPageProxy_AddPlaybackTargetPickerClient:
    case MessageName::WebPageProxy_AssistiveTechnologyMakeFirstResponder:
    case MessageName::WebPageProxy_BackForwardAddItem:
    case MessageName::WebPageProxy_BackForwardClear:
    case MessageName::WebPageProxy_BeginMonitoringCaptureDevices:
    case MessageName::WebPageProxy_BindAccessibilityTree:
    case MessageName::WebPageProxy_ChangeUniversalAccessZoomFocus:
    case MessageName::WebPageProxy_ClassifyModalContainerControls:
    case MessageName::WebPageProxy_ClearAllEditCommands:
    case MessageName::WebPageProxy_ClearTextIndicator:
    case MessageName::WebPageProxy_CloneAttachmentData:
    case MessageName::WebPageProxy_ClosePage:
    case MessageName::WebPageProxy_CommitPotentialTapFailed:
    case MessageName::WebPageProxy_CompositionWasCanceled:
    case MessageName::WebPageProxy_ConfigureLoggingChannel:
    case MessageName::WebPageProxy_ContentFilterDidBlockLoadForFrame:
    case MessageName::WebPageProxy_ContentRuleListNotification:
    case MessageName::WebPageProxy_CouldNotRestorePageState:
    case MessageName::WebPageProxy_CreateInspectorTarget:
    case MessageName::WebPageProxy_CreatePDFHUD:
    case MessageName::WebPageProxy_DecidePolicyForModalContainer:
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync:
    case MessageName::WebPageProxy_DecidePolicyForNewWindowAction:
    case MessageName::WebPageProxy_DecidePolicyForResponse:
    case MessageName::WebPageProxy_DestroyInspectorTarget:
    case MessageName::WebPageProxy_DidCancelClientRedirectForFrame:
    case MessageName::WebPageProxy_DidChangeContentSize:
    case MessageName::WebPageProxy_DidChangeInspectorFrontendCount:
    case MessageName::WebPageProxy_DidChangeIntrinsicContentSize:
    case MessageName::WebPageProxy_DidChangeMainDocument:
    case MessageName::WebPageProxy_DidChangePageCount:
    case MessageName::WebPageProxy_DidChangeProgress:
    case MessageName::WebPageProxy_DidChangeProvisionalURLForFrame:
    case MessageName::WebPageProxy_DidChangeScrollOffsetPinningForMainFrame:
    case MessageName::WebPageProxy_DidChangeScrollbarsForMainFrame:
    case MessageName::WebPageProxy_DidChangeViewportProperties:
    case MessageName::WebPageProxy_DidCommitLoadForFrame:
    case MessageName::WebPageProxy_DidCompleteSyntheticClick:
    case MessageName::WebPageProxy_DidCountStringMatches:
    case MessageName::WebPageProxy_DidCreateContextInWebProcessForVisibilityPropagation:
    case MessageName::WebPageProxy_DidCreateMainFrame:
    case MessageName::WebPageProxy_DidCreateSubframe:
    case MessageName::WebPageProxy_DidCreateWindow:
    case MessageName::WebPageProxy_DidDestroyNavigation:
    case MessageName::WebPageProxy_DidDetectXSSForFrame:
    case MessageName::WebPageProxy_DidDisplayInsecureContentForFrame:
    case MessageName::WebPageProxy_DidEndDragging:
    case MessageName::WebPageProxy_DidExplicitOpenForFrame:
    case MessageName::WebPageProxy_DidFailLoadForFrame:
    case MessageName::WebPageProxy_DidFailProvisionalLoadForFrame:
    case MessageName::WebPageProxy_DidFailToFindString:
    case MessageName::WebPageProxy_DidFailToSuspendAfterProcessSwap:
    case MessageName::WebPageProxy_DidFindString:
    case MessageName::WebPageProxy_DidFindStringMatches:
    case MessageName::WebPageProxy_DidFindTextManipulationItems:
    case MessageName::WebPageProxy_DidFinishDocumentLoadForFrame:
    case MessageName::WebPageProxy_DidFinishLoadForFrame:
    case MessageName::WebPageProxy_DidFinishLoadForQuickLookDocumentInMainFrame:
    case MessageName::WebPageProxy_DidFinishLoadingDataForCustomContentProvider:
    case MessageName::WebPageProxy_DidFinishProgress:
    case MessageName::WebPageProxy_DidFinishServiceWorkerPageRegistration:
    case MessageName::WebPageProxy_DidFirstLayoutForFrame:
    case MessageName::WebPageProxy_DidFirstVisuallyNonEmptyLayoutForFrame:
    case MessageName::WebPageProxy_DidGetImageForFindMatch:
    case MessageName::WebPageProxy_DidGetTapHighlightGeometries:
    case MessageName::WebPageProxy_DidHandleAcceptedCandidate:
    case MessageName::WebPageProxy_DidHandleAdditionalDragItemsRequest:
    case MessageName::WebPageProxy_DidHandleDragStartRequest:
    case MessageName::WebPageProxy_DidInsertAttachmentWithIdentifier:
    case MessageName::WebPageProxy_DidNavigateWithNavigationData:
    case MessageName::WebPageProxy_DidNotHandleTapAsClick:
    case MessageName::WebPageProxy_DidPerformClientRedirect:
    case MessageName::WebPageProxy_DidPerformDictionaryLookup:
    case MessageName::WebPageProxy_DidPerformDragControllerAction:
    case MessageName::WebPageProxy_DidPerformDragOperation:
    case MessageName::WebPageProxy_DidPerformImmediateActionHitTest:
    case MessageName::WebPageProxy_DidPerformServerRedirect:
    case MessageName::WebPageProxy_DidReachLayoutMilestone:
    case MessageName::WebPageProxy_DidReceiveEditDragSnapshot:
    case MessageName::WebPageProxy_DidReceiveEvent:
    case MessageName::WebPageProxy_DidReceivePositionInformation:
    case MessageName::WebPageProxy_DidReceiveServerRedirectForProvisionalLoadForFrame:
    case MessageName::WebPageProxy_DidReceiveTitleForFrame:
    case MessageName::WebPageProxy_DidRemoveAttachmentWithIdentifier:
    case MessageName::WebPageProxy_DidResignInputElementStrongPasswordAppearance:
    case MessageName::WebPageProxy_DidRestoreScrollPosition:
    case MessageName::WebPageProxy_DidRunInsecureContentForFrame:
    case MessageName::WebPageProxy_DidSameDocumentNavigationForFrame:
    case MessageName::WebPageProxy_DidStartLoadForQuickLookDocumentInMainFrame:
    case MessageName::WebPageProxy_DidStartProgress:
    case MessageName::WebPageProxy_DidStartProvisionalLoadForFrame:
    case MessageName::WebPageProxy_DidSuspendAfterProcessSwap:
    case MessageName::WebPageProxy_DidUpdateActivityState:
    case MessageName::WebPageProxy_DidUpdateHistoryTitle:
    case MessageName::WebPageProxy_DidUpdateRenderingAfterCommittingLoad:
    case MessageName::WebPageProxy_DisableDoubleTapGesturesDuringTapIfNecessary:
    case MessageName::WebPageProxy_DisableInspectorNodeSearch:
    case MessageName::WebPageProxy_DismissCorrectionPanel:
    case MessageName::WebPageProxy_EditorStateChanged:
    case MessageName::WebPageProxy_ElementDidBlur:
    case MessageName::WebPageProxy_ElementDidFocus:
    case MessageName::WebPageProxy_EnableInspectorNodeSearch:
    case MessageName::WebPageProxy_EndColorPicker:
    case MessageName::WebPageProxy_EndDataListSuggestions:
    case MessageName::WebPageProxy_EndDateTimePicker:
    case MessageName::WebPageProxy_EnumerateMediaDevicesForFrame:
    case MessageName::WebPageProxy_FixedLayoutSizeDidChange:
    case MessageName::WebPageProxy_FocusedElementDidChangeInputMode:
    case MessageName::WebPageProxy_FocusedFrameChanged:
    case MessageName::WebPageProxy_GetLoadDecisionForIcon:
    case MessageName::WebPageProxy_HandleAcceptsFirstMouse:
    case MessageName::WebPageProxy_HandleAutoFillButtonClick:
    case MessageName::WebPageProxy_HandleAutocorrectionContext:
    case MessageName::WebPageProxy_HandleAutoplayEvent:
    case MessageName::WebPageProxy_HandleClickForDataDetectionResult:
    case MessageName::WebPageProxy_HandleContextMenuTranslation:
    case MessageName::WebPageProxy_HandleKeydownInDataList:
    case MessageName::WebPageProxy_HandleMessage:
    case MessageName::WebPageProxy_HandleMouseDownForModelElement:
    case MessageName::WebPageProxy_HandleMouseMoveForModelElement:
    case MessageName::WebPageProxy_HandleMouseUpForModelElement:
    case MessageName::WebPageProxy_HandleSmartMagnificationInformationForPotentialTap:
    case MessageName::WebPageProxy_HideInspectorHighlight:
    case MessageName::WebPageProxy_HideInspectorIndication:
    case MessageName::WebPageProxy_HidePopupMenu:
    case MessageName::WebPageProxy_HideValidationMessage:
    case MessageName::WebPageProxy_IgnoreWord:
    case MessageName::WebPageProxy_ImageOrMediaDocumentSizeChanged:
    case MessageName::WebPageProxy_IsPlayingMediaDidChange:
    case MessageName::WebPageProxy_LearnWord:
    case MessageName::WebPageProxy_LogDiagnosticMessageFromWebProcess:
    case MessageName::WebPageProxy_LogDiagnosticMessageWithDomainFromWebProcess:
    case MessageName::WebPageProxy_LogDiagnosticMessageWithEnhancedPrivacyFromWebProcess:
    case MessageName::WebPageProxy_LogDiagnosticMessageWithResultFromWebProcess:
    case MessageName::WebPageProxy_LogDiagnosticMessageWithValueDictionaryFromWebProcess:
    case MessageName::WebPageProxy_LogDiagnosticMessageWithValueFromWebProcess:
    case MessageName::WebPageProxy_LogScrollingEvent:
    case MessageName::WebPageProxy_MainFramePluginHandlesPageScaleGestureDidChange:
    case MessageName::WebPageProxy_MakeFirstResponder:
    case MessageName::WebPageProxy_MockMediaPlaybackTargetPickerDismissPopup:
    case MessageName::WebPageProxy_ModelElementAnimationCurrentTime:
    case MessageName::WebPageProxy_ModelElementAnimationDuration:
    case MessageName::WebPageProxy_ModelElementDidCreatePreview:
    case MessageName::WebPageProxy_ModelElementGetCamera:
    case MessageName::WebPageProxy_ModelElementHasAudio:
    case MessageName::WebPageProxy_ModelElementIsLoopingAnimation:
    case MessageName::WebPageProxy_ModelElementIsMuted:
    case MessageName::WebPageProxy_ModelElementIsPlayingAnimation:
    case MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime:
    case MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying:
    case MessageName::WebPageProxy_ModelElementSetCamera:
    case MessageName::WebPageProxy_ModelElementSetInteractionEnabled:
    case MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation:
    case MessageName::WebPageProxy_ModelElementSetIsMuted:
    case MessageName::WebPageProxy_ModelElementSizeDidChange:
    case MessageName::WebPageProxy_MouseDidMoveOverElement:
    case MessageName::WebPageProxy_NotifyScrollerThumbIsVisibleInRect:
    case MessageName::WebPageProxy_OpenPDFFromTemporaryFolderWithNativeApplication:
    case MessageName::WebPageProxy_PageDidScroll:
    case MessageName::WebPageProxy_PageExtendedBackgroundColorDidChange:
    case MessageName::WebPageProxy_PageScaleFactorDidChange:
    case MessageName::WebPageProxy_PlaybackTargetPickerClientStateDidChange:
    case MessageName::WebPageProxy_PluginScaleFactorDidChange:
    case MessageName::WebPageProxy_PluginZoomFactorDidChange:
    case MessageName::WebPageProxy_QueryPermission:
    case MessageName::WebPageProxy_RecommendedScrollbarStyleDidChange:
    case MessageName::WebPageProxy_RecordAutocorrectionResponse:
    case MessageName::WebPageProxy_RegisterAttachmentIdentifier:
    case MessageName::WebPageProxy_RegisterAttachmentIdentifierFromData:
    case MessageName::WebPageProxy_RegisterAttachmentIdentifierFromFilePath:
    case MessageName::WebPageProxy_RegisterAttachmentsFromSerializedData:
    case MessageName::WebPageProxy_RegisterEditCommandForUndo:
    case MessageName::WebPageProxy_RegisterInsertionUndoGrouping:
    case MessageName::WebPageProxy_RegisterWebProcessAccessibilityToken:
    case MessageName::WebPageProxy_RemoveDictationAlternatives:
    case MessageName::WebPageProxy_RemoveMediaUsageManagerSession:
    case MessageName::WebPageProxy_RemovePDFHUD:
    case MessageName::WebPageProxy_RemovePlaybackTargetPickerClient:
    case MessageName::WebPageProxy_RequestAttachmentIcon:
    case MessageName::WebPageProxy_RequestCheckingOfString:
    case MessageName::WebPageProxy_RequestCookieConsent:
    case MessageName::WebPageProxy_RequestGeolocationPermissionForFrame:
    case MessageName::WebPageProxy_RequestInstallMissingMediaPlugins:
    case MessageName::WebPageProxy_RequestMediaKeySystemPermissionForFrame:
    case MessageName::WebPageProxy_RequestNotificationPermission:
    case MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame:
    case MessageName::WebPageProxy_RequestPointerLock:
    case MessageName::WebPageProxy_RequestPointerUnlock:
    case MessageName::WebPageProxy_RequestScrollToRect:
    case MessageName::WebPageProxy_RequestTextRecognition:
    case MessageName::WebPageProxy_RequestUserMediaPermissionForFrame:
    case MessageName::WebPageProxy_RestorePageCenterAndScale:
    case MessageName::WebPageProxy_RestorePageState:
    case MessageName::WebPageProxy_RevokeGeolocationAuthorizationToken:
    case MessageName::WebPageProxy_RunModal:
    case MessageName::WebPageProxy_RunOpenPanel:
    case MessageName::WebPageProxy_SampledPageTopColorChanged:
    case MessageName::WebPageProxy_SaveImageToLibrary:
    case MessageName::WebPageProxy_SavePDFToFileInDownloadsFolder:
    case MessageName::WebPageProxy_SavePDFToTemporaryFolderAndOpenWithNativeApplication:
    case MessageName::WebPageProxy_SaveRecentSearches:
    case MessageName::WebPageProxy_ScrollingNodeScrollDidEndScroll:
    case MessageName::WebPageProxy_ScrollingNodeScrollWillStartScroll:
    case MessageName::WebPageProxy_SearchTheWeb:
    case MessageName::WebPageProxy_SearchWithSpotlight:
    case MessageName::WebPageProxy_SendMessageToInspectorFrontend:
    case MessageName::WebPageProxy_SendMessageToWebView:
    case MessageName::WebPageProxy_SendMessageToWebViewWithReply:
    case MessageName::WebPageProxy_SetCanShortCircuitHorizontalWheelEvents:
    case MessageName::WebPageProxy_SetColorPickerColor:
    case MessageName::WebPageProxy_SetCursor:
    case MessageName::WebPageProxy_SetCursorHiddenUntilMouseMoves:
    case MessageName::WebPageProxy_SetDataDetectionResult:
    case MessageName::WebPageProxy_SetEditableElementIsFocused:
    case MessageName::WebPageProxy_SetFocus:
    case MessageName::WebPageProxy_SetHasActiveAnimatedScrolls:
    case MessageName::WebPageProxy_SetHasExecutedAppBoundBehaviorBeforeNavigation:
    case MessageName::WebPageProxy_SetHasHadSelectionChangesFromUserInteraction:
    case MessageName::WebPageProxy_SetInputMethodState:
    case MessageName::WebPageProxy_SetIsNeverRichlyEditableForTouchBar:
    case MessageName::WebPageProxy_SetIsResizable:
    case MessageName::WebPageProxy_SetIsTouchBarUpdateSupressedForHiddenContentEditable:
    case MessageName::WebPageProxy_SetIsUsingHighPerformanceWebGL:
    case MessageName::WebPageProxy_SetMenuBarIsVisible:
    case MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerEnabled:
    case MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerState:
    case MessageName::WebPageProxy_SetMockVideoPresentationModeEnabled:
    case MessageName::WebPageProxy_SetMockWebAuthenticationConfiguration:
    case MessageName::WebPageProxy_SetNetworkRequestsInProgress:
    case MessageName::WebPageProxy_SetPromisedDataForImage:
    case MessageName::WebPageProxy_SetRenderTreeSize:
    case MessageName::WebPageProxy_SetStatusBarIsVisible:
    case MessageName::WebPageProxy_SetStatusText:
    case MessageName::WebPageProxy_SetTextIndicator:
    case MessageName::WebPageProxy_SetToolbarsAreVisible:
    case MessageName::WebPageProxy_SetWindowFrame:
    case MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess:
    case MessageName::WebPageProxy_ShowColorPicker:
    case MessageName::WebPageProxy_ShowContactPicker:
    case MessageName::WebPageProxy_ShowContextMenu:
    case MessageName::WebPageProxy_ShowCorrectionPanel:
    case MessageName::WebPageProxy_ShowDataDetectorsUIForPositionInformation:
    case MessageName::WebPageProxy_ShowDataListSuggestions:
    case MessageName::WebPageProxy_ShowDateTimePicker:
    case MessageName::WebPageProxy_ShowDictationAlternativeUI:
    case MessageName::WebPageProxy_ShowEmojiPicker:
    case MessageName::WebPageProxy_ShowInspectorHighlight:
    case MessageName::WebPageProxy_ShowInspectorIndication:
    case MessageName::WebPageProxy_ShowMediaControlsContextMenu:
    case MessageName::WebPageProxy_ShowPage:
    case MessageName::WebPageProxy_ShowPlaybackTargetPicker:
    case MessageName::WebPageProxy_ShowPopupMenu:
    case MessageName::WebPageProxy_ShowShareSheet:
    case MessageName::WebPageProxy_ShowTelephoneNumberMenu:
    case MessageName::WebPageProxy_ShowValidationMessage:
    case MessageName::WebPageProxy_Speak:
    case MessageName::WebPageProxy_SpeechSynthesisCancel:
    case MessageName::WebPageProxy_SpeechSynthesisPause:
    case MessageName::WebPageProxy_SpeechSynthesisResetState:
    case MessageName::WebPageProxy_SpeechSynthesisResume:
    case MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback:
    case MessageName::WebPageProxy_SpeechSynthesisSpeak:
    case MessageName::WebPageProxy_StartApplePayAMSUISession:
    case MessageName::WebPageProxy_StartDrag:
    case MessageName::WebPageProxy_StartURLSchemeTask:
    case MessageName::WebPageProxy_StopSpeaking:
    case MessageName::WebPageProxy_StopURLSchemeTask:
    case MessageName::WebPageProxy_StoreAppHighlight:
    case MessageName::WebPageProxy_TakeFocus:
    case MessageName::WebPageProxy_TakeModelElementFullscreen:
    case MessageName::WebPageProxy_ThemeColorChanged:
    case MessageName::WebPageProxy_TouchBarMenuDataChanged:
    case MessageName::WebPageProxy_TouchBarMenuItemDataAdded:
    case MessageName::WebPageProxy_TouchBarMenuItemDataRemoved:
    case MessageName::WebPageProxy_UnableToImplementPolicy:
    case MessageName::WebPageProxy_UpdateInputContextAfterBlurringAndRefocusingElement:
    case MessageName::WebPageProxy_UpdateMediaUsageManagerSessionState:
    case MessageName::WebPageProxy_UpdatePDFHUDLocation:
    case MessageName::WebPageProxy_UpdateSpellingUIWithGrammarString:
    case MessageName::WebPageProxy_UpdateSpellingUIWithMisspelledWord:
    case MessageName::WebPageProxy_UpdateStringForFind:
    case MessageName::WebPageProxy_UseFixedLayoutDidChange:
    case MessageName::WebPageProxy_WillGoToBackForwardListItem:
    case MessageName::WebPageProxy_WillPerformClientRedirectForFrame:
    case MessageName::WebPageProxy_WillReceiveEditDragSnapshot:
    case MessageName::WebPageProxy_WillSubmitForm:
    case MessageName::WebPageProxy_WritePromisedAttachmentToPasteboard:
    case MessageName::WebPageProxy_toggleAutomaticDashSubstitution:
    case MessageName::WebPageProxy_toggleAutomaticLinkDetection:
    case MessageName::WebPageProxy_toggleAutomaticQuoteSubstitution:
    case MessageName::WebPageProxy_toggleAutomaticTextReplacement:
    case MessageName::WebPageProxy_toggleSmartInsertDelete:
        return ReceiverName::WebPageProxy;
    case MessageName::WebPage_AccessibilitySettingsDidChange:
    case MessageName::WebPage_AddConsoleMessage:
    case MessageName::WebPage_AddMIMETypeWithCustomContentProvider:
    case MessageName::WebPage_AdvanceToNextMisspelling:
    case MessageName::WebPage_ApplicationDidBecomeActive:
    case MessageName::WebPage_ApplicationDidEnterBackground:
    case MessageName::WebPage_ApplicationDidEnterBackgroundForMedia:
    case MessageName::WebPage_ApplicationDidFinishSnapshottingAfterEnteringBackground:
    case MessageName::WebPage_ApplicationWillEnterForeground:
    case MessageName::WebPage_ApplicationWillEnterForegroundForMedia:
    case MessageName::WebPage_ApplicationWillResignActive:
    case MessageName::WebPage_ApplyAutocorrection:
    case MessageName::WebPage_AttemptSyntheticClick:
    case MessageName::WebPage_AttributedSubstringForCharacterRangeAsync:
    case MessageName::WebPage_AutofillLoginCredentials:
    case MessageName::WebPage_BeginPrinting:
    case MessageName::WebPage_BeginSelectionInDirection:
    case MessageName::WebPage_BlurFocusedElement:
    case MessageName::WebPage_BoundaryEventOccurred:
    case MessageName::WebPage_CancelAutoscroll:
    case MessageName::WebPage_CancelComposition:
    case MessageName::WebPage_CancelPointer:
    case MessageName::WebPage_CancelPotentialTap:
    case MessageName::WebPage_CapitalizeWord:
    case MessageName::WebPage_CaptureDevicesChanged:
    case MessageName::WebPage_CenterSelectionInVisibleArea:
    case MessageName::WebPage_ChangeFont:
    case MessageName::WebPage_ChangeFontAttributes:
    case MessageName::WebPage_ChangeListType:
    case MessageName::WebPage_ChangeSpellingToWord:
    case MessageName::WebPage_CharacterIndexForPointAsync:
    case MessageName::WebPage_ClearAllDecoratedFoundText:
    case MessageName::WebPage_ClearLoadedSubresourceDomains:
    case MessageName::WebPage_ClearSelection:
    case MessageName::WebPage_ClearServiceWorkerEntitlementOverride:
    case MessageName::WebPage_ClearWheelEventTestMonitor:
    case MessageName::WebPage_Close:
    case MessageName::WebPage_CollapseSelectionInFrame:
    case MessageName::WebPage_CommitPotentialTap:
    case MessageName::WebPage_CompleteTextManipulation:
    case MessageName::WebPage_ComputePagesForPrinting:
    case MessageName::WebPage_ConfirmCompositionAsync:
    case MessageName::WebPage_ConnectInspector:
    case MessageName::WebPage_ContentSizeCategoryDidChange:
    case MessageName::WebPage_ContextMenuForKeyEvent:
    case MessageName::WebPage_ContinueWillSubmitForm:
    case MessageName::WebPage_CountStringMatches:
    case MessageName::WebPage_CreateAppHighlightInSelectedRange:
    case MessageName::WebPage_CreateMediaSessionCoordinator:
    case MessageName::WebPage_DataDetectorsDidChangeUI:
    case MessageName::WebPage_DataDetectorsDidHideUI:
    case MessageName::WebPage_DataDetectorsDidPresentUI:
    case MessageName::WebPage_DecorateTextRangeWithStyle:
    case MessageName::WebPage_DecreaseListLevel:
    case MessageName::WebPage_DeleteSurrounding:
    case MessageName::WebPage_DetectDataInAllFrames:
    case MessageName::WebPage_DidAcquirePointerLock:
    case MessageName::WebPage_DidBeginTextSearchOperation:
    case MessageName::WebPage_DidCancelCheckingText:
    case MessageName::WebPage_DidCancelForOpenPanel:
    case MessageName::WebPage_DidChangeSelectedIndexForActivePopupMenu:
    case MessageName::WebPage_DidChooseColor:
    case MessageName::WebPage_DidChooseDate:
    case MessageName::WebPage_DidChooseFilesForOpenPanel:
    case MessageName::WebPage_DidChooseFilesForOpenPanelWithDisplayStringAndIcon:
    case MessageName::WebPage_DidCloseSuggestions:
    case MessageName::WebPage_DidConcludeDrop:
    case MessageName::WebPage_DidDismissContextMenu:
    case MessageName::WebPage_DidEndColorPicker:
    case MessageName::WebPage_DidEndDateTimePicker:
    case MessageName::WebPage_DidEndMagnificationGesture:
    case MessageName::WebPage_DidEndRequestInstallMissingMediaPlugins:
    case MessageName::WebPage_DidEndTextSearchOperation:
    case MessageName::WebPage_DidFinishCheckingText:
    case MessageName::WebPage_DidGetLoadDecisionForIcon:
    case MessageName::WebPage_DidLosePointerLock:
    case MessageName::WebPage_DidNotAcquirePointerLock:
    case MessageName::WebPage_DidReceiveGeolocationPermissionDecision:
    case MessageName::WebPage_DidReceivePolicyDecision:
    case MessageName::WebPage_DidRecognizeLongPress:
    case MessageName::WebPage_DidRemoveBackForwardItem:
    case MessageName::WebPage_DidRemoveEditCommand:
    case MessageName::WebPage_DidSelectDataListOption:
    case MessageName::WebPage_DidSelectItemFromActiveContextMenu:
    case MessageName::WebPage_DidShowContextMenu:
    case MessageName::WebPage_DidStartDrag:
    case MessageName::WebPage_DisconnectInspector:
    case MessageName::WebPage_DispatchWheelEventWithoutScrolling:
    case MessageName::WebPage_DragCancelled:
    case MessageName::WebPage_DragEnded:
    case MessageName::WebPage_DrawPagesForPrinting:
    case MessageName::WebPage_DrawPagesToPDF:
    case MessageName::WebPage_DrawRectToImage:
    case MessageName::WebPage_DrawToPDF:
    case MessageName::WebPage_DrawToPDFiOS:
    case MessageName::WebPage_DynamicViewportSizeUpdate:
    case MessageName::WebPage_EffectiveAppearanceDidChange:
    case MessageName::WebPage_EndPrinting:
    case MessageName::WebPage_EnqueueSecurityPolicyViolationEvent:
    case MessageName::WebPage_ExecuteEditCommand:
    case MessageName::WebPage_ExecuteEditCommandWithCallback:
    case MessageName::WebPage_ExtendSandboxForFilesFromOpenPanel:
    case MessageName::WebPage_ExtendSelection:
    case MessageName::WebPage_FailedToShowPopupMenu:
    case MessageName::WebPage_FindRectsForStringMatches:
    case MessageName::WebPage_FindString:
    case MessageName::WebPage_FindStringMatches:
    case MessageName::WebPage_FindTextRangesForStringMatches:
    case MessageName::WebPage_FirstRectForCharacterRangeAsync:
    case MessageName::WebPage_FocusNextFocusedElement:
    case MessageName::WebPage_FocusTextInputContextAndPlaceCaret:
    case MessageName::WebPage_ForceRepaint:
    case MessageName::WebPage_FrameBecameRemote:
    case MessageName::WebPage_FreezeLayerTreeDueToSwipeAnimation:
    case MessageName::WebPage_GamepadActivity:
    case MessageName::WebPage_GenerateSyntheticEditingCommand:
    case MessageName::WebPage_GetAllFrames:
    case MessageName::WebPage_GetApplicationManifest:
    case MessageName::WebPage_GetBytecodeProfile:
    case MessageName::WebPage_GetContentsAsAttributedString:
    case MessageName::WebPage_GetContentsAsMHTMLData:
    case MessageName::WebPage_GetContentsAsString:
    case MessageName::WebPage_GetImageForFindMatch:
    case MessageName::WebPage_GetLoadedSubresourceDomains:
    case MessageName::WebPage_GetMainResourceDataOfFrame:
    case MessageName::WebPage_GetMarkedRangeAsync:
    case MessageName::WebPage_GetPDFFirstPageSize:
    case MessageName::WebPage_GetProcessDisplayName:
    case MessageName::WebPage_GetRectsAtSelectionOffsetWithText:
    case MessageName::WebPage_GetRectsForGranularityWithSelectionOffset:
    case MessageName::WebPage_GetRenderTreeExternalRepresentation:
    case MessageName::WebPage_GetResourceDataFromFrame:
    case MessageName::WebPage_GetSamplingProfilerOutput:
    case MessageName::WebPage_GetSelectedRangeAsync:
    case MessageName::WebPage_GetSelectionAsWebArchiveData:
    case MessageName::WebPage_GetSelectionContext:
    case MessageName::WebPage_GetSelectionOrContentsAsString:
    case MessageName::WebPage_GetSourceForFrame:
    case MessageName::WebPage_GetWebArchiveOfFrame:
    case MessageName::WebPage_GoToBackForwardItem:
    case MessageName::WebPage_HandleAcceptedCandidate:
    case MessageName::WebPage_HandleAlternativeTextUIResult:
    case MessageName::WebPage_HandleAutocorrectionContextRequest:
    case MessageName::WebPage_HandleDoubleTapForDoubleClickAtPoint:
    case MessageName::WebPage_HandleTwoFingerTapAtPoint:
    case MessageName::WebPage_HardwareKeyboardAvailabilityChanged:
    case MessageName::WebPage_HasMarkedText:
    case MessageName::WebPage_HideFindIndicator:
    case MessageName::WebPage_HideFindUI:
    case MessageName::WebPage_ImmediateActionDidCancel:
    case MessageName::WebPage_ImmediateActionDidComplete:
    case MessageName::WebPage_ImmediateActionDidUpdate:
    case MessageName::WebPage_IncreaseListLevel:
    case MessageName::WebPage_IndicateFindMatch:
    case MessageName::WebPage_InsertAttachment:
    case MessageName::WebPage_InsertDictatedTextAsync:
    case MessageName::WebPage_InsertDroppedImagePlaceholders:
    case MessageName::WebPage_InsertTextAsync:
    case MessageName::WebPage_InsertTextPlaceholder:
    case MessageName::WebPage_InspectorNodeSearchEndedAtPosition:
    case MessageName::WebPage_InspectorNodeSearchMovedToPosition:
    case MessageName::WebPage_InstallCroppedImageOverlay:
    case MessageName::WebPage_InteractableRegionsInRootViewCoordinates:
    case MessageName::WebPage_InvalidateMediaSessionCoordinator:
    case MessageName::WebPage_IsLayerTreeFrozen:
    case MessageName::WebPage_KeyEvent:
    case MessageName::WebPage_LastNavigationWasAppInitiated:
    case MessageName::WebPage_ListenForLayoutMilestones:
    case MessageName::WebPage_LoadAlternateHTML:
    case MessageName::WebPage_LoadData:
    case MessageName::WebPage_LoadDataInFrame:
    case MessageName::WebPage_LoadRequest:
    case MessageName::WebPage_LoadRequestWaitingForProcessLaunch:
    case MessageName::WebPage_LoadSimulatedRequestAndResponse:
    case MessageName::WebPage_LoadURLInFrame:
    case MessageName::WebPage_LowercaseWord:
    case MessageName::WebPage_MediaKeySystemWasDenied:
    case MessageName::WebPage_MediaKeySystemWasGranted:
    case MessageName::WebPage_MouseEvent:
    case MessageName::WebPage_MoveSelectionAtBoundaryWithDirection:
    case MessageName::WebPage_MoveSelectionByOffset:
    case MessageName::WebPage_NavigateToPDFLinkWithSimulatedClick:
    case MessageName::WebPage_NotifyUserScripts:
    case MessageName::WebPage_OpenPDFWithPreview:
    case MessageName::WebPage_PauseAllMediaPlayback:
    case MessageName::WebPage_PerformActionOnElement:
    case MessageName::WebPage_PerformDictionaryLookupAtLocation:
    case MessageName::WebPage_PerformDictionaryLookupOfCurrentSelection:
    case MessageName::WebPage_PerformDragControllerAction:
    case MessageName::WebPage_PerformImmediateActionHitTestAtLocation:
    case MessageName::WebPage_PlaybackTargetAvailabilityDidChange:
    case MessageName::WebPage_PlaybackTargetPickerWasDismissed:
    case MessageName::WebPage_PlaybackTargetSelected:
    case MessageName::WebPage_PostInjectedBundleMessage:
    case MessageName::WebPage_PotentialTapAtPosition:
    case MessageName::WebPage_PreferencesDidChange:
    case MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView:
    case MessageName::WebPage_ReapplyEditCommand:
    case MessageName::WebPage_RegisterUIProcessAccessibilityTokens:
    case MessageName::WebPage_RegisterURLSchemeHandler:
    case MessageName::WebPage_Reload:
    case MessageName::WebPage_RemoveDataDetectedLinks:
    case MessageName::WebPage_RemoveTextPlaceholder:
    case MessageName::WebPage_ReplaceDictatedText:
    case MessageName::WebPage_ReplaceMatches:
    case MessageName::WebPage_ReplaceSelectedText:
    case MessageName::WebPage_ReplaceSelectionWithPasteboardData:
    case MessageName::WebPage_ReplaceWithPasteboardData:
    case MessageName::WebPage_RequestAcceptsFirstMouse:
    case MessageName::WebPage_RequestActiveNowPlayingSessionInfo:
    case MessageName::WebPage_RequestAdditionalItemsForDragSession:
    case MessageName::WebPage_RequestAutocorrectionData:
    case MessageName::WebPage_RequestDictationContext:
    case MessageName::WebPage_RequestDocumentEditingContext:
    case MessageName::WebPage_RequestDragStart:
    case MessageName::WebPage_RequestEvasionRectsAboveSelection:
    case MessageName::WebPage_RequestFocusedElementInformation:
    case MessageName::WebPage_RequestFontAttributesAtSelectionStart:
    case MessageName::WebPage_RequestImageBitmap:
    case MessageName::WebPage_RequestMediaPlaybackState:
    case MessageName::WebPage_RequestPositionInformation:
    case MessageName::WebPage_RequestRVItemInCurrentSelectedRange:
    case MessageName::WebPage_RequestRectForFoundTextRange:
    case MessageName::WebPage_ResetPotentialTapSecurityOrigin:
    case MessageName::WebPage_RestoreAppHighlightsAndScrollToIndex:
    case MessageName::WebPage_RestoreSelectionInFocusedEditableElement:
    case MessageName::WebPage_RestoreSession:
    case MessageName::WebPage_Resume:
    case MessageName::WebPage_ResumeActiveDOMObjectsAndAnimations:
    case MessageName::WebPage_ResumeAllMediaPlayback:
    case MessageName::WebPage_RunJavaScriptInFrameInScriptWorld:
    case MessageName::WebPage_SavePDF:
    case MessageName::WebPage_ScalePage:
    case MessageName::WebPage_ScalePageInViewCoordinates:
    case MessageName::WebPage_ScaleView:
    case MessageName::WebPage_ScheduleFullEditorStateUpdate:
    case MessageName::WebPage_ScrollBy:
    case MessageName::WebPage_ScrollTextRangeToVisible:
    case MessageName::WebPage_ScrollToRect:
    case MessageName::WebPage_SelectAll:
    case MessageName::WebPage_SelectFindMatch:
    case MessageName::WebPage_SelectPositionAtBoundaryWithDirection:
    case MessageName::WebPage_SelectPositionAtPoint:
    case MessageName::WebPage_SelectTextWithGranularityAtPoint:
    case MessageName::WebPage_SelectWithGesture:
    case MessageName::WebPage_SelectWithTwoTouches:
    case MessageName::WebPage_SelectWordBackward:
    case MessageName::WebPage_SendCSPViolationReport:
    case MessageName::WebPage_SendMessageToTargetBackend:
    case MessageName::WebPage_SendMessageToWebExtension:
    case MessageName::WebPage_SendMessageToWebExtensionWithReply:
    case MessageName::WebPage_SetAccentColor:
    case MessageName::WebPage_SetActivityState:
    case MessageName::WebPage_SetAllowsMediaDocumentInlinePlayback:
    case MessageName::WebPage_SetAlwaysShowsHorizontalScroller:
    case MessageName::WebPage_SetAlwaysShowsVerticalScroller:
    case MessageName::WebPage_SetAppHighlightsVisibility:
    case MessageName::WebPage_SetAutoSizingShouldExpandToViewHeight:
    case MessageName::WebPage_SetBackgroundColor:
    case MessageName::WebPage_SetBackgroundExtendsBeyondPage:
    case MessageName::WebPage_SetBaseWritingDirection:
    case MessageName::WebPage_SetCanRunBeforeUnloadConfirmPanel:
    case MessageName::WebPage_SetCanRunModal:
    case MessageName::WebPage_SetCanShowPlaceholder:
    case MessageName::WebPage_SetCanUseCredentialStorage:
    case MessageName::WebPage_SetCompositionAsync:
    case MessageName::WebPage_SetControlledByAutomation:
    case MessageName::WebPage_SetCroppedImageOverlayVisibility:
    case MessageName::WebPage_SetCurrentHistoryItemForReattach:
    case MessageName::WebPage_SetCustomTextEncodingName:
    case MessageName::WebPage_SetDefersLoading:
    case MessageName::WebPage_SetDeviceOrientation:
    case MessageName::WebPage_SetEditable:
    case MessageName::WebPage_SetEnableHorizontalRubberBanding:
    case MessageName::WebPage_SetEnableVerticalRubberBanding:
    case MessageName::WebPage_SetFixedLayoutSize:
    case MessageName::WebPage_SetFocusedElementSelectedIndex:
    case MessageName::WebPage_SetFocusedElementValue:
    case MessageName::WebPage_SetFooterBannerHeightForTesting:
    case MessageName::WebPage_SetForceAlwaysUserScalable:
    case MessageName::WebPage_SetGapBetweenPages:
    case MessageName::WebPage_SetHasResourceLoadClient:
    case MessageName::WebPage_SetHeaderBannerHeightForTesting:
    case MessageName::WebPage_SetIndicating:
    case MessageName::WebPage_SetInitialFocus:
    case MessageName::WebPage_SetIsShowingInputViewForFocusedElement:
    case MessageName::WebPage_SetIsSuspended:
    case MessageName::WebPage_SetIsTakingSnapshotsForApplicationSuspension:
    case MessageName::WebPage_SetLayerHostingMode:
    case MessageName::WebPage_SetMainFrameIsScrollable:
    case MessageName::WebPage_SetMaximumUnobscuredSize:
    case MessageName::WebPage_SetMayStartMediaWhenInWindow:
    case MessageName::WebPage_SetMediaVolume:
    case MessageName::WebPage_SetMinimumSizeForAutoLayout:
    case MessageName::WebPage_SetMinimumUnobscuredSize:
    case MessageName::WebPage_SetMockCameraIsInterrupted:
    case MessageName::WebPage_SetMuted:
    case MessageName::WebPage_SetNeedsDOMWindowResizeEvent:
    case MessageName::WebPage_SetNeedsFontAttributes:
    case MessageName::WebPage_SetOrientationForMediaCapture:
    case MessageName::WebPage_SetOverriddenMediaType:
    case MessageName::WebPage_SetOverrideViewportArguments:
    case MessageName::WebPage_SetPageAndTextZoomFactors:
    case MessageName::WebPage_SetPageLength:
    case MessageName::WebPage_SetPageZoomFactor:
    case MessageName::WebPage_SetPaginationBehavesLikeColumns:
    case MessageName::WebPage_SetPaginationLineGridEnabled:
    case MessageName::WebPage_SetPaginationMode:
    case MessageName::WebPage_SetScreenIsBeingCaptured:
    case MessageName::WebPage_SetScrollPinningBehavior:
    case MessageName::WebPage_SetScrollbarOverlayStyle:
    case MessageName::WebPage_SetShouldDispatchFakeMouseMoveEvents:
    case MessageName::WebPage_SetShouldPlayToPlaybackTarget:
    case MessageName::WebPage_SetShouldRevealCurrentSelectionAfterInsertion:
    case MessageName::WebPage_SetShouldScaleViewToFitDocument:
    case MessageName::WebPage_SetSizeToContentAutoSizeMaximumSize:
    case MessageName::WebPage_SetSmartInsertDeleteEnabled:
    case MessageName::WebPage_SetSuppressScrollbarAnimations:
    case MessageName::WebPage_SetTextAsync:
    case MessageName::WebPage_SetTextForActivePopupMenu:
    case MessageName::WebPage_SetTextZoomFactor:
    case MessageName::WebPage_SetTopContentInset:
    case MessageName::WebPage_SetTopContentInsetFenced:
    case MessageName::WebPage_SetUnderPageBackgroundColorOverride:
    case MessageName::WebPage_SetUnderlayColor:
    case MessageName::WebPage_SetUseFixedLayout:
    case MessageName::WebPage_SetUseIconLoadingClient:
    case MessageName::WebPage_SetUseSystemAppearance:
    case MessageName::WebPage_SetUserAgent:
    case MessageName::WebPage_SetUserInterfaceLayoutDirection:
    case MessageName::WebPage_SetViewportConfigurationViewLayoutSize:
    case MessageName::WebPage_SetViewportSizeForCSSViewportUnits:
    case MessageName::WebPage_SimulateDeviceOrientationChange:
    case MessageName::WebPage_SpeakingErrorOccurred:
    case MessageName::WebPage_StartAutoscrollAtPosition:
    case MessageName::WebPage_StartImageAnalysis:
    case MessageName::WebPage_StartInteractionWithElementContextOrPosition:
    case MessageName::WebPage_StartTextManipulations:
    case MessageName::WebPage_StopInteraction:
    case MessageName::WebPage_StopLoading:
    case MessageName::WebPage_StopLoadingFrame:
    case MessageName::WebPage_StopMediaCapture:
    case MessageName::WebPage_StoreSelectionForAccessibility:
    case MessageName::WebPage_Suspend:
    case MessageName::WebPage_SuspendActiveDOMObjectsAndAnimations:
    case MessageName::WebPage_SuspendAllMediaPlayback:
    case MessageName::WebPage_SystemPreviewActionTriggered:
    case MessageName::WebPage_TakeSnapshot:
    case MessageName::WebPage_TapHighlightAtPosition:
    case MessageName::WebPage_TextInputContextsInRect:
    case MessageName::WebPage_TouchEvent:
    case MessageName::WebPage_TouchWithIdentifierWasRemoved:
    case MessageName::WebPage_TryClose:
    case MessageName::WebPage_TryRestoreScrollPosition:
    case MessageName::WebPage_URLSchemeTaskDidComplete:
    case MessageName::WebPage_URLSchemeTaskDidPerformRedirection:
    case MessageName::WebPage_URLSchemeTaskDidReceiveData:
    case MessageName::WebPage_URLSchemeTaskDidReceiveResponse:
    case MessageName::WebPage_URLSchemeTaskWillPerformRedirection:
    case MessageName::WebPage_UnapplyEditCommand:
    case MessageName::WebPage_UnfreezeLayerTreeDueToSwipeAnimation:
    case MessageName::WebPage_UpdateAttachmentAttributes:
    case MessageName::WebPage_UpdateAttachmentIcon:
    case MessageName::WebPage_UpdateAttachmentThumbnail:
    case MessageName::WebPage_UpdateBackForwardListForReattach:
    case MessageName::WebPage_UpdateCORSDisablingPatterns:
    case MessageName::WebPage_UpdateCurrentModifierState:
    case MessageName::WebPage_UpdateSelectionWithDelta:
    case MessageName::WebPage_UpdateSelectionWithExtentPoint:
    case MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary:
    case MessageName::WebPage_UpdateSelectionWithTouches:
    case MessageName::WebPage_UpdateWebsitePolicies:
    case MessageName::WebPage_UpdateWithTextRecognitionResult:
    case MessageName::WebPage_UppercaseWord:
    case MessageName::WebPage_UserMediaAccessWasDenied:
    case MessageName::WebPage_UserMediaAccessWasGranted:
    case MessageName::WebPage_ValidateCommand:
    case MessageName::WebPage_ViewWillEndLiveResize:
    case MessageName::WebPage_ViewWillStartLiveResize:
    case MessageName::WebPage_VoicesDidChange:
    case MessageName::WebPage_WasLoadedWithDataTransferFromPrevalentResource:
    case MessageName::WebPage_WillStartUserTriggeredZooming:
    case MessageName::WebPage_WindowAndViewFramesChanged:
    case MessageName::WebPage_WindowScreenDidChange:
    case MessageName::WebPage_ZoomPDFIn:
    case MessageName::WebPage_ZoomPDFOut:
        return ReceiverName::WebPage;
    case MessageName::WebPasteboardProxy_ClearClipboard:
    case MessageName::WebPasteboardProxy_UpdateSupportedTypeIdentifiers:
    case MessageName::WebPasteboardProxy_WriteImageToPasteboard:
    case MessageName::WebPasteboardProxy_WriteStringToPasteboard:
    case MessageName::WebPasteboardProxy_WriteToClipboard:
    case MessageName::WebPasteboardProxy_WriteURLToPasteboard:
    case MessageName::WebPasteboardProxy_WriteWebContentToPasteboard:
        return ReceiverName::WebPasteboardProxy;
    case MessageName::WebProcessPool_HandleMessage:
    case MessageName::WebProcessPool_ReportWebContentCPUTime:
    case MessageName::WebProcessPool_StartedUsingGamepads:
    case MessageName::WebProcessPool_StoppedUsingGamepads:
        return ReceiverName::WebProcessPool;
    case MessageName::WebProcessProxy_CacheMediaMIMETypes:
    case MessageName::WebProcessProxy_CreateSpeechRecognitionServer:
    case MessageName::WebProcessProxy_DestroySpeechRecognitionServer:
    case MessageName::WebProcessProxy_DidCollectPrewarmInformation:
    case MessageName::WebProcessProxy_DidCreateSleepDisabler:
    case MessageName::WebProcessProxy_DidDestroyFrame:
    case MessageName::WebProcessProxy_DidDestroySleepDisabler:
    case MessageName::WebProcessProxy_DidDestroyUserGestureToken:
    case MessageName::WebProcessProxy_DidExceedActiveMemoryLimit:
    case MessageName::WebProcessProxy_DidExceedCPULimit:
    case MessageName::WebProcessProxy_DidExceedInactiveMemoryLimit:
    case MessageName::WebProcessProxy_DidExceedInactiveMemoryLimitWhileActive:
    case MessageName::WebProcessProxy_DidReceiveBackgroundResponsivenessPing:
    case MessageName::WebProcessProxy_DisableSuddenTermination:
    case MessageName::WebProcessProxy_EnableSuddenTermination:
    case MessageName::WebProcessProxy_MemoryPressureStatusChanged:
    case MessageName::WebProcessProxy_ReleaseHighPerformanceGPU:
    case MessageName::WebProcessProxy_RequestHighPerformanceGPU:
    case MessageName::WebProcessProxy_SendMessageToWebContext:
    case MessageName::WebProcessProxy_SendMessageToWebContextWithReply:
    case MessageName::WebProcessProxy_SetCaptionDisplayMode:
    case MessageName::WebProcessProxy_SetCaptionLanguage:
    case MessageName::WebProcessProxy_SetDisplayLinkPreferredFramesPerSecond:
    case MessageName::WebProcessProxy_SetIsHoldingLockedFiles:
    case MessageName::WebProcessProxy_StartDisplayLink:
    case MessageName::WebProcessProxy_StopDisplayLink:
    case MessageName::WebProcessProxy_StopResponsivenessTimer:
    case MessageName::WebProcessProxy_SystemBeep:
    case MessageName::WebProcessProxy_UpdateBackForwardItem:
        return ReceiverName::WebProcessProxy;
    case MessageName::WebProcess_AccessibilityPreferencesDidChange:
    case MessageName::WebProcess_AddMockMediaDevice:
    case MessageName::WebProcess_BackgroundResponsivenessPing:
    case MessageName::WebProcess_BacklightLevelDidChange:
    case MessageName::WebProcess_ClearCachedPage:
    case MessageName::WebProcess_ClearCurrentModifierStateForTesting:
    case MessageName::WebProcess_ClearMockMediaDevices:
    case MessageName::WebProcess_ClearResourceLoadStatistics:
    case MessageName::WebProcess_ColorPreferencesDidChange:
    case MessageName::WebProcess_ConsumeAudioComponentRegistrations:
    case MessageName::WebProcess_CreateWebPage:
    case MessageName::WebProcess_DeleteWebsiteData:
    case MessageName::WebProcess_DeleteWebsiteDataForOrigins:
    case MessageName::WebProcess_DestroyAutomationSessionProxy:
    case MessageName::WebProcess_DidWriteToPasteboardAsynchronously:
    case MessageName::WebProcess_DisplayConfigurationChanged:
    case MessageName::WebProcess_DisplayWasRefreshed:
    case MessageName::WebProcess_EnableRemoteWebInspector:
    case MessageName::WebProcess_EnsureAutomationSessionProxy:
    case MessageName::WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcess:
    case MessageName::WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcess:
    case MessageName::WebProcess_FetchWebsiteData:
    case MessageName::WebProcess_FullKeyboardAccessModeChanged:
    case MessageName::WebProcess_GamepadConnected:
    case MessageName::WebProcess_GamepadDisconnected:
    case MessageName::WebProcess_GarbageCollectJavaScriptObjects:
    case MessageName::WebProcess_GetActivePagesOriginsForTesting:
    case MessageName::WebProcess_GrantAccessToAssetServices:
    case MessageName::WebProcess_GrantUserMediaDeviceSandboxExtensions:
    case MessageName::WebProcess_HandleInjectedBundleMessage:
    case MessageName::WebProcess_InitializeWebProcess:
    case MessageName::WebProcess_IsJITEnabled:
    case MessageName::WebProcess_MarkIsNoLongerPrewarmed:
    case MessageName::WebProcess_NotifyPreferencesChanged:
    case MessageName::WebProcess_PowerSourceDidChange:
    case MessageName::WebProcess_PrepareToSuspend:
    case MessageName::WebProcess_PrewarmWithDomainInformation:
    case MessageName::WebProcess_ProcessDidResume:
    case MessageName::WebProcess_RefreshPlugins:
    case MessageName::WebProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy:
    case MessageName::WebProcess_RegisterURLSchemeAsCORSEnabled:
    case MessageName::WebProcess_RegisterURLSchemeAsCachePartitioned:
    case MessageName::WebProcess_RegisterURLSchemeAsCanDisplayOnlyIfCanRequest:
    case MessageName::WebProcess_RegisterURLSchemeAsDisplayIsolated:
    case MessageName::WebProcess_RegisterURLSchemeAsEmptyDocument:
    case MessageName::WebProcess_RegisterURLSchemeAsLocal:
    case MessageName::WebProcess_RegisterURLSchemeAsNoAccess:
    case MessageName::WebProcess_RegisterURLSchemeAsSecure:
    case MessageName::WebProcess_RemoveMockMediaDevice:
    case MessageName::WebProcess_ResetMockMediaDevices:
    case MessageName::WebProcess_RevokeAccessToAssetServices:
    case MessageName::WebProcess_RevokeUserMediaDeviceSandboxExtensions:
    case MessageName::WebProcess_ScrollerStylePreferenceChanged:
    case MessageName::WebProcess_SeedResourceLoadStatisticsForTesting:
    case MessageName::WebProcess_SendMessageToWebExtension:
    case MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately:
    case MessageName::WebProcess_SetAlwaysUsesComplexTextCodePath:
    case MessageName::WebProcess_SetBackForwardCacheCapacity:
    case MessageName::WebProcess_SetCacheModel:
    case MessageName::WebProcess_SetDefaultRequestTimeoutInterval:
    case MessageName::WebProcess_SetDomainRelaxationForbiddenForURLScheme:
    case MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess:
    case MessageName::WebProcess_SetDomainsWithUserInteraction:
    case MessageName::WebProcess_SetEnabledServices:
    case MessageName::WebProcess_SetEnhancedAccessibility:
    case MessageName::WebProcess_SetHasMouseDevice:
    case MessageName::WebProcess_SetHasStylusDevice:
    case MessageName::WebProcess_SetHasSuspendedPageProxy:
    case MessageName::WebProcess_SetHiddenPageDOMTimerThrottlingIncreaseLimit:
    case MessageName::WebProcess_SetInitialGamepads:
    case MessageName::WebProcess_SetInjectedBundleParameter:
    case MessageName::WebProcess_SetInjectedBundleParameters:
    case MessageName::WebProcess_SetIsInProcessCache:
    case MessageName::WebProcess_SetJavaScriptGarbageCollectorTimerEnabled:
    case MessageName::WebProcess_SetMediaAccessibilityPreferences:
    case MessageName::WebProcess_SetMediaMIMETypes:
    case MessageName::WebProcess_SetMemoryCacheDisabled:
    case MessageName::WebProcess_SetResourceLoadStatisticsEnabled:
    case MessageName::WebProcess_SetScreenProperties:
    case MessageName::WebProcess_SetShouldUseFontSmoothing:
    case MessageName::WebProcess_SetTextCheckerState:
    case MessageName::WebProcess_SetThirdPartyCookieBlockingMode:
    case MessageName::WebProcess_SetUseSystemAppearanceForScrollbars:
    case MessageName::WebProcess_SetWebsiteDataStoreParameters:
    case MessageName::WebProcess_StartMemorySampler:
    case MessageName::WebProcess_StopMemorySampler:
    case MessageName::WebProcess_SwitchFromStaticFontRegistryToUserFontRegistry:
    case MessageName::WebProcess_SystemDidWake:
    case MessageName::WebProcess_SystemWillPowerOn:
    case MessageName::WebProcess_SystemWillSleep:
    case MessageName::WebProcess_UnblockPreferenceService:
    case MessageName::WebProcess_UnblockServicesRequiredByAccessibility:
    case MessageName::WebProcess_UserInterfaceIdiomDidChange:
    case MessageName::WebProcess_UserPreferredLanguagesChanged:
        return ReceiverName::WebProcess;
    case MessageName::WebRTCMonitor_NetworksChanged:
        return ReceiverName::WebRTCMonitor;
    case MessageName::WebRTCResolver_ResolvedAddressError:
    case MessageName::WebRTCResolver_SetResolvedAddress:
        return ReceiverName::WebRTCResolver;
    case MessageName::WebResourceLoader_CancelMainResourceLoadForContentFilter:
    case MessageName::WebResourceLoader_ContentFilterDidBlockLoad:
    case MessageName::WebResourceLoader_DidBlockAuthenticationChallenge:
    case MessageName::WebResourceLoader_DidFailResourceLoad:
    case MessageName::WebResourceLoader_DidFailServiceWorkerLoad:
    case MessageName::WebResourceLoader_DidFinishResourceLoad:
    case MessageName::WebResourceLoader_DidReceiveData:
    case MessageName::WebResourceLoader_DidReceiveResource:
    case MessageName::WebResourceLoader_DidReceiveResponse:
    case MessageName::WebResourceLoader_DidSendData:
    case MessageName::WebResourceLoader_HandleProvisionalLoadFailureFromContentFilter:
    case MessageName::WebResourceLoader_ServiceWorkerDidNotHandle:
    case MessageName::WebResourceLoader_StopLoadingAfterXFrameOptionsOrContentSecurityPolicyDenied:
    case MessageName::WebResourceLoader_WillSendRequest:
        return ReceiverName::WebResourceLoader;
    case MessageName::WebSWClientConnection_FireUpdateFoundEvent:
    case MessageName::WebSWClientConnection_JobRejectedInServer:
    case MessageName::WebSWClientConnection_NotifyClientsOfControllerChange:
    case MessageName::WebSWClientConnection_PostMessageToServiceWorkerClient:
    case MessageName::WebSWClientConnection_RegistrationJobResolvedInServer:
    case MessageName::WebSWClientConnection_SetDocumentIsControlled:
    case MessageName::WebSWClientConnection_SetRegistrationLastUpdateTime:
    case MessageName::WebSWClientConnection_SetRegistrationUpdateViaCache:
    case MessageName::WebSWClientConnection_SetSWOriginTableIsImported:
    case MessageName::WebSWClientConnection_SetSWOriginTableSharedMemory:
    case MessageName::WebSWClientConnection_StartScriptFetchForServer:
    case MessageName::WebSWClientConnection_UpdateRegistrationState:
    case MessageName::WebSWClientConnection_UpdateWorkerState:
        return ReceiverName::WebSWClientConnection;
    case MessageName::WebSWContextManagerConnection_CancelFetch:
    case MessageName::WebSWContextManagerConnection_Close:
    case MessageName::WebSWContextManagerConnection_ContinueDidReceiveFetchResponse:
    case MessageName::WebSWContextManagerConnection_ConvertFetchToDownload:
    case MessageName::WebSWContextManagerConnection_DidSaveScriptsToDisk:
    case MessageName::WebSWContextManagerConnection_FireActivateEvent:
    case MessageName::WebSWContextManagerConnection_FireInstallEvent:
    case MessageName::WebSWContextManagerConnection_FirePushEvent:
    case MessageName::WebSWContextManagerConnection_InstallServiceWorker:
    case MessageName::WebSWContextManagerConnection_MatchAllCompleted:
    case MessageName::WebSWContextManagerConnection_PostMessageToServiceWorker:
    case MessageName::WebSWContextManagerConnection_SetThrottleState:
    case MessageName::WebSWContextManagerConnection_SetUserAgent:
    case MessageName::WebSWContextManagerConnection_StartFetch:
    case MessageName::WebSWContextManagerConnection_TerminateWorker:
    case MessageName::WebSWContextManagerConnection_UpdateAppInitiatedValue:
    case MessageName::WebSWContextManagerConnection_UpdatePreferencesStore:
        return ReceiverName::WebSWContextManagerConnection;
    case MessageName::WebSWServerConnection_AddServiceWorkerRegistrationInServer:
    case MessageName::WebSWServerConnection_DidResolveRegistrationPromise:
    case MessageName::WebSWServerConnection_DisableNavigationPreload:
    case MessageName::WebSWServerConnection_EnableNavigationPreload:
    case MessageName::WebSWServerConnection_FinishFetchingScriptInServer:
    case MessageName::WebSWServerConnection_GetNavigationPreloadState:
    case MessageName::WebSWServerConnection_GetPushPermissionState:
    case MessageName::WebSWServerConnection_GetPushSubscription:
    case MessageName::WebSWServerConnection_GetRegistrations:
    case MessageName::WebSWServerConnection_MatchRegistration:
    case MessageName::WebSWServerConnection_PostMessageToServiceWorker:
    case MessageName::WebSWServerConnection_RegisterServiceWorkerClient:
    case MessageName::WebSWServerConnection_RemoveServiceWorkerRegistrationInServer:
    case MessageName::WebSWServerConnection_ScheduleJobInServer:
    case MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer:
    case MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue:
    case MessageName::WebSWServerConnection_SetThrottleState:
    case MessageName::WebSWServerConnection_StoreRegistrationsOnDisk:
    case MessageName::WebSWServerConnection_SubscribeToPushService:
    case MessageName::WebSWServerConnection_TerminateWorkerFromClient:
    case MessageName::WebSWServerConnection_UnregisterServiceWorkerClient:
    case MessageName::WebSWServerConnection_UnsubscribeFromPushService:
    case MessageName::WebSWServerConnection_WhenRegistrationReady:
    case MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting:
        return ReceiverName::WebSWServerConnection;
    case MessageName::WebSWServerToContextConnection_Claim:
    case MessageName::WebSWServerToContextConnection_DidFailHeartBeatCheck:
    case MessageName::WebSWServerToContextConnection_DidFinishActivation:
    case MessageName::WebSWServerToContextConnection_DidFinishInstall:
    case MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier:
    case MessageName::WebSWServerToContextConnection_MatchAll:
    case MessageName::WebSWServerToContextConnection_PostMessageToServiceWorkerClient:
    case MessageName::WebSWServerToContextConnection_ScriptContextFailedToStart:
    case MessageName::WebSWServerToContextConnection_ScriptContextStarted:
    case MessageName::WebSWServerToContextConnection_SetScriptResource:
    case MessageName::WebSWServerToContextConnection_SetServiceWorkerHasPendingEvents:
    case MessageName::WebSWServerToContextConnection_SkipWaiting:
    case MessageName::WebSWServerToContextConnection_WorkerTerminated:
        return ReceiverName::WebSWServerToContextConnection;
    case MessageName::WebSharedWorkerContextManagerConnection_Close:
    case MessageName::WebSharedWorkerContextManagerConnection_LaunchSharedWorker:
    case MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent:
    case MessageName::WebSharedWorkerContextManagerConnection_SetUserAgent:
    case MessageName::WebSharedWorkerContextManagerConnection_TerminateSharedWorker:
    case MessageName::WebSharedWorkerContextManagerConnection_UpdatePreferencesStore:
        return ReceiverName::WebSharedWorkerContextManagerConnection;
    case MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient:
    case MessageName::WebSharedWorkerObjectConnection_NotifyWorkerObjectOfLoadCompletion:
    case MessageName::WebSharedWorkerObjectConnection_PostExceptionToWorkerObject:
        return ReceiverName::WebSharedWorkerObjectConnection;
    case MessageName::WebSharedWorkerServerConnection_RequestSharedWorker:
    case MessageName::WebSharedWorkerServerConnection_SharedWorkerObjectIsGoingAway:
        return ReceiverName::WebSharedWorkerServerConnection;
    case MessageName::WebSharedWorkerServerToContextConnection_PostExceptionToWorkerObject:
        return ReceiverName::WebSharedWorkerServerToContextConnection;
    case MessageName::WebSocketChannel_DidClose:
    case MessageName::WebSocketChannel_DidConnect:
    case MessageName::WebSocketChannel_DidReceiveBinaryData:
    case MessageName::WebSocketChannel_DidReceiveHandshakeResponse:
    case MessageName::WebSocketChannel_DidReceiveMessageError:
    case MessageName::WebSocketChannel_DidReceiveText:
    case MessageName::WebSocketChannel_DidSendHandshakeRequest:
        return ReceiverName::WebSocketChannel;
    case MessageName::WebSocketStream_DidCloseSocketStream:
    case MessageName::WebSocketStream_DidFailSocketStream:
    case MessageName::WebSocketStream_DidFailToReceiveSocketStreamData:
    case MessageName::WebSocketStream_DidOpenSocketStream:
    case MessageName::WebSocketStream_DidReceiveSocketStreamData:
    case MessageName::WebSocketStream_DidSendData:
    case MessageName::WebSocketStream_DidSendHandshake:
    case MessageName::WebSocketStream_DidUpdateBufferedAmount:
        return ReceiverName::WebSocketStream;
    case MessageName::WebSpeechRecognitionConnection_DidReceiveUpdate:
        return ReceiverName::WebSpeechRecognitionConnection;
    case MessageName::WebUserContentControllerProxy_DidPostMessage:
        return ReceiverName::WebUserContentControllerProxy;
    case MessageName::WebUserContentController_AddContentRuleLists:
    case MessageName::WebUserContentController_AddContentWorlds:
    case MessageName::WebUserContentController_AddUserScriptMessageHandlers:
    case MessageName::WebUserContentController_AddUserScripts:
    case MessageName::WebUserContentController_AddUserStyleSheets:
    case MessageName::WebUserContentController_RemoveAllContentRuleLists:
    case MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlers:
    case MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlersForWorlds:
    case MessageName::WebUserContentController_RemoveAllUserScripts:
    case MessageName::WebUserContentController_RemoveAllUserStyleSheets:
    case MessageName::WebUserContentController_RemoveContentRuleList:
    case MessageName::WebUserContentController_RemoveContentWorlds:
    case MessageName::WebUserContentController_RemoveUserScript:
    case MessageName::WebUserContentController_RemoveUserScriptMessageHandler:
    case MessageName::WebUserContentController_RemoveUserStyleSheet:
        return ReceiverName::WebUserContentController;
    case MessageName::InitializeConnection:
    case MessageName::LegacySessionState:
    case MessageName::ProcessOutOfStreamMessage:
    case MessageName::SetStreamDestinationID:
    case MessageName::SyncMessageReply:
    case MessageName::Terminate:
        return ReceiverName::IPC;
    case MessageName::AuxiliaryProcess_MainThreadPingReply:
    case MessageName::CacheStorageEngineConnection_CachesReply:
    case MessageName::CacheStorageEngineConnection_ClearMemoryRepresentationReply:
    case MessageName::CacheStorageEngineConnection_DeleteMatchingRecordsReply:
    case MessageName::CacheStorageEngineConnection_EngineRepresentationReply:
    case MessageName::CacheStorageEngineConnection_OpenReply:
    case MessageName::CacheStorageEngineConnection_PutRecordsReply:
    case MessageName::CacheStorageEngineConnection_RemoveReply:
    case MessageName::CacheStorageEngineConnection_RetrieveRecordsReply:
    case MessageName::DownloadProxy_DecideDestinationWithSuggestedFilenameReply:
    case MessageName::EventDispatcher_TouchEventReply:
    case MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategoryReply:
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcessReply:
    case MessageName::GPUProcess_PrepareToSuspendReply:
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTimeReply:
    case MessageName::GPUProcess_ShowScreenPickerReply:
    case MessageName::GPUProcess_ShowWindowPickerReply:
    case MessageName::GPUProcess_UpdateCaptureAccessReply:
    case MessageName::GPUProcess_WebProcessConnectionCountForTestingReply:
    case MessageName::MediaPlayerPrivateRemote_GetRawCookiesReply:
    case MessageName::MediaPlayerPrivateRemote_RequestResourceReply:
    case MessageName::MediaPlayerPrivateRemote_SendH2PingReply:
    case MessageName::NetworkBroadcastChannelRegistry_PostMessageReply:
    case MessageName::NetworkConnectionToWebProcess_CheckRemotePortForActivityReply:
    case MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSourceReply:
    case MessageName::NetworkConnectionToWebProcess_CreateRTCProviderReply:
    case MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnectionReply:
    case MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnectionReply:
    case MessageName::NetworkConnectionToWebProcess_GetProcessDisplayNameReply:
    case MessageName::NetworkConnectionToWebProcess_HasStorageAccessReply:
    case MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinishedReply:
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccessReply:
    case MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdatedReply:
    case MessageName::NetworkConnectionToWebProcess_SendH2PingReply:
    case MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPortReply:
    case MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDBReply:
    case MessageName::NetworkProcessConnection_CheckProcessLocalPortForActivityReply:
    case MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSourceReply:
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomainsReply:
    case MessageName::NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcessReply:
    case MessageName::NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcessReply:
    case MessageName::NetworkProcessProxy_GetAppBoundDomainsReply:
    case MessageName::NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentationReply:
    case MessageName::NetworkProcessProxy_RequestStorageAccessConfirmReply:
    case MessageName::NetworkProcessProxy_RequestStorageSpaceReply:
    case MessageName::NetworkProcessProxy_RetrieveCacheStorageParametersReply:
    case MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccessReply:
    case MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigationReply:
    case MessageName::NetworkProcess_AppPrivacyReportTestingDataReply:
    case MessageName::NetworkProcess_CancelDownloadReply:
    case MessageName::NetworkProcess_ClearAppBoundSessionReply:
    case MessageName::NetworkProcess_ClearAppPrivacyReportTestingDataReply:
    case MessageName::NetworkProcess_ClearBundleIdentifierReply:
    case MessageName::NetworkProcess_ClearPrevalentResourceReply:
    case MessageName::NetworkProcess_ClearPrivateClickMeasurementReply:
    case MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverrideReply:
    case MessageName::NetworkProcess_ClearStorageReply:
    case MessageName::NetworkProcess_ClearUserInteractionReply:
    case MessageName::NetworkProcess_CloseITPDatabaseReply:
    case MessageName::NetworkProcess_ClosePCMDatabaseReply:
    case MessageName::NetworkProcess_CountNonDefaultSessionSetsReply:
    case MessageName::NetworkProcess_CreateNetworkConnectionToWebProcessReply:
    case MessageName::NetworkProcess_DeleteCookiesForTestingReply:
    case MessageName::NetworkProcess_DeletePushAndNotificationRegistrationReply:
    case MessageName::NetworkProcess_DeleteWebsiteDataForOriginsReply:
    case MessageName::NetworkProcess_DeleteWebsiteDataReply:
    case MessageName::NetworkProcess_DomainIDExistsInDatabaseReply:
    case MessageName::NetworkProcess_DumpPrivateClickMeasurementReply:
    case MessageName::NetworkProcess_DumpResourceLoadStatisticsReply:
    case MessageName::NetworkProcess_FetchWebsiteDataReply:
    case MessageName::NetworkProcess_FlushCookiesReply:
    case MessageName::NetworkProcess_GetAllStorageAccessEntriesReply:
    case MessageName::NetworkProcess_GetOriginsWithPushAndNotificationPermissionsReply:
    case MessageName::NetworkProcess_GetPendingPushMessagesReply:
    case MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummaryReply:
    case MessageName::NetworkProcess_HadUserInteractionReply:
    case MessageName::NetworkProcess_HasAppBoundSessionReply:
    case MessageName::NetworkProcess_HasIsolatedSessionReply:
    case MessageName::NetworkProcess_HasLocalStorageReply:
    case MessageName::NetworkProcess_InsertExpiredStatisticForTestingReply:
    case MessageName::NetworkProcess_IsGrandfatheredReply:
    case MessageName::NetworkProcess_IsPrevalentResourceReply:
    case MessageName::NetworkProcess_IsRegisteredAsRedirectingToReply:
    case MessageName::NetworkProcess_IsRegisteredAsSubFrameUnderReply:
    case MessageName::NetworkProcess_IsRegisteredAsSubresourceUnderReply:
    case MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnceReply:
    case MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeralReply:
    case MessageName::NetworkProcess_IsVeryPrevalentResourceReply:
    case MessageName::NetworkProcess_LogUserInteractionReply:
    case MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTestingReply:
    case MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTestingReply:
    case MessageName::NetworkProcess_MergeStatisticForTestingReply:
    case MessageName::NetworkProcess_PrepareToSuspendReply:
    case MessageName::NetworkProcess_ProcessPushMessageReply:
    case MessageName::NetworkProcess_RenameOriginInWebsiteDataReply:
    case MessageName::NetworkProcess_RequestResourceReply:
    case MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResourcesReply:
    case MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTestingReply:
    case MessageName::NetworkProcess_ResetParametersToDefaultValuesReply:
    case MessageName::NetworkProcess_ResetQuotaReply:
    case MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistentReply:
    case MessageName::NetworkProcess_ScheduleCookieBlockingUpdateReply:
    case MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessingReply:
    case MessageName::NetworkProcess_SetAgeCapForClientSideCookiesReply:
    case MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatisticsReply:
    case MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResourcesReply:
    case MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTestingReply:
    case MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTestingReply:
    case MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTestingReply:
    case MessageName::NetworkProcess_SetGrandfatheredReply:
    case MessageName::NetworkProcess_SetGrandfatheringTimeReply:
    case MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTestReply:
    case MessageName::NetworkProcess_SetLastSeenReply:
    case MessageName::NetworkProcess_SetMaxStatisticsEntriesReply:
    case MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemovalReply:
    case MessageName::NetworkProcess_SetNotifyPagesWhenDataRecordsWereScannedReply:
    case MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTestingReply:
    case MessageName::NetworkProcess_SetPrevalentResourceForDebugModeReply:
    case MessageName::NetworkProcess_SetPrevalentResourceReply:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTestingReply:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTestingReply:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTestingReply:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTestingReply:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTestingReply:
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTestingReply:
    case MessageName::NetworkProcess_SetPruneEntriesDownToReply:
    case MessageName::NetworkProcess_SetResourceLoadStatisticsDebugModeReply:
    case MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemovalReply:
    case MessageName::NetworkProcess_SetShouldDowngradeReferrerForTestingReply:
    case MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTestingReply:
    case MessageName::NetworkProcess_SetSubframeUnderTopFrameDomainReply:
    case MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomainReply:
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectFromReply:
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectToReply:
    case MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTestingReply:
    case MessageName::NetworkProcess_SetThirdPartyCookieBlockingModeReply:
    case MessageName::NetworkProcess_SetTimeToLiveUserInteractionReply:
    case MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTestingReply:
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectFromReply:
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectToReply:
    case MessageName::NetworkProcess_SetVeryPrevalentResourceReply:
    case MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestartReply:
    case MessageName::NetworkProcess_StatisticsDatabaseHasAllTablesReply:
    case MessageName::NetworkProcess_SyncLocalStorageReply:
    case MessageName::NetworkProcess_UpdateBundleIdentifierReply:
    case MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesForReply:
    case MessageName::NetworkSocketChannel_SendDataReply:
    case MessageName::NetworkSocketChannel_SendStringReply:
    case MessageName::NetworkStorageManager_ClearReply:
    case MessageName::NetworkStorageManager_CloseSyncAccessHandleReply:
    case MessageName::NetworkStorageManager_ConnectToStorageAreaReply:
    case MessageName::NetworkStorageManager_CreateSyncAccessHandleReply:
    case MessageName::NetworkStorageManager_FileSystemGetDirectoryReply:
    case MessageName::NetworkStorageManager_GetDirectoryHandleReply:
    case MessageName::NetworkStorageManager_GetFileHandleReply:
    case MessageName::NetworkStorageManager_GetFileReply:
    case MessageName::NetworkStorageManager_GetHandleNamesReply:
    case MessageName::NetworkStorageManager_GetHandleReply:
    case MessageName::NetworkStorageManager_IsSameEntryReply:
    case MessageName::NetworkStorageManager_MoveReply:
    case MessageName::NetworkStorageManager_PersistReply:
    case MessageName::NetworkStorageManager_PersistedReply:
    case MessageName::NetworkStorageManager_RemoveEntryReply:
    case MessageName::NetworkStorageManager_RemoveItemReply:
    case MessageName::NetworkStorageManager_ResolveReply:
    case MessageName::NetworkStorageManager_SetItemReply:
    case MessageName::NotificationManagerMessageHandler_RequestSystemNotificationPermissionReply:
    case MessageName::PlatformXRSystem_EnumerateImmersiveXRDevicesReply:
    case MessageName::PlatformXRSystem_RequestFrameReply:
    case MessageName::PlatformXRSystem_RequestPermissionOnSessionFeaturesReply:
    case MessageName::RemoteAudioDestinationManager_DeleteAudioDestinationReply:
    case MessageName::RemoteAudioDestinationManager_StartAudioDestinationReply:
    case MessageName::RemoteAudioDestinationManager_StopAudioDestinationReply:
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnitReply:
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfigurationReply:
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificateReply:
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSessionReply:
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSessionReply:
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionDataReply:
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicenseReply:
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicenseReply:
    case MessageName::RemoteCDMProxy_GetSupportedConfigurationReply:
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfigurationReply:
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfigurationReply:
    case MessageName::RemoteMediaPlayerProxy_DidLoadingProgressReply:
    case MessageName::RemoteMediaPlayerProxy_LoadMediaSourceReply:
    case MessageName::RemoteMediaPlayerProxy_LoadReply:
    case MessageName::RemoteMediaPlayerProxy_PerformTaskAtMediaTimeReply:
    case MessageName::RemoteMediaPlayerProxy_PrepareForPlaybackReply:
    case MessageName::RemoteMediaRecorderManager_CreateRecorderReply:
    case MessageName::RemoteMediaRecorder_FetchDataReply:
    case MessageName::RemoteMediaRecorder_PauseReply:
    case MessageName::RemoteMediaRecorder_ResumeReply:
    case MessageName::RemoteMediaRecorder_StopRecordingReply:
    case MessageName::RemoteMediaResourceManager_RedirectReceivedReply:
    case MessageName::RemoteMediaResourceManager_ResponseReceivedReply:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePauseReply:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlayReply:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekToReply:
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrackReply:
    case MessageName::RemoteMediaSessionCoordinatorProxy_JoinReply:
    case MessageName::RemoteMediaSessionCoordinator_PauseSessionReply:
    case MessageName::RemoteMediaSessionCoordinator_PlaySessionReply:
    case MessageName::RemoteMediaSessionCoordinator_SeekSessionToTimeReply:
    case MessageName::RemoteMediaSessionCoordinator_SetSessionTrackReply:
    case MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayerReply:
    case MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackIdReply:
    case MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackIDReply:
    case MessageName::RemoteSourceBufferProxy_RemoveCodedFramesReply:
    case MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegmentReply:
    case MessageName::StorageManagerSet_ClearReply:
    case MessageName::StorageManagerSet_RemoveItemReply:
    case MessageName::StorageManagerSet_SetItemReply:
    case MessageName::WebAutomationSessionProxy_ComputeElementLayoutReply:
    case MessageName::WebAutomationSessionProxy_DeleteCookieReply:
    case MessageName::WebAutomationSessionProxy_GetCookiesForFrameReply:
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNameReply:
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandleReply:
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinalReply:
    case MessageName::WebAutomationSessionProxy_ResolveParentFrameReply:
    case MessageName::WebAutomationSessionProxy_SelectOptionElementReply:
    case MessageName::WebAutomationSessionProxy_SetFilesForInputFileUploadReply:
    case MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshotReply:
    case MessageName::WebBroadcastChannelRegistry_PostMessageToRemoteReply:
    case MessageName::WebCookieManager_DeleteAllCookiesModifiedSinceReply:
    case MessageName::WebCookieManager_DeleteCookieReply:
    case MessageName::WebCookieManager_GetAllCookiesReply:
    case MessageName::WebCookieManager_GetCookiesReply:
    case MessageName::WebCookieManager_GetHTTPCookieAcceptPolicyReply:
    case MessageName::WebCookieManager_GetHostnamesWithCookiesReply:
    case MessageName::WebCookieManager_SetCookieReply:
    case MessageName::WebCookieManager_SetCookiesReply:
    case MessageName::WebCookieManager_SetHTTPCookieAcceptPolicyReply:
    case MessageName::WebLockRegistryProxy_AbortLockRequestReply:
    case MessageName::WebLockRegistryProxy_SnapshotReply:
    case MessageName::WebPageProxy_ClassifyModalContainerControlsReply:
    case MessageName::WebPageProxy_DecidePolicyForModalContainerReply:
    case MessageName::WebPageProxy_EnumerateMediaDevicesForFrameReply:
    case MessageName::WebPageProxy_ModelElementAnimationCurrentTimeReply:
    case MessageName::WebPageProxy_ModelElementAnimationDurationReply:
    case MessageName::WebPageProxy_ModelElementDidCreatePreviewReply:
    case MessageName::WebPageProxy_ModelElementGetCameraReply:
    case MessageName::WebPageProxy_ModelElementHasAudioReply:
    case MessageName::WebPageProxy_ModelElementIsLoopingAnimationReply:
    case MessageName::WebPageProxy_ModelElementIsMutedReply:
    case MessageName::WebPageProxy_ModelElementIsPlayingAnimationReply:
    case MessageName::WebPageProxy_ModelElementSetAnimationCurrentTimeReply:
    case MessageName::WebPageProxy_ModelElementSetAnimationIsPlayingReply:
    case MessageName::WebPageProxy_ModelElementSetCameraReply:
    case MessageName::WebPageProxy_ModelElementSetIsLoopingAnimationReply:
    case MessageName::WebPageProxy_ModelElementSetIsMutedReply:
    case MessageName::WebPageProxy_ModelElementSizeDidChangeReply:
    case MessageName::WebPageProxy_QueryPermissionReply:
    case MessageName::WebPageProxy_RequestCookieConsentReply:
    case MessageName::WebPageProxy_RequestNotificationPermissionReply:
    case MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrameReply:
    case MessageName::WebPageProxy_RequestTextRecognitionReply:
    case MessageName::WebPageProxy_SendMessageToWebViewWithReplyReply:
    case MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccessReply:
    case MessageName::WebPageProxy_ShowContactPickerReply:
    case MessageName::WebPageProxy_ShowEmojiPickerReply:
    case MessageName::WebPageProxy_ShowMediaControlsContextMenuReply:
    case MessageName::WebPageProxy_ShowShareSheetReply:
    case MessageName::WebPageProxy_SpeechSynthesisPauseReply:
    case MessageName::WebPageProxy_SpeechSynthesisResumeReply:
    case MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallbackReply:
    case MessageName::WebPageProxy_SpeechSynthesisSpeakReply:
    case MessageName::WebPageProxy_StartApplePayAMSUISessionReply:
    case MessageName::WebPage_ApplyAutocorrectionReply:
    case MessageName::WebPage_AttributedSubstringForCharacterRangeAsyncReply:
    case MessageName::WebPage_BeginSelectionInDirectionReply:
    case MessageName::WebPage_CharacterIndexForPointAsyncReply:
    case MessageName::WebPage_ClearServiceWorkerEntitlementOverrideReply:
    case MessageName::WebPage_CompleteTextManipulationReply:
    case MessageName::WebPage_ComputePagesForPrintingReply:
    case MessageName::WebPage_CreateMediaSessionCoordinatorReply:
    case MessageName::WebPage_DetectDataInAllFramesReply:
    case MessageName::WebPage_DidGetLoadDecisionForIconReply:
    case MessageName::WebPage_DispatchWheelEventWithoutScrollingReply:
    case MessageName::WebPage_DrawPagesForPrintingReply:
    case MessageName::WebPage_DrawPagesToPDFReply:
    case MessageName::WebPage_DrawRectToImageReply:
    case MessageName::WebPage_DrawToPDFReply:
    case MessageName::WebPage_DrawToPDFiOSReply:
    case MessageName::WebPage_ExecuteEditCommandWithCallbackReply:
    case MessageName::WebPage_ExtendSelectionReply:
    case MessageName::WebPage_FindRectsForStringMatchesReply:
    case MessageName::WebPage_FindStringReply:
    case MessageName::WebPage_FindTextRangesForStringMatchesReply:
    case MessageName::WebPage_FirstRectForCharacterRangeAsyncReply:
    case MessageName::WebPage_FocusNextFocusedElementReply:
    case MessageName::WebPage_FocusTextInputContextAndPlaceCaretReply:
    case MessageName::WebPage_ForceRepaintReply:
    case MessageName::WebPage_GetAllFramesReply:
    case MessageName::WebPage_GetApplicationManifestReply:
    case MessageName::WebPage_GetBytecodeProfileReply:
    case MessageName::WebPage_GetContentsAsAttributedStringReply:
    case MessageName::WebPage_GetContentsAsMHTMLDataReply:
    case MessageName::WebPage_GetContentsAsStringReply:
    case MessageName::WebPage_GetLoadedSubresourceDomainsReply:
    case MessageName::WebPage_GetMainResourceDataOfFrameReply:
    case MessageName::WebPage_GetMarkedRangeAsyncReply:
    case MessageName::WebPage_GetPDFFirstPageSizeReply:
    case MessageName::WebPage_GetProcessDisplayNameReply:
    case MessageName::WebPage_GetRectsAtSelectionOffsetWithTextReply:
    case MessageName::WebPage_GetRectsForGranularityWithSelectionOffsetReply:
    case MessageName::WebPage_GetRenderTreeExternalRepresentationReply:
    case MessageName::WebPage_GetResourceDataFromFrameReply:
    case MessageName::WebPage_GetSamplingProfilerOutputReply:
    case MessageName::WebPage_GetSelectedRangeAsyncReply:
    case MessageName::WebPage_GetSelectionAsWebArchiveDataReply:
    case MessageName::WebPage_GetSelectionContextReply:
    case MessageName::WebPage_GetSelectionOrContentsAsStringReply:
    case MessageName::WebPage_GetSourceForFrameReply:
    case MessageName::WebPage_GetWebArchiveOfFrameReply:
    case MessageName::WebPage_HasMarkedTextReply:
    case MessageName::WebPage_InsertAttachmentReply:
    case MessageName::WebPage_InsertDroppedImagePlaceholdersReply:
    case MessageName::WebPage_InsertTextPlaceholderReply:
    case MessageName::WebPage_InteractableRegionsInRootViewCoordinatesReply:
    case MessageName::WebPage_IsLayerTreeFrozenReply:
    case MessageName::WebPage_LastNavigationWasAppInitiatedReply:
    case MessageName::WebPage_MediaKeySystemWasGrantedReply:
    case MessageName::WebPage_MoveSelectionAtBoundaryWithDirectionReply:
    case MessageName::WebPage_MoveSelectionByOffsetReply:
    case MessageName::WebPage_OpenPDFWithPreviewReply:
    case MessageName::WebPage_PauseAllMediaPlaybackReply:
    case MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInViewReply:
    case MessageName::WebPage_RemoveDataDetectedLinksReply:
    case MessageName::WebPage_RemoveTextPlaceholderReply:
    case MessageName::WebPage_ReplaceMatchesReply:
    case MessageName::WebPage_RequestActiveNowPlayingSessionInfoReply:
    case MessageName::WebPage_RequestAutocorrectionDataReply:
    case MessageName::WebPage_RequestDictationContextReply:
    case MessageName::WebPage_RequestDocumentEditingContextReply:
    case MessageName::WebPage_RequestEvasionRectsAboveSelectionReply:
    case MessageName::WebPage_RequestFocusedElementInformationReply:
    case MessageName::WebPage_RequestFontAttributesAtSelectionStartReply:
    case MessageName::WebPage_RequestImageBitmapReply:
    case MessageName::WebPage_RequestMediaPlaybackStateReply:
    case MessageName::WebPage_RequestRVItemInCurrentSelectedRangeReply:
    case MessageName::WebPage_RequestRectForFoundTextRangeReply:
    case MessageName::WebPage_ResumeAllMediaPlaybackReply:
    case MessageName::WebPage_ResumeReply:
    case MessageName::WebPage_RunJavaScriptInFrameInScriptWorldReply:
    case MessageName::WebPage_SavePDFReply:
    case MessageName::WebPage_SelectPositionAtBoundaryWithDirectionReply:
    case MessageName::WebPage_SelectPositionAtPointReply:
    case MessageName::WebPage_SelectTextWithGranularityAtPointReply:
    case MessageName::WebPage_SelectWithGestureReply:
    case MessageName::WebPage_SelectWithTwoTouchesReply:
    case MessageName::WebPage_SendMessageToWebExtensionWithReplyReply:
    case MessageName::WebPage_SetActivityStateReply:
    case MessageName::WebPage_SetInitialFocusReply:
    case MessageName::WebPage_SetMutedReply:
    case MessageName::WebPage_StartTextManipulationsReply:
    case MessageName::WebPage_StopMediaCaptureReply:
    case MessageName::WebPage_SuspendAllMediaPlaybackReply:
    case MessageName::WebPage_SuspendReply:
    case MessageName::WebPage_TakeSnapshotReply:
    case MessageName::WebPage_TextInputContextsInRectReply:
    case MessageName::WebPage_TryCloseReply:
    case MessageName::WebPage_URLSchemeTaskWillPerformRedirectionReply:
    case MessageName::WebPage_UpdateAttachmentAttributesReply:
    case MessageName::WebPage_UpdateSelectionWithDeltaReply:
    case MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundaryReply:
    case MessageName::WebPage_UpdateSelectionWithExtentPointReply:
    case MessageName::WebPage_UpdateSelectionWithTouchesReply:
    case MessageName::WebPage_UpdateWithTextRecognitionResultReply:
    case MessageName::WebPage_UserMediaAccessWasGrantedReply:
    case MessageName::WebPage_ValidateCommandReply:
    case MessageName::WebProcessProxy_SendMessageToWebContextWithReplyReply:
    case MessageName::WebProcess_ClearCachedPageReply:
    case MessageName::WebProcess_DeleteWebsiteDataForOriginsReply:
    case MessageName::WebProcess_DeleteWebsiteDataReply:
    case MessageName::WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcessReply:
    case MessageName::WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcessReply:
    case MessageName::WebProcess_FetchWebsiteDataReply:
    case MessageName::WebProcess_GetActivePagesOriginsForTestingReply:
    case MessageName::WebProcess_IsJITEnabledReply:
    case MessageName::WebProcess_PrepareToSuspendReply:
    case MessageName::WebProcess_SeedResourceLoadStatisticsForTestingReply:
    case MessageName::WebProcess_SendResourceLoadStatisticsDataImmediatelyReply:
    case MessageName::WebProcess_SetDomainsWithCrossPageStorageAccessReply:
    case MessageName::WebProcess_SetThirdPartyCookieBlockingModeReply:
    case MessageName::WebSWClientConnection_SetDocumentIsControlledReply:
    case MessageName::WebSWContextManagerConnection_FirePushEventReply:
    case MessageName::WebSWServerConnection_DisableNavigationPreloadReply:
    case MessageName::WebSWServerConnection_EnableNavigationPreloadReply:
    case MessageName::WebSWServerConnection_GetNavigationPreloadStateReply:
    case MessageName::WebSWServerConnection_GetPushPermissionStateReply:
    case MessageName::WebSWServerConnection_GetPushSubscriptionReply:
    case MessageName::WebSWServerConnection_GetRegistrationsReply:
    case MessageName::WebSWServerConnection_MatchRegistrationReply:
    case MessageName::WebSWServerConnection_ScheduleUnregisterJobInServerReply:
    case MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValueReply:
    case MessageName::WebSWServerConnection_StoreRegistrationsOnDiskReply:
    case MessageName::WebSWServerConnection_SubscribeToPushServiceReply:
    case MessageName::WebSWServerConnection_TerminateWorkerFromClientReply:
    case MessageName::WebSWServerConnection_UnsubscribeFromPushServiceReply:
    case MessageName::WebSWServerConnection_WhenRegistrationReadyReply:
    case MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTestingReply:
    case MessageName::WebSWServerToContextConnection_ClaimReply:
    case MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifierReply:
    case MessageName::WebSWServerToContextConnection_SkipWaitingReply:
    case MessageName::WebSharedWorkerObjectConnection_FetchScriptInClientReply:
    case MessageName::WebUserContentControllerProxy_DidPostMessageReply:
        return ReceiverName::AsyncReply;
    case MessageName::GPUConnectionToWebProcess_EnsureAudioSession:
        return ReceiverName::GPUConnectionToWebProcess;
    case MessageName::IPCTester_StopMessageTesting:
        return ReceiverName::IPCTester;
    case MessageName::NetworkConnectionToWebProcess_BlobSize:
    case MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue:
    case MessageName::NetworkConnectionToWebProcess_CookiesForDOM:
    case MessageName::NetworkConnectionToWebProcess_DomCookiesForHost:
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse:
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation:
    case MessageName::NetworkConnectionToWebProcess_GetRawCookies:
    case MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad:
    case MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics:
    case MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return ReceiverName::NetworkConnectionToWebProcess;
    case MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return ReceiverName::NetworkProcessProxy;
    case MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync:
    case MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting:
    case MessageName::NetworkProcess_SetAllowsAnySSLCertificateForWebSocket:
    case MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting:
    case MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting:
        return ReceiverName::NetworkProcess;
    case MessageName::NetworkStorageManager_ConnectToStorageAreaSync:
        return ReceiverName::NetworkStorageManager;
    case MessageName::RemoteAdapter_RequestDevice:
        return ReceiverName::RemoteAdapter;
    case MessageName::RemoteAudioDestinationManager_CreateAudioDestination:
        return ReceiverName::RemoteAudioDestinationManager;
    case MessageName::RemoteAudioSessionProxy_TryToSetActive:
        return ReceiverName::RemoteAudioSessionProxy;
    case MessageName::RemoteBuffer_MapAsync:
        return ReceiverName::RemoteBuffer;
    case MessageName::RemoteCDMFactoryProxy_CreateCDM:
    case MessageName::RemoteCDMFactoryProxy_SupportsKeySystem:
        return ReceiverName::RemoteCDMFactoryProxy;
    case MessageName::RemoteCDMInstanceProxy_CreateSession:
        return ReceiverName::RemoteCDMInstanceProxy;
    case MessageName::RemoteCDMProxy_CreateInstance:
        return ReceiverName::RemoteCDMProxy;
    case MessageName::RemoteDevice_CreateComputePipelineAsync:
    case MessageName::RemoteDevice_CreateRenderPipelineAsync:
    case MessageName::RemoteDevice_PopErrorScope:
        return ReceiverName::RemoteDevice;
    case MessageName::RemoteGPU_RequestAdapter:
        return ReceiverName::RemoteGPU;
    case MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus:
    case MessageName::RemoteGraphicsContextGL_ClientWaitSync:
    case MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame:
    case MessageName::RemoteGraphicsContextGL_CreateBuffer:
    case MessageName::RemoteGraphicsContextGL_CreateFramebuffer:
    case MessageName::RemoteGraphicsContextGL_CreateProgram:
    case MessageName::RemoteGraphicsContextGL_CreateQuery:
    case MessageName::RemoteGraphicsContextGL_CreateRenderbuffer:
    case MessageName::RemoteGraphicsContextGL_CreateSampler:
    case MessageName::RemoteGraphicsContextGL_CreateShader:
    case MessageName::RemoteGraphicsContextGL_CreateTexture:
    case MessageName::RemoteGraphicsContextGL_CreateTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_CreateVertexArray:
    case MessageName::RemoteGraphicsContextGL_FenceSync:
    case MessageName::RemoteGraphicsContextGL_GetActiveAttrib:
    case MessageName::RemoteGraphicsContextGL_GetActiveUniform:
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName:
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv:
    case MessageName::RemoteGraphicsContextGL_GetActiveUniforms:
    case MessageName::RemoteGraphicsContextGL_GetAttribLocation:
    case MessageName::RemoteGraphicsContextGL_GetBooleanv:
    case MessageName::RemoteGraphicsContextGL_GetBufferParameteri:
    case MessageName::RemoteGraphicsContextGL_GetBufferSubData:
    case MessageName::RemoteGraphicsContextGL_GetError:
    case MessageName::RemoteGraphicsContextGL_GetFloatv:
    case MessageName::RemoteGraphicsContextGL_GetFragDataLocation:
    case MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri:
    case MessageName::RemoteGraphicsContextGL_GetGraphicsResetStatusARB:
    case MessageName::RemoteGraphicsContextGL_GetInteger64:
    case MessageName::RemoteGraphicsContextGL_GetInteger64i:
    case MessageName::RemoteGraphicsContextGL_GetIntegerv:
    case MessageName::RemoteGraphicsContextGL_GetInternalformativ:
    case MessageName::RemoteGraphicsContextGL_GetProgramInfoLog:
    case MessageName::RemoteGraphicsContextGL_GetProgrami:
    case MessageName::RemoteGraphicsContextGL_GetQuery:
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui:
    case MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri:
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameterf:
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameteri:
    case MessageName::RemoteGraphicsContextGL_GetShaderInfoLog:
    case MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat:
    case MessageName::RemoteGraphicsContextGL_GetShaderSource:
    case MessageName::RemoteGraphicsContextGL_GetShaderi:
    case MessageName::RemoteGraphicsContextGL_GetString:
    case MessageName::RemoteGraphicsContextGL_GetSynci:
    case MessageName::RemoteGraphicsContextGL_GetTexParameterf:
    case MessageName::RemoteGraphicsContextGL_GetTexParameteri:
    case MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying:
    case MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE:
    case MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex:
    case MessageName::RemoteGraphicsContextGL_GetUniformIndices:
    case MessageName::RemoteGraphicsContextGL_GetUniformLocation:
    case MessageName::RemoteGraphicsContextGL_GetUniformfv:
    case MessageName::RemoteGraphicsContextGL_GetUniformiv:
    case MessageName::RemoteGraphicsContextGL_GetUniformuiv:
    case MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset:
    case MessageName::RemoteGraphicsContextGL_IsBuffer:
    case MessageName::RemoteGraphicsContextGL_IsEnabled:
    case MessageName::RemoteGraphicsContextGL_IsFramebuffer:
    case MessageName::RemoteGraphicsContextGL_IsProgram:
    case MessageName::RemoteGraphicsContextGL_IsQuery:
    case MessageName::RemoteGraphicsContextGL_IsRenderbuffer:
    case MessageName::RemoteGraphicsContextGL_IsSampler:
    case MessageName::RemoteGraphicsContextGL_IsShader:
    case MessageName::RemoteGraphicsContextGL_IsSync:
    case MessageName::RemoteGraphicsContextGL_IsTexture:
    case MessageName::RemoteGraphicsContextGL_IsTransformFeedback:
    case MessageName::RemoteGraphicsContextGL_IsVertexArray:
    case MessageName::RemoteGraphicsContextGL_MoveErrorsToSyntheticErrorList:
    case MessageName::RemoteGraphicsContextGL_PaintCompositedResultsToCanvas:
    case MessageName::RemoteGraphicsContextGL_PaintCompositedResultsToMediaSample:
    case MessageName::RemoteGraphicsContextGL_PaintRenderingResultsToCanvas:
    case MessageName::RemoteGraphicsContextGL_PaintRenderingResultsToPixelBuffer:
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
    case MessageName::RemoteGraphicsContextGL_ReadnPixels0:
        return ReceiverName::RemoteGraphicsContextGL;
    case MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM:
    case MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem:
        return ReceiverName::RemoteLegacyCDMFactoryProxy;
    case MessageName::RemoteLegacyCDMProxy_CreateSession:
    case MessageName::RemoteLegacyCDMProxy_SupportsMIMEType:
        return ReceiverName::RemoteLegacyCDMProxy;
    case MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID:
    case MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest:
    case MessageName::RemoteLegacyCDMSessionProxy_Update:
        return ReceiverName::RemoteLegacyCDMSessionProxy;
    case MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes:
    case MessageName::RemoteMediaPlayerManagerProxy_OriginsInMediaCache:
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem:
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs:
        return ReceiverName::RemoteMediaPlayerManagerProxy;
    case MessageName::RemoteMediaPlayerProxy_AccessLog:
    case MessageName::RemoteMediaPlayerProxy_ColorSpace:
    case MessageName::RemoteMediaPlayerProxy_ErrorLog:
    case MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime:
    case MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged:
    case MessageName::RemoteMediaPlayerProxy_WouldTaintOrigin:
        return ReceiverName::RemoteMediaPlayerProxy;
    case MessageName::RemoteMediaSourceProxy_AddSourceBuffer:
        return ReceiverName::RemoteMediaSourceProxy;
    case MessageName::RemoteQueue_OnSubmittedWorkDone:
        return ReceiverName::RemoteQueue;
    case MessageName::RemoteRenderingBackend_GetDataForImageBuffer:
    case MessageName::RemoteRenderingBackend_GetDataURLForImageBuffer:
    case MessageName::RemoteRenderingBackend_GetFilteredImageForImageBuffer:
    case MessageName::RemoteRenderingBackend_GetPixelBufferForImageBuffer:
    case MessageName::RemoteRenderingBackend_GetPixelBufferForImageBufferWithNewMemory:
    case MessageName::RemoteRenderingBackend_GetShareableBitmapForImageBuffer:
    case MessageName::RemoteRenderingBackend_MarkSurfaceNonVolatile:
    case MessageName::RemoteRenderingBackend_MarkSurfacesVolatile:
    case MessageName::RemoteRenderingBackend_SwapToValidFrontBuffer:
        return ReceiverName::RemoteRenderingBackend;
    case MessageName::RemoteShaderModule_CompilationInfo:
        return ReceiverName::RemoteShaderModule;
    case MessageName::RemoteSourceBufferProxy_CanSwitchToType:
    case MessageName::RemoteSourceBufferProxy_EvictCodedFrames:
    case MessageName::RemoteSourceBufferProxy_UpdateBufferedFromTrackBuffers:
        return ReceiverName::RemoteSourceBufferProxy;
    case MessageName::StorageManagerSet_ConnectToLocalStorageArea:
    case MessageName::StorageManagerSet_ConnectToSessionStorageArea:
    case MessageName::StorageManagerSet_ConnectToTransientLocalStorageArea:
    case MessageName::StorageManagerSet_GetValues:
        return ReceiverName::StorageManagerSet;
    case MessageName::WebFullScreenManagerProxy_SupportsFullScreen:
        return ReceiverName::WebFullScreenManagerProxy;
    case MessageName::WebPageProxy_AccessibilityScreenToRootView:
    case MessageName::WebPageProxy_BackForwardGoToItem:
    case MessageName::WebPageProxy_BackForwardItemAtIndex:
    case MessageName::WebPageProxy_BackForwardListCounts:
    case MessageName::WebPageProxy_CanUndoRedo:
    case MessageName::WebPageProxy_CheckGrammarOfString:
    case MessageName::WebPageProxy_CheckSpellingOfString:
    case MessageName::WebPageProxy_CheckTextOfParagraph:
    case MessageName::WebPageProxy_CreateNewPage:
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionSync:
    case MessageName::WebPageProxy_DictationAlternatives:
    case MessageName::WebPageProxy_DismissCorrectionPanelSoon:
    case MessageName::WebPageProxy_ExceededDatabaseQuota:
    case MessageName::WebPageProxy_ExecuteSavedCommandBySelector:
    case MessageName::WebPageProxy_ExecuteUndoRedo:
    case MessageName::WebPageProxy_GetGuessesForWord:
    case MessageName::WebPageProxy_GetIsSpeaking:
    case MessageName::WebPageProxy_GetMenuBarIsVisible:
    case MessageName::WebPageProxy_GetStatusBarIsVisible:
    case MessageName::WebPageProxy_GetToolbarsAreVisible:
    case MessageName::WebPageProxy_GetWindowFrame:
    case MessageName::WebPageProxy_HandleSynchronousMessage:
    case MessageName::WebPageProxy_InterpretKeyEvent:
    case MessageName::WebPageProxy_LoadRecentSearches:
    case MessageName::WebPageProxy_LoadSynchronousURLSchemeTask:
    case MessageName::WebPageProxy_PrintFrame:
    case MessageName::WebPageProxy_ReachedApplicationCacheOriginQuota:
    case MessageName::WebPageProxy_RequestDOMPasteAccess:
    case MessageName::WebPageProxy_ResolveWebGLPolicyForURL:
    case MessageName::WebPageProxy_RootViewToAccessibilityScreen:
    case MessageName::WebPageProxy_RootViewToScreen:
    case MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel:
    case MessageName::WebPageProxy_RunJavaScriptAlert:
    case MessageName::WebPageProxy_RunJavaScriptConfirm:
    case MessageName::WebPageProxy_RunJavaScriptPrompt:
    case MessageName::WebPageProxy_ScreenToRootView:
    case MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers:
    case MessageName::WebPageProxy_ShowPDFContextMenu:
    case MessageName::WebPageProxy_SignedPublicKeyAndChallengeString:
    case MessageName::WebPageProxy_SpeechSynthesisVoiceList:
    case MessageName::WebPageProxy_SpellingUIIsShowing:
    case MessageName::WebPageProxy_SubstitutionsPanelIsShowing:
    case MessageName::WebPageProxy_UnwrapCryptoKey:
    case MessageName::WebPageProxy_WebGLPolicyForURL:
    case MessageName::WebPageProxy_WrapCryptoKey:
        return ReceiverName::WebPageProxy;
    case MessageName::WebPage_ComputePagesForPrintingiOS:
    case MessageName::WebPage_GetDataSelectionForPasteboard:
    case MessageName::WebPage_GetPositionInformation:
    case MessageName::WebPage_GetStringSelectionForPasteboard:
    case MessageName::WebPage_ReadSelectionFromPasteboard:
    case MessageName::WebPage_ShouldDelayWindowOrderingEvent:
    case MessageName::WebPage_SyncApplyAutocorrection:
    case MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
    case MessageName::WebPage_TouchEventSync:
        return ReceiverName::WebPage;
    case MessageName::WebPasteboardProxy_AddPasteboardTypes:
    case MessageName::WebPasteboardProxy_AllPasteboardItemInfo:
    case MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType:
    case MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading:
    case MessageName::WebPasteboardProxy_GetNumberOfFiles:
    case MessageName::WebPasteboardProxy_GetPasteboardBufferForType:
    case MessageName::WebPasteboardProxy_GetPasteboardChangeCount:
    case MessageName::WebPasteboardProxy_GetPasteboardColor:
    case MessageName::WebPasteboardProxy_GetPasteboardItemsCount:
    case MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType:
    case MessageName::WebPasteboardProxy_GetPasteboardStringForType:
    case MessageName::WebPasteboardProxy_GetPasteboardStringsForType:
    case MessageName::WebPasteboardProxy_GetPasteboardTypes:
    case MessageName::WebPasteboardProxy_GetPasteboardURL:
    case MessageName::WebPasteboardProxy_GetTypes:
    case MessageName::WebPasteboardProxy_InformationForItemAtIndex:
    case MessageName::WebPasteboardProxy_ReadBuffer:
    case MessageName::WebPasteboardProxy_ReadBufferFromPasteboard:
    case MessageName::WebPasteboardProxy_ReadFilePaths:
    case MessageName::WebPasteboardProxy_ReadStringFromPasteboard:
    case MessageName::WebPasteboardProxy_ReadText:
    case MessageName::WebPasteboardProxy_ReadURLFromPasteboard:
    case MessageName::WebPasteboardProxy_SetPasteboardBufferForType:
    case MessageName::WebPasteboardProxy_SetPasteboardColor:
    case MessageName::WebPasteboardProxy_SetPasteboardStringForType:
    case MessageName::WebPasteboardProxy_SetPasteboardTypes:
    case MessageName::WebPasteboardProxy_SetPasteboardURL:
    case MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite:
    case MessageName::WebPasteboardProxy_URLStringSuitableForLoading:
    case MessageName::WebPasteboardProxy_WriteCustomData:
        return ReceiverName::WebPasteboardProxy;
    case MessageName::WebProcessPool_HandleSynchronousMessage:
        return ReceiverName::WebProcessPool;
    case MessageName::WebProcessProxy_GetGPUProcessConnection:
    case MessageName::WebProcessProxy_GetNetworkProcessConnection:
    case MessageName::WebProcessProxy_GetWebAuthnProcessConnection:
    case MessageName::WebProcessProxy_IsAXAuthenticated:
    case MessageName::WebProcessProxy_ShouldTerminate:
        return ReceiverName::WebProcessProxy;
    case MessageName::WrappedAsyncMessageForTesting:
        return ReceiverName::IPC;
    }
    ASSERT_NOT_REACHED();
    return ReceiverName::Invalid;
}

bool isValidMessageName(MessageName messageName)
{
    if (messageName == IPC::MessageName::AuthenticationManager_CompleteAuthenticationChallenge)
        return true;
#if OS(LINUX)
    if (messageName == IPC::MessageName::AuxiliaryProcess_DidReceiveMemoryPressureEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::AuxiliaryProcess_MainThreadPing)
        return true;
    if (messageName == IPC::MessageName::AuxiliaryProcess_SetProcessSuppressionEnabled)
        return true;
    if (messageName == IPC::MessageName::AuxiliaryProcess_ShutDown)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_Caches)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_ClearMemoryRepresentation)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_DeleteMatchingRecords)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_Dereference)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_EngineRepresentation)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_Open)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_PutRecords)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_Reference)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_Remove)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_RetrieveRecords)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DidCreateDestination)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DidFail)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DidFinish)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DidReceiveAuthenticationChallenge)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DidReceiveData)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DidStart)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_WillSendRequest)
        return true;
    if (messageName == IPC::MessageName::DrawingAreaProxy_DidFirstLayerFlush)
        return true;
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (messageName == IPC::MessageName::DrawingAreaProxy_DidUpdateBackingStoreState)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingAreaProxy_DidUpdateGeometry)
        return true;
#endif
    if (messageName == IPC::MessageName::DrawingAreaProxy_DispatchPresentationCallbacksAfterFlushingLayers)
        return true;
    if (messageName == IPC::MessageName::DrawingAreaProxy_EnterAcceleratedCompositingMode)
        return true;
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (messageName == IPC::MessageName::DrawingAreaProxy_ExitAcceleratedCompositingMode)
        return true;
#endif
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (messageName == IPC::MessageName::DrawingAreaProxy_Update)
        return true;
#endif
    if (messageName == IPC::MessageName::DrawingAreaProxy_UpdateAcceleratedCompositingMode)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_AcceleratedAnimationDidEnd)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_AcceleratedAnimationDidStart)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_AddTransactionCallbackID)
        return true;
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    if (messageName == IPC::MessageName::DrawingArea_AdjustTransientZoom)
        return true;
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    if (messageName == IPC::MessageName::DrawingArea_CommitTransientZoom)
        return true;
#endif
    if (messageName == IPC::MessageName::DrawingArea_DidUpdate)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_SetColorSpace)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_SetDeviceScaleFactor)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_SetViewExposedRect)
        return true;
#endif
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (messageName == IPC::MessageName::DrawingArea_UpdateBackingStoreState)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::DrawingArea_UpdateGeometry)
        return true;
#endif
#if USE(GRAPHICS_LAYER_WC)
    if (messageName == IPC::MessageName::DrawingArea_UpdateGeometry)
        return true;
#endif
#if HAVE(CVDISPLAYLINK)
    if (messageName == IPC::MessageName::EventDispatcher_DisplayWasRefreshed)
        return true;
#endif
#if ENABLE(MAC_GESTURE_EVENTS)
    if (messageName == IPC::MessageName::EventDispatcher_GestureEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::EventDispatcher_PageScreenDidChange)
        return true;
#if ENABLE(MOMENTUM_EVENT_DISPATCHER)
    if (messageName == IPC::MessageName::EventDispatcher_SetScrollingAccelerationCurve)
        return true;
#endif
#if ENABLE(IOS_TOUCH_EVENTS)
    if (messageName == IPC::MessageName::EventDispatcher_TouchEvent)
        return true;
#endif
#if ENABLE(IOS_TOUCH_EVENTS)
    if (messageName == IPC::MessageName::EventDispatcher_TouchEventWithoutCallback)
        return true;
#endif
    if (messageName == IPC::MessageName::EventDispatcher_WheelEvent)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ClearNowPlayingInfo)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ConfigureLoggingChannel)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateAudioHardwareListener)
        return true;
#if ENABLE(WEBGL)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateGraphicsContextGL)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateRemoteCommandListener)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateRemoteGPU)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateRenderingBackend)
        return true;
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage)
        return true;
#endif
#if USE(GRAPHICS_LAYER_WC)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_CreateWCLayerTreeHost)
        return true;
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage)
        return true;
#endif
#if ENABLE(VP9)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_EnableVP9Decoders)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_EnsureMediaSessionHelper)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ReleaseAudioHardwareListener)
        return true;
#if ENABLE(WEBGL)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ReleaseGraphicsContextGL)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ReleaseRemoteCommandListener)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ReleaseRenderingBackend)
        return true;
#if USE(GRAPHICS_LAYER_WC)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_ReleaseWCLayerTreeHost)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_SetMediaOverridesForTesting)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_SetNowPlayingInfo)
        return true;
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_SetUserPreferredLanguages)
        return true;
#if ENABLE(ROUTING_ARBITRATION)
    if (messageName == IPC::MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcessConnection_DidReceiveRemoteCommand)
        return true;
#if ENABLE(ROUTING_ARBITRATION)
    if (messageName == IPC::MessageName::GPUProcessConnection_EndRoutingArbitration)
        return true;
#endif
#if ENABLE(MEDIA_STREAM) && PLATFORM(COCOA)
    if (messageName == IPC::MessageName::GPUProcessConnection_ResetAudioMediaStreamTrackRendererInternalUnit)
        return true;
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    if (messageName == IPC::MessageName::GPUProcessProxy_DidCreateContextForVisibilityPropagation)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcessProxy_ProcessIsReadyToExit)
        return true;
    if (messageName == IPC::MessageName::GPUProcessProxy_TerminateWebProcess)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_AddMockMediaDevice)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_AddSession)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_ClearMockMediaDevices)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_CreateGPUConnectionToWebProcess)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::GPUProcess_DisplayConfigurationChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_InitializeGPUProcess)
        return true;
#if ENABLE(CFPREFS_DIRECT_MODE)
    if (messageName == IPC::MessageName::GPUProcess_NotifyPreferencesChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_PrepareToSuspend)
        return true;
    if (messageName == IPC::MessageName::GPUProcess_ProcessDidResume)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_RemoveMockMediaDevice)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_RemoveSession)
        return true;
    if (messageName == IPC::MessageName::GPUProcess_RequestBitmapImageForCurrentTime)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_ResetMockMediaDevices)
        return true;
#endif
#if ENABLE(MEDIA_SOURCE) && HAVE(AVSAMPLEBUFFERVIDEOOUTPUT)
    if (messageName == IPC::MessageName::GPUProcess_SetMediaSourceInlinePaintingEnabled)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_SetMockCameraIsInterrupted)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_SetMockCaptureDevicesEnabled)
        return true;
#endif
#if ENABLE(OPUS)
    if (messageName == IPC::MessageName::GPUProcess_SetOpusDecoderEnabled)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_SetOrientationForMediaCapture)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::GPUProcess_SetScreenProperties)
        return true;
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
    if (messageName == IPC::MessageName::GPUProcess_SetUseScreenCaptureKit)
        return true;
#endif
#if ENABLE(VORBIS)
    if (messageName == IPC::MessageName::GPUProcess_SetVorbisDecoderEnabled)
        return true;
#endif
#if ENABLE(WEBM_FORMAT_READER)
    if (messageName == IPC::MessageName::GPUProcess_SetWebMFormatReaderEnabled)
        return true;
#endif
#if ENABLE(MEDIA_SOURCE)
    if (messageName == IPC::MessageName::GPUProcess_SetWebMParserEnabled)
        return true;
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
    if (messageName == IPC::MessageName::GPUProcess_ShowScreenPicker)
        return true;
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
    if (messageName == IPC::MessageName::GPUProcess_ShowWindowPicker)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_UpdateCaptureAccess)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_UpdateCaptureOrigin)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_UpdateSandboxAccess)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_WebProcessConnectionCountForTesting)
        return true;
    if (messageName == IPC::MessageName::GtkSettingsManagerProxy_SettingsDidChange)
        return true;
    if (messageName == IPC::MessageName::IPCTester_StartMessageTesting)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_CreateEncoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_CreateH264Decoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_CreateH265Decoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_CreateVP9Decoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_DecodeFrame)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_EncodeFrame)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_InitializeEncoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_ReleaseDecoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_ReleaseEncoder)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_SetEncodeRates)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_SetFrameSize)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_SetRTCLoggingLevel)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameMemory)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameSemaphore)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecs_CompletedDecoding)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecs_CompletedEncoding)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCCodecs_FailedDecoding)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCNetwork_SignalAddressReady)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCNetwork_SignalClose)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCNetwork_SignalConnect)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCNetwork_SignalNewConnection)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCNetwork_SignalReadPacket)
        return true;
    if (messageName == IPC::MessageName::LibWebRTCNetwork_SignalSentPacket)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_ActiveSourceBuffersChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_AddDataCue)
        return true;
#if ENABLE(DATACUE_VALUE)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_AddDataCueWithType)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_AddGenericCue)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_AddRemoteAudioTrack)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_AddRemoteTextTrack)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_AddRemoteVideoTrack)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_CharacteristicChanged)
        return true;
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_CurrentPlaybackTargetIsWirelessChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_CurrentTimeChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_DurationChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_EngineFailedToLoad)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_FirstVideoFrameAvailable)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_GetRawCookies)
        return true;
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_InitializationDataEncountered)
        return true;
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_MediaPlayerKeyNeeded)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_MuteChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_NetworkStateChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueData)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueDataStruct)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_ParseWebVTTFileHeader)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_PlaybackStateChanged)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_PushVideoFrameMetadata)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RateChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_ReadyStateChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoteAudioTrackConfigurationChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoteTextTrackConfigurationChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoteVideoTrackConfigurationChanged)
        return true;
#if ENABLE(DATACUE_VALUE)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoveDataCue)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoveGenericCue)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoveRemoteAudioTrack)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoveRemoteTextTrack)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoveRemoteVideoTrack)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RemoveResource)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RenderingModeChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RequestResource)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_ResourceNotSupported)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_SendH2Ping)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_SizeChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_TimeChanged)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_UpdateCachedState)
        return true;
#if ENABLE(DATACUE_VALUE)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_UpdateDataCue)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_UpdateGenericCue)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_VolumeChanged)
        return true;
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_WaitingForKeyChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaSourcePrivateRemote_SeekToTime)
        return true;
    if (messageName == IPC::MessageName::NetworkBroadcastChannelRegistry_PostMessage)
        return true;
    if (messageName == IPC::MessageName::NetworkBroadcastChannelRegistry_RegisterChannel)
        return true;
    if (messageName == IPC::MessageName::NetworkBroadcastChannelRegistry_UnregisterChannel)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_AddOriginAccessAllowListEntry)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_BrowsingContextRemoved)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CheckRemotePortForActivity)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ClearPageSpecificData)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CloseSWContextConnection)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CloseSharedWorkerContextConnection)
        return true;
#if ENABLE(WEB_RTC)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ConvertMainResourceLoadToDownload)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CreateNewMessagePortChannel)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CreateRTCProvider)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CreateSocketChannel)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CreateSocketStream)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_DeleteCookie)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_DidDeliverMessagePortMessages)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_EntangleLocalPortInThisProcessToRemote)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_HasStorageAccess)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_LoadPing)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_LogUserInteraction)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_MessagePortClosed)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_MessagePortDisentangled)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_PageLoadCompleted)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_PostMessageToRemote)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_PreconnectTo)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_PrefetchDNS)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_PrioritizeResourceLoads)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterBlobURL)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterBlobURLForSlice)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterBlobURLFromURL)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterBlobURLHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterBlobURLOptionallyFileBacked)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterFileBlobURL)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RegisterURLSchemesAsCORSEnabled)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RemoveLoadIdentifier)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RemoveOriginAccessAllowListEntry)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RemoveStorageAccessForFrame)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RequestStorageAccess)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RequestStorageAccessUnderOpener)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ResetOriginAccessAllowLists)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ScheduleResourceLoad)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SendH2Ping)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SetCORSDisablingPatterns)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SetCaptureExtraNetworkLoadMetricsEnabled)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SetCookiesFromDOM)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SetRawCookie)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SetResourceLoadSchedulingMode)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_StartDownload)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_UnregisterBlobURL)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_UnregisterBlobURLHandle)
        return true;
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_UnsubscribeFromCookieChangeNotifications)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_UpdateActivePages)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_UpdateQuotaBasedOnSpaceUsageForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB)
        return true;
    if (messageName == IPC::MessageName::NetworkContentRuleListManager_AddContentRuleLists)
        return true;
    if (messageName == IPC::MessageName::NetworkContentRuleListManager_Remove)
        return true;
    if (messageName == IPC::MessageName::NetworkContentRuleListManager_RemoveAllContentRuleLists)
        return true;
    if (messageName == IPC::MessageName::NetworkContentRuleListManager_RemoveContentRuleList)
        return true;
    if (messageName == IPC::MessageName::NetworkMDNSRegister_RegisterMDNSName)
        return true;
    if (messageName == IPC::MessageName::NetworkMDNSRegister_UnregisterMDNSNames)
        return true;
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    if (messageName == IPC::MessageName::NetworkProcessConnection_AllCookiesDeleted)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessConnection_BroadcastConsoleMessage)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessConnection_CheckProcessLocalPortForActivity)
        return true;
#if ENABLE(WEB_RTC)
    if (messageName == IPC::MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessConnection_CookieAcceptPolicyChanged)
        return true;
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    if (messageName == IPC::MessageName::NetworkProcessConnection_CookiesAdded)
        return true;
#endif
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    if (messageName == IPC::MessageName::NetworkProcessConnection_CookiesDeleted)
        return true;
#endif
#if ENABLE(SHAREABLE_RESOURCE)
    if (messageName == IPC::MessageName::NetworkProcessConnection_DidCacheResource)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessConnection_DidFinishPingLoad)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessConnection_DidFinishPreconnection)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessConnection_MessagesAvailableForPort)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessConnection_SetOnLineState)
        return true;
#if ENABLE(CONTENT_EXTENSIONS)
    if (messageName == IPC::MessageName::NetworkProcessProxy_ContentExtensionRules)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_DidCommitCrossSiteLoadWithDataTransferFromPrevalentResource)
        return true;
#endif
#if USE(SOUP)
    if (messageName == IPC::MessageName::NetworkProcessProxy_DidExceedMemoryLimit)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_DidNegotiateModernTLS)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_DidReceiveAuthenticationChallenge)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcessProxy_EndServiceWorkerBackgroundProcessing)
        return true;
#endif
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcess)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcess)
        return true;
#if ENABLE(APP_BOUND_DOMAINS)
    if (messageName == IPC::MessageName::NetworkProcessProxy_GetAppBoundDomains)
        return true;
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI_USES_SCENE)
    if (messageName == IPC::MessageName::NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentation)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_IncreaseQuota)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_LogDiagnosticMessage)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_LogDiagnosticMessageWithResult)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_LogDiagnosticMessageWithValue)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_LogTestingEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_NegotiatedLegacyTLS)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_NotifyResourceLoadStatisticsProcessed)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_NotifyWebsiteDataDeletionForRegistrableDomainsFinished)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_NotifyWebsiteDataScanForRegistrableDomainsFinished)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_RegisterRemoteWorkerClientProcess)
        return true;
#if ENABLE(CONTENT_FILTERING_IN_NETWORKING_PROCESS)
    if (messageName == IPC::MessageName::NetworkProcessProxy_ReloadAfterUnblockedContentFilter)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_RemoteWorkerContextConnectionNoLongerNeeded)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_RequestStorageAccessConfirm)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_RequestStorageSpace)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_ResourceLoadDidCompleteWithError)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_ResourceLoadDidPerformHTTPRedirection)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_ResourceLoadDidReceiveChallenge)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_ResourceLoadDidReceiveResponse)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_ResourceLoadDidSendRequest)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_RetrieveCacheStorageParameters)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_SetDomainsWithUserInteraction)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_SetWebProcessHasUploads)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcessProxy_StartServiceWorkerBackgroundProcessing)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_TerminateUnresponsiveServiceWorkerProcesses)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_TerminateWebProcess)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_UnregisterRemoteWorkerClientProcess)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_AddWebPageNetworkParameters)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_AddWebsiteDataStore)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_AllowSpecificHTTPSCertificateForHost)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_AllowTLSCertificateChainForLocalPCMTesting)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::NetworkProcess_AppPrivacyReportTestingData)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ApplicationDidEnterBackground)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ApplicationWillEnterForeground)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_CancelDownload)
        return true;
#if ENABLE(APP_BOUND_DOMAINS)
    if (messageName == IPC::MessageName::NetworkProcess_ClearAppBoundSession)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::NetworkProcess_ClearAppPrivacyReportTestingData)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClearBundleIdentifier)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ClearCachedCredentials)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ClearPrevalentResource)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClearPrivateClickMeasurement)
        return true;
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    if (messageName == IPC::MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClearStorage)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ClearUserInteraction)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_CloseITPDatabase)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClosePCMDatabase)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ContinueWillSendRequest)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_CountNonDefaultSessionSets)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DeleteCookiesForTesting)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_DeletePushAndNotificationRegistration)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_DeleteWebsiteData)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_DeleteWebsiteDataForOrigins)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_DestroySession)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DidCommitCrossSiteLoadWithDataTransfer)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_DidIncreaseQuota)
        return true;
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    if (messageName == IPC::MessageName::NetworkProcess_DisableServiceWorkerEntitlement)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DomainIDExistsInDatabase)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_DownloadRequest)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_DumpPrivateClickMeasurement)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DumpResourceLoadStatistics)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_FetchWebsiteData)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_FlushCookies)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_GetAllStorageAccessEntries)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_GetOriginsWithPushAndNotificationPermissions)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcess_GetPendingPushMessages)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_HadUserInteraction)
        return true;
#endif
#if ENABLE(APP_BOUND_DOMAINS)
    if (messageName == IPC::MessageName::NetworkProcess_HasAppBoundSession)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_HasIsolatedSession)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_HasLocalStorage)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_InitializeNetworkProcess)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_InsertExpiredStatisticForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsGrandfathered)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsPrevalentResource)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRegisteredAsRedirectingTo)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsVeryPrevalentResource)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_LogFrameNavigation)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_LogUserInteraction)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_MergeStatisticForTesting)
        return true;
#endif
#if ENABLE(CFPREFS_DIRECT_MODE)
    if (messageName == IPC::MessageName::NetworkProcess_NotifyPreferencesChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_PreconnectTo)
        return true;
#if USE(SOUP)
    if (messageName == IPC::MessageName::NetworkProcess_PrefetchDNS)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_PrepareToSuspend)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ProcessDidResume)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcess_ProcessPushMessage)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::NetworkProcess_PublishDownloadProgress)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RegisterURLSchemeAsLocal)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RegisterURLSchemeAsNoAccess)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RegisterURLSchemeAsSecure)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RemoveWebPageNetworkParameters)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RenameOriginInWebsiteData)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RequestResource)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ResetParametersToDefaultValues)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ResetQuota)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ResumeDownload)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ScheduleCookieBlockingUpdate)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetAgeCapForClientSideCookies)
        return true;
#endif
#if (ENABLE(INTELLIGENT_TRACKING_PREVENTION) && ENABLE(APP_BOUND_DOMAINS))
    if (messageName == IPC::MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SetCacheModel)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetGrandfathered)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetGrandfatheringTime)
        return true;
#endif
#if USE(SOUP)
    if (messageName == IPC::MessageName::NetworkProcess_SetIgnoreTLSErrors)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetLastSeen)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetMaxStatisticsEntries)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval)
        return true;
#endif
#if USE(SOUP)
    if (messageName == IPC::MessageName::NetworkProcess_SetNetworkProxySettings)
        return true;
#endif
#if USE(CURL)
    if (messageName == IPC::MessageName::NetworkProcess_SetNetworkProxySettings)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetNotifyPagesWhenDataRecordsWereScanned)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting)
        return true;
#if USE(SOUP)
    if (messageName == IPC::MessageName::NetworkProcess_SetPersistentCredentialStorageEnabled)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetPrevalentResource)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetPrevalentResourceForDebugMode)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementDebugMode)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetPruneEntriesDownTo)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::NetworkProcess_SetQOS)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetResourceLoadStatisticsEnabled)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetResourceLoadStatisticsLogTestingEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SetSessionIsControlledByAutomation)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetTimeToLiveUserInteraction)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetVeryPrevalentResource)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_StatisticsDatabaseHasAllTables)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_StorePrivateClickMeasurement)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SyncLocalStorage)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_UpdateBundleIdentifier)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor)
        return true;
#endif
#if USE(SOUP)
    if (messageName == IPC::MessageName::NetworkProcess_UserPreferredLanguagesChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkRTCMonitor_StartUpdatingIfNeeded)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCMonitor_StopUpdating)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_CloseSocket)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_CreateClientTCPSocket)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_CreateResolver)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_CreateServerTCPSocket)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_CreateUDPSocket)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_SendToSocket)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_SetPlatformTCPSocketsEnabled)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_SetPlatformUDPSocketsEnabled)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_SetSocketOption)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_StopResolver)
        return true;
    if (messageName == IPC::MessageName::NetworkRTCProvider_WrapNewTCPConnection)
        return true;
    if (messageName == IPC::MessageName::NetworkResourceLoader_ContinueDidReceiveResponse)
        return true;
    if (messageName == IPC::MessageName::NetworkResourceLoader_ContinueWillSendRequest)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketChannel_Close)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketChannel_SendData)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketChannel_SendString)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketStream_Close)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketStream_SendData)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketStream_SendHandshake)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_AbortOpenAndUpgradeNeeded)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_AbortTransaction)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_Clear)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_ClearObjectStore)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CloneSessionStorageNamespace)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CloseHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CloseSyncAccessHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CommitTransaction)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_ConnectToStorageArea)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CreateIndex)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CreateObjectStore)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CreateSyncAccessHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DatabaseConnectionClosed)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DatabaseConnectionPendingClose)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DeleteDatabase)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DeleteIndex)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DeleteObjectStore)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DeleteRecord)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DidFinishHandlingVersionChangeTransaction)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DidFireVersionChangeEvent)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_DisconnectFromStorageArea)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_EstablishTransaction)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_FileSystemGetDirectory)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetAllDatabaseNamesAndVersions)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetAllRecords)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetCount)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetDirectoryHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetFile)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetFileHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetHandle)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetHandleNames)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetRecord)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_IsSameEntry)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_IterateCursor)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_Move)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_OpenCursor)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_OpenDBRequestCancelled)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_OpenDatabase)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_Persist)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_Persisted)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_PutOrAdd)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_RemoveEntry)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_RemoveItem)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_RenameIndex)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_RenameObjectStore)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_Resolve)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_SetItem)
        return true;
    if (messageName == IPC::MessageName::NotificationManagerMessageHandler_CancelNotification)
        return true;
    if (messageName == IPC::MessageName::NotificationManagerMessageHandler_ClearNotifications)
        return true;
    if (messageName == IPC::MessageName::NotificationManagerMessageHandler_DidDestroyNotification)
        return true;
    if (messageName == IPC::MessageName::NotificationManagerMessageHandler_RequestSystemNotificationPermission)
        return true;
    if (messageName == IPC::MessageName::NotificationManagerMessageHandler_ShowNotification)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystemProxy_SessionDidEnd)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystemProxy_SessionDidUpdateVisibilityState)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_InitializeTrackingAndRendering)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_RequestFrame)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_ShutDownTrackingAndRendering)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_SubmitFrame)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManagerProxy_BufferedAmountIsDecreasing)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManagerProxy_ChangeReadyState)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManagerProxy_Close)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManagerProxy_DetectError)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManagerProxy_ReceiveData)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManagerProxy_SendData)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManager_BufferedAmountIsDecreasing)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManager_ChangeReadyState)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManager_Close)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManager_DetectError)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManager_ReceiveData)
        return true;
    if (messageName == IPC::MessageName::RTCDataChannelRemoteManager_SendData)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_AudioSamplesStorageChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_DeleteAudioDestination)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_StartAudioDestination)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_StopAudioDestination)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeActive)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeInactive)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioHardwareListener_AudioOutputDeviceChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_DeleteUnit)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_SetAudioOutputDevice)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StartUnit)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StopUnit)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSessionProxy_SetCategory)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSessionProxy_SetPreferredBufferSize)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSession_BeginInterruption)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSession_ConfigurationChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSession_EndInterruption)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSourceProviderManager_AudioSamplesAvailable)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSourceProviderManager_AudioStorageChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteBindGroupLayout_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteBindGroup_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteBuffer_Destroy)
        return true;
    if (messageName == IPC::MessageName::RemoteBuffer_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteBuffer_Unmap)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceProxy_SetServerCertificate)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceProxy_SetStorageDirectory)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_CloseSession)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_DisplayIDChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_LoadSession)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_RequestLicense)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_StoreRecordOfKeyUsage)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSession_SendMessage)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSession_SessionIdChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSession_UpdateKeyStatuses)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstance_UnrequestedInitializationDataReceived)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMProxy_GetSupportedConfiguration)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMProxy_LoadAndInitialize)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandBuffer_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_BeginComputePass)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_BeginRenderPass)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_ClearBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_CopyBufferToBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_CopyBufferToTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_CopyTextureToBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_CopyTextureToTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_Finish)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_InsertDebugMarker)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_PopDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_PushDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_ResolveQuerySet)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteCommandEncoder_WriteTimestamp)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_Dispatch)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_DispatchIndirect)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_End)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_InsertDebugMarker)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_PopDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_PushDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_SetBindGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePassEncoder_SetPipeline)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePipeline_GetBindGroupLayout)
        return true;
    if (messageName == IPC::MessageName::RemoteComputePipeline_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateBindGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateBindGroupLayout)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateCommandEncoder)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateComputePipeline)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreatePipelineLayout)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateQuerySet)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateRenderBundleEncoder)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateRenderPipeline)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateSampler)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateShaderModule)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_Destroy)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_ImportExternalTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_PushErrorScope)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ApplyDeviceScaleFactor)
        return true;
#if USE(CG)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ApplyFillPattern)
        return true;
#endif
#if USE(CG)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ApplyStrokePattern)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_BeginTransparencyLayer)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ClearRect)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ClearShadow)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_Clip)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ClipOut)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ClipOutToPath)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ClipPath)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ClipToImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ConcatenateCTM)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_ConvertToLuminanceMask)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawDotsForDocumentMarker)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawEllipse)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawFilteredImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawFocusRingPath)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawFocusRingRects)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawGlyphs)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawLine)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawLinesForText)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawNativeImage)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawPath)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawPattern)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_DrawRect)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_EndTransparencyLayer)
        return true;
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillArc)
        return true;
#endif
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillBezierCurve)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillCompositedRect)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillEllipse)
        return true;
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillLine)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillPath)
        return true;
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillQuadCurve)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillRect)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillRectWithColor)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillRectWithGradient)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillRectWithRoundedHole)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FillRoundedRect)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_FlushContext)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_PaintFrameForMedia)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_Restore)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_Rotate)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_Save)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_Scale)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetCTM)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetInlineFillColor)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetInlineStrokeColor)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetLineCap)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetLineDash)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetLineJoin)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetMiterLimit)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetState)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_SetStrokeThickness)
        return true;
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokeArc)
        return true;
#endif
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokeBezierCurve)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokeEllipse)
        return true;
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokeLine)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokePath)
        return true;
#if ENABLE(INLINE_PATH_DATA)
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokeQuadCurve)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_StrokeRect)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_TransformToColorSpace)
        return true;
    if (messageName == IPC::MessageName::RemoteDisplayListRecorder_Translate)
        return true;
    if (messageName == IPC::MessageName::RemoteExternalTexture_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteGPUProxy_WasCreated)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGLProxy_WasChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGLProxy_WasCreated)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGLProxy_WasLost)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ActiveTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_AttachShader)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BeginQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BeginTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindAttribLocation)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindBufferBase)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindBufferRange)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindRenderbuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindSampler)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BindVertexArray)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BlendColor)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BlendEquation)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BlendEquationSeparate)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BlendFunc)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BlendFuncSeparate)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BlitFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BufferData0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BufferData1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_BufferSubData)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Clear)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearBufferfi)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearBufferfv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearBufferiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearBufferuiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearColor)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearDepth)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClearStencil)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ColorMask)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompileShader)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexImage2D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexImage2D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexImage3D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexImage3D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CopyBufferSubData)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CopyTexImage2D)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CopyTexSubImage2D)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CopyTexSubImage3D)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CullFace)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteProgram)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteRenderbuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteSampler)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteShader)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteSync)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DeleteVertexArray)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DepthFunc)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DepthMask)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DepthRange)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DetachShader)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Disable)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DisableVertexAttribArray)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawArrays)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawArraysInstanced)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawBuffers)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawBuffersEXT)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawElements)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawElementsInstanced)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_DrawRangeElements)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Enable)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_EnableVertexAttribArray)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_EndQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_EndTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_EnsureExtensionEnabled)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Finish)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Flush)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_FramebufferRenderbuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_FramebufferTexture2D)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_FramebufferTextureLayer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_FrontFace)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GenerateMipmap)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Hint)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_InvalidateFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_InvalidateSubFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_LineWidth)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_LinkProgram)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_MarkContextChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_MultiDrawArraysANGLE)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_MultiDrawElementsANGLE)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PauseTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PixelStorei)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PolygonOffset)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ReadBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ReadnPixels1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_RenderbufferStorage)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisample)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Reshape)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ResumeTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_SampleCoverage)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_SamplerParameterf)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_SamplerParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Scissor)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ShaderSource)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_SimulateEventForTesting)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_StencilFunc)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_StencilFuncSeparate)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_StencilMask)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_StencilMaskSeparate)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_StencilOp)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_StencilOpSeparate)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_SynthesizeGLError)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexImage2D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexImage2D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexImage3D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexImage3D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexParameterf)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexStorage2D)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexStorage3D)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexSubImage2D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexSubImage2D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexSubImage3D0)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TexSubImage3D1)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_TransformFeedbackVaryings)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform1f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform1fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform1i)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform1iv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform1ui)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform1uiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform2f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform2fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform2i)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform2iv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform2ui)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform2uiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform3f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform3fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform3i)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform3iv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform3ui)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform3uiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform4f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform4fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform4i)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform4iv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform4ui)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Uniform4uiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformBlockBinding)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix2fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix2x3fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix2x4fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix3fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix3x2fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix3x4fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix4fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix4x2fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UniformMatrix4x3fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_UseProgram)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ValidateProgram)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib1f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib1fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib2f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib2fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib3f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib3fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib4f)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttrib4fv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribDivisor)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribI4i)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribI4iv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribI4ui)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribI4uiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribIPointer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_VertexAttribPointer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_Viewport)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_WaitSync)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMProxy_SetPlayerId)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMSessionProxy_ReleaseKeys)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMSession_SendError)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMSession_SendMessage)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_ClearMediaCache)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_ClearMediaCacheForOrigins)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_CreateMediaPlayer)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_DeleteMediaPlayer)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_AcceleratedRenderingStateChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_ApplicationDidBecomeActive)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_ApplicationWillResignActive)
        return true;
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_AttemptToDecryptWithInstance)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_AudioTrackSetEnabled)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_BeginSimulatedHDCPError)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_CancelLoad)
        return true;
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_CdmInstanceAttached)
        return true;
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_CdmInstanceDetached)
        return true;
#endif
#if ENABLE(WEB_AUDIO)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_CreateAudioSourceProvider)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_DidLoadingProgress)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_EndSimulatedHDCPError)
        return true;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_KeyAdded)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_Load)
        return true;
#if ENABLE(MEDIA_SOURCE)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_LoadMediaSource)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_NotifyActiveSourceBuffersChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_NotifyTrackModeChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_Pause)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PauseAtHostTime)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PerformTaskAtMediaTime)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_Play)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PlayAtHostTime)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PrepareForPlayback)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PrepareForRendering)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PrepareToPlay)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_Seek)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SeekWithTolerance)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetBufferingPolicy)
        return true;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetLegacyCDMSession)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetMuted)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetPageIsVisible)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetPitchCorrectionAlgorithm)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetPreferredDynamicRangeMode)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetPreload)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetPreservesPitch)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetPrivateBrowsingMode)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetRate)
        return true;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) && ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetShouldContinueAfterKeyNeeded)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetShouldDisableSleep)
        return true;
#if ENABLE(WEB_AUDIO)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetShouldEnableAudioSourceProvider)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetShouldMaintainAspectRatio)
        return true;
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetShouldPlayToPlaybackTarget)
        return true;
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenGravity)
        return true;
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenMode)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetVideoInlineSizeFenced)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetVideoPlaybackMetricsUpdateInterval)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetVolume)
        return true;
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetWirelessPlaybackTarget)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_SetWirelessVideoPlaybackDisabled)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_StartVideoFrameMetadataGathering)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_StopVideoFrameMetadataGathering)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_TextTrackSetMode)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_TracksChanged)
        return true;
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_UpdateVideoFullscreenInlineImage)
        return true;
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_VideoFullscreenStandbyChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_VideoTrackSetSelected)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorderManager_CreateRecorder)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorderManager_ReleaseRecorder)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_AudioSamplesAvailable)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_AudioSamplesStorageChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_FetchData)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_Pause)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_Resume)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_SetSharedVideoFrameMemory)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_SetSharedVideoFrameSemaphore)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_StopRecording)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_VideoSampleAvailable)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_AccessControlCheckFailed)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_DataReceived)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_DataSent)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_LoadFailed)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_LoadFinished)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_RedirectReceived)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_ResponseReceived)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_Join)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_Leave)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_PlaybackStateChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_PositionStateChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_ReadyStateChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_TrackIdentifierChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_CoordinatorStateChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_PauseSession)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_PlaySession)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_SetSessionTrack)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_BufferedChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_DurationChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_SeekCompleted)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_SetIsSeeking)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_SetReadyState)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_SetTimeFudgeFactor)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_WaitForSeekCompleted)
        return true;
    if (messageName == IPC::MessageName::RemotePipelineLayout_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteQuerySet_Destroy)
        return true;
    if (messageName == IPC::MessageName::RemoteQuerySet_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteQueue_CopyExternalImageToTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteQueue_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteQueue_Submit)
        return true;
    if (messageName == IPC::MessageName::RemoteQueue_WriteBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteQueue_WriteTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteRemoteCommandListenerProxy_UpdateSupportedCommands)
        return true;
    if (messageName == IPC::MessageName::RemoteRemoteCommandListener_DidReceiveRemoteControlCommand)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_Draw)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_DrawIndexed)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_DrawIndexedIndirect)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_DrawIndirect)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_Finish)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_InsertDebugMarker)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_PopDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_PushDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_SetBindGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_SetIndexBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_SetPipeline)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundleEncoder_SetVertexBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderBundle_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_BeginOcclusionQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_Draw)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_DrawIndexed)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_DrawIndexedIndirect)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_DrawIndirect)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_End)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_EndOcclusionQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_ExecuteBundles)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_InsertDebugMarker)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_PopDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_PushDebugGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetBindGroup)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetBlendConstant)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetIndexBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetPipeline)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetScissorRect)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetStencilReference)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetVertexBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPassEncoder_SetViewport)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPipeline_GetBindGroupLayout)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderPipeline_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackendProxy_DidCreateImageBufferBackend)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackendProxy_DidCreateWakeUpSemaphoreForDisplayListStream)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackendProxy_DidFinalizeRenderingUpdate)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackendProxy_DidFlush)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_CacheFont)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_CacheNativeImage)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_CreateImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_DeleteAllFonts)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_FinalizeRenderingUpdate)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_PutPixelBufferForImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_ReleaseRemoteResource)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayerManager_ReleaseLayer)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_ClearEnqueuedSamples)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_EnqueueSample)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_EnqueueSampleCV)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_Flush)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_FlushAndRemoveImage)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_Pause)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_Play)
        return true;
#if !RELEASE_LOG_DISABLED
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_SetLogIdentifier)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameMemory)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameSemaphore)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_UpdateAffineTransform)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_UpdateBoundsAndPosition)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayer_UpdateDisplayMode)
        return true;
    if (messageName == IPC::MessageName::RemoteSampler_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteShaderModule_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_Abort)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_AddTrackBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_Append)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_ClearTrackBuffers)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_ReenqueueMediaIfNeeded)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_RemoveCodedFrames)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_RemovedFromMediaSource)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_ResetParserState)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_ResetTimestampOffsetInTrackBuffers)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_ResetTrackBuffers)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SeekToTime)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetActive)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetAllTrackBuffersNeedRandomAccess)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetAppendWindowEnd)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetAppendWindowStart)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetGroupStartTimestamp)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetGroupStartTimestampToEndTimestamp)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetMediaSourceEnded)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetMode)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetReadyState)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetShouldGenerateTimestamps)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_SetTimestampOffset)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_StartChangingType)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_UpdateTrackIds)
        return true;
    if (messageName == IPC::MessageName::RemoteTextureView_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteTexture_CreateView)
        return true;
    if (messageName == IPC::MessageName::RemoteTexture_Destroy)
        return true;
    if (messageName == IPC::MessageName::RemoteTexture_SetLabel)
        return true;
    if (messageName == IPC::MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewVideoFrameBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameMemory)
        return true;
    if (messageName == IPC::MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameSemaphore)
        return true;
    if (messageName == IPC::MessageName::RemoteVideoFrameObjectHeapProxyProcessor_VideoFrameBufferNotFound)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::RemoteVideoFrameObjectHeap_GetVideoFrameBuffer)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteVideoFrameObjectHeap_ReleaseVideoFrame)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_Append)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_BringToFront)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_FrontendDidClose)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_FrontendLoaded)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_OpenURLExternally)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_Reopen)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_ResetState)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_Save)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_SendMessageToBackend)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_SetForcedAppearance)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_SetSheetRect)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_ShowCertificate)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUIProxy_StartWindowDrag)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_DidAppend)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_DidSave)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_Initialize)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_SendMessageToFrontend)
        return true;
#if ENABLE(INSPECTOR_TELEMETRY)
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_SetDiagnosticLoggingAvailable)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_ShowConsole)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_ShowResources)
        return true;
    if (messageName == IPC::MessageName::RemoteWebInspectorUI_UpdateFindString)
        return true;
    if (messageName == IPC::MessageName::RemoteWebLockRegistry_DidCompleteLockRequest)
        return true;
    if (messageName == IPC::MessageName::RemoteWebLockRegistry_DidStealLock)
        return true;
    if (messageName == IPC::MessageName::SampleBufferDisplayLayer_SetDidFail)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerDownloadTask_DidFail)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerDownloadTask_DidFinish)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerDownloadTask_DidReceiveData)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerDownloadTask_DidReceiveFormData)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidFail)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidFinish)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidNotHandle)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidReceiveData)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidReceiveFormData)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidReceiveRedirectResponse)
        return true;
    if (messageName == IPC::MessageName::ServiceWorkerFetchTask_DidReceiveResponse)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateAppendComplete)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateAppendError)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateBufferedDirtyChanged)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidDropSample)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidParseSample)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegment)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveRenderingError)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDurationChanged)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateHighestPresentationTimestampChanged)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateReportExtraMemoryCost)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateStreamEndedWithDecodeError)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionRealtimeMediaSourceManager_CreateSource)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionRealtimeMediaSourceManager_DeleteSource)
        return true;
#if ENABLE(SANDBOX_EXTENSIONS)
    if (messageName == IPC::MessageName::SpeechRecognitionRealtimeMediaSourceManager_GrantSandboxExtensions)
        return true;
#endif
#if ENABLE(SANDBOX_EXTENSIONS)
    if (messageName == IPC::MessageName::SpeechRecognitionRealtimeMediaSourceManager_RevokeSandboxExtensions)
        return true;
#endif
    if (messageName == IPC::MessageName::SpeechRecognitionRealtimeMediaSourceManager_Start)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionRealtimeMediaSourceManager_Stop)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteAudioSamplesAvailable)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteCaptureFailed)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteSourceStopped)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_SetStorage)
        return true;
#endif
    if (messageName == IPC::MessageName::SpeechRecognitionServer_Abort)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionServer_Invalidate)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionServer_Start)
        return true;
    if (messageName == IPC::MessageName::SpeechRecognitionServer_Stop)
        return true;
    if (messageName == IPC::MessageName::StorageAreaMap_ClearCache)
        return true;
    if (messageName == IPC::MessageName::StorageAreaMap_DispatchStorageEvent)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_Clear)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_CloneSessionStorageNamespace)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_DisconnectFromStorageArea)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_RemoveItem)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_SetItem)
        return true;
#if !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture)
        return true;
#endif
#if !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold)
        return true;
#endif
#if !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture)
        return true;
#endif
#if !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold)
        return true;
#endif
    if (messageName == IPC::MessageName::VisitedLinkStore_AddVisitedLinkHashFromPage)
        return true;
    if (messageName == IPC::MessageName::VisitedLinkTableController_AllVisitedLinkStateChanged)
        return true;
    if (messageName == IPC::MessageName::VisitedLinkTableController_RemoveAllVisitedLinks)
        return true;
    if (messageName == IPC::MessageName::VisitedLinkTableController_SetVisitedLinkTable)
        return true;
    if (messageName == IPC::MessageName::VisitedLinkTableController_VisitedLinkStateChanged)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ComputeElementLayout)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_DeleteCookie)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_GetCookiesForFrame)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveParentFrame)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_SelectOptionElement)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_TakeScreenshot)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSession_DidEvaluateJavaScriptFunction)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSession_DidTakeScreenshot)
        return true;
    if (messageName == IPC::MessageName::WebBroadcastChannelRegistry_PostMessageToRemote)
        return true;
    if (messageName == IPC::MessageName::WebConnection_HandleMessage)
        return true;
    if (messageName == IPC::MessageName::WebCookieManagerProxy_CookiesDidChange)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_DeleteAllCookies)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_DeleteAllCookiesModifiedSince)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_DeleteCookie)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_DeleteCookiesForHostnames)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetAllCookies)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetCookies)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetHostnamesWithCookies)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_SetCookie)
        return true;
#if USE(SOUP)
    if (messageName == IPC::MessageName::WebCookieManager_SetCookiePersistentStorage)
        return true;
#endif
    if (messageName == IPC::MessageName::WebCookieManager_SetCookies)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_StartObservingCookieChanges)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_StopObservingCookieChanges)
        return true;
    if (messageName == IPC::MessageName::WebFileSystemStorageConnection_InvalidateAccessHandle)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManagerProxy_BeganExitFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManagerProxy_Close)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManagerProxy_EnterFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManagerProxy_ExitFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_DidEnterFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_DidExitFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_RequestEnterFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_RequestExitFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_RestoreScrollPosition)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_SaveScrollPosition)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_SetAnimatingFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_SetFullscreenAutoHideDuration)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_SetFullscreenControlsHidden)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_SetFullscreenInsets)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_WillEnterFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManager_WillExitFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebGeolocationManagerProxy_SetEnableHighAccuracy)
        return true;
    if (messageName == IPC::MessageName::WebGeolocationManagerProxy_StartUpdating)
        return true;
    if (messageName == IPC::MessageName::WebGeolocationManagerProxy_StopUpdating)
        return true;
    if (messageName == IPC::MessageName::WebGeolocationManager_DidChangePosition)
        return true;
    if (messageName == IPC::MessageName::WebGeolocationManager_DidFailToDeterminePosition)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebGeolocationManager_ResetPermissions)
        return true;
#endif
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidAbortTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidClearObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidCloseFromServer)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidCommitTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidCreateIndex)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidCreateObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidDeleteDatabase)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidDeleteIndex)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidDeleteObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidDeleteRecord)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidGetAllDatabaseNamesAndVersions)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidGetAllRecords)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidGetCount)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidGetRecord)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidIterateCursor)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidOpenCursor)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidOpenDatabase)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidPutOrAdd)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidRenameIndex)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidRenameObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_DidStartTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_FireVersionChangeEvent)
        return true;
    if (messageName == IPC::MessageName::WebIDBConnectionToServer_NotifyOpenDBRequestBlocked)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_AbortOpenAndUpgradeNeeded)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_AbortTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_ClearObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_CommitTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_CreateIndex)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_CreateObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DatabaseConnectionClosed)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DatabaseConnectionPendingClose)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DeleteDatabase)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DeleteIndex)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DeleteObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DeleteRecord)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DidFinishHandlingVersionChangeTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_DidFireVersionChangeEvent)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_EstablishTransaction)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_GetAllDatabaseNamesAndVersions)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_GetAllRecords)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_GetCount)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_GetRecord)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_IterateCursor)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_OpenCursor)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_OpenDBRequestCancelled)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_OpenDatabase)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_PutOrAdd)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_RenameIndex)
        return true;
    if (messageName == IPC::MessageName::WebIDBServer_RenameObjectStore)
        return true;
    if (messageName == IPC::MessageName::WebInspectorInterruptDispatcher_NotifyNeedDebuggerBreak)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_Append)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_AttachAvailabilityChanged)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_AttachBottom)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_AttachLeft)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_AttachRight)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_BringInspectedPageToFront)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_BringToFront)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_Detach)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_DidClose)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_ElementSelectionChanged)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_FrontendLoaded)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_InspectedURLChanged)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_OpenLocalInspectorFrontend)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_OpenURLExternally)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_Reopen)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_ResetState)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_Save)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SendMessageToBackend)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SetAttachedWindowHeight)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SetAttachedWindowWidth)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SetDeveloperPreferenceOverride)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SetForcedAppearance)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SetFrontendConnection)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_SetSheetRect)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_ShowCertificate)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_StartWindowDrag)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUIProxy_TimelineRecordingChanged)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_AttachedBottom)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_AttachedLeft)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_AttachedRight)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_Detached)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_DidAppend)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_DidSave)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_EstablishConnection)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_EvaluateInFrontendForTesting)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_SendMessageToFrontend)
        return true;
#if ENABLE(INSPECTOR_TELEMETRY)
    if (messageName == IPC::MessageName::WebInspectorUI_SetDiagnosticLoggingAvailable)
        return true;
#endif
    if (messageName == IPC::MessageName::WebInspectorUI_SetDockingUnavailable)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_SetIsVisible)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_ShowConsole)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_ShowMainResourceForFrame)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_ShowResources)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_StartElementSelection)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_StartPageProfiling)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_StopElementSelection)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_StopPageProfiling)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_UpdateConnection)
        return true;
    if (messageName == IPC::MessageName::WebInspectorUI_UpdateFindString)
        return true;
    if (messageName == IPC::MessageName::WebInspector_Close)
        return true;
    if (messageName == IPC::MessageName::WebInspector_SetAttached)
        return true;
    if (messageName == IPC::MessageName::WebInspector_SetFrontendConnection)
        return true;
    if (messageName == IPC::MessageName::WebInspector_Show)
        return true;
    if (messageName == IPC::MessageName::WebInspector_ShowConsole)
        return true;
    if (messageName == IPC::MessageName::WebInspector_ShowMainResourceForFrame)
        return true;
    if (messageName == IPC::MessageName::WebInspector_ShowResources)
        return true;
    if (messageName == IPC::MessageName::WebInspector_StartElementSelection)
        return true;
    if (messageName == IPC::MessageName::WebInspector_StartPageProfiling)
        return true;
    if (messageName == IPC::MessageName::WebInspector_StopElementSelection)
        return true;
    if (messageName == IPC::MessageName::WebInspector_StopPageProfiling)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_AbortLockRequest)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_ClientIsGoingAway)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_ReleaseLock)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_RequestLock)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_Snapshot)
        return true;
    if (messageName == IPC::MessageName::WebMDNSRegister_FinishedRegisteringMDNSName)
        return true;
    if (messageName == IPC::MessageName::WebNotificationManager_DidClickNotification)
        return true;
    if (messageName == IPC::MessageName::WebNotificationManager_DidCloseNotifications)
        return true;
    if (messageName == IPC::MessageName::WebNotificationManager_DidRemoveNotificationDecisions)
        return true;
    if (messageName == IPC::MessageName::WebNotificationManager_DidShowNotification)
        return true;
    if (messageName == IPC::MessageName::WebNotificationManager_DidUpdateNotificationDecision)
        return true;
#if ENABLE(APPLE_PAY_AMS_UI)
    if (messageName == IPC::MessageName::WebPageProxy_AbortApplePayAMSUISession)
        return true;
#endif
#if ENABLE(MEDIA_USAGE)
    if (messageName == IPC::MessageName::WebPageProxy_AddMediaUsageManagerSession)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_AddPlaybackTargetPickerClient)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_AssistiveTechnologyMakeFirstResponder)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_BackForwardAddItem)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_BackForwardClear)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPageProxy_BeginMonitoringCaptureDevices)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPageProxy_BindAccessibilityTree)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_ChangeUniversalAccessZoomFocus)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ClassifyModalContainerControls)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ClearAllEditCommands)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ClearTextIndicator)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_CloneAttachmentData)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ClosePage)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_CommitPotentialTapFailed)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_CompositionWasCanceled)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ConfigureLoggingChannel)
        return true;
#if ENABLE(CONTENT_FILTERING)
    if (messageName == IPC::MessageName::WebPageProxy_ContentFilterDidBlockLoadForFrame)
        return true;
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    if (messageName == IPC::MessageName::WebPageProxy_ContentRuleListNotification)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_CouldNotRestorePageState)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_CreateInspectorTarget)
        return true;
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPageProxy_CreatePDFHUD)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DecidePolicyForModalContainer)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DecidePolicyForNewWindowAction)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DecidePolicyForResponse)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DestroyInspectorTarget)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidCancelClientRedirectForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeContentSize)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeInspectorFrontendCount)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeIntrinsicContentSize)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeMainDocument)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangePageCount)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeProgress)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeProvisionalURLForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeScrollOffsetPinningForMainFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeScrollbarsForMainFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidChangeViewportProperties)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidCommitLoadForFrame)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_DidCompleteSyntheticClick)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidCountStringMatches)
        return true;
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    if (messageName == IPC::MessageName::WebPageProxy_DidCreateContextInWebProcessForVisibilityPropagation)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidCreateMainFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidCreateSubframe)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidCreateWindow)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidDestroyNavigation)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidDetectXSSForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidDisplayInsecureContentForFrame)
        return true;
#if ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_DidEndDragging)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidExplicitOpenForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFailLoadForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFailProvisionalLoadForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFailToFindString)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFailToSuspendAfterProcessSwap)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFindString)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFindStringMatches)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFindTextManipulationItems)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFinishDocumentLoadForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFinishLoadForFrame)
        return true;
#if USE(QUICK_LOOK)
    if (messageName == IPC::MessageName::WebPageProxy_DidFinishLoadForQuickLookDocumentInMainFrame)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidFinishLoadingDataForCustomContentProvider)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFinishProgress)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::WebPageProxy_DidFinishServiceWorkerPageRegistration)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidFirstLayoutForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidFirstVisuallyNonEmptyLayoutForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidGetImageForFindMatch)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_DidGetTapHighlightGeometries)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_DidHandleAcceptedCandidate)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_DidHandleAdditionalDragItemsRequest)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_DidHandleDragStartRequest)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_DidInsertAttachmentWithIdentifier)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidNavigateWithNavigationData)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_DidNotHandleTapAsClick)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidPerformClientRedirect)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_DidPerformDictionaryLookup)
        return true;
#endif
#if ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_DidPerformDragControllerAction)
        return true;
#endif
#if ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_DidPerformDragOperation)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_DidPerformImmediateActionHitTest)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidPerformServerRedirect)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidReachLayoutMilestone)
        return true;
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_DidReceiveEditDragSnapshot)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidReceiveEvent)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_DidReceivePositionInformation)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidReceiveServerRedirectForProvisionalLoadForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidReceiveTitleForFrame)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_DidRemoveAttachmentWithIdentifier)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidResignInputElementStrongPasswordAppearance)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidRestoreScrollPosition)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidRunInsecureContentForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidSameDocumentNavigationForFrame)
        return true;
#if USE(QUICK_LOOK)
    if (messageName == IPC::MessageName::WebPageProxy_DidStartLoadForQuickLookDocumentInMainFrame)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_DidStartProgress)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidStartProvisionalLoadForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidSuspendAfterProcessSwap)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidUpdateActivityState)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidUpdateHistoryTitle)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DidUpdateRenderingAfterCommittingLoad)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_DisableDoubleTapGesturesDuringTapIfNecessary)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_DisableInspectorNodeSearch)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_DismissCorrectionPanel)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_EditorStateChanged)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ElementDidBlur)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ElementDidFocus)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_EnableInspectorNodeSearch)
        return true;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    if (messageName == IPC::MessageName::WebPageProxy_EndColorPicker)
        return true;
#endif
#if ENABLE(DATALIST_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_EndDataListSuggestions)
        return true;
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    if (messageName == IPC::MessageName::WebPageProxy_EndDateTimePicker)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPageProxy_EnumerateMediaDevicesForFrame)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_FixedLayoutSizeDidChange)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_FocusedElementDidChangeInputMode)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_FocusedFrameChanged)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_GetLoadDecisionForIcon)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_HandleAcceptsFirstMouse)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_HandleAutoFillButtonClick)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_HandleAutocorrectionContext)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_HandleAutoplayEvent)
        return true;
#if ENABLE(DATA_DETECTION)
    if (messageName == IPC::MessageName::WebPageProxy_HandleClickForDataDetectionResult)
        return true;
#endif
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
    if (messageName == IPC::MessageName::WebPageProxy_HandleContextMenuTranslation)
        return true;
#endif
#if ENABLE(DATALIST_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_HandleKeydownInDataList)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_HandleMessage)
        return true;
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_HandleMouseDownForModelElement)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_HandleMouseMoveForModelElement)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_HandleMouseUpForModelElement)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_HandleSmartMagnificationInformationForPotentialTap)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_HideInspectorHighlight)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_HideInspectorIndication)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_HidePopupMenu)
        return true;
#if PLATFORM(COCOA) || PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPageProxy_HideValidationMessage)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_IgnoreWord)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ImageOrMediaDocumentSizeChanged)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_IsPlayingMediaDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LearnWord)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogDiagnosticMessageFromWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogDiagnosticMessageWithDomainFromWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogDiagnosticMessageWithEnhancedPrivacyFromWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogDiagnosticMessageWithResultFromWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogDiagnosticMessageWithValueDictionaryFromWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogDiagnosticMessageWithValueFromWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LogScrollingEvent)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_MainFramePluginHandlesPageScaleGestureDidChange)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_MakeFirstResponder)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_MockMediaPlaybackTargetPickerDismissPopup)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementAnimationCurrentTime)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementAnimationDuration)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementDidCreatePreview)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementGetCamera)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementHasAudio)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementIsLoopingAnimation)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementIsMuted)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementIsPlayingAnimation)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetCamera)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetInteractionEnabled)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetIsMuted)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSizeDidChange)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_MouseDidMoveOverElement)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_NotifyScrollerThumbIsVisibleInRect)
        return true;
#if ENABLE(PDFKIT_PLUGIN) && !ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPageProxy_OpenPDFFromTemporaryFolderWithNativeApplication)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_PageDidScroll)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_PageExtendedBackgroundColorDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_PageScaleFactorDidChange)
        return true;
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_PlaybackTargetPickerClientStateDidChange)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_PluginScaleFactorDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_PluginZoomFactorDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_QueryPermission)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RecommendedScrollbarStyleDidChange)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_RecordAutocorrectionResponse)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_RegisterAttachmentIdentifier)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_RegisterAttachmentIdentifierFromData)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_RegisterAttachmentIdentifierFromFilePath)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_RegisterAttachmentsFromSerializedData)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_RegisterEditCommandForUndo)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RegisterInsertionUndoGrouping)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_RegisterWebProcessAccessibilityToken)
        return true;
#endif
#if USE(DICTATION_ALTERNATIVES)
    if (messageName == IPC::MessageName::WebPageProxy_RemoveDictationAlternatives)
        return true;
#endif
#if ENABLE(MEDIA_USAGE)
    if (messageName == IPC::MessageName::WebPageProxy_RemoveMediaUsageManagerSession)
        return true;
#endif
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPageProxy_RemovePDFHUD)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_RemovePlaybackTargetPickerClient)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_RequestAttachmentIcon)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_RequestCheckingOfString)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RequestCookieConsent)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RequestGeolocationPermissionForFrame)
        return true;
#if ENABLE(VIDEO) && USE(GSTREAMER)
    if (messageName == IPC::MessageName::WebPageProxy_RequestInstallMissingMediaPlugins)
        return true;
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::WebPageProxy_RequestMediaKeySystemPermissionForFrame)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_RequestNotificationPermission)
        return true;
#if USE(QUICK_LOOK)
    if (messageName == IPC::MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame)
        return true;
#endif
#if ENABLE(POINTER_LOCK)
    if (messageName == IPC::MessageName::WebPageProxy_RequestPointerLock)
        return true;
#endif
#if ENABLE(POINTER_LOCK)
    if (messageName == IPC::MessageName::WebPageProxy_RequestPointerUnlock)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_RequestScrollToRect)
        return true;
#if ENABLE(IMAGE_ANALYSIS)
    if (messageName == IPC::MessageName::WebPageProxy_RequestTextRecognition)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPageProxy_RequestUserMediaPermissionForFrame)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_RestorePageCenterAndScale)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_RestorePageState)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_RevokeGeolocationAuthorizationToken)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RunModal)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RunOpenPanel)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SampledPageTopColorChanged)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_SaveImageToLibrary)
        return true;
#endif
#if ENABLE(PDFKIT_PLUGIN) && !ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPageProxy_SavePDFToFileInDownloadsFolder)
        return true;
#endif
#if ENABLE(PDFKIT_PLUGIN) && !ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPageProxy_SavePDFToTemporaryFolderAndOpenWithNativeApplication)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SaveRecentSearches)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ScrollingNodeScrollDidEndScroll)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ScrollingNodeScrollWillStartScroll)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_SearchTheWeb)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_SearchWithSpotlight)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SendMessageToInspectorFrontend)
        return true;
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPageProxy_SendMessageToWebView)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPageProxy_SendMessageToWebViewWithReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetCanShortCircuitHorizontalWheelEvents)
        return true;
#if ENABLE(INPUT_TYPE_COLOR)
    if (messageName == IPC::MessageName::WebPageProxy_SetColorPickerColor)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetCursor)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetCursorHiddenUntilMouseMoves)
        return true;
#if ENABLE(DATA_DETECTION)
    if (messageName == IPC::MessageName::WebPageProxy_SetDataDetectionResult)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_SetEditableElementIsFocused)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetFocus)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetHasActiveAnimatedScrolls)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetHasExecutedAppBoundBehaviorBeforeNavigation)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetHasHadSelectionChangesFromUserInteraction)
        return true;
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPageProxy_SetInputMethodState)
        return true;
#endif
#if HAVE(TOUCH_BAR)
    if (messageName == IPC::MessageName::WebPageProxy_SetIsNeverRichlyEditableForTouchBar)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetIsResizable)
        return true;
#if HAVE(TOUCH_BAR)
    if (messageName == IPC::MessageName::WebPageProxy_SetIsTouchBarUpdateSupressedForHiddenContentEditable)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetIsUsingHighPerformanceWebGL)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetMenuBarIsVisible)
        return true;
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerEnabled)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerState)
        return true;
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (messageName == IPC::MessageName::WebPageProxy_SetMockVideoPresentationModeEnabled)
        return true;
#endif
#if ENABLE(WEB_AUTHN)
    if (messageName == IPC::MessageName::WebPageProxy_SetMockWebAuthenticationConfiguration)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetNetworkRequestsInProgress)
        return true;
#if PLATFORM(COCOA) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_SetPromisedDataForImage)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SetRenderTreeSize)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetStatusBarIsVisible)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetStatusText)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetTextIndicator)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetToolbarsAreVisible)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_SetWindowFrame)
        return true;
#if ENABLE(DEVICE_ORIENTATION)
    if (messageName == IPC::MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess)
        return true;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    if (messageName == IPC::MessageName::WebPageProxy_ShowColorPicker)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ShowContactPicker)
        return true;
#if ENABLE(CONTEXT_MENUS)
    if (messageName == IPC::MessageName::WebPageProxy_ShowContextMenu)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_ShowCorrectionPanel)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ShowDataDetectorsUIForPositionInformation)
        return true;
#endif
#if ENABLE(DATALIST_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_ShowDataListSuggestions)
        return true;
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    if (messageName == IPC::MessageName::WebPageProxy_ShowDateTimePicker)
        return true;
#endif
#if USE(DICTATION_ALTERNATIVES)
    if (messageName == IPC::MessageName::WebPageProxy_ShowDictationAlternativeUI)
        return true;
#endif
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPageProxy_ShowEmojiPicker)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ShowInspectorHighlight)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ShowInspectorIndication)
        return true;
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
    if (messageName == IPC::MessageName::WebPageProxy_ShowMediaControlsContextMenu)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ShowPage)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ShowPlaybackTargetPicker)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_ShowPlaybackTargetPicker)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ShowPopupMenu)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ShowShareSheet)
        return true;
#if (ENABLE(TELEPHONE_NUMBER_DETECTION) && PLATFORM(MAC))
    if (messageName == IPC::MessageName::WebPageProxy_ShowTelephoneNumberMenu)
        return true;
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPageProxy_ShowValidationMessage)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_Speak)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisCancel)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisPause)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisResetState)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisResume)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisSpeak)
        return true;
#endif
#if ENABLE(APPLE_PAY_AMS_UI)
    if (messageName == IPC::MessageName::WebPageProxy_StartApplePayAMSUISession)
        return true;
#endif
#if PLATFORM(COCOA) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_StartDrag)
        return true;
#endif
#if PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_StartDrag)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_StartURLSchemeTask)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_StopSpeaking)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_StopURLSchemeTask)
        return true;
#if ENABLE(APP_HIGHLIGHTS)
    if (messageName == IPC::MessageName::WebPageProxy_StoreAppHighlight)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_TakeFocus)
        return true;
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    if (messageName == IPC::MessageName::WebPageProxy_TakeModelElementFullscreen)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ThemeColorChanged)
        return true;
#if HAVE(TOUCH_BAR)
    if (messageName == IPC::MessageName::WebPageProxy_TouchBarMenuDataChanged)
        return true;
#endif
#if HAVE(TOUCH_BAR)
    if (messageName == IPC::MessageName::WebPageProxy_TouchBarMenuItemDataAdded)
        return true;
#endif
#if HAVE(TOUCH_BAR)
    if (messageName == IPC::MessageName::WebPageProxy_TouchBarMenuItemDataRemoved)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_UnableToImplementPolicy)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_UpdateInputContextAfterBlurringAndRefocusingElement)
        return true;
#endif
#if ENABLE(MEDIA_USAGE)
    if (messageName == IPC::MessageName::WebPageProxy_UpdateMediaUsageManagerSessionState)
        return true;
#endif
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPageProxy_UpdatePDFHUDLocation)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_UpdateSpellingUIWithGrammarString)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_UpdateSpellingUIWithMisspelledWord)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_UpdateStringForFind)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_UseFixedLayoutDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_WillGoToBackForwardListItem)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_WillPerformClientRedirectForFrame)
        return true;
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPageProxy_WillReceiveEditDragSnapshot)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_WillSubmitForm)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_WritePromisedAttachmentToPasteboard)
        return true;
#endif
#if USE(AUTOMATIC_TEXT_REPLACEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_toggleAutomaticDashSubstitution)
        return true;
#endif
#if USE(AUTOMATIC_TEXT_REPLACEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_toggleAutomaticLinkDetection)
        return true;
#endif
#if USE(AUTOMATIC_TEXT_REPLACEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_toggleAutomaticQuoteSubstitution)
        return true;
#endif
#if USE(AUTOMATIC_TEXT_REPLACEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_toggleAutomaticTextReplacement)
        return true;
#endif
#if USE(AUTOMATIC_TEXT_REPLACEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_toggleSmartInsertDelete)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_AccessibilitySettingsDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPage_AddConsoleMessage)
        return true;
    if (messageName == IPC::MessageName::WebPage_AddMIMETypeWithCustomContentProvider)
        return true;
    if (messageName == IPC::MessageName::WebPage_AdvanceToNextMisspelling)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationDidBecomeActive)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationDidEnterBackground)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationDidEnterBackgroundForMedia)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationDidFinishSnapshottingAfterEnteringBackground)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationWillEnterForeground)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationWillEnterForegroundForMedia)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplicationWillResignActive)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplyAutocorrection)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_AttemptSyntheticClick)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_AttributedSubstringForCharacterRangeAsync)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_AutofillLoginCredentials)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_BeginPrinting)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_BeginSelectionInDirection)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_BlurFocusedElement)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPage_BoundaryEventOccurred)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_CancelAutoscroll)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPage_CancelComposition)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_CancelPointer)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_CancelPotentialTap)
        return true;
#endif
#if USE(APPKIT)
    if (messageName == IPC::MessageName::WebPage_CapitalizeWord)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPage_CaptureDevicesChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_CenterSelectionInVisibleArea)
        return true;
    if (messageName == IPC::MessageName::WebPage_ChangeFont)
        return true;
    if (messageName == IPC::MessageName::WebPage_ChangeFontAttributes)
        return true;
    if (messageName == IPC::MessageName::WebPage_ChangeListType)
        return true;
    if (messageName == IPC::MessageName::WebPage_ChangeSpellingToWord)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_CharacterIndexForPointAsync)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ClearAllDecoratedFoundText)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebPage_ClearLoadedSubresourceDomains)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ClearSelection)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ClearServiceWorkerEntitlementOverride)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ClearWheelEventTestMonitor)
        return true;
    if (messageName == IPC::MessageName::WebPage_Close)
        return true;
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPage_CollapseSelectionInFrame)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_CommitPotentialTap)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_CompleteTextManipulation)
        return true;
    if (messageName == IPC::MessageName::WebPage_ComputePagesForPrinting)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_ConfirmCompositionAsync)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ConnectInspector)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ContentSizeCategoryDidChange)
        return true;
#endif
#if ENABLE(CONTEXT_MENUS)
    if (messageName == IPC::MessageName::WebPage_ContextMenuForKeyEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ContinueWillSubmitForm)
        return true;
    if (messageName == IPC::MessageName::WebPage_CountStringMatches)
        return true;
#if ENABLE(APP_HIGHLIGHTS)
    if (messageName == IPC::MessageName::WebPage_CreateAppHighlightInSelectedRange)
        return true;
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    if (messageName == IPC::MessageName::WebPage_CreateMediaSessionCoordinator)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_DataDetectorsDidChangeUI)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_DataDetectorsDidHideUI)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_DataDetectorsDidPresentUI)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DecorateTextRangeWithStyle)
        return true;
    if (messageName == IPC::MessageName::WebPage_DecreaseListLevel)
        return true;
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPage_DeleteSurrounding)
        return true;
#endif
#if ENABLE(DATA_DETECTION)
    if (messageName == IPC::MessageName::WebPage_DetectDataInAllFrames)
        return true;
#endif
#if ENABLE(POINTER_LOCK)
    if (messageName == IPC::MessageName::WebPage_DidAcquirePointerLock)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DidBeginTextSearchOperation)
        return true;
    if (messageName == IPC::MessageName::WebPage_DidCancelCheckingText)
        return true;
    if (messageName == IPC::MessageName::WebPage_DidCancelForOpenPanel)
        return true;
    if (messageName == IPC::MessageName::WebPage_DidChangeSelectedIndexForActivePopupMenu)
        return true;
#if ENABLE(INPUT_TYPE_COLOR)
    if (messageName == IPC::MessageName::WebPage_DidChooseColor)
        return true;
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    if (messageName == IPC::MessageName::WebPage_DidChooseDate)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DidChooseFilesForOpenPanel)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_DidChooseFilesForOpenPanelWithDisplayStringAndIcon)
        return true;
#endif
#if ENABLE(DATALIST_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_DidCloseSuggestions)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_DidConcludeDrop)
        return true;
#endif
#if ENABLE(CONTEXT_MENUS)
    if (messageName == IPC::MessageName::WebPage_DidDismissContextMenu)
        return true;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    if (messageName == IPC::MessageName::WebPage_DidEndColorPicker)
        return true;
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    if (messageName == IPC::MessageName::WebPage_DidEndDateTimePicker)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_DidEndMagnificationGesture)
        return true;
#endif
#if ENABLE(VIDEO) && USE(GSTREAMER)
    if (messageName == IPC::MessageName::WebPage_DidEndRequestInstallMissingMediaPlugins)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DidEndTextSearchOperation)
        return true;
    if (messageName == IPC::MessageName::WebPage_DidFinishCheckingText)
        return true;
    if (messageName == IPC::MessageName::WebPage_DidGetLoadDecisionForIcon)
        return true;
#if ENABLE(POINTER_LOCK)
    if (messageName == IPC::MessageName::WebPage_DidLosePointerLock)
        return true;
#endif
#if ENABLE(POINTER_LOCK)
    if (messageName == IPC::MessageName::WebPage_DidNotAcquirePointerLock)
        return true;
#endif
#if ENABLE(GEOLOCATION)
    if (messageName == IPC::MessageName::WebPage_DidReceiveGeolocationPermissionDecision)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DidReceivePolicyDecision)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_DidRecognizeLongPress)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DidRemoveBackForwardItem)
        return true;
    if (messageName == IPC::MessageName::WebPage_DidRemoveEditCommand)
        return true;
#if ENABLE(DATALIST_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_DidSelectDataListOption)
        return true;
#endif
#if ENABLE(CONTEXT_MENUS)
    if (messageName == IPC::MessageName::WebPage_DidSelectItemFromActiveContextMenu)
        return true;
#endif
#if ENABLE(CONTEXT_MENUS)
    if (messageName == IPC::MessageName::WebPage_DidShowContextMenu)
        return true;
#endif
#if ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_DidStartDrag)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DisconnectInspector)
        return true;
    if (messageName == IPC::MessageName::WebPage_DispatchWheelEventWithoutScrolling)
        return true;
#if ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_DragCancelled)
        return true;
#endif
#if ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_DragEnded)
        return true;
#endif
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPage_DrawPagesForPrinting)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_DrawPagesToPDF)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_DrawRectToImage)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_DrawToPDF)
        return true;
#endif
#if (PLATFORM(COCOA) && PLATFORM(IOS_FAMILY))
    if (messageName == IPC::MessageName::WebPage_DrawToPDFiOS)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_DynamicViewportSizeUpdate)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_EffectiveAppearanceDidChange)
        return true;
    if (messageName == IPC::MessageName::WebPage_EndPrinting)
        return true;
    if (messageName == IPC::MessageName::WebPage_EnqueueSecurityPolicyViolationEvent)
        return true;
    if (messageName == IPC::MessageName::WebPage_ExecuteEditCommand)
        return true;
    if (messageName == IPC::MessageName::WebPage_ExecuteEditCommandWithCallback)
        return true;
#if ENABLE(SANDBOX_EXTENSIONS)
    if (messageName == IPC::MessageName::WebPage_ExtendSandboxForFilesFromOpenPanel)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ExtendSelection)
        return true;
#endif
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPage_FailedToShowPopupMenu)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_FindRectsForStringMatches)
        return true;
    if (messageName == IPC::MessageName::WebPage_FindString)
        return true;
    if (messageName == IPC::MessageName::WebPage_FindStringMatches)
        return true;
    if (messageName == IPC::MessageName::WebPage_FindTextRangesForStringMatches)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_FirstRectForCharacterRangeAsync)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_FocusNextFocusedElement)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_FocusTextInputContextAndPlaceCaret)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ForceRepaint)
        return true;
    if (messageName == IPC::MessageName::WebPage_FrameBecameRemote)
        return true;
    if (messageName == IPC::MessageName::WebPage_FreezeLayerTreeDueToSwipeAnimation)
        return true;
#if ENABLE(GAMEPAD)
    if (messageName == IPC::MessageName::WebPage_GamepadActivity)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GenerateSyntheticEditingCommand)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetAllFrames)
        return true;
#if ENABLE(APPLICATION_MANIFEST)
    if (messageName == IPC::MessageName::WebPage_GetApplicationManifest)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetBytecodeProfile)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetContentsAsAttributedString)
        return true;
#endif
#if ENABLE(MHTML)
    if (messageName == IPC::MessageName::WebPage_GetContentsAsMHTMLData)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetContentsAsString)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetImageForFindMatch)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebPage_GetLoadedSubresourceDomains)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetMainResourceDataOfFrame)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetMarkedRangeAsync)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetPDFFirstPageSize)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetProcessDisplayName)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetRectsAtSelectionOffsetWithText)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetRectsForGranularityWithSelectionOffset)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetRenderTreeExternalRepresentation)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetResourceDataFromFrame)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetSamplingProfilerOutput)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetSelectedRangeAsync)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetSelectionAsWebArchiveData)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetSelectionContext)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetSelectionOrContentsAsString)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetSourceForFrame)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetWebArchiveOfFrame)
        return true;
    if (messageName == IPC::MessageName::WebPage_GoToBackForwardItem)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_HandleAcceptedCandidate)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_HandleAlternativeTextUIResult)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_HandleAutocorrectionContextRequest)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_HandleDoubleTapForDoubleClickAtPoint)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_HandleTwoFingerTapAtPoint)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_HardwareKeyboardAvailabilityChanged)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_HasMarkedText)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_HideFindIndicator)
        return true;
    if (messageName == IPC::MessageName::WebPage_HideFindUI)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_ImmediateActionDidCancel)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_ImmediateActionDidComplete)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_ImmediateActionDidUpdate)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_IncreaseListLevel)
        return true;
    if (messageName == IPC::MessageName::WebPage_IndicateFindMatch)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_InsertAttachment)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_InsertDictatedTextAsync)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_InsertDroppedImagePlaceholders)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_InsertTextAsync)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_InsertTextPlaceholder)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_InspectorNodeSearchEndedAtPosition)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_InspectorNodeSearchMovedToPosition)
        return true;
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    if (messageName == IPC::MessageName::WebPage_InstallCroppedImageOverlay)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_InteractableRegionsInRootViewCoordinates)
        return true;
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    if (messageName == IPC::MessageName::WebPage_InvalidateMediaSessionCoordinator)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_IsLayerTreeFrozen)
        return true;
    if (messageName == IPC::MessageName::WebPage_KeyEvent)
        return true;
    if (messageName == IPC::MessageName::WebPage_LastNavigationWasAppInitiated)
        return true;
    if (messageName == IPC::MessageName::WebPage_ListenForLayoutMilestones)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadAlternateHTML)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadData)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadDataInFrame)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadRequest)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadRequestWaitingForProcessLaunch)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadSimulatedRequestAndResponse)
        return true;
    if (messageName == IPC::MessageName::WebPage_LoadURLInFrame)
        return true;
#if USE(APPKIT)
    if (messageName == IPC::MessageName::WebPage_LowercaseWord)
        return true;
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::WebPage_MediaKeySystemWasDenied)
        return true;
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::WebPage_MediaKeySystemWasGranted)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_MouseEvent)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_MoveSelectionAtBoundaryWithDirection)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_MoveSelectionByOffset)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_NavigateToPDFLinkWithSimulatedClick)
        return true;
    if (messageName == IPC::MessageName::WebPage_NotifyUserScripts)
        return true;
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPage_OpenPDFWithPreview)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_PauseAllMediaPlayback)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_PerformActionOnElement)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_PerformDictionaryLookupAtLocation)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_PerformDictionaryLookupOfCurrentSelection)
        return true;
#endif
#if PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_PerformDragControllerAction)
        return true;
#endif
#if !PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_PerformDragControllerAction)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_PerformImmediateActionHitTestAtLocation)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_PlaybackTargetAvailabilityDidChange)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_PlaybackTargetPickerWasDismissed)
        return true;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_PlaybackTargetSelected)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_PostInjectedBundleMessage)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_PotentialTapAtPosition)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_PreferencesDidChange)
        return true;
#if (PLATFORM(IOS_FAMILY) && ENABLE(REVEAL))
    if (messageName == IPC::MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ReapplyEditCommand)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_RegisterUIProcessAccessibilityTokens)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_RegisterURLSchemeHandler)
        return true;
    if (messageName == IPC::MessageName::WebPage_Reload)
        return true;
#if ENABLE(DATA_DETECTION)
    if (messageName == IPC::MessageName::WebPage_RemoveDataDetectedLinks)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RemoveTextPlaceholder)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ReplaceDictatedText)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ReplaceMatches)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ReplaceSelectedText)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_ReplaceSelectionWithPasteboardData)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_ReplaceWithPasteboardData)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_RequestAcceptsFirstMouse)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_RequestActiveNowPlayingSessionInfo)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_RequestAdditionalItemsForDragSession)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestAutocorrectionData)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestDictationContext)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestDocumentEditingContext)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_RequestDragStart)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestEvasionRectsAboveSelection)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestFocusedElementInformation)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_RequestFontAttributesAtSelectionStart)
        return true;
    if (messageName == IPC::MessageName::WebPage_RequestImageBitmap)
        return true;
    if (messageName == IPC::MessageName::WebPage_RequestMediaPlaybackState)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestPositionInformation)
        return true;
#endif
#if (PLATFORM(IOS_FAMILY) && ENABLE(REVEAL))
    if (messageName == IPC::MessageName::WebPage_RequestRVItemInCurrentSelectedRange)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_RequestRectForFoundTextRange)
        return true;
#if ENABLE(IOS_TOUCH_EVENTS)
    if (messageName == IPC::MessageName::WebPage_ResetPotentialTapSecurityOrigin)
        return true;
#endif
#if ENABLE(APP_HIGHLIGHTS)
    if (messageName == IPC::MessageName::WebPage_RestoreAppHighlightsAndScrollToIndex)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_RestoreSelectionInFocusedEditableElement)
        return true;
    if (messageName == IPC::MessageName::WebPage_RestoreSession)
        return true;
    if (messageName == IPC::MessageName::WebPage_Resume)
        return true;
    if (messageName == IPC::MessageName::WebPage_ResumeActiveDOMObjectsAndAnimations)
        return true;
    if (messageName == IPC::MessageName::WebPage_ResumeAllMediaPlayback)
        return true;
    if (messageName == IPC::MessageName::WebPage_RunJavaScriptInFrameInScriptWorld)
        return true;
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPage_SavePDF)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ScalePage)
        return true;
    if (messageName == IPC::MessageName::WebPage_ScalePageInViewCoordinates)
        return true;
    if (messageName == IPC::MessageName::WebPage_ScaleView)
        return true;
    if (messageName == IPC::MessageName::WebPage_ScheduleFullEditorStateUpdate)
        return true;
    if (messageName == IPC::MessageName::WebPage_ScrollBy)
        return true;
    if (messageName == IPC::MessageName::WebPage_ScrollTextRangeToVisible)
        return true;
    if (messageName == IPC::MessageName::WebPage_ScrollToRect)
        return true;
    if (messageName == IPC::MessageName::WebPage_SelectAll)
        return true;
    if (messageName == IPC::MessageName::WebPage_SelectFindMatch)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectPositionAtBoundaryWithDirection)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectPositionAtPoint)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectTextWithGranularityAtPoint)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectWithGesture)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectWithTwoTouches)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectWordBackward)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SendCSPViolationReport)
        return true;
    if (messageName == IPC::MessageName::WebPage_SendMessageToTargetBackend)
        return true;
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPage_SendMessageToWebExtension)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPage_SendMessageToWebExtensionWithReply)
        return true;
#endif
#if HAVE(APP_ACCENT_COLORS)
    if (messageName == IPC::MessageName::WebPage_SetAccentColor)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetActivityState)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetAllowsMediaDocumentInlinePlayback)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetAlwaysShowsHorizontalScroller)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetAlwaysShowsVerticalScroller)
        return true;
#if ENABLE(APP_HIGHLIGHTS)
    if (messageName == IPC::MessageName::WebPage_SetAppHighlightsVisibility)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetAutoSizingShouldExpandToViewHeight)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetBackgroundColor)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetBackgroundExtendsBeyondPage)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetBaseWritingDirection)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetCanRunBeforeUnloadConfirmPanel)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetCanRunModal)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetCanShowPlaceholder)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetCanUseCredentialStorage)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_SetCompositionAsync)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetControlledByAutomation)
        return true;
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    if (messageName == IPC::MessageName::WebPage_SetCroppedImageOverlayVisibility)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetCurrentHistoryItemForReattach)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetCustomTextEncodingName)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetDefersLoading)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetDeviceOrientation)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetEditable)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetEnableHorizontalRubberBanding)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetEnableVerticalRubberBanding)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetFixedLayoutSize)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetFocusedElementSelectedIndex)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetFocusedElementValue)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_SetFooterBannerHeightForTesting)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetForceAlwaysUserScalable)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetGapBetweenPages)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetHasResourceLoadClient)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_SetHeaderBannerHeightForTesting)
        return true;
#endif
#if ENABLE(REMOTE_INSPECTOR)
    if (messageName == IPC::MessageName::WebPage_SetIndicating)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetInitialFocus)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetIsShowingInputViewForFocusedElement)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetIsSuspended)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetIsTakingSnapshotsForApplicationSuspension)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetLayerHostingMode)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_SetMainFrameIsScrollable)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetMaximumUnobscuredSize)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetMayStartMediaWhenInWindow)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetMediaVolume)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetMinimumSizeForAutoLayout)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetMinimumUnobscuredSize)
        return true;
#endif
#if (ENABLE(MEDIA_STREAM) && USE(GSTREAMER))
    if (messageName == IPC::MessageName::WebPage_SetMockCameraIsInterrupted)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetMuted)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetNeedsDOMWindowResizeEvent)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetNeedsFontAttributes)
        return true;
#if (ENABLE(MEDIA_STREAM) && USE(GSTREAMER))
    if (messageName == IPC::MessageName::WebPage_SetOrientationForMediaCapture)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetOverriddenMediaType)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetOverrideViewportArguments)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetPageAndTextZoomFactors)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetPageLength)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetPageZoomFactor)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetPaginationBehavesLikeColumns)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetPaginationLineGridEnabled)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetPaginationMode)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetScreenIsBeingCaptured)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetScrollPinningBehavior)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetScrollbarOverlayStyle)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetShouldDispatchFakeMouseMoveEvents)
        return true;
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetShouldPlayToPlaybackTarget)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetShouldRevealCurrentSelectionAfterInsertion)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetShouldScaleViewToFitDocument)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetSizeToContentAutoSizeMaximumSize)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_SetSmartInsertDeleteEnabled)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetSuppressScrollbarAnimations)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_SetTextAsync)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetTextForActivePopupMenu)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetTextZoomFactor)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetTopContentInset)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_SetTopContentInsetFenced)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetUnderPageBackgroundColorOverride)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetUnderlayColor)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetUseFixedLayout)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetUseIconLoadingClient)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_SetUseSystemAppearance)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetUserAgent)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetUserInterfaceLayoutDirection)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SetViewportConfigurationViewLayoutSize)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetViewportSizeForCSSViewportUnits)
        return true;
    if (messageName == IPC::MessageName::WebPage_SimulateDeviceOrientationChange)
        return true;
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPage_SpeakingErrorOccurred)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_StartAutoscrollAtPosition)
        return true;
#endif
#if ENABLE(IMAGE_ANALYSIS)
    if (messageName == IPC::MessageName::WebPage_StartImageAnalysis)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_StartInteractionWithElementContextOrPosition)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_StartTextManipulations)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_StopInteraction)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_StopLoading)
        return true;
    if (messageName == IPC::MessageName::WebPage_StopLoadingFrame)
        return true;
    if (messageName == IPC::MessageName::WebPage_StopMediaCapture)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_StoreSelectionForAccessibility)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_Suspend)
        return true;
    if (messageName == IPC::MessageName::WebPage_SuspendActiveDOMObjectsAndAnimations)
        return true;
    if (messageName == IPC::MessageName::WebPage_SuspendAllMediaPlayback)
        return true;
#if USE(SYSTEM_PREVIEW)
    if (messageName == IPC::MessageName::WebPage_SystemPreviewActionTriggered)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_TakeSnapshot)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_TapHighlightAtPosition)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_TextInputContextsInRect)
        return true;
#endif
#if !ENABLE(IOS_TOUCH_EVENTS) && ENABLE(TOUCH_EVENTS)
    if (messageName == IPC::MessageName::WebPage_TouchEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_TouchWithIdentifierWasRemoved)
        return true;
    if (messageName == IPC::MessageName::WebPage_TryClose)
        return true;
    if (messageName == IPC::MessageName::WebPage_TryRestoreScrollPosition)
        return true;
    if (messageName == IPC::MessageName::WebPage_URLSchemeTaskDidComplete)
        return true;
    if (messageName == IPC::MessageName::WebPage_URLSchemeTaskDidPerformRedirection)
        return true;
    if (messageName == IPC::MessageName::WebPage_URLSchemeTaskDidReceiveData)
        return true;
    if (messageName == IPC::MessageName::WebPage_URLSchemeTaskDidReceiveResponse)
        return true;
    if (messageName == IPC::MessageName::WebPage_URLSchemeTaskWillPerformRedirection)
        return true;
    if (messageName == IPC::MessageName::WebPage_UnapplyEditCommand)
        return true;
    if (messageName == IPC::MessageName::WebPage_UnfreezeLayerTreeDueToSwipeAnimation)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_UpdateAttachmentAttributes)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_UpdateAttachmentIcon)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_UpdateAttachmentThumbnail)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_UpdateBackForwardListForReattach)
        return true;
    if (messageName == IPC::MessageName::WebPage_UpdateCORSDisablingPatterns)
        return true;
    if (messageName == IPC::MessageName::WebPage_UpdateCurrentModifierState)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithDelta)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithExtentPoint)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithTouches)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_UpdateWebsitePolicies)
        return true;
#if ENABLE(IMAGE_ANALYSIS)
    if (messageName == IPC::MessageName::WebPage_UpdateWithTextRecognitionResult)
        return true;
#endif
#if USE(APPKIT)
    if (messageName == IPC::MessageName::WebPage_UppercaseWord)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPage_UserMediaAccessWasDenied)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPage_UserMediaAccessWasGranted)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ValidateCommand)
        return true;
    if (messageName == IPC::MessageName::WebPage_ViewWillEndLiveResize)
        return true;
    if (messageName == IPC::MessageName::WebPage_ViewWillStartLiveResize)
        return true;
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPage_VoicesDidChange)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebPage_WasLoadedWithDataTransferFromPrevalentResource)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_WillStartUserTriggeredZooming)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_WindowAndViewFramesChanged)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_WindowScreenDidChange)
        return true;
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPage_ZoomPDFIn)
        return true;
#endif
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPage_ZoomPDFOut)
        return true;
#endif
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPasteboardProxy_ClearClipboard)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPasteboardProxy_UpdateSupportedTypeIdentifiers)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteImageToPasteboard)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteStringToPasteboard)
        return true;
#endif
#if USE(LIBWPE)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteStringToPasteboard)
        return true;
#endif
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteToClipboard)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteURLToPasteboard)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteWebContentToPasteboard)
        return true;
#endif
#if USE(LIBWPE)
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteWebContentToPasteboard)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcessPool_HandleMessage)
        return true;
    if (messageName == IPC::MessageName::WebProcessPool_ReportWebContentCPUTime)
        return true;
#if ENABLE(GAMEPAD)
    if (messageName == IPC::MessageName::WebProcessPool_StartedUsingGamepads)
        return true;
#endif
#if ENABLE(GAMEPAD)
    if (messageName == IPC::MessageName::WebProcessPool_StoppedUsingGamepads)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcessProxy_CacheMediaMIMETypes)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcessProxy_CreateSpeechRecognitionServer)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DestroySpeechRecognitionServer)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidCollectPrewarmInformation)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidCreateSleepDisabler)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidDestroyFrame)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidDestroySleepDisabler)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidDestroyUserGestureToken)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidExceedActiveMemoryLimit)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidExceedCPULimit)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidExceedInactiveMemoryLimit)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidExceedInactiveMemoryLimitWhileActive)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DidReceiveBackgroundResponsivenessPing)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_DisableSuddenTermination)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_EnableSuddenTermination)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_MemoryPressureStatusChanged)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcessProxy_ReleaseHighPerformanceGPU)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcessProxy_RequestHighPerformanceGPU)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebProcessProxy_SendMessageToWebContext)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebProcessProxy_SendMessageToWebContextWithReply)
        return true;
#endif
#if HAVE(MEDIA_ACCESSIBILITY_FRAMEWORK)
    if (messageName == IPC::MessageName::WebProcessProxy_SetCaptionDisplayMode)
        return true;
#endif
#if HAVE(MEDIA_ACCESSIBILITY_FRAMEWORK)
    if (messageName == IPC::MessageName::WebProcessProxy_SetCaptionLanguage)
        return true;
#endif
#if HAVE(CVDISPLAYLINK)
    if (messageName == IPC::MessageName::WebProcessProxy_SetDisplayLinkPreferredFramesPerSecond)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcessProxy_SetIsHoldingLockedFiles)
        return true;
#if HAVE(CVDISPLAYLINK)
    if (messageName == IPC::MessageName::WebProcessProxy_StartDisplayLink)
        return true;
#endif
#if HAVE(CVDISPLAYLINK)
    if (messageName == IPC::MessageName::WebProcessProxy_StopDisplayLink)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcessProxy_StopResponsivenessTimer)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_SystemBeep)
        return true;
    if (messageName == IPC::MessageName::WebProcessProxy_UpdateBackForwardItem)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_AccessibilityPreferencesDidChange)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebProcess_AddMockMediaDevice)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_BackgroundResponsivenessPing)
        return true;
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    if (messageName == IPC::MessageName::WebProcess_BacklightLevelDidChange)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_ClearCachedPage)
        return true;
    if (messageName == IPC::MessageName::WebProcess_ClearCurrentModifierStateForTesting)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebProcess_ClearMockMediaDevices)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_ClearResourceLoadStatistics)
        return true;
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    if (messageName == IPC::MessageName::WebProcess_ColorPreferencesDidChange)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_ConsumeAudioComponentRegistrations)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_CreateWebPage)
        return true;
    if (messageName == IPC::MessageName::WebProcess_DeleteWebsiteData)
        return true;
    if (messageName == IPC::MessageName::WebProcess_DeleteWebsiteDataForOrigins)
        return true;
    if (messageName == IPC::MessageName::WebProcess_DestroyAutomationSessionProxy)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_DidWriteToPasteboardAsynchronously)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcess_DisplayConfigurationChanged)
        return true;
#endif
#if HAVE(CVDISPLAYLINK)
    if (messageName == IPC::MessageName::WebProcess_DisplayWasRefreshed)
        return true;
#endif
#if (PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR))
    if (messageName == IPC::MessageName::WebProcess_EnableRemoteWebInspector)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_EnsureAutomationSessionProxy)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcess)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcess)
        return true;
    if (messageName == IPC::MessageName::WebProcess_FetchWebsiteData)
        return true;
    if (messageName == IPC::MessageName::WebProcess_FullKeyboardAccessModeChanged)
        return true;
#if ENABLE(GAMEPAD)
    if (messageName == IPC::MessageName::WebProcess_GamepadConnected)
        return true;
#endif
#if ENABLE(GAMEPAD)
    if (messageName == IPC::MessageName::WebProcess_GamepadDisconnected)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_GarbageCollectJavaScriptObjects)
        return true;
    if (messageName == IPC::MessageName::WebProcess_GetActivePagesOriginsForTesting)
        return true;
    if (messageName == IPC::MessageName::WebProcess_GrantAccessToAssetServices)
        return true;
#if (ENABLE(MEDIA_STREAM) && ENABLE(SANDBOX_EXTENSIONS))
    if (messageName == IPC::MessageName::WebProcess_GrantUserMediaDeviceSandboxExtensions)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_HandleInjectedBundleMessage)
        return true;
    if (messageName == IPC::MessageName::WebProcess_InitializeWebProcess)
        return true;
    if (messageName == IPC::MessageName::WebProcess_IsJITEnabled)
        return true;
    if (messageName == IPC::MessageName::WebProcess_MarkIsNoLongerPrewarmed)
        return true;
#if (PLATFORM(COCOA) && ENABLE(CFPREFS_DIRECT_MODE))
    if (messageName == IPC::MessageName::WebProcess_NotifyPreferencesChanged)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_PowerSourceDidChange)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_PrepareToSuspend)
        return true;
    if (messageName == IPC::MessageName::WebProcess_PrewarmWithDomainInformation)
        return true;
    if (messageName == IPC::MessageName::WebProcess_ProcessDidResume)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RefreshPlugins)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsCORSEnabled)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsCachePartitioned)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsCanDisplayOnlyIfCanRequest)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsDisplayIsolated)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsEmptyDocument)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsLocal)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsNoAccess)
        return true;
    if (messageName == IPC::MessageName::WebProcess_RegisterURLSchemeAsSecure)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebProcess_RemoveMockMediaDevice)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebProcess_ResetMockMediaDevices)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_RevokeAccessToAssetServices)
        return true;
#if (ENABLE(MEDIA_STREAM) && ENABLE(SANDBOX_EXTENSIONS))
    if (messageName == IPC::MessageName::WebProcess_RevokeUserMediaDeviceSandboxExtensions)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcess_ScrollerStylePreferenceChanged)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SeedResourceLoadStatisticsForTesting)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebProcess_SendMessageToWebExtension)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetAlwaysUsesComplexTextCodePath)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetBackForwardCacheCapacity)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetCacheModel)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetDefaultRequestTimeoutInterval)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetDomainRelaxationForbiddenForURLScheme)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SetDomainsWithUserInteraction)
        return true;
#endif
#if ENABLE(SERVICE_CONTROLS)
    if (messageName == IPC::MessageName::WebProcess_SetEnabledServices)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetEnhancedAccessibility)
        return true;
#if HAVE(MOUSE_DEVICE_OBSERVATION)
    if (messageName == IPC::MessageName::WebProcess_SetHasMouseDevice)
        return true;
#endif
#if HAVE(STYLUS_DEVICE_OBSERVATION)
    if (messageName == IPC::MessageName::WebProcess_SetHasStylusDevice)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetHasSuspendedPageProxy)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetHiddenPageDOMTimerThrottlingIncreaseLimit)
        return true;
#if ENABLE(GAMEPAD)
    if (messageName == IPC::MessageName::WebProcess_SetInitialGamepads)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetInjectedBundleParameter)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetInjectedBundleParameters)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetIsInProcessCache)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetJavaScriptGarbageCollectorTimerEnabled)
        return true;
#if HAVE(MEDIA_ACCESSIBILITY_FRAMEWORK)
    if (messageName == IPC::MessageName::WebProcess_SetMediaAccessibilityPreferences)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_SetMediaMIMETypes)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetMemoryCacheDisabled)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetResourceLoadStatisticsEnabled)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_SetScreenProperties)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetShouldUseFontSmoothing)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SetTextCheckerState)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SetThirdPartyCookieBlockingMode)
        return true;
#endif
#if PLATFORM(GTK) && !USE(GTK4)
    if (messageName == IPC::MessageName::WebProcess_SetUseSystemAppearanceForScrollbars)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_SetWebsiteDataStoreParameters)
        return true;
    if (messageName == IPC::MessageName::WebProcess_StartMemorySampler)
        return true;
    if (messageName == IPC::MessageName::WebProcess_StopMemorySampler)
        return true;
    if (messageName == IPC::MessageName::WebProcess_SwitchFromStaticFontRegistryToUserFontRegistry)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcess_SystemDidWake)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcess_SystemWillPowerOn)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcess_SystemWillSleep)
        return true;
#endif
#if (PLATFORM(COCOA) && ENABLE(CFPREFS_DIRECT_MODE))
    if (messageName == IPC::MessageName::WebProcess_UnblockPreferenceService)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebProcess_UnblockServicesRequiredByAccessibility)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebProcess_UserInterfaceIdiomDidChange)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_UserPreferredLanguagesChanged)
        return true;
    if (messageName == IPC::MessageName::WebRTCMonitor_NetworksChanged)
        return true;
    if (messageName == IPC::MessageName::WebRTCResolver_ResolvedAddressError)
        return true;
    if (messageName == IPC::MessageName::WebRTCResolver_SetResolvedAddress)
        return true;
#if ENABLE(CONTENT_FILTERING_IN_NETWORKING_PROCESS)
    if (messageName == IPC::MessageName::WebResourceLoader_CancelMainResourceLoadForContentFilter)
        return true;
#endif
#if ENABLE(CONTENT_FILTERING_IN_NETWORKING_PROCESS)
    if (messageName == IPC::MessageName::WebResourceLoader_ContentFilterDidBlockLoad)
        return true;
#endif
    if (messageName == IPC::MessageName::WebResourceLoader_DidBlockAuthenticationChallenge)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_DidFailResourceLoad)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_DidFailServiceWorkerLoad)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_DidFinishResourceLoad)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_DidReceiveData)
        return true;
#if ENABLE(SHAREABLE_RESOURCE)
    if (messageName == IPC::MessageName::WebResourceLoader_DidReceiveResource)
        return true;
#endif
    if (messageName == IPC::MessageName::WebResourceLoader_DidReceiveResponse)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_DidSendData)
        return true;
#if ENABLE(CONTENT_FILTERING_IN_NETWORKING_PROCESS)
    if (messageName == IPC::MessageName::WebResourceLoader_HandleProvisionalLoadFailureFromContentFilter)
        return true;
#endif
    if (messageName == IPC::MessageName::WebResourceLoader_ServiceWorkerDidNotHandle)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_StopLoadingAfterXFrameOptionsOrContentSecurityPolicyDenied)
        return true;
    if (messageName == IPC::MessageName::WebResourceLoader_WillSendRequest)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_FireUpdateFoundEvent)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_JobRejectedInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_NotifyClientsOfControllerChange)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_PostMessageToServiceWorkerClient)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_RegistrationJobResolvedInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_SetDocumentIsControlled)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_SetRegistrationLastUpdateTime)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_SetRegistrationUpdateViaCache)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_SetSWOriginTableIsImported)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_SetSWOriginTableSharedMemory)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_StartScriptFetchForServer)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_UpdateRegistrationState)
        return true;
    if (messageName == IPC::MessageName::WebSWClientConnection_UpdateWorkerState)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_CancelFetch)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_Close)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_ContinueDidReceiveFetchResponse)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_ConvertFetchToDownload)
        return true;
#if ENABLE(SHAREABLE_RESOURCE) && PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_DidSaveScriptsToDisk)
        return true;
#endif
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_FireActivateEvent)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_FireInstallEvent)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_FirePushEvent)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_InstallServiceWorker)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_MatchAllCompleted)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_PostMessageToServiceWorker)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_SetThrottleState)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_SetUserAgent)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_StartFetch)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_TerminateWorker)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_UpdateAppInitiatedValue)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_UpdatePreferencesStore)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_AddServiceWorkerRegistrationInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_DidResolveRegistrationPromise)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_DisableNavigationPreload)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_EnableNavigationPreload)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_FinishFetchingScriptInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetNavigationPreloadState)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetPushPermissionState)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetPushSubscription)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetRegistrations)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_MatchRegistration)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_PostMessageToServiceWorker)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_RegisterServiceWorkerClient)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_RemoveServiceWorkerRegistrationInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_ScheduleJobInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_SetThrottleState)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_StoreRegistrationsOnDisk)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_SubscribeToPushService)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_TerminateWorkerFromClient)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_UnregisterServiceWorkerClient)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_UnsubscribeFromPushService)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_WhenRegistrationReady)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_Claim)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_DidFailHeartBeatCheck)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_DidFinishActivation)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_DidFinishInstall)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_MatchAll)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_PostMessageToServiceWorkerClient)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_ScriptContextFailedToStart)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_ScriptContextStarted)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_SetScriptResource)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_SetServiceWorkerHasPendingEvents)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_SkipWaiting)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_WorkerTerminated)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerContextManagerConnection_Close)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerContextManagerConnection_LaunchSharedWorker)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerContextManagerConnection_SetUserAgent)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerContextManagerConnection_TerminateSharedWorker)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerContextManagerConnection_UpdatePreferencesStore)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerObjectConnection_NotifyWorkerObjectOfLoadCompletion)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerObjectConnection_PostExceptionToWorkerObject)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerServerConnection_RequestSharedWorker)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerServerConnection_SharedWorkerObjectIsGoingAway)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerServerToContextConnection_PostExceptionToWorkerObject)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidClose)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidConnect)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidReceiveBinaryData)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidReceiveHandshakeResponse)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidReceiveMessageError)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidReceiveText)
        return true;
    if (messageName == IPC::MessageName::WebSocketChannel_DidSendHandshakeRequest)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidCloseSocketStream)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidFailSocketStream)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidFailToReceiveSocketStreamData)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidOpenSocketStream)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidReceiveSocketStreamData)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidSendData)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidSendHandshake)
        return true;
    if (messageName == IPC::MessageName::WebSocketStream_DidUpdateBufferedAmount)
        return true;
    if (messageName == IPC::MessageName::WebSpeechRecognitionConnection_DidReceiveUpdate)
        return true;
    if (messageName == IPC::MessageName::WebUserContentControllerProxy_DidPostMessage)
        return true;
#if ENABLE(CONTENT_EXTENSIONS)
    if (messageName == IPC::MessageName::WebUserContentController_AddContentRuleLists)
        return true;
#endif
    if (messageName == IPC::MessageName::WebUserContentController_AddContentWorlds)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_AddUserScriptMessageHandlers)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_AddUserScripts)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_AddUserStyleSheets)
        return true;
#if ENABLE(CONTENT_EXTENSIONS)
    if (messageName == IPC::MessageName::WebUserContentController_RemoveAllContentRuleLists)
        return true;
#endif
    if (messageName == IPC::MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlers)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlersForWorlds)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_RemoveAllUserScripts)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_RemoveAllUserStyleSheets)
        return true;
#if ENABLE(CONTENT_EXTENSIONS)
    if (messageName == IPC::MessageName::WebUserContentController_RemoveContentRuleList)
        return true;
#endif
    if (messageName == IPC::MessageName::WebUserContentController_RemoveContentWorlds)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_RemoveUserScript)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_RemoveUserScriptMessageHandler)
        return true;
    if (messageName == IPC::MessageName::WebUserContentController_RemoveUserStyleSheet)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::InitializeConnection)
        return true;
#endif
    if (messageName == IPC::MessageName::LegacySessionState)
        return true;
    if (messageName == IPC::MessageName::ProcessOutOfStreamMessage)
        return true;
    if (messageName == IPC::MessageName::SetStreamDestinationID)
        return true;
    if (messageName == IPC::MessageName::SyncMessageReply)
        return true;
    if (messageName == IPC::MessageName::Terminate)
        return true;
    if (messageName == IPC::MessageName::AuxiliaryProcess_MainThreadPingReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_CachesReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_ClearMemoryRepresentationReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_DeleteMatchingRecordsReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_EngineRepresentationReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_OpenReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_PutRecordsReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_RemoveReply)
        return true;
    if (messageName == IPC::MessageName::CacheStorageEngineConnection_RetrieveRecordsReply)
        return true;
    if (messageName == IPC::MessageName::DownloadProxy_DecideDestinationWithSuggestedFilenameReply)
        return true;
#if ENABLE(IOS_TOUCH_EVENTS)
    if (messageName == IPC::MessageName::EventDispatcher_TouchEventReply)
        return true;
#endif
#if ENABLE(ROUTING_ARBITRATION)
    if (messageName == IPC::MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategoryReply)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_CreateGPUConnectionToWebProcessReply)
        return true;
    if (messageName == IPC::MessageName::GPUProcess_PrepareToSuspendReply)
        return true;
    if (messageName == IPC::MessageName::GPUProcess_RequestBitmapImageForCurrentTimeReply)
        return true;
#if HAVE(SC_CONTENT_SHARING_SESSION)
    if (messageName == IPC::MessageName::GPUProcess_ShowScreenPickerReply)
        return true;
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
    if (messageName == IPC::MessageName::GPUProcess_ShowWindowPickerReply)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::GPUProcess_UpdateCaptureAccessReply)
        return true;
#endif
    if (messageName == IPC::MessageName::GPUProcess_WebProcessConnectionCountForTestingReply)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_GetRawCookiesReply)
        return true;
#endif
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_RequestResourceReply)
        return true;
    if (messageName == IPC::MessageName::MediaPlayerPrivateRemote_SendH2PingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkBroadcastChannelRegistry_PostMessageReply)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CheckRemotePortForActivityReply)
        return true;
#if ENABLE(WEB_RTC)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSourceReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CreateRTCProviderReply)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnectionReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnectionReply)
        return true;
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_GetProcessDisplayNameReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_HasStorageAccessReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinishedReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_RequestStorageAccessReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdatedReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_SendH2PingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPortReply)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDBReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessConnection_CheckProcessLocalPortForActivityReply)
        return true;
#if ENABLE(WEB_RTC)
    if (messageName == IPC::MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSourceReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomainsReply)
        return true;
#endif
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcessProxy_EstablishServiceWorkerContextConnectionToNetworkProcessReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_EstablishSharedWorkerContextConnectionToNetworkProcessReply)
        return true;
#if ENABLE(APP_BOUND_DOMAINS)
    if (messageName == IPC::MessageName::NetworkProcessProxy_GetAppBoundDomainsReply)
        return true;
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI_USES_SCENE)
    if (messageName == IPC::MessageName::NetworkProcessProxy_GetWindowSceneIdentifierForPaymentPresentationReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_RequestStorageAccessConfirmReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_RequestStorageSpaceReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_RetrieveCacheStorageParametersReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccessReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigationReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::NetworkProcess_AppPrivacyReportTestingDataReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_CancelDownloadReply)
        return true;
#if ENABLE(APP_BOUND_DOMAINS)
    if (messageName == IPC::MessageName::NetworkProcess_ClearAppBoundSessionReply)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::NetworkProcess_ClearAppPrivacyReportTestingDataReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClearBundleIdentifierReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ClearPrevalentResourceReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClearPrivateClickMeasurementReply)
        return true;
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    if (messageName == IPC::MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverrideReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClearStorageReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ClearUserInteractionReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_CloseITPDatabaseReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ClosePCMDatabaseReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_CountNonDefaultSessionSetsReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_CreateNetworkConnectionToWebProcessReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DeleteCookiesForTestingReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_DeletePushAndNotificationRegistrationReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_DeleteWebsiteDataForOriginsReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_DeleteWebsiteDataReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DomainIDExistsInDatabaseReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_DumpPrivateClickMeasurementReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_DumpResourceLoadStatisticsReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_FetchWebsiteDataReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_FlushCookiesReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_GetAllStorageAccessEntriesReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_GetOriginsWithPushAndNotificationPermissionsReply)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcess_GetPendingPushMessagesReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummaryReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_HadUserInteractionReply)
        return true;
#endif
#if ENABLE(APP_BOUND_DOMAINS)
    if (messageName == IPC::MessageName::NetworkProcess_HasAppBoundSessionReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_HasIsolatedSessionReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_HasLocalStorageReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_InsertExpiredStatisticForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsGrandfatheredReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsPrevalentResourceReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRegisteredAsRedirectingToReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRegisteredAsSubFrameUnderReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRegisteredAsSubresourceUnderReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnceReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeralReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_IsVeryPrevalentResourceReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_LogUserInteractionReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTestingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTestingReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_MergeStatisticForTestingReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_PrepareToSuspendReply)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::NetworkProcess_ProcessPushMessageReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_RenameOriginInWebsiteDataReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_RequestResourceReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResourcesReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ResetParametersToDefaultValuesReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_ResetQuotaReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistentReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ScheduleCookieBlockingUpdateReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetAgeCapForClientSideCookiesReply)
        return true;
#endif
#if (ENABLE(INTELLIGENT_TRACKING_PREVENTION) && ENABLE(APP_BOUND_DOMAINS))
    if (messageName == IPC::MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatisticsReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResourcesReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetGrandfatheredReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetGrandfatheringTimeReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTestReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetLastSeenReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetMaxStatisticsEntriesReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemovalReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetNotifyPagesWhenDataRecordsWereScannedReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTestingReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetPrevalentResourceForDebugModeReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetPrevalentResourceReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTestingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTestingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTestingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTestingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTestingReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTestingReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetPruneEntriesDownToReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetResourceLoadStatisticsDebugModeReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemovalReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetShouldDowngradeReferrerForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubframeUnderTopFrameDomainReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomainReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubresourceUniqueRedirectFromReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetSubresourceUniqueRedirectToReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetThirdPartyCookieBlockingModeReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetTimeToLiveUserInteractionReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetTopFrameUniqueRedirectFromReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetTopFrameUniqueRedirectToReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_SetVeryPrevalentResourceReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestartReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_StatisticsDatabaseHasAllTablesReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkProcess_SyncLocalStorageReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_UpdateBundleIdentifierReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesForReply)
        return true;
#endif
    if (messageName == IPC::MessageName::NetworkSocketChannel_SendDataReply)
        return true;
    if (messageName == IPC::MessageName::NetworkSocketChannel_SendStringReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_ClearReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CloseSyncAccessHandleReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_ConnectToStorageAreaReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_CreateSyncAccessHandleReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_FileSystemGetDirectoryReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetDirectoryHandleReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetFileHandleReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetFileReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetHandleNamesReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_GetHandleReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_IsSameEntryReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_MoveReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_PersistReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_PersistedReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_RemoveEntryReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_RemoveItemReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_ResolveReply)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_SetItemReply)
        return true;
    if (messageName == IPC::MessageName::NotificationManagerMessageHandler_RequestSystemNotificationPermissionReply)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_EnumerateImmersiveXRDevicesReply)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_RequestFrameReply)
        return true;
    if (messageName == IPC::MessageName::PlatformXRSystem_RequestPermissionOnSessionFeaturesReply)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_DeleteAudioDestinationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_StartAudioDestinationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_StopAudioDestinationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnitReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceProxy_InitializeWithConfigurationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceProxy_SetServerCertificateReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_CloseSessionReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_LoadSessionReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionDataReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_RequestLicenseReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceSessionProxy_UpdateLicenseReply)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMProxy_GetSupportedConfigurationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfigurationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfigurationReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_DidLoadingProgressReply)
        return true;
#if ENABLE(MEDIA_SOURCE)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_LoadMediaSourceReply)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_LoadReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PerformTaskAtMediaTimeReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_PrepareForPlaybackReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorderManager_CreateRecorderReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_FetchDataReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_PauseReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_ResumeReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaRecorder_StopRecordingReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_RedirectReceivedReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaResourceManager_ResponseReceivedReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePauseReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlayReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekToReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrackReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinatorProxy_JoinReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_PauseSessionReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_PlaySessionReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_SeekSessionToTimeReply)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSessionCoordinator_SetSessionTrackReply)
        return true;
    if (messageName == IPC::MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayerReply)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackIdReply)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackIDReply)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_RemoveCodedFramesReply)
        return true;
    if (messageName == IPC::MessageName::SourceBufferPrivateRemote_SourceBufferPrivateDidReceiveInitializationSegmentReply)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_ClearReply)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_RemoveItemReply)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_SetItemReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ComputeElementLayoutReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_DeleteCookieReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_GetCookiesForFrameReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNameReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandleReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinalReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_ResolveParentFrameReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_SelectOptionElementReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_SetFilesForInputFileUploadReply)
        return true;
    if (messageName == IPC::MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshotReply)
        return true;
    if (messageName == IPC::MessageName::WebBroadcastChannelRegistry_PostMessageToRemoteReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_DeleteAllCookiesModifiedSinceReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_DeleteCookieReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetAllCookiesReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetCookiesReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetHTTPCookieAcceptPolicyReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_GetHostnamesWithCookiesReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_SetCookieReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_SetCookiesReply)
        return true;
    if (messageName == IPC::MessageName::WebCookieManager_SetHTTPCookieAcceptPolicyReply)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_AbortLockRequestReply)
        return true;
    if (messageName == IPC::MessageName::WebLockRegistryProxy_SnapshotReply)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ClassifyModalContainerControlsReply)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DecidePolicyForModalContainerReply)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPageProxy_EnumerateMediaDevicesForFrameReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementAnimationCurrentTimeReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementAnimationDurationReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementDidCreatePreviewReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementGetCameraReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementHasAudioReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementIsLoopingAnimationReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementIsMutedReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementIsPlayingAnimationReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetAnimationCurrentTimeReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetAnimationIsPlayingReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetCameraReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetIsLoopingAnimationReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSetIsMutedReply)
        return true;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    if (messageName == IPC::MessageName::WebPageProxy_ModelElementSizeDidChangeReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_QueryPermissionReply)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RequestCookieConsentReply)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RequestNotificationPermissionReply)
        return true;
#if USE(QUICK_LOOK)
    if (messageName == IPC::MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrameReply)
        return true;
#endif
#if ENABLE(IMAGE_ANALYSIS)
    if (messageName == IPC::MessageName::WebPageProxy_RequestTextRecognitionReply)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPageProxy_SendMessageToWebViewWithReplyReply)
        return true;
#endif
#if ENABLE(DEVICE_ORIENTATION)
    if (messageName == IPC::MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccessReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ShowContactPickerReply)
        return true;
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPageProxy_ShowEmojiPickerReply)
        return true;
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
    if (messageName == IPC::MessageName::WebPageProxy_ShowMediaControlsContextMenuReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ShowShareSheetReply)
        return true;
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisPauseReply)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisResumeReply)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallbackReply)
        return true;
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisSpeakReply)
        return true;
#endif
#if ENABLE(APPLE_PAY_AMS_UI)
    if (messageName == IPC::MessageName::WebPageProxy_StartApplePayAMSUISessionReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ApplyAutocorrectionReply)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPage_AttributedSubstringForCharacterRangeAsyncReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_BeginSelectionInDirectionReply)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_CharacterIndexForPointAsyncReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ClearServiceWorkerEntitlementOverrideReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_CompleteTextManipulationReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_ComputePagesForPrintingReply)
        return true;
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    if (messageName == IPC::MessageName::WebPage_CreateMediaSessionCoordinatorReply)
        return true;
#endif
#if ENABLE(DATA_DETECTION)
    if (messageName == IPC::MessageName::WebPage_DetectDataInAllFramesReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_DidGetLoadDecisionForIconReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_DispatchWheelEventWithoutScrollingReply)
        return true;
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPage_DrawPagesForPrintingReply)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_DrawPagesToPDFReply)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_DrawRectToImageReply)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_DrawToPDFReply)
        return true;
#endif
#if (PLATFORM(COCOA) && PLATFORM(IOS_FAMILY))
    if (messageName == IPC::MessageName::WebPage_DrawToPDFiOSReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ExecuteEditCommandWithCallbackReply)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_ExtendSelectionReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_FindRectsForStringMatchesReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_FindStringReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_FindTextRangesForStringMatchesReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_FirstRectForCharacterRangeAsyncReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_FocusNextFocusedElementReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_FocusTextInputContextAndPlaceCaretReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ForceRepaintReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetAllFramesReply)
        return true;
#if ENABLE(APPLICATION_MANIFEST)
    if (messageName == IPC::MessageName::WebPage_GetApplicationManifestReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetBytecodeProfileReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetContentsAsAttributedStringReply)
        return true;
#endif
#if ENABLE(MHTML)
    if (messageName == IPC::MessageName::WebPage_GetContentsAsMHTMLDataReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetContentsAsStringReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebPage_GetLoadedSubresourceDomainsReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetMainResourceDataOfFrameReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetMarkedRangeAsyncReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetPDFFirstPageSizeReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetProcessDisplayNameReply)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetRectsAtSelectionOffsetWithTextReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetRectsForGranularityWithSelectionOffsetReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetRenderTreeExternalRepresentationReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetResourceDataFromFrameReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetSamplingProfilerOutputReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetSelectedRangeAsyncReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetSelectionAsWebArchiveDataReply)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetSelectionContextReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_GetSelectionOrContentsAsStringReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetSourceForFrameReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_GetWebArchiveOfFrameReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_HasMarkedTextReply)
        return true;
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_InsertAttachmentReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    if (messageName == IPC::MessageName::WebPage_InsertDroppedImagePlaceholdersReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_InsertTextPlaceholderReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_InteractableRegionsInRootViewCoordinatesReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_IsLayerTreeFrozenReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_LastNavigationWasAppInitiatedReply)
        return true;
#if ENABLE(ENCRYPTED_MEDIA)
    if (messageName == IPC::MessageName::WebPage_MediaKeySystemWasGrantedReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_MoveSelectionAtBoundaryWithDirectionReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_MoveSelectionByOffsetReply)
        return true;
#endif
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPage_OpenPDFWithPreviewReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_PauseAllMediaPlaybackReply)
        return true;
#if (PLATFORM(IOS_FAMILY) && ENABLE(REVEAL))
    if (messageName == IPC::MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInViewReply)
        return true;
#endif
#if ENABLE(DATA_DETECTION)
    if (messageName == IPC::MessageName::WebPage_RemoveDataDetectedLinksReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RemoveTextPlaceholderReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ReplaceMatchesReply)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_RequestActiveNowPlayingSessionInfoReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestAutocorrectionDataReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestDictationContextReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestDocumentEditingContextReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestEvasionRectsAboveSelectionReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_RequestFocusedElementInformationReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_RequestFontAttributesAtSelectionStartReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_RequestImageBitmapReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_RequestMediaPlaybackStateReply)
        return true;
#if (PLATFORM(IOS_FAMILY) && ENABLE(REVEAL))
    if (messageName == IPC::MessageName::WebPage_RequestRVItemInCurrentSelectedRangeReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_RequestRectForFoundTextRangeReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_ResumeAllMediaPlaybackReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_ResumeReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_RunJavaScriptInFrameInScriptWorldReply)
        return true;
#if ENABLE(UI_PROCESS_PDF_HUD)
    if (messageName == IPC::MessageName::WebPage_SavePDFReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectPositionAtBoundaryWithDirectionReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectPositionAtPointReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectTextWithGranularityAtPointReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectWithGestureReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SelectWithTwoTouchesReply)
        return true;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebPage_SendMessageToWebExtensionWithReplyReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_SetActivityStateReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetInitialFocusReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_SetMutedReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_StartTextManipulationsReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_StopMediaCaptureReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_SuspendAllMediaPlaybackReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_SuspendReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_TakeSnapshotReply)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_TextInputContextsInRectReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_TryCloseReply)
        return true;
    if (messageName == IPC::MessageName::WebPage_URLSchemeTaskWillPerformRedirectionReply)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPage_UpdateAttachmentAttributesReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithDeltaReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundaryReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithExtentPointReply)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_UpdateSelectionWithTouchesReply)
        return true;
#endif
#if ENABLE(IMAGE_ANALYSIS)
    if (messageName == IPC::MessageName::WebPage_UpdateWithTextRecognitionResultReply)
        return true;
#endif
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::WebPage_UserMediaAccessWasGrantedReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_ValidateCommandReply)
        return true;
#if PLATFORM(GTK) || PLATFORM(WPE)
    if (messageName == IPC::MessageName::WebProcessProxy_SendMessageToWebContextWithReplyReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_ClearCachedPageReply)
        return true;
    if (messageName == IPC::MessageName::WebProcess_DeleteWebsiteDataForOriginsReply)
        return true;
    if (messageName == IPC::MessageName::WebProcess_DeleteWebsiteDataReply)
        return true;
#if ENABLE(SERVICE_WORKER)
    if (messageName == IPC::MessageName::WebProcess_EstablishServiceWorkerContextConnectionToNetworkProcessReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcess_EstablishSharedWorkerContextConnectionToNetworkProcessReply)
        return true;
    if (messageName == IPC::MessageName::WebProcess_FetchWebsiteDataReply)
        return true;
    if (messageName == IPC::MessageName::WebProcess_GetActivePagesOriginsForTestingReply)
        return true;
    if (messageName == IPC::MessageName::WebProcess_IsJITEnabledReply)
        return true;
    if (messageName == IPC::MessageName::WebProcess_PrepareToSuspendReply)
        return true;
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SeedResourceLoadStatisticsForTestingReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SendResourceLoadStatisticsDataImmediatelyReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SetDomainsWithCrossPageStorageAccessReply)
        return true;
#endif
#if ENABLE(INTELLIGENT_TRACKING_PREVENTION)
    if (messageName == IPC::MessageName::WebProcess_SetThirdPartyCookieBlockingModeReply)
        return true;
#endif
    if (messageName == IPC::MessageName::WebSWClientConnection_SetDocumentIsControlledReply)
        return true;
    if (messageName == IPC::MessageName::WebSWContextManagerConnection_FirePushEventReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_DisableNavigationPreloadReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_EnableNavigationPreloadReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetNavigationPreloadStateReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetPushPermissionStateReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetPushSubscriptionReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_GetRegistrationsReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_MatchRegistrationReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_ScheduleUnregisterJobInServerReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValueReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_StoreRegistrationsOnDiskReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_SubscribeToPushServiceReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_TerminateWorkerFromClientReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_UnsubscribeFromPushServiceReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_WhenRegistrationReadyReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTestingReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_ClaimReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifierReply)
        return true;
    if (messageName == IPC::MessageName::WebSWServerToContextConnection_SkipWaitingReply)
        return true;
    if (messageName == IPC::MessageName::WebSharedWorkerObjectConnection_FetchScriptInClientReply)
        return true;
    if (messageName == IPC::MessageName::WebUserContentControllerProxy_DidPostMessageReply)
        return true;
#if USE(AUDIO_SESSION)
    if (messageName == IPC::MessageName::GPUConnectionToWebProcess_EnsureAudioSession)
        return true;
#endif
    if (messageName == IPC::MessageName::IPCTester_StopMessageTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_BlobSize)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_CookiesForDOM)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_DomCookiesForHost)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_GetRawCookies)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics)
        return true;
    if (messageName == IPC::MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetAllowsAnySSLCertificateForWebSocket)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting)
        return true;
    if (messageName == IPC::MessageName::NetworkStorageManager_ConnectToStorageAreaSync)
        return true;
    if (messageName == IPC::MessageName::RemoteAdapter_RequestDevice)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioDestinationManager_CreateAudioDestination)
        return true;
    if (messageName == IPC::MessageName::RemoteAudioSessionProxy_TryToSetActive)
        return true;
    if (messageName == IPC::MessageName::RemoteBuffer_MapAsync)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMFactoryProxy_CreateCDM)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMFactoryProxy_SupportsKeySystem)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMInstanceProxy_CreateSession)
        return true;
    if (messageName == IPC::MessageName::RemoteCDMProxy_CreateInstance)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateComputePipelineAsync)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_CreateRenderPipelineAsync)
        return true;
    if (messageName == IPC::MessageName::RemoteDevice_PopErrorScope)
        return true;
    if (messageName == IPC::MessageName::RemoteGPU_RequestAdapter)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ClientWaitSync)
        return true;
#if ENABLE(VIDEO)
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateProgram)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateRenderbuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateSampler)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateShader)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_CreateVertexArray)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_FenceSync)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetActiveAttrib)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetActiveUniform)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetActiveUniforms)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetAttribLocation)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetBooleanv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetBufferParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetBufferSubData)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetError)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetFloatv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetFragDataLocation)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetGraphicsResetStatusARB)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetInteger64)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetInteger64i)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetIntegerv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetInternalformativ)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetProgramInfoLog)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetProgrami)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetQueryObjectui)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetSamplerParameterf)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetSamplerParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetShaderInfoLog)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetShaderSource)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetShaderi)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetString)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetSynci)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetTexParameterf)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetTexParameteri)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetUniformIndices)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetUniformLocation)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetUniformfv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetUniformiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetUniformuiv)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsEnabled)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsFramebuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsProgram)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsQuery)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsRenderbuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsSampler)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsShader)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsSync)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsTexture)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsTransformFeedback)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_IsVertexArray)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_MoveErrorsToSyntheticErrorList)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PaintCompositedResultsToCanvas)
        return true;
#if ENABLE(MEDIA_STREAM)
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PaintCompositedResultsToMediaSample)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PaintRenderingResultsToCanvas)
        return true;
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PaintRenderingResultsToPixelBuffer)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PrepareForDisplay)
        return true;
#endif
#if USE(GRAPHICS_LAYER_WC)
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PrepareForDisplay)
        return true;
#endif
#if !PLATFORM(COCOA) && !USE(GRAPHICS_LAYER_WC)
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_PrepareForDisplay)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteGraphicsContextGL_ReadnPixels0)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMProxy_CreateSession)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMProxy_SupportsMIMEType)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest)
        return true;
    if (messageName == IPC::MessageName::RemoteLegacyCDMSessionProxy_Update)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_OriginsInMediaCache)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_AccessLog)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_ColorSpace)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_ErrorLog)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime)
        return true;
#endif
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaPlayerProxy_WouldTaintOrigin)
        return true;
    if (messageName == IPC::MessageName::RemoteMediaSourceProxy_AddSourceBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteQueue_OnSubmittedWorkDone)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_GetDataForImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_GetDataURLForImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_GetFilteredImageForImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_GetPixelBufferForImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_GetPixelBufferForImageBufferWithNewMemory)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_GetShareableBitmapForImageBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_MarkSurfaceNonVolatile)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_MarkSurfacesVolatile)
        return true;
    if (messageName == IPC::MessageName::RemoteRenderingBackend_SwapToValidFrontBuffer)
        return true;
    if (messageName == IPC::MessageName::RemoteShaderModule_CompilationInfo)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_CanSwitchToType)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_EvictCodedFrames)
        return true;
    if (messageName == IPC::MessageName::RemoteSourceBufferProxy_UpdateBufferedFromTrackBuffers)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_ConnectToLocalStorageArea)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_ConnectToSessionStorageArea)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_ConnectToTransientLocalStorageArea)
        return true;
    if (messageName == IPC::MessageName::StorageManagerSet_GetValues)
        return true;
    if (messageName == IPC::MessageName::WebFullScreenManagerProxy_SupportsFullScreen)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_AccessibilityScreenToRootView)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_BackForwardGoToItem)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_BackForwardItemAtIndex)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_BackForwardListCounts)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_CanUndoRedo)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_CheckGrammarOfString)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_CheckSpellingOfString)
        return true;
#if USE(UNIFIED_TEXT_CHECKING)
    if (messageName == IPC::MessageName::WebPageProxy_CheckTextOfParagraph)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_CreateNewPage)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_DecidePolicyForNavigationActionSync)
        return true;
#if USE(DICTATION_ALTERNATIVES)
    if (messageName == IPC::MessageName::WebPageProxy_DictationAlternatives)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebPageProxy_DismissCorrectionPanelSoon)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ExceededDatabaseQuota)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_ExecuteSavedCommandBySelector)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_ExecuteUndoRedo)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_GetGuessesForWord)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPageProxy_GetIsSpeaking)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_GetMenuBarIsVisible)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_GetStatusBarIsVisible)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_GetToolbarsAreVisible)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_GetWindowFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_HandleSynchronousMessage)
        return true;
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPageProxy_InterpretKeyEvent)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_LoadRecentSearches)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_LoadSynchronousURLSchemeTask)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_PrintFrame)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ReachedApplicationCacheOriginQuota)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RequestDOMPasteAccess)
        return true;
#if ENABLE(WEBGL)
    if (messageName == IPC::MessageName::WebPageProxy_ResolveWebGLPolicyForURL)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_RootViewToAccessibilityScreen)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RootViewToScreen)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RunJavaScriptAlert)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RunJavaScriptConfirm)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_RunJavaScriptPrompt)
        return true;
    if (messageName == IPC::MessageName::WebPageProxy_ScreenToRootView)
        return true;
#if ENABLE(ATTACHMENT_ELEMENT)
    if (messageName == IPC::MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers)
        return true;
#endif
#if ENABLE(PDFKIT_PLUGIN)
    if (messageName == IPC::MessageName::WebPageProxy_ShowPDFContextMenu)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SignedPublicKeyAndChallengeString)
        return true;
#if ENABLE(SPEECH_SYNTHESIS)
    if (messageName == IPC::MessageName::WebPageProxy_SpeechSynthesisVoiceList)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPageProxy_SpellingUIIsShowing)
        return true;
#if USE(APPKIT)
    if (messageName == IPC::MessageName::WebPageProxy_SubstitutionsPanelIsShowing)
        return true;
#endif
#if ENABLE(WEB_CRYPTO)
    if (messageName == IPC::MessageName::WebPageProxy_UnwrapCryptoKey)
        return true;
#endif
#if ENABLE(WEBGL)
    if (messageName == IPC::MessageName::WebPageProxy_WebGLPolicyForURL)
        return true;
#endif
#if ENABLE(WEB_CRYPTO)
    if (messageName == IPC::MessageName::WebPageProxy_WrapCryptoKey)
        return true;
#endif
#if (PLATFORM(COCOA) && PLATFORM(IOS_FAMILY) && !HAVE(UIKIT_BACKGROUND_THREAD_PRINTING))
    if (messageName == IPC::MessageName::WebPage_ComputePagesForPrintingiOS)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetDataSelectionForPasteboard)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_GetPositionInformation)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_GetStringSelectionForPasteboard)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_ReadSelectionFromPasteboard)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPage_ShouldDelayWindowOrderingEvent)
        return true;
#endif
#if PLATFORM(IOS_FAMILY)
    if (messageName == IPC::MessageName::WebPage_SyncApplyAutocorrection)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply)
        return true;
#if ENABLE(IOS_TOUCH_EVENTS)
    if (messageName == IPC::MessageName::WebPage_TouchEventSync)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_AddPasteboardTypes)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_AllPasteboardItemInfo)
        return true;
    if (messageName == IPC::MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetNumberOfFiles)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardBufferForType)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardChangeCount)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardColor)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardItemsCount)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardStringForType)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardStringsForType)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardTypes)
        return true;
#endif
#if USE(LIBWPE)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardTypes)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetPasteboardURL)
        return true;
#endif
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPasteboardProxy_GetTypes)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_InformationForItemAtIndex)
        return true;
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPasteboardProxy_ReadBuffer)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_ReadBufferFromPasteboard)
        return true;
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPasteboardProxy_ReadFilePaths)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_ReadStringFromPasteboard)
        return true;
#if PLATFORM(GTK)
    if (messageName == IPC::MessageName::WebPasteboardProxy_ReadText)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_ReadURLFromPasteboard)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_SetPasteboardBufferForType)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_SetPasteboardColor)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_SetPasteboardStringForType)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_SetPasteboardTypes)
        return true;
#endif
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_SetPasteboardURL)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite)
        return true;
#if PLATFORM(COCOA)
    if (messageName == IPC::MessageName::WebPasteboardProxy_URLStringSuitableForLoading)
        return true;
#endif
    if (messageName == IPC::MessageName::WebPasteboardProxy_WriteCustomData)
        return true;
    if (messageName == IPC::MessageName::WebProcessPool_HandleSynchronousMessage)
        return true;
#if ENABLE(GPU_PROCESS)
    if (messageName == IPC::MessageName::WebProcessProxy_GetGPUProcessConnection)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcessProxy_GetNetworkProcessConnection)
        return true;
#if ENABLE(WEB_AUTHN)
    if (messageName == IPC::MessageName::WebProcessProxy_GetWebAuthnProcessConnection)
        return true;
#endif
#if PLATFORM(MAC)
    if (messageName == IPC::MessageName::WebProcessProxy_IsAXAuthenticated)
        return true;
#endif
    if (messageName == IPC::MessageName::WebProcessProxy_ShouldTerminate)
        return true;
    if (messageName == IPC::MessageName::WrappedAsyncMessageForTesting)
        return true;
    return false;
};

} // namespace IPC
