/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebInspectorUI.h"

#include "ArgumentCoders.h"
#include "DebuggableInfoData.h"
#include "Decoder.h"
#include "HandleMessage.h"
#include "WebInspectorUIMessages.h"
#include "WebPageProxyIdentifier.h"
#include <wtf/text/WTFString.h>

namespace WebKit {

void WebInspectorUI::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
    if (decoder.messageName() == Messages::WebInspectorUI::EstablishConnection::name())
        return IPC::handleMessage<Messages::WebInspectorUI::EstablishConnection>(connection, decoder, this, &WebInspectorUI::establishConnection);
    if (decoder.messageName() == Messages::WebInspectorUI::UpdateConnection::name())
        return IPC::handleMessage<Messages::WebInspectorUI::UpdateConnection>(connection, decoder, this, &WebInspectorUI::updateConnection);
    if (decoder.messageName() == Messages::WebInspectorUI::AttachedBottom::name())
        return IPC::handleMessage<Messages::WebInspectorUI::AttachedBottom>(connection, decoder, this, &WebInspectorUI::attachedBottom);
    if (decoder.messageName() == Messages::WebInspectorUI::AttachedRight::name())
        return IPC::handleMessage<Messages::WebInspectorUI::AttachedRight>(connection, decoder, this, &WebInspectorUI::attachedRight);
    if (decoder.messageName() == Messages::WebInspectorUI::AttachedLeft::name())
        return IPC::handleMessage<Messages::WebInspectorUI::AttachedLeft>(connection, decoder, this, &WebInspectorUI::attachedLeft);
    if (decoder.messageName() == Messages::WebInspectorUI::Detached::name())
        return IPC::handleMessage<Messages::WebInspectorUI::Detached>(connection, decoder, this, &WebInspectorUI::detached);
    if (decoder.messageName() == Messages::WebInspectorUI::SetDockingUnavailable::name())
        return IPC::handleMessage<Messages::WebInspectorUI::SetDockingUnavailable>(connection, decoder, this, &WebInspectorUI::setDockingUnavailable);
    if (decoder.messageName() == Messages::WebInspectorUI::SetIsVisible::name())
        return IPC::handleMessage<Messages::WebInspectorUI::SetIsVisible>(connection, decoder, this, &WebInspectorUI::setIsVisible);
    if (decoder.messageName() == Messages::WebInspectorUI::UpdateFindString::name())
        return IPC::handleMessage<Messages::WebInspectorUI::UpdateFindString>(connection, decoder, this, &WebInspectorUI::updateFindString);
#if ENABLE(INSPECTOR_TELEMETRY)
    if (decoder.messageName() == Messages::WebInspectorUI::SetDiagnosticLoggingAvailable::name())
        return IPC::handleMessage<Messages::WebInspectorUI::SetDiagnosticLoggingAvailable>(connection, decoder, this, &WebInspectorUI::setDiagnosticLoggingAvailable);
#endif
    if (decoder.messageName() == Messages::WebInspectorUI::ShowConsole::name())
        return IPC::handleMessage<Messages::WebInspectorUI::ShowConsole>(connection, decoder, this, &WebInspectorUI::showConsole);
    if (decoder.messageName() == Messages::WebInspectorUI::ShowResources::name())
        return IPC::handleMessage<Messages::WebInspectorUI::ShowResources>(connection, decoder, this, &WebInspectorUI::showResources);
    if (decoder.messageName() == Messages::WebInspectorUI::ShowMainResourceForFrame::name())
        return IPC::handleMessage<Messages::WebInspectorUI::ShowMainResourceForFrame>(connection, decoder, this, &WebInspectorUI::showMainResourceForFrame);
    if (decoder.messageName() == Messages::WebInspectorUI::StartPageProfiling::name())
        return IPC::handleMessage<Messages::WebInspectorUI::StartPageProfiling>(connection, decoder, this, &WebInspectorUI::startPageProfiling);
    if (decoder.messageName() == Messages::WebInspectorUI::StopPageProfiling::name())
        return IPC::handleMessage<Messages::WebInspectorUI::StopPageProfiling>(connection, decoder, this, &WebInspectorUI::stopPageProfiling);
    if (decoder.messageName() == Messages::WebInspectorUI::StartElementSelection::name())
        return IPC::handleMessage<Messages::WebInspectorUI::StartElementSelection>(connection, decoder, this, &WebInspectorUI::startElementSelection);
    if (decoder.messageName() == Messages::WebInspectorUI::StopElementSelection::name())
        return IPC::handleMessage<Messages::WebInspectorUI::StopElementSelection>(connection, decoder, this, &WebInspectorUI::stopElementSelection);
    if (decoder.messageName() == Messages::WebInspectorUI::DidSave::name())
        return IPC::handleMessage<Messages::WebInspectorUI::DidSave>(connection, decoder, this, &WebInspectorUI::didSave);
    if (decoder.messageName() == Messages::WebInspectorUI::DidAppend::name())
        return IPC::handleMessage<Messages::WebInspectorUI::DidAppend>(connection, decoder, this, &WebInspectorUI::didAppend);
    if (decoder.messageName() == Messages::WebInspectorUI::SendMessageToFrontend::name())
        return IPC::handleMessage<Messages::WebInspectorUI::SendMessageToFrontend>(connection, decoder, this, &WebInspectorUI::sendMessageToFrontend);
    if (decoder.messageName() == Messages::WebInspectorUI::EvaluateInFrontendForTesting::name())
        return IPC::handleMessage<Messages::WebInspectorUI::EvaluateInFrontendForTesting>(connection, decoder, this, &WebInspectorUI::evaluateInFrontendForTesting);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit
