/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.Closer;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.FileWriteMode;
import com.google.common.io.LineProcessor;
import com.google.common.io.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class Files {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        @Override
        public Iterable<File> successors(File file2) {
            File[] files;
            if (file2.isDirectory() && (files = file2.listFiles()) != null) {
                return Collections.unmodifiableList(Arrays.asList(files));
            }
            return ImmutableList.of();
        }
    };

    private Files() {
    }

    @Beta
    public static BufferedReader newReader(File file2, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkNotNull(charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), charset));
    }

    @Beta
    public static BufferedWriter newWriter(File file2, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), charset));
    }

    public static ByteSource asByteSource(File file2) {
        return new FileByteSource(file2);
    }

    public static ByteSink asByteSink(File file2, FileWriteMode ... modes) {
        return new FileByteSink(file2, modes);
    }

    public static CharSource asCharSource(File file2, Charset charset) {
        return Files.asByteSource(file2).asCharSource(charset);
    }

    public static CharSink asCharSink(File file2, Charset charset, FileWriteMode ... modes) {
        return Files.asByteSink(file2, modes).asCharSink(charset);
    }

    @Beta
    public static byte[] toByteArray(File file2) throws IOException {
        return Files.asByteSource(file2).read();
    }

    @Deprecated
    @Beta
    public static String toString(File file2, Charset charset) throws IOException {
        return Files.asCharSource(file2, charset).read();
    }

    @Beta
    public static void write(byte[] from, File to) throws IOException {
        Files.asByteSink(to, new FileWriteMode[0]).write(from);
    }

    @Deprecated
    @Beta
    public static void write(CharSequence from, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, new FileWriteMode[0]).write(from);
    }

    @Beta
    public static void copy(File from, OutputStream to) throws IOException {
        Files.asByteSource(from).copyTo(to);
    }

    @Beta
    public static void copy(File from, File to) throws IOException {
        Preconditions.checkArgument(!from.equals(to), "Source %s and destination %s must be different", (Object)from, (Object)to);
        Files.asByteSource(from).copyTo(Files.asByteSink(to, new FileWriteMode[0]));
    }

    @Deprecated
    @Beta
    public static void copy(File from, Charset charset, Appendable to) throws IOException {
        Files.asCharSource(from, charset).copyTo(to);
    }

    @Deprecated
    @Beta
    public static void append(CharSequence from, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from);
    }

    @Beta
    public static boolean equal(File file1, File file2) throws IOException {
        Preconditions.checkNotNull(file1);
        Preconditions.checkNotNull(file2);
        if (file1 == file2 || file1.equals(file2)) {
            return true;
        }
        long len1 = file1.length();
        long len2 = file2.length();
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return Files.asByteSource(file1).contentEquals(Files.asByteSource(file2));
    }

    @Deprecated
    @Beta
    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        long l = System.currentTimeMillis();
        String baseName = new StringBuilder(21).append(l).append("-").toString();
        int counter = 0;
        while (counter < 10000) {
            int n = counter++;
            File tempDir = new File(baseDir, new StringBuilder(11 + String.valueOf(baseName).length()).append(baseName).append(n).toString());
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException(new StringBuilder(66 + String.valueOf(baseName).length() + String.valueOf(baseName).length()).append("Failed to create directory within 10000 attempts (tried ").append(baseName).append("0 to ").append(baseName).append(9999).append(')').toString());
    }

    @Beta
    public static void touch(File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        if (!file2.createNewFile() && !file2.setLastModified(System.currentTimeMillis())) {
            String string2 = String.valueOf(file2);
            throw new IOException(new StringBuilder(38 + String.valueOf(string2).length()).append("Unable to update modification time of ").append(string2).toString());
        }
    }

    @Beta
    public static void createParentDirs(File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        File parent = file2.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            String string2 = String.valueOf(file2);
            throw new IOException(new StringBuilder(39 + String.valueOf(string2).length()).append("Unable to create parent directories of ").append(string2).toString());
        }
    }

    @Beta
    public static void move(File from, File to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        Preconditions.checkArgument(!from.equals(to), "Source %s and destination %s must be different", (Object)from, (Object)to);
        if (!from.renameTo(to)) {
            Files.copy(from, to);
            if (!from.delete()) {
                if (!to.delete()) {
                    String string2 = String.valueOf(to);
                    throw new IOException(new StringBuilder(17 + String.valueOf(string2).length()).append("Unable to delete ").append(string2).toString());
                }
                String string3 = String.valueOf(from);
                throw new IOException(new StringBuilder(17 + String.valueOf(string3).length()).append("Unable to delete ").append(string3).toString());
            }
        }
    }

    @Deprecated
    @CheckForNull
    @Beta
    public static String readFirstLine(File file2, Charset charset) throws IOException {
        return Files.asCharSource(file2, charset).readFirstLine();
    }

    @Beta
    public static List<String> readLines(File file2, Charset charset) throws IOException {
        return Files.asCharSource(file2, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    @Deprecated
    @ParametricNullness
    @Beta
    @CanIgnoreReturnValue
    public static <T> T readLines(File file2, Charset charset, LineProcessor<T> callback) throws IOException {
        return Files.asCharSource(file2, charset).readLines(callback);
    }

    @Deprecated
    @ParametricNullness
    @Beta
    @CanIgnoreReturnValue
    public static <T> T readBytes(File file2, ByteProcessor<T> processor) throws IOException {
        return Files.asByteSource(file2).read(processor);
    }

    @Deprecated
    @Beta
    public static HashCode hash(File file2, HashFunction hashFunction) throws IOException {
        return Files.asByteSource(file2).hash(hashFunction);
    }

    @Beta
    public static MappedByteBuffer map(File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        return Files.map(file2, FileChannel.MapMode.READ_ONLY);
    }

    @Beta
    public static MappedByteBuffer map(File file2, FileChannel.MapMode mode) throws IOException {
        return Files.mapInternal(file2, mode, -1L);
    }

    @Beta
    public static MappedByteBuffer map(File file2, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkArgument(size >= 0L, "size (%s) may not be negative", size);
        return Files.mapInternal(file2, mode, size);
    }

    private static MappedByteBuffer mapInternal(File file2, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkNotNull(mode);
        try (Closer closer = Closer.create();){
            RandomAccessFile raf = closer.register(new RandomAccessFile(file2, mode == FileChannel.MapMode.READ_ONLY ? "r" : "rw"));
            FileChannel channel = closer.register(raf.getChannel());
            MappedByteBuffer mappedByteBuffer = channel.map(mode, 0L, size == -1L ? channel.size() : size);
            return mappedByteBuffer;
        }
    }

    @Beta
    public static String simplifyPath(String pathname) {
        Preconditions.checkNotNull(pathname);
        if (pathname.length() == 0) {
            return ".";
        }
        Iterable<String> components = Splitter.on('/').omitEmptyStrings().split(pathname);
        ArrayList<String> path2 = new ArrayList<String>();
        Iterator<String> iterator = components.iterator();
        block8: while (iterator.hasNext()) {
            String component;
            switch (component = iterator.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (path2.size() > 0 && !((String)path2.get(path2.size() - 1)).equals("..")) {
                        path2.remove(path2.size() - 1);
                        continue block8;
                    }
                    path2.add("..");
                    continue block8;
                }
            }
            path2.add(component);
        }
        String result = Joiner.on('/').join(path2);
        if (pathname.charAt(0) == '/') {
            String string2 = String.valueOf(result);
            String string3 = result = string2.length() != 0 ? "/".concat(string2) : new String("/");
        }
        while (result.startsWith("/../")) {
            result = result.substring(3);
        }
        if (result.equals("/..")) {
            result = "/";
        } else if ("".equals(result)) {
            result = ".";
        }
        return result;
    }

    @Beta
    public static String getFileExtension(String fullName) {
        Preconditions.checkNotNull(fullName);
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    @Beta
    public static String getNameWithoutExtension(String file2) {
        Preconditions.checkNotNull(file2);
        String fileName = new File(file2).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    @Beta
    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    @Beta
    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    @Beta
    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    private static enum FilePredicate implements Predicate<File>
    {
        IS_DIRECTORY{

            @Override
            public boolean apply(File file2) {
                return file2.isDirectory();
            }

            public String toString() {
                return "Files.isDirectory()";
            }
        }
        ,
        IS_FILE{

            @Override
            public boolean apply(File file2) {
                return file2.isFile();
            }

            public String toString() {
                return "Files.isFile()";
            }
        };

    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file2, FileWriteMode ... modes) {
            this.file = Preconditions.checkNotNull(file2);
            this.modes = ImmutableSet.copyOf(modes);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            String string2 = String.valueOf(this.file);
            String string3 = String.valueOf(this.modes);
            return new StringBuilder(20 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Files.asByteSink(").append(string2).append(", ").append(string3).append(")").toString();
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file2) {
            this.file = Preconditions.checkNotNull(file2);
        }

        @Override
        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public long size() throws IOException {
            if (!this.file.isFile()) {
                throw new FileNotFoundException(this.file.toString());
            }
            return this.file.length();
        }

        @Override
        public byte[] read() throws IOException {
            try (Closer closer = Closer.create();){
                FileInputStream in = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray(in, in.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            String string2 = String.valueOf(this.file);
            return new StringBuilder(20 + String.valueOf(string2).length()).append("Files.asByteSource(").append(string2).append(")").toString();
        }
    }
}

