/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.Size;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class FontLibrary {
    private static final Logger logger = Logger.getLogger(FontLibrary.class.getName());
    public static final float DEFAULT_UNSCALED_MAIN_FONT_SIZE = 12.0f;
    private static float mainFontSize = 12.0f;
    private static final Map<FontType, String> keyMap = CollectionUtils.makeUnmodifiableMap(new FontType[]{FontType.NORMAL, FontType.SIMPLE, FontType.HEADER}, new String[]{"font.normal", "font.simple", "font.header"});
    private static Font mainFont = null;
    private static final Map<String, Font> fontCache = new HashMap<String, Font>();

    private static String getFontKey(FontType fontType) {
        return fontType == FontType.NORMAL && mainFont != null ? null : keyMap.getOrDefault((Object)fontType, null);
    }

    public static void setMainFontSize(float newMainFontSize) {
        mainFontSize = newMainFontSize;
    }

    private static float getScaledSize(Size fontSize, float scaleFactor) {
        return fontSize.forFont() * scaleFactor;
    }

    public static Font createMainFont(String fontName) {
        Font font = null;
        if (fontName != null) {
            font = Font.decode(fontName);
        }
        if (font == null) {
            font = ResourceManager.getFont("font.normal");
        }
        mainFont = font = font.deriveFont(mainFontSize);
        return font;
    }

    public static Font getMainFont() {
        return mainFont.deriveFont(mainFontSize);
    }

    private static boolean displayTest(Font font, String text) {
        return font != null && (text == null || font.canDisplayUpTo(text) < 0);
    }

    private static Font tryFont(FontType type, String text) {
        String fontKey = FontLibrary.getFontKey(type);
        if (fontKey == null) {
            return null;
        }
        Font ret = ResourceManager.getFont(fontKey);
        return FontLibrary.displayTest(ret, text) ? ret : null;
    }

    public static Font getUnscaledFont(String spec) {
        return FontLibrary.getUnscaledFont(spec, null);
    }

    public static synchronized Font getUnscaledFont(String spec, String text) {
        String[] a;
        Font ret = fontCache.get(spec);
        if (ret != null) {
            if (FontLibrary.displayTest(ret, text)) {
                return ret;
            }
            logger.warning("Fontlibrary cached font for " + spec + " failed to display: " + text);
        }
        if ((a = spec.split("-")).length != 3) {
            throw new RuntimeException("Bad font spec: " + spec);
        }
        FontType type = Enum.valueOf(FontType.class, StringUtils.upCase(a[0]));
        String[] styles = StringUtils.upCase(a[1]).split("\\+");
        int style = 0;
        for (String s : styles) {
            int x;
            int n = "PLAIN".equals(s) ? 0 : ("BOLD".equals(s) ? 1 : (x = "ITALIC".equals(s) ? 2 : -1));
            if (x < 0) {
                throw new RuntimeException("Bad font style: " + s);
            }
            style |= x;
        }
        Size size = Enum.valueOf(Size.class, StringUtils.upCase(a[2]));
        ret = FontLibrary.tryFont(type, text);
        if (ret == null && type != FontType.NORMAL) {
            ret = FontLibrary.tryFont(FontType.NORMAL, text);
        }
        if (ret == null && type != FontType.SIMPLE) {
            ret = FontLibrary.tryFont(FontType.SIMPLE, text);
        }
        if (ret == null) {
            if (text != null) {
                logger.warning("FontLibrary found no font for: " + text);
            }
            ret = mainFont;
        }
        if ((ret = ret.deriveFont(style, size.forFont())) == null) {
            logger.warning("FontLibrary could not derive font for: " + spec);
        } else {
            fontCache.put(spec, ret);
        }
        return ret;
    }

    public static Font getScaledFont(String spec) {
        return FontLibrary.getScaledFont(spec, null);
    }

    public static Font getScaledFont(String spec, String text) {
        float scaleFactor = FontLibrary.getFontScaling();
        return FontLibrary.getScaledFont(spec, scaleFactor, text);
    }

    public static float getFontScaling() {
        return mainFontSize / 12.0f;
    }

    public static Font getScaledFont(String spec, float scale, String text) {
        String[] a = spec.split("-");
        if (a.length != 3) {
            throw new RuntimeException("Bad font spec: " + spec);
        }
        Font unscaledFont = FontLibrary.getUnscaledFont(spec, text);
        Size size = Enum.valueOf(Size.class, StringUtils.upCase(a[2]));
        float fontSize = Math.round(size.forFont() * scale);
        return unscaledFont.deriveFont(fontSize);
    }

    public static enum FontType {
        NORMAL,
        SIMPLE,
        HEADER;

    }
}

