/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class LoginMessage
extends ObjectMessage {
    public static final String TAG = "login";
    private static final String CURRENT_PLAYER_TAG = "currentPlayer";
    private static final String SINGLE_PLAYER_TAG = "singlePlayer";
    private static final String STATE_TAG = "state";
    private static final String USER_NAME_TAG = "userName";
    private static final String VERSION_TAG = "version";
    private Player player = null;

    public LoginMessage(Player player, String userName, String version, FreeColServer.ServerState state, boolean singlePlayer, boolean currentPlayer, Game game) {
        super(TAG, USER_NAME_TAG, userName, VERSION_TAG, version, SINGLE_PLAYER_TAG, Boolean.toString(singlePlayer), CURRENT_PLAYER_TAG, Boolean.toString(currentPlayer));
        this.player = player;
        if (state != null) {
            this.setStringAttribute(STATE_TAG, state.toString());
        }
        this.appendChild(game);
    }

    public LoginMessage(Game ignoredGame, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, USER_NAME_TAG, VERSION_TAG, STATE_TAG, SINGLE_PLAYER_TAG, CURRENT_PLAYER_TAG);
        Game game = null;
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("game".equals(tag)) {
                game = new Game(null, xr);
                continue;
            }
            this.expected("game", tag);
        }
        xr.expectTag(TAG);
        this.appendChild(game);
        this.player = game == null ? null : this.getPlayer(game);
    }

    private String getUserName() {
        return this.getStringAttribute(USER_NAME_TAG);
    }

    private String getVersion() {
        return this.getStringAttribute(VERSION_TAG);
    }

    private FreeColServer.ServerState getState() {
        return this.getEnumAttribute(STATE_TAG, FreeColServer.ServerState.class, null);
    }

    private boolean getSinglePlayer() {
        return this.getBooleanAttribute(SINGLE_PLAYER_TAG, Boolean.FALSE);
    }

    private boolean getCurrentPlayer() {
        return this.getBooleanAttribute(CURRENT_PLAYER_TAG, Boolean.FALSE);
    }

    private Game getGame() {
        return this.getChild(0, Game.class);
    }

    private Player getPlayer(Game game) {
        return game.getPlayerByName(this.getUserName());
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.EARLY;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = this.getGame();
        freeColClient.getConnectController().login(this.getState(), game, this.getUserName(), this.getSinglePlayer(), this.getCurrentPlayer());
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        FreeColXMLWriter.WriteScope ws = null;
        if (this.player != null) {
            ws = xw.replaceScope(FreeColXMLWriter.WriteScope.toClient(this.player));
        }
        super.toXML(xw);
        if (this.player != null) {
            xw.replaceScope(ws);
        }
    }

    private ChangeSet preGameLogin(FreeColServer freeColServer, Connection connection) {
        ChangeSet ret;
        String userName = this.getUserName();
        ServerGame serverGame = freeColServer.waitForGame();
        if (serverGame == null) {
            ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.timeOut"));
        } else {
            Nation nation = serverGame.getVacantNation();
            if (nation == null) {
                ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.maximumPlayers"));
            } else {
                Player present = this.getPlayer(serverGame);
                if (present != null) {
                    ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.userNameInUse").addName("%name%", userName));
                } else {
                    ServerPlayer serverPlayer = new ServerPlayer((Game)serverGame, connection);
                    serverPlayer.initialize(serverGame, serverGame.getLivePlayerList(new Player[0]).isEmpty(), nation);
                    serverPlayer.setName(userName);
                    ret = new ChangeSet();
                    serverGame.addPlayer(serverPlayer);
                    ret.addNewPlayer(serverPlayer);
                    if (serverGame.getCurrentPlayer() == null) {
                        serverGame.setCurrentPlayer(serverPlayer);
                    }
                    Connection conn = serverPlayer.getConnection();
                    freeColServer.addPlayerConnection(conn);
                    conn.setWriteScope(FreeColXMLWriter.WriteScope.toClient(serverPlayer));
                    ret.add(ChangeSet.See.only(serverPlayer), new LoginMessage(serverPlayer, userName, this.getVersion(), freeColServer.getServerState(), freeColServer.getSinglePlayer(), serverGame.getCurrentPlayer() == serverPlayer, serverGame));
                }
            }
        }
        return ret;
    }

    private ChangeSet loadGameLogin(FreeColServer freeColServer, Connection connection) {
        ChangeSet ret;
        String userName = this.getUserName();
        if ("mapEditor".equals(userName)) {
            ret = ChangeSet.clientError((Player)null, StringTemplate.template("error.mapEditorGame"));
        } else {
            ServerGame serverGame = freeColServer.getGame();
            if (serverGame == null) {
                ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.noSuchGame"));
            } else {
                Player present = this.getPlayer(serverGame);
                if (present == null) {
                    ret = ChangeSet.clientError((Player)null, ((StringTemplate)StringTemplate.template("server.userNameNotPresent").addName("%name%", userName)).addName("%names%", CollectionUtils.transform(serverGame.getLiveEuropeanPlayers(new Player[0]), CollectionUtils.alwaysTrue(), Player::getName, Collectors.joining(", "))));
                } else if (present.isConnected()) {
                    ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.userNameInUse").addName("%name%", userName));
                } else if (present.isAI()) {
                    ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.userNameInUse").addName("%name%", userName));
                } else {
                    present.setConnection(connection);
                    if (serverGame.getCurrentPlayer() == null) {
                        serverGame.setCurrentPlayer(present);
                    }
                    freeColServer.addPlayerConnection(connection);
                    connection.setWriteScope(FreeColXMLWriter.WriteScope.toClient(present));
                    ret = ChangeSet.simpleChange(present, (Message)new LoginMessage(present, userName, this.getVersion(), freeColServer.getServerState(), freeColServer.getSinglePlayer(), serverGame.getCurrentPlayer() == present, serverGame));
                }
            }
        }
        return ret;
    }

    private ChangeSet inGameLogin(FreeColServer freeColServer, Connection connection) {
        ChangeSet ret;
        String userName = this.getUserName();
        ServerGame serverGame = freeColServer.getGame();
        if (serverGame == null) {
            ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.noSuchGame"));
        } else {
            Player present = this.getPlayer(serverGame);
            if (present == null) {
                ret = ChangeSet.clientError((Player)null, ((StringTemplate)StringTemplate.template("server.userNameNotPresent").addName("%name%", userName)).addName("%names%", CollectionUtils.transform(serverGame.getLiveEuropeanPlayers(new Player[0]), CollectionUtils.alwaysTrue(), Player::getName, Collectors.joining(", "))));
            } else if (!present.isAI() && present.isConnected()) {
                ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.userNameInUse").addName("%name%", userName));
            } else {
                if (present.isAI()) {
                    serverGame.changeAI(present, false);
                }
                present.setConnection(connection);
                freeColServer.addPlayerConnection(connection);
                connection.setWriteScope(FreeColXMLWriter.WriteScope.toClient(present));
                ret = ChangeSet.simpleChange(present, (Message)new LoginMessage(present, userName, this.getVersion(), freeColServer.getServerState(), freeColServer.getSinglePlayer(), serverGame.getCurrentPlayer() == present, serverGame));
            }
        }
        return ret;
    }

    public ChangeSet loginHandler(FreeColServer freeColServer, Connection connection) {
        ChangeSet ret;
        String userName = this.getUserName();
        String version = this.getVersion();
        if (userName == null || userName.isEmpty()) {
            ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.missingUserName"));
        } else if (version == null || version.isEmpty()) {
            ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.missingVersion"));
        } else if (!version.equals(FreeCol.getVersion())) {
            ret = ChangeSet.clientError((Player)null, ((StringTemplate)StringTemplate.template("server.wrongFreeColVersion").addName("%clientVersion%", version)).addName("%serverVersion%", FreeCol.getVersion()));
        } else {
            switch (freeColServer.getServerState()) {
                case PRE_GAME: {
                    ret = this.preGameLogin(freeColServer, connection);
                    break;
                }
                case LOAD_GAME: {
                    ret = this.loadGameLogin(freeColServer, connection);
                    break;
                }
                case IN_GAME: {
                    ret = this.inGameLogin(freeColServer, connection);
                    break;
                }
                default: {
                    ret = ChangeSet.clientError((Player)null, StringTemplate.template("server.couldNotLogin"));
                }
            }
        }
        return ret;
    }
}

