/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.PT;
import jspecview.application.JSpecView;
import jspecview.application.MainFrame;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.c.CBK;
import org.jmol.dialog.Dialog;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;
import org.openscience.jmol.app.webexport.WebExport;

public class StatusListener
implements JmolStatusListener,
JmolSyncInterface,
JSVInterface {
    private JmolPanel jmolPanel;
    private DisplayPanel display;
    private Viewer vwr;
    private MainFrame jSpecViewFrame;
    private boolean jSpecViewForceNew;
    private String lastSimulate;
    JmolStatusListener userStatusListener;
    private Map<String, Object> nboOptions;
    private int modificationMode;
    private static String propertiesFileName = "jspecview.properties";

    public void setViewer(Viewer vwr) {
        this.vwr = vwr;
    }

    public StatusListener(JmolPanel jmolPanel, DisplayPanel display) {
        this.jmolPanel = jmolPanel;
        this.display = display;
    }

    @Override
    public boolean notifyEnabled(CBK type) {
        if (this.userStatusListener != null && this.userStatusListener.notifyEnabled(type)) {
            return true;
        }
        switch (type) {
            case ANIMFRAME: 
            case LOADSTRUCT: 
            case STRUCTUREMODIFIED: 
            case MEASURE: 
            case SERVICE: 
            case PICK: 
            case SCRIPT: 
            case SYNC: 
            case ECHO: 
            case ERROR: 
            case MESSAGE: 
            case MINIMIZATION: 
            case MODELKIT: 
            case DRAGDROP: 
            case RESIZE: 
            case CLICK: 
            case ATOMMOVED: 
            case SELECT: 
            case HOVER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(CBK type, Object[] data) {
        JmolCallbackListener appConsole;
        if (this.vwr == null) {
            return;
        }
        if (this.userStatusListener != null && this.userStatusListener.notifyEnabled(type)) {
            this.userStatusListener.notifyCallback(type, data);
        }
        if (this.jmolPanel.isServer() && data != null && "SYNC".equals(data[0])) {
            data[0] = type.toString();
            this.jmolPanel.sendNioSyncRequest(data, 2, null);
        }
        if (!this.jmolPanel.plugins.isEmpty()) {
            for (JmolPlugin p : this.jmolPanel.plugins.values()) {
                p.notifyCallback(type, data);
            }
        }
        String strInfo = data == null || data[1] == null ? null : data[1].toString();
        switch (type) {
            case MESSAGE: {
                return;
            }
            case SERVICE: {
                if (this.display == null) {
                    return;
                }
                Map info = (Map)data[1];
                try {
                    String service = (String)info.get("service");
                    if ("nbo".equals(service) && "showPanel".equals(info.get("action"))) {
                        this.jmolPanel.startNBO(info);
                    }
                }
                catch (Exception service) {
                    // empty catch block
                }
                return;
            }
            case LOADSTRUCT: {
                this.notifyFileLoaded(strInfo, (String)data[2], (String)data[3], (String)data[4], (Boolean)data[8]);
                if (this.jmolPanel.gaussianDialog == null) break;
                this.jmolPanel.gaussianDialog.updateModel(-2);
                break;
            }
            case ANIMFRAME: {
                int[] iData = (int[])data[1];
                strInfo = PT.toJSON(null, iData);
                int modelIndex = iData[0];
                if (modelIndex <= -2) {
                    modelIndex = -2 - modelIndex;
                }
                if (!this.display.haveDisplay) break;
                String menuName = (String)data[2];
                if (menuName.equals("0.0: ")) {
                    menuName = "";
                }
                this.jmolPanel.setStatus(1, menuName);
                if (this.jmolPanel.frame == null) break;
                this.jmolPanel.frame.setTitle(menuName);
                break;
            }
            case SCRIPT: {
                AppConsole console;
                int msWalltime = (Integer)data[3];
                if (msWalltime == 0) {
                    if (data[2] == null || !this.display.haveDisplay) break;
                    this.jmolPanel.setStatus(1, (String)data[2]);
                    break;
                }
                if (msWalltime != -1 || (console = this.jmolPanel.getConsole()) == null) break;
                console.checkUndoEnabled();
                break;
            }
            case MODELKIT: {
                String state = (String)data[1];
                if (state.equals("ON")) {
                    if (this.display.buttonModelkit == null) break;
                    this.display.buttonModelkit.setSelected(true);
                    break;
                }
                if (this.display.buttonRotate == null) break;
                this.display.buttonRotate.setSelected(true);
                break;
            }
            case MEASURE: {
                String mystatus = (String)data[3];
                if (mystatus.indexOf("Sequence") >= 0) break;
                if (mystatus.indexOf("Pending") < 0 && this.display.haveDisplay) {
                    this.jmolPanel.measurementTable.updateTables();
                }
                if (mystatus.indexOf("Picked") >= 0) {
                    this.notifyAtomPicked(strInfo);
                    break;
                }
                if (mystatus.indexOf("Completed") >= 0) break;
                return;
            }
            case PICK: {
                this.notifyAtomPicked(strInfo);
                if (this.jmolPanel.gaussianDialog == null) break;
                this.jmolPanel.gaussianDialog.updateModel((Integer)data[2]);
                break;
            }
            case STRUCTUREMODIFIED: {
                int mode = (Integer)data[1];
                int atomIndex = (Integer)data[2];
                int modelIndexx = (Integer)data[3];
                this.notifyStructureModified(atomIndex, modelIndexx, mode);
                if (this.jmolPanel.gaussianDialog == null) break;
                this.jmolPanel.gaussianDialog.updateModel(-1);
                break;
            }
            case SYNC: {
                String lc;
                String string = lc = strInfo == null ? "" : strInfo.toLowerCase();
                if (lc.startsWith("jspecview")) {
                    this.setJSpecView(strInfo.substring(9).trim(), false, false);
                    return;
                }
                if (lc.equals("getpreference")) {
                    data[0] = data[2] == null ? this.jmolPanel.preferencesDialog : this.jmolPanel.getPreference(data[2].toString());
                    return;
                }
                if (strInfo != null && strInfo.toLowerCase().startsWith("nbo:")) {
                    if (this.nboOptions == null) {
                        this.nboOptions = new Hashtable<String, Object>();
                    }
                    this.nboOptions.put("options", strInfo);
                    this.jmolPanel.startNBO(this.nboOptions);
                    return;
                }
                this.jmolPanel.sendNioSyncRequest(null, (Integer)data[3], strInfo);
                return;
            }
            case APPLETREADY: 
            case AUDIO: 
            case EVAL: 
            case IMAGE: {
                return;
            }
        }
        if (this.jmolPanel.isServer()) {
            this.jmolPanel.sendNioSyncRequest(null, 2, ((Object)((Object)type) + ":" + strInfo).trim());
        }
        if ((appConsole = (JmolCallbackListener)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null) {
            appConsole.notifyCallback(type, data);
        }
    }

    private void notifyStructureModified(int atomIndex, int modelIndex, int mode) {
        this.modificationMode = mode;
        if (mode < 0) {
            switch (mode) {
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    this.checkJSpecView(false);
                    return;
                }
            }
        }
    }

    @Override
    public void setCallbackFunction(String callbackType, String callbackFunction) {
        if (callbackType.equalsIgnoreCase("language")) {
            AppConsole appConsole;
            JmolResourceHandler.clear();
            Dialog.setupUIManager();
            if (this.jmolPanel.webExport != null) {
                WebExport.saveHistory();
                WebExport.dispose();
                this.jmolPanel.createWebExport();
            }
            if ((appConsole = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null) {
                appConsole.sendConsoleEcho(null);
            }
            this.jmolPanel.updateLabels();
            return;
        }
    }

    @Override
    public String eval(String strEval) {
        String msg = "# this funcationality is implemented only for the applet.\n" + strEval;
        this.sendConsoleMessage(msg);
        return msg;
    }

    @Override
    public String createImage(String fileName, String type, Object text_or_bytes, int quality) {
        return null;
    }

    private void notifyAtomPicked(String info) {
        if (this.display.haveDisplay) {
            this.jmolPanel.setStatus(1, info);
        }
    }

    private void notifyFileLoaded(String fullPathName, String fileName, String modelName, String errorMsg, Boolean isAsync) {
        if (errorMsg != null) {
            return;
        }
        if (!this.display.haveDisplay) {
            return;
        }
        String title = "Jmol";
        if (fileName != null && fileName.startsWith("DROP_")) {
            fileName = fileName.substring(5);
        }
        if (modelName != null && fileName != null) {
            title = (fileName.contains("&") ? "" : fileName + " - ") + modelName;
        } else if (fileName != null) {
            title = fileName;
        } else if (modelName != null) {
            title = modelName;
        }
        this.jmolPanel.notifyFileOpen(fullPathName == null ? null : fullPathName + (isAsync == Boolean.TRUE ? " (*)" : ""), title);
        this.checkJSpecView(fullPathName == null);
    }

    private void sendConsoleMessage(String strStatus) {
        JmolAppConsoleInterface appConsole = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (appConsole != null) {
            appConsole.sendConsoleMessage(strStatus);
        }
    }

    @Override
    public void showUrl(String url) {
        try {
            Class<?> c = Class.forName("java.awt.Desktop");
            Method getDesktop = c.getMethod("getDesktop", new Class[0]);
            Object deskTop = getDesktop.invoke(null, new Object[0]);
            Method browse = c.getMethod("browse", URI.class);
            Object[] arguments = new Object[]{new URI(url)};
            browse.invoke(deskTop, arguments);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            JmolAppConsoleInterface appConsole = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (appConsole != null) {
                appConsole.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + url);
            }
            Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + url);
        }
    }

    @Override
    public float[][] functionXY(String functionName, int nX, int nY) {
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        float[][] f = new float[nX][nY];
        int i = nX;
        while (--i >= 0) {
            int j = nY;
            while (--j >= 0) {
                float x = (float)i / 5.0f;
                float y = (float)j / 5.0f;
                f[i][j] = x * x + y;
                if (!Float.isNaN(f[i][j])) continue;
                f[i][j] = -((float)Math.sqrt(-x * x - y));
            }
        }
        return f;
    }

    @Override
    public float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        nX = Math.abs(nX);
        nY = Math.abs(nY);
        nZ = Math.abs(nZ);
        float[][][] f = new float[nX][nY][nZ];
        int i = nX;
        while (--i >= 0) {
            int j = nY;
            while (--j >= 0) {
                int k = nZ;
                while (--k >= 0) {
                    float x = (float)i / ((float)(nX - 1) / 2.0f) - 1.0f;
                    float y = (float)j / ((float)(nY - 1) / 2.0f) - 1.0f;
                    float z = (float)k / ((float)(nZ - 1) / 2.0f) - 1.0f;
                    f[i][j][k] = x * x + y * y - z * z;
                }
            }
        }
        return f;
    }

    @Override
    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    @Override
    public int[] resizeInnerPanel(String data) {
        return this.jmolPanel.resizeInnerPanel(data);
    }

    private void checkJSpecView(boolean closeAll) {
        if (this.jSpecViewFrame != null && this.modificationMode <= 0) {
            this.jSpecViewForceNew = this.jSpecViewFrame.isVisible();
            this.setJSpecView(closeAll ? "none" : "", true, true);
            this.jSpecViewForceNew = true;
        }
    }

    public void setJSpecView(String peaks, boolean doLoadCheck, boolean isFileLoad) {
        if (peaks.startsWith(":")) {
            peaks = peaks.substring(1);
        }
        if (peaks.equals("none") || peaks.equals("NONESimulate:")) {
            if (this.jSpecViewFrame != null) {
                this.jSpecViewFrame.syncScript("close ALL");
                this.jSpecViewFrame.awaken(false);
            }
            return;
        }
        boolean isC13 = peaks.equals("C13Simulate:");
        boolean isSimulation = peaks.equals("H1Simulate:") || isC13;
        boolean isStartup = peaks.length() == 0 || isSimulation;
        boolean newSim = isSimulation && !peaks.equals(this.lastSimulate);
        String data = null;
        if (isSimulation && ((data = this.vwr.extractMolData(null)) == null || data.length() == 0)) {
            return;
        }
        if (this.jSpecViewFrame == null) {
            JSpecView jsv = new JSpecView(true, this);
            this.jSpecViewFrame = new MainFrame(jsv, this.vwr.getBoolean(603979869) ? (Component)this.vwr.display : null, this);
            jsv.setMainFrame(this.jSpecViewFrame);
            this.jSpecViewFrame.setSize(Math.max(1000, this.jmolPanel.frame.getWidth() + 50), 600);
            this.jSpecViewFrame.setLocation(this.jmolPanel.frame.getLocation().x + 10, this.jmolPanel.frame.getLocation().y + 100);
            this.jSpecViewFrame.register("Jmol", this);
            this.vwr.setBooleanProperty("_jspecview", true);
            if (isStartup) {
                doLoadCheck = true;
            }
        }
        if (doLoadCheck || this.jSpecViewForceNew || newSim) {
            String type = "" + this.vwr.getP("_modelType");
            if (type.equalsIgnoreCase("jcampdx")) {
                this.jSpecViewForceNew = false;
                String file = "" + this.vwr.getP("_modelFile");
                if (file.indexOf("/") < 0) {
                    return;
                }
                peaks = "hidden true; load CHECK " + PT.esc(file) + ";hidden false" + (newSim && isC13 ? ";scaleby 0.5" : null);
            } else {
                if (isFileLoad && !this.jSpecViewForceNew && !newSim) {
                    return;
                }
                this.jSpecViewForceNew = false;
                if (newSim) {
                    this.lastSimulate = peaks;
                }
                String model = "" + this.vwr.getP("_modelNumber");
                if (data == null) {
                    peaks = "hidden false";
                } else {
                    data = PT.replaceAllCharacters(data, "&", "_");
                    peaks = "hidden true; load CHECK " + (peaks.equals("H1Simulate:") ? "H1 " : "C13 ") + PT.esc("id='~" + model + "';" + data) + ";hidden false #SYNC_PEAKS";
                }
                isStartup = false;
            }
        }
        if (!this.jSpecViewFrame.isVisible()) {
            if (peaks.contains("<PeakData")) {
                return;
            }
            this.jSpecViewFrame.awaken(true);
            this.display.setViewer(this.vwr);
        }
        if (isStartup) {
            peaks = "HIDDEN false";
        }
        this.jSpecViewFrame.syncScript(peaks);
    }

    @Override
    public void register(String id, JmolSyncInterface jsi) {
    }

    @Override
    public void syncScript(String script) {
        this.jmolPanel.syncScript(script);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileIn = new FileInputStream(propertiesFileName);
            properties.load(fileIn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOut = new FileOutputStream(propertiesFileName);
            properties.store(fileOut, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean withDialog, Object frame) {
    }

    @Override
    public void runScript(String script) {
        this.jSpecViewFrame.runScriptNow(script);
    }

    @Override
    public void syncToJmol(String msg) {
    }

    @Override
    public Map<String, Object> getJSpecViewProperty(String type) {
        if (type.toLowerCase().startsWith("jspecview")) {
            if ((type = type.substring(9)).startsWith(":")) {
                type = type.substring(1);
            }
            return this.jSpecViewFrame == null ? null : this.jSpecViewFrame.getJSpecViewProperty(type);
        }
        return null;
    }
}

