Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var hub_1 = require("@sentry/hub");
var types_1 = require("@sentry/types");
var utils_1 = require("@sentry/utils");
var parsers_1 = require("./parsers");
/**
 * Builds and Event from a Exception
 * @hidden
 */
function eventFromException(options, exception, hint) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    var ex = exception;
    var providedMechanism = hint && hint.data && hint.data.mechanism;
    var mechanism = providedMechanism || {
        handled: true,
        type: 'generic',
    };
    if (!utils_1.isError(exception)) {
        if (utils_1.isPlainObject(exception)) {
            // This will allow us to group events based on top-level keys
            // which is much better than creating new group when any key/value change
            var message = "Non-Error exception captured with keys: " + utils_1.extractExceptionKeysForMessage(exception);
            hub_1.getCurrentHub().configureScope(function (scope) {
                scope.setExtra('__serialized__', utils_1.normalizeToSize(exception));
            });
            ex = (hint && hint.syntheticException) || new Error(message);
            ex.message = message;
        }
        else {
            // This handles when someone does: `throw "something awesome";`
            // We use synthesized Error here so we can extract a (rough) stack trace.
            ex = (hint && hint.syntheticException) || new Error(exception);
            ex.message = exception;
        }
        mechanism.synthetic = true;
    }
    return new utils_1.SyncPromise(function (resolve, reject) {
        return parsers_1.parseError(ex, options)
            .then(function (event) {
            utils_1.addExceptionTypeValue(event, undefined, undefined);
            utils_1.addExceptionMechanism(event, mechanism);
            resolve(tslib_1.__assign(tslib_1.__assign({}, event), { event_id: hint && hint.event_id }));
        })
            .then(null, reject);
    });
}
exports.eventFromException = eventFromException;
/**
 * Builds and Event from a Message
 * @hidden
 */
function eventFromMessage(options, message, level, hint) {
    if (level === void 0) { level = types_1.Severity.Info; }
    var event = {
        event_id: hint && hint.event_id,
        level: level,
        message: message,
    };
    return new utils_1.SyncPromise(function (resolve) {
        if (options.attachStacktrace && hint && hint.syntheticException) {
            var stack = hint.syntheticException ? parsers_1.extractStackFromError(hint.syntheticException) : [];
            void parsers_1.parseStack(stack, options)
                .then(function (frames) {
                event.stacktrace = {
                    frames: parsers_1.prepareFramesForEvent(frames),
                };
                resolve(event);
            })
                .then(null, function () {
                resolve(event);
            });
        }
        else {
            resolve(event);
        }
    });
}
exports.eventFromMessage = eventFromMessage;
//# sourceMappingURL=eventbuilder.js.map