/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.regex.FoxSignature;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.command.regex.RegexResult;

public class RegexLeaf
implements IRegex {
    private static final RegexLeaf END = new RegexLeaf("$");
    private static final RegexLeaf START = new RegexLeaf("^");
    private final String pattern;
    private final String name;
    private int count = -1;
    private static final Set<String> UNKNOWN = new HashSet<String>();
    private static final Pattern p1 = Pattern.compile("^[-0A-Za-z_!:@;/=,\"]+$");
    private static final Pattern p2 = Pattern.compile("^[-0A-Za-z_!:@;/=,\"]+\\?$");
    private static final Pattern p3 = Pattern.compile("^\\(?[-0A-Za-z_!:@;/=\" ]+\\??(\\|[-0A-Za-z_!:@;/=,\" ]+\\??)+\\)?$");

    public RegexLeaf(String regex) {
        this(null, regex);
    }

    public RegexLeaf(String name, String regex) {
        this.pattern = regex;
        this.name = name;
    }

    public static RegexLeaf spaceZeroOrMore() {
        return new RegexLeaf("[%s]*");
    }

    public static RegexLeaf spaceOneOrMore() {
        return new RegexLeaf("[%s]+");
    }

    public static RegexLeaf start() {
        return START;
    }

    public static RegexLeaf end() {
        return END;
    }

    public String toString() {
        return super.toString() + " " + this.name + " " + this.pattern;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int count() {
        if (this.count == -1) {
            this.count = MyPattern.cmpile(this.pattern).matcher("").groupCount();
        }
        return this.count;
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        RegexPartialMatch m = new RegexPartialMatch(this.name);
        for (int i = 0; i < this.count(); ++i) {
            String group = it.next();
            m.add(group);
        }
        if (this.name == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.name, m);
    }

    @Override
    public boolean match(StringLocated full) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexResult matcher(String full) {
        throw new UnsupportedOperationException();
    }

    private static long getSignatureP3(String s) {
        long result = -1L;
        StringTokenizer st = new StringTokenizer(s, "()|");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            long sig = FoxSignature.getFoxSignature(val.endsWith("?") ? val.substring(0, val.length() - 2) : val);
            result &= sig;
        }
        return result;
    }

    public long getFoxSignatureNone() {
        return 0L;
    }

    public long getFoxSignature() {
        if (p1.matcher(this.pattern).matches()) {
            return FoxSignature.getFoxSignature(this.pattern);
        }
        if (p2.matcher(this.pattern).matches()) {
            return FoxSignature.getFoxSignature(this.pattern.substring(0, this.pattern.length() - 2));
        }
        if (p3.matcher(this.pattern).matches()) {
            return RegexLeaf.getSignatureP3(this.pattern);
        }
        if (this.pattern.length() == 2 && this.pattern.startsWith("\\") && !Character.isLetterOrDigit(this.pattern.charAt(1))) {
            return FoxSignature.getFoxSignature(this.pattern.substring(1));
        }
        if (this.pattern.equals("\\<\\>") || this.pattern.equals("(\\<\\<.*\\>\\>)")) {
            return FoxSignature.getFoxSignature("<>");
        }
        if (this.pattern.equals("\\<-\\>")) {
            return FoxSignature.getFoxSignature("<->");
        }
        if (this.pattern.equals("(-+)")) {
            return FoxSignature.getFoxSignature("-");
        }
        if (this.pattern.equals("\\|+") || this.pattern.equals("\\|\\|")) {
            return FoxSignature.getFoxSignature("|");
        }
        if (this.pattern.equals("([*]+)")) {
            return FoxSignature.getFoxSignature("*");
        }
        if (this.pattern.equals("[%s]+") || this.pattern.equals("[%s]*")) {
            return 0L;
        }
        return 0L;
    }
}

