/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.help;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.help.Help;
import net.sourceforge.plantuml.syntax.LanguageDescriptor;

public class CommandHelpType
extends SingleLineCommand2<Help> {
    public CommandHelpType() {
        super(CommandHelpType.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandHelpType.class.getName(), RegexLeaf.start(), new RegexLeaf("help"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("types?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(Help diagram, LineLocation location, RegexResult arg) {
        diagram.add("<b>Help on types");
        diagram.add(" ");
        diagram.add("The code of this command is located in <i>net.sourceforge.plantuml.help</i> package.");
        diagram.add("You may improve it on <i>https://github.com/plantuml/plantuml/tree/master/src/net/sourceforge/plantuml/help</i>");
        diagram.add(" ");
        diagram.add(" The possible types are :");
        for (String type : new LanguageDescriptor().getType()) {
            diagram.add("* " + type);
        }
        return CommandExecutionResult.ok();
    }
}

