/* debug.c generated by valac 0.56.0, the Vala compiler
 * generated from debug.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/folks.h"
#include <gee.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdarg.h>

enum  {
	FOLKS_DEBUG_0_PROPERTY,
	FOLKS_DEBUG_COLOUR_ENABLED_PROPERTY,
	FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED_PROPERTY,
	FOLKS_DEBUG_NUM_PROPERTIES
};
static GParamSpec* folks_debug_properties[FOLKS_DEBUG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	FOLKS_DEBUG_DOMAINS_CORE = 1 << 0,
	FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND = 1 << 1,
	FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND = 1 << 2
} FolksDebugDomains;

#define FOLKS_DEBUG_TYPE_DOMAINS (folks_debug_domains_get_type ())

#define FOLKS_DEBUG_TYPE_KEY_VALUE_PAIR (folks_debug_key_value_pair_get_type ())
typedef struct _FolksDebugKeyValuePair FolksDebugKeyValuePair;
enum  {
	FOLKS_DEBUG_PRINT_STATUS_SIGNAL,
	FOLKS_DEBUG_NUM_SIGNALS
};
static guint folks_debug_signals[FOLKS_DEBUG_NUM_SIGNALS] = {0};

struct _FolksDebugPrivate {
	GeeHashSet* _domains;
	gboolean _all;
	guint _indentation;
	gchar* _indentation_string;
	gboolean _colour_enabled;
	GeeHashSet* _domains_handled;
	gboolean _debug_output_enabled;
};

struct _FolksDebugKeyValuePair {
	gchar* key;
	gchar* val;
};

static gint FolksDebug_private_offset;
static gpointer folks_debug_parent_class = NULL;
static FolksDebug* folks_debug__instance;
static FolksDebug* folks_debug__instance = NULL;

void g_log (const gchar* log_domain,
            GLogLevelFlags log_level,
            const gchar* format,
            ...)  G_GNUC_PRINTF(3,4) ;
static void _folks_debug_remove_handler (FolksDebug* self,
                                  const gchar* domain,
                                  gboolean keep_in_map);
static GType folks_debug_domains_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _folks_debug_print_status_log_handler_cb (FolksDebug* self,
                                               const gchar* log_domain,
                                               GLogLevelFlags log_levels,
                                               const gchar* message);
static void _folks_debug_log_handler_cb (FolksDebug* self,
                                  const gchar* log_domain,
                                  GLogLevelFlags log_levels,
                                  const gchar* message);
VALA_EXTERN void _folks_debug_register_domain (FolksDebug* self,
                                   const gchar* domain);
static void _folks_debug_set_handler (FolksDebug* self,
                               const gchar* domain,
                               GLogLevelFlags flags,
                               GLogFunc log_func,
                               gpointer log_func_target);
static void __folks_debug_log_handler_cb_glog_func (const gchar* log_domain,
                                             GLogLevelFlags log_levels,
                                             const gchar* message,
                                             gpointer self);
static void __lambda65_ (FolksDebug* self,
                  const gchar* domain_arg,
                  GLogLevelFlags flags,
                  const gchar* message);
static void ___lambda65__glog_func (const gchar* log_domain,
                             GLogLevelFlags log_levels,
                             const gchar* message,
                             gpointer self);
static FolksDebug* folks_debug_new (void);
static FolksDebug* folks_debug_construct (GType object_type);
static gchar* _folks_debug_format_nullable_string (FolksDebug* self,
                                            const gchar* input);
static GType folks_debug_key_value_pair_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FolksDebugKeyValuePair* folks_debug_key_value_pair_dup (const FolksDebugKeyValuePair* self);
static void folks_debug_key_value_pair_free (FolksDebugKeyValuePair* self);
static void folks_debug_key_value_pair_copy (const FolksDebugKeyValuePair* self,
                                      FolksDebugKeyValuePair* dest);
static void folks_debug_key_value_pair_destroy (FolksDebugKeyValuePair* self);
static void _vala_array_add1 (FolksDebugKeyValuePair* * array,
                       gint* length,
                       gint* size,
                       const FolksDebugKeyValuePair* value);
static void _vala_FolksDebugKeyValuePair_array_free (FolksDebugKeyValuePair * array,
                                              gssize array_length);
static GObject * folks_debug_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void __folks_debug_print_status_log_handler_cb_glog_func (const gchar* log_domain,
                                                          GLogLevelFlags log_levels,
                                                          const gchar* message,
                                                          gpointer self);
static void folks_debug_finalize (GObject * obj);
static GType folks_debug_get_type_once (void);
static void _vala_folks_debug_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_folks_debug_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
folks_debug_get_instance_private (FolksDebug* self)
{
	return G_STRUCT_MEMBER_P (self, FolksDebug_private_offset);
}

static GType
folks_debug_domains_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_DEBUG_DOMAINS_CORE, "FOLKS_DEBUG_DOMAINS_CORE", "core"}, {FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND, "FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND", "telepathy-backend"}, {FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND, "FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND", "key-file-backend"}, {0, NULL, NULL}};
	GType folks_debug_domains_type_id;
	folks_debug_domains_type_id = g_enum_register_static ("FolksDebugDomains", values);
	return folks_debug_domains_type_id;
}

static GType
folks_debug_domains_get_type (void)
{
	static volatile gsize folks_debug_domains_type_id__once = 0;
	if (g_once_init_enter (&folks_debug_domains_type_id__once)) {
		GType folks_debug_domains_type_id;
		folks_debug_domains_type_id = folks_debug_domains_get_type_once ();
		g_once_init_leave (&folks_debug_domains_type_id__once, folks_debug_domains_type_id);
	}
	return folks_debug_domains_type_id__once;
}

static void
_folks_debug_print_status_log_handler_cb (FolksDebug* self,
                                          const gchar* log_domain,
                                          GLogLevelFlags log_levels,
                                          const gchar* message)
{
	FILE* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s\n", message);
}

static void
_folks_debug_log_handler_cb (FolksDebug* self,
                             const gchar* log_domain,
                             GLogLevelFlags log_levels,
                             const gchar* message)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GLogFunc _tmp2_;
	gpointer _tmp2__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = folks_debug_get_debug_output_enabled (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FALSE) {
		return;
	}
	_tmp2_ = g_log_default_handler;
	_tmp2__target = NULL;
	_tmp2_ (log_domain, log_levels, message, _tmp2__target);
}

static void
__folks_debug_log_handler_cb_glog_func (const gchar* log_domain,
                                        GLogLevelFlags log_levels,
                                        const gchar* message,
                                        gpointer self)
{
	_folks_debug_log_handler_cb ((FolksDebug*) self, log_domain, log_levels, message);
}

static void
__lambda65_ (FolksDebug* self,
             const gchar* domain_arg,
             GLogLevelFlags flags,
             const gchar* message)
{
	g_return_if_fail (message != NULL);
}

static void
___lambda65__glog_func (const gchar* log_domain,
                        GLogLevelFlags log_levels,
                        const gchar* message,
                        gpointer self)
{
	__lambda65_ ((FolksDebug*) self, log_domain, log_levels, message);
}

void
_folks_debug_register_domain (FolksDebug* self,
                              const gchar* domain)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	if (self->priv->_all) {
		_tmp0_ = TRUE;
	} else {
		GeeHashSet* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_domains;
		_tmp2_ = g_utf8_strdown (domain, (gssize) -1);
		_tmp3_ = _tmp2_;
		_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
	}
	if (_tmp0_) {
		_folks_debug_set_handler (self, domain, G_LOG_LEVEL_MASK, __folks_debug_log_handler_cb_glog_func, self);
		return;
	}
	_folks_debug_set_handler (self, domain, G_LOG_LEVEL_DEBUG, ___lambda65__glog_func, self);
}

/**
   * Create or return the singleton {@link Folks.Debug} class instance.
   * If the instance doesn't exist already, it will be created with no debug
   * domains enabled.
   *
   * This function is thread-safe.
   *
   * @return  Singleton {@link Folks.Debug} instance
   * @since 0.5.1
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FolksDebug*
folks_debug_dup (void)
{
	FolksDebug* _retval = NULL;
	FolksDebug* _tmp0_;
	FolksDebug* _tmp1_;
	FolksDebug* retval = NULL;
	FolksDebug* _tmp2_;
	FolksDebug* result;
	_tmp0_ = folks_debug__instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_retval = _tmp1_;
	_tmp2_ = _retval;
	if (_tmp2_ == NULL) {
		FolksDebug* _tmp3_;
		FolksDebug* _tmp4_;
		_tmp3_ = folks_debug_new ();
		_g_object_unref0 (retval);
		retval = _tmp3_;
		_tmp4_ = retval;
		folks_debug__instance = _tmp4_;
	} else {
		FolksDebug* _tmp5_;
		FolksDebug* _tmp6_;
		_tmp5_ = _retval;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_DEBUG, FolksDebug));
		_g_object_unref0 (retval);
		retval = _tmp6_;
	}
	result = retval;
	_g_object_unref0 (_retval);
	return result;
}

/**
   * Create or return the singleton {@link Folks.Debug} class instance.
   * If the instance doesn't exist already, it will be created with the given
   * set of debug domains enabled. Otherwise, the existing instance will have
   * its set of enabled domains changed to the provided set.
   *
   * @param debug_flags A comma-separated list of debug domains to enable, or
   * null to disable debug output
   * @param colour_enabled Whether debug output should be coloured using
   * terminal escape sequences
   * @return Singleton {@link Folks.Debug} instance
   * @since 0.5.1
   */
FolksDebug*
folks_debug_dup_with_flags (const gchar* debug_flags,
                            gboolean colour_enabled)
{
	FolksDebug* retval = NULL;
	FolksDebug* _tmp0_;
	FolksDebug* _tmp1_;
	FolksDebug* _tmp2_;
	GeeHashSet* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp17_ = FALSE;
	FolksDebug* _tmp18_;
	FolksDebug* _tmp23_;
	FolksDebug* _tmp24_;
	FolksDebug* result;
	_tmp0_ = folks_debug_dup ();
	retval = _tmp0_;
	_tmp1_ = retval;
	_tmp1_->priv->_all = FALSE;
	_tmp2_ = retval;
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_tmp2_->priv->_domains);
	_tmp2_->priv->_domains = _tmp3_;
	if (debug_flags != NULL) {
		_tmp4_ = g_strcmp0 (debug_flags, "") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar** domains_split = NULL;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint domains_split_length1;
		gint _domains_split_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp6_ = _tmp5_ = g_strsplit ((const gchar*) debug_flags, ",", 0);
		domains_split = _tmp6_;
		domains_split_length1 = _vala_array_length (_tmp5_);
		_domains_split_size_ = domains_split_length1;
		_tmp7_ = domains_split;
		_tmp7__length1 = domains_split_length1;
		{
			gchar** domain_collection = NULL;
			gint domain_collection_length1 = 0;
			gint _domain_collection_size_ = 0;
			gint domain_it = 0;
			domain_collection = _tmp7_;
			domain_collection_length1 = _tmp7__length1;
			for (domain_it = 0; domain_it < domain_collection_length1; domain_it = domain_it + 1) {
				gchar* _tmp8_;
				gchar* domain = NULL;
				_tmp8_ = g_strdup (domain_collection[domain_it]);
				domain = _tmp8_;
				{
					gchar* domain_lower = NULL;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					GCompareFunc _tmp11_;
					const gchar* _tmp12_;
					_tmp9_ = domain;
					_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
					domain_lower = _tmp10_;
					_tmp11_ = ((GCompareFunc) g_strcmp0);
					_tmp12_ = domain_lower;
					if (_tmp11_ (_tmp12_, "all") == 0) {
						FolksDebug* _tmp13_;
						_tmp13_ = retval;
						_tmp13_->priv->_all = TRUE;
					} else {
						FolksDebug* _tmp14_;
						GeeHashSet* _tmp15_;
						const gchar* _tmp16_;
						_tmp14_ = retval;
						_tmp15_ = _tmp14_->priv->_domains;
						_tmp16_ = domain_lower;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
					}
					_g_free0 (domain_lower);
					_g_free0 (domain);
				}
			}
		}
		domains_split = (_vala_array_free (domains_split, domains_split_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = retval;
	if (_tmp18_->priv->_all) {
		_tmp17_ = TRUE;
	} else {
		FolksDebug* _tmp19_;
		GeeHashSet* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = retval;
		_tmp20_ = _tmp19_->priv->_domains;
		_tmp21_ = gee_collection_get_is_empty ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp17_ = !_tmp22_;
	}
	_tmp23_ = retval;
	folks_debug_set_debug_output_enabled (_tmp23_, _tmp17_);
	_tmp24_ = retval;
	folks_debug_set_colour_enabled (_tmp24_, colour_enabled);
	result = retval;
	return result;
}

static FolksDebug*
folks_debug_construct (GType object_type)
{
	FolksDebug * self = NULL;
	self = (FolksDebug*) g_object_new (object_type, NULL);
	return self;
}

static FolksDebug*
folks_debug_new (void)
{
	return folks_debug_construct (FOLKS_TYPE_DEBUG);
}

static void
_folks_debug_set_handler (FolksDebug* self,
                          const gchar* domain,
                          GLogLevelFlags flags,
                          GLogFunc log_func,
                          gpointer log_func_target)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_folks_debug_remove_handler (self, domain, FALSE);
	g_log_set_handler (domain, flags, log_func, log_func_target);
	_tmp0_ = self->priv->_domains_handled;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, domain);
}

static void
_folks_debug_remove_handler (FolksDebug* self,
                             const gchar* domain,
                             gboolean keep_in_map)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_tmp0_ = self->priv->_domains_handled;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, domain)) {
		GLogFunc _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = g_log_default_handler;
		_tmp1__target = NULL;
		g_log_set_handler (domain, (G_LOG_LEVEL_MASK | G_LOG_FLAG_RECURSION) | G_LOG_FLAG_FATAL, _tmp1_, _tmp1__target);
		if (!keep_in_map) {
			GeeHashSet* _tmp2_;
			_tmp2_ = self->priv->_domains_handled;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp2_, domain);
		}
	}
}

/**
   * Causes all significant objects in the library to print their current
   * status to standard output, obeying the options set on this
   * {@link Folks.Debug} instance for colouring and other formatting.
   *
   * @since 0.5.1
   */
void
folks_debug_emit_print_status (FolksDebug* self)
{
	g_return_if_fail (self != NULL);
	g_print ("Dumping status information…\n");
	g_signal_emit (self, folks_debug_signals[FOLKS_DEBUG_PRINT_STATUS_SIGNAL], 0);
}

/**
   * Increment the indentation level used when printing output through the
   * object.
   *
   * This is intended to be used by backend libraries only.
   *
   * @since 0.5.1
   */
void
folks_debug_indent (FolksDebug* self)
{
	guint _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_indentation;
	self->priv->_indentation = _tmp0_ + 1;
	_tmp1_ = g_strnfill ((gsize) (self->priv->_indentation * 2), ' ');
	_g_free0 (self->priv->_indentation_string);
	self->priv->_indentation_string = _tmp1_;
}

/**
   * Decrement the indentation level used when printing output through the
   * object.
   *
   * This is intended to be used by backend libraries only.
   *
   * @since 0.5.1
   */
void
folks_debug_unindent (FolksDebug* self)
{
	guint _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_indentation;
	self->priv->_indentation = _tmp0_ - 1;
	_tmp1_ = g_strnfill ((gsize) (self->priv->_indentation * 2), ' ');
	_g_free0 (self->priv->_indentation_string);
	self->priv->_indentation_string = _tmp1_;
}

/**
   * Print a debug line with the current indentation level for the specified
   * debug domain.
   *
   * This is intended to be used by backend libraries only.
   *
   * @param domain The debug domain name
   * @param level A set of log level flags for the message
   * @param format A printf-style format string for the heading
   * @param ... Arguments for the format string
   * @since 0.5.1
   */
void
folks_debug_print_line (FolksDebug* self,
                        const gchar* domain,
                        GLogLevelFlags level,
                        const gchar* format,
                        ...)
{
	va_list valist = {0};
	gchar* output = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = g_strdup_vprintf (format, valist);
	output = _tmp0_;
	_tmp1_ = self->priv->_indentation_string;
	g_log (domain, level, "%s%s", _tmp1_, output);
	_g_free0 (output);
	va_end (valist);
}

/**
   * Print a debug line as a heading. It will be coloured according to the
   * current indentation level so that different levels of headings stand out.
   *
   * This is intended to be used by backend libraries only.
   *
   * @param domain The debug domain name
   * @param level A set of log level flags for the message
   * @param format A printf-style format string for the heading
   * @param ... Arguments for the format string
   * @since 0.5.1
   */
void
folks_debug_print_heading (FolksDebug* self,
                           const gchar* domain,
                           GLogLevelFlags level,
                           const gchar* format,
                           ...)
{
	static const gint heading_colours[3] = {31, 32, 34};
	gchar* wrapper_format = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	va_list valist = {0};
	gchar* output = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (format != NULL);
	_tmp0_ = g_strdup ("%s");
	wrapper_format = _tmp0_;
	_tmp1_ = folks_debug_get_colour_enabled (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		guint indentation = 0U;
		gint _tmp3_;
		gchar* _tmp4_;
		indentation = CLAMP (self->priv->_indentation, (guint) 0, (guint) (G_N_ELEMENTS (heading_colours) - 1));
		_tmp3_ = heading_colours[indentation];
		_tmp4_ = g_strdup_printf ("\033[1;%im%%s\033[0m", _tmp3_);
		_g_free0 (wrapper_format);
		wrapper_format = _tmp4_;
	}
	va_start (valist, format);
	_tmp5_ = g_strdup_vprintf (format, valist);
	output = _tmp5_;
	_tmp6_ = wrapper_format;
	folks_debug_print_line (self, domain, level, _tmp6_, output);
	_g_free0 (output);
	va_end (valist);
	_g_free0 (wrapper_format);
}

static gchar*
_folks_debug_format_nullable_string (FolksDebug* self,
                                     const gchar* input)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = folks_debug_get_colour_enabled (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		_tmp0_ = input == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("\033[1;36m(null)\033[0m");
		result = _tmp3_;
		return result;
	} else {
		if (input == NULL) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("(null)");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_strdup ((const gchar*) input);
	result = _tmp5_;
	return result;
}

/**
   * Print a set of key–value pairs in a table. The width of the key column is
   * automatically set to the width of the longest key. The keys and values
   * must be provided as a null-delimited list of alternating key–value varargs.
   * Values may be null but keys may not.
   *
   * This is intended to be used by backend libraries only.
   *
   * The table will be printed at the current indentation level plus one.
   *
   * @param domain The debug domain name
   * @param level A set of log level flags for the message
   * @param ... Alternating keys and values, terminated with null
   * @since 0.5.1
   */
static void
_vala_array_add1 (FolksDebugKeyValuePair* * array,
                  gint* length,
                  gint* size,
                  const FolksDebugKeyValuePair* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksDebugKeyValuePair, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_FolksDebugKeyValuePair_array_free (FolksDebugKeyValuePair * array,
                                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			folks_debug_key_value_pair_destroy (&array[i]);
		}
	}
	g_free (array);
}

void
folks_debug_print_key_value_pairs (FolksDebug* self,
                                   const gchar* domain,
                                   GLogLevelFlags level,
                                   ...)
{
	va_list valist = {0};
	FolksDebugKeyValuePair* lines = NULL;
	FolksDebugKeyValuePair* _tmp0_;
	gint lines_length1;
	gint _lines_size_;
	guint max_key_length = 0U;
	FolksDebugKeyValuePair* _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	va_start (valist, level);
	_tmp0_ = g_new0 (FolksDebugKeyValuePair, 0);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	max_key_length = (guint) 0;
	while (TRUE) {
		gchar* _key = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* key = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* val = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		FolksDebugKeyValuePair _tmp15_ = {0};
		_tmp1_ = va_arg (valist, gchar*);
		_tmp2_ = g_strdup (_tmp1_);
		_key = _tmp2_;
		_tmp3_ = _key;
		if (_tmp3_ == NULL) {
			_g_free0 (_key);
			break;
		}
		_tmp4_ = _key;
		_tmp5_ = g_strdup ((const gchar*) _tmp4_);
		key = _tmp5_;
		_tmp6_ = va_arg (valist, gchar*);
		_tmp7_ = g_strdup (_tmp6_);
		val = _tmp7_;
		_tmp8_ = key;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		max_key_length = MAX ((guint) _tmp10_, max_key_length);
		_tmp11_ = key;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = val;
		_tmp14_ = g_strdup (_tmp13_);
		memset (&_tmp15_, 0, sizeof (FolksDebugKeyValuePair));
		_g_free0 (_tmp15_.key);
		_tmp15_.key = _tmp12_;
		_g_free0 (_tmp15_.val);
		_tmp15_.val = _tmp14_;
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, &_tmp15_);
		_g_free0 (val);
		_g_free0 (key);
		_g_free0 (_key);
	}
	folks_debug_indent (self);
	_tmp16_ = lines;
	_tmp16__length1 = lines_length1;
	{
		FolksDebugKeyValuePair* line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp16_;
		line_collection_length1 = _tmp16__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			FolksDebugKeyValuePair _tmp17_;
			FolksDebugKeyValuePair _tmp18_ = {0};
			FolksDebugKeyValuePair line = {0};
			_tmp17_ = line_collection[line_it];
			folks_debug_key_value_pair_copy (&_tmp17_, &_tmp18_);
			line = _tmp18_;
			{
				gchar* padding = NULL;
				FolksDebugKeyValuePair _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gchar* _tmp23_;
				FolksDebugKeyValuePair _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				FolksDebugKeyValuePair _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp19_ = line;
				_tmp20_ = _tmp19_.key;
				_tmp21_ = strlen (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strnfill ((gsize) (max_key_length - _tmp22_), ' ');
				padding = _tmp23_;
				_tmp24_ = line;
				_tmp25_ = _tmp24_.key;
				_tmp26_ = padding;
				_tmp27_ = line;
				_tmp28_ = _tmp27_.val;
				_tmp29_ = _folks_debug_format_nullable_string (self, _tmp28_);
				_tmp30_ = _tmp29_;
				folks_debug_print_line (self, domain, level, "%s: %s%s", _tmp25_, _tmp26_, _tmp30_);
				_g_free0 (_tmp30_);
				_g_free0 (padding);
				folks_debug_key_value_pair_destroy (&line);
			}
		}
	}
	folks_debug_unindent (self);
	lines = (_vala_FolksDebugKeyValuePair_array_free (lines, lines_length1), NULL);
	va_end (valist);
}

gboolean
folks_debug_get_colour_enabled (FolksDebug* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_colour_enabled;
	return result;
}

void
folks_debug_set_colour_enabled (FolksDebug* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_colour_enabled = value;
	g_object_notify_by_pspec ((GObject *) self, folks_debug_properties[FOLKS_DEBUG_COLOUR_ENABLED_PROPERTY]);
}

gboolean
folks_debug_get_debug_output_enabled (FolksDebug* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug_output_enabled;
	return result;
}

void
folks_debug_set_debug_output_enabled (FolksDebug* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_debug_output_enabled = value;
	g_object_notify_by_pspec ((GObject *) self, folks_debug_properties[FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED_PROPERTY]);
}

static void
folks_debug_key_value_pair_copy (const FolksDebugKeyValuePair* self,
                                 FolksDebugKeyValuePair* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).key;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp1_;
	_tmp2_ = (*self).val;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).val);
	(*dest).val = _tmp3_;
}

static void
folks_debug_key_value_pair_destroy (FolksDebugKeyValuePair* self)
{
	_g_free0 ((*self).key);
	_g_free0 ((*self).val);
}

static FolksDebugKeyValuePair*
folks_debug_key_value_pair_dup (const FolksDebugKeyValuePair* self)
{
	FolksDebugKeyValuePair* dup;
	dup = g_new0 (FolksDebugKeyValuePair, 1);
	folks_debug_key_value_pair_copy (self, dup);
	return dup;
}

static void
folks_debug_key_value_pair_free (FolksDebugKeyValuePair* self)
{
	folks_debug_key_value_pair_destroy (self);
	g_free (self);
}

static GType
folks_debug_key_value_pair_get_type_once (void)
{
	GType folks_debug_key_value_pair_type_id;
	folks_debug_key_value_pair_type_id = g_boxed_type_register_static ("FolksDebugKeyValuePair", (GBoxedCopyFunc) folks_debug_key_value_pair_dup, (GBoxedFreeFunc) folks_debug_key_value_pair_free);
	return folks_debug_key_value_pair_type_id;
}

static GType
folks_debug_key_value_pair_get_type (void)
{
	static volatile gsize folks_debug_key_value_pair_type_id__once = 0;
	if (g_once_init_enter (&folks_debug_key_value_pair_type_id__once)) {
		GType folks_debug_key_value_pair_type_id;
		folks_debug_key_value_pair_type_id = folks_debug_key_value_pair_get_type_once ();
		g_once_init_leave (&folks_debug_key_value_pair_type_id__once, folks_debug_key_value_pair_type_id);
	}
	return folks_debug_key_value_pair_type_id__once;
}

static void
__folks_debug_print_status_log_handler_cb_glog_func (const gchar* log_domain,
                                                     GLogLevelFlags log_levels,
                                                     const gchar* message,
                                                     gpointer self)
{
	_folks_debug_print_status_log_handler_cb ((FolksDebug*) self, log_domain, log_levels, message);
}

static GObject *
folks_debug_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksDebug * self;
	GeeHashSet* _tmp0_;
	parent_class = G_OBJECT_CLASS (folks_debug_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_DEBUG, FolksDebug);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_domains_handled);
	self->priv->_domains_handled = _tmp0_;
	_folks_debug_set_handler (self, FOLKS_DEBUG_STATUS_LOG_DOMAIN, G_LOG_LEVEL_MASK, __folks_debug_print_status_log_handler_cb_glog_func, self);
	return obj;
}

static void
folks_debug_class_init (FolksDebugClass * klass,
                        gpointer klass_data)
{
	folks_debug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksDebug_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_debug_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_debug_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_debug_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_debug_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DEBUG_COLOUR_ENABLED_PROPERTY, folks_debug_properties[FOLKS_DEBUG_COLOUR_ENABLED_PROPERTY] = g_param_spec_boolean ("colour-enabled", "colour-enabled", "colour-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether debug output is enabled. This is orthogonal to the set of enabled
	   * debug domains; filtering of debug output as a whole is done after filtering
	   * by enabled domains.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED_PROPERTY, folks_debug_properties[FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED_PROPERTY] = g_param_spec_boolean ("debug-output-enabled", "debug-output-enabled", "debug-output-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Signal emitted in the main thread whenever objects should print their
	   * current status. All significant objects in the library should connect
	   * to this and print their current status in some suitable format when it's
	   * emitted.
	   *
	   * Client processes should emit this signal by calling
	   * {@link Debug.emit_print_status}.
	   *
	   * @since 0.5.1
	   */
	folks_debug_signals[FOLKS_DEBUG_PRINT_STATUS_SIGNAL] = g_signal_new ("print-status", FOLKS_TYPE_DEBUG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
folks_debug_instance_init (FolksDebug * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	self->priv = folks_debug_get_instance_private (self);
	self->priv->_all = FALSE;
	self->priv->_indentation = (guint) 0;
	_tmp0_ = g_strdup ("");
	self->priv->_indentation_string = _tmp0_;
	self->priv->_colour_enabled = TRUE;
	self->priv->_debug_output_enabled = FALSE;
}

static void
folks_debug_finalize (GObject * obj)
{
	FolksDebug * self;
	GeeHashSet* _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_DEBUG, FolksDebug);
	{
		GeeIterator* _domain_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->_domains_handled;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_domain_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gchar* domain = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			const gchar* _tmp5_;
			_tmp2_ = _domain_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _domain_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			domain = (gchar*) _tmp4_;
			_tmp5_ = domain;
			_folks_debug_remove_handler (self, _tmp5_, TRUE);
			_g_free0 (domain);
		}
		_g_object_unref0 (_domain_it);
	}
	_tmp6_ = self->priv->_domains_handled;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
	folks_debug__instance = NULL;
	_g_object_unref0 (self->priv->_domains);
	_g_free0 (self->priv->_indentation_string);
	_g_object_unref0 (self->priv->_domains_handled);
	G_OBJECT_CLASS (folks_debug_parent_class)->finalize (obj);
}

/**
 * Manages debug output and status reporting for all folks objects.
 *
 * All GLib debug logging calls are passed through a log handler in this class,
 * which allows debug domains to be outputted according to whether they've been
 * enabled by being passed to {@link Debug.dup}.
 *
 * @since 0.5.1
 */
static GType
folks_debug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksDebugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_debug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDebug), 0, (GInstanceInitFunc) folks_debug_instance_init, NULL };
	GType folks_debug_type_id;
	folks_debug_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksDebug", &g_define_type_info, 0);
	FolksDebug_private_offset = g_type_add_instance_private (folks_debug_type_id, sizeof (FolksDebugPrivate));
	return folks_debug_type_id;
}

GType
folks_debug_get_type (void)
{
	static volatile gsize folks_debug_type_id__once = 0;
	if (g_once_init_enter (&folks_debug_type_id__once)) {
		GType folks_debug_type_id;
		folks_debug_type_id = folks_debug_get_type_once ();
		g_once_init_leave (&folks_debug_type_id__once, folks_debug_type_id);
	}
	return folks_debug_type_id__once;
}

static void
_vala_folks_debug_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	FolksDebug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_DEBUG, FolksDebug);
	switch (property_id) {
		case FOLKS_DEBUG_COLOUR_ENABLED_PROPERTY:
		g_value_set_boolean (value, folks_debug_get_colour_enabled (self));
		break;
		case FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED_PROPERTY:
		g_value_set_boolean (value, folks_debug_get_debug_output_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_debug_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	FolksDebug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_DEBUG, FolksDebug);
	switch (property_id) {
		case FOLKS_DEBUG_COLOUR_ENABLED_PROPERTY:
		folks_debug_set_colour_enabled (self, g_value_get_boolean (value));
		break;
		case FOLKS_DEBUG_DEBUG_OUTPUT_ENABLED_PROPERTY:
		folks_debug_set_debug_output_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

