/* math-buttons.c generated by valac 0.56.0, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include "calculator.h"
#include <glib.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
enum  {
	MATH_BUTTONS_0_PROPERTY,
	MATH_BUTTONS_MODE_PROPERTY,
	MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY,
	MATH_BUTTONS_NUM_PROPERTIES
};
static GParamSpec* math_buttons_properties[MATH_BUTTONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MATH_VARIABLE (math_variable_get_type ())
#define MATH_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE, MathVariable))
#define MATH_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE, MathVariableClass))
#define IS_MATH_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE))
#define IS_MATH_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE))
#define MATH_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE, MathVariableClass))

typedef struct _MathVariable MathVariable;
typedef struct _MathVariableClass MathVariableClass;

#define TYPE_MATH_POPOVER (math_popover_get_type ())
#define MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_POPOVER, MathPopover))
#define MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_POPOVER, MathPopoverClass))
#define IS_MATH_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_POPOVER))
#define IS_MATH_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_POPOVER))
#define MATH_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_POPOVER, MathPopoverClass))

typedef struct _MathPopover MathPopover;
typedef struct _MathPopoverClass MathPopoverClass;

#define TYPE_MATH_VARIABLE_POPOVER (math_variable_popover_get_type ())
#define MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopover))
#define MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))
#define IS_MATH_VARIABLE_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPOVER))
#define IS_MATH_VARIABLE_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPOVER))
#define MATH_VARIABLE_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPOVER, MathVariablePopoverClass))

typedef struct _MathVariablePopover MathVariablePopover;
typedef struct _MathVariablePopoverClass MathVariablePopoverClass;

#define TYPE_MATH_FUNCTION_POPOVER (math_function_popover_get_type ())
#define MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopover))
#define MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))
#define IS_MATH_FUNCTION_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPOVER))
#define IS_MATH_FUNCTION_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPOVER))
#define MATH_FUNCTION_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPOVER, MathFunctionPopoverClass))

typedef struct _MathFunctionPopover MathFunctionPopover;
typedef struct _MathFunctionPopoverClass MathFunctionPopoverClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	MathWindow* window;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	AdwLeaflet* prog_leaflet;
	GtkToggleButton* prog_view_more_button;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkMenuButton* word_size_button;
	GtkWidget* bit_panel;
	GList* toggle_bit_buttons;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
	GSimpleActionGroup* action_group;
};

struct _Block1Data {
	int _ref_count_;
	MathButtons* self;
	MathPopover* math_popover;
};

struct _Block2Data {
	int _ref_count_;
	MathButtons* self;
	MathPopover* math_popover;
};

static gint MathButtons_private_offset;
static gpointer math_buttons_parent_class = NULL;

VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
static void math_buttons_on_insert (MathButtons* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_buttons_on_insert_digit (MathButtons* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void math_buttons_on_subtract (MathButtons* self,
                               GSimpleAction* action,
                               GVariant* param);
static void _math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void math_buttons_on_square (MathButtons* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_buttons_on_undo (MathButtons* self,
                           GSimpleAction* action,
                           GVariant* param);
static void _math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void math_buttons_on_solve (MathButtons* self,
                            GSimpleAction* action,
                            GVariant* param);
static void _math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void math_buttons_on_clear (MathButtons* self,
                            GSimpleAction* action,
                            GVariant* param);
static void _math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void math_buttons_on_factorize (MathButtons* self,
                                GSimpleAction* action,
                                GVariant* param);
static void _math_buttons_on_factorize_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void math_buttons_on_insert_exponent (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_bitshift (MathButtons* self,
                               GSimpleAction* action,
                               GVariant* param);
static void _math_buttons_on_bitshift_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void math_buttons_on_set_word_size (MathButtons* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _math_buttons_on_set_word_size_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void math_buttons_on_toggle_bit (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param);
static void _math_buttons_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void math_buttons_on_insert_character (MathButtons* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _math_buttons_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void math_buttons_on_insert_numeric_point (MathButtons* self,
                                           GSimpleAction* action,
                                           GVariant* param);
static void _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void math_buttons_on_set_number_mode (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param);
static void _math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void math_buttons_on_launch_finc_dialog (MathButtons* self,
                                         GSimpleAction* action,
                                         GVariant* param);
static void _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN MathButtons* math_buttons_new (MathEquation* equation,
                               MathWindow* window);
VALA_EXTERN MathButtons* math_buttons_construct (GType object_type,
                                     MathEquation* equation,
                                     MathWindow* window);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self);
static void __lambda35_ (MathButtons* self,
                  GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda36_ (MathButtons* self,
                  GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda36__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda37_ (MathButtons* self,
                  GParamSpec* pspec);
static void ___lambda37__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda38_ (MathButtons* self,
                  GParamSpec* pspec);
static void ___lambda38__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda39_ (MathButtons* self,
                  GParamSpec* pspec);
static void math_buttons_word_size_changed_cb (MathButtons* self);
static void ___lambda39__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
static void math_buttons_load_finc_dialog (MathButtons* self,
                                    const gchar* name,
                                    gchar** entry_names,
                                    gint entry_names_length1,
                                    FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self,
                                    GtkWidget* widget,
                                    gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                         gint response_id,
                                                         gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self,
                                    GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                        gpointer self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self,
                                            GtkComboBox* combo);
VALA_EXTERN void math_buttons_set_programming_base (MathButtons* self,
                                        gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
static void math_buttons_update_view_more_visible (MathButtons* self);
VALA_EXTERN void math_converter_set_view_more_visible (MathConverter* self,
                                           gboolean value);
static GtkWidget* math_buttons_load_mode (MathButtons* self,
                                   ButtonMode mode);
static gboolean ___lambda13_ (MathButtons* self,
                       GBinding* binding,
                       GValue* from,
                       GValue* to);
static gboolean ____lambda13__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static gboolean ___lambda14_ (MathButtons* self,
                       GBinding* binding,
                       GValue* from,
                       GValue* to);
static gboolean ____lambda14__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static void _math_buttons_update_view_more_visible_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static gboolean ___lambda15_ (MathButtons* self,
                       GBinding* binding,
                       GValue* from,
                       GValue* to);
static gboolean ____lambda15__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static gboolean ___lambda16_ (MathButtons* self,
                       GBinding* binding,
                       GValue* from,
                       GValue* to);
static gboolean ____lambda16__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static gboolean ___lambda17_ (MathButtons* self,
                       GBinding* binding,
                       GValue* from,
                       GValue* to);
static gboolean ____lambda17__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static gboolean ___lambda18_ (MathButtons* self,
                       GBinding* binding,
                       GValue* from,
                       GValue* to);
static gboolean ____lambda18__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static GMenu* math_buttons_create_shift_menu (MathButtons* self,
                                       gboolean shift_left);
static GMenu* math_buttons_create_word_size_menu (MathButtons* self);
VALA_EXTERN GType math_variable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathVariable, g_object_unref)
VALA_EXTERN GType math_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPopover, g_object_unref)
VALA_EXTERN GType math_variable_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathVariablePopover, g_object_unref)
static gint ___lambda24_ (MathButtons* self,
                   gconstpointer a,
                   gconstpointer b);
VALA_EXTERN gint math_variable_name_compare_func (MathVariable* var1,
                                      MathVariable* var2);
static gint ____lambda24__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
VALA_EXTERN MathVariablePopover* math_variable_popover_new (MathEquation* equation,
                                                GListStore* model,
                                                GCompareDataFunc compare_func,
                                                gpointer compare_func_target);
VALA_EXTERN MathVariablePopover* math_variable_popover_construct (GType object_type,
                                                      MathEquation* equation,
                                                      GListStore* model,
                                                      GCompareDataFunc compare_func,
                                                      gpointer compare_func_target);
static void math_buttons_fill_variables_model (MathButtons* self,
                                        GListStore* model,
                                        MathPopover* math_popover,
                                        MathEquation* equation);
VALA_EXTERN GType math_function_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathFunctionPopover, g_object_unref)
VALA_EXTERN MathFunctionPopover* math_function_popover_new (MathEquation* equation,
                                                GListStore* model);
VALA_EXTERN MathFunctionPopover* math_function_popover_construct (GType object_type,
                                                      MathEquation* equation,
                                                      GListStore* model);
static void math_buttons_fill_functions_model (MathButtons* self,
                                        GListStore* model,
                                        MathPopover* math_popover,
                                        FunctionManager* function_manager);
static void math_buttons_character_code_dialog_response_cb (MathButtons* self,
                                                     GtkWidget* dialog,
                                                     gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                                          gint response_id,
                                                                          gpointer self);
static gboolean math_buttons_character_code_dialog_close_request (MathButtons* self,
                                                           GtkWidget* dialog);
static gboolean _math_buttons_character_code_dialog_close_request_gtk_window_close_request (GtkWindow* _sender,
                                                                                     gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self,
                                                     GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                                         gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static void ___lambda34_ (MathButtons* self,
                   GParamSpec* pspec);
static void ____lambda34__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN void math_popover_item_added_cb (MathPopover* self,
                                 gconstpointer item);
static void __lambda31_ (Block1Data* _data1_,
                  MathFunction* f);
static void ___lambda31__function_manager_function_added (FunctionManager* _sender,
                                                   MathFunction* function,
                                                   gpointer self);
static void __lambda32_ (Block1Data* _data1_,
                  MathFunction* f);
VALA_EXTERN void math_popover_item_edited_cb (MathPopover* self,
                                  gconstpointer item);
static void ___lambda32__function_manager_function_edited (FunctionManager* _sender,
                                                    MathFunction* new_function,
                                                    gpointer self);
static void __lambda33_ (Block1Data* _data1_,
                  MathFunction* f);
VALA_EXTERN void math_popover_item_deleted_cb (MathPopover* self,
                                   gconstpointer item);
static void ___lambda33__function_manager_function_deleted (FunctionManager* _sender,
                                                     MathFunction* function,
                                                     gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN MathVariable* math_variable_new (const gchar* name,
                                 Number* value);
VALA_EXTERN MathVariable* math_variable_construct (GType object_type,
                                       const gchar* name,
                                       Number* value);
static void __lambda25_ (Block2Data* _data2_,
                  const gchar* name,
                  Number* value);
static void ___lambda25__math_variables_variable_added (MathVariables* _sender,
                                                 const gchar* name,
                                                 Number* value,
                                                 gpointer self);
static void __lambda26_ (Block2Data* _data2_,
                  const gchar* name,
                  Number* value);
static void ___lambda26__math_variables_variable_edited (MathVariables* _sender,
                                                  const gchar* name,
                                                  Number* new_value,
                                                  gpointer self);
static void __lambda27_ (Block2Data* _data2_,
                  const gchar* name);
static void ___lambda27__math_variables_variable_deleted (MathVariables* _sender,
                                                   const gchar* name,
                                                   gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
VALA_EXTERN void math_converter_get_conversion (MathConverter* self,
                                    Unit** from_unit,
                                    Unit** to_unit);
VALA_EXTERN MathConverter* math_converter_new (MathEquation* equation);
VALA_EXTERN MathConverter* math_converter_construct (GType object_type,
                                         MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender,
                                                                gpointer self);
static void ___lambda12_ (MathButtons* self);
VALA_EXTERN gboolean math_converter_get_view_more_active (MathConverter* self);
static void ____lambda12__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void math_buttons_update_bit_button_sensitivities (MathButtons* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup10 (gchar** self,
                           gssize length);
static guint8* _vala_array_dup11 (guint8* self,
                           gssize length);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
VALA_EXTERN void math_buttons_set_mode (MathButtons* self,
                            ButtonMode value);
VALA_EXTERN void math_converter_set_category (MathConverter* self,
                                  const gchar* category);
VALA_EXTERN void math_converter_set_conversion (MathConverter* self,
                                    const gchar* unit_a,
                                    const gchar* unit_b);
VALA_EXTERN void math_converter_set_view_more_active (MathConverter* self,
                                          gboolean value);
VALA_EXTERN gint math_buttons_get_programming_base (MathButtons* self);
static void math_buttons_finalize (GObject * obj);
static GType math_buttons_get_type_once (void);
static void _vala_math_buttons_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[4] = {"syd_cost", "syd_salvage", "syd_life", "syd_period"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};
static const GActionEntry MATH_BUTTONS_action_entries[16] = {{"insert-general", _math_buttons_on_insert_gsimple_action_activate_callback, "s"}, {"insert-digit", _math_buttons_on_insert_digit_gsimple_action_activate_callback, "i"}, {"subtract", _math_buttons_on_subtract_gsimple_action_activate_callback}, {"square", _math_buttons_on_square_gsimple_action_activate_callback}, {"undo", _math_buttons_on_undo_gsimple_action_activate_callback}, {"solve", _math_buttons_on_solve_gsimple_action_activate_callback}, {"clear", _math_buttons_on_clear_gsimple_action_activate_callback}, {"factorize", _math_buttons_on_factorize_gsimple_action_activate_callback}, {"insert-exponent", _math_buttons_on_insert_exponent_gsimple_action_activate_callback}, {"bitshift", _math_buttons_on_bitshift_gsimple_action_activate_callback, "i"}, {"set-word-size", _math_buttons_on_set_word_size_gsimple_action_activate_callback, "i"}, {"toggle-bit", _math_buttons_on_toggle_bit_gsimple_action_activate_callback, "i"}, {"insert-character", _math_buttons_on_insert_character_gsimple_action_activate_callback}, {"insert-numeric-point", _math_buttons_on_insert_numeric_point_gsimple_action_activate_callback}, {"set-number-mode", _math_buttons_on_set_number_mode_gsimple_action_activate_callback, "s", "'normal'"}, {"launch-finc-dialog", _math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback, "s"}};

static GType
button_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {BUTTON_MODE_KEYBOARD, "BUTTON_MODE_KEYBOARD", "keyboard"}, {0, NULL, NULL}};
	GType button_mode_type_id;
	button_mode_type_id = g_enum_register_static ("ButtonMode", values);
	return button_mode_type_id;
}

GType
button_mode_get_type (void)
{
	static volatile gsize button_mode_type_id__once = 0;
	if (g_once_init_enter (&button_mode_type_id__once)) {
		GType button_mode_type_id;
		button_mode_type_id = button_mode_get_type_once ();
		g_once_init_leave (&button_mode_type_id__once, button_mode_type_id);
	}
	return button_mode_type_id__once;
}

static inline gpointer
math_buttons_get_instance_private (MathButtons* self)
{
	return G_STRUCT_MEMBER_P (self, MathButtons_private_offset);
}

static void
_math_buttons_on_insert_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_buttons_on_insert ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_digit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	math_buttons_on_insert_digit ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_subtract_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	math_buttons_on_subtract ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_square_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_buttons_on_square ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	math_buttons_on_undo ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_solve_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	math_buttons_on_solve ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_clear_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	math_buttons_on_clear ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_factorize_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	math_buttons_on_factorize ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_exponent_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_insert_exponent ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_bitshift_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	math_buttons_on_bitshift ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_set_word_size_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	math_buttons_on_set_word_size ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_toggle_bit_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	math_buttons_on_toggle_bit ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_character_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	math_buttons_on_insert_character ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_insert_numeric_point_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	math_buttons_on_insert_numeric_point ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_set_number_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	math_buttons_on_set_number_mode ((MathButtons*) self, action, parameter);
}

static void
_math_buttons_on_launch_finc_dialog_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	math_buttons_on_launch_finc_dialog ((MathButtons*) self, action, parameter);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender,
                                            gpointer self)
{
	math_buttons_load_buttons ((MathButtons*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda35_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}

static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda35_ ((MathButtons*) self, pspec);
}

static void
__lambda36_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}

static void
___lambda36__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda36_ ((MathButtons*) self, pspec);
}

static void
__lambda37_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}

static void
___lambda37__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda37_ ((MathButtons*) self, pspec);
}

static void
__lambda38_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}

static void
___lambda38__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda38_ ((MathButtons*) self, pspec);
}

static void
__lambda39_ (MathButtons* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_word_size_changed_cb (self);
}

static void
___lambda39__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda39_ ((MathButtons*) self, pspec);
}

MathButtons*
math_buttons_construct (GType object_type,
                        MathEquation* equation,
                        MathWindow* window)
{
	MathButtons * self = NULL;
	MathEquation* _tmp0_;
	MathWindow* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "vexpand-set", TRUE, NULL);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp1_;
	_tmp2_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp2_, MATH_BUTTONS_action_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_action_entries), self);
	_tmp3_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "cal", (GActionGroup*) _tmp3_);
	g_signal_connect_object ((GObject*) equation, "notify::display", (GCallback) ___lambda35__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::number-mode", (GCallback) ___lambda36__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::angle-units", (GCallback) ___lambda37__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::number-format", (GCallback) ___lambda38__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) equation, "notify::word-size", (GCallback) ___lambda39__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}

MathButtons*
math_buttons_new (MathEquation* equation,
                  MathWindow* window)
{
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation, window);
}

static void
math_buttons_load_finc_dialogs (MathButtons* self)
{
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, (gint) G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}

static void
_math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                    gint response_id,
                                                    gpointer self)
{
	math_buttons_finc_response_cb ((MathButtons*) self, _sender, response_id);
}

static void
_math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                   gpointer self)
{
	math_buttons_finc_activate_cb ((MathButtons*) self, _sender);
}

static void
math_buttons_load_finc_dialog (MathButtons* self,
                               const gchar* name,
                               gchar** entry_names,
                               gint entry_names_length1,
                               FinancialDialog function)
{
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = gtk_builder_get_object (_tmp0_, name);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	g_object_set_data_full ((GObject*) _tmp3_, "finc-function", (gpointer) ((gintptr) function), NULL);
	_tmp4_ = dialog;
	g_signal_connect_object (_tmp4_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp7_;
				const gchar* _tmp8_;
				GObject* _tmp9_;
				GtkEntry* _tmp10_;
				GtkEntry* _tmp16_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < entry_names_length1)) {
					break;
				}
				_tmp7_ = self->priv->financial_ui;
				_tmp8_ = entry_names[i];
				_tmp9_ = gtk_builder_get_object (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp9_) : NULL);
				entry = _tmp10_;
				if (i != (entry_names_length1 - 1)) {
					GtkEntry* _tmp11_;
					GtkBuilder* _tmp12_;
					const gchar* _tmp13_;
					GObject* _tmp14_;
					GtkEntry* _tmp15_;
					_tmp11_ = entry;
					_tmp12_ = self->priv->financial_ui;
					_tmp13_ = entry_names[i + 1];
					_tmp14_ = gtk_builder_get_object (_tmp12_, _tmp13_);
					_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp14_) : NULL);
					g_object_set_data_full ((GObject*) _tmp11_, "next-entry", _tmp15_, g_object_unref);
				}
				_tmp16_ = entry;
				g_signal_connect_object (_tmp16_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}

static void
math_buttons_on_insert (MathButtons* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	MathEquation* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = g_variant_get_string (param, NULL);
	math_equation_insert (_tmp0_, _tmp1_);
}

static void
math_buttons_on_insert_digit (MathButtons* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_digit (_tmp0_, (guint) g_variant_get_int32 (param));
}

static void
math_buttons_on_subtract (MathButtons* self,
                          GSimpleAction* action,
                          GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}

static void
math_buttons_on_square (MathButtons* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_square (_tmp0_);
}

static void
math_buttons_on_undo (MathButtons* self,
                      GSimpleAction* action,
                      GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	gtk_text_buffer_undo ((GtkTextBuffer*) _tmp0_);
}

static void
math_buttons_on_solve (MathButtons* self,
                       GSimpleAction* action,
                       GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}

static void
math_buttons_on_clear (MathButtons* self,
                       GSimpleAction* action,
                       GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}

static void
math_buttons_on_factorize (MathButtons* self,
                           GSimpleAction* action,
                           GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}

static void
math_buttons_on_insert_exponent (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}

static void
math_buttons_on_bitshift (MathButtons* self,
                          GSimpleAction* action,
                          GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_shift (_tmp0_, (gint) g_variant_get_int32 (param));
}

static void
math_buttons_on_set_word_size (MathButtons* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->word_size_button;
	if (_tmp0_ != NULL) {
		MathEquation* _tmp1_;
		gchar* format = NULL;
		gchar* _tmp2_;
		GtkMenuButton* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->priv->equation;
		math_equation_set_word_size (_tmp1_, (gint) g_variant_get_int32 (param));
		_tmp2_ = g_strdup (ngettext ("%d-bit", "%d-bit", (gulong) g_variant_get_int32 (param)));
		format = _tmp2_;
		_tmp3_ = self->priv->word_size_button;
		_tmp4_ = format;
		_tmp5_ = g_strdup_printf (_tmp4_, g_variant_get_int32 (param));
		_tmp6_ = _tmp5_;
		gtk_menu_button_set_label (_tmp3_, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (format);
	}
}

static void
math_buttons_on_insert_numeric_point (MathButtons* self,
                                      GSimpleAction* action,
                                      GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}

static void
math_buttons_update_bit_panel (MathButtons* self)
{
	GtkWidget* _tmp0_;
	Number* x = NULL;
	MathEquation* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_;
	GtkWidget* _tmp15_;
	GtkLabel* _tmp16_;
	gint i = 0;
	GList* _tmp17_;
	gint number_base = 0;
	MathEquation* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gchar* label = NULL;
	gchar* _tmp27_;
	GtkLabel* _tmp46_;
	const gchar* _tmp47_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	if (enabled) {
		Number* max = NULL;
		Number* _tmp5_;
		Number* fraction = NULL;
		Number* _tmp6_;
		Number* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		Number* _tmp10_;
		_tmp5_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
		max = _tmp5_;
		_tmp6_ = x;
		_tmp7_ = number_fractional_part (_tmp6_);
		fraction = _tmp7_;
		_tmp10_ = x;
		if (number_is_negative (_tmp10_)) {
			_tmp9_ = TRUE;
		} else {
			Number* _tmp11_;
			Number* _tmp12_;
			_tmp11_ = x;
			_tmp12_ = max;
			_tmp9_ = number_compare (_tmp11_, _tmp12_) > 0;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			Number* _tmp13_;
			_tmp13_ = fraction;
			_tmp8_ = !number_is_zero (_tmp13_);
		}
		if (_tmp8_) {
			enabled = FALSE;
		} else {
			Number* _tmp14_;
			_tmp14_ = x;
			bits = number_to_unsigned_integer (_tmp14_);
		}
		_g_object_unref0 (fraction);
		_g_object_unref0 (max);
	}
	_tmp15_ = self->priv->bit_panel;
	gtk_widget_set_sensitive (_tmp15_, enabled);
	_tmp16_ = self->priv->base_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, enabled);
	if (!enabled) {
		_g_object_unref0 (x);
		return;
	}
	i = 0;
	_tmp17_ = self->priv->toggle_bit_buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp17_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp18_;
			GtkButton* button = NULL;
			_tmp18_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp18_;
			{
				gchar* text = NULL;
				gchar* _tmp19_;
				GtkButton* _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_;
				_tmp19_ = g_strdup ("0");
				text = _tmp19_;
				if ((bits & (1ULL << i)) != ((guint64) 0)) {
					gchar* _tmp20_;
					_tmp20_ = g_strdup ("1");
					_g_free0 (text);
					text = _tmp20_;
				}
				_tmp21_ = button;
				_tmp22_ = text;
				gtk_button_set_label (_tmp21_, _tmp22_);
				_tmp23_ = i;
				i = _tmp23_ + 1;
				_g_free0 (text);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp24_ = self->priv->equation;
	_tmp25_ = math_equation_get_number_base (_tmp24_);
	_tmp26_ = _tmp25_;
	number_base = _tmp26_;
	_tmp27_ = g_strdup ("");
	label = _tmp27_;
	if (number_base != 8) {
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp28_ = label;
		_tmp29_ = g_strdup_printf ("%llo₈", bits);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
		_g_free0 (label);
		label = _tmp31_;
		_g_free0 (_tmp30_);
	}
	if (number_base != 10) {
		const gchar* _tmp32_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp32_ = label;
		if (g_strcmp0 (_tmp32_, "") != 0) {
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp33_ = label;
			_tmp34_ = g_strconcat (_tmp33_, " = ", NULL);
			_g_free0 (label);
			label = _tmp34_;
		}
		_tmp35_ = label;
		_tmp36_ = g_strdup_printf ("%llu₁₀", bits);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp35_, _tmp37_, NULL);
		_g_free0 (label);
		label = _tmp38_;
		_g_free0 (_tmp37_);
	}
	if (number_base != 16) {
		const gchar* _tmp39_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp39_ = label;
		if (g_strcmp0 (_tmp39_, "") != 0) {
			const gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp40_ = label;
			_tmp41_ = g_strconcat (_tmp40_, " = ", NULL);
			_g_free0 (label);
			label = _tmp41_;
		}
		_tmp42_ = label;
		_tmp43_ = g_strdup_printf ("%llX₁₆", bits);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp42_, _tmp44_, NULL);
		_g_free0 (label);
		label = _tmp45_;
		_g_free0 (_tmp44_);
	}
	_tmp46_ = self->priv->base_label;
	_tmp47_ = label;
	gtk_label_set_text (_tmp46_, _tmp47_);
	_g_free0 (label);
	_g_object_unref0 (x);
}

static void
math_buttons_base_combobox_changed_cb (MathButtons* self,
                                       GtkComboBox* combo)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = gtk_combo_box_get_active_id (combo);
	_tmp1_ = _tmp0_;
	math_buttons_set_programming_base (self, atoi (_tmp1_));
}

static void
math_buttons_base_changed_cb (MathButtons* self)
{
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	MathEquation* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkComboBox* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = g_strdup_printf ("%i", self->priv->_programming_base);
	_tmp7_ = _tmp6_;
	gtk_combo_box_set_active_id (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	math_buttons_update_bit_panel (self);
}

static void
math_buttons_update_view_more_visible (MathButtons* self)
{
	gboolean visible = FALSE;
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	MathConverter* _tmp17_;
	GtkToggleButton* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			visible = FALSE;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			gboolean _tmp2_ = FALSE;
			GtkWidget* _tmp3_;
			_tmp3_ = self->priv->adv_panel;
			if (_tmp3_ != NULL) {
				GtkWidget* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp4_ = self->priv->adv_panel;
				_tmp5_ = adw_leaflet_get_folded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp4_) : NULL);
				_tmp6_ = _tmp5_;
				_tmp2_ = _tmp6_;
			} else {
				_tmp2_ = FALSE;
			}
			visible = _tmp2_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			gboolean _tmp7_ = FALSE;
			GtkWidget* _tmp8_;
			_tmp8_ = self->priv->fin_panel;
			if (_tmp8_ != NULL) {
				GtkWidget* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = self->priv->fin_panel;
				_tmp10_ = adw_leaflet_get_folded (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp9_) : NULL);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_;
			} else {
				_tmp7_ = FALSE;
			}
			visible = _tmp7_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			gboolean _tmp12_ = FALSE;
			AdwLeaflet* _tmp13_;
			_tmp13_ = self->priv->prog_leaflet;
			if (_tmp13_ != NULL) {
				AdwLeaflet* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = self->priv->prog_leaflet;
				_tmp15_ = adw_leaflet_get_folded (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_;
			} else {
				_tmp12_ = FALSE;
			}
			visible = _tmp12_;
			break;
		}
	}
	_tmp17_ = self->priv->converter;
	math_converter_set_view_more_visible (_tmp17_, visible);
	_tmp18_ = self->priv->prog_view_more_button;
	if (_tmp18_ != NULL) {
		GtkToggleButton* _tmp19_;
		_tmp19_ = self->priv->prog_view_more_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp19_, visible);
	}
}

static gboolean
___lambda13_ (MathButtons* self,
              GBinding* binding,
              GValue* from,
              GValue* to)
{
	const gchar* _tmp0_ = NULL;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (to != NULL, FALSE);
	if (g_value_get_boolean (from)) {
		_tmp0_ = "advanced";
	} else {
		_tmp0_ = "basic";
	}
	g_value_set_string (to, _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
____lambda13__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda13_ ((MathButtons*) self, binding, from_value, to_value);
	return result;
}

static gboolean
___lambda14_ (MathButtons* self,
              GBinding* binding,
              GValue* from,
              GValue* to)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (to != NULL, FALSE);
	_tmp0_ = g_value_get_string (from);
	g_value_set_boolean (to, g_strcmp0 (_tmp0_, "advanced") == 0);
	result = TRUE;
	return result;
}

static gboolean
____lambda14__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda14_ ((MathButtons*) self, binding, from_value, to_value);
	return result;
}

static void
_math_buttons_update_view_more_visible_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	math_buttons_update_view_more_visible ((MathButtons*) self);
}

static gboolean
___lambda15_ (MathButtons* self,
              GBinding* binding,
              GValue* from,
              GValue* to)
{
	const gchar* _tmp0_ = NULL;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (to != NULL, FALSE);
	if (g_value_get_boolean (from)) {
		_tmp0_ = "advanced";
	} else {
		_tmp0_ = "basic";
	}
	g_value_set_string (to, _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
____lambda15__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda15_ ((MathButtons*) self, binding, from_value, to_value);
	return result;
}

static gboolean
___lambda16_ (MathButtons* self,
              GBinding* binding,
              GValue* from,
              GValue* to)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (to != NULL, FALSE);
	_tmp0_ = g_value_get_string (from);
	g_value_set_boolean (to, g_strcmp0 (_tmp0_, "advanced") == 0);
	result = TRUE;
	return result;
}

static gboolean
____lambda16__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda16_ ((MathButtons*) self, binding, from_value, to_value);
	return result;
}

static gboolean
___lambda17_ (MathButtons* self,
              GBinding* binding,
              GValue* from,
              GValue* to)
{
	const gchar* _tmp0_ = NULL;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (to != NULL, FALSE);
	if (g_value_get_boolean (from)) {
		_tmp0_ = "advanced";
	} else {
		_tmp0_ = "basic";
	}
	g_value_set_string (to, _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
____lambda17__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda17_ ((MathButtons*) self, binding, from_value, to_value);
	return result;
}

static gboolean
___lambda18_ (MathButtons* self,
              GBinding* binding,
              GValue* from,
              GValue* to)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (to != NULL, FALSE);
	_tmp0_ = g_value_get_string (from);
	g_value_set_boolean (to, g_strcmp0 (_tmp0_, "advanced") == 0);
	result = TRUE;
	return result;
}

static gboolean
____lambda18__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda18_ ((MathButtons*) self, binding, from_value, to_value);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gint
___lambda24_ (MathButtons* self,
              gconstpointer a,
              gconstpointer b)
{
	gint result;
	result = math_variable_name_compare_func (IS_MATH_VARIABLE (a) ? ((MathVariable*) a) : NULL, IS_MATH_VARIABLE (b) ? ((MathVariable*) b) : NULL);
	return result;
}

static gint
____lambda24__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ___lambda24_ ((MathButtons*) self, a, b);
	return result;
}

static void
_math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender,
                                                                     gint response_id,
                                                                     gpointer self)
{
	math_buttons_character_code_dialog_response_cb ((MathButtons*) self, _sender, response_id);
}

static gboolean
_math_buttons_character_code_dialog_close_request_gtk_window_close_request (GtkWindow* _sender,
                                                                            gpointer self)
{
	gboolean result;
	result = math_buttons_character_code_dialog_close_request ((MathButtons*) self, _sender);
	return result;
}

static void
_math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender,
                                                                    gpointer self)
{
	math_buttons_character_code_dialog_activate_cb ((MathButtons*) self, _sender);
}

static void
_math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	math_buttons_base_combobox_changed_cb ((MathButtons*) self, _sender);
}

static void
___lambda34_ (MathButtons* self,
              GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}

static void
____lambda34__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda34_ ((MathButtons*) self, pspec);
}

static GtkWidget*
math_buttons_load_mode (MathButtons* self,
                        ButtonMode mode)
{
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	GtkBuilder* _tmp28_;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_;
	GtkWidget* _tmp36_;
	GtkWidget* _tmp37_;
	GtkButton* button = NULL;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_;
	GtkButton* _tmp63_;
	GtkButton* _tmp64_;
	GtkMenuButton* menu_button = NULL;
	GtkBuilder* _tmp71_;
	GObject* _tmp72_;
	GtkMenuButton* _tmp73_;
	GtkMenuButton* _tmp74_;
	GtkBuilder* _tmp78_;
	GObject* _tmp79_;
	GtkMenuButton* _tmp80_;
	GtkMenuButton* _tmp81_;
	GtkBuilder* _tmp85_;
	GObject* _tmp86_;
	GtkMenuButton* _tmp87_;
	GtkMenuButton* _tmp88_;
	GtkBuilder* _tmp92_;
	GObject* _tmp93_;
	GtkMenuButton* _tmp94_;
	GtkMenuButton* _tmp95_;
	GtkBuilder* _tmp105_;
	GObject* _tmp106_;
	GtkMenuButton* _tmp107_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp108_;
	GtkMenuButton* _tmp109_;
	GError* _inner_error0_ = NULL;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp0_;
			GtkBuilder* _tmp3_;
			GtkBuilder* _tmp4_;
			GtkBuilder* _tmp5_;
			gchar* _tmp6_;
			_tmp0_ = self->priv->bas_panel;
			if (_tmp0_ != NULL) {
				GtkWidget* _tmp1_;
				GtkWidget* _tmp2_;
				_tmp1_ = self->priv->bas_panel;
				_tmp2_ = _g_object_ref0 (_tmp1_);
				result = _tmp2_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp3_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp3_;
			_tmp4_ = self->priv->basic_ui;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (builder);
			builder = _tmp5_;
			_tmp6_ = g_strdup ("buttons-basic.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp6_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp7_;
			GtkBuilder* _tmp10_;
			GtkBuilder* _tmp11_;
			GtkBuilder* _tmp12_;
			gchar* _tmp13_;
			_tmp7_ = self->priv->adv_panel;
			if (_tmp7_ != NULL) {
				GtkWidget* _tmp8_;
				GtkWidget* _tmp9_;
				_tmp8_ = self->priv->adv_panel;
				_tmp9_ = _g_object_ref0 (_tmp8_);
				result = _tmp9_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp10_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp10_;
			_tmp11_ = self->priv->advanced_ui;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (builder);
			builder = _tmp12_;
			_tmp13_ = g_strdup ("buttons-advanced.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp13_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp14_;
			GtkBuilder* _tmp17_;
			GtkBuilder* _tmp18_;
			GtkBuilder* _tmp19_;
			gchar* _tmp20_;
			_tmp14_ = self->priv->fin_panel;
			if (_tmp14_ != NULL) {
				GtkWidget* _tmp15_;
				GtkWidget* _tmp16_;
				_tmp15_ = self->priv->fin_panel;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				result = _tmp16_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp17_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp17_;
			_tmp18_ = self->priv->financial_ui;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (builder);
			builder = _tmp19_;
			_tmp20_ = g_strdup ("buttons-financial.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp20_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp21_;
			GtkBuilder* _tmp24_;
			GtkBuilder* _tmp25_;
			GtkBuilder* _tmp26_;
			gchar* _tmp27_;
			_tmp21_ = self->priv->prog_panel;
			if (_tmp21_ != NULL) {
				GtkWidget* _tmp22_;
				GtkWidget* _tmp23_;
				_tmp22_ = self->priv->prog_panel;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				result = _tmp23_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp24_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp24_;
			_tmp25_ = self->priv->programming_ui;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_g_object_unref0 (builder);
			builder = _tmp26_;
			_tmp27_ = g_strdup ("buttons-programming.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp27_;
			break;
		}
	}
	_tmp28_ = builder;
	gtk_builder_set_current_object (_tmp28_, (GObject*) self);
	{
		GtkBuilder* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = builder;
		_tmp30_ = builder_resource;
		_tmp31_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp30_);
		_tmp32_ = _tmp31_;
		gtk_builder_add_from_resource (_tmp29_, _tmp32_, &_inner_error0_);
		_g_free0 (_tmp32_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = e->message;
		g_error ("math-buttons.vala:376: Error loading button UI: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (builder_resource);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "button_panel");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp35_) : NULL);
	panel = _tmp36_;
	_tmp37_ = panel;
	gtk_box_append ((GtkBox*) self, _tmp37_);
	switch (mode) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp38_;
			GtkWidget* _tmp39_;
			_tmp38_ = panel;
			_tmp39_ = _g_object_ref0 (_tmp38_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp39_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp40_;
			GtkWidget* _tmp41_;
			MathConverter* _tmp42_;
			GtkWidget* _tmp43_;
			GtkWidget* _tmp44_;
			_tmp40_ = panel;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp41_;
			_tmp42_ = self->priv->converter;
			_tmp43_ = panel;
			g_object_bind_property_with_closures ((GObject*) _tmp42_, "view-more-active", (GObject*) _tmp43_, "visible-child-name", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((____lambda13__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda13__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((____lambda14__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda14__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
			_tmp44_ = self->priv->adv_panel;
			g_signal_connect_object ((GObject*) _tmp44_, "notify::folded", (GCallback) _math_buttons_update_view_more_visible_g_object_notify, self, 0);
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp45_;
			GtkWidget* _tmp46_;
			MathConverter* _tmp47_;
			GtkWidget* _tmp48_;
			GtkWidget* _tmp49_;
			_tmp45_ = panel;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp46_;
			_tmp47_ = self->priv->converter;
			_tmp48_ = panel;
			g_object_bind_property_with_closures ((GObject*) _tmp47_, "view-more-active", (GObject*) _tmp48_, "visible-child-name", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((____lambda15__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda15__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((____lambda16__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda16__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
			_tmp49_ = self->priv->fin_panel;
			g_signal_connect_object ((GObject*) _tmp49_, "notify::folded", (GCallback) _math_buttons_update_view_more_visible_g_object_notify, self, 0);
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp50_;
			GtkWidget* _tmp51_;
			GtkBuilder* _tmp52_;
			GObject* _tmp53_;
			AdwLeaflet* _tmp54_;
			GtkBuilder* _tmp55_;
			GObject* _tmp56_;
			GtkToggleButton* _tmp57_;
			GtkToggleButton* _tmp58_;
			AdwLeaflet* _tmp59_;
			AdwLeaflet* _tmp60_;
			_tmp50_ = panel;
			_tmp51_ = _g_object_ref0 (_tmp50_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp51_;
			_tmp52_ = builder;
			_tmp53_ = gtk_builder_get_object (_tmp52_, "leaflet");
			_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp53_) : NULL);
			_g_object_unref0 (self->priv->prog_leaflet);
			self->priv->prog_leaflet = _tmp54_;
			_tmp55_ = builder;
			_tmp56_ = gtk_builder_get_object (_tmp55_, "view_more_button");
			_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp56_) : NULL);
			_g_object_unref0 (self->priv->prog_view_more_button);
			self->priv->prog_view_more_button = _tmp57_;
			_tmp58_ = self->priv->prog_view_more_button;
			_tmp59_ = self->priv->prog_leaflet;
			g_object_bind_property_with_closures ((GObject*) _tmp58_, "active", (GObject*) _tmp59_, "visible-child-name", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((____lambda17__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda17__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((____lambda18__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ____lambda18__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
			_tmp60_ = self->priv->prog_leaflet;
			g_signal_connect_object ((GObject*) _tmp60_, "notify::folded", (GCallback) _math_buttons_update_view_more_visible_g_object_notify, self, 0);
			break;
		}
	}
	_tmp61_ = builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "calc_numeric_point_button");
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, gtk_button_get_type ()) ? ((GtkButton*) _tmp62_) : NULL);
	button = _tmp63_;
	_tmp64_ = button;
	if (_tmp64_ != NULL) {
		GtkButton* _tmp65_;
		MathEquation* _tmp66_;
		Serializer* _tmp67_;
		Serializer* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp65_ = button;
		_tmp66_ = self->priv->equation;
		_tmp67_ = math_equation_get_serializer (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_unichar_to_string (serializer_get_radix (_tmp68_));
		_tmp70_ = _tmp69_;
		gtk_button_set_label (_tmp65_, _tmp70_);
		_g_free0 (_tmp70_);
	}
	_tmp71_ = builder;
	_tmp72_ = gtk_builder_get_object (_tmp71_, "calc_shift_left_button");
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp72_) : NULL);
	menu_button = _tmp73_;
	_tmp74_ = menu_button;
	if (_tmp74_ != NULL) {
		GtkMenuButton* _tmp75_;
		GMenu* _tmp76_;
		GMenu* _tmp77_;
		_tmp75_ = menu_button;
		_tmp76_ = math_buttons_create_shift_menu (self, TRUE);
		_tmp77_ = _tmp76_;
		gtk_menu_button_set_menu_model (_tmp75_, (GMenuModel*) _tmp77_);
		_g_object_unref0 (_tmp77_);
	}
	_tmp78_ = builder;
	_tmp79_ = gtk_builder_get_object (_tmp78_, "calc_shift_right_button");
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp79_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp80_;
	_tmp81_ = menu_button;
	if (_tmp81_ != NULL) {
		GtkMenuButton* _tmp82_;
		GMenu* _tmp83_;
		GMenu* _tmp84_;
		_tmp82_ = menu_button;
		_tmp83_ = math_buttons_create_shift_menu (self, FALSE);
		_tmp84_ = _tmp83_;
		gtk_menu_button_set_menu_model (_tmp82_, (GMenuModel*) _tmp84_);
		_g_object_unref0 (_tmp84_);
	}
	_tmp85_ = builder;
	_tmp86_ = gtk_builder_get_object (_tmp85_, "calc_word_size_button");
	_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp86_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp87_;
	_tmp88_ = menu_button;
	if (_tmp88_ != NULL) {
		GtkMenuButton* _tmp89_;
		GMenu* _tmp90_;
		GMenu* _tmp91_;
		_tmp89_ = menu_button;
		_tmp90_ = math_buttons_create_word_size_menu (self);
		_tmp91_ = _tmp90_;
		gtk_menu_button_set_menu_model (_tmp89_, (GMenuModel*) _tmp91_);
		_g_object_unref0 (_tmp91_);
	}
	_tmp92_ = builder;
	_tmp93_ = gtk_builder_get_object (_tmp92_, "calc_memory_button");
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp93_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp94_;
	_tmp95_ = menu_button;
	if (_tmp95_ != NULL) {
		GListStore* model = NULL;
		GListStore* _tmp96_;
		MathVariablePopover* math_popover = NULL;
		MathEquation* _tmp97_;
		GListStore* _tmp98_;
		MathVariablePopover* _tmp99_;
		GListStore* _tmp100_;
		MathVariablePopover* _tmp101_;
		MathEquation* _tmp102_;
		GtkMenuButton* _tmp103_;
		MathVariablePopover* _tmp104_;
		_tmp96_ = g_list_store_new (TYPE_MATH_VARIABLE);
		model = _tmp96_;
		_tmp97_ = self->priv->equation;
		_tmp98_ = model;
		_tmp99_ = math_variable_popover_new (_tmp97_, _tmp98_, ____lambda24__gcompare_data_func, self);
		g_object_ref_sink (_tmp99_);
		math_popover = _tmp99_;
		_tmp100_ = model;
		_tmp101_ = math_popover;
		_tmp102_ = self->priv->equation;
		math_buttons_fill_variables_model (self, _tmp100_, (MathPopover*) _tmp101_, _tmp102_);
		_tmp103_ = menu_button;
		_tmp104_ = math_popover;
		gtk_menu_button_set_popover (_tmp103_, (GtkPopover*) _tmp104_);
		_g_object_unref0 (math_popover);
		_g_object_unref0 (model);
	}
	_tmp105_ = builder;
	_tmp106_ = gtk_builder_get_object (_tmp105_, "calc_function_button");
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp106_) : NULL);
	_g_object_unref0 (menu_button);
	menu_button = _tmp107_;
	_tmp108_ = function_manager_get_default_function_manager ();
	function_manager = _tmp108_;
	_tmp109_ = menu_button;
	if (_tmp109_ != NULL) {
		GListStore* model = NULL;
		GListStore* _tmp110_;
		MathFunctionPopover* math_popover = NULL;
		MathEquation* _tmp111_;
		GListStore* _tmp112_;
		MathFunctionPopover* _tmp113_;
		GListStore* _tmp114_;
		MathFunctionPopover* _tmp115_;
		FunctionManager* _tmp116_;
		GtkMenuButton* _tmp117_;
		MathFunctionPopover* _tmp118_;
		_tmp110_ = g_list_store_new (TYPE_MATH_FUNCTION);
		model = _tmp110_;
		_tmp111_ = self->priv->equation;
		_tmp112_ = model;
		_tmp113_ = math_function_popover_new (_tmp111_, _tmp112_);
		g_object_ref_sink (_tmp113_);
		math_popover = _tmp113_;
		_tmp114_ = model;
		_tmp115_ = math_popover;
		_tmp116_ = function_manager;
		math_buttons_fill_functions_model (self, _tmp114_, (MathPopover*) _tmp115_, _tmp116_);
		_tmp117_ = menu_button;
		_tmp118_ = math_popover;
		gtk_menu_button_set_popover (_tmp117_, (GtkPopover*) _tmp118_);
		_g_object_unref0 (math_popover);
		_g_object_unref0 (model);
	}
	if (mode == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp119_;
		GObject* _tmp120_;
		GtkLabel* _tmp121_;
		GtkBuilder* _tmp122_;
		GObject* _tmp123_;
		GtkDialog* _tmp124_;
		GtkDialog* _tmp125_;
		GtkDialog* _tmp126_;
		GtkBuilder* _tmp127_;
		GObject* _tmp128_;
		GtkEntry* _tmp129_;
		GtkEntry* _tmp130_;
		GtkBuilder* _tmp131_;
		GObject* _tmp132_;
		GtkWidget* _tmp133_;
		GtkWidget* _tmp134_;
		gint i = 0;
		GtkBuilder* _tmp144_;
		GObject* _tmp145_;
		GtkMenuButton* _tmp146_;
		GtkBuilder* _tmp147_;
		GObject* _tmp148_;
		GtkComboBox* _tmp149_;
		GtkComboBox* _tmp150_;
		MathEquation* _tmp151_;
		_tmp119_ = builder;
		_tmp120_ = gtk_builder_get_object (_tmp119_, "base_label");
		_tmp121_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp120_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp120_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp121_;
		_tmp122_ = builder;
		_tmp123_ = gtk_builder_get_object (_tmp122_, "character_code_dialog");
		_tmp124_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp123_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp124_;
		_tmp125_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp125_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp126_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWindow*) _tmp126_, "close-request", (GCallback) _math_buttons_character_code_dialog_close_request_gtk_window_close_request, self, 0);
		_tmp127_ = builder;
		_tmp128_ = gtk_builder_get_object (_tmp127_, "character_code_entry");
		_tmp129_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp128_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp129_;
		_tmp130_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp130_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp131_ = builder;
		_tmp132_ = gtk_builder_get_object (_tmp131_, "bit_table");
		_tmp133_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp132_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp133_;
		_tmp134_ = self->priv->bit_panel;
		gtk_widget_set_direction (_tmp134_, GTK_TEXT_DIR_LTR);
		(self->priv->toggle_bit_buttons == NULL) ? NULL : (self->priv->toggle_bit_buttons = (_g_list_free__g_object_unref0_ (self->priv->toggle_bit_buttons), NULL));
		self->priv->toggle_bit_buttons = NULL;
		i = 0;
		while (TRUE) {
			gchar* name = NULL;
			gchar* _tmp135_;
			GtkButton* toggle_bit_button = NULL;
			GtkBuilder* _tmp136_;
			const gchar* _tmp137_;
			GObject* _tmp138_;
			GtkButton* _tmp139_;
			GtkButton* _tmp140_;
			GtkButton* _tmp141_;
			GtkButton* _tmp142_;
			gint _tmp143_;
			_tmp135_ = g_strdup_printf ("toggle_bit_%d_button", i);
			name = _tmp135_;
			_tmp136_ = builder;
			_tmp137_ = name;
			_tmp138_ = gtk_builder_get_object (_tmp136_, _tmp137_);
			_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, gtk_button_get_type ()) ? ((GtkButton*) _tmp138_) : NULL);
			toggle_bit_button = _tmp139_;
			_tmp140_ = toggle_bit_button;
			if (_tmp140_ == NULL) {
				_g_object_unref0 (toggle_bit_button);
				_g_free0 (name);
				break;
			}
			_tmp141_ = toggle_bit_button;
			_tmp142_ = _g_object_ref0 (_tmp141_);
			self->priv->toggle_bit_buttons = g_list_append (self->priv->toggle_bit_buttons, _tmp142_);
			_tmp143_ = i;
			i = _tmp143_ + 1;
			_g_object_unref0 (toggle_bit_button);
			_g_free0 (name);
		}
		self->priv->toggle_bit_buttons = g_list_reverse (self->priv->toggle_bit_buttons);
		_tmp144_ = builder;
		_tmp145_ = gtk_builder_get_object (_tmp144_, "calc_word_size_button");
		_tmp146_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp145_, gtk_menu_button_get_type ()) ? ((GtkMenuButton*) _tmp145_) : NULL);
		_g_object_unref0 (self->priv->word_size_button);
		self->priv->word_size_button = _tmp146_;
		_tmp147_ = builder;
		_tmp148_ = gtk_builder_get_object (_tmp147_, "base_combo");
		_tmp149_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp148_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp149_;
		_tmp150_ = self->priv->base_combo;
		g_signal_connect_object (_tmp150_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp151_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp151_, "notify::number-base", (GCallback) ____lambda34__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
		math_buttons_word_size_changed_cb (self);
	}
	if (mode == BUTTON_MODE_FINANCIAL) {
		math_buttons_load_finc_dialogs (self);
	}
	math_buttons_update_bit_panel (self);
	math_buttons_update_view_more_visible (self);
	result = panel;
	_g_object_unref0 (function_manager);
	_g_object_unref0 (menu_button);
	_g_object_unref0 (button);
	_g_free0 (builder_resource);
	_g_object_unref0 (builder);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MathButtons* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->math_popover);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda31_ (Block1Data* _data1_,
             MathFunction* f)
{
	MathButtons* self;
	self = _data1_->self;
	g_return_if_fail (f != NULL);
	math_popover_item_added_cb (_data1_->math_popover, G_TYPE_CHECK_INSTANCE_TYPE (f, TYPE_MATH_FUNCTION) ? ((MathFunction*) f) : NULL);
}

static void
___lambda31__function_manager_function_added (FunctionManager* _sender,
                                              MathFunction* function,
                                              gpointer self)
{
	__lambda31_ (self, function);
}

static void
__lambda32_ (Block1Data* _data1_,
             MathFunction* f)
{
	MathButtons* self;
	self = _data1_->self;
	g_return_if_fail (f != NULL);
	math_popover_item_edited_cb (_data1_->math_popover, G_TYPE_CHECK_INSTANCE_TYPE (f, TYPE_MATH_FUNCTION) ? ((MathFunction*) f) : NULL);
}

static void
___lambda32__function_manager_function_edited (FunctionManager* _sender,
                                               MathFunction* new_function,
                                               gpointer self)
{
	__lambda32_ (self, new_function);
}

static void
__lambda33_ (Block1Data* _data1_,
             MathFunction* f)
{
	MathButtons* self;
	self = _data1_->self;
	g_return_if_fail (f != NULL);
	math_popover_item_deleted_cb (_data1_->math_popover, G_TYPE_CHECK_INSTANCE_TYPE (f, TYPE_MATH_FUNCTION) ? ((MathFunction*) f) : NULL);
}

static void
___lambda33__function_manager_function_deleted (FunctionManager* _sender,
                                                MathFunction* function,
                                                gpointer self)
{
	__lambda33_ (self, function);
}

static void
math_buttons_fill_functions_model (MathButtons* self,
                                   GListStore* model,
                                   MathPopover* math_popover,
                                   FunctionManager* function_manager)
{
	Block1Data* _data1_;
	MathPopover* _tmp0_;
	gchar** names = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint names_length1;
	gint _names_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (math_popover != NULL);
	g_return_if_fail (function_manager != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (math_popover);
	_g_object_unref0 (_data1_->math_popover);
	_data1_->math_popover = _tmp0_;
	_tmp2_ = function_manager_get_names (function_manager, &_tmp1_);
	names = _tmp2_;
	names_length1 = _tmp1_;
	_names_size_ = names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				MathFunction* function = NULL;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				MathFunction* _tmp9_;
				MathFunction* _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = names;
				_tmp5__length1 = names_length1;
				_tmp6_ = _tmp5_[i];
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = names;
				_tmp7__length1 = names_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = function_manager_get (function_manager, _tmp8_);
				function = _tmp9_;
				_tmp10_ = function;
				math_popover_item_added_cb (_data1_->math_popover, _tmp10_);
				_g_object_unref0 (function);
			}
		}
	}
	g_signal_connect_data (function_manager, "function-added", (GCallback) ___lambda31__function_manager_function_added, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data (function_manager, "function-edited", (GCallback) ___lambda32__function_manager_function_edited, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data (function_manager, "function-deleted", (GCallback) ___lambda33__function_manager_function_deleted, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MathButtons* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->math_popover);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda25_ (Block2Data* _data2_,
             const gchar* name,
             Number* value)
{
	MathButtons* self;
	MathVariable* _tmp0_;
	MathVariable* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = math_variable_new (name, value);
	_tmp1_ = _tmp0_;
	math_popover_item_added_cb (_data2_->math_popover, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda25__math_variables_variable_added (MathVariables* _sender,
                                            const gchar* name,
                                            Number* value,
                                            gpointer self)
{
	__lambda25_ (self, name, value);
}

static void
__lambda26_ (Block2Data* _data2_,
             const gchar* name,
             Number* value)
{
	MathButtons* self;
	MathVariable* _tmp0_;
	MathVariable* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = math_variable_new (name, value);
	_tmp1_ = _tmp0_;
	math_popover_item_edited_cb (_data2_->math_popover, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda26__math_variables_variable_edited (MathVariables* _sender,
                                             const gchar* name,
                                             Number* new_value,
                                             gpointer self)
{
	__lambda26_ (self, name, new_value);
}

static void
__lambda27_ (Block2Data* _data2_,
             const gchar* name)
{
	MathButtons* self;
	MathVariable* _tmp0_;
	MathVariable* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (name != NULL);
	_tmp0_ = math_variable_new (name, NULL);
	_tmp1_ = _tmp0_;
	math_popover_item_deleted_cb (_data2_->math_popover, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda27__math_variables_variable_deleted (MathVariables* _sender,
                                              const gchar* name,
                                              gpointer self)
{
	__lambda27_ (self, name);
}

static void
math_buttons_fill_variables_model (MathButtons* self,
                                   GListStore* model,
                                   MathPopover* math_popover,
                                   MathEquation* equation)
{
	Block2Data* _data2_;
	MathPopover* _tmp0_;
	gchar** names = NULL;
	MathVariables* _tmp1_;
	MathVariables* _tmp2_;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint names_length1;
	gint _names_size_;
	MathVariable* _tmp19_;
	MathVariable* _tmp20_;
	MathVariables* _tmp21_;
	MathVariables* _tmp22_;
	MathVariables* _tmp23_;
	MathVariables* _tmp24_;
	MathVariables* _tmp25_;
	MathVariables* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (math_popover != NULL);
	g_return_if_fail (equation != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (math_popover);
	_g_object_unref0 (_data2_->math_popover);
	_data2_->math_popover = _tmp0_;
	_tmp1_ = math_equation_get_variables (equation);
	_tmp2_ = _tmp1_;
	_tmp4_ = math_variables_get_names (_tmp2_, &_tmp3_);
	names = _tmp4_;
	names_length1 = _tmp3_;
	_names_size_ = names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				Number* value = NULL;
				MathVariables* _tmp9_;
				MathVariables* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				Number* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				Number* _tmp16_;
				MathVariable* _tmp17_;
				MathVariable* _tmp18_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = names;
				_tmp7__length1 = names_length1;
				_tmp8_ = _tmp7_[i];
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = math_equation_get_variables (equation);
				_tmp10_ = _tmp9_;
				_tmp11_ = names;
				_tmp11__length1 = names_length1;
				_tmp12_ = _tmp11_[i];
				_tmp13_ = math_variables_get (_tmp10_, _tmp12_);
				value = _tmp13_;
				_tmp14_ = names;
				_tmp14__length1 = names_length1;
				_tmp15_ = _tmp14_[i];
				_tmp16_ = value;
				_tmp17_ = math_variable_new (_tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				math_popover_item_added_cb (_data2_->math_popover, _tmp18_);
				_g_object_unref0 (_tmp18_);
				_g_object_unref0 (value);
			}
		}
	}
	_tmp19_ = math_variable_new ("rand", NULL);
	_tmp20_ = _tmp19_;
	math_popover_item_added_cb (_data2_->math_popover, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = math_equation_get_variables (equation);
	_tmp22_ = _tmp21_;
	g_signal_connect_data (_tmp22_, "variable-added", (GCallback) ___lambda25__math_variables_variable_added, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp23_ = math_equation_get_variables (equation);
	_tmp24_ = _tmp23_;
	g_signal_connect_data (_tmp24_, "variable-edited", (GCallback) ___lambda26__math_variables_variable_edited, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp25_ = math_equation_get_variables (equation);
	_tmp26_ = _tmp25_;
	g_signal_connect_data (_tmp26_, "variable-deleted", (GCallback) ___lambda27__math_variables_variable_deleted, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
math_buttons_converter_changed_cb (MathButtons* self)
{
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_;
	ButtonMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_;
		Unit* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		MathEquation* _tmp10_;
		Unit* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_;
		Unit* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		MathEquation* _tmp20_;
		Unit* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}

static void
_math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender,
                                                           gpointer self)
{
	math_buttons_converter_changed_cb ((MathButtons*) self);
}

static void
___lambda12_ (MathButtons* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp6_;
	_tmp0_ = self->priv->adv_panel;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		MathConverter* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		GtkWidget* _tmp5_;
		_tmp2_ = self->priv->converter;
		_tmp3_ = math_converter_get_view_more_active (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			_tmp1_ = "advanced";
		} else {
			_tmp1_ = "basic";
		}
		_tmp5_ = self->priv->adv_panel;
		adw_leaflet_set_visible_child_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp5_) : NULL, _tmp1_);
	}
	_tmp6_ = self->priv->fin_panel;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_ = NULL;
		MathConverter* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		GtkWidget* _tmp11_;
		_tmp8_ = self->priv->converter;
		_tmp9_ = math_converter_get_view_more_active (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			_tmp7_ = "advanced";
		} else {
			_tmp7_ = "basic";
		}
		_tmp11_ = self->priv->fin_panel;
		adw_leaflet_set_visible_child_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp11_) : NULL, _tmp7_);
	}
}

static void
____lambda12__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda12_ ((MathButtons*) self);
}

static void
math_buttons_load_buttons (MathButtons* self)
{
	MathConverter* _tmp0_;
	GtkWidget* panel = NULL;
	ButtonMode _tmp6_;
	ButtonMode _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
		return;
	}
	_tmp0_ = self->priv->converter;
	if (_tmp0_ == NULL) {
		MathEquation* _tmp1_;
		MathConverter* _tmp2_;
		MathConverter* _tmp3_;
		MathConverter* _tmp4_;
		MathConverter* _tmp5_;
		_tmp1_ = self->priv->equation;
		_tmp2_ = math_converter_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp2_;
		_tmp3_ = self->priv->converter;
		g_signal_connect_object (_tmp3_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp4_ = self->priv->converter;
		gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->converter;
		g_signal_connect_object ((GObject*) _tmp5_, "notify::view-more-active", (GCallback) ____lambda12__g_object_notify, self, 0);
	}
	_tmp6_ = math_buttons_get_mode (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
	panel = _tmp8_;
	_tmp9_ = self->priv->active_panel;
	_tmp10_ = panel;
	if (_tmp9_ == _tmp10_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp11_ = self->priv->active_panel;
	if (_tmp11_ != NULL) {
		GtkWidget* _tmp12_;
		_tmp12_ = self->priv->active_panel;
		gtk_widget_hide (_tmp12_);
	}
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp14_;
	_tmp15_ = panel;
	if (_tmp15_ != NULL) {
		GtkWidget* _tmp16_;
		_tmp16_ = panel;
		gtk_widget_show (_tmp16_);
	}
	_g_object_unref0 (panel);
}

static GMenu*
math_buttons_create_shift_menu (MathButtons* self,
                                gboolean shift_left)
{
	GMenu* shift_menu = NULL;
	GMenu* _tmp0_;
	GMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	shift_menu = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* format = NULL;
				gchar* _tmp3_;
				gint _tmp6_ = 0;
				gint positions = 0;
				GMenu* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 16)) {
					break;
				}
				_tmp3_ = g_strdup (ngettext ("%d place", "%d places", (gulong) i));
				format = _tmp3_;
				if (i < 10) {
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = format;
					_tmp5_ = g_strconcat ("_", _tmp4_, NULL);
					_g_free0 (format);
					format = _tmp5_;
				}
				if (shift_left) {
					_tmp6_ = i;
				} else {
					_tmp6_ = -i;
				}
				positions = _tmp6_;
				_tmp7_ = shift_menu;
				_tmp8_ = format;
				_tmp9_ = g_strdup_printf (_tmp8_, i);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("cal.bitshift(%d)", positions);
				_tmp12_ = _tmp11_;
				g_menu_append (_tmp7_, _tmp10_, _tmp12_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_free0 (format);
			}
		}
	}
	result = shift_menu;
	return result;
}

static GMenu*
math_buttons_create_word_size_menu (MathButtons* self)
{
	GMenu* word_size_menu = NULL;
	GMenu* _tmp0_;
	gint i = 0;
	gchar* format = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_menu_new ();
	word_size_menu = _tmp0_;
	i = 64;
	_tmp1_ = g_strdup (ngettext ("%d-bit", "%d-bit", (gulong) i));
	format = _tmp1_;
	_tmp2_ = g_strdup_printf (format, i);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("cal.set-word-size(%d)", i);
	_tmp5_ = _tmp4_;
	g_menu_append (word_size_menu, _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	i = 32;
	_tmp6_ = g_strdup_printf (format, i);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("cal.set-word-size(%d)", i);
	_tmp9_ = _tmp8_;
	g_menu_append (word_size_menu, _tmp7_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	i = 16;
	_tmp10_ = g_strdup_printf (format, i);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("cal.set-word-size(%d)", i);
	_tmp13_ = _tmp12_;
	g_menu_append (word_size_menu, _tmp11_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	i = 8;
	_tmp14_ = g_strdup_printf (format, i);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("cal.set-word-size(%d)", i);
	_tmp17_ = _tmp16_;
	g_menu_append (word_size_menu, _tmp15_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = word_size_menu;
	_g_free0 (format);
	return result;
}

static void
math_buttons_word_size_changed_cb (MathButtons* self)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->word_size_button;
	if (_tmp0_ != NULL) {
		gint size = 0;
		MathEquation* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* format = NULL;
		gchar* _tmp4_;
		GtkMenuButton* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->equation;
		_tmp2_ = math_equation_get_word_size (_tmp1_);
		_tmp3_ = _tmp2_;
		size = _tmp3_;
		_tmp4_ = g_strdup (ngettext ("%d-bit", "%d-bit", (gulong) size));
		format = _tmp4_;
		_tmp5_ = self->priv->word_size_button;
		_tmp6_ = format;
		_tmp7_ = g_strdup_printf (_tmp6_, size);
		_tmp8_ = _tmp7_;
		gtk_menu_button_set_label (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (format);
	}
	math_buttons_update_bit_button_sensitivities (self);
}

static void
math_buttons_update_bit_button_sensitivities (MathButtons* self)
{
	gint i = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	i = 0;
	_tmp0_ = self->priv->toggle_bit_buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp0_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			GtkButton* _tmp1_;
			GtkButton* button = NULL;
			_tmp1_ = _g_object_ref0 ((GtkButton*) button_it->data);
			button = _tmp1_;
			{
				MathEquation* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp11_;
				_tmp2_ = self->priv->equation;
				_tmp3_ = math_equation_get_word_size (_tmp2_);
				_tmp4_ = _tmp3_;
				if (i < _tmp4_) {
					GtkButton* _tmp5_;
					_tmp5_ = button;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
				} else {
					GtkButton* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					GtkButton* _tmp10_;
					_tmp6_ = button;
					_tmp7_ = gtk_button_get_label (_tmp6_);
					_tmp8_ = _tmp7_;
					if (g_strcmp0 (_tmp8_, "1") == 0) {
						MathEquation* _tmp9_;
						_tmp9_ = self->priv->equation;
						math_equation_toggle_bit (_tmp9_, (guint) (63 - i));
					}
					_tmp10_ = button;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
				}
				_tmp11_ = i;
				i = _tmp11_ + 1;
				_g_object_unref0 (button);
			}
		}
	}
}

static void
math_buttons_on_launch_finc_dialog (MathButtons* self,
                                    GSimpleAction* action,
                                    GVariant* param)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_;
	GtkDialog* _tmp4_;
	MathWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->financial_ui;
	_tmp3_ = gtk_builder_get_object (_tmp2_, name);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL);
	dialog = _tmp4_;
	_tmp5_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp5_) : NULL);
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}

static void
math_buttons_on_insert_character (MathButtons* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
math_buttons_finc_activate_cb (MathButtons* self,
                               GtkWidget* widget)
{
	GtkEntry* next_entry = NULL;
	gconstpointer _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_object_get_data ((GObject*) widget, "next-entry");
	_tmp1_ = _g_object_ref0 ((GtkEntry*) _tmp0_);
	next_entry = _tmp1_;
	_tmp2_ = next_entry;
	if (_tmp2_ == NULL) {
		GtkDialog* dialog = NULL;
		GtkRoot* _tmp3_;
		GtkDialog* _tmp4_;
		GtkDialog* _tmp5_;
		_tmp3_ = gtk_widget_get_root (widget);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL);
		dialog = _tmp4_;
		_tmp5_ = dialog;
		if (_tmp5_ != NULL) {
			GtkDialog* _tmp6_;
			_tmp6_ = dialog;
			gtk_dialog_response (_tmp6_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp7_;
		_tmp7_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	}
	_g_object_unref0 (next_entry);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup10 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
math_buttons_finc_response_cb (MathButtons* self,
                               GtkWidget* widget,
                               gint response_id)
{
	FinancialDialog function = 0;
	gconstpointer _tmp0_;
	gchar** entries = NULL;
	gchar** _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	Number* arg[4] = {0};
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	GObject* _tmp32_;
	GtkEntry* _tmp33_;
	GtkEntry* _tmp34_;
	MathEquation* _tmp35_;
	Number* _tmp36_;
	Number* _tmp37_;
	Number* _tmp38_;
	Number* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_widget_hide ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_window_get_type ()) ? ((GtkWindow*) widget) : NULL));
	if (response_id != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp0_ = g_object_get_data ((GObject*) widget, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp0_));
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp1_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	switch (function) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp2_;
			gint _tmp2__length1;
			_tmp2_ = _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries));
			_tmp2__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp2_;
			entries_length1 = _tmp2__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp3_;
			gint _tmp3__length1;
			_tmp3_ = _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries));
			_tmp3__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp3_;
			entries_length1 = _tmp3__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp4_;
			gint _tmp4__length1;
			_tmp4_ = _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries));
			_tmp4__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp4_;
			entries_length1 = _tmp4__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp5_;
			gint _tmp5__length1;
			_tmp5_ = _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries));
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries));
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp7_;
			gint _tmp7__length1;
			_tmp7_ = _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries));
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp8_ = _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries));
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp9_;
			gint _tmp9__length1;
			_tmp9_ = _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries));
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp10_ = _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries));
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries));
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp12_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp13_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp14_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp15_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp16_[0] = _tmp12_;
	_tmp16_[1] = _tmp13_;
	_tmp16_[2] = _tmp14_;
	_tmp16_[3] = _tmp15_;
	memcpy (arg, _tmp16_, 4 * sizeof (Number*));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gchar** _tmp19_;
				gint _tmp19__length1;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				GObject* _tmp23_;
				GtkEntry* _tmp24_;
				GtkEntry* _tmp25_;
				const gchar* _tmp26_;
				Number* _tmp27_;
				GtkEntry* _tmp28_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = entries;
				_tmp19__length1 = entries_length1;
				if (!(i < _tmp19__length1)) {
					break;
				}
				_tmp20_ = self->priv->financial_ui;
				_tmp21_ = entries;
				_tmp21__length1 = entries_length1;
				_tmp22_ = _tmp21_[i];
				_tmp23_ = gtk_builder_get_object (_tmp20_, _tmp22_);
				_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp23_) : NULL);
				entry = _tmp24_;
				_tmp25_ = entry;
				_tmp26_ = gtk_editable_get_text ((GtkEditable*) _tmp25_);
				_tmp27_ = mp_set_from_string (_tmp26_, 10);
				_g_object_unref0 (arg[i]);
				arg[i] = _tmp27_;
				_tmp28_ = entry;
				gtk_editable_set_text ((GtkEditable*) _tmp28_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp29_ = self->priv->financial_ui;
	_tmp30_ = entries;
	_tmp30__length1 = entries_length1;
	_tmp31_ = _tmp30_[0];
	_tmp32_ = gtk_builder_get_object (_tmp29_, _tmp31_);
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp32_) : NULL);
	first_entry = _tmp33_;
	_tmp34_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->equation;
	_tmp36_ = arg[0];
	_tmp37_ = arg[1];
	_tmp38_ = arg[2];
	_tmp39_ = arg[3];
	do_finc_expression (_tmp35_, function, _tmp36_, _tmp37_, _tmp38_, _tmp39_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) g_object_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup11 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
math_buttons_character_code_dialog_response_cb (MathButtons* self,
                                                GtkWidget* dialog,
                                                gint response_id)
{
	gchar* text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		Number* x = NULL;
		Number* _tmp3_;
		guint8* decoded = NULL;
		const gchar* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_ = 0;
		guint8* _tmp7_;
		gint _tmp7__length1;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gint decoded_length1;
		gint _decoded_size_;
		gint len = 0;
		guint8* _tmp9_;
		gint _tmp9__length1;
		MathEquation* _tmp20_;
		Number* _tmp21_;
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		x = _tmp3_;
		_tmp4_ = text;
		_tmp5_ = string_get_data (_tmp4_, &_tmp6_);
		_tmp5__length1 = _tmp6_;
		_tmp7_ = _tmp5_;
		_tmp7__length1 = _tmp5__length1;
		_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup11 (_tmp7_, _tmp7__length1) : _tmp7_;
		_tmp8__length1 = _tmp7__length1;
		decoded = _tmp8_;
		decoded_length1 = _tmp8__length1;
		_decoded_size_ = decoded_length1;
		_tmp9_ = decoded;
		_tmp9__length1 = decoded_length1;
		len = _tmp9__length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					Number* _tmp12_;
					guint8* _tmp13_;
					gint _tmp13__length1;
					guint8 _tmp14_;
					Number* _tmp15_;
					Number* _tmp16_;
					Number* _tmp17_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					if (!(i < len)) {
						break;
					}
					_tmp12_ = x;
					_tmp13_ = decoded;
					_tmp13__length1 = decoded_length1;
					_tmp14_ = _tmp13_[i];
					_tmp15_ = number_new_integer ((gint64) _tmp14_, (gint64) 0);
					_tmp16_ = _tmp15_;
					_tmp17_ = number_add (_tmp12_, _tmp16_);
					_g_object_unref0 (x);
					x = _tmp17_;
					_g_object_unref0 (_tmp16_);
					if (i != (len - 1)) {
						Number* _tmp18_;
						Number* _tmp19_;
						_tmp18_ = x;
						_tmp19_ = number_shift (_tmp18_, (gint64) 8);
						_g_object_unref0 (x);
						x = _tmp19_;
					}
				}
			}
		}
		_tmp20_ = self->priv->equation;
		_tmp21_ = x;
		math_equation_insert_number (_tmp20_, _tmp21_);
		decoded = (g_free (decoded), NULL);
		_g_object_unref0 (x);
	}
	gtk_widget_hide (dialog);
	_g_free0 (text);
}

static void
math_buttons_character_code_dialog_activate_cb (MathButtons* self,
                                                GtkWidget* entry)
{
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}

static gboolean
math_buttons_character_code_dialog_close_request (MathButtons* self,
                                                  GtkWidget* dialog)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	math_buttons_character_code_dialog_response_cb (self, dialog, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}

static void
math_buttons_on_toggle_bit (MathButtons* self,
                            GSimpleAction* action,
                            GVariant* param)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->equation;
	math_equation_toggle_bit (_tmp0_, (guint) g_variant_get_int32 (param));
}

static void
math_buttons_on_set_number_mode (MathButtons* self,
                                 GSimpleAction* action,
                                 GVariant* param)
{
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_action_get_state ((GAction*) action);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_string (_tmp3_, NULL);
	_tmp5_ = g_strcmp0 (_tmp0_, _tmp4_) == 0;
	_g_variant_unref0 (_tmp3_);
	if (_tmp5_) {
		MathEquation* _tmp6_;
		_tmp6_ = self->priv->equation;
		math_equation_set_number_mode (_tmp6_, NUMBER_MODE_NORMAL);
	} else {
		const gchar* _tmp7_;
		_tmp7_ = g_variant_get_string (param, NULL);
		if (g_strcmp0 (_tmp7_, "superscript") == 0) {
			MathEquation* _tmp8_;
			MathEquation* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = self->priv->equation;
			math_equation_set_number_mode (_tmp8_, NUMBER_MODE_SUPERSCRIPT);
			_tmp9_ = self->priv->equation;
			_tmp10_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				MathEquation* _tmp12_;
				_tmp12_ = self->priv->equation;
				math_equation_remove_trailing_spaces (_tmp12_);
			}
		} else {
			const gchar* _tmp13_;
			_tmp13_ = g_variant_get_string (param, NULL);
			if (g_strcmp0 (_tmp13_, "subscript") == 0) {
				MathEquation* _tmp14_;
				MathEquation* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp14_ = self->priv->equation;
				math_equation_set_number_mode (_tmp14_, NUMBER_MODE_SUBSCRIPT);
				_tmp15_ = self->priv->equation;
				_tmp16_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					MathEquation* _tmp18_;
					_tmp18_ = self->priv->equation;
					math_equation_remove_trailing_spaces (_tmp18_);
				}
			}
		}
	}
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
math_buttons_number_mode_changed_cb (MathButtons* self)
{
	MathEquation* _tmp0_;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		GSimpleActionGroup* _tmp3_;
		GVariant* _tmp4_;
		_tmp3_ = self->priv->action_group;
		_tmp4_ = _variant_new1 ("superscript");
		g_action_group_change_action_state ((GActionGroup*) _tmp3_, "set-number-mode", _tmp4_);
		_g_variant_unref0 (_tmp4_);
	} else {
		MathEquation* _tmp5_;
		NumberMode _tmp6_;
		NumberMode _tmp7_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = math_equation_get_number_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NUMBER_MODE_SUBSCRIPT) {
			GSimpleActionGroup* _tmp8_;
			GVariant* _tmp9_;
			_tmp8_ = self->priv->action_group;
			_tmp9_ = _variant_new2 ("subscript");
			g_action_group_change_action_state ((GActionGroup*) _tmp8_, "set-number-mode", _tmp9_);
			_g_variant_unref0 (_tmp9_);
		} else {
			GSimpleActionGroup* _tmp10_;
			GVariant* _tmp11_;
			_tmp10_ = self->priv->action_group;
			_tmp11_ = _variant_new3 ("normal");
			g_action_group_change_action_state ((GActionGroup*) _tmp10_, "set-number-mode", _tmp11_);
			_g_variant_unref0 (_tmp11_);
		}
	}
}

ButtonMode
math_buttons_get_mode (MathButtons* self)
{
	ButtonMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
math_buttons_set_mode (MathButtons* self,
                       ButtonMode value)
{
	gboolean _tmp0_ = FALSE;
	ButtonMode _tmp2_;
	ButtonMode _tmp3_;
	gboolean _tmp6_ = FALSE;
	ButtonMode _tmp7_;
	ButtonMode _tmp8_;
	MathConverter* _tmp11_;
	ButtonMode _tmp12_;
	ButtonMode _tmp13_;
	MathConverter* _tmp36_;
	GtkToggleButton* _tmp37_;
	GtkWidget* _tmp39_;
	GtkWidget* _tmp41_;
	AdwLeaflet* _tmp43_;
	g_return_if_fail (self != NULL);
	if (self->priv->_mode == value) {
		MathConverter* _tmp1_;
		_tmp1_ = self->priv->converter;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->_mode = value;
	_tmp2_ = math_buttons_get_mode (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp4_;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_base (_tmp4_, self->priv->_programming_base);
	} else {
		MathEquation* _tmp5_;
		_tmp5_ = self->priv->equation;
		math_equation_set_number_base (_tmp5_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp7_ = math_buttons_get_mode (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == BUTTON_MODE_ADVANCED) {
		_tmp6_ = TRUE;
	} else {
		ButtonMode _tmp9_;
		ButtonMode _tmp10_;
		_tmp9_ = math_buttons_get_mode (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp11_ = self->priv->converter;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp6_);
	_tmp12_ = math_buttons_get_mode (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp14_;
		MathConverter* _tmp15_;
		MathEquation* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		MathEquation* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp14_ = self->priv->converter;
		math_converter_set_category (_tmp14_, NULL);
		_tmp15_ = self->priv->converter;
		_tmp16_ = self->priv->equation;
		_tmp17_ = math_equation_get_source_units (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->equation;
		_tmp21_ = math_equation_get_target_units (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		math_converter_set_conversion (_tmp15_, _tmp19_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp19_);
	} else {
		ButtonMode _tmp24_;
		ButtonMode _tmp25_;
		_tmp24_ = math_buttons_get_mode (self);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp26_;
			MathConverter* _tmp27_;
			MathEquation* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			MathEquation* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp26_ = self->priv->converter;
			math_converter_set_category (_tmp26_, "currency");
			_tmp27_ = self->priv->converter;
			_tmp28_ = self->priv->equation;
			_tmp29_ = math_equation_get_source_currency (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->equation;
			_tmp33_ = math_equation_get_target_currency (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			math_converter_set_conversion (_tmp27_, _tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp31_);
		}
	}
	math_buttons_update_view_more_visible (self);
	_tmp36_ = self->priv->converter;
	math_converter_set_view_more_active (_tmp36_, FALSE);
	_tmp37_ = self->priv->prog_view_more_button;
	if (_tmp37_ != NULL) {
		GtkToggleButton* _tmp38_;
		_tmp38_ = self->priv->prog_view_more_button;
		gtk_toggle_button_set_active (_tmp38_, FALSE);
	}
	_tmp39_ = self->priv->adv_panel;
	if (_tmp39_ != NULL) {
		GtkWidget* _tmp40_;
		_tmp40_ = self->priv->adv_panel;
		adw_leaflet_set_visible_child_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp40_) : NULL, "basic");
	}
	_tmp41_ = self->priv->fin_panel;
	if (_tmp41_ != NULL) {
		GtkWidget* _tmp42_;
		_tmp42_ = self->priv->fin_panel;
		adw_leaflet_set_visible_child_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, adw_leaflet_get_type ()) ? ((AdwLeaflet*) _tmp42_) : NULL, "basic");
	}
	_tmp43_ = self->priv->prog_leaflet;
	if (_tmp43_ != NULL) {
		AdwLeaflet* _tmp44_;
		_tmp44_ = self->priv->prog_leaflet;
		adw_leaflet_set_visible_child_name (_tmp44_, "basic");
	}
	g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_MODE_PROPERTY]);
}

gint
math_buttons_get_programming_base (MathButtons* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_programming_base;
	return result;
}

void
math_buttons_set_programming_base (MathButtons* self,
                                   gint value)
{
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->_programming_base == value) {
		return;
	}
	self->priv->_programming_base = value;
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp2_;
		_tmp2_ = self->priv->equation;
		math_equation_set_number_base (_tmp2_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, math_buttons_properties[MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY]);
}

static void
math_buttons_class_init (MathButtonsClass * klass,
                         gpointer klass_data)
{
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathButtons_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE_PROPERTY, math_buttons_properties[MATH_BUTTONS_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY, math_buttons_properties[MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY] = g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
math_buttons_instance_init (MathButtons * self,
                            gpointer klass)
{
	GSimpleActionGroup* _tmp0_;
	self->priv = math_buttons_get_instance_private (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
	_tmp0_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp0_;
}

static void
math_buttons_finalize (GObject * obj)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->prog_leaflet);
	_g_object_unref0 (self->priv->prog_view_more_button);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->word_size_button);
	_g_object_unref0 (self->priv->bit_panel);
	(self->priv->toggle_bit_buttons == NULL) ? NULL : (self->priv->toggle_bit_buttons = (_g_list_free__g_object_unref0_ (self->priv->toggle_bit_buttons), NULL));
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}

static GType
math_buttons_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
	GType math_buttons_type_id;
	math_buttons_type_id = g_type_register_static (gtk_box_get_type (), "MathButtons", &g_define_type_info, 0);
	MathButtons_private_offset = g_type_add_instance_private (math_buttons_type_id, sizeof (MathButtonsPrivate));
	return math_buttons_type_id;
}

GType
math_buttons_get_type (void)
{
	static volatile gsize math_buttons_type_id__once = 0;
	if (g_once_init_enter (&math_buttons_type_id__once)) {
		GType math_buttons_type_id;
		math_buttons_type_id = math_buttons_get_type_once ();
		g_once_init_leave (&math_buttons_type_id__once, math_buttons_type_id);
	}
	return math_buttons_type_id__once;
}

static void
_vala_math_buttons_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE_PROPERTY:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_buttons_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE_PROPERTY:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE_PROPERTY:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

