/* ai-profile.c generated by valac 0.56.0, the Vala compiler
 * generated from ai-profile.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2016 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "libengine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

enum  {
	AI_PROFILE_0_PROPERTY,
	AI_PROFILE_NAME_PROPERTY,
	AI_PROFILE_PROTOCOL_PROPERTY,
	AI_PROFILE_BINARY_PROPERTY,
	AI_PROFILE_PATH_PROPERTY,
	AI_PROFILE_DELAY_SECONDS_PROPERTY,
	AI_PROFILE_EASY_ARGS_PROPERTY,
	AI_PROFILE_NORMAL_ARGS_PROPERTY,
	AI_PROFILE_HARD_ARGS_PROPERTY,
	AI_PROFILE_EASY_OPTIONS_PROPERTY,
	AI_PROFILE_NORMAL_OPTIONS_PROPERTY,
	AI_PROFILE_HARD_OPTIONS_PROPERTY,
	AI_PROFILE_EASY_UCI_GO_OPTIONS_PROPERTY,
	AI_PROFILE_NORMAL_UCI_GO_OPTIONS_PROPERTY,
	AI_PROFILE_HARD_UCI_GO_OPTIONS_PROPERTY,
	AI_PROFILE_NUM_PROPERTIES
};
static GParamSpec* ai_profile_properties[AI_PROFILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _AIProfilePrivate {
	gchar* _name;
	gchar* _protocol;
	gchar* _binary;
	gchar* _path;
	guint _delay_seconds;
	gchar** _easy_args;
	gint _easy_args_length1;
	gint __easy_args_size_;
	gchar** _normal_args;
	gint _normal_args_length1;
	gint __normal_args_size_;
	gchar** _hard_args;
	gint _hard_args_length1;
	gint __hard_args_size_;
	gchar** _easy_options;
	gint _easy_options_length1;
	gint __easy_options_size_;
	gchar** _normal_options;
	gint _normal_options_length1;
	gint __normal_options_size_;
	gchar** _hard_options;
	gint _hard_options_length1;
	gint __hard_options_size_;
	gchar** _easy_uci_go_options;
	gint _easy_uci_go_options_length1;
	gint __easy_uci_go_options_size_;
	gchar** _normal_uci_go_options;
	gint _normal_uci_go_options_length1;
	gint __normal_uci_go_options_size_;
	gchar** _hard_uci_go_options;
	gint _hard_uci_go_options_length1;
	gint __hard_uci_go_options_size_;
};

static gint AIProfile_private_offset;
static gpointer ai_profile_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ai_profile_set_name (AIProfile* self,
                          const gchar* value);
static void ai_profile_set_protocol (AIProfile* self,
                              const gchar* value);
static void ai_profile_set_binary (AIProfile* self,
                            const gchar* value);
static gchar** ai_profile_load_array (GKeyFile* file,
                               const gchar* name,
                               const gchar* type,
                               const gchar* difficulty,
                               gint* result_length1,
                               GError** error);
static void ai_profile_set_easy_args (AIProfile* self,
                               gchar** value,
                               gint value_length1);
static void ai_profile_set_normal_args (AIProfile* self,
                                 gchar** value,
                                 gint value_length1);
static void ai_profile_set_hard_args (AIProfile* self,
                               gchar** value,
                               gint value_length1);
static void ai_profile_set_easy_options (AIProfile* self,
                                  gchar** value,
                                  gint value_length1);
static void ai_profile_set_normal_options (AIProfile* self,
                                    gchar** value,
                                    gint value_length1);
static void ai_profile_set_hard_options (AIProfile* self,
                                  gchar** value,
                                  gint value_length1);
static void ai_profile_set_easy_uci_go_options (AIProfile* self,
                                         gchar** value,
                                         gint value_length1);
static void ai_profile_set_normal_uci_go_options (AIProfile* self,
                                           gchar** value,
                                           gint value_length1);
static void ai_profile_set_hard_uci_go_options (AIProfile* self,
                                         gchar** value,
                                         gint value_length1);
static void ai_profile_set_delay_seconds (AIProfile* self,
                                   guint value);
static void ai_profile_set_path (AIProfile* self,
                          const gchar* value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static void ai_profile_finalize (GObject * obj);
static GType ai_profile_get_type_once (void);
static void _vala_ai_profile_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_ai_profile_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
ai_profile_get_instance_private (AIProfile* self)
{
	return G_STRUCT_MEMBER_P (self, AIProfile_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GList*
ai_profile_load_ai_profiles (const gchar* filename)
{
	GList* profiles = NULL;
	GKeyFile* file = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp6_;
	gsize _tmp7_ = 0;
	gchar** _tmp8_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (filename != NULL, NULL);
	profiles = NULL;
	_tmp0_ = g_key_file_new ();
	file = _tmp0_;
	{
		GKeyFile* _tmp1_;
		_tmp1_ = file;
		g_key_file_load_from_file (_tmp1_, filename, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_unref0 (file);
			(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("ai-profile.vala:41: Failed to load AI profiles: %s", _tmp3_);
		result = profiles;
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ai-profile.vala:46: Failed to load AI profiles: %s", _tmp5_);
		result = profiles;
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (file);
		(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = file;
	_tmp8_ = g_key_file_get_groups (_tmp6_, &_tmp7_);
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp8_;
		name_collection_length1 = _tmp7_;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp9_;
			gchar* name = NULL;
			_tmp9_ = g_strdup (name_collection[name_it]);
			name = _tmp9_;
			{
				const gchar* _tmp10_;
				AIProfile* profile = NULL;
				AIProfile* _tmp11_;
				gchar* path = NULL;
				AIProfile* _tmp87_;
				const gchar* _tmp88_;
				gchar* _tmp89_;
				const gchar* _tmp90_;
				_tmp10_ = name;
				g_debug ("ai-profile.vala:52: Loading AI profile %s", _tmp10_);
				_tmp11_ = ai_profile_new ();
				profile = _tmp11_;
				{
					AIProfile* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					GKeyFile* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					AIProfile* _tmp18_;
					gchar* _tmp19_ = NULL;
					GKeyFile* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					AIProfile* _tmp23_;
					gchar** _tmp24_ = NULL;
					GKeyFile* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_ = 0;
					gchar** _tmp28_;
					gint _tmp24__length1;
					gint __tmp24__size_;
					AIProfile* _tmp29_;
					gchar** _tmp30_ = NULL;
					GKeyFile* _tmp31_;
					const gchar* _tmp32_;
					gint _tmp33_ = 0;
					gchar** _tmp34_;
					gint _tmp30__length1;
					gint __tmp30__size_;
					AIProfile* _tmp35_;
					gchar** _tmp36_ = NULL;
					GKeyFile* _tmp37_;
					const gchar* _tmp38_;
					gint _tmp39_ = 0;
					gchar** _tmp40_;
					gint _tmp36__length1;
					gint __tmp36__size_;
					AIProfile* _tmp41_;
					gchar** _tmp42_ = NULL;
					GKeyFile* _tmp43_;
					const gchar* _tmp44_;
					gint _tmp45_ = 0;
					gchar** _tmp46_;
					gint _tmp42__length1;
					gint __tmp42__size_;
					AIProfile* _tmp47_;
					gchar** _tmp48_ = NULL;
					GKeyFile* _tmp49_;
					const gchar* _tmp50_;
					gint _tmp51_ = 0;
					gchar** _tmp52_;
					gint _tmp48__length1;
					gint __tmp48__size_;
					AIProfile* _tmp53_;
					gchar** _tmp54_ = NULL;
					GKeyFile* _tmp55_;
					const gchar* _tmp56_;
					gint _tmp57_ = 0;
					gchar** _tmp58_;
					gint _tmp54__length1;
					gint __tmp54__size_;
					AIProfile* _tmp59_;
					gchar** _tmp60_ = NULL;
					GKeyFile* _tmp61_;
					const gchar* _tmp62_;
					gint _tmp63_ = 0;
					gchar** _tmp64_;
					gint _tmp60__length1;
					gint __tmp60__size_;
					AIProfile* _tmp65_;
					gchar** _tmp66_ = NULL;
					GKeyFile* _tmp67_;
					const gchar* _tmp68_;
					gint _tmp69_ = 0;
					gchar** _tmp70_;
					gint _tmp66__length1;
					gint __tmp66__size_;
					AIProfile* _tmp71_;
					gchar** _tmp72_ = NULL;
					GKeyFile* _tmp73_;
					const gchar* _tmp74_;
					gint _tmp75_ = 0;
					gchar** _tmp76_;
					gint _tmp72__length1;
					gint __tmp72__size_;
					AIProfile* _tmp77_;
					gboolean _tmp78_ = FALSE;
					GKeyFile* _tmp79_;
					const gchar* _tmp80_;
					_tmp12_ = profile;
					_tmp13_ = name;
					ai_profile_set_name (_tmp12_, _tmp13_);
					_tmp15_ = file;
					_tmp16_ = name;
					_tmp17_ = g_key_file_get_value (_tmp15_, _tmp16_, "protocol", &_inner_error0_);
					_tmp14_ = _tmp17_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp18_ = profile;
					ai_profile_set_protocol (_tmp18_, _tmp14_);
					_tmp20_ = file;
					_tmp21_ = name;
					_tmp22_ = g_key_file_get_value (_tmp20_, _tmp21_, "binary", &_inner_error0_);
					_tmp19_ = _tmp22_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp23_ = profile;
					ai_profile_set_binary (_tmp23_, _tmp19_);
					_tmp25_ = file;
					_tmp26_ = name;
					_tmp28_ = ai_profile_load_array (_tmp25_, _tmp26_, "arg", "easy", &_tmp27_, &_inner_error0_);
					_tmp24_ = _tmp28_;
					_tmp24__length1 = _tmp27_;
					__tmp24__size_ = _tmp24__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp29_ = profile;
					ai_profile_set_easy_args (_tmp29_, _tmp24_, _tmp24__length1);
					_tmp31_ = file;
					_tmp32_ = name;
					_tmp34_ = ai_profile_load_array (_tmp31_, _tmp32_, "arg", "normal", &_tmp33_, &_inner_error0_);
					_tmp30_ = _tmp34_;
					_tmp30__length1 = _tmp33_;
					__tmp30__size_ = _tmp30__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp35_ = profile;
					ai_profile_set_normal_args (_tmp35_, _tmp30_, _tmp30__length1);
					_tmp37_ = file;
					_tmp38_ = name;
					_tmp40_ = ai_profile_load_array (_tmp37_, _tmp38_, "arg", "hard", &_tmp39_, &_inner_error0_);
					_tmp36_ = _tmp40_;
					_tmp36__length1 = _tmp39_;
					__tmp36__size_ = _tmp36__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp41_ = profile;
					ai_profile_set_hard_args (_tmp41_, _tmp36_, _tmp36__length1);
					_tmp43_ = file;
					_tmp44_ = name;
					_tmp46_ = ai_profile_load_array (_tmp43_, _tmp44_, "option", "easy", &_tmp45_, &_inner_error0_);
					_tmp42_ = _tmp46_;
					_tmp42__length1 = _tmp45_;
					__tmp42__size_ = _tmp42__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp47_ = profile;
					ai_profile_set_easy_options (_tmp47_, _tmp42_, _tmp42__length1);
					_tmp49_ = file;
					_tmp50_ = name;
					_tmp52_ = ai_profile_load_array (_tmp49_, _tmp50_, "option", "normal", &_tmp51_, &_inner_error0_);
					_tmp48_ = _tmp52_;
					_tmp48__length1 = _tmp51_;
					__tmp48__size_ = _tmp48__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp53_ = profile;
					ai_profile_set_normal_options (_tmp53_, _tmp48_, _tmp48__length1);
					_tmp55_ = file;
					_tmp56_ = name;
					_tmp58_ = ai_profile_load_array (_tmp55_, _tmp56_, "option", "hard", &_tmp57_, &_inner_error0_);
					_tmp54_ = _tmp58_;
					_tmp54__length1 = _tmp57_;
					__tmp54__size_ = _tmp54__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
						_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp59_ = profile;
					ai_profile_set_hard_options (_tmp59_, _tmp54_, _tmp54__length1);
					_tmp61_ = file;
					_tmp62_ = name;
					_tmp64_ = ai_profile_load_array (_tmp61_, _tmp62_, "uci-go-option", "easy", &_tmp63_, &_inner_error0_);
					_tmp60_ = _tmp64_;
					_tmp60__length1 = _tmp63_;
					__tmp60__size_ = _tmp60__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
						_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
						_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp65_ = profile;
					ai_profile_set_easy_uci_go_options (_tmp65_, _tmp60_, _tmp60__length1);
					_tmp67_ = file;
					_tmp68_ = name;
					_tmp70_ = ai_profile_load_array (_tmp67_, _tmp68_, "uci-go-option", "normal", &_tmp69_, &_inner_error0_);
					_tmp66_ = _tmp70_;
					_tmp66__length1 = _tmp69_;
					__tmp66__size_ = _tmp66__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
						_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
						_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
						_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp71_ = profile;
					ai_profile_set_normal_uci_go_options (_tmp71_, _tmp66_, _tmp66__length1);
					_tmp73_ = file;
					_tmp74_ = name;
					_tmp76_ = ai_profile_load_array (_tmp73_, _tmp74_, "uci-go-option", "hard", &_tmp75_, &_inner_error0_);
					_tmp72_ = _tmp76_;
					_tmp72__length1 = _tmp75_;
					__tmp72__size_ = _tmp72__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_free), NULL);
						_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
						_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
						_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
						_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp77_ = profile;
					ai_profile_set_hard_uci_go_options (_tmp77_, _tmp72_, _tmp72__length1);
					_tmp79_ = file;
					_tmp80_ = name;
					_tmp78_ = g_key_file_has_key (_tmp79_, _tmp80_, "delay-before-move", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
						_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_free), NULL);
						_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
						_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
						_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
						_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
						_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
						_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp14_);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						_g_object_unref0 (profile);
						_g_free0 (name);
						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_unref0 (file);
						(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					if (_tmp78_) {
						gint _tmp81_ = 0;
						GKeyFile* _tmp82_;
						const gchar* _tmp83_;
						AIProfile* _tmp84_;
						_tmp82_ = file;
						_tmp83_ = name;
						_tmp81_ = g_key_file_get_integer (_tmp82_, _tmp83_, "delay-before-move", &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
							_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_free), NULL);
							_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
							_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
							_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
							_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
							_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
							_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
							_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (_tmp19_);
							_g_free0 (_tmp14_);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch1_g_key_file_error;
							}
							_g_object_unref0 (profile);
							_g_free0 (name);
							name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
							_g_key_file_unref0 (file);
							(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp84_ = profile;
						ai_profile_set_delay_seconds (_tmp84_, (guint) _tmp81_);
					}
					_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
					_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_free), NULL);
					_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
					_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
					_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
					_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
					_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
					_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
					_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp19_);
					_g_free0 (_tmp14_);
				}
				goto __finally1;
				__catch1_g_key_file_error:
				{
					GError* e = NULL;
					GError* _tmp85_;
					const gchar* _tmp86_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp85_ = e;
					_tmp86_ = _tmp85_->message;
					g_warning ("ai-profile.vala:74: Error reading AI profiles: %s", _tmp86_);
					_g_error_free0 (e);
					_g_object_unref0 (profile);
					_g_free0 (name);
					continue;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (profile);
					_g_free0 (name);
					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_key_file_unref0 (file);
					(profiles == NULL) ? NULL : (profiles = (_g_list_free__g_object_unref0_ (profiles), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp87_ = profile;
				_tmp88_ = _tmp87_->priv->_binary;
				_tmp89_ = g_find_program_in_path (_tmp88_);
				path = _tmp89_;
				_tmp90_ = path;
				if (_tmp90_ != NULL) {
					AIProfile* _tmp91_;
					const gchar* _tmp92_;
					AIProfile* _tmp93_;
					AIProfile* _tmp94_;
					_tmp91_ = profile;
					_tmp92_ = path;
					ai_profile_set_path (_tmp91_, _tmp92_);
					_tmp93_ = profile;
					_tmp94_ = _g_object_ref0 (_tmp93_);
					profiles = g_list_append (profiles, _tmp94_);
				}
				_g_free0 (path);
				_g_object_unref0 (profile);
				_g_free0 (name);
			}
		}
		name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = profiles;
	_g_key_file_unref0 (file);
	return result;
}

static gchar**
ai_profile_load_array (GKeyFile* file,
                       const gchar* name,
                       const gchar* type,
                       const gchar* difficulty,
                       gint* result_length1,
                       GError** error)
{
	gint count = 0;
	gchar** options = NULL;
	gchar** _tmp5_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	count = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_;
		gint _tmp4_;
		_tmp1_ = g_strdup_printf ("%s-%s-%d", type, difficulty, count);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_key_file_has_key (file, name, _tmp2_, &_inner_error0_);
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = count;
		count = _tmp4_ + 1;
	}
	_tmp5_ = g_new0 (gchar*, count + 1);
	options = _tmp5_;
	options_length1 = count;
	_options_size_ = options_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar* _tmp14_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp9_ = g_strdup_printf ("%s-%s-%d", type, difficulty, i);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_key_file_get_value (file, name, _tmp10_, &_inner_error0_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp10_);
				_tmp8_ = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp13_ = options;
				_tmp13__length1 = options_length1;
				_tmp14_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (_tmp13_[i]);
				_tmp13_[i] = _tmp14_;
				_g_free0 (_tmp8_);
			}
		}
	}
	_tmp15_ = options;
	_tmp15__length1 = options_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

AIProfile*
ai_profile_construct (GType object_type)
{
	AIProfile * self = NULL;
	self = (AIProfile*) g_object_new (object_type, NULL);
	return self;
}

AIProfile*
ai_profile_new (void)
{
	return ai_profile_construct (TYPE_AI_PROFILE);
}

const gchar*
ai_profile_get_name (AIProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
ai_profile_set_name (AIProfile* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_NAME_PROPERTY]);
	}
}

const gchar*
ai_profile_get_protocol (AIProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}

static void
ai_profile_set_protocol (AIProfile* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_protocol (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_protocol);
		self->priv->_protocol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_PROTOCOL_PROPERTY]);
	}
}

const gchar*
ai_profile_get_binary (AIProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_binary;
	result = _tmp0_;
	return result;
}

static void
ai_profile_set_binary (AIProfile* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_binary (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_binary);
		self->priv->_binary = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_BINARY_PROPERTY]);
	}
}

const gchar*
ai_profile_get_path (AIProfile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

static void
ai_profile_set_path (AIProfile* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_PATH_PROPERTY]);
	}
}

guint
ai_profile_get_delay_seconds (AIProfile* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_delay_seconds;
	return result;
}

static void
ai_profile_set_delay_seconds (AIProfile* self,
                              guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_delay_seconds (self);
	if (old_value != value) {
		self->priv->_delay_seconds = value;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_DELAY_SECONDS_PROPERTY]);
	}
}

gchar**
ai_profile_get_easy_args (AIProfile* self,
                          gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_easy_args;
	_tmp0__length1 = self->priv->_easy_args_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_easy_args (AIProfile* self,
                          gchar** value,
                          gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_easy_args (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_easy_args = (_vala_array_free (self->priv->_easy_args, self->priv->_easy_args_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_easy_args = _tmp0_;
		self->priv->_easy_args_length1 = _tmp0__length1;
		self->priv->__easy_args_size_ = self->priv->_easy_args_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_EASY_ARGS_PROPERTY]);
	}
}

gchar**
ai_profile_get_normal_args (AIProfile* self,
                            gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_normal_args;
	_tmp0__length1 = self->priv->_normal_args_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_normal_args (AIProfile* self,
                            gchar** value,
                            gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_normal_args (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_normal_args = (_vala_array_free (self->priv->_normal_args, self->priv->_normal_args_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_normal_args = _tmp0_;
		self->priv->_normal_args_length1 = _tmp0__length1;
		self->priv->__normal_args_size_ = self->priv->_normal_args_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_NORMAL_ARGS_PROPERTY]);
	}
}

gchar**
ai_profile_get_hard_args (AIProfile* self,
                          gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hard_args;
	_tmp0__length1 = self->priv->_hard_args_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_hard_args (AIProfile* self,
                          gchar** value,
                          gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_hard_args (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_hard_args = (_vala_array_free (self->priv->_hard_args, self->priv->_hard_args_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_hard_args = _tmp0_;
		self->priv->_hard_args_length1 = _tmp0__length1;
		self->priv->__hard_args_size_ = self->priv->_hard_args_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_HARD_ARGS_PROPERTY]);
	}
}

gchar**
ai_profile_get_easy_options (AIProfile* self,
                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_easy_options;
	_tmp0__length1 = self->priv->_easy_options_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_easy_options (AIProfile* self,
                             gchar** value,
                             gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_easy_options (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup4 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_easy_options = (_vala_array_free (self->priv->_easy_options, self->priv->_easy_options_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_easy_options = _tmp0_;
		self->priv->_easy_options_length1 = _tmp0__length1;
		self->priv->__easy_options_size_ = self->priv->_easy_options_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_EASY_OPTIONS_PROPERTY]);
	}
}

gchar**
ai_profile_get_normal_options (AIProfile* self,
                               gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_normal_options;
	_tmp0__length1 = self->priv->_normal_options_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_normal_options (AIProfile* self,
                               gchar** value,
                               gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_normal_options (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup5 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_normal_options = (_vala_array_free (self->priv->_normal_options, self->priv->_normal_options_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_normal_options = _tmp0_;
		self->priv->_normal_options_length1 = _tmp0__length1;
		self->priv->__normal_options_size_ = self->priv->_normal_options_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_NORMAL_OPTIONS_PROPERTY]);
	}
}

gchar**
ai_profile_get_hard_options (AIProfile* self,
                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hard_options;
	_tmp0__length1 = self->priv->_hard_options_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_hard_options (AIProfile* self,
                             gchar** value,
                             gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_hard_options (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup6 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_hard_options = (_vala_array_free (self->priv->_hard_options, self->priv->_hard_options_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_hard_options = _tmp0_;
		self->priv->_hard_options_length1 = _tmp0__length1;
		self->priv->__hard_options_size_ = self->priv->_hard_options_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_HARD_OPTIONS_PROPERTY]);
	}
}

gchar**
ai_profile_get_easy_uci_go_options (AIProfile* self,
                                    gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_easy_uci_go_options;
	_tmp0__length1 = self->priv->_easy_uci_go_options_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_easy_uci_go_options (AIProfile* self,
                                    gchar** value,
                                    gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_easy_uci_go_options (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup7 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_easy_uci_go_options = (_vala_array_free (self->priv->_easy_uci_go_options, self->priv->_easy_uci_go_options_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_easy_uci_go_options = _tmp0_;
		self->priv->_easy_uci_go_options_length1 = _tmp0__length1;
		self->priv->__easy_uci_go_options_size_ = self->priv->_easy_uci_go_options_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_EASY_UCI_GO_OPTIONS_PROPERTY]);
	}
}

gchar**
ai_profile_get_normal_uci_go_options (AIProfile* self,
                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_normal_uci_go_options;
	_tmp0__length1 = self->priv->_normal_uci_go_options_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_normal_uci_go_options (AIProfile* self,
                                      gchar** value,
                                      gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_normal_uci_go_options (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup8 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_normal_uci_go_options = (_vala_array_free (self->priv->_normal_uci_go_options, self->priv->_normal_uci_go_options_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_normal_uci_go_options = _tmp0_;
		self->priv->_normal_uci_go_options_length1 = _tmp0__length1;
		self->priv->__normal_uci_go_options_size_ = self->priv->_normal_uci_go_options_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_NORMAL_UCI_GO_OPTIONS_PROPERTY]);
	}
}

gchar**
ai_profile_get_hard_uci_go_options (AIProfile* self,
                                    gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hard_uci_go_options;
	_tmp0__length1 = self->priv->_hard_uci_go_options_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
ai_profile_set_hard_uci_go_options (AIProfile* self,
                                    gchar** value,
                                    gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = ai_profile_get_hard_uci_go_options (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup9 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_hard_uci_go_options = (_vala_array_free (self->priv->_hard_uci_go_options, self->priv->_hard_uci_go_options_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_hard_uci_go_options = _tmp0_;
		self->priv->_hard_uci_go_options_length1 = _tmp0__length1;
		self->priv->__hard_uci_go_options_size_ = self->priv->_hard_uci_go_options_length1;
		g_object_notify_by_pspec ((GObject *) self, ai_profile_properties[AI_PROFILE_HARD_UCI_GO_OPTIONS_PROPERTY]);
	}
}

static void
ai_profile_class_init (AIProfileClass * klass,
                       gpointer klass_data)
{
	ai_profile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AIProfile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_ai_profile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ai_profile_set_property;
	G_OBJECT_CLASS (klass)->finalize = ai_profile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_NAME_PROPERTY, ai_profile_properties[AI_PROFILE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_PROTOCOL_PROPERTY, ai_profile_properties[AI_PROFILE_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_BINARY_PROPERTY, ai_profile_properties[AI_PROFILE_BINARY_PROPERTY] = g_param_spec_string ("binary", "binary", "binary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_PATH_PROPERTY, ai_profile_properties[AI_PROFILE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_DELAY_SECONDS_PROPERTY, ai_profile_properties[AI_PROFILE_DELAY_SECONDS_PROPERTY] = g_param_spec_uint ("delay-seconds", "delay-seconds", "delay-seconds", 0, G_MAXUINT, (guint) 2, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_EASY_ARGS_PROPERTY, ai_profile_properties[AI_PROFILE_EASY_ARGS_PROPERTY] = g_param_spec_boxed ("easy-args", "easy-args", "easy-args", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_NORMAL_ARGS_PROPERTY, ai_profile_properties[AI_PROFILE_NORMAL_ARGS_PROPERTY] = g_param_spec_boxed ("normal-args", "normal-args", "normal-args", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_HARD_ARGS_PROPERTY, ai_profile_properties[AI_PROFILE_HARD_ARGS_PROPERTY] = g_param_spec_boxed ("hard-args", "hard-args", "hard-args", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_EASY_OPTIONS_PROPERTY, ai_profile_properties[AI_PROFILE_EASY_OPTIONS_PROPERTY] = g_param_spec_boxed ("easy-options", "easy-options", "easy-options", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_NORMAL_OPTIONS_PROPERTY, ai_profile_properties[AI_PROFILE_NORMAL_OPTIONS_PROPERTY] = g_param_spec_boxed ("normal-options", "normal-options", "normal-options", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_HARD_OPTIONS_PROPERTY, ai_profile_properties[AI_PROFILE_HARD_OPTIONS_PROPERTY] = g_param_spec_boxed ("hard-options", "hard-options", "hard-options", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_EASY_UCI_GO_OPTIONS_PROPERTY, ai_profile_properties[AI_PROFILE_EASY_UCI_GO_OPTIONS_PROPERTY] = g_param_spec_boxed ("easy-uci-go-options", "easy-uci-go-options", "easy-uci-go-options", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_NORMAL_UCI_GO_OPTIONS_PROPERTY, ai_profile_properties[AI_PROFILE_NORMAL_UCI_GO_OPTIONS_PROPERTY] = g_param_spec_boxed ("normal-uci-go-options", "normal-uci-go-options", "normal-uci-go-options", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AI_PROFILE_HARD_UCI_GO_OPTIONS_PROPERTY, ai_profile_properties[AI_PROFILE_HARD_UCI_GO_OPTIONS_PROPERTY] = g_param_spec_boxed ("hard-uci-go-options", "hard-uci-go-options", "hard-uci-go-options", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
ai_profile_instance_init (AIProfile * self,
                          gpointer klass)
{
	self->priv = ai_profile_get_instance_private (self);
	self->priv->_delay_seconds = (guint) 2;
}

static void
ai_profile_finalize (GObject * obj)
{
	AIProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AI_PROFILE, AIProfile);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_protocol);
	_g_free0 (self->priv->_binary);
	_g_free0 (self->priv->_path);
	self->priv->_easy_args = (_vala_array_free (self->priv->_easy_args, self->priv->_easy_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_normal_args = (_vala_array_free (self->priv->_normal_args, self->priv->_normal_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_hard_args = (_vala_array_free (self->priv->_hard_args, self->priv->_hard_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_easy_options = (_vala_array_free (self->priv->_easy_options, self->priv->_easy_options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_normal_options = (_vala_array_free (self->priv->_normal_options, self->priv->_normal_options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_hard_options = (_vala_array_free (self->priv->_hard_options, self->priv->_hard_options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_easy_uci_go_options = (_vala_array_free (self->priv->_easy_uci_go_options, self->priv->_easy_uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_normal_uci_go_options = (_vala_array_free (self->priv->_normal_uci_go_options, self->priv->_normal_uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_hard_uci_go_options = (_vala_array_free (self->priv->_hard_uci_go_options, self->priv->_hard_uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (ai_profile_parent_class)->finalize (obj);
}

static GType
ai_profile_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AIProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ai_profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AIProfile), 0, (GInstanceInitFunc) ai_profile_instance_init, NULL };
	GType ai_profile_type_id;
	ai_profile_type_id = g_type_register_static (G_TYPE_OBJECT, "AIProfile", &g_define_type_info, 0);
	AIProfile_private_offset = g_type_add_instance_private (ai_profile_type_id, sizeof (AIProfilePrivate));
	return ai_profile_type_id;
}

GType
ai_profile_get_type (void)
{
	static volatile gsize ai_profile_type_id__once = 0;
	if (g_once_init_enter (&ai_profile_type_id__once)) {
		GType ai_profile_type_id;
		ai_profile_type_id = ai_profile_get_type_once ();
		g_once_init_leave (&ai_profile_type_id__once, ai_profile_type_id);
	}
	return ai_profile_type_id__once;
}

static void
_vala_ai_profile_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	AIProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AI_PROFILE, AIProfile);
	switch (property_id) {
		case AI_PROFILE_NAME_PROPERTY:
		g_value_set_string (value, ai_profile_get_name (self));
		break;
		case AI_PROFILE_PROTOCOL_PROPERTY:
		g_value_set_string (value, ai_profile_get_protocol (self));
		break;
		case AI_PROFILE_BINARY_PROPERTY:
		g_value_set_string (value, ai_profile_get_binary (self));
		break;
		case AI_PROFILE_PATH_PROPERTY:
		g_value_set_string (value, ai_profile_get_path (self));
		break;
		case AI_PROFILE_DELAY_SECONDS_PROPERTY:
		g_value_set_uint (value, ai_profile_get_delay_seconds (self));
		break;
		case AI_PROFILE_EASY_ARGS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_easy_args (self, &length));
		}
		break;
		case AI_PROFILE_NORMAL_ARGS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_normal_args (self, &length));
		}
		break;
		case AI_PROFILE_HARD_ARGS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_hard_args (self, &length));
		}
		break;
		case AI_PROFILE_EASY_OPTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_easy_options (self, &length));
		}
		break;
		case AI_PROFILE_NORMAL_OPTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_normal_options (self, &length));
		}
		break;
		case AI_PROFILE_HARD_OPTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_hard_options (self, &length));
		}
		break;
		case AI_PROFILE_EASY_UCI_GO_OPTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_easy_uci_go_options (self, &length));
		}
		break;
		case AI_PROFILE_NORMAL_UCI_GO_OPTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_normal_uci_go_options (self, &length));
		}
		break;
		case AI_PROFILE_HARD_UCI_GO_OPTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, ai_profile_get_hard_uci_go_options (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ai_profile_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	AIProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AI_PROFILE, AIProfile);
	switch (property_id) {
		case AI_PROFILE_NAME_PROPERTY:
		ai_profile_set_name (self, g_value_get_string (value));
		break;
		case AI_PROFILE_PROTOCOL_PROPERTY:
		ai_profile_set_protocol (self, g_value_get_string (value));
		break;
		case AI_PROFILE_BINARY_PROPERTY:
		ai_profile_set_binary (self, g_value_get_string (value));
		break;
		case AI_PROFILE_PATH_PROPERTY:
		ai_profile_set_path (self, g_value_get_string (value));
		break;
		case AI_PROFILE_DELAY_SECONDS_PROPERTY:
		ai_profile_set_delay_seconds (self, g_value_get_uint (value));
		break;
		case AI_PROFILE_EASY_ARGS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_easy_args (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_NORMAL_ARGS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_normal_args (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_HARD_ARGS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_hard_args (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_EASY_OPTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_easy_options (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_NORMAL_OPTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_normal_options (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_HARD_OPTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_hard_options (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_EASY_UCI_GO_OPTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_easy_uci_go_options (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_NORMAL_UCI_GO_OPTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_normal_uci_go_options (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case AI_PROFILE_HARD_UCI_GO_OPTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			ai_profile_set_hard_uci_go_options (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

