/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XNodeInfo;

public class XTreeRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof XNodeInfo) {
            XNodeInfo node = (XNodeInfo)userObject;
            this.setToolTipText(node.getToolTipText());
            switch (node.getType()) {
                case MBEAN: {
                    XMBean xmbean = (XMBean)node.getData();
                    this.setIcon((ImageIcon)xmbean.getIcon());
                    break;
                }
                case NONMBEAN: {
                    break;
                }
                case ATTRIBUTES: 
                case OPERATIONS: 
                case NOTIFICATIONS: {
                    this.setIcon(null);
                    break;
                }
                case ATTRIBUTE: 
                case OPERATION: 
                case NOTIFICATION: {
                    this.setIcon(null);
                }
            }
        } else {
            this.setToolTipText(null);
        }
        return this;
    }
}

