/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         ir3_yyparse
#define yylex           ir3_yylex
#define yyerror         ir3_yyerror
#define yydebug         ir3_yydebug
#define yynerrs         ir3_yynerrs
#define yylval          ir3_yylval
#define yychar          ir3_yychar

/* First part of user prologue.  */
#line 32 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"

#define YYDEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "util/half_float.h"
#include "util/u_math.h"

#include "ir3/ir3.h"
#include "ir3/ir3_shader.h"
#include "ir3/instr-a3xx.h"

#include "ir3_parser.h"

#define swap(a, b) \
	do { __typeof(a) __tmp = (a); (a) = (b); (b) = __tmp; } while (0)

/* ir3 treats the abs/neg flags as separate flags for float vs integer,
 * but in the instruction encoding they are the same thing.  Tracking
 * them separately is only for the benefit of ir3 opt passes, and not
 * required here, so just use the float versions:
 */
#define IR3_REG_ABS     IR3_REG_FABS
#define IR3_REG_NEGATE  IR3_REG_FNEG

static struct ir3_kernel_info    *info;
static struct ir3_shader_variant *variant;
/* NOTE the assembler doesn't really use the ir3_block construction
 * like the compiler does.  Everything is treated as one large block.
 * Which might happen to contain flow control.  But since we don't
 * use any of the ir3 backend passes (sched, RA, etc) this doesn't
 * really matter.
 */
static struct ir3_block          *block;   /* current shader block */
static struct ir3_instruction    *instr;   /* current instruction */
static unsigned ip; /* current instruction pointer */
static struct hash_table *labels;

void *ir3_parser_dead_ctx;

static struct {
	unsigned flags;
	unsigned repeat;
	unsigned nop;
} iflags;

static struct {
	unsigned flags;
	unsigned wrmask;
} rflags;

int ir3_yyget_lineno(void);

static void new_label(const char *name)
{
	ralloc_steal(labels, (void *) name);
	_mesa_hash_table_insert(labels, name, (void *)(uintptr_t)ip);
}

static struct ir3_instruction * new_instr(opc_t opc)
{
	instr = ir3_instr_create(block, opc, 4, 6);
	instr->flags = iflags.flags;
	instr->repeat = iflags.repeat;
	instr->nop = iflags.nop;
	instr->line = ir3_yyget_lineno();
	iflags.flags = iflags.repeat = iflags.nop = 0;
	ip++;
	return instr;
}

static void new_shader(void)
{
	variant->ir = ir3_create(variant->shader->compiler, variant);
	block = ir3_block_create(variant->ir);
	list_addtail(&block->node, &variant->ir->block_list);
	ip = 0;
	labels = _mesa_hash_table_create(variant, _mesa_hash_string, _mesa_key_string_equal);
	ir3_parser_dead_ctx = ralloc_context(NULL);
}

static type_t parse_type(const char **type)
{
	if (!strncmp("f16", *type, 3)) {
		*type += 3;
		return TYPE_F16;
	} else if (!strncmp("f32", *type, 3)) {
		*type += 3;
		return TYPE_F32;
	} else if (!strncmp("u16", *type, 3)) {
		*type += 3;
		return TYPE_U16;
	} else if (!strncmp("u32", *type, 3)) {
		*type += 3;
		return TYPE_U32;
	} else if (!strncmp("s16", *type, 3)) {
		*type += 3;
		return TYPE_S16;
	} else if (!strncmp("s32", *type, 3)) {
		*type += 3;
		return TYPE_S32;
	} else if (!strncmp("u8", *type, 2)) {
		*type += 2;
		return TYPE_U8;
	} else if (!strncmp("s8", *type, 2)) {
		*type += 2;
		return TYPE_S8;
	} else {
		assert(0);  /* shouldn't get here */
		return ~0;
	}
}

static struct ir3_instruction * parse_type_type(struct ir3_instruction *instr,
		const char *type_type)
{
	instr->cat1.src_type = parse_type(&type_type);
	instr->cat1.dst_type = parse_type(&type_type);
	return instr;
}

static struct ir3_register * new_src(int num, unsigned flags)
{
	struct ir3_register *reg;
	flags |= rflags.flags;
	if (num & 0x1)
		flags |= IR3_REG_HALF;
	reg = ir3_src_create(instr, num>>1, flags);
	reg->wrmask = MAX2(1, rflags.wrmask);
	rflags.flags = rflags.wrmask = 0;
	return reg;
}

static struct ir3_register * new_dst(int num, unsigned flags)
{
	struct ir3_register *reg;
	flags |= rflags.flags;
	if (num & 0x1)
		flags |= IR3_REG_HALF;
	reg = ir3_dst_create(instr, num>>1, flags);
	reg->wrmask = MAX2(1, rflags.wrmask);
	rflags.flags = rflags.wrmask = 0;
	return reg;
}

static struct ir3_register * dummy_dst(void)
{
	return new_dst(0, 0);
}

static void fixup_cat5_s2en(void)
{
	assert(opc_cat(instr->opc) == 5);
	if (!(instr->flags & IR3_INSTR_S2EN))
		return;
	/* For various reasons (ie. mainly to make the .s2en src easier to
	 * find, given that various different cat5 tex instructions can have
	 * different # of src registers), in ir3 the samp/tex src register
	 * is first, rather than last.  So we have to detect this case and
	 * fix things up.
	 */
	struct ir3_register *s2en_src = instr->srcs[instr->srcs_count - 1];

	if (instr->flags & IR3_INSTR_B)
		assert(!(s2en_src->flags & IR3_REG_HALF));
	else
		assert(s2en_src->flags & IR3_REG_HALF);

	for (int i = 0; i < instr->srcs_count - 1; i++) {
		instr->srcs[i+1] = instr->srcs[i];
	}
	instr->srcs[0] = s2en_src;
}

static void add_const(unsigned reg, unsigned c0, unsigned c1, unsigned c2, unsigned c3)
{
	struct ir3_const_state *const_state = ir3_const_state(variant);
	assert((reg & 0x7) == 0);
	int idx = reg >> (1 + 2); /* low bit is half vs full, next two bits are swiz */
	if (idx * 4 + 4 > const_state->immediates_size) {
		const_state->immediates = rerzalloc(const_state,
				const_state->immediates,
				__typeof__(const_state->immediates[0]),
				const_state->immediates_size,
				idx * 4 + 4);
		for (unsigned i = const_state->immediates_size; i < idx * 4; i++)
			const_state->immediates[i] = 0xd0d0d0d0;
		const_state->immediates_size = const_state->immediates_count = idx * 4 + 4;
	}
	const_state->immediates[idx * 4 + 0] = c0;
	const_state->immediates[idx * 4 + 1] = c1;
	const_state->immediates[idx * 4 + 2] = c2;
	const_state->immediates[idx * 4 + 3] = c3;
}

static void add_sysval(unsigned reg, unsigned compmask, gl_system_value sysval)
{
	unsigned n = variant->inputs_count++;
	variant->inputs[n].regid = reg;
	variant->inputs[n].sysval = true;
	variant->inputs[n].slot = sysval;
	variant->inputs[n].compmask = compmask;
	variant->total_in++;
}

static bool resolve_labels(void)
{
	int instr_ip = 0;
	foreach_instr (instr, &block->instr_list) {
		if (opc_cat(instr->opc) == 0 && instr->cat0.target_label) {
			struct hash_entry *entry = _mesa_hash_table_search(labels, instr->cat0.target_label);
			if (!entry) {
				fprintf(stderr, "unknown label %s\n", instr->cat0.target_label);
				return false;
			}
			int target_ip = (uintptr_t)entry->data;
			instr->cat0.immed = target_ip - instr_ip;
		}
		instr_ip++;
	}
	return true;
}

#ifdef YYDEBUG
int yydebug;
#endif

extern int yylex(void);
void ir3_yyset_lineno(int _line_number);
void ir3_yyset_input(FILE *f);

int yyparse(void);

static void yyerror(const char *error)
{
	fprintf(stderr, "error at line %d: %s\n", ir3_yyget_lineno(), error);
}

struct ir3 * ir3_parse(struct ir3_shader_variant *v,
		struct ir3_kernel_info *k, FILE *f)
{
	ir3_yyset_lineno(1);
	ir3_yyset_input(f);
#ifdef YYDEBUG
	yydebug = 1;
#endif
	info = k;
	variant = v;
	if (yyparse() || !resolve_labels()) {
		ir3_destroy(variant->ir);
		variant->ir = NULL;
	}
	ralloc_free(labels);
	ralloc_free(ir3_parser_dead_ctx);
	return variant->ir;
}

#line 339 "src/freedreno/ir3/ir3_parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "ir3_parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_INT = 3,                      /* T_INT  */
  YYSYMBOL_T_HEX = 4,                      /* T_HEX  */
  YYSYMBOL_T_FLOAT = 5,                    /* T_FLOAT  */
  YYSYMBOL_T_IDENTIFIER = 6,               /* T_IDENTIFIER  */
  YYSYMBOL_T_REGISTER = 7,                 /* T_REGISTER  */
  YYSYMBOL_T_CONSTANT = 8,                 /* T_CONSTANT  */
  YYSYMBOL_T_A_LOCALSIZE = 9,              /* T_A_LOCALSIZE  */
  YYSYMBOL_T_A_CONST = 10,                 /* T_A_CONST  */
  YYSYMBOL_T_A_BUF = 11,                   /* T_A_BUF  */
  YYSYMBOL_T_A_INVOCATIONID = 12,          /* T_A_INVOCATIONID  */
  YYSYMBOL_T_A_WGID = 13,                  /* T_A_WGID  */
  YYSYMBOL_T_A_NUMWG = 14,                 /* T_A_NUMWG  */
  YYSYMBOL_T_A_BRANCHSTACK = 15,           /* T_A_BRANCHSTACK  */
  YYSYMBOL_T_A_IN = 16,                    /* T_A_IN  */
  YYSYMBOL_T_A_OUT = 17,                   /* T_A_OUT  */
  YYSYMBOL_T_A_TEX = 18,                   /* T_A_TEX  */
  YYSYMBOL_T_A_PVTMEM = 19,                /* T_A_PVTMEM  */
  YYSYMBOL_T_ABSNEG = 20,                  /* T_ABSNEG  */
  YYSYMBOL_T_NEG = 21,                     /* T_NEG  */
  YYSYMBOL_T_ABS = 22,                     /* T_ABS  */
  YYSYMBOL_T_R = 23,                       /* T_R  */
  YYSYMBOL_T_HR = 24,                      /* T_HR  */
  YYSYMBOL_T_HC = 25,                      /* T_HC  */
  YYSYMBOL_T_EVEN = 26,                    /* T_EVEN  */
  YYSYMBOL_T_POS_INFINITY = 27,            /* T_POS_INFINITY  */
  YYSYMBOL_T_NEG_INFINITY = 28,            /* T_NEG_INFINITY  */
  YYSYMBOL_T_EI = 29,                      /* T_EI  */
  YYSYMBOL_T_WRMASK = 30,                  /* T_WRMASK  */
  YYSYMBOL_T_FLUT_0_0 = 31,                /* T_FLUT_0_0  */
  YYSYMBOL_T_FLUT_0_5 = 32,                /* T_FLUT_0_5  */
  YYSYMBOL_T_FLUT_1_0 = 33,                /* T_FLUT_1_0  */
  YYSYMBOL_T_FLUT_2_0 = 34,                /* T_FLUT_2_0  */
  YYSYMBOL_T_FLUT_E = 35,                  /* T_FLUT_E  */
  YYSYMBOL_T_FLUT_PI = 36,                 /* T_FLUT_PI  */
  YYSYMBOL_T_FLUT_INV_PI = 37,             /* T_FLUT_INV_PI  */
  YYSYMBOL_T_FLUT_INV_LOG2_E = 38,         /* T_FLUT_INV_LOG2_E  */
  YYSYMBOL_T_FLUT_LOG2_E = 39,             /* T_FLUT_LOG2_E  */
  YYSYMBOL_T_FLUT_INV_LOG2_10 = 40,        /* T_FLUT_INV_LOG2_10  */
  YYSYMBOL_T_FLUT_LOG2_10 = 41,            /* T_FLUT_LOG2_10  */
  YYSYMBOL_T_FLUT_4_0 = 42,                /* T_FLUT_4_0  */
  YYSYMBOL_T_SY = 43,                      /* T_SY  */
  YYSYMBOL_T_SS = 44,                      /* T_SS  */
  YYSYMBOL_T_JP = 45,                      /* T_JP  */
  YYSYMBOL_T_SAT = 46,                     /* T_SAT  */
  YYSYMBOL_T_RPT = 47,                     /* T_RPT  */
  YYSYMBOL_T_UL = 48,                      /* T_UL  */
  YYSYMBOL_T_NOP = 49,                     /* T_NOP  */
  YYSYMBOL_T_OP_NOP = 50,                  /* T_OP_NOP  */
  YYSYMBOL_T_OP_BR = 51,                   /* T_OP_BR  */
  YYSYMBOL_T_OP_BRAO = 52,                 /* T_OP_BRAO  */
  YYSYMBOL_T_OP_BRAA = 53,                 /* T_OP_BRAA  */
  YYSYMBOL_T_OP_BRAC = 54,                 /* T_OP_BRAC  */
  YYSYMBOL_T_OP_BANY = 55,                 /* T_OP_BANY  */
  YYSYMBOL_T_OP_BALL = 56,                 /* T_OP_BALL  */
  YYSYMBOL_T_OP_BRAX = 57,                 /* T_OP_BRAX  */
  YYSYMBOL_T_OP_JUMP = 58,                 /* T_OP_JUMP  */
  YYSYMBOL_T_OP_CALL = 59,                 /* T_OP_CALL  */
  YYSYMBOL_T_OP_RET = 60,                  /* T_OP_RET  */
  YYSYMBOL_T_OP_KILL = 61,                 /* T_OP_KILL  */
  YYSYMBOL_T_OP_END = 62,                  /* T_OP_END  */
  YYSYMBOL_T_OP_EMIT = 63,                 /* T_OP_EMIT  */
  YYSYMBOL_T_OP_CUT = 64,                  /* T_OP_CUT  */
  YYSYMBOL_T_OP_CHMASK = 65,               /* T_OP_CHMASK  */
  YYSYMBOL_T_OP_CHSH = 66,                 /* T_OP_CHSH  */
  YYSYMBOL_T_OP_FLOW_REV = 67,             /* T_OP_FLOW_REV  */
  YYSYMBOL_T_OP_BKT = 68,                  /* T_OP_BKT  */
  YYSYMBOL_T_OP_STKS = 69,                 /* T_OP_STKS  */
  YYSYMBOL_T_OP_STKR = 70,                 /* T_OP_STKR  */
  YYSYMBOL_T_OP_XSET = 71,                 /* T_OP_XSET  */
  YYSYMBOL_T_OP_XCLR = 72,                 /* T_OP_XCLR  */
  YYSYMBOL_T_OP_GETLAST = 73,              /* T_OP_GETLAST  */
  YYSYMBOL_T_OP_GETONE = 74,               /* T_OP_GETONE  */
  YYSYMBOL_T_OP_DBG = 75,                  /* T_OP_DBG  */
  YYSYMBOL_T_OP_SHPS = 76,                 /* T_OP_SHPS  */
  YYSYMBOL_T_OP_SHPE = 77,                 /* T_OP_SHPE  */
  YYSYMBOL_T_OP_PREDT = 78,                /* T_OP_PREDT  */
  YYSYMBOL_T_OP_PREDF = 79,                /* T_OP_PREDF  */
  YYSYMBOL_T_OP_PREDE = 80,                /* T_OP_PREDE  */
  YYSYMBOL_T_OP_MOVMSK = 81,               /* T_OP_MOVMSK  */
  YYSYMBOL_T_OP_MOVA1 = 82,                /* T_OP_MOVA1  */
  YYSYMBOL_T_OP_MOVA = 83,                 /* T_OP_MOVA  */
  YYSYMBOL_T_OP_MOV = 84,                  /* T_OP_MOV  */
  YYSYMBOL_T_OP_COV = 85,                  /* T_OP_COV  */
  YYSYMBOL_T_OP_SWZ = 86,                  /* T_OP_SWZ  */
  YYSYMBOL_T_OP_GAT = 87,                  /* T_OP_GAT  */
  YYSYMBOL_T_OP_SCT = 88,                  /* T_OP_SCT  */
  YYSYMBOL_T_OP_ADD_F = 89,                /* T_OP_ADD_F  */
  YYSYMBOL_T_OP_MIN_F = 90,                /* T_OP_MIN_F  */
  YYSYMBOL_T_OP_MAX_F = 91,                /* T_OP_MAX_F  */
  YYSYMBOL_T_OP_MUL_F = 92,                /* T_OP_MUL_F  */
  YYSYMBOL_T_OP_SIGN_F = 93,               /* T_OP_SIGN_F  */
  YYSYMBOL_T_OP_CMPS_F = 94,               /* T_OP_CMPS_F  */
  YYSYMBOL_T_OP_ABSNEG_F = 95,             /* T_OP_ABSNEG_F  */
  YYSYMBOL_T_OP_CMPV_F = 96,               /* T_OP_CMPV_F  */
  YYSYMBOL_T_OP_FLOOR_F = 97,              /* T_OP_FLOOR_F  */
  YYSYMBOL_T_OP_CEIL_F = 98,               /* T_OP_CEIL_F  */
  YYSYMBOL_T_OP_RNDNE_F = 99,              /* T_OP_RNDNE_F  */
  YYSYMBOL_T_OP_RNDAZ_F = 100,             /* T_OP_RNDAZ_F  */
  YYSYMBOL_T_OP_TRUNC_F = 101,             /* T_OP_TRUNC_F  */
  YYSYMBOL_T_OP_ADD_U = 102,               /* T_OP_ADD_U  */
  YYSYMBOL_T_OP_ADD_S = 103,               /* T_OP_ADD_S  */
  YYSYMBOL_T_OP_SUB_U = 104,               /* T_OP_SUB_U  */
  YYSYMBOL_T_OP_SUB_S = 105,               /* T_OP_SUB_S  */
  YYSYMBOL_T_OP_CMPS_U = 106,              /* T_OP_CMPS_U  */
  YYSYMBOL_T_OP_CMPS_S = 107,              /* T_OP_CMPS_S  */
  YYSYMBOL_T_OP_MIN_U = 108,               /* T_OP_MIN_U  */
  YYSYMBOL_T_OP_MIN_S = 109,               /* T_OP_MIN_S  */
  YYSYMBOL_T_OP_MAX_U = 110,               /* T_OP_MAX_U  */
  YYSYMBOL_T_OP_MAX_S = 111,               /* T_OP_MAX_S  */
  YYSYMBOL_T_OP_ABSNEG_S = 112,            /* T_OP_ABSNEG_S  */
  YYSYMBOL_T_OP_AND_B = 113,               /* T_OP_AND_B  */
  YYSYMBOL_T_OP_OR_B = 114,                /* T_OP_OR_B  */
  YYSYMBOL_T_OP_NOT_B = 115,               /* T_OP_NOT_B  */
  YYSYMBOL_T_OP_XOR_B = 116,               /* T_OP_XOR_B  */
  YYSYMBOL_T_OP_CMPV_U = 117,              /* T_OP_CMPV_U  */
  YYSYMBOL_T_OP_CMPV_S = 118,              /* T_OP_CMPV_S  */
  YYSYMBOL_T_OP_MUL_U24 = 119,             /* T_OP_MUL_U24  */
  YYSYMBOL_T_OP_MUL_S24 = 120,             /* T_OP_MUL_S24  */
  YYSYMBOL_T_OP_MULL_U = 121,              /* T_OP_MULL_U  */
  YYSYMBOL_T_OP_BFREV_B = 122,             /* T_OP_BFREV_B  */
  YYSYMBOL_T_OP_CLZ_S = 123,               /* T_OP_CLZ_S  */
  YYSYMBOL_T_OP_CLZ_B = 124,               /* T_OP_CLZ_B  */
  YYSYMBOL_T_OP_SHL_B = 125,               /* T_OP_SHL_B  */
  YYSYMBOL_T_OP_SHR_B = 126,               /* T_OP_SHR_B  */
  YYSYMBOL_T_OP_ASHR_B = 127,              /* T_OP_ASHR_B  */
  YYSYMBOL_T_OP_BARY_F = 128,              /* T_OP_BARY_F  */
  YYSYMBOL_T_OP_FLAT_B = 129,              /* T_OP_FLAT_B  */
  YYSYMBOL_T_OP_MGEN_B = 130,              /* T_OP_MGEN_B  */
  YYSYMBOL_T_OP_GETBIT_B = 131,            /* T_OP_GETBIT_B  */
  YYSYMBOL_T_OP_SETRM = 132,               /* T_OP_SETRM  */
  YYSYMBOL_T_OP_CBITS_B = 133,             /* T_OP_CBITS_B  */
  YYSYMBOL_T_OP_SHB = 134,                 /* T_OP_SHB  */
  YYSYMBOL_T_OP_MSAD = 135,                /* T_OP_MSAD  */
  YYSYMBOL_T_OP_MAD_U16 = 136,             /* T_OP_MAD_U16  */
  YYSYMBOL_T_OP_MADSH_U16 = 137,           /* T_OP_MADSH_U16  */
  YYSYMBOL_T_OP_MAD_S16 = 138,             /* T_OP_MAD_S16  */
  YYSYMBOL_T_OP_MADSH_M16 = 139,           /* T_OP_MADSH_M16  */
  YYSYMBOL_T_OP_MAD_U24 = 140,             /* T_OP_MAD_U24  */
  YYSYMBOL_T_OP_MAD_S24 = 141,             /* T_OP_MAD_S24  */
  YYSYMBOL_T_OP_MAD_F16 = 142,             /* T_OP_MAD_F16  */
  YYSYMBOL_T_OP_MAD_F32 = 143,             /* T_OP_MAD_F32  */
  YYSYMBOL_T_OP_SEL_B16 = 144,             /* T_OP_SEL_B16  */
  YYSYMBOL_T_OP_SEL_B32 = 145,             /* T_OP_SEL_B32  */
  YYSYMBOL_T_OP_SEL_S16 = 146,             /* T_OP_SEL_S16  */
  YYSYMBOL_T_OP_SEL_S32 = 147,             /* T_OP_SEL_S32  */
  YYSYMBOL_T_OP_SEL_F16 = 148,             /* T_OP_SEL_F16  */
  YYSYMBOL_T_OP_SEL_F32 = 149,             /* T_OP_SEL_F32  */
  YYSYMBOL_T_OP_SAD_S16 = 150,             /* T_OP_SAD_S16  */
  YYSYMBOL_T_OP_SAD_S32 = 151,             /* T_OP_SAD_S32  */
  YYSYMBOL_T_OP_SHRM = 152,                /* T_OP_SHRM  */
  YYSYMBOL_T_OP_SHLM = 153,                /* T_OP_SHLM  */
  YYSYMBOL_T_OP_SHRG = 154,                /* T_OP_SHRG  */
  YYSYMBOL_T_OP_SHLG = 155,                /* T_OP_SHLG  */
  YYSYMBOL_T_OP_ANDG = 156,                /* T_OP_ANDG  */
  YYSYMBOL_T_OP_DP2ACC = 157,              /* T_OP_DP2ACC  */
  YYSYMBOL_T_OP_DP4ACC = 158,              /* T_OP_DP4ACC  */
  YYSYMBOL_T_OP_WMM = 159,                 /* T_OP_WMM  */
  YYSYMBOL_T_OP_WMM_ACCU = 160,            /* T_OP_WMM_ACCU  */
  YYSYMBOL_T_OP_RCP = 161,                 /* T_OP_RCP  */
  YYSYMBOL_T_OP_RSQ = 162,                 /* T_OP_RSQ  */
  YYSYMBOL_T_OP_LOG2 = 163,                /* T_OP_LOG2  */
  YYSYMBOL_T_OP_EXP2 = 164,                /* T_OP_EXP2  */
  YYSYMBOL_T_OP_SIN = 165,                 /* T_OP_SIN  */
  YYSYMBOL_T_OP_COS = 166,                 /* T_OP_COS  */
  YYSYMBOL_T_OP_SQRT = 167,                /* T_OP_SQRT  */
  YYSYMBOL_T_OP_HRSQ = 168,                /* T_OP_HRSQ  */
  YYSYMBOL_T_OP_HLOG2 = 169,               /* T_OP_HLOG2  */
  YYSYMBOL_T_OP_HEXP2 = 170,               /* T_OP_HEXP2  */
  YYSYMBOL_T_OP_ISAM = 171,                /* T_OP_ISAM  */
  YYSYMBOL_T_OP_ISAML = 172,               /* T_OP_ISAML  */
  YYSYMBOL_T_OP_ISAMM = 173,               /* T_OP_ISAMM  */
  YYSYMBOL_T_OP_SAM = 174,                 /* T_OP_SAM  */
  YYSYMBOL_T_OP_SAMB = 175,                /* T_OP_SAMB  */
  YYSYMBOL_T_OP_SAML = 176,                /* T_OP_SAML  */
  YYSYMBOL_T_OP_SAMGQ = 177,               /* T_OP_SAMGQ  */
  YYSYMBOL_T_OP_GETLOD = 178,              /* T_OP_GETLOD  */
  YYSYMBOL_T_OP_CONV = 179,                /* T_OP_CONV  */
  YYSYMBOL_T_OP_CONVM = 180,               /* T_OP_CONVM  */
  YYSYMBOL_T_OP_GETSIZE = 181,             /* T_OP_GETSIZE  */
  YYSYMBOL_T_OP_GETBUF = 182,              /* T_OP_GETBUF  */
  YYSYMBOL_T_OP_GETPOS = 183,              /* T_OP_GETPOS  */
  YYSYMBOL_T_OP_GETINFO = 184,             /* T_OP_GETINFO  */
  YYSYMBOL_T_OP_DSX = 185,                 /* T_OP_DSX  */
  YYSYMBOL_T_OP_DSY = 186,                 /* T_OP_DSY  */
  YYSYMBOL_T_OP_GATHER4R = 187,            /* T_OP_GATHER4R  */
  YYSYMBOL_T_OP_GATHER4G = 188,            /* T_OP_GATHER4G  */
  YYSYMBOL_T_OP_GATHER4B = 189,            /* T_OP_GATHER4B  */
  YYSYMBOL_T_OP_GATHER4A = 190,            /* T_OP_GATHER4A  */
  YYSYMBOL_T_OP_SAMGP0 = 191,              /* T_OP_SAMGP0  */
  YYSYMBOL_T_OP_SAMGP1 = 192,              /* T_OP_SAMGP1  */
  YYSYMBOL_T_OP_SAMGP2 = 193,              /* T_OP_SAMGP2  */
  YYSYMBOL_T_OP_SAMGP3 = 194,              /* T_OP_SAMGP3  */
  YYSYMBOL_T_OP_DSXPP_1 = 195,             /* T_OP_DSXPP_1  */
  YYSYMBOL_T_OP_DSYPP_1 = 196,             /* T_OP_DSYPP_1  */
  YYSYMBOL_T_OP_RGETPOS = 197,             /* T_OP_RGETPOS  */
  YYSYMBOL_T_OP_RGETINFO = 198,            /* T_OP_RGETINFO  */
  YYSYMBOL_T_OP_BRCST_A = 199,             /* T_OP_BRCST_A  */
  YYSYMBOL_T_OP_QSHUFFLE_BRCST = 200,      /* T_OP_QSHUFFLE_BRCST  */
  YYSYMBOL_T_OP_QSHUFFLE_H = 201,          /* T_OP_QSHUFFLE_H  */
  YYSYMBOL_T_OP_QSHUFFLE_V = 202,          /* T_OP_QSHUFFLE_V  */
  YYSYMBOL_T_OP_QSHUFFLE_DIAG = 203,       /* T_OP_QSHUFFLE_DIAG  */
  YYSYMBOL_T_OP_LDG = 204,                 /* T_OP_LDG  */
  YYSYMBOL_T_OP_LDG_A = 205,               /* T_OP_LDG_A  */
  YYSYMBOL_T_OP_LDL = 206,                 /* T_OP_LDL  */
  YYSYMBOL_T_OP_LDP = 207,                 /* T_OP_LDP  */
  YYSYMBOL_T_OP_STG = 208,                 /* T_OP_STG  */
  YYSYMBOL_T_OP_STG_A = 209,               /* T_OP_STG_A  */
  YYSYMBOL_T_OP_STL = 210,                 /* T_OP_STL  */
  YYSYMBOL_T_OP_STP = 211,                 /* T_OP_STP  */
  YYSYMBOL_T_OP_LDIB = 212,                /* T_OP_LDIB  */
  YYSYMBOL_T_OP_G2L = 213,                 /* T_OP_G2L  */
  YYSYMBOL_T_OP_L2G = 214,                 /* T_OP_L2G  */
  YYSYMBOL_T_OP_PREFETCH = 215,            /* T_OP_PREFETCH  */
  YYSYMBOL_T_OP_LDLW = 216,                /* T_OP_LDLW  */
  YYSYMBOL_T_OP_STLW = 217,                /* T_OP_STLW  */
  YYSYMBOL_T_OP_RESFMT = 218,              /* T_OP_RESFMT  */
  YYSYMBOL_T_OP_RESINFO = 219,             /* T_OP_RESINFO  */
  YYSYMBOL_T_OP_ATOMIC_ADD = 220,          /* T_OP_ATOMIC_ADD  */
  YYSYMBOL_T_OP_ATOMIC_SUB = 221,          /* T_OP_ATOMIC_SUB  */
  YYSYMBOL_T_OP_ATOMIC_XCHG = 222,         /* T_OP_ATOMIC_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_INC = 223,          /* T_OP_ATOMIC_INC  */
  YYSYMBOL_T_OP_ATOMIC_DEC = 224,          /* T_OP_ATOMIC_DEC  */
  YYSYMBOL_T_OP_ATOMIC_CMPXCHG = 225,      /* T_OP_ATOMIC_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_MIN = 226,          /* T_OP_ATOMIC_MIN  */
  YYSYMBOL_T_OP_ATOMIC_MAX = 227,          /* T_OP_ATOMIC_MAX  */
  YYSYMBOL_T_OP_ATOMIC_AND = 228,          /* T_OP_ATOMIC_AND  */
  YYSYMBOL_T_OP_ATOMIC_OR = 229,           /* T_OP_ATOMIC_OR  */
  YYSYMBOL_T_OP_ATOMIC_XOR = 230,          /* T_OP_ATOMIC_XOR  */
  YYSYMBOL_T_OP_RESINFO_B = 231,           /* T_OP_RESINFO_B  */
  YYSYMBOL_T_OP_LDIB_B = 232,              /* T_OP_LDIB_B  */
  YYSYMBOL_T_OP_STIB_B = 233,              /* T_OP_STIB_B  */
  YYSYMBOL_T_OP_ATOMIC_B_ADD = 234,        /* T_OP_ATOMIC_B_ADD  */
  YYSYMBOL_T_OP_ATOMIC_B_SUB = 235,        /* T_OP_ATOMIC_B_SUB  */
  YYSYMBOL_T_OP_ATOMIC_B_XCHG = 236,       /* T_OP_ATOMIC_B_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_B_INC = 237,        /* T_OP_ATOMIC_B_INC  */
  YYSYMBOL_T_OP_ATOMIC_B_DEC = 238,        /* T_OP_ATOMIC_B_DEC  */
  YYSYMBOL_T_OP_ATOMIC_B_CMPXCHG = 239,    /* T_OP_ATOMIC_B_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_B_MIN = 240,        /* T_OP_ATOMIC_B_MIN  */
  YYSYMBOL_T_OP_ATOMIC_B_MAX = 241,        /* T_OP_ATOMIC_B_MAX  */
  YYSYMBOL_T_OP_ATOMIC_B_AND = 242,        /* T_OP_ATOMIC_B_AND  */
  YYSYMBOL_T_OP_ATOMIC_B_OR = 243,         /* T_OP_ATOMIC_B_OR  */
  YYSYMBOL_T_OP_ATOMIC_B_XOR = 244,        /* T_OP_ATOMIC_B_XOR  */
  YYSYMBOL_T_OP_ATOMIC_S_ADD = 245,        /* T_OP_ATOMIC_S_ADD  */
  YYSYMBOL_T_OP_ATOMIC_S_SUB = 246,        /* T_OP_ATOMIC_S_SUB  */
  YYSYMBOL_T_OP_ATOMIC_S_XCHG = 247,       /* T_OP_ATOMIC_S_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_S_INC = 248,        /* T_OP_ATOMIC_S_INC  */
  YYSYMBOL_T_OP_ATOMIC_S_DEC = 249,        /* T_OP_ATOMIC_S_DEC  */
  YYSYMBOL_T_OP_ATOMIC_S_CMPXCHG = 250,    /* T_OP_ATOMIC_S_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_S_MIN = 251,        /* T_OP_ATOMIC_S_MIN  */
  YYSYMBOL_T_OP_ATOMIC_S_MAX = 252,        /* T_OP_ATOMIC_S_MAX  */
  YYSYMBOL_T_OP_ATOMIC_S_AND = 253,        /* T_OP_ATOMIC_S_AND  */
  YYSYMBOL_T_OP_ATOMIC_S_OR = 254,         /* T_OP_ATOMIC_S_OR  */
  YYSYMBOL_T_OP_ATOMIC_S_XOR = 255,        /* T_OP_ATOMIC_S_XOR  */
  YYSYMBOL_T_OP_ATOMIC_G_ADD = 256,        /* T_OP_ATOMIC_G_ADD  */
  YYSYMBOL_T_OP_ATOMIC_G_SUB = 257,        /* T_OP_ATOMIC_G_SUB  */
  YYSYMBOL_T_OP_ATOMIC_G_XCHG = 258,       /* T_OP_ATOMIC_G_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_G_INC = 259,        /* T_OP_ATOMIC_G_INC  */
  YYSYMBOL_T_OP_ATOMIC_G_DEC = 260,        /* T_OP_ATOMIC_G_DEC  */
  YYSYMBOL_T_OP_ATOMIC_G_CMPXCHG = 261,    /* T_OP_ATOMIC_G_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_G_MIN = 262,        /* T_OP_ATOMIC_G_MIN  */
  YYSYMBOL_T_OP_ATOMIC_G_MAX = 263,        /* T_OP_ATOMIC_G_MAX  */
  YYSYMBOL_T_OP_ATOMIC_G_AND = 264,        /* T_OP_ATOMIC_G_AND  */
  YYSYMBOL_T_OP_ATOMIC_G_OR = 265,         /* T_OP_ATOMIC_G_OR  */
  YYSYMBOL_T_OP_ATOMIC_G_XOR = 266,        /* T_OP_ATOMIC_G_XOR  */
  YYSYMBOL_T_OP_LDGB = 267,                /* T_OP_LDGB  */
  YYSYMBOL_T_OP_STGB = 268,                /* T_OP_STGB  */
  YYSYMBOL_T_OP_STIB = 269,                /* T_OP_STIB  */
  YYSYMBOL_T_OP_LDC = 270,                 /* T_OP_LDC  */
  YYSYMBOL_T_OP_LDLV = 271,                /* T_OP_LDLV  */
  YYSYMBOL_T_OP_GETSPID = 272,             /* T_OP_GETSPID  */
  YYSYMBOL_T_OP_GETWID = 273,              /* T_OP_GETWID  */
  YYSYMBOL_T_OP_GETFIBERID = 274,          /* T_OP_GETFIBERID  */
  YYSYMBOL_T_OP_BAR = 275,                 /* T_OP_BAR  */
  YYSYMBOL_T_OP_FENCE = 276,               /* T_OP_FENCE  */
  YYSYMBOL_T_TYPE_F16 = 277,               /* T_TYPE_F16  */
  YYSYMBOL_T_TYPE_F32 = 278,               /* T_TYPE_F32  */
  YYSYMBOL_T_TYPE_U16 = 279,               /* T_TYPE_U16  */
  YYSYMBOL_T_TYPE_U32 = 280,               /* T_TYPE_U32  */
  YYSYMBOL_T_TYPE_S16 = 281,               /* T_TYPE_S16  */
  YYSYMBOL_T_TYPE_S32 = 282,               /* T_TYPE_S32  */
  YYSYMBOL_T_TYPE_U8 = 283,                /* T_TYPE_U8  */
  YYSYMBOL_T_TYPE_S8 = 284,                /* T_TYPE_S8  */
  YYSYMBOL_T_UNTYPED = 285,                /* T_UNTYPED  */
  YYSYMBOL_T_TYPED = 286,                  /* T_TYPED  */
  YYSYMBOL_T_MIXED = 287,                  /* T_MIXED  */
  YYSYMBOL_T_UNSIGNED = 288,               /* T_UNSIGNED  */
  YYSYMBOL_T_LOW = 289,                    /* T_LOW  */
  YYSYMBOL_T_HIGH = 290,                   /* T_HIGH  */
  YYSYMBOL_T_1D = 291,                     /* T_1D  */
  YYSYMBOL_T_2D = 292,                     /* T_2D  */
  YYSYMBOL_T_3D = 293,                     /* T_3D  */
  YYSYMBOL_T_4D = 294,                     /* T_4D  */
  YYSYMBOL_T_LT = 295,                     /* T_LT  */
  YYSYMBOL_T_LE = 296,                     /* T_LE  */
  YYSYMBOL_T_GT = 297,                     /* T_GT  */
  YYSYMBOL_T_GE = 298,                     /* T_GE  */
  YYSYMBOL_T_EQ = 299,                     /* T_EQ  */
  YYSYMBOL_T_NE = 300,                     /* T_NE  */
  YYSYMBOL_T_S2EN = 301,                   /* T_S2EN  */
  YYSYMBOL_T_SAMP = 302,                   /* T_SAMP  */
  YYSYMBOL_T_TEX = 303,                    /* T_TEX  */
  YYSYMBOL_T_BASE = 304,                   /* T_BASE  */
  YYSYMBOL_T_OFFSET = 305,                 /* T_OFFSET  */
  YYSYMBOL_T_UNIFORM = 306,                /* T_UNIFORM  */
  YYSYMBOL_T_NONUNIFORM = 307,             /* T_NONUNIFORM  */
  YYSYMBOL_T_IMM = 308,                    /* T_IMM  */
  YYSYMBOL_T_NAN = 309,                    /* T_NAN  */
  YYSYMBOL_T_INF = 310,                    /* T_INF  */
  YYSYMBOL_T_A0 = 311,                     /* T_A0  */
  YYSYMBOL_T_A1 = 312,                     /* T_A1  */
  YYSYMBOL_T_P0 = 313,                     /* T_P0  */
  YYSYMBOL_T_W = 314,                      /* T_W  */
  YYSYMBOL_T_CAT1_TYPE_TYPE = 315,         /* T_CAT1_TYPE_TYPE  */
  YYSYMBOL_316_ = 316,                     /* '-'  */
  YYSYMBOL_317_ = 317,                     /* ','  */
  YYSYMBOL_318_ = 318,                     /* '('  */
  YYSYMBOL_319_ = 319,                     /* ')'  */
  YYSYMBOL_320_ = 320,                     /* '='  */
  YYSYMBOL_321_ = 321,                     /* ':'  */
  YYSYMBOL_322_ = 322,                     /* '!'  */
  YYSYMBOL_323_ = 323,                     /* '#'  */
  YYSYMBOL_324_ = 324,                     /* '.'  */
  YYSYMBOL_325_a_ = 325,                   /* 'a'  */
  YYSYMBOL_326_o_ = 326,                   /* 'o'  */
  YYSYMBOL_327_p_ = 327,                   /* 'p'  */
  YYSYMBOL_328_s_ = 328,                   /* 's'  */
  YYSYMBOL_329_ = 329,                     /* '+'  */
  YYSYMBOL_330_ = 330,                     /* '<'  */
  YYSYMBOL_331_g_ = 331,                   /* 'g'  */
  YYSYMBOL_332_ = 332,                     /* '['  */
  YYSYMBOL_333_ = 333,                     /* ']'  */
  YYSYMBOL_334_l_ = 334,                   /* 'l'  */
  YYSYMBOL_335_w_ = 335,                   /* 'w'  */
  YYSYMBOL_336_r_ = 336,                   /* 'r'  */
  YYSYMBOL_337_ = 337,                     /* '>'  */
  YYSYMBOL_338_c_ = 338,                   /* 'c'  */
  YYSYMBOL_339_h_ = 339,                   /* 'h'  */
  YYSYMBOL_YYACCEPT = 340,                 /* $accept  */
  YYSYMBOL_shader = 341,                   /* shader  */
  YYSYMBOL_342_1 = 342,                    /* $@1  */
  YYSYMBOL_headers = 343,                  /* headers  */
  YYSYMBOL_header = 344,                   /* header  */
  YYSYMBOL_const_val = 345,                /* const_val  */
  YYSYMBOL_localsize_header = 346,         /* localsize_header  */
  YYSYMBOL_const_header = 347,             /* const_header  */
  YYSYMBOL_buf_header_addr_reg = 348,      /* buf_header_addr_reg  */
  YYSYMBOL_buf_header = 349,               /* buf_header  */
  YYSYMBOL_350_2 = 350,                    /* $@2  */
  YYSYMBOL_invocationid_header = 351,      /* invocationid_header  */
  YYSYMBOL_wgid_header = 352,              /* wgid_header  */
  YYSYMBOL_numwg_header = 353,             /* numwg_header  */
  YYSYMBOL_branchstack_header = 354,       /* branchstack_header  */
  YYSYMBOL_pvtmem_header = 355,            /* pvtmem_header  */
  YYSYMBOL_in_header = 356,                /* in_header  */
  YYSYMBOL_out_header = 357,               /* out_header  */
  YYSYMBOL_tex_header = 358,               /* tex_header  */
  YYSYMBOL_iflag = 359,                    /* iflag  */
  YYSYMBOL_iflags = 360,                   /* iflags  */
  YYSYMBOL_instrs = 361,                   /* instrs  */
  YYSYMBOL_instr = 362,                    /* instr  */
  YYSYMBOL_label = 363,                    /* label  */
  YYSYMBOL_cat0_src1 = 364,                /* cat0_src1  */
  YYSYMBOL_cat0_src2 = 365,                /* cat0_src2  */
  YYSYMBOL_cat0_immed = 366,               /* cat0_immed  */
  YYSYMBOL_cat0_instr = 367,               /* cat0_instr  */
  YYSYMBOL_368_3 = 368,                    /* $@3  */
  YYSYMBOL_369_4 = 369,                    /* $@4  */
  YYSYMBOL_370_5 = 370,                    /* $@5  */
  YYSYMBOL_371_6 = 371,                    /* $@6  */
  YYSYMBOL_372_7 = 372,                    /* $@7  */
  YYSYMBOL_373_8 = 373,                    /* $@8  */
  YYSYMBOL_374_9 = 374,                    /* $@9  */
  YYSYMBOL_375_10 = 375,                   /* $@10  */
  YYSYMBOL_376_11 = 376,                   /* $@11  */
  YYSYMBOL_377_12 = 377,                   /* $@12  */
  YYSYMBOL_378_13 = 378,                   /* $@13  */
  YYSYMBOL_379_14 = 379,                   /* $@14  */
  YYSYMBOL_380_15 = 380,                   /* $@15  */
  YYSYMBOL_381_16 = 381,                   /* $@16  */
  YYSYMBOL_382_17 = 382,                   /* $@17  */
  YYSYMBOL_383_18 = 383,                   /* $@18  */
  YYSYMBOL_cat1_opc = 384,                 /* cat1_opc  */
  YYSYMBOL_cat1_src = 385,                 /* cat1_src  */
  YYSYMBOL_cat1_movmsk = 386,              /* cat1_movmsk  */
  YYSYMBOL_387_19 = 387,                   /* $@19  */
  YYSYMBOL_cat1_mova1 = 388,               /* cat1_mova1  */
  YYSYMBOL_389_20 = 389,                   /* $@20  */
  YYSYMBOL_cat1_mova = 390,                /* cat1_mova  */
  YYSYMBOL_391_21 = 391,                   /* $@21  */
  YYSYMBOL_cat1_swz = 392,                 /* cat1_swz  */
  YYSYMBOL_393_22 = 393,                   /* $@22  */
  YYSYMBOL_cat1_gat = 394,                 /* cat1_gat  */
  YYSYMBOL_395_23 = 395,                   /* $@23  */
  YYSYMBOL_cat1_sct = 396,                 /* cat1_sct  */
  YYSYMBOL_397_24 = 397,                   /* $@24  */
  YYSYMBOL_cat1_instr = 398,               /* cat1_instr  */
  YYSYMBOL_cat2_opc_1src = 399,            /* cat2_opc_1src  */
  YYSYMBOL_cat2_opc_2src_cnd = 400,        /* cat2_opc_2src_cnd  */
  YYSYMBOL_cat2_opc_2src = 401,            /* cat2_opc_2src  */
  YYSYMBOL_cond = 402,                     /* cond  */
  YYSYMBOL_cat2_instr = 403,               /* cat2_instr  */
  YYSYMBOL_cat3_dp_signedness = 404,       /* cat3_dp_signedness  */
  YYSYMBOL_cat3_dp_pack = 405,             /* cat3_dp_pack  */
  YYSYMBOL_cat3_opc = 406,                 /* cat3_opc  */
  YYSYMBOL_cat3_imm_reg_opc = 407,         /* cat3_imm_reg_opc  */
  YYSYMBOL_cat3_wmm = 408,                 /* cat3_wmm  */
  YYSYMBOL_cat3_dp = 409,                  /* cat3_dp  */
  YYSYMBOL_cat3_instr = 410,               /* cat3_instr  */
  YYSYMBOL_cat4_opc = 411,                 /* cat4_opc  */
  YYSYMBOL_cat4_instr = 412,               /* cat4_instr  */
  YYSYMBOL_cat5_opc_dsxypp = 413,          /* cat5_opc_dsxypp  */
  YYSYMBOL_cat5_opc = 414,                 /* cat5_opc  */
  YYSYMBOL_cat5_flag = 415,                /* cat5_flag  */
  YYSYMBOL_cat5_flags = 416,               /* cat5_flags  */
  YYSYMBOL_cat5_samp = 417,                /* cat5_samp  */
  YYSYMBOL_cat5_tex = 418,                 /* cat5_tex  */
  YYSYMBOL_cat5_type = 419,                /* cat5_type  */
  YYSYMBOL_cat5_a1 = 420,                  /* cat5_a1  */
  YYSYMBOL_cat5_instr = 421,               /* cat5_instr  */
  YYSYMBOL_cat6_typed = 422,               /* cat6_typed  */
  YYSYMBOL_cat6_dim = 423,                 /* cat6_dim  */
  YYSYMBOL_cat6_type = 424,                /* cat6_type  */
  YYSYMBOL_cat6_imm_offset = 425,          /* cat6_imm_offset  */
  YYSYMBOL_cat6_offset = 426,              /* cat6_offset  */
  YYSYMBOL_cat6_dst_offset = 427,          /* cat6_dst_offset  */
  YYSYMBOL_cat6_immed = 428,               /* cat6_immed  */
  YYSYMBOL_cat6_stg_ldg_a6xx_offset = 429, /* cat6_stg_ldg_a6xx_offset  */
  YYSYMBOL_cat6_load = 430,                /* cat6_load  */
  YYSYMBOL_431_25 = 431,                   /* $@25  */
  YYSYMBOL_432_26 = 432,                   /* $@26  */
  YYSYMBOL_433_27 = 433,                   /* $@27  */
  YYSYMBOL_434_28 = 434,                   /* $@28  */
  YYSYMBOL_435_29 = 435,                   /* $@29  */
  YYSYMBOL_436_30 = 436,                   /* $@30  */
  YYSYMBOL_437_31 = 437,                   /* $@31  */
  YYSYMBOL_cat6_store = 438,               /* cat6_store  */
  YYSYMBOL_439_32 = 439,                   /* $@32  */
  YYSYMBOL_440_33 = 440,                   /* $@33  */
  YYSYMBOL_441_34 = 441,                   /* $@34  */
  YYSYMBOL_442_35 = 442,                   /* $@35  */
  YYSYMBOL_443_36 = 443,                   /* $@36  */
  YYSYMBOL_cat6_loadib = 444,              /* cat6_loadib  */
  YYSYMBOL_445_37 = 445,                   /* $@37  */
  YYSYMBOL_cat6_storeib = 446,             /* cat6_storeib  */
  YYSYMBOL_447_38 = 447,                   /* $@38  */
  YYSYMBOL_cat6_prefetch = 448,            /* cat6_prefetch  */
  YYSYMBOL_449_39 = 449,                   /* $@39  */
  YYSYMBOL_cat6_atomic_opc = 450,          /* cat6_atomic_opc  */
  YYSYMBOL_cat6_a3xx_atomic_opc = 451,     /* cat6_a3xx_atomic_opc  */
  YYSYMBOL_cat6_a6xx_atomic_opc = 452,     /* cat6_a6xx_atomic_opc  */
  YYSYMBOL_cat6_a3xx_atomic_s = 453,       /* cat6_a3xx_atomic_s  */
  YYSYMBOL_cat6_a6xx_atomic_g = 454,       /* cat6_a6xx_atomic_g  */
  YYSYMBOL_cat6_atomic_l = 455,            /* cat6_atomic_l  */
  YYSYMBOL_cat6_atomic = 456,              /* cat6_atomic  */
  YYSYMBOL_cat6_ibo_opc_1src = 457,        /* cat6_ibo_opc_1src  */
  YYSYMBOL_cat6_ibo_opc_ldgb = 458,        /* cat6_ibo_opc_ldgb  */
  YYSYMBOL_cat6_ibo_opc_stgb = 459,        /* cat6_ibo_opc_stgb  */
  YYSYMBOL_cat6_ibo = 460,                 /* cat6_ibo  */
  YYSYMBOL_461_40 = 461,                   /* $@40  */
  YYSYMBOL_cat6_id_opc = 462,              /* cat6_id_opc  */
  YYSYMBOL_cat6_id = 463,                  /* cat6_id  */
  YYSYMBOL_cat6_bindless_base = 464,       /* cat6_bindless_base  */
  YYSYMBOL_cat6_bindless_mode = 465,       /* cat6_bindless_mode  */
  YYSYMBOL_cat6_reg_or_immed = 466,        /* cat6_reg_or_immed  */
  YYSYMBOL_cat6_bindless_ibo_opc_1src = 467, /* cat6_bindless_ibo_opc_1src  */
  YYSYMBOL_cat6_bindless_ibo_opc_2src = 468, /* cat6_bindless_ibo_opc_2src  */
  YYSYMBOL_cat6_bindless_ibo_opc_2src_dst = 469, /* cat6_bindless_ibo_opc_2src_dst  */
  YYSYMBOL_cat6_bindless_ibo = 470,        /* cat6_bindless_ibo  */
  YYSYMBOL_cat6_bindless_ldc_opc = 471,    /* cat6_bindless_ldc_opc  */
  YYSYMBOL_cat6_bindless_ldc = 472,        /* cat6_bindless_ldc  */
  YYSYMBOL_cat6_todo = 473,                /* cat6_todo  */
  YYSYMBOL_cat6_instr = 474,               /* cat6_instr  */
  YYSYMBOL_cat7_scope = 475,               /* cat7_scope  */
  YYSYMBOL_cat7_scopes = 476,              /* cat7_scopes  */
  YYSYMBOL_cat7_barrier = 477,             /* cat7_barrier  */
  YYSYMBOL_478_41 = 478,                   /* $@41  */
  YYSYMBOL_479_42 = 479,                   /* $@42  */
  YYSYMBOL_cat7_instr = 480,               /* cat7_instr  */
  YYSYMBOL_src = 481,                      /* src  */
  YYSYMBOL_dst = 482,                      /* dst  */
  YYSYMBOL_const = 483,                    /* const  */
  YYSYMBOL_dst_reg_flag = 484,             /* dst_reg_flag  */
  YYSYMBOL_dst_reg_flags = 485,            /* dst_reg_flags  */
  YYSYMBOL_dst_reg = 486,                  /* dst_reg  */
  YYSYMBOL_src_reg_flag = 487,             /* src_reg_flag  */
  YYSYMBOL_src_reg_flags = 488,            /* src_reg_flags  */
  YYSYMBOL_src_reg = 489,                  /* src_reg  */
  YYSYMBOL_src_reg_gpr = 490,              /* src_reg_gpr  */
  YYSYMBOL_src_const = 491,                /* src_const  */
  YYSYMBOL_src_reg_or_const = 492,         /* src_reg_or_const  */
  YYSYMBOL_src_reg_or_const_or_rel = 493,  /* src_reg_or_const_or_rel  */
  YYSYMBOL_src_reg_or_const_or_rel_or_imm = 494, /* src_reg_or_const_or_rel_or_imm  */
  YYSYMBOL_src_reg_or_rel_or_imm = 495,    /* src_reg_or_rel_or_imm  */
  YYSYMBOL_offset = 496,                   /* offset  */
  YYSYMBOL_relative_gpr_src = 497,         /* relative_gpr_src  */
  YYSYMBOL_relative_gpr_dst = 498,         /* relative_gpr_dst  */
  YYSYMBOL_relative_const = 499,           /* relative_const  */
  YYSYMBOL_relative = 500,                 /* relative  */
  YYSYMBOL_immediate_cat1 = 501,           /* immediate_cat1  */
  YYSYMBOL_immediate = 502,                /* immediate  */
  YYSYMBOL_flut_immed = 503,               /* flut_immed  */
  YYSYMBOL_integer = 504,                  /* integer  */
  YYSYMBOL_float = 505,                    /* float  */
  YYSYMBOL_type = 506                      /* type  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 307 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"

#if YYDEBUG
static void print_token(FILE *file, int type, YYSTYPE value)
{
	fprintf(file, "\ntype: %d\n", type);
}

#define YYPRINT(file, type, value) print_token(file, type, value)
#endif

#line 890 "src/freedreno/ir3/ir3_parser.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1347

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  340
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  167
/* YYNRULES -- Number of rules.  */
#define YYNRULES  532
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1108

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   570


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   322,     2,   323,     2,     2,     2,     2,
     318,   319,     2,   329,   317,   316,   324,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   321,     2,
     330,   320,   337,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   332,     2,   333,     2,     2,     2,   325,     2,   338,
       2,     2,     2,   331,   339,     2,     2,     2,   334,     2,
       2,   326,   327,     2,   336,   328,     2,     2,     2,   335,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   687,   687,   687,   689,   690,   692,   693,   694,   695,
     696,   697,   698,   699,   700,   701,   702,   704,   705,   706,
     707,   709,   715,   720,   728,   730,   730,   736,   742,   749,
     756,   765,   767,   770,   772,   774,   781,   782,   783,   784,
     785,   786,   787,   789,   790,   792,   793,   795,   796,   797,
     798,   799,   800,   801,   802,   803,   805,   807,   808,   810,
     811,   813,   814,   816,   817,   817,   818,   818,   819,   819,
     820,   820,   821,   821,   822,   822,   823,   823,   824,   824,
     825,   825,   826,   827,   827,   828,   829,   830,   831,   832,
     833,   834,   834,   835,   836,   837,   838,   839,   839,   840,
     841,   841,   842,   843,   843,   844,   844,   845,   846,   846,
     848,   851,   855,   856,   858,   858,   874,   874,   881,   881,
     888,   888,   890,   890,   892,   892,   895,   896,   897,   898,
     899,   900,   901,   902,   904,   905,   906,   907,   908,   909,
     910,   911,   912,   913,   914,   915,   916,   917,   919,   920,
     921,   922,   923,   924,   926,   927,   928,   929,   930,   931,
     932,   933,   934,   935,   936,   937,   938,   939,   940,   941,
     942,   943,   944,   945,   946,   947,   948,   949,   950,   951,
     952,   954,   955,   956,   957,   958,   959,   961,   962,   963,
     965,   966,   968,   969,   971,   972,   973,   974,   975,   976,
     977,   978,   979,   980,   981,   982,   983,   984,   985,   986,
     988,   989,   990,   991,   992,   994,   995,   997,   998,  1000,
    1001,  1002,  1003,  1005,  1006,  1007,  1008,  1009,  1010,  1011,
    1012,  1013,  1014,  1016,  1018,  1019,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1053,  1054,  1055,
    1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,  1066,
    1067,  1068,  1069,  1071,  1072,  1073,  1074,  1075,  1076,  1077,
    1078,  1079,  1080,  1081,  1082,  1083,  1084,  1085,  1087,  1088,
    1090,  1091,  1092,  1093,  1095,  1096,  1097,  1098,  1099,  1100,
    1102,  1105,  1110,  1116,  1116,  1117,  1117,  1118,  1118,  1119,
    1119,  1120,  1120,  1121,  1121,  1121,  1125,  1125,  1126,  1126,
    1127,  1127,  1128,  1128,  1129,  1129,  1131,  1131,  1132,  1132,
    1134,  1134,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,
    1144,  1145,  1146,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1160,  1161,  1162,  1163,  1164,  1165,
    1166,  1167,  1168,  1169,  1170,  1172,  1174,  1176,  1178,  1179,
    1180,  1182,  1184,  1185,  1187,  1188,  1189,  1189,  1192,  1193,
    1194,  1196,  1198,  1199,  1201,  1202,  1203,  1205,  1206,  1208,
    1210,  1211,  1212,  1213,  1214,  1215,  1216,  1217,  1218,  1219,
    1220,  1221,  1223,  1225,  1226,  1227,  1229,  1231,  1238,  1239,
    1240,  1242,  1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,
    1251,  1252,  1254,  1255,  1256,  1257,  1259,  1260,  1262,  1262,
    1263,  1263,  1265,  1267,  1268,  1269,  1270,  1272,  1273,  1274,
    1275,  1277,  1279,  1280,  1281,  1282,  1283,  1285,  1286,  1289,
    1290,  1292,  1293,  1294,  1295,  1297,  1298,  1300,  1301,  1303,
    1304,  1306,  1307,  1309,  1310,  1312,  1313,  1314,  1316,  1317,
    1318,  1320,  1321,  1322,  1324,  1325,  1326,  1328,  1329,  1331,
    1332,  1334,  1335,  1337,  1338,  1344,  1345,  1346,  1347,  1348,
    1349,  1350,  1352,  1353,  1354,  1355,  1356,  1359,  1360,  1361,
    1362,  1363,  1364,  1365,  1366,  1367,  1368,  1369,  1370,  1372,
    1373,  1374,  1375,  1377,  1378,  1380,  1381,  1382,  1383,  1384,
    1385,  1386,  1387
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "T_INT", "T_HEX",
  "T_FLOAT", "T_IDENTIFIER", "T_REGISTER", "T_CONSTANT", "T_A_LOCALSIZE",
  "T_A_CONST", "T_A_BUF", "T_A_INVOCATIONID", "T_A_WGID", "T_A_NUMWG",
  "T_A_BRANCHSTACK", "T_A_IN", "T_A_OUT", "T_A_TEX", "T_A_PVTMEM",
  "T_ABSNEG", "T_NEG", "T_ABS", "T_R", "T_HR", "T_HC", "T_EVEN",
  "T_POS_INFINITY", "T_NEG_INFINITY", "T_EI", "T_WRMASK", "T_FLUT_0_0",
  "T_FLUT_0_5", "T_FLUT_1_0", "T_FLUT_2_0", "T_FLUT_E", "T_FLUT_PI",
  "T_FLUT_INV_PI", "T_FLUT_INV_LOG2_E", "T_FLUT_LOG2_E",
  "T_FLUT_INV_LOG2_10", "T_FLUT_LOG2_10", "T_FLUT_4_0", "T_SY", "T_SS",
  "T_JP", "T_SAT", "T_RPT", "T_UL", "T_NOP", "T_OP_NOP", "T_OP_BR",
  "T_OP_BRAO", "T_OP_BRAA", "T_OP_BRAC", "T_OP_BANY", "T_OP_BALL",
  "T_OP_BRAX", "T_OP_JUMP", "T_OP_CALL", "T_OP_RET", "T_OP_KILL",
  "T_OP_END", "T_OP_EMIT", "T_OP_CUT", "T_OP_CHMASK", "T_OP_CHSH",
  "T_OP_FLOW_REV", "T_OP_BKT", "T_OP_STKS", "T_OP_STKR", "T_OP_XSET",
  "T_OP_XCLR", "T_OP_GETLAST", "T_OP_GETONE", "T_OP_DBG", "T_OP_SHPS",
  "T_OP_SHPE", "T_OP_PREDT", "T_OP_PREDF", "T_OP_PREDE", "T_OP_MOVMSK",
  "T_OP_MOVA1", "T_OP_MOVA", "T_OP_MOV", "T_OP_COV", "T_OP_SWZ",
  "T_OP_GAT", "T_OP_SCT", "T_OP_ADD_F", "T_OP_MIN_F", "T_OP_MAX_F",
  "T_OP_MUL_F", "T_OP_SIGN_F", "T_OP_CMPS_F", "T_OP_ABSNEG_F",
  "T_OP_CMPV_F", "T_OP_FLOOR_F", "T_OP_CEIL_F", "T_OP_RNDNE_F",
  "T_OP_RNDAZ_F", "T_OP_TRUNC_F", "T_OP_ADD_U", "T_OP_ADD_S", "T_OP_SUB_U",
  "T_OP_SUB_S", "T_OP_CMPS_U", "T_OP_CMPS_S", "T_OP_MIN_U", "T_OP_MIN_S",
  "T_OP_MAX_U", "T_OP_MAX_S", "T_OP_ABSNEG_S", "T_OP_AND_B", "T_OP_OR_B",
  "T_OP_NOT_B", "T_OP_XOR_B", "T_OP_CMPV_U", "T_OP_CMPV_S", "T_OP_MUL_U24",
  "T_OP_MUL_S24", "T_OP_MULL_U", "T_OP_BFREV_B", "T_OP_CLZ_S",
  "T_OP_CLZ_B", "T_OP_SHL_B", "T_OP_SHR_B", "T_OP_ASHR_B", "T_OP_BARY_F",
  "T_OP_FLAT_B", "T_OP_MGEN_B", "T_OP_GETBIT_B", "T_OP_SETRM",
  "T_OP_CBITS_B", "T_OP_SHB", "T_OP_MSAD", "T_OP_MAD_U16",
  "T_OP_MADSH_U16", "T_OP_MAD_S16", "T_OP_MADSH_M16", "T_OP_MAD_U24",
  "T_OP_MAD_S24", "T_OP_MAD_F16", "T_OP_MAD_F32", "T_OP_SEL_B16",
  "T_OP_SEL_B32", "T_OP_SEL_S16", "T_OP_SEL_S32", "T_OP_SEL_F16",
  "T_OP_SEL_F32", "T_OP_SAD_S16", "T_OP_SAD_S32", "T_OP_SHRM", "T_OP_SHLM",
  "T_OP_SHRG", "T_OP_SHLG", "T_OP_ANDG", "T_OP_DP2ACC", "T_OP_DP4ACC",
  "T_OP_WMM", "T_OP_WMM_ACCU", "T_OP_RCP", "T_OP_RSQ", "T_OP_LOG2",
  "T_OP_EXP2", "T_OP_SIN", "T_OP_COS", "T_OP_SQRT", "T_OP_HRSQ",
  "T_OP_HLOG2", "T_OP_HEXP2", "T_OP_ISAM", "T_OP_ISAML", "T_OP_ISAMM",
  "T_OP_SAM", "T_OP_SAMB", "T_OP_SAML", "T_OP_SAMGQ", "T_OP_GETLOD",
  "T_OP_CONV", "T_OP_CONVM", "T_OP_GETSIZE", "T_OP_GETBUF", "T_OP_GETPOS",
  "T_OP_GETINFO", "T_OP_DSX", "T_OP_DSY", "T_OP_GATHER4R", "T_OP_GATHER4G",
  "T_OP_GATHER4B", "T_OP_GATHER4A", "T_OP_SAMGP0", "T_OP_SAMGP1",
  "T_OP_SAMGP2", "T_OP_SAMGP3", "T_OP_DSXPP_1", "T_OP_DSYPP_1",
  "T_OP_RGETPOS", "T_OP_RGETINFO", "T_OP_BRCST_A", "T_OP_QSHUFFLE_BRCST",
  "T_OP_QSHUFFLE_H", "T_OP_QSHUFFLE_V", "T_OP_QSHUFFLE_DIAG", "T_OP_LDG",
  "T_OP_LDG_A", "T_OP_LDL", "T_OP_LDP", "T_OP_STG", "T_OP_STG_A",
  "T_OP_STL", "T_OP_STP", "T_OP_LDIB", "T_OP_G2L", "T_OP_L2G",
  "T_OP_PREFETCH", "T_OP_LDLW", "T_OP_STLW", "T_OP_RESFMT", "T_OP_RESINFO",
  "T_OP_ATOMIC_ADD", "T_OP_ATOMIC_SUB", "T_OP_ATOMIC_XCHG",
  "T_OP_ATOMIC_INC", "T_OP_ATOMIC_DEC", "T_OP_ATOMIC_CMPXCHG",
  "T_OP_ATOMIC_MIN", "T_OP_ATOMIC_MAX", "T_OP_ATOMIC_AND",
  "T_OP_ATOMIC_OR", "T_OP_ATOMIC_XOR", "T_OP_RESINFO_B", "T_OP_LDIB_B",
  "T_OP_STIB_B", "T_OP_ATOMIC_B_ADD", "T_OP_ATOMIC_B_SUB",
  "T_OP_ATOMIC_B_XCHG", "T_OP_ATOMIC_B_INC", "T_OP_ATOMIC_B_DEC",
  "T_OP_ATOMIC_B_CMPXCHG", "T_OP_ATOMIC_B_MIN", "T_OP_ATOMIC_B_MAX",
  "T_OP_ATOMIC_B_AND", "T_OP_ATOMIC_B_OR", "T_OP_ATOMIC_B_XOR",
  "T_OP_ATOMIC_S_ADD", "T_OP_ATOMIC_S_SUB", "T_OP_ATOMIC_S_XCHG",
  "T_OP_ATOMIC_S_INC", "T_OP_ATOMIC_S_DEC", "T_OP_ATOMIC_S_CMPXCHG",
  "T_OP_ATOMIC_S_MIN", "T_OP_ATOMIC_S_MAX", "T_OP_ATOMIC_S_AND",
  "T_OP_ATOMIC_S_OR", "T_OP_ATOMIC_S_XOR", "T_OP_ATOMIC_G_ADD",
  "T_OP_ATOMIC_G_SUB", "T_OP_ATOMIC_G_XCHG", "T_OP_ATOMIC_G_INC",
  "T_OP_ATOMIC_G_DEC", "T_OP_ATOMIC_G_CMPXCHG", "T_OP_ATOMIC_G_MIN",
  "T_OP_ATOMIC_G_MAX", "T_OP_ATOMIC_G_AND", "T_OP_ATOMIC_G_OR",
  "T_OP_ATOMIC_G_XOR", "T_OP_LDGB", "T_OP_STGB", "T_OP_STIB", "T_OP_LDC",
  "T_OP_LDLV", "T_OP_GETSPID", "T_OP_GETWID", "T_OP_GETFIBERID",
  "T_OP_BAR", "T_OP_FENCE", "T_TYPE_F16", "T_TYPE_F32", "T_TYPE_U16",
  "T_TYPE_U32", "T_TYPE_S16", "T_TYPE_S32", "T_TYPE_U8", "T_TYPE_S8",
  "T_UNTYPED", "T_TYPED", "T_MIXED", "T_UNSIGNED", "T_LOW", "T_HIGH",
  "T_1D", "T_2D", "T_3D", "T_4D", "T_LT", "T_LE", "T_GT", "T_GE", "T_EQ",
  "T_NE", "T_S2EN", "T_SAMP", "T_TEX", "T_BASE", "T_OFFSET", "T_UNIFORM",
  "T_NONUNIFORM", "T_IMM", "T_NAN", "T_INF", "T_A0", "T_A1", "T_P0", "T_W",
  "T_CAT1_TYPE_TYPE", "'-'", "','", "'('", "')'", "'='", "':'", "'!'",
  "'#'", "'.'", "'a'", "'o'", "'p'", "'s'", "'+'", "'<'", "'g'", "'['",
  "']'", "'l'", "'w'", "'r'", "'>'", "'c'", "'h'", "$accept", "shader",
  "$@1", "headers", "header", "const_val", "localsize_header",
  "const_header", "buf_header_addr_reg", "buf_header", "$@2",
  "invocationid_header", "wgid_header", "numwg_header",
  "branchstack_header", "pvtmem_header", "in_header", "out_header",
  "tex_header", "iflag", "iflags", "instrs", "instr", "label", "cat0_src1",
  "cat0_src2", "cat0_immed", "cat0_instr", "$@3", "$@4", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "$@14", "$@15",
  "$@16", "$@17", "$@18", "cat1_opc", "cat1_src", "cat1_movmsk", "$@19",
  "cat1_mova1", "$@20", "cat1_mova", "$@21", "cat1_swz", "$@22",
  "cat1_gat", "$@23", "cat1_sct", "$@24", "cat1_instr", "cat2_opc_1src",
  "cat2_opc_2src_cnd", "cat2_opc_2src", "cond", "cat2_instr",
  "cat3_dp_signedness", "cat3_dp_pack", "cat3_opc", "cat3_imm_reg_opc",
  "cat3_wmm", "cat3_dp", "cat3_instr", "cat4_opc", "cat4_instr",
  "cat5_opc_dsxypp", "cat5_opc", "cat5_flag", "cat5_flags", "cat5_samp",
  "cat5_tex", "cat5_type", "cat5_a1", "cat5_instr", "cat6_typed",
  "cat6_dim", "cat6_type", "cat6_imm_offset", "cat6_offset",
  "cat6_dst_offset", "cat6_immed", "cat6_stg_ldg_a6xx_offset", "cat6_load",
  "$@25", "$@26", "$@27", "$@28", "$@29", "$@30", "$@31", "cat6_store",
  "$@32", "$@33", "$@34", "$@35", "$@36", "cat6_loadib", "$@37",
  "cat6_storeib", "$@38", "cat6_prefetch", "$@39", "cat6_atomic_opc",
  "cat6_a3xx_atomic_opc", "cat6_a6xx_atomic_opc", "cat6_a3xx_atomic_s",
  "cat6_a6xx_atomic_g", "cat6_atomic_l", "cat6_atomic",
  "cat6_ibo_opc_1src", "cat6_ibo_opc_ldgb", "cat6_ibo_opc_stgb",
  "cat6_ibo", "$@40", "cat6_id_opc", "cat6_id", "cat6_bindless_base",
  "cat6_bindless_mode", "cat6_reg_or_immed", "cat6_bindless_ibo_opc_1src",
  "cat6_bindless_ibo_opc_2src", "cat6_bindless_ibo_opc_2src_dst",
  "cat6_bindless_ibo", "cat6_bindless_ldc_opc", "cat6_bindless_ldc",
  "cat6_todo", "cat6_instr", "cat7_scope", "cat7_scopes", "cat7_barrier",
  "$@41", "$@42", "cat7_instr", "src", "dst", "const", "dst_reg_flag",
  "dst_reg_flags", "dst_reg", "src_reg_flag", "src_reg_flags", "src_reg",
  "src_reg_gpr", "src_const", "src_reg_or_const",
  "src_reg_or_const_or_rel", "src_reg_or_const_or_rel_or_imm",
  "src_reg_or_rel_or_imm", "offset", "relative_gpr_src",
  "relative_gpr_dst", "relative_const", "relative", "immediate_cat1",
  "immediate", "flut_immed", "integer", "float", "type", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-844)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-47)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -844,    49,   868,  -844,    31,  -263,    31,  -239,  -235,  -223,
      31,  -193,  -178,  -166,    31,   246,   868,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,   180,  -133,   178,  -844,   191,   125,   198,  -844,   204,
     208,   218,  -844,   -93,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,   637,  1071,  -844,   227,  -844,  -844,  -844,    31,   -90,
     -86,   -84,   -83,   -80,   -75,   -74,   -68,   -66,  -844,  -844,
    -844,  -844,  -844,  -844,   -56,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,   -55,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,   -47,   -54,   -32,   -44,   -42,   -40,   -39,   -24,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,   127,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,   175,   -22,   175,  -844,
     175,   175,   175,   -15,  -844,   175,  -844,    -5,    -5,  -844,
    -844,  -844,  -844,  -844,  -844,    -3,    -3,    -3,  -844,  -844,
    -844,  -844,    -1,    -3,    -3,  -844,    -1,  -844,    -3,    -3,
      -3,  -844,     1,  -844,  -844,  -844,  -844,  -844,  -844,    15,
      31,   325,  -844,  -844,  -844,  -844,  -844,   328,   332,   333,
    -244,  -244,  -244,    10,  -244,  -244,    18,    18,    18,  -244,
      18,    28,    18,    18,  -244,  -244,    29,    32,    33,    37,
      51,    56,    63,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -3,    17,    -1,    -1,    -3,    -1,    22,    22,
    -844,    42,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
      55,  -844,   404,    89,    72,    78,    79,   -35,    80,    88,
      92,    93,  -138,    90,    96,   596,    -5,   175,   102,  -127,
      97,    97,    97,   394,    97,    97,    97,   175,    97,    97,
      97,   122,    31,   118,   137,   119,   123,   126,  -844,   142,
     147,   148,   149,  -844,  -844,   163,  -844,   152,   153,    95,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,   175,   175,
     175,   175,   128,   140,   139,   151,    97,   144,   175,   146,
      97,   175,  -213,    22,  -844,  -844,   170,   174,  -844,  -844,
     552,   552,   699,  -844,  -844,  -844,  -844,  -844,  -844,   175,
     699,   106,   741,    68,  -844,  -844,  -113,   175,   699,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
     176,   394,   175,  -844,  -844,   -72,    -1,    -1,    -1,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,   175,    -1,
      -1,  -844,    -1,    -1,    -1,   167,  -844,    31,  -844,   490,
     491,    10,  -844,    18,  -219,  -219,  -844,  -844,    18,    18,
      18,  -844,  -844,    18,   175,   552,   552,   175,   175,   175,
     181,   185,   193,   194,   183,   187,   192,   195,    -1,   210,
     209,   197,    -1,   216,  -844,  -844,  -844,  -844,  -844,  -242,
    -242,  -844,  -844,  -844,  -844,  -844,  -844,   205,   211,  -844,
    -844,  -844,    60,   213,   214,   190,  -844,  -844,  -844,   336,
     136,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,    10,   623,   781,  -844,  -844,  -844,  -844,
    -844,   217,   222,   223,   210,  -844,   229,  -844,  -844,  -844,
     233,  -844,  -844,  -844,   241,  -844,    50,   206,   245,  -844,
    -844,  -844,  -844,   221,   239,   240,   248,   243,   244,   247,
     254,   255,    10,   252,   250,   260,   264,  -844,  -844,   269,
     266,   268,  -844,  -844,  -844,  -844,  -844,  -844,  -844,   271,
     278,   279,   267,   275,   257,   284,   210,   210,   210,   210,
     281,  -214,   282,   210,   293,   287,    10,    10,   285,   286,
     313,   317,  -844,   310,   311,   159,   312,   326,   321,   341,
      57,  -844,  -844,  -844,  -844,   348,    10,  -844,  -844,   699,
     699,   171,   171,    50,   741,  -844,  -844,   307,    10,    10,
      10,   356,    10,    10,    10,    10,    10,   320,  -844,    31,
      10,    10,   684,  -844,    18,    18,   175,    50,   175,   359,
     360,   363,   364,  -242,   368,  -205,  -205,    10,    24,  -844,
     365,  -844,   369,  -205,    10,   372,  -844,  -844,  -844,  -844,
    -242,  -242,  -844,  -844,  -844,  -844,  -844,  -242,  -242,   381,
     386,  -844,   389,   392,  -844,   188,   393,   396,   397,   398,
    -844,  -844,   399,  -844,   400,   387,   401,   402,   410,   175,
    -844,   405,   422,   423,  -134,   411,   431,   432,   434,  -844,
    -844,   435,   438,   439,   210,   210,   210,   210,   424,     0,
     425,    24,   426,  -844,   427,   175,  -844,   450,   210,   436,
     437,    10,   433,   453,   454,   455,  -844,  -844,  -844,   699,
     106,   741,     6,   171,   468,   307,   459,   456,   478,    24,
     494,   496,  -134,  -134,  -134,   509,   509,   509,   175,    31,
    -844,  -844,    10,    50,    50,   175,  -214,   368,  -214,  -214,
     517,   210,   505,   519,  -844,   521,   522,   529,    10,  -214,
     533,   520,   518,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,   537,  -844,   538,  -844,   539,   175,   175,   175,   524,
    -844,  -844,   527,   530,   175,    50,   175,   555,  -844,  -844,
    -844,   544,  -844,   549,   550,   554,   575,   536,   560,   561,
     563,   210,  -242,   568,   210,   210,   210,   570,  -844,   571,
     210,     6,  -844,   741,   483,   307,   588,   590,   591,  -844,
     577,    24,   594,   595,   597,  -844,    24,   907,    50,    50,
     175,   598,   599,   600,   601,   602,   606,    10,   603,   611,
     612,   604,   613,   616,   605,   617,  -844,  -844,  -844,  -844,
     618,  -844,  -844,   608,   609,   210,    24,   610,    24,    24,
      24,   620,   619,  -844,   627,   628,     6,     6,     6,     6,
       6,   622,  -242,     6,     6,     6,     6,     6,     6,   629,
       6,   468,   615,   621,   631,   624,   638,  -844,   641,   642,
      24,    10,    50,    50,  -844,  -844,  -844,  -844,  -844,   630,
     634,  -844,  -844,  -844,   635,  -844,  -844,   210,  -844,  -844,
      24,    24,   210,   644,   210,    24,    24,  -844,   652,  -844,
    -844,    10,   640,   654,   655,   643,   645,  -844,   210,   656,
    -844,  -844,   948,  -844,    10,   210,   210,   658,   660,   662,
      24,   661,  -844,   663,   665,   210,   210,   210,   666,    10,
     210,   210,  -844,   667,  -844,   210,   668,  -844,  -844,   210,
    -844,   980,   670,   669,   210,    10,  -844,  -844
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     4,     1,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     4,     6,     7,     8,
       9,    10,    11,    12,    16,    13,    14,    15,    18,    20,
      17,     0,     0,     0,    25,     0,     0,     0,    31,     0,
       0,     0,    32,     0,    36,    37,    38,    39,    40,    41,
      42,    43,     0,     3,    43,    55,     5,    19,     0,     0,
      24,     0,     0,     0,     0,     0,     0,     0,    56,    44,
      63,    64,    66,    68,     0,    72,    74,    76,    78,    80,
      82,    83,    85,    86,    87,    88,    89,    90,    91,    93,
      94,    95,    96,     0,    97,    99,   100,   102,   103,   105,
     107,     0,     0,     0,     0,     0,     0,     0,     0,   154,
     155,   156,   157,   138,   148,   134,   151,   139,   140,   141,
     142,   143,   158,   159,   160,   161,   149,   150,   162,   163,
     164,   165,   135,   166,   167,   144,   168,   152,   153,   169,
     170,   171,   145,   137,   136,   172,   173,   174,   175,   176,
     177,   178,   146,   147,   179,   180,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   217,   218,   215,
     216,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   234,   235,   260,   261,   262,
     263,   264,   265,   266,   313,   315,   319,   317,   326,   328,
     332,   330,   336,   418,   419,   340,   321,   334,   420,   381,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   399,   412,   411,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   382,   383,   338,
     416,   323,   388,   389,   390,   438,   440,    47,     0,   126,
     127,   128,   129,   130,   131,    48,     0,     0,     0,    49,
       0,     0,     0,     0,    50,     0,    51,   277,   277,    52,
     421,   423,   422,   424,   425,     0,     0,     0,   379,   380,
     378,   426,     0,     0,     0,   427,     0,   428,     0,     0,
       0,   430,     0,   429,   431,    53,   442,    54,    45,     0,
       0,     0,    26,    27,    28,    29,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   436,   436,
     447,     0,   452,   453,   454,   455,   456,   448,   449,   450,
       0,   459,   457,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   277,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,   519,   521,     0,    70,     0,     0,     0,
      77,    79,    81,    84,    92,   108,    98,   101,   104,   106,
     114,   116,   118,   110,   111,   120,   122,   124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   436,   439,   441,     0,     0,   458,   460,
       0,     0,     0,   181,   182,   183,   184,   185,   186,     0,
       0,     0,     0,     0,   190,   191,     0,     0,     0,   267,
     272,   275,   273,   274,   276,   268,   269,   270,   271,   278,
       0,     0,     0,   298,   299,     0,     0,     0,     0,   525,
     526,   527,   528,   529,   530,   531,   532,   304,     0,     0,
       0,   391,     0,     0,     0,     0,    21,     0,    23,     0,
       0,     0,    57,     0,     0,     0,   520,   522,     0,     0,
       0,    62,    61,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   435,   434,   432,   433,   437,   484,
     484,   443,   451,   461,   462,   463,   464,     0,     0,   444,
     445,   446,     0,     0,     0,     0,   132,   467,   471,   465,
       0,   473,   474,   475,   112,   493,   494,   476,   113,   495,
     133,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   518,     0,     0,     0,   478,   187,   480,   504,
     502,     0,     0,     0,     0,   481,     0,   482,   483,   469,
       0,   470,   192,   193,     0,   233,     0,     0,   297,   300,
     301,   302,   303,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    65,    60,     0,
       0,     0,    71,    73,    75,   109,   115,   117,   119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   484,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   523,     0,     0,     0,     0,     0,     0,     0,
       0,   466,   468,   472,   477,     0,     0,   506,   479,     0,
       0,     0,     0,     0,     0,   283,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   310,     0,
       0,     0,     0,    59,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   484,     0,   484,   484,     0,     0,   306,
       0,   305,     0,   484,     0,     0,   486,   485,   490,   489,
     484,   484,   500,   501,   524,   496,   497,   484,   484,     0,
       0,   503,     0,     0,   189,     0,     0,     0,     0,     0,
     279,   280,   295,   296,   293,     0,     0,     0,     0,     0,
     386,     0,     0,     0,     0,     0,     0,     0,     0,    67,
      69,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   308,     0,     0,   307,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   498,   499,   505,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   392,   392,   392,     0,     0,
      33,    34,     0,     0,     0,     0,   484,     0,   484,   484,
       0,     0,     0,     0,   309,     0,     0,     0,     0,   484,
       0,     0,     0,   488,   492,   487,   491,   188,   219,   220,
     221,     0,   294,   291,   292,   288,     0,     0,     0,     0,
     397,   398,     0,     0,     0,     0,     0,     0,   395,   396,
     394,     0,    22,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   484,     0,     0,     0,     0,     0,   341,     0,
       0,     0,   324,     0,     0,     0,     0,     0,     0,   384,
       0,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,   289,   290,   282,
     286,   287,   284,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   121,     0,     0,     0,     0,     0,     0,
       0,     0,   484,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,     0,     0,
       0,     0,     0,     0,   314,   316,   320,   318,   327,     0,
       0,   329,   333,   331,     0,   322,   335,     0,   325,   285,
       0,     0,     0,     0,     0,     0,     0,   417,     0,   123,
     125,     0,     0,     0,     0,     0,     0,   376,     0,     0,
     414,   415,     0,   311,     0,     0,     0,     0,     0,     0,
       0,     0,   312,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   377,     0,   385,     0,     0,   337,   339,     0,
     387,     0,     0,     0,     0,     0,   375,    35
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -844,  -844,  -844,   972,  -844,    -6,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
     939,   937,  -844,  -844,   228,   428,  -314,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -471,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -289,  -843,  -717,  -844,
    -844,  -844,   274,   409,   413,   219,  -780,  -683,    76,   107,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -696,  -557,  -124,  -844,  -844,  -844,
    -844,  -844,  -844,  -844,  -844,  -844,  -376,  -844,  -844,  -844,
    -844,  -538,   582,  -595,  -844,   584,  -291,  -844,  -434,  -501,
    -844,  -844,  -656,  -495,  -492,  -741,  -567,   484,  -844,  -844,
    -510,  -844,  -367,   354,  -362,   270,   471
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,    15,    16,    32,    17,    18,   352,    19,
      60,    20,    21,    22,    23,    24,    25,    26,    27,    51,
      52,    53,    54,    55,   450,   690,   460,   297,   360,   361,
     362,   568,   364,   365,   366,   367,   368,   369,   370,   372,
     373,   374,   375,   573,   298,   616,   299,   574,   300,   575,
     301,   576,   302,   577,   303,   578,   304,   579,   305,   306,
     307,   308,   509,   309,   423,   517,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   426,   427,   812,   813,   532,
     988,   319,   430,   536,   434,   779,   780,   842,   757,   840,
     320,   384,   385,   387,   386,   394,   397,   985,   321,   388,
     389,   391,   390,   395,   322,   392,   323,   396,   324,   393,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   871,   336,   337,   928,   878,   919,   338,   339,   340,
     341,   342,   343,   344,   345,   493,   494,   346,   398,   399,
     347,   617,   411,   618,   412,   413,   414,   619,   654,   621,
     660,   622,   623,   646,   647,   656,   781,   625,   415,   626,
     627,   628,   648,   649,   650,   727,   547
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      34,   456,   657,   809,    38,   624,   624,   601,    42,   453,
     454,   655,   659,   453,   454,   416,   653,   418,   652,   419,
     420,   421,   913,   495,   424,   733,   665,   453,   454,   428,
     630,   601,   718,   719,    28,    29,    30,   631,   632,   633,
     634,   635,   636,   637,   638,   639,   640,   641,   642,     3,
     733,   711,   349,   461,   462,    33,   464,   601,   466,   467,
     453,   454,   722,   453,   454,   722,   620,   620,   645,   448,
     603,   604,   605,   606,   716,   601,   645,   620,   449,    35,
     624,   624,   732,    36,   645,   806,   807,   717,   603,   604,
     605,   606,   607,   844,   688,    37,   400,   572,   453,   454,
     849,   571,   716,   689,   697,   698,   937,   732,   939,   940,
     734,   716,   990,   601,   602,   778,   732,   598,   594,   949,
     909,   595,   596,   597,   841,    39,   603,   604,   605,   606,
     607,   608,    62,    63,   400,   734,   530,   529,   629,   629,
      40,   620,   620,   601,   602,   658,   551,   912,   914,   514,
     515,   401,    41,   402,   403,   404,   405,   406,   533,   534,
     607,   608,   566,   567,   794,   745,   566,   567,   773,   774,
     775,   776,   875,   876,   877,   783,   662,   663,   601,   602,
     929,   930,   400,    57,    58,   731,    59,   580,   581,   582,
     583,   603,   604,   605,   606,   601,   602,   590,    61,   686,
     593,   402,   403,   404,   405,   406,    64,   911,   843,   843,
     733,    65,   986,   629,   629,    66,   843,   601,   651,   669,
     670,   671,   672,   852,   853,    67,   664,   -46,    68,   350,
     854,   855,   351,    43,   657,   353,   354,   987,   991,   355,
     846,   668,   808,   655,   356,   357,   814,   803,   804,   687,
     726,   358,    43,   359,   692,   693,   694,   676,   377,   695,
     503,   504,   505,   506,   507,   508,   832,   732,   363,   371,
      44,    45,    46,    47,    48,    49,    50,   376,   738,   378,
     379,   735,   380,   696,   381,   382,   699,   700,   701,    44,
      45,    46,    47,    48,    49,    50,   886,   887,   888,   889,
     383,   892,   417,   894,  1049,   645,   645,   805,   805,   422,
     899,   609,   610,   611,   601,   924,   925,   926,   891,   425,
     758,   429,   455,   433,   643,   441,   455,   603,   604,   605,
     606,   920,   442,   444,   445,   609,   610,   611,   446,   447,
     455,   459,   465,   470,   443,   644,   492,    31,   487,   471,
     472,   657,   473,   942,   786,   787,   603,   604,   605,   606,
     655,   609,   610,   611,   915,   908,   474,   907,   799,   723,
     724,   475,   496,   725,   802,   976,   725,   658,   476,   609,
     610,   611,   934,   935,   477,   497,   758,   758,   758,   500,
     758,   758,   758,   758,   758,   501,   502,   510,   826,   827,
     407,   408,   409,   975,   613,   511,   978,   979,   980,   512,
     513,   455,   983,   518,   516,   758,   787,   609,   610,   611,
     531,   535,   758,   920,   963,   645,   620,   555,   920,   805,
     402,   403,   404,   405,   406,   557,   556,   559,   407,   408,
     409,   560,   613,   657,   614,  1040,   561,   609,   610,   611,
     829,   830,   655,   989,   992,   562,   558,  1024,   920,   584,
     920,   920,   920,   410,   563,   564,   565,  1003,  1004,   569,
     570,   585,   613,   586,   614,   831,   589,   833,   587,   787,
     591,   599,   609,   610,   611,   600,   407,   408,   409,   902,
     601,   682,   920,   666,   658,   910,   684,   685,   702,   609,
     610,   611,   703,   603,   604,   605,   606,   921,   730,  1064,
     704,   705,   920,   920,  1067,   706,  1069,   920,   920,   707,
     933,   609,   610,   611,   708,   746,   712,   709,   870,   713,
    1079,  1059,  1060,   715,   739,   720,   758,  1083,  1084,   740,
     741,   721,   920,   728,   729,   748,   742,  1092,  1093,  1094,
     743,   683,  1097,  1098,   897,   453,   454,  1100,   744,   601,
     602,  1102,   747,   749,   750,   751,  1106,   752,   753,   759,
     760,   754,   603,   604,   605,   606,   607,   608,   755,   756,
     761,   762,   763,   764,   984,   765,   658,   931,   766,   451,
     452,   771,   457,   458,   936,   767,   768,   463,   769,   921,
     431,   432,   468,   469,   921,   777,   770,   435,   436,   810,
     811,   772,   438,   439,   440,  1012,   782,   784,   609,   610,
     611,   785,   788,   789,   790,   956,   957,   958,   791,   792,
     793,   795,   797,   962,   921,   964,   921,   921,   921,  1034,
    1035,  1036,  1037,  1038,   824,   796,  1041,  1042,  1043,  1044,
    1045,  1046,   798,  1048,   631,   632,   633,   634,   635,   636,
     637,   638,   639,   640,   641,   642,   486,   801,   921,  1058,
     490,   539,   540,   541,   542,   543,   544,   545,   546,  1005,
      44,    45,    46,    47,    48,    49,    50,   818,   921,   921,
     828,   834,   835,   921,   921,   836,   837,   839,   847,  1073,
     856,   848,   453,   454,   851,   857,   601,   602,   858,   859,
     860,   866,  1082,   861,   862,   863,   864,   865,   921,   603,
     604,   605,   606,   607,   608,   867,   868,  1096,   879,   872,
     631,   632,   633,   634,   635,   636,   637,   638,   639,   640,
     641,   642,   869,  1107,   453,   454,   873,   874,   601,   437,
     880,   881,   883,   825,   882,   884,   885,   890,   893,   895,
     896,   603,   604,   605,   606,   607,   608,   898,   901,   900,
     903,   811,   631,   632,   633,   634,   635,   636,   637,   638,
     639,   640,   641,   642,   453,   454,   811,   917,   601,   602,
     904,   905,   906,   916,   609,   610,   611,   478,   479,   480,
     481,   482,   483,   484,   485,   607,   608,   488,   489,   918,
     491,   922,   631,   632,   633,   634,   635,   636,   637,   638,
     639,   640,   641,   642,   815,   816,   817,   923,   819,   820,
     821,   822,   823,   927,   941,   943,   944,   997,   945,   946,
     537,   538,  1001,   548,   549,   550,   947,   552,   553,   554,
     950,   952,   951,   845,   953,   954,   955,   959,   960,   965,
     850,   966,   961,   609,   610,   611,   967,   968,   455,   971,
     612,   969,  1025,   932,  1027,  1028,  1029,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,   613,   519,
     614,   615,   970,   972,   973,   588,   974,   520,   977,   592,
     521,   981,   522,   523,   982,   993,  1057,   994,   995,   996,
     524,   998,   999,  1002,  1000,  1006,  1007,  1008,  1009,  1010,
    1013,   525,   526,   527,   528,  1011,  1065,  1066,  1014,  1015,
    1017,  1070,  1071,  1018,  1020,  1021,  1016,  1030,  1019,  1031,
    1023,   736,  1022,  1026,  1032,  1033,  1047,  1050,  1052,   673,
     674,   675,  1039,  1051,  1081,  1054,  1088,  1053,  1055,  1056,
    1061,  1068,   677,   678,  1062,   679,   680,   681,  1063,  1072,
    1074,  1075,  1076,  1080,   948,  1085,  1077,  1086,  1078,  1087,
    1090,  1089,  1091,  1095,  1099,  1101,  1103,  1104,    56,  1105,
      69,   348,   838,   691,   938,   499,   498,   661,   737,     0,
     800,   710,   667,     0,     0,   714,     0,     0,     0,     0,
     609,   610,   611,     0,     0,   455,     0,   643,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   613,     0,   614,   644,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   609,   610,   611,     0,     0,   455,     0,   643,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   613,     0,   614,
     644,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   609,   610,   611,     0,     0,   455,     0,   643,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   613,     0,   614,
     644,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296
};

static const yytype_int16 yycheck[] =
{
       6,   363,   512,   744,    10,   500,   501,     7,    14,     3,
       4,   512,   513,     3,     4,   306,   511,   308,   510,   310,
     311,   312,   865,   399,   315,   620,   518,     3,     4,   318,
     501,     7,   599,   600,     3,     4,     5,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,     0,
     645,   589,    58,   367,   368,   318,   370,     7,   372,   373,
       3,     4,     5,     3,     4,     5,   500,   501,   502,   313,
      20,    21,    22,    23,   316,     7,   510,   511,   322,   318,
     575,   576,   620,   318,   518,   741,   742,   329,    20,    21,
      22,    23,    24,   776,   313,   318,     7,   459,     3,     4,
     783,     6,   316,   322,   575,   576,   886,   645,   888,   889,
     620,   316,   955,     7,     8,   329,   654,   493,   331,   899,
     861,   334,   335,   336,   329,   318,    20,    21,    22,    23,
      24,    25,     7,     8,     7,   645,   427,   426,   500,   501,
     318,   575,   576,     7,     8,   512,   437,   864,   865,   287,
     288,    24,   318,    26,    27,    28,    29,    30,   285,   286,
      24,    25,     3,     4,     5,   666,     3,     4,   706,   707,
     708,   709,   306,   307,   308,   713,   289,   290,     7,     8,
     876,   877,     7,     3,   317,   619,     8,   478,   479,   480,
     481,    20,    21,    22,    23,     7,     8,   488,     7,   561,
     491,    26,    27,    28,    29,    30,     8,   863,   775,   776,
     805,     7,   953,   575,   576,     7,   783,     7,   509,   291,
     292,   293,   294,   790,   791,     7,   517,     0,   321,   319,
     797,   798,   318,     6,   744,   319,   319,   954,   955,   319,
     778,   532,   743,   744,   319,   319,   747,   739,   740,   563,
     612,   319,     6,   319,   568,   569,   570,   548,   312,   573,
     295,   296,   297,   298,   299,   300,   767,   805,   324,   324,
      43,    44,    45,    46,    47,    48,    49,   324,   645,   311,
     324,   643,   324,   574,   324,   324,   577,   578,   579,    43,
      44,    45,    46,    47,    48,    49,   834,   835,   836,   837,
     324,   839,   324,   841,  1021,   739,   740,   741,   742,   324,
     848,   311,   312,   313,     7,   872,   873,   874,   318,   324,
     682,   324,   316,   324,   318,   324,   316,    20,    21,    22,
      23,   869,   317,     8,     6,   311,   312,   313,     6,     6,
     316,   323,   314,   314,   350,   339,   324,   316,   331,   317,
     317,   861,   315,   891,   716,   717,    20,    21,    22,    23,
     861,   311,   312,   313,   865,   860,   315,   859,   730,   309,
     310,   315,   330,   316,   736,   942,   316,   744,   315,   311,
     312,   313,   883,   884,   315,   330,   748,   749,   750,   317,
     752,   753,   754,   755,   756,   317,   317,   317,   760,   761,
     311,   312,   313,   941,   336,   317,   944,   945,   946,   317,
     317,   316,   950,   317,   324,   777,   778,   311,   312,   313,
     318,   324,   784,   961,   925,   859,   860,   305,   966,   863,
      26,    27,    28,    29,    30,   317,   442,   318,   311,   312,
     313,   318,   336,   953,   338,  1012,   320,   311,   312,   313,
     764,   765,   953,   954,   955,   313,   319,   995,   996,   331,
     998,   999,  1000,   336,   317,   317,   317,   968,   969,   317,
     317,   331,   336,   334,   338,   766,   332,   768,   327,   841,
     334,   311,   311,   312,   313,   311,   311,   312,   313,   851,
       7,   324,  1030,   317,   861,   862,     6,     6,   317,   311,
     312,   313,   317,    20,    21,    22,    23,   869,   318,  1047,
     317,   317,  1050,  1051,  1052,   332,  1054,  1055,  1056,   332,
     882,   311,   312,   313,   332,   319,   317,   332,   819,   332,
    1068,  1032,  1033,   317,   317,   330,   898,  1075,  1076,   317,
     317,   330,  1080,   330,   330,   324,   317,  1085,  1086,  1087,
     317,   557,  1090,  1091,   845,     3,     4,  1095,   317,     7,
       8,  1099,   317,   324,   324,   317,  1104,   324,   324,   317,
     320,   324,    20,    21,    22,    23,    24,    25,   324,   324,
     320,   317,   313,   317,   951,   317,   953,   878,   317,   361,
     362,   334,   364,   365,   885,   317,   317,   369,   331,   961,
     326,   327,   374,   375,   966,   324,   331,   333,   334,   302,
     303,   327,   338,   339,   340,   977,   334,   324,   311,   312,
     313,   334,   337,   337,   311,   916,   917,   918,   311,   319,
     319,   319,   311,   924,   996,   926,   998,   999,  1000,  1006,
    1007,  1008,  1009,  1010,   324,   319,  1013,  1014,  1015,  1016,
    1017,  1018,   311,  1020,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,   392,   319,  1030,  1031,
     396,   277,   278,   279,   280,   281,   282,   283,   284,   970,
      43,    44,    45,    46,    47,    48,    49,   331,  1050,  1051,
       6,   332,   332,  1055,  1056,   332,   332,   329,   333,  1061,
     319,   332,     3,     4,   332,   319,     7,     8,   319,   317,
     317,   324,  1074,   317,   317,   317,   317,   317,  1080,    20,
      21,    22,    23,    24,    25,   324,   324,  1089,   317,   324,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,   332,  1105,     3,     4,   324,   324,     7,   336,
     319,   319,   317,   759,   320,   317,   317,   333,   333,   333,
     333,    20,    21,    22,    23,    24,    25,   317,   331,   333,
     337,   303,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,     3,     4,   303,   331,     7,     8,
     337,   337,   337,   334,   311,   312,   313,   384,   385,   386,
     387,   388,   389,   390,   391,    24,    25,   394,   395,   331,
     397,   317,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,   748,   749,   750,   331,   752,   753,
     754,   755,   756,   324,   317,   330,   317,   961,   317,   317,
     431,   432,   966,   434,   435,   436,   317,   438,   439,   440,
     317,   333,   332,   777,   317,   317,   317,   333,   331,   304,
     784,   317,   332,   311,   312,   313,   317,   317,   316,   333,
     318,   317,   996,   879,   998,   999,  1000,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,   336,   293,
     338,   339,   317,   333,   333,   486,   333,   301,   330,   490,
     304,   331,   306,   307,   333,   317,  1030,   317,   317,   332,
     314,   317,   317,     6,   317,   317,   317,   317,   317,   317,
     317,   325,   326,   327,   328,   319,  1050,  1051,   317,   317,
     317,  1055,  1056,   317,   317,   317,   332,   317,   333,   320,
     331,   318,   334,   333,   317,   317,   317,   332,   317,   536,
     537,   538,   330,   332,     6,   317,  1080,   333,   317,   317,
     330,   317,   549,   550,   330,   552,   553,   554,   333,   317,
     330,   317,   317,   317,   898,   317,   333,   317,   333,   317,
     317,   320,   317,   317,   317,   317,     6,   317,    16,   320,
      51,    54,   773,   565,   887,   413,   412,   513,   644,    -1,
     730,   588,   531,    -1,    -1,   592,    -1,    -1,    -1,    -1,
     311,   312,   313,    -1,    -1,   316,    -1,   318,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   336,    -1,   338,   339,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   311,   312,   313,    -1,    -1,   316,    -1,   318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,   338,
     339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   311,   312,   313,    -1,    -1,   316,    -1,   318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,   338,
     339,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   341,   342,     0,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,   343,   344,   346,   347,   349,
     351,   352,   353,   354,   355,   356,   357,   358,     3,     4,
       5,   316,   345,   318,   345,   318,   318,   318,   345,   318,
     318,   318,   345,     6,    43,    44,    45,    46,    47,    48,
      49,   359,   360,   361,   362,   363,   343,     3,   317,     8,
     350,     7,     7,     8,     8,     7,     7,     7,   321,   360,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   367,   384,   386,
     388,   390,   392,   394,   396,   398,   399,   400,   401,   403,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   421,
     430,   438,   444,   446,   448,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   462,   463,   467,   468,
     469,   470,   471,   472,   473,   474,   477,   480,   361,   345,
     319,   318,   348,   319,   319,   319,   319,   319,   319,   319,
     368,   369,   370,   324,   372,   373,   374,   375,   376,   377,
     378,   324,   379,   380,   381,   382,   324,   312,   311,   324,
     324,   324,   324,   324,   431,   432,   434,   433,   439,   440,
     442,   441,   445,   449,   435,   443,   447,   436,   478,   479,
       7,    24,    26,    27,    28,    29,    30,   311,   312,   313,
     336,   482,   484,   485,   486,   498,   486,   324,   486,   486,
     486,   486,   324,   404,   486,   324,   415,   416,   416,   324,
     422,   422,   422,   324,   424,   422,   422,   424,   422,   422,
     422,   324,   317,   345,     8,     6,     6,     6,   313,   322,
     364,   364,   364,     3,     4,   316,   504,   364,   364,   323,
     366,   366,   366,   364,   366,   314,   366,   366,   364,   364,
     314,   317,   317,   315,   315,   315,   315,   315,   424,   424,
     424,   424,   424,   424,   424,   424,   422,   331,   424,   424,
     422,   424,   324,   475,   476,   476,   330,   330,   485,   482,
     317,   317,   317,   295,   296,   297,   298,   299,   300,   402,
     317,   317,   317,   317,   287,   288,   324,   405,   317,   293,
     301,   304,   306,   307,   314,   325,   326,   327,   328,   416,
     486,   318,   419,   285,   286,   324,   423,   423,   423,   277,
     278,   279,   280,   281,   282,   283,   284,   506,   423,   423,
     423,   486,   423,   423,   423,   305,   345,   317,   319,   318,
     318,   320,   313,   317,   317,   317,     3,     4,   371,   317,
     317,     6,   504,   383,   387,   389,   391,   393,   395,   397,
     486,   486,   486,   486,   331,   331,   334,   327,   423,   332,
     486,   334,   423,   486,   331,   334,   335,   336,   476,   311,
     311,     7,     8,    20,    21,    22,    23,    24,    25,   311,
     312,   313,   318,   336,   338,   339,   385,   481,   483,   487,
     488,   489,   491,   492,   493,   497,   499,   500,   501,   504,
     385,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,   318,   339,   488,   493,   494,   502,   503,
     504,   486,   494,   493,   488,   489,   495,   500,   502,   489,
     490,   497,   289,   290,   486,   494,   317,   506,   486,   291,
     292,   293,   294,   424,   424,   424,   486,   424,   424,   424,
     424,   424,   324,   345,     6,     6,   504,   366,   313,   322,
     365,   365,   366,   366,   366,   366,   486,   385,   385,   486,
     486,   486,   317,   317,   317,   317,   332,   332,   332,   332,
     424,   481,   317,   332,   424,   317,   316,   329,   496,   496,
     330,   330,     5,   309,   310,   316,   504,   505,   330,   330,
     318,   488,   481,   483,   500,   504,   318,   503,   502,   317,
     317,   317,   317,   317,   317,   489,   319,   317,   324,   324,
     324,   317,   324,   324,   324,   324,   324,   428,   504,   317,
     320,   320,   317,   313,   317,   317,   317,   317,   317,   331,
     331,   334,   327,   481,   481,   481,   481,   324,   329,   425,
     426,   496,   334,   481,   324,   334,   504,   504,   337,   337,
     311,   311,   319,   319,     5,   319,   319,   311,   311,   504,
     505,   319,   504,   494,   494,   488,   492,   492,   489,   495,
     302,   303,   417,   418,   489,   428,   428,   428,   331,   428,
     428,   428,   428,   428,   324,   345,   504,   504,     6,   366,
     366,   486,   489,   486,   332,   332,   332,   332,   425,   329,
     429,   329,   427,   496,   427,   428,   481,   333,   332,   427,
     428,   332,   496,   496,   496,   496,   319,   319,   319,   317,
     317,   317,   317,   317,   317,   317,   324,   324,   324,   332,
     486,   461,   324,   324,   324,   306,   307,   308,   465,   317,
     319,   319,   320,   317,   317,   317,   481,   481,   481,   481,
     333,   318,   481,   333,   481,   333,   333,   486,   317,   481,
     333,   331,   504,   337,   337,   337,   337,   494,   493,   495,
     502,   492,   418,   417,   418,   489,   334,   331,   331,   466,
     481,   504,   317,   331,   465,   465,   465,   324,   464,   464,
     464,   486,   345,   504,   489,   489,   486,   426,   429,   426,
     426,   317,   481,   330,   317,   317,   317,   317,   428,   426,
     317,   332,   333,   317,   317,   317,   486,   486,   486,   333,
     331,   332,   486,   489,   486,   304,   317,   317,   317,   317,
     317,   333,   333,   333,   333,   481,   496,   330,   481,   481,
     481,   331,   333,   481,   502,   437,   495,   418,   420,   489,
     417,   418,   489,   317,   317,   317,   332,   466,   317,   317,
     317,   466,     6,   489,   489,   486,   317,   317,   317,   317,
     317,   319,   504,   317,   317,   317,   332,   317,   317,   333,
     317,   317,   334,   331,   481,   466,   333,   466,   466,   466,
     317,   320,   317,   317,   502,   502,   502,   502,   502,   330,
     496,   502,   502,   502,   502,   502,   502,   317,   502,   418,
     332,   332,   317,   333,   317,   317,   317,   466,   504,   489,
     489,   330,   330,   333,   481,   466,   466,   481,   317,   481,
     466,   466,   317,   504,   330,   317,   317,   333,   333,   481,
     317,     6,   504,   481,   481,   317,   317,   317,   466,   320,
     317,   317,   481,   481,   481,   317,   504,   481,   481,   317,
     481,   317,   481,     6,   317,   320,   481,   504
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   340,   342,   341,   343,   343,   344,   344,   344,   344,
     344,   344,   344,   344,   344,   344,   344,   345,   345,   345,
     345,   346,   347,   348,   348,   350,   349,   351,   352,   352,
     353,   354,   355,   356,   357,   358,   359,   359,   359,   359,
     359,   359,   359,   360,   360,   361,   361,   362,   362,   362,
     362,   362,   362,   362,   362,   362,   363,   364,   364,   365,
     365,   366,   366,   367,   368,   367,   369,   367,   370,   367,
     371,   367,   372,   367,   373,   367,   374,   367,   375,   367,
     376,   367,   367,   377,   367,   367,   367,   367,   367,   367,
     367,   378,   367,   367,   367,   367,   367,   379,   367,   367,
     380,   367,   367,   381,   367,   382,   367,   367,   383,   367,
     384,   384,   385,   385,   387,   386,   389,   388,   391,   390,
     393,   392,   395,   394,   397,   396,   398,   398,   398,   398,
     398,   398,   398,   398,   399,   399,   399,   399,   399,   399,
     399,   399,   399,   399,   399,   399,   399,   399,   400,   400,
     400,   400,   400,   400,   401,   401,   401,   401,   401,   401,
     401,   401,   401,   401,   401,   401,   401,   401,   401,   401,
     401,   401,   401,   401,   401,   401,   401,   401,   401,   401,
     401,   402,   402,   402,   402,   402,   402,   403,   403,   403,
     404,   404,   405,   405,   406,   406,   406,   406,   406,   406,
     406,   406,   406,   406,   406,   406,   406,   406,   406,   406,
     407,   407,   407,   407,   407,   408,   408,   409,   409,   410,
     410,   410,   410,   411,   411,   411,   411,   411,   411,   411,
     411,   411,   411,   412,   413,   413,   414,   414,   414,   414,
     414,   414,   414,   414,   414,   414,   414,   414,   414,   414,
     414,   414,   414,   414,   414,   414,   414,   414,   414,   414,
     414,   414,   414,   414,   414,   414,   414,   415,   415,   415,
     415,   415,   415,   415,   415,   415,   415,   416,   416,   417,
     418,   419,   420,   421,   421,   421,   421,   421,   421,   421,
     421,   421,   421,   421,   421,   421,   421,   421,   422,   422,
     423,   423,   423,   423,   424,   425,   426,   426,   427,   427,
     428,   429,   429,   431,   430,   432,   430,   433,   430,   434,
     430,   435,   430,   436,   437,   430,   439,   438,   440,   438,
     441,   438,   442,   438,   443,   438,   445,   444,   447,   446,
     449,   448,   450,   450,   450,   450,   450,   450,   450,   450,
     450,   450,   450,   451,   451,   451,   451,   451,   451,   451,
     451,   451,   451,   451,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   453,   454,   455,   456,   456,
     456,   457,   458,   459,   460,   460,   461,   460,   462,   462,
     462,   463,   464,   464,   465,   465,   465,   466,   466,   467,
     468,   468,   468,   468,   468,   468,   468,   468,   468,   468,
     468,   468,   469,   470,   470,   470,   471,   472,   473,   473,
     473,   474,   474,   474,   474,   474,   474,   474,   474,   474,
     474,   474,   475,   475,   475,   475,   476,   476,   478,   477,
     479,   477,   480,   481,   481,   481,   481,   482,   482,   482,
     482,   483,   484,   484,   484,   484,   484,   485,   485,   486,
     486,   487,   487,   487,   487,   488,   488,   489,   489,   490,
     490,   491,   491,   492,   492,   493,   493,   493,   494,   494,
     494,   495,   495,   495,   496,   496,   496,   497,   497,   498,
     498,   499,   499,   500,   500,   501,   501,   501,   501,   501,
     501,   501,   502,   502,   502,   502,   502,   503,   503,   503,
     503,   503,   503,   503,   503,   503,   503,   503,   503,   504,
     504,   504,   504,   505,   505,   506,   506,   506,   506,   506,
     506,   506,   506
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     3,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     6,    11,     3,     0,     0,     4,     4,     4,     4,
       4,     2,     2,    10,    10,    23,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     2,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     2,     2,     1,     2,
       1,     2,     2,     1,     0,     5,     0,     7,     0,     7,
       0,     5,     0,     5,     0,     5,     0,     3,     0,     3,
       0,     3,     1,     0,     3,     1,     1,     1,     1,     1,
       1,     0,     3,     1,     1,     1,     1,     0,     3,     1,
       0,     3,     1,     0,     3,     0,     3,     1,     0,     5,
       3,     3,     1,     1,     0,     5,     0,     5,     0,     5,
       0,    11,     0,    13,     0,    13,     1,     1,     1,     1,
       1,     1,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     8,     6,
       2,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     8,
       8,     8,    10,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     0,     2,     1,
       1,     3,     1,     5,    10,    12,    10,    10,     8,    10,
      10,     8,     8,     6,     8,     6,     6,     4,     2,     2,
       2,     2,     2,     2,     2,     1,     1,     2,     1,     2,
       1,     8,     9,     0,    12,     0,    12,     0,    12,     0,
      12,     0,    12,     0,     0,    12,     0,    12,     0,    12,
       0,    12,     0,    12,     0,    12,     0,    17,     0,    17,
       0,     9,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,    20,    13,    16,     1,     1,
       1,     1,     1,     1,     9,    16,     0,    17,     1,     1,
       1,     3,     0,     2,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,    11,    13,    13,     1,    12,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     0,     2,     0,     3,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       2,     1,     1,     1,     1,     1,     2,     1,     2,     1,
       1,     1,     2,     1,     1,     1,     1,     2,     1,     2,
       1,     1,     1,     1,     0,     2,     2,     5,     5,     5,
       5,     5,     5,     1,     1,     1,     3,     3,     4,     4,
       3,     3,     1,     3,     1,     4,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 687 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                   { new_shader(); }
#line 3027 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 17: /* const_val: T_FLOAT  */
#line 704 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = fui((yyvsp[0].flt)); }
#line 3033 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 18: /* const_val: T_INT  */
#line 705 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = (yyvsp[0].num);      }
#line 3039 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 19: /* const_val: '-' T_INT  */
#line 706 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = -(yyvsp[0].num);     }
#line 3045 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 20: /* const_val: T_HEX  */
#line 707 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = (yyvsp[0].unum);      }
#line 3051 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 21: /* localsize_header: T_A_LOCALSIZE const_val ',' const_val ',' const_val  */
#line 709 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                       {
                       variant->local_size[0] = (yyvsp[-4].unum);
                       variant->local_size[1] = (yyvsp[-2].unum);
                       variant->local_size[2] = (yyvsp[0].unum);
}
#line 3061 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 22: /* const_header: T_A_CONST '(' T_CONSTANT ')' const_val ',' const_val ',' const_val ',' const_val  */
#line 715 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                    {
                       add_const((yyvsp[-8].num), (yyvsp[-6].unum), (yyvsp[-4].unum), (yyvsp[-2].unum), (yyvsp[0].unum));
}
#line 3069 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 23: /* buf_header_addr_reg: '(' T_CONSTANT ')'  */
#line 720 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                      {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;

                       info->buf_addr_regs[info->num_bufs - 1] = reg;
                       /* reserve space in immediates for the actual value to be plugged in later: */
                       add_const((yyvsp[-1].num), 0, 0, 0, 0);
}
#line 3082 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 25: /* $@2: %empty  */
#line 730 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                     {
                       int idx = info->num_bufs++;
                       assert(idx < MAX_BUFS);
                       info->buf_sizes[idx] = (yyvsp[0].unum);
}
#line 3092 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 27: /* invocationid_header: T_A_INVOCATIONID '(' T_REGISTER ')'  */
#line 736 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                         {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       add_sysval(reg, 0x7, SYSTEM_VALUE_LOCAL_INVOCATION_ID);
}
#line 3102 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 28: /* wgid_header: T_A_WGID '(' T_REGISTER ')'  */
#line 742 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                               {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       assert(variant->shader->compiler->gen >= 5);
                       assert(reg >= regid(48, 0)); /* must be a high reg */
                       add_sysval(reg, 0x7, SYSTEM_VALUE_WORKGROUP_ID);
}
#line 3114 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 29: /* wgid_header: T_A_WGID '(' T_CONSTANT ')'  */
#line 749 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                               {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       assert(variant->shader->compiler->gen < 5);
                       info->wgid = reg;
}
#line 3125 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 30: /* numwg_header: T_A_NUMWG '(' T_CONSTANT ')'  */
#line 756 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       info->numwg = reg;
                       /* reserve space in immediates for the actual value to be plugged in later: */
                       if (variant->shader->compiler->gen >= 5)
                          add_const((yyvsp[-1].num), 0, 0, 0, 0);
}
#line 3138 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 31: /* branchstack_header: T_A_BRANCHSTACK const_val  */
#line 765 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { variant->branchstack = (yyvsp[0].unum); }
#line 3144 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 32: /* pvtmem_header: T_A_PVTMEM const_val  */
#line 767 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                    { variant->pvtmem_size = (yyvsp[0].unum); }
#line 3150 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 33: /* in_header: T_A_IN '(' T_REGISTER ')' T_IDENTIFIER '(' T_IDENTIFIER '=' integer ')'  */
#line 770 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                           { }
#line 3156 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 34: /* out_header: T_A_OUT '(' T_REGISTER ')' T_IDENTIFIER '(' T_IDENTIFIER '=' integer ')'  */
#line 772 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                            { }
#line 3162 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 35: /* tex_header: T_A_TEX '(' T_REGISTER ')' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer  */
#line 779 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                              { }
#line 3168 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 36: /* iflag: T_SY  */
#line 781 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SY; }
#line 3174 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 37: /* iflag: T_SS  */
#line 782 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SS; }
#line 3180 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 38: /* iflag: T_JP  */
#line 783 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_JP; }
#line 3186 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 39: /* iflag: T_SAT  */
#line 784 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SAT; }
#line 3192 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 40: /* iflag: T_RPT  */
#line 785 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.repeat = (yyvsp[0].num); }
#line 3198 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 41: /* iflag: T_UL  */
#line 786 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_UL; }
#line 3204 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 42: /* iflag: T_NOP  */
#line 787 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                          { iflags.nop = (yyvsp[0].tok); }
#line 3210 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 52: /* instr: iflags cat5_instr  */
#line 800 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                     { fixup_cat5_s2en(); }
#line 3216 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 56: /* label: T_IDENTIFIER ':'  */
#line 805 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                    { new_label((yyvsp[-1].str)); }
#line 3222 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 57: /* cat0_src1: '!' T_P0  */
#line 807 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.inv1 = true; instr->cat0.comp1 = (yyvsp[0].num) >> 1; }
#line 3228 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 58: /* cat0_src1: T_P0  */
#line 808 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.comp1 = (yyvsp[0].num) >> 1; }
#line 3234 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 59: /* cat0_src2: '!' T_P0  */
#line 810 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.inv2 = true; instr->cat0.comp2 = (yyvsp[0].num) >> 1; }
#line 3240 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 60: /* cat0_src2: T_P0  */
#line 811 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.comp2 = (yyvsp[0].num) >> 1; }
#line 3246 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 61: /* cat0_immed: '#' integer  */
#line 813 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.immed = (yyvsp[0].num); }
#line 3252 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 62: /* cat0_immed: '#' T_IDENTIFIER  */
#line 814 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                    { ralloc_steal(instr, (void *)(yyvsp[0].str)); instr->cat0.target_label = (yyvsp[0].str); }
#line 3258 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 63: /* cat0_instr: T_OP_NOP  */
#line 816 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_NOP); }
#line 3264 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 64: /* $@3: %empty  */
#line 817 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_PLAIN; }
#line 3270 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 66: /* $@4: %empty  */
#line 818 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_OR;    }
#line 3276 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 68: /* $@5: %empty  */
#line 819 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_AND;    }
#line 3282 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 70: /* $@6: %empty  */
#line 820 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                         { new_instr(OPC_B)->cat0.brtype = BRANCH_CONST; instr->cat0.idx = (yyvsp[0].num); }
#line 3288 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 72: /* $@7: %empty  */
#line 821 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_ANY; }
#line 3294 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 74: /* $@8: %empty  */
#line 822 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_ALL; }
#line 3300 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 76: /* $@9: %empty  */
#line 823 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_X; }
#line 3306 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 78: /* $@10: %empty  */
#line 824 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_JUMP); }
#line 3312 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 80: /* $@11: %empty  */
#line 825 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CALL); }
#line 3318 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 82: /* cat0_instr: T_OP_RET  */
#line 826 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_RET); }
#line 3324 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 83: /* $@12: %empty  */
#line 827 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_KILL); }
#line 3330 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 85: /* cat0_instr: T_OP_END  */
#line 828 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_END); }
#line 3336 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 86: /* cat0_instr: T_OP_EMIT  */
#line 829 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_EMIT); }
#line 3342 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 87: /* cat0_instr: T_OP_CUT  */
#line 830 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CUT); }
#line 3348 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 88: /* cat0_instr: T_OP_CHMASK  */
#line 831 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CHMASK); }
#line 3354 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 89: /* cat0_instr: T_OP_CHSH  */
#line 832 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CHSH); }
#line 3360 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 90: /* cat0_instr: T_OP_FLOW_REV  */
#line 833 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_FLOW_REV); }
#line 3366 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 91: /* $@13: %empty  */
#line 834 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BKT); }
#line 3372 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 93: /* cat0_instr: T_OP_STKS  */
#line 835 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_STKS); }
#line 3378 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 94: /* cat0_instr: T_OP_STKR  */
#line 836 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_STKR); }
#line 3384 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 95: /* cat0_instr: T_OP_XSET  */
#line 837 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_XSET); }
#line 3390 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 96: /* cat0_instr: T_OP_XCLR  */
#line 838 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_XCLR); }
#line 3396 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 97: /* $@14: %empty  */
#line 839 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_GETONE); }
#line 3402 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 99: /* cat0_instr: T_OP_DBG  */
#line 840 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_DBG); }
#line 3408 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 100: /* $@15: %empty  */
#line 841 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_SHPS); }
#line 3414 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 102: /* cat0_instr: T_OP_SHPE  */
#line 842 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_SHPE); }
#line 3420 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 103: /* $@16: %empty  */
#line 843 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDT); }
#line 3426 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 105: /* $@17: %empty  */
#line 844 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDF); }
#line 3432 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 107: /* cat0_instr: T_OP_PREDE  */
#line 845 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDE); }
#line 3438 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 108: /* $@18: %empty  */
#line 846 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                        { new_instr(OPC_GETLAST); }
#line 3444 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 110: /* cat1_opc: T_OP_MOV '.' T_CAT1_TYPE_TYPE  */
#line 848 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                 {
                       parse_type_type(new_instr(OPC_MOV), (yyvsp[0].str));
}
#line 3452 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 111: /* cat1_opc: T_OP_COV '.' T_CAT1_TYPE_TYPE  */
#line 851 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                 {
                       parse_type_type(new_instr(OPC_MOV), (yyvsp[0].str));
}
#line 3460 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 114: /* $@19: %empty  */
#line 858 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       {
                       new_instr(OPC_MOVMSK);
                       instr->cat1.src_type = TYPE_U32;
                       instr->cat1.dst_type = TYPE_U32;
                   }
#line 3470 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 115: /* cat1_movmsk: T_OP_MOVMSK '.' T_W $@19 dst_reg  */
#line 862 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             {
                       if (((yyvsp[-2].num) % 32) != 0)
                          yyerror("w# must be multiple of 32");
                       if ((yyvsp[-2].num) < 32)
                          yyerror("w# must be at least 32");

                       int num = (yyvsp[-2].num) / 32;

                       instr->repeat = num - 1;
                       instr->dsts[0]->wrmask = (1 << num) - 1;
                   }
#line 3486 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 116: /* $@20: %empty  */
#line 874 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       {
                       new_instr(OPC_MOV);
                       instr->cat1.src_type = TYPE_U16;
                       instr->cat1.dst_type = TYPE_U16;
                       new_dst((61 << 3) + 2, IR3_REG_HALF);
                   }
#line 3497 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 118: /* $@21: %empty  */
#line 881 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                      {
                       new_instr(OPC_MOV);
                       instr->cat1.src_type = TYPE_S16;
                       instr->cat1.dst_type = TYPE_S16;
                       new_dst((61 << 3), IR3_REG_HALF);
                   }
#line 3508 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 120: /* $@22: %empty  */
#line 888 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_SWZ), (yyvsp[0].str)); }
#line 3514 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 122: /* $@23: %empty  */
#line 890 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_GAT), (yyvsp[0].str)); }
#line 3520 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 124: /* $@24: %empty  */
#line 892 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_SCT), (yyvsp[0].str)); }
#line 3526 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 134: /* cat2_opc_1src: T_OP_ABSNEG_F  */
#line 904 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ABSNEG_F); }
#line 3532 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 135: /* cat2_opc_1src: T_OP_ABSNEG_S  */
#line 905 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ABSNEG_S); }
#line 3538 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 136: /* cat2_opc_1src: T_OP_CLZ_B  */
#line 906 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CLZ_B); }
#line 3544 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 137: /* cat2_opc_1src: T_OP_CLZ_S  */
#line 907 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CLZ_S); }
#line 3550 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 138: /* cat2_opc_1src: T_OP_SIGN_F  */
#line 908 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SIGN_F); }
#line 3556 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 139: /* cat2_opc_1src: T_OP_FLOOR_F  */
#line 909 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_FLOOR_F); }
#line 3562 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 140: /* cat2_opc_1src: T_OP_CEIL_F  */
#line 910 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CEIL_F); }
#line 3568 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 141: /* cat2_opc_1src: T_OP_RNDNE_F  */
#line 911 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RNDNE_F); }
#line 3574 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 142: /* cat2_opc_1src: T_OP_RNDAZ_F  */
#line 912 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RNDAZ_F); }
#line 3580 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 143: /* cat2_opc_1src: T_OP_TRUNC_F  */
#line 913 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_TRUNC_F); }
#line 3586 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 144: /* cat2_opc_1src: T_OP_NOT_B  */
#line 914 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_NOT_B); }
#line 3592 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 145: /* cat2_opc_1src: T_OP_BFREV_B  */
#line 915 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BFREV_B); }
#line 3598 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 146: /* cat2_opc_1src: T_OP_SETRM  */
#line 916 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SETRM); }
#line 3604 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 147: /* cat2_opc_1src: T_OP_CBITS_B  */
#line 917 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CBITS_B); }
#line 3610 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 148: /* cat2_opc_2src_cnd: T_OP_CMPS_F  */
#line 919 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_F); }
#line 3616 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 149: /* cat2_opc_2src_cnd: T_OP_CMPS_U  */
#line 920 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_U); }
#line 3622 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 150: /* cat2_opc_2src_cnd: T_OP_CMPS_S  */
#line 921 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_S); }
#line 3628 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 151: /* cat2_opc_2src_cnd: T_OP_CMPV_F  */
#line 922 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_F); }
#line 3634 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 152: /* cat2_opc_2src_cnd: T_OP_CMPV_U  */
#line 923 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_U); }
#line 3640 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 153: /* cat2_opc_2src_cnd: T_OP_CMPV_S  */
#line 924 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_S); }
#line 3646 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 154: /* cat2_opc_2src: T_OP_ADD_F  */
#line 926 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_F); }
#line 3652 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 155: /* cat2_opc_2src: T_OP_MIN_F  */
#line 927 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_F); }
#line 3658 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 156: /* cat2_opc_2src: T_OP_MAX_F  */
#line 928 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_F); }
#line 3664 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 157: /* cat2_opc_2src: T_OP_MUL_F  */
#line 929 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_F); }
#line 3670 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 158: /* cat2_opc_2src: T_OP_ADD_U  */
#line 930 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_U); }
#line 3676 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 159: /* cat2_opc_2src: T_OP_ADD_S  */
#line 931 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_S); }
#line 3682 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 160: /* cat2_opc_2src: T_OP_SUB_U  */
#line 932 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SUB_U); }
#line 3688 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 161: /* cat2_opc_2src: T_OP_SUB_S  */
#line 933 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SUB_S); }
#line 3694 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 162: /* cat2_opc_2src: T_OP_MIN_U  */
#line 934 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_U); }
#line 3700 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 163: /* cat2_opc_2src: T_OP_MIN_S  */
#line 935 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_S); }
#line 3706 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 164: /* cat2_opc_2src: T_OP_MAX_U  */
#line 936 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_U); }
#line 3712 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 165: /* cat2_opc_2src: T_OP_MAX_S  */
#line 937 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_S); }
#line 3718 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 166: /* cat2_opc_2src: T_OP_AND_B  */
#line 938 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_AND_B); }
#line 3724 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 167: /* cat2_opc_2src: T_OP_OR_B  */
#line 939 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_OR_B); }
#line 3730 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 168: /* cat2_opc_2src: T_OP_XOR_B  */
#line 940 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_XOR_B); }
#line 3736 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 169: /* cat2_opc_2src: T_OP_MUL_U24  */
#line 941 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_U24); }
#line 3742 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 170: /* cat2_opc_2src: T_OP_MUL_S24  */
#line 942 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_S24); }
#line 3748 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 171: /* cat2_opc_2src: T_OP_MULL_U  */
#line 943 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MULL_U); }
#line 3754 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 172: /* cat2_opc_2src: T_OP_SHL_B  */
#line 944 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHL_B); }
#line 3760 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 173: /* cat2_opc_2src: T_OP_SHR_B  */
#line 945 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHR_B); }
#line 3766 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 174: /* cat2_opc_2src: T_OP_ASHR_B  */
#line 946 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ASHR_B); }
#line 3772 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 175: /* cat2_opc_2src: T_OP_BARY_F  */
#line 947 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BARY_F); }
#line 3778 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 176: /* cat2_opc_2src: T_OP_FLAT_B  */
#line 948 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_FLAT_B); }
#line 3784 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 177: /* cat2_opc_2src: T_OP_MGEN_B  */
#line 949 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MGEN_B); }
#line 3790 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 178: /* cat2_opc_2src: T_OP_GETBIT_B  */
#line 950 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETBIT_B); }
#line 3796 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 179: /* cat2_opc_2src: T_OP_SHB  */
#line 951 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHB); }
#line 3802 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 180: /* cat2_opc_2src: T_OP_MSAD  */
#line 952 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MSAD); }
#line 3808 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 181: /* cond: T_LT  */
#line 954 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_LT; }
#line 3814 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 182: /* cond: T_LE  */
#line 955 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_LE; }
#line 3820 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 183: /* cond: T_GT  */
#line 956 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_GT; }
#line 3826 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 184: /* cond: T_GE  */
#line 957 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_GE; }
#line 3832 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 185: /* cond: T_EQ  */
#line 958 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_EQ; }
#line 3838 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 186: /* cond: T_NE  */
#line 959 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_NE; }
#line 3844 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 190: /* cat3_dp_signedness: '.' T_MIXED  */
#line 965 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.signedness = IR3_SRC_MIXED; }
#line 3850 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 191: /* cat3_dp_signedness: '.' T_UNSIGNED  */
#line 966 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.signedness = IR3_SRC_UNSIGNED; }
#line 3856 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 192: /* cat3_dp_pack: '.' T_LOW  */
#line 968 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.packed = IR3_SRC_PACKED_LOW; }
#line 3862 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 193: /* cat3_dp_pack: '.' T_HIGH  */
#line 969 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.packed = IR3_SRC_PACKED_HIGH; }
#line 3868 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 194: /* cat3_opc: T_OP_MAD_U16  */
#line 971 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_U16); }
#line 3874 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 195: /* cat3_opc: T_OP_MADSH_U16  */
#line 972 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MADSH_U16); }
#line 3880 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 196: /* cat3_opc: T_OP_MAD_S16  */
#line 973 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_S16); }
#line 3886 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 197: /* cat3_opc: T_OP_MADSH_M16  */
#line 974 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MADSH_M16); }
#line 3892 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 198: /* cat3_opc: T_OP_MAD_U24  */
#line 975 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_U24); }
#line 3898 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 199: /* cat3_opc: T_OP_MAD_S24  */
#line 976 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_S24); }
#line 3904 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 200: /* cat3_opc: T_OP_MAD_F16  */
#line 977 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_F16); }
#line 3910 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 201: /* cat3_opc: T_OP_MAD_F32  */
#line 978 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_F32); }
#line 3916 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 202: /* cat3_opc: T_OP_SEL_B16  */
#line 979 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_B16); }
#line 3922 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 203: /* cat3_opc: T_OP_SEL_B32  */
#line 980 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_B32); }
#line 3928 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 204: /* cat3_opc: T_OP_SEL_S16  */
#line 981 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_S16); }
#line 3934 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 205: /* cat3_opc: T_OP_SEL_S32  */
#line 982 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_S32); }
#line 3940 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 206: /* cat3_opc: T_OP_SEL_F16  */
#line 983 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_F16); }
#line 3946 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 207: /* cat3_opc: T_OP_SEL_F32  */
#line 984 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_F32); }
#line 3952 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 208: /* cat3_opc: T_OP_SAD_S16  */
#line 985 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAD_S16); }
#line 3958 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 209: /* cat3_opc: T_OP_SAD_S32  */
#line 986 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAD_S32); }
#line 3964 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 210: /* cat3_imm_reg_opc: T_OP_SHRM  */
#line 988 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHRM); }
#line 3970 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 211: /* cat3_imm_reg_opc: T_OP_SHLM  */
#line 989 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHLM); }
#line 3976 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 212: /* cat3_imm_reg_opc: T_OP_SHRG  */
#line 990 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHRG); }
#line 3982 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 213: /* cat3_imm_reg_opc: T_OP_SHLG  */
#line 991 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHLG); }
#line 3988 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 214: /* cat3_imm_reg_opc: T_OP_ANDG  */
#line 992 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ANDG); }
#line 3994 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 215: /* cat3_wmm: T_OP_WMM  */
#line 994 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_WMM); }
#line 4000 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 216: /* cat3_wmm: T_OP_WMM_ACCU  */
#line 995 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_WMM_ACCU); }
#line 4006 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 217: /* cat3_dp: T_OP_DP2ACC  */
#line 997 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DP2ACC); }
#line 4012 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 218: /* cat3_dp: T_OP_DP4ACC  */
#line 998 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DP4ACC); }
#line 4018 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 223: /* cat4_opc: T_OP_RCP  */
#line 1005 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RCP); }
#line 4024 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 224: /* cat4_opc: T_OP_RSQ  */
#line 1006 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RSQ); }
#line 4030 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 225: /* cat4_opc: T_OP_LOG2  */
#line 1007 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_LOG2); }
#line 4036 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 226: /* cat4_opc: T_OP_EXP2  */
#line 1008 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_EXP2); }
#line 4042 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 227: /* cat4_opc: T_OP_SIN  */
#line 1009 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SIN); }
#line 4048 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 228: /* cat4_opc: T_OP_COS  */
#line 1010 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_COS); }
#line 4054 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 229: /* cat4_opc: T_OP_SQRT  */
#line 1011 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SQRT); }
#line 4060 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 230: /* cat4_opc: T_OP_HRSQ  */
#line 1012 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HRSQ); }
#line 4066 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 231: /* cat4_opc: T_OP_HLOG2  */
#line 1013 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HLOG2); }
#line 4072 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 232: /* cat4_opc: T_OP_HEXP2  */
#line 1014 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HEXP2); }
#line 4078 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 234: /* cat5_opc_dsxypp: T_OP_DSXPP_1  */
#line 1018 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSXPP_1)->cat5.type = TYPE_F32; }
#line 4084 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 235: /* cat5_opc_dsxypp: T_OP_DSYPP_1  */
#line 1019 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSYPP_1)->cat5.type = TYPE_F32; }
#line 4090 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 236: /* cat5_opc: T_OP_ISAM  */
#line 1021 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAM); }
#line 4096 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 237: /* cat5_opc: T_OP_ISAML  */
#line 1022 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAML); }
#line 4102 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 238: /* cat5_opc: T_OP_ISAMM  */
#line 1023 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAMM); }
#line 4108 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 239: /* cat5_opc: T_OP_SAM  */
#line 1024 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAM); }
#line 4114 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 240: /* cat5_opc: T_OP_SAMB  */
#line 1025 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMB); }
#line 4120 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 241: /* cat5_opc: T_OP_SAML  */
#line 1026 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAML); }
#line 4126 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 242: /* cat5_opc: T_OP_SAMGQ  */
#line 1027 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGQ); }
#line 4132 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 243: /* cat5_opc: T_OP_GETLOD  */
#line 1028 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETLOD); }
#line 4138 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 244: /* cat5_opc: T_OP_CONV  */
#line 1029 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CONV); }
#line 4144 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 245: /* cat5_opc: T_OP_CONVM  */
#line 1030 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CONVM); }
#line 4150 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 246: /* cat5_opc: T_OP_GETSIZE  */
#line 1031 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETSIZE); }
#line 4156 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 247: /* cat5_opc: T_OP_GETBUF  */
#line 1032 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETBUF); }
#line 4162 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 248: /* cat5_opc: T_OP_GETPOS  */
#line 1033 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETPOS); }
#line 4168 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 249: /* cat5_opc: T_OP_GETINFO  */
#line 1034 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETINFO); }
#line 4174 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 250: /* cat5_opc: T_OP_DSX  */
#line 1035 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSX); }
#line 4180 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 251: /* cat5_opc: T_OP_DSY  */
#line 1036 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSY); }
#line 4186 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 252: /* cat5_opc: T_OP_GATHER4R  */
#line 1037 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4R); }
#line 4192 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 253: /* cat5_opc: T_OP_GATHER4G  */
#line 1038 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4G); }
#line 4198 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 254: /* cat5_opc: T_OP_GATHER4B  */
#line 1039 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4B); }
#line 4204 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 255: /* cat5_opc: T_OP_GATHER4A  */
#line 1040 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4A); }
#line 4210 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 256: /* cat5_opc: T_OP_SAMGP0  */
#line 1041 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP0); }
#line 4216 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 257: /* cat5_opc: T_OP_SAMGP1  */
#line 1042 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP1); }
#line 4222 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 258: /* cat5_opc: T_OP_SAMGP2  */
#line 1043 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP2); }
#line 4228 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 259: /* cat5_opc: T_OP_SAMGP3  */
#line 1044 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP3); }
#line 4234 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 260: /* cat5_opc: T_OP_RGETPOS  */
#line 1045 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RGETPOS); }
#line 4240 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 261: /* cat5_opc: T_OP_RGETINFO  */
#line 1046 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RGETINFO); }
#line 4246 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 262: /* cat5_opc: T_OP_BRCST_A  */
#line 1047 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BRCST_ACTIVE); }
#line 4252 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 263: /* cat5_opc: T_OP_QSHUFFLE_BRCST  */
#line 1048 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_BRCST); }
#line 4258 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 264: /* cat5_opc: T_OP_QSHUFFLE_H  */
#line 1049 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_HORIZ); }
#line 4264 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 265: /* cat5_opc: T_OP_QSHUFFLE_V  */
#line 1050 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_VERT); }
#line 4270 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 266: /* cat5_opc: T_OP_QSHUFFLE_DIAG  */
#line 1051 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_DIAG); }
#line 4276 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 267: /* cat5_flag: '.' T_3D  */
#line 1053 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_3D; }
#line 4282 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 268: /* cat5_flag: '.' 'a'  */
#line 1054 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_A; }
#line 4288 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 269: /* cat5_flag: '.' 'o'  */
#line 1055 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_O; }
#line 4294 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 270: /* cat5_flag: '.' 'p'  */
#line 1056 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_P; }
#line 4300 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 271: /* cat5_flag: '.' 's'  */
#line 1057 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_S; }
#line 4306 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 272: /* cat5_flag: '.' T_S2EN  */
#line 1058 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_S2EN; }
#line 4312 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 273: /* cat5_flag: '.' T_UNIFORM  */
#line 1059 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { }
#line 4318 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 274: /* cat5_flag: '.' T_NONUNIFORM  */
#line 1060 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                     { instr->flags |= IR3_INSTR_NONUNIF; }
#line 4324 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 275: /* cat5_flag: '.' T_BASE  */
#line 1061 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_B; instr->cat5.tex_base = (yyvsp[0].tok); }
#line 4330 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 276: /* cat5_flag: '.' T_W  */
#line 1062 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.cluster_size = (yyvsp[0].num); }
#line 4336 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 279: /* cat5_samp: T_SAMP  */
#line 1066 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.samp = (yyvsp[0].tok); }
#line 4342 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 280: /* cat5_tex: T_TEX  */
#line 1067 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.tex = (yyvsp[0].tok); }
#line 4348 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 281: /* cat5_type: '(' type ')'  */
#line 1068 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.type = (yyvsp[-1].type); }
#line 4354 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 282: /* cat5_a1: src_reg  */
#line 1069 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_A1EN; }
#line 4360 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 298: /* cat6_typed: '.' T_UNTYPED  */
#line 1087 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat6.typed = 0; }
#line 4366 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 299: /* cat6_typed: '.' T_TYPED  */
#line 1088 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat6.typed = 1; }
#line 4372 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 300: /* cat6_dim: '.' T_1D  */
#line 1090 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 1; }
#line 4378 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 301: /* cat6_dim: '.' T_2D  */
#line 1091 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 2; }
#line 4384 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 302: /* cat6_dim: '.' T_3D  */
#line 1092 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 3; }
#line 4390 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 303: /* cat6_dim: '.' T_4D  */
#line 1093 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 4; }
#line 4396 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 304: /* cat6_type: '.' type  */
#line 1095 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.type = (yyvsp[0].type); }
#line 4402 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 305: /* cat6_imm_offset: offset  */
#line 1096 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 4408 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 308: /* cat6_dst_offset: offset  */
#line 1099 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.dst_offset = (yyvsp[0].num); }
#line 4414 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 310: /* cat6_immed: integer  */
#line 1102 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.iim_val = (yyvsp[0].num); }
#line 4420 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 311: /* cat6_stg_ldg_a6xx_offset: '+' '(' src offset ')' '<' '<' integer  */
#line 1105 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                           {
                        assert((yyvsp[0].num) == 2);
                        new_src(0, IR3_REG_IMMED)->uim_val = 0;
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-4].num);
                    }
#line 4430 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 312: /* cat6_stg_ldg_a6xx_offset: '+' src '<' '<' integer offset '<' '<' integer  */
#line 1110 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                  {
                        assert((yyvsp[0].num) == 2);
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-4].num) - 2;
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-3].num);
                    }
#line 4440 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 313: /* $@25: %empty  */
#line 1116 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG); }
#line 4446 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 315: /* $@26: %empty  */
#line 1117 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG_A); }
#line 4452 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 317: /* $@27: %empty  */
#line 1118 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDP); }
#line 4458 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 319: /* $@28: %empty  */
#line 1119 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDL); }
#line 4464 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 321: /* $@29: %empty  */
#line 1120 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDLW); }
#line 4470 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 323: /* $@30: %empty  */
#line 1121 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDLV); }
#line 4476 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 324: /* $@31: %empty  */
#line 1121 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                  {
                       new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[-1].num);
                   }
#line 4484 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 326: /* $@32: %empty  */
#line 1125 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_STG); dummy_dst(); }
#line 4490 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 328: /* $@33: %empty  */
#line 1126 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_STG_A); dummy_dst(); }
#line 4496 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 330: /* $@34: %empty  */
#line 1127 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STP); dummy_dst(); }
#line 4502 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 332: /* $@35: %empty  */
#line 1128 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STL); dummy_dst(); }
#line 4508 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 334: /* $@36: %empty  */
#line 1129 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STLW); dummy_dst(); }
#line 4514 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 336: /* $@37: %empty  */
#line 1131 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_LDIB); }
#line 4520 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 338: /* $@38: %empty  */
#line 1132 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STIB); dummy_dst(); }
#line 4526 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 340: /* $@39: %empty  */
#line 1134 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                 { new_instr(OPC_PREFETCH); new_dst(0,0); /* dummy dst */ }
#line 4532 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 342: /* cat6_atomic_opc: T_OP_ATOMIC_ADD  */
#line 1136 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_ADD); }
#line 4538 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 343: /* cat6_atomic_opc: T_OP_ATOMIC_SUB  */
#line 1137 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_SUB); }
#line 4544 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 344: /* cat6_atomic_opc: T_OP_ATOMIC_XCHG  */
#line 1138 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_XCHG); }
#line 4550 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 345: /* cat6_atomic_opc: T_OP_ATOMIC_INC  */
#line 1139 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_INC); }
#line 4556 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 346: /* cat6_atomic_opc: T_OP_ATOMIC_DEC  */
#line 1140 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_DEC); }
#line 4562 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 347: /* cat6_atomic_opc: T_OP_ATOMIC_CMPXCHG  */
#line 1141 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_CMPXCHG); }
#line 4568 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 348: /* cat6_atomic_opc: T_OP_ATOMIC_MIN  */
#line 1142 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_MIN); }
#line 4574 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 349: /* cat6_atomic_opc: T_OP_ATOMIC_MAX  */
#line 1143 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_MAX); }
#line 4580 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 350: /* cat6_atomic_opc: T_OP_ATOMIC_AND  */
#line 1144 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_AND); }
#line 4586 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 351: /* cat6_atomic_opc: T_OP_ATOMIC_OR  */
#line 1145 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_OR); }
#line 4592 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 352: /* cat6_atomic_opc: T_OP_ATOMIC_XOR  */
#line 1146 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_XOR); }
#line 4598 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 353: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_ADD  */
#line 1148 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_ADD); }
#line 4604 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 354: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_SUB  */
#line 1149 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_SUB); }
#line 4610 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 355: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_XCHG  */
#line 1150 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_XCHG); }
#line 4616 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 356: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_INC  */
#line 1151 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_INC); }
#line 4622 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 357: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_DEC  */
#line 1152 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_DEC); }
#line 4628 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 358: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_CMPXCHG  */
#line 1153 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_CMPXCHG); }
#line 4634 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 359: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_MIN  */
#line 1154 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_MIN); }
#line 4640 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 360: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_MAX  */
#line 1155 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_MAX); }
#line 4646 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 361: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_AND  */
#line 1156 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_AND); }
#line 4652 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 362: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_OR  */
#line 1157 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_OR); }
#line 4658 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 363: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_XOR  */
#line 1158 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_XOR); }
#line 4664 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 364: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_ADD  */
#line 1160 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_ADD); }
#line 4670 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 365: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_SUB  */
#line 1161 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_SUB); }
#line 4676 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 366: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_XCHG  */
#line 1162 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_XCHG); }
#line 4682 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 367: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_INC  */
#line 1163 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_INC); }
#line 4688 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 368: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_DEC  */
#line 1164 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_DEC); }
#line 4694 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 369: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_CMPXCHG  */
#line 1165 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_CMPXCHG); }
#line 4700 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 370: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_MIN  */
#line 1166 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_MIN); }
#line 4706 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 371: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_MAX  */
#line 1167 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_MAX); }
#line 4712 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 372: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_AND  */
#line 1168 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_AND); }
#line 4718 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 373: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_OR  */
#line 1169 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_OR); }
#line 4724 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 374: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_XOR  */
#line 1170 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_XOR); }
#line 4730 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 381: /* cat6_ibo_opc_1src: T_OP_RESINFO  */
#line 1182 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RESINFO); }
#line 4736 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 382: /* cat6_ibo_opc_ldgb: T_OP_LDGB  */
#line 1184 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_LDGB); }
#line 4742 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 383: /* cat6_ibo_opc_stgb: T_OP_STGB  */
#line 1185 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_STGB); }
#line 4748 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 386: /* $@40: %empty  */
#line 1189 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                  { dummy_dst(); }
#line 4754 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 388: /* cat6_id_opc: T_OP_GETSPID  */
#line 1192 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                { new_instr(OPC_GETSPID); }
#line 4760 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 389: /* cat6_id_opc: T_OP_GETWID  */
#line 1193 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                { new_instr(OPC_GETWID); }
#line 4766 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 390: /* cat6_id_opc: T_OP_GETFIBERID  */
#line 1194 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_GETFIBERID); }
#line 4772 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 393: /* cat6_bindless_base: '.' T_BASE  */
#line 1199 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                              { instr->flags |= IR3_INSTR_B; instr->cat6.base = (yyvsp[0].tok); }
#line 4778 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 396: /* cat6_bindless_mode: T_NONUNIFORM cat6_bindless_base  */
#line 1203 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                   { instr->flags |= IR3_INSTR_NONUNIF; }
#line 4784 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 398: /* cat6_reg_or_immed: integer  */
#line 1206 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                           { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 4790 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 399: /* cat6_bindless_ibo_opc_1src: T_OP_RESINFO_B  */
#line 1208 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                 { new_instr(OPC_RESINFO); }
#line 4796 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 400: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_ADD  */
#line 1210 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                     { new_instr(OPC_ATOMIC_B_ADD); dummy_dst(); }
#line 4802 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 401: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_SUB  */
#line 1211 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_SUB); dummy_dst(); }
#line 4808 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 402: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_XCHG  */
#line 1212 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_XCHG); dummy_dst(); }
#line 4814 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 403: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_INC  */
#line 1213 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_INC); dummy_dst(); }
#line 4820 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 404: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_DEC  */
#line 1214 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_DEC); dummy_dst(); }
#line 4826 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 405: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_CMPXCHG  */
#line 1215 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_CMPXCHG); dummy_dst(); }
#line 4832 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 406: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_MIN  */
#line 1216 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_MIN); dummy_dst(); }
#line 4838 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 407: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_MAX  */
#line 1217 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_MAX); dummy_dst(); }
#line 4844 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 408: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_AND  */
#line 1218 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_AND); dummy_dst(); }
#line 4850 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 409: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_OR  */
#line 1219 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_OR); dummy_dst(); }
#line 4856 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 410: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_XOR  */
#line 1220 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_XOR); dummy_dst(); }
#line 4862 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 411: /* cat6_bindless_ibo_opc_2src: T_OP_STIB_B  */
#line 1221 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_STIB); dummy_dst(); }
#line 4868 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 412: /* cat6_bindless_ibo_opc_2src_dst: T_OP_LDIB_B  */
#line 1223 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                         { new_instr(OPC_LDIB); }
#line 4874 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 414: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_2src cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode src_reg ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1226 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                      { swap(instr->srcs[0], instr->srcs[2]); }
#line 4880 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 415: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_2src_dst cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode dst_reg ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1227 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                          { swap(instr->srcs[0], instr->srcs[1]); }
#line 4886 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 416: /* cat6_bindless_ldc_opc: T_OP_LDC  */
#line 1229 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                 { new_instr(OPC_LDC); }
#line 4892 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 417: /* cat6_bindless_ldc: cat6_bindless_ldc_opc '.' T_OFFSET '.' cat6_immed '.' cat6_bindless_mode dst_reg ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1231 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                {
                      instr->cat6.d = (yyvsp[-9].tok);
                      instr->cat6.type = TYPE_U32;
                      /* TODO cleanup ir3 src order: */
                      swap(instr->srcs[0], instr->srcs[1]);
                   }
#line 4903 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 418: /* cat6_todo: T_OP_G2L  */
#line 1238 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_G2L); }
#line 4909 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 419: /* cat6_todo: T_OP_L2G  */
#line 1239 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_L2G); }
#line 4915 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 420: /* cat6_todo: T_OP_RESFMT  */
#line 1240 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_RESFMT); }
#line 4921 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 432: /* cat7_scope: '.' 'w'  */
#line 1254 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.w = true; }
#line 4927 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 433: /* cat7_scope: '.' 'r'  */
#line 1255 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.r = true; }
#line 4933 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 434: /* cat7_scope: '.' 'l'  */
#line 1256 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.l = true; }
#line 4939 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 435: /* cat7_scope: '.' 'g'  */
#line 1257 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.g = true; }
#line 4945 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 438: /* $@41: %empty  */
#line 1262 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_BAR); }
#line 4951 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 440: /* $@42: %empty  */
#line 1263 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_FENCE); }
#line 4957 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 443: /* src: T_REGISTER  */
#line 1267 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((yyvsp[0].num), 0); }
#line 4963 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 444: /* src: T_A0  */
#line 1268 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((61 << 3), IR3_REG_HALF); }
#line 4969 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 445: /* src: T_A1  */
#line 1269 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((61 << 3) + 1, IR3_REG_HALF); }
#line 4975 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 446: /* src: T_P0  */
#line 1270 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), 0); }
#line 4981 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 447: /* dst: T_REGISTER  */
#line 1272 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((yyvsp[0].num), 0); }
#line 4987 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 448: /* dst: T_A0  */
#line 1273 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((61 << 3), IR3_REG_HALF); }
#line 4993 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 449: /* dst: T_A1  */
#line 1274 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((61 << 3) + 1, IR3_REG_HALF); }
#line 4999 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 450: /* dst: T_P0  */
#line 1275 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((62 << 3) + (yyvsp[0].num), 0); }
#line 5005 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 451: /* const: T_CONSTANT  */
#line 1277 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((yyvsp[0].num), IR3_REG_CONST); }
#line 5011 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 452: /* dst_reg_flag: T_EVEN  */
#line 1279 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_EVEN; }
#line 5017 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 453: /* dst_reg_flag: T_POS_INFINITY  */
#line 1280 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_POS_INF; }
#line 5023 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 454: /* dst_reg_flag: T_NEG_INFINITY  */
#line 1281 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_NEG_INF; }
#line 5029 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 455: /* dst_reg_flag: T_EI  */
#line 1282 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_EI; }
#line 5035 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 456: /* dst_reg_flag: T_WRMASK  */
#line 1283 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.wrmask = (yyvsp[0].num); }
#line 5041 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 459: /* dst_reg: dst  */
#line 1289 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { (yyvsp[0].reg)->flags |= IR3_REG_R; }
#line 5047 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 460: /* dst_reg: dst_reg_flags dst  */
#line 1290 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { (yyvsp[0].reg)->flags |= IR3_REG_R; }
#line 5053 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 461: /* src_reg_flag: T_ABSNEG  */
#line 1292 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_ABS|IR3_REG_NEGATE; }
#line 5059 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 462: /* src_reg_flag: T_NEG  */
#line 1293 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_NEGATE; }
#line 5065 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 463: /* src_reg_flag: T_ABS  */
#line 1294 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_ABS; }
#line 5071 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 464: /* src_reg_flag: T_R  */
#line 1295 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_R; }
#line 5077 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 484: /* offset: %empty  */
#line 1324 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                   { (yyval.num) = 0; }
#line 5083 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 485: /* offset: '+' integer  */
#line 1325 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].num); }
#line 5089 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 486: /* offset: '-' integer  */
#line 1326 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].num); }
#line 5095 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 487: /* relative_gpr_src: 'r' '<' T_A0 offset '>'  */
#line 1328 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_src(0, IR3_REG_RELATIV)->array.offset = (yyvsp[-1].num); }
#line 5101 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 488: /* relative_gpr_src: T_HR '<' T_A0 offset '>'  */
#line 1329 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                             { new_src(0, IR3_REG_RELATIV | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5107 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 489: /* relative_gpr_dst: 'r' '<' T_A0 offset '>'  */
#line 1331 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_dst(0, IR3_REG_RELATIV)->array.offset = (yyvsp[-1].num); }
#line 5113 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 490: /* relative_gpr_dst: T_HR '<' T_A0 offset '>'  */
#line 1332 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                             { new_dst(0, IR3_REG_RELATIV | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5119 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 491: /* relative_const: 'c' '<' T_A0 offset '>'  */
#line 1334 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                            { new_src(0, IR3_REG_RELATIV | IR3_REG_CONST)->array.offset = (yyvsp[-1].num); }
#line 5125 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 492: /* relative_const: T_HC '<' T_A0 offset '>'  */
#line 1335 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                             { new_src(0, IR3_REG_RELATIV | IR3_REG_CONST | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5131 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 495: /* immediate_cat1: integer  */
#line 1344 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = type_size(instr->cat1.src_type) < 32 ? (yyvsp[0].num) & 0xffff : (yyvsp[0].num); }
#line 5137 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 496: /* immediate_cat1: '(' integer ')'  */
#line 1345 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].num); }
#line 5143 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 497: /* immediate_cat1: '(' float ')'  */
#line 1346 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].flt); }
#line 5149 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 498: /* immediate_cat1: 'h' '(' integer ')'  */
#line 1347 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->iim_val = (yyvsp[-1].num) & 0xffff; }
#line 5155 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 499: /* immediate_cat1: 'h' '(' float ')'  */
#line 1348 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->uim_val = _mesa_float_to_half((yyvsp[-1].flt)); }
#line 5161 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 500: /* immediate_cat1: '(' T_NAN ')'  */
#line 1349 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = NAN; }
#line 5167 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 501: /* immediate_cat1: '(' T_INF ')'  */
#line 1350 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = INFINITY; }
#line 5173 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 502: /* immediate: integer  */
#line 1352 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 5179 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 503: /* immediate: '(' integer ')'  */
#line 1353 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].num); }
#line 5185 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 504: /* immediate: flut_immed  */
#line 1354 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num); }
#line 5191 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 505: /* immediate: 'h' '(' integer ')'  */
#line 1355 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->iim_val = (yyvsp[-1].num); }
#line 5197 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 506: /* immediate: 'h' flut_immed  */
#line 1356 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->uim_val = (yyvsp[0].num); }
#line 5203 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 519: /* integer: T_INT  */
#line 1372 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].num); }
#line 5209 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 520: /* integer: '-' T_INT  */
#line 1373 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].num); }
#line 5215 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 521: /* integer: T_HEX  */
#line 1374 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].unum); }
#line 5221 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 522: /* integer: '-' T_HEX  */
#line 1375 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].unum); }
#line 5227 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 523: /* float: T_FLOAT  */
#line 1377 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.flt) = (yyvsp[0].flt); }
#line 5233 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 524: /* float: '-' T_FLOAT  */
#line 1378 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.flt) = -(yyvsp[0].flt); }
#line 5239 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 525: /* type: T_TYPE_F16  */
#line 1380 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_F16; }
#line 5245 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 526: /* type: T_TYPE_F32  */
#line 1381 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_F32; }
#line 5251 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 527: /* type: T_TYPE_U16  */
#line 1382 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_U16; }
#line 5257 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 528: /* type: T_TYPE_U32  */
#line 1383 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_U32; }
#line 5263 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 529: /* type: T_TYPE_S16  */
#line 1384 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_S16; }
#line 5269 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 530: /* type: T_TYPE_S32  */
#line 1385 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_S32; }
#line 5275 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 531: /* type: T_TYPE_U8  */
#line 1386 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_U8;  }
#line 5281 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 532: /* type: T_TYPE_S8  */
#line 1387 "../mesa-22.0.4/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_S8;  }
#line 5287 "src/freedreno/ir3/ir3_parser.c"
    break;


#line 5291 "src/freedreno/ir3/ir3_parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

